﻿//******************************************************************************
// <copyright file="license.md" company="RawCMS project  (https://github.com/arduosoft/RawCMS)">
// Copyright (c) 2019 RawCMS project  (https://github.com/arduosoft/RawCMS)
// RawCMS project is released under GPL3 terms, see LICENSE file on repository root at  https://github.com/arduosoft/RawCMS .
// </copyright>
// <author>Daniele Fontani, Emanuele Bucarelli, Francesco Mina'</author>
// <autogenerated>true</autogenerated>
//******************************************************************************
using Microsoft.AspNetCore.Http;
using RawCMS.Plugins.ApiGateway.Classes.Balancer.Policy;
using System.Collections.Generic;
using System.Linq;

namespace RawCMS.Plugins.ApiGateway.Classes.Balancer
{
    public class BalancerDispatcher
    {
        private List<BalancerPolicy> policies { get; set; }

        public BalancerDispatcher(IEnumerable<BalancerPolicy> policies)
        {
            this.policies = policies.ToList();
        }

        public BalancerPolicy GetActiveBalancerPolicy(HttpContext context)
        {
            return policies.Where(x => x.IsEnable(context)).FirstOrDefault();
        }
    }
}