<?php

namespace App\Exceptions;

use Illuminate\Foundation\Exceptions\Handler as ExceptionHandler;
use Throwable;

use Symfony\Component\HttpKernel\Exception\HttpException;

use Proton\Framework\Exception\ApiException;

class Handler extends ExceptionHandler
{
    /**
     * A list of the exception types that are not reported.
     *
     * @var string[]
     */
    protected $dontReport = [
        //
    ];

    /**
     * A list of the inputs that are never flashed for validation exceptions.
     *
     * @var string[]
     */
    protected $dontFlash = [
        'current_password',
        'password',
        'password_confirmation',
    ];

    /**
     * Register the exception handling callbacks for the application.
     *
     * @return void
     */
    public function register()
    {
        $this->reportable(function (Throwable $e) {
            //
        });

        $this->renderable(function (HttpException $e, $request) {
            if ($e->getStatusCode() == 404) {
                return response(json_encode([
                    "rc" => 404,
                    "url" => $request->url(),
                    "method" => $request->method(),
                ]), 404);
            }
        });

        $this->renderable(function (UserNotLoginException $e, $request) {
            return response($e->getApiError(), 401);
        });

        $this->renderable(function (ApiException $e, $request) {
            return response($e->getApiError(), 500);
        });
    }
}
