# Copyright 2020 Appvia Ltd <info@appvia.io>
#
# Licensed under the Apache License, Version 2.0 (the "License");
# you may not use this file except in compliance with the License.
# You may obtain a copy of the License at
#
#     http://www.apache.org/licenses/LICENSE-2.0
#
# Unless required by applicable law or agreed to in writing, software
# distributed under the License is distributed on an "AS IS" BASIS,
# WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
# See the License for the specific language governing permissions and
# limitations under the License.

# Undestands how to instantiate RedisGraph client

require 'redisgraph'

module Krane
  module Clients
    module RedisGraph
      extend self

      REDIS_GRAPH_HOST = "127.0.0.1"
      REDIS_GRAPH_PORT = 6379

      def client attrs = {}
        cluster = attrs.fetch(:cluster, 'default')
        host    = attrs.fetch(:host, ENV['REDIS_GRAPH_HOST'] || REDIS_GRAPH_HOST)
        port    = attrs.fetch(:port, ENV['REDIS_GRAPH_PORT'] || REDIS_GRAPH_PORT)
        ::RedisGraph.new("rbac-#{cluster}", { host: host, port: port })
      end
    end
  end
end
