# Contributing

When contributing to this repository, please first discuss the change you wish to make via issue,
email, or any other method with the owners of this repository before making a change. 

Please note we have a code of conduct, please follow it in all your interactions with the project.

## Pull Request Process

1. Ensure any install or build dependencies are removed before the end of the layer when doing a 
   build.
2. Update the README.md with details of changes to the interface, this includes new environment 
   variables, exposed ports, useful file locations and container parameters.
3. Increase the version numbers in any examples files and the README.md to the new version that this
   Pull Request would represent. The versioning scheme we use is [SemVer](http://semver.org/).
4. You may merge the Pull Request in once you have the sign-off of two other developers, or if you 
   do not have permission to do that, you may request the second reviewer to merge it for you.

## Contributor Code of Conduct

As contributors and maintainers of this project, and in the interest of fostering an open and 
welcoming community, we pledge to respect all people who contribute through reporting issues, 
posting feature requests, updating documentation, submitting pull requests or patches, and other 
activities.

We are committed to making participation in this project a harassment-free experience for everyone, 
regardless of level of experience, gender, gender identity and expression, sexual orientation, 
disability, personal appearance, body size, race, ethnicity, age, religion, or nationality.

Examples of unacceptable behavior by participants include:

* The use of sexualized language or imagery
* Personal attacks
* Trolling or insulting/derogatory comments
* Public or private harassment
* Publishing other's private information, such as physical or electronic addresses, without explicit
  permission
* Other unethical or unprofessional conduct.

Project maintainers have the right and responsibility to remove, edit, or reject comments, commits, 
code, wiki edits, issues, and other contributions that are not aligned to this Code of Conduct. By 
adopting this Code of Conduct, project maintainers commit themselves to fairly and consistently 
applying these principles to every aspect of managing this project. Project maintainers who do not 
follow or enforce the Code of Conduct may be permanently removed from the project team.

This code of conduct applies both within project spaces and in public spaces when an individual is 
representing the project or its community.

Instances of abusive, harassing, or otherwise unacceptable behavior may be reported by opening an 
issue or contacting one or more of the project maintainers.

This Code of Conduct is adapted from the [Contributor Covenant](http://contributor-covenant.org), 
version 1.2.0, available at 
[http://contributor-covenant.org/version/1/2/0/](http://contributor-covenant.org/version/1/2/0/)