<?php

/**
 * \AppserverIo\Appserver\PersistenceContainer\PersistenceManagerFactory
 *
 * NOTICE OF LICENSE
 *
 * This source file is subject to the Open Software License (OSL 3.0)
 * that is available through the world-wide-web at this URL:
 * http://opensource.org/licenses/osl-3.0.php
 *
 * PHP version 5
 *
 * @author    Bernhard Wick <bw@appserver.io>
 * @author    Tim Wagner <tw@appserver.io>
 * @copyright 2015 TechDivision GmbH <info@appserver.io>
 * @license   http://opensource.org/licenses/osl-3.0.php Open Software License (OSL 3.0)
 * @link      https://github.com/appserver-io/appserver
 * @link      http://www.appserver.io
 */

namespace AppserverIo\Appserver\PersistenceContainer;

use AppserverIo\Storage\StackableStorage;
use AppserverIo\Psr\Application\ApplicationInterface;
use AppserverIo\Appserver\Core\Api\Node\ManagerNodeInterface;
use AppserverIo\Appserver\Core\Interfaces\ManagerFactoryInterface;

/**
 * The persistence manager handles the entity managers registered for the application.
 *
 * @author    Bernhard Wick <bw@appserver.io>
 * @author    Tim Wagner <tw@appserver.io>
 * @copyright 2015 TechDivision GmbH <info@appserver.io>
 * @license   http://opensource.org/licenses/osl-3.0.php Open Software License (OSL 3.0)
 * @link      https://github.com/appserver-io/appserver
 * @link      http://www.appserver.io
 */
class PersistenceManagerFactory implements ManagerFactoryInterface
{

    /**
     * The main method that creates new instances in a separate context.
     *
     * @param \AppserverIo\Psr\Application\ApplicationInterface         $application          The application instance to register the class loader with
     * @param \AppserverIo\Appserver\Core\Api\Node\ManagerNodeInterface $managerConfiguration The manager configuration
     *
     * @return void
     */
    public static function visit(ApplicationInterface $application, ManagerNodeInterface $managerConfiguration)
    {

        // initialize the stackable for the entity manager names
        $entityManagerNames = new StackableStorage();

        // initialize the default settings for the persistence units
        $persistenceManagerSettings = new PersistenceManagerSettings();
        $persistenceManagerSettings->mergeWithParams($managerConfiguration->getParamsAsArray());

        // initialize the persistence manager instance
        $persistenceManager = new PersistenceManager();
        $persistenceManager->injectApplication($application);
        $persistenceManager->injectEntityManagerNames($entityManagerNames);
        $persistenceManager->injectManagerSettings($persistenceManagerSettings);

        // create the naming context and add it the manager
        $contextFactory = $managerConfiguration->getContextFactory();
        $contextFactory::visit($persistenceManager);

        // attach the instance
        $application->addManager($persistenceManager, $managerConfiguration);
    }
}
