<?php

/**
 * AppserverIo\Appserver\PersistenceContainer\Doctrine\DoctrineContextSession
 *
 * NOTICE OF LICENSE
 *
 * This source file is subject to the Open Software License (OSL 3.0)
 * that is available through the world-wide-web at this URL:
 * http://opensource.org/licenses/osl-3.0.php
 *
 * PHP version 5
 *
 * @author    Tim Wagner <tw@appserver.io>
 * @copyright 2015 TechDivision GmbH <info@appserver.io>
 * @license   http://opensource.org/licenses/osl-3.0.php Open Software License (OSL 3.0)
 * @link      https://github.com/appserver-io/rmi
 * @link      http://www.appserver.io
 */

namespace AppserverIo\Appserver\PersistenceContainer\Doctrine;

use AppserverIo\RemoteMethodInvocation\ContextSession;

/**
 * The interface for the remote connection.
 *
 * @author    Tim Wagner <tw@appserver.io>
 * @author    Bernhard Wick <bw@appserver.io>
 * @copyright 2015 TechDivision GmbH <info@appserver.io>
 * @license   http://opensource.org/licenses/osl-3.0.php Open Software License (OSL 3.0)
 * @link      https://github.com/appserver-io/rmi
 * @link      http://www.appserver.io
 */
class DoctrineContextSession extends ContextSession
{

    /**
     * Clean-Up the session context by re-attaching the
     * session beans to the container.
     *
     * @return void
     */
    protected function cleanUp()
    {
        // we don't want to clean up anything here
    }

    /**
     * Creates a remote initial context instance.
     *
     * @return \AppserverIo\RemoteMethodInvocation\RemoteObjectInterface The proxy for the initial context
     * @see \AppserverIo\RemoteMethodInvocation\SessionInterface::createInitialContext()
     */
    public function createInitialContext()
    {
        $initialContext = new DoctrineInitialContextProxy();
        $initialContext->__setSession($this);
        return $initialContext;
    }
}
