<?php

/**
 * \AppserverIo\Appserver\Core\Interfaces\ProvisionerInterface
 *
 * NOTICE OF LICENSE
 *
 * This source file is subject to the Open Software License (OSL 3.0)
 * that is available through the world-wide-web at this URL:
 * http://opensource.org/licenses/osl-3.0.php
 *
 * PHP version 5
 *
 * @author    Tim Wagner <tw@appserver.io>
 * @copyright 2015 TechDivision GmbH <info@appserver.io>
 * @license   http://opensource.org/licenses/osl-3.0.php Open Software License (OSL 3.0)
 * @link      https://github.com/appserver-io/appserver
 * @link      http://www.appserver.io
 */

namespace AppserverIo\Appserver\Core\Interfaces;

/**
 * An provisioner interface.
 *
 * @author    Tim Wagner <tw@appserver.io>
 * @copyright 2015 TechDivision GmbH <info@appserver.io>
 * @license   http://opensource.org/licenses/osl-3.0.php Open Software License (OSL 3.0)
 * @link      https://github.com/appserver-io/appserver
 * @link      http://www.appserver.io
 */
interface ProvisionerInterface
{

    /**
     * Provisions all web applications.
     *
     * @return void
     */
    public function provision();

    /**
     * Returns the provisioner node configuration data.
     *
     * @return \AppserverIo\Appserver\Core\Api\Node\ProvisionerNodeInterface The provisioner node configuration data
     */
    public function getProvisionerNode();
}
