<?php

/**
 * \AppserverIo\Appserver\Core\Api\Node\ManagersNodeTrait
 *
 * NOTICE OF LICENSE
 *
 * This source file is subject to the Open Software License (OSL 3.0)
 * that is available through the world-wide-web at this URL:
 * http://opensource.org/licenses/osl-3.0.php
 *
 * PHP version 5
 *
 * @author    Tim Wagner <tw@appserver.io>
 * @author    Bernhard Wick <bw@appserver.io>
 * @copyright 2015 TechDivision GmbH <info@appserver.io>
 * @license   http://opensource.org/licenses/osl-3.0.php Open Software License (OSL 3.0)
 * @link      https://github.com/appserver-io/appserver
 * @link      http://www.appserver.io
 */

namespace AppserverIo\Appserver\Core\Api\Node;

use AppserverIo\Description\Annotations as DI;

/**
 * Abstract node that a contexts manager nodes.
 *
 * @author    Tim Wagner <tw@appserver.io>
 * @author    Bernhard Wick <bw@appserver.io>
 * @copyright 2015 TechDivision GmbH <info@appserver.io>
 * @license   http://opensource.org/licenses/osl-3.0.php Open Software License (OSL 3.0)
 * @link      https://github.com/appserver-io/appserver
 * @link      http://www.appserver.io
 */
trait ManagersNodeTrait
{

    /**
     * The contexts manager configuration.
     *
     * @var array
     * @DI\Mapping(nodeName="managers/manager", nodeType="array", elementType="AppserverIo\Appserver\Core\Api\Node\ManagerNode")
     */
    protected $managers = array();

    /**
     * Sets the contexts manager configuration.
     *
     * @param array $managers The contexts manager configuration
     *
     * @return void
     */
    public function setManagers($managers)
    {
        $this->managers = $managers;
    }

    /**
     * Returns the contexts manager configuration.
     *
     * @return array The contexts manager configuration
     */
    public function getManagers()
    {
        return $this->managers;
    }
}
