# appserver.io, a PHP application server

[![Gitter chat](https://badges.gitter.im/appserver-io/appserver.png)](https://gitter.im/appserver-io/appserver)
[![FOSSA Status](https://app.fossa.io/api/projects/git%2Bgithub.com%2Fappserver-io%2Fappserver.svg?type=shield)](https://app.fossa.io/projects/git%2Bgithub.com%2Fappserver-io%2Fappserver?ref=badge_shield)
 [![Build Status](https://img.shields.io/travis/appserver-io/appserver/master.svg?style=flat-square)](http://travis-ci.org/appserver-io/appserver)
 [![Scrutinizer Code Quality](https://img.shields.io/scrutinizer/g/appserver-io/appserver/master.svg?style=flat-square)](https://scrutinizer-ci.com/g/appserver-io/appserver/?branch=master)
 [![Code Coverage](https://img.shields.io/scrutinizer/coverage/g/appserver-io/appserver/master.svg?style=flat-square)](https://scrutinizer-ci.com/g/appserver-io/appserver/?branch=master)

This is the main repository for the [appserver.io](http://www.appserver.io/) project.

## What is appserver.io

appserver.io is a multithreaded application server for PHP, written in PHP. Yes, pure PHP! If you know anything about PHP, you're probably thinking we might be crazy. Well, we aren't. We are dead serious (but we most certainly still love having fun!).

appserver.io overcomes some of the biggest overhead issues most PHP (CGI) programs have in common, through a blazingly fast and rock solid infrastructure and with concepts new to PHP. At the same time, appserver.io offers PHP developers the fundamental core features found in most popular frameworks today, yet not intending to be a framework at all. It is a suprizingly fun infrastructure for PHP development, allowing you to build powerful applications without needing the bulk of a PHP framework.

appserver.io includes great features like...

 - Its own performant Web Server and HTTP foundation.
 - A powerful Servlet Engine, with true multi-threading
 - A Dependency Injection Container, for building modern, modular and testable code
 - Multiple Persistence Containers, for sessions and other stateful components
 - A Message Queue System, for contolling the execution of long running tasks
 - A Timer Service, for running scheduled tasks

and much more.

appserver.io also supports [Aspect Oriented Programming](http://en.wikipedia.org/wiki/Aspect-oriented_programming) (AOP), which is a programming paradigm also found in the most popular frameworks today, like Laravel. AOP allows the separation of cross-cutting concerns within a program, allowing developers to create even more modular systems.

With appserver.io, it is our goal to establish a solution as the next standard for enterprise applications written in PHP. With your help, we can reach this goal.

Give it a try!

## License
[![FOSSA Status](https://app.fossa.io/api/projects/git%2Bgithub.com%2Fappserver-io%2Fappserver.svg?type=large)](https://app.fossa.io/projects/git%2Bgithub.com%2Fappserver-io%2Fappserver?ref=badge_large)
