# Model Zoo

⚠️ For recent papers along with pre-trained models, training/evaluation recipes, and configuration files, please see [examples](https://github.com/apple/ml-cvnets/tree/main/examples) folder. We will update model zoo periodically.⚠️

This file contains the links to all the pre-trained models in CVNets and their configs:

## Classification (ImageNet-1k)

| Model | Parameters | Top-1 | Pretrained weights | Config file | Logs |
| ---  | --- | --- | --- | --- | --- |
| ViT-tiny | 5.7 M | 72.91 | [Link](https://docs-assets.developer.apple.com/ml-research/models/cvnets-v2/classification/vit-tiny.pt) | [Link](https://docs-assets.developer.apple.com/ml-research/models/cvnets-v2/classification/vit-tiny.yaml) | [Link](https://docs-assets.developer.apple.com/ml-research/models/cvnets-v2/classification/vit-tiny.logs) |
| ResNet-34 | 21.8 M | 74.85 | [Link](https://docs-assets.developer.apple.com/ml-research/models/cvnets-v2/classification/resnet-34.pt) | [Link](https://docs-assets.developer.apple.com/ml-research/models/cvnets-v2/classification/resnet-34.yaml) | [Link](https://docs-assets.developer.apple.com/ml-research/models/cvnets-v2/classification/resnet-34.logs) |
| ResNet-50 | 25.6 M | 78.44 | [Link](https://docs-assets.developer.apple.com/ml-research/models/cvnets-v2/classification/resnet-50.pt) | [Link](https://docs-assets.developer.apple.com/ml-research/models/cvnets-v2/classification/resnet-50.yaml) | [Link](https://docs-assets.developer.apple.com/ml-research/models/cvnets-v2/classification/resnet-50.logs) |
| ResNet-101 | 44.5 M | 79.81 | [Link](https://docs-assets.developer.apple.com/ml-research/models/cvnets-v2/classification/resnet-101.pt) | [Link](https://docs-assets.developer.apple.com/ml-research/models/cvnets-v2/classification/resnet-101.yaml) | [Link](https://docs-assets.developer.apple.com/ml-research/models/cvnets-v2/classification/resnet-101.logs) |
| MobileNetv1-0.25 | 0.5 M | 54.45 | [Link](https://docs-assets.developer.apple.com/ml-research/models/cvnets-v2/classification/mobilenetv1-0.25.pt) | [Link](https://docs-assets.developer.apple.com/ml-research/models/cvnets-v2/classification/mobilenetv1-0.25.yaml) | [Link](https://docs-assets.developer.apple.com/ml-research/models/cvnets-v2/classification/mobilenetv1-0.25.logs) |
| MobileNetv1-0.5 | 1.3 M | 65.93 | [Link](https://docs-assets.developer.apple.com/ml-research/models/cvnets-v2/classification/mobilenetv1-0.5.pt) | [Link](https://docs-assets.developer.apple.com/ml-research/models/cvnets-v2/classification/mobilenetv1-0.5.yaml) | [Link](https://docs-assets.developer.apple.com/ml-research/models/cvnets-v2/classification/mobilenetv1-0.5.logs) |
| MobileNetv1-0.75 | 2.6 M | 71.44 | [Link](https://docs-assets.developer.apple.com/ml-research/models/cvnets-v2/classification/mobilenetv1-0.75.pt) | [Link](https://docs-assets.developer.apple.com/ml-research/models/cvnets-v2/classification/mobilenetv1-0.75.yaml) | [Link](https://docs-assets.developer.apple.com/ml-research/models/cvnets-v2/classification/mobilenetv1-0.75.logs) |
| MobileNetv1-1.00 | 4.2 M | 74.04 | [Link](https://docs-assets.developer.apple.com/ml-research/models/cvnets-v2/classification/mobilenetv1-1.00.pt) | [Link](https://docs-assets.developer.apple.com/ml-research/models/cvnets-v2/classification/mobilenetv1-1.00.yaml) | [Link](https://docs-assets.developer.apple.com/ml-research/models/cvnets-v2/classification/mobilenetv1-1.00.logs) |
| MobileNetv2-0.25 | 1.5 M | 53.57 | [Link](https://docs-assets.developer.apple.com/ml-research/models/cvnets-v2/classification/mobilenetv2-0.25.pt) | [Link](https://docs-assets.developer.apple.com/ml-research/models/cvnets-v2/classification/mobilenetv2-0.25.yaml) | [Link](https://docs-assets.developer.apple.com/ml-research/models/cvnets-v2/classification/mobilenetv2-0.25.logs) |
| MobileNetv2-0.5 | 2.0 M | 65.28 | [Link](https://docs-assets.developer.apple.com/ml-research/models/cvnets-v2/classification/mobilenetv2-0.5.pt) | [Link](https://docs-assets.developer.apple.com/ml-research/models/cvnets-v2/classification/mobilenetv2-0.5.yaml) | [Link](https://docs-assets.developer.apple.com/ml-research/models/cvnets-v2/classification/mobilenetv2-0.5.logs) |
| MobileNetv2-0.75 | 2.6 M | 70.42 | [Link](https://docs-assets.developer.apple.com/ml-research/models/cvnets-v2/classification/mobilenetv2-0.75.pt) | [Link](https://docs-assets.developer.apple.com/ml-research/models/cvnets-v2/classification/mobilenetv2-0.75.yaml) | [Link](https://docs-assets.developer.apple.com/ml-research/models/cvnets-v2/classification/mobilenetv2-0.75.logs) |
| MobileNetv2-1.00 | 3.5 M | 72.93 | [Link](https://docs-assets.developer.apple.com/ml-research/models/cvnets-v2/classification/mobilenetv2-1.00.pt) | [Link](https://docs-assets.developer.apple.com/ml-research/models/cvnets-v2/classification/mobilenetv2-1.00.yaml) | [Link](https://docs-assets.developer.apple.com/ml-research/models/cvnets-v2/classification/mobilenetv2-1.00.logs) |
| MobileNetv3-small | 2.5 M | 66.65 | [Link](https://docs-assets.developer.apple.com/ml-research/models/cvnets-v2/classification/mobilenetv3-small.pt) | [Link](https://docs-assets.developer.apple.com/ml-research/models/cvnets-v2/classification/mobilenetv3-small.yaml) | [Link](https://docs-assets.developer.apple.com/ml-research/models/cvnets-v2/classification/mobilenetv3-small.logs) |
| MobileNetv3-large | 5.4 M | 75.13 | [Link](https://docs-assets.developer.apple.com/ml-research/models/cvnets-v2/classification/mobilenetv3-large.pt) | [Link](https://docs-assets.developer.apple.com/ml-research/models/cvnets-v2/classification/mobilenetv3-large.yaml) | [Link](https://docs-assets.developer.apple.com/ml-research/models/cvnets-v2/classification/mobilenetv3-large.logs) |
| ResNet-34 (advanced recipe) | 21.8 M | 76.91 | [Link](https://docs-assets.developer.apple.com/ml-research/models/cvnets-v2/classification/advanced/resnet-34-adv.pt) | [Link](https://docs-assets.developer.apple.com/ml-research/models/cvnets-v2/classification/advanced/resnet-34-adv.yaml) | [Link](https://docs-assets.developer.apple.com/ml-research/models/cvnets-v2/classification/advanced/resnet-34-adv.logs) |
| ResNet-50 (advanced recipe) | 25.6 M | 80.36 | [Link](https://docs-assets.developer.apple.com/ml-research/models/cvnets-v2/classification/advanced/resnet-50-adv.pt) | [Link](https://docs-assets.developer.apple.com/ml-research/models/cvnets-v2/classification/advanced/resnet-50-adv.yaml) | [Link](https://docs-assets.developer.apple.com/ml-research/models/cvnets-v2/classification/advanced/resnet-50-adv.logs) |
| ResNet-101 (advanced recipe) | 44.5 M | 81.68 | [Link](https://docs-assets.developer.apple.com/ml-research/models/cvnets-v2/classification/advanced/resnet-101-adv.pt) | [Link](https://docs-assets.developer.apple.com/ml-research/models/cvnets-v2/classification/advanced/resnet-101-adv.yaml) | [Link](https://docs-assets.developer.apple.com/ml-research/models/cvnets-v2/classification/advanced/resnet-101-adv.logs) |

### MobileViTv1 (Legacy)

Note: These resutls are from CVNets v0.1. We discontinued the support of OpenCV and switched to PIL in v0.2. For MobileViTv1 results, see v0.1.

| Model | Parameters | Top-1 | Pretrained weights | Config file |
| ---  | --- | --- | --- | --- |
| MobileViT-XXS | 1.3 M | 69.0 | [Link](https://docs-assets.developer.apple.com/ml-research/models/cvnets/classification/mobilevit_xxs.pt) | [Link](https://docs-assets.developer.apple.com/ml-research/models/cvnets/classification/mobilevit_xxs.yaml) |
| MobileViT-XS | 2.3 M | 74.7 | [Link](https://docs-assets.developer.apple.com/ml-research/models/cvnets/classification/mobilevit_xs.pt) | [Link](https://docs-assets.developer.apple.com/ml-research/models/cvnets/classification/mobilevit_xs.yaml) |
| MobileViT-S | 5.6 M | 78.3 | [Link](https://docs-assets.developer.apple.com/ml-research/models/cvnets/classification/mobilevit_s.pt) | [Link](https://docs-assets.developer.apple.com/ml-research/models/cvnets/classification/mobilevit_s.yaml) |


### MobileViTv2 (256x256)
| Model | Parameters | Top-1 | Pretrained weights | Config file | Logs |
| ---  | --- | --- | --- | --- |  --- |
| MobileViTv2-0.5 | 1.4 M | 70.18 | [Link](https://docs-assets.developer.apple.com/ml-research/models/cvnets-v2/classification/mobilevitv2/imagenet1k/256x256/mobilevitv2-0.5.pt) | [Link](https://docs-assets.developer.apple.com/ml-research/models/cvnets-v2/classification/mobilevitv2/imagenet1k/256x256/mobilevitv2-0.5.yaml) | [Link](https://docs-assets.developer.apple.com/ml-research/models/cvnets-v2/classification/mobilevitv2/imagenet1k/256x256/mobilevitv2-0.5.logs) |
| MobileViTv2-0.75 | 2.9 M | 75.56 | [Link](https://docs-assets.developer.apple.com/ml-research/models/cvnets-v2/classification/mobilevitv2/imagenet1k/256x256/mobilevitv2-0.75.pt) | [Link](https://docs-assets.developer.apple.com/ml-research/models/cvnets-v2/classification/mobilevitv2/imagenet1k/256x256/mobilevitv2-0.75.yaml) | [Link](https://docs-assets.developer.apple.com/ml-research/models/cvnets-v2/classification/mobilevitv2/imagenet1k/256x256/mobilevitv2-0.75.logs) |
| MobileViTv2-1.0 | 4.9 M | 78.09 | [Link](https://docs-assets.developer.apple.com/ml-research/models/cvnets-v2/classification/mobilevitv2/imagenet1k/256x256/mobilevitv2-1.0.pt) | [Link](https://docs-assets.developer.apple.com/ml-research/models/cvnets-v2/classification/mobilevitv2/imagenet1k/256x256/mobilevitv2-1.0.yaml) | [Link](https://docs-assets.developer.apple.com/ml-research/models/cvnets-v2/classification/mobilevitv2/imagenet1k/256x256/mobilevitv2-1.0.logs) |
| MobileViTv2-1.25 | 7.5 M | 79.65 | [Link](https://docs-assets.developer.apple.com/ml-research/models/cvnets-v2/classification/mobilevitv2/imagenet1k/256x256/mobilevitv2-1.25.pt) | [Link](https://docs-assets.developer.apple.com/ml-research/models/cvnets-v2/classification/mobilevitv2/imagenet1k/256x256/mobilevitv2-1.25.yaml) | [Link](https://docs-assets.developer.apple.com/ml-research/models/cvnets-v2/classification/mobilevitv2/imagenet1k/256x256/mobilevitv2-1.25.logs) |
| MobileViTv2-1.5 | 10.6 M | 80.38 | [Link](https://docs-assets.developer.apple.com/ml-research/models/cvnets-v2/classification/mobilevitv2/imagenet1k/256x256/mobilevitv2-1.5.pt) | [Link](https://docs-assets.developer.apple.com/ml-research/models/cvnets-v2/classification/mobilevitv2/imagenet1k/256x256/mobilevitv2-1.5.yaml) | [Link](https://docs-assets.developer.apple.com/ml-research/models/cvnets-v2/classification/mobilevitv2/imagenet1k/256x256/mobilevitv2-1.5.logs) |
| MobileViTv2-1.75 | 14.3 M | 80.84 | [Link](https://docs-assets.developer.apple.com/ml-research/models/cvnets-v2/classification/mobilevitv2/imagenet1k/256x256/mobilevitv2-1.75.pt) | [Link](https://docs-assets.developer.apple.com/ml-research/models/cvnets-v2/classification/mobilevitv2/imagenet1k/256x256/mobilevitv2-1.75.yaml) | [Link](https://docs-assets.developer.apple.com/ml-research/models/cvnets-v2/classification/mobilevitv2/imagenet1k/256x256/mobilevitv2-1.75.logs) |
| MobileViTv2-2.0 | 18.4 M | 81.17 | [Link](https://docs-assets.developer.apple.com/ml-research/models/cvnets-v2/classification/mobilevitv2/imagenet1k/256x256/mobilevitv2-2.0.pt) | [Link](https://docs-assets.developer.apple.com/ml-research/models/cvnets-v2/classification/mobilevitv2/imagenet1k/256x256/mobilevitv2-2.0.yaml) | [Link](https://docs-assets.developer.apple.com/ml-research/models/cvnets-v2/classification/mobilevitv2/imagenet1k/256x256/mobilevitv2-2.0.logs) |

### MobileViTv2 (Trained on 256x256 and Finetuned on 384x384)
| Model | Parameters | Top-1 | Pretrained weights | Config file | Logs |
| ---  | --- | --- | --- | --- |  --- |
| MobileViTv2-0.5 | 1.4 M | 72.14 | [Link](https://docs-assets.developer.apple.com/ml-research/models/cvnets-v2/classification/mobilevitv2/imagenet1k/384x384/mobilevitv2-0.5.pt) | [Link](https://docs-assets.developer.apple.com/ml-research/models/cvnets-v2/classification/mobilevitv2/imagenet1k/384x384/mobilevitv2-0.5.yaml) | [Link](https://docs-assets.developer.apple.com/ml-research/models/cvnets-v2/classification/mobilevitv2/imagenet1k/384x384/mobilevitv2-0.5.logs) |
| MobileViTv2-0.75 | 2.9 M | 76.98 | [Link](https://docs-assets.developer.apple.com/ml-research/models/cvnets-v2/classification/mobilevitv2/imagenet1k/384x384/mobilevitv2-0.75.pt) | [Link](https://docs-assets.developer.apple.com/ml-research/models/cvnets-v2/classification/mobilevitv2/imagenet1k/384x384/mobilevitv2-0.75.yaml) | [Link](https://docs-assets.developer.apple.com/ml-research/models/cvnets-v2/classification/mobilevitv2/imagenet1k/384x384/mobilevitv2-0.75.logs) |
| MobileViTv2-1.0 | 4.9 M | 79.68 | [Link](https://docs-assets.developer.apple.com/ml-research/models/cvnets-v2/classification/mobilevitv2/imagenet1k/384x384/mobilevitv2-1.0.pt) | [Link](https://docs-assets.developer.apple.com/ml-research/models/cvnets-v2/classification/mobilevitv2/imagenet1k/384x384/mobilevitv2-1.0.yaml) | [Link](https://docs-assets.developer.apple.com/ml-research/models/cvnets-v2/classification/mobilevitv2/imagenet1k/384x384/mobilevitv2-1.0.logs) |
| MobileViTv2-1.25 | 7.5 M | 80.94 | [Link](https://docs-assets.developer.apple.com/ml-research/models/cvnets-v2/classification/mobilevitv2/imagenet1k/384x384/mobilevitv2-1.25.pt) | [Link](https://docs-assets.developer.apple.com/ml-research/models/cvnets-v2/classification/mobilevitv2/imagenet1k/384x384/mobilevitv2-1.25.yaml) | [Link](https://docs-assets.developer.apple.com/ml-research/models/cvnets-v2/classification/mobilevitv2/imagenet1k/384x384/mobilevitv2-1.25.logs) |
| MobileViTv2-1.5 | 10.6 M | 81.50 | [Link](https://docs-assets.developer.apple.com/ml-research/models/cvnets-v2/classification/mobilevitv2/imagenet1k/384x384/mobilevitv2-1.5.pt) | [Link](https://docs-assets.developer.apple.com/ml-research/models/cvnets-v2/classification/mobilevitv2/imagenet1k/384x384/mobilevitv2-1.5.yaml) | [Link](https://docs-assets.developer.apple.com/ml-research/models/cvnets-v2/classification/mobilevitv2/imagenet1k/384x384/mobilevitv2-1.5.logs) |
| MobileViTv2-1.75 | 14.3 M | 82.04 | [Link](https://docs-assets.developer.apple.com/ml-research/models/cvnets-v2/classification/mobilevitv2/imagenet1k/384x384/mobilevitv2-1.75.pt) | [Link](https://docs-assets.developer.apple.com/ml-research/models/cvnets-v2/classification/mobilevitv2/imagenet1k/384x384/mobilevitv2-1.75.yaml) | [Link](https://docs-assets.developer.apple.com/ml-research/models/cvnets-v2/classification/mobilevitv2/imagenet1k/384x384/mobilevitv2-1.75.logs) |
| MobileViTv2-2.0 | 18.4 M | 82.17 | [Link](https://docs-assets.developer.apple.com/ml-research/models/cvnets-v2/classification/mobilevitv2/imagenet1k/384x384/mobilevitv2-2.0.pt) | [Link](https://docs-assets.developer.apple.com/ml-research/models/cvnets-v2/classification/mobilevitv2/imagenet1k/384x384/mobilevitv2-2.0.yaml) | [Link](https://docs-assets.developer.apple.com/ml-research/models/cvnets-v2/classification/mobilevitv2/imagenet1k/384x384/mobilevitv2-2.0.logs) |


### MobileViTv2 (Trained on ImageNet-21k and Finetuned on ImageNet-1k 256x256)
| Model | Parameters | Top-1 | Pretrained weights | Config file | Logs |
| ---  | --- | --- | --- | --- |  --- |
| MobileViTv2-1.5 | 10.6 M | 81.46 | [Link](https://docs-assets.developer.apple.com/ml-research/models/cvnets-v2/classification/mobilevitv2/imagenet21k_to_1k/256x256/mobilevitv2-1.5.pt) | [Link](https://docs-assets.developer.apple.com/ml-research/models/cvnets-v2/classification/mobilevitv2/imagenet21k_to_1k/256x256/mobilevitv2-1.5.yaml) | [Link](https://docs-assets.developer.apple.com/ml-research/models/cvnets-v2/classification/mobilevitv2/imagenet21k_to_1k/256x256/mobilevitv2-1.5.logs) |
| MobileViTv2-1.75 | 14.3 M | 81.94 | [Link](https://docs-assets.developer.apple.com/ml-research/models/cvnets-v2/classification/mobilevitv2/imagenet21k_to_1k/256x256/mobilevitv2-1.75.pt) | [Link](https://docs-assets.developer.apple.com/ml-research/models/cvnets-v2/classification/mobilevitv2/imagenet21k_to_1k/256x256/mobilevitv2-1.75.yaml) | [Link](https://docs-assets.developer.apple.com/ml-research/models/cvnets-v2/classification/mobilevitv2/imagenet21k_to_1k/256x256/mobilevitv2-1.75.logs) |
| MobileViTv2-2.0 | 18.4 M | 82.36 | [Link](https://docs-assets.developer.apple.com/ml-research/models/cvnets-v2/classification/mobilevitv2/imagenet21k_to_1k/256x256/mobilevitv2-2.0.pt) | [Link](https://docs-assets.developer.apple.com/ml-research/models/cvnets-v2/classification/mobilevitv2/imagenet21k_to_1k/256x256/mobilevitv2-2.0.yaml) | [Link](https://docs-assets.developer.apple.com/ml-research/models/cvnets-v2/classification/mobilevitv2/imagenet21k_to_1k/256x256/mobilevitv2-2.0.logs) |

### MobileViTv2 (Trained on ImageNet-21k, Finetuned on ImageNet-1k 256x256, and Finetuned on ImageNet-1k 384x384)
| Model | Parameters | Top-1 | Pretrained weights | Config file | Logs |
| ---  | --- | --- | --- | --- |  --- |
| MobileViTv2-1.5 | 10.6 M | 82.60 | [Link](https://docs-assets.developer.apple.com/ml-research/models/cvnets-v2/classification/mobilevitv2/imagenet21k_to_1k/384x384/mobilevitv2-1.5.pt) | [Link](https://docs-assets.developer.apple.com/ml-research/models/cvnets-v2/classification/mobilevitv2/imagenet21k_to_1k/384x384/mobilevitv2-1.5.yaml) | [Link](https://docs-assets.developer.apple.com/ml-research/models/cvnets-v2/classification/mobilevitv2/imagenet21k_to_1k/384x384/mobilevitv2-1.5.logs) |
| MobileViTv2-1.75 | 14.3 M | 82.93 | [Link](https://docs-assets.developer.apple.com/ml-research/models/cvnets-v2/classification/mobilevitv2/imagenet21k_to_1k/384x384/mobilevitv2-1.75.pt) | [Link](https://docs-assets.developer.apple.com/ml-research/models/cvnets-v2/classification/mobilevitv2/imagenet21k_to_1k/384x384/mobilevitv2-1.75.yaml) | [Link](https://docs-assets.developer.apple.com/ml-research/models/cvnets-v2/classification/mobilevitv2/imagenet21k_to_1k/384x384/mobilevitv2-1.75.logs) |
| MobileViTv2-2.0 | 18.4 M | 83.41 | [Link](https://docs-assets.developer.apple.com/ml-research/models/cvnets-v2/classification/mobilevitv2/imagenet21k_to_1k/384x384/mobilevitv2-2.0.pt) | [Link](https://docs-assets.developer.apple.com/ml-research/models/cvnets-v2/classification/mobilevitv2/imagenet21k_to_1k/384x384/mobilevitv2-2.0.yaml) | [Link](https://docs-assets.developer.apple.com/ml-research/models/cvnets-v2/classification/mobilevitv2/imagenet21k_to_1k/384x384/mobilevitv2-2.0.logs) |

## Object Detection (MS-COCO)

| Model | Parameters | MAP | Pretrained weights | Config file | Logs |
| ---  | --- | --- | --- | --- |  --- |
| SSD ResNet-50 | 28.5 M | 29.98 | [Link](https://docs-assets.developer.apple.com/ml-research/models/cvnets-v2/detection/coco-ssd-resnet-50.pt) | [Link](https://docs-assets.developer.apple.com/ml-research/models/cvnets-v2/detection/coco-ssd-resnet-50.yaml) | [Link](https://docs-assets.developer.apple.com/ml-research/models/cvnets-v2/detection/coco-ssd-resnet-50.logs) |
| SSD MobileViTv2-0.5 | 2.0 M | 21.24 | [Link](https://docs-assets.developer.apple.com/ml-research/models/cvnets-v2/detection/mobilevitv2/coco-ssd-mobilevitv2-0.5.pt) | [Link](https://docs-assets.developer.apple.com/ml-research/models/cvnets-v2/detection/mobilevitv2/coco-ssd-mobilevitv2-0.5.yaml) | [Link](https://docs-assets.developer.apple.com/ml-research/models/cvnets-v2/detection/mobilevitv2/coco-ssd-mobilevitv2-0.5.logs) |
| SSD MobileViTv2-0.75 | 3.6 M | 24.57 | [Link](https://docs-assets.developer.apple.com/ml-research/models/cvnets-v2/detection/mobilevitv2/coco-ssd-mobilevitv2-0.75.pt) | [Link](https://docs-assets.developer.apple.com/ml-research/models/cvnets-v2/detection/mobilevitv2/coco-ssd-mobilevitv2-0.75.yaml) | [Link](https://docs-assets.developer.apple.com/ml-research/models/cvnets-v2/detection/mobilevitv2/coco-ssd-mobilevitv2-0.75.logs) |
| SSD MobileViTv2-1.0 | 5.6 M | 26.47 | [Link](https://docs-assets.developer.apple.com/ml-research/models/cvnets-v2/detection/mobilevitv2/coco-ssd-mobilevitv2-1.0.pt) | [Link](https://docs-assets.developer.apple.com/ml-research/models/cvnets-v2/detection/mobilevitv2/coco-ssd-mobilevitv2-1.0.yaml) | [Link](https://docs-assets.developer.apple.com/ml-research/models/cvnets-v2/detection/mobilevitv2/coco-ssd-mobilevitv2-1.0.logs) |
| SSD MobileViTv2-1.25 | 8.2 M | 27.85 | [Link](https://docs-assets.developer.apple.com/ml-research/models/cvnets-v2/detection/mobilevitv2/coco-ssd-mobilevitv2-1.25.pt) | [Link](https://docs-assets.developer.apple.com/ml-research/models/cvnets-v2/detection/mobilevitv2/coco-ssd-mobilevitv2-1.25.yaml) | [Link](https://docs-assets.developer.apple.com/ml-research/models/cvnets-v2/detection/mobilevitv2/coco-ssd-mobilevitv2-1.25.logs) |
| SSD MobileViTv2-1.5 | 11.3 M | 28.83 | [Link](https://docs-assets.developer.apple.com/ml-research/models/cvnets-v2/detection/mobilevitv2/coco-ssd-mobilevitv2-1.5.pt) | [Link](https://docs-assets.developer.apple.com/ml-research/models/cvnets-v2/detection/mobilevitv2/coco-ssd-mobilevitv2-1.5.yaml) | [Link](https://docs-assets.developer.apple.com/ml-research/models/cvnets-v2/detection/mobilevitv2/coco-ssd-mobilevitv2-1.5.logs) |
| SSD MobileViTv2-1.75 | 14.9 M | 29.52 | [Link](https://docs-assets.developer.apple.com/ml-research/models/cvnets-v2/detection/mobilevitv2/coco-ssd-mobilevitv2-1.75.pt) | [Link](https://docs-assets.developer.apple.com/ml-research/models/cvnets-v2/detection/mobilevitv2/coco-ssd-mobilevitv2-1.75.yaml) | [Link](https://docs-assets.developer.apple.com/ml-research/models/cvnets-v2/detection/mobilevitv2/coco-ssd-mobilevitv2-1.75.logs) |
| SSD MobileViTv2-2.0 | 19.1 M | 30.21 | [Link](https://docs-assets.developer.apple.com/ml-research/models/cvnets-v2/detection/mobilevitv2/coco-ssd-mobilevitv2-2.0.pt) | [Link](https://docs-assets.developer.apple.com/ml-research/models/cvnets-v2/detection/mobilevitv2/coco-ssd-mobilevitv2-2.0.yaml) | [Link](https://docs-assets.developer.apple.com/ml-research/models/cvnets-v2/detection/mobilevitv2/coco-ssd-mobilevitv2-2.0.logs) |


## Segmentation

Note: The number of parameters reported does not include the auxiliary branches.

### ADE20K Dataset
| Model | Parameters | mIoU | Pretrained weights | Config file | Logs |
| ---  | --- | --- | --- | --- |  --- |
| DeepLabv3 MobileNetv2 | 8.0 M | 35.20 | [Link](https://docs-assets.developer.apple.com/ml-research/models/cvnets-v2/segmentation/ade20k/deeplabv3-mobilenetv2.pt) | [Link](https://docs-assets.developer.apple.com/ml-research/models/cvnets-v2/segmentation/ade20k/deeplabv3-mobilenetv2.yaml) | [Link](https://docs-assets.developer.apple.com/ml-research/models/cvnets-v2/segmentation/ade20k/deeplabv3-mobilenetv2.logs) |
| PSPNet MobileViTv2-0.5 | 3.6 M | 31.77 | [Link](https://docs-assets.developer.apple.com/ml-research/models/cvnets-v2/segmentation/ade20k/mobilevitv2/pspnet-mobilevitv2-0.5.pt) | [Link](https://docs-assets.developer.apple.com/ml-research/models/cvnets-v2/segmentation/ade20k/mobilevitv2/pspnet-mobilevitv2-0.5.yaml) | [Link](https://docs-assets.developer.apple.com/ml-research/models/cvnets-v2/segmentation/ade20k/mobilevitv2/pspnet-mobilevitv2-0.5.logs) |
| PSPNet MobileViTv2-0.75 | 6.2 M | 35.22 | [Link](https://docs-assets.developer.apple.com/ml-research/models/cvnets-v2/segmentation/ade20k/mobilevitv2/pspnet-mobilevitv2-0.75.pt) | [Link](https://docs-assets.developer.apple.com/ml-research/models/cvnets-v2/segmentation/ade20k/mobilevitv2/pspnet-mobilevitv2-0.75.yaml) | [Link](https://docs-assets.developer.apple.com/ml-research/models/cvnets-v2/segmentation/ade20k/mobilevitv2/pspnet-mobilevitv2-0.75.logs) |
| PSPNet MobileViTv2-1.0 | 9.4 M | 36.57 | [Link](https://docs-assets.developer.apple.com/ml-research/models/cvnets-v2/segmentation/ade20k/mobilevitv2/pspnet-mobilevitv2-1.0.pt) | [Link](https://docs-assets.developer.apple.com/ml-research/models/cvnets-v2/segmentation/ade20k/mobilevitv2/pspnet-mobilevitv2-1.0.yaml) | [Link](https://docs-assets.developer.apple.com/ml-research/models/cvnets-v2/segmentation/ade20k/mobilevitv2/pspnet-mobilevitv2-1.0.logs) |
| PSPNet MobileViTv2-1.25 | 13.2 M | 38.76 | [Link](https://docs-assets.developer.apple.com/ml-research/models/cvnets-v2/segmentation/ade20k/mobilevitv2/pspnet-mobilevitv2-1.25.pt) | [Link](https://docs-assets.developer.apple.com/ml-research/models/cvnets-v2/segmentation/ade20k/mobilevitv2/pspnet-mobilevitv2-1.25.yaml) | [Link](https://docs-assets.developer.apple.com/ml-research/models/cvnets-v2/segmentation/ade20k/mobilevitv2/pspnet-mobilevitv2-1.25.logs) |
| PSPNet MobileViTv2-1.5 | 17.6 M | 38.74 | [Link](https://docs-assets.developer.apple.com/ml-research/models/cvnets-v2/segmentation/ade20k/mobilevitv2/pspnet-mobilevitv2-1.5.pt) | [Link](https://docs-assets.developer.apple.com/ml-research/models/cvnets-v2/segmentation/ade20k/mobilevitv2/pspnet-mobilevitv2-1.5.yaml) | [Link](https://docs-assets.developer.apple.com/ml-research/models/cvnets-v2/segmentation/ade20k/mobilevitv2/pspnet-mobilevitv2-1.5.logs) |
| PSPNet MobileViTv2-1.75 | 22.5 M | 39.82 | [Link](https://docs-assets.developer.apple.com/ml-research/models/cvnets-v2/segmentation/ade20k/mobilevitv2/pspnet-mobilevitv2-1.75.pt) | [Link](https://docs-assets.developer.apple.com/ml-research/models/cvnets-v2/segmentation/ade20k/mobilevitv2/pspnet-mobilevitv2-1.75.yaml) | [Link](https://docs-assets.developer.apple.com/ml-research/models/cvnets-v2/segmentation/ade20k/mobilevitv2/pspnet-mobilevitv2-1.75.logs) |
| DeepLabv3 MobileViTv2-0.5 | 6.3 M | 31.93 | [Link](https://docs-assets.developer.apple.com/ml-research/models/cvnets-v2/segmentation/ade20k/mobilevitv2/deeplabv3-mobilevitv2-0.5.pt) | [Link](https://docs-assets.developer.apple.com/ml-research/models/cvnets-v2/segmentation/ade20k/mobilevitv2/deeplabv3-mobilevitv2-0.5.yaml) | [Link](https://docs-assets.developer.apple.com/ml-research/models/cvnets-v2/segmentation/ade20k/mobilevitv2/deeplabv3-mobilevitv2-0.5.logs) |
| DeepLabv3 MobileViTv2-0.75 | 9.6 M | 34.70 | [Link](https://docs-assets.developer.apple.com/ml-research/models/cvnets-v2/segmentation/ade20k/mobilevitv2/deeplabv3-mobilevitv2-0.75.pt) | [Link](https://docs-assets.developer.apple.com/ml-research/models/cvnets-v2/segmentation/ade20k/mobilevitv2/deeplabv3-mobilevitv2-0.75.yaml) | [Link](https://docs-assets.developer.apple.com/ml-research/models/cvnets-v2/segmentation/ade20k/mobilevitv2/deeplabv3-mobilevitv2-0.75.logs) |
| DeepLabv3 MobileViTv2-1.0 | 13.4 M | 37.06 | [Link](https://docs-assets.developer.apple.com/ml-research/models/cvnets-v2/segmentation/ade20k/mobilevitv2/deeplabv3-mobilevitv2-1.0.pt) | [Link](https://docs-assets.developer.apple.com/ml-research/models/cvnets-v2/segmentation/ade20k/mobilevitv2/deeplabv3-mobilevitv2-1.0.yaml) | [Link](https://docs-assets.developer.apple.com/ml-research/models/cvnets-v2/segmentation/ade20k/mobilevitv2/deeplabv3-mobilevitv2-1.0.logs) |
| DeepLabv3 MobileViTv2-1.25 | 17.7 M | 38.42 | [Link](https://docs-assets.developer.apple.com/ml-research/models/cvnets-v2/segmentation/ade20k/mobilevitv2/deeplabv3-mobilevitv2-1.25.pt) | [Link](https://docs-assets.developer.apple.com/ml-research/models/cvnets-v2/segmentation/ade20k/mobilevitv2/deeplabv3-mobilevitv2-1.25.yaml) | [Link](https://docs-assets.developer.apple.com/ml-research/models/cvnets-v2/segmentation/ade20k/mobilevitv2/deeplabv3-mobilevitv2-1.25.logs) |
| DeepLabv3 MobileViTv2-1.5 | 22.6 M | 38.91 | [Link](https://docs-assets.developer.apple.com/ml-research/models/cvnets-v2/segmentation/ade20k/mobilevitv2/deeplabv3-mobilevitv2-1.5.pt) | [Link](https://docs-assets.developer.apple.com/ml-research/models/cvnets-v2/segmentation/ade20k/mobilevitv2/deeplabv3-mobilevitv2-1.5.yaml) | [Link](https://docs-assets.developer.apple.com/ml-research/models/cvnets-v2/segmentation/ade20k/mobilevitv2/deeplabv3-mobilevitv2-1.5.logs) |
| DeepLabv3 MobileViTv2-1.75 | 28.1 M | 39.53 | [Link](https://docs-assets.developer.apple.com/ml-research/models/cvnets-v2/segmentation/ade20k/mobilevitv2/deeplabv3-mobilevitv2-1.75.pt) | [Link](https://docs-assets.developer.apple.com/ml-research/models/cvnets-v2/segmentation/ade20k/mobilevitv2/deeplabv3-mobilevitv2-1.75.yaml) | [Link](https://docs-assets.developer.apple.com/ml-research/models/cvnets-v2/segmentation/ade20k/mobilevitv2/deeplabv3-mobilevitv2-1.75.logs) |
| DeepLabv3 MobileViTv2-2.0 | 34.0 M | 40.94 | [Link](https://docs-assets.developer.apple.com/ml-research/models/cvnets-v2/segmentation/ade20k/mobilevitv2/deeplabv3-mobilevitv2-2.0.pt) | [Link](https://docs-assets.developer.apple.com/ml-research/models/cvnets-v2/segmentation/ade20k/mobilevitv2/deeplabv3-mobilevitv2-2.0.yaml) | [Link](https://docs-assets.developer.apple.com/ml-research/models/cvnets-v2/segmentation/ade20k/mobilevitv2/deeplabv3-mobilevitv2-2.0.logs) |


### Pascal VOC 2012 Dataset
| Model | Parameters | mIoU | Pretrained weights | Config file | Logs |
| ---  | --- | --- | --- | --- |  --- |
| DeepLabv3 MobileViTv1 | 8.5 M | 79.44 | [Link](https://docs-assets.developer.apple.com/ml-research/models/cvnets-v2/segmentation/pascalvoc/deeplabv3-mobilevitv1.pt) | [Link](https://docs-assets.developer.apple.com/ml-research/models/cvnets-v2/segmentation/pascalvoc/deeplabv3-mobilevitv1.yaml) | [Link](https://docs-assets.developer.apple.com/ml-research/models/cvnets-v2/segmentation/pascalvoc/deeplabv3-mobilevitv1.logs) |
| PSPNet MobileViTv2-0.5 | 3.6 M | 74.62 | [Link](https://docs-assets.developer.apple.com/ml-research/models/cvnets-v2/segmentation/pascalvoc/mobilevitv2/pspnet-mobilevitv2-0.5.pt) | [Link](https://docs-assets.developer.apple.com/ml-research/models/cvnets-v2/segmentation/pascalvoc/mobilevitv2/pspnet-mobilevitv2-0.5.yaml) | [Link](https://docs-assets.developer.apple.com/ml-research/models/cvnets-v2/segmentation/pascalvoc/mobilevitv2/pspnet-mobilevitv2-0.5.logs) |
| PSPNet MobileViTv2-0.75 | 6.2 M | 77.44 | [Link](https://docs-assets.developer.apple.com/ml-research/models/cvnets-v2/segmentation/pascalvoc/mobilevitv2/pspnet-mobilevitv2-0.75.pt) | [Link](https://docs-assets.developer.apple.com/ml-research/models/cvnets-v2/segmentation/pascalvoc/mobilevitv2/pspnet-mobilevitv2-0.75.yaml) | [Link](https://docs-assets.developer.apple.com/ml-research/models/cvnets-v2/segmentation/pascalvoc/mobilevitv2/pspnet-mobilevitv2-0.75.logs) |
| PSPNet MobileViTv2-1.0 | 9.4 M | 78.92 | [Link](https://docs-assets.developer.apple.com/ml-research/models/cvnets-v2/segmentation/pascalvoc/mobilevitv2/pspnet-mobilevitv2-1.0.pt) | [Link](https://docs-assets.developer.apple.com/ml-research/models/cvnets-v2/segmentation/pascalvoc/mobilevitv2/pspnet-mobilevitv2-1.0.yaml) | [Link](https://docs-assets.developer.apple.com/ml-research/models/cvnets-v2/segmentation/pascalvoc/mobilevitv2/pspnet-mobilevitv2-1.0.logs) |
| PSPNet MobileViTv2-1.25 | 13.2 M | 79.40 | [Link](https://docs-assets.developer.apple.com/ml-research/models/cvnets-v2/segmentation/pascalvoc/mobilevitv2/pspnet-mobilevitv2-1.25.pt) | [Link](https://docs-assets.developer.apple.com/ml-research/models/cvnets-v2/segmentation/pascalvoc/mobilevitv2/pspnet-mobilevitv2-1.25.yaml) | [Link](https://docs-assets.developer.apple.com/ml-research/models/cvnets-v2/segmentation/pascalvoc/mobilevitv2/pspnet-mobilevitv2-1.25.logs) |
| PSPNet MobileViTv2-1.5 | 17.5 M | 79.93 | [Link](https://docs-assets.developer.apple.com/ml-research/models/cvnets-v2/segmentation/pascalvoc/mobilevitv2/pspnet-mobilevitv2-1.5.pt) | [Link](https://docs-assets.developer.apple.com/ml-research/models/cvnets-v2/segmentation/pascalvoc/mobilevitv2/pspnet-mobilevitv2-1.5.yaml) | [Link](https://docs-assets.developer.apple.com/ml-research/models/cvnets-v2/segmentation/pascalvoc/mobilevitv2/pspnet-mobilevitv2-1.5.logs) |
| DeepLabv3 MobileViTv2-0.5 | 6.2 M | 75.07 | [Link](https://docs-assets.developer.apple.com/ml-research/models/cvnets-v2/segmentation/pascalvoc/mobilevitv2/deeplabv3-mobilevitv2-0.5.pt) | [Link](https://docs-assets.developer.apple.com/ml-research/models/cvnets-v2/segmentation/pascalvoc/mobilevitv2/deeplabv3-mobilevitv2-0.5.yaml) | [Link](https://docs-assets.developer.apple.com/ml-research/models/cvnets-v2/segmentation/pascalvoc/mobilevitv2/deeplabv3-mobilevitv2-0.5.logs) |
| DeepLabv3 MobileViTv2-1.0 | 13.3 M | 78.94 | [Link](https://docs-assets.developer.apple.com/ml-research/models/cvnets-v2/segmentation/pascalvoc/mobilevitv2/deeplabv3-mobilevitv2-1.0.pt) | [Link](https://docs-assets.developer.apple.com/ml-research/models/cvnets-v2/segmentation/pascalvoc/mobilevitv2/deeplabv3-mobilevitv2-1.0.yaml) | [Link](https://docs-assets.developer.apple.com/ml-research/models/cvnets-v2/segmentation/pascalvoc/mobilevitv2/deeplabv3-mobilevitv2-1.0.logs) |
| DeepLabv3 MobileViTv2-1.25 | 17.7 M | 79.68 | [Link](https://docs-assets.developer.apple.com/ml-research/models/cvnets-v2/segmentation/pascalvoc/mobilevitv2/deeplabv3-mobilevitv2-1.25.pt) | [Link](https://docs-assets.developer.apple.com/ml-research/models/cvnets-v2/segmentation/pascalvoc/mobilevitv2/deeplabv3-mobilevitv2-1.25.yaml) | [Link](https://docs-assets.developer.apple.com/ml-research/models/cvnets-v2/segmentation/pascalvoc/mobilevitv2/deeplabv3-mobilevitv2-1.25.logs) |
| DeepLabv3 MobileViTv2-1.5 | 22.6 M | 80.30 | [Link](https://docs-assets.developer.apple.com/ml-research/models/cvnets-v2/segmentation/pascalvoc/mobilevitv2/deeplabv3-mobilevitv2-1.5.pt) | [Link](https://docs-assets.developer.apple.com/ml-research/models/cvnets-v2/segmentation/pascalvoc/mobilevitv2/deeplabv3-mobilevitv2-1.5.yaml) | [Link](https://docs-assets.developer.apple.com/ml-research/models/cvnets-v2/segmentation/pascalvoc/mobilevitv2/deeplabv3-mobilevitv2-1.5.logs) |


## Video Classification (Kinetics-400)


| Model | Parameters | Top-1 | Pretrained weights | Config file | Logs |
| ---  | --- | --- | --- | --- |  --- |
| MobileViTv1-small-SpatioTemporal | 5.2 M | 68.38 | [Link](https://docs-assets.developer.apple.com/ml-research/models/cvnets-v2/video_classification/mobilevitv1-small-st.pt) | [Link](https://docs-assets.developer.apple.com/ml-research/models/cvnets-v2/video_classification/mobilevitv1-small-st.yaml) | [Link](https://docs-assets.developer.apple.com/ml-research/models/cvnets-v2/video_classification/mobilevitv1-small-st.logs) |
