#
# For licensing see accompanying LICENSE file.
# Copyright (C) 2023 Apple Inc. All Rights Reserved.
#

from typing import List

CLIP_IMAGENET_TEMPLATES = [
    "a bad photo of a {class_name}.",
    "a photo of many {class_name}.",
    "a sculpture of a {class_name}.",
    "a photo of the hard to see {class_name}.",
    "a low resolution photo of the {class_name}.",
    "a rendering of a {class_name}.",
    "graffiti of a {class_name}.",
    "a bad photo of the {class_name}.",
    "a cropped photo of the {class_name}.",
    "a tattoo of a {class_name}.",
    "the embroidered {class_name}.",
    "a photo of a hard to see {class_name}.",
    "a bright photo of a {class_name}.",
    "a photo of a clean {class_name}.",
    "a photo of a dirty {class_name}.",
    "a dark photo of the {class_name}.",
    "a drawing of a {class_name}.",
    "a photo of my {class_name}.",
    "the plastic {class_name}.",
    "a photo of the cool {class_name}.",
    "a close-up photo of a {class_name}.",
    "a black and white photo of the {class_name}.",
    "a painting of the {class_name}.",
    "a painting of a {class_name}.",
    "a pixelated photo of the {class_name}.",
    "a sculpture of the {class_name}.",
    "a bright photo of the {class_name}.",
    "a cropped photo of a {class_name}.",
    "a plastic {class_name}.",
    "a photo of the dirty {class_name}.",
    "a jpeg corrupted photo of a {class_name}.",
    "a blurry photo of the {class_name}.",
    "a photo of the {class_name}.",
    "a good photo of the {class_name}.",
    "a rendering of the {class_name}.",
    "a {class_name} in a video game.",
    "a photo of one {class_name}.",
    "a doodle of a {class_name}.",
    "a close-up photo of the {class_name}.",
    "a photo of a {class_name}.",
    "the origami {class_name}.",
    "the {class_name} in a video game.",
    "a sketch of a {class_name}.",
    "a doodle of the {class_name}.",
    "a origami {class_name}.",
    "a low resolution photo of a {class_name}.",
    "the toy {class_name}.",
    "a rendition of the {class_name}.",
    "a photo of the clean {class_name}.",
    "a photo of a large {class_name}.",
    "a rendition of a {class_name}.",
    "a photo of a nice {class_name}.",
    "a photo of a weird {class_name}.",
    "a blurry photo of a {class_name}.",
    "a cartoon {class_name}.",
    "art of a {class_name}.",
    "a sketch of the {class_name}.",
    "a embroidered {class_name}.",
    "a pixelated photo of a {class_name}.",
    "itap of the {class_name}.",
    "a jpeg corrupted photo of the {class_name}.",
    "a good photo of a {class_name}.",
    "a plushie {class_name}.",
    "a photo of the nice {class_name}.",
    "a photo of the small {class_name}.",
    "a photo of the weird {class_name}.",
    "the cartoon {class_name}.",
    "art of the {class_name}.",
    "a drawing of the {class_name}.",
    "a photo of the large {class_name}.",
    "a black and white photo of a {class_name}.",
    "the plushie {class_name}.",
    "a dark photo of a {class_name}.",
    "itap of a {class_name}.",
    "graffiti of the {class_name}.",
    "a toy {class_name}.",
    "itap of my {class_name}.",
    "a photo of a cool {class_name}.",
    "a photo of a small {class_name}.",
    "a tattoo of the {class_name}.",
]


def generate_text_prompts_clip(class_name) -> List[str]:
    """Return a list of prompts for the given class name."""
    return [
        template.format(class_name=class_name) for template in CLIP_IMAGENET_TEMPLATES
    ]
