---
layout: post
permalink: "/debug/langs/"
title: "`/debug/langs/`"
image: assets/img-min/social/rRS54e00uoQ.webp
author: apkd
likeable: false
editable: false
searchable: false
sitemap: false
---

<style>
table strong {
  display: inline-block;
  width: 10vw;
  min-width: 4rem;
  max-width: 8rem;
}
</style>

list of languages supported on this website

<div class="table-responsive" markdown="block">

| **Code**                | Description                                                                                                              |
|-------------------------|--------------------------------------------------------------------------------------------------------------------------|
| `abap`                  | ABAP, a high-level programming language created by SAP                                                                   |
| `actionscript`          | ActionScript, an object-oriented programming language for Adobe Flash                                                    |
| `apache`                | Apache, used for configuring Apache HTTP Server                                                                          |
| `apiblueprint`          | API Blueprint, a design-first language for RESTful APIs                                                                  |
| `applescript`           | AppleScript, an English-like language used to automate actions on Mac OS X                                               |
| `awk`                   | AWK, a text-processing language for making data extraction easier                                                        |
| `biml`                  | BIML, a language for defining business intelligence and data warehouse solutions                                         |
| `brainfuck`             | Brainfuck, a minimalist and tricky-to-read programming language                                                          |
| `bsl`                   | BSL, the programming language for the 1C:Enterprise software system                                                      |
| `c`                     | C, a high-level and widely-used programming language                                                                     |
| `ceylon`                | Ceylon, a statically-typed, flow-sensitive language by Red Hat                                                           |
| `cfscript`              | CFScript, a scripting language for Adobe ColdFusion Markup Language                                                      |
| `clojure`               | Clojure, a modern, dynamic, and functional dialect of the Lisp language                                                  |
| `cmake`                 | CMake, a platform that manages the build process in an OS and Compiler independent manner                                |
| `coffeescript`          | CoffeeScript, a little language that compiles into JavaScript                                                            |
| `common_lisp`           | Common Lisp, the modern, multi-paradigm, high-performance dialect of Lisp                                                |
| `conf`                  | Lexer for various configuration file formats                                                                             |
| `console`               | Lexer for shell sessions, including command-line input and output                                                        |
| `coq`                   | Coq, a formal proof management system                                                                                    |
| `cpp`                   | C++, a statically-typed, free-form, multi-paradigm, compiled, general-purpose programming language                       |
| `crystal`               | Crystal, a statically-typed, compiled language with Ruby-like syntax                                                     |
| `csharp`                | C#, a statically-typed, multi-paradigm language designed for the Common Language Infrastructure                          |
| `css`                   | CSS, a style-sheet language used for describing the look and formatting of a document written in HTML                    |
| `d`                     | D, a language with C-like syntax and static typing                                                                       |
| `dart`                  | Dart, a client-optimized language for fast apps on any platform                                                          |
| `diff`                  | Lexer for unified diffs or patches, showing changes made to a document                                                   |
| `digdag`                | DigDag, a simple workflow engine for scripting multi-step tasks                                                          |
| `docker`                | Dockerfile, a script of instructions used to create Docker images                                                        |
| `dot`                   | DOT, a graph description language used in the Graphviz tool                                                              |
| `eiffel`                | Eiffel, an object-oriented language emphasizing design by contract                                                       |
| `elixir`                | Elixir, a functional, concurrent, general-purpose programming language that runs on the Erlang virtual machine           |
| `elm`                   | Elm, a functional language that compiles to JavaScript                                                                   |
| `erb`                   | ERB (Embedded RuBy), a templating system that embeds Ruby into a text document                                           |
| `erlang`                | Erlang, a general-purpose, concurrent, functional programming language                                                   |
| `escape`                | Lexer for including escaped content                                                                                      |
| `factor`                | Factor, a stack-based, reflective, concatenative programming language                                                    |
| `fortran`               | Fortran, a general-purpose, compiled imperative programming language                                                     |
| `fsharp`                | F#, a functional-first programming language developed by Microsoft                                                       |
| `gherkin`               | Gherkin, a business-readable language used for behavior-driven development                                               |
| `glsl`                  | GLSL, a high-level shading language for programmable GPUs                                                                |
| `go`                    | Go, a statically-typed compiled language developed by Google                                                             |
| `gradle`                | Gradle, a powerful build automation system that leverages the JVM                                                        |
| `graphql`               | GraphQL, a data query and manipulation language for APIs                                                                 |
| `groovy`                | Groovy, a dynamic, object-oriented language for the Java platform                                                        |
| `hack`                  | Hack, a statically-typed dialect of PHP developed by Facebook                                                            |
| `haml`                  | Haml, a lightweight markup language used for templating in Ruby                                                          |
| `handlebars`            | Handlebars, a popular templating engine for JavaScript                                                                   |
| `haskell`               | Haskell, a statically-typed, purely functional programming language                                                      |
| `hcl`                   | HCL, a configuration language used by HashiCorp's software suite                                                         |
| `gherkin`               | Business-readable domain-specific language for behavior-driven development                                               |
| `glsl`                  | C-like language for programming shaders                                                                                  |
| `go`                    | Statically typed, compiled language known for simplicity and efficiency                                                  |
| `gradle`                | Build automation system using Groovy                                                                                     |
| `graphql`               | Data query and manipulation language for APIs                                                                            |
| `groovy`                | Object-oriented language for the Java platform                                                                           |
| `hack`                  | Static typing for PHP                                                                                                    |
| `haml`                  | Lightweight markup language used for templating in Ruby                                                                  |
| `handlebars`            | Templating system to build semantic templates                                                                            |
| `haskell`               | Purely functional, statically typed language                                                                             |
| `hcl`                   | Configuration language used by HashiCorp's tools                                                                         |
| `hack`                  | Hack, a programming language for the HipHop Virtual Machine (HHVM)                                                       |
| `haml`                  | Haml, a Ruby-based HTML abstraction markup language                                                                      |
| `handlebars`            | Handlebars/Mustache, a logicless templating languages                                                                    |
| `haskell`               | Haskell, a statically typed, purely functional programming language                                                      |
| `hcl`                   | HCL, a configuration language by HashiCorp used in many of their tools                                                   |
| `html`                  | HTML, the standard markup language for creating web pages                                                                |
| `http`                  | HTTP, a protocol used for transmitting hypermedia documents                                                              |
| `hylang`                | HyLang, a Lisp-flavored Python                                                                                           |
| `idlang`                | IDL, a programming language used for data analysis                                                                       |
| `igorpro`               | Igor Pro, a scientific data analysis software                                                                            |
| `ini`                   | INI, a simple configuration file format                                                                                  |
| `io`                    | Io, a pure object-oriented programming language inspired by Smalltalk                                                    |
| `irb`                   | IRB, an interactive Ruby shell                                                                                           |
| `java`                  | Java, a class-based, object-oriented programming language                                                                |
| `javascript`            | JavaScript, a high-level, interpreted scripting language for web development                                             |
| `jinja`                 | Jinja, a web template engine for Python                                                                                  |
| `json`                  | JSON, a lightweight data-interchange format                                                                              |
| `json-doc`              | JSON-Doc, a variant of JSON with documentation extensions                                                                |
| `jsonnet`               | Jsonnet, a data templating language for app configuration                                                                |
| `jsp`                   | JSP, a technology for developing web pages that support dynamic content                                                  |
| `jsx`                   | JSX, a syntax extension for JavaScript used in React.js                                                                  |
| `julia`                 | Julia, a high-level, high-performance language for technical computing                                                   |
| `kotlin`                | Kotlin, a statically typed programming language for modern multi-platform applications                                   |
| `lasso`                 | Lasso, a programming language for web development                                                                        |
| `liquid`                | Liquid, a Ruby library for rendering safe templates                                                                      |
| `literate_coffeescript` | Literate CoffeeScript, a literate programming variant of CoffeeScript                                                    |
| `literate_haskell`      | Literate Haskell, a literate programming variant of Haskell                                                              |
| `llvm`                  | LLVM, a collection of modular and reusable compiler and toolchain technologies                                           |
| `lua`                   | Lua, a lightweight, high-level, multi-paradigm programming language                                                      |
| `m68k`                  | M68k, an assembly language for Motorola 68k microprocessors                                                              |
| `magik`                 | Magik, a dynamic, object-oriented programming language                                                                   |
| `make`                  | Make, a build automation tool                                                                                            |
| `markdown`              | Markdown, a lightweight markup language for creating formatted text                                                      |
| `mathematica`           | Mathematica, a computational software used in scientific, engineering, and mathematical fields                           |
| `matlab`                | MATLAB, a high-level language and interactive environment for numerical computation                                      |
| `moonscript`            | MoonScript, a dynamic scripting language that compiles into Lua                                                          |
| `mosel`                 | Mosel, a modeling language for mathematical optimization                                                                 |
| `mxml`                  | MXML, a XML-based user interface markup language for Adobe Flex                                                          |
| `nasm`                  | NASM, an assembler for the x86 CPU architecture                                                                          |
| `nginx`                 | Nginx, a web server which can also be used as a reverse proxy                                                            |
| `nim`                   | Nim, a statically typed compiled systems programming language                                                            |
| `nix`                   | Nix, a purely functional package manager                                                                                 |
| `objective_c`           | Objective-C, a general-purpose, object-oriented language that adds Smalltalk-style messaging to C                        |
| `ocaml`                 | OCaml, an industrial strength programming language supporting functional, imperative and object-oriented styles          |
| `pascal`                | Pascal, a simple, efficient, and readable programming language often used for teaching structured programming            |
| `perl`                  | Perl, a high-level, general-purpose, interpreted, dynamic programming language                                           |
| `php`                   | PHP, a popular general-purpose scripting language that is especially suited to web development                           |
| `plaintext`             | Plain text, unformatted text                                                                                             |
| `plist`                 | Plist, a type of file used to store user preference files, applications, and in software development                     |
| `powershell`            | PowerShell, a task automation and configuration management framework from Microsoft                                      |
| `praat`                 | Praat, a language for phonetic analysis                                                                                  |
| `prolog`                | Prolog, a logic programming language associated with artificial intelligence and computational linguistics               |
| `prometheus`            | Prometheus, a monitoring system and time series database                                                                 |
| `properties`            | Java Properties Files, simple text files for storing configuration data for Java applications                            |
| `protobuf`              | Protocol Buffers, a method of serializing structured data by Google                                                      |
| `puppet`                | Puppet, a configuration management tool by Puppet labs                                                                   |
| `python`                | Python, a high-level, interpreted, interactive and object-oriented scripting language                                    |
| `q`                     | Q, a programming language for array processing, typically used for time series data                                      |
| `qml`                   | QML, a user interface markup language by Qt for designing desktop and mobile apps                                        |
| `r`                     | R, a programming language and software environment for statistical computing and graphics                                |
| `racket`                | Racket, a general-purpose, multi-paradigm programming language based on the Scheme dialect of Lisp                       |
| `ruby`                  | Ruby, a dynamic, open source programming language with a focus on simplicity and productivity                            |
| `rust`                  | Rust, a multi-paradigm programming language focused on performance and safety                                            |
| `sass`                  | Sass, a preprocessor scripting language that is interpreted or compiled into Cascading Style Sheets (CSS)                |
| `scala`                 | Scala, a high-level language that integrates object-oriented and functional programming                                  |
| `scheme`                | Scheme, a minimalist dialect of the Lisp family of programming languages                                                 |
| `scss`                  | SCSS, a CSS preprocessor that uses Sass syntax                                                                           |
| `sed`                   | Sed, a Unix utility that parses and transforms text                                                                      |
| `shell`                 | Shell scripting, scripting in Unix-like operating systems                                                                |
| `sieve`                 | Sieve, a language for filtering email messages                                                                           |
| `slim`                  | Slim, a lightweight templating engine for Ruby                                                                           |
| `smalltalk`             | Smalltalk, an object-oriented, dynamically typed reflective programming language                                         |
| `smarty`                | Smarty, a web template system written in PHP                                                                             |
| `sml`                   | Standard ML, a general-purpose, modular, functional programming language                                                 |
| `sqf`                   | SQF, a scripting language used for gaming (Arma)                                                                         |
| `sql`                   | SQL, a standard language for managing data held in a relational database management system                               |
| `supercollider`         | SuperCollider, an environment and programming language for real-time audio synthesis                                     |
| `swift`                 | Swift, a powerful and intuitive programming language for iOS, macOS, watchOS, and beyond                                 |
| `tap`                   | TAP, a protocol for communication between unit tests and a test harness                                                  |
| `tcl`                   | TCL, a scripting language commonly used for GUIs and testing                                                             |
| `terraform`             | Terraform, a tool for building, changing, and versioning infrastructure safely and efficiently                           |
| `tex`                   | TeX, a typesetting system designed for the creation of beautiful books                                                   |
| `toml`                  | TOML, a minimal configuration file format that's easy to read due to obvious semantics                                   |
| `tsx`                   | TSX, an XML-like syntax extension to TypeScript                                                                          |
| `tulip`                 | Tulip, a programming language designed for writing concurrent systems                                                    |
| `turtle`                | Turtle, a syntax and file format for expressing data in the RDF data model                                               |
| `twig`                  | Twig, a flexible, fast, and secure template engine for PHP                                                               |
| `typescript`            | TypeScript, a statically typed superset of JavaScript that adds optional types                                           |
| `vala`                  | Vala, an object-oriented programming language with a self-hosting compiler that generates C code                         |
| `vb`                    | Visual Basic, a third-generation event-driven programming language and integrated development environment from Microsoft |
| `verilog`               | Verilog, a hardware description language used to model electronic systems                                                |
| `vhdl`                  | VHDL, a hardware description language used in electronic design automation to describe digital and mixed-signal systems  |
| `viml`                  | VimL, a powerful scripting language native to the Vim text editor                                                        |
| `vue`                   | Vue.js, a progressive JavaScript framework for building user interfaces                                                  |
| `wollok`                | Wollok, a programming language and environment for learning and teaching OOP                                             |
| `xml`                   | XML, a markup language that defines a set of rules for encoding documents                                                |
| `xojo`                  | Xojo, a rapid application development tool for creating powerful, native applications                                    |
| `yaml`                  | YAML, a human-friendly data serialization standard for all programming languages                                         |

</div>

{% capture a %}`kvps.Select(x => $"{x.Key}").Join('\n');`{% endcapture %}
{% capture b %}`the quick brown fox jumps over 16 the 32f lazy 0xff dog`{% endcapture %}
{% capture c %}`\Packages\com.unity.burst\package.json`{% endcapture %}

<div class="table-responsive" markdown="block">

| lang                    | csharp                                            | sentence                                          | path                                              |
|-------------------------|---------------------------------------------------|---------------------------------------------------|---------------------------------------------------| 
| `abap`                  | {{a}}{:.highlight.language-abap}                  | {{b}}{:.highlight.language-abap}                  | {{c}}{:.highlight.language-abap}                  |
| `actionscript`          | {{a}}{:.highlight.language-actionscript}          | {{b}}{:.highlight.language-actionscript}          | {{c}}{:.highlight.language-actionscript}          |
| `apache`                | {{a}}{:.highlight.language-apache}                | {{b}}{:.highlight.language-apache}                | {{c}}{:.highlight.language-apache}                |
| `apiblueprint`          | {{a}}{:.highlight.language-apiblueprint}          | {{b}}{:.highlight.language-apiblueprint}          | {{c}}{:.highlight.language-apiblueprint}          |
| `applescript`           | {{a}}{:.highlight.language-applescript}           | {{b}}{:.highlight.language-applescript}           | {{c}}{:.highlight.language-applescript}           |
| `awk`                   | {{a}}{:.highlight.language-awk}                   | {{b}}{:.highlight.language-awk}                   | {{c}}{:.highlight.language-awk}                   |
| `biml`                  | {{a}}{:.highlight.language-biml}                  | {{b}}{:.highlight.language-biml}                  | {{c}}{:.highlight.language-biml}                  |
| `brainfuck`             | {{a}}{:.highlight.language-brainfuck}             | {{b}}{:.highlight.language-brainfuck}             | {{c}}{:.highlight.language-brainfuck}             |
| `bsl`                   | {{a}}{:.highlight.language-bsl}                   | {{b}}{:.highlight.language-bsl}                   | {{c}}{:.highlight.language-bsl}                   |
| `c`                     | {{a}}{:.highlight.language-c}                     | {{b}}{:.highlight.language-c}                     | {{c}}{:.highlight.language-c}                     |
| `ceylon`                | {{a}}{:.highlight.language-ceylon}                | {{b}}{:.highlight.language-ceylon}                | {{c}}{:.highlight.language-ceylon}                |
| `cfscript`              | {{a}}{:.highlight.language-cfscript}              | {{b}}{:.highlight.language-cfscript}              | {{c}}{:.highlight.language-cfscript}              |
| `clojure`               | {{a}}{:.highlight.language-clojure}               | {{b}}{:.highlight.language-clojure}               | {{c}}{:.highlight.language-clojure}               |
| `cmake`                 | {{a}}{:.highlight.language-cmake}                 | {{b}}{:.highlight.language-cmake}                 | {{c}}{:.highlight.language-cmake}                 |
| `coffeescript`          | {{a}}{:.highlight.language-coffeescript}          | {{b}}{:.highlight.language-coffeescript}          | {{c}}{:.highlight.language-coffeescript}          |
| `common_lisp`           | {{a}}{:.highlight.language-common_lisp}           | {{b}}{:.highlight.language-common_lisp}           | {{c}}{:.highlight.language-common_lisp}           |
| `conf`                  | {{a}}{:.highlight.language-conf}                  | {{b}}{:.highlight.language-conf}                  | {{c}}{:.highlight.language-conf}                  |
| `console`               | {{a}}{:.highlight.language-console}               | {{b}}{:.highlight.language-console}               | {{c}}{:.highlight.language-console}               |
| `coq`                   | {{a}}{:.highlight.language-coq}                   | {{b}}{:.highlight.language-coq}                   | {{c}}{:.highlight.language-coq}                   |
| `cpp`                   | {{a}}{:.highlight.language-cpp}                   | {{b}}{:.highlight.language-cpp}                   | {{c}}{:.highlight.language-cpp}                   |
| `crystal`               | {{a}}{:.highlight.language-crystal}               | {{b}}{:.highlight.language-crystal}               | {{c}}{:.highlight.language-crystal}               |
| `csharp`                | {{a}}{:.highlight.language-csharp}                | {{b}}{:.highlight.language-csharp}                | {{c}}{:.highlight.language-csharp}                |
| `css`                   | {{a}}{:.highlight.language-css}                   | {{b}}{:.highlight.language-css}                   | {{c}}{:.highlight.language-css}                   |
| `d`                     | {{a}}{:.highlight.language-d}                     | {{b}}{:.highlight.language-d}                     | {{c}}{:.highlight.language-d}                     |
| `dart`                  | {{a}}{:.highlight.language-dart}                  | {{b}}{:.highlight.language-dart}                  | {{c}}{:.highlight.language-dart}                  |
| `diff`                  | {{a}}{:.highlight.language-diff}                  | {{b}}{:.highlight.language-diff}                  | {{c}}{:.highlight.language-diff}                  |
| `digdag`                | {{a}}{:.highlight.language-digdag}                | {{b}}{:.highlight.language-digdag}                | {{c}}{:.highlight.language-digdag}                |
| `docker`                | {{a}}{:.highlight.language-docker}                | {{b}}{:.highlight.language-docker}                | {{c}}{:.highlight.language-docker}                |
| `dot`                   | {{a}}{:.highlight.language-dot}                   | {{b}}{:.highlight.language-dot}                   | {{c}}{:.highlight.language-dot}                   |
| `eiffel`                | {{a}}{:.highlight.language-eiffel}                | {{b}}{:.highlight.language-eiffel}                | {{c}}{:.highlight.language-eiffel}                |
| `elixir`                | {{a}}{:.highlight.language-elixir}                | {{b}}{:.highlight.language-elixir}                | {{c}}{:.highlight.language-elixir}                |
| `elm`                   | {{a}}{:.highlight.language-elm}                   | {{b}}{:.highlight.language-elm}                   | {{c}}{:.highlight.language-elm}                   |
| `erb`                   | {{a}}{:.highlight.language-erb}                   | {{b}}{:.highlight.language-erb}                   | {{c}}{:.highlight.language-erb}                   |
| `erlang`                | {{a}}{:.highlight.language-erlang}                | {{b}}{:.highlight.language-erlang}                | {{c}}{:.highlight.language-erlang}                |
| `escape`                | {{a}}{:.highlight.language-escape}                | {{b}}{:.highlight.language-escape}                | {{c}}{:.highlight.language-escape}                |
| `factor`                | {{a}}{:.highlight.language-factor}                | {{b}}{:.highlight.language-factor}                | {{c}}{:.highlight.language-factor}                |
| `fortran`               | {{a}}{:.highlight.language-fortran}               | {{b}}{:.highlight.language-fortran}               | {{c}}{:.highlight.language-fortran}               |
| `fsharp`                | {{a}}{:.highlight.language-fsharp}                | {{b}}{:.highlight.language-fsharp}                | {{c}}{:.highlight.language-fsharp}                |
| `gherkin`               | {{a}}{:.highlight.language-gherkin}               | {{b}}{:.highlight.language-gherkin}               | {{c}}{:.highlight.language-gherkin}               |
| `glsl`                  | {{a}}{:.highlight.language-glsl}                  | {{b}}{:.highlight.language-glsl}                  | {{c}}{:.highlight.language-glsl}                  |
| `go`                    | {{a}}{:.highlight.language-go}                    | {{b}}{:.highlight.language-go}                    | {{c}}{:.highlight.language-go}                    |
| `gradle`                | {{a}}{:.highlight.language-gradle}                | {{b}}{:.highlight.language-gradle}                | {{c}}{:.highlight.language-gradle}                |
| `graphql`               | {{a}}{:.highlight.language-graphql}               | {{b}}{:.highlight.language-graphql}               | {{c}}{:.highlight.language-graphql}               |
| `groovy`                | {{a}}{:.highlight.language-groovy}                | {{b}}{:.highlight.language-groovy}                | {{c}}{:.highlight.language-groovy}                |
| `hack`                  | {{a}}{:.highlight.language-hack}                  | {{b}}{:.highlight.language-hack}                  | {{c}}{:.highlight.language-hack}                  |
| `haml`                  | {{a}}{:.highlight.language-haml}                  | {{b}}{:.highlight.language-haml}                  | {{c}}{:.highlight.language-haml}                  |
| `handlebars`            | {{a}}{:.highlight.language-handlebars}            | {{b}}{:.highlight.language-handlebars}            | {{c}}{:.highlight.language-handlebars}            |
| `haskell`               | {{a}}{:.highlight.language-haskell}               | {{b}}{:.highlight.language-haskell}               | {{c}}{:.highlight.language-haskell}               |
| `hcl`                   | {{a}}{:.highlight.language-hcl}                   | {{b}}{:.highlight.language-hcl}                   | {{c}}{:.highlight.language-hcl}                   |
| `html`                  | {{a}}{:.highlight.language-html}                  | {{b}}{:.highlight.language-html}                  | {{c}}{:.highlight.language-html}                  |
| `http`                  | {{a}}{:.highlight.language-http}                  | {{b}}{:.highlight.language-http}                  | {{c}}{:.highlight.language-http}                  |
| `hylang`                | {{a}}{:.highlight.language-hylang}                | {{b}}{:.highlight.language-hylang}                | {{c}}{:.highlight.language-hylang}                |
| `idlang`                | {{a}}{:.highlight.language-idlang}                | {{b}}{:.highlight.language-idlang}                | {{c}}{:.highlight.language-idlang}                |
| `igorpro`               | {{a}}{:.highlight.language-igorpro}               | {{b}}{:.highlight.language-igorpro}               | {{c}}{:.highlight.language-igorpro}               |
| `ini`                   | {{a}}{:.highlight.language-ini}                   | {{b}}{:.highlight.language-ini}                   | {{c}}{:.highlight.language-ini}                   |
| `io`                    | {{a}}{:.highlight.language-io}                    | {{b}}{:.highlight.language-io}                    | {{c}}{:.highlight.language-io}                    |
| `irb`                   | {{a}}{:.highlight.language-irb}                   | {{b}}{:.highlight.language-irb}                   | {{c}}{:.highlight.language-irb}                   |
| `java`                  | {{a}}{:.highlight.language-java}                  | {{b}}{:.highlight.language-java}                  | {{c}}{:.highlight.language-java}                  |
| `javascript`            | {{a}}{:.highlight.language-javascript}            | {{b}}{:.highlight.language-javascript}            | {{c}}{:.highlight.language-javascript}            |
| `jinja`                 | {{a}}{:.highlight.language-jinja}                 | {{b}}{:.highlight.language-jinja}                 | {{c}}{:.highlight.language-jinja}                 |
| `json`                  | {{a}}{:.highlight.language-json}                  | {{b}}{:.highlight.language-json}                  | {{c}}{:.highlight.language-json}                  |
| `json-doc`              | {{a}}{:.highlight.language-json-doc}              | {{b}}{:.highlight.language-json-doc}              | {{c}}{:.highlight.language-json-doc}              |
| `jsonnet`               | {{a}}{:.highlight.language-jsonnet}               | {{b}}{:.highlight.language-jsonnet}               | {{c}}{:.highlight.language-jsonnet}               |
| `jsp`                   | {{a}}{:.highlight.language-jsp}                   | {{b}}{:.highlight.language-jsp}                   | {{c}}{:.highlight.language-jsp}                   |
| `jsx`                   | {{a}}{:.highlight.language-jsx}                   | {{b}}{:.highlight.language-jsx}                   | {{c}}{:.highlight.language-jsx}                   |
| `julia`                 | {{a}}{:.highlight.language-julia}                 | {{b}}{:.highlight.language-julia}                 | {{c}}{:.highlight.language-julia}                 |
| `kotlin`                | {{a}}{:.highlight.language-kotlin}                | {{b}}{:.highlight.language-kotlin}                | {{c}}{:.highlight.language-kotlin}                |
| `lasso`                 | {{a}}{:.highlight.language-lasso}                 | {{b}}{:.highlight.language-lasso}                 | {{c}}{:.highlight.language-lasso}                 |
| `liquid`                | {{a}}{:.highlight.language-liquid}                | {{b}}{:.highlight.language-liquid}                | {{c}}{:.highlight.language-liquid}                |
| `literate_coffeescript` | {{a}}{:.highlight.language-literate_coffeescript} | {{b}}{:.highlight.language-literate_coffeescript} | {{c}}{:.highlight.language-literate_coffeescript} |
| `literate_haskell`      | {{a}}{:.highlight.language-literate_haskell}      | {{b}}{:.highlight.language-literate_haskell}      | {{c}}{:.highlight.language-literate_haskell}      |
| `llvm`                  | {{a}}{:.highlight.language-llvm}                  | {{b}}{:.highlight.language-llvm}                  | {{c}}{:.highlight.language-llvm}                  |
| `lua`                   | {{a}}{:.highlight.language-lua}                   | {{b}}{:.highlight.language-lua}                   | {{c}}{:.highlight.language-lua}                   |
| `m68k`                  | {{a}}{:.highlight.language-m68k}                  | {{b}}{:.highlight.language-m68k}                  | {{c}}{:.highlight.language-m68k}                  |
| `magik`                 | {{a}}{:.highlight.language-magik}                 | {{b}}{:.highlight.language-magik}                 | {{c}}{:.highlight.language-magik}                 |
| `make`                  | {{a}}{:.highlight.language-make}                  | {{b}}{:.highlight.language-make}                  | {{c}}{:.highlight.language-make}                  |
| `markdown`              | {{a}}{:.highlight.language-markdown}              | {{b}}{:.highlight.language-markdown}              | {{c}}{:.highlight.language-markdown}              |
| `mathematica`           | {{a}}{:.highlight.language-mathematica}           | {{b}}{:.highlight.language-mathematica}           | {{c}}{:.highlight.language-mathematica}           |
| `matlab`                | {{a}}{:.highlight.language-matlab}                | {{b}}{:.highlight.language-matlab}                | {{c}}{:.highlight.language-matlab}                |
| `moonscript`            | {{a}}{:.highlight.language-moonscript}            | {{b}}{:.highlight.language-moonscript}            | {{c}}{:.highlight.language-moonscript}            |
| `mosel`                 | {{a}}{:.highlight.language-mosel}                 | {{b}}{:.highlight.language-mosel}                 | {{c}}{:.highlight.language-mosel}                 |
| `mxml`                  | {{a}}{:.highlight.language-mxml}                  | {{b}}{:.highlight.language-mxml}                  | {{c}}{:.highlight.language-mxml}                  |
| `nasm`                  | {{a}}{:.highlight.language-nasm}                  | {{b}}{:.highlight.language-nasm}                  | {{c}}{:.highlight.language-nasm}                  |
| `nginx`                 | {{a}}{:.highlight.language-nginx}                 | {{b}}{:.highlight.language-nginx}                 | {{c}}{:.highlight.language-nginx}                 |
| `nim`                   | {{a}}{:.highlight.language-nim}                   | {{b}}{:.highlight.language-nim}                   | {{c}}{:.highlight.language-nim}                   |
| `nix`                   | {{a}}{:.highlight.language-nix}                   | {{b}}{:.highlight.language-nix}                   | {{c}}{:.highlight.language-nix}                   |
| `objective_c`           | {{a}}{:.highlight.language-objective_c}           | {{b}}{:.highlight.language-objective_c}           | {{c}}{:.highlight.language-objective_c}           |
| `ocaml`                 | {{a}}{:.highlight.language-ocaml}                 | {{b}}{:.highlight.language-ocaml}                 | {{c}}{:.highlight.language-ocaml}                 |
| `pascal`                | {{a}}{:.highlight.language-pascal}                | {{b}}{:.highlight.language-pascal}                | {{c}}{:.highlight.language-pascal}                |
| `perl`                  | {{a}}{:.highlight.language-perl}                  | {{b}}{:.highlight.language-perl}                  | {{c}}{:.highlight.language-perl}                  |
| `php`                   | {{a}}{:.highlight.language-php}                   | {{b}}{:.highlight.language-php}                   | {{c}}{:.highlight.language-php}                   |
| `plaintext`             | {{a}}{:.highlight.language-plaintext}             | {{b}}{:.highlight.language-plaintext}             | {{c}}{:.highlight.language-plaintext}             |
| `plist`                 | {{a}}{:.highlight.language-plist}                 | {{b}}{:.highlight.language-plist}                 | {{c}}{:.highlight.language-plist}                 |
| `powershell`            | {{a}}{:.highlight.language-powershell}            | {{b}}{:.highlight.language-powershell}            | {{c}}{:.highlight.language-powershell}            |
| `praat`                 | {{a}}{:.highlight.language-praat}                 | {{b}}{:.highlight.language-praat}                 | {{c}}{:.highlight.language-praat}                 |
| `prolog`                | {{a}}{:.highlight.language-prolog}                | {{b}}{:.highlight.language-prolog}                | {{c}}{:.highlight.language-prolog}                |
| `prometheus`            | {{a}}{:.highlight.language-prometheus}            | {{b}}{:.highlight.language-prometheus}            | {{c}}{:.highlight.language-prometheus}            |
| `properties`            | {{a}}{:.highlight.language-properties}            | {{b}}{:.highlight.language-properties}            | {{c}}{:.highlight.language-properties}            |
| `protobuf`              | {{a}}{:.highlight.language-protobuf}              | {{b}}{:.highlight.language-protobuf}              | {{c}}{:.highlight.language-protobuf}              |
| `puppet`                | {{a}}{:.highlight.language-puppet}                | {{b}}{:.highlight.language-puppet}                | {{c}}{:.highlight.language-puppet}                |
| `python`                | {{a}}{:.highlight.language-python}                | {{b}}{:.highlight.language-python}                | {{c}}{:.highlight.language-python}                |
| `q`                     | {{a}}{:.highlight.language-q}                     | {{b}}{:.highlight.language-q}                     | {{c}}{:.highlight.language-q}                     |
| `qml`                   | {{a}}{:.highlight.language-qml}                   | {{b}}{:.highlight.language-qml}                   | {{c}}{:.highlight.language-qml}                   |
| `r`                     | {{a}}{:.highlight.language-r}                     | {{b}}{:.highlight.language-r}                     | {{c}}{:.highlight.language-r}                     |
| `racket`                | {{a}}{:.highlight.language-racket}                | {{b}}{:.highlight.language-racket}                | {{c}}{:.highlight.language-racket}                |
| `ruby`                  | {{a}}{:.highlight.language-ruby}                  | {{b}}{:.highlight.language-ruby}                  | {{c}}{:.highlight.language-ruby}                  |
| `rust`                  | {{a}}{:.highlight.language-rust}                  | {{b}}{:.highlight.language-rust}                  | {{c}}{:.highlight.language-rust}                  |
| `sass`                  | {{a}}{:.highlight.language-sass}                  | {{b}}{:.highlight.language-sass}                  | {{c}}{:.highlight.language-sass}                  |
| `scala`                 | {{a}}{:.highlight.language-scala}                 | {{b}}{:.highlight.language-scala}                 | {{c}}{:.highlight.language-scala}                 |
| `scheme`                | {{a}}{:.highlight.language-scheme}                | {{b}}{:.highlight.language-scheme}                | {{c}}{:.highlight.language-scheme}                |
| `scss`                  | {{a}}{:.highlight.language-scss}                  | {{b}}{:.highlight.language-scss}                  | {{c}}{:.highlight.language-scss}                  |
| `sed`                   | {{a}}{:.highlight.language-sed}                   | {{b}}{:.highlight.language-sed}                   | {{c}}{:.highlight.language-sed}                   |
| `shell`                 | {{a}}{:.highlight.language-shell}                 | {{b}}{:.highlight.language-shell}                 | {{c}}{:.highlight.language-shell}                 |
| `sieve`                 | {{a}}{:.highlight.language-sieve}                 | {{b}}{:.highlight.language-sieve}                 | {{c}}{:.highlight.language-sieve}                 |
| `slim`                  | {{a}}{:.highlight.language-slim}                  | {{b}}{:.highlight.language-slim}                  | {{c}}{:.highlight.language-slim}                  |
| `smalltalk`             | {{a}}{:.highlight.language-smalltalk}             | {{b}}{:.highlight.language-smalltalk}             | {{c}}{:.highlight.language-smalltalk}             |
| `smarty`                | {{a}}{:.highlight.language-smarty}                | {{b}}{:.highlight.language-smarty}                | {{c}}{:.highlight.language-smarty}                |
| `sml`                   | {{a}}{:.highlight.language-sml}                   | {{b}}{:.highlight.language-sml}                   | {{c}}{:.highlight.language-sml}                   |
| `sqf`                   | {{a}}{:.highlight.language-sqf}                   | {{b}}{:.highlight.language-sqf}                   | {{c}}{:.highlight.language-sqf}                   |
| `sql`                   | {{a}}{:.highlight.language-sql}                   | {{b}}{:.highlight.language-sql}                   | {{c}}{:.highlight.language-sql}                   |
| `supercollider`         | {{a}}{:.highlight.language-supercollider}         | {{b}}{:.highlight.language-supercollider}         | {{c}}{:.highlight.language-supercollider}         |
| `swift`                 | {{a}}{:.highlight.language-swift}                 | {{b}}{:.highlight.language-swift}                 | {{c}}{:.highlight.language-swift}                 |
| `tap`                   | {{a}}{:.highlight.language-tap}                   | {{b}}{:.highlight.language-tap}                   | {{c}}{:.highlight.language-tap}                   |
| `tcl`                   | {{a}}{:.highlight.language-tcl}                   | {{b}}{:.highlight.language-tcl}                   | {{c}}{:.highlight.language-tcl}                   |
| `terraform`             | {{a}}{:.highlight.language-terraform}             | {{b}}{:.highlight.language-terraform}             | {{c}}{:.highlight.language-terraform}             |
| `tex`                   | {{a}}{:.highlight.language-tex}                   | {{b}}{:.highlight.language-tex}                   | {{c}}{:.highlight.language-tex}                   |
| `toml`                  | {{a}}{:.highlight.language-toml}                  | {{b}}{:.highlight.language-toml}                  | {{c}}{:.highlight.language-toml}                  |
| `tsx`                   | {{a}}{:.highlight.language-tsx}                   | {{b}}{:.highlight.language-tsx}                   | {{c}}{:.highlight.language-tsx}                   |
| `tulip`                 | {{a}}{:.highlight.language-tulip}                 | {{b}}{:.highlight.language-tulip}                 | {{c}}{:.highlight.language-tulip}                 |
| `turtle`                | {{a}}{:.highlight.language-turtle}                | {{b}}{:.highlight.language-turtle}                | {{c}}{:.highlight.language-turtle}                |
| `twig`                  | {{a}}{:.highlight.language-twig}                  | {{b}}{:.highlight.language-twig}                  | {{c}}{:.highlight.language-twig}                  |
| `typescript`            | {{a}}{:.highlight.language-typescript}            | {{b}}{:.highlight.language-typescript}            | {{c}}{:.highlight.language-typescript}            |
| `vala`                  | {{a}}{:.highlight.language-vala}                  | {{b}}{:.highlight.language-vala}                  | {{c}}{:.highlight.language-vala}                  |
| `vb`                    | {{a}}{:.highlight.language-vb}                    | {{b}}{:.highlight.language-vb}                    | {{c}}{:.highlight.language-vb}                    |
| `verilog`               | {{a}}{:.highlight.language-verilog}               | {{b}}{:.highlight.language-verilog}               | {{c}}{:.highlight.language-verilog}               |
| `vhdl`                  | {{a}}{:.highlight.language-vhdl}                  | {{b}}{:.highlight.language-vhdl}                  | {{c}}{:.highlight.language-vhdl}                  |
| `viml`                  | {{a}}{:.highlight.language-viml}                  | {{b}}{:.highlight.language-viml}                  | {{c}}{:.highlight.language-viml}                  |
| `vue`                   | {{a}}{:.highlight.language-vue}                   | {{b}}{:.highlight.language-vue}                   | {{c}}{:.highlight.language-vue}                   |
| `wollok`                | {{a}}{:.highlight.language-wollok}                | {{b}}{:.highlight.language-wollok}                | {{c}}{:.highlight.language-wollok}                |
| `xml`                   | {{a}}{:.highlight.language-xml}                   | {{b}}{:.highlight.language-xml}                   | {{c}}{:.highlight.language-xml}                   |
| `xojo`                  | {{a}}{:.highlight.language-xojo}                  | {{b}}{:.highlight.language-xojo}                  | {{c}}{:.highlight.language-xojo}                  |
| `yaml`                  | {{a}}{:.highlight.language-yaml}                  | {{b}}{:.highlight.language-yaml}                  | {{c}}{:.highlight.language-yaml}                  |

</div>
