# Contributing

Contributions are **welcome** and will be fully **credited**.

We accept contributions via Pull Requests on [Github](https://github.com/apertureless/vue-observable).


## Pull Requests

- **Keep the same style** - eslint will automatically be ran before committing

- **Tip** to pass lint tests easier use the `npm run lint:fix` command

- **Add tests!** - Your patch won't be accepted if it doesn't have tests.

- **Document any change in behaviour** - Make sure the `README.md` and any other relevant documentation are kept up-to-date.

- **Consider our release cycle** - We try to follow [SemVer v2.0.0](http://semver.org/). Randomly breaking public APIs is not an option.

- **Create feature branches** - Don't ask us to pull from your master branch.

- **One pull request per feature** - If you want to do more than one thing, send multiple pull requests.

- **Send coherent history** - Make sure your commits message means something


## Running Tests

Launch visual tests and watch the components at the same time

``` bash
$ npm run dev
```


**Happy coding**!
