---
title: Dependencies for Submarine
---

<!--
Licensed to the Apache Software Foundation (ASF) under one
or more contributor license agreements.  See the NOTICE file
distributed with this work for additional information
regarding copyright ownership.  The ASF licenses this file
to you under the Apache License, Version 2.0 (the
"License"); you may not use this file except in compliance
with the License.  You may obtain a copy of the License at

  http://www.apache.org/licenses/LICENSE-2.0

Unless required by applicable law or agreed to in writing,
software distributed under the License is distributed on an
"AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY
KIND, either express or implied.  See the License for the
specific language governing permissions and limitations
under the License.
-->

- These are the dependencies currently used by Apache Submarine.

## Kubernetes

| Kubernetes Version  |    Support?    |
| ------------------- | :------------: |
| 1.18.x (or earlier) |       X        |
| 1.19.x - 1.21.x     |   Not tested   |
| 1.22.x - 1.25.x     |       √        |
| 1.26.x (or later)   | To be verified |

## KinD

| KinD Version       | Support? |
| ------------------ | :------: |
| 0.5.x (or earlier) |    X     |
| 0.6.x - 0.17.x     |    √     |

## Java

| JDK Version |    Support?    |
| ----------- | :------------: |
| 8           |       X        |
| 11          |       √        |
| 17          | To be verified |

## Maven

- 3.3 or later ( < 3.8.1 )

## Docker

- Latest

## Helm

- Version 3

## NodeJS

- 14 (or later)

## Go

| Go Version      | Support? |
| --------------- | :------: |
| 1.15            |    X     |
| 1.16            |    √     |
| 1.17            |    √     |
| 1.18 (or later) |    X     |

## Python

| Python Version   | Support? |
| ---------------- | :------: |
| 3.6 (or earlier) |    X     |
| 3.7              |    √     |
| 3.8              |    √     |
| 3.9              |    √     |
| 3.10             |    √     |
