---
title: How to vote a Committer or PMC
---

<!--
   Licensed to the Apache Software Foundation (ASF) under one or more
   contributor license agreements.  See the NOTICE file distributed with
   this work for additional information regarding copyright ownership.
   The ASF licenses this file to You under the Apache License, Version 2.0
   (the "License"); you may not use this file except in compliance with
   the License.  You may obtain a copy of the License at
   http://www.apache.org/licenses/LICENSE-2.0
   Unless required by applicable law or agreed to in writing, software
   distributed under the License is distributed on an "AS IS" BASIS,
   WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
   See the License for the specific language governing permissions and
   limitations under the License.
-->

### The voting process of becoming a Submarine Committer or PMC

1. After the PMC members of Submarine discover any valuable contributions from the community contributors and obtain the consent of the candidate, they initiate a discussion on the private mailing list of Submarine:

   > [DISCUSS] YYYYY as a Submarine XXXXXX

   In the email, the source of the candidate’s contributions should be clearly stated, so that everyone can discuss and analyze. The discussion email will last at least 72 hours, and the project team members, including the mentors, will fully express their views on the proposed email.

2. Regardless of whether there is a disagreement, after the discussion email, the vote initiator needs to initiate a Committer or PMC vote on the private mailing list of Submarine;

   > [VOTE] YYYYY as a Submarine XXXXXX

   The voting mail should last for at least 72 hours, and there should be at least 3 +1 votes to pass the vote. If there are 0 votes or one -1 vote, the entire vote will fail. If voting -1, you need to clarify the question so that everyone can understand.

3. After the voting email is over, the vote initiator should summarize it on the voting line, remind the end of voting, and send it to the voting summary email.

   > [RESULTS][vote] YYYYY as a Submarine XXXXXX

4. After the vote summary email is sent, if the vote passed, the vote initiator must send an invitation email to the candidate, and the invitation email needs the candidate to reply to accept or decline through the designated mailbox.

   > [Invitation] Invitation to join Apache Submarine as a XXXXXX

   The email should be sent to the candidate, and the copy is sent to private@submarine.apache.org

5. After the candidate accepts the invitation, if the candidate does not have an apache email account, the vote initiator needs to assist the candidate to create an apache account according to the guidelines.

6. If the above content is completed, the vote initiator still needs to do the following two things:

   6.1 Apply to the project leader to add project team members, and open the authority accounts for the jira and apache projects.

   6.2 Send a notification email to the dev@submarine.apache.org mail group:

   > [ANNOUNCE] New XXXXXX: YYYYY

So far, the entire process is completed, then the candidate officially becomes the Committer or PMC of Submarine.
