---
title: How to become a Committer
---

<!--
   Licensed to the Apache Software Foundation (ASF) under one or more
   contributor license agreements.  See the NOTICE file distributed with
   this work for additional information regarding copyright ownership.
   The ASF licenses this file to You under the Apache License, Version 2.0
   (the "License"); you may not use this file except in compliance with
   the License.  You may obtain a copy of the License at
   http://www.apache.org/licenses/LICENSE-2.0
   Unless required by applicable law or agreed to in writing, software
   distributed under the License is distributed on an "AS IS" BASIS,
   WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
   See the License for the specific language governing permissions and
   limitations under the License.
-->

Apache Submarine builds a community completely following Apache’s rules. Apache Committer is a term used in ASF (Apache Software Foundation) to indicate the person who submits a specific project. Apache Submarine Committer has permission to write the Submarine codebase and can merge PR. Anyone who has made enough contributions to the community and gained enough trust can become an Apache Submarine Committer.

As long as anyone contributes to the Submarine project, you are the officially recognized Contributor of the Submarine project. There is no exact standard for growing from Contributor to Committer, and there is no expected timetable, but Committer candidates are generally long-term active contributors, becoming Committer does not require a huge architectural improvement contribution, or how many lines of code contribution. Contributing to the codebase, contributing to the documents, participating in the discussion of the mailing list, helping to answer questions, etc., are all ways to increase your influence.

List of potential contributions (in no particular order):

- Submit the bugs, features, and improvements you found to the issue
- Update the official documents so that the project documents are the most recent, the best practices for writing Submarine, and various useful documents for users to analyze the features.
- Perform test and report test results.
- Actively participate in voting when the version is released
- Participate in the discussion on the mailing list, usually there will be mails starting with [DISCUSS]
- Answer questions from users or developers on the mailing list
- Review the work of others (both code and non-code) and publish your own suggestions
- Review the issues on JIRA and maintain the latest status of the issues, such as closing outdated issues, changing the issue’s error information, etc.
- Guide new contributors and be familiar with the community process
- Give speeches and blogs about Submarine, and add these to the official website of Submarine
- Any contribution that is beneficial to the development of the Submarine community
  ......

More can refer to: [ASF official documents](https://community.apache.org/contributors/)

Not everyone can complete all (or even any) items on this list. If you want to contribute in other ways, then just do it (and add them to the list). Pleasant manners and dedication are all you need to have a positive impact on the Submarine project. Inviting you to become Committer is the result of your long-term and stable interaction with the community, and the trust and recognition of the Submarine community.

Committer is obliged to review and merge PRs submitted by others, test and vote on candidate versions when the version is released, participate in the discussion of feature design plans, and other types of project contributions. When you are active enough and make a bigger contribution to the community, you can be promoted to a PMC member of the Submarine project.
