/*!
 * Licensed to the Apache Software Foundation (ASF) under one
 * or more contributor license agreements.  See the NOTICE file
 * distributed with this work for additional information
 * regarding copyright ownership.  The ASF licenses this file
 * to you under the Apache License, Version 2.0 (the
 * "License"); you may not use this file except in compliance
 * with the License.  You may obtain a copy of the License at
 *
 *   http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing,
 * software distributed under the License is distributed on an
 * "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY
 * KIND, either express or implied.  See the License for the
 * specific language governing permissions and limitations
 * under the License.
 */
// tslint:disable
/**
 * Submarine API
 * The Submarine REST API allows you to access Submarine resources such as,  experiments, environments and notebooks. The  API is hosted under the /v1 path on the Submarine server. For example,  to list experiments on a server hosted at http://localhost:8080, access http://localhost:8080/api/v1/experiment/
 *
 * The version of the OpenAPI document: 0.8.0-SNAPSHOT
 * Contact: dev@submarine.apache.org
 *
 * NOTE: This class is auto generated by OpenAPI Generator (https://openapi-generator.tech).
 * https://openapi-generator.tech
 * Do not edit the class manually.
 */

import * as globalImportUrl from "url";
import { Configuration } from "./configuration";
import globalAxios, { AxiosPromise, AxiosInstance } from "axios";
// Some imports not used depending on template conditions
// @ts-ignore
import { BASE_PATH, COLLECTION_FORMATS, RequestArgs, BaseAPI, RequiredError } from "./base";

/**
 *
 * @export
 * @interface CodeSpec
 */
export interface CodeSpec {
  /**
   *
   * @type {string}
   * @memberof CodeSpec
   */
  syncMode?: string;
  /**
   *
   * @type {string}
   * @memberof CodeSpec
   */
  url?: string;
}
/**
 *
 * @export
 * @interface EnvironmentSpec
 */
export interface EnvironmentSpec {
  /**
   *
   * @type {string}
   * @memberof EnvironmentSpec
   */
  name?: string;
  /**
   *
   * @type {string}
   * @memberof EnvironmentSpec
   */
  dockerImage?: string;
  /**
   *
   * @type {KernelSpec}
   * @memberof EnvironmentSpec
   */
  kernelSpec?: KernelSpec;
  /**
   *
   * @type {string}
   * @memberof EnvironmentSpec
   */
  description?: string;
  /**
   *
   * @type {string}
   * @memberof EnvironmentSpec
   */
  image?: string;
}
/**
 *
 * @export
 * @interface ExperimentMeta
 */
export interface ExperimentMeta {
  /**
   *
   * @type {string}
   * @memberof ExperimentMeta
   */
  experimentId?: string;
  /**
   *
   * @type {string}
   * @memberof ExperimentMeta
   */
  name?: string;
  /**
   *
   * @type {string}
   * @memberof ExperimentMeta
   */
  namespace?: string;
  /**
   *
   * @type {string}
   * @memberof ExperimentMeta
   */
  framework?: string;
  /**
   *
   * @type {string}
   * @memberof ExperimentMeta
   */
  cmd?: string;
  /**
   *
   * @type {{ [key: string]: string; }}
   * @memberof ExperimentMeta
   */
  envVars?: { [key: string]: string };
  /**
   *
   * @type {Array<string>}
   * @memberof ExperimentMeta
   */
  tags?: Array<string>;
}
/**
 *
 * @export
 * @interface ExperimentSpec
 */
export interface ExperimentSpec {
  /**
   *
   * @type {ExperimentMeta}
   * @memberof ExperimentSpec
   */
  meta?: ExperimentMeta;
  /**
   *
   * @type {EnvironmentSpec}
   * @memberof ExperimentSpec
   */
  environment?: EnvironmentSpec;
  /**
   *
   * @type {{ [key: string]: ExperimentTaskSpec; }}
   * @memberof ExperimentSpec
   */
  spec?: { [key: string]: ExperimentTaskSpec };
  /**
   *
   * @type {CodeSpec}
   * @memberof ExperimentSpec
   */
  code?: CodeSpec;
}
/**
 *
 * @export
 * @interface ExperimentTaskSpec
 */
export interface ExperimentTaskSpec {
  /**
   *
   * @type {number}
   * @memberof ExperimentTaskSpec
   */
  replicas?: number;
  /**
   *
   * @type {string}
   * @memberof ExperimentTaskSpec
   */
  resources?: string;
  /**
   *
   * @type {string}
   * @memberof ExperimentTaskSpec
   */
  name?: string;
  /**
   *
   * @type {string}
   * @memberof ExperimentTaskSpec
   */
  image?: string;
  /**
   *
   * @type {string}
   * @memberof ExperimentTaskSpec
   */
  cmd?: string;
  /**
   *
   * @type {{ [key: string]: string; }}
   * @memberof ExperimentTaskSpec
   */
  envVars?: { [key: string]: string };
  /**
   *
   * @type {string}
   * @memberof ExperimentTaskSpec
   */
  gpu?: string;
  /**
   *
   * @type {string}
   * @memberof ExperimentTaskSpec
   */
  memory?: string;
  /**
   *
   * @type {string}
   * @memberof ExperimentTaskSpec
   */
  cpu?: string;
}
/**
 *
 * @export
 * @interface ExperimentTemplateParamSpec
 */
export interface ExperimentTemplateParamSpec {
  /**
   *
   * @type {string}
   * @memberof ExperimentTemplateParamSpec
   */
  name?: string;
  /**
   *
   * @type {string}
   * @memberof ExperimentTemplateParamSpec
   */
  required?: string;
  /**
   *
   * @type {string}
   * @memberof ExperimentTemplateParamSpec
   */
  description?: string;
  /**
   *
   * @type {string}
   * @memberof ExperimentTemplateParamSpec
   */
  value?: string;
}
/**
 *
 * @export
 * @interface ExperimentTemplateSpec
 */
export interface ExperimentTemplateSpec {
  /**
   *
   * @type {string}
   * @memberof ExperimentTemplateSpec
   */
  name?: string;
  /**
   *
   * @type {string}
   * @memberof ExperimentTemplateSpec
   */
  author?: string;
  /**
   *
   * @type {string}
   * @memberof ExperimentTemplateSpec
   */
  description?: string;
  /**
   *
   * @type {Array<ExperimentTemplateParamSpec>}
   * @memberof ExperimentTemplateSpec
   */
  parameters?: Array<ExperimentTemplateParamSpec>;
  /**
   *
   * @type {ExperimentSpec}
   * @memberof ExperimentTemplateSpec
   */
  experimentSpec?: ExperimentSpec;
  /**
   *
   * @type {Array<ExperimentTemplateParamSpec>}
   * @memberof ExperimentTemplateSpec
   */
  experimentTemplateParamSpec?: Array<ExperimentTemplateParamSpec>;
}
/**
 *
 * @export
 * @interface ExperimentTemplateSubmit
 */
export interface ExperimentTemplateSubmit {
  /**
   *
   * @type {string}
   * @memberof ExperimentTemplateSubmit
   */
  name?: string;
  /**
   *
   * @type {{ [key: string]: string; }}
   * @memberof ExperimentTemplateSubmit
   */
  params?: { [key: string]: string };
}
/**
 *
 * @export
 * @interface JsonResponse
 */
export interface JsonResponse {
  /**
   *
   * @type {number}
   * @memberof JsonResponse
   */
  code?: number;
  /**
   *
   * @type {boolean}
   * @memberof JsonResponse
   */
  success?: boolean;
  /**
   *
   * @type {object}
   * @memberof JsonResponse
   */
  result?: object;
  /**
   *
   * @type {{ [key: string]: object; }}
   * @memberof JsonResponse
   */
  attributes?: { [key: string]: object };
}
/**
 *
 * @export
 * @interface KernelSpec
 */
export interface KernelSpec {
  /**
   *
   * @type {string}
   * @memberof KernelSpec
   */
  name?: string;
  /**
   *
   * @type {Array<string>}
   * @memberof KernelSpec
   */
  channels?: Array<string>;
  /**
   *
   * @type {Array<string>}
   * @memberof KernelSpec
   */
  condaDependencies?: Array<string>;
  /**
   *
   * @type {Array<string>}
   * @memberof KernelSpec
   */
  pipDependencies?: Array<string>;
}
/**
 *
 * @export
 * @interface ModelVersionEntity
 */
export interface ModelVersionEntity {
  /**
   *
   * @type {string}
   * @memberof ModelVersionEntity
   */
  name?: string;
  /**
   *
   * @type {number}
   * @memberof ModelVersionEntity
   */
  version?: number;
  /**
   *
   * @type {string}
   * @memberof ModelVersionEntity
   */
  id?: string;
  /**
   *
   * @type {string}
   * @memberof ModelVersionEntity
   */
  userId?: string;
  /**
   *
   * @type {string}
   * @memberof ModelVersionEntity
   */
  experimentId?: string;
  /**
   *
   * @type {string}
   * @memberof ModelVersionEntity
   */
  modelType?: string;
  /**
   *
   * @type {string}
   * @memberof ModelVersionEntity
   */
  currentStage?: string;
  /**
   *
   * @type {string}
   * @memberof ModelVersionEntity
   */
  creationTime?: string;
  /**
   *
   * @type {string}
   * @memberof ModelVersionEntity
   */
  lastUpdatedTime?: string;
  /**
   *
   * @type {string}
   * @memberof ModelVersionEntity
   */
  dataset?: string;
  /**
   *
   * @type {string}
   * @memberof ModelVersionEntity
   */
  description?: string;
  /**
   *
   * @type {Array<string>}
   * @memberof ModelVersionEntity
   */
  tags?: Array<string>;
}
/**
 *
 * @export
 * @interface NotebookMeta
 */
export interface NotebookMeta {
  /**
   *
   * @type {string}
   * @memberof NotebookMeta
   */
  name?: string;
  /**
   *
   * @type {string}
   * @memberof NotebookMeta
   */
  namespace?: string;
  /**
   *
   * @type {string}
   * @memberof NotebookMeta
   */
  ownerId?: string;
  /**
   *
   * @type {{ [key: string]: string; }}
   * @memberof NotebookMeta
   */
  labels?: { [key: string]: string };
}
/**
 *
 * @export
 * @interface NotebookPodSpec
 */
export interface NotebookPodSpec {
  /**
   *
   * @type {{ [key: string]: string; }}
   * @memberof NotebookPodSpec
   */
  envVars?: { [key: string]: string };
  /**
   *
   * @type {string}
   * @memberof NotebookPodSpec
   */
  resources?: string;
  /**
   *
   * @type {string}
   * @memberof NotebookPodSpec
   */
  gpu?: string;
  /**
   *
   * @type {string}
   * @memberof NotebookPodSpec
   */
  memory?: string;
  /**
   *
   * @type {string}
   * @memberof NotebookPodSpec
   */
  cpu?: string;
}
/**
 *
 * @export
 * @interface NotebookSpec
 */
export interface NotebookSpec {
  /**
   *
   * @type {NotebookMeta}
   * @memberof NotebookSpec
   */
  meta?: NotebookMeta;
  /**
   *
   * @type {EnvironmentSpec}
   * @memberof NotebookSpec
   */
  environment?: EnvironmentSpec;
  /**
   *
   * @type {NotebookPodSpec}
   * @memberof NotebookSpec
   */
  spec?: NotebookPodSpec;
}
/**
 *
 * @export
 * @interface RegisteredModelEntity
 */
export interface RegisteredModelEntity {
  /**
   *
   * @type {string}
   * @memberof RegisteredModelEntity
   */
  name?: string;
  /**
   *
   * @type {string}
   * @memberof RegisteredModelEntity
   */
  creationTime?: string;
  /**
   *
   * @type {string}
   * @memberof RegisteredModelEntity
   */
  lastUpdatedTime?: string;
  /**
   *
   * @type {string}
   * @memberof RegisteredModelEntity
   */
  description?: string;
  /**
   *
   * @type {Array<string>}
   * @memberof RegisteredModelEntity
   */
  tags?: Array<string>;
}
/**
 *
 * @export
 * @interface ServeSpec
 */
export interface ServeSpec {
  /**
   *
   * @type {string}
   * @memberof ServeSpec
   */
  modelName?: string;
  /**
   *
   * @type {number}
   * @memberof ServeSpec
   */
  modelVersion?: number;
  /**
   *
   * @type {string}
   * @memberof ServeSpec
   */
  modelId?: string;
  /**
   *
   * @type {string}
   * @memberof ServeSpec
   */
  modelType?: string;
  /**
   *
   * @type {string}
   * @memberof ServeSpec
   */
  modelURI?: string;
}

/**
 * EnvironmentApi - axios parameter creator
 * @export
 */
export const EnvironmentApiAxiosParamCreator = function (configuration?: Configuration) {
  return {
    /**
     *
     * @summary Create a environment
     * @param {EnvironmentSpec} [environmentSpec]
     * @param {*} [options] Override http request option.
     * @throws {RequiredError}
     */
    createEnvironment: async (environmentSpec?: EnvironmentSpec, options: any = {}): Promise<RequestArgs> => {
      const localVarPath = `/v1/environment`;
      const localVarUrlObj = globalImportUrl.parse(localVarPath, true);
      let baseOptions;
      if (configuration) {
        baseOptions = configuration.baseOptions;
      }
      const localVarRequestOptions = { method: "POST", ...baseOptions, ...options };
      const localVarHeaderParameter = {} as any;
      const localVarQueryParameter = {} as any;

      localVarHeaderParameter["Content-Type"] = "application/yaml";

      localVarUrlObj.query = { ...localVarUrlObj.query, ...localVarQueryParameter, ...options.query };
      // fix override query string Detail: https://stackoverflow.com/a/7517673/1077943
      delete localVarUrlObj.search;
      let headersFromBaseOptions = baseOptions && baseOptions.headers ? baseOptions.headers : {};
      localVarRequestOptions.headers = { ...localVarHeaderParameter, ...headersFromBaseOptions, ...options.headers };
      const needsSerialization =
        typeof environmentSpec !== "string" || localVarRequestOptions.headers["Content-Type"] === "application/json";
      localVarRequestOptions.data = needsSerialization
        ? JSON.stringify(environmentSpec !== undefined ? environmentSpec : {})
        : environmentSpec || "";

      return {
        url: globalImportUrl.format(localVarUrlObj),
        options: localVarRequestOptions,
      };
    },
    /**
     *
     * @summary Delete the environment
     * @param {string} id
     * @param {*} [options] Override http request option.
     * @throws {RequiredError}
     */
    deleteEnvironment: async (id: string, options: any = {}): Promise<RequestArgs> => {
      // verify required parameter 'id' is not null or undefined
      if (id === null || id === undefined) {
        throw new RequiredError("id", "Required parameter id was null or undefined when calling deleteEnvironment.");
      }
      const localVarPath = `/v1/environment/{id}`.replace(`{${"id"}}`, encodeURIComponent(String(id)));
      const localVarUrlObj = globalImportUrl.parse(localVarPath, true);
      let baseOptions;
      if (configuration) {
        baseOptions = configuration.baseOptions;
      }
      const localVarRequestOptions = { method: "DELETE", ...baseOptions, ...options };
      const localVarHeaderParameter = {} as any;
      const localVarQueryParameter = {} as any;

      localVarUrlObj.query = { ...localVarUrlObj.query, ...localVarQueryParameter, ...options.query };
      // fix override query string Detail: https://stackoverflow.com/a/7517673/1077943
      delete localVarUrlObj.search;
      let headersFromBaseOptions = baseOptions && baseOptions.headers ? baseOptions.headers : {};
      localVarRequestOptions.headers = { ...localVarHeaderParameter, ...headersFromBaseOptions, ...options.headers };

      return {
        url: globalImportUrl.format(localVarUrlObj),
        options: localVarRequestOptions,
      };
    },
    /**
     *
     * @summary Find environment by name
     * @param {string} id
     * @param {*} [options] Override http request option.
     * @throws {RequiredError}
     */
    getEnvironment: async (id: string, options: any = {}): Promise<RequestArgs> => {
      // verify required parameter 'id' is not null or undefined
      if (id === null || id === undefined) {
        throw new RequiredError("id", "Required parameter id was null or undefined when calling getEnvironment.");
      }
      const localVarPath = `/v1/environment/{id}`.replace(`{${"id"}}`, encodeURIComponent(String(id)));
      const localVarUrlObj = globalImportUrl.parse(localVarPath, true);
      let baseOptions;
      if (configuration) {
        baseOptions = configuration.baseOptions;
      }
      const localVarRequestOptions = { method: "GET", ...baseOptions, ...options };
      const localVarHeaderParameter = {} as any;
      const localVarQueryParameter = {} as any;

      localVarUrlObj.query = { ...localVarUrlObj.query, ...localVarQueryParameter, ...options.query };
      // fix override query string Detail: https://stackoverflow.com/a/7517673/1077943
      delete localVarUrlObj.search;
      let headersFromBaseOptions = baseOptions && baseOptions.headers ? baseOptions.headers : {};
      localVarRequestOptions.headers = { ...localVarHeaderParameter, ...headersFromBaseOptions, ...options.headers };

      return {
        url: globalImportUrl.format(localVarUrlObj),
        options: localVarRequestOptions,
      };
    },
    /**
     *
     * @summary List of Environments
     * @param {string} [status]
     * @param {*} [options] Override http request option.
     * @throws {RequiredError}
     */
    listEnvironment: async (status?: string, options: any = {}): Promise<RequestArgs> => {
      const localVarPath = `/v1/environment`;
      const localVarUrlObj = globalImportUrl.parse(localVarPath, true);
      let baseOptions;
      if (configuration) {
        baseOptions = configuration.baseOptions;
      }
      const localVarRequestOptions = { method: "GET", ...baseOptions, ...options };
      const localVarHeaderParameter = {} as any;
      const localVarQueryParameter = {} as any;

      if (status !== undefined) {
        localVarQueryParameter["status"] = status;
      }

      localVarUrlObj.query = { ...localVarUrlObj.query, ...localVarQueryParameter, ...options.query };
      // fix override query string Detail: https://stackoverflow.com/a/7517673/1077943
      delete localVarUrlObj.search;
      let headersFromBaseOptions = baseOptions && baseOptions.headers ? baseOptions.headers : {};
      localVarRequestOptions.headers = { ...localVarHeaderParameter, ...headersFromBaseOptions, ...options.headers };

      return {
        url: globalImportUrl.format(localVarUrlObj),
        options: localVarRequestOptions,
      };
    },
    /**
     *
     * @summary Update the environment with job spec
     * @param {string} id
     * @param {EnvironmentSpec} [environmentSpec]
     * @param {*} [options] Override http request option.
     * @throws {RequiredError}
     */
    updateEnvironment: async (
      id: string,
      environmentSpec?: EnvironmentSpec,
      options: any = {}
    ): Promise<RequestArgs> => {
      // verify required parameter 'id' is not null or undefined
      if (id === null || id === undefined) {
        throw new RequiredError("id", "Required parameter id was null or undefined when calling updateEnvironment.");
      }
      const localVarPath = `/v1/environment/{id}`.replace(`{${"id"}}`, encodeURIComponent(String(id)));
      const localVarUrlObj = globalImportUrl.parse(localVarPath, true);
      let baseOptions;
      if (configuration) {
        baseOptions = configuration.baseOptions;
      }
      const localVarRequestOptions = { method: "PATCH", ...baseOptions, ...options };
      const localVarHeaderParameter = {} as any;
      const localVarQueryParameter = {} as any;

      localVarHeaderParameter["Content-Type"] = "application/yaml";

      localVarUrlObj.query = { ...localVarUrlObj.query, ...localVarQueryParameter, ...options.query };
      // fix override query string Detail: https://stackoverflow.com/a/7517673/1077943
      delete localVarUrlObj.search;
      let headersFromBaseOptions = baseOptions && baseOptions.headers ? baseOptions.headers : {};
      localVarRequestOptions.headers = { ...localVarHeaderParameter, ...headersFromBaseOptions, ...options.headers };
      const needsSerialization =
        typeof environmentSpec !== "string" || localVarRequestOptions.headers["Content-Type"] === "application/json";
      localVarRequestOptions.data = needsSerialization
        ? JSON.stringify(environmentSpec !== undefined ? environmentSpec : {})
        : environmentSpec || "";

      return {
        url: globalImportUrl.format(localVarUrlObj),
        options: localVarRequestOptions,
      };
    },
  };
};

/**
 * EnvironmentApi - functional programming interface
 * @export
 */
export const EnvironmentApiFp = function (configuration?: Configuration) {
  return {
    /**
     *
     * @summary Create a environment
     * @param {EnvironmentSpec} [environmentSpec]
     * @param {*} [options] Override http request option.
     * @throws {RequiredError}
     */
    async createEnvironment(
      environmentSpec?: EnvironmentSpec,
      options?: any
    ): Promise<(axios?: AxiosInstance, basePath?: string) => AxiosPromise<JsonResponse>> {
      const localVarAxiosArgs = await EnvironmentApiAxiosParamCreator(configuration).createEnvironment(
        environmentSpec,
        options
      );
      return (axios: AxiosInstance = globalAxios, basePath: string = BASE_PATH) => {
        const axiosRequestArgs = { ...localVarAxiosArgs.options, url: basePath + localVarAxiosArgs.url };
        return axios.request(axiosRequestArgs);
      };
    },
    /**
     *
     * @summary Delete the environment
     * @param {string} id
     * @param {*} [options] Override http request option.
     * @throws {RequiredError}
     */
    async deleteEnvironment(
      id: string,
      options?: any
    ): Promise<(axios?: AxiosInstance, basePath?: string) => AxiosPromise<JsonResponse>> {
      const localVarAxiosArgs = await EnvironmentApiAxiosParamCreator(configuration).deleteEnvironment(id, options);
      return (axios: AxiosInstance = globalAxios, basePath: string = BASE_PATH) => {
        const axiosRequestArgs = { ...localVarAxiosArgs.options, url: basePath + localVarAxiosArgs.url };
        return axios.request(axiosRequestArgs);
      };
    },
    /**
     *
     * @summary Find environment by name
     * @param {string} id
     * @param {*} [options] Override http request option.
     * @throws {RequiredError}
     */
    async getEnvironment(
      id: string,
      options?: any
    ): Promise<(axios?: AxiosInstance, basePath?: string) => AxiosPromise<JsonResponse>> {
      const localVarAxiosArgs = await EnvironmentApiAxiosParamCreator(configuration).getEnvironment(id, options);
      return (axios: AxiosInstance = globalAxios, basePath: string = BASE_PATH) => {
        const axiosRequestArgs = { ...localVarAxiosArgs.options, url: basePath + localVarAxiosArgs.url };
        return axios.request(axiosRequestArgs);
      };
    },
    /**
     *
     * @summary List of Environments
     * @param {string} [status]
     * @param {*} [options] Override http request option.
     * @throws {RequiredError}
     */
    async listEnvironment(
      status?: string,
      options?: any
    ): Promise<(axios?: AxiosInstance, basePath?: string) => AxiosPromise<JsonResponse>> {
      const localVarAxiosArgs = await EnvironmentApiAxiosParamCreator(configuration).listEnvironment(status, options);
      return (axios: AxiosInstance = globalAxios, basePath: string = BASE_PATH) => {
        const axiosRequestArgs = { ...localVarAxiosArgs.options, url: basePath + localVarAxiosArgs.url };
        return axios.request(axiosRequestArgs);
      };
    },
    /**
     *
     * @summary Update the environment with job spec
     * @param {string} id
     * @param {EnvironmentSpec} [environmentSpec]
     * @param {*} [options] Override http request option.
     * @throws {RequiredError}
     */
    async updateEnvironment(
      id: string,
      environmentSpec?: EnvironmentSpec,
      options?: any
    ): Promise<(axios?: AxiosInstance, basePath?: string) => AxiosPromise<JsonResponse>> {
      const localVarAxiosArgs = await EnvironmentApiAxiosParamCreator(configuration).updateEnvironment(
        id,
        environmentSpec,
        options
      );
      return (axios: AxiosInstance = globalAxios, basePath: string = BASE_PATH) => {
        const axiosRequestArgs = { ...localVarAxiosArgs.options, url: basePath + localVarAxiosArgs.url };
        return axios.request(axiosRequestArgs);
      };
    },
  };
};

/**
 * EnvironmentApi - factory interface
 * @export
 */
export const EnvironmentApiFactory = function (
  configuration?: Configuration,
  basePath?: string,
  axios?: AxiosInstance
) {
  return {
    /**
     *
     * @summary Create a environment
     * @param {EnvironmentSpec} [environmentSpec]
     * @param {*} [options] Override http request option.
     * @throws {RequiredError}
     */
    createEnvironment(environmentSpec?: EnvironmentSpec, options?: any): AxiosPromise<JsonResponse> {
      return EnvironmentApiFp(configuration)
        .createEnvironment(environmentSpec, options)
        .then((request) => request(axios, basePath));
    },
    /**
     *
     * @summary Delete the environment
     * @param {string} id
     * @param {*} [options] Override http request option.
     * @throws {RequiredError}
     */
    deleteEnvironment(id: string, options?: any): AxiosPromise<JsonResponse> {
      return EnvironmentApiFp(configuration)
        .deleteEnvironment(id, options)
        .then((request) => request(axios, basePath));
    },
    /**
     *
     * @summary Find environment by name
     * @param {string} id
     * @param {*} [options] Override http request option.
     * @throws {RequiredError}
     */
    getEnvironment(id: string, options?: any): AxiosPromise<JsonResponse> {
      return EnvironmentApiFp(configuration)
        .getEnvironment(id, options)
        .then((request) => request(axios, basePath));
    },
    /**
     *
     * @summary List of Environments
     * @param {string} [status]
     * @param {*} [options] Override http request option.
     * @throws {RequiredError}
     */
    listEnvironment(status?: string, options?: any): AxiosPromise<JsonResponse> {
      return EnvironmentApiFp(configuration)
        .listEnvironment(status, options)
        .then((request) => request(axios, basePath));
    },
    /**
     *
     * @summary Update the environment with job spec
     * @param {string} id
     * @param {EnvironmentSpec} [environmentSpec]
     * @param {*} [options] Override http request option.
     * @throws {RequiredError}
     */
    updateEnvironment(id: string, environmentSpec?: EnvironmentSpec, options?: any): AxiosPromise<JsonResponse> {
      return EnvironmentApiFp(configuration)
        .updateEnvironment(id, environmentSpec, options)
        .then((request) => request(axios, basePath));
    },
  };
};

/**
 * EnvironmentApi - object-oriented interface
 * @export
 * @class EnvironmentApi
 * @extends {BaseAPI}
 */
export class EnvironmentApi extends BaseAPI {
  /**
   *
   * @summary Create a environment
   * @param {EnvironmentSpec} [environmentSpec]
   * @param {*} [options] Override http request option.
   * @throws {RequiredError}
   * @memberof EnvironmentApi
   */
  public createEnvironment(environmentSpec?: EnvironmentSpec, options?: any) {
    return EnvironmentApiFp(this.configuration)
      .createEnvironment(environmentSpec, options)
      .then((request) => request(this.axios, this.basePath));
  }

  /**
   *
   * @summary Delete the environment
   * @param {string} id
   * @param {*} [options] Override http request option.
   * @throws {RequiredError}
   * @memberof EnvironmentApi
   */
  public deleteEnvironment(id: string, options?: any) {
    return EnvironmentApiFp(this.configuration)
      .deleteEnvironment(id, options)
      .then((request) => request(this.axios, this.basePath));
  }

  /**
   *
   * @summary Find environment by name
   * @param {string} id
   * @param {*} [options] Override http request option.
   * @throws {RequiredError}
   * @memberof EnvironmentApi
   */
  public getEnvironment(id: string, options?: any) {
    return EnvironmentApiFp(this.configuration)
      .getEnvironment(id, options)
      .then((request) => request(this.axios, this.basePath));
  }

  /**
   *
   * @summary List of Environments
   * @param {string} [status]
   * @param {*} [options] Override http request option.
   * @throws {RequiredError}
   * @memberof EnvironmentApi
   */
  public listEnvironment(status?: string, options?: any) {
    return EnvironmentApiFp(this.configuration)
      .listEnvironment(status, options)
      .then((request) => request(this.axios, this.basePath));
  }

  /**
   *
   * @summary Update the environment with job spec
   * @param {string} id
   * @param {EnvironmentSpec} [environmentSpec]
   * @param {*} [options] Override http request option.
   * @throws {RequiredError}
   * @memberof EnvironmentApi
   */
  public updateEnvironment(id: string, environmentSpec?: EnvironmentSpec, options?: any) {
    return EnvironmentApiFp(this.configuration)
      .updateEnvironment(id, environmentSpec, options)
      .then((request) => request(this.axios, this.basePath));
  }
}

/**
 * ExperimentApi - axios parameter creator
 * @export
 */
export const ExperimentApiAxiosParamCreator = function (configuration?: Configuration) {
  return {
    /**
     *
     * @summary Create an experiment
     * @param {ExperimentSpec} [experimentSpec]
     * @param {*} [options] Override http request option.
     * @throws {RequiredError}
     */
    createExperiment: async (experimentSpec?: ExperimentSpec, options: any = {}): Promise<RequestArgs> => {
      const localVarPath = `/v1/experiment`;
      const localVarUrlObj = globalImportUrl.parse(localVarPath, true);
      let baseOptions;
      if (configuration) {
        baseOptions = configuration.baseOptions;
      }
      const localVarRequestOptions = { method: "POST", ...baseOptions, ...options };
      const localVarHeaderParameter = {} as any;
      const localVarQueryParameter = {} as any;

      localVarHeaderParameter["Content-Type"] = "application/yaml";

      localVarUrlObj.query = { ...localVarUrlObj.query, ...localVarQueryParameter, ...options.query };
      // fix override query string Detail: https://stackoverflow.com/a/7517673/1077943
      delete localVarUrlObj.search;
      let headersFromBaseOptions = baseOptions && baseOptions.headers ? baseOptions.headers : {};
      localVarRequestOptions.headers = { ...localVarHeaderParameter, ...headersFromBaseOptions, ...options.headers };
      const needsSerialization =
        typeof experimentSpec !== "string" || localVarRequestOptions.headers["Content-Type"] === "application/json";
      localVarRequestOptions.data = needsSerialization
        ? JSON.stringify(experimentSpec !== undefined ? experimentSpec : {})
        : experimentSpec || "";

      return {
        url: globalImportUrl.format(localVarUrlObj),
        options: localVarRequestOptions,
      };
    },
    /**
     *
     * @summary Delete the experiment
     * @param {string} id
     * @param {*} [options] Override http request option.
     * @throws {RequiredError}
     */
    deleteExperiment: async (id: string, options: any = {}): Promise<RequestArgs> => {
      // verify required parameter 'id' is not null or undefined
      if (id === null || id === undefined) {
        throw new RequiredError("id", "Required parameter id was null or undefined when calling deleteExperiment.");
      }
      const localVarPath = `/v1/experiment/{id}`.replace(`{${"id"}}`, encodeURIComponent(String(id)));
      const localVarUrlObj = globalImportUrl.parse(localVarPath, true);
      let baseOptions;
      if (configuration) {
        baseOptions = configuration.baseOptions;
      }
      const localVarRequestOptions = { method: "DELETE", ...baseOptions, ...options };
      const localVarHeaderParameter = {} as any;
      const localVarQueryParameter = {} as any;

      localVarUrlObj.query = { ...localVarUrlObj.query, ...localVarQueryParameter, ...options.query };
      // fix override query string Detail: https://stackoverflow.com/a/7517673/1077943
      delete localVarUrlObj.search;
      let headersFromBaseOptions = baseOptions && baseOptions.headers ? baseOptions.headers : {};
      localVarRequestOptions.headers = { ...localVarHeaderParameter, ...headersFromBaseOptions, ...options.headers };

      return {
        url: globalImportUrl.format(localVarUrlObj),
        options: localVarRequestOptions,
      };
    },
    /**
     *
     * @summary List artifact paths by id
     * @param {string} id
     * @param {*} [options] Override http request option.
     * @throws {RequiredError}
     */
    getArtifactPaths: async (id: string, options: any = {}): Promise<RequestArgs> => {
      // verify required parameter 'id' is not null or undefined
      if (id === null || id === undefined) {
        throw new RequiredError("id", "Required parameter id was null or undefined when calling getArtifactPaths.");
      }
      const localVarPath = `/v1/experiment/artifacts/{id}`.replace(`{${"id"}}`, encodeURIComponent(String(id)));
      const localVarUrlObj = globalImportUrl.parse(localVarPath, true);
      let baseOptions;
      if (configuration) {
        baseOptions = configuration.baseOptions;
      }
      const localVarRequestOptions = { method: "GET", ...baseOptions, ...options };
      const localVarHeaderParameter = {} as any;
      const localVarQueryParameter = {} as any;

      localVarUrlObj.query = { ...localVarUrlObj.query, ...localVarQueryParameter, ...options.query };
      // fix override query string Detail: https://stackoverflow.com/a/7517673/1077943
      delete localVarUrlObj.search;
      let headersFromBaseOptions = baseOptions && baseOptions.headers ? baseOptions.headers : {};
      localVarRequestOptions.headers = { ...localVarHeaderParameter, ...headersFromBaseOptions, ...options.headers };

      return {
        url: globalImportUrl.format(localVarUrlObj),
        options: localVarRequestOptions,
      };
    },
    /**
     *
     * @summary Get the experiment\'s detailed info by id
     * @param {string} id
     * @param {*} [options] Override http request option.
     * @throws {RequiredError}
     */
    getExperiment: async (id: string, options: any = {}): Promise<RequestArgs> => {
      // verify required parameter 'id' is not null or undefined
      if (id === null || id === undefined) {
        throw new RequiredError("id", "Required parameter id was null or undefined when calling getExperiment.");
      }
      const localVarPath = `/v1/experiment/{id}`.replace(`{${"id"}}`, encodeURIComponent(String(id)));
      const localVarUrlObj = globalImportUrl.parse(localVarPath, true);
      let baseOptions;
      if (configuration) {
        baseOptions = configuration.baseOptions;
      }
      const localVarRequestOptions = { method: "GET", ...baseOptions, ...options };
      const localVarHeaderParameter = {} as any;
      const localVarQueryParameter = {} as any;

      localVarUrlObj.query = { ...localVarUrlObj.query, ...localVarQueryParameter, ...options.query };
      // fix override query string Detail: https://stackoverflow.com/a/7517673/1077943
      delete localVarUrlObj.search;
      let headersFromBaseOptions = baseOptions && baseOptions.headers ? baseOptions.headers : {};
      localVarRequestOptions.headers = { ...localVarHeaderParameter, ...headersFromBaseOptions, ...options.headers };

      return {
        url: globalImportUrl.format(localVarUrlObj),
        options: localVarRequestOptions,
      };
    },
    /**
     *
     * @summary Log experiment by id
     * @param {string} id
     * @param {*} [options] Override http request option.
     * @throws {RequiredError}
     */
    getLog: async (id: string, options: any = {}): Promise<RequestArgs> => {
      // verify required parameter 'id' is not null or undefined
      if (id === null || id === undefined) {
        throw new RequiredError("id", "Required parameter id was null or undefined when calling getLog.");
      }
      const localVarPath = `/v1/experiment/logs/{id}`.replace(`{${"id"}}`, encodeURIComponent(String(id)));
      const localVarUrlObj = globalImportUrl.parse(localVarPath, true);
      let baseOptions;
      if (configuration) {
        baseOptions = configuration.baseOptions;
      }
      const localVarRequestOptions = { method: "GET", ...baseOptions, ...options };
      const localVarHeaderParameter = {} as any;
      const localVarQueryParameter = {} as any;

      localVarUrlObj.query = { ...localVarUrlObj.query, ...localVarQueryParameter, ...options.query };
      // fix override query string Detail: https://stackoverflow.com/a/7517673/1077943
      delete localVarUrlObj.search;
      let headersFromBaseOptions = baseOptions && baseOptions.headers ? baseOptions.headers : {};
      localVarRequestOptions.headers = { ...localVarHeaderParameter, ...headersFromBaseOptions, ...options.headers };

      return {
        url: globalImportUrl.format(localVarUrlObj),
        options: localVarRequestOptions,
      };
    },
    /**
     *
     * @summary Get mlflow\'s information
     * @param {*} [options] Override http request option.
     * @throws {RequiredError}
     */
    getMLflowInfo: async (options: any = {}): Promise<RequestArgs> => {
      const localVarPath = `/v1/experiment/mlflow`;
      const localVarUrlObj = globalImportUrl.parse(localVarPath, true);
      let baseOptions;
      if (configuration) {
        baseOptions = configuration.baseOptions;
      }
      const localVarRequestOptions = { method: "GET", ...baseOptions, ...options };
      const localVarHeaderParameter = {} as any;
      const localVarQueryParameter = {} as any;

      localVarUrlObj.query = { ...localVarUrlObj.query, ...localVarQueryParameter, ...options.query };
      // fix override query string Detail: https://stackoverflow.com/a/7517673/1077943
      delete localVarUrlObj.search;
      let headersFromBaseOptions = baseOptions && baseOptions.headers ? baseOptions.headers : {};
      localVarRequestOptions.headers = { ...localVarHeaderParameter, ...headersFromBaseOptions, ...options.headers };

      return {
        url: globalImportUrl.format(localVarUrlObj),
        options: localVarRequestOptions,
      };
    },
    /**
     *
     * @summary Get tensorboard\'s information
     * @param {*} [options] Override http request option.
     * @throws {RequiredError}
     */
    getTensorboardInfo: async (options: any = {}): Promise<RequestArgs> => {
      const localVarPath = `/v1/experiment/tensorboard`;
      const localVarUrlObj = globalImportUrl.parse(localVarPath, true);
      let baseOptions;
      if (configuration) {
        baseOptions = configuration.baseOptions;
      }
      const localVarRequestOptions = { method: "GET", ...baseOptions, ...options };
      const localVarHeaderParameter = {} as any;
      const localVarQueryParameter = {} as any;

      localVarUrlObj.query = { ...localVarUrlObj.query, ...localVarQueryParameter, ...options.query };
      // fix override query string Detail: https://stackoverflow.com/a/7517673/1077943
      delete localVarUrlObj.search;
      let headersFromBaseOptions = baseOptions && baseOptions.headers ? baseOptions.headers : {};
      localVarRequestOptions.headers = { ...localVarHeaderParameter, ...headersFromBaseOptions, ...options.headers };

      return {
        url: globalImportUrl.format(localVarUrlObj),
        options: localVarRequestOptions,
      };
    },
    /**
     *
     * @summary List experiments
     * @param {string} [status]
     * @param {*} [options] Override http request option.
     * @throws {RequiredError}
     */
    listExperiments: async (status?: string, options: any = {}): Promise<RequestArgs> => {
      const localVarPath = `/v1/experiment`;
      const localVarUrlObj = globalImportUrl.parse(localVarPath, true);
      let baseOptions;
      if (configuration) {
        baseOptions = configuration.baseOptions;
      }
      const localVarRequestOptions = { method: "GET", ...baseOptions, ...options };
      const localVarHeaderParameter = {} as any;
      const localVarQueryParameter = {} as any;

      if (status !== undefined) {
        localVarQueryParameter["status"] = status;
      }

      localVarUrlObj.query = { ...localVarUrlObj.query, ...localVarQueryParameter, ...options.query };
      // fix override query string Detail: https://stackoverflow.com/a/7517673/1077943
      delete localVarUrlObj.search;
      let headersFromBaseOptions = baseOptions && baseOptions.headers ? baseOptions.headers : {};
      localVarRequestOptions.headers = { ...localVarHeaderParameter, ...headersFromBaseOptions, ...options.headers };

      return {
        url: globalImportUrl.format(localVarUrlObj),
        options: localVarRequestOptions,
      };
    },
    /**
     *
     * @summary List experiment\'s log
     * @param {string} [status]
     * @param {*} [options] Override http request option.
     * @throws {RequiredError}
     */
    listLog: async (status?: string, options: any = {}): Promise<RequestArgs> => {
      const localVarPath = `/v1/experiment/logs`;
      const localVarUrlObj = globalImportUrl.parse(localVarPath, true);
      let baseOptions;
      if (configuration) {
        baseOptions = configuration.baseOptions;
      }
      const localVarRequestOptions = { method: "GET", ...baseOptions, ...options };
      const localVarHeaderParameter = {} as any;
      const localVarQueryParameter = {} as any;

      if (status !== undefined) {
        localVarQueryParameter["status"] = status;
      }

      localVarUrlObj.query = { ...localVarUrlObj.query, ...localVarQueryParameter, ...options.query };
      // fix override query string Detail: https://stackoverflow.com/a/7517673/1077943
      delete localVarUrlObj.search;
      let headersFromBaseOptions = baseOptions && baseOptions.headers ? baseOptions.headers : {};
      localVarRequestOptions.headers = { ...localVarHeaderParameter, ...headersFromBaseOptions, ...options.headers };

      return {
        url: globalImportUrl.format(localVarUrlObj),
        options: localVarRequestOptions,
      };
    },
    /**
     *
     * @summary Update the experiment in the submarine server with spec
     * @param {string} id
     * @param {ExperimentSpec} [experimentSpec]
     * @param {*} [options] Override http request option.
     * @throws {RequiredError}
     */
    patchExperiment: async (id: string, experimentSpec?: ExperimentSpec, options: any = {}): Promise<RequestArgs> => {
      // verify required parameter 'id' is not null or undefined
      if (id === null || id === undefined) {
        throw new RequiredError("id", "Required parameter id was null or undefined when calling patchExperiment.");
      }
      const localVarPath = `/v1/experiment/{id}`.replace(`{${"id"}}`, encodeURIComponent(String(id)));
      const localVarUrlObj = globalImportUrl.parse(localVarPath, true);
      let baseOptions;
      if (configuration) {
        baseOptions = configuration.baseOptions;
      }
      const localVarRequestOptions = { method: "PATCH", ...baseOptions, ...options };
      const localVarHeaderParameter = {} as any;
      const localVarQueryParameter = {} as any;

      localVarHeaderParameter["Content-Type"] = "application/yaml";

      localVarUrlObj.query = { ...localVarUrlObj.query, ...localVarQueryParameter, ...options.query };
      // fix override query string Detail: https://stackoverflow.com/a/7517673/1077943
      delete localVarUrlObj.search;
      let headersFromBaseOptions = baseOptions && baseOptions.headers ? baseOptions.headers : {};
      localVarRequestOptions.headers = { ...localVarHeaderParameter, ...headersFromBaseOptions, ...options.headers };
      const needsSerialization =
        typeof experimentSpec !== "string" || localVarRequestOptions.headers["Content-Type"] === "application/json";
      localVarRequestOptions.data = needsSerialization
        ? JSON.stringify(experimentSpec !== undefined ? experimentSpec : {})
        : experimentSpec || "";

      return {
        url: globalImportUrl.format(localVarUrlObj),
        options: localVarRequestOptions,
      };
    },
    /**
     * Return the Pong message for test the connectivity
     * @summary Ping submarine server
     * @param {*} [options] Override http request option.
     * @throws {RequiredError}
     */
    ping: async (options: any = {}): Promise<RequestArgs> => {
      const localVarPath = `/v1/experiment/ping`;
      const localVarUrlObj = globalImportUrl.parse(localVarPath, true);
      let baseOptions;
      if (configuration) {
        baseOptions = configuration.baseOptions;
      }
      const localVarRequestOptions = { method: "GET", ...baseOptions, ...options };
      const localVarHeaderParameter = {} as any;
      const localVarQueryParameter = {} as any;

      localVarUrlObj.query = { ...localVarUrlObj.query, ...localVarQueryParameter, ...options.query };
      // fix override query string Detail: https://stackoverflow.com/a/7517673/1077943
      delete localVarUrlObj.search;
      let headersFromBaseOptions = baseOptions && baseOptions.headers ? baseOptions.headers : {};
      localVarRequestOptions.headers = { ...localVarHeaderParameter, ...headersFromBaseOptions, ...options.headers };

      return {
        url: globalImportUrl.format(localVarUrlObj),
        options: localVarRequestOptions,
      };
    },
    /**
     *
     * @summary use experiment template to create an experiment
     * @param {string} name
     * @param {ExperimentTemplateSubmit} [experimentTemplateSubmit]
     * @param {*} [options] Override http request option.
     * @throws {RequiredError}
     */
    submitExperimentTemplate: async (
      name: string,
      experimentTemplateSubmit?: ExperimentTemplateSubmit,
      options: any = {}
    ): Promise<RequestArgs> => {
      // verify required parameter 'name' is not null or undefined
      if (name === null || name === undefined) {
        throw new RequiredError(
          "name",
          "Required parameter name was null or undefined when calling submitExperimentTemplate."
        );
      }
      const localVarPath = `/v1/experiment/{name}`.replace(`{${"name"}}`, encodeURIComponent(String(name)));
      const localVarUrlObj = globalImportUrl.parse(localVarPath, true);
      let baseOptions;
      if (configuration) {
        baseOptions = configuration.baseOptions;
      }
      const localVarRequestOptions = { method: "POST", ...baseOptions, ...options };
      const localVarHeaderParameter = {} as any;
      const localVarQueryParameter = {} as any;

      localVarHeaderParameter["Content-Type"] = "application/yaml";

      localVarUrlObj.query = { ...localVarUrlObj.query, ...localVarQueryParameter, ...options.query };
      // fix override query string Detail: https://stackoverflow.com/a/7517673/1077943
      delete localVarUrlObj.search;
      let headersFromBaseOptions = baseOptions && baseOptions.headers ? baseOptions.headers : {};
      localVarRequestOptions.headers = { ...localVarHeaderParameter, ...headersFromBaseOptions, ...options.headers };
      const needsSerialization =
        typeof experimentTemplateSubmit !== "string" ||
        localVarRequestOptions.headers["Content-Type"] === "application/json";
      localVarRequestOptions.data = needsSerialization
        ? JSON.stringify(experimentTemplateSubmit !== undefined ? experimentTemplateSubmit : {})
        : experimentTemplateSubmit || "";

      return {
        url: globalImportUrl.format(localVarUrlObj),
        options: localVarRequestOptions,
      };
    },
  };
};

/**
 * ExperimentApi - functional programming interface
 * @export
 */
export const ExperimentApiFp = function (configuration?: Configuration) {
  return {
    /**
     *
     * @summary Create an experiment
     * @param {ExperimentSpec} [experimentSpec]
     * @param {*} [options] Override http request option.
     * @throws {RequiredError}
     */
    async createExperiment(
      experimentSpec?: ExperimentSpec,
      options?: any
    ): Promise<(axios?: AxiosInstance, basePath?: string) => AxiosPromise<JsonResponse>> {
      const localVarAxiosArgs = await ExperimentApiAxiosParamCreator(configuration).createExperiment(
        experimentSpec,
        options
      );
      return (axios: AxiosInstance = globalAxios, basePath: string = BASE_PATH) => {
        const axiosRequestArgs = { ...localVarAxiosArgs.options, url: basePath + localVarAxiosArgs.url };
        return axios.request(axiosRequestArgs);
      };
    },
    /**
     *
     * @summary Delete the experiment
     * @param {string} id
     * @param {*} [options] Override http request option.
     * @throws {RequiredError}
     */
    async deleteExperiment(
      id: string,
      options?: any
    ): Promise<(axios?: AxiosInstance, basePath?: string) => AxiosPromise<JsonResponse>> {
      const localVarAxiosArgs = await ExperimentApiAxiosParamCreator(configuration).deleteExperiment(id, options);
      return (axios: AxiosInstance = globalAxios, basePath: string = BASE_PATH) => {
        const axiosRequestArgs = { ...localVarAxiosArgs.options, url: basePath + localVarAxiosArgs.url };
        return axios.request(axiosRequestArgs);
      };
    },
    /**
     *
     * @summary List artifact paths by id
     * @param {string} id
     * @param {*} [options] Override http request option.
     * @throws {RequiredError}
     */
    async getArtifactPaths(
      id: string,
      options?: any
    ): Promise<(axios?: AxiosInstance, basePath?: string) => AxiosPromise<JsonResponse>> {
      const localVarAxiosArgs = await ExperimentApiAxiosParamCreator(configuration).getArtifactPaths(id, options);
      return (axios: AxiosInstance = globalAxios, basePath: string = BASE_PATH) => {
        const axiosRequestArgs = { ...localVarAxiosArgs.options, url: basePath + localVarAxiosArgs.url };
        return axios.request(axiosRequestArgs);
      };
    },
    /**
     *
     * @summary Get the experiment\'s detailed info by id
     * @param {string} id
     * @param {*} [options] Override http request option.
     * @throws {RequiredError}
     */
    async getExperiment(
      id: string,
      options?: any
    ): Promise<(axios?: AxiosInstance, basePath?: string) => AxiosPromise<JsonResponse>> {
      const localVarAxiosArgs = await ExperimentApiAxiosParamCreator(configuration).getExperiment(id, options);
      return (axios: AxiosInstance = globalAxios, basePath: string = BASE_PATH) => {
        const axiosRequestArgs = { ...localVarAxiosArgs.options, url: basePath + localVarAxiosArgs.url };
        return axios.request(axiosRequestArgs);
      };
    },
    /**
     *
     * @summary Log experiment by id
     * @param {string} id
     * @param {*} [options] Override http request option.
     * @throws {RequiredError}
     */
    async getLog(
      id: string,
      options?: any
    ): Promise<(axios?: AxiosInstance, basePath?: string) => AxiosPromise<JsonResponse>> {
      const localVarAxiosArgs = await ExperimentApiAxiosParamCreator(configuration).getLog(id, options);
      return (axios: AxiosInstance = globalAxios, basePath: string = BASE_PATH) => {
        const axiosRequestArgs = { ...localVarAxiosArgs.options, url: basePath + localVarAxiosArgs.url };
        return axios.request(axiosRequestArgs);
      };
    },
    /**
     *
     * @summary Get mlflow\'s information
     * @param {*} [options] Override http request option.
     * @throws {RequiredError}
     */
    async getMLflowInfo(
      options?: any
    ): Promise<(axios?: AxiosInstance, basePath?: string) => AxiosPromise<JsonResponse>> {
      const localVarAxiosArgs = await ExperimentApiAxiosParamCreator(configuration).getMLflowInfo(options);
      return (axios: AxiosInstance = globalAxios, basePath: string = BASE_PATH) => {
        const axiosRequestArgs = { ...localVarAxiosArgs.options, url: basePath + localVarAxiosArgs.url };
        return axios.request(axiosRequestArgs);
      };
    },
    /**
     *
     * @summary Get tensorboard\'s information
     * @param {*} [options] Override http request option.
     * @throws {RequiredError}
     */
    async getTensorboardInfo(
      options?: any
    ): Promise<(axios?: AxiosInstance, basePath?: string) => AxiosPromise<JsonResponse>> {
      const localVarAxiosArgs = await ExperimentApiAxiosParamCreator(configuration).getTensorboardInfo(options);
      return (axios: AxiosInstance = globalAxios, basePath: string = BASE_PATH) => {
        const axiosRequestArgs = { ...localVarAxiosArgs.options, url: basePath + localVarAxiosArgs.url };
        return axios.request(axiosRequestArgs);
      };
    },
    /**
     *
     * @summary List experiments
     * @param {string} [status]
     * @param {*} [options] Override http request option.
     * @throws {RequiredError}
     */
    async listExperiments(
      status?: string,
      options?: any
    ): Promise<(axios?: AxiosInstance, basePath?: string) => AxiosPromise<JsonResponse>> {
      const localVarAxiosArgs = await ExperimentApiAxiosParamCreator(configuration).listExperiments(status, options);
      return (axios: AxiosInstance = globalAxios, basePath: string = BASE_PATH) => {
        const axiosRequestArgs = { ...localVarAxiosArgs.options, url: basePath + localVarAxiosArgs.url };
        return axios.request(axiosRequestArgs);
      };
    },
    /**
     *
     * @summary List experiment\'s log
     * @param {string} [status]
     * @param {*} [options] Override http request option.
     * @throws {RequiredError}
     */
    async listLog(
      status?: string,
      options?: any
    ): Promise<(axios?: AxiosInstance, basePath?: string) => AxiosPromise<JsonResponse>> {
      const localVarAxiosArgs = await ExperimentApiAxiosParamCreator(configuration).listLog(status, options);
      return (axios: AxiosInstance = globalAxios, basePath: string = BASE_PATH) => {
        const axiosRequestArgs = { ...localVarAxiosArgs.options, url: basePath + localVarAxiosArgs.url };
        return axios.request(axiosRequestArgs);
      };
    },
    /**
     *
     * @summary Update the experiment in the submarine server with spec
     * @param {string} id
     * @param {ExperimentSpec} [experimentSpec]
     * @param {*} [options] Override http request option.
     * @throws {RequiredError}
     */
    async patchExperiment(
      id: string,
      experimentSpec?: ExperimentSpec,
      options?: any
    ): Promise<(axios?: AxiosInstance, basePath?: string) => AxiosPromise<JsonResponse>> {
      const localVarAxiosArgs = await ExperimentApiAxiosParamCreator(configuration).patchExperiment(
        id,
        experimentSpec,
        options
      );
      return (axios: AxiosInstance = globalAxios, basePath: string = BASE_PATH) => {
        const axiosRequestArgs = { ...localVarAxiosArgs.options, url: basePath + localVarAxiosArgs.url };
        return axios.request(axiosRequestArgs);
      };
    },
    /**
     * Return the Pong message for test the connectivity
     * @summary Ping submarine server
     * @param {*} [options] Override http request option.
     * @throws {RequiredError}
     */
    async ping(options?: any): Promise<(axios?: AxiosInstance, basePath?: string) => AxiosPromise<string>> {
      const localVarAxiosArgs = await ExperimentApiAxiosParamCreator(configuration).ping(options);
      return (axios: AxiosInstance = globalAxios, basePath: string = BASE_PATH) => {
        const axiosRequestArgs = { ...localVarAxiosArgs.options, url: basePath + localVarAxiosArgs.url };
        return axios.request(axiosRequestArgs);
      };
    },
    /**
     *
     * @summary use experiment template to create an experiment
     * @param {string} name
     * @param {ExperimentTemplateSubmit} [experimentTemplateSubmit]
     * @param {*} [options] Override http request option.
     * @throws {RequiredError}
     */
    async submitExperimentTemplate(
      name: string,
      experimentTemplateSubmit?: ExperimentTemplateSubmit,
      options?: any
    ): Promise<(axios?: AxiosInstance, basePath?: string) => AxiosPromise<JsonResponse>> {
      const localVarAxiosArgs = await ExperimentApiAxiosParamCreator(configuration).submitExperimentTemplate(
        name,
        experimentTemplateSubmit,
        options
      );
      return (axios: AxiosInstance = globalAxios, basePath: string = BASE_PATH) => {
        const axiosRequestArgs = { ...localVarAxiosArgs.options, url: basePath + localVarAxiosArgs.url };
        return axios.request(axiosRequestArgs);
      };
    },
  };
};

/**
 * ExperimentApi - factory interface
 * @export
 */
export const ExperimentApiFactory = function (configuration?: Configuration, basePath?: string, axios?: AxiosInstance) {
  return {
    /**
     *
     * @summary Create an experiment
     * @param {ExperimentSpec} [experimentSpec]
     * @param {*} [options] Override http request option.
     * @throws {RequiredError}
     */
    createExperiment(experimentSpec?: ExperimentSpec, options?: any): AxiosPromise<JsonResponse> {
      return ExperimentApiFp(configuration)
        .createExperiment(experimentSpec, options)
        .then((request) => request(axios, basePath));
    },
    /**
     *
     * @summary Delete the experiment
     * @param {string} id
     * @param {*} [options] Override http request option.
     * @throws {RequiredError}
     */
    deleteExperiment(id: string, options?: any): AxiosPromise<JsonResponse> {
      return ExperimentApiFp(configuration)
        .deleteExperiment(id, options)
        .then((request) => request(axios, basePath));
    },
    /**
     *
     * @summary List artifact paths by id
     * @param {string} id
     * @param {*} [options] Override http request option.
     * @throws {RequiredError}
     */
    getArtifactPaths(id: string, options?: any): AxiosPromise<JsonResponse> {
      return ExperimentApiFp(configuration)
        .getArtifactPaths(id, options)
        .then((request) => request(axios, basePath));
    },
    /**
     *
     * @summary Get the experiment\'s detailed info by id
     * @param {string} id
     * @param {*} [options] Override http request option.
     * @throws {RequiredError}
     */
    getExperiment(id: string, options?: any): AxiosPromise<JsonResponse> {
      return ExperimentApiFp(configuration)
        .getExperiment(id, options)
        .then((request) => request(axios, basePath));
    },
    /**
     *
     * @summary Log experiment by id
     * @param {string} id
     * @param {*} [options] Override http request option.
     * @throws {RequiredError}
     */
    getLog(id: string, options?: any): AxiosPromise<JsonResponse> {
      return ExperimentApiFp(configuration)
        .getLog(id, options)
        .then((request) => request(axios, basePath));
    },
    /**
     *
     * @summary Get mlflow\'s information
     * @param {*} [options] Override http request option.
     * @throws {RequiredError}
     */
    getMLflowInfo(options?: any): AxiosPromise<JsonResponse> {
      return ExperimentApiFp(configuration)
        .getMLflowInfo(options)
        .then((request) => request(axios, basePath));
    },
    /**
     *
     * @summary Get tensorboard\'s information
     * @param {*} [options] Override http request option.
     * @throws {RequiredError}
     */
    getTensorboardInfo(options?: any): AxiosPromise<JsonResponse> {
      return ExperimentApiFp(configuration)
        .getTensorboardInfo(options)
        .then((request) => request(axios, basePath));
    },
    /**
     *
     * @summary List experiments
     * @param {string} [status]
     * @param {*} [options] Override http request option.
     * @throws {RequiredError}
     */
    listExperiments(status?: string, options?: any): AxiosPromise<JsonResponse> {
      return ExperimentApiFp(configuration)
        .listExperiments(status, options)
        .then((request) => request(axios, basePath));
    },
    /**
     *
     * @summary List experiment\'s log
     * @param {string} [status]
     * @param {*} [options] Override http request option.
     * @throws {RequiredError}
     */
    listLog(status?: string, options?: any): AxiosPromise<JsonResponse> {
      return ExperimentApiFp(configuration)
        .listLog(status, options)
        .then((request) => request(axios, basePath));
    },
    /**
     *
     * @summary Update the experiment in the submarine server with spec
     * @param {string} id
     * @param {ExperimentSpec} [experimentSpec]
     * @param {*} [options] Override http request option.
     * @throws {RequiredError}
     */
    patchExperiment(id: string, experimentSpec?: ExperimentSpec, options?: any): AxiosPromise<JsonResponse> {
      return ExperimentApiFp(configuration)
        .patchExperiment(id, experimentSpec, options)
        .then((request) => request(axios, basePath));
    },
    /**
     * Return the Pong message for test the connectivity
     * @summary Ping submarine server
     * @param {*} [options] Override http request option.
     * @throws {RequiredError}
     */
    ping(options?: any): AxiosPromise<string> {
      return ExperimentApiFp(configuration)
        .ping(options)
        .then((request) => request(axios, basePath));
    },
    /**
     *
     * @summary use experiment template to create an experiment
     * @param {string} name
     * @param {ExperimentTemplateSubmit} [experimentTemplateSubmit]
     * @param {*} [options] Override http request option.
     * @throws {RequiredError}
     */
    submitExperimentTemplate(
      name: string,
      experimentTemplateSubmit?: ExperimentTemplateSubmit,
      options?: any
    ): AxiosPromise<JsonResponse> {
      return ExperimentApiFp(configuration)
        .submitExperimentTemplate(name, experimentTemplateSubmit, options)
        .then((request) => request(axios, basePath));
    },
  };
};

/**
 * ExperimentApi - object-oriented interface
 * @export
 * @class ExperimentApi
 * @extends {BaseAPI}
 */
export class ExperimentApi extends BaseAPI {
  /**
   *
   * @summary Create an experiment
   * @param {ExperimentSpec} [experimentSpec]
   * @param {*} [options] Override http request option.
   * @throws {RequiredError}
   * @memberof ExperimentApi
   */
  public createExperiment(experimentSpec?: ExperimentSpec, options?: any) {
    return ExperimentApiFp(this.configuration)
      .createExperiment(experimentSpec, options)
      .then((request) => request(this.axios, this.basePath));
  }

  /**
   *
   * @summary Delete the experiment
   * @param {string} id
   * @param {*} [options] Override http request option.
   * @throws {RequiredError}
   * @memberof ExperimentApi
   */
  public deleteExperiment(id: string, options?: any) {
    return ExperimentApiFp(this.configuration)
      .deleteExperiment(id, options)
      .then((request) => request(this.axios, this.basePath));
  }

  /**
   *
   * @summary List artifact paths by id
   * @param {string} id
   * @param {*} [options] Override http request option.
   * @throws {RequiredError}
   * @memberof ExperimentApi
   */
  public getArtifactPaths(id: string, options?: any) {
    return ExperimentApiFp(this.configuration)
      .getArtifactPaths(id, options)
      .then((request) => request(this.axios, this.basePath));
  }

  /**
   *
   * @summary Get the experiment\'s detailed info by id
   * @param {string} id
   * @param {*} [options] Override http request option.
   * @throws {RequiredError}
   * @memberof ExperimentApi
   */
  public getExperiment(id: string, options?: any) {
    return ExperimentApiFp(this.configuration)
      .getExperiment(id, options)
      .then((request) => request(this.axios, this.basePath));
  }

  /**
   *
   * @summary Log experiment by id
   * @param {string} id
   * @param {*} [options] Override http request option.
   * @throws {RequiredError}
   * @memberof ExperimentApi
   */
  public getLog(id: string, options?: any) {
    return ExperimentApiFp(this.configuration)
      .getLog(id, options)
      .then((request) => request(this.axios, this.basePath));
  }

  /**
   *
   * @summary Get mlflow\'s information
   * @param {*} [options] Override http request option.
   * @throws {RequiredError}
   * @memberof ExperimentApi
   */
  public getMLflowInfo(options?: any) {
    return ExperimentApiFp(this.configuration)
      .getMLflowInfo(options)
      .then((request) => request(this.axios, this.basePath));
  }

  /**
   *
   * @summary Get tensorboard\'s information
   * @param {*} [options] Override http request option.
   * @throws {RequiredError}
   * @memberof ExperimentApi
   */
  public getTensorboardInfo(options?: any) {
    return ExperimentApiFp(this.configuration)
      .getTensorboardInfo(options)
      .then((request) => request(this.axios, this.basePath));
  }

  /**
   *
   * @summary List experiments
   * @param {string} [status]
   * @param {*} [options] Override http request option.
   * @throws {RequiredError}
   * @memberof ExperimentApi
   */
  public listExperiments(status?: string, options?: any) {
    return ExperimentApiFp(this.configuration)
      .listExperiments(status, options)
      .then((request) => request(this.axios, this.basePath));
  }

  /**
   *
   * @summary List experiment\'s log
   * @param {string} [status]
   * @param {*} [options] Override http request option.
   * @throws {RequiredError}
   * @memberof ExperimentApi
   */
  public listLog(status?: string, options?: any) {
    return ExperimentApiFp(this.configuration)
      .listLog(status, options)
      .then((request) => request(this.axios, this.basePath));
  }

  /**
   *
   * @summary Update the experiment in the submarine server with spec
   * @param {string} id
   * @param {ExperimentSpec} [experimentSpec]
   * @param {*} [options] Override http request option.
   * @throws {RequiredError}
   * @memberof ExperimentApi
   */
  public patchExperiment(id: string, experimentSpec?: ExperimentSpec, options?: any) {
    return ExperimentApiFp(this.configuration)
      .patchExperiment(id, experimentSpec, options)
      .then((request) => request(this.axios, this.basePath));
  }

  /**
   * Return the Pong message for test the connectivity
   * @summary Ping submarine server
   * @param {*} [options] Override http request option.
   * @throws {RequiredError}
   * @memberof ExperimentApi
   */
  public ping(options?: any) {
    return ExperimentApiFp(this.configuration)
      .ping(options)
      .then((request) => request(this.axios, this.basePath));
  }

  /**
   *
   * @summary use experiment template to create an experiment
   * @param {string} name
   * @param {ExperimentTemplateSubmit} [experimentTemplateSubmit]
   * @param {*} [options] Override http request option.
   * @throws {RequiredError}
   * @memberof ExperimentApi
   */
  public submitExperimentTemplate(name: string, experimentTemplateSubmit?: ExperimentTemplateSubmit, options?: any) {
    return ExperimentApiFp(this.configuration)
      .submitExperimentTemplate(name, experimentTemplateSubmit, options)
      .then((request) => request(this.axios, this.basePath));
  }
}

/**
 * ExperimentTemplateApi - axios parameter creator
 * @export
 */
export const ExperimentTemplateApiAxiosParamCreator = function (configuration?: Configuration) {
  return {
    /**
     *
     * @summary Create a experimentTemplate
     * @param {ExperimentTemplateSpec} [experimentTemplateSpec]
     * @param {*} [options] Override http request option.
     * @throws {RequiredError}
     */
    createExperimentTemplate: async (
      experimentTemplateSpec?: ExperimentTemplateSpec,
      options: any = {}
    ): Promise<RequestArgs> => {
      const localVarPath = `/v1/template`;
      const localVarUrlObj = globalImportUrl.parse(localVarPath, true);
      let baseOptions;
      if (configuration) {
        baseOptions = configuration.baseOptions;
      }
      const localVarRequestOptions = { method: "POST", ...baseOptions, ...options };
      const localVarHeaderParameter = {} as any;
      const localVarQueryParameter = {} as any;

      localVarHeaderParameter["Content-Type"] = "application/yaml";

      localVarUrlObj.query = { ...localVarUrlObj.query, ...localVarQueryParameter, ...options.query };
      // fix override query string Detail: https://stackoverflow.com/a/7517673/1077943
      delete localVarUrlObj.search;
      let headersFromBaseOptions = baseOptions && baseOptions.headers ? baseOptions.headers : {};
      localVarRequestOptions.headers = { ...localVarHeaderParameter, ...headersFromBaseOptions, ...options.headers };
      const needsSerialization =
        typeof experimentTemplateSpec !== "string" ||
        localVarRequestOptions.headers["Content-Type"] === "application/json";
      localVarRequestOptions.data = needsSerialization
        ? JSON.stringify(experimentTemplateSpec !== undefined ? experimentTemplateSpec : {})
        : experimentTemplateSpec || "";

      return {
        url: globalImportUrl.format(localVarUrlObj),
        options: localVarRequestOptions,
      };
    },
    /**
     *
     * @summary Find experimentTemplate by name
     * @param {string} id
     * @param {*} [options] Override http request option.
     * @throws {RequiredError}
     */
    getExperimentTemplate: async (id: string, options: any = {}): Promise<RequestArgs> => {
      // verify required parameter 'id' is not null or undefined
      if (id === null || id === undefined) {
        throw new RequiredError(
          "id",
          "Required parameter id was null or undefined when calling getExperimentTemplate."
        );
      }
      const localVarPath = `/v1/template/{id}`.replace(`{${"id"}}`, encodeURIComponent(String(id)));
      const localVarUrlObj = globalImportUrl.parse(localVarPath, true);
      let baseOptions;
      if (configuration) {
        baseOptions = configuration.baseOptions;
      }
      const localVarRequestOptions = { method: "GET", ...baseOptions, ...options };
      const localVarHeaderParameter = {} as any;
      const localVarQueryParameter = {} as any;

      localVarUrlObj.query = { ...localVarUrlObj.query, ...localVarQueryParameter, ...options.query };
      // fix override query string Detail: https://stackoverflow.com/a/7517673/1077943
      delete localVarUrlObj.search;
      let headersFromBaseOptions = baseOptions && baseOptions.headers ? baseOptions.headers : {};
      localVarRequestOptions.headers = { ...localVarHeaderParameter, ...headersFromBaseOptions, ...options.headers };

      return {
        url: globalImportUrl.format(localVarUrlObj),
        options: localVarRequestOptions,
      };
    },
  };
};

/**
 * ExperimentTemplateApi - functional programming interface
 * @export
 */
export const ExperimentTemplateApiFp = function (configuration?: Configuration) {
  return {
    /**
     *
     * @summary Create a experimentTemplate
     * @param {ExperimentTemplateSpec} [experimentTemplateSpec]
     * @param {*} [options] Override http request option.
     * @throws {RequiredError}
     */
    async createExperimentTemplate(
      experimentTemplateSpec?: ExperimentTemplateSpec,
      options?: any
    ): Promise<(axios?: AxiosInstance, basePath?: string) => AxiosPromise<JsonResponse>> {
      const localVarAxiosArgs = await ExperimentTemplateApiAxiosParamCreator(configuration).createExperimentTemplate(
        experimentTemplateSpec,
        options
      );
      return (axios: AxiosInstance = globalAxios, basePath: string = BASE_PATH) => {
        const axiosRequestArgs = { ...localVarAxiosArgs.options, url: basePath + localVarAxiosArgs.url };
        return axios.request(axiosRequestArgs);
      };
    },
    /**
     *
     * @summary Find experimentTemplate by name
     * @param {string} id
     * @param {*} [options] Override http request option.
     * @throws {RequiredError}
     */
    async getExperimentTemplate(
      id: string,
      options?: any
    ): Promise<(axios?: AxiosInstance, basePath?: string) => AxiosPromise<JsonResponse>> {
      const localVarAxiosArgs = await ExperimentTemplateApiAxiosParamCreator(configuration).getExperimentTemplate(
        id,
        options
      );
      return (axios: AxiosInstance = globalAxios, basePath: string = BASE_PATH) => {
        const axiosRequestArgs = { ...localVarAxiosArgs.options, url: basePath + localVarAxiosArgs.url };
        return axios.request(axiosRequestArgs);
      };
    },
  };
};

/**
 * ExperimentTemplateApi - factory interface
 * @export
 */
export const ExperimentTemplateApiFactory = function (
  configuration?: Configuration,
  basePath?: string,
  axios?: AxiosInstance
) {
  return {
    /**
     *
     * @summary Create a experimentTemplate
     * @param {ExperimentTemplateSpec} [experimentTemplateSpec]
     * @param {*} [options] Override http request option.
     * @throws {RequiredError}
     */
    createExperimentTemplate(
      experimentTemplateSpec?: ExperimentTemplateSpec,
      options?: any
    ): AxiosPromise<JsonResponse> {
      return ExperimentTemplateApiFp(configuration)
        .createExperimentTemplate(experimentTemplateSpec, options)
        .then((request) => request(axios, basePath));
    },
    /**
     *
     * @summary Find experimentTemplate by name
     * @param {string} id
     * @param {*} [options] Override http request option.
     * @throws {RequiredError}
     */
    getExperimentTemplate(id: string, options?: any): AxiosPromise<JsonResponse> {
      return ExperimentTemplateApiFp(configuration)
        .getExperimentTemplate(id, options)
        .then((request) => request(axios, basePath));
    },
  };
};

/**
 * ExperimentTemplateApi - object-oriented interface
 * @export
 * @class ExperimentTemplateApi
 * @extends {BaseAPI}
 */
export class ExperimentTemplateApi extends BaseAPI {
  /**
   *
   * @summary Create a experimentTemplate
   * @param {ExperimentTemplateSpec} [experimentTemplateSpec]
   * @param {*} [options] Override http request option.
   * @throws {RequiredError}
   * @memberof ExperimentTemplateApi
   */
  public createExperimentTemplate(experimentTemplateSpec?: ExperimentTemplateSpec, options?: any) {
    return ExperimentTemplateApiFp(this.configuration)
      .createExperimentTemplate(experimentTemplateSpec, options)
      .then((request) => request(this.axios, this.basePath));
  }

  /**
   *
   * @summary Find experimentTemplate by name
   * @param {string} id
   * @param {*} [options] Override http request option.
   * @throws {RequiredError}
   * @memberof ExperimentTemplateApi
   */
  public getExperimentTemplate(id: string, options?: any) {
    return ExperimentTemplateApiFp(this.configuration)
      .getExperimentTemplate(id, options)
      .then((request) => request(this.axios, this.basePath));
  }
}

/**
 * ExperimentTemplatesApi - axios parameter creator
 * @export
 */
export const ExperimentTemplatesApiAxiosParamCreator = function (configuration?: Configuration) {
  return {
    /**
     *
     * @summary Delete the experimentTemplate
     * @param {string} id
     * @param {*} [options] Override http request option.
     * @throws {RequiredError}
     */
    deleteExperimentTemplate: async (id: string, options: any = {}): Promise<RequestArgs> => {
      // verify required parameter 'id' is not null or undefined
      if (id === null || id === undefined) {
        throw new RequiredError(
          "id",
          "Required parameter id was null or undefined when calling deleteExperimentTemplate."
        );
      }
      const localVarPath = `/v1/template/{id}`.replace(`{${"id"}}`, encodeURIComponent(String(id)));
      const localVarUrlObj = globalImportUrl.parse(localVarPath, true);
      let baseOptions;
      if (configuration) {
        baseOptions = configuration.baseOptions;
      }
      const localVarRequestOptions = { method: "DELETE", ...baseOptions, ...options };
      const localVarHeaderParameter = {} as any;
      const localVarQueryParameter = {} as any;

      localVarUrlObj.query = { ...localVarUrlObj.query, ...localVarQueryParameter, ...options.query };
      // fix override query string Detail: https://stackoverflow.com/a/7517673/1077943
      delete localVarUrlObj.search;
      let headersFromBaseOptions = baseOptions && baseOptions.headers ? baseOptions.headers : {};
      localVarRequestOptions.headers = { ...localVarHeaderParameter, ...headersFromBaseOptions, ...options.headers };

      return {
        url: globalImportUrl.format(localVarUrlObj),
        options: localVarRequestOptions,
      };
    },
    /**
     *
     * @summary List of ExperimentTemplates
     * @param {string} [status]
     * @param {*} [options] Override http request option.
     * @throws {RequiredError}
     */
    listExperimentTemplate: async (status?: string, options: any = {}): Promise<RequestArgs> => {
      const localVarPath = `/v1/template`;
      const localVarUrlObj = globalImportUrl.parse(localVarPath, true);
      let baseOptions;
      if (configuration) {
        baseOptions = configuration.baseOptions;
      }
      const localVarRequestOptions = { method: "GET", ...baseOptions, ...options };
      const localVarHeaderParameter = {} as any;
      const localVarQueryParameter = {} as any;

      if (status !== undefined) {
        localVarQueryParameter["status"] = status;
      }

      localVarUrlObj.query = { ...localVarUrlObj.query, ...localVarQueryParameter, ...options.query };
      // fix override query string Detail: https://stackoverflow.com/a/7517673/1077943
      delete localVarUrlObj.search;
      let headersFromBaseOptions = baseOptions && baseOptions.headers ? baseOptions.headers : {};
      localVarRequestOptions.headers = { ...localVarHeaderParameter, ...headersFromBaseOptions, ...options.headers };

      return {
        url: globalImportUrl.format(localVarUrlObj),
        options: localVarRequestOptions,
      };
    },
    /**
     *
     * @summary Update the experimentTemplate with job spec
     * @param {string} id
     * @param {ExperimentTemplateSpec} [experimentTemplateSpec]
     * @param {*} [options] Override http request option.
     * @throws {RequiredError}
     */
    updateExperimentTemplate: async (
      id: string,
      experimentTemplateSpec?: ExperimentTemplateSpec,
      options: any = {}
    ): Promise<RequestArgs> => {
      // verify required parameter 'id' is not null or undefined
      if (id === null || id === undefined) {
        throw new RequiredError(
          "id",
          "Required parameter id was null or undefined when calling updateExperimentTemplate."
        );
      }
      const localVarPath = `/v1/template/{id}`.replace(`{${"id"}}`, encodeURIComponent(String(id)));
      const localVarUrlObj = globalImportUrl.parse(localVarPath, true);
      let baseOptions;
      if (configuration) {
        baseOptions = configuration.baseOptions;
      }
      const localVarRequestOptions = { method: "PATCH", ...baseOptions, ...options };
      const localVarHeaderParameter = {} as any;
      const localVarQueryParameter = {} as any;

      localVarHeaderParameter["Content-Type"] = "application/yaml";

      localVarUrlObj.query = { ...localVarUrlObj.query, ...localVarQueryParameter, ...options.query };
      // fix override query string Detail: https://stackoverflow.com/a/7517673/1077943
      delete localVarUrlObj.search;
      let headersFromBaseOptions = baseOptions && baseOptions.headers ? baseOptions.headers : {};
      localVarRequestOptions.headers = { ...localVarHeaderParameter, ...headersFromBaseOptions, ...options.headers };
      const needsSerialization =
        typeof experimentTemplateSpec !== "string" ||
        localVarRequestOptions.headers["Content-Type"] === "application/json";
      localVarRequestOptions.data = needsSerialization
        ? JSON.stringify(experimentTemplateSpec !== undefined ? experimentTemplateSpec : {})
        : experimentTemplateSpec || "";

      return {
        url: globalImportUrl.format(localVarUrlObj),
        options: localVarRequestOptions,
      };
    },
  };
};

/**
 * ExperimentTemplatesApi - functional programming interface
 * @export
 */
export const ExperimentTemplatesApiFp = function (configuration?: Configuration) {
  return {
    /**
     *
     * @summary Delete the experimentTemplate
     * @param {string} id
     * @param {*} [options] Override http request option.
     * @throws {RequiredError}
     */
    async deleteExperimentTemplate(
      id: string,
      options?: any
    ): Promise<(axios?: AxiosInstance, basePath?: string) => AxiosPromise<JsonResponse>> {
      const localVarAxiosArgs = await ExperimentTemplatesApiAxiosParamCreator(configuration).deleteExperimentTemplate(
        id,
        options
      );
      return (axios: AxiosInstance = globalAxios, basePath: string = BASE_PATH) => {
        const axiosRequestArgs = { ...localVarAxiosArgs.options, url: basePath + localVarAxiosArgs.url };
        return axios.request(axiosRequestArgs);
      };
    },
    /**
     *
     * @summary List of ExperimentTemplates
     * @param {string} [status]
     * @param {*} [options] Override http request option.
     * @throws {RequiredError}
     */
    async listExperimentTemplate(
      status?: string,
      options?: any
    ): Promise<(axios?: AxiosInstance, basePath?: string) => AxiosPromise<JsonResponse>> {
      const localVarAxiosArgs = await ExperimentTemplatesApiAxiosParamCreator(configuration).listExperimentTemplate(
        status,
        options
      );
      return (axios: AxiosInstance = globalAxios, basePath: string = BASE_PATH) => {
        const axiosRequestArgs = { ...localVarAxiosArgs.options, url: basePath + localVarAxiosArgs.url };
        return axios.request(axiosRequestArgs);
      };
    },
    /**
     *
     * @summary Update the experimentTemplate with job spec
     * @param {string} id
     * @param {ExperimentTemplateSpec} [experimentTemplateSpec]
     * @param {*} [options] Override http request option.
     * @throws {RequiredError}
     */
    async updateExperimentTemplate(
      id: string,
      experimentTemplateSpec?: ExperimentTemplateSpec,
      options?: any
    ): Promise<(axios?: AxiosInstance, basePath?: string) => AxiosPromise<JsonResponse>> {
      const localVarAxiosArgs = await ExperimentTemplatesApiAxiosParamCreator(configuration).updateExperimentTemplate(
        id,
        experimentTemplateSpec,
        options
      );
      return (axios: AxiosInstance = globalAxios, basePath: string = BASE_PATH) => {
        const axiosRequestArgs = { ...localVarAxiosArgs.options, url: basePath + localVarAxiosArgs.url };
        return axios.request(axiosRequestArgs);
      };
    },
  };
};

/**
 * ExperimentTemplatesApi - factory interface
 * @export
 */
export const ExperimentTemplatesApiFactory = function (
  configuration?: Configuration,
  basePath?: string,
  axios?: AxiosInstance
) {
  return {
    /**
     *
     * @summary Delete the experimentTemplate
     * @param {string} id
     * @param {*} [options] Override http request option.
     * @throws {RequiredError}
     */
    deleteExperimentTemplate(id: string, options?: any): AxiosPromise<JsonResponse> {
      return ExperimentTemplatesApiFp(configuration)
        .deleteExperimentTemplate(id, options)
        .then((request) => request(axios, basePath));
    },
    /**
     *
     * @summary List of ExperimentTemplates
     * @param {string} [status]
     * @param {*} [options] Override http request option.
     * @throws {RequiredError}
     */
    listExperimentTemplate(status?: string, options?: any): AxiosPromise<JsonResponse> {
      return ExperimentTemplatesApiFp(configuration)
        .listExperimentTemplate(status, options)
        .then((request) => request(axios, basePath));
    },
    /**
     *
     * @summary Update the experimentTemplate with job spec
     * @param {string} id
     * @param {ExperimentTemplateSpec} [experimentTemplateSpec]
     * @param {*} [options] Override http request option.
     * @throws {RequiredError}
     */
    updateExperimentTemplate(
      id: string,
      experimentTemplateSpec?: ExperimentTemplateSpec,
      options?: any
    ): AxiosPromise<JsonResponse> {
      return ExperimentTemplatesApiFp(configuration)
        .updateExperimentTemplate(id, experimentTemplateSpec, options)
        .then((request) => request(axios, basePath));
    },
  };
};

/**
 * ExperimentTemplatesApi - object-oriented interface
 * @export
 * @class ExperimentTemplatesApi
 * @extends {BaseAPI}
 */
export class ExperimentTemplatesApi extends BaseAPI {
  /**
   *
   * @summary Delete the experimentTemplate
   * @param {string} id
   * @param {*} [options] Override http request option.
   * @throws {RequiredError}
   * @memberof ExperimentTemplatesApi
   */
  public deleteExperimentTemplate(id: string, options?: any) {
    return ExperimentTemplatesApiFp(this.configuration)
      .deleteExperimentTemplate(id, options)
      .then((request) => request(this.axios, this.basePath));
  }

  /**
   *
   * @summary List of ExperimentTemplates
   * @param {string} [status]
   * @param {*} [options] Override http request option.
   * @throws {RequiredError}
   * @memberof ExperimentTemplatesApi
   */
  public listExperimentTemplate(status?: string, options?: any) {
    return ExperimentTemplatesApiFp(this.configuration)
      .listExperimentTemplate(status, options)
      .then((request) => request(this.axios, this.basePath));
  }

  /**
   *
   * @summary Update the experimentTemplate with job spec
   * @param {string} id
   * @param {ExperimentTemplateSpec} [experimentTemplateSpec]
   * @param {*} [options] Override http request option.
   * @throws {RequiredError}
   * @memberof ExperimentTemplatesApi
   */
  public updateExperimentTemplate(id: string, experimentTemplateSpec?: ExperimentTemplateSpec, options?: any) {
    return ExperimentTemplatesApiFp(this.configuration)
      .updateExperimentTemplate(id, experimentTemplateSpec, options)
      .then((request) => request(this.axios, this.basePath));
  }
}

/**
 * ModelVersionApi - axios parameter creator
 * @export
 */
export const ModelVersionApiAxiosParamCreator = function (configuration?: Configuration) {
  return {
    /**
     *
     * @summary Create a model version instance
     * @param {string} [baseDir]
     * @param {ModelVersionEntity} [modelVersionEntity]
     * @param {*} [options] Override http request option.
     * @throws {RequiredError}
     */
    createModelVersion: async (
      baseDir?: string,
      modelVersionEntity?: ModelVersionEntity,
      options: any = {}
    ): Promise<RequestArgs> => {
      const localVarPath = `/v1/model-version`;
      const localVarUrlObj = globalImportUrl.parse(localVarPath, true);
      let baseOptions;
      if (configuration) {
        baseOptions = configuration.baseOptions;
      }
      const localVarRequestOptions = { method: "POST", ...baseOptions, ...options };
      const localVarHeaderParameter = {} as any;
      const localVarQueryParameter = {} as any;

      if (baseDir !== undefined) {
        localVarQueryParameter["baseDir"] = baseDir;
      }

      localVarHeaderParameter["Content-Type"] = "application/yaml";

      localVarUrlObj.query = { ...localVarUrlObj.query, ...localVarQueryParameter, ...options.query };
      // fix override query string Detail: https://stackoverflow.com/a/7517673/1077943
      delete localVarUrlObj.search;
      let headersFromBaseOptions = baseOptions && baseOptions.headers ? baseOptions.headers : {};
      localVarRequestOptions.headers = { ...localVarHeaderParameter, ...headersFromBaseOptions, ...options.headers };
      const needsSerialization =
        typeof modelVersionEntity !== "string" || localVarRequestOptions.headers["Content-Type"] === "application/json";
      localVarRequestOptions.data = needsSerialization
        ? JSON.stringify(modelVersionEntity !== undefined ? modelVersionEntity : {})
        : modelVersionEntity || "";

      return {
        url: globalImportUrl.format(localVarUrlObj),
        options: localVarRequestOptions,
      };
    },
    /**
     *
     * @summary Create a model version tag instance
     * @param {string} [name]
     * @param {string} [version]
     * @param {string} [tag]
     * @param {*} [options] Override http request option.
     * @throws {RequiredError}
     */
    createModelVersionTag: async (
      name?: string,
      version?: string,
      tag?: string,
      options: any = {}
    ): Promise<RequestArgs> => {
      const localVarPath = `/v1/model-version/tag`;
      const localVarUrlObj = globalImportUrl.parse(localVarPath, true);
      let baseOptions;
      if (configuration) {
        baseOptions = configuration.baseOptions;
      }
      const localVarRequestOptions = { method: "POST", ...baseOptions, ...options };
      const localVarHeaderParameter = {} as any;
      const localVarQueryParameter = {} as any;

      if (name !== undefined) {
        localVarQueryParameter["name"] = name;
      }

      if (version !== undefined) {
        localVarQueryParameter["version"] = version;
      }

      if (tag !== undefined) {
        localVarQueryParameter["tag"] = tag;
      }

      localVarUrlObj.query = { ...localVarUrlObj.query, ...localVarQueryParameter, ...options.query };
      // fix override query string Detail: https://stackoverflow.com/a/7517673/1077943
      delete localVarUrlObj.search;
      let headersFromBaseOptions = baseOptions && baseOptions.headers ? baseOptions.headers : {};
      localVarRequestOptions.headers = { ...localVarHeaderParameter, ...headersFromBaseOptions, ...options.headers };

      return {
        url: globalImportUrl.format(localVarUrlObj),
        options: localVarRequestOptions,
      };
    },
    /**
     *
     * @summary Delete the model version
     * @param {string} name
     * @param {number} version
     * @param {*} [options] Override http request option.
     * @throws {RequiredError}
     */
    deleteModelVersion: async (name: string, version: number, options: any = {}): Promise<RequestArgs> => {
      // verify required parameter 'name' is not null or undefined
      if (name === null || name === undefined) {
        throw new RequiredError(
          "name",
          "Required parameter name was null or undefined when calling deleteModelVersion."
        );
      }
      // verify required parameter 'version' is not null or undefined
      if (version === null || version === undefined) {
        throw new RequiredError(
          "version",
          "Required parameter version was null or undefined when calling deleteModelVersion."
        );
      }
      const localVarPath = `/v1/model-version/{name}/{version}`
        .replace(`{${"name"}}`, encodeURIComponent(String(name)))
        .replace(`{${"version"}}`, encodeURIComponent(String(version)));
      const localVarUrlObj = globalImportUrl.parse(localVarPath, true);
      let baseOptions;
      if (configuration) {
        baseOptions = configuration.baseOptions;
      }
      const localVarRequestOptions = { method: "DELETE", ...baseOptions, ...options };
      const localVarHeaderParameter = {} as any;
      const localVarQueryParameter = {} as any;

      localVarUrlObj.query = { ...localVarUrlObj.query, ...localVarQueryParameter, ...options.query };
      // fix override query string Detail: https://stackoverflow.com/a/7517673/1077943
      delete localVarUrlObj.search;
      let headersFromBaseOptions = baseOptions && baseOptions.headers ? baseOptions.headers : {};
      localVarRequestOptions.headers = { ...localVarHeaderParameter, ...headersFromBaseOptions, ...options.headers };

      return {
        url: globalImportUrl.format(localVarUrlObj),
        options: localVarRequestOptions,
      };
    },
    /**
     *
     * @summary Delete a model version tag instance
     * @param {string} [name]
     * @param {string} [version]
     * @param {string} [tag]
     * @param {*} [options] Override http request option.
     * @throws {RequiredError}
     */
    deleteModelVersionTag: async (
      name?: string,
      version?: string,
      tag?: string,
      options: any = {}
    ): Promise<RequestArgs> => {
      const localVarPath = `/v1/model-version/tag`;
      const localVarUrlObj = globalImportUrl.parse(localVarPath, true);
      let baseOptions;
      if (configuration) {
        baseOptions = configuration.baseOptions;
      }
      const localVarRequestOptions = { method: "DELETE", ...baseOptions, ...options };
      const localVarHeaderParameter = {} as any;
      const localVarQueryParameter = {} as any;

      if (name !== undefined) {
        localVarQueryParameter["name"] = name;
      }

      if (version !== undefined) {
        localVarQueryParameter["version"] = version;
      }

      if (tag !== undefined) {
        localVarQueryParameter["tag"] = tag;
      }

      localVarUrlObj.query = { ...localVarUrlObj.query, ...localVarQueryParameter, ...options.query };
      // fix override query string Detail: https://stackoverflow.com/a/7517673/1077943
      delete localVarUrlObj.search;
      let headersFromBaseOptions = baseOptions && baseOptions.headers ? baseOptions.headers : {};
      localVarRequestOptions.headers = { ...localVarHeaderParameter, ...headersFromBaseOptions, ...options.headers };

      return {
        url: globalImportUrl.format(localVarUrlObj),
        options: localVarRequestOptions,
      };
    },
    /**
     *
     * @summary Get detailed info about the model version
     * @param {string} name
     * @param {number} version
     * @param {*} [options] Override http request option.
     * @throws {RequiredError}
     */
    getModelVersion: async (name: string, version: number, options: any = {}): Promise<RequestArgs> => {
      // verify required parameter 'name' is not null or undefined
      if (name === null || name === undefined) {
        throw new RequiredError("name", "Required parameter name was null or undefined when calling getModelVersion.");
      }
      // verify required parameter 'version' is not null or undefined
      if (version === null || version === undefined) {
        throw new RequiredError(
          "version",
          "Required parameter version was null or undefined when calling getModelVersion."
        );
      }
      const localVarPath = `/v1/model-version/{name}/{version}`
        .replace(`{${"name"}}`, encodeURIComponent(String(name)))
        .replace(`{${"version"}}`, encodeURIComponent(String(version)));
      const localVarUrlObj = globalImportUrl.parse(localVarPath, true);
      let baseOptions;
      if (configuration) {
        baseOptions = configuration.baseOptions;
      }
      const localVarRequestOptions = { method: "GET", ...baseOptions, ...options };
      const localVarHeaderParameter = {} as any;
      const localVarQueryParameter = {} as any;

      localVarUrlObj.query = { ...localVarUrlObj.query, ...localVarQueryParameter, ...options.query };
      // fix override query string Detail: https://stackoverflow.com/a/7517673/1077943
      delete localVarUrlObj.search;
      let headersFromBaseOptions = baseOptions && baseOptions.headers ? baseOptions.headers : {};
      localVarRequestOptions.headers = { ...localVarHeaderParameter, ...headersFromBaseOptions, ...options.headers };

      return {
        url: globalImportUrl.format(localVarUrlObj),
        options: localVarRequestOptions,
      };
    },
    /**
     *
     * @summary List model versions
     * @param {string} name
     * @param {*} [options] Override http request option.
     * @throws {RequiredError}
     */
    listModelVersions: async (name: string, options: any = {}): Promise<RequestArgs> => {
      // verify required parameter 'name' is not null or undefined
      if (name === null || name === undefined) {
        throw new RequiredError(
          "name",
          "Required parameter name was null or undefined when calling listModelVersions."
        );
      }
      const localVarPath = `/v1/model-version/{name}`.replace(`{${"name"}}`, encodeURIComponent(String(name)));
      const localVarUrlObj = globalImportUrl.parse(localVarPath, true);
      let baseOptions;
      if (configuration) {
        baseOptions = configuration.baseOptions;
      }
      const localVarRequestOptions = { method: "GET", ...baseOptions, ...options };
      const localVarHeaderParameter = {} as any;
      const localVarQueryParameter = {} as any;

      localVarUrlObj.query = { ...localVarUrlObj.query, ...localVarQueryParameter, ...options.query };
      // fix override query string Detail: https://stackoverflow.com/a/7517673/1077943
      delete localVarUrlObj.search;
      let headersFromBaseOptions = baseOptions && baseOptions.headers ? baseOptions.headers : {};
      localVarRequestOptions.headers = { ...localVarHeaderParameter, ...headersFromBaseOptions, ...options.headers };

      return {
        url: globalImportUrl.format(localVarUrlObj),
        options: localVarRequestOptions,
      };
    },
    /**
     * Return the Pong message for test the connectivity
     * @summary Ping submarine server
     * @param {*} [options] Override http request option.
     * @throws {RequiredError}
     */
    ping1: async (options: any = {}): Promise<RequestArgs> => {
      const localVarPath = `/v1/model-version/ping`;
      const localVarUrlObj = globalImportUrl.parse(localVarPath, true);
      let baseOptions;
      if (configuration) {
        baseOptions = configuration.baseOptions;
      }
      const localVarRequestOptions = { method: "GET", ...baseOptions, ...options };
      const localVarHeaderParameter = {} as any;
      const localVarQueryParameter = {} as any;

      localVarUrlObj.query = { ...localVarUrlObj.query, ...localVarQueryParameter, ...options.query };
      // fix override query string Detail: https://stackoverflow.com/a/7517673/1077943
      delete localVarUrlObj.search;
      let headersFromBaseOptions = baseOptions && baseOptions.headers ? baseOptions.headers : {};
      localVarRequestOptions.headers = { ...localVarHeaderParameter, ...headersFromBaseOptions, ...options.headers };

      return {
        url: globalImportUrl.format(localVarUrlObj),
        options: localVarRequestOptions,
      };
    },
    /**
     *
     * @summary Update the model version
     * @param {ModelVersionEntity} [modelVersionEntity]
     * @param {*} [options] Override http request option.
     * @throws {RequiredError}
     */
    updateModelVersion: async (modelVersionEntity?: ModelVersionEntity, options: any = {}): Promise<RequestArgs> => {
      const localVarPath = `/v1/model-version`;
      const localVarUrlObj = globalImportUrl.parse(localVarPath, true);
      let baseOptions;
      if (configuration) {
        baseOptions = configuration.baseOptions;
      }
      const localVarRequestOptions = { method: "PATCH", ...baseOptions, ...options };
      const localVarHeaderParameter = {} as any;
      const localVarQueryParameter = {} as any;

      localVarHeaderParameter["Content-Type"] = "application/json";

      localVarUrlObj.query = { ...localVarUrlObj.query, ...localVarQueryParameter, ...options.query };
      // fix override query string Detail: https://stackoverflow.com/a/7517673/1077943
      delete localVarUrlObj.search;
      let headersFromBaseOptions = baseOptions && baseOptions.headers ? baseOptions.headers : {};
      localVarRequestOptions.headers = { ...localVarHeaderParameter, ...headersFromBaseOptions, ...options.headers };
      const needsSerialization =
        typeof modelVersionEntity !== "string" || localVarRequestOptions.headers["Content-Type"] === "application/json";
      localVarRequestOptions.data = needsSerialization
        ? JSON.stringify(modelVersionEntity !== undefined ? modelVersionEntity : {})
        : modelVersionEntity || "";

      return {
        url: globalImportUrl.format(localVarUrlObj),
        options: localVarRequestOptions,
      };
    },
  };
};

/**
 * ModelVersionApi - functional programming interface
 * @export
 */
export const ModelVersionApiFp = function (configuration?: Configuration) {
  return {
    /**
     *
     * @summary Create a model version instance
     * @param {string} [baseDir]
     * @param {ModelVersionEntity} [modelVersionEntity]
     * @param {*} [options] Override http request option.
     * @throws {RequiredError}
     */
    async createModelVersion(
      baseDir?: string,
      modelVersionEntity?: ModelVersionEntity,
      options?: any
    ): Promise<(axios?: AxiosInstance, basePath?: string) => AxiosPromise<JsonResponse>> {
      const localVarAxiosArgs = await ModelVersionApiAxiosParamCreator(configuration).createModelVersion(
        baseDir,
        modelVersionEntity,
        options
      );
      return (axios: AxiosInstance = globalAxios, basePath: string = BASE_PATH) => {
        const axiosRequestArgs = { ...localVarAxiosArgs.options, url: basePath + localVarAxiosArgs.url };
        return axios.request(axiosRequestArgs);
      };
    },
    /**
     *
     * @summary Create a model version tag instance
     * @param {string} [name]
     * @param {string} [version]
     * @param {string} [tag]
     * @param {*} [options] Override http request option.
     * @throws {RequiredError}
     */
    async createModelVersionTag(
      name?: string,
      version?: string,
      tag?: string,
      options?: any
    ): Promise<(axios?: AxiosInstance, basePath?: string) => AxiosPromise<JsonResponse>> {
      const localVarAxiosArgs = await ModelVersionApiAxiosParamCreator(configuration).createModelVersionTag(
        name,
        version,
        tag,
        options
      );
      return (axios: AxiosInstance = globalAxios, basePath: string = BASE_PATH) => {
        const axiosRequestArgs = { ...localVarAxiosArgs.options, url: basePath + localVarAxiosArgs.url };
        return axios.request(axiosRequestArgs);
      };
    },
    /**
     *
     * @summary Delete the model version
     * @param {string} name
     * @param {number} version
     * @param {*} [options] Override http request option.
     * @throws {RequiredError}
     */
    async deleteModelVersion(
      name: string,
      version: number,
      options?: any
    ): Promise<(axios?: AxiosInstance, basePath?: string) => AxiosPromise<JsonResponse>> {
      const localVarAxiosArgs = await ModelVersionApiAxiosParamCreator(configuration).deleteModelVersion(
        name,
        version,
        options
      );
      return (axios: AxiosInstance = globalAxios, basePath: string = BASE_PATH) => {
        const axiosRequestArgs = { ...localVarAxiosArgs.options, url: basePath + localVarAxiosArgs.url };
        return axios.request(axiosRequestArgs);
      };
    },
    /**
     *
     * @summary Delete a model version tag instance
     * @param {string} [name]
     * @param {string} [version]
     * @param {string} [tag]
     * @param {*} [options] Override http request option.
     * @throws {RequiredError}
     */
    async deleteModelVersionTag(
      name?: string,
      version?: string,
      tag?: string,
      options?: any
    ): Promise<(axios?: AxiosInstance, basePath?: string) => AxiosPromise<JsonResponse>> {
      const localVarAxiosArgs = await ModelVersionApiAxiosParamCreator(configuration).deleteModelVersionTag(
        name,
        version,
        tag,
        options
      );
      return (axios: AxiosInstance = globalAxios, basePath: string = BASE_PATH) => {
        const axiosRequestArgs = { ...localVarAxiosArgs.options, url: basePath + localVarAxiosArgs.url };
        return axios.request(axiosRequestArgs);
      };
    },
    /**
     *
     * @summary Get detailed info about the model version
     * @param {string} name
     * @param {number} version
     * @param {*} [options] Override http request option.
     * @throws {RequiredError}
     */
    async getModelVersion(
      name: string,
      version: number,
      options?: any
    ): Promise<(axios?: AxiosInstance, basePath?: string) => AxiosPromise<JsonResponse>> {
      const localVarAxiosArgs = await ModelVersionApiAxiosParamCreator(configuration).getModelVersion(
        name,
        version,
        options
      );
      return (axios: AxiosInstance = globalAxios, basePath: string = BASE_PATH) => {
        const axiosRequestArgs = { ...localVarAxiosArgs.options, url: basePath + localVarAxiosArgs.url };
        return axios.request(axiosRequestArgs);
      };
    },
    /**
     *
     * @summary List model versions
     * @param {string} name
     * @param {*} [options] Override http request option.
     * @throws {RequiredError}
     */
    async listModelVersions(
      name: string,
      options?: any
    ): Promise<(axios?: AxiosInstance, basePath?: string) => AxiosPromise<JsonResponse>> {
      const localVarAxiosArgs = await ModelVersionApiAxiosParamCreator(configuration).listModelVersions(name, options);
      return (axios: AxiosInstance = globalAxios, basePath: string = BASE_PATH) => {
        const axiosRequestArgs = { ...localVarAxiosArgs.options, url: basePath + localVarAxiosArgs.url };
        return axios.request(axiosRequestArgs);
      };
    },
    /**
     * Return the Pong message for test the connectivity
     * @summary Ping submarine server
     * @param {*} [options] Override http request option.
     * @throws {RequiredError}
     */
    async ping1(options?: any): Promise<(axios?: AxiosInstance, basePath?: string) => AxiosPromise<string>> {
      const localVarAxiosArgs = await ModelVersionApiAxiosParamCreator(configuration).ping1(options);
      return (axios: AxiosInstance = globalAxios, basePath: string = BASE_PATH) => {
        const axiosRequestArgs = { ...localVarAxiosArgs.options, url: basePath + localVarAxiosArgs.url };
        return axios.request(axiosRequestArgs);
      };
    },
    /**
     *
     * @summary Update the model version
     * @param {ModelVersionEntity} [modelVersionEntity]
     * @param {*} [options] Override http request option.
     * @throws {RequiredError}
     */
    async updateModelVersion(
      modelVersionEntity?: ModelVersionEntity,
      options?: any
    ): Promise<(axios?: AxiosInstance, basePath?: string) => AxiosPromise<JsonResponse>> {
      const localVarAxiosArgs = await ModelVersionApiAxiosParamCreator(configuration).updateModelVersion(
        modelVersionEntity,
        options
      );
      return (axios: AxiosInstance = globalAxios, basePath: string = BASE_PATH) => {
        const axiosRequestArgs = { ...localVarAxiosArgs.options, url: basePath + localVarAxiosArgs.url };
        return axios.request(axiosRequestArgs);
      };
    },
  };
};

/**
 * ModelVersionApi - factory interface
 * @export
 */
export const ModelVersionApiFactory = function (
  configuration?: Configuration,
  basePath?: string,
  axios?: AxiosInstance
) {
  return {
    /**
     *
     * @summary Create a model version instance
     * @param {string} [baseDir]
     * @param {ModelVersionEntity} [modelVersionEntity]
     * @param {*} [options] Override http request option.
     * @throws {RequiredError}
     */
    createModelVersion(
      baseDir?: string,
      modelVersionEntity?: ModelVersionEntity,
      options?: any
    ): AxiosPromise<JsonResponse> {
      return ModelVersionApiFp(configuration)
        .createModelVersion(baseDir, modelVersionEntity, options)
        .then((request) => request(axios, basePath));
    },
    /**
     *
     * @summary Create a model version tag instance
     * @param {string} [name]
     * @param {string} [version]
     * @param {string} [tag]
     * @param {*} [options] Override http request option.
     * @throws {RequiredError}
     */
    createModelVersionTag(name?: string, version?: string, tag?: string, options?: any): AxiosPromise<JsonResponse> {
      return ModelVersionApiFp(configuration)
        .createModelVersionTag(name, version, tag, options)
        .then((request) => request(axios, basePath));
    },
    /**
     *
     * @summary Delete the model version
     * @param {string} name
     * @param {number} version
     * @param {*} [options] Override http request option.
     * @throws {RequiredError}
     */
    deleteModelVersion(name: string, version: number, options?: any): AxiosPromise<JsonResponse> {
      return ModelVersionApiFp(configuration)
        .deleteModelVersion(name, version, options)
        .then((request) => request(axios, basePath));
    },
    /**
     *
     * @summary Delete a model version tag instance
     * @param {string} [name]
     * @param {string} [version]
     * @param {string} [tag]
     * @param {*} [options] Override http request option.
     * @throws {RequiredError}
     */
    deleteModelVersionTag(name?: string, version?: string, tag?: string, options?: any): AxiosPromise<JsonResponse> {
      return ModelVersionApiFp(configuration)
        .deleteModelVersionTag(name, version, tag, options)
        .then((request) => request(axios, basePath));
    },
    /**
     *
     * @summary Get detailed info about the model version
     * @param {string} name
     * @param {number} version
     * @param {*} [options] Override http request option.
     * @throws {RequiredError}
     */
    getModelVersion(name: string, version: number, options?: any): AxiosPromise<JsonResponse> {
      return ModelVersionApiFp(configuration)
        .getModelVersion(name, version, options)
        .then((request) => request(axios, basePath));
    },
    /**
     *
     * @summary List model versions
     * @param {string} name
     * @param {*} [options] Override http request option.
     * @throws {RequiredError}
     */
    listModelVersions(name: string, options?: any): AxiosPromise<JsonResponse> {
      return ModelVersionApiFp(configuration)
        .listModelVersions(name, options)
        .then((request) => request(axios, basePath));
    },
    /**
     * Return the Pong message for test the connectivity
     * @summary Ping submarine server
     * @param {*} [options] Override http request option.
     * @throws {RequiredError}
     */
    ping1(options?: any): AxiosPromise<string> {
      return ModelVersionApiFp(configuration)
        .ping1(options)
        .then((request) => request(axios, basePath));
    },
    /**
     *
     * @summary Update the model version
     * @param {ModelVersionEntity} [modelVersionEntity]
     * @param {*} [options] Override http request option.
     * @throws {RequiredError}
     */
    updateModelVersion(modelVersionEntity?: ModelVersionEntity, options?: any): AxiosPromise<JsonResponse> {
      return ModelVersionApiFp(configuration)
        .updateModelVersion(modelVersionEntity, options)
        .then((request) => request(axios, basePath));
    },
  };
};

/**
 * ModelVersionApi - object-oriented interface
 * @export
 * @class ModelVersionApi
 * @extends {BaseAPI}
 */
export class ModelVersionApi extends BaseAPI {
  /**
   *
   * @summary Create a model version instance
   * @param {string} [baseDir]
   * @param {ModelVersionEntity} [modelVersionEntity]
   * @param {*} [options] Override http request option.
   * @throws {RequiredError}
   * @memberof ModelVersionApi
   */
  public createModelVersion(baseDir?: string, modelVersionEntity?: ModelVersionEntity, options?: any) {
    return ModelVersionApiFp(this.configuration)
      .createModelVersion(baseDir, modelVersionEntity, options)
      .then((request) => request(this.axios, this.basePath));
  }

  /**
   *
   * @summary Create a model version tag instance
   * @param {string} [name]
   * @param {string} [version]
   * @param {string} [tag]
   * @param {*} [options] Override http request option.
   * @throws {RequiredError}
   * @memberof ModelVersionApi
   */
  public createModelVersionTag(name?: string, version?: string, tag?: string, options?: any) {
    return ModelVersionApiFp(this.configuration)
      .createModelVersionTag(name, version, tag, options)
      .then((request) => request(this.axios, this.basePath));
  }

  /**
   *
   * @summary Delete the model version
   * @param {string} name
   * @param {number} version
   * @param {*} [options] Override http request option.
   * @throws {RequiredError}
   * @memberof ModelVersionApi
   */
  public deleteModelVersion(name: string, version: number, options?: any) {
    return ModelVersionApiFp(this.configuration)
      .deleteModelVersion(name, version, options)
      .then((request) => request(this.axios, this.basePath));
  }

  /**
   *
   * @summary Delete a model version tag instance
   * @param {string} [name]
   * @param {string} [version]
   * @param {string} [tag]
   * @param {*} [options] Override http request option.
   * @throws {RequiredError}
   * @memberof ModelVersionApi
   */
  public deleteModelVersionTag(name?: string, version?: string, tag?: string, options?: any) {
    return ModelVersionApiFp(this.configuration)
      .deleteModelVersionTag(name, version, tag, options)
      .then((request) => request(this.axios, this.basePath));
  }

  /**
   *
   * @summary Get detailed info about the model version
   * @param {string} name
   * @param {number} version
   * @param {*} [options] Override http request option.
   * @throws {RequiredError}
   * @memberof ModelVersionApi
   */
  public getModelVersion(name: string, version: number, options?: any) {
    return ModelVersionApiFp(this.configuration)
      .getModelVersion(name, version, options)
      .then((request) => request(this.axios, this.basePath));
  }

  /**
   *
   * @summary List model versions
   * @param {string} name
   * @param {*} [options] Override http request option.
   * @throws {RequiredError}
   * @memberof ModelVersionApi
   */
  public listModelVersions(name: string, options?: any) {
    return ModelVersionApiFp(this.configuration)
      .listModelVersions(name, options)
      .then((request) => request(this.axios, this.basePath));
  }

  /**
   * Return the Pong message for test the connectivity
   * @summary Ping submarine server
   * @param {*} [options] Override http request option.
   * @throws {RequiredError}
   * @memberof ModelVersionApi
   */
  public ping1(options?: any) {
    return ModelVersionApiFp(this.configuration)
      .ping1(options)
      .then((request) => request(this.axios, this.basePath));
  }

  /**
   *
   * @summary Update the model version
   * @param {ModelVersionEntity} [modelVersionEntity]
   * @param {*} [options] Override http request option.
   * @throws {RequiredError}
   * @memberof ModelVersionApi
   */
  public updateModelVersion(modelVersionEntity?: ModelVersionEntity, options?: any) {
    return ModelVersionApiFp(this.configuration)
      .updateModelVersion(modelVersionEntity, options)
      .then((request) => request(this.axios, this.basePath));
  }
}

/**
 * NotebookApi - axios parameter creator
 * @export
 */
export const NotebookApiAxiosParamCreator = function (configuration?: Configuration) {
  return {
    /**
     *
     * @summary Create a notebook instance
     * @param {NotebookSpec} [notebookSpec]
     * @param {*} [options] Override http request option.
     * @throws {RequiredError}
     */
    createNotebook: async (notebookSpec?: NotebookSpec, options: any = {}): Promise<RequestArgs> => {
      const localVarPath = `/v1/notebook`;
      const localVarUrlObj = globalImportUrl.parse(localVarPath, true);
      let baseOptions;
      if (configuration) {
        baseOptions = configuration.baseOptions;
      }
      const localVarRequestOptions = { method: "POST", ...baseOptions, ...options };
      const localVarHeaderParameter = {} as any;
      const localVarQueryParameter = {} as any;

      localVarHeaderParameter["Content-Type"] = "application/yaml";

      localVarUrlObj.query = { ...localVarUrlObj.query, ...localVarQueryParameter, ...options.query };
      // fix override query string Detail: https://stackoverflow.com/a/7517673/1077943
      delete localVarUrlObj.search;
      let headersFromBaseOptions = baseOptions && baseOptions.headers ? baseOptions.headers : {};
      localVarRequestOptions.headers = { ...localVarHeaderParameter, ...headersFromBaseOptions, ...options.headers };
      const needsSerialization =
        typeof notebookSpec !== "string" || localVarRequestOptions.headers["Content-Type"] === "application/json";
      localVarRequestOptions.data = needsSerialization
        ? JSON.stringify(notebookSpec !== undefined ? notebookSpec : {})
        : notebookSpec || "";

      return {
        url: globalImportUrl.format(localVarUrlObj),
        options: localVarRequestOptions,
      };
    },
    /**
     *
     * @summary Delete the notebook
     * @param {string} id
     * @param {*} [options] Override http request option.
     * @throws {RequiredError}
     */
    deleteNotebook: async (id: string, options: any = {}): Promise<RequestArgs> => {
      // verify required parameter 'id' is not null or undefined
      if (id === null || id === undefined) {
        throw new RequiredError("id", "Required parameter id was null or undefined when calling deleteNotebook.");
      }
      const localVarPath = `/v1/notebook/{id}`.replace(`{${"id"}}`, encodeURIComponent(String(id)));
      const localVarUrlObj = globalImportUrl.parse(localVarPath, true);
      let baseOptions;
      if (configuration) {
        baseOptions = configuration.baseOptions;
      }
      const localVarRequestOptions = { method: "DELETE", ...baseOptions, ...options };
      const localVarHeaderParameter = {} as any;
      const localVarQueryParameter = {} as any;

      localVarUrlObj.query = { ...localVarUrlObj.query, ...localVarQueryParameter, ...options.query };
      // fix override query string Detail: https://stackoverflow.com/a/7517673/1077943
      delete localVarUrlObj.search;
      let headersFromBaseOptions = baseOptions && baseOptions.headers ? baseOptions.headers : {};
      localVarRequestOptions.headers = { ...localVarHeaderParameter, ...headersFromBaseOptions, ...options.headers };

      return {
        url: globalImportUrl.format(localVarUrlObj),
        options: localVarRequestOptions,
      };
    },
    /**
     *
     * @summary Get detailed info about the notebook
     * @param {string} id
     * @param {*} [options] Override http request option.
     * @throws {RequiredError}
     */
    getNotebook: async (id: string, options: any = {}): Promise<RequestArgs> => {
      // verify required parameter 'id' is not null or undefined
      if (id === null || id === undefined) {
        throw new RequiredError("id", "Required parameter id was null or undefined when calling getNotebook.");
      }
      const localVarPath = `/v1/notebook/{id}`.replace(`{${"id"}}`, encodeURIComponent(String(id)));
      const localVarUrlObj = globalImportUrl.parse(localVarPath, true);
      let baseOptions;
      if (configuration) {
        baseOptions = configuration.baseOptions;
      }
      const localVarRequestOptions = { method: "GET", ...baseOptions, ...options };
      const localVarHeaderParameter = {} as any;
      const localVarQueryParameter = {} as any;

      localVarUrlObj.query = { ...localVarUrlObj.query, ...localVarQueryParameter, ...options.query };
      // fix override query string Detail: https://stackoverflow.com/a/7517673/1077943
      delete localVarUrlObj.search;
      let headersFromBaseOptions = baseOptions && baseOptions.headers ? baseOptions.headers : {};
      localVarRequestOptions.headers = { ...localVarHeaderParameter, ...headersFromBaseOptions, ...options.headers };

      return {
        url: globalImportUrl.format(localVarUrlObj),
        options: localVarRequestOptions,
      };
    },
    /**
     *
     * @summary List notebooks
     * @param {string} [id]
     * @param {*} [options] Override http request option.
     * @throws {RequiredError}
     */
    listNotebooks: async (id?: string, options: any = {}): Promise<RequestArgs> => {
      const localVarPath = `/v1/notebook`;
      const localVarUrlObj = globalImportUrl.parse(localVarPath, true);
      let baseOptions;
      if (configuration) {
        baseOptions = configuration.baseOptions;
      }
      const localVarRequestOptions = { method: "GET", ...baseOptions, ...options };
      const localVarHeaderParameter = {} as any;
      const localVarQueryParameter = {} as any;

      if (id !== undefined) {
        localVarQueryParameter["id"] = id;
      }

      localVarUrlObj.query = { ...localVarUrlObj.query, ...localVarQueryParameter, ...options.query };
      // fix override query string Detail: https://stackoverflow.com/a/7517673/1077943
      delete localVarUrlObj.search;
      let headersFromBaseOptions = baseOptions && baseOptions.headers ? baseOptions.headers : {};
      localVarRequestOptions.headers = { ...localVarHeaderParameter, ...headersFromBaseOptions, ...options.headers };

      return {
        url: globalImportUrl.format(localVarUrlObj),
        options: localVarRequestOptions,
      };
    },
    /**
     * Return the Pong message for test the connectivity
     * @summary Ping submarine server
     * @param {*} [options] Override http request option.
     * @throws {RequiredError}
     */
    ping2: async (options: any = {}): Promise<RequestArgs> => {
      const localVarPath = `/v1/notebook/ping`;
      const localVarUrlObj = globalImportUrl.parse(localVarPath, true);
      let baseOptions;
      if (configuration) {
        baseOptions = configuration.baseOptions;
      }
      const localVarRequestOptions = { method: "GET", ...baseOptions, ...options };
      const localVarHeaderParameter = {} as any;
      const localVarQueryParameter = {} as any;

      localVarUrlObj.query = { ...localVarUrlObj.query, ...localVarQueryParameter, ...options.query };
      // fix override query string Detail: https://stackoverflow.com/a/7517673/1077943
      delete localVarUrlObj.search;
      let headersFromBaseOptions = baseOptions && baseOptions.headers ? baseOptions.headers : {};
      localVarRequestOptions.headers = { ...localVarHeaderParameter, ...headersFromBaseOptions, ...options.headers };

      return {
        url: globalImportUrl.format(localVarUrlObj),
        options: localVarRequestOptions,
      };
    },
  };
};

/**
 * NotebookApi - functional programming interface
 * @export
 */
export const NotebookApiFp = function (configuration?: Configuration) {
  return {
    /**
     *
     * @summary Create a notebook instance
     * @param {NotebookSpec} [notebookSpec]
     * @param {*} [options] Override http request option.
     * @throws {RequiredError}
     */
    async createNotebook(
      notebookSpec?: NotebookSpec,
      options?: any
    ): Promise<(axios?: AxiosInstance, basePath?: string) => AxiosPromise<JsonResponse>> {
      const localVarAxiosArgs = await NotebookApiAxiosParamCreator(configuration).createNotebook(notebookSpec, options);
      return (axios: AxiosInstance = globalAxios, basePath: string = BASE_PATH) => {
        const axiosRequestArgs = { ...localVarAxiosArgs.options, url: basePath + localVarAxiosArgs.url };
        return axios.request(axiosRequestArgs);
      };
    },
    /**
     *
     * @summary Delete the notebook
     * @param {string} id
     * @param {*} [options] Override http request option.
     * @throws {RequiredError}
     */
    async deleteNotebook(
      id: string,
      options?: any
    ): Promise<(axios?: AxiosInstance, basePath?: string) => AxiosPromise<JsonResponse>> {
      const localVarAxiosArgs = await NotebookApiAxiosParamCreator(configuration).deleteNotebook(id, options);
      return (axios: AxiosInstance = globalAxios, basePath: string = BASE_PATH) => {
        const axiosRequestArgs = { ...localVarAxiosArgs.options, url: basePath + localVarAxiosArgs.url };
        return axios.request(axiosRequestArgs);
      };
    },
    /**
     *
     * @summary Get detailed info about the notebook
     * @param {string} id
     * @param {*} [options] Override http request option.
     * @throws {RequiredError}
     */
    async getNotebook(
      id: string,
      options?: any
    ): Promise<(axios?: AxiosInstance, basePath?: string) => AxiosPromise<JsonResponse>> {
      const localVarAxiosArgs = await NotebookApiAxiosParamCreator(configuration).getNotebook(id, options);
      return (axios: AxiosInstance = globalAxios, basePath: string = BASE_PATH) => {
        const axiosRequestArgs = { ...localVarAxiosArgs.options, url: basePath + localVarAxiosArgs.url };
        return axios.request(axiosRequestArgs);
      };
    },
    /**
     *
     * @summary List notebooks
     * @param {string} [id]
     * @param {*} [options] Override http request option.
     * @throws {RequiredError}
     */
    async listNotebooks(
      id?: string,
      options?: any
    ): Promise<(axios?: AxiosInstance, basePath?: string) => AxiosPromise<JsonResponse>> {
      const localVarAxiosArgs = await NotebookApiAxiosParamCreator(configuration).listNotebooks(id, options);
      return (axios: AxiosInstance = globalAxios, basePath: string = BASE_PATH) => {
        const axiosRequestArgs = { ...localVarAxiosArgs.options, url: basePath + localVarAxiosArgs.url };
        return axios.request(axiosRequestArgs);
      };
    },
    /**
     * Return the Pong message for test the connectivity
     * @summary Ping submarine server
     * @param {*} [options] Override http request option.
     * @throws {RequiredError}
     */
    async ping2(options?: any): Promise<(axios?: AxiosInstance, basePath?: string) => AxiosPromise<string>> {
      const localVarAxiosArgs = await NotebookApiAxiosParamCreator(configuration).ping2(options);
      return (axios: AxiosInstance = globalAxios, basePath: string = BASE_PATH) => {
        const axiosRequestArgs = { ...localVarAxiosArgs.options, url: basePath + localVarAxiosArgs.url };
        return axios.request(axiosRequestArgs);
      };
    },
  };
};

/**
 * NotebookApi - factory interface
 * @export
 */
export const NotebookApiFactory = function (configuration?: Configuration, basePath?: string, axios?: AxiosInstance) {
  return {
    /**
     *
     * @summary Create a notebook instance
     * @param {NotebookSpec} [notebookSpec]
     * @param {*} [options] Override http request option.
     * @throws {RequiredError}
     */
    createNotebook(notebookSpec?: NotebookSpec, options?: any): AxiosPromise<JsonResponse> {
      return NotebookApiFp(configuration)
        .createNotebook(notebookSpec, options)
        .then((request) => request(axios, basePath));
    },
    /**
     *
     * @summary Delete the notebook
     * @param {string} id
     * @param {*} [options] Override http request option.
     * @throws {RequiredError}
     */
    deleteNotebook(id: string, options?: any): AxiosPromise<JsonResponse> {
      return NotebookApiFp(configuration)
        .deleteNotebook(id, options)
        .then((request) => request(axios, basePath));
    },
    /**
     *
     * @summary Get detailed info about the notebook
     * @param {string} id
     * @param {*} [options] Override http request option.
     * @throws {RequiredError}
     */
    getNotebook(id: string, options?: any): AxiosPromise<JsonResponse> {
      return NotebookApiFp(configuration)
        .getNotebook(id, options)
        .then((request) => request(axios, basePath));
    },
    /**
     *
     * @summary List notebooks
     * @param {string} [id]
     * @param {*} [options] Override http request option.
     * @throws {RequiredError}
     */
    listNotebooks(id?: string, options?: any): AxiosPromise<JsonResponse> {
      return NotebookApiFp(configuration)
        .listNotebooks(id, options)
        .then((request) => request(axios, basePath));
    },
    /**
     * Return the Pong message for test the connectivity
     * @summary Ping submarine server
     * @param {*} [options] Override http request option.
     * @throws {RequiredError}
     */
    ping2(options?: any): AxiosPromise<string> {
      return NotebookApiFp(configuration)
        .ping2(options)
        .then((request) => request(axios, basePath));
    },
  };
};

/**
 * NotebookApi - object-oriented interface
 * @export
 * @class NotebookApi
 * @extends {BaseAPI}
 */
export class NotebookApi extends BaseAPI {
  /**
   *
   * @summary Create a notebook instance
   * @param {NotebookSpec} [notebookSpec]
   * @param {*} [options] Override http request option.
   * @throws {RequiredError}
   * @memberof NotebookApi
   */
  public createNotebook(notebookSpec?: NotebookSpec, options?: any) {
    return NotebookApiFp(this.configuration)
      .createNotebook(notebookSpec, options)
      .then((request) => request(this.axios, this.basePath));
  }

  /**
   *
   * @summary Delete the notebook
   * @param {string} id
   * @param {*} [options] Override http request option.
   * @throws {RequiredError}
   * @memberof NotebookApi
   */
  public deleteNotebook(id: string, options?: any) {
    return NotebookApiFp(this.configuration)
      .deleteNotebook(id, options)
      .then((request) => request(this.axios, this.basePath));
  }

  /**
   *
   * @summary Get detailed info about the notebook
   * @param {string} id
   * @param {*} [options] Override http request option.
   * @throws {RequiredError}
   * @memberof NotebookApi
   */
  public getNotebook(id: string, options?: any) {
    return NotebookApiFp(this.configuration)
      .getNotebook(id, options)
      .then((request) => request(this.axios, this.basePath));
  }

  /**
   *
   * @summary List notebooks
   * @param {string} [id]
   * @param {*} [options] Override http request option.
   * @throws {RequiredError}
   * @memberof NotebookApi
   */
  public listNotebooks(id?: string, options?: any) {
    return NotebookApiFp(this.configuration)
      .listNotebooks(id, options)
      .then((request) => request(this.axios, this.basePath));
  }

  /**
   * Return the Pong message for test the connectivity
   * @summary Ping submarine server
   * @param {*} [options] Override http request option.
   * @throws {RequiredError}
   * @memberof NotebookApi
   */
  public ping2(options?: any) {
    return NotebookApiFp(this.configuration)
      .ping2(options)
      .then((request) => request(this.axios, this.basePath));
  }
}

/**
 * RegisteredModelApi - axios parameter creator
 * @export
 */
export const RegisteredModelApiAxiosParamCreator = function (configuration?: Configuration) {
  return {
    /**
     *
     * @summary Create a registered model instance
     * @param {RegisteredModelEntity} [registeredModelEntity]
     * @param {*} [options] Override http request option.
     * @throws {RequiredError}
     */
    createRegisteredModel: async (
      registeredModelEntity?: RegisteredModelEntity,
      options: any = {}
    ): Promise<RequestArgs> => {
      const localVarPath = `/v1/registered-model`;
      const localVarUrlObj = globalImportUrl.parse(localVarPath, true);
      let baseOptions;
      if (configuration) {
        baseOptions = configuration.baseOptions;
      }
      const localVarRequestOptions = { method: "POST", ...baseOptions, ...options };
      const localVarHeaderParameter = {} as any;
      const localVarQueryParameter = {} as any;

      localVarHeaderParameter["Content-Type"] = "application/yaml";

      localVarUrlObj.query = { ...localVarUrlObj.query, ...localVarQueryParameter, ...options.query };
      // fix override query string Detail: https://stackoverflow.com/a/7517673/1077943
      delete localVarUrlObj.search;
      let headersFromBaseOptions = baseOptions && baseOptions.headers ? baseOptions.headers : {};
      localVarRequestOptions.headers = { ...localVarHeaderParameter, ...headersFromBaseOptions, ...options.headers };
      const needsSerialization =
        typeof registeredModelEntity !== "string" ||
        localVarRequestOptions.headers["Content-Type"] === "application/json";
      localVarRequestOptions.data = needsSerialization
        ? JSON.stringify(registeredModelEntity !== undefined ? registeredModelEntity : {})
        : registeredModelEntity || "";

      return {
        url: globalImportUrl.format(localVarUrlObj),
        options: localVarRequestOptions,
      };
    },
    /**
     *
     * @summary Create a registered model tag instance
     * @param {string} [name]
     * @param {string} [tag]
     * @param {*} [options] Override http request option.
     * @throws {RequiredError}
     */
    createRegisteredModelTag: async (name?: string, tag?: string, options: any = {}): Promise<RequestArgs> => {
      const localVarPath = `/v1/registered-model/tag`;
      const localVarUrlObj = globalImportUrl.parse(localVarPath, true);
      let baseOptions;
      if (configuration) {
        baseOptions = configuration.baseOptions;
      }
      const localVarRequestOptions = { method: "POST", ...baseOptions, ...options };
      const localVarHeaderParameter = {} as any;
      const localVarQueryParameter = {} as any;

      if (name !== undefined) {
        localVarQueryParameter["name"] = name;
      }

      if (tag !== undefined) {
        localVarQueryParameter["tag"] = tag;
      }

      localVarUrlObj.query = { ...localVarUrlObj.query, ...localVarQueryParameter, ...options.query };
      // fix override query string Detail: https://stackoverflow.com/a/7517673/1077943
      delete localVarUrlObj.search;
      let headersFromBaseOptions = baseOptions && baseOptions.headers ? baseOptions.headers : {};
      localVarRequestOptions.headers = { ...localVarHeaderParameter, ...headersFromBaseOptions, ...options.headers };

      return {
        url: globalImportUrl.format(localVarUrlObj),
        options: localVarRequestOptions,
      };
    },
    /**
     *
     * @summary Delete the registered model
     * @param {string} name
     * @param {*} [options] Override http request option.
     * @throws {RequiredError}
     */
    deleteRegisteredModel: async (name: string, options: any = {}): Promise<RequestArgs> => {
      // verify required parameter 'name' is not null or undefined
      if (name === null || name === undefined) {
        throw new RequiredError(
          "name",
          "Required parameter name was null or undefined when calling deleteRegisteredModel."
        );
      }
      const localVarPath = `/v1/registered-model/{name}`.replace(`{${"name"}}`, encodeURIComponent(String(name)));
      const localVarUrlObj = globalImportUrl.parse(localVarPath, true);
      let baseOptions;
      if (configuration) {
        baseOptions = configuration.baseOptions;
      }
      const localVarRequestOptions = { method: "DELETE", ...baseOptions, ...options };
      const localVarHeaderParameter = {} as any;
      const localVarQueryParameter = {} as any;

      localVarUrlObj.query = { ...localVarUrlObj.query, ...localVarQueryParameter, ...options.query };
      // fix override query string Detail: https://stackoverflow.com/a/7517673/1077943
      delete localVarUrlObj.search;
      let headersFromBaseOptions = baseOptions && baseOptions.headers ? baseOptions.headers : {};
      localVarRequestOptions.headers = { ...localVarHeaderParameter, ...headersFromBaseOptions, ...options.headers };

      return {
        url: globalImportUrl.format(localVarUrlObj),
        options: localVarRequestOptions,
      };
    },
    /**
     *
     * @summary Delete a registered model tag instance
     * @param {string} [name]
     * @param {string} [tag]
     * @param {*} [options] Override http request option.
     * @throws {RequiredError}
     */
    deleteRegisteredModelTag: async (name?: string, tag?: string, options: any = {}): Promise<RequestArgs> => {
      const localVarPath = `/v1/registered-model/tag`;
      const localVarUrlObj = globalImportUrl.parse(localVarPath, true);
      let baseOptions;
      if (configuration) {
        baseOptions = configuration.baseOptions;
      }
      const localVarRequestOptions = { method: "DELETE", ...baseOptions, ...options };
      const localVarHeaderParameter = {} as any;
      const localVarQueryParameter = {} as any;

      if (name !== undefined) {
        localVarQueryParameter["name"] = name;
      }

      if (tag !== undefined) {
        localVarQueryParameter["tag"] = tag;
      }

      localVarUrlObj.query = { ...localVarUrlObj.query, ...localVarQueryParameter, ...options.query };
      // fix override query string Detail: https://stackoverflow.com/a/7517673/1077943
      delete localVarUrlObj.search;
      let headersFromBaseOptions = baseOptions && baseOptions.headers ? baseOptions.headers : {};
      localVarRequestOptions.headers = { ...localVarHeaderParameter, ...headersFromBaseOptions, ...options.headers };

      return {
        url: globalImportUrl.format(localVarUrlObj),
        options: localVarRequestOptions,
      };
    },
    /**
     *
     * @summary Get detailed info about the registered model
     * @param {string} name
     * @param {*} [options] Override http request option.
     * @throws {RequiredError}
     */
    getRegisteredModel: async (name: string, options: any = {}): Promise<RequestArgs> => {
      // verify required parameter 'name' is not null or undefined
      if (name === null || name === undefined) {
        throw new RequiredError(
          "name",
          "Required parameter name was null or undefined when calling getRegisteredModel."
        );
      }
      const localVarPath = `/v1/registered-model/{name}`.replace(`{${"name"}}`, encodeURIComponent(String(name)));
      const localVarUrlObj = globalImportUrl.parse(localVarPath, true);
      let baseOptions;
      if (configuration) {
        baseOptions = configuration.baseOptions;
      }
      const localVarRequestOptions = { method: "GET", ...baseOptions, ...options };
      const localVarHeaderParameter = {} as any;
      const localVarQueryParameter = {} as any;

      localVarUrlObj.query = { ...localVarUrlObj.query, ...localVarQueryParameter, ...options.query };
      // fix override query string Detail: https://stackoverflow.com/a/7517673/1077943
      delete localVarUrlObj.search;
      let headersFromBaseOptions = baseOptions && baseOptions.headers ? baseOptions.headers : {};
      localVarRequestOptions.headers = { ...localVarHeaderParameter, ...headersFromBaseOptions, ...options.headers };

      return {
        url: globalImportUrl.format(localVarUrlObj),
        options: localVarRequestOptions,
      };
    },
    /**
     *
     * @summary List registered models
     * @param {*} [options] Override http request option.
     * @throws {RequiredError}
     */
    listRegisteredModels: async (options: any = {}): Promise<RequestArgs> => {
      const localVarPath = `/v1/registered-model`;
      const localVarUrlObj = globalImportUrl.parse(localVarPath, true);
      let baseOptions;
      if (configuration) {
        baseOptions = configuration.baseOptions;
      }
      const localVarRequestOptions = { method: "GET", ...baseOptions, ...options };
      const localVarHeaderParameter = {} as any;
      const localVarQueryParameter = {} as any;

      localVarUrlObj.query = { ...localVarUrlObj.query, ...localVarQueryParameter, ...options.query };
      // fix override query string Detail: https://stackoverflow.com/a/7517673/1077943
      delete localVarUrlObj.search;
      let headersFromBaseOptions = baseOptions && baseOptions.headers ? baseOptions.headers : {};
      localVarRequestOptions.headers = { ...localVarHeaderParameter, ...headersFromBaseOptions, ...options.headers };

      return {
        url: globalImportUrl.format(localVarUrlObj),
        options: localVarRequestOptions,
      };
    },
    /**
     * Return the Pong message for test the connectivity
     * @summary Ping submarine server
     * @param {*} [options] Override http request option.
     * @throws {RequiredError}
     */
    ping3: async (options: any = {}): Promise<RequestArgs> => {
      const localVarPath = `/v1/registered-model/ping`;
      const localVarUrlObj = globalImportUrl.parse(localVarPath, true);
      let baseOptions;
      if (configuration) {
        baseOptions = configuration.baseOptions;
      }
      const localVarRequestOptions = { method: "GET", ...baseOptions, ...options };
      const localVarHeaderParameter = {} as any;
      const localVarQueryParameter = {} as any;

      localVarUrlObj.query = { ...localVarUrlObj.query, ...localVarQueryParameter, ...options.query };
      // fix override query string Detail: https://stackoverflow.com/a/7517673/1077943
      delete localVarUrlObj.search;
      let headersFromBaseOptions = baseOptions && baseOptions.headers ? baseOptions.headers : {};
      localVarRequestOptions.headers = { ...localVarHeaderParameter, ...headersFromBaseOptions, ...options.headers };

      return {
        url: globalImportUrl.format(localVarUrlObj),
        options: localVarRequestOptions,
      };
    },
    /**
     *
     * @summary Update the registered model
     * @param {string} name
     * @param {RegisteredModelEntity} [registeredModelEntity]
     * @param {*} [options] Override http request option.
     * @throws {RequiredError}
     */
    updateRegisteredModel: async (
      name: string,
      registeredModelEntity?: RegisteredModelEntity,
      options: any = {}
    ): Promise<RequestArgs> => {
      // verify required parameter 'name' is not null or undefined
      if (name === null || name === undefined) {
        throw new RequiredError(
          "name",
          "Required parameter name was null or undefined when calling updateRegisteredModel."
        );
      }
      const localVarPath = `/v1/registered-model/{name}`.replace(`{${"name"}}`, encodeURIComponent(String(name)));
      const localVarUrlObj = globalImportUrl.parse(localVarPath, true);
      let baseOptions;
      if (configuration) {
        baseOptions = configuration.baseOptions;
      }
      const localVarRequestOptions = { method: "PATCH", ...baseOptions, ...options };
      const localVarHeaderParameter = {} as any;
      const localVarQueryParameter = {} as any;

      localVarHeaderParameter["Content-Type"] = "application/json";

      localVarUrlObj.query = { ...localVarUrlObj.query, ...localVarQueryParameter, ...options.query };
      // fix override query string Detail: https://stackoverflow.com/a/7517673/1077943
      delete localVarUrlObj.search;
      let headersFromBaseOptions = baseOptions && baseOptions.headers ? baseOptions.headers : {};
      localVarRequestOptions.headers = { ...localVarHeaderParameter, ...headersFromBaseOptions, ...options.headers };
      const needsSerialization =
        typeof registeredModelEntity !== "string" ||
        localVarRequestOptions.headers["Content-Type"] === "application/json";
      localVarRequestOptions.data = needsSerialization
        ? JSON.stringify(registeredModelEntity !== undefined ? registeredModelEntity : {})
        : registeredModelEntity || "";

      return {
        url: globalImportUrl.format(localVarUrlObj),
        options: localVarRequestOptions,
      };
    },
  };
};

/**
 * RegisteredModelApi - functional programming interface
 * @export
 */
export const RegisteredModelApiFp = function (configuration?: Configuration) {
  return {
    /**
     *
     * @summary Create a registered model instance
     * @param {RegisteredModelEntity} [registeredModelEntity]
     * @param {*} [options] Override http request option.
     * @throws {RequiredError}
     */
    async createRegisteredModel(
      registeredModelEntity?: RegisteredModelEntity,
      options?: any
    ): Promise<(axios?: AxiosInstance, basePath?: string) => AxiosPromise<JsonResponse>> {
      const localVarAxiosArgs = await RegisteredModelApiAxiosParamCreator(configuration).createRegisteredModel(
        registeredModelEntity,
        options
      );
      return (axios: AxiosInstance = globalAxios, basePath: string = BASE_PATH) => {
        const axiosRequestArgs = { ...localVarAxiosArgs.options, url: basePath + localVarAxiosArgs.url };
        return axios.request(axiosRequestArgs);
      };
    },
    /**
     *
     * @summary Create a registered model tag instance
     * @param {string} [name]
     * @param {string} [tag]
     * @param {*} [options] Override http request option.
     * @throws {RequiredError}
     */
    async createRegisteredModelTag(
      name?: string,
      tag?: string,
      options?: any
    ): Promise<(axios?: AxiosInstance, basePath?: string) => AxiosPromise<JsonResponse>> {
      const localVarAxiosArgs = await RegisteredModelApiAxiosParamCreator(configuration).createRegisteredModelTag(
        name,
        tag,
        options
      );
      return (axios: AxiosInstance = globalAxios, basePath: string = BASE_PATH) => {
        const axiosRequestArgs = { ...localVarAxiosArgs.options, url: basePath + localVarAxiosArgs.url };
        return axios.request(axiosRequestArgs);
      };
    },
    /**
     *
     * @summary Delete the registered model
     * @param {string} name
     * @param {*} [options] Override http request option.
     * @throws {RequiredError}
     */
    async deleteRegisteredModel(
      name: string,
      options?: any
    ): Promise<(axios?: AxiosInstance, basePath?: string) => AxiosPromise<JsonResponse>> {
      const localVarAxiosArgs = await RegisteredModelApiAxiosParamCreator(configuration).deleteRegisteredModel(
        name,
        options
      );
      return (axios: AxiosInstance = globalAxios, basePath: string = BASE_PATH) => {
        const axiosRequestArgs = { ...localVarAxiosArgs.options, url: basePath + localVarAxiosArgs.url };
        return axios.request(axiosRequestArgs);
      };
    },
    /**
     *
     * @summary Delete a registered model tag instance
     * @param {string} [name]
     * @param {string} [tag]
     * @param {*} [options] Override http request option.
     * @throws {RequiredError}
     */
    async deleteRegisteredModelTag(
      name?: string,
      tag?: string,
      options?: any
    ): Promise<(axios?: AxiosInstance, basePath?: string) => AxiosPromise<JsonResponse>> {
      const localVarAxiosArgs = await RegisteredModelApiAxiosParamCreator(configuration).deleteRegisteredModelTag(
        name,
        tag,
        options
      );
      return (axios: AxiosInstance = globalAxios, basePath: string = BASE_PATH) => {
        const axiosRequestArgs = { ...localVarAxiosArgs.options, url: basePath + localVarAxiosArgs.url };
        return axios.request(axiosRequestArgs);
      };
    },
    /**
     *
     * @summary Get detailed info about the registered model
     * @param {string} name
     * @param {*} [options] Override http request option.
     * @throws {RequiredError}
     */
    async getRegisteredModel(
      name: string,
      options?: any
    ): Promise<(axios?: AxiosInstance, basePath?: string) => AxiosPromise<JsonResponse>> {
      const localVarAxiosArgs = await RegisteredModelApiAxiosParamCreator(configuration).getRegisteredModel(
        name,
        options
      );
      return (axios: AxiosInstance = globalAxios, basePath: string = BASE_PATH) => {
        const axiosRequestArgs = { ...localVarAxiosArgs.options, url: basePath + localVarAxiosArgs.url };
        return axios.request(axiosRequestArgs);
      };
    },
    /**
     *
     * @summary List registered models
     * @param {*} [options] Override http request option.
     * @throws {RequiredError}
     */
    async listRegisteredModels(
      options?: any
    ): Promise<(axios?: AxiosInstance, basePath?: string) => AxiosPromise<JsonResponse>> {
      const localVarAxiosArgs = await RegisteredModelApiAxiosParamCreator(configuration).listRegisteredModels(options);
      return (axios: AxiosInstance = globalAxios, basePath: string = BASE_PATH) => {
        const axiosRequestArgs = { ...localVarAxiosArgs.options, url: basePath + localVarAxiosArgs.url };
        return axios.request(axiosRequestArgs);
      };
    },
    /**
     * Return the Pong message for test the connectivity
     * @summary Ping submarine server
     * @param {*} [options] Override http request option.
     * @throws {RequiredError}
     */
    async ping3(options?: any): Promise<(axios?: AxiosInstance, basePath?: string) => AxiosPromise<string>> {
      const localVarAxiosArgs = await RegisteredModelApiAxiosParamCreator(configuration).ping3(options);
      return (axios: AxiosInstance = globalAxios, basePath: string = BASE_PATH) => {
        const axiosRequestArgs = { ...localVarAxiosArgs.options, url: basePath + localVarAxiosArgs.url };
        return axios.request(axiosRequestArgs);
      };
    },
    /**
     *
     * @summary Update the registered model
     * @param {string} name
     * @param {RegisteredModelEntity} [registeredModelEntity]
     * @param {*} [options] Override http request option.
     * @throws {RequiredError}
     */
    async updateRegisteredModel(
      name: string,
      registeredModelEntity?: RegisteredModelEntity,
      options?: any
    ): Promise<(axios?: AxiosInstance, basePath?: string) => AxiosPromise<JsonResponse>> {
      const localVarAxiosArgs = await RegisteredModelApiAxiosParamCreator(configuration).updateRegisteredModel(
        name,
        registeredModelEntity,
        options
      );
      return (axios: AxiosInstance = globalAxios, basePath: string = BASE_PATH) => {
        const axiosRequestArgs = { ...localVarAxiosArgs.options, url: basePath + localVarAxiosArgs.url };
        return axios.request(axiosRequestArgs);
      };
    },
  };
};

/**
 * RegisteredModelApi - factory interface
 * @export
 */
export const RegisteredModelApiFactory = function (
  configuration?: Configuration,
  basePath?: string,
  axios?: AxiosInstance
) {
  return {
    /**
     *
     * @summary Create a registered model instance
     * @param {RegisteredModelEntity} [registeredModelEntity]
     * @param {*} [options] Override http request option.
     * @throws {RequiredError}
     */
    createRegisteredModel(registeredModelEntity?: RegisteredModelEntity, options?: any): AxiosPromise<JsonResponse> {
      return RegisteredModelApiFp(configuration)
        .createRegisteredModel(registeredModelEntity, options)
        .then((request) => request(axios, basePath));
    },
    /**
     *
     * @summary Create a registered model tag instance
     * @param {string} [name]
     * @param {string} [tag]
     * @param {*} [options] Override http request option.
     * @throws {RequiredError}
     */
    createRegisteredModelTag(name?: string, tag?: string, options?: any): AxiosPromise<JsonResponse> {
      return RegisteredModelApiFp(configuration)
        .createRegisteredModelTag(name, tag, options)
        .then((request) => request(axios, basePath));
    },
    /**
     *
     * @summary Delete the registered model
     * @param {string} name
     * @param {*} [options] Override http request option.
     * @throws {RequiredError}
     */
    deleteRegisteredModel(name: string, options?: any): AxiosPromise<JsonResponse> {
      return RegisteredModelApiFp(configuration)
        .deleteRegisteredModel(name, options)
        .then((request) => request(axios, basePath));
    },
    /**
     *
     * @summary Delete a registered model tag instance
     * @param {string} [name]
     * @param {string} [tag]
     * @param {*} [options] Override http request option.
     * @throws {RequiredError}
     */
    deleteRegisteredModelTag(name?: string, tag?: string, options?: any): AxiosPromise<JsonResponse> {
      return RegisteredModelApiFp(configuration)
        .deleteRegisteredModelTag(name, tag, options)
        .then((request) => request(axios, basePath));
    },
    /**
     *
     * @summary Get detailed info about the registered model
     * @param {string} name
     * @param {*} [options] Override http request option.
     * @throws {RequiredError}
     */
    getRegisteredModel(name: string, options?: any): AxiosPromise<JsonResponse> {
      return RegisteredModelApiFp(configuration)
        .getRegisteredModel(name, options)
        .then((request) => request(axios, basePath));
    },
    /**
     *
     * @summary List registered models
     * @param {*} [options] Override http request option.
     * @throws {RequiredError}
     */
    listRegisteredModels(options?: any): AxiosPromise<JsonResponse> {
      return RegisteredModelApiFp(configuration)
        .listRegisteredModels(options)
        .then((request) => request(axios, basePath));
    },
    /**
     * Return the Pong message for test the connectivity
     * @summary Ping submarine server
     * @param {*} [options] Override http request option.
     * @throws {RequiredError}
     */
    ping3(options?: any): AxiosPromise<string> {
      return RegisteredModelApiFp(configuration)
        .ping3(options)
        .then((request) => request(axios, basePath));
    },
    /**
     *
     * @summary Update the registered model
     * @param {string} name
     * @param {RegisteredModelEntity} [registeredModelEntity]
     * @param {*} [options] Override http request option.
     * @throws {RequiredError}
     */
    updateRegisteredModel(
      name: string,
      registeredModelEntity?: RegisteredModelEntity,
      options?: any
    ): AxiosPromise<JsonResponse> {
      return RegisteredModelApiFp(configuration)
        .updateRegisteredModel(name, registeredModelEntity, options)
        .then((request) => request(axios, basePath));
    },
  };
};

/**
 * RegisteredModelApi - object-oriented interface
 * @export
 * @class RegisteredModelApi
 * @extends {BaseAPI}
 */
export class RegisteredModelApi extends BaseAPI {
  /**
   *
   * @summary Create a registered model instance
   * @param {RegisteredModelEntity} [registeredModelEntity]
   * @param {*} [options] Override http request option.
   * @throws {RequiredError}
   * @memberof RegisteredModelApi
   */
  public createRegisteredModel(registeredModelEntity?: RegisteredModelEntity, options?: any) {
    return RegisteredModelApiFp(this.configuration)
      .createRegisteredModel(registeredModelEntity, options)
      .then((request) => request(this.axios, this.basePath));
  }

  /**
   *
   * @summary Create a registered model tag instance
   * @param {string} [name]
   * @param {string} [tag]
   * @param {*} [options] Override http request option.
   * @throws {RequiredError}
   * @memberof RegisteredModelApi
   */
  public createRegisteredModelTag(name?: string, tag?: string, options?: any) {
    return RegisteredModelApiFp(this.configuration)
      .createRegisteredModelTag(name, tag, options)
      .then((request) => request(this.axios, this.basePath));
  }

  /**
   *
   * @summary Delete the registered model
   * @param {string} name
   * @param {*} [options] Override http request option.
   * @throws {RequiredError}
   * @memberof RegisteredModelApi
   */
  public deleteRegisteredModel(name: string, options?: any) {
    return RegisteredModelApiFp(this.configuration)
      .deleteRegisteredModel(name, options)
      .then((request) => request(this.axios, this.basePath));
  }

  /**
   *
   * @summary Delete a registered model tag instance
   * @param {string} [name]
   * @param {string} [tag]
   * @param {*} [options] Override http request option.
   * @throws {RequiredError}
   * @memberof RegisteredModelApi
   */
  public deleteRegisteredModelTag(name?: string, tag?: string, options?: any) {
    return RegisteredModelApiFp(this.configuration)
      .deleteRegisteredModelTag(name, tag, options)
      .then((request) => request(this.axios, this.basePath));
  }

  /**
   *
   * @summary Get detailed info about the registered model
   * @param {string} name
   * @param {*} [options] Override http request option.
   * @throws {RequiredError}
   * @memberof RegisteredModelApi
   */
  public getRegisteredModel(name: string, options?: any) {
    return RegisteredModelApiFp(this.configuration)
      .getRegisteredModel(name, options)
      .then((request) => request(this.axios, this.basePath));
  }

  /**
   *
   * @summary List registered models
   * @param {*} [options] Override http request option.
   * @throws {RequiredError}
   * @memberof RegisteredModelApi
   */
  public listRegisteredModels(options?: any) {
    return RegisteredModelApiFp(this.configuration)
      .listRegisteredModels(options)
      .then((request) => request(this.axios, this.basePath));
  }

  /**
   * Return the Pong message for test the connectivity
   * @summary Ping submarine server
   * @param {*} [options] Override http request option.
   * @throws {RequiredError}
   * @memberof RegisteredModelApi
   */
  public ping3(options?: any) {
    return RegisteredModelApiFp(this.configuration)
      .ping3(options)
      .then((request) => request(this.axios, this.basePath));
  }

  /**
   *
   * @summary Update the registered model
   * @param {string} name
   * @param {RegisteredModelEntity} [registeredModelEntity]
   * @param {*} [options] Override http request option.
   * @throws {RequiredError}
   * @memberof RegisteredModelApi
   */
  public updateRegisteredModel(name: string, registeredModelEntity?: RegisteredModelEntity, options?: any) {
    return RegisteredModelApiFp(this.configuration)
      .updateRegisteredModel(name, registeredModelEntity, options)
      .then((request) => request(this.axios, this.basePath));
  }
}

/**
 * ServeApi - axios parameter creator
 * @export
 */
export const ServeApiAxiosParamCreator = function (configuration?: Configuration) {
  return {
    /**
     *
     * @summary Create a serve instance
     * @param {ServeSpec} [serveSpec]
     * @param {*} [options] Override http request option.
     * @throws {RequiredError}
     */
    createServe: async (serveSpec?: ServeSpec, options: any = {}): Promise<RequestArgs> => {
      const localVarPath = `/v1/serve`;
      const localVarUrlObj = globalImportUrl.parse(localVarPath, true);
      let baseOptions;
      if (configuration) {
        baseOptions = configuration.baseOptions;
      }
      const localVarRequestOptions = { method: "POST", ...baseOptions, ...options };
      const localVarHeaderParameter = {} as any;
      const localVarQueryParameter = {} as any;

      localVarHeaderParameter["Content-Type"] = "application/yaml";

      localVarUrlObj.query = { ...localVarUrlObj.query, ...localVarQueryParameter, ...options.query };
      // fix override query string Detail: https://stackoverflow.com/a/7517673/1077943
      delete localVarUrlObj.search;
      let headersFromBaseOptions = baseOptions && baseOptions.headers ? baseOptions.headers : {};
      localVarRequestOptions.headers = { ...localVarHeaderParameter, ...headersFromBaseOptions, ...options.headers };
      const needsSerialization =
        typeof serveSpec !== "string" || localVarRequestOptions.headers["Content-Type"] === "application/json";
      localVarRequestOptions.data = needsSerialization
        ? JSON.stringify(serveSpec !== undefined ? serveSpec : {})
        : serveSpec || "";

      return {
        url: globalImportUrl.format(localVarUrlObj),
        options: localVarRequestOptions,
      };
    },
    /**
     *
     * @summary Delete the serve instance.
     * @param {ServeSpec} [serveSpec]
     * @param {*} [options] Override http request option.
     * @throws {RequiredError}
     */
    deleteServe: async (serveSpec?: ServeSpec, options: any = {}): Promise<RequestArgs> => {
      const localVarPath = `/v1/serve`;
      const localVarUrlObj = globalImportUrl.parse(localVarPath, true);
      let baseOptions;
      if (configuration) {
        baseOptions = configuration.baseOptions;
      }
      const localVarRequestOptions = { method: "DELETE", ...baseOptions, ...options };
      const localVarHeaderParameter = {} as any;
      const localVarQueryParameter = {} as any;

      localVarHeaderParameter["Content-Type"] = "application/json";

      localVarUrlObj.query = { ...localVarUrlObj.query, ...localVarQueryParameter, ...options.query };
      // fix override query string Detail: https://stackoverflow.com/a/7517673/1077943
      delete localVarUrlObj.search;
      let headersFromBaseOptions = baseOptions && baseOptions.headers ? baseOptions.headers : {};
      localVarRequestOptions.headers = { ...localVarHeaderParameter, ...headersFromBaseOptions, ...options.headers };
      const needsSerialization =
        typeof serveSpec !== "string" || localVarRequestOptions.headers["Content-Type"] === "application/json";
      localVarRequestOptions.data = needsSerialization
        ? JSON.stringify(serveSpec !== undefined ? serveSpec : {})
        : serveSpec || "";

      return {
        url: globalImportUrl.format(localVarUrlObj),
        options: localVarRequestOptions,
      };
    },
    /**
     * Return the Pong message for test the connectivity
     * @summary Ping submarine server
     * @param {*} [options] Override http request option.
     * @throws {RequiredError}
     */
    ping4: async (options: any = {}): Promise<RequestArgs> => {
      const localVarPath = `/v1/serve/ping`;
      const localVarUrlObj = globalImportUrl.parse(localVarPath, true);
      let baseOptions;
      if (configuration) {
        baseOptions = configuration.baseOptions;
      }
      const localVarRequestOptions = { method: "GET", ...baseOptions, ...options };
      const localVarHeaderParameter = {} as any;
      const localVarQueryParameter = {} as any;

      localVarUrlObj.query = { ...localVarUrlObj.query, ...localVarQueryParameter, ...options.query };
      // fix override query string Detail: https://stackoverflow.com/a/7517673/1077943
      delete localVarUrlObj.search;
      let headersFromBaseOptions = baseOptions && baseOptions.headers ? baseOptions.headers : {};
      localVarRequestOptions.headers = { ...localVarHeaderParameter, ...headersFromBaseOptions, ...options.headers };

      return {
        url: globalImportUrl.format(localVarUrlObj),
        options: localVarRequestOptions,
      };
    },
  };
};

/**
 * ServeApi - functional programming interface
 * @export
 */
export const ServeApiFp = function (configuration?: Configuration) {
  return {
    /**
     *
     * @summary Create a serve instance
     * @param {ServeSpec} [serveSpec]
     * @param {*} [options] Override http request option.
     * @throws {RequiredError}
     */
    async createServe(
      serveSpec?: ServeSpec,
      options?: any
    ): Promise<(axios?: AxiosInstance, basePath?: string) => AxiosPromise<JsonResponse>> {
      const localVarAxiosArgs = await ServeApiAxiosParamCreator(configuration).createServe(serveSpec, options);
      return (axios: AxiosInstance = globalAxios, basePath: string = BASE_PATH) => {
        const axiosRequestArgs = { ...localVarAxiosArgs.options, url: basePath + localVarAxiosArgs.url };
        return axios.request(axiosRequestArgs);
      };
    },
    /**
     *
     * @summary Delete the serve instance.
     * @param {ServeSpec} [serveSpec]
     * @param {*} [options] Override http request option.
     * @throws {RequiredError}
     */
    async deleteServe(
      serveSpec?: ServeSpec,
      options?: any
    ): Promise<(axios?: AxiosInstance, basePath?: string) => AxiosPromise<JsonResponse>> {
      const localVarAxiosArgs = await ServeApiAxiosParamCreator(configuration).deleteServe(serveSpec, options);
      return (axios: AxiosInstance = globalAxios, basePath: string = BASE_PATH) => {
        const axiosRequestArgs = { ...localVarAxiosArgs.options, url: basePath + localVarAxiosArgs.url };
        return axios.request(axiosRequestArgs);
      };
    },
    /**
     * Return the Pong message for test the connectivity
     * @summary Ping submarine server
     * @param {*} [options] Override http request option.
     * @throws {RequiredError}
     */
    async ping4(options?: any): Promise<(axios?: AxiosInstance, basePath?: string) => AxiosPromise<string>> {
      const localVarAxiosArgs = await ServeApiAxiosParamCreator(configuration).ping4(options);
      return (axios: AxiosInstance = globalAxios, basePath: string = BASE_PATH) => {
        const axiosRequestArgs = { ...localVarAxiosArgs.options, url: basePath + localVarAxiosArgs.url };
        return axios.request(axiosRequestArgs);
      };
    },
  };
};

/**
 * ServeApi - factory interface
 * @export
 */
export const ServeApiFactory = function (configuration?: Configuration, basePath?: string, axios?: AxiosInstance) {
  return {
    /**
     *
     * @summary Create a serve instance
     * @param {ServeSpec} [serveSpec]
     * @param {*} [options] Override http request option.
     * @throws {RequiredError}
     */
    createServe(serveSpec?: ServeSpec, options?: any): AxiosPromise<JsonResponse> {
      return ServeApiFp(configuration)
        .createServe(serveSpec, options)
        .then((request) => request(axios, basePath));
    },
    /**
     *
     * @summary Delete the serve instance.
     * @param {ServeSpec} [serveSpec]
     * @param {*} [options] Override http request option.
     * @throws {RequiredError}
     */
    deleteServe(serveSpec?: ServeSpec, options?: any): AxiosPromise<JsonResponse> {
      return ServeApiFp(configuration)
        .deleteServe(serveSpec, options)
        .then((request) => request(axios, basePath));
    },
    /**
     * Return the Pong message for test the connectivity
     * @summary Ping submarine server
     * @param {*} [options] Override http request option.
     * @throws {RequiredError}
     */
    ping4(options?: any): AxiosPromise<string> {
      return ServeApiFp(configuration)
        .ping4(options)
        .then((request) => request(axios, basePath));
    },
  };
};

/**
 * ServeApi - object-oriented interface
 * @export
 * @class ServeApi
 * @extends {BaseAPI}
 */
export class ServeApi extends BaseAPI {
  /**
   *
   * @summary Create a serve instance
   * @param {ServeSpec} [serveSpec]
   * @param {*} [options] Override http request option.
   * @throws {RequiredError}
   * @memberof ServeApi
   */
  public createServe(serveSpec?: ServeSpec, options?: any) {
    return ServeApiFp(this.configuration)
      .createServe(serveSpec, options)
      .then((request) => request(this.axios, this.basePath));
  }

  /**
   *
   * @summary Delete the serve instance.
   * @param {ServeSpec} [serveSpec]
   * @param {*} [options] Override http request option.
   * @throws {RequiredError}
   * @memberof ServeApi
   */
  public deleteServe(serveSpec?: ServeSpec, options?: any) {
    return ServeApiFp(this.configuration)
      .deleteServe(serveSpec, options)
      .then((request) => request(this.axios, this.basePath));
  }

  /**
   * Return the Pong message for test the connectivity
   * @summary Ping submarine server
   * @param {*} [options] Override http request option.
   * @throws {RequiredError}
   * @memberof ServeApi
   */
  public ping4(options?: any) {
    return ServeApiFp(this.configuration)
      .ping4(options)
      .then((request) => request(this.axios, this.basePath));
  }
}
