/*
 * Licensed to the Apache Software Foundation (ASF) under one
 * or more contributor license agreements.  See the NOTICE file
 * distributed with this work for additional information
 * regarding copyright ownership.  The ASF licenses this file
 * to you under the Apache License, Version 2.0 (the
 * "License"); you may not use this file except in compliance
 * with the License.  You may obtain a copy of the License at
 *
 *   http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing,
 * software distributed under the License is distributed on an
 * "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY
 * KIND, either express or implied.  See the License for the
 * specific language governing permissions and limitations
 * under the License.
 */

package org.apache.submarine.server.api.spec;

import java.util.List;

/**
 * Kernel Spec.
 */
public class KernelSpec {

  /**
   * Name of the kernel
   */
  private String name;

  /**
   * Name of the channels
   */
  private List<String> channels;

  /**
   * List of kernel conda dependencies
   */
  private List<String> condaDependencies;
  /**
   * List of kernel pip dependencies
   */
  private List<String> pipDependencies;

  public String getName() {
    return name;
  }

  public void setName(String name) {
    this.name = name;
  }

  public List<String> getChannels() {
    return channels;
  }

  public void setChannels(List<String> channels) {
    this.channels = channels;
  }

  public List<String> getCondaDependencies() {
    return condaDependencies;
  }

  public void setCondaDependencies(List<String> condaDependencies) {
    this.condaDependencies = condaDependencies;
  }

  public List<String> getPipDependencies() {
    return pipDependencies;
  }

  public void setPipDependencies(List<String> pipDependencies) {
    this.pipDependencies = pipDependencies;
  }
}
