/*
 * Licensed to the Apache Software Foundation (ASF) under one
 * or more contributor license agreements.  See the NOTICE file
 * distributed with this work for additional information
 * regarding copyright ownership.  The ASF licenses this file
 * to you under the Apache License, Version 2.0 (the
 * "License"); you may not use this file except in compliance
 * with the License.  You may obtain a copy of the License at
 *
 *   http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing,
 * software distributed under the License is distributed on an
 * "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY
 * KIND, either express or implied.  See the License for the
 * specific language governing permissions and limitations
 * under the License.
 */
// Generated by the protocol buffer compiler.  DO NOT EDIT!
// source: org/apache/submarine/server/api/proto/model_config.proto

package org.apache.submarine.server.api.proto;

public final class TritonModelConfig {
  private TritonModelConfig() {}
  public static void registerAllExtensions(
      com.google.protobuf.ExtensionRegistryLite registry) {
  }

  public static void registerAllExtensions(
      com.google.protobuf.ExtensionRegistry registry) {
    registerAllExtensions(
        (com.google.protobuf.ExtensionRegistryLite) registry);
  }
  /**
   * <pre>
   *&#64;&#64;
   *&#64;&#64;.. cpp:enum:: DataType
   *&#64;&#64;
   *&#64;&#64;   Data types supported for input and output tensors.
   *&#64;&#64;
   * </pre>
   *
   * Protobuf enum {@code inference.DataType}
   */
  public enum DataType
      implements com.google.protobuf.ProtocolMessageEnum {
    /**
     * <pre>
     *&#64;&#64;  .. cpp:enumerator:: DataType::INVALID = 0
     * </pre>
     *
     * <code>TYPE_INVALID = 0;</code>
     */
    TYPE_INVALID(0),
    /**
     * <pre>
     *&#64;&#64;  .. cpp:enumerator:: DataType::BOOL = 1
     * </pre>
     *
     * <code>TYPE_BOOL = 1;</code>
     */
    TYPE_BOOL(1),
    /**
     * <pre>
     *&#64;&#64;  .. cpp:enumerator:: DataType::UINT8 = 2
     * </pre>
     *
     * <code>TYPE_UINT8 = 2;</code>
     */
    TYPE_UINT8(2),
    /**
     * <pre>
     *&#64;&#64;  .. cpp:enumerator:: DataType::UINT16 = 3
     * </pre>
     *
     * <code>TYPE_UINT16 = 3;</code>
     */
    TYPE_UINT16(3),
    /**
     * <pre>
     *&#64;&#64;  .. cpp:enumerator:: DataType::UINT32 = 4
     * </pre>
     *
     * <code>TYPE_UINT32 = 4;</code>
     */
    TYPE_UINT32(4),
    /**
     * <pre>
     *&#64;&#64;  .. cpp:enumerator:: DataType::UINT64 = 5
     * </pre>
     *
     * <code>TYPE_UINT64 = 5;</code>
     */
    TYPE_UINT64(5),
    /**
     * <pre>
     *&#64;&#64;  .. cpp:enumerator:: DataType::INT8 = 6
     * </pre>
     *
     * <code>TYPE_INT8 = 6;</code>
     */
    TYPE_INT8(6),
    /**
     * <pre>
     *&#64;&#64;  .. cpp:enumerator:: DataType::INT16 = 7
     * </pre>
     *
     * <code>TYPE_INT16 = 7;</code>
     */
    TYPE_INT16(7),
    /**
     * <pre>
     *&#64;&#64;  .. cpp:enumerator:: DataType::INT32 = 8
     * </pre>
     *
     * <code>TYPE_INT32 = 8;</code>
     */
    TYPE_INT32(8),
    /**
     * <pre>
     *&#64;&#64;  .. cpp:enumerator:: DataType::INT64 = 9
     * </pre>
     *
     * <code>TYPE_INT64 = 9;</code>
     */
    TYPE_INT64(9),
    /**
     * <pre>
     *&#64;&#64;  .. cpp:enumerator:: DataType::FP16 = 10
     * </pre>
     *
     * <code>TYPE_FP16 = 10;</code>
     */
    TYPE_FP16(10),
    /**
     * <pre>
     *&#64;&#64;  .. cpp:enumerator:: DataType::FP32 = 11
     * </pre>
     *
     * <code>TYPE_FP32 = 11;</code>
     */
    TYPE_FP32(11),
    /**
     * <pre>
     *&#64;&#64;  .. cpp:enumerator:: DataType::FP64 = 12
     * </pre>
     *
     * <code>TYPE_FP64 = 12;</code>
     */
    TYPE_FP64(12),
    /**
     * <pre>
     *&#64;&#64;  .. cpp:enumerator:: DataType::STRING = 13
     * </pre>
     *
     * <code>TYPE_STRING = 13;</code>
     */
    TYPE_STRING(13),
    UNRECOGNIZED(-1),
    ;

    /**
     * <pre>
     *&#64;&#64;  .. cpp:enumerator:: DataType::INVALID = 0
     * </pre>
     *
     * <code>TYPE_INVALID = 0;</code>
     */
    public static final int TYPE_INVALID_VALUE = 0;
    /**
     * <pre>
     *&#64;&#64;  .. cpp:enumerator:: DataType::BOOL = 1
     * </pre>
     *
     * <code>TYPE_BOOL = 1;</code>
     */
    public static final int TYPE_BOOL_VALUE = 1;
    /**
     * <pre>
     *&#64;&#64;  .. cpp:enumerator:: DataType::UINT8 = 2
     * </pre>
     *
     * <code>TYPE_UINT8 = 2;</code>
     */
    public static final int TYPE_UINT8_VALUE = 2;
    /**
     * <pre>
     *&#64;&#64;  .. cpp:enumerator:: DataType::UINT16 = 3
     * </pre>
     *
     * <code>TYPE_UINT16 = 3;</code>
     */
    public static final int TYPE_UINT16_VALUE = 3;
    /**
     * <pre>
     *&#64;&#64;  .. cpp:enumerator:: DataType::UINT32 = 4
     * </pre>
     *
     * <code>TYPE_UINT32 = 4;</code>
     */
    public static final int TYPE_UINT32_VALUE = 4;
    /**
     * <pre>
     *&#64;&#64;  .. cpp:enumerator:: DataType::UINT64 = 5
     * </pre>
     *
     * <code>TYPE_UINT64 = 5;</code>
     */
    public static final int TYPE_UINT64_VALUE = 5;
    /**
     * <pre>
     *&#64;&#64;  .. cpp:enumerator:: DataType::INT8 = 6
     * </pre>
     *
     * <code>TYPE_INT8 = 6;</code>
     */
    public static final int TYPE_INT8_VALUE = 6;
    /**
     * <pre>
     *&#64;&#64;  .. cpp:enumerator:: DataType::INT16 = 7
     * </pre>
     *
     * <code>TYPE_INT16 = 7;</code>
     */
    public static final int TYPE_INT16_VALUE = 7;
    /**
     * <pre>
     *&#64;&#64;  .. cpp:enumerator:: DataType::INT32 = 8
     * </pre>
     *
     * <code>TYPE_INT32 = 8;</code>
     */
    public static final int TYPE_INT32_VALUE = 8;
    /**
     * <pre>
     *&#64;&#64;  .. cpp:enumerator:: DataType::INT64 = 9
     * </pre>
     *
     * <code>TYPE_INT64 = 9;</code>
     */
    public static final int TYPE_INT64_VALUE = 9;
    /**
     * <pre>
     *&#64;&#64;  .. cpp:enumerator:: DataType::FP16 = 10
     * </pre>
     *
     * <code>TYPE_FP16 = 10;</code>
     */
    public static final int TYPE_FP16_VALUE = 10;
    /**
     * <pre>
     *&#64;&#64;  .. cpp:enumerator:: DataType::FP32 = 11
     * </pre>
     *
     * <code>TYPE_FP32 = 11;</code>
     */
    public static final int TYPE_FP32_VALUE = 11;
    /**
     * <pre>
     *&#64;&#64;  .. cpp:enumerator:: DataType::FP64 = 12
     * </pre>
     *
     * <code>TYPE_FP64 = 12;</code>
     */
    public static final int TYPE_FP64_VALUE = 12;
    /**
     * <pre>
     *&#64;&#64;  .. cpp:enumerator:: DataType::STRING = 13
     * </pre>
     *
     * <code>TYPE_STRING = 13;</code>
     */
    public static final int TYPE_STRING_VALUE = 13;


    public final int getNumber() {
      if (this == UNRECOGNIZED) {
        throw new java.lang.IllegalArgumentException(
            "Can't get the number of an unknown enum value.");
      }
      return value;
    }

    /**
     * @param value The numeric wire value of the corresponding enum entry.
     * @return The enum associated with the given numeric wire value.
     * @deprecated Use {@link #forNumber(int)} instead.
     */
    @java.lang.Deprecated
    public static DataType valueOf(int value) {
      return forNumber(value);
    }

    /**
     * @param value The numeric wire value of the corresponding enum entry.
     * @return The enum associated with the given numeric wire value.
     */
    public static DataType forNumber(int value) {
      switch (value) {
        case 0: return TYPE_INVALID;
        case 1: return TYPE_BOOL;
        case 2: return TYPE_UINT8;
        case 3: return TYPE_UINT16;
        case 4: return TYPE_UINT32;
        case 5: return TYPE_UINT64;
        case 6: return TYPE_INT8;
        case 7: return TYPE_INT16;
        case 8: return TYPE_INT32;
        case 9: return TYPE_INT64;
        case 10: return TYPE_FP16;
        case 11: return TYPE_FP32;
        case 12: return TYPE_FP64;
        case 13: return TYPE_STRING;
        default: return null;
      }
    }

    public static com.google.protobuf.Internal.EnumLiteMap<DataType>
        internalGetValueMap() {
      return internalValueMap;
    }
    private static final com.google.protobuf.Internal.EnumLiteMap<
        DataType> internalValueMap =
          new com.google.protobuf.Internal.EnumLiteMap<DataType>() {
            public DataType findValueByNumber(int number) {
              return DataType.forNumber(number);
            }
          };

    public final com.google.protobuf.Descriptors.EnumValueDescriptor
        getValueDescriptor() {
      if (this == UNRECOGNIZED) {
        throw new java.lang.IllegalStateException(
            "Can't get the descriptor of an unrecognized enum value.");
      }
      return getDescriptor().getValues().get(ordinal());
    }
    public final com.google.protobuf.Descriptors.EnumDescriptor
        getDescriptorForType() {
      return getDescriptor();
    }
    public static final com.google.protobuf.Descriptors.EnumDescriptor
        getDescriptor() {
      return org.apache.submarine.server.api.proto.TritonModelConfig.getDescriptor().getEnumTypes().get(0);
    }

    private static final DataType[] VALUES = values();

    public static DataType valueOf(
        com.google.protobuf.Descriptors.EnumValueDescriptor desc) {
      if (desc.getType() != getDescriptor()) {
        throw new java.lang.IllegalArgumentException(
          "EnumValueDescriptor is not for this type.");
      }
      if (desc.getIndex() == -1) {
        return UNRECOGNIZED;
      }
      return VALUES[desc.getIndex()];
    }

    private final int value;

    private DataType(int value) {
      this.value = value;
    }

    // @@protoc_insertion_point(enum_scope:inference.DataType)
  }

  public interface ModelRateLimiterOrBuilder extends
      // @@protoc_insertion_point(interface_extends:inference.ModelRateLimiter)
      com.google.protobuf.MessageOrBuilder {

    /**
     * <pre>
     *&#64;&#64;  .. cpp:var:: Resource resources (repeated)
     *&#64;&#64;
     *&#64;&#64;     The resources required to execute the request on a model instance.
     *&#64;&#64;     Resources are just names with a corresponding count. The execution
     *&#64;&#64;     of the instance will be blocked until the specificied resources are
     *&#64;&#64;     available. By default an instance uses no rate-limiter resources.
     *&#64;&#64;
     * </pre>
     *
     * <code>repeated .inference.ModelRateLimiter.Resource resources = 1;</code>
     */
    java.util.List<org.apache.submarine.server.api.proto.TritonModelConfig.ModelRateLimiter.Resource> 
        getResourcesList();
    /**
     * <pre>
     *&#64;&#64;  .. cpp:var:: Resource resources (repeated)
     *&#64;&#64;
     *&#64;&#64;     The resources required to execute the request on a model instance.
     *&#64;&#64;     Resources are just names with a corresponding count. The execution
     *&#64;&#64;     of the instance will be blocked until the specificied resources are
     *&#64;&#64;     available. By default an instance uses no rate-limiter resources.
     *&#64;&#64;
     * </pre>
     *
     * <code>repeated .inference.ModelRateLimiter.Resource resources = 1;</code>
     */
    org.apache.submarine.server.api.proto.TritonModelConfig.ModelRateLimiter.Resource getResources(int index);
    /**
     * <pre>
     *&#64;&#64;  .. cpp:var:: Resource resources (repeated)
     *&#64;&#64;
     *&#64;&#64;     The resources required to execute the request on a model instance.
     *&#64;&#64;     Resources are just names with a corresponding count. The execution
     *&#64;&#64;     of the instance will be blocked until the specificied resources are
     *&#64;&#64;     available. By default an instance uses no rate-limiter resources.
     *&#64;&#64;
     * </pre>
     *
     * <code>repeated .inference.ModelRateLimiter.Resource resources = 1;</code>
     */
    int getResourcesCount();
    /**
     * <pre>
     *&#64;&#64;  .. cpp:var:: Resource resources (repeated)
     *&#64;&#64;
     *&#64;&#64;     The resources required to execute the request on a model instance.
     *&#64;&#64;     Resources are just names with a corresponding count. The execution
     *&#64;&#64;     of the instance will be blocked until the specificied resources are
     *&#64;&#64;     available. By default an instance uses no rate-limiter resources.
     *&#64;&#64;
     * </pre>
     *
     * <code>repeated .inference.ModelRateLimiter.Resource resources = 1;</code>
     */
    java.util.List<? extends org.apache.submarine.server.api.proto.TritonModelConfig.ModelRateLimiter.ResourceOrBuilder> 
        getResourcesOrBuilderList();
    /**
     * <pre>
     *&#64;&#64;  .. cpp:var:: Resource resources (repeated)
     *&#64;&#64;
     *&#64;&#64;     The resources required to execute the request on a model instance.
     *&#64;&#64;     Resources are just names with a corresponding count. The execution
     *&#64;&#64;     of the instance will be blocked until the specificied resources are
     *&#64;&#64;     available. By default an instance uses no rate-limiter resources.
     *&#64;&#64;
     * </pre>
     *
     * <code>repeated .inference.ModelRateLimiter.Resource resources = 1;</code>
     */
    org.apache.submarine.server.api.proto.TritonModelConfig.ModelRateLimiter.ResourceOrBuilder getResourcesOrBuilder(
        int index);

    /**
     * <pre>
     *&#64;&#64;  .. cpp:var:: uint32 priority
     *&#64;&#64;
     *&#64;&#64;     The optional weighting value to be used for prioritizing across
     *&#64;&#64;     instances. An instance with priority 2 will be given 1/2 the
     *&#64;&#64;     number of scheduling chances as an instance_group with priority
     *&#64;&#64;     1. The default priority is 1. The priority of value 0 will be
     *&#64;&#64;     treated as priority 1.
     *&#64;&#64;
     * </pre>
     *
     * <code>uint32 priority = 2;</code>
     * @return The priority.
     */
    int getPriority();
  }
  /**
   * <pre>
   *&#64;&#64;
   *&#64;&#64;  .. cpp:var:: message ModelRateLimiter
   *&#64;&#64;
   *&#64;&#64;     The specifications required by the rate limiter to properly
   *&#64;&#64;     schedule the inference requests across the different models
   *&#64;&#64;     and their instances.
   *&#64;&#64;
   * </pre>
   *
   * Protobuf type {@code inference.ModelRateLimiter}
   */
  public static final class ModelRateLimiter extends
      com.google.protobuf.GeneratedMessageV3 implements
      // @@protoc_insertion_point(message_implements:inference.ModelRateLimiter)
      ModelRateLimiterOrBuilder {
  private static final long serialVersionUID = 0L;
    // Use ModelRateLimiter.newBuilder() to construct.
    private ModelRateLimiter(com.google.protobuf.GeneratedMessageV3.Builder<?> builder) {
      super(builder);
    }
    private ModelRateLimiter() {
      resources_ = java.util.Collections.emptyList();
    }

    @java.lang.Override
    @SuppressWarnings({"unused"})
    protected java.lang.Object newInstance(
        UnusedPrivateParameter unused) {
      return new ModelRateLimiter();
    }

    @java.lang.Override
    public final com.google.protobuf.UnknownFieldSet
    getUnknownFields() {
      return this.unknownFields;
    }
    private ModelRateLimiter(
        com.google.protobuf.CodedInputStream input,
        com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws com.google.protobuf.InvalidProtocolBufferException {
      this();
      if (extensionRegistry == null) {
        throw new java.lang.NullPointerException();
      }
      int mutable_bitField0_ = 0;
      com.google.protobuf.UnknownFieldSet.Builder unknownFields =
          com.google.protobuf.UnknownFieldSet.newBuilder();
      try {
        boolean done = false;
        while (!done) {
          int tag = input.readTag();
          switch (tag) {
            case 0:
              done = true;
              break;
            case 10: {
              if (!((mutable_bitField0_ & 0x00000001) != 0)) {
                resources_ = new java.util.ArrayList<org.apache.submarine.server.api.proto.TritonModelConfig.ModelRateLimiter.Resource>();
                mutable_bitField0_ |= 0x00000001;
              }
              resources_.add(
                  input.readMessage(org.apache.submarine.server.api.proto.TritonModelConfig.ModelRateLimiter.Resource.parser(), extensionRegistry));
              break;
            }
            case 16: {

              priority_ = input.readUInt32();
              break;
            }
            default: {
              if (!parseUnknownField(
                  input, unknownFields, extensionRegistry, tag)) {
                done = true;
              }
              break;
            }
          }
        }
      } catch (com.google.protobuf.InvalidProtocolBufferException e) {
        throw e.setUnfinishedMessage(this);
      } catch (java.io.IOException e) {
        throw new com.google.protobuf.InvalidProtocolBufferException(
            e).setUnfinishedMessage(this);
      } finally {
        if (((mutable_bitField0_ & 0x00000001) != 0)) {
          resources_ = java.util.Collections.unmodifiableList(resources_);
        }
        this.unknownFields = unknownFields.build();
        makeExtensionsImmutable();
      }
    }
    public static final com.google.protobuf.Descriptors.Descriptor
        getDescriptor() {
      return org.apache.submarine.server.api.proto.TritonModelConfig.internal_static_inference_ModelRateLimiter_descriptor;
    }

    @java.lang.Override
    protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
        internalGetFieldAccessorTable() {
      return org.apache.submarine.server.api.proto.TritonModelConfig.internal_static_inference_ModelRateLimiter_fieldAccessorTable
          .ensureFieldAccessorsInitialized(
              org.apache.submarine.server.api.proto.TritonModelConfig.ModelRateLimiter.class, org.apache.submarine.server.api.proto.TritonModelConfig.ModelRateLimiter.Builder.class);
    }

    public interface ResourceOrBuilder extends
        // @@protoc_insertion_point(interface_extends:inference.ModelRateLimiter.Resource)
        com.google.protobuf.MessageOrBuilder {

      /**
       * <pre>
       *&#64;&#64;  .. cpp:var:: string name
       *&#64;&#64;
       *&#64;&#64;     The name associated with the resource.
       *&#64;&#64;
       * </pre>
       *
       * <code>string name = 1;</code>
       * @return The name.
       */
      java.lang.String getName();
      /**
       * <pre>
       *&#64;&#64;  .. cpp:var:: string name
       *&#64;&#64;
       *&#64;&#64;     The name associated with the resource.
       *&#64;&#64;
       * </pre>
       *
       * <code>string name = 1;</code>
       * @return The bytes for name.
       */
      com.google.protobuf.ByteString
          getNameBytes();

      /**
       * <pre>
       *&#64;&#64;  .. cpp:var:: bool global
       *&#64;&#64;
       *&#64;&#64;     Whether or not the resource is global. If true then the resource
       *&#64;&#64;     is assumed to be shared among the devices otherwise specified
       *&#64;&#64;     count of the resource is assumed for each device associated
       *&#64;&#64;     with the instance.
       *&#64;&#64;
       * </pre>
       *
       * <code>bool global = 2;</code>
       * @return The global.
       */
      boolean getGlobal();

      /**
       * <pre>
       *&#64;&#64;  .. cpp:var:: uint32 count
       *&#64;&#64;
       *&#64;&#64;     The number of resources required for the execution of the model
       *&#64;&#64;     instance.
       *&#64;&#64;
       * </pre>
       *
       * <code>uint32 count = 3;</code>
       * @return The count.
       */
      int getCount();
    }
    /**
     * <pre>
     *&#64;&#64;  .. cpp:var:: message Resource
     *&#64;&#64;
     *&#64;&#64;     The resource property.
     *&#64;&#64;
     * </pre>
     *
     * Protobuf type {@code inference.ModelRateLimiter.Resource}
     */
    public static final class Resource extends
        com.google.protobuf.GeneratedMessageV3 implements
        // @@protoc_insertion_point(message_implements:inference.ModelRateLimiter.Resource)
        ResourceOrBuilder {
    private static final long serialVersionUID = 0L;
      // Use Resource.newBuilder() to construct.
      private Resource(com.google.protobuf.GeneratedMessageV3.Builder<?> builder) {
        super(builder);
      }
      private Resource() {
        name_ = "";
      }

      @java.lang.Override
      @SuppressWarnings({"unused"})
      protected java.lang.Object newInstance(
          UnusedPrivateParameter unused) {
        return new Resource();
      }

      @java.lang.Override
      public final com.google.protobuf.UnknownFieldSet
      getUnknownFields() {
        return this.unknownFields;
      }
      private Resource(
          com.google.protobuf.CodedInputStream input,
          com.google.protobuf.ExtensionRegistryLite extensionRegistry)
          throws com.google.protobuf.InvalidProtocolBufferException {
        this();
        if (extensionRegistry == null) {
          throw new java.lang.NullPointerException();
        }
        com.google.protobuf.UnknownFieldSet.Builder unknownFields =
            com.google.protobuf.UnknownFieldSet.newBuilder();
        try {
          boolean done = false;
          while (!done) {
            int tag = input.readTag();
            switch (tag) {
              case 0:
                done = true;
                break;
              case 10: {
                java.lang.String s = input.readStringRequireUtf8();

                name_ = s;
                break;
              }
              case 16: {

                global_ = input.readBool();
                break;
              }
              case 24: {

                count_ = input.readUInt32();
                break;
              }
              default: {
                if (!parseUnknownField(
                    input, unknownFields, extensionRegistry, tag)) {
                  done = true;
                }
                break;
              }
            }
          }
        } catch (com.google.protobuf.InvalidProtocolBufferException e) {
          throw e.setUnfinishedMessage(this);
        } catch (java.io.IOException e) {
          throw new com.google.protobuf.InvalidProtocolBufferException(
              e).setUnfinishedMessage(this);
        } finally {
          this.unknownFields = unknownFields.build();
          makeExtensionsImmutable();
        }
      }
      public static final com.google.protobuf.Descriptors.Descriptor
          getDescriptor() {
        return org.apache.submarine.server.api.proto.TritonModelConfig.internal_static_inference_ModelRateLimiter_Resource_descriptor;
      }

      @java.lang.Override
      protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
          internalGetFieldAccessorTable() {
        return org.apache.submarine.server.api.proto.TritonModelConfig.internal_static_inference_ModelRateLimiter_Resource_fieldAccessorTable
            .ensureFieldAccessorsInitialized(
                org.apache.submarine.server.api.proto.TritonModelConfig.ModelRateLimiter.Resource.class, org.apache.submarine.server.api.proto.TritonModelConfig.ModelRateLimiter.Resource.Builder.class);
      }

      public static final int NAME_FIELD_NUMBER = 1;
      private volatile java.lang.Object name_;
      /**
       * <pre>
       *&#64;&#64;  .. cpp:var:: string name
       *&#64;&#64;
       *&#64;&#64;     The name associated with the resource.
       *&#64;&#64;
       * </pre>
       *
       * <code>string name = 1;</code>
       * @return The name.
       */
      @java.lang.Override
      public java.lang.String getName() {
        java.lang.Object ref = name_;
        if (ref instanceof java.lang.String) {
          return (java.lang.String) ref;
        } else {
          com.google.protobuf.ByteString bs = 
              (com.google.protobuf.ByteString) ref;
          java.lang.String s = bs.toStringUtf8();
          name_ = s;
          return s;
        }
      }
      /**
       * <pre>
       *&#64;&#64;  .. cpp:var:: string name
       *&#64;&#64;
       *&#64;&#64;     The name associated with the resource.
       *&#64;&#64;
       * </pre>
       *
       * <code>string name = 1;</code>
       * @return The bytes for name.
       */
      @java.lang.Override
      public com.google.protobuf.ByteString
          getNameBytes() {
        java.lang.Object ref = name_;
        if (ref instanceof java.lang.String) {
          com.google.protobuf.ByteString b = 
              com.google.protobuf.ByteString.copyFromUtf8(
                  (java.lang.String) ref);
          name_ = b;
          return b;
        } else {
          return (com.google.protobuf.ByteString) ref;
        }
      }

      public static final int GLOBAL_FIELD_NUMBER = 2;
      private boolean global_;
      /**
       * <pre>
       *&#64;&#64;  .. cpp:var:: bool global
       *&#64;&#64;
       *&#64;&#64;     Whether or not the resource is global. If true then the resource
       *&#64;&#64;     is assumed to be shared among the devices otherwise specified
       *&#64;&#64;     count of the resource is assumed for each device associated
       *&#64;&#64;     with the instance.
       *&#64;&#64;
       * </pre>
       *
       * <code>bool global = 2;</code>
       * @return The global.
       */
      @java.lang.Override
      public boolean getGlobal() {
        return global_;
      }

      public static final int COUNT_FIELD_NUMBER = 3;
      private int count_;
      /**
       * <pre>
       *&#64;&#64;  .. cpp:var:: uint32 count
       *&#64;&#64;
       *&#64;&#64;     The number of resources required for the execution of the model
       *&#64;&#64;     instance.
       *&#64;&#64;
       * </pre>
       *
       * <code>uint32 count = 3;</code>
       * @return The count.
       */
      @java.lang.Override
      public int getCount() {
        return count_;
      }

      private byte memoizedIsInitialized = -1;
      @java.lang.Override
      public final boolean isInitialized() {
        byte isInitialized = memoizedIsInitialized;
        if (isInitialized == 1) return true;
        if (isInitialized == 0) return false;

        memoizedIsInitialized = 1;
        return true;
      }

      @java.lang.Override
      public void writeTo(com.google.protobuf.CodedOutputStream output)
                          throws java.io.IOException {
        if (!getNameBytes().isEmpty()) {
          com.google.protobuf.GeneratedMessageV3.writeString(output, 1, name_);
        }
        if (global_ != false) {
          output.writeBool(2, global_);
        }
        if (count_ != 0) {
          output.writeUInt32(3, count_);
        }
        unknownFields.writeTo(output);
      }

      @java.lang.Override
      public int getSerializedSize() {
        int size = memoizedSize;
        if (size != -1) return size;

        size = 0;
        if (!getNameBytes().isEmpty()) {
          size += com.google.protobuf.GeneratedMessageV3.computeStringSize(1, name_);
        }
        if (global_ != false) {
          size += com.google.protobuf.CodedOutputStream
            .computeBoolSize(2, global_);
        }
        if (count_ != 0) {
          size += com.google.protobuf.CodedOutputStream
            .computeUInt32Size(3, count_);
        }
        size += unknownFields.getSerializedSize();
        memoizedSize = size;
        return size;
      }

      @java.lang.Override
      public boolean equals(final java.lang.Object obj) {
        if (obj == this) {
         return true;
        }
        if (!(obj instanceof org.apache.submarine.server.api.proto.TritonModelConfig.ModelRateLimiter.Resource)) {
          return super.equals(obj);
        }
        org.apache.submarine.server.api.proto.TritonModelConfig.ModelRateLimiter.Resource other = (org.apache.submarine.server.api.proto.TritonModelConfig.ModelRateLimiter.Resource) obj;

        if (!getName()
            .equals(other.getName())) return false;
        if (getGlobal()
            != other.getGlobal()) return false;
        if (getCount()
            != other.getCount()) return false;
        if (!unknownFields.equals(other.unknownFields)) return false;
        return true;
      }

      @java.lang.Override
      public int hashCode() {
        if (memoizedHashCode != 0) {
          return memoizedHashCode;
        }
        int hash = 41;
        hash = (19 * hash) + getDescriptor().hashCode();
        hash = (37 * hash) + NAME_FIELD_NUMBER;
        hash = (53 * hash) + getName().hashCode();
        hash = (37 * hash) + GLOBAL_FIELD_NUMBER;
        hash = (53 * hash) + com.google.protobuf.Internal.hashBoolean(
            getGlobal());
        hash = (37 * hash) + COUNT_FIELD_NUMBER;
        hash = (53 * hash) + getCount();
        hash = (29 * hash) + unknownFields.hashCode();
        memoizedHashCode = hash;
        return hash;
      }

      public static org.apache.submarine.server.api.proto.TritonModelConfig.ModelRateLimiter.Resource parseFrom(
          java.nio.ByteBuffer data)
          throws com.google.protobuf.InvalidProtocolBufferException {
        return PARSER.parseFrom(data);
      }
      public static org.apache.submarine.server.api.proto.TritonModelConfig.ModelRateLimiter.Resource parseFrom(
          java.nio.ByteBuffer data,
          com.google.protobuf.ExtensionRegistryLite extensionRegistry)
          throws com.google.protobuf.InvalidProtocolBufferException {
        return PARSER.parseFrom(data, extensionRegistry);
      }
      public static org.apache.submarine.server.api.proto.TritonModelConfig.ModelRateLimiter.Resource parseFrom(
          com.google.protobuf.ByteString data)
          throws com.google.protobuf.InvalidProtocolBufferException {
        return PARSER.parseFrom(data);
      }
      public static org.apache.submarine.server.api.proto.TritonModelConfig.ModelRateLimiter.Resource parseFrom(
          com.google.protobuf.ByteString data,
          com.google.protobuf.ExtensionRegistryLite extensionRegistry)
          throws com.google.protobuf.InvalidProtocolBufferException {
        return PARSER.parseFrom(data, extensionRegistry);
      }
      public static org.apache.submarine.server.api.proto.TritonModelConfig.ModelRateLimiter.Resource parseFrom(byte[] data)
          throws com.google.protobuf.InvalidProtocolBufferException {
        return PARSER.parseFrom(data);
      }
      public static org.apache.submarine.server.api.proto.TritonModelConfig.ModelRateLimiter.Resource parseFrom(
          byte[] data,
          com.google.protobuf.ExtensionRegistryLite extensionRegistry)
          throws com.google.protobuf.InvalidProtocolBufferException {
        return PARSER.parseFrom(data, extensionRegistry);
      }
      public static org.apache.submarine.server.api.proto.TritonModelConfig.ModelRateLimiter.Resource parseFrom(java.io.InputStream input)
          throws java.io.IOException {
        return com.google.protobuf.GeneratedMessageV3
            .parseWithIOException(PARSER, input);
      }
      public static org.apache.submarine.server.api.proto.TritonModelConfig.ModelRateLimiter.Resource parseFrom(
          java.io.InputStream input,
          com.google.protobuf.ExtensionRegistryLite extensionRegistry)
          throws java.io.IOException {
        return com.google.protobuf.GeneratedMessageV3
            .parseWithIOException(PARSER, input, extensionRegistry);
      }
      public static org.apache.submarine.server.api.proto.TritonModelConfig.ModelRateLimiter.Resource parseDelimitedFrom(java.io.InputStream input)
          throws java.io.IOException {
        return com.google.protobuf.GeneratedMessageV3
            .parseDelimitedWithIOException(PARSER, input);
      }
      public static org.apache.submarine.server.api.proto.TritonModelConfig.ModelRateLimiter.Resource parseDelimitedFrom(
          java.io.InputStream input,
          com.google.protobuf.ExtensionRegistryLite extensionRegistry)
          throws java.io.IOException {
        return com.google.protobuf.GeneratedMessageV3
            .parseDelimitedWithIOException(PARSER, input, extensionRegistry);
      }
      public static org.apache.submarine.server.api.proto.TritonModelConfig.ModelRateLimiter.Resource parseFrom(
          com.google.protobuf.CodedInputStream input)
          throws java.io.IOException {
        return com.google.protobuf.GeneratedMessageV3
            .parseWithIOException(PARSER, input);
      }
      public static org.apache.submarine.server.api.proto.TritonModelConfig.ModelRateLimiter.Resource parseFrom(
          com.google.protobuf.CodedInputStream input,
          com.google.protobuf.ExtensionRegistryLite extensionRegistry)
          throws java.io.IOException {
        return com.google.protobuf.GeneratedMessageV3
            .parseWithIOException(PARSER, input, extensionRegistry);
      }

      @java.lang.Override
      public Builder newBuilderForType() { return newBuilder(); }
      public static Builder newBuilder() {
        return DEFAULT_INSTANCE.toBuilder();
      }
      public static Builder newBuilder(org.apache.submarine.server.api.proto.TritonModelConfig.ModelRateLimiter.Resource prototype) {
        return DEFAULT_INSTANCE.toBuilder().mergeFrom(prototype);
      }
      @java.lang.Override
      public Builder toBuilder() {
        return this == DEFAULT_INSTANCE
            ? new Builder() : new Builder().mergeFrom(this);
      }

      @java.lang.Override
      protected Builder newBuilderForType(
          com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
        Builder builder = new Builder(parent);
        return builder;
      }
      /**
       * <pre>
       *&#64;&#64;  .. cpp:var:: message Resource
       *&#64;&#64;
       *&#64;&#64;     The resource property.
       *&#64;&#64;
       * </pre>
       *
       * Protobuf type {@code inference.ModelRateLimiter.Resource}
       */
      public static final class Builder extends
          com.google.protobuf.GeneratedMessageV3.Builder<Builder> implements
          // @@protoc_insertion_point(builder_implements:inference.ModelRateLimiter.Resource)
          org.apache.submarine.server.api.proto.TritonModelConfig.ModelRateLimiter.ResourceOrBuilder {
        public static final com.google.protobuf.Descriptors.Descriptor
            getDescriptor() {
          return org.apache.submarine.server.api.proto.TritonModelConfig.internal_static_inference_ModelRateLimiter_Resource_descriptor;
        }

        @java.lang.Override
        protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
            internalGetFieldAccessorTable() {
          return org.apache.submarine.server.api.proto.TritonModelConfig.internal_static_inference_ModelRateLimiter_Resource_fieldAccessorTable
              .ensureFieldAccessorsInitialized(
                  org.apache.submarine.server.api.proto.TritonModelConfig.ModelRateLimiter.Resource.class, org.apache.submarine.server.api.proto.TritonModelConfig.ModelRateLimiter.Resource.Builder.class);
        }

        // Construct using org.apache.submarine.server.api.proto.TritonModelConfig.ModelRateLimiter.Resource.newBuilder()
        private Builder() {
          maybeForceBuilderInitialization();
        }

        private Builder(
            com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
          super(parent);
          maybeForceBuilderInitialization();
        }
        private void maybeForceBuilderInitialization() {
          if (com.google.protobuf.GeneratedMessageV3
                  .alwaysUseFieldBuilders) {
          }
        }
        @java.lang.Override
        public Builder clear() {
          super.clear();
          name_ = "";

          global_ = false;

          count_ = 0;

          return this;
        }

        @java.lang.Override
        public com.google.protobuf.Descriptors.Descriptor
            getDescriptorForType() {
          return org.apache.submarine.server.api.proto.TritonModelConfig.internal_static_inference_ModelRateLimiter_Resource_descriptor;
        }

        @java.lang.Override
        public org.apache.submarine.server.api.proto.TritonModelConfig.ModelRateLimiter.Resource getDefaultInstanceForType() {
          return org.apache.submarine.server.api.proto.TritonModelConfig.ModelRateLimiter.Resource.getDefaultInstance();
        }

        @java.lang.Override
        public org.apache.submarine.server.api.proto.TritonModelConfig.ModelRateLimiter.Resource build() {
          org.apache.submarine.server.api.proto.TritonModelConfig.ModelRateLimiter.Resource result = buildPartial();
          if (!result.isInitialized()) {
            throw newUninitializedMessageException(result);
          }
          return result;
        }

        @java.lang.Override
        public org.apache.submarine.server.api.proto.TritonModelConfig.ModelRateLimiter.Resource buildPartial() {
          org.apache.submarine.server.api.proto.TritonModelConfig.ModelRateLimiter.Resource result = new org.apache.submarine.server.api.proto.TritonModelConfig.ModelRateLimiter.Resource(this);
          result.name_ = name_;
          result.global_ = global_;
          result.count_ = count_;
          onBuilt();
          return result;
        }

        @java.lang.Override
        public Builder clone() {
          return super.clone();
        }
        @java.lang.Override
        public Builder setField(
            com.google.protobuf.Descriptors.FieldDescriptor field,
            java.lang.Object value) {
          return super.setField(field, value);
        }
        @java.lang.Override
        public Builder clearField(
            com.google.protobuf.Descriptors.FieldDescriptor field) {
          return super.clearField(field);
        }
        @java.lang.Override
        public Builder clearOneof(
            com.google.protobuf.Descriptors.OneofDescriptor oneof) {
          return super.clearOneof(oneof);
        }
        @java.lang.Override
        public Builder setRepeatedField(
            com.google.protobuf.Descriptors.FieldDescriptor field,
            int index, java.lang.Object value) {
          return super.setRepeatedField(field, index, value);
        }
        @java.lang.Override
        public Builder addRepeatedField(
            com.google.protobuf.Descriptors.FieldDescriptor field,
            java.lang.Object value) {
          return super.addRepeatedField(field, value);
        }
        @java.lang.Override
        public Builder mergeFrom(com.google.protobuf.Message other) {
          if (other instanceof org.apache.submarine.server.api.proto.TritonModelConfig.ModelRateLimiter.Resource) {
            return mergeFrom((org.apache.submarine.server.api.proto.TritonModelConfig.ModelRateLimiter.Resource)other);
          } else {
            super.mergeFrom(other);
            return this;
          }
        }

        public Builder mergeFrom(org.apache.submarine.server.api.proto.TritonModelConfig.ModelRateLimiter.Resource other) {
          if (other == org.apache.submarine.server.api.proto.TritonModelConfig.ModelRateLimiter.Resource.getDefaultInstance()) return this;
          if (!other.getName().isEmpty()) {
            name_ = other.name_;
            onChanged();
          }
          if (other.getGlobal() != false) {
            setGlobal(other.getGlobal());
          }
          if (other.getCount() != 0) {
            setCount(other.getCount());
          }
          this.mergeUnknownFields(other.unknownFields);
          onChanged();
          return this;
        }

        @java.lang.Override
        public final boolean isInitialized() {
          return true;
        }

        @java.lang.Override
        public Builder mergeFrom(
            com.google.protobuf.CodedInputStream input,
            com.google.protobuf.ExtensionRegistryLite extensionRegistry)
            throws java.io.IOException {
          org.apache.submarine.server.api.proto.TritonModelConfig.ModelRateLimiter.Resource parsedMessage = null;
          try {
            parsedMessage = PARSER.parsePartialFrom(input, extensionRegistry);
          } catch (com.google.protobuf.InvalidProtocolBufferException e) {
            parsedMessage = (org.apache.submarine.server.api.proto.TritonModelConfig.ModelRateLimiter.Resource) e.getUnfinishedMessage();
            throw e.unwrapIOException();
          } finally {
            if (parsedMessage != null) {
              mergeFrom(parsedMessage);
            }
          }
          return this;
        }

        private java.lang.Object name_ = "";
        /**
         * <pre>
         *&#64;&#64;  .. cpp:var:: string name
         *&#64;&#64;
         *&#64;&#64;     The name associated with the resource.
         *&#64;&#64;
         * </pre>
         *
         * <code>string name = 1;</code>
         * @return The name.
         */
        public java.lang.String getName() {
          java.lang.Object ref = name_;
          if (!(ref instanceof java.lang.String)) {
            com.google.protobuf.ByteString bs =
                (com.google.protobuf.ByteString) ref;
            java.lang.String s = bs.toStringUtf8();
            name_ = s;
            return s;
          } else {
            return (java.lang.String) ref;
          }
        }
        /**
         * <pre>
         *&#64;&#64;  .. cpp:var:: string name
         *&#64;&#64;
         *&#64;&#64;     The name associated with the resource.
         *&#64;&#64;
         * </pre>
         *
         * <code>string name = 1;</code>
         * @return The bytes for name.
         */
        public com.google.protobuf.ByteString
            getNameBytes() {
          java.lang.Object ref = name_;
          if (ref instanceof String) {
            com.google.protobuf.ByteString b = 
                com.google.protobuf.ByteString.copyFromUtf8(
                    (java.lang.String) ref);
            name_ = b;
            return b;
          } else {
            return (com.google.protobuf.ByteString) ref;
          }
        }
        /**
         * <pre>
         *&#64;&#64;  .. cpp:var:: string name
         *&#64;&#64;
         *&#64;&#64;     The name associated with the resource.
         *&#64;&#64;
         * </pre>
         *
         * <code>string name = 1;</code>
         * @param value The name to set.
         * @return This builder for chaining.
         */
        public Builder setName(
            java.lang.String value) {
          if (value == null) {
    throw new NullPointerException();
  }
  
          name_ = value;
          onChanged();
          return this;
        }
        /**
         * <pre>
         *&#64;&#64;  .. cpp:var:: string name
         *&#64;&#64;
         *&#64;&#64;     The name associated with the resource.
         *&#64;&#64;
         * </pre>
         *
         * <code>string name = 1;</code>
         * @return This builder for chaining.
         */
        public Builder clearName() {
          
          name_ = getDefaultInstance().getName();
          onChanged();
          return this;
        }
        /**
         * <pre>
         *&#64;&#64;  .. cpp:var:: string name
         *&#64;&#64;
         *&#64;&#64;     The name associated with the resource.
         *&#64;&#64;
         * </pre>
         *
         * <code>string name = 1;</code>
         * @param value The bytes for name to set.
         * @return This builder for chaining.
         */
        public Builder setNameBytes(
            com.google.protobuf.ByteString value) {
          if (value == null) {
    throw new NullPointerException();
  }
  checkByteStringIsUtf8(value);
          
          name_ = value;
          onChanged();
          return this;
        }

        private boolean global_ ;
        /**
         * <pre>
         *&#64;&#64;  .. cpp:var:: bool global
         *&#64;&#64;
         *&#64;&#64;     Whether or not the resource is global. If true then the resource
         *&#64;&#64;     is assumed to be shared among the devices otherwise specified
         *&#64;&#64;     count of the resource is assumed for each device associated
         *&#64;&#64;     with the instance.
         *&#64;&#64;
         * </pre>
         *
         * <code>bool global = 2;</code>
         * @return The global.
         */
        @java.lang.Override
        public boolean getGlobal() {
          return global_;
        }
        /**
         * <pre>
         *&#64;&#64;  .. cpp:var:: bool global
         *&#64;&#64;
         *&#64;&#64;     Whether or not the resource is global. If true then the resource
         *&#64;&#64;     is assumed to be shared among the devices otherwise specified
         *&#64;&#64;     count of the resource is assumed for each device associated
         *&#64;&#64;     with the instance.
         *&#64;&#64;
         * </pre>
         *
         * <code>bool global = 2;</code>
         * @param value The global to set.
         * @return This builder for chaining.
         */
        public Builder setGlobal(boolean value) {
          
          global_ = value;
          onChanged();
          return this;
        }
        /**
         * <pre>
         *&#64;&#64;  .. cpp:var:: bool global
         *&#64;&#64;
         *&#64;&#64;     Whether or not the resource is global. If true then the resource
         *&#64;&#64;     is assumed to be shared among the devices otherwise specified
         *&#64;&#64;     count of the resource is assumed for each device associated
         *&#64;&#64;     with the instance.
         *&#64;&#64;
         * </pre>
         *
         * <code>bool global = 2;</code>
         * @return This builder for chaining.
         */
        public Builder clearGlobal() {
          
          global_ = false;
          onChanged();
          return this;
        }

        private int count_ ;
        /**
         * <pre>
         *&#64;&#64;  .. cpp:var:: uint32 count
         *&#64;&#64;
         *&#64;&#64;     The number of resources required for the execution of the model
         *&#64;&#64;     instance.
         *&#64;&#64;
         * </pre>
         *
         * <code>uint32 count = 3;</code>
         * @return The count.
         */
        @java.lang.Override
        public int getCount() {
          return count_;
        }
        /**
         * <pre>
         *&#64;&#64;  .. cpp:var:: uint32 count
         *&#64;&#64;
         *&#64;&#64;     The number of resources required for the execution of the model
         *&#64;&#64;     instance.
         *&#64;&#64;
         * </pre>
         *
         * <code>uint32 count = 3;</code>
         * @param value The count to set.
         * @return This builder for chaining.
         */
        public Builder setCount(int value) {
          
          count_ = value;
          onChanged();
          return this;
        }
        /**
         * <pre>
         *&#64;&#64;  .. cpp:var:: uint32 count
         *&#64;&#64;
         *&#64;&#64;     The number of resources required for the execution of the model
         *&#64;&#64;     instance.
         *&#64;&#64;
         * </pre>
         *
         * <code>uint32 count = 3;</code>
         * @return This builder for chaining.
         */
        public Builder clearCount() {
          
          count_ = 0;
          onChanged();
          return this;
        }
        @java.lang.Override
        public final Builder setUnknownFields(
            final com.google.protobuf.UnknownFieldSet unknownFields) {
          return super.setUnknownFields(unknownFields);
        }

        @java.lang.Override
        public final Builder mergeUnknownFields(
            final com.google.protobuf.UnknownFieldSet unknownFields) {
          return super.mergeUnknownFields(unknownFields);
        }


        // @@protoc_insertion_point(builder_scope:inference.ModelRateLimiter.Resource)
      }

      // @@protoc_insertion_point(class_scope:inference.ModelRateLimiter.Resource)
      private static final org.apache.submarine.server.api.proto.TritonModelConfig.ModelRateLimiter.Resource DEFAULT_INSTANCE;
      static {
        DEFAULT_INSTANCE = new org.apache.submarine.server.api.proto.TritonModelConfig.ModelRateLimiter.Resource();
      }

      public static org.apache.submarine.server.api.proto.TritonModelConfig.ModelRateLimiter.Resource getDefaultInstance() {
        return DEFAULT_INSTANCE;
      }

      private static final com.google.protobuf.Parser<Resource>
          PARSER = new com.google.protobuf.AbstractParser<Resource>() {
        @java.lang.Override
        public Resource parsePartialFrom(
            com.google.protobuf.CodedInputStream input,
            com.google.protobuf.ExtensionRegistryLite extensionRegistry)
            throws com.google.protobuf.InvalidProtocolBufferException {
          return new Resource(input, extensionRegistry);
        }
      };

      public static com.google.protobuf.Parser<Resource> parser() {
        return PARSER;
      }

      @java.lang.Override
      public com.google.protobuf.Parser<Resource> getParserForType() {
        return PARSER;
      }

      @java.lang.Override
      public org.apache.submarine.server.api.proto.TritonModelConfig.ModelRateLimiter.Resource getDefaultInstanceForType() {
        return DEFAULT_INSTANCE;
      }

    }

    public static final int RESOURCES_FIELD_NUMBER = 1;
    private java.util.List<org.apache.submarine.server.api.proto.TritonModelConfig.ModelRateLimiter.Resource> resources_;
    /**
     * <pre>
     *&#64;&#64;  .. cpp:var:: Resource resources (repeated)
     *&#64;&#64;
     *&#64;&#64;     The resources required to execute the request on a model instance.
     *&#64;&#64;     Resources are just names with a corresponding count. The execution
     *&#64;&#64;     of the instance will be blocked until the specificied resources are
     *&#64;&#64;     available. By default an instance uses no rate-limiter resources.
     *&#64;&#64;
     * </pre>
     *
     * <code>repeated .inference.ModelRateLimiter.Resource resources = 1;</code>
     */
    @java.lang.Override
    public java.util.List<org.apache.submarine.server.api.proto.TritonModelConfig.ModelRateLimiter.Resource> getResourcesList() {
      return resources_;
    }
    /**
     * <pre>
     *&#64;&#64;  .. cpp:var:: Resource resources (repeated)
     *&#64;&#64;
     *&#64;&#64;     The resources required to execute the request on a model instance.
     *&#64;&#64;     Resources are just names with a corresponding count. The execution
     *&#64;&#64;     of the instance will be blocked until the specificied resources are
     *&#64;&#64;     available. By default an instance uses no rate-limiter resources.
     *&#64;&#64;
     * </pre>
     *
     * <code>repeated .inference.ModelRateLimiter.Resource resources = 1;</code>
     */
    @java.lang.Override
    public java.util.List<? extends org.apache.submarine.server.api.proto.TritonModelConfig.ModelRateLimiter.ResourceOrBuilder> 
        getResourcesOrBuilderList() {
      return resources_;
    }
    /**
     * <pre>
     *&#64;&#64;  .. cpp:var:: Resource resources (repeated)
     *&#64;&#64;
     *&#64;&#64;     The resources required to execute the request on a model instance.
     *&#64;&#64;     Resources are just names with a corresponding count. The execution
     *&#64;&#64;     of the instance will be blocked until the specificied resources are
     *&#64;&#64;     available. By default an instance uses no rate-limiter resources.
     *&#64;&#64;
     * </pre>
     *
     * <code>repeated .inference.ModelRateLimiter.Resource resources = 1;</code>
     */
    @java.lang.Override
    public int getResourcesCount() {
      return resources_.size();
    }
    /**
     * <pre>
     *&#64;&#64;  .. cpp:var:: Resource resources (repeated)
     *&#64;&#64;
     *&#64;&#64;     The resources required to execute the request on a model instance.
     *&#64;&#64;     Resources are just names with a corresponding count. The execution
     *&#64;&#64;     of the instance will be blocked until the specificied resources are
     *&#64;&#64;     available. By default an instance uses no rate-limiter resources.
     *&#64;&#64;
     * </pre>
     *
     * <code>repeated .inference.ModelRateLimiter.Resource resources = 1;</code>
     */
    @java.lang.Override
    public org.apache.submarine.server.api.proto.TritonModelConfig.ModelRateLimiter.Resource getResources(int index) {
      return resources_.get(index);
    }
    /**
     * <pre>
     *&#64;&#64;  .. cpp:var:: Resource resources (repeated)
     *&#64;&#64;
     *&#64;&#64;     The resources required to execute the request on a model instance.
     *&#64;&#64;     Resources are just names with a corresponding count. The execution
     *&#64;&#64;     of the instance will be blocked until the specificied resources are
     *&#64;&#64;     available. By default an instance uses no rate-limiter resources.
     *&#64;&#64;
     * </pre>
     *
     * <code>repeated .inference.ModelRateLimiter.Resource resources = 1;</code>
     */
    @java.lang.Override
    public org.apache.submarine.server.api.proto.TritonModelConfig.ModelRateLimiter.ResourceOrBuilder getResourcesOrBuilder(
        int index) {
      return resources_.get(index);
    }

    public static final int PRIORITY_FIELD_NUMBER = 2;
    private int priority_;
    /**
     * <pre>
     *&#64;&#64;  .. cpp:var:: uint32 priority
     *&#64;&#64;
     *&#64;&#64;     The optional weighting value to be used for prioritizing across
     *&#64;&#64;     instances. An instance with priority 2 will be given 1/2 the
     *&#64;&#64;     number of scheduling chances as an instance_group with priority
     *&#64;&#64;     1. The default priority is 1. The priority of value 0 will be
     *&#64;&#64;     treated as priority 1.
     *&#64;&#64;
     * </pre>
     *
     * <code>uint32 priority = 2;</code>
     * @return The priority.
     */
    @java.lang.Override
    public int getPriority() {
      return priority_;
    }

    private byte memoizedIsInitialized = -1;
    @java.lang.Override
    public final boolean isInitialized() {
      byte isInitialized = memoizedIsInitialized;
      if (isInitialized == 1) return true;
      if (isInitialized == 0) return false;

      memoizedIsInitialized = 1;
      return true;
    }

    @java.lang.Override
    public void writeTo(com.google.protobuf.CodedOutputStream output)
                        throws java.io.IOException {
      for (int i = 0; i < resources_.size(); i++) {
        output.writeMessage(1, resources_.get(i));
      }
      if (priority_ != 0) {
        output.writeUInt32(2, priority_);
      }
      unknownFields.writeTo(output);
    }

    @java.lang.Override
    public int getSerializedSize() {
      int size = memoizedSize;
      if (size != -1) return size;

      size = 0;
      for (int i = 0; i < resources_.size(); i++) {
        size += com.google.protobuf.CodedOutputStream
          .computeMessageSize(1, resources_.get(i));
      }
      if (priority_ != 0) {
        size += com.google.protobuf.CodedOutputStream
          .computeUInt32Size(2, priority_);
      }
      size += unknownFields.getSerializedSize();
      memoizedSize = size;
      return size;
    }

    @java.lang.Override
    public boolean equals(final java.lang.Object obj) {
      if (obj == this) {
       return true;
      }
      if (!(obj instanceof org.apache.submarine.server.api.proto.TritonModelConfig.ModelRateLimiter)) {
        return super.equals(obj);
      }
      org.apache.submarine.server.api.proto.TritonModelConfig.ModelRateLimiter other = (org.apache.submarine.server.api.proto.TritonModelConfig.ModelRateLimiter) obj;

      if (!getResourcesList()
          .equals(other.getResourcesList())) return false;
      if (getPriority()
          != other.getPriority()) return false;
      if (!unknownFields.equals(other.unknownFields)) return false;
      return true;
    }

    @java.lang.Override
    public int hashCode() {
      if (memoizedHashCode != 0) {
        return memoizedHashCode;
      }
      int hash = 41;
      hash = (19 * hash) + getDescriptor().hashCode();
      if (getResourcesCount() > 0) {
        hash = (37 * hash) + RESOURCES_FIELD_NUMBER;
        hash = (53 * hash) + getResourcesList().hashCode();
      }
      hash = (37 * hash) + PRIORITY_FIELD_NUMBER;
      hash = (53 * hash) + getPriority();
      hash = (29 * hash) + unknownFields.hashCode();
      memoizedHashCode = hash;
      return hash;
    }

    public static org.apache.submarine.server.api.proto.TritonModelConfig.ModelRateLimiter parseFrom(
        java.nio.ByteBuffer data)
        throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data);
    }
    public static org.apache.submarine.server.api.proto.TritonModelConfig.ModelRateLimiter parseFrom(
        java.nio.ByteBuffer data,
        com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data, extensionRegistry);
    }
    public static org.apache.submarine.server.api.proto.TritonModelConfig.ModelRateLimiter parseFrom(
        com.google.protobuf.ByteString data)
        throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data);
    }
    public static org.apache.submarine.server.api.proto.TritonModelConfig.ModelRateLimiter parseFrom(
        com.google.protobuf.ByteString data,
        com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data, extensionRegistry);
    }
    public static org.apache.submarine.server.api.proto.TritonModelConfig.ModelRateLimiter parseFrom(byte[] data)
        throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data);
    }
    public static org.apache.submarine.server.api.proto.TritonModelConfig.ModelRateLimiter parseFrom(
        byte[] data,
        com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data, extensionRegistry);
    }
    public static org.apache.submarine.server.api.proto.TritonModelConfig.ModelRateLimiter parseFrom(java.io.InputStream input)
        throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3
          .parseWithIOException(PARSER, input);
    }
    public static org.apache.submarine.server.api.proto.TritonModelConfig.ModelRateLimiter parseFrom(
        java.io.InputStream input,
        com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3
          .parseWithIOException(PARSER, input, extensionRegistry);
    }
    public static org.apache.submarine.server.api.proto.TritonModelConfig.ModelRateLimiter parseDelimitedFrom(java.io.InputStream input)
        throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3
          .parseDelimitedWithIOException(PARSER, input);
    }
    public static org.apache.submarine.server.api.proto.TritonModelConfig.ModelRateLimiter parseDelimitedFrom(
        java.io.InputStream input,
        com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3
          .parseDelimitedWithIOException(PARSER, input, extensionRegistry);
    }
    public static org.apache.submarine.server.api.proto.TritonModelConfig.ModelRateLimiter parseFrom(
        com.google.protobuf.CodedInputStream input)
        throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3
          .parseWithIOException(PARSER, input);
    }
    public static org.apache.submarine.server.api.proto.TritonModelConfig.ModelRateLimiter parseFrom(
        com.google.protobuf.CodedInputStream input,
        com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3
          .parseWithIOException(PARSER, input, extensionRegistry);
    }

    @java.lang.Override
    public Builder newBuilderForType() { return newBuilder(); }
    public static Builder newBuilder() {
      return DEFAULT_INSTANCE.toBuilder();
    }
    public static Builder newBuilder(org.apache.submarine.server.api.proto.TritonModelConfig.ModelRateLimiter prototype) {
      return DEFAULT_INSTANCE.toBuilder().mergeFrom(prototype);
    }
    @java.lang.Override
    public Builder toBuilder() {
      return this == DEFAULT_INSTANCE
          ? new Builder() : new Builder().mergeFrom(this);
    }

    @java.lang.Override
    protected Builder newBuilderForType(
        com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
      Builder builder = new Builder(parent);
      return builder;
    }
    /**
     * <pre>
     *&#64;&#64;
     *&#64;&#64;  .. cpp:var:: message ModelRateLimiter
     *&#64;&#64;
     *&#64;&#64;     The specifications required by the rate limiter to properly
     *&#64;&#64;     schedule the inference requests across the different models
     *&#64;&#64;     and their instances.
     *&#64;&#64;
     * </pre>
     *
     * Protobuf type {@code inference.ModelRateLimiter}
     */
    public static final class Builder extends
        com.google.protobuf.GeneratedMessageV3.Builder<Builder> implements
        // @@protoc_insertion_point(builder_implements:inference.ModelRateLimiter)
        org.apache.submarine.server.api.proto.TritonModelConfig.ModelRateLimiterOrBuilder {
      public static final com.google.protobuf.Descriptors.Descriptor
          getDescriptor() {
        return org.apache.submarine.server.api.proto.TritonModelConfig.internal_static_inference_ModelRateLimiter_descriptor;
      }

      @java.lang.Override
      protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
          internalGetFieldAccessorTable() {
        return org.apache.submarine.server.api.proto.TritonModelConfig.internal_static_inference_ModelRateLimiter_fieldAccessorTable
            .ensureFieldAccessorsInitialized(
                org.apache.submarine.server.api.proto.TritonModelConfig.ModelRateLimiter.class, org.apache.submarine.server.api.proto.TritonModelConfig.ModelRateLimiter.Builder.class);
      }

      // Construct using org.apache.submarine.server.api.proto.TritonModelConfig.ModelRateLimiter.newBuilder()
      private Builder() {
        maybeForceBuilderInitialization();
      }

      private Builder(
          com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
        super(parent);
        maybeForceBuilderInitialization();
      }
      private void maybeForceBuilderInitialization() {
        if (com.google.protobuf.GeneratedMessageV3
                .alwaysUseFieldBuilders) {
          getResourcesFieldBuilder();
        }
      }
      @java.lang.Override
      public Builder clear() {
        super.clear();
        if (resourcesBuilder_ == null) {
          resources_ = java.util.Collections.emptyList();
          bitField0_ = (bitField0_ & ~0x00000001);
        } else {
          resourcesBuilder_.clear();
        }
        priority_ = 0;

        return this;
      }

      @java.lang.Override
      public com.google.protobuf.Descriptors.Descriptor
          getDescriptorForType() {
        return org.apache.submarine.server.api.proto.TritonModelConfig.internal_static_inference_ModelRateLimiter_descriptor;
      }

      @java.lang.Override
      public org.apache.submarine.server.api.proto.TritonModelConfig.ModelRateLimiter getDefaultInstanceForType() {
        return org.apache.submarine.server.api.proto.TritonModelConfig.ModelRateLimiter.getDefaultInstance();
      }

      @java.lang.Override
      public org.apache.submarine.server.api.proto.TritonModelConfig.ModelRateLimiter build() {
        org.apache.submarine.server.api.proto.TritonModelConfig.ModelRateLimiter result = buildPartial();
        if (!result.isInitialized()) {
          throw newUninitializedMessageException(result);
        }
        return result;
      }

      @java.lang.Override
      public org.apache.submarine.server.api.proto.TritonModelConfig.ModelRateLimiter buildPartial() {
        org.apache.submarine.server.api.proto.TritonModelConfig.ModelRateLimiter result = new org.apache.submarine.server.api.proto.TritonModelConfig.ModelRateLimiter(this);
        int from_bitField0_ = bitField0_;
        if (resourcesBuilder_ == null) {
          if (((bitField0_ & 0x00000001) != 0)) {
            resources_ = java.util.Collections.unmodifiableList(resources_);
            bitField0_ = (bitField0_ & ~0x00000001);
          }
          result.resources_ = resources_;
        } else {
          result.resources_ = resourcesBuilder_.build();
        }
        result.priority_ = priority_;
        onBuilt();
        return result;
      }

      @java.lang.Override
      public Builder clone() {
        return super.clone();
      }
      @java.lang.Override
      public Builder setField(
          com.google.protobuf.Descriptors.FieldDescriptor field,
          java.lang.Object value) {
        return super.setField(field, value);
      }
      @java.lang.Override
      public Builder clearField(
          com.google.protobuf.Descriptors.FieldDescriptor field) {
        return super.clearField(field);
      }
      @java.lang.Override
      public Builder clearOneof(
          com.google.protobuf.Descriptors.OneofDescriptor oneof) {
        return super.clearOneof(oneof);
      }
      @java.lang.Override
      public Builder setRepeatedField(
          com.google.protobuf.Descriptors.FieldDescriptor field,
          int index, java.lang.Object value) {
        return super.setRepeatedField(field, index, value);
      }
      @java.lang.Override
      public Builder addRepeatedField(
          com.google.protobuf.Descriptors.FieldDescriptor field,
          java.lang.Object value) {
        return super.addRepeatedField(field, value);
      }
      @java.lang.Override
      public Builder mergeFrom(com.google.protobuf.Message other) {
        if (other instanceof org.apache.submarine.server.api.proto.TritonModelConfig.ModelRateLimiter) {
          return mergeFrom((org.apache.submarine.server.api.proto.TritonModelConfig.ModelRateLimiter)other);
        } else {
          super.mergeFrom(other);
          return this;
        }
      }

      public Builder mergeFrom(org.apache.submarine.server.api.proto.TritonModelConfig.ModelRateLimiter other) {
        if (other == org.apache.submarine.server.api.proto.TritonModelConfig.ModelRateLimiter.getDefaultInstance()) return this;
        if (resourcesBuilder_ == null) {
          if (!other.resources_.isEmpty()) {
            if (resources_.isEmpty()) {
              resources_ = other.resources_;
              bitField0_ = (bitField0_ & ~0x00000001);
            } else {
              ensureResourcesIsMutable();
              resources_.addAll(other.resources_);
            }
            onChanged();
          }
        } else {
          if (!other.resources_.isEmpty()) {
            if (resourcesBuilder_.isEmpty()) {
              resourcesBuilder_.dispose();
              resourcesBuilder_ = null;
              resources_ = other.resources_;
              bitField0_ = (bitField0_ & ~0x00000001);
              resourcesBuilder_ = 
                com.google.protobuf.GeneratedMessageV3.alwaysUseFieldBuilders ?
                   getResourcesFieldBuilder() : null;
            } else {
              resourcesBuilder_.addAllMessages(other.resources_);
            }
          }
        }
        if (other.getPriority() != 0) {
          setPriority(other.getPriority());
        }
        this.mergeUnknownFields(other.unknownFields);
        onChanged();
        return this;
      }

      @java.lang.Override
      public final boolean isInitialized() {
        return true;
      }

      @java.lang.Override
      public Builder mergeFrom(
          com.google.protobuf.CodedInputStream input,
          com.google.protobuf.ExtensionRegistryLite extensionRegistry)
          throws java.io.IOException {
        org.apache.submarine.server.api.proto.TritonModelConfig.ModelRateLimiter parsedMessage = null;
        try {
          parsedMessage = PARSER.parsePartialFrom(input, extensionRegistry);
        } catch (com.google.protobuf.InvalidProtocolBufferException e) {
          parsedMessage = (org.apache.submarine.server.api.proto.TritonModelConfig.ModelRateLimiter) e.getUnfinishedMessage();
          throw e.unwrapIOException();
        } finally {
          if (parsedMessage != null) {
            mergeFrom(parsedMessage);
          }
        }
        return this;
      }
      private int bitField0_;

      private java.util.List<org.apache.submarine.server.api.proto.TritonModelConfig.ModelRateLimiter.Resource> resources_ =
        java.util.Collections.emptyList();
      private void ensureResourcesIsMutable() {
        if (!((bitField0_ & 0x00000001) != 0)) {
          resources_ = new java.util.ArrayList<org.apache.submarine.server.api.proto.TritonModelConfig.ModelRateLimiter.Resource>(resources_);
          bitField0_ |= 0x00000001;
         }
      }

      private com.google.protobuf.RepeatedFieldBuilderV3<
          org.apache.submarine.server.api.proto.TritonModelConfig.ModelRateLimiter.Resource, org.apache.submarine.server.api.proto.TritonModelConfig.ModelRateLimiter.Resource.Builder, org.apache.submarine.server.api.proto.TritonModelConfig.ModelRateLimiter.ResourceOrBuilder> resourcesBuilder_;

      /**
       * <pre>
       *&#64;&#64;  .. cpp:var:: Resource resources (repeated)
       *&#64;&#64;
       *&#64;&#64;     The resources required to execute the request on a model instance.
       *&#64;&#64;     Resources are just names with a corresponding count. The execution
       *&#64;&#64;     of the instance will be blocked until the specificied resources are
       *&#64;&#64;     available. By default an instance uses no rate-limiter resources.
       *&#64;&#64;
       * </pre>
       *
       * <code>repeated .inference.ModelRateLimiter.Resource resources = 1;</code>
       */
      public java.util.List<org.apache.submarine.server.api.proto.TritonModelConfig.ModelRateLimiter.Resource> getResourcesList() {
        if (resourcesBuilder_ == null) {
          return java.util.Collections.unmodifiableList(resources_);
        } else {
          return resourcesBuilder_.getMessageList();
        }
      }
      /**
       * <pre>
       *&#64;&#64;  .. cpp:var:: Resource resources (repeated)
       *&#64;&#64;
       *&#64;&#64;     The resources required to execute the request on a model instance.
       *&#64;&#64;     Resources are just names with a corresponding count. The execution
       *&#64;&#64;     of the instance will be blocked until the specificied resources are
       *&#64;&#64;     available. By default an instance uses no rate-limiter resources.
       *&#64;&#64;
       * </pre>
       *
       * <code>repeated .inference.ModelRateLimiter.Resource resources = 1;</code>
       */
      public int getResourcesCount() {
        if (resourcesBuilder_ == null) {
          return resources_.size();
        } else {
          return resourcesBuilder_.getCount();
        }
      }
      /**
       * <pre>
       *&#64;&#64;  .. cpp:var:: Resource resources (repeated)
       *&#64;&#64;
       *&#64;&#64;     The resources required to execute the request on a model instance.
       *&#64;&#64;     Resources are just names with a corresponding count. The execution
       *&#64;&#64;     of the instance will be blocked until the specificied resources are
       *&#64;&#64;     available. By default an instance uses no rate-limiter resources.
       *&#64;&#64;
       * </pre>
       *
       * <code>repeated .inference.ModelRateLimiter.Resource resources = 1;</code>
       */
      public org.apache.submarine.server.api.proto.TritonModelConfig.ModelRateLimiter.Resource getResources(int index) {
        if (resourcesBuilder_ == null) {
          return resources_.get(index);
        } else {
          return resourcesBuilder_.getMessage(index);
        }
      }
      /**
       * <pre>
       *&#64;&#64;  .. cpp:var:: Resource resources (repeated)
       *&#64;&#64;
       *&#64;&#64;     The resources required to execute the request on a model instance.
       *&#64;&#64;     Resources are just names with a corresponding count. The execution
       *&#64;&#64;     of the instance will be blocked until the specificied resources are
       *&#64;&#64;     available. By default an instance uses no rate-limiter resources.
       *&#64;&#64;
       * </pre>
       *
       * <code>repeated .inference.ModelRateLimiter.Resource resources = 1;</code>
       */
      public Builder setResources(
          int index, org.apache.submarine.server.api.proto.TritonModelConfig.ModelRateLimiter.Resource value) {
        if (resourcesBuilder_ == null) {
          if (value == null) {
            throw new NullPointerException();
          }
          ensureResourcesIsMutable();
          resources_.set(index, value);
          onChanged();
        } else {
          resourcesBuilder_.setMessage(index, value);
        }
        return this;
      }
      /**
       * <pre>
       *&#64;&#64;  .. cpp:var:: Resource resources (repeated)
       *&#64;&#64;
       *&#64;&#64;     The resources required to execute the request on a model instance.
       *&#64;&#64;     Resources are just names with a corresponding count. The execution
       *&#64;&#64;     of the instance will be blocked until the specificied resources are
       *&#64;&#64;     available. By default an instance uses no rate-limiter resources.
       *&#64;&#64;
       * </pre>
       *
       * <code>repeated .inference.ModelRateLimiter.Resource resources = 1;</code>
       */
      public Builder setResources(
          int index, org.apache.submarine.server.api.proto.TritonModelConfig.ModelRateLimiter.Resource.Builder builderForValue) {
        if (resourcesBuilder_ == null) {
          ensureResourcesIsMutable();
          resources_.set(index, builderForValue.build());
          onChanged();
        } else {
          resourcesBuilder_.setMessage(index, builderForValue.build());
        }
        return this;
      }
      /**
       * <pre>
       *&#64;&#64;  .. cpp:var:: Resource resources (repeated)
       *&#64;&#64;
       *&#64;&#64;     The resources required to execute the request on a model instance.
       *&#64;&#64;     Resources are just names with a corresponding count. The execution
       *&#64;&#64;     of the instance will be blocked until the specificied resources are
       *&#64;&#64;     available. By default an instance uses no rate-limiter resources.
       *&#64;&#64;
       * </pre>
       *
       * <code>repeated .inference.ModelRateLimiter.Resource resources = 1;</code>
       */
      public Builder addResources(org.apache.submarine.server.api.proto.TritonModelConfig.ModelRateLimiter.Resource value) {
        if (resourcesBuilder_ == null) {
          if (value == null) {
            throw new NullPointerException();
          }
          ensureResourcesIsMutable();
          resources_.add(value);
          onChanged();
        } else {
          resourcesBuilder_.addMessage(value);
        }
        return this;
      }
      /**
       * <pre>
       *&#64;&#64;  .. cpp:var:: Resource resources (repeated)
       *&#64;&#64;
       *&#64;&#64;     The resources required to execute the request on a model instance.
       *&#64;&#64;     Resources are just names with a corresponding count. The execution
       *&#64;&#64;     of the instance will be blocked until the specificied resources are
       *&#64;&#64;     available. By default an instance uses no rate-limiter resources.
       *&#64;&#64;
       * </pre>
       *
       * <code>repeated .inference.ModelRateLimiter.Resource resources = 1;</code>
       */
      public Builder addResources(
          int index, org.apache.submarine.server.api.proto.TritonModelConfig.ModelRateLimiter.Resource value) {
        if (resourcesBuilder_ == null) {
          if (value == null) {
            throw new NullPointerException();
          }
          ensureResourcesIsMutable();
          resources_.add(index, value);
          onChanged();
        } else {
          resourcesBuilder_.addMessage(index, value);
        }
        return this;
      }
      /**
       * <pre>
       *&#64;&#64;  .. cpp:var:: Resource resources (repeated)
       *&#64;&#64;
       *&#64;&#64;     The resources required to execute the request on a model instance.
       *&#64;&#64;     Resources are just names with a corresponding count. The execution
       *&#64;&#64;     of the instance will be blocked until the specificied resources are
       *&#64;&#64;     available. By default an instance uses no rate-limiter resources.
       *&#64;&#64;
       * </pre>
       *
       * <code>repeated .inference.ModelRateLimiter.Resource resources = 1;</code>
       */
      public Builder addResources(
          org.apache.submarine.server.api.proto.TritonModelConfig.ModelRateLimiter.Resource.Builder builderForValue) {
        if (resourcesBuilder_ == null) {
          ensureResourcesIsMutable();
          resources_.add(builderForValue.build());
          onChanged();
        } else {
          resourcesBuilder_.addMessage(builderForValue.build());
        }
        return this;
      }
      /**
       * <pre>
       *&#64;&#64;  .. cpp:var:: Resource resources (repeated)
       *&#64;&#64;
       *&#64;&#64;     The resources required to execute the request on a model instance.
       *&#64;&#64;     Resources are just names with a corresponding count. The execution
       *&#64;&#64;     of the instance will be blocked until the specificied resources are
       *&#64;&#64;     available. By default an instance uses no rate-limiter resources.
       *&#64;&#64;
       * </pre>
       *
       * <code>repeated .inference.ModelRateLimiter.Resource resources = 1;</code>
       */
      public Builder addResources(
          int index, org.apache.submarine.server.api.proto.TritonModelConfig.ModelRateLimiter.Resource.Builder builderForValue) {
        if (resourcesBuilder_ == null) {
          ensureResourcesIsMutable();
          resources_.add(index, builderForValue.build());
          onChanged();
        } else {
          resourcesBuilder_.addMessage(index, builderForValue.build());
        }
        return this;
      }
      /**
       * <pre>
       *&#64;&#64;  .. cpp:var:: Resource resources (repeated)
       *&#64;&#64;
       *&#64;&#64;     The resources required to execute the request on a model instance.
       *&#64;&#64;     Resources are just names with a corresponding count. The execution
       *&#64;&#64;     of the instance will be blocked until the specificied resources are
       *&#64;&#64;     available. By default an instance uses no rate-limiter resources.
       *&#64;&#64;
       * </pre>
       *
       * <code>repeated .inference.ModelRateLimiter.Resource resources = 1;</code>
       */
      public Builder addAllResources(
          java.lang.Iterable<? extends org.apache.submarine.server.api.proto.TritonModelConfig.ModelRateLimiter.Resource> values) {
        if (resourcesBuilder_ == null) {
          ensureResourcesIsMutable();
          com.google.protobuf.AbstractMessageLite.Builder.addAll(
              values, resources_);
          onChanged();
        } else {
          resourcesBuilder_.addAllMessages(values);
        }
        return this;
      }
      /**
       * <pre>
       *&#64;&#64;  .. cpp:var:: Resource resources (repeated)
       *&#64;&#64;
       *&#64;&#64;     The resources required to execute the request on a model instance.
       *&#64;&#64;     Resources are just names with a corresponding count. The execution
       *&#64;&#64;     of the instance will be blocked until the specificied resources are
       *&#64;&#64;     available. By default an instance uses no rate-limiter resources.
       *&#64;&#64;
       * </pre>
       *
       * <code>repeated .inference.ModelRateLimiter.Resource resources = 1;</code>
       */
      public Builder clearResources() {
        if (resourcesBuilder_ == null) {
          resources_ = java.util.Collections.emptyList();
          bitField0_ = (bitField0_ & ~0x00000001);
          onChanged();
        } else {
          resourcesBuilder_.clear();
        }
        return this;
      }
      /**
       * <pre>
       *&#64;&#64;  .. cpp:var:: Resource resources (repeated)
       *&#64;&#64;
       *&#64;&#64;     The resources required to execute the request on a model instance.
       *&#64;&#64;     Resources are just names with a corresponding count. The execution
       *&#64;&#64;     of the instance will be blocked until the specificied resources are
       *&#64;&#64;     available. By default an instance uses no rate-limiter resources.
       *&#64;&#64;
       * </pre>
       *
       * <code>repeated .inference.ModelRateLimiter.Resource resources = 1;</code>
       */
      public Builder removeResources(int index) {
        if (resourcesBuilder_ == null) {
          ensureResourcesIsMutable();
          resources_.remove(index);
          onChanged();
        } else {
          resourcesBuilder_.remove(index);
        }
        return this;
      }
      /**
       * <pre>
       *&#64;&#64;  .. cpp:var:: Resource resources (repeated)
       *&#64;&#64;
       *&#64;&#64;     The resources required to execute the request on a model instance.
       *&#64;&#64;     Resources are just names with a corresponding count. The execution
       *&#64;&#64;     of the instance will be blocked until the specificied resources are
       *&#64;&#64;     available. By default an instance uses no rate-limiter resources.
       *&#64;&#64;
       * </pre>
       *
       * <code>repeated .inference.ModelRateLimiter.Resource resources = 1;</code>
       */
      public org.apache.submarine.server.api.proto.TritonModelConfig.ModelRateLimiter.Resource.Builder getResourcesBuilder(
          int index) {
        return getResourcesFieldBuilder().getBuilder(index);
      }
      /**
       * <pre>
       *&#64;&#64;  .. cpp:var:: Resource resources (repeated)
       *&#64;&#64;
       *&#64;&#64;     The resources required to execute the request on a model instance.
       *&#64;&#64;     Resources are just names with a corresponding count. The execution
       *&#64;&#64;     of the instance will be blocked until the specificied resources are
       *&#64;&#64;     available. By default an instance uses no rate-limiter resources.
       *&#64;&#64;
       * </pre>
       *
       * <code>repeated .inference.ModelRateLimiter.Resource resources = 1;</code>
       */
      public org.apache.submarine.server.api.proto.TritonModelConfig.ModelRateLimiter.ResourceOrBuilder getResourcesOrBuilder(
          int index) {
        if (resourcesBuilder_ == null) {
          return resources_.get(index);  } else {
          return resourcesBuilder_.getMessageOrBuilder(index);
        }
      }
      /**
       * <pre>
       *&#64;&#64;  .. cpp:var:: Resource resources (repeated)
       *&#64;&#64;
       *&#64;&#64;     The resources required to execute the request on a model instance.
       *&#64;&#64;     Resources are just names with a corresponding count. The execution
       *&#64;&#64;     of the instance will be blocked until the specificied resources are
       *&#64;&#64;     available. By default an instance uses no rate-limiter resources.
       *&#64;&#64;
       * </pre>
       *
       * <code>repeated .inference.ModelRateLimiter.Resource resources = 1;</code>
       */
      public java.util.List<? extends org.apache.submarine.server.api.proto.TritonModelConfig.ModelRateLimiter.ResourceOrBuilder> 
           getResourcesOrBuilderList() {
        if (resourcesBuilder_ != null) {
          return resourcesBuilder_.getMessageOrBuilderList();
        } else {
          return java.util.Collections.unmodifiableList(resources_);
        }
      }
      /**
       * <pre>
       *&#64;&#64;  .. cpp:var:: Resource resources (repeated)
       *&#64;&#64;
       *&#64;&#64;     The resources required to execute the request on a model instance.
       *&#64;&#64;     Resources are just names with a corresponding count. The execution
       *&#64;&#64;     of the instance will be blocked until the specificied resources are
       *&#64;&#64;     available. By default an instance uses no rate-limiter resources.
       *&#64;&#64;
       * </pre>
       *
       * <code>repeated .inference.ModelRateLimiter.Resource resources = 1;</code>
       */
      public org.apache.submarine.server.api.proto.TritonModelConfig.ModelRateLimiter.Resource.Builder addResourcesBuilder() {
        return getResourcesFieldBuilder().addBuilder(
            org.apache.submarine.server.api.proto.TritonModelConfig.ModelRateLimiter.Resource.getDefaultInstance());
      }
      /**
       * <pre>
       *&#64;&#64;  .. cpp:var:: Resource resources (repeated)
       *&#64;&#64;
       *&#64;&#64;     The resources required to execute the request on a model instance.
       *&#64;&#64;     Resources are just names with a corresponding count. The execution
       *&#64;&#64;     of the instance will be blocked until the specificied resources are
       *&#64;&#64;     available. By default an instance uses no rate-limiter resources.
       *&#64;&#64;
       * </pre>
       *
       * <code>repeated .inference.ModelRateLimiter.Resource resources = 1;</code>
       */
      public org.apache.submarine.server.api.proto.TritonModelConfig.ModelRateLimiter.Resource.Builder addResourcesBuilder(
          int index) {
        return getResourcesFieldBuilder().addBuilder(
            index, org.apache.submarine.server.api.proto.TritonModelConfig.ModelRateLimiter.Resource.getDefaultInstance());
      }
      /**
       * <pre>
       *&#64;&#64;  .. cpp:var:: Resource resources (repeated)
       *&#64;&#64;
       *&#64;&#64;     The resources required to execute the request on a model instance.
       *&#64;&#64;     Resources are just names with a corresponding count. The execution
       *&#64;&#64;     of the instance will be blocked until the specificied resources are
       *&#64;&#64;     available. By default an instance uses no rate-limiter resources.
       *&#64;&#64;
       * </pre>
       *
       * <code>repeated .inference.ModelRateLimiter.Resource resources = 1;</code>
       */
      public java.util.List<org.apache.submarine.server.api.proto.TritonModelConfig.ModelRateLimiter.Resource.Builder> 
           getResourcesBuilderList() {
        return getResourcesFieldBuilder().getBuilderList();
      }
      private com.google.protobuf.RepeatedFieldBuilderV3<
          org.apache.submarine.server.api.proto.TritonModelConfig.ModelRateLimiter.Resource, org.apache.submarine.server.api.proto.TritonModelConfig.ModelRateLimiter.Resource.Builder, org.apache.submarine.server.api.proto.TritonModelConfig.ModelRateLimiter.ResourceOrBuilder> 
          getResourcesFieldBuilder() {
        if (resourcesBuilder_ == null) {
          resourcesBuilder_ = new com.google.protobuf.RepeatedFieldBuilderV3<
              org.apache.submarine.server.api.proto.TritonModelConfig.ModelRateLimiter.Resource, org.apache.submarine.server.api.proto.TritonModelConfig.ModelRateLimiter.Resource.Builder, org.apache.submarine.server.api.proto.TritonModelConfig.ModelRateLimiter.ResourceOrBuilder>(
                  resources_,
                  ((bitField0_ & 0x00000001) != 0),
                  getParentForChildren(),
                  isClean());
          resources_ = null;
        }
        return resourcesBuilder_;
      }

      private int priority_ ;
      /**
       * <pre>
       *&#64;&#64;  .. cpp:var:: uint32 priority
       *&#64;&#64;
       *&#64;&#64;     The optional weighting value to be used for prioritizing across
       *&#64;&#64;     instances. An instance with priority 2 will be given 1/2 the
       *&#64;&#64;     number of scheduling chances as an instance_group with priority
       *&#64;&#64;     1. The default priority is 1. The priority of value 0 will be
       *&#64;&#64;     treated as priority 1.
       *&#64;&#64;
       * </pre>
       *
       * <code>uint32 priority = 2;</code>
       * @return The priority.
       */
      @java.lang.Override
      public int getPriority() {
        return priority_;
      }
      /**
       * <pre>
       *&#64;&#64;  .. cpp:var:: uint32 priority
       *&#64;&#64;
       *&#64;&#64;     The optional weighting value to be used for prioritizing across
       *&#64;&#64;     instances. An instance with priority 2 will be given 1/2 the
       *&#64;&#64;     number of scheduling chances as an instance_group with priority
       *&#64;&#64;     1. The default priority is 1. The priority of value 0 will be
       *&#64;&#64;     treated as priority 1.
       *&#64;&#64;
       * </pre>
       *
       * <code>uint32 priority = 2;</code>
       * @param value The priority to set.
       * @return This builder for chaining.
       */
      public Builder setPriority(int value) {
        
        priority_ = value;
        onChanged();
        return this;
      }
      /**
       * <pre>
       *&#64;&#64;  .. cpp:var:: uint32 priority
       *&#64;&#64;
       *&#64;&#64;     The optional weighting value to be used for prioritizing across
       *&#64;&#64;     instances. An instance with priority 2 will be given 1/2 the
       *&#64;&#64;     number of scheduling chances as an instance_group with priority
       *&#64;&#64;     1. The default priority is 1. The priority of value 0 will be
       *&#64;&#64;     treated as priority 1.
       *&#64;&#64;
       * </pre>
       *
       * <code>uint32 priority = 2;</code>
       * @return This builder for chaining.
       */
      public Builder clearPriority() {
        
        priority_ = 0;
        onChanged();
        return this;
      }
      @java.lang.Override
      public final Builder setUnknownFields(
          final com.google.protobuf.UnknownFieldSet unknownFields) {
        return super.setUnknownFields(unknownFields);
      }

      @java.lang.Override
      public final Builder mergeUnknownFields(
          final com.google.protobuf.UnknownFieldSet unknownFields) {
        return super.mergeUnknownFields(unknownFields);
      }


      // @@protoc_insertion_point(builder_scope:inference.ModelRateLimiter)
    }

    // @@protoc_insertion_point(class_scope:inference.ModelRateLimiter)
    private static final org.apache.submarine.server.api.proto.TritonModelConfig.ModelRateLimiter DEFAULT_INSTANCE;
    static {
      DEFAULT_INSTANCE = new org.apache.submarine.server.api.proto.TritonModelConfig.ModelRateLimiter();
    }

    public static org.apache.submarine.server.api.proto.TritonModelConfig.ModelRateLimiter getDefaultInstance() {
      return DEFAULT_INSTANCE;
    }

    private static final com.google.protobuf.Parser<ModelRateLimiter>
        PARSER = new com.google.protobuf.AbstractParser<ModelRateLimiter>() {
      @java.lang.Override
      public ModelRateLimiter parsePartialFrom(
          com.google.protobuf.CodedInputStream input,
          com.google.protobuf.ExtensionRegistryLite extensionRegistry)
          throws com.google.protobuf.InvalidProtocolBufferException {
        return new ModelRateLimiter(input, extensionRegistry);
      }
    };

    public static com.google.protobuf.Parser<ModelRateLimiter> parser() {
      return PARSER;
    }

    @java.lang.Override
    public com.google.protobuf.Parser<ModelRateLimiter> getParserForType() {
      return PARSER;
    }

    @java.lang.Override
    public org.apache.submarine.server.api.proto.TritonModelConfig.ModelRateLimiter getDefaultInstanceForType() {
      return DEFAULT_INSTANCE;
    }

  }

  public interface ModelInstanceGroupOrBuilder extends
      // @@protoc_insertion_point(interface_extends:inference.ModelInstanceGroup)
      com.google.protobuf.MessageOrBuilder {

    /**
     * <pre>
     *&#64;&#64;  .. cpp:var:: string name
     *&#64;&#64;
     *&#64;&#64;     Optional name of this group of instances. If not specified the
     *&#64;&#64;     name will be formed as &lt;model name&gt;_&lt;group number&gt;. The name of
     *&#64;&#64;     individual instances will be further formed by a unique instance
     *&#64;&#64;     number and GPU index:
     *&#64;&#64;
     * </pre>
     *
     * <code>string name = 1;</code>
     * @return The name.
     */
    java.lang.String getName();
    /**
     * <pre>
     *&#64;&#64;  .. cpp:var:: string name
     *&#64;&#64;
     *&#64;&#64;     Optional name of this group of instances. If not specified the
     *&#64;&#64;     name will be formed as &lt;model name&gt;_&lt;group number&gt;. The name of
     *&#64;&#64;     individual instances will be further formed by a unique instance
     *&#64;&#64;     number and GPU index:
     *&#64;&#64;
     * </pre>
     *
     * <code>string name = 1;</code>
     * @return The bytes for name.
     */
    com.google.protobuf.ByteString
        getNameBytes();

    /**
     * <pre>
     *&#64;&#64;  .. cpp:var:: Kind kind
     *&#64;&#64;
     *&#64;&#64;     The kind of this instance group. Default is KIND_AUTO. If
     *&#64;&#64;     KIND_AUTO or KIND_GPU then both 'count' and 'gpu' are valid and
     *&#64;&#64;     may be specified. If KIND_CPU or KIND_MODEL only 'count' is valid
     *&#64;&#64;     and 'gpu' cannot be specified.
     *&#64;&#64;
     * </pre>
     *
     * <code>.inference.ModelInstanceGroup.Kind kind = 4;</code>
     * @return The enum numeric value on the wire for kind.
     */
    int getKindValue();
    /**
     * <pre>
     *&#64;&#64;  .. cpp:var:: Kind kind
     *&#64;&#64;
     *&#64;&#64;     The kind of this instance group. Default is KIND_AUTO. If
     *&#64;&#64;     KIND_AUTO or KIND_GPU then both 'count' and 'gpu' are valid and
     *&#64;&#64;     may be specified. If KIND_CPU or KIND_MODEL only 'count' is valid
     *&#64;&#64;     and 'gpu' cannot be specified.
     *&#64;&#64;
     * </pre>
     *
     * <code>.inference.ModelInstanceGroup.Kind kind = 4;</code>
     * @return The kind.
     */
    org.apache.submarine.server.api.proto.TritonModelConfig.ModelInstanceGroup.Kind getKind();

    /**
     * <pre>
     *&#64;&#64;  .. cpp:var:: int32 count
     *&#64;&#64;
     *&#64;&#64;     For a group assigned to GPU, the number of instances created for
     *&#64;&#64;     each GPU listed in 'gpus'. For a group assigned to CPU the number
     *&#64;&#64;     of instances created. Default is 1.
     * </pre>
     *
     * <code>int32 count = 2;</code>
     * @return The count.
     */
    int getCount();

    /**
     * <pre>
     *&#64;&#64;  .. cpp:var:: ModelRateLimiter rate_limiter
     *&#64;&#64;
     *&#64;&#64;     The rate limiter specific settings to be associated with this
     *&#64;&#64;     instance group. Optional, if not specified no rate limiting
     *&#64;&#64;     will be applied to this instance group.
     *&#64;&#64;
     * </pre>
     *
     * <code>.inference.ModelRateLimiter rate_limiter = 6;</code>
     * @return Whether the rateLimiter field is set.
     */
    boolean hasRateLimiter();
    /**
     * <pre>
     *&#64;&#64;  .. cpp:var:: ModelRateLimiter rate_limiter
     *&#64;&#64;
     *&#64;&#64;     The rate limiter specific settings to be associated with this
     *&#64;&#64;     instance group. Optional, if not specified no rate limiting
     *&#64;&#64;     will be applied to this instance group.
     *&#64;&#64;
     * </pre>
     *
     * <code>.inference.ModelRateLimiter rate_limiter = 6;</code>
     * @return The rateLimiter.
     */
    org.apache.submarine.server.api.proto.TritonModelConfig.ModelRateLimiter getRateLimiter();
    /**
     * <pre>
     *&#64;&#64;  .. cpp:var:: ModelRateLimiter rate_limiter
     *&#64;&#64;
     *&#64;&#64;     The rate limiter specific settings to be associated with this
     *&#64;&#64;     instance group. Optional, if not specified no rate limiting
     *&#64;&#64;     will be applied to this instance group.
     *&#64;&#64;
     * </pre>
     *
     * <code>.inference.ModelRateLimiter rate_limiter = 6;</code>
     */
    org.apache.submarine.server.api.proto.TritonModelConfig.ModelRateLimiterOrBuilder getRateLimiterOrBuilder();

    /**
     * <pre>
     *&#64;&#64;  .. cpp:var:: int32 gpus (repeated)
     *&#64;&#64;
     *&#64;&#64;     GPU(s) where instances should be available. For each GPU listed,
     *&#64;&#64;     'count' instances of the model will be available. Setting 'gpus'
     *&#64;&#64;     to empty (or not specifying at all) is eqivalent to listing all
     *&#64;&#64;     available GPUs.
     *&#64;&#64;
     * </pre>
     *
     * <code>repeated int32 gpus = 3;</code>
     * @return A list containing the gpus.
     */
    java.util.List<java.lang.Integer> getGpusList();
    /**
     * <pre>
     *&#64;&#64;  .. cpp:var:: int32 gpus (repeated)
     *&#64;&#64;
     *&#64;&#64;     GPU(s) where instances should be available. For each GPU listed,
     *&#64;&#64;     'count' instances of the model will be available. Setting 'gpus'
     *&#64;&#64;     to empty (or not specifying at all) is eqivalent to listing all
     *&#64;&#64;     available GPUs.
     *&#64;&#64;
     * </pre>
     *
     * <code>repeated int32 gpus = 3;</code>
     * @return The count of gpus.
     */
    int getGpusCount();
    /**
     * <pre>
     *&#64;&#64;  .. cpp:var:: int32 gpus (repeated)
     *&#64;&#64;
     *&#64;&#64;     GPU(s) where instances should be available. For each GPU listed,
     *&#64;&#64;     'count' instances of the model will be available. Setting 'gpus'
     *&#64;&#64;     to empty (or not specifying at all) is eqivalent to listing all
     *&#64;&#64;     available GPUs.
     *&#64;&#64;
     * </pre>
     *
     * <code>repeated int32 gpus = 3;</code>
     * @param index The index of the element to return.
     * @return The gpus at the given index.
     */
    int getGpus(int index);

    /**
     * <pre>
     *&#64;&#64;  .. cpp:var:: SecondaryDevice secondary_devices (repeated)
     *&#64;&#64;
     *&#64;&#64;     Secondary devices that are required by instances specified by this
     *&#64;&#64;     instance group. Optional.
     *&#64;&#64;
     * </pre>
     *
     * <code>repeated .inference.ModelInstanceGroup.SecondaryDevice secondary_devices = 8;</code>
     */
    java.util.List<org.apache.submarine.server.api.proto.TritonModelConfig.ModelInstanceGroup.SecondaryDevice> 
        getSecondaryDevicesList();
    /**
     * <pre>
     *&#64;&#64;  .. cpp:var:: SecondaryDevice secondary_devices (repeated)
     *&#64;&#64;
     *&#64;&#64;     Secondary devices that are required by instances specified by this
     *&#64;&#64;     instance group. Optional.
     *&#64;&#64;
     * </pre>
     *
     * <code>repeated .inference.ModelInstanceGroup.SecondaryDevice secondary_devices = 8;</code>
     */
    org.apache.submarine.server.api.proto.TritonModelConfig.ModelInstanceGroup.SecondaryDevice getSecondaryDevices(int index);
    /**
     * <pre>
     *&#64;&#64;  .. cpp:var:: SecondaryDevice secondary_devices (repeated)
     *&#64;&#64;
     *&#64;&#64;     Secondary devices that are required by instances specified by this
     *&#64;&#64;     instance group. Optional.
     *&#64;&#64;
     * </pre>
     *
     * <code>repeated .inference.ModelInstanceGroup.SecondaryDevice secondary_devices = 8;</code>
     */
    int getSecondaryDevicesCount();
    /**
     * <pre>
     *&#64;&#64;  .. cpp:var:: SecondaryDevice secondary_devices (repeated)
     *&#64;&#64;
     *&#64;&#64;     Secondary devices that are required by instances specified by this
     *&#64;&#64;     instance group. Optional.
     *&#64;&#64;
     * </pre>
     *
     * <code>repeated .inference.ModelInstanceGroup.SecondaryDevice secondary_devices = 8;</code>
     */
    java.util.List<? extends org.apache.submarine.server.api.proto.TritonModelConfig.ModelInstanceGroup.SecondaryDeviceOrBuilder> 
        getSecondaryDevicesOrBuilderList();
    /**
     * <pre>
     *&#64;&#64;  .. cpp:var:: SecondaryDevice secondary_devices (repeated)
     *&#64;&#64;
     *&#64;&#64;     Secondary devices that are required by instances specified by this
     *&#64;&#64;     instance group. Optional.
     *&#64;&#64;
     * </pre>
     *
     * <code>repeated .inference.ModelInstanceGroup.SecondaryDevice secondary_devices = 8;</code>
     */
    org.apache.submarine.server.api.proto.TritonModelConfig.ModelInstanceGroup.SecondaryDeviceOrBuilder getSecondaryDevicesOrBuilder(
        int index);

    /**
     * <pre>
     *&#64;&#64;  .. cpp:var:: string profile (repeated)
     *&#64;&#64;
     *&#64;&#64;     For TensorRT models containing multiple optimization profile, this
     *&#64;&#64;     parameter specifies a set of optimization profiles available to this
     *&#64;&#64;     instance group. The inference server will choose the optimal profile
     *&#64;&#64;     based on the shapes of the input tensors. This field should lie
     *&#64;&#64;     between 0 and &lt;TotalNumberOfOptimizationProfilesInPlanModel&gt; - 1
     *&#64;&#64;     and be specified only for TensorRT backend, otherwise an error will
     *&#64;&#64;     be generated. If not specified, the server will select the first
     *&#64;&#64;     optimization profile by default.
     *&#64;&#64;
     * </pre>
     *
     * <code>repeated string profile = 5;</code>
     * @return A list containing the profile.
     */
    java.util.List<java.lang.String>
        getProfileList();
    /**
     * <pre>
     *&#64;&#64;  .. cpp:var:: string profile (repeated)
     *&#64;&#64;
     *&#64;&#64;     For TensorRT models containing multiple optimization profile, this
     *&#64;&#64;     parameter specifies a set of optimization profiles available to this
     *&#64;&#64;     instance group. The inference server will choose the optimal profile
     *&#64;&#64;     based on the shapes of the input tensors. This field should lie
     *&#64;&#64;     between 0 and &lt;TotalNumberOfOptimizationProfilesInPlanModel&gt; - 1
     *&#64;&#64;     and be specified only for TensorRT backend, otherwise an error will
     *&#64;&#64;     be generated. If not specified, the server will select the first
     *&#64;&#64;     optimization profile by default.
     *&#64;&#64;
     * </pre>
     *
     * <code>repeated string profile = 5;</code>
     * @return The count of profile.
     */
    int getProfileCount();
    /**
     * <pre>
     *&#64;&#64;  .. cpp:var:: string profile (repeated)
     *&#64;&#64;
     *&#64;&#64;     For TensorRT models containing multiple optimization profile, this
     *&#64;&#64;     parameter specifies a set of optimization profiles available to this
     *&#64;&#64;     instance group. The inference server will choose the optimal profile
     *&#64;&#64;     based on the shapes of the input tensors. This field should lie
     *&#64;&#64;     between 0 and &lt;TotalNumberOfOptimizationProfilesInPlanModel&gt; - 1
     *&#64;&#64;     and be specified only for TensorRT backend, otherwise an error will
     *&#64;&#64;     be generated. If not specified, the server will select the first
     *&#64;&#64;     optimization profile by default.
     *&#64;&#64;
     * </pre>
     *
     * <code>repeated string profile = 5;</code>
     * @param index The index of the element to return.
     * @return The profile at the given index.
     */
    java.lang.String getProfile(int index);
    /**
     * <pre>
     *&#64;&#64;  .. cpp:var:: string profile (repeated)
     *&#64;&#64;
     *&#64;&#64;     For TensorRT models containing multiple optimization profile, this
     *&#64;&#64;     parameter specifies a set of optimization profiles available to this
     *&#64;&#64;     instance group. The inference server will choose the optimal profile
     *&#64;&#64;     based on the shapes of the input tensors. This field should lie
     *&#64;&#64;     between 0 and &lt;TotalNumberOfOptimizationProfilesInPlanModel&gt; - 1
     *&#64;&#64;     and be specified only for TensorRT backend, otherwise an error will
     *&#64;&#64;     be generated. If not specified, the server will select the first
     *&#64;&#64;     optimization profile by default.
     *&#64;&#64;
     * </pre>
     *
     * <code>repeated string profile = 5;</code>
     * @param index The index of the value to return.
     * @return The bytes of the profile at the given index.
     */
    com.google.protobuf.ByteString
        getProfileBytes(int index);

    /**
     * <pre>
     *&#64;&#64;  .. cpp:var:: bool passive
     *&#64;&#64;
     *&#64;&#64;     Whether the instances within this instance group will be accepting
     *&#64;&#64;     inference requests from the scheduler. If true, the instances will
     *&#64;&#64;     not be added to the scheduler. Default value is false.
     *&#64;&#64;
     * </pre>
     *
     * <code>bool passive = 7;</code>
     * @return The passive.
     */
    boolean getPassive();

    /**
     * <pre>
     *&#64;&#64;  .. cpp:var:: string host_policy
     *&#64;&#64;
     *&#64;&#64;     The host policy name that the instance to be associated with.
     *&#64;&#64;     The default value is set to reflect the device kind of the instance,
     *&#64;&#64;     for instance, KIND_CPU is "cpu", KIND_MODEL is "model" and
     *&#64;&#64;     KIND_GPU is "gpu_&lt;gpu_id&gt;".
     *&#64;&#64;
     * </pre>
     *
     * <code>string host_policy = 9;</code>
     * @return The hostPolicy.
     */
    java.lang.String getHostPolicy();
    /**
     * <pre>
     *&#64;&#64;  .. cpp:var:: string host_policy
     *&#64;&#64;
     *&#64;&#64;     The host policy name that the instance to be associated with.
     *&#64;&#64;     The default value is set to reflect the device kind of the instance,
     *&#64;&#64;     for instance, KIND_CPU is "cpu", KIND_MODEL is "model" and
     *&#64;&#64;     KIND_GPU is "gpu_&lt;gpu_id&gt;".
     *&#64;&#64;
     * </pre>
     *
     * <code>string host_policy = 9;</code>
     * @return The bytes for hostPolicy.
     */
    com.google.protobuf.ByteString
        getHostPolicyBytes();
  }
  /**
   * <pre>
   *&#64;&#64;
   *&#64;&#64;.. cpp:var:: message ModelInstanceGroup
   *&#64;&#64;
   *&#64;&#64;   A group of one or more instances of a model and resources made
   *&#64;&#64;   available for those instances.
   *&#64;&#64;
   * </pre>
   *
   * Protobuf type {@code inference.ModelInstanceGroup}
   */
  public static final class ModelInstanceGroup extends
      com.google.protobuf.GeneratedMessageV3 implements
      // @@protoc_insertion_point(message_implements:inference.ModelInstanceGroup)
      ModelInstanceGroupOrBuilder {
  private static final long serialVersionUID = 0L;
    // Use ModelInstanceGroup.newBuilder() to construct.
    private ModelInstanceGroup(com.google.protobuf.GeneratedMessageV3.Builder<?> builder) {
      super(builder);
    }
    private ModelInstanceGroup() {
      name_ = "";
      kind_ = 0;
      gpus_ = emptyIntList();
      secondaryDevices_ = java.util.Collections.emptyList();
      profile_ = com.google.protobuf.LazyStringArrayList.EMPTY;
      hostPolicy_ = "";
    }

    @java.lang.Override
    @SuppressWarnings({"unused"})
    protected java.lang.Object newInstance(
        UnusedPrivateParameter unused) {
      return new ModelInstanceGroup();
    }

    @java.lang.Override
    public final com.google.protobuf.UnknownFieldSet
    getUnknownFields() {
      return this.unknownFields;
    }
    private ModelInstanceGroup(
        com.google.protobuf.CodedInputStream input,
        com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws com.google.protobuf.InvalidProtocolBufferException {
      this();
      if (extensionRegistry == null) {
        throw new java.lang.NullPointerException();
      }
      int mutable_bitField0_ = 0;
      com.google.protobuf.UnknownFieldSet.Builder unknownFields =
          com.google.protobuf.UnknownFieldSet.newBuilder();
      try {
        boolean done = false;
        while (!done) {
          int tag = input.readTag();
          switch (tag) {
            case 0:
              done = true;
              break;
            case 10: {
              java.lang.String s = input.readStringRequireUtf8();

              name_ = s;
              break;
            }
            case 16: {

              count_ = input.readInt32();
              break;
            }
            case 24: {
              if (!((mutable_bitField0_ & 0x00000001) != 0)) {
                gpus_ = newIntList();
                mutable_bitField0_ |= 0x00000001;
              }
              gpus_.addInt(input.readInt32());
              break;
            }
            case 26: {
              int length = input.readRawVarint32();
              int limit = input.pushLimit(length);
              if (!((mutable_bitField0_ & 0x00000001) != 0) && input.getBytesUntilLimit() > 0) {
                gpus_ = newIntList();
                mutable_bitField0_ |= 0x00000001;
              }
              while (input.getBytesUntilLimit() > 0) {
                gpus_.addInt(input.readInt32());
              }
              input.popLimit(limit);
              break;
            }
            case 32: {
              int rawValue = input.readEnum();

              kind_ = rawValue;
              break;
            }
            case 42: {
              java.lang.String s = input.readStringRequireUtf8();
              if (!((mutable_bitField0_ & 0x00000004) != 0)) {
                profile_ = new com.google.protobuf.LazyStringArrayList();
                mutable_bitField0_ |= 0x00000004;
              }
              profile_.add(s);
              break;
            }
            case 50: {
              org.apache.submarine.server.api.proto.TritonModelConfig.ModelRateLimiter.Builder subBuilder = null;
              if (rateLimiter_ != null) {
                subBuilder = rateLimiter_.toBuilder();
              }
              rateLimiter_ = input.readMessage(org.apache.submarine.server.api.proto.TritonModelConfig.ModelRateLimiter.parser(), extensionRegistry);
              if (subBuilder != null) {
                subBuilder.mergeFrom(rateLimiter_);
                rateLimiter_ = subBuilder.buildPartial();
              }

              break;
            }
            case 56: {

              passive_ = input.readBool();
              break;
            }
            case 66: {
              if (!((mutable_bitField0_ & 0x00000002) != 0)) {
                secondaryDevices_ = new java.util.ArrayList<org.apache.submarine.server.api.proto.TritonModelConfig.ModelInstanceGroup.SecondaryDevice>();
                mutable_bitField0_ |= 0x00000002;
              }
              secondaryDevices_.add(
                  input.readMessage(org.apache.submarine.server.api.proto.TritonModelConfig.ModelInstanceGroup.SecondaryDevice.parser(), extensionRegistry));
              break;
            }
            case 74: {
              java.lang.String s = input.readStringRequireUtf8();

              hostPolicy_ = s;
              break;
            }
            default: {
              if (!parseUnknownField(
                  input, unknownFields, extensionRegistry, tag)) {
                done = true;
              }
              break;
            }
          }
        }
      } catch (com.google.protobuf.InvalidProtocolBufferException e) {
        throw e.setUnfinishedMessage(this);
      } catch (java.io.IOException e) {
        throw new com.google.protobuf.InvalidProtocolBufferException(
            e).setUnfinishedMessage(this);
      } finally {
        if (((mutable_bitField0_ & 0x00000001) != 0)) {
          gpus_.makeImmutable(); // C
        }
        if (((mutable_bitField0_ & 0x00000004) != 0)) {
          profile_ = profile_.getUnmodifiableView();
        }
        if (((mutable_bitField0_ & 0x00000002) != 0)) {
          secondaryDevices_ = java.util.Collections.unmodifiableList(secondaryDevices_);
        }
        this.unknownFields = unknownFields.build();
        makeExtensionsImmutable();
      }
    }
    public static final com.google.protobuf.Descriptors.Descriptor
        getDescriptor() {
      return org.apache.submarine.server.api.proto.TritonModelConfig.internal_static_inference_ModelInstanceGroup_descriptor;
    }

    @java.lang.Override
    protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
        internalGetFieldAccessorTable() {
      return org.apache.submarine.server.api.proto.TritonModelConfig.internal_static_inference_ModelInstanceGroup_fieldAccessorTable
          .ensureFieldAccessorsInitialized(
              org.apache.submarine.server.api.proto.TritonModelConfig.ModelInstanceGroup.class, org.apache.submarine.server.api.proto.TritonModelConfig.ModelInstanceGroup.Builder.class);
    }

    /**
     * <pre>
     *&#64;&#64;
     *&#64;&#64;  .. cpp:enum:: Kind
     *&#64;&#64;
     *&#64;&#64;     Kind of this instance group.
     *&#64;&#64;
     * </pre>
     *
     * Protobuf enum {@code inference.ModelInstanceGroup.Kind}
     */
    public enum Kind
        implements com.google.protobuf.ProtocolMessageEnum {
      /**
       * <pre>
       *&#64;&#64;    .. cpp:enumerator:: Kind::KIND_AUTO = 0
       *&#64;&#64;
       *&#64;&#64;       This instance group represents instances that can run on either
       *&#64;&#64;       CPU or GPU. If all GPUs listed in 'gpus' are available then
       *&#64;&#64;       instances will be created on GPU(s), otherwise instances will
       *&#64;&#64;       be created on CPU.
       *&#64;&#64;
       * </pre>
       *
       * <code>KIND_AUTO = 0;</code>
       */
      KIND_AUTO(0),
      /**
       * <pre>
       *&#64;&#64;    .. cpp:enumerator:: Kind::KIND_GPU = 1
       *&#64;&#64;
       *&#64;&#64;       This instance group represents instances that must run on the
       *&#64;&#64;       GPU.
       *&#64;&#64;
       * </pre>
       *
       * <code>KIND_GPU = 1;</code>
       */
      KIND_GPU(1),
      /**
       * <pre>
       *&#64;&#64;    .. cpp:enumerator:: Kind::KIND_CPU = 2
       *&#64;&#64;
       *&#64;&#64;       This instance group represents instances that must run on the
       *&#64;&#64;       CPU.
       *&#64;&#64;
       * </pre>
       *
       * <code>KIND_CPU = 2;</code>
       */
      KIND_CPU(2),
      /**
       * <pre>
       *&#64;&#64;    .. cpp:enumerator:: Kind::KIND_MODEL = 3
       *&#64;&#64;
       *&#64;&#64;       This instance group represents instances that should run on the
       *&#64;&#64;       CPU and/or GPU(s) as specified by the model or backend itself.
       *&#64;&#64;       The inference server will not override the model/backend
       *&#64;&#64;       settings.
       *&#64;&#64;
       * </pre>
       *
       * <code>KIND_MODEL = 3;</code>
       */
      KIND_MODEL(3),
      UNRECOGNIZED(-1),
      ;

      /**
       * <pre>
       *&#64;&#64;    .. cpp:enumerator:: Kind::KIND_AUTO = 0
       *&#64;&#64;
       *&#64;&#64;       This instance group represents instances that can run on either
       *&#64;&#64;       CPU or GPU. If all GPUs listed in 'gpus' are available then
       *&#64;&#64;       instances will be created on GPU(s), otherwise instances will
       *&#64;&#64;       be created on CPU.
       *&#64;&#64;
       * </pre>
       *
       * <code>KIND_AUTO = 0;</code>
       */
      public static final int KIND_AUTO_VALUE = 0;
      /**
       * <pre>
       *&#64;&#64;    .. cpp:enumerator:: Kind::KIND_GPU = 1
       *&#64;&#64;
       *&#64;&#64;       This instance group represents instances that must run on the
       *&#64;&#64;       GPU.
       *&#64;&#64;
       * </pre>
       *
       * <code>KIND_GPU = 1;</code>
       */
      public static final int KIND_GPU_VALUE = 1;
      /**
       * <pre>
       *&#64;&#64;    .. cpp:enumerator:: Kind::KIND_CPU = 2
       *&#64;&#64;
       *&#64;&#64;       This instance group represents instances that must run on the
       *&#64;&#64;       CPU.
       *&#64;&#64;
       * </pre>
       *
       * <code>KIND_CPU = 2;</code>
       */
      public static final int KIND_CPU_VALUE = 2;
      /**
       * <pre>
       *&#64;&#64;    .. cpp:enumerator:: Kind::KIND_MODEL = 3
       *&#64;&#64;
       *&#64;&#64;       This instance group represents instances that should run on the
       *&#64;&#64;       CPU and/or GPU(s) as specified by the model or backend itself.
       *&#64;&#64;       The inference server will not override the model/backend
       *&#64;&#64;       settings.
       *&#64;&#64;
       * </pre>
       *
       * <code>KIND_MODEL = 3;</code>
       */
      public static final int KIND_MODEL_VALUE = 3;


      public final int getNumber() {
        if (this == UNRECOGNIZED) {
          throw new java.lang.IllegalArgumentException(
              "Can't get the number of an unknown enum value.");
        }
        return value;
      }

      /**
       * @param value The numeric wire value of the corresponding enum entry.
       * @return The enum associated with the given numeric wire value.
       * @deprecated Use {@link #forNumber(int)} instead.
       */
      @java.lang.Deprecated
      public static Kind valueOf(int value) {
        return forNumber(value);
      }

      /**
       * @param value The numeric wire value of the corresponding enum entry.
       * @return The enum associated with the given numeric wire value.
       */
      public static Kind forNumber(int value) {
        switch (value) {
          case 0: return KIND_AUTO;
          case 1: return KIND_GPU;
          case 2: return KIND_CPU;
          case 3: return KIND_MODEL;
          default: return null;
        }
      }

      public static com.google.protobuf.Internal.EnumLiteMap<Kind>
          internalGetValueMap() {
        return internalValueMap;
      }
      private static final com.google.protobuf.Internal.EnumLiteMap<
          Kind> internalValueMap =
            new com.google.protobuf.Internal.EnumLiteMap<Kind>() {
              public Kind findValueByNumber(int number) {
                return Kind.forNumber(number);
              }
            };

      public final com.google.protobuf.Descriptors.EnumValueDescriptor
          getValueDescriptor() {
        if (this == UNRECOGNIZED) {
          throw new java.lang.IllegalStateException(
              "Can't get the descriptor of an unrecognized enum value.");
        }
        return getDescriptor().getValues().get(ordinal());
      }
      public final com.google.protobuf.Descriptors.EnumDescriptor
          getDescriptorForType() {
        return getDescriptor();
      }
      public static final com.google.protobuf.Descriptors.EnumDescriptor
          getDescriptor() {
        return org.apache.submarine.server.api.proto.TritonModelConfig.ModelInstanceGroup.getDescriptor().getEnumTypes().get(0);
      }

      private static final Kind[] VALUES = values();

      public static Kind valueOf(
          com.google.protobuf.Descriptors.EnumValueDescriptor desc) {
        if (desc.getType() != getDescriptor()) {
          throw new java.lang.IllegalArgumentException(
            "EnumValueDescriptor is not for this type.");
        }
        if (desc.getIndex() == -1) {
          return UNRECOGNIZED;
        }
        return VALUES[desc.getIndex()];
      }

      private final int value;

      private Kind(int value) {
        this.value = value;
      }

      // @@protoc_insertion_point(enum_scope:inference.ModelInstanceGroup.Kind)
    }

    public interface SecondaryDeviceOrBuilder extends
        // @@protoc_insertion_point(interface_extends:inference.ModelInstanceGroup.SecondaryDevice)
        com.google.protobuf.MessageOrBuilder {

      /**
       * <pre>
       *&#64;&#64;  .. cpp:var:: SecondaryDeviceKind kind
       *&#64;&#64;
       *&#64;&#64;     The secondary device kind.
       *&#64;&#64;
       * </pre>
       *
       * <code>.inference.ModelInstanceGroup.SecondaryDevice.SecondaryDeviceKind kind = 1;</code>
       * @return The enum numeric value on the wire for kind.
       */
      int getKindValue();
      /**
       * <pre>
       *&#64;&#64;  .. cpp:var:: SecondaryDeviceKind kind
       *&#64;&#64;
       *&#64;&#64;     The secondary device kind.
       *&#64;&#64;
       * </pre>
       *
       * <code>.inference.ModelInstanceGroup.SecondaryDevice.SecondaryDeviceKind kind = 1;</code>
       * @return The kind.
       */
      org.apache.submarine.server.api.proto.TritonModelConfig.ModelInstanceGroup.SecondaryDevice.SecondaryDeviceKind getKind();

      /**
       * <pre>
       *&#64;&#64;  .. cpp:var:: int64 device_id
       *&#64;&#64;
       *&#64;&#64;     Identifier for the secondary device.
       *&#64;&#64;
       * </pre>
       *
       * <code>int64 device_id = 2;</code>
       * @return The deviceId.
       */
      long getDeviceId();
    }
    /**
     * <pre>
     *&#64;&#64;
     *&#64;&#64;  .. cpp:var:: message SecondaryDevice
     *&#64;&#64;
     *&#64;&#64;     A secondary device required for a model instance.
     *&#64;&#64;
     * </pre>
     *
     * Protobuf type {@code inference.ModelInstanceGroup.SecondaryDevice}
     */
    public static final class SecondaryDevice extends
        com.google.protobuf.GeneratedMessageV3 implements
        // @@protoc_insertion_point(message_implements:inference.ModelInstanceGroup.SecondaryDevice)
        SecondaryDeviceOrBuilder {
    private static final long serialVersionUID = 0L;
      // Use SecondaryDevice.newBuilder() to construct.
      private SecondaryDevice(com.google.protobuf.GeneratedMessageV3.Builder<?> builder) {
        super(builder);
      }
      private SecondaryDevice() {
        kind_ = 0;
      }

      @java.lang.Override
      @SuppressWarnings({"unused"})
      protected java.lang.Object newInstance(
          UnusedPrivateParameter unused) {
        return new SecondaryDevice();
      }

      @java.lang.Override
      public final com.google.protobuf.UnknownFieldSet
      getUnknownFields() {
        return this.unknownFields;
      }
      private SecondaryDevice(
          com.google.protobuf.CodedInputStream input,
          com.google.protobuf.ExtensionRegistryLite extensionRegistry)
          throws com.google.protobuf.InvalidProtocolBufferException {
        this();
        if (extensionRegistry == null) {
          throw new java.lang.NullPointerException();
        }
        com.google.protobuf.UnknownFieldSet.Builder unknownFields =
            com.google.protobuf.UnknownFieldSet.newBuilder();
        try {
          boolean done = false;
          while (!done) {
            int tag = input.readTag();
            switch (tag) {
              case 0:
                done = true;
                break;
              case 8: {
                int rawValue = input.readEnum();

                kind_ = rawValue;
                break;
              }
              case 16: {

                deviceId_ = input.readInt64();
                break;
              }
              default: {
                if (!parseUnknownField(
                    input, unknownFields, extensionRegistry, tag)) {
                  done = true;
                }
                break;
              }
            }
          }
        } catch (com.google.protobuf.InvalidProtocolBufferException e) {
          throw e.setUnfinishedMessage(this);
        } catch (java.io.IOException e) {
          throw new com.google.protobuf.InvalidProtocolBufferException(
              e).setUnfinishedMessage(this);
        } finally {
          this.unknownFields = unknownFields.build();
          makeExtensionsImmutable();
        }
      }
      public static final com.google.protobuf.Descriptors.Descriptor
          getDescriptor() {
        return org.apache.submarine.server.api.proto.TritonModelConfig.internal_static_inference_ModelInstanceGroup_SecondaryDevice_descriptor;
      }

      @java.lang.Override
      protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
          internalGetFieldAccessorTable() {
        return org.apache.submarine.server.api.proto.TritonModelConfig.internal_static_inference_ModelInstanceGroup_SecondaryDevice_fieldAccessorTable
            .ensureFieldAccessorsInitialized(
                org.apache.submarine.server.api.proto.TritonModelConfig.ModelInstanceGroup.SecondaryDevice.class, org.apache.submarine.server.api.proto.TritonModelConfig.ModelInstanceGroup.SecondaryDevice.Builder.class);
      }

      /**
       * <pre>
       *&#64;&#64;
       *&#64;&#64;  .. cpp:enum:: SecondaryDeviceKind
       *&#64;&#64;
       *&#64;&#64;     The kind of the secondary device.
       *&#64;&#64;
       * </pre>
       *
       * Protobuf enum {@code inference.ModelInstanceGroup.SecondaryDevice.SecondaryDeviceKind}
       */
      public enum SecondaryDeviceKind
          implements com.google.protobuf.ProtocolMessageEnum {
        /**
         * <pre>
         *&#64;&#64;    .. cpp:enumerator:: SecondaryDeviceKind::KIND_NVDLA = 0
         *&#64;&#64;
         *&#64;&#64;       An NVDLA core. http://nvdla.org
         *&#64;&#64;       Currently KIND_NVDLA is only supported by the TensorRT backend.
         *&#64;&#64;
         * </pre>
         *
         * <code>KIND_NVDLA = 0;</code>
         */
        KIND_NVDLA(0),
        UNRECOGNIZED(-1),
        ;

        /**
         * <pre>
         *&#64;&#64;    .. cpp:enumerator:: SecondaryDeviceKind::KIND_NVDLA = 0
         *&#64;&#64;
         *&#64;&#64;       An NVDLA core. http://nvdla.org
         *&#64;&#64;       Currently KIND_NVDLA is only supported by the TensorRT backend.
         *&#64;&#64;
         * </pre>
         *
         * <code>KIND_NVDLA = 0;</code>
         */
        public static final int KIND_NVDLA_VALUE = 0;


        public final int getNumber() {
          if (this == UNRECOGNIZED) {
            throw new java.lang.IllegalArgumentException(
                "Can't get the number of an unknown enum value.");
          }
          return value;
        }

        /**
         * @param value The numeric wire value of the corresponding enum entry.
         * @return The enum associated with the given numeric wire value.
         * @deprecated Use {@link #forNumber(int)} instead.
         */
        @java.lang.Deprecated
        public static SecondaryDeviceKind valueOf(int value) {
          return forNumber(value);
        }

        /**
         * @param value The numeric wire value of the corresponding enum entry.
         * @return The enum associated with the given numeric wire value.
         */
        public static SecondaryDeviceKind forNumber(int value) {
          switch (value) {
            case 0: return KIND_NVDLA;
            default: return null;
          }
        }

        public static com.google.protobuf.Internal.EnumLiteMap<SecondaryDeviceKind>
            internalGetValueMap() {
          return internalValueMap;
        }
        private static final com.google.protobuf.Internal.EnumLiteMap<
            SecondaryDeviceKind> internalValueMap =
              new com.google.protobuf.Internal.EnumLiteMap<SecondaryDeviceKind>() {
                public SecondaryDeviceKind findValueByNumber(int number) {
                  return SecondaryDeviceKind.forNumber(number);
                }
              };

        public final com.google.protobuf.Descriptors.EnumValueDescriptor
            getValueDescriptor() {
          if (this == UNRECOGNIZED) {
            throw new java.lang.IllegalStateException(
                "Can't get the descriptor of an unrecognized enum value.");
          }
          return getDescriptor().getValues().get(ordinal());
        }
        public final com.google.protobuf.Descriptors.EnumDescriptor
            getDescriptorForType() {
          return getDescriptor();
        }
        public static final com.google.protobuf.Descriptors.EnumDescriptor
            getDescriptor() {
          return org.apache.submarine.server.api.proto.TritonModelConfig.ModelInstanceGroup.SecondaryDevice.getDescriptor().getEnumTypes().get(0);
        }

        private static final SecondaryDeviceKind[] VALUES = values();

        public static SecondaryDeviceKind valueOf(
            com.google.protobuf.Descriptors.EnumValueDescriptor desc) {
          if (desc.getType() != getDescriptor()) {
            throw new java.lang.IllegalArgumentException(
              "EnumValueDescriptor is not for this type.");
          }
          if (desc.getIndex() == -1) {
            return UNRECOGNIZED;
          }
          return VALUES[desc.getIndex()];
        }

        private final int value;

        private SecondaryDeviceKind(int value) {
          this.value = value;
        }

        // @@protoc_insertion_point(enum_scope:inference.ModelInstanceGroup.SecondaryDevice.SecondaryDeviceKind)
      }

      public static final int KIND_FIELD_NUMBER = 1;
      private int kind_;
      /**
       * <pre>
       *&#64;&#64;  .. cpp:var:: SecondaryDeviceKind kind
       *&#64;&#64;
       *&#64;&#64;     The secondary device kind.
       *&#64;&#64;
       * </pre>
       *
       * <code>.inference.ModelInstanceGroup.SecondaryDevice.SecondaryDeviceKind kind = 1;</code>
       * @return The enum numeric value on the wire for kind.
       */
      @java.lang.Override public int getKindValue() {
        return kind_;
      }
      /**
       * <pre>
       *&#64;&#64;  .. cpp:var:: SecondaryDeviceKind kind
       *&#64;&#64;
       *&#64;&#64;     The secondary device kind.
       *&#64;&#64;
       * </pre>
       *
       * <code>.inference.ModelInstanceGroup.SecondaryDevice.SecondaryDeviceKind kind = 1;</code>
       * @return The kind.
       */
      @java.lang.Override public org.apache.submarine.server.api.proto.TritonModelConfig.ModelInstanceGroup.SecondaryDevice.SecondaryDeviceKind getKind() {
        @SuppressWarnings("deprecation")
        org.apache.submarine.server.api.proto.TritonModelConfig.ModelInstanceGroup.SecondaryDevice.SecondaryDeviceKind result = org.apache.submarine.server.api.proto.TritonModelConfig.ModelInstanceGroup.SecondaryDevice.SecondaryDeviceKind.valueOf(kind_);
        return result == null ? org.apache.submarine.server.api.proto.TritonModelConfig.ModelInstanceGroup.SecondaryDevice.SecondaryDeviceKind.UNRECOGNIZED : result;
      }

      public static final int DEVICE_ID_FIELD_NUMBER = 2;
      private long deviceId_;
      /**
       * <pre>
       *&#64;&#64;  .. cpp:var:: int64 device_id
       *&#64;&#64;
       *&#64;&#64;     Identifier for the secondary device.
       *&#64;&#64;
       * </pre>
       *
       * <code>int64 device_id = 2;</code>
       * @return The deviceId.
       */
      @java.lang.Override
      public long getDeviceId() {
        return deviceId_;
      }

      private byte memoizedIsInitialized = -1;
      @java.lang.Override
      public final boolean isInitialized() {
        byte isInitialized = memoizedIsInitialized;
        if (isInitialized == 1) return true;
        if (isInitialized == 0) return false;

        memoizedIsInitialized = 1;
        return true;
      }

      @java.lang.Override
      public void writeTo(com.google.protobuf.CodedOutputStream output)
                          throws java.io.IOException {
        if (kind_ != org.apache.submarine.server.api.proto.TritonModelConfig.ModelInstanceGroup.SecondaryDevice.SecondaryDeviceKind.KIND_NVDLA.getNumber()) {
          output.writeEnum(1, kind_);
        }
        if (deviceId_ != 0L) {
          output.writeInt64(2, deviceId_);
        }
        unknownFields.writeTo(output);
      }

      @java.lang.Override
      public int getSerializedSize() {
        int size = memoizedSize;
        if (size != -1) return size;

        size = 0;
        if (kind_ != org.apache.submarine.server.api.proto.TritonModelConfig.ModelInstanceGroup.SecondaryDevice.SecondaryDeviceKind.KIND_NVDLA.getNumber()) {
          size += com.google.protobuf.CodedOutputStream
            .computeEnumSize(1, kind_);
        }
        if (deviceId_ != 0L) {
          size += com.google.protobuf.CodedOutputStream
            .computeInt64Size(2, deviceId_);
        }
        size += unknownFields.getSerializedSize();
        memoizedSize = size;
        return size;
      }

      @java.lang.Override
      public boolean equals(final java.lang.Object obj) {
        if (obj == this) {
         return true;
        }
        if (!(obj instanceof org.apache.submarine.server.api.proto.TritonModelConfig.ModelInstanceGroup.SecondaryDevice)) {
          return super.equals(obj);
        }
        org.apache.submarine.server.api.proto.TritonModelConfig.ModelInstanceGroup.SecondaryDevice other = (org.apache.submarine.server.api.proto.TritonModelConfig.ModelInstanceGroup.SecondaryDevice) obj;

        if (kind_ != other.kind_) return false;
        if (getDeviceId()
            != other.getDeviceId()) return false;
        if (!unknownFields.equals(other.unknownFields)) return false;
        return true;
      }

      @java.lang.Override
      public int hashCode() {
        if (memoizedHashCode != 0) {
          return memoizedHashCode;
        }
        int hash = 41;
        hash = (19 * hash) + getDescriptor().hashCode();
        hash = (37 * hash) + KIND_FIELD_NUMBER;
        hash = (53 * hash) + kind_;
        hash = (37 * hash) + DEVICE_ID_FIELD_NUMBER;
        hash = (53 * hash) + com.google.protobuf.Internal.hashLong(
            getDeviceId());
        hash = (29 * hash) + unknownFields.hashCode();
        memoizedHashCode = hash;
        return hash;
      }

      public static org.apache.submarine.server.api.proto.TritonModelConfig.ModelInstanceGroup.SecondaryDevice parseFrom(
          java.nio.ByteBuffer data)
          throws com.google.protobuf.InvalidProtocolBufferException {
        return PARSER.parseFrom(data);
      }
      public static org.apache.submarine.server.api.proto.TritonModelConfig.ModelInstanceGroup.SecondaryDevice parseFrom(
          java.nio.ByteBuffer data,
          com.google.protobuf.ExtensionRegistryLite extensionRegistry)
          throws com.google.protobuf.InvalidProtocolBufferException {
        return PARSER.parseFrom(data, extensionRegistry);
      }
      public static org.apache.submarine.server.api.proto.TritonModelConfig.ModelInstanceGroup.SecondaryDevice parseFrom(
          com.google.protobuf.ByteString data)
          throws com.google.protobuf.InvalidProtocolBufferException {
        return PARSER.parseFrom(data);
      }
      public static org.apache.submarine.server.api.proto.TritonModelConfig.ModelInstanceGroup.SecondaryDevice parseFrom(
          com.google.protobuf.ByteString data,
          com.google.protobuf.ExtensionRegistryLite extensionRegistry)
          throws com.google.protobuf.InvalidProtocolBufferException {
        return PARSER.parseFrom(data, extensionRegistry);
      }
      public static org.apache.submarine.server.api.proto.TritonModelConfig.ModelInstanceGroup.SecondaryDevice parseFrom(byte[] data)
          throws com.google.protobuf.InvalidProtocolBufferException {
        return PARSER.parseFrom(data);
      }
      public static org.apache.submarine.server.api.proto.TritonModelConfig.ModelInstanceGroup.SecondaryDevice parseFrom(
          byte[] data,
          com.google.protobuf.ExtensionRegistryLite extensionRegistry)
          throws com.google.protobuf.InvalidProtocolBufferException {
        return PARSER.parseFrom(data, extensionRegistry);
      }
      public static org.apache.submarine.server.api.proto.TritonModelConfig.ModelInstanceGroup.SecondaryDevice parseFrom(java.io.InputStream input)
          throws java.io.IOException {
        return com.google.protobuf.GeneratedMessageV3
            .parseWithIOException(PARSER, input);
      }
      public static org.apache.submarine.server.api.proto.TritonModelConfig.ModelInstanceGroup.SecondaryDevice parseFrom(
          java.io.InputStream input,
          com.google.protobuf.ExtensionRegistryLite extensionRegistry)
          throws java.io.IOException {
        return com.google.protobuf.GeneratedMessageV3
            .parseWithIOException(PARSER, input, extensionRegistry);
      }
      public static org.apache.submarine.server.api.proto.TritonModelConfig.ModelInstanceGroup.SecondaryDevice parseDelimitedFrom(java.io.InputStream input)
          throws java.io.IOException {
        return com.google.protobuf.GeneratedMessageV3
            .parseDelimitedWithIOException(PARSER, input);
      }
      public static org.apache.submarine.server.api.proto.TritonModelConfig.ModelInstanceGroup.SecondaryDevice parseDelimitedFrom(
          java.io.InputStream input,
          com.google.protobuf.ExtensionRegistryLite extensionRegistry)
          throws java.io.IOException {
        return com.google.protobuf.GeneratedMessageV3
            .parseDelimitedWithIOException(PARSER, input, extensionRegistry);
      }
      public static org.apache.submarine.server.api.proto.TritonModelConfig.ModelInstanceGroup.SecondaryDevice parseFrom(
          com.google.protobuf.CodedInputStream input)
          throws java.io.IOException {
        return com.google.protobuf.GeneratedMessageV3
            .parseWithIOException(PARSER, input);
      }
      public static org.apache.submarine.server.api.proto.TritonModelConfig.ModelInstanceGroup.SecondaryDevice parseFrom(
          com.google.protobuf.CodedInputStream input,
          com.google.protobuf.ExtensionRegistryLite extensionRegistry)
          throws java.io.IOException {
        return com.google.protobuf.GeneratedMessageV3
            .parseWithIOException(PARSER, input, extensionRegistry);
      }

      @java.lang.Override
      public Builder newBuilderForType() { return newBuilder(); }
      public static Builder newBuilder() {
        return DEFAULT_INSTANCE.toBuilder();
      }
      public static Builder newBuilder(org.apache.submarine.server.api.proto.TritonModelConfig.ModelInstanceGroup.SecondaryDevice prototype) {
        return DEFAULT_INSTANCE.toBuilder().mergeFrom(prototype);
      }
      @java.lang.Override
      public Builder toBuilder() {
        return this == DEFAULT_INSTANCE
            ? new Builder() : new Builder().mergeFrom(this);
      }

      @java.lang.Override
      protected Builder newBuilderForType(
          com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
        Builder builder = new Builder(parent);
        return builder;
      }
      /**
       * <pre>
       *&#64;&#64;
       *&#64;&#64;  .. cpp:var:: message SecondaryDevice
       *&#64;&#64;
       *&#64;&#64;     A secondary device required for a model instance.
       *&#64;&#64;
       * </pre>
       *
       * Protobuf type {@code inference.ModelInstanceGroup.SecondaryDevice}
       */
      public static final class Builder extends
          com.google.protobuf.GeneratedMessageV3.Builder<Builder> implements
          // @@protoc_insertion_point(builder_implements:inference.ModelInstanceGroup.SecondaryDevice)
          org.apache.submarine.server.api.proto.TritonModelConfig.ModelInstanceGroup.SecondaryDeviceOrBuilder {
        public static final com.google.protobuf.Descriptors.Descriptor
            getDescriptor() {
          return org.apache.submarine.server.api.proto.TritonModelConfig.internal_static_inference_ModelInstanceGroup_SecondaryDevice_descriptor;
        }

        @java.lang.Override
        protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
            internalGetFieldAccessorTable() {
          return org.apache.submarine.server.api.proto.TritonModelConfig.internal_static_inference_ModelInstanceGroup_SecondaryDevice_fieldAccessorTable
              .ensureFieldAccessorsInitialized(
                  org.apache.submarine.server.api.proto.TritonModelConfig.ModelInstanceGroup.SecondaryDevice.class, org.apache.submarine.server.api.proto.TritonModelConfig.ModelInstanceGroup.SecondaryDevice.Builder.class);
        }

        // Construct using org.apache.submarine.server.api.proto.TritonModelConfig.ModelInstanceGroup.SecondaryDevice.newBuilder()
        private Builder() {
          maybeForceBuilderInitialization();
        }

        private Builder(
            com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
          super(parent);
          maybeForceBuilderInitialization();
        }
        private void maybeForceBuilderInitialization() {
          if (com.google.protobuf.GeneratedMessageV3
                  .alwaysUseFieldBuilders) {
          }
        }
        @java.lang.Override
        public Builder clear() {
          super.clear();
          kind_ = 0;

          deviceId_ = 0L;

          return this;
        }

        @java.lang.Override
        public com.google.protobuf.Descriptors.Descriptor
            getDescriptorForType() {
          return org.apache.submarine.server.api.proto.TritonModelConfig.internal_static_inference_ModelInstanceGroup_SecondaryDevice_descriptor;
        }

        @java.lang.Override
        public org.apache.submarine.server.api.proto.TritonModelConfig.ModelInstanceGroup.SecondaryDevice getDefaultInstanceForType() {
          return org.apache.submarine.server.api.proto.TritonModelConfig.ModelInstanceGroup.SecondaryDevice.getDefaultInstance();
        }

        @java.lang.Override
        public org.apache.submarine.server.api.proto.TritonModelConfig.ModelInstanceGroup.SecondaryDevice build() {
          org.apache.submarine.server.api.proto.TritonModelConfig.ModelInstanceGroup.SecondaryDevice result = buildPartial();
          if (!result.isInitialized()) {
            throw newUninitializedMessageException(result);
          }
          return result;
        }

        @java.lang.Override
        public org.apache.submarine.server.api.proto.TritonModelConfig.ModelInstanceGroup.SecondaryDevice buildPartial() {
          org.apache.submarine.server.api.proto.TritonModelConfig.ModelInstanceGroup.SecondaryDevice result = new org.apache.submarine.server.api.proto.TritonModelConfig.ModelInstanceGroup.SecondaryDevice(this);
          result.kind_ = kind_;
          result.deviceId_ = deviceId_;
          onBuilt();
          return result;
        }

        @java.lang.Override
        public Builder clone() {
          return super.clone();
        }
        @java.lang.Override
        public Builder setField(
            com.google.protobuf.Descriptors.FieldDescriptor field,
            java.lang.Object value) {
          return super.setField(field, value);
        }
        @java.lang.Override
        public Builder clearField(
            com.google.protobuf.Descriptors.FieldDescriptor field) {
          return super.clearField(field);
        }
        @java.lang.Override
        public Builder clearOneof(
            com.google.protobuf.Descriptors.OneofDescriptor oneof) {
          return super.clearOneof(oneof);
        }
        @java.lang.Override
        public Builder setRepeatedField(
            com.google.protobuf.Descriptors.FieldDescriptor field,
            int index, java.lang.Object value) {
          return super.setRepeatedField(field, index, value);
        }
        @java.lang.Override
        public Builder addRepeatedField(
            com.google.protobuf.Descriptors.FieldDescriptor field,
            java.lang.Object value) {
          return super.addRepeatedField(field, value);
        }
        @java.lang.Override
        public Builder mergeFrom(com.google.protobuf.Message other) {
          if (other instanceof org.apache.submarine.server.api.proto.TritonModelConfig.ModelInstanceGroup.SecondaryDevice) {
            return mergeFrom((org.apache.submarine.server.api.proto.TritonModelConfig.ModelInstanceGroup.SecondaryDevice)other);
          } else {
            super.mergeFrom(other);
            return this;
          }
        }

        public Builder mergeFrom(org.apache.submarine.server.api.proto.TritonModelConfig.ModelInstanceGroup.SecondaryDevice other) {
          if (other == org.apache.submarine.server.api.proto.TritonModelConfig.ModelInstanceGroup.SecondaryDevice.getDefaultInstance()) return this;
          if (other.kind_ != 0) {
            setKindValue(other.getKindValue());
          }
          if (other.getDeviceId() != 0L) {
            setDeviceId(other.getDeviceId());
          }
          this.mergeUnknownFields(other.unknownFields);
          onChanged();
          return this;
        }

        @java.lang.Override
        public final boolean isInitialized() {
          return true;
        }

        @java.lang.Override
        public Builder mergeFrom(
            com.google.protobuf.CodedInputStream input,
            com.google.protobuf.ExtensionRegistryLite extensionRegistry)
            throws java.io.IOException {
          org.apache.submarine.server.api.proto.TritonModelConfig.ModelInstanceGroup.SecondaryDevice parsedMessage = null;
          try {
            parsedMessage = PARSER.parsePartialFrom(input, extensionRegistry);
          } catch (com.google.protobuf.InvalidProtocolBufferException e) {
            parsedMessage = (org.apache.submarine.server.api.proto.TritonModelConfig.ModelInstanceGroup.SecondaryDevice) e.getUnfinishedMessage();
            throw e.unwrapIOException();
          } finally {
            if (parsedMessage != null) {
              mergeFrom(parsedMessage);
            }
          }
          return this;
        }

        private int kind_ = 0;
        /**
         * <pre>
         *&#64;&#64;  .. cpp:var:: SecondaryDeviceKind kind
         *&#64;&#64;
         *&#64;&#64;     The secondary device kind.
         *&#64;&#64;
         * </pre>
         *
         * <code>.inference.ModelInstanceGroup.SecondaryDevice.SecondaryDeviceKind kind = 1;</code>
         * @return The enum numeric value on the wire for kind.
         */
        @java.lang.Override public int getKindValue() {
          return kind_;
        }
        /**
         * <pre>
         *&#64;&#64;  .. cpp:var:: SecondaryDeviceKind kind
         *&#64;&#64;
         *&#64;&#64;     The secondary device kind.
         *&#64;&#64;
         * </pre>
         *
         * <code>.inference.ModelInstanceGroup.SecondaryDevice.SecondaryDeviceKind kind = 1;</code>
         * @param value The enum numeric value on the wire for kind to set.
         * @return This builder for chaining.
         */
        public Builder setKindValue(int value) {
          
          kind_ = value;
          onChanged();
          return this;
        }
        /**
         * <pre>
         *&#64;&#64;  .. cpp:var:: SecondaryDeviceKind kind
         *&#64;&#64;
         *&#64;&#64;     The secondary device kind.
         *&#64;&#64;
         * </pre>
         *
         * <code>.inference.ModelInstanceGroup.SecondaryDevice.SecondaryDeviceKind kind = 1;</code>
         * @return The kind.
         */
        @java.lang.Override
        public org.apache.submarine.server.api.proto.TritonModelConfig.ModelInstanceGroup.SecondaryDevice.SecondaryDeviceKind getKind() {
          @SuppressWarnings("deprecation")
          org.apache.submarine.server.api.proto.TritonModelConfig.ModelInstanceGroup.SecondaryDevice.SecondaryDeviceKind result = org.apache.submarine.server.api.proto.TritonModelConfig.ModelInstanceGroup.SecondaryDevice.SecondaryDeviceKind.valueOf(kind_);
          return result == null ? org.apache.submarine.server.api.proto.TritonModelConfig.ModelInstanceGroup.SecondaryDevice.SecondaryDeviceKind.UNRECOGNIZED : result;
        }
        /**
         * <pre>
         *&#64;&#64;  .. cpp:var:: SecondaryDeviceKind kind
         *&#64;&#64;
         *&#64;&#64;     The secondary device kind.
         *&#64;&#64;
         * </pre>
         *
         * <code>.inference.ModelInstanceGroup.SecondaryDevice.SecondaryDeviceKind kind = 1;</code>
         * @param value The kind to set.
         * @return This builder for chaining.
         */
        public Builder setKind(org.apache.submarine.server.api.proto.TritonModelConfig.ModelInstanceGroup.SecondaryDevice.SecondaryDeviceKind value) {
          if (value == null) {
            throw new NullPointerException();
          }
          
          kind_ = value.getNumber();
          onChanged();
          return this;
        }
        /**
         * <pre>
         *&#64;&#64;  .. cpp:var:: SecondaryDeviceKind kind
         *&#64;&#64;
         *&#64;&#64;     The secondary device kind.
         *&#64;&#64;
         * </pre>
         *
         * <code>.inference.ModelInstanceGroup.SecondaryDevice.SecondaryDeviceKind kind = 1;</code>
         * @return This builder for chaining.
         */
        public Builder clearKind() {
          
          kind_ = 0;
          onChanged();
          return this;
        }

        private long deviceId_ ;
        /**
         * <pre>
         *&#64;&#64;  .. cpp:var:: int64 device_id
         *&#64;&#64;
         *&#64;&#64;     Identifier for the secondary device.
         *&#64;&#64;
         * </pre>
         *
         * <code>int64 device_id = 2;</code>
         * @return The deviceId.
         */
        @java.lang.Override
        public long getDeviceId() {
          return deviceId_;
        }
        /**
         * <pre>
         *&#64;&#64;  .. cpp:var:: int64 device_id
         *&#64;&#64;
         *&#64;&#64;     Identifier for the secondary device.
         *&#64;&#64;
         * </pre>
         *
         * <code>int64 device_id = 2;</code>
         * @param value The deviceId to set.
         * @return This builder for chaining.
         */
        public Builder setDeviceId(long value) {
          
          deviceId_ = value;
          onChanged();
          return this;
        }
        /**
         * <pre>
         *&#64;&#64;  .. cpp:var:: int64 device_id
         *&#64;&#64;
         *&#64;&#64;     Identifier for the secondary device.
         *&#64;&#64;
         * </pre>
         *
         * <code>int64 device_id = 2;</code>
         * @return This builder for chaining.
         */
        public Builder clearDeviceId() {
          
          deviceId_ = 0L;
          onChanged();
          return this;
        }
        @java.lang.Override
        public final Builder setUnknownFields(
            final com.google.protobuf.UnknownFieldSet unknownFields) {
          return super.setUnknownFields(unknownFields);
        }

        @java.lang.Override
        public final Builder mergeUnknownFields(
            final com.google.protobuf.UnknownFieldSet unknownFields) {
          return super.mergeUnknownFields(unknownFields);
        }


        // @@protoc_insertion_point(builder_scope:inference.ModelInstanceGroup.SecondaryDevice)
      }

      // @@protoc_insertion_point(class_scope:inference.ModelInstanceGroup.SecondaryDevice)
      private static final org.apache.submarine.server.api.proto.TritonModelConfig.ModelInstanceGroup.SecondaryDevice DEFAULT_INSTANCE;
      static {
        DEFAULT_INSTANCE = new org.apache.submarine.server.api.proto.TritonModelConfig.ModelInstanceGroup.SecondaryDevice();
      }

      public static org.apache.submarine.server.api.proto.TritonModelConfig.ModelInstanceGroup.SecondaryDevice getDefaultInstance() {
        return DEFAULT_INSTANCE;
      }

      private static final com.google.protobuf.Parser<SecondaryDevice>
          PARSER = new com.google.protobuf.AbstractParser<SecondaryDevice>() {
        @java.lang.Override
        public SecondaryDevice parsePartialFrom(
            com.google.protobuf.CodedInputStream input,
            com.google.protobuf.ExtensionRegistryLite extensionRegistry)
            throws com.google.protobuf.InvalidProtocolBufferException {
          return new SecondaryDevice(input, extensionRegistry);
        }
      };

      public static com.google.protobuf.Parser<SecondaryDevice> parser() {
        return PARSER;
      }

      @java.lang.Override
      public com.google.protobuf.Parser<SecondaryDevice> getParserForType() {
        return PARSER;
      }

      @java.lang.Override
      public org.apache.submarine.server.api.proto.TritonModelConfig.ModelInstanceGroup.SecondaryDevice getDefaultInstanceForType() {
        return DEFAULT_INSTANCE;
      }

    }

    public static final int NAME_FIELD_NUMBER = 1;
    private volatile java.lang.Object name_;
    /**
     * <pre>
     *&#64;&#64;  .. cpp:var:: string name
     *&#64;&#64;
     *&#64;&#64;     Optional name of this group of instances. If not specified the
     *&#64;&#64;     name will be formed as &lt;model name&gt;_&lt;group number&gt;. The name of
     *&#64;&#64;     individual instances will be further formed by a unique instance
     *&#64;&#64;     number and GPU index:
     *&#64;&#64;
     * </pre>
     *
     * <code>string name = 1;</code>
     * @return The name.
     */
    @java.lang.Override
    public java.lang.String getName() {
      java.lang.Object ref = name_;
      if (ref instanceof java.lang.String) {
        return (java.lang.String) ref;
      } else {
        com.google.protobuf.ByteString bs = 
            (com.google.protobuf.ByteString) ref;
        java.lang.String s = bs.toStringUtf8();
        name_ = s;
        return s;
      }
    }
    /**
     * <pre>
     *&#64;&#64;  .. cpp:var:: string name
     *&#64;&#64;
     *&#64;&#64;     Optional name of this group of instances. If not specified the
     *&#64;&#64;     name will be formed as &lt;model name&gt;_&lt;group number&gt;. The name of
     *&#64;&#64;     individual instances will be further formed by a unique instance
     *&#64;&#64;     number and GPU index:
     *&#64;&#64;
     * </pre>
     *
     * <code>string name = 1;</code>
     * @return The bytes for name.
     */
    @java.lang.Override
    public com.google.protobuf.ByteString
        getNameBytes() {
      java.lang.Object ref = name_;
      if (ref instanceof java.lang.String) {
        com.google.protobuf.ByteString b = 
            com.google.protobuf.ByteString.copyFromUtf8(
                (java.lang.String) ref);
        name_ = b;
        return b;
      } else {
        return (com.google.protobuf.ByteString) ref;
      }
    }

    public static final int KIND_FIELD_NUMBER = 4;
    private int kind_;
    /**
     * <pre>
     *&#64;&#64;  .. cpp:var:: Kind kind
     *&#64;&#64;
     *&#64;&#64;     The kind of this instance group. Default is KIND_AUTO. If
     *&#64;&#64;     KIND_AUTO or KIND_GPU then both 'count' and 'gpu' are valid and
     *&#64;&#64;     may be specified. If KIND_CPU or KIND_MODEL only 'count' is valid
     *&#64;&#64;     and 'gpu' cannot be specified.
     *&#64;&#64;
     * </pre>
     *
     * <code>.inference.ModelInstanceGroup.Kind kind = 4;</code>
     * @return The enum numeric value on the wire for kind.
     */
    @java.lang.Override public int getKindValue() {
      return kind_;
    }
    /**
     * <pre>
     *&#64;&#64;  .. cpp:var:: Kind kind
     *&#64;&#64;
     *&#64;&#64;     The kind of this instance group. Default is KIND_AUTO. If
     *&#64;&#64;     KIND_AUTO or KIND_GPU then both 'count' and 'gpu' are valid and
     *&#64;&#64;     may be specified. If KIND_CPU or KIND_MODEL only 'count' is valid
     *&#64;&#64;     and 'gpu' cannot be specified.
     *&#64;&#64;
     * </pre>
     *
     * <code>.inference.ModelInstanceGroup.Kind kind = 4;</code>
     * @return The kind.
     */
    @java.lang.Override public org.apache.submarine.server.api.proto.TritonModelConfig.ModelInstanceGroup.Kind getKind() {
      @SuppressWarnings("deprecation")
      org.apache.submarine.server.api.proto.TritonModelConfig.ModelInstanceGroup.Kind result = org.apache.submarine.server.api.proto.TritonModelConfig.ModelInstanceGroup.Kind.valueOf(kind_);
      return result == null ? org.apache.submarine.server.api.proto.TritonModelConfig.ModelInstanceGroup.Kind.UNRECOGNIZED : result;
    }

    public static final int COUNT_FIELD_NUMBER = 2;
    private int count_;
    /**
     * <pre>
     *&#64;&#64;  .. cpp:var:: int32 count
     *&#64;&#64;
     *&#64;&#64;     For a group assigned to GPU, the number of instances created for
     *&#64;&#64;     each GPU listed in 'gpus'. For a group assigned to CPU the number
     *&#64;&#64;     of instances created. Default is 1.
     * </pre>
     *
     * <code>int32 count = 2;</code>
     * @return The count.
     */
    @java.lang.Override
    public int getCount() {
      return count_;
    }

    public static final int RATE_LIMITER_FIELD_NUMBER = 6;
    private org.apache.submarine.server.api.proto.TritonModelConfig.ModelRateLimiter rateLimiter_;
    /**
     * <pre>
     *&#64;&#64;  .. cpp:var:: ModelRateLimiter rate_limiter
     *&#64;&#64;
     *&#64;&#64;     The rate limiter specific settings to be associated with this
     *&#64;&#64;     instance group. Optional, if not specified no rate limiting
     *&#64;&#64;     will be applied to this instance group.
     *&#64;&#64;
     * </pre>
     *
     * <code>.inference.ModelRateLimiter rate_limiter = 6;</code>
     * @return Whether the rateLimiter field is set.
     */
    @java.lang.Override
    public boolean hasRateLimiter() {
      return rateLimiter_ != null;
    }
    /**
     * <pre>
     *&#64;&#64;  .. cpp:var:: ModelRateLimiter rate_limiter
     *&#64;&#64;
     *&#64;&#64;     The rate limiter specific settings to be associated with this
     *&#64;&#64;     instance group. Optional, if not specified no rate limiting
     *&#64;&#64;     will be applied to this instance group.
     *&#64;&#64;
     * </pre>
     *
     * <code>.inference.ModelRateLimiter rate_limiter = 6;</code>
     * @return The rateLimiter.
     */
    @java.lang.Override
    public org.apache.submarine.server.api.proto.TritonModelConfig.ModelRateLimiter getRateLimiter() {
      return rateLimiter_ == null ? org.apache.submarine.server.api.proto.TritonModelConfig.ModelRateLimiter.getDefaultInstance() : rateLimiter_;
    }
    /**
     * <pre>
     *&#64;&#64;  .. cpp:var:: ModelRateLimiter rate_limiter
     *&#64;&#64;
     *&#64;&#64;     The rate limiter specific settings to be associated with this
     *&#64;&#64;     instance group. Optional, if not specified no rate limiting
     *&#64;&#64;     will be applied to this instance group.
     *&#64;&#64;
     * </pre>
     *
     * <code>.inference.ModelRateLimiter rate_limiter = 6;</code>
     */
    @java.lang.Override
    public org.apache.submarine.server.api.proto.TritonModelConfig.ModelRateLimiterOrBuilder getRateLimiterOrBuilder() {
      return getRateLimiter();
    }

    public static final int GPUS_FIELD_NUMBER = 3;
    private com.google.protobuf.Internal.IntList gpus_;
    /**
     * <pre>
     *&#64;&#64;  .. cpp:var:: int32 gpus (repeated)
     *&#64;&#64;
     *&#64;&#64;     GPU(s) where instances should be available. For each GPU listed,
     *&#64;&#64;     'count' instances of the model will be available. Setting 'gpus'
     *&#64;&#64;     to empty (or not specifying at all) is eqivalent to listing all
     *&#64;&#64;     available GPUs.
     *&#64;&#64;
     * </pre>
     *
     * <code>repeated int32 gpus = 3;</code>
     * @return A list containing the gpus.
     */
    @java.lang.Override
    public java.util.List<java.lang.Integer>
        getGpusList() {
      return gpus_;
    }
    /**
     * <pre>
     *&#64;&#64;  .. cpp:var:: int32 gpus (repeated)
     *&#64;&#64;
     *&#64;&#64;     GPU(s) where instances should be available. For each GPU listed,
     *&#64;&#64;     'count' instances of the model will be available. Setting 'gpus'
     *&#64;&#64;     to empty (or not specifying at all) is eqivalent to listing all
     *&#64;&#64;     available GPUs.
     *&#64;&#64;
     * </pre>
     *
     * <code>repeated int32 gpus = 3;</code>
     * @return The count of gpus.
     */
    public int getGpusCount() {
      return gpus_.size();
    }
    /**
     * <pre>
     *&#64;&#64;  .. cpp:var:: int32 gpus (repeated)
     *&#64;&#64;
     *&#64;&#64;     GPU(s) where instances should be available. For each GPU listed,
     *&#64;&#64;     'count' instances of the model will be available. Setting 'gpus'
     *&#64;&#64;     to empty (or not specifying at all) is eqivalent to listing all
     *&#64;&#64;     available GPUs.
     *&#64;&#64;
     * </pre>
     *
     * <code>repeated int32 gpus = 3;</code>
     * @param index The index of the element to return.
     * @return The gpus at the given index.
     */
    public int getGpus(int index) {
      return gpus_.getInt(index);
    }
    private int gpusMemoizedSerializedSize = -1;

    public static final int SECONDARY_DEVICES_FIELD_NUMBER = 8;
    private java.util.List<org.apache.submarine.server.api.proto.TritonModelConfig.ModelInstanceGroup.SecondaryDevice> secondaryDevices_;
    /**
     * <pre>
     *&#64;&#64;  .. cpp:var:: SecondaryDevice secondary_devices (repeated)
     *&#64;&#64;
     *&#64;&#64;     Secondary devices that are required by instances specified by this
     *&#64;&#64;     instance group. Optional.
     *&#64;&#64;
     * </pre>
     *
     * <code>repeated .inference.ModelInstanceGroup.SecondaryDevice secondary_devices = 8;</code>
     */
    @java.lang.Override
    public java.util.List<org.apache.submarine.server.api.proto.TritonModelConfig.ModelInstanceGroup.SecondaryDevice> getSecondaryDevicesList() {
      return secondaryDevices_;
    }
    /**
     * <pre>
     *&#64;&#64;  .. cpp:var:: SecondaryDevice secondary_devices (repeated)
     *&#64;&#64;
     *&#64;&#64;     Secondary devices that are required by instances specified by this
     *&#64;&#64;     instance group. Optional.
     *&#64;&#64;
     * </pre>
     *
     * <code>repeated .inference.ModelInstanceGroup.SecondaryDevice secondary_devices = 8;</code>
     */
    @java.lang.Override
    public java.util.List<? extends org.apache.submarine.server.api.proto.TritonModelConfig.ModelInstanceGroup.SecondaryDeviceOrBuilder> 
        getSecondaryDevicesOrBuilderList() {
      return secondaryDevices_;
    }
    /**
     * <pre>
     *&#64;&#64;  .. cpp:var:: SecondaryDevice secondary_devices (repeated)
     *&#64;&#64;
     *&#64;&#64;     Secondary devices that are required by instances specified by this
     *&#64;&#64;     instance group. Optional.
     *&#64;&#64;
     * </pre>
     *
     * <code>repeated .inference.ModelInstanceGroup.SecondaryDevice secondary_devices = 8;</code>
     */
    @java.lang.Override
    public int getSecondaryDevicesCount() {
      return secondaryDevices_.size();
    }
    /**
     * <pre>
     *&#64;&#64;  .. cpp:var:: SecondaryDevice secondary_devices (repeated)
     *&#64;&#64;
     *&#64;&#64;     Secondary devices that are required by instances specified by this
     *&#64;&#64;     instance group. Optional.
     *&#64;&#64;
     * </pre>
     *
     * <code>repeated .inference.ModelInstanceGroup.SecondaryDevice secondary_devices = 8;</code>
     */
    @java.lang.Override
    public org.apache.submarine.server.api.proto.TritonModelConfig.ModelInstanceGroup.SecondaryDevice getSecondaryDevices(int index) {
      return secondaryDevices_.get(index);
    }
    /**
     * <pre>
     *&#64;&#64;  .. cpp:var:: SecondaryDevice secondary_devices (repeated)
     *&#64;&#64;
     *&#64;&#64;     Secondary devices that are required by instances specified by this
     *&#64;&#64;     instance group. Optional.
     *&#64;&#64;
     * </pre>
     *
     * <code>repeated .inference.ModelInstanceGroup.SecondaryDevice secondary_devices = 8;</code>
     */
    @java.lang.Override
    public org.apache.submarine.server.api.proto.TritonModelConfig.ModelInstanceGroup.SecondaryDeviceOrBuilder getSecondaryDevicesOrBuilder(
        int index) {
      return secondaryDevices_.get(index);
    }

    public static final int PROFILE_FIELD_NUMBER = 5;
    private com.google.protobuf.LazyStringList profile_;
    /**
     * <pre>
     *&#64;&#64;  .. cpp:var:: string profile (repeated)
     *&#64;&#64;
     *&#64;&#64;     For TensorRT models containing multiple optimization profile, this
     *&#64;&#64;     parameter specifies a set of optimization profiles available to this
     *&#64;&#64;     instance group. The inference server will choose the optimal profile
     *&#64;&#64;     based on the shapes of the input tensors. This field should lie
     *&#64;&#64;     between 0 and &lt;TotalNumberOfOptimizationProfilesInPlanModel&gt; - 1
     *&#64;&#64;     and be specified only for TensorRT backend, otherwise an error will
     *&#64;&#64;     be generated. If not specified, the server will select the first
     *&#64;&#64;     optimization profile by default.
     *&#64;&#64;
     * </pre>
     *
     * <code>repeated string profile = 5;</code>
     * @return A list containing the profile.
     */
    public com.google.protobuf.ProtocolStringList
        getProfileList() {
      return profile_;
    }
    /**
     * <pre>
     *&#64;&#64;  .. cpp:var:: string profile (repeated)
     *&#64;&#64;
     *&#64;&#64;     For TensorRT models containing multiple optimization profile, this
     *&#64;&#64;     parameter specifies a set of optimization profiles available to this
     *&#64;&#64;     instance group. The inference server will choose the optimal profile
     *&#64;&#64;     based on the shapes of the input tensors. This field should lie
     *&#64;&#64;     between 0 and &lt;TotalNumberOfOptimizationProfilesInPlanModel&gt; - 1
     *&#64;&#64;     and be specified only for TensorRT backend, otherwise an error will
     *&#64;&#64;     be generated. If not specified, the server will select the first
     *&#64;&#64;     optimization profile by default.
     *&#64;&#64;
     * </pre>
     *
     * <code>repeated string profile = 5;</code>
     * @return The count of profile.
     */
    public int getProfileCount() {
      return profile_.size();
    }
    /**
     * <pre>
     *&#64;&#64;  .. cpp:var:: string profile (repeated)
     *&#64;&#64;
     *&#64;&#64;     For TensorRT models containing multiple optimization profile, this
     *&#64;&#64;     parameter specifies a set of optimization profiles available to this
     *&#64;&#64;     instance group. The inference server will choose the optimal profile
     *&#64;&#64;     based on the shapes of the input tensors. This field should lie
     *&#64;&#64;     between 0 and &lt;TotalNumberOfOptimizationProfilesInPlanModel&gt; - 1
     *&#64;&#64;     and be specified only for TensorRT backend, otherwise an error will
     *&#64;&#64;     be generated. If not specified, the server will select the first
     *&#64;&#64;     optimization profile by default.
     *&#64;&#64;
     * </pre>
     *
     * <code>repeated string profile = 5;</code>
     * @param index The index of the element to return.
     * @return The profile at the given index.
     */
    public java.lang.String getProfile(int index) {
      return profile_.get(index);
    }
    /**
     * <pre>
     *&#64;&#64;  .. cpp:var:: string profile (repeated)
     *&#64;&#64;
     *&#64;&#64;     For TensorRT models containing multiple optimization profile, this
     *&#64;&#64;     parameter specifies a set of optimization profiles available to this
     *&#64;&#64;     instance group. The inference server will choose the optimal profile
     *&#64;&#64;     based on the shapes of the input tensors. This field should lie
     *&#64;&#64;     between 0 and &lt;TotalNumberOfOptimizationProfilesInPlanModel&gt; - 1
     *&#64;&#64;     and be specified only for TensorRT backend, otherwise an error will
     *&#64;&#64;     be generated. If not specified, the server will select the first
     *&#64;&#64;     optimization profile by default.
     *&#64;&#64;
     * </pre>
     *
     * <code>repeated string profile = 5;</code>
     * @param index The index of the value to return.
     * @return The bytes of the profile at the given index.
     */
    public com.google.protobuf.ByteString
        getProfileBytes(int index) {
      return profile_.getByteString(index);
    }

    public static final int PASSIVE_FIELD_NUMBER = 7;
    private boolean passive_;
    /**
     * <pre>
     *&#64;&#64;  .. cpp:var:: bool passive
     *&#64;&#64;
     *&#64;&#64;     Whether the instances within this instance group will be accepting
     *&#64;&#64;     inference requests from the scheduler. If true, the instances will
     *&#64;&#64;     not be added to the scheduler. Default value is false.
     *&#64;&#64;
     * </pre>
     *
     * <code>bool passive = 7;</code>
     * @return The passive.
     */
    @java.lang.Override
    public boolean getPassive() {
      return passive_;
    }

    public static final int HOST_POLICY_FIELD_NUMBER = 9;
    private volatile java.lang.Object hostPolicy_;
    /**
     * <pre>
     *&#64;&#64;  .. cpp:var:: string host_policy
     *&#64;&#64;
     *&#64;&#64;     The host policy name that the instance to be associated with.
     *&#64;&#64;     The default value is set to reflect the device kind of the instance,
     *&#64;&#64;     for instance, KIND_CPU is "cpu", KIND_MODEL is "model" and
     *&#64;&#64;     KIND_GPU is "gpu_&lt;gpu_id&gt;".
     *&#64;&#64;
     * </pre>
     *
     * <code>string host_policy = 9;</code>
     * @return The hostPolicy.
     */
    @java.lang.Override
    public java.lang.String getHostPolicy() {
      java.lang.Object ref = hostPolicy_;
      if (ref instanceof java.lang.String) {
        return (java.lang.String) ref;
      } else {
        com.google.protobuf.ByteString bs = 
            (com.google.protobuf.ByteString) ref;
        java.lang.String s = bs.toStringUtf8();
        hostPolicy_ = s;
        return s;
      }
    }
    /**
     * <pre>
     *&#64;&#64;  .. cpp:var:: string host_policy
     *&#64;&#64;
     *&#64;&#64;     The host policy name that the instance to be associated with.
     *&#64;&#64;     The default value is set to reflect the device kind of the instance,
     *&#64;&#64;     for instance, KIND_CPU is "cpu", KIND_MODEL is "model" and
     *&#64;&#64;     KIND_GPU is "gpu_&lt;gpu_id&gt;".
     *&#64;&#64;
     * </pre>
     *
     * <code>string host_policy = 9;</code>
     * @return The bytes for hostPolicy.
     */
    @java.lang.Override
    public com.google.protobuf.ByteString
        getHostPolicyBytes() {
      java.lang.Object ref = hostPolicy_;
      if (ref instanceof java.lang.String) {
        com.google.protobuf.ByteString b = 
            com.google.protobuf.ByteString.copyFromUtf8(
                (java.lang.String) ref);
        hostPolicy_ = b;
        return b;
      } else {
        return (com.google.protobuf.ByteString) ref;
      }
    }

    private byte memoizedIsInitialized = -1;
    @java.lang.Override
    public final boolean isInitialized() {
      byte isInitialized = memoizedIsInitialized;
      if (isInitialized == 1) return true;
      if (isInitialized == 0) return false;

      memoizedIsInitialized = 1;
      return true;
    }

    @java.lang.Override
    public void writeTo(com.google.protobuf.CodedOutputStream output)
                        throws java.io.IOException {
      getSerializedSize();
      if (!getNameBytes().isEmpty()) {
        com.google.protobuf.GeneratedMessageV3.writeString(output, 1, name_);
      }
      if (count_ != 0) {
        output.writeInt32(2, count_);
      }
      if (getGpusList().size() > 0) {
        output.writeUInt32NoTag(26);
        output.writeUInt32NoTag(gpusMemoizedSerializedSize);
      }
      for (int i = 0; i < gpus_.size(); i++) {
        output.writeInt32NoTag(gpus_.getInt(i));
      }
      if (kind_ != org.apache.submarine.server.api.proto.TritonModelConfig.ModelInstanceGroup.Kind.KIND_AUTO.getNumber()) {
        output.writeEnum(4, kind_);
      }
      for (int i = 0; i < profile_.size(); i++) {
        com.google.protobuf.GeneratedMessageV3.writeString(output, 5, profile_.getRaw(i));
      }
      if (rateLimiter_ != null) {
        output.writeMessage(6, getRateLimiter());
      }
      if (passive_ != false) {
        output.writeBool(7, passive_);
      }
      for (int i = 0; i < secondaryDevices_.size(); i++) {
        output.writeMessage(8, secondaryDevices_.get(i));
      }
      if (!getHostPolicyBytes().isEmpty()) {
        com.google.protobuf.GeneratedMessageV3.writeString(output, 9, hostPolicy_);
      }
      unknownFields.writeTo(output);
    }

    @java.lang.Override
    public int getSerializedSize() {
      int size = memoizedSize;
      if (size != -1) return size;

      size = 0;
      if (!getNameBytes().isEmpty()) {
        size += com.google.protobuf.GeneratedMessageV3.computeStringSize(1, name_);
      }
      if (count_ != 0) {
        size += com.google.protobuf.CodedOutputStream
          .computeInt32Size(2, count_);
      }
      {
        int dataSize = 0;
        for (int i = 0; i < gpus_.size(); i++) {
          dataSize += com.google.protobuf.CodedOutputStream
            .computeInt32SizeNoTag(gpus_.getInt(i));
        }
        size += dataSize;
        if (!getGpusList().isEmpty()) {
          size += 1;
          size += com.google.protobuf.CodedOutputStream
              .computeInt32SizeNoTag(dataSize);
        }
        gpusMemoizedSerializedSize = dataSize;
      }
      if (kind_ != org.apache.submarine.server.api.proto.TritonModelConfig.ModelInstanceGroup.Kind.KIND_AUTO.getNumber()) {
        size += com.google.protobuf.CodedOutputStream
          .computeEnumSize(4, kind_);
      }
      {
        int dataSize = 0;
        for (int i = 0; i < profile_.size(); i++) {
          dataSize += computeStringSizeNoTag(profile_.getRaw(i));
        }
        size += dataSize;
        size += 1 * getProfileList().size();
      }
      if (rateLimiter_ != null) {
        size += com.google.protobuf.CodedOutputStream
          .computeMessageSize(6, getRateLimiter());
      }
      if (passive_ != false) {
        size += com.google.protobuf.CodedOutputStream
          .computeBoolSize(7, passive_);
      }
      for (int i = 0; i < secondaryDevices_.size(); i++) {
        size += com.google.protobuf.CodedOutputStream
          .computeMessageSize(8, secondaryDevices_.get(i));
      }
      if (!getHostPolicyBytes().isEmpty()) {
        size += com.google.protobuf.GeneratedMessageV3.computeStringSize(9, hostPolicy_);
      }
      size += unknownFields.getSerializedSize();
      memoizedSize = size;
      return size;
    }

    @java.lang.Override
    public boolean equals(final java.lang.Object obj) {
      if (obj == this) {
       return true;
      }
      if (!(obj instanceof org.apache.submarine.server.api.proto.TritonModelConfig.ModelInstanceGroup)) {
        return super.equals(obj);
      }
      org.apache.submarine.server.api.proto.TritonModelConfig.ModelInstanceGroup other = (org.apache.submarine.server.api.proto.TritonModelConfig.ModelInstanceGroup) obj;

      if (!getName()
          .equals(other.getName())) return false;
      if (kind_ != other.kind_) return false;
      if (getCount()
          != other.getCount()) return false;
      if (hasRateLimiter() != other.hasRateLimiter()) return false;
      if (hasRateLimiter()) {
        if (!getRateLimiter()
            .equals(other.getRateLimiter())) return false;
      }
      if (!getGpusList()
          .equals(other.getGpusList())) return false;
      if (!getSecondaryDevicesList()
          .equals(other.getSecondaryDevicesList())) return false;
      if (!getProfileList()
          .equals(other.getProfileList())) return false;
      if (getPassive()
          != other.getPassive()) return false;
      if (!getHostPolicy()
          .equals(other.getHostPolicy())) return false;
      if (!unknownFields.equals(other.unknownFields)) return false;
      return true;
    }

    @java.lang.Override
    public int hashCode() {
      if (memoizedHashCode != 0) {
        return memoizedHashCode;
      }
      int hash = 41;
      hash = (19 * hash) + getDescriptor().hashCode();
      hash = (37 * hash) + NAME_FIELD_NUMBER;
      hash = (53 * hash) + getName().hashCode();
      hash = (37 * hash) + KIND_FIELD_NUMBER;
      hash = (53 * hash) + kind_;
      hash = (37 * hash) + COUNT_FIELD_NUMBER;
      hash = (53 * hash) + getCount();
      if (hasRateLimiter()) {
        hash = (37 * hash) + RATE_LIMITER_FIELD_NUMBER;
        hash = (53 * hash) + getRateLimiter().hashCode();
      }
      if (getGpusCount() > 0) {
        hash = (37 * hash) + GPUS_FIELD_NUMBER;
        hash = (53 * hash) + getGpusList().hashCode();
      }
      if (getSecondaryDevicesCount() > 0) {
        hash = (37 * hash) + SECONDARY_DEVICES_FIELD_NUMBER;
        hash = (53 * hash) + getSecondaryDevicesList().hashCode();
      }
      if (getProfileCount() > 0) {
        hash = (37 * hash) + PROFILE_FIELD_NUMBER;
        hash = (53 * hash) + getProfileList().hashCode();
      }
      hash = (37 * hash) + PASSIVE_FIELD_NUMBER;
      hash = (53 * hash) + com.google.protobuf.Internal.hashBoolean(
          getPassive());
      hash = (37 * hash) + HOST_POLICY_FIELD_NUMBER;
      hash = (53 * hash) + getHostPolicy().hashCode();
      hash = (29 * hash) + unknownFields.hashCode();
      memoizedHashCode = hash;
      return hash;
    }

    public static org.apache.submarine.server.api.proto.TritonModelConfig.ModelInstanceGroup parseFrom(
        java.nio.ByteBuffer data)
        throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data);
    }
    public static org.apache.submarine.server.api.proto.TritonModelConfig.ModelInstanceGroup parseFrom(
        java.nio.ByteBuffer data,
        com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data, extensionRegistry);
    }
    public static org.apache.submarine.server.api.proto.TritonModelConfig.ModelInstanceGroup parseFrom(
        com.google.protobuf.ByteString data)
        throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data);
    }
    public static org.apache.submarine.server.api.proto.TritonModelConfig.ModelInstanceGroup parseFrom(
        com.google.protobuf.ByteString data,
        com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data, extensionRegistry);
    }
    public static org.apache.submarine.server.api.proto.TritonModelConfig.ModelInstanceGroup parseFrom(byte[] data)
        throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data);
    }
    public static org.apache.submarine.server.api.proto.TritonModelConfig.ModelInstanceGroup parseFrom(
        byte[] data,
        com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data, extensionRegistry);
    }
    public static org.apache.submarine.server.api.proto.TritonModelConfig.ModelInstanceGroup parseFrom(java.io.InputStream input)
        throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3
          .parseWithIOException(PARSER, input);
    }
    public static org.apache.submarine.server.api.proto.TritonModelConfig.ModelInstanceGroup parseFrom(
        java.io.InputStream input,
        com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3
          .parseWithIOException(PARSER, input, extensionRegistry);
    }
    public static org.apache.submarine.server.api.proto.TritonModelConfig.ModelInstanceGroup parseDelimitedFrom(java.io.InputStream input)
        throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3
          .parseDelimitedWithIOException(PARSER, input);
    }
    public static org.apache.submarine.server.api.proto.TritonModelConfig.ModelInstanceGroup parseDelimitedFrom(
        java.io.InputStream input,
        com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3
          .parseDelimitedWithIOException(PARSER, input, extensionRegistry);
    }
    public static org.apache.submarine.server.api.proto.TritonModelConfig.ModelInstanceGroup parseFrom(
        com.google.protobuf.CodedInputStream input)
        throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3
          .parseWithIOException(PARSER, input);
    }
    public static org.apache.submarine.server.api.proto.TritonModelConfig.ModelInstanceGroup parseFrom(
        com.google.protobuf.CodedInputStream input,
        com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3
          .parseWithIOException(PARSER, input, extensionRegistry);
    }

    @java.lang.Override
    public Builder newBuilderForType() { return newBuilder(); }
    public static Builder newBuilder() {
      return DEFAULT_INSTANCE.toBuilder();
    }
    public static Builder newBuilder(org.apache.submarine.server.api.proto.TritonModelConfig.ModelInstanceGroup prototype) {
      return DEFAULT_INSTANCE.toBuilder().mergeFrom(prototype);
    }
    @java.lang.Override
    public Builder toBuilder() {
      return this == DEFAULT_INSTANCE
          ? new Builder() : new Builder().mergeFrom(this);
    }

    @java.lang.Override
    protected Builder newBuilderForType(
        com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
      Builder builder = new Builder(parent);
      return builder;
    }
    /**
     * <pre>
     *&#64;&#64;
     *&#64;&#64;.. cpp:var:: message ModelInstanceGroup
     *&#64;&#64;
     *&#64;&#64;   A group of one or more instances of a model and resources made
     *&#64;&#64;   available for those instances.
     *&#64;&#64;
     * </pre>
     *
     * Protobuf type {@code inference.ModelInstanceGroup}
     */
    public static final class Builder extends
        com.google.protobuf.GeneratedMessageV3.Builder<Builder> implements
        // @@protoc_insertion_point(builder_implements:inference.ModelInstanceGroup)
        org.apache.submarine.server.api.proto.TritonModelConfig.ModelInstanceGroupOrBuilder {
      public static final com.google.protobuf.Descriptors.Descriptor
          getDescriptor() {
        return org.apache.submarine.server.api.proto.TritonModelConfig.internal_static_inference_ModelInstanceGroup_descriptor;
      }

      @java.lang.Override
      protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
          internalGetFieldAccessorTable() {
        return org.apache.submarine.server.api.proto.TritonModelConfig.internal_static_inference_ModelInstanceGroup_fieldAccessorTable
            .ensureFieldAccessorsInitialized(
                org.apache.submarine.server.api.proto.TritonModelConfig.ModelInstanceGroup.class, org.apache.submarine.server.api.proto.TritonModelConfig.ModelInstanceGroup.Builder.class);
      }

      // Construct using org.apache.submarine.server.api.proto.TritonModelConfig.ModelInstanceGroup.newBuilder()
      private Builder() {
        maybeForceBuilderInitialization();
      }

      private Builder(
          com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
        super(parent);
        maybeForceBuilderInitialization();
      }
      private void maybeForceBuilderInitialization() {
        if (com.google.protobuf.GeneratedMessageV3
                .alwaysUseFieldBuilders) {
          getSecondaryDevicesFieldBuilder();
        }
      }
      @java.lang.Override
      public Builder clear() {
        super.clear();
        name_ = "";

        kind_ = 0;

        count_ = 0;

        if (rateLimiterBuilder_ == null) {
          rateLimiter_ = null;
        } else {
          rateLimiter_ = null;
          rateLimiterBuilder_ = null;
        }
        gpus_ = emptyIntList();
        bitField0_ = (bitField0_ & ~0x00000001);
        if (secondaryDevicesBuilder_ == null) {
          secondaryDevices_ = java.util.Collections.emptyList();
          bitField0_ = (bitField0_ & ~0x00000002);
        } else {
          secondaryDevicesBuilder_.clear();
        }
        profile_ = com.google.protobuf.LazyStringArrayList.EMPTY;
        bitField0_ = (bitField0_ & ~0x00000004);
        passive_ = false;

        hostPolicy_ = "";

        return this;
      }

      @java.lang.Override
      public com.google.protobuf.Descriptors.Descriptor
          getDescriptorForType() {
        return org.apache.submarine.server.api.proto.TritonModelConfig.internal_static_inference_ModelInstanceGroup_descriptor;
      }

      @java.lang.Override
      public org.apache.submarine.server.api.proto.TritonModelConfig.ModelInstanceGroup getDefaultInstanceForType() {
        return org.apache.submarine.server.api.proto.TritonModelConfig.ModelInstanceGroup.getDefaultInstance();
      }

      @java.lang.Override
      public org.apache.submarine.server.api.proto.TritonModelConfig.ModelInstanceGroup build() {
        org.apache.submarine.server.api.proto.TritonModelConfig.ModelInstanceGroup result = buildPartial();
        if (!result.isInitialized()) {
          throw newUninitializedMessageException(result);
        }
        return result;
      }

      @java.lang.Override
      public org.apache.submarine.server.api.proto.TritonModelConfig.ModelInstanceGroup buildPartial() {
        org.apache.submarine.server.api.proto.TritonModelConfig.ModelInstanceGroup result = new org.apache.submarine.server.api.proto.TritonModelConfig.ModelInstanceGroup(this);
        int from_bitField0_ = bitField0_;
        result.name_ = name_;
        result.kind_ = kind_;
        result.count_ = count_;
        if (rateLimiterBuilder_ == null) {
          result.rateLimiter_ = rateLimiter_;
        } else {
          result.rateLimiter_ = rateLimiterBuilder_.build();
        }
        if (((bitField0_ & 0x00000001) != 0)) {
          gpus_.makeImmutable();
          bitField0_ = (bitField0_ & ~0x00000001);
        }
        result.gpus_ = gpus_;
        if (secondaryDevicesBuilder_ == null) {
          if (((bitField0_ & 0x00000002) != 0)) {
            secondaryDevices_ = java.util.Collections.unmodifiableList(secondaryDevices_);
            bitField0_ = (bitField0_ & ~0x00000002);
          }
          result.secondaryDevices_ = secondaryDevices_;
        } else {
          result.secondaryDevices_ = secondaryDevicesBuilder_.build();
        }
        if (((bitField0_ & 0x00000004) != 0)) {
          profile_ = profile_.getUnmodifiableView();
          bitField0_ = (bitField0_ & ~0x00000004);
        }
        result.profile_ = profile_;
        result.passive_ = passive_;
        result.hostPolicy_ = hostPolicy_;
        onBuilt();
        return result;
      }

      @java.lang.Override
      public Builder clone() {
        return super.clone();
      }
      @java.lang.Override
      public Builder setField(
          com.google.protobuf.Descriptors.FieldDescriptor field,
          java.lang.Object value) {
        return super.setField(field, value);
      }
      @java.lang.Override
      public Builder clearField(
          com.google.protobuf.Descriptors.FieldDescriptor field) {
        return super.clearField(field);
      }
      @java.lang.Override
      public Builder clearOneof(
          com.google.protobuf.Descriptors.OneofDescriptor oneof) {
        return super.clearOneof(oneof);
      }
      @java.lang.Override
      public Builder setRepeatedField(
          com.google.protobuf.Descriptors.FieldDescriptor field,
          int index, java.lang.Object value) {
        return super.setRepeatedField(field, index, value);
      }
      @java.lang.Override
      public Builder addRepeatedField(
          com.google.protobuf.Descriptors.FieldDescriptor field,
          java.lang.Object value) {
        return super.addRepeatedField(field, value);
      }
      @java.lang.Override
      public Builder mergeFrom(com.google.protobuf.Message other) {
        if (other instanceof org.apache.submarine.server.api.proto.TritonModelConfig.ModelInstanceGroup) {
          return mergeFrom((org.apache.submarine.server.api.proto.TritonModelConfig.ModelInstanceGroup)other);
        } else {
          super.mergeFrom(other);
          return this;
        }
      }

      public Builder mergeFrom(org.apache.submarine.server.api.proto.TritonModelConfig.ModelInstanceGroup other) {
        if (other == org.apache.submarine.server.api.proto.TritonModelConfig.ModelInstanceGroup.getDefaultInstance()) return this;
        if (!other.getName().isEmpty()) {
          name_ = other.name_;
          onChanged();
        }
        if (other.kind_ != 0) {
          setKindValue(other.getKindValue());
        }
        if (other.getCount() != 0) {
          setCount(other.getCount());
        }
        if (other.hasRateLimiter()) {
          mergeRateLimiter(other.getRateLimiter());
        }
        if (!other.gpus_.isEmpty()) {
          if (gpus_.isEmpty()) {
            gpus_ = other.gpus_;
            bitField0_ = (bitField0_ & ~0x00000001);
          } else {
            ensureGpusIsMutable();
            gpus_.addAll(other.gpus_);
          }
          onChanged();
        }
        if (secondaryDevicesBuilder_ == null) {
          if (!other.secondaryDevices_.isEmpty()) {
            if (secondaryDevices_.isEmpty()) {
              secondaryDevices_ = other.secondaryDevices_;
              bitField0_ = (bitField0_ & ~0x00000002);
            } else {
              ensureSecondaryDevicesIsMutable();
              secondaryDevices_.addAll(other.secondaryDevices_);
            }
            onChanged();
          }
        } else {
          if (!other.secondaryDevices_.isEmpty()) {
            if (secondaryDevicesBuilder_.isEmpty()) {
              secondaryDevicesBuilder_.dispose();
              secondaryDevicesBuilder_ = null;
              secondaryDevices_ = other.secondaryDevices_;
              bitField0_ = (bitField0_ & ~0x00000002);
              secondaryDevicesBuilder_ = 
                com.google.protobuf.GeneratedMessageV3.alwaysUseFieldBuilders ?
                   getSecondaryDevicesFieldBuilder() : null;
            } else {
              secondaryDevicesBuilder_.addAllMessages(other.secondaryDevices_);
            }
          }
        }
        if (!other.profile_.isEmpty()) {
          if (profile_.isEmpty()) {
            profile_ = other.profile_;
            bitField0_ = (bitField0_ & ~0x00000004);
          } else {
            ensureProfileIsMutable();
            profile_.addAll(other.profile_);
          }
          onChanged();
        }
        if (other.getPassive() != false) {
          setPassive(other.getPassive());
        }
        if (!other.getHostPolicy().isEmpty()) {
          hostPolicy_ = other.hostPolicy_;
          onChanged();
        }
        this.mergeUnknownFields(other.unknownFields);
        onChanged();
        return this;
      }

      @java.lang.Override
      public final boolean isInitialized() {
        return true;
      }

      @java.lang.Override
      public Builder mergeFrom(
          com.google.protobuf.CodedInputStream input,
          com.google.protobuf.ExtensionRegistryLite extensionRegistry)
          throws java.io.IOException {
        org.apache.submarine.server.api.proto.TritonModelConfig.ModelInstanceGroup parsedMessage = null;
        try {
          parsedMessage = PARSER.parsePartialFrom(input, extensionRegistry);
        } catch (com.google.protobuf.InvalidProtocolBufferException e) {
          parsedMessage = (org.apache.submarine.server.api.proto.TritonModelConfig.ModelInstanceGroup) e.getUnfinishedMessage();
          throw e.unwrapIOException();
        } finally {
          if (parsedMessage != null) {
            mergeFrom(parsedMessage);
          }
        }
        return this;
      }
      private int bitField0_;

      private java.lang.Object name_ = "";
      /**
       * <pre>
       *&#64;&#64;  .. cpp:var:: string name
       *&#64;&#64;
       *&#64;&#64;     Optional name of this group of instances. If not specified the
       *&#64;&#64;     name will be formed as &lt;model name&gt;_&lt;group number&gt;. The name of
       *&#64;&#64;     individual instances will be further formed by a unique instance
       *&#64;&#64;     number and GPU index:
       *&#64;&#64;
       * </pre>
       *
       * <code>string name = 1;</code>
       * @return The name.
       */
      public java.lang.String getName() {
        java.lang.Object ref = name_;
        if (!(ref instanceof java.lang.String)) {
          com.google.protobuf.ByteString bs =
              (com.google.protobuf.ByteString) ref;
          java.lang.String s = bs.toStringUtf8();
          name_ = s;
          return s;
        } else {
          return (java.lang.String) ref;
        }
      }
      /**
       * <pre>
       *&#64;&#64;  .. cpp:var:: string name
       *&#64;&#64;
       *&#64;&#64;     Optional name of this group of instances. If not specified the
       *&#64;&#64;     name will be formed as &lt;model name&gt;_&lt;group number&gt;. The name of
       *&#64;&#64;     individual instances will be further formed by a unique instance
       *&#64;&#64;     number and GPU index:
       *&#64;&#64;
       * </pre>
       *
       * <code>string name = 1;</code>
       * @return The bytes for name.
       */
      public com.google.protobuf.ByteString
          getNameBytes() {
        java.lang.Object ref = name_;
        if (ref instanceof String) {
          com.google.protobuf.ByteString b = 
              com.google.protobuf.ByteString.copyFromUtf8(
                  (java.lang.String) ref);
          name_ = b;
          return b;
        } else {
          return (com.google.protobuf.ByteString) ref;
        }
      }
      /**
       * <pre>
       *&#64;&#64;  .. cpp:var:: string name
       *&#64;&#64;
       *&#64;&#64;     Optional name of this group of instances. If not specified the
       *&#64;&#64;     name will be formed as &lt;model name&gt;_&lt;group number&gt;. The name of
       *&#64;&#64;     individual instances will be further formed by a unique instance
       *&#64;&#64;     number and GPU index:
       *&#64;&#64;
       * </pre>
       *
       * <code>string name = 1;</code>
       * @param value The name to set.
       * @return This builder for chaining.
       */
      public Builder setName(
          java.lang.String value) {
        if (value == null) {
    throw new NullPointerException();
  }
  
        name_ = value;
        onChanged();
        return this;
      }
      /**
       * <pre>
       *&#64;&#64;  .. cpp:var:: string name
       *&#64;&#64;
       *&#64;&#64;     Optional name of this group of instances. If not specified the
       *&#64;&#64;     name will be formed as &lt;model name&gt;_&lt;group number&gt;. The name of
       *&#64;&#64;     individual instances will be further formed by a unique instance
       *&#64;&#64;     number and GPU index:
       *&#64;&#64;
       * </pre>
       *
       * <code>string name = 1;</code>
       * @return This builder for chaining.
       */
      public Builder clearName() {
        
        name_ = getDefaultInstance().getName();
        onChanged();
        return this;
      }
      /**
       * <pre>
       *&#64;&#64;  .. cpp:var:: string name
       *&#64;&#64;
       *&#64;&#64;     Optional name of this group of instances. If not specified the
       *&#64;&#64;     name will be formed as &lt;model name&gt;_&lt;group number&gt;. The name of
       *&#64;&#64;     individual instances will be further formed by a unique instance
       *&#64;&#64;     number and GPU index:
       *&#64;&#64;
       * </pre>
       *
       * <code>string name = 1;</code>
       * @param value The bytes for name to set.
       * @return This builder for chaining.
       */
      public Builder setNameBytes(
          com.google.protobuf.ByteString value) {
        if (value == null) {
    throw new NullPointerException();
  }
  checkByteStringIsUtf8(value);
        
        name_ = value;
        onChanged();
        return this;
      }

      private int kind_ = 0;
      /**
       * <pre>
       *&#64;&#64;  .. cpp:var:: Kind kind
       *&#64;&#64;
       *&#64;&#64;     The kind of this instance group. Default is KIND_AUTO. If
       *&#64;&#64;     KIND_AUTO or KIND_GPU then both 'count' and 'gpu' are valid and
       *&#64;&#64;     may be specified. If KIND_CPU or KIND_MODEL only 'count' is valid
       *&#64;&#64;     and 'gpu' cannot be specified.
       *&#64;&#64;
       * </pre>
       *
       * <code>.inference.ModelInstanceGroup.Kind kind = 4;</code>
       * @return The enum numeric value on the wire for kind.
       */
      @java.lang.Override public int getKindValue() {
        return kind_;
      }
      /**
       * <pre>
       *&#64;&#64;  .. cpp:var:: Kind kind
       *&#64;&#64;
       *&#64;&#64;     The kind of this instance group. Default is KIND_AUTO. If
       *&#64;&#64;     KIND_AUTO or KIND_GPU then both 'count' and 'gpu' are valid and
       *&#64;&#64;     may be specified. If KIND_CPU or KIND_MODEL only 'count' is valid
       *&#64;&#64;     and 'gpu' cannot be specified.
       *&#64;&#64;
       * </pre>
       *
       * <code>.inference.ModelInstanceGroup.Kind kind = 4;</code>
       * @param value The enum numeric value on the wire for kind to set.
       * @return This builder for chaining.
       */
      public Builder setKindValue(int value) {
        
        kind_ = value;
        onChanged();
        return this;
      }
      /**
       * <pre>
       *&#64;&#64;  .. cpp:var:: Kind kind
       *&#64;&#64;
       *&#64;&#64;     The kind of this instance group. Default is KIND_AUTO. If
       *&#64;&#64;     KIND_AUTO or KIND_GPU then both 'count' and 'gpu' are valid and
       *&#64;&#64;     may be specified. If KIND_CPU or KIND_MODEL only 'count' is valid
       *&#64;&#64;     and 'gpu' cannot be specified.
       *&#64;&#64;
       * </pre>
       *
       * <code>.inference.ModelInstanceGroup.Kind kind = 4;</code>
       * @return The kind.
       */
      @java.lang.Override
      public org.apache.submarine.server.api.proto.TritonModelConfig.ModelInstanceGroup.Kind getKind() {
        @SuppressWarnings("deprecation")
        org.apache.submarine.server.api.proto.TritonModelConfig.ModelInstanceGroup.Kind result = org.apache.submarine.server.api.proto.TritonModelConfig.ModelInstanceGroup.Kind.valueOf(kind_);
        return result == null ? org.apache.submarine.server.api.proto.TritonModelConfig.ModelInstanceGroup.Kind.UNRECOGNIZED : result;
      }
      /**
       * <pre>
       *&#64;&#64;  .. cpp:var:: Kind kind
       *&#64;&#64;
       *&#64;&#64;     The kind of this instance group. Default is KIND_AUTO. If
       *&#64;&#64;     KIND_AUTO or KIND_GPU then both 'count' and 'gpu' are valid and
       *&#64;&#64;     may be specified. If KIND_CPU or KIND_MODEL only 'count' is valid
       *&#64;&#64;     and 'gpu' cannot be specified.
       *&#64;&#64;
       * </pre>
       *
       * <code>.inference.ModelInstanceGroup.Kind kind = 4;</code>
       * @param value The kind to set.
       * @return This builder for chaining.
       */
      public Builder setKind(org.apache.submarine.server.api.proto.TritonModelConfig.ModelInstanceGroup.Kind value) {
        if (value == null) {
          throw new NullPointerException();
        }
        
        kind_ = value.getNumber();
        onChanged();
        return this;
      }
      /**
       * <pre>
       *&#64;&#64;  .. cpp:var:: Kind kind
       *&#64;&#64;
       *&#64;&#64;     The kind of this instance group. Default is KIND_AUTO. If
       *&#64;&#64;     KIND_AUTO or KIND_GPU then both 'count' and 'gpu' are valid and
       *&#64;&#64;     may be specified. If KIND_CPU or KIND_MODEL only 'count' is valid
       *&#64;&#64;     and 'gpu' cannot be specified.
       *&#64;&#64;
       * </pre>
       *
       * <code>.inference.ModelInstanceGroup.Kind kind = 4;</code>
       * @return This builder for chaining.
       */
      public Builder clearKind() {
        
        kind_ = 0;
        onChanged();
        return this;
      }

      private int count_ ;
      /**
       * <pre>
       *&#64;&#64;  .. cpp:var:: int32 count
       *&#64;&#64;
       *&#64;&#64;     For a group assigned to GPU, the number of instances created for
       *&#64;&#64;     each GPU listed in 'gpus'. For a group assigned to CPU the number
       *&#64;&#64;     of instances created. Default is 1.
       * </pre>
       *
       * <code>int32 count = 2;</code>
       * @return The count.
       */
      @java.lang.Override
      public int getCount() {
        return count_;
      }
      /**
       * <pre>
       *&#64;&#64;  .. cpp:var:: int32 count
       *&#64;&#64;
       *&#64;&#64;     For a group assigned to GPU, the number of instances created for
       *&#64;&#64;     each GPU listed in 'gpus'. For a group assigned to CPU the number
       *&#64;&#64;     of instances created. Default is 1.
       * </pre>
       *
       * <code>int32 count = 2;</code>
       * @param value The count to set.
       * @return This builder for chaining.
       */
      public Builder setCount(int value) {
        
        count_ = value;
        onChanged();
        return this;
      }
      /**
       * <pre>
       *&#64;&#64;  .. cpp:var:: int32 count
       *&#64;&#64;
       *&#64;&#64;     For a group assigned to GPU, the number of instances created for
       *&#64;&#64;     each GPU listed in 'gpus'. For a group assigned to CPU the number
       *&#64;&#64;     of instances created. Default is 1.
       * </pre>
       *
       * <code>int32 count = 2;</code>
       * @return This builder for chaining.
       */
      public Builder clearCount() {
        
        count_ = 0;
        onChanged();
        return this;
      }

      private org.apache.submarine.server.api.proto.TritonModelConfig.ModelRateLimiter rateLimiter_;
      private com.google.protobuf.SingleFieldBuilderV3<
          org.apache.submarine.server.api.proto.TritonModelConfig.ModelRateLimiter, org.apache.submarine.server.api.proto.TritonModelConfig.ModelRateLimiter.Builder, org.apache.submarine.server.api.proto.TritonModelConfig.ModelRateLimiterOrBuilder> rateLimiterBuilder_;
      /**
       * <pre>
       *&#64;&#64;  .. cpp:var:: ModelRateLimiter rate_limiter
       *&#64;&#64;
       *&#64;&#64;     The rate limiter specific settings to be associated with this
       *&#64;&#64;     instance group. Optional, if not specified no rate limiting
       *&#64;&#64;     will be applied to this instance group.
       *&#64;&#64;
       * </pre>
       *
       * <code>.inference.ModelRateLimiter rate_limiter = 6;</code>
       * @return Whether the rateLimiter field is set.
       */
      public boolean hasRateLimiter() {
        return rateLimiterBuilder_ != null || rateLimiter_ != null;
      }
      /**
       * <pre>
       *&#64;&#64;  .. cpp:var:: ModelRateLimiter rate_limiter
       *&#64;&#64;
       *&#64;&#64;     The rate limiter specific settings to be associated with this
       *&#64;&#64;     instance group. Optional, if not specified no rate limiting
       *&#64;&#64;     will be applied to this instance group.
       *&#64;&#64;
       * </pre>
       *
       * <code>.inference.ModelRateLimiter rate_limiter = 6;</code>
       * @return The rateLimiter.
       */
      public org.apache.submarine.server.api.proto.TritonModelConfig.ModelRateLimiter getRateLimiter() {
        if (rateLimiterBuilder_ == null) {
          return rateLimiter_ == null ? org.apache.submarine.server.api.proto.TritonModelConfig.ModelRateLimiter.getDefaultInstance() : rateLimiter_;
        } else {
          return rateLimiterBuilder_.getMessage();
        }
      }
      /**
       * <pre>
       *&#64;&#64;  .. cpp:var:: ModelRateLimiter rate_limiter
       *&#64;&#64;
       *&#64;&#64;     The rate limiter specific settings to be associated with this
       *&#64;&#64;     instance group. Optional, if not specified no rate limiting
       *&#64;&#64;     will be applied to this instance group.
       *&#64;&#64;
       * </pre>
       *
       * <code>.inference.ModelRateLimiter rate_limiter = 6;</code>
       */
      public Builder setRateLimiter(org.apache.submarine.server.api.proto.TritonModelConfig.ModelRateLimiter value) {
        if (rateLimiterBuilder_ == null) {
          if (value == null) {
            throw new NullPointerException();
          }
          rateLimiter_ = value;
          onChanged();
        } else {
          rateLimiterBuilder_.setMessage(value);
        }

        return this;
      }
      /**
       * <pre>
       *&#64;&#64;  .. cpp:var:: ModelRateLimiter rate_limiter
       *&#64;&#64;
       *&#64;&#64;     The rate limiter specific settings to be associated with this
       *&#64;&#64;     instance group. Optional, if not specified no rate limiting
       *&#64;&#64;     will be applied to this instance group.
       *&#64;&#64;
       * </pre>
       *
       * <code>.inference.ModelRateLimiter rate_limiter = 6;</code>
       */
      public Builder setRateLimiter(
          org.apache.submarine.server.api.proto.TritonModelConfig.ModelRateLimiter.Builder builderForValue) {
        if (rateLimiterBuilder_ == null) {
          rateLimiter_ = builderForValue.build();
          onChanged();
        } else {
          rateLimiterBuilder_.setMessage(builderForValue.build());
        }

        return this;
      }
      /**
       * <pre>
       *&#64;&#64;  .. cpp:var:: ModelRateLimiter rate_limiter
       *&#64;&#64;
       *&#64;&#64;     The rate limiter specific settings to be associated with this
       *&#64;&#64;     instance group. Optional, if not specified no rate limiting
       *&#64;&#64;     will be applied to this instance group.
       *&#64;&#64;
       * </pre>
       *
       * <code>.inference.ModelRateLimiter rate_limiter = 6;</code>
       */
      public Builder mergeRateLimiter(org.apache.submarine.server.api.proto.TritonModelConfig.ModelRateLimiter value) {
        if (rateLimiterBuilder_ == null) {
          if (rateLimiter_ != null) {
            rateLimiter_ =
              org.apache.submarine.server.api.proto.TritonModelConfig.ModelRateLimiter.newBuilder(rateLimiter_).mergeFrom(value).buildPartial();
          } else {
            rateLimiter_ = value;
          }
          onChanged();
        } else {
          rateLimiterBuilder_.mergeFrom(value);
        }

        return this;
      }
      /**
       * <pre>
       *&#64;&#64;  .. cpp:var:: ModelRateLimiter rate_limiter
       *&#64;&#64;
       *&#64;&#64;     The rate limiter specific settings to be associated with this
       *&#64;&#64;     instance group. Optional, if not specified no rate limiting
       *&#64;&#64;     will be applied to this instance group.
       *&#64;&#64;
       * </pre>
       *
       * <code>.inference.ModelRateLimiter rate_limiter = 6;</code>
       */
      public Builder clearRateLimiter() {
        if (rateLimiterBuilder_ == null) {
          rateLimiter_ = null;
          onChanged();
        } else {
          rateLimiter_ = null;
          rateLimiterBuilder_ = null;
        }

        return this;
      }
      /**
       * <pre>
       *&#64;&#64;  .. cpp:var:: ModelRateLimiter rate_limiter
       *&#64;&#64;
       *&#64;&#64;     The rate limiter specific settings to be associated with this
       *&#64;&#64;     instance group. Optional, if not specified no rate limiting
       *&#64;&#64;     will be applied to this instance group.
       *&#64;&#64;
       * </pre>
       *
       * <code>.inference.ModelRateLimiter rate_limiter = 6;</code>
       */
      public org.apache.submarine.server.api.proto.TritonModelConfig.ModelRateLimiter.Builder getRateLimiterBuilder() {
        
        onChanged();
        return getRateLimiterFieldBuilder().getBuilder();
      }
      /**
       * <pre>
       *&#64;&#64;  .. cpp:var:: ModelRateLimiter rate_limiter
       *&#64;&#64;
       *&#64;&#64;     The rate limiter specific settings to be associated with this
       *&#64;&#64;     instance group. Optional, if not specified no rate limiting
       *&#64;&#64;     will be applied to this instance group.
       *&#64;&#64;
       * </pre>
       *
       * <code>.inference.ModelRateLimiter rate_limiter = 6;</code>
       */
      public org.apache.submarine.server.api.proto.TritonModelConfig.ModelRateLimiterOrBuilder getRateLimiterOrBuilder() {
        if (rateLimiterBuilder_ != null) {
          return rateLimiterBuilder_.getMessageOrBuilder();
        } else {
          return rateLimiter_ == null ?
              org.apache.submarine.server.api.proto.TritonModelConfig.ModelRateLimiter.getDefaultInstance() : rateLimiter_;
        }
      }
      /**
       * <pre>
       *&#64;&#64;  .. cpp:var:: ModelRateLimiter rate_limiter
       *&#64;&#64;
       *&#64;&#64;     The rate limiter specific settings to be associated with this
       *&#64;&#64;     instance group. Optional, if not specified no rate limiting
       *&#64;&#64;     will be applied to this instance group.
       *&#64;&#64;
       * </pre>
       *
       * <code>.inference.ModelRateLimiter rate_limiter = 6;</code>
       */
      private com.google.protobuf.SingleFieldBuilderV3<
          org.apache.submarine.server.api.proto.TritonModelConfig.ModelRateLimiter, org.apache.submarine.server.api.proto.TritonModelConfig.ModelRateLimiter.Builder, org.apache.submarine.server.api.proto.TritonModelConfig.ModelRateLimiterOrBuilder> 
          getRateLimiterFieldBuilder() {
        if (rateLimiterBuilder_ == null) {
          rateLimiterBuilder_ = new com.google.protobuf.SingleFieldBuilderV3<
              org.apache.submarine.server.api.proto.TritonModelConfig.ModelRateLimiter, org.apache.submarine.server.api.proto.TritonModelConfig.ModelRateLimiter.Builder, org.apache.submarine.server.api.proto.TritonModelConfig.ModelRateLimiterOrBuilder>(
                  getRateLimiter(),
                  getParentForChildren(),
                  isClean());
          rateLimiter_ = null;
        }
        return rateLimiterBuilder_;
      }

      private com.google.protobuf.Internal.IntList gpus_ = emptyIntList();
      private void ensureGpusIsMutable() {
        if (!((bitField0_ & 0x00000001) != 0)) {
          gpus_ = mutableCopy(gpus_);
          bitField0_ |= 0x00000001;
         }
      }
      /**
       * <pre>
       *&#64;&#64;  .. cpp:var:: int32 gpus (repeated)
       *&#64;&#64;
       *&#64;&#64;     GPU(s) where instances should be available. For each GPU listed,
       *&#64;&#64;     'count' instances of the model will be available. Setting 'gpus'
       *&#64;&#64;     to empty (or not specifying at all) is eqivalent to listing all
       *&#64;&#64;     available GPUs.
       *&#64;&#64;
       * </pre>
       *
       * <code>repeated int32 gpus = 3;</code>
       * @return A list containing the gpus.
       */
      public java.util.List<java.lang.Integer>
          getGpusList() {
        return ((bitField0_ & 0x00000001) != 0) ?
                 java.util.Collections.unmodifiableList(gpus_) : gpus_;
      }
      /**
       * <pre>
       *&#64;&#64;  .. cpp:var:: int32 gpus (repeated)
       *&#64;&#64;
       *&#64;&#64;     GPU(s) where instances should be available. For each GPU listed,
       *&#64;&#64;     'count' instances of the model will be available. Setting 'gpus'
       *&#64;&#64;     to empty (or not specifying at all) is eqivalent to listing all
       *&#64;&#64;     available GPUs.
       *&#64;&#64;
       * </pre>
       *
       * <code>repeated int32 gpus = 3;</code>
       * @return The count of gpus.
       */
      public int getGpusCount() {
        return gpus_.size();
      }
      /**
       * <pre>
       *&#64;&#64;  .. cpp:var:: int32 gpus (repeated)
       *&#64;&#64;
       *&#64;&#64;     GPU(s) where instances should be available. For each GPU listed,
       *&#64;&#64;     'count' instances of the model will be available. Setting 'gpus'
       *&#64;&#64;     to empty (or not specifying at all) is eqivalent to listing all
       *&#64;&#64;     available GPUs.
       *&#64;&#64;
       * </pre>
       *
       * <code>repeated int32 gpus = 3;</code>
       * @param index The index of the element to return.
       * @return The gpus at the given index.
       */
      public int getGpus(int index) {
        return gpus_.getInt(index);
      }
      /**
       * <pre>
       *&#64;&#64;  .. cpp:var:: int32 gpus (repeated)
       *&#64;&#64;
       *&#64;&#64;     GPU(s) where instances should be available. For each GPU listed,
       *&#64;&#64;     'count' instances of the model will be available. Setting 'gpus'
       *&#64;&#64;     to empty (or not specifying at all) is eqivalent to listing all
       *&#64;&#64;     available GPUs.
       *&#64;&#64;
       * </pre>
       *
       * <code>repeated int32 gpus = 3;</code>
       * @param index The index to set the value at.
       * @param value The gpus to set.
       * @return This builder for chaining.
       */
      public Builder setGpus(
          int index, int value) {
        ensureGpusIsMutable();
        gpus_.setInt(index, value);
        onChanged();
        return this;
      }
      /**
       * <pre>
       *&#64;&#64;  .. cpp:var:: int32 gpus (repeated)
       *&#64;&#64;
       *&#64;&#64;     GPU(s) where instances should be available. For each GPU listed,
       *&#64;&#64;     'count' instances of the model will be available. Setting 'gpus'
       *&#64;&#64;     to empty (or not specifying at all) is eqivalent to listing all
       *&#64;&#64;     available GPUs.
       *&#64;&#64;
       * </pre>
       *
       * <code>repeated int32 gpus = 3;</code>
       * @param value The gpus to add.
       * @return This builder for chaining.
       */
      public Builder addGpus(int value) {
        ensureGpusIsMutable();
        gpus_.addInt(value);
        onChanged();
        return this;
      }
      /**
       * <pre>
       *&#64;&#64;  .. cpp:var:: int32 gpus (repeated)
       *&#64;&#64;
       *&#64;&#64;     GPU(s) where instances should be available. For each GPU listed,
       *&#64;&#64;     'count' instances of the model will be available. Setting 'gpus'
       *&#64;&#64;     to empty (or not specifying at all) is eqivalent to listing all
       *&#64;&#64;     available GPUs.
       *&#64;&#64;
       * </pre>
       *
       * <code>repeated int32 gpus = 3;</code>
       * @param values The gpus to add.
       * @return This builder for chaining.
       */
      public Builder addAllGpus(
          java.lang.Iterable<? extends java.lang.Integer> values) {
        ensureGpusIsMutable();
        com.google.protobuf.AbstractMessageLite.Builder.addAll(
            values, gpus_);
        onChanged();
        return this;
      }
      /**
       * <pre>
       *&#64;&#64;  .. cpp:var:: int32 gpus (repeated)
       *&#64;&#64;
       *&#64;&#64;     GPU(s) where instances should be available. For each GPU listed,
       *&#64;&#64;     'count' instances of the model will be available. Setting 'gpus'
       *&#64;&#64;     to empty (or not specifying at all) is eqivalent to listing all
       *&#64;&#64;     available GPUs.
       *&#64;&#64;
       * </pre>
       *
       * <code>repeated int32 gpus = 3;</code>
       * @return This builder for chaining.
       */
      public Builder clearGpus() {
        gpus_ = emptyIntList();
        bitField0_ = (bitField0_ & ~0x00000001);
        onChanged();
        return this;
      }

      private java.util.List<org.apache.submarine.server.api.proto.TritonModelConfig.ModelInstanceGroup.SecondaryDevice> secondaryDevices_ =
        java.util.Collections.emptyList();
      private void ensureSecondaryDevicesIsMutable() {
        if (!((bitField0_ & 0x00000002) != 0)) {
          secondaryDevices_ = new java.util.ArrayList<org.apache.submarine.server.api.proto.TritonModelConfig.ModelInstanceGroup.SecondaryDevice>(secondaryDevices_);
          bitField0_ |= 0x00000002;
         }
      }

      private com.google.protobuf.RepeatedFieldBuilderV3<
          org.apache.submarine.server.api.proto.TritonModelConfig.ModelInstanceGroup.SecondaryDevice, org.apache.submarine.server.api.proto.TritonModelConfig.ModelInstanceGroup.SecondaryDevice.Builder, org.apache.submarine.server.api.proto.TritonModelConfig.ModelInstanceGroup.SecondaryDeviceOrBuilder> secondaryDevicesBuilder_;

      /**
       * <pre>
       *&#64;&#64;  .. cpp:var:: SecondaryDevice secondary_devices (repeated)
       *&#64;&#64;
       *&#64;&#64;     Secondary devices that are required by instances specified by this
       *&#64;&#64;     instance group. Optional.
       *&#64;&#64;
       * </pre>
       *
       * <code>repeated .inference.ModelInstanceGroup.SecondaryDevice secondary_devices = 8;</code>
       */
      public java.util.List<org.apache.submarine.server.api.proto.TritonModelConfig.ModelInstanceGroup.SecondaryDevice> getSecondaryDevicesList() {
        if (secondaryDevicesBuilder_ == null) {
          return java.util.Collections.unmodifiableList(secondaryDevices_);
        } else {
          return secondaryDevicesBuilder_.getMessageList();
        }
      }
      /**
       * <pre>
       *&#64;&#64;  .. cpp:var:: SecondaryDevice secondary_devices (repeated)
       *&#64;&#64;
       *&#64;&#64;     Secondary devices that are required by instances specified by this
       *&#64;&#64;     instance group. Optional.
       *&#64;&#64;
       * </pre>
       *
       * <code>repeated .inference.ModelInstanceGroup.SecondaryDevice secondary_devices = 8;</code>
       */
      public int getSecondaryDevicesCount() {
        if (secondaryDevicesBuilder_ == null) {
          return secondaryDevices_.size();
        } else {
          return secondaryDevicesBuilder_.getCount();
        }
      }
      /**
       * <pre>
       *&#64;&#64;  .. cpp:var:: SecondaryDevice secondary_devices (repeated)
       *&#64;&#64;
       *&#64;&#64;     Secondary devices that are required by instances specified by this
       *&#64;&#64;     instance group. Optional.
       *&#64;&#64;
       * </pre>
       *
       * <code>repeated .inference.ModelInstanceGroup.SecondaryDevice secondary_devices = 8;</code>
       */
      public org.apache.submarine.server.api.proto.TritonModelConfig.ModelInstanceGroup.SecondaryDevice getSecondaryDevices(int index) {
        if (secondaryDevicesBuilder_ == null) {
          return secondaryDevices_.get(index);
        } else {
          return secondaryDevicesBuilder_.getMessage(index);
        }
      }
      /**
       * <pre>
       *&#64;&#64;  .. cpp:var:: SecondaryDevice secondary_devices (repeated)
       *&#64;&#64;
       *&#64;&#64;     Secondary devices that are required by instances specified by this
       *&#64;&#64;     instance group. Optional.
       *&#64;&#64;
       * </pre>
       *
       * <code>repeated .inference.ModelInstanceGroup.SecondaryDevice secondary_devices = 8;</code>
       */
      public Builder setSecondaryDevices(
          int index, org.apache.submarine.server.api.proto.TritonModelConfig.ModelInstanceGroup.SecondaryDevice value) {
        if (secondaryDevicesBuilder_ == null) {
          if (value == null) {
            throw new NullPointerException();
          }
          ensureSecondaryDevicesIsMutable();
          secondaryDevices_.set(index, value);
          onChanged();
        } else {
          secondaryDevicesBuilder_.setMessage(index, value);
        }
        return this;
      }
      /**
       * <pre>
       *&#64;&#64;  .. cpp:var:: SecondaryDevice secondary_devices (repeated)
       *&#64;&#64;
       *&#64;&#64;     Secondary devices that are required by instances specified by this
       *&#64;&#64;     instance group. Optional.
       *&#64;&#64;
       * </pre>
       *
       * <code>repeated .inference.ModelInstanceGroup.SecondaryDevice secondary_devices = 8;</code>
       */
      public Builder setSecondaryDevices(
          int index, org.apache.submarine.server.api.proto.TritonModelConfig.ModelInstanceGroup.SecondaryDevice.Builder builderForValue) {
        if (secondaryDevicesBuilder_ == null) {
          ensureSecondaryDevicesIsMutable();
          secondaryDevices_.set(index, builderForValue.build());
          onChanged();
        } else {
          secondaryDevicesBuilder_.setMessage(index, builderForValue.build());
        }
        return this;
      }
      /**
       * <pre>
       *&#64;&#64;  .. cpp:var:: SecondaryDevice secondary_devices (repeated)
       *&#64;&#64;
       *&#64;&#64;     Secondary devices that are required by instances specified by this
       *&#64;&#64;     instance group. Optional.
       *&#64;&#64;
       * </pre>
       *
       * <code>repeated .inference.ModelInstanceGroup.SecondaryDevice secondary_devices = 8;</code>
       */
      public Builder addSecondaryDevices(org.apache.submarine.server.api.proto.TritonModelConfig.ModelInstanceGroup.SecondaryDevice value) {
        if (secondaryDevicesBuilder_ == null) {
          if (value == null) {
            throw new NullPointerException();
          }
          ensureSecondaryDevicesIsMutable();
          secondaryDevices_.add(value);
          onChanged();
        } else {
          secondaryDevicesBuilder_.addMessage(value);
        }
        return this;
      }
      /**
       * <pre>
       *&#64;&#64;  .. cpp:var:: SecondaryDevice secondary_devices (repeated)
       *&#64;&#64;
       *&#64;&#64;     Secondary devices that are required by instances specified by this
       *&#64;&#64;     instance group. Optional.
       *&#64;&#64;
       * </pre>
       *
       * <code>repeated .inference.ModelInstanceGroup.SecondaryDevice secondary_devices = 8;</code>
       */
      public Builder addSecondaryDevices(
          int index, org.apache.submarine.server.api.proto.TritonModelConfig.ModelInstanceGroup.SecondaryDevice value) {
        if (secondaryDevicesBuilder_ == null) {
          if (value == null) {
            throw new NullPointerException();
          }
          ensureSecondaryDevicesIsMutable();
          secondaryDevices_.add(index, value);
          onChanged();
        } else {
          secondaryDevicesBuilder_.addMessage(index, value);
        }
        return this;
      }
      /**
       * <pre>
       *&#64;&#64;  .. cpp:var:: SecondaryDevice secondary_devices (repeated)
       *&#64;&#64;
       *&#64;&#64;     Secondary devices that are required by instances specified by this
       *&#64;&#64;     instance group. Optional.
       *&#64;&#64;
       * </pre>
       *
       * <code>repeated .inference.ModelInstanceGroup.SecondaryDevice secondary_devices = 8;</code>
       */
      public Builder addSecondaryDevices(
          org.apache.submarine.server.api.proto.TritonModelConfig.ModelInstanceGroup.SecondaryDevice.Builder builderForValue) {
        if (secondaryDevicesBuilder_ == null) {
          ensureSecondaryDevicesIsMutable();
          secondaryDevices_.add(builderForValue.build());
          onChanged();
        } else {
          secondaryDevicesBuilder_.addMessage(builderForValue.build());
        }
        return this;
      }
      /**
       * <pre>
       *&#64;&#64;  .. cpp:var:: SecondaryDevice secondary_devices (repeated)
       *&#64;&#64;
       *&#64;&#64;     Secondary devices that are required by instances specified by this
       *&#64;&#64;     instance group. Optional.
       *&#64;&#64;
       * </pre>
       *
       * <code>repeated .inference.ModelInstanceGroup.SecondaryDevice secondary_devices = 8;</code>
       */
      public Builder addSecondaryDevices(
          int index, org.apache.submarine.server.api.proto.TritonModelConfig.ModelInstanceGroup.SecondaryDevice.Builder builderForValue) {
        if (secondaryDevicesBuilder_ == null) {
          ensureSecondaryDevicesIsMutable();
          secondaryDevices_.add(index, builderForValue.build());
          onChanged();
        } else {
          secondaryDevicesBuilder_.addMessage(index, builderForValue.build());
        }
        return this;
      }
      /**
       * <pre>
       *&#64;&#64;  .. cpp:var:: SecondaryDevice secondary_devices (repeated)
       *&#64;&#64;
       *&#64;&#64;     Secondary devices that are required by instances specified by this
       *&#64;&#64;     instance group. Optional.
       *&#64;&#64;
       * </pre>
       *
       * <code>repeated .inference.ModelInstanceGroup.SecondaryDevice secondary_devices = 8;</code>
       */
      public Builder addAllSecondaryDevices(
          java.lang.Iterable<? extends org.apache.submarine.server.api.proto.TritonModelConfig.ModelInstanceGroup.SecondaryDevice> values) {
        if (secondaryDevicesBuilder_ == null) {
          ensureSecondaryDevicesIsMutable();
          com.google.protobuf.AbstractMessageLite.Builder.addAll(
              values, secondaryDevices_);
          onChanged();
        } else {
          secondaryDevicesBuilder_.addAllMessages(values);
        }
        return this;
      }
      /**
       * <pre>
       *&#64;&#64;  .. cpp:var:: SecondaryDevice secondary_devices (repeated)
       *&#64;&#64;
       *&#64;&#64;     Secondary devices that are required by instances specified by this
       *&#64;&#64;     instance group. Optional.
       *&#64;&#64;
       * </pre>
       *
       * <code>repeated .inference.ModelInstanceGroup.SecondaryDevice secondary_devices = 8;</code>
       */
      public Builder clearSecondaryDevices() {
        if (secondaryDevicesBuilder_ == null) {
          secondaryDevices_ = java.util.Collections.emptyList();
          bitField0_ = (bitField0_ & ~0x00000002);
          onChanged();
        } else {
          secondaryDevicesBuilder_.clear();
        }
        return this;
      }
      /**
       * <pre>
       *&#64;&#64;  .. cpp:var:: SecondaryDevice secondary_devices (repeated)
       *&#64;&#64;
       *&#64;&#64;     Secondary devices that are required by instances specified by this
       *&#64;&#64;     instance group. Optional.
       *&#64;&#64;
       * </pre>
       *
       * <code>repeated .inference.ModelInstanceGroup.SecondaryDevice secondary_devices = 8;</code>
       */
      public Builder removeSecondaryDevices(int index) {
        if (secondaryDevicesBuilder_ == null) {
          ensureSecondaryDevicesIsMutable();
          secondaryDevices_.remove(index);
          onChanged();
        } else {
          secondaryDevicesBuilder_.remove(index);
        }
        return this;
      }
      /**
       * <pre>
       *&#64;&#64;  .. cpp:var:: SecondaryDevice secondary_devices (repeated)
       *&#64;&#64;
       *&#64;&#64;     Secondary devices that are required by instances specified by this
       *&#64;&#64;     instance group. Optional.
       *&#64;&#64;
       * </pre>
       *
       * <code>repeated .inference.ModelInstanceGroup.SecondaryDevice secondary_devices = 8;</code>
       */
      public org.apache.submarine.server.api.proto.TritonModelConfig.ModelInstanceGroup.SecondaryDevice.Builder getSecondaryDevicesBuilder(
          int index) {
        return getSecondaryDevicesFieldBuilder().getBuilder(index);
      }
      /**
       * <pre>
       *&#64;&#64;  .. cpp:var:: SecondaryDevice secondary_devices (repeated)
       *&#64;&#64;
       *&#64;&#64;     Secondary devices that are required by instances specified by this
       *&#64;&#64;     instance group. Optional.
       *&#64;&#64;
       * </pre>
       *
       * <code>repeated .inference.ModelInstanceGroup.SecondaryDevice secondary_devices = 8;</code>
       */
      public org.apache.submarine.server.api.proto.TritonModelConfig.ModelInstanceGroup.SecondaryDeviceOrBuilder getSecondaryDevicesOrBuilder(
          int index) {
        if (secondaryDevicesBuilder_ == null) {
          return secondaryDevices_.get(index);  } else {
          return secondaryDevicesBuilder_.getMessageOrBuilder(index);
        }
      }
      /**
       * <pre>
       *&#64;&#64;  .. cpp:var:: SecondaryDevice secondary_devices (repeated)
       *&#64;&#64;
       *&#64;&#64;     Secondary devices that are required by instances specified by this
       *&#64;&#64;     instance group. Optional.
       *&#64;&#64;
       * </pre>
       *
       * <code>repeated .inference.ModelInstanceGroup.SecondaryDevice secondary_devices = 8;</code>
       */
      public java.util.List<? extends org.apache.submarine.server.api.proto.TritonModelConfig.ModelInstanceGroup.SecondaryDeviceOrBuilder> 
           getSecondaryDevicesOrBuilderList() {
        if (secondaryDevicesBuilder_ != null) {
          return secondaryDevicesBuilder_.getMessageOrBuilderList();
        } else {
          return java.util.Collections.unmodifiableList(secondaryDevices_);
        }
      }
      /**
       * <pre>
       *&#64;&#64;  .. cpp:var:: SecondaryDevice secondary_devices (repeated)
       *&#64;&#64;
       *&#64;&#64;     Secondary devices that are required by instances specified by this
       *&#64;&#64;     instance group. Optional.
       *&#64;&#64;
       * </pre>
       *
       * <code>repeated .inference.ModelInstanceGroup.SecondaryDevice secondary_devices = 8;</code>
       */
      public org.apache.submarine.server.api.proto.TritonModelConfig.ModelInstanceGroup.SecondaryDevice.Builder addSecondaryDevicesBuilder() {
        return getSecondaryDevicesFieldBuilder().addBuilder(
            org.apache.submarine.server.api.proto.TritonModelConfig.ModelInstanceGroup.SecondaryDevice.getDefaultInstance());
      }
      /**
       * <pre>
       *&#64;&#64;  .. cpp:var:: SecondaryDevice secondary_devices (repeated)
       *&#64;&#64;
       *&#64;&#64;     Secondary devices that are required by instances specified by this
       *&#64;&#64;     instance group. Optional.
       *&#64;&#64;
       * </pre>
       *
       * <code>repeated .inference.ModelInstanceGroup.SecondaryDevice secondary_devices = 8;</code>
       */
      public org.apache.submarine.server.api.proto.TritonModelConfig.ModelInstanceGroup.SecondaryDevice.Builder addSecondaryDevicesBuilder(
          int index) {
        return getSecondaryDevicesFieldBuilder().addBuilder(
            index, org.apache.submarine.server.api.proto.TritonModelConfig.ModelInstanceGroup.SecondaryDevice.getDefaultInstance());
      }
      /**
       * <pre>
       *&#64;&#64;  .. cpp:var:: SecondaryDevice secondary_devices (repeated)
       *&#64;&#64;
       *&#64;&#64;     Secondary devices that are required by instances specified by this
       *&#64;&#64;     instance group. Optional.
       *&#64;&#64;
       * </pre>
       *
       * <code>repeated .inference.ModelInstanceGroup.SecondaryDevice secondary_devices = 8;</code>
       */
      public java.util.List<org.apache.submarine.server.api.proto.TritonModelConfig.ModelInstanceGroup.SecondaryDevice.Builder> 
           getSecondaryDevicesBuilderList() {
        return getSecondaryDevicesFieldBuilder().getBuilderList();
      }
      private com.google.protobuf.RepeatedFieldBuilderV3<
          org.apache.submarine.server.api.proto.TritonModelConfig.ModelInstanceGroup.SecondaryDevice, org.apache.submarine.server.api.proto.TritonModelConfig.ModelInstanceGroup.SecondaryDevice.Builder, org.apache.submarine.server.api.proto.TritonModelConfig.ModelInstanceGroup.SecondaryDeviceOrBuilder> 
          getSecondaryDevicesFieldBuilder() {
        if (secondaryDevicesBuilder_ == null) {
          secondaryDevicesBuilder_ = new com.google.protobuf.RepeatedFieldBuilderV3<
              org.apache.submarine.server.api.proto.TritonModelConfig.ModelInstanceGroup.SecondaryDevice, org.apache.submarine.server.api.proto.TritonModelConfig.ModelInstanceGroup.SecondaryDevice.Builder, org.apache.submarine.server.api.proto.TritonModelConfig.ModelInstanceGroup.SecondaryDeviceOrBuilder>(
                  secondaryDevices_,
                  ((bitField0_ & 0x00000002) != 0),
                  getParentForChildren(),
                  isClean());
          secondaryDevices_ = null;
        }
        return secondaryDevicesBuilder_;
      }

      private com.google.protobuf.LazyStringList profile_ = com.google.protobuf.LazyStringArrayList.EMPTY;
      private void ensureProfileIsMutable() {
        if (!((bitField0_ & 0x00000004) != 0)) {
          profile_ = new com.google.protobuf.LazyStringArrayList(profile_);
          bitField0_ |= 0x00000004;
         }
      }
      /**
       * <pre>
       *&#64;&#64;  .. cpp:var:: string profile (repeated)
       *&#64;&#64;
       *&#64;&#64;     For TensorRT models containing multiple optimization profile, this
       *&#64;&#64;     parameter specifies a set of optimization profiles available to this
       *&#64;&#64;     instance group. The inference server will choose the optimal profile
       *&#64;&#64;     based on the shapes of the input tensors. This field should lie
       *&#64;&#64;     between 0 and &lt;TotalNumberOfOptimizationProfilesInPlanModel&gt; - 1
       *&#64;&#64;     and be specified only for TensorRT backend, otherwise an error will
       *&#64;&#64;     be generated. If not specified, the server will select the first
       *&#64;&#64;     optimization profile by default.
       *&#64;&#64;
       * </pre>
       *
       * <code>repeated string profile = 5;</code>
       * @return A list containing the profile.
       */
      public com.google.protobuf.ProtocolStringList
          getProfileList() {
        return profile_.getUnmodifiableView();
      }
      /**
       * <pre>
       *&#64;&#64;  .. cpp:var:: string profile (repeated)
       *&#64;&#64;
       *&#64;&#64;     For TensorRT models containing multiple optimization profile, this
       *&#64;&#64;     parameter specifies a set of optimization profiles available to this
       *&#64;&#64;     instance group. The inference server will choose the optimal profile
       *&#64;&#64;     based on the shapes of the input tensors. This field should lie
       *&#64;&#64;     between 0 and &lt;TotalNumberOfOptimizationProfilesInPlanModel&gt; - 1
       *&#64;&#64;     and be specified only for TensorRT backend, otherwise an error will
       *&#64;&#64;     be generated. If not specified, the server will select the first
       *&#64;&#64;     optimization profile by default.
       *&#64;&#64;
       * </pre>
       *
       * <code>repeated string profile = 5;</code>
       * @return The count of profile.
       */
      public int getProfileCount() {
        return profile_.size();
      }
      /**
       * <pre>
       *&#64;&#64;  .. cpp:var:: string profile (repeated)
       *&#64;&#64;
       *&#64;&#64;     For TensorRT models containing multiple optimization profile, this
       *&#64;&#64;     parameter specifies a set of optimization profiles available to this
       *&#64;&#64;     instance group. The inference server will choose the optimal profile
       *&#64;&#64;     based on the shapes of the input tensors. This field should lie
       *&#64;&#64;     between 0 and &lt;TotalNumberOfOptimizationProfilesInPlanModel&gt; - 1
       *&#64;&#64;     and be specified only for TensorRT backend, otherwise an error will
       *&#64;&#64;     be generated. If not specified, the server will select the first
       *&#64;&#64;     optimization profile by default.
       *&#64;&#64;
       * </pre>
       *
       * <code>repeated string profile = 5;</code>
       * @param index The index of the element to return.
       * @return The profile at the given index.
       */
      public java.lang.String getProfile(int index) {
        return profile_.get(index);
      }
      /**
       * <pre>
       *&#64;&#64;  .. cpp:var:: string profile (repeated)
       *&#64;&#64;
       *&#64;&#64;     For TensorRT models containing multiple optimization profile, this
       *&#64;&#64;     parameter specifies a set of optimization profiles available to this
       *&#64;&#64;     instance group. The inference server will choose the optimal profile
       *&#64;&#64;     based on the shapes of the input tensors. This field should lie
       *&#64;&#64;     between 0 and &lt;TotalNumberOfOptimizationProfilesInPlanModel&gt; - 1
       *&#64;&#64;     and be specified only for TensorRT backend, otherwise an error will
       *&#64;&#64;     be generated. If not specified, the server will select the first
       *&#64;&#64;     optimization profile by default.
       *&#64;&#64;
       * </pre>
       *
       * <code>repeated string profile = 5;</code>
       * @param index The index of the value to return.
       * @return The bytes of the profile at the given index.
       */
      public com.google.protobuf.ByteString
          getProfileBytes(int index) {
        return profile_.getByteString(index);
      }
      /**
       * <pre>
       *&#64;&#64;  .. cpp:var:: string profile (repeated)
       *&#64;&#64;
       *&#64;&#64;     For TensorRT models containing multiple optimization profile, this
       *&#64;&#64;     parameter specifies a set of optimization profiles available to this
       *&#64;&#64;     instance group. The inference server will choose the optimal profile
       *&#64;&#64;     based on the shapes of the input tensors. This field should lie
       *&#64;&#64;     between 0 and &lt;TotalNumberOfOptimizationProfilesInPlanModel&gt; - 1
       *&#64;&#64;     and be specified only for TensorRT backend, otherwise an error will
       *&#64;&#64;     be generated. If not specified, the server will select the first
       *&#64;&#64;     optimization profile by default.
       *&#64;&#64;
       * </pre>
       *
       * <code>repeated string profile = 5;</code>
       * @param index The index to set the value at.
       * @param value The profile to set.
       * @return This builder for chaining.
       */
      public Builder setProfile(
          int index, java.lang.String value) {
        if (value == null) {
    throw new NullPointerException();
  }
  ensureProfileIsMutable();
        profile_.set(index, value);
        onChanged();
        return this;
      }
      /**
       * <pre>
       *&#64;&#64;  .. cpp:var:: string profile (repeated)
       *&#64;&#64;
       *&#64;&#64;     For TensorRT models containing multiple optimization profile, this
       *&#64;&#64;     parameter specifies a set of optimization profiles available to this
       *&#64;&#64;     instance group. The inference server will choose the optimal profile
       *&#64;&#64;     based on the shapes of the input tensors. This field should lie
       *&#64;&#64;     between 0 and &lt;TotalNumberOfOptimizationProfilesInPlanModel&gt; - 1
       *&#64;&#64;     and be specified only for TensorRT backend, otherwise an error will
       *&#64;&#64;     be generated. If not specified, the server will select the first
       *&#64;&#64;     optimization profile by default.
       *&#64;&#64;
       * </pre>
       *
       * <code>repeated string profile = 5;</code>
       * @param value The profile to add.
       * @return This builder for chaining.
       */
      public Builder addProfile(
          java.lang.String value) {
        if (value == null) {
    throw new NullPointerException();
  }
  ensureProfileIsMutable();
        profile_.add(value);
        onChanged();
        return this;
      }
      /**
       * <pre>
       *&#64;&#64;  .. cpp:var:: string profile (repeated)
       *&#64;&#64;
       *&#64;&#64;     For TensorRT models containing multiple optimization profile, this
       *&#64;&#64;     parameter specifies a set of optimization profiles available to this
       *&#64;&#64;     instance group. The inference server will choose the optimal profile
       *&#64;&#64;     based on the shapes of the input tensors. This field should lie
       *&#64;&#64;     between 0 and &lt;TotalNumberOfOptimizationProfilesInPlanModel&gt; - 1
       *&#64;&#64;     and be specified only for TensorRT backend, otherwise an error will
       *&#64;&#64;     be generated. If not specified, the server will select the first
       *&#64;&#64;     optimization profile by default.
       *&#64;&#64;
       * </pre>
       *
       * <code>repeated string profile = 5;</code>
       * @param values The profile to add.
       * @return This builder for chaining.
       */
      public Builder addAllProfile(
          java.lang.Iterable<java.lang.String> values) {
        ensureProfileIsMutable();
        com.google.protobuf.AbstractMessageLite.Builder.addAll(
            values, profile_);
        onChanged();
        return this;
      }
      /**
       * <pre>
       *&#64;&#64;  .. cpp:var:: string profile (repeated)
       *&#64;&#64;
       *&#64;&#64;     For TensorRT models containing multiple optimization profile, this
       *&#64;&#64;     parameter specifies a set of optimization profiles available to this
       *&#64;&#64;     instance group. The inference server will choose the optimal profile
       *&#64;&#64;     based on the shapes of the input tensors. This field should lie
       *&#64;&#64;     between 0 and &lt;TotalNumberOfOptimizationProfilesInPlanModel&gt; - 1
       *&#64;&#64;     and be specified only for TensorRT backend, otherwise an error will
       *&#64;&#64;     be generated. If not specified, the server will select the first
       *&#64;&#64;     optimization profile by default.
       *&#64;&#64;
       * </pre>
       *
       * <code>repeated string profile = 5;</code>
       * @return This builder for chaining.
       */
      public Builder clearProfile() {
        profile_ = com.google.protobuf.LazyStringArrayList.EMPTY;
        bitField0_ = (bitField0_ & ~0x00000004);
        onChanged();
        return this;
      }
      /**
       * <pre>
       *&#64;&#64;  .. cpp:var:: string profile (repeated)
       *&#64;&#64;
       *&#64;&#64;     For TensorRT models containing multiple optimization profile, this
       *&#64;&#64;     parameter specifies a set of optimization profiles available to this
       *&#64;&#64;     instance group. The inference server will choose the optimal profile
       *&#64;&#64;     based on the shapes of the input tensors. This field should lie
       *&#64;&#64;     between 0 and &lt;TotalNumberOfOptimizationProfilesInPlanModel&gt; - 1
       *&#64;&#64;     and be specified only for TensorRT backend, otherwise an error will
       *&#64;&#64;     be generated. If not specified, the server will select the first
       *&#64;&#64;     optimization profile by default.
       *&#64;&#64;
       * </pre>
       *
       * <code>repeated string profile = 5;</code>
       * @param value The bytes of the profile to add.
       * @return This builder for chaining.
       */
      public Builder addProfileBytes(
          com.google.protobuf.ByteString value) {
        if (value == null) {
    throw new NullPointerException();
  }
  checkByteStringIsUtf8(value);
        ensureProfileIsMutable();
        profile_.add(value);
        onChanged();
        return this;
      }

      private boolean passive_ ;
      /**
       * <pre>
       *&#64;&#64;  .. cpp:var:: bool passive
       *&#64;&#64;
       *&#64;&#64;     Whether the instances within this instance group will be accepting
       *&#64;&#64;     inference requests from the scheduler. If true, the instances will
       *&#64;&#64;     not be added to the scheduler. Default value is false.
       *&#64;&#64;
       * </pre>
       *
       * <code>bool passive = 7;</code>
       * @return The passive.
       */
      @java.lang.Override
      public boolean getPassive() {
        return passive_;
      }
      /**
       * <pre>
       *&#64;&#64;  .. cpp:var:: bool passive
       *&#64;&#64;
       *&#64;&#64;     Whether the instances within this instance group will be accepting
       *&#64;&#64;     inference requests from the scheduler. If true, the instances will
       *&#64;&#64;     not be added to the scheduler. Default value is false.
       *&#64;&#64;
       * </pre>
       *
       * <code>bool passive = 7;</code>
       * @param value The passive to set.
       * @return This builder for chaining.
       */
      public Builder setPassive(boolean value) {
        
        passive_ = value;
        onChanged();
        return this;
      }
      /**
       * <pre>
       *&#64;&#64;  .. cpp:var:: bool passive
       *&#64;&#64;
       *&#64;&#64;     Whether the instances within this instance group will be accepting
       *&#64;&#64;     inference requests from the scheduler. If true, the instances will
       *&#64;&#64;     not be added to the scheduler. Default value is false.
       *&#64;&#64;
       * </pre>
       *
       * <code>bool passive = 7;</code>
       * @return This builder for chaining.
       */
      public Builder clearPassive() {
        
        passive_ = false;
        onChanged();
        return this;
      }

      private java.lang.Object hostPolicy_ = "";
      /**
       * <pre>
       *&#64;&#64;  .. cpp:var:: string host_policy
       *&#64;&#64;
       *&#64;&#64;     The host policy name that the instance to be associated with.
       *&#64;&#64;     The default value is set to reflect the device kind of the instance,
       *&#64;&#64;     for instance, KIND_CPU is "cpu", KIND_MODEL is "model" and
       *&#64;&#64;     KIND_GPU is "gpu_&lt;gpu_id&gt;".
       *&#64;&#64;
       * </pre>
       *
       * <code>string host_policy = 9;</code>
       * @return The hostPolicy.
       */
      public java.lang.String getHostPolicy() {
        java.lang.Object ref = hostPolicy_;
        if (!(ref instanceof java.lang.String)) {
          com.google.protobuf.ByteString bs =
              (com.google.protobuf.ByteString) ref;
          java.lang.String s = bs.toStringUtf8();
          hostPolicy_ = s;
          return s;
        } else {
          return (java.lang.String) ref;
        }
      }
      /**
       * <pre>
       *&#64;&#64;  .. cpp:var:: string host_policy
       *&#64;&#64;
       *&#64;&#64;     The host policy name that the instance to be associated with.
       *&#64;&#64;     The default value is set to reflect the device kind of the instance,
       *&#64;&#64;     for instance, KIND_CPU is "cpu", KIND_MODEL is "model" and
       *&#64;&#64;     KIND_GPU is "gpu_&lt;gpu_id&gt;".
       *&#64;&#64;
       * </pre>
       *
       * <code>string host_policy = 9;</code>
       * @return The bytes for hostPolicy.
       */
      public com.google.protobuf.ByteString
          getHostPolicyBytes() {
        java.lang.Object ref = hostPolicy_;
        if (ref instanceof String) {
          com.google.protobuf.ByteString b = 
              com.google.protobuf.ByteString.copyFromUtf8(
                  (java.lang.String) ref);
          hostPolicy_ = b;
          return b;
        } else {
          return (com.google.protobuf.ByteString) ref;
        }
      }
      /**
       * <pre>
       *&#64;&#64;  .. cpp:var:: string host_policy
       *&#64;&#64;
       *&#64;&#64;     The host policy name that the instance to be associated with.
       *&#64;&#64;     The default value is set to reflect the device kind of the instance,
       *&#64;&#64;     for instance, KIND_CPU is "cpu", KIND_MODEL is "model" and
       *&#64;&#64;     KIND_GPU is "gpu_&lt;gpu_id&gt;".
       *&#64;&#64;
       * </pre>
       *
       * <code>string host_policy = 9;</code>
       * @param value The hostPolicy to set.
       * @return This builder for chaining.
       */
      public Builder setHostPolicy(
          java.lang.String value) {
        if (value == null) {
    throw new NullPointerException();
  }
  
        hostPolicy_ = value;
        onChanged();
        return this;
      }
      /**
       * <pre>
       *&#64;&#64;  .. cpp:var:: string host_policy
       *&#64;&#64;
       *&#64;&#64;     The host policy name that the instance to be associated with.
       *&#64;&#64;     The default value is set to reflect the device kind of the instance,
       *&#64;&#64;     for instance, KIND_CPU is "cpu", KIND_MODEL is "model" and
       *&#64;&#64;     KIND_GPU is "gpu_&lt;gpu_id&gt;".
       *&#64;&#64;
       * </pre>
       *
       * <code>string host_policy = 9;</code>
       * @return This builder for chaining.
       */
      public Builder clearHostPolicy() {
        
        hostPolicy_ = getDefaultInstance().getHostPolicy();
        onChanged();
        return this;
      }
      /**
       * <pre>
       *&#64;&#64;  .. cpp:var:: string host_policy
       *&#64;&#64;
       *&#64;&#64;     The host policy name that the instance to be associated with.
       *&#64;&#64;     The default value is set to reflect the device kind of the instance,
       *&#64;&#64;     for instance, KIND_CPU is "cpu", KIND_MODEL is "model" and
       *&#64;&#64;     KIND_GPU is "gpu_&lt;gpu_id&gt;".
       *&#64;&#64;
       * </pre>
       *
       * <code>string host_policy = 9;</code>
       * @param value The bytes for hostPolicy to set.
       * @return This builder for chaining.
       */
      public Builder setHostPolicyBytes(
          com.google.protobuf.ByteString value) {
        if (value == null) {
    throw new NullPointerException();
  }
  checkByteStringIsUtf8(value);
        
        hostPolicy_ = value;
        onChanged();
        return this;
      }
      @java.lang.Override
      public final Builder setUnknownFields(
          final com.google.protobuf.UnknownFieldSet unknownFields) {
        return super.setUnknownFields(unknownFields);
      }

      @java.lang.Override
      public final Builder mergeUnknownFields(
          final com.google.protobuf.UnknownFieldSet unknownFields) {
        return super.mergeUnknownFields(unknownFields);
      }


      // @@protoc_insertion_point(builder_scope:inference.ModelInstanceGroup)
    }

    // @@protoc_insertion_point(class_scope:inference.ModelInstanceGroup)
    private static final org.apache.submarine.server.api.proto.TritonModelConfig.ModelInstanceGroup DEFAULT_INSTANCE;
    static {
      DEFAULT_INSTANCE = new org.apache.submarine.server.api.proto.TritonModelConfig.ModelInstanceGroup();
    }

    public static org.apache.submarine.server.api.proto.TritonModelConfig.ModelInstanceGroup getDefaultInstance() {
      return DEFAULT_INSTANCE;
    }

    private static final com.google.protobuf.Parser<ModelInstanceGroup>
        PARSER = new com.google.protobuf.AbstractParser<ModelInstanceGroup>() {
      @java.lang.Override
      public ModelInstanceGroup parsePartialFrom(
          com.google.protobuf.CodedInputStream input,
          com.google.protobuf.ExtensionRegistryLite extensionRegistry)
          throws com.google.protobuf.InvalidProtocolBufferException {
        return new ModelInstanceGroup(input, extensionRegistry);
      }
    };

    public static com.google.protobuf.Parser<ModelInstanceGroup> parser() {
      return PARSER;
    }

    @java.lang.Override
    public com.google.protobuf.Parser<ModelInstanceGroup> getParserForType() {
      return PARSER;
    }

    @java.lang.Override
    public org.apache.submarine.server.api.proto.TritonModelConfig.ModelInstanceGroup getDefaultInstanceForType() {
      return DEFAULT_INSTANCE;
    }

  }

  public interface ModelTensorReshapeOrBuilder extends
      // @@protoc_insertion_point(interface_extends:inference.ModelTensorReshape)
      com.google.protobuf.MessageOrBuilder {

    /**
     * <pre>
     *&#64;&#64;  .. cpp:var:: int64 shape (repeated)
     *&#64;&#64;
     *&#64;&#64;     The shape to use for reshaping.
     *&#64;&#64;
     * </pre>
     *
     * <code>repeated int64 shape = 1;</code>
     * @return A list containing the shape.
     */
    java.util.List<java.lang.Long> getShapeList();
    /**
     * <pre>
     *&#64;&#64;  .. cpp:var:: int64 shape (repeated)
     *&#64;&#64;
     *&#64;&#64;     The shape to use for reshaping.
     *&#64;&#64;
     * </pre>
     *
     * <code>repeated int64 shape = 1;</code>
     * @return The count of shape.
     */
    int getShapeCount();
    /**
     * <pre>
     *&#64;&#64;  .. cpp:var:: int64 shape (repeated)
     *&#64;&#64;
     *&#64;&#64;     The shape to use for reshaping.
     *&#64;&#64;
     * </pre>
     *
     * <code>repeated int64 shape = 1;</code>
     * @param index The index of the element to return.
     * @return The shape at the given index.
     */
    long getShape(int index);
  }
  /**
   * <pre>
   *&#64;&#64;
   *&#64;&#64;.. cpp:var:: message ModelTensorReshape
   *&#64;&#64;
   *&#64;&#64;   Reshape specification for input and output tensors.
   *&#64;&#64;
   * </pre>
   *
   * Protobuf type {@code inference.ModelTensorReshape}
   */
  public static final class ModelTensorReshape extends
      com.google.protobuf.GeneratedMessageV3 implements
      // @@protoc_insertion_point(message_implements:inference.ModelTensorReshape)
      ModelTensorReshapeOrBuilder {
  private static final long serialVersionUID = 0L;
    // Use ModelTensorReshape.newBuilder() to construct.
    private ModelTensorReshape(com.google.protobuf.GeneratedMessageV3.Builder<?> builder) {
      super(builder);
    }
    private ModelTensorReshape() {
      shape_ = emptyLongList();
    }

    @java.lang.Override
    @SuppressWarnings({"unused"})
    protected java.lang.Object newInstance(
        UnusedPrivateParameter unused) {
      return new ModelTensorReshape();
    }

    @java.lang.Override
    public final com.google.protobuf.UnknownFieldSet
    getUnknownFields() {
      return this.unknownFields;
    }
    private ModelTensorReshape(
        com.google.protobuf.CodedInputStream input,
        com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws com.google.protobuf.InvalidProtocolBufferException {
      this();
      if (extensionRegistry == null) {
        throw new java.lang.NullPointerException();
      }
      int mutable_bitField0_ = 0;
      com.google.protobuf.UnknownFieldSet.Builder unknownFields =
          com.google.protobuf.UnknownFieldSet.newBuilder();
      try {
        boolean done = false;
        while (!done) {
          int tag = input.readTag();
          switch (tag) {
            case 0:
              done = true;
              break;
            case 8: {
              if (!((mutable_bitField0_ & 0x00000001) != 0)) {
                shape_ = newLongList();
                mutable_bitField0_ |= 0x00000001;
              }
              shape_.addLong(input.readInt64());
              break;
            }
            case 10: {
              int length = input.readRawVarint32();
              int limit = input.pushLimit(length);
              if (!((mutable_bitField0_ & 0x00000001) != 0) && input.getBytesUntilLimit() > 0) {
                shape_ = newLongList();
                mutable_bitField0_ |= 0x00000001;
              }
              while (input.getBytesUntilLimit() > 0) {
                shape_.addLong(input.readInt64());
              }
              input.popLimit(limit);
              break;
            }
            default: {
              if (!parseUnknownField(
                  input, unknownFields, extensionRegistry, tag)) {
                done = true;
              }
              break;
            }
          }
        }
      } catch (com.google.protobuf.InvalidProtocolBufferException e) {
        throw e.setUnfinishedMessage(this);
      } catch (java.io.IOException e) {
        throw new com.google.protobuf.InvalidProtocolBufferException(
            e).setUnfinishedMessage(this);
      } finally {
        if (((mutable_bitField0_ & 0x00000001) != 0)) {
          shape_.makeImmutable(); // C
        }
        this.unknownFields = unknownFields.build();
        makeExtensionsImmutable();
      }
    }
    public static final com.google.protobuf.Descriptors.Descriptor
        getDescriptor() {
      return org.apache.submarine.server.api.proto.TritonModelConfig.internal_static_inference_ModelTensorReshape_descriptor;
    }

    @java.lang.Override
    protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
        internalGetFieldAccessorTable() {
      return org.apache.submarine.server.api.proto.TritonModelConfig.internal_static_inference_ModelTensorReshape_fieldAccessorTable
          .ensureFieldAccessorsInitialized(
              org.apache.submarine.server.api.proto.TritonModelConfig.ModelTensorReshape.class, org.apache.submarine.server.api.proto.TritonModelConfig.ModelTensorReshape.Builder.class);
    }

    public static final int SHAPE_FIELD_NUMBER = 1;
    private com.google.protobuf.Internal.LongList shape_;
    /**
     * <pre>
     *&#64;&#64;  .. cpp:var:: int64 shape (repeated)
     *&#64;&#64;
     *&#64;&#64;     The shape to use for reshaping.
     *&#64;&#64;
     * </pre>
     *
     * <code>repeated int64 shape = 1;</code>
     * @return A list containing the shape.
     */
    @java.lang.Override
    public java.util.List<java.lang.Long>
        getShapeList() {
      return shape_;
    }
    /**
     * <pre>
     *&#64;&#64;  .. cpp:var:: int64 shape (repeated)
     *&#64;&#64;
     *&#64;&#64;     The shape to use for reshaping.
     *&#64;&#64;
     * </pre>
     *
     * <code>repeated int64 shape = 1;</code>
     * @return The count of shape.
     */
    public int getShapeCount() {
      return shape_.size();
    }
    /**
     * <pre>
     *&#64;&#64;  .. cpp:var:: int64 shape (repeated)
     *&#64;&#64;
     *&#64;&#64;     The shape to use for reshaping.
     *&#64;&#64;
     * </pre>
     *
     * <code>repeated int64 shape = 1;</code>
     * @param index The index of the element to return.
     * @return The shape at the given index.
     */
    public long getShape(int index) {
      return shape_.getLong(index);
    }
    private int shapeMemoizedSerializedSize = -1;

    private byte memoizedIsInitialized = -1;
    @java.lang.Override
    public final boolean isInitialized() {
      byte isInitialized = memoizedIsInitialized;
      if (isInitialized == 1) return true;
      if (isInitialized == 0) return false;

      memoizedIsInitialized = 1;
      return true;
    }

    @java.lang.Override
    public void writeTo(com.google.protobuf.CodedOutputStream output)
                        throws java.io.IOException {
      getSerializedSize();
      if (getShapeList().size() > 0) {
        output.writeUInt32NoTag(10);
        output.writeUInt32NoTag(shapeMemoizedSerializedSize);
      }
      for (int i = 0; i < shape_.size(); i++) {
        output.writeInt64NoTag(shape_.getLong(i));
      }
      unknownFields.writeTo(output);
    }

    @java.lang.Override
    public int getSerializedSize() {
      int size = memoizedSize;
      if (size != -1) return size;

      size = 0;
      {
        int dataSize = 0;
        for (int i = 0; i < shape_.size(); i++) {
          dataSize += com.google.protobuf.CodedOutputStream
            .computeInt64SizeNoTag(shape_.getLong(i));
        }
        size += dataSize;
        if (!getShapeList().isEmpty()) {
          size += 1;
          size += com.google.protobuf.CodedOutputStream
              .computeInt32SizeNoTag(dataSize);
        }
        shapeMemoizedSerializedSize = dataSize;
      }
      size += unknownFields.getSerializedSize();
      memoizedSize = size;
      return size;
    }

    @java.lang.Override
    public boolean equals(final java.lang.Object obj) {
      if (obj == this) {
       return true;
      }
      if (!(obj instanceof org.apache.submarine.server.api.proto.TritonModelConfig.ModelTensorReshape)) {
        return super.equals(obj);
      }
      org.apache.submarine.server.api.proto.TritonModelConfig.ModelTensorReshape other = (org.apache.submarine.server.api.proto.TritonModelConfig.ModelTensorReshape) obj;

      if (!getShapeList()
          .equals(other.getShapeList())) return false;
      if (!unknownFields.equals(other.unknownFields)) return false;
      return true;
    }

    @java.lang.Override
    public int hashCode() {
      if (memoizedHashCode != 0) {
        return memoizedHashCode;
      }
      int hash = 41;
      hash = (19 * hash) + getDescriptor().hashCode();
      if (getShapeCount() > 0) {
        hash = (37 * hash) + SHAPE_FIELD_NUMBER;
        hash = (53 * hash) + getShapeList().hashCode();
      }
      hash = (29 * hash) + unknownFields.hashCode();
      memoizedHashCode = hash;
      return hash;
    }

    public static org.apache.submarine.server.api.proto.TritonModelConfig.ModelTensorReshape parseFrom(
        java.nio.ByteBuffer data)
        throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data);
    }
    public static org.apache.submarine.server.api.proto.TritonModelConfig.ModelTensorReshape parseFrom(
        java.nio.ByteBuffer data,
        com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data, extensionRegistry);
    }
    public static org.apache.submarine.server.api.proto.TritonModelConfig.ModelTensorReshape parseFrom(
        com.google.protobuf.ByteString data)
        throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data);
    }
    public static org.apache.submarine.server.api.proto.TritonModelConfig.ModelTensorReshape parseFrom(
        com.google.protobuf.ByteString data,
        com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data, extensionRegistry);
    }
    public static org.apache.submarine.server.api.proto.TritonModelConfig.ModelTensorReshape parseFrom(byte[] data)
        throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data);
    }
    public static org.apache.submarine.server.api.proto.TritonModelConfig.ModelTensorReshape parseFrom(
        byte[] data,
        com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data, extensionRegistry);
    }
    public static org.apache.submarine.server.api.proto.TritonModelConfig.ModelTensorReshape parseFrom(java.io.InputStream input)
        throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3
          .parseWithIOException(PARSER, input);
    }
    public static org.apache.submarine.server.api.proto.TritonModelConfig.ModelTensorReshape parseFrom(
        java.io.InputStream input,
        com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3
          .parseWithIOException(PARSER, input, extensionRegistry);
    }
    public static org.apache.submarine.server.api.proto.TritonModelConfig.ModelTensorReshape parseDelimitedFrom(java.io.InputStream input)
        throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3
          .parseDelimitedWithIOException(PARSER, input);
    }
    public static org.apache.submarine.server.api.proto.TritonModelConfig.ModelTensorReshape parseDelimitedFrom(
        java.io.InputStream input,
        com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3
          .parseDelimitedWithIOException(PARSER, input, extensionRegistry);
    }
    public static org.apache.submarine.server.api.proto.TritonModelConfig.ModelTensorReshape parseFrom(
        com.google.protobuf.CodedInputStream input)
        throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3
          .parseWithIOException(PARSER, input);
    }
    public static org.apache.submarine.server.api.proto.TritonModelConfig.ModelTensorReshape parseFrom(
        com.google.protobuf.CodedInputStream input,
        com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3
          .parseWithIOException(PARSER, input, extensionRegistry);
    }

    @java.lang.Override
    public Builder newBuilderForType() { return newBuilder(); }
    public static Builder newBuilder() {
      return DEFAULT_INSTANCE.toBuilder();
    }
    public static Builder newBuilder(org.apache.submarine.server.api.proto.TritonModelConfig.ModelTensorReshape prototype) {
      return DEFAULT_INSTANCE.toBuilder().mergeFrom(prototype);
    }
    @java.lang.Override
    public Builder toBuilder() {
      return this == DEFAULT_INSTANCE
          ? new Builder() : new Builder().mergeFrom(this);
    }

    @java.lang.Override
    protected Builder newBuilderForType(
        com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
      Builder builder = new Builder(parent);
      return builder;
    }
    /**
     * <pre>
     *&#64;&#64;
     *&#64;&#64;.. cpp:var:: message ModelTensorReshape
     *&#64;&#64;
     *&#64;&#64;   Reshape specification for input and output tensors.
     *&#64;&#64;
     * </pre>
     *
     * Protobuf type {@code inference.ModelTensorReshape}
     */
    public static final class Builder extends
        com.google.protobuf.GeneratedMessageV3.Builder<Builder> implements
        // @@protoc_insertion_point(builder_implements:inference.ModelTensorReshape)
        org.apache.submarine.server.api.proto.TritonModelConfig.ModelTensorReshapeOrBuilder {
      public static final com.google.protobuf.Descriptors.Descriptor
          getDescriptor() {
        return org.apache.submarine.server.api.proto.TritonModelConfig.internal_static_inference_ModelTensorReshape_descriptor;
      }

      @java.lang.Override
      protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
          internalGetFieldAccessorTable() {
        return org.apache.submarine.server.api.proto.TritonModelConfig.internal_static_inference_ModelTensorReshape_fieldAccessorTable
            .ensureFieldAccessorsInitialized(
                org.apache.submarine.server.api.proto.TritonModelConfig.ModelTensorReshape.class, org.apache.submarine.server.api.proto.TritonModelConfig.ModelTensorReshape.Builder.class);
      }

      // Construct using org.apache.submarine.server.api.proto.TritonModelConfig.ModelTensorReshape.newBuilder()
      private Builder() {
        maybeForceBuilderInitialization();
      }

      private Builder(
          com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
        super(parent);
        maybeForceBuilderInitialization();
      }
      private void maybeForceBuilderInitialization() {
        if (com.google.protobuf.GeneratedMessageV3
                .alwaysUseFieldBuilders) {
        }
      }
      @java.lang.Override
      public Builder clear() {
        super.clear();
        shape_ = emptyLongList();
        bitField0_ = (bitField0_ & ~0x00000001);
        return this;
      }

      @java.lang.Override
      public com.google.protobuf.Descriptors.Descriptor
          getDescriptorForType() {
        return org.apache.submarine.server.api.proto.TritonModelConfig.internal_static_inference_ModelTensorReshape_descriptor;
      }

      @java.lang.Override
      public org.apache.submarine.server.api.proto.TritonModelConfig.ModelTensorReshape getDefaultInstanceForType() {
        return org.apache.submarine.server.api.proto.TritonModelConfig.ModelTensorReshape.getDefaultInstance();
      }

      @java.lang.Override
      public org.apache.submarine.server.api.proto.TritonModelConfig.ModelTensorReshape build() {
        org.apache.submarine.server.api.proto.TritonModelConfig.ModelTensorReshape result = buildPartial();
        if (!result.isInitialized()) {
          throw newUninitializedMessageException(result);
        }
        return result;
      }

      @java.lang.Override
      public org.apache.submarine.server.api.proto.TritonModelConfig.ModelTensorReshape buildPartial() {
        org.apache.submarine.server.api.proto.TritonModelConfig.ModelTensorReshape result = new org.apache.submarine.server.api.proto.TritonModelConfig.ModelTensorReshape(this);
        int from_bitField0_ = bitField0_;
        if (((bitField0_ & 0x00000001) != 0)) {
          shape_.makeImmutable();
          bitField0_ = (bitField0_ & ~0x00000001);
        }
        result.shape_ = shape_;
        onBuilt();
        return result;
      }

      @java.lang.Override
      public Builder clone() {
        return super.clone();
      }
      @java.lang.Override
      public Builder setField(
          com.google.protobuf.Descriptors.FieldDescriptor field,
          java.lang.Object value) {
        return super.setField(field, value);
      }
      @java.lang.Override
      public Builder clearField(
          com.google.protobuf.Descriptors.FieldDescriptor field) {
        return super.clearField(field);
      }
      @java.lang.Override
      public Builder clearOneof(
          com.google.protobuf.Descriptors.OneofDescriptor oneof) {
        return super.clearOneof(oneof);
      }
      @java.lang.Override
      public Builder setRepeatedField(
          com.google.protobuf.Descriptors.FieldDescriptor field,
          int index, java.lang.Object value) {
        return super.setRepeatedField(field, index, value);
      }
      @java.lang.Override
      public Builder addRepeatedField(
          com.google.protobuf.Descriptors.FieldDescriptor field,
          java.lang.Object value) {
        return super.addRepeatedField(field, value);
      }
      @java.lang.Override
      public Builder mergeFrom(com.google.protobuf.Message other) {
        if (other instanceof org.apache.submarine.server.api.proto.TritonModelConfig.ModelTensorReshape) {
          return mergeFrom((org.apache.submarine.server.api.proto.TritonModelConfig.ModelTensorReshape)other);
        } else {
          super.mergeFrom(other);
          return this;
        }
      }

      public Builder mergeFrom(org.apache.submarine.server.api.proto.TritonModelConfig.ModelTensorReshape other) {
        if (other == org.apache.submarine.server.api.proto.TritonModelConfig.ModelTensorReshape.getDefaultInstance()) return this;
        if (!other.shape_.isEmpty()) {
          if (shape_.isEmpty()) {
            shape_ = other.shape_;
            bitField0_ = (bitField0_ & ~0x00000001);
          } else {
            ensureShapeIsMutable();
            shape_.addAll(other.shape_);
          }
          onChanged();
        }
        this.mergeUnknownFields(other.unknownFields);
        onChanged();
        return this;
      }

      @java.lang.Override
      public final boolean isInitialized() {
        return true;
      }

      @java.lang.Override
      public Builder mergeFrom(
          com.google.protobuf.CodedInputStream input,
          com.google.protobuf.ExtensionRegistryLite extensionRegistry)
          throws java.io.IOException {
        org.apache.submarine.server.api.proto.TritonModelConfig.ModelTensorReshape parsedMessage = null;
        try {
          parsedMessage = PARSER.parsePartialFrom(input, extensionRegistry);
        } catch (com.google.protobuf.InvalidProtocolBufferException e) {
          parsedMessage = (org.apache.submarine.server.api.proto.TritonModelConfig.ModelTensorReshape) e.getUnfinishedMessage();
          throw e.unwrapIOException();
        } finally {
          if (parsedMessage != null) {
            mergeFrom(parsedMessage);
          }
        }
        return this;
      }
      private int bitField0_;

      private com.google.protobuf.Internal.LongList shape_ = emptyLongList();
      private void ensureShapeIsMutable() {
        if (!((bitField0_ & 0x00000001) != 0)) {
          shape_ = mutableCopy(shape_);
          bitField0_ |= 0x00000001;
         }
      }
      /**
       * <pre>
       *&#64;&#64;  .. cpp:var:: int64 shape (repeated)
       *&#64;&#64;
       *&#64;&#64;     The shape to use for reshaping.
       *&#64;&#64;
       * </pre>
       *
       * <code>repeated int64 shape = 1;</code>
       * @return A list containing the shape.
       */
      public java.util.List<java.lang.Long>
          getShapeList() {
        return ((bitField0_ & 0x00000001) != 0) ?
                 java.util.Collections.unmodifiableList(shape_) : shape_;
      }
      /**
       * <pre>
       *&#64;&#64;  .. cpp:var:: int64 shape (repeated)
       *&#64;&#64;
       *&#64;&#64;     The shape to use for reshaping.
       *&#64;&#64;
       * </pre>
       *
       * <code>repeated int64 shape = 1;</code>
       * @return The count of shape.
       */
      public int getShapeCount() {
        return shape_.size();
      }
      /**
       * <pre>
       *&#64;&#64;  .. cpp:var:: int64 shape (repeated)
       *&#64;&#64;
       *&#64;&#64;     The shape to use for reshaping.
       *&#64;&#64;
       * </pre>
       *
       * <code>repeated int64 shape = 1;</code>
       * @param index The index of the element to return.
       * @return The shape at the given index.
       */
      public long getShape(int index) {
        return shape_.getLong(index);
      }
      /**
       * <pre>
       *&#64;&#64;  .. cpp:var:: int64 shape (repeated)
       *&#64;&#64;
       *&#64;&#64;     The shape to use for reshaping.
       *&#64;&#64;
       * </pre>
       *
       * <code>repeated int64 shape = 1;</code>
       * @param index The index to set the value at.
       * @param value The shape to set.
       * @return This builder for chaining.
       */
      public Builder setShape(
          int index, long value) {
        ensureShapeIsMutable();
        shape_.setLong(index, value);
        onChanged();
        return this;
      }
      /**
       * <pre>
       *&#64;&#64;  .. cpp:var:: int64 shape (repeated)
       *&#64;&#64;
       *&#64;&#64;     The shape to use for reshaping.
       *&#64;&#64;
       * </pre>
       *
       * <code>repeated int64 shape = 1;</code>
       * @param value The shape to add.
       * @return This builder for chaining.
       */
      public Builder addShape(long value) {
        ensureShapeIsMutable();
        shape_.addLong(value);
        onChanged();
        return this;
      }
      /**
       * <pre>
       *&#64;&#64;  .. cpp:var:: int64 shape (repeated)
       *&#64;&#64;
       *&#64;&#64;     The shape to use for reshaping.
       *&#64;&#64;
       * </pre>
       *
       * <code>repeated int64 shape = 1;</code>
       * @param values The shape to add.
       * @return This builder for chaining.
       */
      public Builder addAllShape(
          java.lang.Iterable<? extends java.lang.Long> values) {
        ensureShapeIsMutable();
        com.google.protobuf.AbstractMessageLite.Builder.addAll(
            values, shape_);
        onChanged();
        return this;
      }
      /**
       * <pre>
       *&#64;&#64;  .. cpp:var:: int64 shape (repeated)
       *&#64;&#64;
       *&#64;&#64;     The shape to use for reshaping.
       *&#64;&#64;
       * </pre>
       *
       * <code>repeated int64 shape = 1;</code>
       * @return This builder for chaining.
       */
      public Builder clearShape() {
        shape_ = emptyLongList();
        bitField0_ = (bitField0_ & ~0x00000001);
        onChanged();
        return this;
      }
      @java.lang.Override
      public final Builder setUnknownFields(
          final com.google.protobuf.UnknownFieldSet unknownFields) {
        return super.setUnknownFields(unknownFields);
      }

      @java.lang.Override
      public final Builder mergeUnknownFields(
          final com.google.protobuf.UnknownFieldSet unknownFields) {
        return super.mergeUnknownFields(unknownFields);
      }


      // @@protoc_insertion_point(builder_scope:inference.ModelTensorReshape)
    }

    // @@protoc_insertion_point(class_scope:inference.ModelTensorReshape)
    private static final org.apache.submarine.server.api.proto.TritonModelConfig.ModelTensorReshape DEFAULT_INSTANCE;
    static {
      DEFAULT_INSTANCE = new org.apache.submarine.server.api.proto.TritonModelConfig.ModelTensorReshape();
    }

    public static org.apache.submarine.server.api.proto.TritonModelConfig.ModelTensorReshape getDefaultInstance() {
      return DEFAULT_INSTANCE;
    }

    private static final com.google.protobuf.Parser<ModelTensorReshape>
        PARSER = new com.google.protobuf.AbstractParser<ModelTensorReshape>() {
      @java.lang.Override
      public ModelTensorReshape parsePartialFrom(
          com.google.protobuf.CodedInputStream input,
          com.google.protobuf.ExtensionRegistryLite extensionRegistry)
          throws com.google.protobuf.InvalidProtocolBufferException {
        return new ModelTensorReshape(input, extensionRegistry);
      }
    };

    public static com.google.protobuf.Parser<ModelTensorReshape> parser() {
      return PARSER;
    }

    @java.lang.Override
    public com.google.protobuf.Parser<ModelTensorReshape> getParserForType() {
      return PARSER;
    }

    @java.lang.Override
    public org.apache.submarine.server.api.proto.TritonModelConfig.ModelTensorReshape getDefaultInstanceForType() {
      return DEFAULT_INSTANCE;
    }

  }

  public interface ModelInputOrBuilder extends
      // @@protoc_insertion_point(interface_extends:inference.ModelInput)
      com.google.protobuf.MessageOrBuilder {

    /**
     * <pre>
     *&#64;&#64;  .. cpp:var:: string name
     *&#64;&#64;
     *&#64;&#64;     The name of the input.
     *&#64;&#64;
     * </pre>
     *
     * <code>string name = 1;</code>
     * @return The name.
     */
    java.lang.String getName();
    /**
     * <pre>
     *&#64;&#64;  .. cpp:var:: string name
     *&#64;&#64;
     *&#64;&#64;     The name of the input.
     *&#64;&#64;
     * </pre>
     *
     * <code>string name = 1;</code>
     * @return The bytes for name.
     */
    com.google.protobuf.ByteString
        getNameBytes();

    /**
     * <pre>
     *&#64;&#64;  .. cpp:var:: DataType data_type
     *&#64;&#64;
     *&#64;&#64;     The data-type of the input.
     *&#64;&#64;
     * </pre>
     *
     * <code>.inference.DataType data_type = 2;</code>
     * @return The enum numeric value on the wire for dataType.
     */
    int getDataTypeValue();
    /**
     * <pre>
     *&#64;&#64;  .. cpp:var:: DataType data_type
     *&#64;&#64;
     *&#64;&#64;     The data-type of the input.
     *&#64;&#64;
     * </pre>
     *
     * <code>.inference.DataType data_type = 2;</code>
     * @return The dataType.
     */
    org.apache.submarine.server.api.proto.TritonModelConfig.DataType getDataType();

    /**
     * <pre>
     *&#64;&#64;  .. cpp:var:: Format format
     *&#64;&#64;
     *&#64;&#64;     The format of the input. Optional.
     *&#64;&#64;
     * </pre>
     *
     * <code>.inference.ModelInput.Format format = 3;</code>
     * @return The enum numeric value on the wire for format.
     */
    int getFormatValue();
    /**
     * <pre>
     *&#64;&#64;  .. cpp:var:: Format format
     *&#64;&#64;
     *&#64;&#64;     The format of the input. Optional.
     *&#64;&#64;
     * </pre>
     *
     * <code>.inference.ModelInput.Format format = 3;</code>
     * @return The format.
     */
    org.apache.submarine.server.api.proto.TritonModelConfig.ModelInput.Format getFormat();

    /**
     * <pre>
     *&#64;&#64;  .. cpp:var:: int64 dims (repeated)
     *&#64;&#64;
     *&#64;&#64;     The dimensions/shape of the input tensor that must be provided
     *&#64;&#64;     when invoking the inference API for this model.
     *&#64;&#64;
     * </pre>
     *
     * <code>repeated int64 dims = 4;</code>
     * @return A list containing the dims.
     */
    java.util.List<java.lang.Long> getDimsList();
    /**
     * <pre>
     *&#64;&#64;  .. cpp:var:: int64 dims (repeated)
     *&#64;&#64;
     *&#64;&#64;     The dimensions/shape of the input tensor that must be provided
     *&#64;&#64;     when invoking the inference API for this model.
     *&#64;&#64;
     * </pre>
     *
     * <code>repeated int64 dims = 4;</code>
     * @return The count of dims.
     */
    int getDimsCount();
    /**
     * <pre>
     *&#64;&#64;  .. cpp:var:: int64 dims (repeated)
     *&#64;&#64;
     *&#64;&#64;     The dimensions/shape of the input tensor that must be provided
     *&#64;&#64;     when invoking the inference API for this model.
     *&#64;&#64;
     * </pre>
     *
     * <code>repeated int64 dims = 4;</code>
     * @param index The index of the element to return.
     * @return The dims at the given index.
     */
    long getDims(int index);

    /**
     * <pre>
     *&#64;&#64;  .. cpp:var:: ModelTensorReshape reshape
     *&#64;&#64;
     *&#64;&#64;     The shape expected for this input by the backend. The input will
     *&#64;&#64;     be reshaped to this before being presented to the backend. The
     *&#64;&#64;     reshape must have the same number of elements as the input shape
     *&#64;&#64;     specified by 'dims'. Optional.
     *&#64;&#64;
     * </pre>
     *
     * <code>.inference.ModelTensorReshape reshape = 5;</code>
     * @return Whether the reshape field is set.
     */
    boolean hasReshape();
    /**
     * <pre>
     *&#64;&#64;  .. cpp:var:: ModelTensorReshape reshape
     *&#64;&#64;
     *&#64;&#64;     The shape expected for this input by the backend. The input will
     *&#64;&#64;     be reshaped to this before being presented to the backend. The
     *&#64;&#64;     reshape must have the same number of elements as the input shape
     *&#64;&#64;     specified by 'dims'. Optional.
     *&#64;&#64;
     * </pre>
     *
     * <code>.inference.ModelTensorReshape reshape = 5;</code>
     * @return The reshape.
     */
    org.apache.submarine.server.api.proto.TritonModelConfig.ModelTensorReshape getReshape();
    /**
     * <pre>
     *&#64;&#64;  .. cpp:var:: ModelTensorReshape reshape
     *&#64;&#64;
     *&#64;&#64;     The shape expected for this input by the backend. The input will
     *&#64;&#64;     be reshaped to this before being presented to the backend. The
     *&#64;&#64;     reshape must have the same number of elements as the input shape
     *&#64;&#64;     specified by 'dims'. Optional.
     *&#64;&#64;
     * </pre>
     *
     * <code>.inference.ModelTensorReshape reshape = 5;</code>
     */
    org.apache.submarine.server.api.proto.TritonModelConfig.ModelTensorReshapeOrBuilder getReshapeOrBuilder();

    /**
     * <pre>
     *&#64;&#64;  .. cpp:var:: bool is_shape_tensor
     *&#64;&#64;
     *&#64;&#64;     Whether or not the input is a shape tensor to the model. This field
     *&#64;&#64;     is currently supported only for the TensorRT model. An error will be
     *&#64;&#64;     generated if this specification does not comply with underlying
     *&#64;&#64;     model.
     *&#64;&#64;
     * </pre>
     *
     * <code>bool is_shape_tensor = 6;</code>
     * @return The isShapeTensor.
     */
    boolean getIsShapeTensor();

    /**
     * <pre>
     *&#64;&#64;  .. cpp:var:: bool allow_ragged_batch
     *&#64;&#64;
     *&#64;&#64;     Whether or not the input is allowed to be "ragged" in a dynamically
     *&#64;&#64;     created batch. Default is false indicating that two requests will
     *&#64;&#64;     only be batched if this tensor has the same shape in both requests.
     *&#64;&#64;     True indicates that two requests can be batched even if this tensor
     *&#64;&#64;     has a different shape in each request.
     *&#64;&#64;
     * </pre>
     *
     * <code>bool allow_ragged_batch = 7;</code>
     * @return The allowRaggedBatch.
     */
    boolean getAllowRaggedBatch();

    /**
     * <pre>
     *&#64;&#64;  .. cpp:var:: bool optional
     *&#64;&#64;
     *&#64;&#64;     Whether or not the input is optional for the model execution.
     *&#64;&#64;     If true, the input is not required in the inference request.
     *&#64;&#64;     Default value is false.
     *&#64;&#64;
     * </pre>
     *
     * <code>bool optional = 8;</code>
     * @return The optional.
     */
    boolean getOptional();
  }
  /**
   * <pre>
   *&#64;&#64;
   *&#64;&#64;.. cpp:var:: message ModelInput
   *&#64;&#64;
   *&#64;&#64;   An input required by the model.
   *&#64;&#64;
   * </pre>
   *
   * Protobuf type {@code inference.ModelInput}
   */
  public static final class ModelInput extends
      com.google.protobuf.GeneratedMessageV3 implements
      // @@protoc_insertion_point(message_implements:inference.ModelInput)
      ModelInputOrBuilder {
  private static final long serialVersionUID = 0L;
    // Use ModelInput.newBuilder() to construct.
    private ModelInput(com.google.protobuf.GeneratedMessageV3.Builder<?> builder) {
      super(builder);
    }
    private ModelInput() {
      name_ = "";
      dataType_ = 0;
      format_ = 0;
      dims_ = emptyLongList();
    }

    @java.lang.Override
    @SuppressWarnings({"unused"})
    protected java.lang.Object newInstance(
        UnusedPrivateParameter unused) {
      return new ModelInput();
    }

    @java.lang.Override
    public final com.google.protobuf.UnknownFieldSet
    getUnknownFields() {
      return this.unknownFields;
    }
    private ModelInput(
        com.google.protobuf.CodedInputStream input,
        com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws com.google.protobuf.InvalidProtocolBufferException {
      this();
      if (extensionRegistry == null) {
        throw new java.lang.NullPointerException();
      }
      int mutable_bitField0_ = 0;
      com.google.protobuf.UnknownFieldSet.Builder unknownFields =
          com.google.protobuf.UnknownFieldSet.newBuilder();
      try {
        boolean done = false;
        while (!done) {
          int tag = input.readTag();
          switch (tag) {
            case 0:
              done = true;
              break;
            case 10: {
              java.lang.String s = input.readStringRequireUtf8();

              name_ = s;
              break;
            }
            case 16: {
              int rawValue = input.readEnum();

              dataType_ = rawValue;
              break;
            }
            case 24: {
              int rawValue = input.readEnum();

              format_ = rawValue;
              break;
            }
            case 32: {
              if (!((mutable_bitField0_ & 0x00000001) != 0)) {
                dims_ = newLongList();
                mutable_bitField0_ |= 0x00000001;
              }
              dims_.addLong(input.readInt64());
              break;
            }
            case 34: {
              int length = input.readRawVarint32();
              int limit = input.pushLimit(length);
              if (!((mutable_bitField0_ & 0x00000001) != 0) && input.getBytesUntilLimit() > 0) {
                dims_ = newLongList();
                mutable_bitField0_ |= 0x00000001;
              }
              while (input.getBytesUntilLimit() > 0) {
                dims_.addLong(input.readInt64());
              }
              input.popLimit(limit);
              break;
            }
            case 42: {
              org.apache.submarine.server.api.proto.TritonModelConfig.ModelTensorReshape.Builder subBuilder = null;
              if (reshape_ != null) {
                subBuilder = reshape_.toBuilder();
              }
              reshape_ = input.readMessage(org.apache.submarine.server.api.proto.TritonModelConfig.ModelTensorReshape.parser(), extensionRegistry);
              if (subBuilder != null) {
                subBuilder.mergeFrom(reshape_);
                reshape_ = subBuilder.buildPartial();
              }

              break;
            }
            case 48: {

              isShapeTensor_ = input.readBool();
              break;
            }
            case 56: {

              allowRaggedBatch_ = input.readBool();
              break;
            }
            case 64: {

              optional_ = input.readBool();
              break;
            }
            default: {
              if (!parseUnknownField(
                  input, unknownFields, extensionRegistry, tag)) {
                done = true;
              }
              break;
            }
          }
        }
      } catch (com.google.protobuf.InvalidProtocolBufferException e) {
        throw e.setUnfinishedMessage(this);
      } catch (java.io.IOException e) {
        throw new com.google.protobuf.InvalidProtocolBufferException(
            e).setUnfinishedMessage(this);
      } finally {
        if (((mutable_bitField0_ & 0x00000001) != 0)) {
          dims_.makeImmutable(); // C
        }
        this.unknownFields = unknownFields.build();
        makeExtensionsImmutable();
      }
    }
    public static final com.google.protobuf.Descriptors.Descriptor
        getDescriptor() {
      return org.apache.submarine.server.api.proto.TritonModelConfig.internal_static_inference_ModelInput_descriptor;
    }

    @java.lang.Override
    protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
        internalGetFieldAccessorTable() {
      return org.apache.submarine.server.api.proto.TritonModelConfig.internal_static_inference_ModelInput_fieldAccessorTable
          .ensureFieldAccessorsInitialized(
              org.apache.submarine.server.api.proto.TritonModelConfig.ModelInput.class, org.apache.submarine.server.api.proto.TritonModelConfig.ModelInput.Builder.class);
    }

    /**
     * <pre>
     *&#64;&#64;
     *&#64;&#64;  .. cpp:enum:: Format
     *&#64;&#64;
     *&#64;&#64;     The format for the input.
     *&#64;&#64;
     * </pre>
     *
     * Protobuf enum {@code inference.ModelInput.Format}
     */
    public enum Format
        implements com.google.protobuf.ProtocolMessageEnum {
      /**
       * <pre>
       *&#64;&#64;    .. cpp:enumerator:: Format::FORMAT_NONE = 0
       *&#64;&#64;
       *&#64;&#64;       The input has no specific format. This is the default.
       *&#64;&#64;
       * </pre>
       *
       * <code>FORMAT_NONE = 0;</code>
       */
      FORMAT_NONE(0),
      /**
       * <pre>
       *&#64;&#64;    .. cpp:enumerator:: Format::FORMAT_NHWC = 1
       *&#64;&#64;
       *&#64;&#64;       HWC image format. Tensors with this format require 3 dimensions
       *&#64;&#64;       if the model does not support batching (max_batch_size = 0) or 4
       *&#64;&#64;       dimensions if the model does support batching (max_batch_size
       *&#64;&#64;       &gt;= 1). In either case the 'dims' below should only specify the
       *&#64;&#64;       3 non-batch dimensions (i.e. HWC or CHW).
       *&#64;&#64;
       * </pre>
       *
       * <code>FORMAT_NHWC = 1;</code>
       */
      FORMAT_NHWC(1),
      /**
       * <pre>
       *&#64;&#64;    .. cpp:enumerator:: Format::FORMAT_NCHW = 2
       *&#64;&#64;
       *&#64;&#64;       CHW image format. Tensors with this format require 3 dimensions
       *&#64;&#64;       if the model does not support batching (max_batch_size = 0) or 4
       *&#64;&#64;       dimensions if the model does support batching (max_batch_size
       *&#64;&#64;       &gt;= 1). In either case the 'dims' below should only specify the
       *&#64;&#64;       3 non-batch dimensions (i.e. HWC or CHW).
       *&#64;&#64;
       * </pre>
       *
       * <code>FORMAT_NCHW = 2;</code>
       */
      FORMAT_NCHW(2),
      UNRECOGNIZED(-1),
      ;

      /**
       * <pre>
       *&#64;&#64;    .. cpp:enumerator:: Format::FORMAT_NONE = 0
       *&#64;&#64;
       *&#64;&#64;       The input has no specific format. This is the default.
       *&#64;&#64;
       * </pre>
       *
       * <code>FORMAT_NONE = 0;</code>
       */
      public static final int FORMAT_NONE_VALUE = 0;
      /**
       * <pre>
       *&#64;&#64;    .. cpp:enumerator:: Format::FORMAT_NHWC = 1
       *&#64;&#64;
       *&#64;&#64;       HWC image format. Tensors with this format require 3 dimensions
       *&#64;&#64;       if the model does not support batching (max_batch_size = 0) or 4
       *&#64;&#64;       dimensions if the model does support batching (max_batch_size
       *&#64;&#64;       &gt;= 1). In either case the 'dims' below should only specify the
       *&#64;&#64;       3 non-batch dimensions (i.e. HWC or CHW).
       *&#64;&#64;
       * </pre>
       *
       * <code>FORMAT_NHWC = 1;</code>
       */
      public static final int FORMAT_NHWC_VALUE = 1;
      /**
       * <pre>
       *&#64;&#64;    .. cpp:enumerator:: Format::FORMAT_NCHW = 2
       *&#64;&#64;
       *&#64;&#64;       CHW image format. Tensors with this format require 3 dimensions
       *&#64;&#64;       if the model does not support batching (max_batch_size = 0) or 4
       *&#64;&#64;       dimensions if the model does support batching (max_batch_size
       *&#64;&#64;       &gt;= 1). In either case the 'dims' below should only specify the
       *&#64;&#64;       3 non-batch dimensions (i.e. HWC or CHW).
       *&#64;&#64;
       * </pre>
       *
       * <code>FORMAT_NCHW = 2;</code>
       */
      public static final int FORMAT_NCHW_VALUE = 2;


      public final int getNumber() {
        if (this == UNRECOGNIZED) {
          throw new java.lang.IllegalArgumentException(
              "Can't get the number of an unknown enum value.");
        }
        return value;
      }

      /**
       * @param value The numeric wire value of the corresponding enum entry.
       * @return The enum associated with the given numeric wire value.
       * @deprecated Use {@link #forNumber(int)} instead.
       */
      @java.lang.Deprecated
      public static Format valueOf(int value) {
        return forNumber(value);
      }

      /**
       * @param value The numeric wire value of the corresponding enum entry.
       * @return The enum associated with the given numeric wire value.
       */
      public static Format forNumber(int value) {
        switch (value) {
          case 0: return FORMAT_NONE;
          case 1: return FORMAT_NHWC;
          case 2: return FORMAT_NCHW;
          default: return null;
        }
      }

      public static com.google.protobuf.Internal.EnumLiteMap<Format>
          internalGetValueMap() {
        return internalValueMap;
      }
      private static final com.google.protobuf.Internal.EnumLiteMap<
          Format> internalValueMap =
            new com.google.protobuf.Internal.EnumLiteMap<Format>() {
              public Format findValueByNumber(int number) {
                return Format.forNumber(number);
              }
            };

      public final com.google.protobuf.Descriptors.EnumValueDescriptor
          getValueDescriptor() {
        if (this == UNRECOGNIZED) {
          throw new java.lang.IllegalStateException(
              "Can't get the descriptor of an unrecognized enum value.");
        }
        return getDescriptor().getValues().get(ordinal());
      }
      public final com.google.protobuf.Descriptors.EnumDescriptor
          getDescriptorForType() {
        return getDescriptor();
      }
      public static final com.google.protobuf.Descriptors.EnumDescriptor
          getDescriptor() {
        return org.apache.submarine.server.api.proto.TritonModelConfig.ModelInput.getDescriptor().getEnumTypes().get(0);
      }

      private static final Format[] VALUES = values();

      public static Format valueOf(
          com.google.protobuf.Descriptors.EnumValueDescriptor desc) {
        if (desc.getType() != getDescriptor()) {
          throw new java.lang.IllegalArgumentException(
            "EnumValueDescriptor is not for this type.");
        }
        if (desc.getIndex() == -1) {
          return UNRECOGNIZED;
        }
        return VALUES[desc.getIndex()];
      }

      private final int value;

      private Format(int value) {
        this.value = value;
      }

      // @@protoc_insertion_point(enum_scope:inference.ModelInput.Format)
    }

    public static final int NAME_FIELD_NUMBER = 1;
    private volatile java.lang.Object name_;
    /**
     * <pre>
     *&#64;&#64;  .. cpp:var:: string name
     *&#64;&#64;
     *&#64;&#64;     The name of the input.
     *&#64;&#64;
     * </pre>
     *
     * <code>string name = 1;</code>
     * @return The name.
     */
    @java.lang.Override
    public java.lang.String getName() {
      java.lang.Object ref = name_;
      if (ref instanceof java.lang.String) {
        return (java.lang.String) ref;
      } else {
        com.google.protobuf.ByteString bs = 
            (com.google.protobuf.ByteString) ref;
        java.lang.String s = bs.toStringUtf8();
        name_ = s;
        return s;
      }
    }
    /**
     * <pre>
     *&#64;&#64;  .. cpp:var:: string name
     *&#64;&#64;
     *&#64;&#64;     The name of the input.
     *&#64;&#64;
     * </pre>
     *
     * <code>string name = 1;</code>
     * @return The bytes for name.
     */
    @java.lang.Override
    public com.google.protobuf.ByteString
        getNameBytes() {
      java.lang.Object ref = name_;
      if (ref instanceof java.lang.String) {
        com.google.protobuf.ByteString b = 
            com.google.protobuf.ByteString.copyFromUtf8(
                (java.lang.String) ref);
        name_ = b;
        return b;
      } else {
        return (com.google.protobuf.ByteString) ref;
      }
    }

    public static final int DATA_TYPE_FIELD_NUMBER = 2;
    private int dataType_;
    /**
     * <pre>
     *&#64;&#64;  .. cpp:var:: DataType data_type
     *&#64;&#64;
     *&#64;&#64;     The data-type of the input.
     *&#64;&#64;
     * </pre>
     *
     * <code>.inference.DataType data_type = 2;</code>
     * @return The enum numeric value on the wire for dataType.
     */
    @java.lang.Override public int getDataTypeValue() {
      return dataType_;
    }
    /**
     * <pre>
     *&#64;&#64;  .. cpp:var:: DataType data_type
     *&#64;&#64;
     *&#64;&#64;     The data-type of the input.
     *&#64;&#64;
     * </pre>
     *
     * <code>.inference.DataType data_type = 2;</code>
     * @return The dataType.
     */
    @java.lang.Override public org.apache.submarine.server.api.proto.TritonModelConfig.DataType getDataType() {
      @SuppressWarnings("deprecation")
      org.apache.submarine.server.api.proto.TritonModelConfig.DataType result = org.apache.submarine.server.api.proto.TritonModelConfig.DataType.valueOf(dataType_);
      return result == null ? org.apache.submarine.server.api.proto.TritonModelConfig.DataType.UNRECOGNIZED : result;
    }

    public static final int FORMAT_FIELD_NUMBER = 3;
    private int format_;
    /**
     * <pre>
     *&#64;&#64;  .. cpp:var:: Format format
     *&#64;&#64;
     *&#64;&#64;     The format of the input. Optional.
     *&#64;&#64;
     * </pre>
     *
     * <code>.inference.ModelInput.Format format = 3;</code>
     * @return The enum numeric value on the wire for format.
     */
    @java.lang.Override public int getFormatValue() {
      return format_;
    }
    /**
     * <pre>
     *&#64;&#64;  .. cpp:var:: Format format
     *&#64;&#64;
     *&#64;&#64;     The format of the input. Optional.
     *&#64;&#64;
     * </pre>
     *
     * <code>.inference.ModelInput.Format format = 3;</code>
     * @return The format.
     */
    @java.lang.Override public org.apache.submarine.server.api.proto.TritonModelConfig.ModelInput.Format getFormat() {
      @SuppressWarnings("deprecation")
      org.apache.submarine.server.api.proto.TritonModelConfig.ModelInput.Format result = org.apache.submarine.server.api.proto.TritonModelConfig.ModelInput.Format.valueOf(format_);
      return result == null ? org.apache.submarine.server.api.proto.TritonModelConfig.ModelInput.Format.UNRECOGNIZED : result;
    }

    public static final int DIMS_FIELD_NUMBER = 4;
    private com.google.protobuf.Internal.LongList dims_;
    /**
     * <pre>
     *&#64;&#64;  .. cpp:var:: int64 dims (repeated)
     *&#64;&#64;
     *&#64;&#64;     The dimensions/shape of the input tensor that must be provided
     *&#64;&#64;     when invoking the inference API for this model.
     *&#64;&#64;
     * </pre>
     *
     * <code>repeated int64 dims = 4;</code>
     * @return A list containing the dims.
     */
    @java.lang.Override
    public java.util.List<java.lang.Long>
        getDimsList() {
      return dims_;
    }
    /**
     * <pre>
     *&#64;&#64;  .. cpp:var:: int64 dims (repeated)
     *&#64;&#64;
     *&#64;&#64;     The dimensions/shape of the input tensor that must be provided
     *&#64;&#64;     when invoking the inference API for this model.
     *&#64;&#64;
     * </pre>
     *
     * <code>repeated int64 dims = 4;</code>
     * @return The count of dims.
     */
    public int getDimsCount() {
      return dims_.size();
    }
    /**
     * <pre>
     *&#64;&#64;  .. cpp:var:: int64 dims (repeated)
     *&#64;&#64;
     *&#64;&#64;     The dimensions/shape of the input tensor that must be provided
     *&#64;&#64;     when invoking the inference API for this model.
     *&#64;&#64;
     * </pre>
     *
     * <code>repeated int64 dims = 4;</code>
     * @param index The index of the element to return.
     * @return The dims at the given index.
     */
    public long getDims(int index) {
      return dims_.getLong(index);
    }
    private int dimsMemoizedSerializedSize = -1;

    public static final int RESHAPE_FIELD_NUMBER = 5;
    private org.apache.submarine.server.api.proto.TritonModelConfig.ModelTensorReshape reshape_;
    /**
     * <pre>
     *&#64;&#64;  .. cpp:var:: ModelTensorReshape reshape
     *&#64;&#64;
     *&#64;&#64;     The shape expected for this input by the backend. The input will
     *&#64;&#64;     be reshaped to this before being presented to the backend. The
     *&#64;&#64;     reshape must have the same number of elements as the input shape
     *&#64;&#64;     specified by 'dims'. Optional.
     *&#64;&#64;
     * </pre>
     *
     * <code>.inference.ModelTensorReshape reshape = 5;</code>
     * @return Whether the reshape field is set.
     */
    @java.lang.Override
    public boolean hasReshape() {
      return reshape_ != null;
    }
    /**
     * <pre>
     *&#64;&#64;  .. cpp:var:: ModelTensorReshape reshape
     *&#64;&#64;
     *&#64;&#64;     The shape expected for this input by the backend. The input will
     *&#64;&#64;     be reshaped to this before being presented to the backend. The
     *&#64;&#64;     reshape must have the same number of elements as the input shape
     *&#64;&#64;     specified by 'dims'. Optional.
     *&#64;&#64;
     * </pre>
     *
     * <code>.inference.ModelTensorReshape reshape = 5;</code>
     * @return The reshape.
     */
    @java.lang.Override
    public org.apache.submarine.server.api.proto.TritonModelConfig.ModelTensorReshape getReshape() {
      return reshape_ == null ? org.apache.submarine.server.api.proto.TritonModelConfig.ModelTensorReshape.getDefaultInstance() : reshape_;
    }
    /**
     * <pre>
     *&#64;&#64;  .. cpp:var:: ModelTensorReshape reshape
     *&#64;&#64;
     *&#64;&#64;     The shape expected for this input by the backend. The input will
     *&#64;&#64;     be reshaped to this before being presented to the backend. The
     *&#64;&#64;     reshape must have the same number of elements as the input shape
     *&#64;&#64;     specified by 'dims'. Optional.
     *&#64;&#64;
     * </pre>
     *
     * <code>.inference.ModelTensorReshape reshape = 5;</code>
     */
    @java.lang.Override
    public org.apache.submarine.server.api.proto.TritonModelConfig.ModelTensorReshapeOrBuilder getReshapeOrBuilder() {
      return getReshape();
    }

    public static final int IS_SHAPE_TENSOR_FIELD_NUMBER = 6;
    private boolean isShapeTensor_;
    /**
     * <pre>
     *&#64;&#64;  .. cpp:var:: bool is_shape_tensor
     *&#64;&#64;
     *&#64;&#64;     Whether or not the input is a shape tensor to the model. This field
     *&#64;&#64;     is currently supported only for the TensorRT model. An error will be
     *&#64;&#64;     generated if this specification does not comply with underlying
     *&#64;&#64;     model.
     *&#64;&#64;
     * </pre>
     *
     * <code>bool is_shape_tensor = 6;</code>
     * @return The isShapeTensor.
     */
    @java.lang.Override
    public boolean getIsShapeTensor() {
      return isShapeTensor_;
    }

    public static final int ALLOW_RAGGED_BATCH_FIELD_NUMBER = 7;
    private boolean allowRaggedBatch_;
    /**
     * <pre>
     *&#64;&#64;  .. cpp:var:: bool allow_ragged_batch
     *&#64;&#64;
     *&#64;&#64;     Whether or not the input is allowed to be "ragged" in a dynamically
     *&#64;&#64;     created batch. Default is false indicating that two requests will
     *&#64;&#64;     only be batched if this tensor has the same shape in both requests.
     *&#64;&#64;     True indicates that two requests can be batched even if this tensor
     *&#64;&#64;     has a different shape in each request.
     *&#64;&#64;
     * </pre>
     *
     * <code>bool allow_ragged_batch = 7;</code>
     * @return The allowRaggedBatch.
     */
    @java.lang.Override
    public boolean getAllowRaggedBatch() {
      return allowRaggedBatch_;
    }

    public static final int OPTIONAL_FIELD_NUMBER = 8;
    private boolean optional_;
    /**
     * <pre>
     *&#64;&#64;  .. cpp:var:: bool optional
     *&#64;&#64;
     *&#64;&#64;     Whether or not the input is optional for the model execution.
     *&#64;&#64;     If true, the input is not required in the inference request.
     *&#64;&#64;     Default value is false.
     *&#64;&#64;
     * </pre>
     *
     * <code>bool optional = 8;</code>
     * @return The optional.
     */
    @java.lang.Override
    public boolean getOptional() {
      return optional_;
    }

    private byte memoizedIsInitialized = -1;
    @java.lang.Override
    public final boolean isInitialized() {
      byte isInitialized = memoizedIsInitialized;
      if (isInitialized == 1) return true;
      if (isInitialized == 0) return false;

      memoizedIsInitialized = 1;
      return true;
    }

    @java.lang.Override
    public void writeTo(com.google.protobuf.CodedOutputStream output)
                        throws java.io.IOException {
      getSerializedSize();
      if (!getNameBytes().isEmpty()) {
        com.google.protobuf.GeneratedMessageV3.writeString(output, 1, name_);
      }
      if (dataType_ != org.apache.submarine.server.api.proto.TritonModelConfig.DataType.TYPE_INVALID.getNumber()) {
        output.writeEnum(2, dataType_);
      }
      if (format_ != org.apache.submarine.server.api.proto.TritonModelConfig.ModelInput.Format.FORMAT_NONE.getNumber()) {
        output.writeEnum(3, format_);
      }
      if (getDimsList().size() > 0) {
        output.writeUInt32NoTag(34);
        output.writeUInt32NoTag(dimsMemoizedSerializedSize);
      }
      for (int i = 0; i < dims_.size(); i++) {
        output.writeInt64NoTag(dims_.getLong(i));
      }
      if (reshape_ != null) {
        output.writeMessage(5, getReshape());
      }
      if (isShapeTensor_ != false) {
        output.writeBool(6, isShapeTensor_);
      }
      if (allowRaggedBatch_ != false) {
        output.writeBool(7, allowRaggedBatch_);
      }
      if (optional_ != false) {
        output.writeBool(8, optional_);
      }
      unknownFields.writeTo(output);
    }

    @java.lang.Override
    public int getSerializedSize() {
      int size = memoizedSize;
      if (size != -1) return size;

      size = 0;
      if (!getNameBytes().isEmpty()) {
        size += com.google.protobuf.GeneratedMessageV3.computeStringSize(1, name_);
      }
      if (dataType_ != org.apache.submarine.server.api.proto.TritonModelConfig.DataType.TYPE_INVALID.getNumber()) {
        size += com.google.protobuf.CodedOutputStream
          .computeEnumSize(2, dataType_);
      }
      if (format_ != org.apache.submarine.server.api.proto.TritonModelConfig.ModelInput.Format.FORMAT_NONE.getNumber()) {
        size += com.google.protobuf.CodedOutputStream
          .computeEnumSize(3, format_);
      }
      {
        int dataSize = 0;
        for (int i = 0; i < dims_.size(); i++) {
          dataSize += com.google.protobuf.CodedOutputStream
            .computeInt64SizeNoTag(dims_.getLong(i));
        }
        size += dataSize;
        if (!getDimsList().isEmpty()) {
          size += 1;
          size += com.google.protobuf.CodedOutputStream
              .computeInt32SizeNoTag(dataSize);
        }
        dimsMemoizedSerializedSize = dataSize;
      }
      if (reshape_ != null) {
        size += com.google.protobuf.CodedOutputStream
          .computeMessageSize(5, getReshape());
      }
      if (isShapeTensor_ != false) {
        size += com.google.protobuf.CodedOutputStream
          .computeBoolSize(6, isShapeTensor_);
      }
      if (allowRaggedBatch_ != false) {
        size += com.google.protobuf.CodedOutputStream
          .computeBoolSize(7, allowRaggedBatch_);
      }
      if (optional_ != false) {
        size += com.google.protobuf.CodedOutputStream
          .computeBoolSize(8, optional_);
      }
      size += unknownFields.getSerializedSize();
      memoizedSize = size;
      return size;
    }

    @java.lang.Override
    public boolean equals(final java.lang.Object obj) {
      if (obj == this) {
       return true;
      }
      if (!(obj instanceof org.apache.submarine.server.api.proto.TritonModelConfig.ModelInput)) {
        return super.equals(obj);
      }
      org.apache.submarine.server.api.proto.TritonModelConfig.ModelInput other = (org.apache.submarine.server.api.proto.TritonModelConfig.ModelInput) obj;

      if (!getName()
          .equals(other.getName())) return false;
      if (dataType_ != other.dataType_) return false;
      if (format_ != other.format_) return false;
      if (!getDimsList()
          .equals(other.getDimsList())) return false;
      if (hasReshape() != other.hasReshape()) return false;
      if (hasReshape()) {
        if (!getReshape()
            .equals(other.getReshape())) return false;
      }
      if (getIsShapeTensor()
          != other.getIsShapeTensor()) return false;
      if (getAllowRaggedBatch()
          != other.getAllowRaggedBatch()) return false;
      if (getOptional()
          != other.getOptional()) return false;
      if (!unknownFields.equals(other.unknownFields)) return false;
      return true;
    }

    @java.lang.Override
    public int hashCode() {
      if (memoizedHashCode != 0) {
        return memoizedHashCode;
      }
      int hash = 41;
      hash = (19 * hash) + getDescriptor().hashCode();
      hash = (37 * hash) + NAME_FIELD_NUMBER;
      hash = (53 * hash) + getName().hashCode();
      hash = (37 * hash) + DATA_TYPE_FIELD_NUMBER;
      hash = (53 * hash) + dataType_;
      hash = (37 * hash) + FORMAT_FIELD_NUMBER;
      hash = (53 * hash) + format_;
      if (getDimsCount() > 0) {
        hash = (37 * hash) + DIMS_FIELD_NUMBER;
        hash = (53 * hash) + getDimsList().hashCode();
      }
      if (hasReshape()) {
        hash = (37 * hash) + RESHAPE_FIELD_NUMBER;
        hash = (53 * hash) + getReshape().hashCode();
      }
      hash = (37 * hash) + IS_SHAPE_TENSOR_FIELD_NUMBER;
      hash = (53 * hash) + com.google.protobuf.Internal.hashBoolean(
          getIsShapeTensor());
      hash = (37 * hash) + ALLOW_RAGGED_BATCH_FIELD_NUMBER;
      hash = (53 * hash) + com.google.protobuf.Internal.hashBoolean(
          getAllowRaggedBatch());
      hash = (37 * hash) + OPTIONAL_FIELD_NUMBER;
      hash = (53 * hash) + com.google.protobuf.Internal.hashBoolean(
          getOptional());
      hash = (29 * hash) + unknownFields.hashCode();
      memoizedHashCode = hash;
      return hash;
    }

    public static org.apache.submarine.server.api.proto.TritonModelConfig.ModelInput parseFrom(
        java.nio.ByteBuffer data)
        throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data);
    }
    public static org.apache.submarine.server.api.proto.TritonModelConfig.ModelInput parseFrom(
        java.nio.ByteBuffer data,
        com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data, extensionRegistry);
    }
    public static org.apache.submarine.server.api.proto.TritonModelConfig.ModelInput parseFrom(
        com.google.protobuf.ByteString data)
        throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data);
    }
    public static org.apache.submarine.server.api.proto.TritonModelConfig.ModelInput parseFrom(
        com.google.protobuf.ByteString data,
        com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data, extensionRegistry);
    }
    public static org.apache.submarine.server.api.proto.TritonModelConfig.ModelInput parseFrom(byte[] data)
        throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data);
    }
    public static org.apache.submarine.server.api.proto.TritonModelConfig.ModelInput parseFrom(
        byte[] data,
        com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data, extensionRegistry);
    }
    public static org.apache.submarine.server.api.proto.TritonModelConfig.ModelInput parseFrom(java.io.InputStream input)
        throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3
          .parseWithIOException(PARSER, input);
    }
    public static org.apache.submarine.server.api.proto.TritonModelConfig.ModelInput parseFrom(
        java.io.InputStream input,
        com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3
          .parseWithIOException(PARSER, input, extensionRegistry);
    }
    public static org.apache.submarine.server.api.proto.TritonModelConfig.ModelInput parseDelimitedFrom(java.io.InputStream input)
        throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3
          .parseDelimitedWithIOException(PARSER, input);
    }
    public static org.apache.submarine.server.api.proto.TritonModelConfig.ModelInput parseDelimitedFrom(
        java.io.InputStream input,
        com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3
          .parseDelimitedWithIOException(PARSER, input, extensionRegistry);
    }
    public static org.apache.submarine.server.api.proto.TritonModelConfig.ModelInput parseFrom(
        com.google.protobuf.CodedInputStream input)
        throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3
          .parseWithIOException(PARSER, input);
    }
    public static org.apache.submarine.server.api.proto.TritonModelConfig.ModelInput parseFrom(
        com.google.protobuf.CodedInputStream input,
        com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3
          .parseWithIOException(PARSER, input, extensionRegistry);
    }

    @java.lang.Override
    public Builder newBuilderForType() { return newBuilder(); }
    public static Builder newBuilder() {
      return DEFAULT_INSTANCE.toBuilder();
    }
    public static Builder newBuilder(org.apache.submarine.server.api.proto.TritonModelConfig.ModelInput prototype) {
      return DEFAULT_INSTANCE.toBuilder().mergeFrom(prototype);
    }
    @java.lang.Override
    public Builder toBuilder() {
      return this == DEFAULT_INSTANCE
          ? new Builder() : new Builder().mergeFrom(this);
    }

    @java.lang.Override
    protected Builder newBuilderForType(
        com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
      Builder builder = new Builder(parent);
      return builder;
    }
    /**
     * <pre>
     *&#64;&#64;
     *&#64;&#64;.. cpp:var:: message ModelInput
     *&#64;&#64;
     *&#64;&#64;   An input required by the model.
     *&#64;&#64;
     * </pre>
     *
     * Protobuf type {@code inference.ModelInput}
     */
    public static final class Builder extends
        com.google.protobuf.GeneratedMessageV3.Builder<Builder> implements
        // @@protoc_insertion_point(builder_implements:inference.ModelInput)
        org.apache.submarine.server.api.proto.TritonModelConfig.ModelInputOrBuilder {
      public static final com.google.protobuf.Descriptors.Descriptor
          getDescriptor() {
        return org.apache.submarine.server.api.proto.TritonModelConfig.internal_static_inference_ModelInput_descriptor;
      }

      @java.lang.Override
      protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
          internalGetFieldAccessorTable() {
        return org.apache.submarine.server.api.proto.TritonModelConfig.internal_static_inference_ModelInput_fieldAccessorTable
            .ensureFieldAccessorsInitialized(
                org.apache.submarine.server.api.proto.TritonModelConfig.ModelInput.class, org.apache.submarine.server.api.proto.TritonModelConfig.ModelInput.Builder.class);
      }

      // Construct using org.apache.submarine.server.api.proto.TritonModelConfig.ModelInput.newBuilder()
      private Builder() {
        maybeForceBuilderInitialization();
      }

      private Builder(
          com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
        super(parent);
        maybeForceBuilderInitialization();
      }
      private void maybeForceBuilderInitialization() {
        if (com.google.protobuf.GeneratedMessageV3
                .alwaysUseFieldBuilders) {
        }
      }
      @java.lang.Override
      public Builder clear() {
        super.clear();
        name_ = "";

        dataType_ = 0;

        format_ = 0;

        dims_ = emptyLongList();
        bitField0_ = (bitField0_ & ~0x00000001);
        if (reshapeBuilder_ == null) {
          reshape_ = null;
        } else {
          reshape_ = null;
          reshapeBuilder_ = null;
        }
        isShapeTensor_ = false;

        allowRaggedBatch_ = false;

        optional_ = false;

        return this;
      }

      @java.lang.Override
      public com.google.protobuf.Descriptors.Descriptor
          getDescriptorForType() {
        return org.apache.submarine.server.api.proto.TritonModelConfig.internal_static_inference_ModelInput_descriptor;
      }

      @java.lang.Override
      public org.apache.submarine.server.api.proto.TritonModelConfig.ModelInput getDefaultInstanceForType() {
        return org.apache.submarine.server.api.proto.TritonModelConfig.ModelInput.getDefaultInstance();
      }

      @java.lang.Override
      public org.apache.submarine.server.api.proto.TritonModelConfig.ModelInput build() {
        org.apache.submarine.server.api.proto.TritonModelConfig.ModelInput result = buildPartial();
        if (!result.isInitialized()) {
          throw newUninitializedMessageException(result);
        }
        return result;
      }

      @java.lang.Override
      public org.apache.submarine.server.api.proto.TritonModelConfig.ModelInput buildPartial() {
        org.apache.submarine.server.api.proto.TritonModelConfig.ModelInput result = new org.apache.submarine.server.api.proto.TritonModelConfig.ModelInput(this);
        int from_bitField0_ = bitField0_;
        result.name_ = name_;
        result.dataType_ = dataType_;
        result.format_ = format_;
        if (((bitField0_ & 0x00000001) != 0)) {
          dims_.makeImmutable();
          bitField0_ = (bitField0_ & ~0x00000001);
        }
        result.dims_ = dims_;
        if (reshapeBuilder_ == null) {
          result.reshape_ = reshape_;
        } else {
          result.reshape_ = reshapeBuilder_.build();
        }
        result.isShapeTensor_ = isShapeTensor_;
        result.allowRaggedBatch_ = allowRaggedBatch_;
        result.optional_ = optional_;
        onBuilt();
        return result;
      }

      @java.lang.Override
      public Builder clone() {
        return super.clone();
      }
      @java.lang.Override
      public Builder setField(
          com.google.protobuf.Descriptors.FieldDescriptor field,
          java.lang.Object value) {
        return super.setField(field, value);
      }
      @java.lang.Override
      public Builder clearField(
          com.google.protobuf.Descriptors.FieldDescriptor field) {
        return super.clearField(field);
      }
      @java.lang.Override
      public Builder clearOneof(
          com.google.protobuf.Descriptors.OneofDescriptor oneof) {
        return super.clearOneof(oneof);
      }
      @java.lang.Override
      public Builder setRepeatedField(
          com.google.protobuf.Descriptors.FieldDescriptor field,
          int index, java.lang.Object value) {
        return super.setRepeatedField(field, index, value);
      }
      @java.lang.Override
      public Builder addRepeatedField(
          com.google.protobuf.Descriptors.FieldDescriptor field,
          java.lang.Object value) {
        return super.addRepeatedField(field, value);
      }
      @java.lang.Override
      public Builder mergeFrom(com.google.protobuf.Message other) {
        if (other instanceof org.apache.submarine.server.api.proto.TritonModelConfig.ModelInput) {
          return mergeFrom((org.apache.submarine.server.api.proto.TritonModelConfig.ModelInput)other);
        } else {
          super.mergeFrom(other);
          return this;
        }
      }

      public Builder mergeFrom(org.apache.submarine.server.api.proto.TritonModelConfig.ModelInput other) {
        if (other == org.apache.submarine.server.api.proto.TritonModelConfig.ModelInput.getDefaultInstance()) return this;
        if (!other.getName().isEmpty()) {
          name_ = other.name_;
          onChanged();
        }
        if (other.dataType_ != 0) {
          setDataTypeValue(other.getDataTypeValue());
        }
        if (other.format_ != 0) {
          setFormatValue(other.getFormatValue());
        }
        if (!other.dims_.isEmpty()) {
          if (dims_.isEmpty()) {
            dims_ = other.dims_;
            bitField0_ = (bitField0_ & ~0x00000001);
          } else {
            ensureDimsIsMutable();
            dims_.addAll(other.dims_);
          }
          onChanged();
        }
        if (other.hasReshape()) {
          mergeReshape(other.getReshape());
        }
        if (other.getIsShapeTensor() != false) {
          setIsShapeTensor(other.getIsShapeTensor());
        }
        if (other.getAllowRaggedBatch() != false) {
          setAllowRaggedBatch(other.getAllowRaggedBatch());
        }
        if (other.getOptional() != false) {
          setOptional(other.getOptional());
        }
        this.mergeUnknownFields(other.unknownFields);
        onChanged();
        return this;
      }

      @java.lang.Override
      public final boolean isInitialized() {
        return true;
      }

      @java.lang.Override
      public Builder mergeFrom(
          com.google.protobuf.CodedInputStream input,
          com.google.protobuf.ExtensionRegistryLite extensionRegistry)
          throws java.io.IOException {
        org.apache.submarine.server.api.proto.TritonModelConfig.ModelInput parsedMessage = null;
        try {
          parsedMessage = PARSER.parsePartialFrom(input, extensionRegistry);
        } catch (com.google.protobuf.InvalidProtocolBufferException e) {
          parsedMessage = (org.apache.submarine.server.api.proto.TritonModelConfig.ModelInput) e.getUnfinishedMessage();
          throw e.unwrapIOException();
        } finally {
          if (parsedMessage != null) {
            mergeFrom(parsedMessage);
          }
        }
        return this;
      }
      private int bitField0_;

      private java.lang.Object name_ = "";
      /**
       * <pre>
       *&#64;&#64;  .. cpp:var:: string name
       *&#64;&#64;
       *&#64;&#64;     The name of the input.
       *&#64;&#64;
       * </pre>
       *
       * <code>string name = 1;</code>
       * @return The name.
       */
      public java.lang.String getName() {
        java.lang.Object ref = name_;
        if (!(ref instanceof java.lang.String)) {
          com.google.protobuf.ByteString bs =
              (com.google.protobuf.ByteString) ref;
          java.lang.String s = bs.toStringUtf8();
          name_ = s;
          return s;
        } else {
          return (java.lang.String) ref;
        }
      }
      /**
       * <pre>
       *&#64;&#64;  .. cpp:var:: string name
       *&#64;&#64;
       *&#64;&#64;     The name of the input.
       *&#64;&#64;
       * </pre>
       *
       * <code>string name = 1;</code>
       * @return The bytes for name.
       */
      public com.google.protobuf.ByteString
          getNameBytes() {
        java.lang.Object ref = name_;
        if (ref instanceof String) {
          com.google.protobuf.ByteString b = 
              com.google.protobuf.ByteString.copyFromUtf8(
                  (java.lang.String) ref);
          name_ = b;
          return b;
        } else {
          return (com.google.protobuf.ByteString) ref;
        }
      }
      /**
       * <pre>
       *&#64;&#64;  .. cpp:var:: string name
       *&#64;&#64;
       *&#64;&#64;     The name of the input.
       *&#64;&#64;
       * </pre>
       *
       * <code>string name = 1;</code>
       * @param value The name to set.
       * @return This builder for chaining.
       */
      public Builder setName(
          java.lang.String value) {
        if (value == null) {
    throw new NullPointerException();
  }
  
        name_ = value;
        onChanged();
        return this;
      }
      /**
       * <pre>
       *&#64;&#64;  .. cpp:var:: string name
       *&#64;&#64;
       *&#64;&#64;     The name of the input.
       *&#64;&#64;
       * </pre>
       *
       * <code>string name = 1;</code>
       * @return This builder for chaining.
       */
      public Builder clearName() {
        
        name_ = getDefaultInstance().getName();
        onChanged();
        return this;
      }
      /**
       * <pre>
       *&#64;&#64;  .. cpp:var:: string name
       *&#64;&#64;
       *&#64;&#64;     The name of the input.
       *&#64;&#64;
       * </pre>
       *
       * <code>string name = 1;</code>
       * @param value The bytes for name to set.
       * @return This builder for chaining.
       */
      public Builder setNameBytes(
          com.google.protobuf.ByteString value) {
        if (value == null) {
    throw new NullPointerException();
  }
  checkByteStringIsUtf8(value);
        
        name_ = value;
        onChanged();
        return this;
      }

      private int dataType_ = 0;
      /**
       * <pre>
       *&#64;&#64;  .. cpp:var:: DataType data_type
       *&#64;&#64;
       *&#64;&#64;     The data-type of the input.
       *&#64;&#64;
       * </pre>
       *
       * <code>.inference.DataType data_type = 2;</code>
       * @return The enum numeric value on the wire for dataType.
       */
      @java.lang.Override public int getDataTypeValue() {
        return dataType_;
      }
      /**
       * <pre>
       *&#64;&#64;  .. cpp:var:: DataType data_type
       *&#64;&#64;
       *&#64;&#64;     The data-type of the input.
       *&#64;&#64;
       * </pre>
       *
       * <code>.inference.DataType data_type = 2;</code>
       * @param value The enum numeric value on the wire for dataType to set.
       * @return This builder for chaining.
       */
      public Builder setDataTypeValue(int value) {
        
        dataType_ = value;
        onChanged();
        return this;
      }
      /**
       * <pre>
       *&#64;&#64;  .. cpp:var:: DataType data_type
       *&#64;&#64;
       *&#64;&#64;     The data-type of the input.
       *&#64;&#64;
       * </pre>
       *
       * <code>.inference.DataType data_type = 2;</code>
       * @return The dataType.
       */
      @java.lang.Override
      public org.apache.submarine.server.api.proto.TritonModelConfig.DataType getDataType() {
        @SuppressWarnings("deprecation")
        org.apache.submarine.server.api.proto.TritonModelConfig.DataType result = org.apache.submarine.server.api.proto.TritonModelConfig.DataType.valueOf(dataType_);
        return result == null ? org.apache.submarine.server.api.proto.TritonModelConfig.DataType.UNRECOGNIZED : result;
      }
      /**
       * <pre>
       *&#64;&#64;  .. cpp:var:: DataType data_type
       *&#64;&#64;
       *&#64;&#64;     The data-type of the input.
       *&#64;&#64;
       * </pre>
       *
       * <code>.inference.DataType data_type = 2;</code>
       * @param value The dataType to set.
       * @return This builder for chaining.
       */
      public Builder setDataType(org.apache.submarine.server.api.proto.TritonModelConfig.DataType value) {
        if (value == null) {
          throw new NullPointerException();
        }
        
        dataType_ = value.getNumber();
        onChanged();
        return this;
      }
      /**
       * <pre>
       *&#64;&#64;  .. cpp:var:: DataType data_type
       *&#64;&#64;
       *&#64;&#64;     The data-type of the input.
       *&#64;&#64;
       * </pre>
       *
       * <code>.inference.DataType data_type = 2;</code>
       * @return This builder for chaining.
       */
      public Builder clearDataType() {
        
        dataType_ = 0;
        onChanged();
        return this;
      }

      private int format_ = 0;
      /**
       * <pre>
       *&#64;&#64;  .. cpp:var:: Format format
       *&#64;&#64;
       *&#64;&#64;     The format of the input. Optional.
       *&#64;&#64;
       * </pre>
       *
       * <code>.inference.ModelInput.Format format = 3;</code>
       * @return The enum numeric value on the wire for format.
       */
      @java.lang.Override public int getFormatValue() {
        return format_;
      }
      /**
       * <pre>
       *&#64;&#64;  .. cpp:var:: Format format
       *&#64;&#64;
       *&#64;&#64;     The format of the input. Optional.
       *&#64;&#64;
       * </pre>
       *
       * <code>.inference.ModelInput.Format format = 3;</code>
       * @param value The enum numeric value on the wire for format to set.
       * @return This builder for chaining.
       */
      public Builder setFormatValue(int value) {
        
        format_ = value;
        onChanged();
        return this;
      }
      /**
       * <pre>
       *&#64;&#64;  .. cpp:var:: Format format
       *&#64;&#64;
       *&#64;&#64;     The format of the input. Optional.
       *&#64;&#64;
       * </pre>
       *
       * <code>.inference.ModelInput.Format format = 3;</code>
       * @return The format.
       */
      @java.lang.Override
      public org.apache.submarine.server.api.proto.TritonModelConfig.ModelInput.Format getFormat() {
        @SuppressWarnings("deprecation")
        org.apache.submarine.server.api.proto.TritonModelConfig.ModelInput.Format result = org.apache.submarine.server.api.proto.TritonModelConfig.ModelInput.Format.valueOf(format_);
        return result == null ? org.apache.submarine.server.api.proto.TritonModelConfig.ModelInput.Format.UNRECOGNIZED : result;
      }
      /**
       * <pre>
       *&#64;&#64;  .. cpp:var:: Format format
       *&#64;&#64;
       *&#64;&#64;     The format of the input. Optional.
       *&#64;&#64;
       * </pre>
       *
       * <code>.inference.ModelInput.Format format = 3;</code>
       * @param value The format to set.
       * @return This builder for chaining.
       */
      public Builder setFormat(org.apache.submarine.server.api.proto.TritonModelConfig.ModelInput.Format value) {
        if (value == null) {
          throw new NullPointerException();
        }
        
        format_ = value.getNumber();
        onChanged();
        return this;
      }
      /**
       * <pre>
       *&#64;&#64;  .. cpp:var:: Format format
       *&#64;&#64;
       *&#64;&#64;     The format of the input. Optional.
       *&#64;&#64;
       * </pre>
       *
       * <code>.inference.ModelInput.Format format = 3;</code>
       * @return This builder for chaining.
       */
      public Builder clearFormat() {
        
        format_ = 0;
        onChanged();
        return this;
      }

      private com.google.protobuf.Internal.LongList dims_ = emptyLongList();
      private void ensureDimsIsMutable() {
        if (!((bitField0_ & 0x00000001) != 0)) {
          dims_ = mutableCopy(dims_);
          bitField0_ |= 0x00000001;
         }
      }
      /**
       * <pre>
       *&#64;&#64;  .. cpp:var:: int64 dims (repeated)
       *&#64;&#64;
       *&#64;&#64;     The dimensions/shape of the input tensor that must be provided
       *&#64;&#64;     when invoking the inference API for this model.
       *&#64;&#64;
       * </pre>
       *
       * <code>repeated int64 dims = 4;</code>
       * @return A list containing the dims.
       */
      public java.util.List<java.lang.Long>
          getDimsList() {
        return ((bitField0_ & 0x00000001) != 0) ?
                 java.util.Collections.unmodifiableList(dims_) : dims_;
      }
      /**
       * <pre>
       *&#64;&#64;  .. cpp:var:: int64 dims (repeated)
       *&#64;&#64;
       *&#64;&#64;     The dimensions/shape of the input tensor that must be provided
       *&#64;&#64;     when invoking the inference API for this model.
       *&#64;&#64;
       * </pre>
       *
       * <code>repeated int64 dims = 4;</code>
       * @return The count of dims.
       */
      public int getDimsCount() {
        return dims_.size();
      }
      /**
       * <pre>
       *&#64;&#64;  .. cpp:var:: int64 dims (repeated)
       *&#64;&#64;
       *&#64;&#64;     The dimensions/shape of the input tensor that must be provided
       *&#64;&#64;     when invoking the inference API for this model.
       *&#64;&#64;
       * </pre>
       *
       * <code>repeated int64 dims = 4;</code>
       * @param index The index of the element to return.
       * @return The dims at the given index.
       */
      public long getDims(int index) {
        return dims_.getLong(index);
      }
      /**
       * <pre>
       *&#64;&#64;  .. cpp:var:: int64 dims (repeated)
       *&#64;&#64;
       *&#64;&#64;     The dimensions/shape of the input tensor that must be provided
       *&#64;&#64;     when invoking the inference API for this model.
       *&#64;&#64;
       * </pre>
       *
       * <code>repeated int64 dims = 4;</code>
       * @param index The index to set the value at.
       * @param value The dims to set.
       * @return This builder for chaining.
       */
      public Builder setDims(
          int index, long value) {
        ensureDimsIsMutable();
        dims_.setLong(index, value);
        onChanged();
        return this;
      }
      /**
       * <pre>
       *&#64;&#64;  .. cpp:var:: int64 dims (repeated)
       *&#64;&#64;
       *&#64;&#64;     The dimensions/shape of the input tensor that must be provided
       *&#64;&#64;     when invoking the inference API for this model.
       *&#64;&#64;
       * </pre>
       *
       * <code>repeated int64 dims = 4;</code>
       * @param value The dims to add.
       * @return This builder for chaining.
       */
      public Builder addDims(long value) {
        ensureDimsIsMutable();
        dims_.addLong(value);
        onChanged();
        return this;
      }
      /**
       * <pre>
       *&#64;&#64;  .. cpp:var:: int64 dims (repeated)
       *&#64;&#64;
       *&#64;&#64;     The dimensions/shape of the input tensor that must be provided
       *&#64;&#64;     when invoking the inference API for this model.
       *&#64;&#64;
       * </pre>
       *
       * <code>repeated int64 dims = 4;</code>
       * @param values The dims to add.
       * @return This builder for chaining.
       */
      public Builder addAllDims(
          java.lang.Iterable<? extends java.lang.Long> values) {
        ensureDimsIsMutable();
        com.google.protobuf.AbstractMessageLite.Builder.addAll(
            values, dims_);
        onChanged();
        return this;
      }
      /**
       * <pre>
       *&#64;&#64;  .. cpp:var:: int64 dims (repeated)
       *&#64;&#64;
       *&#64;&#64;     The dimensions/shape of the input tensor that must be provided
       *&#64;&#64;     when invoking the inference API for this model.
       *&#64;&#64;
       * </pre>
       *
       * <code>repeated int64 dims = 4;</code>
       * @return This builder for chaining.
       */
      public Builder clearDims() {
        dims_ = emptyLongList();
        bitField0_ = (bitField0_ & ~0x00000001);
        onChanged();
        return this;
      }

      private org.apache.submarine.server.api.proto.TritonModelConfig.ModelTensorReshape reshape_;
      private com.google.protobuf.SingleFieldBuilderV3<
          org.apache.submarine.server.api.proto.TritonModelConfig.ModelTensorReshape, org.apache.submarine.server.api.proto.TritonModelConfig.ModelTensorReshape.Builder, org.apache.submarine.server.api.proto.TritonModelConfig.ModelTensorReshapeOrBuilder> reshapeBuilder_;
      /**
       * <pre>
       *&#64;&#64;  .. cpp:var:: ModelTensorReshape reshape
       *&#64;&#64;
       *&#64;&#64;     The shape expected for this input by the backend. The input will
       *&#64;&#64;     be reshaped to this before being presented to the backend. The
       *&#64;&#64;     reshape must have the same number of elements as the input shape
       *&#64;&#64;     specified by 'dims'. Optional.
       *&#64;&#64;
       * </pre>
       *
       * <code>.inference.ModelTensorReshape reshape = 5;</code>
       * @return Whether the reshape field is set.
       */
      public boolean hasReshape() {
        return reshapeBuilder_ != null || reshape_ != null;
      }
      /**
       * <pre>
       *&#64;&#64;  .. cpp:var:: ModelTensorReshape reshape
       *&#64;&#64;
       *&#64;&#64;     The shape expected for this input by the backend. The input will
       *&#64;&#64;     be reshaped to this before being presented to the backend. The
       *&#64;&#64;     reshape must have the same number of elements as the input shape
       *&#64;&#64;     specified by 'dims'. Optional.
       *&#64;&#64;
       * </pre>
       *
       * <code>.inference.ModelTensorReshape reshape = 5;</code>
       * @return The reshape.
       */
      public org.apache.submarine.server.api.proto.TritonModelConfig.ModelTensorReshape getReshape() {
        if (reshapeBuilder_ == null) {
          return reshape_ == null ? org.apache.submarine.server.api.proto.TritonModelConfig.ModelTensorReshape.getDefaultInstance() : reshape_;
        } else {
          return reshapeBuilder_.getMessage();
        }
      }
      /**
       * <pre>
       *&#64;&#64;  .. cpp:var:: ModelTensorReshape reshape
       *&#64;&#64;
       *&#64;&#64;     The shape expected for this input by the backend. The input will
       *&#64;&#64;     be reshaped to this before being presented to the backend. The
       *&#64;&#64;     reshape must have the same number of elements as the input shape
       *&#64;&#64;     specified by 'dims'. Optional.
       *&#64;&#64;
       * </pre>
       *
       * <code>.inference.ModelTensorReshape reshape = 5;</code>
       */
      public Builder setReshape(org.apache.submarine.server.api.proto.TritonModelConfig.ModelTensorReshape value) {
        if (reshapeBuilder_ == null) {
          if (value == null) {
            throw new NullPointerException();
          }
          reshape_ = value;
          onChanged();
        } else {
          reshapeBuilder_.setMessage(value);
        }

        return this;
      }
      /**
       * <pre>
       *&#64;&#64;  .. cpp:var:: ModelTensorReshape reshape
       *&#64;&#64;
       *&#64;&#64;     The shape expected for this input by the backend. The input will
       *&#64;&#64;     be reshaped to this before being presented to the backend. The
       *&#64;&#64;     reshape must have the same number of elements as the input shape
       *&#64;&#64;     specified by 'dims'. Optional.
       *&#64;&#64;
       * </pre>
       *
       * <code>.inference.ModelTensorReshape reshape = 5;</code>
       */
      public Builder setReshape(
          org.apache.submarine.server.api.proto.TritonModelConfig.ModelTensorReshape.Builder builderForValue) {
        if (reshapeBuilder_ == null) {
          reshape_ = builderForValue.build();
          onChanged();
        } else {
          reshapeBuilder_.setMessage(builderForValue.build());
        }

        return this;
      }
      /**
       * <pre>
       *&#64;&#64;  .. cpp:var:: ModelTensorReshape reshape
       *&#64;&#64;
       *&#64;&#64;     The shape expected for this input by the backend. The input will
       *&#64;&#64;     be reshaped to this before being presented to the backend. The
       *&#64;&#64;     reshape must have the same number of elements as the input shape
       *&#64;&#64;     specified by 'dims'. Optional.
       *&#64;&#64;
       * </pre>
       *
       * <code>.inference.ModelTensorReshape reshape = 5;</code>
       */
      public Builder mergeReshape(org.apache.submarine.server.api.proto.TritonModelConfig.ModelTensorReshape value) {
        if (reshapeBuilder_ == null) {
          if (reshape_ != null) {
            reshape_ =
              org.apache.submarine.server.api.proto.TritonModelConfig.ModelTensorReshape.newBuilder(reshape_).mergeFrom(value).buildPartial();
          } else {
            reshape_ = value;
          }
          onChanged();
        } else {
          reshapeBuilder_.mergeFrom(value);
        }

        return this;
      }
      /**
       * <pre>
       *&#64;&#64;  .. cpp:var:: ModelTensorReshape reshape
       *&#64;&#64;
       *&#64;&#64;     The shape expected for this input by the backend. The input will
       *&#64;&#64;     be reshaped to this before being presented to the backend. The
       *&#64;&#64;     reshape must have the same number of elements as the input shape
       *&#64;&#64;     specified by 'dims'. Optional.
       *&#64;&#64;
       * </pre>
       *
       * <code>.inference.ModelTensorReshape reshape = 5;</code>
       */
      public Builder clearReshape() {
        if (reshapeBuilder_ == null) {
          reshape_ = null;
          onChanged();
        } else {
          reshape_ = null;
          reshapeBuilder_ = null;
        }

        return this;
      }
      /**
       * <pre>
       *&#64;&#64;  .. cpp:var:: ModelTensorReshape reshape
       *&#64;&#64;
       *&#64;&#64;     The shape expected for this input by the backend. The input will
       *&#64;&#64;     be reshaped to this before being presented to the backend. The
       *&#64;&#64;     reshape must have the same number of elements as the input shape
       *&#64;&#64;     specified by 'dims'. Optional.
       *&#64;&#64;
       * </pre>
       *
       * <code>.inference.ModelTensorReshape reshape = 5;</code>
       */
      public org.apache.submarine.server.api.proto.TritonModelConfig.ModelTensorReshape.Builder getReshapeBuilder() {
        
        onChanged();
        return getReshapeFieldBuilder().getBuilder();
      }
      /**
       * <pre>
       *&#64;&#64;  .. cpp:var:: ModelTensorReshape reshape
       *&#64;&#64;
       *&#64;&#64;     The shape expected for this input by the backend. The input will
       *&#64;&#64;     be reshaped to this before being presented to the backend. The
       *&#64;&#64;     reshape must have the same number of elements as the input shape
       *&#64;&#64;     specified by 'dims'. Optional.
       *&#64;&#64;
       * </pre>
       *
       * <code>.inference.ModelTensorReshape reshape = 5;</code>
       */
      public org.apache.submarine.server.api.proto.TritonModelConfig.ModelTensorReshapeOrBuilder getReshapeOrBuilder() {
        if (reshapeBuilder_ != null) {
          return reshapeBuilder_.getMessageOrBuilder();
        } else {
          return reshape_ == null ?
              org.apache.submarine.server.api.proto.TritonModelConfig.ModelTensorReshape.getDefaultInstance() : reshape_;
        }
      }
      /**
       * <pre>
       *&#64;&#64;  .. cpp:var:: ModelTensorReshape reshape
       *&#64;&#64;
       *&#64;&#64;     The shape expected for this input by the backend. The input will
       *&#64;&#64;     be reshaped to this before being presented to the backend. The
       *&#64;&#64;     reshape must have the same number of elements as the input shape
       *&#64;&#64;     specified by 'dims'. Optional.
       *&#64;&#64;
       * </pre>
       *
       * <code>.inference.ModelTensorReshape reshape = 5;</code>
       */
      private com.google.protobuf.SingleFieldBuilderV3<
          org.apache.submarine.server.api.proto.TritonModelConfig.ModelTensorReshape, org.apache.submarine.server.api.proto.TritonModelConfig.ModelTensorReshape.Builder, org.apache.submarine.server.api.proto.TritonModelConfig.ModelTensorReshapeOrBuilder> 
          getReshapeFieldBuilder() {
        if (reshapeBuilder_ == null) {
          reshapeBuilder_ = new com.google.protobuf.SingleFieldBuilderV3<
              org.apache.submarine.server.api.proto.TritonModelConfig.ModelTensorReshape, org.apache.submarine.server.api.proto.TritonModelConfig.ModelTensorReshape.Builder, org.apache.submarine.server.api.proto.TritonModelConfig.ModelTensorReshapeOrBuilder>(
                  getReshape(),
                  getParentForChildren(),
                  isClean());
          reshape_ = null;
        }
        return reshapeBuilder_;
      }

      private boolean isShapeTensor_ ;
      /**
       * <pre>
       *&#64;&#64;  .. cpp:var:: bool is_shape_tensor
       *&#64;&#64;
       *&#64;&#64;     Whether or not the input is a shape tensor to the model. This field
       *&#64;&#64;     is currently supported only for the TensorRT model. An error will be
       *&#64;&#64;     generated if this specification does not comply with underlying
       *&#64;&#64;     model.
       *&#64;&#64;
       * </pre>
       *
       * <code>bool is_shape_tensor = 6;</code>
       * @return The isShapeTensor.
       */
      @java.lang.Override
      public boolean getIsShapeTensor() {
        return isShapeTensor_;
      }
      /**
       * <pre>
       *&#64;&#64;  .. cpp:var:: bool is_shape_tensor
       *&#64;&#64;
       *&#64;&#64;     Whether or not the input is a shape tensor to the model. This field
       *&#64;&#64;     is currently supported only for the TensorRT model. An error will be
       *&#64;&#64;     generated if this specification does not comply with underlying
       *&#64;&#64;     model.
       *&#64;&#64;
       * </pre>
       *
       * <code>bool is_shape_tensor = 6;</code>
       * @param value The isShapeTensor to set.
       * @return This builder for chaining.
       */
      public Builder setIsShapeTensor(boolean value) {
        
        isShapeTensor_ = value;
        onChanged();
        return this;
      }
      /**
       * <pre>
       *&#64;&#64;  .. cpp:var:: bool is_shape_tensor
       *&#64;&#64;
       *&#64;&#64;     Whether or not the input is a shape tensor to the model. This field
       *&#64;&#64;     is currently supported only for the TensorRT model. An error will be
       *&#64;&#64;     generated if this specification does not comply with underlying
       *&#64;&#64;     model.
       *&#64;&#64;
       * </pre>
       *
       * <code>bool is_shape_tensor = 6;</code>
       * @return This builder for chaining.
       */
      public Builder clearIsShapeTensor() {
        
        isShapeTensor_ = false;
        onChanged();
        return this;
      }

      private boolean allowRaggedBatch_ ;
      /**
       * <pre>
       *&#64;&#64;  .. cpp:var:: bool allow_ragged_batch
       *&#64;&#64;
       *&#64;&#64;     Whether or not the input is allowed to be "ragged" in a dynamically
       *&#64;&#64;     created batch. Default is false indicating that two requests will
       *&#64;&#64;     only be batched if this tensor has the same shape in both requests.
       *&#64;&#64;     True indicates that two requests can be batched even if this tensor
       *&#64;&#64;     has a different shape in each request.
       *&#64;&#64;
       * </pre>
       *
       * <code>bool allow_ragged_batch = 7;</code>
       * @return The allowRaggedBatch.
       */
      @java.lang.Override
      public boolean getAllowRaggedBatch() {
        return allowRaggedBatch_;
      }
      /**
       * <pre>
       *&#64;&#64;  .. cpp:var:: bool allow_ragged_batch
       *&#64;&#64;
       *&#64;&#64;     Whether or not the input is allowed to be "ragged" in a dynamically
       *&#64;&#64;     created batch. Default is false indicating that two requests will
       *&#64;&#64;     only be batched if this tensor has the same shape in both requests.
       *&#64;&#64;     True indicates that two requests can be batched even if this tensor
       *&#64;&#64;     has a different shape in each request.
       *&#64;&#64;
       * </pre>
       *
       * <code>bool allow_ragged_batch = 7;</code>
       * @param value The allowRaggedBatch to set.
       * @return This builder for chaining.
       */
      public Builder setAllowRaggedBatch(boolean value) {
        
        allowRaggedBatch_ = value;
        onChanged();
        return this;
      }
      /**
       * <pre>
       *&#64;&#64;  .. cpp:var:: bool allow_ragged_batch
       *&#64;&#64;
       *&#64;&#64;     Whether or not the input is allowed to be "ragged" in a dynamically
       *&#64;&#64;     created batch. Default is false indicating that two requests will
       *&#64;&#64;     only be batched if this tensor has the same shape in both requests.
       *&#64;&#64;     True indicates that two requests can be batched even if this tensor
       *&#64;&#64;     has a different shape in each request.
       *&#64;&#64;
       * </pre>
       *
       * <code>bool allow_ragged_batch = 7;</code>
       * @return This builder for chaining.
       */
      public Builder clearAllowRaggedBatch() {
        
        allowRaggedBatch_ = false;
        onChanged();
        return this;
      }

      private boolean optional_ ;
      /**
       * <pre>
       *&#64;&#64;  .. cpp:var:: bool optional
       *&#64;&#64;
       *&#64;&#64;     Whether or not the input is optional for the model execution.
       *&#64;&#64;     If true, the input is not required in the inference request.
       *&#64;&#64;     Default value is false.
       *&#64;&#64;
       * </pre>
       *
       * <code>bool optional = 8;</code>
       * @return The optional.
       */
      @java.lang.Override
      public boolean getOptional() {
        return optional_;
      }
      /**
       * <pre>
       *&#64;&#64;  .. cpp:var:: bool optional
       *&#64;&#64;
       *&#64;&#64;     Whether or not the input is optional for the model execution.
       *&#64;&#64;     If true, the input is not required in the inference request.
       *&#64;&#64;     Default value is false.
       *&#64;&#64;
       * </pre>
       *
       * <code>bool optional = 8;</code>
       * @param value The optional to set.
       * @return This builder for chaining.
       */
      public Builder setOptional(boolean value) {
        
        optional_ = value;
        onChanged();
        return this;
      }
      /**
       * <pre>
       *&#64;&#64;  .. cpp:var:: bool optional
       *&#64;&#64;
       *&#64;&#64;     Whether or not the input is optional for the model execution.
       *&#64;&#64;     If true, the input is not required in the inference request.
       *&#64;&#64;     Default value is false.
       *&#64;&#64;
       * </pre>
       *
       * <code>bool optional = 8;</code>
       * @return This builder for chaining.
       */
      public Builder clearOptional() {
        
        optional_ = false;
        onChanged();
        return this;
      }
      @java.lang.Override
      public final Builder setUnknownFields(
          final com.google.protobuf.UnknownFieldSet unknownFields) {
        return super.setUnknownFields(unknownFields);
      }

      @java.lang.Override
      public final Builder mergeUnknownFields(
          final com.google.protobuf.UnknownFieldSet unknownFields) {
        return super.mergeUnknownFields(unknownFields);
      }


      // @@protoc_insertion_point(builder_scope:inference.ModelInput)
    }

    // @@protoc_insertion_point(class_scope:inference.ModelInput)
    private static final org.apache.submarine.server.api.proto.TritonModelConfig.ModelInput DEFAULT_INSTANCE;
    static {
      DEFAULT_INSTANCE = new org.apache.submarine.server.api.proto.TritonModelConfig.ModelInput();
    }

    public static org.apache.submarine.server.api.proto.TritonModelConfig.ModelInput getDefaultInstance() {
      return DEFAULT_INSTANCE;
    }

    private static final com.google.protobuf.Parser<ModelInput>
        PARSER = new com.google.protobuf.AbstractParser<ModelInput>() {
      @java.lang.Override
      public ModelInput parsePartialFrom(
          com.google.protobuf.CodedInputStream input,
          com.google.protobuf.ExtensionRegistryLite extensionRegistry)
          throws com.google.protobuf.InvalidProtocolBufferException {
        return new ModelInput(input, extensionRegistry);
      }
    };

    public static com.google.protobuf.Parser<ModelInput> parser() {
      return PARSER;
    }

    @java.lang.Override
    public com.google.protobuf.Parser<ModelInput> getParserForType() {
      return PARSER;
    }

    @java.lang.Override
    public org.apache.submarine.server.api.proto.TritonModelConfig.ModelInput getDefaultInstanceForType() {
      return DEFAULT_INSTANCE;
    }

  }

  public interface ModelOutputOrBuilder extends
      // @@protoc_insertion_point(interface_extends:inference.ModelOutput)
      com.google.protobuf.MessageOrBuilder {

    /**
     * <pre>
     *&#64;&#64;  .. cpp:var:: string name
     *&#64;&#64;
     *&#64;&#64;     The name of the output.
     *&#64;&#64;
     * </pre>
     *
     * <code>string name = 1;</code>
     * @return The name.
     */
    java.lang.String getName();
    /**
     * <pre>
     *&#64;&#64;  .. cpp:var:: string name
     *&#64;&#64;
     *&#64;&#64;     The name of the output.
     *&#64;&#64;
     * </pre>
     *
     * <code>string name = 1;</code>
     * @return The bytes for name.
     */
    com.google.protobuf.ByteString
        getNameBytes();

    /**
     * <pre>
     *&#64;&#64;  .. cpp:var:: DataType data_type
     *&#64;&#64;
     *&#64;&#64;     The data-type of the output.
     *&#64;&#64;
     * </pre>
     *
     * <code>.inference.DataType data_type = 2;</code>
     * @return The enum numeric value on the wire for dataType.
     */
    int getDataTypeValue();
    /**
     * <pre>
     *&#64;&#64;  .. cpp:var:: DataType data_type
     *&#64;&#64;
     *&#64;&#64;     The data-type of the output.
     *&#64;&#64;
     * </pre>
     *
     * <code>.inference.DataType data_type = 2;</code>
     * @return The dataType.
     */
    org.apache.submarine.server.api.proto.TritonModelConfig.DataType getDataType();

    /**
     * <pre>
     *&#64;&#64;  .. cpp:var:: int64 dims (repeated)
     *&#64;&#64;
     *&#64;&#64;     The dimensions/shape of the output tensor.
     *&#64;&#64;
     * </pre>
     *
     * <code>repeated int64 dims = 3;</code>
     * @return A list containing the dims.
     */
    java.util.List<java.lang.Long> getDimsList();
    /**
     * <pre>
     *&#64;&#64;  .. cpp:var:: int64 dims (repeated)
     *&#64;&#64;
     *&#64;&#64;     The dimensions/shape of the output tensor.
     *&#64;&#64;
     * </pre>
     *
     * <code>repeated int64 dims = 3;</code>
     * @return The count of dims.
     */
    int getDimsCount();
    /**
     * <pre>
     *&#64;&#64;  .. cpp:var:: int64 dims (repeated)
     *&#64;&#64;
     *&#64;&#64;     The dimensions/shape of the output tensor.
     *&#64;&#64;
     * </pre>
     *
     * <code>repeated int64 dims = 3;</code>
     * @param index The index of the element to return.
     * @return The dims at the given index.
     */
    long getDims(int index);

    /**
     * <pre>
     *&#64;&#64;  .. cpp:var:: ModelTensorReshape reshape
     *&#64;&#64;
     *&#64;&#64;     The shape produced for this output by the backend. The output will
     *&#64;&#64;     be reshaped from this to the shape specifed in 'dims' before being
     *&#64;&#64;     returned in the inference response. The reshape must have the same
     *&#64;&#64;     number of elements as the output shape specified by 'dims'. Optional.
     *&#64;&#64;
     * </pre>
     *
     * <code>.inference.ModelTensorReshape reshape = 5;</code>
     * @return Whether the reshape field is set.
     */
    boolean hasReshape();
    /**
     * <pre>
     *&#64;&#64;  .. cpp:var:: ModelTensorReshape reshape
     *&#64;&#64;
     *&#64;&#64;     The shape produced for this output by the backend. The output will
     *&#64;&#64;     be reshaped from this to the shape specifed in 'dims' before being
     *&#64;&#64;     returned in the inference response. The reshape must have the same
     *&#64;&#64;     number of elements as the output shape specified by 'dims'. Optional.
     *&#64;&#64;
     * </pre>
     *
     * <code>.inference.ModelTensorReshape reshape = 5;</code>
     * @return The reshape.
     */
    org.apache.submarine.server.api.proto.TritonModelConfig.ModelTensorReshape getReshape();
    /**
     * <pre>
     *&#64;&#64;  .. cpp:var:: ModelTensorReshape reshape
     *&#64;&#64;
     *&#64;&#64;     The shape produced for this output by the backend. The output will
     *&#64;&#64;     be reshaped from this to the shape specifed in 'dims' before being
     *&#64;&#64;     returned in the inference response. The reshape must have the same
     *&#64;&#64;     number of elements as the output shape specified by 'dims'. Optional.
     *&#64;&#64;
     * </pre>
     *
     * <code>.inference.ModelTensorReshape reshape = 5;</code>
     */
    org.apache.submarine.server.api.proto.TritonModelConfig.ModelTensorReshapeOrBuilder getReshapeOrBuilder();

    /**
     * <pre>
     *&#64;&#64;  .. cpp:var:: string label_filename
     *&#64;&#64;
     *&#64;&#64;     The label file associated with this output. Should be specified only
     *&#64;&#64;     for outputs that represent classifications. Optional.
     *&#64;&#64;
     * </pre>
     *
     * <code>string label_filename = 4;</code>
     * @return The labelFilename.
     */
    java.lang.String getLabelFilename();
    /**
     * <pre>
     *&#64;&#64;  .. cpp:var:: string label_filename
     *&#64;&#64;
     *&#64;&#64;     The label file associated with this output. Should be specified only
     *&#64;&#64;     for outputs that represent classifications. Optional.
     *&#64;&#64;
     * </pre>
     *
     * <code>string label_filename = 4;</code>
     * @return The bytes for labelFilename.
     */
    com.google.protobuf.ByteString
        getLabelFilenameBytes();

    /**
     * <pre>
     *&#64;&#64;  .. cpp:var:: bool is_shape_tensor
     *&#64;&#64;
     *&#64;&#64;     Whether or not the output is a shape tensor to the model. This field
     *&#64;&#64;     is currently supported only for the TensorRT model. An error will be
     *&#64;&#64;     generated if this specification does not comply with underlying
     *&#64;&#64;     model.
     *&#64;&#64;
     * </pre>
     *
     * <code>bool is_shape_tensor = 6;</code>
     * @return The isShapeTensor.
     */
    boolean getIsShapeTensor();
  }
  /**
   * <pre>
   *&#64;&#64;
   *&#64;&#64;.. cpp:var:: message ModelOutput
   *&#64;&#64;
   *&#64;&#64;   An output produced by the model.
   *&#64;&#64;
   * </pre>
   *
   * Protobuf type {@code inference.ModelOutput}
   */
  public static final class ModelOutput extends
      com.google.protobuf.GeneratedMessageV3 implements
      // @@protoc_insertion_point(message_implements:inference.ModelOutput)
      ModelOutputOrBuilder {
  private static final long serialVersionUID = 0L;
    // Use ModelOutput.newBuilder() to construct.
    private ModelOutput(com.google.protobuf.GeneratedMessageV3.Builder<?> builder) {
      super(builder);
    }
    private ModelOutput() {
      name_ = "";
      dataType_ = 0;
      dims_ = emptyLongList();
      labelFilename_ = "";
    }

    @java.lang.Override
    @SuppressWarnings({"unused"})
    protected java.lang.Object newInstance(
        UnusedPrivateParameter unused) {
      return new ModelOutput();
    }

    @java.lang.Override
    public final com.google.protobuf.UnknownFieldSet
    getUnknownFields() {
      return this.unknownFields;
    }
    private ModelOutput(
        com.google.protobuf.CodedInputStream input,
        com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws com.google.protobuf.InvalidProtocolBufferException {
      this();
      if (extensionRegistry == null) {
        throw new java.lang.NullPointerException();
      }
      int mutable_bitField0_ = 0;
      com.google.protobuf.UnknownFieldSet.Builder unknownFields =
          com.google.protobuf.UnknownFieldSet.newBuilder();
      try {
        boolean done = false;
        while (!done) {
          int tag = input.readTag();
          switch (tag) {
            case 0:
              done = true;
              break;
            case 10: {
              java.lang.String s = input.readStringRequireUtf8();

              name_ = s;
              break;
            }
            case 16: {
              int rawValue = input.readEnum();

              dataType_ = rawValue;
              break;
            }
            case 24: {
              if (!((mutable_bitField0_ & 0x00000001) != 0)) {
                dims_ = newLongList();
                mutable_bitField0_ |= 0x00000001;
              }
              dims_.addLong(input.readInt64());
              break;
            }
            case 26: {
              int length = input.readRawVarint32();
              int limit = input.pushLimit(length);
              if (!((mutable_bitField0_ & 0x00000001) != 0) && input.getBytesUntilLimit() > 0) {
                dims_ = newLongList();
                mutable_bitField0_ |= 0x00000001;
              }
              while (input.getBytesUntilLimit() > 0) {
                dims_.addLong(input.readInt64());
              }
              input.popLimit(limit);
              break;
            }
            case 34: {
              java.lang.String s = input.readStringRequireUtf8();

              labelFilename_ = s;
              break;
            }
            case 42: {
              org.apache.submarine.server.api.proto.TritonModelConfig.ModelTensorReshape.Builder subBuilder = null;
              if (reshape_ != null) {
                subBuilder = reshape_.toBuilder();
              }
              reshape_ = input.readMessage(org.apache.submarine.server.api.proto.TritonModelConfig.ModelTensorReshape.parser(), extensionRegistry);
              if (subBuilder != null) {
                subBuilder.mergeFrom(reshape_);
                reshape_ = subBuilder.buildPartial();
              }

              break;
            }
            case 48: {

              isShapeTensor_ = input.readBool();
              break;
            }
            default: {
              if (!parseUnknownField(
                  input, unknownFields, extensionRegistry, tag)) {
                done = true;
              }
              break;
            }
          }
        }
      } catch (com.google.protobuf.InvalidProtocolBufferException e) {
        throw e.setUnfinishedMessage(this);
      } catch (java.io.IOException e) {
        throw new com.google.protobuf.InvalidProtocolBufferException(
            e).setUnfinishedMessage(this);
      } finally {
        if (((mutable_bitField0_ & 0x00000001) != 0)) {
          dims_.makeImmutable(); // C
        }
        this.unknownFields = unknownFields.build();
        makeExtensionsImmutable();
      }
    }
    public static final com.google.protobuf.Descriptors.Descriptor
        getDescriptor() {
      return org.apache.submarine.server.api.proto.TritonModelConfig.internal_static_inference_ModelOutput_descriptor;
    }

    @java.lang.Override
    protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
        internalGetFieldAccessorTable() {
      return org.apache.submarine.server.api.proto.TritonModelConfig.internal_static_inference_ModelOutput_fieldAccessorTable
          .ensureFieldAccessorsInitialized(
              org.apache.submarine.server.api.proto.TritonModelConfig.ModelOutput.class, org.apache.submarine.server.api.proto.TritonModelConfig.ModelOutput.Builder.class);
    }

    public static final int NAME_FIELD_NUMBER = 1;
    private volatile java.lang.Object name_;
    /**
     * <pre>
     *&#64;&#64;  .. cpp:var:: string name
     *&#64;&#64;
     *&#64;&#64;     The name of the output.
     *&#64;&#64;
     * </pre>
     *
     * <code>string name = 1;</code>
     * @return The name.
     */
    @java.lang.Override
    public java.lang.String getName() {
      java.lang.Object ref = name_;
      if (ref instanceof java.lang.String) {
        return (java.lang.String) ref;
      } else {
        com.google.protobuf.ByteString bs = 
            (com.google.protobuf.ByteString) ref;
        java.lang.String s = bs.toStringUtf8();
        name_ = s;
        return s;
      }
    }
    /**
     * <pre>
     *&#64;&#64;  .. cpp:var:: string name
     *&#64;&#64;
     *&#64;&#64;     The name of the output.
     *&#64;&#64;
     * </pre>
     *
     * <code>string name = 1;</code>
     * @return The bytes for name.
     */
    @java.lang.Override
    public com.google.protobuf.ByteString
        getNameBytes() {
      java.lang.Object ref = name_;
      if (ref instanceof java.lang.String) {
        com.google.protobuf.ByteString b = 
            com.google.protobuf.ByteString.copyFromUtf8(
                (java.lang.String) ref);
        name_ = b;
        return b;
      } else {
        return (com.google.protobuf.ByteString) ref;
      }
    }

    public static final int DATA_TYPE_FIELD_NUMBER = 2;
    private int dataType_;
    /**
     * <pre>
     *&#64;&#64;  .. cpp:var:: DataType data_type
     *&#64;&#64;
     *&#64;&#64;     The data-type of the output.
     *&#64;&#64;
     * </pre>
     *
     * <code>.inference.DataType data_type = 2;</code>
     * @return The enum numeric value on the wire for dataType.
     */
    @java.lang.Override public int getDataTypeValue() {
      return dataType_;
    }
    /**
     * <pre>
     *&#64;&#64;  .. cpp:var:: DataType data_type
     *&#64;&#64;
     *&#64;&#64;     The data-type of the output.
     *&#64;&#64;
     * </pre>
     *
     * <code>.inference.DataType data_type = 2;</code>
     * @return The dataType.
     */
    @java.lang.Override public org.apache.submarine.server.api.proto.TritonModelConfig.DataType getDataType() {
      @SuppressWarnings("deprecation")
      org.apache.submarine.server.api.proto.TritonModelConfig.DataType result = org.apache.submarine.server.api.proto.TritonModelConfig.DataType.valueOf(dataType_);
      return result == null ? org.apache.submarine.server.api.proto.TritonModelConfig.DataType.UNRECOGNIZED : result;
    }

    public static final int DIMS_FIELD_NUMBER = 3;
    private com.google.protobuf.Internal.LongList dims_;
    /**
     * <pre>
     *&#64;&#64;  .. cpp:var:: int64 dims (repeated)
     *&#64;&#64;
     *&#64;&#64;     The dimensions/shape of the output tensor.
     *&#64;&#64;
     * </pre>
     *
     * <code>repeated int64 dims = 3;</code>
     * @return A list containing the dims.
     */
    @java.lang.Override
    public java.util.List<java.lang.Long>
        getDimsList() {
      return dims_;
    }
    /**
     * <pre>
     *&#64;&#64;  .. cpp:var:: int64 dims (repeated)
     *&#64;&#64;
     *&#64;&#64;     The dimensions/shape of the output tensor.
     *&#64;&#64;
     * </pre>
     *
     * <code>repeated int64 dims = 3;</code>
     * @return The count of dims.
     */
    public int getDimsCount() {
      return dims_.size();
    }
    /**
     * <pre>
     *&#64;&#64;  .. cpp:var:: int64 dims (repeated)
     *&#64;&#64;
     *&#64;&#64;     The dimensions/shape of the output tensor.
     *&#64;&#64;
     * </pre>
     *
     * <code>repeated int64 dims = 3;</code>
     * @param index The index of the element to return.
     * @return The dims at the given index.
     */
    public long getDims(int index) {
      return dims_.getLong(index);
    }
    private int dimsMemoizedSerializedSize = -1;

    public static final int RESHAPE_FIELD_NUMBER = 5;
    private org.apache.submarine.server.api.proto.TritonModelConfig.ModelTensorReshape reshape_;
    /**
     * <pre>
     *&#64;&#64;  .. cpp:var:: ModelTensorReshape reshape
     *&#64;&#64;
     *&#64;&#64;     The shape produced for this output by the backend. The output will
     *&#64;&#64;     be reshaped from this to the shape specifed in 'dims' before being
     *&#64;&#64;     returned in the inference response. The reshape must have the same
     *&#64;&#64;     number of elements as the output shape specified by 'dims'. Optional.
     *&#64;&#64;
     * </pre>
     *
     * <code>.inference.ModelTensorReshape reshape = 5;</code>
     * @return Whether the reshape field is set.
     */
    @java.lang.Override
    public boolean hasReshape() {
      return reshape_ != null;
    }
    /**
     * <pre>
     *&#64;&#64;  .. cpp:var:: ModelTensorReshape reshape
     *&#64;&#64;
     *&#64;&#64;     The shape produced for this output by the backend. The output will
     *&#64;&#64;     be reshaped from this to the shape specifed in 'dims' before being
     *&#64;&#64;     returned in the inference response. The reshape must have the same
     *&#64;&#64;     number of elements as the output shape specified by 'dims'. Optional.
     *&#64;&#64;
     * </pre>
     *
     * <code>.inference.ModelTensorReshape reshape = 5;</code>
     * @return The reshape.
     */
    @java.lang.Override
    public org.apache.submarine.server.api.proto.TritonModelConfig.ModelTensorReshape getReshape() {
      return reshape_ == null ? org.apache.submarine.server.api.proto.TritonModelConfig.ModelTensorReshape.getDefaultInstance() : reshape_;
    }
    /**
     * <pre>
     *&#64;&#64;  .. cpp:var:: ModelTensorReshape reshape
     *&#64;&#64;
     *&#64;&#64;     The shape produced for this output by the backend. The output will
     *&#64;&#64;     be reshaped from this to the shape specifed in 'dims' before being
     *&#64;&#64;     returned in the inference response. The reshape must have the same
     *&#64;&#64;     number of elements as the output shape specified by 'dims'. Optional.
     *&#64;&#64;
     * </pre>
     *
     * <code>.inference.ModelTensorReshape reshape = 5;</code>
     */
    @java.lang.Override
    public org.apache.submarine.server.api.proto.TritonModelConfig.ModelTensorReshapeOrBuilder getReshapeOrBuilder() {
      return getReshape();
    }

    public static final int LABEL_FILENAME_FIELD_NUMBER = 4;
    private volatile java.lang.Object labelFilename_;
    /**
     * <pre>
     *&#64;&#64;  .. cpp:var:: string label_filename
     *&#64;&#64;
     *&#64;&#64;     The label file associated with this output. Should be specified only
     *&#64;&#64;     for outputs that represent classifications. Optional.
     *&#64;&#64;
     * </pre>
     *
     * <code>string label_filename = 4;</code>
     * @return The labelFilename.
     */
    @java.lang.Override
    public java.lang.String getLabelFilename() {
      java.lang.Object ref = labelFilename_;
      if (ref instanceof java.lang.String) {
        return (java.lang.String) ref;
      } else {
        com.google.protobuf.ByteString bs = 
            (com.google.protobuf.ByteString) ref;
        java.lang.String s = bs.toStringUtf8();
        labelFilename_ = s;
        return s;
      }
    }
    /**
     * <pre>
     *&#64;&#64;  .. cpp:var:: string label_filename
     *&#64;&#64;
     *&#64;&#64;     The label file associated with this output. Should be specified only
     *&#64;&#64;     for outputs that represent classifications. Optional.
     *&#64;&#64;
     * </pre>
     *
     * <code>string label_filename = 4;</code>
     * @return The bytes for labelFilename.
     */
    @java.lang.Override
    public com.google.protobuf.ByteString
        getLabelFilenameBytes() {
      java.lang.Object ref = labelFilename_;
      if (ref instanceof java.lang.String) {
        com.google.protobuf.ByteString b = 
            com.google.protobuf.ByteString.copyFromUtf8(
                (java.lang.String) ref);
        labelFilename_ = b;
        return b;
      } else {
        return (com.google.protobuf.ByteString) ref;
      }
    }

    public static final int IS_SHAPE_TENSOR_FIELD_NUMBER = 6;
    private boolean isShapeTensor_;
    /**
     * <pre>
     *&#64;&#64;  .. cpp:var:: bool is_shape_tensor
     *&#64;&#64;
     *&#64;&#64;     Whether or not the output is a shape tensor to the model. This field
     *&#64;&#64;     is currently supported only for the TensorRT model. An error will be
     *&#64;&#64;     generated if this specification does not comply with underlying
     *&#64;&#64;     model.
     *&#64;&#64;
     * </pre>
     *
     * <code>bool is_shape_tensor = 6;</code>
     * @return The isShapeTensor.
     */
    @java.lang.Override
    public boolean getIsShapeTensor() {
      return isShapeTensor_;
    }

    private byte memoizedIsInitialized = -1;
    @java.lang.Override
    public final boolean isInitialized() {
      byte isInitialized = memoizedIsInitialized;
      if (isInitialized == 1) return true;
      if (isInitialized == 0) return false;

      memoizedIsInitialized = 1;
      return true;
    }

    @java.lang.Override
    public void writeTo(com.google.protobuf.CodedOutputStream output)
                        throws java.io.IOException {
      getSerializedSize();
      if (!getNameBytes().isEmpty()) {
        com.google.protobuf.GeneratedMessageV3.writeString(output, 1, name_);
      }
      if (dataType_ != org.apache.submarine.server.api.proto.TritonModelConfig.DataType.TYPE_INVALID.getNumber()) {
        output.writeEnum(2, dataType_);
      }
      if (getDimsList().size() > 0) {
        output.writeUInt32NoTag(26);
        output.writeUInt32NoTag(dimsMemoizedSerializedSize);
      }
      for (int i = 0; i < dims_.size(); i++) {
        output.writeInt64NoTag(dims_.getLong(i));
      }
      if (!getLabelFilenameBytes().isEmpty()) {
        com.google.protobuf.GeneratedMessageV3.writeString(output, 4, labelFilename_);
      }
      if (reshape_ != null) {
        output.writeMessage(5, getReshape());
      }
      if (isShapeTensor_ != false) {
        output.writeBool(6, isShapeTensor_);
      }
      unknownFields.writeTo(output);
    }

    @java.lang.Override
    public int getSerializedSize() {
      int size = memoizedSize;
      if (size != -1) return size;

      size = 0;
      if (!getNameBytes().isEmpty()) {
        size += com.google.protobuf.GeneratedMessageV3.computeStringSize(1, name_);
      }
      if (dataType_ != org.apache.submarine.server.api.proto.TritonModelConfig.DataType.TYPE_INVALID.getNumber()) {
        size += com.google.protobuf.CodedOutputStream
          .computeEnumSize(2, dataType_);
      }
      {
        int dataSize = 0;
        for (int i = 0; i < dims_.size(); i++) {
          dataSize += com.google.protobuf.CodedOutputStream
            .computeInt64SizeNoTag(dims_.getLong(i));
        }
        size += dataSize;
        if (!getDimsList().isEmpty()) {
          size += 1;
          size += com.google.protobuf.CodedOutputStream
              .computeInt32SizeNoTag(dataSize);
        }
        dimsMemoizedSerializedSize = dataSize;
      }
      if (!getLabelFilenameBytes().isEmpty()) {
        size += com.google.protobuf.GeneratedMessageV3.computeStringSize(4, labelFilename_);
      }
      if (reshape_ != null) {
        size += com.google.protobuf.CodedOutputStream
          .computeMessageSize(5, getReshape());
      }
      if (isShapeTensor_ != false) {
        size += com.google.protobuf.CodedOutputStream
          .computeBoolSize(6, isShapeTensor_);
      }
      size += unknownFields.getSerializedSize();
      memoizedSize = size;
      return size;
    }

    @java.lang.Override
    public boolean equals(final java.lang.Object obj) {
      if (obj == this) {
       return true;
      }
      if (!(obj instanceof org.apache.submarine.server.api.proto.TritonModelConfig.ModelOutput)) {
        return super.equals(obj);
      }
      org.apache.submarine.server.api.proto.TritonModelConfig.ModelOutput other = (org.apache.submarine.server.api.proto.TritonModelConfig.ModelOutput) obj;

      if (!getName()
          .equals(other.getName())) return false;
      if (dataType_ != other.dataType_) return false;
      if (!getDimsList()
          .equals(other.getDimsList())) return false;
      if (hasReshape() != other.hasReshape()) return false;
      if (hasReshape()) {
        if (!getReshape()
            .equals(other.getReshape())) return false;
      }
      if (!getLabelFilename()
          .equals(other.getLabelFilename())) return false;
      if (getIsShapeTensor()
          != other.getIsShapeTensor()) return false;
      if (!unknownFields.equals(other.unknownFields)) return false;
      return true;
    }

    @java.lang.Override
    public int hashCode() {
      if (memoizedHashCode != 0) {
        return memoizedHashCode;
      }
      int hash = 41;
      hash = (19 * hash) + getDescriptor().hashCode();
      hash = (37 * hash) + NAME_FIELD_NUMBER;
      hash = (53 * hash) + getName().hashCode();
      hash = (37 * hash) + DATA_TYPE_FIELD_NUMBER;
      hash = (53 * hash) + dataType_;
      if (getDimsCount() > 0) {
        hash = (37 * hash) + DIMS_FIELD_NUMBER;
        hash = (53 * hash) + getDimsList().hashCode();
      }
      if (hasReshape()) {
        hash = (37 * hash) + RESHAPE_FIELD_NUMBER;
        hash = (53 * hash) + getReshape().hashCode();
      }
      hash = (37 * hash) + LABEL_FILENAME_FIELD_NUMBER;
      hash = (53 * hash) + getLabelFilename().hashCode();
      hash = (37 * hash) + IS_SHAPE_TENSOR_FIELD_NUMBER;
      hash = (53 * hash) + com.google.protobuf.Internal.hashBoolean(
          getIsShapeTensor());
      hash = (29 * hash) + unknownFields.hashCode();
      memoizedHashCode = hash;
      return hash;
    }

    public static org.apache.submarine.server.api.proto.TritonModelConfig.ModelOutput parseFrom(
        java.nio.ByteBuffer data)
        throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data);
    }
    public static org.apache.submarine.server.api.proto.TritonModelConfig.ModelOutput parseFrom(
        java.nio.ByteBuffer data,
        com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data, extensionRegistry);
    }
    public static org.apache.submarine.server.api.proto.TritonModelConfig.ModelOutput parseFrom(
        com.google.protobuf.ByteString data)
        throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data);
    }
    public static org.apache.submarine.server.api.proto.TritonModelConfig.ModelOutput parseFrom(
        com.google.protobuf.ByteString data,
        com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data, extensionRegistry);
    }
    public static org.apache.submarine.server.api.proto.TritonModelConfig.ModelOutput parseFrom(byte[] data)
        throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data);
    }
    public static org.apache.submarine.server.api.proto.TritonModelConfig.ModelOutput parseFrom(
        byte[] data,
        com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data, extensionRegistry);
    }
    public static org.apache.submarine.server.api.proto.TritonModelConfig.ModelOutput parseFrom(java.io.InputStream input)
        throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3
          .parseWithIOException(PARSER, input);
    }
    public static org.apache.submarine.server.api.proto.TritonModelConfig.ModelOutput parseFrom(
        java.io.InputStream input,
        com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3
          .parseWithIOException(PARSER, input, extensionRegistry);
    }
    public static org.apache.submarine.server.api.proto.TritonModelConfig.ModelOutput parseDelimitedFrom(java.io.InputStream input)
        throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3
          .parseDelimitedWithIOException(PARSER, input);
    }
    public static org.apache.submarine.server.api.proto.TritonModelConfig.ModelOutput parseDelimitedFrom(
        java.io.InputStream input,
        com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3
          .parseDelimitedWithIOException(PARSER, input, extensionRegistry);
    }
    public static org.apache.submarine.server.api.proto.TritonModelConfig.ModelOutput parseFrom(
        com.google.protobuf.CodedInputStream input)
        throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3
          .parseWithIOException(PARSER, input);
    }
    public static org.apache.submarine.server.api.proto.TritonModelConfig.ModelOutput parseFrom(
        com.google.protobuf.CodedInputStream input,
        com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3
          .parseWithIOException(PARSER, input, extensionRegistry);
    }

    @java.lang.Override
    public Builder newBuilderForType() { return newBuilder(); }
    public static Builder newBuilder() {
      return DEFAULT_INSTANCE.toBuilder();
    }
    public static Builder newBuilder(org.apache.submarine.server.api.proto.TritonModelConfig.ModelOutput prototype) {
      return DEFAULT_INSTANCE.toBuilder().mergeFrom(prototype);
    }
    @java.lang.Override
    public Builder toBuilder() {
      return this == DEFAULT_INSTANCE
          ? new Builder() : new Builder().mergeFrom(this);
    }

    @java.lang.Override
    protected Builder newBuilderForType(
        com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
      Builder builder = new Builder(parent);
      return builder;
    }
    /**
     * <pre>
     *&#64;&#64;
     *&#64;&#64;.. cpp:var:: message ModelOutput
     *&#64;&#64;
     *&#64;&#64;   An output produced by the model.
     *&#64;&#64;
     * </pre>
     *
     * Protobuf type {@code inference.ModelOutput}
     */
    public static final class Builder extends
        com.google.protobuf.GeneratedMessageV3.Builder<Builder> implements
        // @@protoc_insertion_point(builder_implements:inference.ModelOutput)
        org.apache.submarine.server.api.proto.TritonModelConfig.ModelOutputOrBuilder {
      public static final com.google.protobuf.Descriptors.Descriptor
          getDescriptor() {
        return org.apache.submarine.server.api.proto.TritonModelConfig.internal_static_inference_ModelOutput_descriptor;
      }

      @java.lang.Override
      protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
          internalGetFieldAccessorTable() {
        return org.apache.submarine.server.api.proto.TritonModelConfig.internal_static_inference_ModelOutput_fieldAccessorTable
            .ensureFieldAccessorsInitialized(
                org.apache.submarine.server.api.proto.TritonModelConfig.ModelOutput.class, org.apache.submarine.server.api.proto.TritonModelConfig.ModelOutput.Builder.class);
      }

      // Construct using org.apache.submarine.server.api.proto.TritonModelConfig.ModelOutput.newBuilder()
      private Builder() {
        maybeForceBuilderInitialization();
      }

      private Builder(
          com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
        super(parent);
        maybeForceBuilderInitialization();
      }
      private void maybeForceBuilderInitialization() {
        if (com.google.protobuf.GeneratedMessageV3
                .alwaysUseFieldBuilders) {
        }
      }
      @java.lang.Override
      public Builder clear() {
        super.clear();
        name_ = "";

        dataType_ = 0;

        dims_ = emptyLongList();
        bitField0_ = (bitField0_ & ~0x00000001);
        if (reshapeBuilder_ == null) {
          reshape_ = null;
        } else {
          reshape_ = null;
          reshapeBuilder_ = null;
        }
        labelFilename_ = "";

        isShapeTensor_ = false;

        return this;
      }

      @java.lang.Override
      public com.google.protobuf.Descriptors.Descriptor
          getDescriptorForType() {
        return org.apache.submarine.server.api.proto.TritonModelConfig.internal_static_inference_ModelOutput_descriptor;
      }

      @java.lang.Override
      public org.apache.submarine.server.api.proto.TritonModelConfig.ModelOutput getDefaultInstanceForType() {
        return org.apache.submarine.server.api.proto.TritonModelConfig.ModelOutput.getDefaultInstance();
      }

      @java.lang.Override
      public org.apache.submarine.server.api.proto.TritonModelConfig.ModelOutput build() {
        org.apache.submarine.server.api.proto.TritonModelConfig.ModelOutput result = buildPartial();
        if (!result.isInitialized()) {
          throw newUninitializedMessageException(result);
        }
        return result;
      }

      @java.lang.Override
      public org.apache.submarine.server.api.proto.TritonModelConfig.ModelOutput buildPartial() {
        org.apache.submarine.server.api.proto.TritonModelConfig.ModelOutput result = new org.apache.submarine.server.api.proto.TritonModelConfig.ModelOutput(this);
        int from_bitField0_ = bitField0_;
        result.name_ = name_;
        result.dataType_ = dataType_;
        if (((bitField0_ & 0x00000001) != 0)) {
          dims_.makeImmutable();
          bitField0_ = (bitField0_ & ~0x00000001);
        }
        result.dims_ = dims_;
        if (reshapeBuilder_ == null) {
          result.reshape_ = reshape_;
        } else {
          result.reshape_ = reshapeBuilder_.build();
        }
        result.labelFilename_ = labelFilename_;
        result.isShapeTensor_ = isShapeTensor_;
        onBuilt();
        return result;
      }

      @java.lang.Override
      public Builder clone() {
        return super.clone();
      }
      @java.lang.Override
      public Builder setField(
          com.google.protobuf.Descriptors.FieldDescriptor field,
          java.lang.Object value) {
        return super.setField(field, value);
      }
      @java.lang.Override
      public Builder clearField(
          com.google.protobuf.Descriptors.FieldDescriptor field) {
        return super.clearField(field);
      }
      @java.lang.Override
      public Builder clearOneof(
          com.google.protobuf.Descriptors.OneofDescriptor oneof) {
        return super.clearOneof(oneof);
      }
      @java.lang.Override
      public Builder setRepeatedField(
          com.google.protobuf.Descriptors.FieldDescriptor field,
          int index, java.lang.Object value) {
        return super.setRepeatedField(field, index, value);
      }
      @java.lang.Override
      public Builder addRepeatedField(
          com.google.protobuf.Descriptors.FieldDescriptor field,
          java.lang.Object value) {
        return super.addRepeatedField(field, value);
      }
      @java.lang.Override
      public Builder mergeFrom(com.google.protobuf.Message other) {
        if (other instanceof org.apache.submarine.server.api.proto.TritonModelConfig.ModelOutput) {
          return mergeFrom((org.apache.submarine.server.api.proto.TritonModelConfig.ModelOutput)other);
        } else {
          super.mergeFrom(other);
          return this;
        }
      }

      public Builder mergeFrom(org.apache.submarine.server.api.proto.TritonModelConfig.ModelOutput other) {
        if (other == org.apache.submarine.server.api.proto.TritonModelConfig.ModelOutput.getDefaultInstance()) return this;
        if (!other.getName().isEmpty()) {
          name_ = other.name_;
          onChanged();
        }
        if (other.dataType_ != 0) {
          setDataTypeValue(other.getDataTypeValue());
        }
        if (!other.dims_.isEmpty()) {
          if (dims_.isEmpty()) {
            dims_ = other.dims_;
            bitField0_ = (bitField0_ & ~0x00000001);
          } else {
            ensureDimsIsMutable();
            dims_.addAll(other.dims_);
          }
          onChanged();
        }
        if (other.hasReshape()) {
          mergeReshape(other.getReshape());
        }
        if (!other.getLabelFilename().isEmpty()) {
          labelFilename_ = other.labelFilename_;
          onChanged();
        }
        if (other.getIsShapeTensor() != false) {
          setIsShapeTensor(other.getIsShapeTensor());
        }
        this.mergeUnknownFields(other.unknownFields);
        onChanged();
        return this;
      }

      @java.lang.Override
      public final boolean isInitialized() {
        return true;
      }

      @java.lang.Override
      public Builder mergeFrom(
          com.google.protobuf.CodedInputStream input,
          com.google.protobuf.ExtensionRegistryLite extensionRegistry)
          throws java.io.IOException {
        org.apache.submarine.server.api.proto.TritonModelConfig.ModelOutput parsedMessage = null;
        try {
          parsedMessage = PARSER.parsePartialFrom(input, extensionRegistry);
        } catch (com.google.protobuf.InvalidProtocolBufferException e) {
          parsedMessage = (org.apache.submarine.server.api.proto.TritonModelConfig.ModelOutput) e.getUnfinishedMessage();
          throw e.unwrapIOException();
        } finally {
          if (parsedMessage != null) {
            mergeFrom(parsedMessage);
          }
        }
        return this;
      }
      private int bitField0_;

      private java.lang.Object name_ = "";
      /**
       * <pre>
       *&#64;&#64;  .. cpp:var:: string name
       *&#64;&#64;
       *&#64;&#64;     The name of the output.
       *&#64;&#64;
       * </pre>
       *
       * <code>string name = 1;</code>
       * @return The name.
       */
      public java.lang.String getName() {
        java.lang.Object ref = name_;
        if (!(ref instanceof java.lang.String)) {
          com.google.protobuf.ByteString bs =
              (com.google.protobuf.ByteString) ref;
          java.lang.String s = bs.toStringUtf8();
          name_ = s;
          return s;
        } else {
          return (java.lang.String) ref;
        }
      }
      /**
       * <pre>
       *&#64;&#64;  .. cpp:var:: string name
       *&#64;&#64;
       *&#64;&#64;     The name of the output.
       *&#64;&#64;
       * </pre>
       *
       * <code>string name = 1;</code>
       * @return The bytes for name.
       */
      public com.google.protobuf.ByteString
          getNameBytes() {
        java.lang.Object ref = name_;
        if (ref instanceof String) {
          com.google.protobuf.ByteString b = 
              com.google.protobuf.ByteString.copyFromUtf8(
                  (java.lang.String) ref);
          name_ = b;
          return b;
        } else {
          return (com.google.protobuf.ByteString) ref;
        }
      }
      /**
       * <pre>
       *&#64;&#64;  .. cpp:var:: string name
       *&#64;&#64;
       *&#64;&#64;     The name of the output.
       *&#64;&#64;
       * </pre>
       *
       * <code>string name = 1;</code>
       * @param value The name to set.
       * @return This builder for chaining.
       */
      public Builder setName(
          java.lang.String value) {
        if (value == null) {
    throw new NullPointerException();
  }
  
        name_ = value;
        onChanged();
        return this;
      }
      /**
       * <pre>
       *&#64;&#64;  .. cpp:var:: string name
       *&#64;&#64;
       *&#64;&#64;     The name of the output.
       *&#64;&#64;
       * </pre>
       *
       * <code>string name = 1;</code>
       * @return This builder for chaining.
       */
      public Builder clearName() {
        
        name_ = getDefaultInstance().getName();
        onChanged();
        return this;
      }
      /**
       * <pre>
       *&#64;&#64;  .. cpp:var:: string name
       *&#64;&#64;
       *&#64;&#64;     The name of the output.
       *&#64;&#64;
       * </pre>
       *
       * <code>string name = 1;</code>
       * @param value The bytes for name to set.
       * @return This builder for chaining.
       */
      public Builder setNameBytes(
          com.google.protobuf.ByteString value) {
        if (value == null) {
    throw new NullPointerException();
  }
  checkByteStringIsUtf8(value);
        
        name_ = value;
        onChanged();
        return this;
      }

      private int dataType_ = 0;
      /**
       * <pre>
       *&#64;&#64;  .. cpp:var:: DataType data_type
       *&#64;&#64;
       *&#64;&#64;     The data-type of the output.
       *&#64;&#64;
       * </pre>
       *
       * <code>.inference.DataType data_type = 2;</code>
       * @return The enum numeric value on the wire for dataType.
       */
      @java.lang.Override public int getDataTypeValue() {
        return dataType_;
      }
      /**
       * <pre>
       *&#64;&#64;  .. cpp:var:: DataType data_type
       *&#64;&#64;
       *&#64;&#64;     The data-type of the output.
       *&#64;&#64;
       * </pre>
       *
       * <code>.inference.DataType data_type = 2;</code>
       * @param value The enum numeric value on the wire for dataType to set.
       * @return This builder for chaining.
       */
      public Builder setDataTypeValue(int value) {
        
        dataType_ = value;
        onChanged();
        return this;
      }
      /**
       * <pre>
       *&#64;&#64;  .. cpp:var:: DataType data_type
       *&#64;&#64;
       *&#64;&#64;     The data-type of the output.
       *&#64;&#64;
       * </pre>
       *
       * <code>.inference.DataType data_type = 2;</code>
       * @return The dataType.
       */
      @java.lang.Override
      public org.apache.submarine.server.api.proto.TritonModelConfig.DataType getDataType() {
        @SuppressWarnings("deprecation")
        org.apache.submarine.server.api.proto.TritonModelConfig.DataType result = org.apache.submarine.server.api.proto.TritonModelConfig.DataType.valueOf(dataType_);
        return result == null ? org.apache.submarine.server.api.proto.TritonModelConfig.DataType.UNRECOGNIZED : result;
      }
      /**
       * <pre>
       *&#64;&#64;  .. cpp:var:: DataType data_type
       *&#64;&#64;
       *&#64;&#64;     The data-type of the output.
       *&#64;&#64;
       * </pre>
       *
       * <code>.inference.DataType data_type = 2;</code>
       * @param value The dataType to set.
       * @return This builder for chaining.
       */
      public Builder setDataType(org.apache.submarine.server.api.proto.TritonModelConfig.DataType value) {
        if (value == null) {
          throw new NullPointerException();
        }
        
        dataType_ = value.getNumber();
        onChanged();
        return this;
      }
      /**
       * <pre>
       *&#64;&#64;  .. cpp:var:: DataType data_type
       *&#64;&#64;
       *&#64;&#64;     The data-type of the output.
       *&#64;&#64;
       * </pre>
       *
       * <code>.inference.DataType data_type = 2;</code>
       * @return This builder for chaining.
       */
      public Builder clearDataType() {
        
        dataType_ = 0;
        onChanged();
        return this;
      }

      private com.google.protobuf.Internal.LongList dims_ = emptyLongList();
      private void ensureDimsIsMutable() {
        if (!((bitField0_ & 0x00000001) != 0)) {
          dims_ = mutableCopy(dims_);
          bitField0_ |= 0x00000001;
         }
      }
      /**
       * <pre>
       *&#64;&#64;  .. cpp:var:: int64 dims (repeated)
       *&#64;&#64;
       *&#64;&#64;     The dimensions/shape of the output tensor.
       *&#64;&#64;
       * </pre>
       *
       * <code>repeated int64 dims = 3;</code>
       * @return A list containing the dims.
       */
      public java.util.List<java.lang.Long>
          getDimsList() {
        return ((bitField0_ & 0x00000001) != 0) ?
                 java.util.Collections.unmodifiableList(dims_) : dims_;
      }
      /**
       * <pre>
       *&#64;&#64;  .. cpp:var:: int64 dims (repeated)
       *&#64;&#64;
       *&#64;&#64;     The dimensions/shape of the output tensor.
       *&#64;&#64;
       * </pre>
       *
       * <code>repeated int64 dims = 3;</code>
       * @return The count of dims.
       */
      public int getDimsCount() {
        return dims_.size();
      }
      /**
       * <pre>
       *&#64;&#64;  .. cpp:var:: int64 dims (repeated)
       *&#64;&#64;
       *&#64;&#64;     The dimensions/shape of the output tensor.
       *&#64;&#64;
       * </pre>
       *
       * <code>repeated int64 dims = 3;</code>
       * @param index The index of the element to return.
       * @return The dims at the given index.
       */
      public long getDims(int index) {
        return dims_.getLong(index);
      }
      /**
       * <pre>
       *&#64;&#64;  .. cpp:var:: int64 dims (repeated)
       *&#64;&#64;
       *&#64;&#64;     The dimensions/shape of the output tensor.
       *&#64;&#64;
       * </pre>
       *
       * <code>repeated int64 dims = 3;</code>
       * @param index The index to set the value at.
       * @param value The dims to set.
       * @return This builder for chaining.
       */
      public Builder setDims(
          int index, long value) {
        ensureDimsIsMutable();
        dims_.setLong(index, value);
        onChanged();
        return this;
      }
      /**
       * <pre>
       *&#64;&#64;  .. cpp:var:: int64 dims (repeated)
       *&#64;&#64;
       *&#64;&#64;     The dimensions/shape of the output tensor.
       *&#64;&#64;
       * </pre>
       *
       * <code>repeated int64 dims = 3;</code>
       * @param value The dims to add.
       * @return This builder for chaining.
       */
      public Builder addDims(long value) {
        ensureDimsIsMutable();
        dims_.addLong(value);
        onChanged();
        return this;
      }
      /**
       * <pre>
       *&#64;&#64;  .. cpp:var:: int64 dims (repeated)
       *&#64;&#64;
       *&#64;&#64;     The dimensions/shape of the output tensor.
       *&#64;&#64;
       * </pre>
       *
       * <code>repeated int64 dims = 3;</code>
       * @param values The dims to add.
       * @return This builder for chaining.
       */
      public Builder addAllDims(
          java.lang.Iterable<? extends java.lang.Long> values) {
        ensureDimsIsMutable();
        com.google.protobuf.AbstractMessageLite.Builder.addAll(
            values, dims_);
        onChanged();
        return this;
      }
      /**
       * <pre>
       *&#64;&#64;  .. cpp:var:: int64 dims (repeated)
       *&#64;&#64;
       *&#64;&#64;     The dimensions/shape of the output tensor.
       *&#64;&#64;
       * </pre>
       *
       * <code>repeated int64 dims = 3;</code>
       * @return This builder for chaining.
       */
      public Builder clearDims() {
        dims_ = emptyLongList();
        bitField0_ = (bitField0_ & ~0x00000001);
        onChanged();
        return this;
      }

      private org.apache.submarine.server.api.proto.TritonModelConfig.ModelTensorReshape reshape_;
      private com.google.protobuf.SingleFieldBuilderV3<
          org.apache.submarine.server.api.proto.TritonModelConfig.ModelTensorReshape, org.apache.submarine.server.api.proto.TritonModelConfig.ModelTensorReshape.Builder, org.apache.submarine.server.api.proto.TritonModelConfig.ModelTensorReshapeOrBuilder> reshapeBuilder_;
      /**
       * <pre>
       *&#64;&#64;  .. cpp:var:: ModelTensorReshape reshape
       *&#64;&#64;
       *&#64;&#64;     The shape produced for this output by the backend. The output will
       *&#64;&#64;     be reshaped from this to the shape specifed in 'dims' before being
       *&#64;&#64;     returned in the inference response. The reshape must have the same
       *&#64;&#64;     number of elements as the output shape specified by 'dims'. Optional.
       *&#64;&#64;
       * </pre>
       *
       * <code>.inference.ModelTensorReshape reshape = 5;</code>
       * @return Whether the reshape field is set.
       */
      public boolean hasReshape() {
        return reshapeBuilder_ != null || reshape_ != null;
      }
      /**
       * <pre>
       *&#64;&#64;  .. cpp:var:: ModelTensorReshape reshape
       *&#64;&#64;
       *&#64;&#64;     The shape produced for this output by the backend. The output will
       *&#64;&#64;     be reshaped from this to the shape specifed in 'dims' before being
       *&#64;&#64;     returned in the inference response. The reshape must have the same
       *&#64;&#64;     number of elements as the output shape specified by 'dims'. Optional.
       *&#64;&#64;
       * </pre>
       *
       * <code>.inference.ModelTensorReshape reshape = 5;</code>
       * @return The reshape.
       */
      public org.apache.submarine.server.api.proto.TritonModelConfig.ModelTensorReshape getReshape() {
        if (reshapeBuilder_ == null) {
          return reshape_ == null ? org.apache.submarine.server.api.proto.TritonModelConfig.ModelTensorReshape.getDefaultInstance() : reshape_;
        } else {
          return reshapeBuilder_.getMessage();
        }
      }
      /**
       * <pre>
       *&#64;&#64;  .. cpp:var:: ModelTensorReshape reshape
       *&#64;&#64;
       *&#64;&#64;     The shape produced for this output by the backend. The output will
       *&#64;&#64;     be reshaped from this to the shape specifed in 'dims' before being
       *&#64;&#64;     returned in the inference response. The reshape must have the same
       *&#64;&#64;     number of elements as the output shape specified by 'dims'. Optional.
       *&#64;&#64;
       * </pre>
       *
       * <code>.inference.ModelTensorReshape reshape = 5;</code>
       */
      public Builder setReshape(org.apache.submarine.server.api.proto.TritonModelConfig.ModelTensorReshape value) {
        if (reshapeBuilder_ == null) {
          if (value == null) {
            throw new NullPointerException();
          }
          reshape_ = value;
          onChanged();
        } else {
          reshapeBuilder_.setMessage(value);
        }

        return this;
      }
      /**
       * <pre>
       *&#64;&#64;  .. cpp:var:: ModelTensorReshape reshape
       *&#64;&#64;
       *&#64;&#64;     The shape produced for this output by the backend. The output will
       *&#64;&#64;     be reshaped from this to the shape specifed in 'dims' before being
       *&#64;&#64;     returned in the inference response. The reshape must have the same
       *&#64;&#64;     number of elements as the output shape specified by 'dims'. Optional.
       *&#64;&#64;
       * </pre>
       *
       * <code>.inference.ModelTensorReshape reshape = 5;</code>
       */
      public Builder setReshape(
          org.apache.submarine.server.api.proto.TritonModelConfig.ModelTensorReshape.Builder builderForValue) {
        if (reshapeBuilder_ == null) {
          reshape_ = builderForValue.build();
          onChanged();
        } else {
          reshapeBuilder_.setMessage(builderForValue.build());
        }

        return this;
      }
      /**
       * <pre>
       *&#64;&#64;  .. cpp:var:: ModelTensorReshape reshape
       *&#64;&#64;
       *&#64;&#64;     The shape produced for this output by the backend. The output will
       *&#64;&#64;     be reshaped from this to the shape specifed in 'dims' before being
       *&#64;&#64;     returned in the inference response. The reshape must have the same
       *&#64;&#64;     number of elements as the output shape specified by 'dims'. Optional.
       *&#64;&#64;
       * </pre>
       *
       * <code>.inference.ModelTensorReshape reshape = 5;</code>
       */
      public Builder mergeReshape(org.apache.submarine.server.api.proto.TritonModelConfig.ModelTensorReshape value) {
        if (reshapeBuilder_ == null) {
          if (reshape_ != null) {
            reshape_ =
              org.apache.submarine.server.api.proto.TritonModelConfig.ModelTensorReshape.newBuilder(reshape_).mergeFrom(value).buildPartial();
          } else {
            reshape_ = value;
          }
          onChanged();
        } else {
          reshapeBuilder_.mergeFrom(value);
        }

        return this;
      }
      /**
       * <pre>
       *&#64;&#64;  .. cpp:var:: ModelTensorReshape reshape
       *&#64;&#64;
       *&#64;&#64;     The shape produced for this output by the backend. The output will
       *&#64;&#64;     be reshaped from this to the shape specifed in 'dims' before being
       *&#64;&#64;     returned in the inference response. The reshape must have the same
       *&#64;&#64;     number of elements as the output shape specified by 'dims'. Optional.
       *&#64;&#64;
       * </pre>
       *
       * <code>.inference.ModelTensorReshape reshape = 5;</code>
       */
      public Builder clearReshape() {
        if (reshapeBuilder_ == null) {
          reshape_ = null;
          onChanged();
        } else {
          reshape_ = null;
          reshapeBuilder_ = null;
        }

        return this;
      }
      /**
       * <pre>
       *&#64;&#64;  .. cpp:var:: ModelTensorReshape reshape
       *&#64;&#64;
       *&#64;&#64;     The shape produced for this output by the backend. The output will
       *&#64;&#64;     be reshaped from this to the shape specifed in 'dims' before being
       *&#64;&#64;     returned in the inference response. The reshape must have the same
       *&#64;&#64;     number of elements as the output shape specified by 'dims'. Optional.
       *&#64;&#64;
       * </pre>
       *
       * <code>.inference.ModelTensorReshape reshape = 5;</code>
       */
      public org.apache.submarine.server.api.proto.TritonModelConfig.ModelTensorReshape.Builder getReshapeBuilder() {
        
        onChanged();
        return getReshapeFieldBuilder().getBuilder();
      }
      /**
       * <pre>
       *&#64;&#64;  .. cpp:var:: ModelTensorReshape reshape
       *&#64;&#64;
       *&#64;&#64;     The shape produced for this output by the backend. The output will
       *&#64;&#64;     be reshaped from this to the shape specifed in 'dims' before being
       *&#64;&#64;     returned in the inference response. The reshape must have the same
       *&#64;&#64;     number of elements as the output shape specified by 'dims'. Optional.
       *&#64;&#64;
       * </pre>
       *
       * <code>.inference.ModelTensorReshape reshape = 5;</code>
       */
      public org.apache.submarine.server.api.proto.TritonModelConfig.ModelTensorReshapeOrBuilder getReshapeOrBuilder() {
        if (reshapeBuilder_ != null) {
          return reshapeBuilder_.getMessageOrBuilder();
        } else {
          return reshape_ == null ?
              org.apache.submarine.server.api.proto.TritonModelConfig.ModelTensorReshape.getDefaultInstance() : reshape_;
        }
      }
      /**
       * <pre>
       *&#64;&#64;  .. cpp:var:: ModelTensorReshape reshape
       *&#64;&#64;
       *&#64;&#64;     The shape produced for this output by the backend. The output will
       *&#64;&#64;     be reshaped from this to the shape specifed in 'dims' before being
       *&#64;&#64;     returned in the inference response. The reshape must have the same
       *&#64;&#64;     number of elements as the output shape specified by 'dims'. Optional.
       *&#64;&#64;
       * </pre>
       *
       * <code>.inference.ModelTensorReshape reshape = 5;</code>
       */
      private com.google.protobuf.SingleFieldBuilderV3<
          org.apache.submarine.server.api.proto.TritonModelConfig.ModelTensorReshape, org.apache.submarine.server.api.proto.TritonModelConfig.ModelTensorReshape.Builder, org.apache.submarine.server.api.proto.TritonModelConfig.ModelTensorReshapeOrBuilder> 
          getReshapeFieldBuilder() {
        if (reshapeBuilder_ == null) {
          reshapeBuilder_ = new com.google.protobuf.SingleFieldBuilderV3<
              org.apache.submarine.server.api.proto.TritonModelConfig.ModelTensorReshape, org.apache.submarine.server.api.proto.TritonModelConfig.ModelTensorReshape.Builder, org.apache.submarine.server.api.proto.TritonModelConfig.ModelTensorReshapeOrBuilder>(
                  getReshape(),
                  getParentForChildren(),
                  isClean());
          reshape_ = null;
        }
        return reshapeBuilder_;
      }

      private java.lang.Object labelFilename_ = "";
      /**
       * <pre>
       *&#64;&#64;  .. cpp:var:: string label_filename
       *&#64;&#64;
       *&#64;&#64;     The label file associated with this output. Should be specified only
       *&#64;&#64;     for outputs that represent classifications. Optional.
       *&#64;&#64;
       * </pre>
       *
       * <code>string label_filename = 4;</code>
       * @return The labelFilename.
       */
      public java.lang.String getLabelFilename() {
        java.lang.Object ref = labelFilename_;
        if (!(ref instanceof java.lang.String)) {
          com.google.protobuf.ByteString bs =
              (com.google.protobuf.ByteString) ref;
          java.lang.String s = bs.toStringUtf8();
          labelFilename_ = s;
          return s;
        } else {
          return (java.lang.String) ref;
        }
      }
      /**
       * <pre>
       *&#64;&#64;  .. cpp:var:: string label_filename
       *&#64;&#64;
       *&#64;&#64;     The label file associated with this output. Should be specified only
       *&#64;&#64;     for outputs that represent classifications. Optional.
       *&#64;&#64;
       * </pre>
       *
       * <code>string label_filename = 4;</code>
       * @return The bytes for labelFilename.
       */
      public com.google.protobuf.ByteString
          getLabelFilenameBytes() {
        java.lang.Object ref = labelFilename_;
        if (ref instanceof String) {
          com.google.protobuf.ByteString b = 
              com.google.protobuf.ByteString.copyFromUtf8(
                  (java.lang.String) ref);
          labelFilename_ = b;
          return b;
        } else {
          return (com.google.protobuf.ByteString) ref;
        }
      }
      /**
       * <pre>
       *&#64;&#64;  .. cpp:var:: string label_filename
       *&#64;&#64;
       *&#64;&#64;     The label file associated with this output. Should be specified only
       *&#64;&#64;     for outputs that represent classifications. Optional.
       *&#64;&#64;
       * </pre>
       *
       * <code>string label_filename = 4;</code>
       * @param value The labelFilename to set.
       * @return This builder for chaining.
       */
      public Builder setLabelFilename(
          java.lang.String value) {
        if (value == null) {
    throw new NullPointerException();
  }
  
        labelFilename_ = value;
        onChanged();
        return this;
      }
      /**
       * <pre>
       *&#64;&#64;  .. cpp:var:: string label_filename
       *&#64;&#64;
       *&#64;&#64;     The label file associated with this output. Should be specified only
       *&#64;&#64;     for outputs that represent classifications. Optional.
       *&#64;&#64;
       * </pre>
       *
       * <code>string label_filename = 4;</code>
       * @return This builder for chaining.
       */
      public Builder clearLabelFilename() {
        
        labelFilename_ = getDefaultInstance().getLabelFilename();
        onChanged();
        return this;
      }
      /**
       * <pre>
       *&#64;&#64;  .. cpp:var:: string label_filename
       *&#64;&#64;
       *&#64;&#64;     The label file associated with this output. Should be specified only
       *&#64;&#64;     for outputs that represent classifications. Optional.
       *&#64;&#64;
       * </pre>
       *
       * <code>string label_filename = 4;</code>
       * @param value The bytes for labelFilename to set.
       * @return This builder for chaining.
       */
      public Builder setLabelFilenameBytes(
          com.google.protobuf.ByteString value) {
        if (value == null) {
    throw new NullPointerException();
  }
  checkByteStringIsUtf8(value);
        
        labelFilename_ = value;
        onChanged();
        return this;
      }

      private boolean isShapeTensor_ ;
      /**
       * <pre>
       *&#64;&#64;  .. cpp:var:: bool is_shape_tensor
       *&#64;&#64;
       *&#64;&#64;     Whether or not the output is a shape tensor to the model. This field
       *&#64;&#64;     is currently supported only for the TensorRT model. An error will be
       *&#64;&#64;     generated if this specification does not comply with underlying
       *&#64;&#64;     model.
       *&#64;&#64;
       * </pre>
       *
       * <code>bool is_shape_tensor = 6;</code>
       * @return The isShapeTensor.
       */
      @java.lang.Override
      public boolean getIsShapeTensor() {
        return isShapeTensor_;
      }
      /**
       * <pre>
       *&#64;&#64;  .. cpp:var:: bool is_shape_tensor
       *&#64;&#64;
       *&#64;&#64;     Whether or not the output is a shape tensor to the model. This field
       *&#64;&#64;     is currently supported only for the TensorRT model. An error will be
       *&#64;&#64;     generated if this specification does not comply with underlying
       *&#64;&#64;     model.
       *&#64;&#64;
       * </pre>
       *
       * <code>bool is_shape_tensor = 6;</code>
       * @param value The isShapeTensor to set.
       * @return This builder for chaining.
       */
      public Builder setIsShapeTensor(boolean value) {
        
        isShapeTensor_ = value;
        onChanged();
        return this;
      }
      /**
       * <pre>
       *&#64;&#64;  .. cpp:var:: bool is_shape_tensor
       *&#64;&#64;
       *&#64;&#64;     Whether or not the output is a shape tensor to the model. This field
       *&#64;&#64;     is currently supported only for the TensorRT model. An error will be
       *&#64;&#64;     generated if this specification does not comply with underlying
       *&#64;&#64;     model.
       *&#64;&#64;
       * </pre>
       *
       * <code>bool is_shape_tensor = 6;</code>
       * @return This builder for chaining.
       */
      public Builder clearIsShapeTensor() {
        
        isShapeTensor_ = false;
        onChanged();
        return this;
      }
      @java.lang.Override
      public final Builder setUnknownFields(
          final com.google.protobuf.UnknownFieldSet unknownFields) {
        return super.setUnknownFields(unknownFields);
      }

      @java.lang.Override
      public final Builder mergeUnknownFields(
          final com.google.protobuf.UnknownFieldSet unknownFields) {
        return super.mergeUnknownFields(unknownFields);
      }


      // @@protoc_insertion_point(builder_scope:inference.ModelOutput)
    }

    // @@protoc_insertion_point(class_scope:inference.ModelOutput)
    private static final org.apache.submarine.server.api.proto.TritonModelConfig.ModelOutput DEFAULT_INSTANCE;
    static {
      DEFAULT_INSTANCE = new org.apache.submarine.server.api.proto.TritonModelConfig.ModelOutput();
    }

    public static org.apache.submarine.server.api.proto.TritonModelConfig.ModelOutput getDefaultInstance() {
      return DEFAULT_INSTANCE;
    }

    private static final com.google.protobuf.Parser<ModelOutput>
        PARSER = new com.google.protobuf.AbstractParser<ModelOutput>() {
      @java.lang.Override
      public ModelOutput parsePartialFrom(
          com.google.protobuf.CodedInputStream input,
          com.google.protobuf.ExtensionRegistryLite extensionRegistry)
          throws com.google.protobuf.InvalidProtocolBufferException {
        return new ModelOutput(input, extensionRegistry);
      }
    };

    public static com.google.protobuf.Parser<ModelOutput> parser() {
      return PARSER;
    }

    @java.lang.Override
    public com.google.protobuf.Parser<ModelOutput> getParserForType() {
      return PARSER;
    }

    @java.lang.Override
    public org.apache.submarine.server.api.proto.TritonModelConfig.ModelOutput getDefaultInstanceForType() {
      return DEFAULT_INSTANCE;
    }

  }

  public interface BatchInputOrBuilder extends
      // @@protoc_insertion_point(interface_extends:inference.BatchInput)
      com.google.protobuf.MessageOrBuilder {

    /**
     * <pre>
     *&#64;&#64;    .. cpp:var:: Kind kind
     *&#64;&#64;
     *&#64;&#64;       The kind of this batch input.
     *&#64;&#64;
     * </pre>
     *
     * <code>.inference.BatchInput.Kind kind = 1;</code>
     * @return The enum numeric value on the wire for kind.
     */
    int getKindValue();
    /**
     * <pre>
     *&#64;&#64;    .. cpp:var:: Kind kind
     *&#64;&#64;
     *&#64;&#64;       The kind of this batch input.
     *&#64;&#64;
     * </pre>
     *
     * <code>.inference.BatchInput.Kind kind = 1;</code>
     * @return The kind.
     */
    org.apache.submarine.server.api.proto.TritonModelConfig.BatchInput.Kind getKind();

    /**
     * <pre>
     *&#64;&#64;    .. cpp:var:: string target_name (repeated)
     *&#64;&#64;
     *&#64;&#64;       The name of the model inputs that the backend will create
     *&#64;&#64;       for this batch input.
     *&#64;&#64;
     * </pre>
     *
     * <code>repeated string target_name = 2;</code>
     * @return A list containing the targetName.
     */
    java.util.List<java.lang.String>
        getTargetNameList();
    /**
     * <pre>
     *&#64;&#64;    .. cpp:var:: string target_name (repeated)
     *&#64;&#64;
     *&#64;&#64;       The name of the model inputs that the backend will create
     *&#64;&#64;       for this batch input.
     *&#64;&#64;
     * </pre>
     *
     * <code>repeated string target_name = 2;</code>
     * @return The count of targetName.
     */
    int getTargetNameCount();
    /**
     * <pre>
     *&#64;&#64;    .. cpp:var:: string target_name (repeated)
     *&#64;&#64;
     *&#64;&#64;       The name of the model inputs that the backend will create
     *&#64;&#64;       for this batch input.
     *&#64;&#64;
     * </pre>
     *
     * <code>repeated string target_name = 2;</code>
     * @param index The index of the element to return.
     * @return The targetName at the given index.
     */
    java.lang.String getTargetName(int index);
    /**
     * <pre>
     *&#64;&#64;    .. cpp:var:: string target_name (repeated)
     *&#64;&#64;
     *&#64;&#64;       The name of the model inputs that the backend will create
     *&#64;&#64;       for this batch input.
     *&#64;&#64;
     * </pre>
     *
     * <code>repeated string target_name = 2;</code>
     * @param index The index of the value to return.
     * @return The bytes of the targetName at the given index.
     */
    com.google.protobuf.ByteString
        getTargetNameBytes(int index);

    /**
     * <pre>
     *&#64;&#64;    .. cpp:var:: DataType data_type
     *&#64;&#64;
     *&#64;&#64;       The input's datatype. The data type can be TYPE_INT32 or
     *&#64;&#64;       TYPE_FP32.
     *&#64;&#64;
     * </pre>
     *
     * <code>.inference.DataType data_type = 3;</code>
     * @return The enum numeric value on the wire for dataType.
     */
    int getDataTypeValue();
    /**
     * <pre>
     *&#64;&#64;    .. cpp:var:: DataType data_type
     *&#64;&#64;
     *&#64;&#64;       The input's datatype. The data type can be TYPE_INT32 or
     *&#64;&#64;       TYPE_FP32.
     *&#64;&#64;
     * </pre>
     *
     * <code>.inference.DataType data_type = 3;</code>
     * @return The dataType.
     */
    org.apache.submarine.server.api.proto.TritonModelConfig.DataType getDataType();

    /**
     * <pre>
     *&#64;&#64;    .. cpp:var:: string source_input (repeated)
     *&#64;&#64;
     *&#64;&#64;       The backend derives the value for each batch input from one or
     *&#64;&#64;       more other inputs. 'source_input' gives the names of those
     *&#64;&#64;       inputs.
     *&#64;&#64;
     * </pre>
     *
     * <code>repeated string source_input = 4;</code>
     * @return A list containing the sourceInput.
     */
    java.util.List<java.lang.String>
        getSourceInputList();
    /**
     * <pre>
     *&#64;&#64;    .. cpp:var:: string source_input (repeated)
     *&#64;&#64;
     *&#64;&#64;       The backend derives the value for each batch input from one or
     *&#64;&#64;       more other inputs. 'source_input' gives the names of those
     *&#64;&#64;       inputs.
     *&#64;&#64;
     * </pre>
     *
     * <code>repeated string source_input = 4;</code>
     * @return The count of sourceInput.
     */
    int getSourceInputCount();
    /**
     * <pre>
     *&#64;&#64;    .. cpp:var:: string source_input (repeated)
     *&#64;&#64;
     *&#64;&#64;       The backend derives the value for each batch input from one or
     *&#64;&#64;       more other inputs. 'source_input' gives the names of those
     *&#64;&#64;       inputs.
     *&#64;&#64;
     * </pre>
     *
     * <code>repeated string source_input = 4;</code>
     * @param index The index of the element to return.
     * @return The sourceInput at the given index.
     */
    java.lang.String getSourceInput(int index);
    /**
     * <pre>
     *&#64;&#64;    .. cpp:var:: string source_input (repeated)
     *&#64;&#64;
     *&#64;&#64;       The backend derives the value for each batch input from one or
     *&#64;&#64;       more other inputs. 'source_input' gives the names of those
     *&#64;&#64;       inputs.
     *&#64;&#64;
     * </pre>
     *
     * <code>repeated string source_input = 4;</code>
     * @param index The index of the value to return.
     * @return The bytes of the sourceInput at the given index.
     */
    com.google.protobuf.ByteString
        getSourceInputBytes(int index);
  }
  /**
   * <pre>
   *&#64;&#64;  .. cpp:var:: message BatchInput
   *&#64;&#64;
   *&#64;&#64;     A batch input is an additional input that must be added by
   *&#64;&#64;     the backend based on all the requests in a batch.
   *&#64;&#64;
   * </pre>
   *
   * Protobuf type {@code inference.BatchInput}
   */
  public static final class BatchInput extends
      com.google.protobuf.GeneratedMessageV3 implements
      // @@protoc_insertion_point(message_implements:inference.BatchInput)
      BatchInputOrBuilder {
  private static final long serialVersionUID = 0L;
    // Use BatchInput.newBuilder() to construct.
    private BatchInput(com.google.protobuf.GeneratedMessageV3.Builder<?> builder) {
      super(builder);
    }
    private BatchInput() {
      kind_ = 0;
      targetName_ = com.google.protobuf.LazyStringArrayList.EMPTY;
      dataType_ = 0;
      sourceInput_ = com.google.protobuf.LazyStringArrayList.EMPTY;
    }

    @java.lang.Override
    @SuppressWarnings({"unused"})
    protected java.lang.Object newInstance(
        UnusedPrivateParameter unused) {
      return new BatchInput();
    }

    @java.lang.Override
    public final com.google.protobuf.UnknownFieldSet
    getUnknownFields() {
      return this.unknownFields;
    }
    private BatchInput(
        com.google.protobuf.CodedInputStream input,
        com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws com.google.protobuf.InvalidProtocolBufferException {
      this();
      if (extensionRegistry == null) {
        throw new java.lang.NullPointerException();
      }
      int mutable_bitField0_ = 0;
      com.google.protobuf.UnknownFieldSet.Builder unknownFields =
          com.google.protobuf.UnknownFieldSet.newBuilder();
      try {
        boolean done = false;
        while (!done) {
          int tag = input.readTag();
          switch (tag) {
            case 0:
              done = true;
              break;
            case 8: {
              int rawValue = input.readEnum();

              kind_ = rawValue;
              break;
            }
            case 18: {
              java.lang.String s = input.readStringRequireUtf8();
              if (!((mutable_bitField0_ & 0x00000001) != 0)) {
                targetName_ = new com.google.protobuf.LazyStringArrayList();
                mutable_bitField0_ |= 0x00000001;
              }
              targetName_.add(s);
              break;
            }
            case 24: {
              int rawValue = input.readEnum();

              dataType_ = rawValue;
              break;
            }
            case 34: {
              java.lang.String s = input.readStringRequireUtf8();
              if (!((mutable_bitField0_ & 0x00000002) != 0)) {
                sourceInput_ = new com.google.protobuf.LazyStringArrayList();
                mutable_bitField0_ |= 0x00000002;
              }
              sourceInput_.add(s);
              break;
            }
            default: {
              if (!parseUnknownField(
                  input, unknownFields, extensionRegistry, tag)) {
                done = true;
              }
              break;
            }
          }
        }
      } catch (com.google.protobuf.InvalidProtocolBufferException e) {
        throw e.setUnfinishedMessage(this);
      } catch (java.io.IOException e) {
        throw new com.google.protobuf.InvalidProtocolBufferException(
            e).setUnfinishedMessage(this);
      } finally {
        if (((mutable_bitField0_ & 0x00000001) != 0)) {
          targetName_ = targetName_.getUnmodifiableView();
        }
        if (((mutable_bitField0_ & 0x00000002) != 0)) {
          sourceInput_ = sourceInput_.getUnmodifiableView();
        }
        this.unknownFields = unknownFields.build();
        makeExtensionsImmutable();
      }
    }
    public static final com.google.protobuf.Descriptors.Descriptor
        getDescriptor() {
      return org.apache.submarine.server.api.proto.TritonModelConfig.internal_static_inference_BatchInput_descriptor;
    }

    @java.lang.Override
    protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
        internalGetFieldAccessorTable() {
      return org.apache.submarine.server.api.proto.TritonModelConfig.internal_static_inference_BatchInput_fieldAccessorTable
          .ensureFieldAccessorsInitialized(
              org.apache.submarine.server.api.proto.TritonModelConfig.BatchInput.class, org.apache.submarine.server.api.proto.TritonModelConfig.BatchInput.Builder.class);
    }

    /**
     * <pre>
     *&#64;&#64;
     *&#64;&#64;    .. cpp:enum:: Kind
     *&#64;&#64;
     *&#64;&#64;       The kind of the batch input.
     *&#64;&#64;
     * </pre>
     *
     * Protobuf enum {@code inference.BatchInput.Kind}
     */
    public enum Kind
        implements com.google.protobuf.ProtocolMessageEnum {
      /**
       * <pre>
       *&#64;&#64;      .. cpp:enumerator:: Kind::BATCH_ELEMENT_COUNT = 0
       *&#64;&#64;
       *&#64;&#64;         The element count of the 'source_input' will be added as
       *&#64;&#64;         input with shape [1].
       *&#64;&#64;
       * </pre>
       *
       * <code>BATCH_ELEMENT_COUNT = 0;</code>
       */
      BATCH_ELEMENT_COUNT(0),
      /**
       * <pre>
       *&#64;&#64;      .. cpp:enumerator:: Kind::BATCH_ACCUMULATED_ELEMENT_COUNT = 1
       *&#64;&#64;
       *&#64;&#64;         The accumulated element count of the 'source_input' will be
       *&#64;&#64;         added as input with shape [1]. For example, if there is a
       *&#64;&#64;         batch of two request, each with 2 elements, an input of value
       *&#64;&#64;         2 will be added to the first request, and an input of value
       *&#64;&#64;         4 will be added to the second request.
       *&#64;&#64;
       * </pre>
       *
       * <code>BATCH_ACCUMULATED_ELEMENT_COUNT = 1;</code>
       */
      BATCH_ACCUMULATED_ELEMENT_COUNT(1),
      /**
       * <pre>
       *&#64;&#64;      .. cpp:enumerator::
       *&#64;&#64;         Kind::BATCH_ACCUMULATED_ELEMENT_COUNT_WITH_ZERO = 2
       *&#64;&#64;
       *&#64;&#64;         The accumulated element count of the 'source_input' will be
       *&#64;&#64;         added as input with shape [1], except for the first request
       *&#64;&#64;         in the batch. For the first request in the batch, the input
       *&#64;&#64;         will have shape [2] where the first element is value 0.
       *&#64;&#64;
       * </pre>
       *
       * <code>BATCH_ACCUMULATED_ELEMENT_COUNT_WITH_ZERO = 2;</code>
       */
      BATCH_ACCUMULATED_ELEMENT_COUNT_WITH_ZERO(2),
      /**
       * <pre>
       *&#64;&#64;      .. cpp:enumerator:: Kind::BATCH_MAX_ELEMENT_COUNT_AS_SHAPE = 3
       *&#64;&#64;
       *&#64;&#64;         Among the requests in the batch, the max element count of the
       *&#64;&#64;         'source_input' will be added as input with shape
       *&#64;&#64;         [max_element_count] for the first request in the batch.
       *&#64;&#64;         For other requests, such input will be with shape [0].
       *&#64;&#64;         The data of the tensor will be uninitialized.
       *&#64;&#64;
       * </pre>
       *
       * <code>BATCH_MAX_ELEMENT_COUNT_AS_SHAPE = 3;</code>
       */
      BATCH_MAX_ELEMENT_COUNT_AS_SHAPE(3),
      UNRECOGNIZED(-1),
      ;

      /**
       * <pre>
       *&#64;&#64;      .. cpp:enumerator:: Kind::BATCH_ELEMENT_COUNT = 0
       *&#64;&#64;
       *&#64;&#64;         The element count of the 'source_input' will be added as
       *&#64;&#64;         input with shape [1].
       *&#64;&#64;
       * </pre>
       *
       * <code>BATCH_ELEMENT_COUNT = 0;</code>
       */
      public static final int BATCH_ELEMENT_COUNT_VALUE = 0;
      /**
       * <pre>
       *&#64;&#64;      .. cpp:enumerator:: Kind::BATCH_ACCUMULATED_ELEMENT_COUNT = 1
       *&#64;&#64;
       *&#64;&#64;         The accumulated element count of the 'source_input' will be
       *&#64;&#64;         added as input with shape [1]. For example, if there is a
       *&#64;&#64;         batch of two request, each with 2 elements, an input of value
       *&#64;&#64;         2 will be added to the first request, and an input of value
       *&#64;&#64;         4 will be added to the second request.
       *&#64;&#64;
       * </pre>
       *
       * <code>BATCH_ACCUMULATED_ELEMENT_COUNT = 1;</code>
       */
      public static final int BATCH_ACCUMULATED_ELEMENT_COUNT_VALUE = 1;
      /**
       * <pre>
       *&#64;&#64;      .. cpp:enumerator::
       *&#64;&#64;         Kind::BATCH_ACCUMULATED_ELEMENT_COUNT_WITH_ZERO = 2
       *&#64;&#64;
       *&#64;&#64;         The accumulated element count of the 'source_input' will be
       *&#64;&#64;         added as input with shape [1], except for the first request
       *&#64;&#64;         in the batch. For the first request in the batch, the input
       *&#64;&#64;         will have shape [2] where the first element is value 0.
       *&#64;&#64;
       * </pre>
       *
       * <code>BATCH_ACCUMULATED_ELEMENT_COUNT_WITH_ZERO = 2;</code>
       */
      public static final int BATCH_ACCUMULATED_ELEMENT_COUNT_WITH_ZERO_VALUE = 2;
      /**
       * <pre>
       *&#64;&#64;      .. cpp:enumerator:: Kind::BATCH_MAX_ELEMENT_COUNT_AS_SHAPE = 3
       *&#64;&#64;
       *&#64;&#64;         Among the requests in the batch, the max element count of the
       *&#64;&#64;         'source_input' will be added as input with shape
       *&#64;&#64;         [max_element_count] for the first request in the batch.
       *&#64;&#64;         For other requests, such input will be with shape [0].
       *&#64;&#64;         The data of the tensor will be uninitialized.
       *&#64;&#64;
       * </pre>
       *
       * <code>BATCH_MAX_ELEMENT_COUNT_AS_SHAPE = 3;</code>
       */
      public static final int BATCH_MAX_ELEMENT_COUNT_AS_SHAPE_VALUE = 3;


      public final int getNumber() {
        if (this == UNRECOGNIZED) {
          throw new java.lang.IllegalArgumentException(
              "Can't get the number of an unknown enum value.");
        }
        return value;
      }

      /**
       * @param value The numeric wire value of the corresponding enum entry.
       * @return The enum associated with the given numeric wire value.
       * @deprecated Use {@link #forNumber(int)} instead.
       */
      @java.lang.Deprecated
      public static Kind valueOf(int value) {
        return forNumber(value);
      }

      /**
       * @param value The numeric wire value of the corresponding enum entry.
       * @return The enum associated with the given numeric wire value.
       */
      public static Kind forNumber(int value) {
        switch (value) {
          case 0: return BATCH_ELEMENT_COUNT;
          case 1: return BATCH_ACCUMULATED_ELEMENT_COUNT;
          case 2: return BATCH_ACCUMULATED_ELEMENT_COUNT_WITH_ZERO;
          case 3: return BATCH_MAX_ELEMENT_COUNT_AS_SHAPE;
          default: return null;
        }
      }

      public static com.google.protobuf.Internal.EnumLiteMap<Kind>
          internalGetValueMap() {
        return internalValueMap;
      }
      private static final com.google.protobuf.Internal.EnumLiteMap<
          Kind> internalValueMap =
            new com.google.protobuf.Internal.EnumLiteMap<Kind>() {
              public Kind findValueByNumber(int number) {
                return Kind.forNumber(number);
              }
            };

      public final com.google.protobuf.Descriptors.EnumValueDescriptor
          getValueDescriptor() {
        if (this == UNRECOGNIZED) {
          throw new java.lang.IllegalStateException(
              "Can't get the descriptor of an unrecognized enum value.");
        }
        return getDescriptor().getValues().get(ordinal());
      }
      public final com.google.protobuf.Descriptors.EnumDescriptor
          getDescriptorForType() {
        return getDescriptor();
      }
      public static final com.google.protobuf.Descriptors.EnumDescriptor
          getDescriptor() {
        return org.apache.submarine.server.api.proto.TritonModelConfig.BatchInput.getDescriptor().getEnumTypes().get(0);
      }

      private static final Kind[] VALUES = values();

      public static Kind valueOf(
          com.google.protobuf.Descriptors.EnumValueDescriptor desc) {
        if (desc.getType() != getDescriptor()) {
          throw new java.lang.IllegalArgumentException(
            "EnumValueDescriptor is not for this type.");
        }
        if (desc.getIndex() == -1) {
          return UNRECOGNIZED;
        }
        return VALUES[desc.getIndex()];
      }

      private final int value;

      private Kind(int value) {
        this.value = value;
      }

      // @@protoc_insertion_point(enum_scope:inference.BatchInput.Kind)
    }

    public static final int KIND_FIELD_NUMBER = 1;
    private int kind_;
    /**
     * <pre>
     *&#64;&#64;    .. cpp:var:: Kind kind
     *&#64;&#64;
     *&#64;&#64;       The kind of this batch input.
     *&#64;&#64;
     * </pre>
     *
     * <code>.inference.BatchInput.Kind kind = 1;</code>
     * @return The enum numeric value on the wire for kind.
     */
    @java.lang.Override public int getKindValue() {
      return kind_;
    }
    /**
     * <pre>
     *&#64;&#64;    .. cpp:var:: Kind kind
     *&#64;&#64;
     *&#64;&#64;       The kind of this batch input.
     *&#64;&#64;
     * </pre>
     *
     * <code>.inference.BatchInput.Kind kind = 1;</code>
     * @return The kind.
     */
    @java.lang.Override public org.apache.submarine.server.api.proto.TritonModelConfig.BatchInput.Kind getKind() {
      @SuppressWarnings("deprecation")
      org.apache.submarine.server.api.proto.TritonModelConfig.BatchInput.Kind result = org.apache.submarine.server.api.proto.TritonModelConfig.BatchInput.Kind.valueOf(kind_);
      return result == null ? org.apache.submarine.server.api.proto.TritonModelConfig.BatchInput.Kind.UNRECOGNIZED : result;
    }

    public static final int TARGET_NAME_FIELD_NUMBER = 2;
    private com.google.protobuf.LazyStringList targetName_;
    /**
     * <pre>
     *&#64;&#64;    .. cpp:var:: string target_name (repeated)
     *&#64;&#64;
     *&#64;&#64;       The name of the model inputs that the backend will create
     *&#64;&#64;       for this batch input.
     *&#64;&#64;
     * </pre>
     *
     * <code>repeated string target_name = 2;</code>
     * @return A list containing the targetName.
     */
    public com.google.protobuf.ProtocolStringList
        getTargetNameList() {
      return targetName_;
    }
    /**
     * <pre>
     *&#64;&#64;    .. cpp:var:: string target_name (repeated)
     *&#64;&#64;
     *&#64;&#64;       The name of the model inputs that the backend will create
     *&#64;&#64;       for this batch input.
     *&#64;&#64;
     * </pre>
     *
     * <code>repeated string target_name = 2;</code>
     * @return The count of targetName.
     */
    public int getTargetNameCount() {
      return targetName_.size();
    }
    /**
     * <pre>
     *&#64;&#64;    .. cpp:var:: string target_name (repeated)
     *&#64;&#64;
     *&#64;&#64;       The name of the model inputs that the backend will create
     *&#64;&#64;       for this batch input.
     *&#64;&#64;
     * </pre>
     *
     * <code>repeated string target_name = 2;</code>
     * @param index The index of the element to return.
     * @return The targetName at the given index.
     */
    public java.lang.String getTargetName(int index) {
      return targetName_.get(index);
    }
    /**
     * <pre>
     *&#64;&#64;    .. cpp:var:: string target_name (repeated)
     *&#64;&#64;
     *&#64;&#64;       The name of the model inputs that the backend will create
     *&#64;&#64;       for this batch input.
     *&#64;&#64;
     * </pre>
     *
     * <code>repeated string target_name = 2;</code>
     * @param index The index of the value to return.
     * @return The bytes of the targetName at the given index.
     */
    public com.google.protobuf.ByteString
        getTargetNameBytes(int index) {
      return targetName_.getByteString(index);
    }

    public static final int DATA_TYPE_FIELD_NUMBER = 3;
    private int dataType_;
    /**
     * <pre>
     *&#64;&#64;    .. cpp:var:: DataType data_type
     *&#64;&#64;
     *&#64;&#64;       The input's datatype. The data type can be TYPE_INT32 or
     *&#64;&#64;       TYPE_FP32.
     *&#64;&#64;
     * </pre>
     *
     * <code>.inference.DataType data_type = 3;</code>
     * @return The enum numeric value on the wire for dataType.
     */
    @java.lang.Override public int getDataTypeValue() {
      return dataType_;
    }
    /**
     * <pre>
     *&#64;&#64;    .. cpp:var:: DataType data_type
     *&#64;&#64;
     *&#64;&#64;       The input's datatype. The data type can be TYPE_INT32 or
     *&#64;&#64;       TYPE_FP32.
     *&#64;&#64;
     * </pre>
     *
     * <code>.inference.DataType data_type = 3;</code>
     * @return The dataType.
     */
    @java.lang.Override public org.apache.submarine.server.api.proto.TritonModelConfig.DataType getDataType() {
      @SuppressWarnings("deprecation")
      org.apache.submarine.server.api.proto.TritonModelConfig.DataType result = org.apache.submarine.server.api.proto.TritonModelConfig.DataType.valueOf(dataType_);
      return result == null ? org.apache.submarine.server.api.proto.TritonModelConfig.DataType.UNRECOGNIZED : result;
    }

    public static final int SOURCE_INPUT_FIELD_NUMBER = 4;
    private com.google.protobuf.LazyStringList sourceInput_;
    /**
     * <pre>
     *&#64;&#64;    .. cpp:var:: string source_input (repeated)
     *&#64;&#64;
     *&#64;&#64;       The backend derives the value for each batch input from one or
     *&#64;&#64;       more other inputs. 'source_input' gives the names of those
     *&#64;&#64;       inputs.
     *&#64;&#64;
     * </pre>
     *
     * <code>repeated string source_input = 4;</code>
     * @return A list containing the sourceInput.
     */
    public com.google.protobuf.ProtocolStringList
        getSourceInputList() {
      return sourceInput_;
    }
    /**
     * <pre>
     *&#64;&#64;    .. cpp:var:: string source_input (repeated)
     *&#64;&#64;
     *&#64;&#64;       The backend derives the value for each batch input from one or
     *&#64;&#64;       more other inputs. 'source_input' gives the names of those
     *&#64;&#64;       inputs.
     *&#64;&#64;
     * </pre>
     *
     * <code>repeated string source_input = 4;</code>
     * @return The count of sourceInput.
     */
    public int getSourceInputCount() {
      return sourceInput_.size();
    }
    /**
     * <pre>
     *&#64;&#64;    .. cpp:var:: string source_input (repeated)
     *&#64;&#64;
     *&#64;&#64;       The backend derives the value for each batch input from one or
     *&#64;&#64;       more other inputs. 'source_input' gives the names of those
     *&#64;&#64;       inputs.
     *&#64;&#64;
     * </pre>
     *
     * <code>repeated string source_input = 4;</code>
     * @param index The index of the element to return.
     * @return The sourceInput at the given index.
     */
    public java.lang.String getSourceInput(int index) {
      return sourceInput_.get(index);
    }
    /**
     * <pre>
     *&#64;&#64;    .. cpp:var:: string source_input (repeated)
     *&#64;&#64;
     *&#64;&#64;       The backend derives the value for each batch input from one or
     *&#64;&#64;       more other inputs. 'source_input' gives the names of those
     *&#64;&#64;       inputs.
     *&#64;&#64;
     * </pre>
     *
     * <code>repeated string source_input = 4;</code>
     * @param index The index of the value to return.
     * @return The bytes of the sourceInput at the given index.
     */
    public com.google.protobuf.ByteString
        getSourceInputBytes(int index) {
      return sourceInput_.getByteString(index);
    }

    private byte memoizedIsInitialized = -1;
    @java.lang.Override
    public final boolean isInitialized() {
      byte isInitialized = memoizedIsInitialized;
      if (isInitialized == 1) return true;
      if (isInitialized == 0) return false;

      memoizedIsInitialized = 1;
      return true;
    }

    @java.lang.Override
    public void writeTo(com.google.protobuf.CodedOutputStream output)
                        throws java.io.IOException {
      if (kind_ != org.apache.submarine.server.api.proto.TritonModelConfig.BatchInput.Kind.BATCH_ELEMENT_COUNT.getNumber()) {
        output.writeEnum(1, kind_);
      }
      for (int i = 0; i < targetName_.size(); i++) {
        com.google.protobuf.GeneratedMessageV3.writeString(output, 2, targetName_.getRaw(i));
      }
      if (dataType_ != org.apache.submarine.server.api.proto.TritonModelConfig.DataType.TYPE_INVALID.getNumber()) {
        output.writeEnum(3, dataType_);
      }
      for (int i = 0; i < sourceInput_.size(); i++) {
        com.google.protobuf.GeneratedMessageV3.writeString(output, 4, sourceInput_.getRaw(i));
      }
      unknownFields.writeTo(output);
    }

    @java.lang.Override
    public int getSerializedSize() {
      int size = memoizedSize;
      if (size != -1) return size;

      size = 0;
      if (kind_ != org.apache.submarine.server.api.proto.TritonModelConfig.BatchInput.Kind.BATCH_ELEMENT_COUNT.getNumber()) {
        size += com.google.protobuf.CodedOutputStream
          .computeEnumSize(1, kind_);
      }
      {
        int dataSize = 0;
        for (int i = 0; i < targetName_.size(); i++) {
          dataSize += computeStringSizeNoTag(targetName_.getRaw(i));
        }
        size += dataSize;
        size += 1 * getTargetNameList().size();
      }
      if (dataType_ != org.apache.submarine.server.api.proto.TritonModelConfig.DataType.TYPE_INVALID.getNumber()) {
        size += com.google.protobuf.CodedOutputStream
          .computeEnumSize(3, dataType_);
      }
      {
        int dataSize = 0;
        for (int i = 0; i < sourceInput_.size(); i++) {
          dataSize += computeStringSizeNoTag(sourceInput_.getRaw(i));
        }
        size += dataSize;
        size += 1 * getSourceInputList().size();
      }
      size += unknownFields.getSerializedSize();
      memoizedSize = size;
      return size;
    }

    @java.lang.Override
    public boolean equals(final java.lang.Object obj) {
      if (obj == this) {
       return true;
      }
      if (!(obj instanceof org.apache.submarine.server.api.proto.TritonModelConfig.BatchInput)) {
        return super.equals(obj);
      }
      org.apache.submarine.server.api.proto.TritonModelConfig.BatchInput other = (org.apache.submarine.server.api.proto.TritonModelConfig.BatchInput) obj;

      if (kind_ != other.kind_) return false;
      if (!getTargetNameList()
          .equals(other.getTargetNameList())) return false;
      if (dataType_ != other.dataType_) return false;
      if (!getSourceInputList()
          .equals(other.getSourceInputList())) return false;
      if (!unknownFields.equals(other.unknownFields)) return false;
      return true;
    }

    @java.lang.Override
    public int hashCode() {
      if (memoizedHashCode != 0) {
        return memoizedHashCode;
      }
      int hash = 41;
      hash = (19 * hash) + getDescriptor().hashCode();
      hash = (37 * hash) + KIND_FIELD_NUMBER;
      hash = (53 * hash) + kind_;
      if (getTargetNameCount() > 0) {
        hash = (37 * hash) + TARGET_NAME_FIELD_NUMBER;
        hash = (53 * hash) + getTargetNameList().hashCode();
      }
      hash = (37 * hash) + DATA_TYPE_FIELD_NUMBER;
      hash = (53 * hash) + dataType_;
      if (getSourceInputCount() > 0) {
        hash = (37 * hash) + SOURCE_INPUT_FIELD_NUMBER;
        hash = (53 * hash) + getSourceInputList().hashCode();
      }
      hash = (29 * hash) + unknownFields.hashCode();
      memoizedHashCode = hash;
      return hash;
    }

    public static org.apache.submarine.server.api.proto.TritonModelConfig.BatchInput parseFrom(
        java.nio.ByteBuffer data)
        throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data);
    }
    public static org.apache.submarine.server.api.proto.TritonModelConfig.BatchInput parseFrom(
        java.nio.ByteBuffer data,
        com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data, extensionRegistry);
    }
    public static org.apache.submarine.server.api.proto.TritonModelConfig.BatchInput parseFrom(
        com.google.protobuf.ByteString data)
        throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data);
    }
    public static org.apache.submarine.server.api.proto.TritonModelConfig.BatchInput parseFrom(
        com.google.protobuf.ByteString data,
        com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data, extensionRegistry);
    }
    public static org.apache.submarine.server.api.proto.TritonModelConfig.BatchInput parseFrom(byte[] data)
        throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data);
    }
    public static org.apache.submarine.server.api.proto.TritonModelConfig.BatchInput parseFrom(
        byte[] data,
        com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data, extensionRegistry);
    }
    public static org.apache.submarine.server.api.proto.TritonModelConfig.BatchInput parseFrom(java.io.InputStream input)
        throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3
          .parseWithIOException(PARSER, input);
    }
    public static org.apache.submarine.server.api.proto.TritonModelConfig.BatchInput parseFrom(
        java.io.InputStream input,
        com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3
          .parseWithIOException(PARSER, input, extensionRegistry);
    }
    public static org.apache.submarine.server.api.proto.TritonModelConfig.BatchInput parseDelimitedFrom(java.io.InputStream input)
        throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3
          .parseDelimitedWithIOException(PARSER, input);
    }
    public static org.apache.submarine.server.api.proto.TritonModelConfig.BatchInput parseDelimitedFrom(
        java.io.InputStream input,
        com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3
          .parseDelimitedWithIOException(PARSER, input, extensionRegistry);
    }
    public static org.apache.submarine.server.api.proto.TritonModelConfig.BatchInput parseFrom(
        com.google.protobuf.CodedInputStream input)
        throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3
          .parseWithIOException(PARSER, input);
    }
    public static org.apache.submarine.server.api.proto.TritonModelConfig.BatchInput parseFrom(
        com.google.protobuf.CodedInputStream input,
        com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3
          .parseWithIOException(PARSER, input, extensionRegistry);
    }

    @java.lang.Override
    public Builder newBuilderForType() { return newBuilder(); }
    public static Builder newBuilder() {
      return DEFAULT_INSTANCE.toBuilder();
    }
    public static Builder newBuilder(org.apache.submarine.server.api.proto.TritonModelConfig.BatchInput prototype) {
      return DEFAULT_INSTANCE.toBuilder().mergeFrom(prototype);
    }
    @java.lang.Override
    public Builder toBuilder() {
      return this == DEFAULT_INSTANCE
          ? new Builder() : new Builder().mergeFrom(this);
    }

    @java.lang.Override
    protected Builder newBuilderForType(
        com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
      Builder builder = new Builder(parent);
      return builder;
    }
    /**
     * <pre>
     *&#64;&#64;  .. cpp:var:: message BatchInput
     *&#64;&#64;
     *&#64;&#64;     A batch input is an additional input that must be added by
     *&#64;&#64;     the backend based on all the requests in a batch.
     *&#64;&#64;
     * </pre>
     *
     * Protobuf type {@code inference.BatchInput}
     */
    public static final class Builder extends
        com.google.protobuf.GeneratedMessageV3.Builder<Builder> implements
        // @@protoc_insertion_point(builder_implements:inference.BatchInput)
        org.apache.submarine.server.api.proto.TritonModelConfig.BatchInputOrBuilder {
      public static final com.google.protobuf.Descriptors.Descriptor
          getDescriptor() {
        return org.apache.submarine.server.api.proto.TritonModelConfig.internal_static_inference_BatchInput_descriptor;
      }

      @java.lang.Override
      protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
          internalGetFieldAccessorTable() {
        return org.apache.submarine.server.api.proto.TritonModelConfig.internal_static_inference_BatchInput_fieldAccessorTable
            .ensureFieldAccessorsInitialized(
                org.apache.submarine.server.api.proto.TritonModelConfig.BatchInput.class, org.apache.submarine.server.api.proto.TritonModelConfig.BatchInput.Builder.class);
      }

      // Construct using org.apache.submarine.server.api.proto.TritonModelConfig.BatchInput.newBuilder()
      private Builder() {
        maybeForceBuilderInitialization();
      }

      private Builder(
          com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
        super(parent);
        maybeForceBuilderInitialization();
      }
      private void maybeForceBuilderInitialization() {
        if (com.google.protobuf.GeneratedMessageV3
                .alwaysUseFieldBuilders) {
        }
      }
      @java.lang.Override
      public Builder clear() {
        super.clear();
        kind_ = 0;

        targetName_ = com.google.protobuf.LazyStringArrayList.EMPTY;
        bitField0_ = (bitField0_ & ~0x00000001);
        dataType_ = 0;

        sourceInput_ = com.google.protobuf.LazyStringArrayList.EMPTY;
        bitField0_ = (bitField0_ & ~0x00000002);
        return this;
      }

      @java.lang.Override
      public com.google.protobuf.Descriptors.Descriptor
          getDescriptorForType() {
        return org.apache.submarine.server.api.proto.TritonModelConfig.internal_static_inference_BatchInput_descriptor;
      }

      @java.lang.Override
      public org.apache.submarine.server.api.proto.TritonModelConfig.BatchInput getDefaultInstanceForType() {
        return org.apache.submarine.server.api.proto.TritonModelConfig.BatchInput.getDefaultInstance();
      }

      @java.lang.Override
      public org.apache.submarine.server.api.proto.TritonModelConfig.BatchInput build() {
        org.apache.submarine.server.api.proto.TritonModelConfig.BatchInput result = buildPartial();
        if (!result.isInitialized()) {
          throw newUninitializedMessageException(result);
        }
        return result;
      }

      @java.lang.Override
      public org.apache.submarine.server.api.proto.TritonModelConfig.BatchInput buildPartial() {
        org.apache.submarine.server.api.proto.TritonModelConfig.BatchInput result = new org.apache.submarine.server.api.proto.TritonModelConfig.BatchInput(this);
        int from_bitField0_ = bitField0_;
        result.kind_ = kind_;
        if (((bitField0_ & 0x00000001) != 0)) {
          targetName_ = targetName_.getUnmodifiableView();
          bitField0_ = (bitField0_ & ~0x00000001);
        }
        result.targetName_ = targetName_;
        result.dataType_ = dataType_;
        if (((bitField0_ & 0x00000002) != 0)) {
          sourceInput_ = sourceInput_.getUnmodifiableView();
          bitField0_ = (bitField0_ & ~0x00000002);
        }
        result.sourceInput_ = sourceInput_;
        onBuilt();
        return result;
      }

      @java.lang.Override
      public Builder clone() {
        return super.clone();
      }
      @java.lang.Override
      public Builder setField(
          com.google.protobuf.Descriptors.FieldDescriptor field,
          java.lang.Object value) {
        return super.setField(field, value);
      }
      @java.lang.Override
      public Builder clearField(
          com.google.protobuf.Descriptors.FieldDescriptor field) {
        return super.clearField(field);
      }
      @java.lang.Override
      public Builder clearOneof(
          com.google.protobuf.Descriptors.OneofDescriptor oneof) {
        return super.clearOneof(oneof);
      }
      @java.lang.Override
      public Builder setRepeatedField(
          com.google.protobuf.Descriptors.FieldDescriptor field,
          int index, java.lang.Object value) {
        return super.setRepeatedField(field, index, value);
      }
      @java.lang.Override
      public Builder addRepeatedField(
          com.google.protobuf.Descriptors.FieldDescriptor field,
          java.lang.Object value) {
        return super.addRepeatedField(field, value);
      }
      @java.lang.Override
      public Builder mergeFrom(com.google.protobuf.Message other) {
        if (other instanceof org.apache.submarine.server.api.proto.TritonModelConfig.BatchInput) {
          return mergeFrom((org.apache.submarine.server.api.proto.TritonModelConfig.BatchInput)other);
        } else {
          super.mergeFrom(other);
          return this;
        }
      }

      public Builder mergeFrom(org.apache.submarine.server.api.proto.TritonModelConfig.BatchInput other) {
        if (other == org.apache.submarine.server.api.proto.TritonModelConfig.BatchInput.getDefaultInstance()) return this;
        if (other.kind_ != 0) {
          setKindValue(other.getKindValue());
        }
        if (!other.targetName_.isEmpty()) {
          if (targetName_.isEmpty()) {
            targetName_ = other.targetName_;
            bitField0_ = (bitField0_ & ~0x00000001);
          } else {
            ensureTargetNameIsMutable();
            targetName_.addAll(other.targetName_);
          }
          onChanged();
        }
        if (other.dataType_ != 0) {
          setDataTypeValue(other.getDataTypeValue());
        }
        if (!other.sourceInput_.isEmpty()) {
          if (sourceInput_.isEmpty()) {
            sourceInput_ = other.sourceInput_;
            bitField0_ = (bitField0_ & ~0x00000002);
          } else {
            ensureSourceInputIsMutable();
            sourceInput_.addAll(other.sourceInput_);
          }
          onChanged();
        }
        this.mergeUnknownFields(other.unknownFields);
        onChanged();
        return this;
      }

      @java.lang.Override
      public final boolean isInitialized() {
        return true;
      }

      @java.lang.Override
      public Builder mergeFrom(
          com.google.protobuf.CodedInputStream input,
          com.google.protobuf.ExtensionRegistryLite extensionRegistry)
          throws java.io.IOException {
        org.apache.submarine.server.api.proto.TritonModelConfig.BatchInput parsedMessage = null;
        try {
          parsedMessage = PARSER.parsePartialFrom(input, extensionRegistry);
        } catch (com.google.protobuf.InvalidProtocolBufferException e) {
          parsedMessage = (org.apache.submarine.server.api.proto.TritonModelConfig.BatchInput) e.getUnfinishedMessage();
          throw e.unwrapIOException();
        } finally {
          if (parsedMessage != null) {
            mergeFrom(parsedMessage);
          }
        }
        return this;
      }
      private int bitField0_;

      private int kind_ = 0;
      /**
       * <pre>
       *&#64;&#64;    .. cpp:var:: Kind kind
       *&#64;&#64;
       *&#64;&#64;       The kind of this batch input.
       *&#64;&#64;
       * </pre>
       *
       * <code>.inference.BatchInput.Kind kind = 1;</code>
       * @return The enum numeric value on the wire for kind.
       */
      @java.lang.Override public int getKindValue() {
        return kind_;
      }
      /**
       * <pre>
       *&#64;&#64;    .. cpp:var:: Kind kind
       *&#64;&#64;
       *&#64;&#64;       The kind of this batch input.
       *&#64;&#64;
       * </pre>
       *
       * <code>.inference.BatchInput.Kind kind = 1;</code>
       * @param value The enum numeric value on the wire for kind to set.
       * @return This builder for chaining.
       */
      public Builder setKindValue(int value) {
        
        kind_ = value;
        onChanged();
        return this;
      }
      /**
       * <pre>
       *&#64;&#64;    .. cpp:var:: Kind kind
       *&#64;&#64;
       *&#64;&#64;       The kind of this batch input.
       *&#64;&#64;
       * </pre>
       *
       * <code>.inference.BatchInput.Kind kind = 1;</code>
       * @return The kind.
       */
      @java.lang.Override
      public org.apache.submarine.server.api.proto.TritonModelConfig.BatchInput.Kind getKind() {
        @SuppressWarnings("deprecation")
        org.apache.submarine.server.api.proto.TritonModelConfig.BatchInput.Kind result = org.apache.submarine.server.api.proto.TritonModelConfig.BatchInput.Kind.valueOf(kind_);
        return result == null ? org.apache.submarine.server.api.proto.TritonModelConfig.BatchInput.Kind.UNRECOGNIZED : result;
      }
      /**
       * <pre>
       *&#64;&#64;    .. cpp:var:: Kind kind
       *&#64;&#64;
       *&#64;&#64;       The kind of this batch input.
       *&#64;&#64;
       * </pre>
       *
       * <code>.inference.BatchInput.Kind kind = 1;</code>
       * @param value The kind to set.
       * @return This builder for chaining.
       */
      public Builder setKind(org.apache.submarine.server.api.proto.TritonModelConfig.BatchInput.Kind value) {
        if (value == null) {
          throw new NullPointerException();
        }
        
        kind_ = value.getNumber();
        onChanged();
        return this;
      }
      /**
       * <pre>
       *&#64;&#64;    .. cpp:var:: Kind kind
       *&#64;&#64;
       *&#64;&#64;       The kind of this batch input.
       *&#64;&#64;
       * </pre>
       *
       * <code>.inference.BatchInput.Kind kind = 1;</code>
       * @return This builder for chaining.
       */
      public Builder clearKind() {
        
        kind_ = 0;
        onChanged();
        return this;
      }

      private com.google.protobuf.LazyStringList targetName_ = com.google.protobuf.LazyStringArrayList.EMPTY;
      private void ensureTargetNameIsMutable() {
        if (!((bitField0_ & 0x00000001) != 0)) {
          targetName_ = new com.google.protobuf.LazyStringArrayList(targetName_);
          bitField0_ |= 0x00000001;
         }
      }
      /**
       * <pre>
       *&#64;&#64;    .. cpp:var:: string target_name (repeated)
       *&#64;&#64;
       *&#64;&#64;       The name of the model inputs that the backend will create
       *&#64;&#64;       for this batch input.
       *&#64;&#64;
       * </pre>
       *
       * <code>repeated string target_name = 2;</code>
       * @return A list containing the targetName.
       */
      public com.google.protobuf.ProtocolStringList
          getTargetNameList() {
        return targetName_.getUnmodifiableView();
      }
      /**
       * <pre>
       *&#64;&#64;    .. cpp:var:: string target_name (repeated)
       *&#64;&#64;
       *&#64;&#64;       The name of the model inputs that the backend will create
       *&#64;&#64;       for this batch input.
       *&#64;&#64;
       * </pre>
       *
       * <code>repeated string target_name = 2;</code>
       * @return The count of targetName.
       */
      public int getTargetNameCount() {
        return targetName_.size();
      }
      /**
       * <pre>
       *&#64;&#64;    .. cpp:var:: string target_name (repeated)
       *&#64;&#64;
       *&#64;&#64;       The name of the model inputs that the backend will create
       *&#64;&#64;       for this batch input.
       *&#64;&#64;
       * </pre>
       *
       * <code>repeated string target_name = 2;</code>
       * @param index The index of the element to return.
       * @return The targetName at the given index.
       */
      public java.lang.String getTargetName(int index) {
        return targetName_.get(index);
      }
      /**
       * <pre>
       *&#64;&#64;    .. cpp:var:: string target_name (repeated)
       *&#64;&#64;
       *&#64;&#64;       The name of the model inputs that the backend will create
       *&#64;&#64;       for this batch input.
       *&#64;&#64;
       * </pre>
       *
       * <code>repeated string target_name = 2;</code>
       * @param index The index of the value to return.
       * @return The bytes of the targetName at the given index.
       */
      public com.google.protobuf.ByteString
          getTargetNameBytes(int index) {
        return targetName_.getByteString(index);
      }
      /**
       * <pre>
       *&#64;&#64;    .. cpp:var:: string target_name (repeated)
       *&#64;&#64;
       *&#64;&#64;       The name of the model inputs that the backend will create
       *&#64;&#64;       for this batch input.
       *&#64;&#64;
       * </pre>
       *
       * <code>repeated string target_name = 2;</code>
       * @param index The index to set the value at.
       * @param value The targetName to set.
       * @return This builder for chaining.
       */
      public Builder setTargetName(
          int index, java.lang.String value) {
        if (value == null) {
    throw new NullPointerException();
  }
  ensureTargetNameIsMutable();
        targetName_.set(index, value);
        onChanged();
        return this;
      }
      /**
       * <pre>
       *&#64;&#64;    .. cpp:var:: string target_name (repeated)
       *&#64;&#64;
       *&#64;&#64;       The name of the model inputs that the backend will create
       *&#64;&#64;       for this batch input.
       *&#64;&#64;
       * </pre>
       *
       * <code>repeated string target_name = 2;</code>
       * @param value The targetName to add.
       * @return This builder for chaining.
       */
      public Builder addTargetName(
          java.lang.String value) {
        if (value == null) {
    throw new NullPointerException();
  }
  ensureTargetNameIsMutable();
        targetName_.add(value);
        onChanged();
        return this;
      }
      /**
       * <pre>
       *&#64;&#64;    .. cpp:var:: string target_name (repeated)
       *&#64;&#64;
       *&#64;&#64;       The name of the model inputs that the backend will create
       *&#64;&#64;       for this batch input.
       *&#64;&#64;
       * </pre>
       *
       * <code>repeated string target_name = 2;</code>
       * @param values The targetName to add.
       * @return This builder for chaining.
       */
      public Builder addAllTargetName(
          java.lang.Iterable<java.lang.String> values) {
        ensureTargetNameIsMutable();
        com.google.protobuf.AbstractMessageLite.Builder.addAll(
            values, targetName_);
        onChanged();
        return this;
      }
      /**
       * <pre>
       *&#64;&#64;    .. cpp:var:: string target_name (repeated)
       *&#64;&#64;
       *&#64;&#64;       The name of the model inputs that the backend will create
       *&#64;&#64;       for this batch input.
       *&#64;&#64;
       * </pre>
       *
       * <code>repeated string target_name = 2;</code>
       * @return This builder for chaining.
       */
      public Builder clearTargetName() {
        targetName_ = com.google.protobuf.LazyStringArrayList.EMPTY;
        bitField0_ = (bitField0_ & ~0x00000001);
        onChanged();
        return this;
      }
      /**
       * <pre>
       *&#64;&#64;    .. cpp:var:: string target_name (repeated)
       *&#64;&#64;
       *&#64;&#64;       The name of the model inputs that the backend will create
       *&#64;&#64;       for this batch input.
       *&#64;&#64;
       * </pre>
       *
       * <code>repeated string target_name = 2;</code>
       * @param value The bytes of the targetName to add.
       * @return This builder for chaining.
       */
      public Builder addTargetNameBytes(
          com.google.protobuf.ByteString value) {
        if (value == null) {
    throw new NullPointerException();
  }
  checkByteStringIsUtf8(value);
        ensureTargetNameIsMutable();
        targetName_.add(value);
        onChanged();
        return this;
      }

      private int dataType_ = 0;
      /**
       * <pre>
       *&#64;&#64;    .. cpp:var:: DataType data_type
       *&#64;&#64;
       *&#64;&#64;       The input's datatype. The data type can be TYPE_INT32 or
       *&#64;&#64;       TYPE_FP32.
       *&#64;&#64;
       * </pre>
       *
       * <code>.inference.DataType data_type = 3;</code>
       * @return The enum numeric value on the wire for dataType.
       */
      @java.lang.Override public int getDataTypeValue() {
        return dataType_;
      }
      /**
       * <pre>
       *&#64;&#64;    .. cpp:var:: DataType data_type
       *&#64;&#64;
       *&#64;&#64;       The input's datatype. The data type can be TYPE_INT32 or
       *&#64;&#64;       TYPE_FP32.
       *&#64;&#64;
       * </pre>
       *
       * <code>.inference.DataType data_type = 3;</code>
       * @param value The enum numeric value on the wire for dataType to set.
       * @return This builder for chaining.
       */
      public Builder setDataTypeValue(int value) {
        
        dataType_ = value;
        onChanged();
        return this;
      }
      /**
       * <pre>
       *&#64;&#64;    .. cpp:var:: DataType data_type
       *&#64;&#64;
       *&#64;&#64;       The input's datatype. The data type can be TYPE_INT32 or
       *&#64;&#64;       TYPE_FP32.
       *&#64;&#64;
       * </pre>
       *
       * <code>.inference.DataType data_type = 3;</code>
       * @return The dataType.
       */
      @java.lang.Override
      public org.apache.submarine.server.api.proto.TritonModelConfig.DataType getDataType() {
        @SuppressWarnings("deprecation")
        org.apache.submarine.server.api.proto.TritonModelConfig.DataType result = org.apache.submarine.server.api.proto.TritonModelConfig.DataType.valueOf(dataType_);
        return result == null ? org.apache.submarine.server.api.proto.TritonModelConfig.DataType.UNRECOGNIZED : result;
      }
      /**
       * <pre>
       *&#64;&#64;    .. cpp:var:: DataType data_type
       *&#64;&#64;
       *&#64;&#64;       The input's datatype. The data type can be TYPE_INT32 or
       *&#64;&#64;       TYPE_FP32.
       *&#64;&#64;
       * </pre>
       *
       * <code>.inference.DataType data_type = 3;</code>
       * @param value The dataType to set.
       * @return This builder for chaining.
       */
      public Builder setDataType(org.apache.submarine.server.api.proto.TritonModelConfig.DataType value) {
        if (value == null) {
          throw new NullPointerException();
        }
        
        dataType_ = value.getNumber();
        onChanged();
        return this;
      }
      /**
       * <pre>
       *&#64;&#64;    .. cpp:var:: DataType data_type
       *&#64;&#64;
       *&#64;&#64;       The input's datatype. The data type can be TYPE_INT32 or
       *&#64;&#64;       TYPE_FP32.
       *&#64;&#64;
       * </pre>
       *
       * <code>.inference.DataType data_type = 3;</code>
       * @return This builder for chaining.
       */
      public Builder clearDataType() {
        
        dataType_ = 0;
        onChanged();
        return this;
      }

      private com.google.protobuf.LazyStringList sourceInput_ = com.google.protobuf.LazyStringArrayList.EMPTY;
      private void ensureSourceInputIsMutable() {
        if (!((bitField0_ & 0x00000002) != 0)) {
          sourceInput_ = new com.google.protobuf.LazyStringArrayList(sourceInput_);
          bitField0_ |= 0x00000002;
         }
      }
      /**
       * <pre>
       *&#64;&#64;    .. cpp:var:: string source_input (repeated)
       *&#64;&#64;
       *&#64;&#64;       The backend derives the value for each batch input from one or
       *&#64;&#64;       more other inputs. 'source_input' gives the names of those
       *&#64;&#64;       inputs.
       *&#64;&#64;
       * </pre>
       *
       * <code>repeated string source_input = 4;</code>
       * @return A list containing the sourceInput.
       */
      public com.google.protobuf.ProtocolStringList
          getSourceInputList() {
        return sourceInput_.getUnmodifiableView();
      }
      /**
       * <pre>
       *&#64;&#64;    .. cpp:var:: string source_input (repeated)
       *&#64;&#64;
       *&#64;&#64;       The backend derives the value for each batch input from one or
       *&#64;&#64;       more other inputs. 'source_input' gives the names of those
       *&#64;&#64;       inputs.
       *&#64;&#64;
       * </pre>
       *
       * <code>repeated string source_input = 4;</code>
       * @return The count of sourceInput.
       */
      public int getSourceInputCount() {
        return sourceInput_.size();
      }
      /**
       * <pre>
       *&#64;&#64;    .. cpp:var:: string source_input (repeated)
       *&#64;&#64;
       *&#64;&#64;       The backend derives the value for each batch input from one or
       *&#64;&#64;       more other inputs. 'source_input' gives the names of those
       *&#64;&#64;       inputs.
       *&#64;&#64;
       * </pre>
       *
       * <code>repeated string source_input = 4;</code>
       * @param index The index of the element to return.
       * @return The sourceInput at the given index.
       */
      public java.lang.String getSourceInput(int index) {
        return sourceInput_.get(index);
      }
      /**
       * <pre>
       *&#64;&#64;    .. cpp:var:: string source_input (repeated)
       *&#64;&#64;
       *&#64;&#64;       The backend derives the value for each batch input from one or
       *&#64;&#64;       more other inputs. 'source_input' gives the names of those
       *&#64;&#64;       inputs.
       *&#64;&#64;
       * </pre>
       *
       * <code>repeated string source_input = 4;</code>
       * @param index The index of the value to return.
       * @return The bytes of the sourceInput at the given index.
       */
      public com.google.protobuf.ByteString
          getSourceInputBytes(int index) {
        return sourceInput_.getByteString(index);
      }
      /**
       * <pre>
       *&#64;&#64;    .. cpp:var:: string source_input (repeated)
       *&#64;&#64;
       *&#64;&#64;       The backend derives the value for each batch input from one or
       *&#64;&#64;       more other inputs. 'source_input' gives the names of those
       *&#64;&#64;       inputs.
       *&#64;&#64;
       * </pre>
       *
       * <code>repeated string source_input = 4;</code>
       * @param index The index to set the value at.
       * @param value The sourceInput to set.
       * @return This builder for chaining.
       */
      public Builder setSourceInput(
          int index, java.lang.String value) {
        if (value == null) {
    throw new NullPointerException();
  }
  ensureSourceInputIsMutable();
        sourceInput_.set(index, value);
        onChanged();
        return this;
      }
      /**
       * <pre>
       *&#64;&#64;    .. cpp:var:: string source_input (repeated)
       *&#64;&#64;
       *&#64;&#64;       The backend derives the value for each batch input from one or
       *&#64;&#64;       more other inputs. 'source_input' gives the names of those
       *&#64;&#64;       inputs.
       *&#64;&#64;
       * </pre>
       *
       * <code>repeated string source_input = 4;</code>
       * @param value The sourceInput to add.
       * @return This builder for chaining.
       */
      public Builder addSourceInput(
          java.lang.String value) {
        if (value == null) {
    throw new NullPointerException();
  }
  ensureSourceInputIsMutable();
        sourceInput_.add(value);
        onChanged();
        return this;
      }
      /**
       * <pre>
       *&#64;&#64;    .. cpp:var:: string source_input (repeated)
       *&#64;&#64;
       *&#64;&#64;       The backend derives the value for each batch input from one or
       *&#64;&#64;       more other inputs. 'source_input' gives the names of those
       *&#64;&#64;       inputs.
       *&#64;&#64;
       * </pre>
       *
       * <code>repeated string source_input = 4;</code>
       * @param values The sourceInput to add.
       * @return This builder for chaining.
       */
      public Builder addAllSourceInput(
          java.lang.Iterable<java.lang.String> values) {
        ensureSourceInputIsMutable();
        com.google.protobuf.AbstractMessageLite.Builder.addAll(
            values, sourceInput_);
        onChanged();
        return this;
      }
      /**
       * <pre>
       *&#64;&#64;    .. cpp:var:: string source_input (repeated)
       *&#64;&#64;
       *&#64;&#64;       The backend derives the value for each batch input from one or
       *&#64;&#64;       more other inputs. 'source_input' gives the names of those
       *&#64;&#64;       inputs.
       *&#64;&#64;
       * </pre>
       *
       * <code>repeated string source_input = 4;</code>
       * @return This builder for chaining.
       */
      public Builder clearSourceInput() {
        sourceInput_ = com.google.protobuf.LazyStringArrayList.EMPTY;
        bitField0_ = (bitField0_ & ~0x00000002);
        onChanged();
        return this;
      }
      /**
       * <pre>
       *&#64;&#64;    .. cpp:var:: string source_input (repeated)
       *&#64;&#64;
       *&#64;&#64;       The backend derives the value for each batch input from one or
       *&#64;&#64;       more other inputs. 'source_input' gives the names of those
       *&#64;&#64;       inputs.
       *&#64;&#64;
       * </pre>
       *
       * <code>repeated string source_input = 4;</code>
       * @param value The bytes of the sourceInput to add.
       * @return This builder for chaining.
       */
      public Builder addSourceInputBytes(
          com.google.protobuf.ByteString value) {
        if (value == null) {
    throw new NullPointerException();
  }
  checkByteStringIsUtf8(value);
        ensureSourceInputIsMutable();
        sourceInput_.add(value);
        onChanged();
        return this;
      }
      @java.lang.Override
      public final Builder setUnknownFields(
          final com.google.protobuf.UnknownFieldSet unknownFields) {
        return super.setUnknownFields(unknownFields);
      }

      @java.lang.Override
      public final Builder mergeUnknownFields(
          final com.google.protobuf.UnknownFieldSet unknownFields) {
        return super.mergeUnknownFields(unknownFields);
      }


      // @@protoc_insertion_point(builder_scope:inference.BatchInput)
    }

    // @@protoc_insertion_point(class_scope:inference.BatchInput)
    private static final org.apache.submarine.server.api.proto.TritonModelConfig.BatchInput DEFAULT_INSTANCE;
    static {
      DEFAULT_INSTANCE = new org.apache.submarine.server.api.proto.TritonModelConfig.BatchInput();
    }

    public static org.apache.submarine.server.api.proto.TritonModelConfig.BatchInput getDefaultInstance() {
      return DEFAULT_INSTANCE;
    }

    private static final com.google.protobuf.Parser<BatchInput>
        PARSER = new com.google.protobuf.AbstractParser<BatchInput>() {
      @java.lang.Override
      public BatchInput parsePartialFrom(
          com.google.protobuf.CodedInputStream input,
          com.google.protobuf.ExtensionRegistryLite extensionRegistry)
          throws com.google.protobuf.InvalidProtocolBufferException {
        return new BatchInput(input, extensionRegistry);
      }
    };

    public static com.google.protobuf.Parser<BatchInput> parser() {
      return PARSER;
    }

    @java.lang.Override
    public com.google.protobuf.Parser<BatchInput> getParserForType() {
      return PARSER;
    }

    @java.lang.Override
    public org.apache.submarine.server.api.proto.TritonModelConfig.BatchInput getDefaultInstanceForType() {
      return DEFAULT_INSTANCE;
    }

  }

  public interface BatchOutputOrBuilder extends
      // @@protoc_insertion_point(interface_extends:inference.BatchOutput)
      com.google.protobuf.MessageOrBuilder {

    /**
     * <pre>
     *&#64;&#64;  .. cpp:var:: string target_name (repeated)
     *&#64;&#64;
     *&#64;&#64;     The name of the outputs to be produced by this batch output
     *&#64;&#64;     specification.
     *&#64;&#64;
     * </pre>
     *
     * <code>repeated string target_name = 1;</code>
     * @return A list containing the targetName.
     */
    java.util.List<java.lang.String>
        getTargetNameList();
    /**
     * <pre>
     *&#64;&#64;  .. cpp:var:: string target_name (repeated)
     *&#64;&#64;
     *&#64;&#64;     The name of the outputs to be produced by this batch output
     *&#64;&#64;     specification.
     *&#64;&#64;
     * </pre>
     *
     * <code>repeated string target_name = 1;</code>
     * @return The count of targetName.
     */
    int getTargetNameCount();
    /**
     * <pre>
     *&#64;&#64;  .. cpp:var:: string target_name (repeated)
     *&#64;&#64;
     *&#64;&#64;     The name of the outputs to be produced by this batch output
     *&#64;&#64;     specification.
     *&#64;&#64;
     * </pre>
     *
     * <code>repeated string target_name = 1;</code>
     * @param index The index of the element to return.
     * @return The targetName at the given index.
     */
    java.lang.String getTargetName(int index);
    /**
     * <pre>
     *&#64;&#64;  .. cpp:var:: string target_name (repeated)
     *&#64;&#64;
     *&#64;&#64;     The name of the outputs to be produced by this batch output
     *&#64;&#64;     specification.
     *&#64;&#64;
     * </pre>
     *
     * <code>repeated string target_name = 1;</code>
     * @param index The index of the value to return.
     * @return The bytes of the targetName at the given index.
     */
    com.google.protobuf.ByteString
        getTargetNameBytes(int index);

    /**
     * <pre>
     *&#64;&#64;  .. cpp:var:: Kind kind
     *&#64;&#64;
     *&#64;&#64;     The kind of this batch output.
     *&#64;&#64;
     * </pre>
     *
     * <code>.inference.BatchOutput.Kind kind = 2;</code>
     * @return The enum numeric value on the wire for kind.
     */
    int getKindValue();
    /**
     * <pre>
     *&#64;&#64;  .. cpp:var:: Kind kind
     *&#64;&#64;
     *&#64;&#64;     The kind of this batch output.
     *&#64;&#64;
     * </pre>
     *
     * <code>.inference.BatchOutput.Kind kind = 2;</code>
     * @return The kind.
     */
    org.apache.submarine.server.api.proto.TritonModelConfig.BatchOutput.Kind getKind();

    /**
     * <pre>
     *&#64;&#64;  .. cpp:var:: string source_input (repeated)
     *&#64;&#64;
     *&#64;&#64;     The backend derives each batch output from one or more inputs.
     *&#64;&#64;     'source_input' gives the names of those inputs.
     *&#64;&#64;
     * </pre>
     *
     * <code>repeated string source_input = 3;</code>
     * @return A list containing the sourceInput.
     */
    java.util.List<java.lang.String>
        getSourceInputList();
    /**
     * <pre>
     *&#64;&#64;  .. cpp:var:: string source_input (repeated)
     *&#64;&#64;
     *&#64;&#64;     The backend derives each batch output from one or more inputs.
     *&#64;&#64;     'source_input' gives the names of those inputs.
     *&#64;&#64;
     * </pre>
     *
     * <code>repeated string source_input = 3;</code>
     * @return The count of sourceInput.
     */
    int getSourceInputCount();
    /**
     * <pre>
     *&#64;&#64;  .. cpp:var:: string source_input (repeated)
     *&#64;&#64;
     *&#64;&#64;     The backend derives each batch output from one or more inputs.
     *&#64;&#64;     'source_input' gives the names of those inputs.
     *&#64;&#64;
     * </pre>
     *
     * <code>repeated string source_input = 3;</code>
     * @param index The index of the element to return.
     * @return The sourceInput at the given index.
     */
    java.lang.String getSourceInput(int index);
    /**
     * <pre>
     *&#64;&#64;  .. cpp:var:: string source_input (repeated)
     *&#64;&#64;
     *&#64;&#64;     The backend derives each batch output from one or more inputs.
     *&#64;&#64;     'source_input' gives the names of those inputs.
     *&#64;&#64;
     * </pre>
     *
     * <code>repeated string source_input = 3;</code>
     * @param index The index of the value to return.
     * @return The bytes of the sourceInput at the given index.
     */
    com.google.protobuf.ByteString
        getSourceInputBytes(int index);
  }
  /**
   * <pre>
   *&#64;&#64;.. cpp:var:: message BatchOutput
   *&#64;&#64;
   *&#64;&#64;   A batch output is an output produced by the model that must be handled
   *&#64;&#64;   differently by the backend based on all the requests in a batch.
   *&#64;&#64;
   * </pre>
   *
   * Protobuf type {@code inference.BatchOutput}
   */
  public static final class BatchOutput extends
      com.google.protobuf.GeneratedMessageV3 implements
      // @@protoc_insertion_point(message_implements:inference.BatchOutput)
      BatchOutputOrBuilder {
  private static final long serialVersionUID = 0L;
    // Use BatchOutput.newBuilder() to construct.
    private BatchOutput(com.google.protobuf.GeneratedMessageV3.Builder<?> builder) {
      super(builder);
    }
    private BatchOutput() {
      targetName_ = com.google.protobuf.LazyStringArrayList.EMPTY;
      kind_ = 0;
      sourceInput_ = com.google.protobuf.LazyStringArrayList.EMPTY;
    }

    @java.lang.Override
    @SuppressWarnings({"unused"})
    protected java.lang.Object newInstance(
        UnusedPrivateParameter unused) {
      return new BatchOutput();
    }

    @java.lang.Override
    public final com.google.protobuf.UnknownFieldSet
    getUnknownFields() {
      return this.unknownFields;
    }
    private BatchOutput(
        com.google.protobuf.CodedInputStream input,
        com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws com.google.protobuf.InvalidProtocolBufferException {
      this();
      if (extensionRegistry == null) {
        throw new java.lang.NullPointerException();
      }
      int mutable_bitField0_ = 0;
      com.google.protobuf.UnknownFieldSet.Builder unknownFields =
          com.google.protobuf.UnknownFieldSet.newBuilder();
      try {
        boolean done = false;
        while (!done) {
          int tag = input.readTag();
          switch (tag) {
            case 0:
              done = true;
              break;
            case 10: {
              java.lang.String s = input.readStringRequireUtf8();
              if (!((mutable_bitField0_ & 0x00000001) != 0)) {
                targetName_ = new com.google.protobuf.LazyStringArrayList();
                mutable_bitField0_ |= 0x00000001;
              }
              targetName_.add(s);
              break;
            }
            case 16: {
              int rawValue = input.readEnum();

              kind_ = rawValue;
              break;
            }
            case 26: {
              java.lang.String s = input.readStringRequireUtf8();
              if (!((mutable_bitField0_ & 0x00000002) != 0)) {
                sourceInput_ = new com.google.protobuf.LazyStringArrayList();
                mutable_bitField0_ |= 0x00000002;
              }
              sourceInput_.add(s);
              break;
            }
            default: {
              if (!parseUnknownField(
                  input, unknownFields, extensionRegistry, tag)) {
                done = true;
              }
              break;
            }
          }
        }
      } catch (com.google.protobuf.InvalidProtocolBufferException e) {
        throw e.setUnfinishedMessage(this);
      } catch (java.io.IOException e) {
        throw new com.google.protobuf.InvalidProtocolBufferException(
            e).setUnfinishedMessage(this);
      } finally {
        if (((mutable_bitField0_ & 0x00000001) != 0)) {
          targetName_ = targetName_.getUnmodifiableView();
        }
        if (((mutable_bitField0_ & 0x00000002) != 0)) {
          sourceInput_ = sourceInput_.getUnmodifiableView();
        }
        this.unknownFields = unknownFields.build();
        makeExtensionsImmutable();
      }
    }
    public static final com.google.protobuf.Descriptors.Descriptor
        getDescriptor() {
      return org.apache.submarine.server.api.proto.TritonModelConfig.internal_static_inference_BatchOutput_descriptor;
    }

    @java.lang.Override
    protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
        internalGetFieldAccessorTable() {
      return org.apache.submarine.server.api.proto.TritonModelConfig.internal_static_inference_BatchOutput_fieldAccessorTable
          .ensureFieldAccessorsInitialized(
              org.apache.submarine.server.api.proto.TritonModelConfig.BatchOutput.class, org.apache.submarine.server.api.proto.TritonModelConfig.BatchOutput.Builder.class);
    }

    /**
     * <pre>
     *&#64;&#64;
     *&#64;&#64;  .. cpp:enum:: Kind
     *&#64;&#64;
     *&#64;&#64;     The kind of the batch output.
     *&#64;&#64;
     * </pre>
     *
     * Protobuf enum {@code inference.BatchOutput.Kind}
     */
    public enum Kind
        implements com.google.protobuf.ProtocolMessageEnum {
      /**
       * <pre>
       *&#64;&#64;    .. cpp:enumerator:: Kind::BATCH_SCATTER_WITH_INPUT_SHAPE = 0
       *&#64;&#64;
       *&#64;&#64;       The output should be scattered according to the shape of
       *&#64;&#64;       'source_input'. The dynamic dimension of the output will
       *&#64;&#64;       be set to the value of the same dimension in the input.
       *&#64;&#64;
       * </pre>
       *
       * <code>BATCH_SCATTER_WITH_INPUT_SHAPE = 0;</code>
       */
      BATCH_SCATTER_WITH_INPUT_SHAPE(0),
      UNRECOGNIZED(-1),
      ;

      /**
       * <pre>
       *&#64;&#64;    .. cpp:enumerator:: Kind::BATCH_SCATTER_WITH_INPUT_SHAPE = 0
       *&#64;&#64;
       *&#64;&#64;       The output should be scattered according to the shape of
       *&#64;&#64;       'source_input'. The dynamic dimension of the output will
       *&#64;&#64;       be set to the value of the same dimension in the input.
       *&#64;&#64;
       * </pre>
       *
       * <code>BATCH_SCATTER_WITH_INPUT_SHAPE = 0;</code>
       */
      public static final int BATCH_SCATTER_WITH_INPUT_SHAPE_VALUE = 0;


      public final int getNumber() {
        if (this == UNRECOGNIZED) {
          throw new java.lang.IllegalArgumentException(
              "Can't get the number of an unknown enum value.");
        }
        return value;
      }

      /**
       * @param value The numeric wire value of the corresponding enum entry.
       * @return The enum associated with the given numeric wire value.
       * @deprecated Use {@link #forNumber(int)} instead.
       */
      @java.lang.Deprecated
      public static Kind valueOf(int value) {
        return forNumber(value);
      }

      /**
       * @param value The numeric wire value of the corresponding enum entry.
       * @return The enum associated with the given numeric wire value.
       */
      public static Kind forNumber(int value) {
        switch (value) {
          case 0: return BATCH_SCATTER_WITH_INPUT_SHAPE;
          default: return null;
        }
      }

      public static com.google.protobuf.Internal.EnumLiteMap<Kind>
          internalGetValueMap() {
        return internalValueMap;
      }
      private static final com.google.protobuf.Internal.EnumLiteMap<
          Kind> internalValueMap =
            new com.google.protobuf.Internal.EnumLiteMap<Kind>() {
              public Kind findValueByNumber(int number) {
                return Kind.forNumber(number);
              }
            };

      public final com.google.protobuf.Descriptors.EnumValueDescriptor
          getValueDescriptor() {
        if (this == UNRECOGNIZED) {
          throw new java.lang.IllegalStateException(
              "Can't get the descriptor of an unrecognized enum value.");
        }
        return getDescriptor().getValues().get(ordinal());
      }
      public final com.google.protobuf.Descriptors.EnumDescriptor
          getDescriptorForType() {
        return getDescriptor();
      }
      public static final com.google.protobuf.Descriptors.EnumDescriptor
          getDescriptor() {
        return org.apache.submarine.server.api.proto.TritonModelConfig.BatchOutput.getDescriptor().getEnumTypes().get(0);
      }

      private static final Kind[] VALUES = values();

      public static Kind valueOf(
          com.google.protobuf.Descriptors.EnumValueDescriptor desc) {
        if (desc.getType() != getDescriptor()) {
          throw new java.lang.IllegalArgumentException(
            "EnumValueDescriptor is not for this type.");
        }
        if (desc.getIndex() == -1) {
          return UNRECOGNIZED;
        }
        return VALUES[desc.getIndex()];
      }

      private final int value;

      private Kind(int value) {
        this.value = value;
      }

      // @@protoc_insertion_point(enum_scope:inference.BatchOutput.Kind)
    }

    public static final int TARGET_NAME_FIELD_NUMBER = 1;
    private com.google.protobuf.LazyStringList targetName_;
    /**
     * <pre>
     *&#64;&#64;  .. cpp:var:: string target_name (repeated)
     *&#64;&#64;
     *&#64;&#64;     The name of the outputs to be produced by this batch output
     *&#64;&#64;     specification.
     *&#64;&#64;
     * </pre>
     *
     * <code>repeated string target_name = 1;</code>
     * @return A list containing the targetName.
     */
    public com.google.protobuf.ProtocolStringList
        getTargetNameList() {
      return targetName_;
    }
    /**
     * <pre>
     *&#64;&#64;  .. cpp:var:: string target_name (repeated)
     *&#64;&#64;
     *&#64;&#64;     The name of the outputs to be produced by this batch output
     *&#64;&#64;     specification.
     *&#64;&#64;
     * </pre>
     *
     * <code>repeated string target_name = 1;</code>
     * @return The count of targetName.
     */
    public int getTargetNameCount() {
      return targetName_.size();
    }
    /**
     * <pre>
     *&#64;&#64;  .. cpp:var:: string target_name (repeated)
     *&#64;&#64;
     *&#64;&#64;     The name of the outputs to be produced by this batch output
     *&#64;&#64;     specification.
     *&#64;&#64;
     * </pre>
     *
     * <code>repeated string target_name = 1;</code>
     * @param index The index of the element to return.
     * @return The targetName at the given index.
     */
    public java.lang.String getTargetName(int index) {
      return targetName_.get(index);
    }
    /**
     * <pre>
     *&#64;&#64;  .. cpp:var:: string target_name (repeated)
     *&#64;&#64;
     *&#64;&#64;     The name of the outputs to be produced by this batch output
     *&#64;&#64;     specification.
     *&#64;&#64;
     * </pre>
     *
     * <code>repeated string target_name = 1;</code>
     * @param index The index of the value to return.
     * @return The bytes of the targetName at the given index.
     */
    public com.google.protobuf.ByteString
        getTargetNameBytes(int index) {
      return targetName_.getByteString(index);
    }

    public static final int KIND_FIELD_NUMBER = 2;
    private int kind_;
    /**
     * <pre>
     *&#64;&#64;  .. cpp:var:: Kind kind
     *&#64;&#64;
     *&#64;&#64;     The kind of this batch output.
     *&#64;&#64;
     * </pre>
     *
     * <code>.inference.BatchOutput.Kind kind = 2;</code>
     * @return The enum numeric value on the wire for kind.
     */
    @java.lang.Override public int getKindValue() {
      return kind_;
    }
    /**
     * <pre>
     *&#64;&#64;  .. cpp:var:: Kind kind
     *&#64;&#64;
     *&#64;&#64;     The kind of this batch output.
     *&#64;&#64;
     * </pre>
     *
     * <code>.inference.BatchOutput.Kind kind = 2;</code>
     * @return The kind.
     */
    @java.lang.Override public org.apache.submarine.server.api.proto.TritonModelConfig.BatchOutput.Kind getKind() {
      @SuppressWarnings("deprecation")
      org.apache.submarine.server.api.proto.TritonModelConfig.BatchOutput.Kind result = org.apache.submarine.server.api.proto.TritonModelConfig.BatchOutput.Kind.valueOf(kind_);
      return result == null ? org.apache.submarine.server.api.proto.TritonModelConfig.BatchOutput.Kind.UNRECOGNIZED : result;
    }

    public static final int SOURCE_INPUT_FIELD_NUMBER = 3;
    private com.google.protobuf.LazyStringList sourceInput_;
    /**
     * <pre>
     *&#64;&#64;  .. cpp:var:: string source_input (repeated)
     *&#64;&#64;
     *&#64;&#64;     The backend derives each batch output from one or more inputs.
     *&#64;&#64;     'source_input' gives the names of those inputs.
     *&#64;&#64;
     * </pre>
     *
     * <code>repeated string source_input = 3;</code>
     * @return A list containing the sourceInput.
     */
    public com.google.protobuf.ProtocolStringList
        getSourceInputList() {
      return sourceInput_;
    }
    /**
     * <pre>
     *&#64;&#64;  .. cpp:var:: string source_input (repeated)
     *&#64;&#64;
     *&#64;&#64;     The backend derives each batch output from one or more inputs.
     *&#64;&#64;     'source_input' gives the names of those inputs.
     *&#64;&#64;
     * </pre>
     *
     * <code>repeated string source_input = 3;</code>
     * @return The count of sourceInput.
     */
    public int getSourceInputCount() {
      return sourceInput_.size();
    }
    /**
     * <pre>
     *&#64;&#64;  .. cpp:var:: string source_input (repeated)
     *&#64;&#64;
     *&#64;&#64;     The backend derives each batch output from one or more inputs.
     *&#64;&#64;     'source_input' gives the names of those inputs.
     *&#64;&#64;
     * </pre>
     *
     * <code>repeated string source_input = 3;</code>
     * @param index The index of the element to return.
     * @return The sourceInput at the given index.
     */
    public java.lang.String getSourceInput(int index) {
      return sourceInput_.get(index);
    }
    /**
     * <pre>
     *&#64;&#64;  .. cpp:var:: string source_input (repeated)
     *&#64;&#64;
     *&#64;&#64;     The backend derives each batch output from one or more inputs.
     *&#64;&#64;     'source_input' gives the names of those inputs.
     *&#64;&#64;
     * </pre>
     *
     * <code>repeated string source_input = 3;</code>
     * @param index The index of the value to return.
     * @return The bytes of the sourceInput at the given index.
     */
    public com.google.protobuf.ByteString
        getSourceInputBytes(int index) {
      return sourceInput_.getByteString(index);
    }

    private byte memoizedIsInitialized = -1;
    @java.lang.Override
    public final boolean isInitialized() {
      byte isInitialized = memoizedIsInitialized;
      if (isInitialized == 1) return true;
      if (isInitialized == 0) return false;

      memoizedIsInitialized = 1;
      return true;
    }

    @java.lang.Override
    public void writeTo(com.google.protobuf.CodedOutputStream output)
                        throws java.io.IOException {
      for (int i = 0; i < targetName_.size(); i++) {
        com.google.protobuf.GeneratedMessageV3.writeString(output, 1, targetName_.getRaw(i));
      }
      if (kind_ != org.apache.submarine.server.api.proto.TritonModelConfig.BatchOutput.Kind.BATCH_SCATTER_WITH_INPUT_SHAPE.getNumber()) {
        output.writeEnum(2, kind_);
      }
      for (int i = 0; i < sourceInput_.size(); i++) {
        com.google.protobuf.GeneratedMessageV3.writeString(output, 3, sourceInput_.getRaw(i));
      }
      unknownFields.writeTo(output);
    }

    @java.lang.Override
    public int getSerializedSize() {
      int size = memoizedSize;
      if (size != -1) return size;

      size = 0;
      {
        int dataSize = 0;
        for (int i = 0; i < targetName_.size(); i++) {
          dataSize += computeStringSizeNoTag(targetName_.getRaw(i));
        }
        size += dataSize;
        size += 1 * getTargetNameList().size();
      }
      if (kind_ != org.apache.submarine.server.api.proto.TritonModelConfig.BatchOutput.Kind.BATCH_SCATTER_WITH_INPUT_SHAPE.getNumber()) {
        size += com.google.protobuf.CodedOutputStream
          .computeEnumSize(2, kind_);
      }
      {
        int dataSize = 0;
        for (int i = 0; i < sourceInput_.size(); i++) {
          dataSize += computeStringSizeNoTag(sourceInput_.getRaw(i));
        }
        size += dataSize;
        size += 1 * getSourceInputList().size();
      }
      size += unknownFields.getSerializedSize();
      memoizedSize = size;
      return size;
    }

    @java.lang.Override
    public boolean equals(final java.lang.Object obj) {
      if (obj == this) {
       return true;
      }
      if (!(obj instanceof org.apache.submarine.server.api.proto.TritonModelConfig.BatchOutput)) {
        return super.equals(obj);
      }
      org.apache.submarine.server.api.proto.TritonModelConfig.BatchOutput other = (org.apache.submarine.server.api.proto.TritonModelConfig.BatchOutput) obj;

      if (!getTargetNameList()
          .equals(other.getTargetNameList())) return false;
      if (kind_ != other.kind_) return false;
      if (!getSourceInputList()
          .equals(other.getSourceInputList())) return false;
      if (!unknownFields.equals(other.unknownFields)) return false;
      return true;
    }

    @java.lang.Override
    public int hashCode() {
      if (memoizedHashCode != 0) {
        return memoizedHashCode;
      }
      int hash = 41;
      hash = (19 * hash) + getDescriptor().hashCode();
      if (getTargetNameCount() > 0) {
        hash = (37 * hash) + TARGET_NAME_FIELD_NUMBER;
        hash = (53 * hash) + getTargetNameList().hashCode();
      }
      hash = (37 * hash) + KIND_FIELD_NUMBER;
      hash = (53 * hash) + kind_;
      if (getSourceInputCount() > 0) {
        hash = (37 * hash) + SOURCE_INPUT_FIELD_NUMBER;
        hash = (53 * hash) + getSourceInputList().hashCode();
      }
      hash = (29 * hash) + unknownFields.hashCode();
      memoizedHashCode = hash;
      return hash;
    }

    public static org.apache.submarine.server.api.proto.TritonModelConfig.BatchOutput parseFrom(
        java.nio.ByteBuffer data)
        throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data);
    }
    public static org.apache.submarine.server.api.proto.TritonModelConfig.BatchOutput parseFrom(
        java.nio.ByteBuffer data,
        com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data, extensionRegistry);
    }
    public static org.apache.submarine.server.api.proto.TritonModelConfig.BatchOutput parseFrom(
        com.google.protobuf.ByteString data)
        throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data);
    }
    public static org.apache.submarine.server.api.proto.TritonModelConfig.BatchOutput parseFrom(
        com.google.protobuf.ByteString data,
        com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data, extensionRegistry);
    }
    public static org.apache.submarine.server.api.proto.TritonModelConfig.BatchOutput parseFrom(byte[] data)
        throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data);
    }
    public static org.apache.submarine.server.api.proto.TritonModelConfig.BatchOutput parseFrom(
        byte[] data,
        com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data, extensionRegistry);
    }
    public static org.apache.submarine.server.api.proto.TritonModelConfig.BatchOutput parseFrom(java.io.InputStream input)
        throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3
          .parseWithIOException(PARSER, input);
    }
    public static org.apache.submarine.server.api.proto.TritonModelConfig.BatchOutput parseFrom(
        java.io.InputStream input,
        com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3
          .parseWithIOException(PARSER, input, extensionRegistry);
    }
    public static org.apache.submarine.server.api.proto.TritonModelConfig.BatchOutput parseDelimitedFrom(java.io.InputStream input)
        throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3
          .parseDelimitedWithIOException(PARSER, input);
    }
    public static org.apache.submarine.server.api.proto.TritonModelConfig.BatchOutput parseDelimitedFrom(
        java.io.InputStream input,
        com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3
          .parseDelimitedWithIOException(PARSER, input, extensionRegistry);
    }
    public static org.apache.submarine.server.api.proto.TritonModelConfig.BatchOutput parseFrom(
        com.google.protobuf.CodedInputStream input)
        throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3
          .parseWithIOException(PARSER, input);
    }
    public static org.apache.submarine.server.api.proto.TritonModelConfig.BatchOutput parseFrom(
        com.google.protobuf.CodedInputStream input,
        com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3
          .parseWithIOException(PARSER, input, extensionRegistry);
    }

    @java.lang.Override
    public Builder newBuilderForType() { return newBuilder(); }
    public static Builder newBuilder() {
      return DEFAULT_INSTANCE.toBuilder();
    }
    public static Builder newBuilder(org.apache.submarine.server.api.proto.TritonModelConfig.BatchOutput prototype) {
      return DEFAULT_INSTANCE.toBuilder().mergeFrom(prototype);
    }
    @java.lang.Override
    public Builder toBuilder() {
      return this == DEFAULT_INSTANCE
          ? new Builder() : new Builder().mergeFrom(this);
    }

    @java.lang.Override
    protected Builder newBuilderForType(
        com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
      Builder builder = new Builder(parent);
      return builder;
    }
    /**
     * <pre>
     *&#64;&#64;.. cpp:var:: message BatchOutput
     *&#64;&#64;
     *&#64;&#64;   A batch output is an output produced by the model that must be handled
     *&#64;&#64;   differently by the backend based on all the requests in a batch.
     *&#64;&#64;
     * </pre>
     *
     * Protobuf type {@code inference.BatchOutput}
     */
    public static final class Builder extends
        com.google.protobuf.GeneratedMessageV3.Builder<Builder> implements
        // @@protoc_insertion_point(builder_implements:inference.BatchOutput)
        org.apache.submarine.server.api.proto.TritonModelConfig.BatchOutputOrBuilder {
      public static final com.google.protobuf.Descriptors.Descriptor
          getDescriptor() {
        return org.apache.submarine.server.api.proto.TritonModelConfig.internal_static_inference_BatchOutput_descriptor;
      }

      @java.lang.Override
      protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
          internalGetFieldAccessorTable() {
        return org.apache.submarine.server.api.proto.TritonModelConfig.internal_static_inference_BatchOutput_fieldAccessorTable
            .ensureFieldAccessorsInitialized(
                org.apache.submarine.server.api.proto.TritonModelConfig.BatchOutput.class, org.apache.submarine.server.api.proto.TritonModelConfig.BatchOutput.Builder.class);
      }

      // Construct using org.apache.submarine.server.api.proto.TritonModelConfig.BatchOutput.newBuilder()
      private Builder() {
        maybeForceBuilderInitialization();
      }

      private Builder(
          com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
        super(parent);
        maybeForceBuilderInitialization();
      }
      private void maybeForceBuilderInitialization() {
        if (com.google.protobuf.GeneratedMessageV3
                .alwaysUseFieldBuilders) {
        }
      }
      @java.lang.Override
      public Builder clear() {
        super.clear();
        targetName_ = com.google.protobuf.LazyStringArrayList.EMPTY;
        bitField0_ = (bitField0_ & ~0x00000001);
        kind_ = 0;

        sourceInput_ = com.google.protobuf.LazyStringArrayList.EMPTY;
        bitField0_ = (bitField0_ & ~0x00000002);
        return this;
      }

      @java.lang.Override
      public com.google.protobuf.Descriptors.Descriptor
          getDescriptorForType() {
        return org.apache.submarine.server.api.proto.TritonModelConfig.internal_static_inference_BatchOutput_descriptor;
      }

      @java.lang.Override
      public org.apache.submarine.server.api.proto.TritonModelConfig.BatchOutput getDefaultInstanceForType() {
        return org.apache.submarine.server.api.proto.TritonModelConfig.BatchOutput.getDefaultInstance();
      }

      @java.lang.Override
      public org.apache.submarine.server.api.proto.TritonModelConfig.BatchOutput build() {
        org.apache.submarine.server.api.proto.TritonModelConfig.BatchOutput result = buildPartial();
        if (!result.isInitialized()) {
          throw newUninitializedMessageException(result);
        }
        return result;
      }

      @java.lang.Override
      public org.apache.submarine.server.api.proto.TritonModelConfig.BatchOutput buildPartial() {
        org.apache.submarine.server.api.proto.TritonModelConfig.BatchOutput result = new org.apache.submarine.server.api.proto.TritonModelConfig.BatchOutput(this);
        int from_bitField0_ = bitField0_;
        if (((bitField0_ & 0x00000001) != 0)) {
          targetName_ = targetName_.getUnmodifiableView();
          bitField0_ = (bitField0_ & ~0x00000001);
        }
        result.targetName_ = targetName_;
        result.kind_ = kind_;
        if (((bitField0_ & 0x00000002) != 0)) {
          sourceInput_ = sourceInput_.getUnmodifiableView();
          bitField0_ = (bitField0_ & ~0x00000002);
        }
        result.sourceInput_ = sourceInput_;
        onBuilt();
        return result;
      }

      @java.lang.Override
      public Builder clone() {
        return super.clone();
      }
      @java.lang.Override
      public Builder setField(
          com.google.protobuf.Descriptors.FieldDescriptor field,
          java.lang.Object value) {
        return super.setField(field, value);
      }
      @java.lang.Override
      public Builder clearField(
          com.google.protobuf.Descriptors.FieldDescriptor field) {
        return super.clearField(field);
      }
      @java.lang.Override
      public Builder clearOneof(
          com.google.protobuf.Descriptors.OneofDescriptor oneof) {
        return super.clearOneof(oneof);
      }
      @java.lang.Override
      public Builder setRepeatedField(
          com.google.protobuf.Descriptors.FieldDescriptor field,
          int index, java.lang.Object value) {
        return super.setRepeatedField(field, index, value);
      }
      @java.lang.Override
      public Builder addRepeatedField(
          com.google.protobuf.Descriptors.FieldDescriptor field,
          java.lang.Object value) {
        return super.addRepeatedField(field, value);
      }
      @java.lang.Override
      public Builder mergeFrom(com.google.protobuf.Message other) {
        if (other instanceof org.apache.submarine.server.api.proto.TritonModelConfig.BatchOutput) {
          return mergeFrom((org.apache.submarine.server.api.proto.TritonModelConfig.BatchOutput)other);
        } else {
          super.mergeFrom(other);
          return this;
        }
      }

      public Builder mergeFrom(org.apache.submarine.server.api.proto.TritonModelConfig.BatchOutput other) {
        if (other == org.apache.submarine.server.api.proto.TritonModelConfig.BatchOutput.getDefaultInstance()) return this;
        if (!other.targetName_.isEmpty()) {
          if (targetName_.isEmpty()) {
            targetName_ = other.targetName_;
            bitField0_ = (bitField0_ & ~0x00000001);
          } else {
            ensureTargetNameIsMutable();
            targetName_.addAll(other.targetName_);
          }
          onChanged();
        }
        if (other.kind_ != 0) {
          setKindValue(other.getKindValue());
        }
        if (!other.sourceInput_.isEmpty()) {
          if (sourceInput_.isEmpty()) {
            sourceInput_ = other.sourceInput_;
            bitField0_ = (bitField0_ & ~0x00000002);
          } else {
            ensureSourceInputIsMutable();
            sourceInput_.addAll(other.sourceInput_);
          }
          onChanged();
        }
        this.mergeUnknownFields(other.unknownFields);
        onChanged();
        return this;
      }

      @java.lang.Override
      public final boolean isInitialized() {
        return true;
      }

      @java.lang.Override
      public Builder mergeFrom(
          com.google.protobuf.CodedInputStream input,
          com.google.protobuf.ExtensionRegistryLite extensionRegistry)
          throws java.io.IOException {
        org.apache.submarine.server.api.proto.TritonModelConfig.BatchOutput parsedMessage = null;
        try {
          parsedMessage = PARSER.parsePartialFrom(input, extensionRegistry);
        } catch (com.google.protobuf.InvalidProtocolBufferException e) {
          parsedMessage = (org.apache.submarine.server.api.proto.TritonModelConfig.BatchOutput) e.getUnfinishedMessage();
          throw e.unwrapIOException();
        } finally {
          if (parsedMessage != null) {
            mergeFrom(parsedMessage);
          }
        }
        return this;
      }
      private int bitField0_;

      private com.google.protobuf.LazyStringList targetName_ = com.google.protobuf.LazyStringArrayList.EMPTY;
      private void ensureTargetNameIsMutable() {
        if (!((bitField0_ & 0x00000001) != 0)) {
          targetName_ = new com.google.protobuf.LazyStringArrayList(targetName_);
          bitField0_ |= 0x00000001;
         }
      }
      /**
       * <pre>
       *&#64;&#64;  .. cpp:var:: string target_name (repeated)
       *&#64;&#64;
       *&#64;&#64;     The name of the outputs to be produced by this batch output
       *&#64;&#64;     specification.
       *&#64;&#64;
       * </pre>
       *
       * <code>repeated string target_name = 1;</code>
       * @return A list containing the targetName.
       */
      public com.google.protobuf.ProtocolStringList
          getTargetNameList() {
        return targetName_.getUnmodifiableView();
      }
      /**
       * <pre>
       *&#64;&#64;  .. cpp:var:: string target_name (repeated)
       *&#64;&#64;
       *&#64;&#64;     The name of the outputs to be produced by this batch output
       *&#64;&#64;     specification.
       *&#64;&#64;
       * </pre>
       *
       * <code>repeated string target_name = 1;</code>
       * @return The count of targetName.
       */
      public int getTargetNameCount() {
        return targetName_.size();
      }
      /**
       * <pre>
       *&#64;&#64;  .. cpp:var:: string target_name (repeated)
       *&#64;&#64;
       *&#64;&#64;     The name of the outputs to be produced by this batch output
       *&#64;&#64;     specification.
       *&#64;&#64;
       * </pre>
       *
       * <code>repeated string target_name = 1;</code>
       * @param index The index of the element to return.
       * @return The targetName at the given index.
       */
      public java.lang.String getTargetName(int index) {
        return targetName_.get(index);
      }
      /**
       * <pre>
       *&#64;&#64;  .. cpp:var:: string target_name (repeated)
       *&#64;&#64;
       *&#64;&#64;     The name of the outputs to be produced by this batch output
       *&#64;&#64;     specification.
       *&#64;&#64;
       * </pre>
       *
       * <code>repeated string target_name = 1;</code>
       * @param index The index of the value to return.
       * @return The bytes of the targetName at the given index.
       */
      public com.google.protobuf.ByteString
          getTargetNameBytes(int index) {
        return targetName_.getByteString(index);
      }
      /**
       * <pre>
       *&#64;&#64;  .. cpp:var:: string target_name (repeated)
       *&#64;&#64;
       *&#64;&#64;     The name of the outputs to be produced by this batch output
       *&#64;&#64;     specification.
       *&#64;&#64;
       * </pre>
       *
       * <code>repeated string target_name = 1;</code>
       * @param index The index to set the value at.
       * @param value The targetName to set.
       * @return This builder for chaining.
       */
      public Builder setTargetName(
          int index, java.lang.String value) {
        if (value == null) {
    throw new NullPointerException();
  }
  ensureTargetNameIsMutable();
        targetName_.set(index, value);
        onChanged();
        return this;
      }
      /**
       * <pre>
       *&#64;&#64;  .. cpp:var:: string target_name (repeated)
       *&#64;&#64;
       *&#64;&#64;     The name of the outputs to be produced by this batch output
       *&#64;&#64;     specification.
       *&#64;&#64;
       * </pre>
       *
       * <code>repeated string target_name = 1;</code>
       * @param value The targetName to add.
       * @return This builder for chaining.
       */
      public Builder addTargetName(
          java.lang.String value) {
        if (value == null) {
    throw new NullPointerException();
  }
  ensureTargetNameIsMutable();
        targetName_.add(value);
        onChanged();
        return this;
      }
      /**
       * <pre>
       *&#64;&#64;  .. cpp:var:: string target_name (repeated)
       *&#64;&#64;
       *&#64;&#64;     The name of the outputs to be produced by this batch output
       *&#64;&#64;     specification.
       *&#64;&#64;
       * </pre>
       *
       * <code>repeated string target_name = 1;</code>
       * @param values The targetName to add.
       * @return This builder for chaining.
       */
      public Builder addAllTargetName(
          java.lang.Iterable<java.lang.String> values) {
        ensureTargetNameIsMutable();
        com.google.protobuf.AbstractMessageLite.Builder.addAll(
            values, targetName_);
        onChanged();
        return this;
      }
      /**
       * <pre>
       *&#64;&#64;  .. cpp:var:: string target_name (repeated)
       *&#64;&#64;
       *&#64;&#64;     The name of the outputs to be produced by this batch output
       *&#64;&#64;     specification.
       *&#64;&#64;
       * </pre>
       *
       * <code>repeated string target_name = 1;</code>
       * @return This builder for chaining.
       */
      public Builder clearTargetName() {
        targetName_ = com.google.protobuf.LazyStringArrayList.EMPTY;
        bitField0_ = (bitField0_ & ~0x00000001);
        onChanged();
        return this;
      }
      /**
       * <pre>
       *&#64;&#64;  .. cpp:var:: string target_name (repeated)
       *&#64;&#64;
       *&#64;&#64;     The name of the outputs to be produced by this batch output
       *&#64;&#64;     specification.
       *&#64;&#64;
       * </pre>
       *
       * <code>repeated string target_name = 1;</code>
       * @param value The bytes of the targetName to add.
       * @return This builder for chaining.
       */
      public Builder addTargetNameBytes(
          com.google.protobuf.ByteString value) {
        if (value == null) {
    throw new NullPointerException();
  }
  checkByteStringIsUtf8(value);
        ensureTargetNameIsMutable();
        targetName_.add(value);
        onChanged();
        return this;
      }

      private int kind_ = 0;
      /**
       * <pre>
       *&#64;&#64;  .. cpp:var:: Kind kind
       *&#64;&#64;
       *&#64;&#64;     The kind of this batch output.
       *&#64;&#64;
       * </pre>
       *
       * <code>.inference.BatchOutput.Kind kind = 2;</code>
       * @return The enum numeric value on the wire for kind.
       */
      @java.lang.Override public int getKindValue() {
        return kind_;
      }
      /**
       * <pre>
       *&#64;&#64;  .. cpp:var:: Kind kind
       *&#64;&#64;
       *&#64;&#64;     The kind of this batch output.
       *&#64;&#64;
       * </pre>
       *
       * <code>.inference.BatchOutput.Kind kind = 2;</code>
       * @param value The enum numeric value on the wire for kind to set.
       * @return This builder for chaining.
       */
      public Builder setKindValue(int value) {
        
        kind_ = value;
        onChanged();
        return this;
      }
      /**
       * <pre>
       *&#64;&#64;  .. cpp:var:: Kind kind
       *&#64;&#64;
       *&#64;&#64;     The kind of this batch output.
       *&#64;&#64;
       * </pre>
       *
       * <code>.inference.BatchOutput.Kind kind = 2;</code>
       * @return The kind.
       */
      @java.lang.Override
      public org.apache.submarine.server.api.proto.TritonModelConfig.BatchOutput.Kind getKind() {
        @SuppressWarnings("deprecation")
        org.apache.submarine.server.api.proto.TritonModelConfig.BatchOutput.Kind result = org.apache.submarine.server.api.proto.TritonModelConfig.BatchOutput.Kind.valueOf(kind_);
        return result == null ? org.apache.submarine.server.api.proto.TritonModelConfig.BatchOutput.Kind.UNRECOGNIZED : result;
      }
      /**
       * <pre>
       *&#64;&#64;  .. cpp:var:: Kind kind
       *&#64;&#64;
       *&#64;&#64;     The kind of this batch output.
       *&#64;&#64;
       * </pre>
       *
       * <code>.inference.BatchOutput.Kind kind = 2;</code>
       * @param value The kind to set.
       * @return This builder for chaining.
       */
      public Builder setKind(org.apache.submarine.server.api.proto.TritonModelConfig.BatchOutput.Kind value) {
        if (value == null) {
          throw new NullPointerException();
        }
        
        kind_ = value.getNumber();
        onChanged();
        return this;
      }
      /**
       * <pre>
       *&#64;&#64;  .. cpp:var:: Kind kind
       *&#64;&#64;
       *&#64;&#64;     The kind of this batch output.
       *&#64;&#64;
       * </pre>
       *
       * <code>.inference.BatchOutput.Kind kind = 2;</code>
       * @return This builder for chaining.
       */
      public Builder clearKind() {
        
        kind_ = 0;
        onChanged();
        return this;
      }

      private com.google.protobuf.LazyStringList sourceInput_ = com.google.protobuf.LazyStringArrayList.EMPTY;
      private void ensureSourceInputIsMutable() {
        if (!((bitField0_ & 0x00000002) != 0)) {
          sourceInput_ = new com.google.protobuf.LazyStringArrayList(sourceInput_);
          bitField0_ |= 0x00000002;
         }
      }
      /**
       * <pre>
       *&#64;&#64;  .. cpp:var:: string source_input (repeated)
       *&#64;&#64;
       *&#64;&#64;     The backend derives each batch output from one or more inputs.
       *&#64;&#64;     'source_input' gives the names of those inputs.
       *&#64;&#64;
       * </pre>
       *
       * <code>repeated string source_input = 3;</code>
       * @return A list containing the sourceInput.
       */
      public com.google.protobuf.ProtocolStringList
          getSourceInputList() {
        return sourceInput_.getUnmodifiableView();
      }
      /**
       * <pre>
       *&#64;&#64;  .. cpp:var:: string source_input (repeated)
       *&#64;&#64;
       *&#64;&#64;     The backend derives each batch output from one or more inputs.
       *&#64;&#64;     'source_input' gives the names of those inputs.
       *&#64;&#64;
       * </pre>
       *
       * <code>repeated string source_input = 3;</code>
       * @return The count of sourceInput.
       */
      public int getSourceInputCount() {
        return sourceInput_.size();
      }
      /**
       * <pre>
       *&#64;&#64;  .. cpp:var:: string source_input (repeated)
       *&#64;&#64;
       *&#64;&#64;     The backend derives each batch output from one or more inputs.
       *&#64;&#64;     'source_input' gives the names of those inputs.
       *&#64;&#64;
       * </pre>
       *
       * <code>repeated string source_input = 3;</code>
       * @param index The index of the element to return.
       * @return The sourceInput at the given index.
       */
      public java.lang.String getSourceInput(int index) {
        return sourceInput_.get(index);
      }
      /**
       * <pre>
       *&#64;&#64;  .. cpp:var:: string source_input (repeated)
       *&#64;&#64;
       *&#64;&#64;     The backend derives each batch output from one or more inputs.
       *&#64;&#64;     'source_input' gives the names of those inputs.
       *&#64;&#64;
       * </pre>
       *
       * <code>repeated string source_input = 3;</code>
       * @param index The index of the value to return.
       * @return The bytes of the sourceInput at the given index.
       */
      public com.google.protobuf.ByteString
          getSourceInputBytes(int index) {
        return sourceInput_.getByteString(index);
      }
      /**
       * <pre>
       *&#64;&#64;  .. cpp:var:: string source_input (repeated)
       *&#64;&#64;
       *&#64;&#64;     The backend derives each batch output from one or more inputs.
       *&#64;&#64;     'source_input' gives the names of those inputs.
       *&#64;&#64;
       * </pre>
       *
       * <code>repeated string source_input = 3;</code>
       * @param index The index to set the value at.
       * @param value The sourceInput to set.
       * @return This builder for chaining.
       */
      public Builder setSourceInput(
          int index, java.lang.String value) {
        if (value == null) {
    throw new NullPointerException();
  }
  ensureSourceInputIsMutable();
        sourceInput_.set(index, value);
        onChanged();
        return this;
      }
      /**
       * <pre>
       *&#64;&#64;  .. cpp:var:: string source_input (repeated)
       *&#64;&#64;
       *&#64;&#64;     The backend derives each batch output from one or more inputs.
       *&#64;&#64;     'source_input' gives the names of those inputs.
       *&#64;&#64;
       * </pre>
       *
       * <code>repeated string source_input = 3;</code>
       * @param value The sourceInput to add.
       * @return This builder for chaining.
       */
      public Builder addSourceInput(
          java.lang.String value) {
        if (value == null) {
    throw new NullPointerException();
  }
  ensureSourceInputIsMutable();
        sourceInput_.add(value);
        onChanged();
        return this;
      }
      /**
       * <pre>
       *&#64;&#64;  .. cpp:var:: string source_input (repeated)
       *&#64;&#64;
       *&#64;&#64;     The backend derives each batch output from one or more inputs.
       *&#64;&#64;     'source_input' gives the names of those inputs.
       *&#64;&#64;
       * </pre>
       *
       * <code>repeated string source_input = 3;</code>
       * @param values The sourceInput to add.
       * @return This builder for chaining.
       */
      public Builder addAllSourceInput(
          java.lang.Iterable<java.lang.String> values) {
        ensureSourceInputIsMutable();
        com.google.protobuf.AbstractMessageLite.Builder.addAll(
            values, sourceInput_);
        onChanged();
        return this;
      }
      /**
       * <pre>
       *&#64;&#64;  .. cpp:var:: string source_input (repeated)
       *&#64;&#64;
       *&#64;&#64;     The backend derives each batch output from one or more inputs.
       *&#64;&#64;     'source_input' gives the names of those inputs.
       *&#64;&#64;
       * </pre>
       *
       * <code>repeated string source_input = 3;</code>
       * @return This builder for chaining.
       */
      public Builder clearSourceInput() {
        sourceInput_ = com.google.protobuf.LazyStringArrayList.EMPTY;
        bitField0_ = (bitField0_ & ~0x00000002);
        onChanged();
        return this;
      }
      /**
       * <pre>
       *&#64;&#64;  .. cpp:var:: string source_input (repeated)
       *&#64;&#64;
       *&#64;&#64;     The backend derives each batch output from one or more inputs.
       *&#64;&#64;     'source_input' gives the names of those inputs.
       *&#64;&#64;
       * </pre>
       *
       * <code>repeated string source_input = 3;</code>
       * @param value The bytes of the sourceInput to add.
       * @return This builder for chaining.
       */
      public Builder addSourceInputBytes(
          com.google.protobuf.ByteString value) {
        if (value == null) {
    throw new NullPointerException();
  }
  checkByteStringIsUtf8(value);
        ensureSourceInputIsMutable();
        sourceInput_.add(value);
        onChanged();
        return this;
      }
      @java.lang.Override
      public final Builder setUnknownFields(
          final com.google.protobuf.UnknownFieldSet unknownFields) {
        return super.setUnknownFields(unknownFields);
      }

      @java.lang.Override
      public final Builder mergeUnknownFields(
          final com.google.protobuf.UnknownFieldSet unknownFields) {
        return super.mergeUnknownFields(unknownFields);
      }


      // @@protoc_insertion_point(builder_scope:inference.BatchOutput)
    }

    // @@protoc_insertion_point(class_scope:inference.BatchOutput)
    private static final org.apache.submarine.server.api.proto.TritonModelConfig.BatchOutput DEFAULT_INSTANCE;
    static {
      DEFAULT_INSTANCE = new org.apache.submarine.server.api.proto.TritonModelConfig.BatchOutput();
    }

    public static org.apache.submarine.server.api.proto.TritonModelConfig.BatchOutput getDefaultInstance() {
      return DEFAULT_INSTANCE;
    }

    private static final com.google.protobuf.Parser<BatchOutput>
        PARSER = new com.google.protobuf.AbstractParser<BatchOutput>() {
      @java.lang.Override
      public BatchOutput parsePartialFrom(
          com.google.protobuf.CodedInputStream input,
          com.google.protobuf.ExtensionRegistryLite extensionRegistry)
          throws com.google.protobuf.InvalidProtocolBufferException {
        return new BatchOutput(input, extensionRegistry);
      }
    };

    public static com.google.protobuf.Parser<BatchOutput> parser() {
      return PARSER;
    }

    @java.lang.Override
    public com.google.protobuf.Parser<BatchOutput> getParserForType() {
      return PARSER;
    }

    @java.lang.Override
    public org.apache.submarine.server.api.proto.TritonModelConfig.BatchOutput getDefaultInstanceForType() {
      return DEFAULT_INSTANCE;
    }

  }

  public interface ModelVersionPolicyOrBuilder extends
      // @@protoc_insertion_point(interface_extends:inference.ModelVersionPolicy)
      com.google.protobuf.MessageOrBuilder {

    /**
     * <pre>
     *&#64;&#64;    .. cpp:var:: Latest latest
     *&#64;&#64;
     *&#64;&#64;       Serve only latest version(s) of the model.
     *&#64;&#64;
     * </pre>
     *
     * <code>.inference.ModelVersionPolicy.Latest latest = 1;</code>
     * @return Whether the latest field is set.
     */
    boolean hasLatest();
    /**
     * <pre>
     *&#64;&#64;    .. cpp:var:: Latest latest
     *&#64;&#64;
     *&#64;&#64;       Serve only latest version(s) of the model.
     *&#64;&#64;
     * </pre>
     *
     * <code>.inference.ModelVersionPolicy.Latest latest = 1;</code>
     * @return The latest.
     */
    org.apache.submarine.server.api.proto.TritonModelConfig.ModelVersionPolicy.Latest getLatest();
    /**
     * <pre>
     *&#64;&#64;    .. cpp:var:: Latest latest
     *&#64;&#64;
     *&#64;&#64;       Serve only latest version(s) of the model.
     *&#64;&#64;
     * </pre>
     *
     * <code>.inference.ModelVersionPolicy.Latest latest = 1;</code>
     */
    org.apache.submarine.server.api.proto.TritonModelConfig.ModelVersionPolicy.LatestOrBuilder getLatestOrBuilder();

    /**
     * <pre>
     *&#64;&#64;    .. cpp:var:: All all
     *&#64;&#64;
     *&#64;&#64;       Serve all versions of the model.
     *&#64;&#64;
     * </pre>
     *
     * <code>.inference.ModelVersionPolicy.All all = 2;</code>
     * @return Whether the all field is set.
     */
    boolean hasAll();
    /**
     * <pre>
     *&#64;&#64;    .. cpp:var:: All all
     *&#64;&#64;
     *&#64;&#64;       Serve all versions of the model.
     *&#64;&#64;
     * </pre>
     *
     * <code>.inference.ModelVersionPolicy.All all = 2;</code>
     * @return The all.
     */
    org.apache.submarine.server.api.proto.TritonModelConfig.ModelVersionPolicy.All getAll();
    /**
     * <pre>
     *&#64;&#64;    .. cpp:var:: All all
     *&#64;&#64;
     *&#64;&#64;       Serve all versions of the model.
     *&#64;&#64;
     * </pre>
     *
     * <code>.inference.ModelVersionPolicy.All all = 2;</code>
     */
    org.apache.submarine.server.api.proto.TritonModelConfig.ModelVersionPolicy.AllOrBuilder getAllOrBuilder();

    /**
     * <pre>
     *&#64;&#64;    .. cpp:var:: Specific specific
     *&#64;&#64;
     *&#64;&#64;       Serve only specific version(s) of the model.
     *&#64;&#64;
     * </pre>
     *
     * <code>.inference.ModelVersionPolicy.Specific specific = 3;</code>
     * @return Whether the specific field is set.
     */
    boolean hasSpecific();
    /**
     * <pre>
     *&#64;&#64;    .. cpp:var:: Specific specific
     *&#64;&#64;
     *&#64;&#64;       Serve only specific version(s) of the model.
     *&#64;&#64;
     * </pre>
     *
     * <code>.inference.ModelVersionPolicy.Specific specific = 3;</code>
     * @return The specific.
     */
    org.apache.submarine.server.api.proto.TritonModelConfig.ModelVersionPolicy.Specific getSpecific();
    /**
     * <pre>
     *&#64;&#64;    .. cpp:var:: Specific specific
     *&#64;&#64;
     *&#64;&#64;       Serve only specific version(s) of the model.
     *&#64;&#64;
     * </pre>
     *
     * <code>.inference.ModelVersionPolicy.Specific specific = 3;</code>
     */
    org.apache.submarine.server.api.proto.TritonModelConfig.ModelVersionPolicy.SpecificOrBuilder getSpecificOrBuilder();

    public org.apache.submarine.server.api.proto.TritonModelConfig.ModelVersionPolicy.PolicyChoiceCase getPolicyChoiceCase();
  }
  /**
   * <pre>
   *&#64;&#64;
   *&#64;&#64;.. cpp:var:: message ModelVersionPolicy
   *&#64;&#64;
   *&#64;&#64;   Policy indicating which versions of a model should be made
   *&#64;&#64;   available by the inference server.
   *&#64;&#64;
   * </pre>
   *
   * Protobuf type {@code inference.ModelVersionPolicy}
   */
  public static final class ModelVersionPolicy extends
      com.google.protobuf.GeneratedMessageV3 implements
      // @@protoc_insertion_point(message_implements:inference.ModelVersionPolicy)
      ModelVersionPolicyOrBuilder {
  private static final long serialVersionUID = 0L;
    // Use ModelVersionPolicy.newBuilder() to construct.
    private ModelVersionPolicy(com.google.protobuf.GeneratedMessageV3.Builder<?> builder) {
      super(builder);
    }
    private ModelVersionPolicy() {
    }

    @java.lang.Override
    @SuppressWarnings({"unused"})
    protected java.lang.Object newInstance(
        UnusedPrivateParameter unused) {
      return new ModelVersionPolicy();
    }

    @java.lang.Override
    public final com.google.protobuf.UnknownFieldSet
    getUnknownFields() {
      return this.unknownFields;
    }
    private ModelVersionPolicy(
        com.google.protobuf.CodedInputStream input,
        com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws com.google.protobuf.InvalidProtocolBufferException {
      this();
      if (extensionRegistry == null) {
        throw new java.lang.NullPointerException();
      }
      com.google.protobuf.UnknownFieldSet.Builder unknownFields =
          com.google.protobuf.UnknownFieldSet.newBuilder();
      try {
        boolean done = false;
        while (!done) {
          int tag = input.readTag();
          switch (tag) {
            case 0:
              done = true;
              break;
            case 10: {
              org.apache.submarine.server.api.proto.TritonModelConfig.ModelVersionPolicy.Latest.Builder subBuilder = null;
              if (policyChoiceCase_ == 1) {
                subBuilder = ((org.apache.submarine.server.api.proto.TritonModelConfig.ModelVersionPolicy.Latest) policyChoice_).toBuilder();
              }
              policyChoice_ =
                  input.readMessage(org.apache.submarine.server.api.proto.TritonModelConfig.ModelVersionPolicy.Latest.parser(), extensionRegistry);
              if (subBuilder != null) {
                subBuilder.mergeFrom((org.apache.submarine.server.api.proto.TritonModelConfig.ModelVersionPolicy.Latest) policyChoice_);
                policyChoice_ = subBuilder.buildPartial();
              }
              policyChoiceCase_ = 1;
              break;
            }
            case 18: {
              org.apache.submarine.server.api.proto.TritonModelConfig.ModelVersionPolicy.All.Builder subBuilder = null;
              if (policyChoiceCase_ == 2) {
                subBuilder = ((org.apache.submarine.server.api.proto.TritonModelConfig.ModelVersionPolicy.All) policyChoice_).toBuilder();
              }
              policyChoice_ =
                  input.readMessage(org.apache.submarine.server.api.proto.TritonModelConfig.ModelVersionPolicy.All.parser(), extensionRegistry);
              if (subBuilder != null) {
                subBuilder.mergeFrom((org.apache.submarine.server.api.proto.TritonModelConfig.ModelVersionPolicy.All) policyChoice_);
                policyChoice_ = subBuilder.buildPartial();
              }
              policyChoiceCase_ = 2;
              break;
            }
            case 26: {
              org.apache.submarine.server.api.proto.TritonModelConfig.ModelVersionPolicy.Specific.Builder subBuilder = null;
              if (policyChoiceCase_ == 3) {
                subBuilder = ((org.apache.submarine.server.api.proto.TritonModelConfig.ModelVersionPolicy.Specific) policyChoice_).toBuilder();
              }
              policyChoice_ =
                  input.readMessage(org.apache.submarine.server.api.proto.TritonModelConfig.ModelVersionPolicy.Specific.parser(), extensionRegistry);
              if (subBuilder != null) {
                subBuilder.mergeFrom((org.apache.submarine.server.api.proto.TritonModelConfig.ModelVersionPolicy.Specific) policyChoice_);
                policyChoice_ = subBuilder.buildPartial();
              }
              policyChoiceCase_ = 3;
              break;
            }
            default: {
              if (!parseUnknownField(
                  input, unknownFields, extensionRegistry, tag)) {
                done = true;
              }
              break;
            }
          }
        }
      } catch (com.google.protobuf.InvalidProtocolBufferException e) {
        throw e.setUnfinishedMessage(this);
      } catch (java.io.IOException e) {
        throw new com.google.protobuf.InvalidProtocolBufferException(
            e).setUnfinishedMessage(this);
      } finally {
        this.unknownFields = unknownFields.build();
        makeExtensionsImmutable();
      }
    }
    public static final com.google.protobuf.Descriptors.Descriptor
        getDescriptor() {
      return org.apache.submarine.server.api.proto.TritonModelConfig.internal_static_inference_ModelVersionPolicy_descriptor;
    }

    @java.lang.Override
    protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
        internalGetFieldAccessorTable() {
      return org.apache.submarine.server.api.proto.TritonModelConfig.internal_static_inference_ModelVersionPolicy_fieldAccessorTable
          .ensureFieldAccessorsInitialized(
              org.apache.submarine.server.api.proto.TritonModelConfig.ModelVersionPolicy.class, org.apache.submarine.server.api.proto.TritonModelConfig.ModelVersionPolicy.Builder.class);
    }

    public interface LatestOrBuilder extends
        // @@protoc_insertion_point(interface_extends:inference.ModelVersionPolicy.Latest)
        com.google.protobuf.MessageOrBuilder {

      /**
       * <pre>
       *&#64;&#64;    .. cpp:var:: uint32 num_versions
       *&#64;&#64;
       *&#64;&#64;       Serve only the 'num_versions' highest-numbered versions. T
       *&#64;&#64;       The default value of 'num_versions' is 1, indicating that by
       *&#64;&#64;       default only the single highest-number version of a
       *&#64;&#64;       model will be served.
       *&#64;&#64;
       * </pre>
       *
       * <code>uint32 num_versions = 1;</code>
       * @return The numVersions.
       */
      int getNumVersions();
    }
    /**
     * <pre>
     *&#64;&#64;  .. cpp:var:: message Latest
     *&#64;&#64;
     *&#64;&#64;     Serve only the latest version(s) of a model. This is
     *&#64;&#64;     the default policy.
     *&#64;&#64;
     * </pre>
     *
     * Protobuf type {@code inference.ModelVersionPolicy.Latest}
     */
    public static final class Latest extends
        com.google.protobuf.GeneratedMessageV3 implements
        // @@protoc_insertion_point(message_implements:inference.ModelVersionPolicy.Latest)
        LatestOrBuilder {
    private static final long serialVersionUID = 0L;
      // Use Latest.newBuilder() to construct.
      private Latest(com.google.protobuf.GeneratedMessageV3.Builder<?> builder) {
        super(builder);
      }
      private Latest() {
      }

      @java.lang.Override
      @SuppressWarnings({"unused"})
      protected java.lang.Object newInstance(
          UnusedPrivateParameter unused) {
        return new Latest();
      }

      @java.lang.Override
      public final com.google.protobuf.UnknownFieldSet
      getUnknownFields() {
        return this.unknownFields;
      }
      private Latest(
          com.google.protobuf.CodedInputStream input,
          com.google.protobuf.ExtensionRegistryLite extensionRegistry)
          throws com.google.protobuf.InvalidProtocolBufferException {
        this();
        if (extensionRegistry == null) {
          throw new java.lang.NullPointerException();
        }
        com.google.protobuf.UnknownFieldSet.Builder unknownFields =
            com.google.protobuf.UnknownFieldSet.newBuilder();
        try {
          boolean done = false;
          while (!done) {
            int tag = input.readTag();
            switch (tag) {
              case 0:
                done = true;
                break;
              case 8: {

                numVersions_ = input.readUInt32();
                break;
              }
              default: {
                if (!parseUnknownField(
                    input, unknownFields, extensionRegistry, tag)) {
                  done = true;
                }
                break;
              }
            }
          }
        } catch (com.google.protobuf.InvalidProtocolBufferException e) {
          throw e.setUnfinishedMessage(this);
        } catch (java.io.IOException e) {
          throw new com.google.protobuf.InvalidProtocolBufferException(
              e).setUnfinishedMessage(this);
        } finally {
          this.unknownFields = unknownFields.build();
          makeExtensionsImmutable();
        }
      }
      public static final com.google.protobuf.Descriptors.Descriptor
          getDescriptor() {
        return org.apache.submarine.server.api.proto.TritonModelConfig.internal_static_inference_ModelVersionPolicy_Latest_descriptor;
      }

      @java.lang.Override
      protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
          internalGetFieldAccessorTable() {
        return org.apache.submarine.server.api.proto.TritonModelConfig.internal_static_inference_ModelVersionPolicy_Latest_fieldAccessorTable
            .ensureFieldAccessorsInitialized(
                org.apache.submarine.server.api.proto.TritonModelConfig.ModelVersionPolicy.Latest.class, org.apache.submarine.server.api.proto.TritonModelConfig.ModelVersionPolicy.Latest.Builder.class);
      }

      public static final int NUM_VERSIONS_FIELD_NUMBER = 1;
      private int numVersions_;
      /**
       * <pre>
       *&#64;&#64;    .. cpp:var:: uint32 num_versions
       *&#64;&#64;
       *&#64;&#64;       Serve only the 'num_versions' highest-numbered versions. T
       *&#64;&#64;       The default value of 'num_versions' is 1, indicating that by
       *&#64;&#64;       default only the single highest-number version of a
       *&#64;&#64;       model will be served.
       *&#64;&#64;
       * </pre>
       *
       * <code>uint32 num_versions = 1;</code>
       * @return The numVersions.
       */
      @java.lang.Override
      public int getNumVersions() {
        return numVersions_;
      }

      private byte memoizedIsInitialized = -1;
      @java.lang.Override
      public final boolean isInitialized() {
        byte isInitialized = memoizedIsInitialized;
        if (isInitialized == 1) return true;
        if (isInitialized == 0) return false;

        memoizedIsInitialized = 1;
        return true;
      }

      @java.lang.Override
      public void writeTo(com.google.protobuf.CodedOutputStream output)
                          throws java.io.IOException {
        if (numVersions_ != 0) {
          output.writeUInt32(1, numVersions_);
        }
        unknownFields.writeTo(output);
      }

      @java.lang.Override
      public int getSerializedSize() {
        int size = memoizedSize;
        if (size != -1) return size;

        size = 0;
        if (numVersions_ != 0) {
          size += com.google.protobuf.CodedOutputStream
            .computeUInt32Size(1, numVersions_);
        }
        size += unknownFields.getSerializedSize();
        memoizedSize = size;
        return size;
      }

      @java.lang.Override
      public boolean equals(final java.lang.Object obj) {
        if (obj == this) {
         return true;
        }
        if (!(obj instanceof org.apache.submarine.server.api.proto.TritonModelConfig.ModelVersionPolicy.Latest)) {
          return super.equals(obj);
        }
        org.apache.submarine.server.api.proto.TritonModelConfig.ModelVersionPolicy.Latest other = (org.apache.submarine.server.api.proto.TritonModelConfig.ModelVersionPolicy.Latest) obj;

        if (getNumVersions()
            != other.getNumVersions()) return false;
        if (!unknownFields.equals(other.unknownFields)) return false;
        return true;
      }

      @java.lang.Override
      public int hashCode() {
        if (memoizedHashCode != 0) {
          return memoizedHashCode;
        }
        int hash = 41;
        hash = (19 * hash) + getDescriptor().hashCode();
        hash = (37 * hash) + NUM_VERSIONS_FIELD_NUMBER;
        hash = (53 * hash) + getNumVersions();
        hash = (29 * hash) + unknownFields.hashCode();
        memoizedHashCode = hash;
        return hash;
      }

      public static org.apache.submarine.server.api.proto.TritonModelConfig.ModelVersionPolicy.Latest parseFrom(
          java.nio.ByteBuffer data)
          throws com.google.protobuf.InvalidProtocolBufferException {
        return PARSER.parseFrom(data);
      }
      public static org.apache.submarine.server.api.proto.TritonModelConfig.ModelVersionPolicy.Latest parseFrom(
          java.nio.ByteBuffer data,
          com.google.protobuf.ExtensionRegistryLite extensionRegistry)
          throws com.google.protobuf.InvalidProtocolBufferException {
        return PARSER.parseFrom(data, extensionRegistry);
      }
      public static org.apache.submarine.server.api.proto.TritonModelConfig.ModelVersionPolicy.Latest parseFrom(
          com.google.protobuf.ByteString data)
          throws com.google.protobuf.InvalidProtocolBufferException {
        return PARSER.parseFrom(data);
      }
      public static org.apache.submarine.server.api.proto.TritonModelConfig.ModelVersionPolicy.Latest parseFrom(
          com.google.protobuf.ByteString data,
          com.google.protobuf.ExtensionRegistryLite extensionRegistry)
          throws com.google.protobuf.InvalidProtocolBufferException {
        return PARSER.parseFrom(data, extensionRegistry);
      }
      public static org.apache.submarine.server.api.proto.TritonModelConfig.ModelVersionPolicy.Latest parseFrom(byte[] data)
          throws com.google.protobuf.InvalidProtocolBufferException {
        return PARSER.parseFrom(data);
      }
      public static org.apache.submarine.server.api.proto.TritonModelConfig.ModelVersionPolicy.Latest parseFrom(
          byte[] data,
          com.google.protobuf.ExtensionRegistryLite extensionRegistry)
          throws com.google.protobuf.InvalidProtocolBufferException {
        return PARSER.parseFrom(data, extensionRegistry);
      }
      public static org.apache.submarine.server.api.proto.TritonModelConfig.ModelVersionPolicy.Latest parseFrom(java.io.InputStream input)
          throws java.io.IOException {
        return com.google.protobuf.GeneratedMessageV3
            .parseWithIOException(PARSER, input);
      }
      public static org.apache.submarine.server.api.proto.TritonModelConfig.ModelVersionPolicy.Latest parseFrom(
          java.io.InputStream input,
          com.google.protobuf.ExtensionRegistryLite extensionRegistry)
          throws java.io.IOException {
        return com.google.protobuf.GeneratedMessageV3
            .parseWithIOException(PARSER, input, extensionRegistry);
      }
      public static org.apache.submarine.server.api.proto.TritonModelConfig.ModelVersionPolicy.Latest parseDelimitedFrom(java.io.InputStream input)
          throws java.io.IOException {
        return com.google.protobuf.GeneratedMessageV3
            .parseDelimitedWithIOException(PARSER, input);
      }
      public static org.apache.submarine.server.api.proto.TritonModelConfig.ModelVersionPolicy.Latest parseDelimitedFrom(
          java.io.InputStream input,
          com.google.protobuf.ExtensionRegistryLite extensionRegistry)
          throws java.io.IOException {
        return com.google.protobuf.GeneratedMessageV3
            .parseDelimitedWithIOException(PARSER, input, extensionRegistry);
      }
      public static org.apache.submarine.server.api.proto.TritonModelConfig.ModelVersionPolicy.Latest parseFrom(
          com.google.protobuf.CodedInputStream input)
          throws java.io.IOException {
        return com.google.protobuf.GeneratedMessageV3
            .parseWithIOException(PARSER, input);
      }
      public static org.apache.submarine.server.api.proto.TritonModelConfig.ModelVersionPolicy.Latest parseFrom(
          com.google.protobuf.CodedInputStream input,
          com.google.protobuf.ExtensionRegistryLite extensionRegistry)
          throws java.io.IOException {
        return com.google.protobuf.GeneratedMessageV3
            .parseWithIOException(PARSER, input, extensionRegistry);
      }

      @java.lang.Override
      public Builder newBuilderForType() { return newBuilder(); }
      public static Builder newBuilder() {
        return DEFAULT_INSTANCE.toBuilder();
      }
      public static Builder newBuilder(org.apache.submarine.server.api.proto.TritonModelConfig.ModelVersionPolicy.Latest prototype) {
        return DEFAULT_INSTANCE.toBuilder().mergeFrom(prototype);
      }
      @java.lang.Override
      public Builder toBuilder() {
        return this == DEFAULT_INSTANCE
            ? new Builder() : new Builder().mergeFrom(this);
      }

      @java.lang.Override
      protected Builder newBuilderForType(
          com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
        Builder builder = new Builder(parent);
        return builder;
      }
      /**
       * <pre>
       *&#64;&#64;  .. cpp:var:: message Latest
       *&#64;&#64;
       *&#64;&#64;     Serve only the latest version(s) of a model. This is
       *&#64;&#64;     the default policy.
       *&#64;&#64;
       * </pre>
       *
       * Protobuf type {@code inference.ModelVersionPolicy.Latest}
       */
      public static final class Builder extends
          com.google.protobuf.GeneratedMessageV3.Builder<Builder> implements
          // @@protoc_insertion_point(builder_implements:inference.ModelVersionPolicy.Latest)
          org.apache.submarine.server.api.proto.TritonModelConfig.ModelVersionPolicy.LatestOrBuilder {
        public static final com.google.protobuf.Descriptors.Descriptor
            getDescriptor() {
          return org.apache.submarine.server.api.proto.TritonModelConfig.internal_static_inference_ModelVersionPolicy_Latest_descriptor;
        }

        @java.lang.Override
        protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
            internalGetFieldAccessorTable() {
          return org.apache.submarine.server.api.proto.TritonModelConfig.internal_static_inference_ModelVersionPolicy_Latest_fieldAccessorTable
              .ensureFieldAccessorsInitialized(
                  org.apache.submarine.server.api.proto.TritonModelConfig.ModelVersionPolicy.Latest.class, org.apache.submarine.server.api.proto.TritonModelConfig.ModelVersionPolicy.Latest.Builder.class);
        }

        // Construct using org.apache.submarine.server.api.proto.TritonModelConfig.ModelVersionPolicy.Latest.newBuilder()
        private Builder() {
          maybeForceBuilderInitialization();
        }

        private Builder(
            com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
          super(parent);
          maybeForceBuilderInitialization();
        }
        private void maybeForceBuilderInitialization() {
          if (com.google.protobuf.GeneratedMessageV3
                  .alwaysUseFieldBuilders) {
          }
        }
        @java.lang.Override
        public Builder clear() {
          super.clear();
          numVersions_ = 0;

          return this;
        }

        @java.lang.Override
        public com.google.protobuf.Descriptors.Descriptor
            getDescriptorForType() {
          return org.apache.submarine.server.api.proto.TritonModelConfig.internal_static_inference_ModelVersionPolicy_Latest_descriptor;
        }

        @java.lang.Override
        public org.apache.submarine.server.api.proto.TritonModelConfig.ModelVersionPolicy.Latest getDefaultInstanceForType() {
          return org.apache.submarine.server.api.proto.TritonModelConfig.ModelVersionPolicy.Latest.getDefaultInstance();
        }

        @java.lang.Override
        public org.apache.submarine.server.api.proto.TritonModelConfig.ModelVersionPolicy.Latest build() {
          org.apache.submarine.server.api.proto.TritonModelConfig.ModelVersionPolicy.Latest result = buildPartial();
          if (!result.isInitialized()) {
            throw newUninitializedMessageException(result);
          }
          return result;
        }

        @java.lang.Override
        public org.apache.submarine.server.api.proto.TritonModelConfig.ModelVersionPolicy.Latest buildPartial() {
          org.apache.submarine.server.api.proto.TritonModelConfig.ModelVersionPolicy.Latest result = new org.apache.submarine.server.api.proto.TritonModelConfig.ModelVersionPolicy.Latest(this);
          result.numVersions_ = numVersions_;
          onBuilt();
          return result;
        }

        @java.lang.Override
        public Builder clone() {
          return super.clone();
        }
        @java.lang.Override
        public Builder setField(
            com.google.protobuf.Descriptors.FieldDescriptor field,
            java.lang.Object value) {
          return super.setField(field, value);
        }
        @java.lang.Override
        public Builder clearField(
            com.google.protobuf.Descriptors.FieldDescriptor field) {
          return super.clearField(field);
        }
        @java.lang.Override
        public Builder clearOneof(
            com.google.protobuf.Descriptors.OneofDescriptor oneof) {
          return super.clearOneof(oneof);
        }
        @java.lang.Override
        public Builder setRepeatedField(
            com.google.protobuf.Descriptors.FieldDescriptor field,
            int index, java.lang.Object value) {
          return super.setRepeatedField(field, index, value);
        }
        @java.lang.Override
        public Builder addRepeatedField(
            com.google.protobuf.Descriptors.FieldDescriptor field,
            java.lang.Object value) {
          return super.addRepeatedField(field, value);
        }
        @java.lang.Override
        public Builder mergeFrom(com.google.protobuf.Message other) {
          if (other instanceof org.apache.submarine.server.api.proto.TritonModelConfig.ModelVersionPolicy.Latest) {
            return mergeFrom((org.apache.submarine.server.api.proto.TritonModelConfig.ModelVersionPolicy.Latest)other);
          } else {
            super.mergeFrom(other);
            return this;
          }
        }

        public Builder mergeFrom(org.apache.submarine.server.api.proto.TritonModelConfig.ModelVersionPolicy.Latest other) {
          if (other == org.apache.submarine.server.api.proto.TritonModelConfig.ModelVersionPolicy.Latest.getDefaultInstance()) return this;
          if (other.getNumVersions() != 0) {
            setNumVersions(other.getNumVersions());
          }
          this.mergeUnknownFields(other.unknownFields);
          onChanged();
          return this;
        }

        @java.lang.Override
        public final boolean isInitialized() {
          return true;
        }

        @java.lang.Override
        public Builder mergeFrom(
            com.google.protobuf.CodedInputStream input,
            com.google.protobuf.ExtensionRegistryLite extensionRegistry)
            throws java.io.IOException {
          org.apache.submarine.server.api.proto.TritonModelConfig.ModelVersionPolicy.Latest parsedMessage = null;
          try {
            parsedMessage = PARSER.parsePartialFrom(input, extensionRegistry);
          } catch (com.google.protobuf.InvalidProtocolBufferException e) {
            parsedMessage = (org.apache.submarine.server.api.proto.TritonModelConfig.ModelVersionPolicy.Latest) e.getUnfinishedMessage();
            throw e.unwrapIOException();
          } finally {
            if (parsedMessage != null) {
              mergeFrom(parsedMessage);
            }
          }
          return this;
        }

        private int numVersions_ ;
        /**
         * <pre>
         *&#64;&#64;    .. cpp:var:: uint32 num_versions
         *&#64;&#64;
         *&#64;&#64;       Serve only the 'num_versions' highest-numbered versions. T
         *&#64;&#64;       The default value of 'num_versions' is 1, indicating that by
         *&#64;&#64;       default only the single highest-number version of a
         *&#64;&#64;       model will be served.
         *&#64;&#64;
         * </pre>
         *
         * <code>uint32 num_versions = 1;</code>
         * @return The numVersions.
         */
        @java.lang.Override
        public int getNumVersions() {
          return numVersions_;
        }
        /**
         * <pre>
         *&#64;&#64;    .. cpp:var:: uint32 num_versions
         *&#64;&#64;
         *&#64;&#64;       Serve only the 'num_versions' highest-numbered versions. T
         *&#64;&#64;       The default value of 'num_versions' is 1, indicating that by
         *&#64;&#64;       default only the single highest-number version of a
         *&#64;&#64;       model will be served.
         *&#64;&#64;
         * </pre>
         *
         * <code>uint32 num_versions = 1;</code>
         * @param value The numVersions to set.
         * @return This builder for chaining.
         */
        public Builder setNumVersions(int value) {
          
          numVersions_ = value;
          onChanged();
          return this;
        }
        /**
         * <pre>
         *&#64;&#64;    .. cpp:var:: uint32 num_versions
         *&#64;&#64;
         *&#64;&#64;       Serve only the 'num_versions' highest-numbered versions. T
         *&#64;&#64;       The default value of 'num_versions' is 1, indicating that by
         *&#64;&#64;       default only the single highest-number version of a
         *&#64;&#64;       model will be served.
         *&#64;&#64;
         * </pre>
         *
         * <code>uint32 num_versions = 1;</code>
         * @return This builder for chaining.
         */
        public Builder clearNumVersions() {
          
          numVersions_ = 0;
          onChanged();
          return this;
        }
        @java.lang.Override
        public final Builder setUnknownFields(
            final com.google.protobuf.UnknownFieldSet unknownFields) {
          return super.setUnknownFields(unknownFields);
        }

        @java.lang.Override
        public final Builder mergeUnknownFields(
            final com.google.protobuf.UnknownFieldSet unknownFields) {
          return super.mergeUnknownFields(unknownFields);
        }


        // @@protoc_insertion_point(builder_scope:inference.ModelVersionPolicy.Latest)
      }

      // @@protoc_insertion_point(class_scope:inference.ModelVersionPolicy.Latest)
      private static final org.apache.submarine.server.api.proto.TritonModelConfig.ModelVersionPolicy.Latest DEFAULT_INSTANCE;
      static {
        DEFAULT_INSTANCE = new org.apache.submarine.server.api.proto.TritonModelConfig.ModelVersionPolicy.Latest();
      }

      public static org.apache.submarine.server.api.proto.TritonModelConfig.ModelVersionPolicy.Latest getDefaultInstance() {
        return DEFAULT_INSTANCE;
      }

      private static final com.google.protobuf.Parser<Latest>
          PARSER = new com.google.protobuf.AbstractParser<Latest>() {
        @java.lang.Override
        public Latest parsePartialFrom(
            com.google.protobuf.CodedInputStream input,
            com.google.protobuf.ExtensionRegistryLite extensionRegistry)
            throws com.google.protobuf.InvalidProtocolBufferException {
          return new Latest(input, extensionRegistry);
        }
      };

      public static com.google.protobuf.Parser<Latest> parser() {
        return PARSER;
      }

      @java.lang.Override
      public com.google.protobuf.Parser<Latest> getParserForType() {
        return PARSER;
      }

      @java.lang.Override
      public org.apache.submarine.server.api.proto.TritonModelConfig.ModelVersionPolicy.Latest getDefaultInstanceForType() {
        return DEFAULT_INSTANCE;
      }

    }

    public interface AllOrBuilder extends
        // @@protoc_insertion_point(interface_extends:inference.ModelVersionPolicy.All)
        com.google.protobuf.MessageOrBuilder {
    }
    /**
     * <pre>
     *&#64;&#64;  .. cpp:var:: message All
     *&#64;&#64;
     *&#64;&#64;     Serve all versions of the model.
     *&#64;&#64;
     * </pre>
     *
     * Protobuf type {@code inference.ModelVersionPolicy.All}
     */
    public static final class All extends
        com.google.protobuf.GeneratedMessageV3 implements
        // @@protoc_insertion_point(message_implements:inference.ModelVersionPolicy.All)
        AllOrBuilder {
    private static final long serialVersionUID = 0L;
      // Use All.newBuilder() to construct.
      private All(com.google.protobuf.GeneratedMessageV3.Builder<?> builder) {
        super(builder);
      }
      private All() {
      }

      @java.lang.Override
      @SuppressWarnings({"unused"})
      protected java.lang.Object newInstance(
          UnusedPrivateParameter unused) {
        return new All();
      }

      @java.lang.Override
      public final com.google.protobuf.UnknownFieldSet
      getUnknownFields() {
        return this.unknownFields;
      }
      private All(
          com.google.protobuf.CodedInputStream input,
          com.google.protobuf.ExtensionRegistryLite extensionRegistry)
          throws com.google.protobuf.InvalidProtocolBufferException {
        this();
        if (extensionRegistry == null) {
          throw new java.lang.NullPointerException();
        }
        com.google.protobuf.UnknownFieldSet.Builder unknownFields =
            com.google.protobuf.UnknownFieldSet.newBuilder();
        try {
          boolean done = false;
          while (!done) {
            int tag = input.readTag();
            switch (tag) {
              case 0:
                done = true;
                break;
              default: {
                if (!parseUnknownField(
                    input, unknownFields, extensionRegistry, tag)) {
                  done = true;
                }
                break;
              }
            }
          }
        } catch (com.google.protobuf.InvalidProtocolBufferException e) {
          throw e.setUnfinishedMessage(this);
        } catch (java.io.IOException e) {
          throw new com.google.protobuf.InvalidProtocolBufferException(
              e).setUnfinishedMessage(this);
        } finally {
          this.unknownFields = unknownFields.build();
          makeExtensionsImmutable();
        }
      }
      public static final com.google.protobuf.Descriptors.Descriptor
          getDescriptor() {
        return org.apache.submarine.server.api.proto.TritonModelConfig.internal_static_inference_ModelVersionPolicy_All_descriptor;
      }

      @java.lang.Override
      protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
          internalGetFieldAccessorTable() {
        return org.apache.submarine.server.api.proto.TritonModelConfig.internal_static_inference_ModelVersionPolicy_All_fieldAccessorTable
            .ensureFieldAccessorsInitialized(
                org.apache.submarine.server.api.proto.TritonModelConfig.ModelVersionPolicy.All.class, org.apache.submarine.server.api.proto.TritonModelConfig.ModelVersionPolicy.All.Builder.class);
      }

      private byte memoizedIsInitialized = -1;
      @java.lang.Override
      public final boolean isInitialized() {
        byte isInitialized = memoizedIsInitialized;
        if (isInitialized == 1) return true;
        if (isInitialized == 0) return false;

        memoizedIsInitialized = 1;
        return true;
      }

      @java.lang.Override
      public void writeTo(com.google.protobuf.CodedOutputStream output)
                          throws java.io.IOException {
        unknownFields.writeTo(output);
      }

      @java.lang.Override
      public int getSerializedSize() {
        int size = memoizedSize;
        if (size != -1) return size;

        size = 0;
        size += unknownFields.getSerializedSize();
        memoizedSize = size;
        return size;
      }

      @java.lang.Override
      public boolean equals(final java.lang.Object obj) {
        if (obj == this) {
         return true;
        }
        if (!(obj instanceof org.apache.submarine.server.api.proto.TritonModelConfig.ModelVersionPolicy.All)) {
          return super.equals(obj);
        }
        org.apache.submarine.server.api.proto.TritonModelConfig.ModelVersionPolicy.All other = (org.apache.submarine.server.api.proto.TritonModelConfig.ModelVersionPolicy.All) obj;

        if (!unknownFields.equals(other.unknownFields)) return false;
        return true;
      }

      @java.lang.Override
      public int hashCode() {
        if (memoizedHashCode != 0) {
          return memoizedHashCode;
        }
        int hash = 41;
        hash = (19 * hash) + getDescriptor().hashCode();
        hash = (29 * hash) + unknownFields.hashCode();
        memoizedHashCode = hash;
        return hash;
      }

      public static org.apache.submarine.server.api.proto.TritonModelConfig.ModelVersionPolicy.All parseFrom(
          java.nio.ByteBuffer data)
          throws com.google.protobuf.InvalidProtocolBufferException {
        return PARSER.parseFrom(data);
      }
      public static org.apache.submarine.server.api.proto.TritonModelConfig.ModelVersionPolicy.All parseFrom(
          java.nio.ByteBuffer data,
          com.google.protobuf.ExtensionRegistryLite extensionRegistry)
          throws com.google.protobuf.InvalidProtocolBufferException {
        return PARSER.parseFrom(data, extensionRegistry);
      }
      public static org.apache.submarine.server.api.proto.TritonModelConfig.ModelVersionPolicy.All parseFrom(
          com.google.protobuf.ByteString data)
          throws com.google.protobuf.InvalidProtocolBufferException {
        return PARSER.parseFrom(data);
      }
      public static org.apache.submarine.server.api.proto.TritonModelConfig.ModelVersionPolicy.All parseFrom(
          com.google.protobuf.ByteString data,
          com.google.protobuf.ExtensionRegistryLite extensionRegistry)
          throws com.google.protobuf.InvalidProtocolBufferException {
        return PARSER.parseFrom(data, extensionRegistry);
      }
      public static org.apache.submarine.server.api.proto.TritonModelConfig.ModelVersionPolicy.All parseFrom(byte[] data)
          throws com.google.protobuf.InvalidProtocolBufferException {
        return PARSER.parseFrom(data);
      }
      public static org.apache.submarine.server.api.proto.TritonModelConfig.ModelVersionPolicy.All parseFrom(
          byte[] data,
          com.google.protobuf.ExtensionRegistryLite extensionRegistry)
          throws com.google.protobuf.InvalidProtocolBufferException {
        return PARSER.parseFrom(data, extensionRegistry);
      }
      public static org.apache.submarine.server.api.proto.TritonModelConfig.ModelVersionPolicy.All parseFrom(java.io.InputStream input)
          throws java.io.IOException {
        return com.google.protobuf.GeneratedMessageV3
            .parseWithIOException(PARSER, input);
      }
      public static org.apache.submarine.server.api.proto.TritonModelConfig.ModelVersionPolicy.All parseFrom(
          java.io.InputStream input,
          com.google.protobuf.ExtensionRegistryLite extensionRegistry)
          throws java.io.IOException {
        return com.google.protobuf.GeneratedMessageV3
            .parseWithIOException(PARSER, input, extensionRegistry);
      }
      public static org.apache.submarine.server.api.proto.TritonModelConfig.ModelVersionPolicy.All parseDelimitedFrom(java.io.InputStream input)
          throws java.io.IOException {
        return com.google.protobuf.GeneratedMessageV3
            .parseDelimitedWithIOException(PARSER, input);
      }
      public static org.apache.submarine.server.api.proto.TritonModelConfig.ModelVersionPolicy.All parseDelimitedFrom(
          java.io.InputStream input,
          com.google.protobuf.ExtensionRegistryLite extensionRegistry)
          throws java.io.IOException {
        return com.google.protobuf.GeneratedMessageV3
            .parseDelimitedWithIOException(PARSER, input, extensionRegistry);
      }
      public static org.apache.submarine.server.api.proto.TritonModelConfig.ModelVersionPolicy.All parseFrom(
          com.google.protobuf.CodedInputStream input)
          throws java.io.IOException {
        return com.google.protobuf.GeneratedMessageV3
            .parseWithIOException(PARSER, input);
      }
      public static org.apache.submarine.server.api.proto.TritonModelConfig.ModelVersionPolicy.All parseFrom(
          com.google.protobuf.CodedInputStream input,
          com.google.protobuf.ExtensionRegistryLite extensionRegistry)
          throws java.io.IOException {
        return com.google.protobuf.GeneratedMessageV3
            .parseWithIOException(PARSER, input, extensionRegistry);
      }

      @java.lang.Override
      public Builder newBuilderForType() { return newBuilder(); }
      public static Builder newBuilder() {
        return DEFAULT_INSTANCE.toBuilder();
      }
      public static Builder newBuilder(org.apache.submarine.server.api.proto.TritonModelConfig.ModelVersionPolicy.All prototype) {
        return DEFAULT_INSTANCE.toBuilder().mergeFrom(prototype);
      }
      @java.lang.Override
      public Builder toBuilder() {
        return this == DEFAULT_INSTANCE
            ? new Builder() : new Builder().mergeFrom(this);
      }

      @java.lang.Override
      protected Builder newBuilderForType(
          com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
        Builder builder = new Builder(parent);
        return builder;
      }
      /**
       * <pre>
       *&#64;&#64;  .. cpp:var:: message All
       *&#64;&#64;
       *&#64;&#64;     Serve all versions of the model.
       *&#64;&#64;
       * </pre>
       *
       * Protobuf type {@code inference.ModelVersionPolicy.All}
       */
      public static final class Builder extends
          com.google.protobuf.GeneratedMessageV3.Builder<Builder> implements
          // @@protoc_insertion_point(builder_implements:inference.ModelVersionPolicy.All)
          org.apache.submarine.server.api.proto.TritonModelConfig.ModelVersionPolicy.AllOrBuilder {
        public static final com.google.protobuf.Descriptors.Descriptor
            getDescriptor() {
          return org.apache.submarine.server.api.proto.TritonModelConfig.internal_static_inference_ModelVersionPolicy_All_descriptor;
        }

        @java.lang.Override
        protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
            internalGetFieldAccessorTable() {
          return org.apache.submarine.server.api.proto.TritonModelConfig.internal_static_inference_ModelVersionPolicy_All_fieldAccessorTable
              .ensureFieldAccessorsInitialized(
                  org.apache.submarine.server.api.proto.TritonModelConfig.ModelVersionPolicy.All.class, org.apache.submarine.server.api.proto.TritonModelConfig.ModelVersionPolicy.All.Builder.class);
        }

        // Construct using org.apache.submarine.server.api.proto.TritonModelConfig.ModelVersionPolicy.All.newBuilder()
        private Builder() {
          maybeForceBuilderInitialization();
        }

        private Builder(
            com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
          super(parent);
          maybeForceBuilderInitialization();
        }
        private void maybeForceBuilderInitialization() {
          if (com.google.protobuf.GeneratedMessageV3
                  .alwaysUseFieldBuilders) {
          }
        }
        @java.lang.Override
        public Builder clear() {
          super.clear();
          return this;
        }

        @java.lang.Override
        public com.google.protobuf.Descriptors.Descriptor
            getDescriptorForType() {
          return org.apache.submarine.server.api.proto.TritonModelConfig.internal_static_inference_ModelVersionPolicy_All_descriptor;
        }

        @java.lang.Override
        public org.apache.submarine.server.api.proto.TritonModelConfig.ModelVersionPolicy.All getDefaultInstanceForType() {
          return org.apache.submarine.server.api.proto.TritonModelConfig.ModelVersionPolicy.All.getDefaultInstance();
        }

        @java.lang.Override
        public org.apache.submarine.server.api.proto.TritonModelConfig.ModelVersionPolicy.All build() {
          org.apache.submarine.server.api.proto.TritonModelConfig.ModelVersionPolicy.All result = buildPartial();
          if (!result.isInitialized()) {
            throw newUninitializedMessageException(result);
          }
          return result;
        }

        @java.lang.Override
        public org.apache.submarine.server.api.proto.TritonModelConfig.ModelVersionPolicy.All buildPartial() {
          org.apache.submarine.server.api.proto.TritonModelConfig.ModelVersionPolicy.All result = new org.apache.submarine.server.api.proto.TritonModelConfig.ModelVersionPolicy.All(this);
          onBuilt();
          return result;
        }

        @java.lang.Override
        public Builder clone() {
          return super.clone();
        }
        @java.lang.Override
        public Builder setField(
            com.google.protobuf.Descriptors.FieldDescriptor field,
            java.lang.Object value) {
          return super.setField(field, value);
        }
        @java.lang.Override
        public Builder clearField(
            com.google.protobuf.Descriptors.FieldDescriptor field) {
          return super.clearField(field);
        }
        @java.lang.Override
        public Builder clearOneof(
            com.google.protobuf.Descriptors.OneofDescriptor oneof) {
          return super.clearOneof(oneof);
        }
        @java.lang.Override
        public Builder setRepeatedField(
            com.google.protobuf.Descriptors.FieldDescriptor field,
            int index, java.lang.Object value) {
          return super.setRepeatedField(field, index, value);
        }
        @java.lang.Override
        public Builder addRepeatedField(
            com.google.protobuf.Descriptors.FieldDescriptor field,
            java.lang.Object value) {
          return super.addRepeatedField(field, value);
        }
        @java.lang.Override
        public Builder mergeFrom(com.google.protobuf.Message other) {
          if (other instanceof org.apache.submarine.server.api.proto.TritonModelConfig.ModelVersionPolicy.All) {
            return mergeFrom((org.apache.submarine.server.api.proto.TritonModelConfig.ModelVersionPolicy.All)other);
          } else {
            super.mergeFrom(other);
            return this;
          }
        }

        public Builder mergeFrom(org.apache.submarine.server.api.proto.TritonModelConfig.ModelVersionPolicy.All other) {
          if (other == org.apache.submarine.server.api.proto.TritonModelConfig.ModelVersionPolicy.All.getDefaultInstance()) return this;
          this.mergeUnknownFields(other.unknownFields);
          onChanged();
          return this;
        }

        @java.lang.Override
        public final boolean isInitialized() {
          return true;
        }

        @java.lang.Override
        public Builder mergeFrom(
            com.google.protobuf.CodedInputStream input,
            com.google.protobuf.ExtensionRegistryLite extensionRegistry)
            throws java.io.IOException {
          org.apache.submarine.server.api.proto.TritonModelConfig.ModelVersionPolicy.All parsedMessage = null;
          try {
            parsedMessage = PARSER.parsePartialFrom(input, extensionRegistry);
          } catch (com.google.protobuf.InvalidProtocolBufferException e) {
            parsedMessage = (org.apache.submarine.server.api.proto.TritonModelConfig.ModelVersionPolicy.All) e.getUnfinishedMessage();
            throw e.unwrapIOException();
          } finally {
            if (parsedMessage != null) {
              mergeFrom(parsedMessage);
            }
          }
          return this;
        }
        @java.lang.Override
        public final Builder setUnknownFields(
            final com.google.protobuf.UnknownFieldSet unknownFields) {
          return super.setUnknownFields(unknownFields);
        }

        @java.lang.Override
        public final Builder mergeUnknownFields(
            final com.google.protobuf.UnknownFieldSet unknownFields) {
          return super.mergeUnknownFields(unknownFields);
        }


        // @@protoc_insertion_point(builder_scope:inference.ModelVersionPolicy.All)
      }

      // @@protoc_insertion_point(class_scope:inference.ModelVersionPolicy.All)
      private static final org.apache.submarine.server.api.proto.TritonModelConfig.ModelVersionPolicy.All DEFAULT_INSTANCE;
      static {
        DEFAULT_INSTANCE = new org.apache.submarine.server.api.proto.TritonModelConfig.ModelVersionPolicy.All();
      }

      public static org.apache.submarine.server.api.proto.TritonModelConfig.ModelVersionPolicy.All getDefaultInstance() {
        return DEFAULT_INSTANCE;
      }

      private static final com.google.protobuf.Parser<All>
          PARSER = new com.google.protobuf.AbstractParser<All>() {
        @java.lang.Override
        public All parsePartialFrom(
            com.google.protobuf.CodedInputStream input,
            com.google.protobuf.ExtensionRegistryLite extensionRegistry)
            throws com.google.protobuf.InvalidProtocolBufferException {
          return new All(input, extensionRegistry);
        }
      };

      public static com.google.protobuf.Parser<All> parser() {
        return PARSER;
      }

      @java.lang.Override
      public com.google.protobuf.Parser<All> getParserForType() {
        return PARSER;
      }

      @java.lang.Override
      public org.apache.submarine.server.api.proto.TritonModelConfig.ModelVersionPolicy.All getDefaultInstanceForType() {
        return DEFAULT_INSTANCE;
      }

    }

    public interface SpecificOrBuilder extends
        // @@protoc_insertion_point(interface_extends:inference.ModelVersionPolicy.Specific)
        com.google.protobuf.MessageOrBuilder {

      /**
       * <pre>
       *&#64;&#64;    .. cpp:var:: int64 versions (repeated)
       *&#64;&#64;
       *&#64;&#64;       The specific versions of the model that will be served.
       *&#64;&#64;
       * </pre>
       *
       * <code>repeated int64 versions = 1;</code>
       * @return A list containing the versions.
       */
      java.util.List<java.lang.Long> getVersionsList();
      /**
       * <pre>
       *&#64;&#64;    .. cpp:var:: int64 versions (repeated)
       *&#64;&#64;
       *&#64;&#64;       The specific versions of the model that will be served.
       *&#64;&#64;
       * </pre>
       *
       * <code>repeated int64 versions = 1;</code>
       * @return The count of versions.
       */
      int getVersionsCount();
      /**
       * <pre>
       *&#64;&#64;    .. cpp:var:: int64 versions (repeated)
       *&#64;&#64;
       *&#64;&#64;       The specific versions of the model that will be served.
       *&#64;&#64;
       * </pre>
       *
       * <code>repeated int64 versions = 1;</code>
       * @param index The index of the element to return.
       * @return The versions at the given index.
       */
      long getVersions(int index);
    }
    /**
     * <pre>
     *&#64;&#64;  .. cpp:var:: message Specific
     *&#64;&#64;
     *&#64;&#64;     Serve only specific versions of the model.
     *&#64;&#64;
     * </pre>
     *
     * Protobuf type {@code inference.ModelVersionPolicy.Specific}
     */
    public static final class Specific extends
        com.google.protobuf.GeneratedMessageV3 implements
        // @@protoc_insertion_point(message_implements:inference.ModelVersionPolicy.Specific)
        SpecificOrBuilder {
    private static final long serialVersionUID = 0L;
      // Use Specific.newBuilder() to construct.
      private Specific(com.google.protobuf.GeneratedMessageV3.Builder<?> builder) {
        super(builder);
      }
      private Specific() {
        versions_ = emptyLongList();
      }

      @java.lang.Override
      @SuppressWarnings({"unused"})
      protected java.lang.Object newInstance(
          UnusedPrivateParameter unused) {
        return new Specific();
      }

      @java.lang.Override
      public final com.google.protobuf.UnknownFieldSet
      getUnknownFields() {
        return this.unknownFields;
      }
      private Specific(
          com.google.protobuf.CodedInputStream input,
          com.google.protobuf.ExtensionRegistryLite extensionRegistry)
          throws com.google.protobuf.InvalidProtocolBufferException {
        this();
        if (extensionRegistry == null) {
          throw new java.lang.NullPointerException();
        }
        int mutable_bitField0_ = 0;
        com.google.protobuf.UnknownFieldSet.Builder unknownFields =
            com.google.protobuf.UnknownFieldSet.newBuilder();
        try {
          boolean done = false;
          while (!done) {
            int tag = input.readTag();
            switch (tag) {
              case 0:
                done = true;
                break;
              case 8: {
                if (!((mutable_bitField0_ & 0x00000001) != 0)) {
                  versions_ = newLongList();
                  mutable_bitField0_ |= 0x00000001;
                }
                versions_.addLong(input.readInt64());
                break;
              }
              case 10: {
                int length = input.readRawVarint32();
                int limit = input.pushLimit(length);
                if (!((mutable_bitField0_ & 0x00000001) != 0) && input.getBytesUntilLimit() > 0) {
                  versions_ = newLongList();
                  mutable_bitField0_ |= 0x00000001;
                }
                while (input.getBytesUntilLimit() > 0) {
                  versions_.addLong(input.readInt64());
                }
                input.popLimit(limit);
                break;
              }
              default: {
                if (!parseUnknownField(
                    input, unknownFields, extensionRegistry, tag)) {
                  done = true;
                }
                break;
              }
            }
          }
        } catch (com.google.protobuf.InvalidProtocolBufferException e) {
          throw e.setUnfinishedMessage(this);
        } catch (java.io.IOException e) {
          throw new com.google.protobuf.InvalidProtocolBufferException(
              e).setUnfinishedMessage(this);
        } finally {
          if (((mutable_bitField0_ & 0x00000001) != 0)) {
            versions_.makeImmutable(); // C
          }
          this.unknownFields = unknownFields.build();
          makeExtensionsImmutable();
        }
      }
      public static final com.google.protobuf.Descriptors.Descriptor
          getDescriptor() {
        return org.apache.submarine.server.api.proto.TritonModelConfig.internal_static_inference_ModelVersionPolicy_Specific_descriptor;
      }

      @java.lang.Override
      protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
          internalGetFieldAccessorTable() {
        return org.apache.submarine.server.api.proto.TritonModelConfig.internal_static_inference_ModelVersionPolicy_Specific_fieldAccessorTable
            .ensureFieldAccessorsInitialized(
                org.apache.submarine.server.api.proto.TritonModelConfig.ModelVersionPolicy.Specific.class, org.apache.submarine.server.api.proto.TritonModelConfig.ModelVersionPolicy.Specific.Builder.class);
      }

      public static final int VERSIONS_FIELD_NUMBER = 1;
      private com.google.protobuf.Internal.LongList versions_;
      /**
       * <pre>
       *&#64;&#64;    .. cpp:var:: int64 versions (repeated)
       *&#64;&#64;
       *&#64;&#64;       The specific versions of the model that will be served.
       *&#64;&#64;
       * </pre>
       *
       * <code>repeated int64 versions = 1;</code>
       * @return A list containing the versions.
       */
      @java.lang.Override
      public java.util.List<java.lang.Long>
          getVersionsList() {
        return versions_;
      }
      /**
       * <pre>
       *&#64;&#64;    .. cpp:var:: int64 versions (repeated)
       *&#64;&#64;
       *&#64;&#64;       The specific versions of the model that will be served.
       *&#64;&#64;
       * </pre>
       *
       * <code>repeated int64 versions = 1;</code>
       * @return The count of versions.
       */
      public int getVersionsCount() {
        return versions_.size();
      }
      /**
       * <pre>
       *&#64;&#64;    .. cpp:var:: int64 versions (repeated)
       *&#64;&#64;
       *&#64;&#64;       The specific versions of the model that will be served.
       *&#64;&#64;
       * </pre>
       *
       * <code>repeated int64 versions = 1;</code>
       * @param index The index of the element to return.
       * @return The versions at the given index.
       */
      public long getVersions(int index) {
        return versions_.getLong(index);
      }
      private int versionsMemoizedSerializedSize = -1;

      private byte memoizedIsInitialized = -1;
      @java.lang.Override
      public final boolean isInitialized() {
        byte isInitialized = memoizedIsInitialized;
        if (isInitialized == 1) return true;
        if (isInitialized == 0) return false;

        memoizedIsInitialized = 1;
        return true;
      }

      @java.lang.Override
      public void writeTo(com.google.protobuf.CodedOutputStream output)
                          throws java.io.IOException {
        getSerializedSize();
        if (getVersionsList().size() > 0) {
          output.writeUInt32NoTag(10);
          output.writeUInt32NoTag(versionsMemoizedSerializedSize);
        }
        for (int i = 0; i < versions_.size(); i++) {
          output.writeInt64NoTag(versions_.getLong(i));
        }
        unknownFields.writeTo(output);
      }

      @java.lang.Override
      public int getSerializedSize() {
        int size = memoizedSize;
        if (size != -1) return size;

        size = 0;
        {
          int dataSize = 0;
          for (int i = 0; i < versions_.size(); i++) {
            dataSize += com.google.protobuf.CodedOutputStream
              .computeInt64SizeNoTag(versions_.getLong(i));
          }
          size += dataSize;
          if (!getVersionsList().isEmpty()) {
            size += 1;
            size += com.google.protobuf.CodedOutputStream
                .computeInt32SizeNoTag(dataSize);
          }
          versionsMemoizedSerializedSize = dataSize;
        }
        size += unknownFields.getSerializedSize();
        memoizedSize = size;
        return size;
      }

      @java.lang.Override
      public boolean equals(final java.lang.Object obj) {
        if (obj == this) {
         return true;
        }
        if (!(obj instanceof org.apache.submarine.server.api.proto.TritonModelConfig.ModelVersionPolicy.Specific)) {
          return super.equals(obj);
        }
        org.apache.submarine.server.api.proto.TritonModelConfig.ModelVersionPolicy.Specific other = (org.apache.submarine.server.api.proto.TritonModelConfig.ModelVersionPolicy.Specific) obj;

        if (!getVersionsList()
            .equals(other.getVersionsList())) return false;
        if (!unknownFields.equals(other.unknownFields)) return false;
        return true;
      }

      @java.lang.Override
      public int hashCode() {
        if (memoizedHashCode != 0) {
          return memoizedHashCode;
        }
        int hash = 41;
        hash = (19 * hash) + getDescriptor().hashCode();
        if (getVersionsCount() > 0) {
          hash = (37 * hash) + VERSIONS_FIELD_NUMBER;
          hash = (53 * hash) + getVersionsList().hashCode();
        }
        hash = (29 * hash) + unknownFields.hashCode();
        memoizedHashCode = hash;
        return hash;
      }

      public static org.apache.submarine.server.api.proto.TritonModelConfig.ModelVersionPolicy.Specific parseFrom(
          java.nio.ByteBuffer data)
          throws com.google.protobuf.InvalidProtocolBufferException {
        return PARSER.parseFrom(data);
      }
      public static org.apache.submarine.server.api.proto.TritonModelConfig.ModelVersionPolicy.Specific parseFrom(
          java.nio.ByteBuffer data,
          com.google.protobuf.ExtensionRegistryLite extensionRegistry)
          throws com.google.protobuf.InvalidProtocolBufferException {
        return PARSER.parseFrom(data, extensionRegistry);
      }
      public static org.apache.submarine.server.api.proto.TritonModelConfig.ModelVersionPolicy.Specific parseFrom(
          com.google.protobuf.ByteString data)
          throws com.google.protobuf.InvalidProtocolBufferException {
        return PARSER.parseFrom(data);
      }
      public static org.apache.submarine.server.api.proto.TritonModelConfig.ModelVersionPolicy.Specific parseFrom(
          com.google.protobuf.ByteString data,
          com.google.protobuf.ExtensionRegistryLite extensionRegistry)
          throws com.google.protobuf.InvalidProtocolBufferException {
        return PARSER.parseFrom(data, extensionRegistry);
      }
      public static org.apache.submarine.server.api.proto.TritonModelConfig.ModelVersionPolicy.Specific parseFrom(byte[] data)
          throws com.google.protobuf.InvalidProtocolBufferException {
        return PARSER.parseFrom(data);
      }
      public static org.apache.submarine.server.api.proto.TritonModelConfig.ModelVersionPolicy.Specific parseFrom(
          byte[] data,
          com.google.protobuf.ExtensionRegistryLite extensionRegistry)
          throws com.google.protobuf.InvalidProtocolBufferException {
        return PARSER.parseFrom(data, extensionRegistry);
      }
      public static org.apache.submarine.server.api.proto.TritonModelConfig.ModelVersionPolicy.Specific parseFrom(java.io.InputStream input)
          throws java.io.IOException {
        return com.google.protobuf.GeneratedMessageV3
            .parseWithIOException(PARSER, input);
      }
      public static org.apache.submarine.server.api.proto.TritonModelConfig.ModelVersionPolicy.Specific parseFrom(
          java.io.InputStream input,
          com.google.protobuf.ExtensionRegistryLite extensionRegistry)
          throws java.io.IOException {
        return com.google.protobuf.GeneratedMessageV3
            .parseWithIOException(PARSER, input, extensionRegistry);
      }
      public static org.apache.submarine.server.api.proto.TritonModelConfig.ModelVersionPolicy.Specific parseDelimitedFrom(java.io.InputStream input)
          throws java.io.IOException {
        return com.google.protobuf.GeneratedMessageV3
            .parseDelimitedWithIOException(PARSER, input);
      }
      public static org.apache.submarine.server.api.proto.TritonModelConfig.ModelVersionPolicy.Specific parseDelimitedFrom(
          java.io.InputStream input,
          com.google.protobuf.ExtensionRegistryLite extensionRegistry)
          throws java.io.IOException {
        return com.google.protobuf.GeneratedMessageV3
            .parseDelimitedWithIOException(PARSER, input, extensionRegistry);
      }
      public static org.apache.submarine.server.api.proto.TritonModelConfig.ModelVersionPolicy.Specific parseFrom(
          com.google.protobuf.CodedInputStream input)
          throws java.io.IOException {
        return com.google.protobuf.GeneratedMessageV3
            .parseWithIOException(PARSER, input);
      }
      public static org.apache.submarine.server.api.proto.TritonModelConfig.ModelVersionPolicy.Specific parseFrom(
          com.google.protobuf.CodedInputStream input,
          com.google.protobuf.ExtensionRegistryLite extensionRegistry)
          throws java.io.IOException {
        return com.google.protobuf.GeneratedMessageV3
            .parseWithIOException(PARSER, input, extensionRegistry);
      }

      @java.lang.Override
      public Builder newBuilderForType() { return newBuilder(); }
      public static Builder newBuilder() {
        return DEFAULT_INSTANCE.toBuilder();
      }
      public static Builder newBuilder(org.apache.submarine.server.api.proto.TritonModelConfig.ModelVersionPolicy.Specific prototype) {
        return DEFAULT_INSTANCE.toBuilder().mergeFrom(prototype);
      }
      @java.lang.Override
      public Builder toBuilder() {
        return this == DEFAULT_INSTANCE
            ? new Builder() : new Builder().mergeFrom(this);
      }

      @java.lang.Override
      protected Builder newBuilderForType(
          com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
        Builder builder = new Builder(parent);
        return builder;
      }
      /**
       * <pre>
       *&#64;&#64;  .. cpp:var:: message Specific
       *&#64;&#64;
       *&#64;&#64;     Serve only specific versions of the model.
       *&#64;&#64;
       * </pre>
       *
       * Protobuf type {@code inference.ModelVersionPolicy.Specific}
       */
      public static final class Builder extends
          com.google.protobuf.GeneratedMessageV3.Builder<Builder> implements
          // @@protoc_insertion_point(builder_implements:inference.ModelVersionPolicy.Specific)
          org.apache.submarine.server.api.proto.TritonModelConfig.ModelVersionPolicy.SpecificOrBuilder {
        public static final com.google.protobuf.Descriptors.Descriptor
            getDescriptor() {
          return org.apache.submarine.server.api.proto.TritonModelConfig.internal_static_inference_ModelVersionPolicy_Specific_descriptor;
        }

        @java.lang.Override
        protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
            internalGetFieldAccessorTable() {
          return org.apache.submarine.server.api.proto.TritonModelConfig.internal_static_inference_ModelVersionPolicy_Specific_fieldAccessorTable
              .ensureFieldAccessorsInitialized(
                  org.apache.submarine.server.api.proto.TritonModelConfig.ModelVersionPolicy.Specific.class, org.apache.submarine.server.api.proto.TritonModelConfig.ModelVersionPolicy.Specific.Builder.class);
        }

        // Construct using org.apache.submarine.server.api.proto.TritonModelConfig.ModelVersionPolicy.Specific.newBuilder()
        private Builder() {
          maybeForceBuilderInitialization();
        }

        private Builder(
            com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
          super(parent);
          maybeForceBuilderInitialization();
        }
        private void maybeForceBuilderInitialization() {
          if (com.google.protobuf.GeneratedMessageV3
                  .alwaysUseFieldBuilders) {
          }
        }
        @java.lang.Override
        public Builder clear() {
          super.clear();
          versions_ = emptyLongList();
          bitField0_ = (bitField0_ & ~0x00000001);
          return this;
        }

        @java.lang.Override
        public com.google.protobuf.Descriptors.Descriptor
            getDescriptorForType() {
          return org.apache.submarine.server.api.proto.TritonModelConfig.internal_static_inference_ModelVersionPolicy_Specific_descriptor;
        }

        @java.lang.Override
        public org.apache.submarine.server.api.proto.TritonModelConfig.ModelVersionPolicy.Specific getDefaultInstanceForType() {
          return org.apache.submarine.server.api.proto.TritonModelConfig.ModelVersionPolicy.Specific.getDefaultInstance();
        }

        @java.lang.Override
        public org.apache.submarine.server.api.proto.TritonModelConfig.ModelVersionPolicy.Specific build() {
          org.apache.submarine.server.api.proto.TritonModelConfig.ModelVersionPolicy.Specific result = buildPartial();
          if (!result.isInitialized()) {
            throw newUninitializedMessageException(result);
          }
          return result;
        }

        @java.lang.Override
        public org.apache.submarine.server.api.proto.TritonModelConfig.ModelVersionPolicy.Specific buildPartial() {
          org.apache.submarine.server.api.proto.TritonModelConfig.ModelVersionPolicy.Specific result = new org.apache.submarine.server.api.proto.TritonModelConfig.ModelVersionPolicy.Specific(this);
          int from_bitField0_ = bitField0_;
          if (((bitField0_ & 0x00000001) != 0)) {
            versions_.makeImmutable();
            bitField0_ = (bitField0_ & ~0x00000001);
          }
          result.versions_ = versions_;
          onBuilt();
          return result;
        }

        @java.lang.Override
        public Builder clone() {
          return super.clone();
        }
        @java.lang.Override
        public Builder setField(
            com.google.protobuf.Descriptors.FieldDescriptor field,
            java.lang.Object value) {
          return super.setField(field, value);
        }
        @java.lang.Override
        public Builder clearField(
            com.google.protobuf.Descriptors.FieldDescriptor field) {
          return super.clearField(field);
        }
        @java.lang.Override
        public Builder clearOneof(
            com.google.protobuf.Descriptors.OneofDescriptor oneof) {
          return super.clearOneof(oneof);
        }
        @java.lang.Override
        public Builder setRepeatedField(
            com.google.protobuf.Descriptors.FieldDescriptor field,
            int index, java.lang.Object value) {
          return super.setRepeatedField(field, index, value);
        }
        @java.lang.Override
        public Builder addRepeatedField(
            com.google.protobuf.Descriptors.FieldDescriptor field,
            java.lang.Object value) {
          return super.addRepeatedField(field, value);
        }
        @java.lang.Override
        public Builder mergeFrom(com.google.protobuf.Message other) {
          if (other instanceof org.apache.submarine.server.api.proto.TritonModelConfig.ModelVersionPolicy.Specific) {
            return mergeFrom((org.apache.submarine.server.api.proto.TritonModelConfig.ModelVersionPolicy.Specific)other);
          } else {
            super.mergeFrom(other);
            return this;
          }
        }

        public Builder mergeFrom(org.apache.submarine.server.api.proto.TritonModelConfig.ModelVersionPolicy.Specific other) {
          if (other == org.apache.submarine.server.api.proto.TritonModelConfig.ModelVersionPolicy.Specific.getDefaultInstance()) return this;
          if (!other.versions_.isEmpty()) {
            if (versions_.isEmpty()) {
              versions_ = other.versions_;
              bitField0_ = (bitField0_ & ~0x00000001);
            } else {
              ensureVersionsIsMutable();
              versions_.addAll(other.versions_);
            }
            onChanged();
          }
          this.mergeUnknownFields(other.unknownFields);
          onChanged();
          return this;
        }

        @java.lang.Override
        public final boolean isInitialized() {
          return true;
        }

        @java.lang.Override
        public Builder mergeFrom(
            com.google.protobuf.CodedInputStream input,
            com.google.protobuf.ExtensionRegistryLite extensionRegistry)
            throws java.io.IOException {
          org.apache.submarine.server.api.proto.TritonModelConfig.ModelVersionPolicy.Specific parsedMessage = null;
          try {
            parsedMessage = PARSER.parsePartialFrom(input, extensionRegistry);
          } catch (com.google.protobuf.InvalidProtocolBufferException e) {
            parsedMessage = (org.apache.submarine.server.api.proto.TritonModelConfig.ModelVersionPolicy.Specific) e.getUnfinishedMessage();
            throw e.unwrapIOException();
          } finally {
            if (parsedMessage != null) {
              mergeFrom(parsedMessage);
            }
          }
          return this;
        }
        private int bitField0_;

        private com.google.protobuf.Internal.LongList versions_ = emptyLongList();
        private void ensureVersionsIsMutable() {
          if (!((bitField0_ & 0x00000001) != 0)) {
            versions_ = mutableCopy(versions_);
            bitField0_ |= 0x00000001;
           }
        }
        /**
         * <pre>
         *&#64;&#64;    .. cpp:var:: int64 versions (repeated)
         *&#64;&#64;
         *&#64;&#64;       The specific versions of the model that will be served.
         *&#64;&#64;
         * </pre>
         *
         * <code>repeated int64 versions = 1;</code>
         * @return A list containing the versions.
         */
        public java.util.List<java.lang.Long>
            getVersionsList() {
          return ((bitField0_ & 0x00000001) != 0) ?
                   java.util.Collections.unmodifiableList(versions_) : versions_;
        }
        /**
         * <pre>
         *&#64;&#64;    .. cpp:var:: int64 versions (repeated)
         *&#64;&#64;
         *&#64;&#64;       The specific versions of the model that will be served.
         *&#64;&#64;
         * </pre>
         *
         * <code>repeated int64 versions = 1;</code>
         * @return The count of versions.
         */
        public int getVersionsCount() {
          return versions_.size();
        }
        /**
         * <pre>
         *&#64;&#64;    .. cpp:var:: int64 versions (repeated)
         *&#64;&#64;
         *&#64;&#64;       The specific versions of the model that will be served.
         *&#64;&#64;
         * </pre>
         *
         * <code>repeated int64 versions = 1;</code>
         * @param index The index of the element to return.
         * @return The versions at the given index.
         */
        public long getVersions(int index) {
          return versions_.getLong(index);
        }
        /**
         * <pre>
         *&#64;&#64;    .. cpp:var:: int64 versions (repeated)
         *&#64;&#64;
         *&#64;&#64;       The specific versions of the model that will be served.
         *&#64;&#64;
         * </pre>
         *
         * <code>repeated int64 versions = 1;</code>
         * @param index The index to set the value at.
         * @param value The versions to set.
         * @return This builder for chaining.
         */
        public Builder setVersions(
            int index, long value) {
          ensureVersionsIsMutable();
          versions_.setLong(index, value);
          onChanged();
          return this;
        }
        /**
         * <pre>
         *&#64;&#64;    .. cpp:var:: int64 versions (repeated)
         *&#64;&#64;
         *&#64;&#64;       The specific versions of the model that will be served.
         *&#64;&#64;
         * </pre>
         *
         * <code>repeated int64 versions = 1;</code>
         * @param value The versions to add.
         * @return This builder for chaining.
         */
        public Builder addVersions(long value) {
          ensureVersionsIsMutable();
          versions_.addLong(value);
          onChanged();
          return this;
        }
        /**
         * <pre>
         *&#64;&#64;    .. cpp:var:: int64 versions (repeated)
         *&#64;&#64;
         *&#64;&#64;       The specific versions of the model that will be served.
         *&#64;&#64;
         * </pre>
         *
         * <code>repeated int64 versions = 1;</code>
         * @param values The versions to add.
         * @return This builder for chaining.
         */
        public Builder addAllVersions(
            java.lang.Iterable<? extends java.lang.Long> values) {
          ensureVersionsIsMutable();
          com.google.protobuf.AbstractMessageLite.Builder.addAll(
              values, versions_);
          onChanged();
          return this;
        }
        /**
         * <pre>
         *&#64;&#64;    .. cpp:var:: int64 versions (repeated)
         *&#64;&#64;
         *&#64;&#64;       The specific versions of the model that will be served.
         *&#64;&#64;
         * </pre>
         *
         * <code>repeated int64 versions = 1;</code>
         * @return This builder for chaining.
         */
        public Builder clearVersions() {
          versions_ = emptyLongList();
          bitField0_ = (bitField0_ & ~0x00000001);
          onChanged();
          return this;
        }
        @java.lang.Override
        public final Builder setUnknownFields(
            final com.google.protobuf.UnknownFieldSet unknownFields) {
          return super.setUnknownFields(unknownFields);
        }

        @java.lang.Override
        public final Builder mergeUnknownFields(
            final com.google.protobuf.UnknownFieldSet unknownFields) {
          return super.mergeUnknownFields(unknownFields);
        }


        // @@protoc_insertion_point(builder_scope:inference.ModelVersionPolicy.Specific)
      }

      // @@protoc_insertion_point(class_scope:inference.ModelVersionPolicy.Specific)
      private static final org.apache.submarine.server.api.proto.TritonModelConfig.ModelVersionPolicy.Specific DEFAULT_INSTANCE;
      static {
        DEFAULT_INSTANCE = new org.apache.submarine.server.api.proto.TritonModelConfig.ModelVersionPolicy.Specific();
      }

      public static org.apache.submarine.server.api.proto.TritonModelConfig.ModelVersionPolicy.Specific getDefaultInstance() {
        return DEFAULT_INSTANCE;
      }

      private static final com.google.protobuf.Parser<Specific>
          PARSER = new com.google.protobuf.AbstractParser<Specific>() {
        @java.lang.Override
        public Specific parsePartialFrom(
            com.google.protobuf.CodedInputStream input,
            com.google.protobuf.ExtensionRegistryLite extensionRegistry)
            throws com.google.protobuf.InvalidProtocolBufferException {
          return new Specific(input, extensionRegistry);
        }
      };

      public static com.google.protobuf.Parser<Specific> parser() {
        return PARSER;
      }

      @java.lang.Override
      public com.google.protobuf.Parser<Specific> getParserForType() {
        return PARSER;
      }

      @java.lang.Override
      public org.apache.submarine.server.api.proto.TritonModelConfig.ModelVersionPolicy.Specific getDefaultInstanceForType() {
        return DEFAULT_INSTANCE;
      }

    }

    private int policyChoiceCase_ = 0;
    private java.lang.Object policyChoice_;
    public enum PolicyChoiceCase
        implements com.google.protobuf.Internal.EnumLite,
            com.google.protobuf.AbstractMessage.InternalOneOfEnum {
      LATEST(1),
      ALL(2),
      SPECIFIC(3),
      POLICYCHOICE_NOT_SET(0);
      private final int value;
      private PolicyChoiceCase(int value) {
        this.value = value;
      }
      /**
       * @param value The number of the enum to look for.
       * @return The enum associated with the given number.
       * @deprecated Use {@link #forNumber(int)} instead.
       */
      @java.lang.Deprecated
      public static PolicyChoiceCase valueOf(int value) {
        return forNumber(value);
      }

      public static PolicyChoiceCase forNumber(int value) {
        switch (value) {
          case 1: return LATEST;
          case 2: return ALL;
          case 3: return SPECIFIC;
          case 0: return POLICYCHOICE_NOT_SET;
          default: return null;
        }
      }
      public int getNumber() {
        return this.value;
      }
    };

    public PolicyChoiceCase
    getPolicyChoiceCase() {
      return PolicyChoiceCase.forNumber(
          policyChoiceCase_);
    }

    public static final int LATEST_FIELD_NUMBER = 1;
    /**
     * <pre>
     *&#64;&#64;    .. cpp:var:: Latest latest
     *&#64;&#64;
     *&#64;&#64;       Serve only latest version(s) of the model.
     *&#64;&#64;
     * </pre>
     *
     * <code>.inference.ModelVersionPolicy.Latest latest = 1;</code>
     * @return Whether the latest field is set.
     */
    @java.lang.Override
    public boolean hasLatest() {
      return policyChoiceCase_ == 1;
    }
    /**
     * <pre>
     *&#64;&#64;    .. cpp:var:: Latest latest
     *&#64;&#64;
     *&#64;&#64;       Serve only latest version(s) of the model.
     *&#64;&#64;
     * </pre>
     *
     * <code>.inference.ModelVersionPolicy.Latest latest = 1;</code>
     * @return The latest.
     */
    @java.lang.Override
    public org.apache.submarine.server.api.proto.TritonModelConfig.ModelVersionPolicy.Latest getLatest() {
      if (policyChoiceCase_ == 1) {
         return (org.apache.submarine.server.api.proto.TritonModelConfig.ModelVersionPolicy.Latest) policyChoice_;
      }
      return org.apache.submarine.server.api.proto.TritonModelConfig.ModelVersionPolicy.Latest.getDefaultInstance();
    }
    /**
     * <pre>
     *&#64;&#64;    .. cpp:var:: Latest latest
     *&#64;&#64;
     *&#64;&#64;       Serve only latest version(s) of the model.
     *&#64;&#64;
     * </pre>
     *
     * <code>.inference.ModelVersionPolicy.Latest latest = 1;</code>
     */
    @java.lang.Override
    public org.apache.submarine.server.api.proto.TritonModelConfig.ModelVersionPolicy.LatestOrBuilder getLatestOrBuilder() {
      if (policyChoiceCase_ == 1) {
         return (org.apache.submarine.server.api.proto.TritonModelConfig.ModelVersionPolicy.Latest) policyChoice_;
      }
      return org.apache.submarine.server.api.proto.TritonModelConfig.ModelVersionPolicy.Latest.getDefaultInstance();
    }

    public static final int ALL_FIELD_NUMBER = 2;
    /**
     * <pre>
     *&#64;&#64;    .. cpp:var:: All all
     *&#64;&#64;
     *&#64;&#64;       Serve all versions of the model.
     *&#64;&#64;
     * </pre>
     *
     * <code>.inference.ModelVersionPolicy.All all = 2;</code>
     * @return Whether the all field is set.
     */
    @java.lang.Override
    public boolean hasAll() {
      return policyChoiceCase_ == 2;
    }
    /**
     * <pre>
     *&#64;&#64;    .. cpp:var:: All all
     *&#64;&#64;
     *&#64;&#64;       Serve all versions of the model.
     *&#64;&#64;
     * </pre>
     *
     * <code>.inference.ModelVersionPolicy.All all = 2;</code>
     * @return The all.
     */
    @java.lang.Override
    public org.apache.submarine.server.api.proto.TritonModelConfig.ModelVersionPolicy.All getAll() {
      if (policyChoiceCase_ == 2) {
         return (org.apache.submarine.server.api.proto.TritonModelConfig.ModelVersionPolicy.All) policyChoice_;
      }
      return org.apache.submarine.server.api.proto.TritonModelConfig.ModelVersionPolicy.All.getDefaultInstance();
    }
    /**
     * <pre>
     *&#64;&#64;    .. cpp:var:: All all
     *&#64;&#64;
     *&#64;&#64;       Serve all versions of the model.
     *&#64;&#64;
     * </pre>
     *
     * <code>.inference.ModelVersionPolicy.All all = 2;</code>
     */
    @java.lang.Override
    public org.apache.submarine.server.api.proto.TritonModelConfig.ModelVersionPolicy.AllOrBuilder getAllOrBuilder() {
      if (policyChoiceCase_ == 2) {
         return (org.apache.submarine.server.api.proto.TritonModelConfig.ModelVersionPolicy.All) policyChoice_;
      }
      return org.apache.submarine.server.api.proto.TritonModelConfig.ModelVersionPolicy.All.getDefaultInstance();
    }

    public static final int SPECIFIC_FIELD_NUMBER = 3;
    /**
     * <pre>
     *&#64;&#64;    .. cpp:var:: Specific specific
     *&#64;&#64;
     *&#64;&#64;       Serve only specific version(s) of the model.
     *&#64;&#64;
     * </pre>
     *
     * <code>.inference.ModelVersionPolicy.Specific specific = 3;</code>
     * @return Whether the specific field is set.
     */
    @java.lang.Override
    public boolean hasSpecific() {
      return policyChoiceCase_ == 3;
    }
    /**
     * <pre>
     *&#64;&#64;    .. cpp:var:: Specific specific
     *&#64;&#64;
     *&#64;&#64;       Serve only specific version(s) of the model.
     *&#64;&#64;
     * </pre>
     *
     * <code>.inference.ModelVersionPolicy.Specific specific = 3;</code>
     * @return The specific.
     */
    @java.lang.Override
    public org.apache.submarine.server.api.proto.TritonModelConfig.ModelVersionPolicy.Specific getSpecific() {
      if (policyChoiceCase_ == 3) {
         return (org.apache.submarine.server.api.proto.TritonModelConfig.ModelVersionPolicy.Specific) policyChoice_;
      }
      return org.apache.submarine.server.api.proto.TritonModelConfig.ModelVersionPolicy.Specific.getDefaultInstance();
    }
    /**
     * <pre>
     *&#64;&#64;    .. cpp:var:: Specific specific
     *&#64;&#64;
     *&#64;&#64;       Serve only specific version(s) of the model.
     *&#64;&#64;
     * </pre>
     *
     * <code>.inference.ModelVersionPolicy.Specific specific = 3;</code>
     */
    @java.lang.Override
    public org.apache.submarine.server.api.proto.TritonModelConfig.ModelVersionPolicy.SpecificOrBuilder getSpecificOrBuilder() {
      if (policyChoiceCase_ == 3) {
         return (org.apache.submarine.server.api.proto.TritonModelConfig.ModelVersionPolicy.Specific) policyChoice_;
      }
      return org.apache.submarine.server.api.proto.TritonModelConfig.ModelVersionPolicy.Specific.getDefaultInstance();
    }

    private byte memoizedIsInitialized = -1;
    @java.lang.Override
    public final boolean isInitialized() {
      byte isInitialized = memoizedIsInitialized;
      if (isInitialized == 1) return true;
      if (isInitialized == 0) return false;

      memoizedIsInitialized = 1;
      return true;
    }

    @java.lang.Override
    public void writeTo(com.google.protobuf.CodedOutputStream output)
                        throws java.io.IOException {
      if (policyChoiceCase_ == 1) {
        output.writeMessage(1, (org.apache.submarine.server.api.proto.TritonModelConfig.ModelVersionPolicy.Latest) policyChoice_);
      }
      if (policyChoiceCase_ == 2) {
        output.writeMessage(2, (org.apache.submarine.server.api.proto.TritonModelConfig.ModelVersionPolicy.All) policyChoice_);
      }
      if (policyChoiceCase_ == 3) {
        output.writeMessage(3, (org.apache.submarine.server.api.proto.TritonModelConfig.ModelVersionPolicy.Specific) policyChoice_);
      }
      unknownFields.writeTo(output);
    }

    @java.lang.Override
    public int getSerializedSize() {
      int size = memoizedSize;
      if (size != -1) return size;

      size = 0;
      if (policyChoiceCase_ == 1) {
        size += com.google.protobuf.CodedOutputStream
          .computeMessageSize(1, (org.apache.submarine.server.api.proto.TritonModelConfig.ModelVersionPolicy.Latest) policyChoice_);
      }
      if (policyChoiceCase_ == 2) {
        size += com.google.protobuf.CodedOutputStream
          .computeMessageSize(2, (org.apache.submarine.server.api.proto.TritonModelConfig.ModelVersionPolicy.All) policyChoice_);
      }
      if (policyChoiceCase_ == 3) {
        size += com.google.protobuf.CodedOutputStream
          .computeMessageSize(3, (org.apache.submarine.server.api.proto.TritonModelConfig.ModelVersionPolicy.Specific) policyChoice_);
      }
      size += unknownFields.getSerializedSize();
      memoizedSize = size;
      return size;
    }

    @java.lang.Override
    public boolean equals(final java.lang.Object obj) {
      if (obj == this) {
       return true;
      }
      if (!(obj instanceof org.apache.submarine.server.api.proto.TritonModelConfig.ModelVersionPolicy)) {
        return super.equals(obj);
      }
      org.apache.submarine.server.api.proto.TritonModelConfig.ModelVersionPolicy other = (org.apache.submarine.server.api.proto.TritonModelConfig.ModelVersionPolicy) obj;

      if (!getPolicyChoiceCase().equals(other.getPolicyChoiceCase())) return false;
      switch (policyChoiceCase_) {
        case 1:
          if (!getLatest()
              .equals(other.getLatest())) return false;
          break;
        case 2:
          if (!getAll()
              .equals(other.getAll())) return false;
          break;
        case 3:
          if (!getSpecific()
              .equals(other.getSpecific())) return false;
          break;
        case 0:
        default:
      }
      if (!unknownFields.equals(other.unknownFields)) return false;
      return true;
    }

    @java.lang.Override
    public int hashCode() {
      if (memoizedHashCode != 0) {
        return memoizedHashCode;
      }
      int hash = 41;
      hash = (19 * hash) + getDescriptor().hashCode();
      switch (policyChoiceCase_) {
        case 1:
          hash = (37 * hash) + LATEST_FIELD_NUMBER;
          hash = (53 * hash) + getLatest().hashCode();
          break;
        case 2:
          hash = (37 * hash) + ALL_FIELD_NUMBER;
          hash = (53 * hash) + getAll().hashCode();
          break;
        case 3:
          hash = (37 * hash) + SPECIFIC_FIELD_NUMBER;
          hash = (53 * hash) + getSpecific().hashCode();
          break;
        case 0:
        default:
      }
      hash = (29 * hash) + unknownFields.hashCode();
      memoizedHashCode = hash;
      return hash;
    }

    public static org.apache.submarine.server.api.proto.TritonModelConfig.ModelVersionPolicy parseFrom(
        java.nio.ByteBuffer data)
        throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data);
    }
    public static org.apache.submarine.server.api.proto.TritonModelConfig.ModelVersionPolicy parseFrom(
        java.nio.ByteBuffer data,
        com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data, extensionRegistry);
    }
    public static org.apache.submarine.server.api.proto.TritonModelConfig.ModelVersionPolicy parseFrom(
        com.google.protobuf.ByteString data)
        throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data);
    }
    public static org.apache.submarine.server.api.proto.TritonModelConfig.ModelVersionPolicy parseFrom(
        com.google.protobuf.ByteString data,
        com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data, extensionRegistry);
    }
    public static org.apache.submarine.server.api.proto.TritonModelConfig.ModelVersionPolicy parseFrom(byte[] data)
        throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data);
    }
    public static org.apache.submarine.server.api.proto.TritonModelConfig.ModelVersionPolicy parseFrom(
        byte[] data,
        com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data, extensionRegistry);
    }
    public static org.apache.submarine.server.api.proto.TritonModelConfig.ModelVersionPolicy parseFrom(java.io.InputStream input)
        throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3
          .parseWithIOException(PARSER, input);
    }
    public static org.apache.submarine.server.api.proto.TritonModelConfig.ModelVersionPolicy parseFrom(
        java.io.InputStream input,
        com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3
          .parseWithIOException(PARSER, input, extensionRegistry);
    }
    public static org.apache.submarine.server.api.proto.TritonModelConfig.ModelVersionPolicy parseDelimitedFrom(java.io.InputStream input)
        throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3
          .parseDelimitedWithIOException(PARSER, input);
    }
    public static org.apache.submarine.server.api.proto.TritonModelConfig.ModelVersionPolicy parseDelimitedFrom(
        java.io.InputStream input,
        com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3
          .parseDelimitedWithIOException(PARSER, input, extensionRegistry);
    }
    public static org.apache.submarine.server.api.proto.TritonModelConfig.ModelVersionPolicy parseFrom(
        com.google.protobuf.CodedInputStream input)
        throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3
          .parseWithIOException(PARSER, input);
    }
    public static org.apache.submarine.server.api.proto.TritonModelConfig.ModelVersionPolicy parseFrom(
        com.google.protobuf.CodedInputStream input,
        com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3
          .parseWithIOException(PARSER, input, extensionRegistry);
    }

    @java.lang.Override
    public Builder newBuilderForType() { return newBuilder(); }
    public static Builder newBuilder() {
      return DEFAULT_INSTANCE.toBuilder();
    }
    public static Builder newBuilder(org.apache.submarine.server.api.proto.TritonModelConfig.ModelVersionPolicy prototype) {
      return DEFAULT_INSTANCE.toBuilder().mergeFrom(prototype);
    }
    @java.lang.Override
    public Builder toBuilder() {
      return this == DEFAULT_INSTANCE
          ? new Builder() : new Builder().mergeFrom(this);
    }

    @java.lang.Override
    protected Builder newBuilderForType(
        com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
      Builder builder = new Builder(parent);
      return builder;
    }
    /**
     * <pre>
     *&#64;&#64;
     *&#64;&#64;.. cpp:var:: message ModelVersionPolicy
     *&#64;&#64;
     *&#64;&#64;   Policy indicating which versions of a model should be made
     *&#64;&#64;   available by the inference server.
     *&#64;&#64;
     * </pre>
     *
     * Protobuf type {@code inference.ModelVersionPolicy}
     */
    public static final class Builder extends
        com.google.protobuf.GeneratedMessageV3.Builder<Builder> implements
        // @@protoc_insertion_point(builder_implements:inference.ModelVersionPolicy)
        org.apache.submarine.server.api.proto.TritonModelConfig.ModelVersionPolicyOrBuilder {
      public static final com.google.protobuf.Descriptors.Descriptor
          getDescriptor() {
        return org.apache.submarine.server.api.proto.TritonModelConfig.internal_static_inference_ModelVersionPolicy_descriptor;
      }

      @java.lang.Override
      protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
          internalGetFieldAccessorTable() {
        return org.apache.submarine.server.api.proto.TritonModelConfig.internal_static_inference_ModelVersionPolicy_fieldAccessorTable
            .ensureFieldAccessorsInitialized(
                org.apache.submarine.server.api.proto.TritonModelConfig.ModelVersionPolicy.class, org.apache.submarine.server.api.proto.TritonModelConfig.ModelVersionPolicy.Builder.class);
      }

      // Construct using org.apache.submarine.server.api.proto.TritonModelConfig.ModelVersionPolicy.newBuilder()
      private Builder() {
        maybeForceBuilderInitialization();
      }

      private Builder(
          com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
        super(parent);
        maybeForceBuilderInitialization();
      }
      private void maybeForceBuilderInitialization() {
        if (com.google.protobuf.GeneratedMessageV3
                .alwaysUseFieldBuilders) {
        }
      }
      @java.lang.Override
      public Builder clear() {
        super.clear();
        policyChoiceCase_ = 0;
        policyChoice_ = null;
        return this;
      }

      @java.lang.Override
      public com.google.protobuf.Descriptors.Descriptor
          getDescriptorForType() {
        return org.apache.submarine.server.api.proto.TritonModelConfig.internal_static_inference_ModelVersionPolicy_descriptor;
      }

      @java.lang.Override
      public org.apache.submarine.server.api.proto.TritonModelConfig.ModelVersionPolicy getDefaultInstanceForType() {
        return org.apache.submarine.server.api.proto.TritonModelConfig.ModelVersionPolicy.getDefaultInstance();
      }

      @java.lang.Override
      public org.apache.submarine.server.api.proto.TritonModelConfig.ModelVersionPolicy build() {
        org.apache.submarine.server.api.proto.TritonModelConfig.ModelVersionPolicy result = buildPartial();
        if (!result.isInitialized()) {
          throw newUninitializedMessageException(result);
        }
        return result;
      }

      @java.lang.Override
      public org.apache.submarine.server.api.proto.TritonModelConfig.ModelVersionPolicy buildPartial() {
        org.apache.submarine.server.api.proto.TritonModelConfig.ModelVersionPolicy result = new org.apache.submarine.server.api.proto.TritonModelConfig.ModelVersionPolicy(this);
        if (policyChoiceCase_ == 1) {
          if (latestBuilder_ == null) {
            result.policyChoice_ = policyChoice_;
          } else {
            result.policyChoice_ = latestBuilder_.build();
          }
        }
        if (policyChoiceCase_ == 2) {
          if (allBuilder_ == null) {
            result.policyChoice_ = policyChoice_;
          } else {
            result.policyChoice_ = allBuilder_.build();
          }
        }
        if (policyChoiceCase_ == 3) {
          if (specificBuilder_ == null) {
            result.policyChoice_ = policyChoice_;
          } else {
            result.policyChoice_ = specificBuilder_.build();
          }
        }
        result.policyChoiceCase_ = policyChoiceCase_;
        onBuilt();
        return result;
      }

      @java.lang.Override
      public Builder clone() {
        return super.clone();
      }
      @java.lang.Override
      public Builder setField(
          com.google.protobuf.Descriptors.FieldDescriptor field,
          java.lang.Object value) {
        return super.setField(field, value);
      }
      @java.lang.Override
      public Builder clearField(
          com.google.protobuf.Descriptors.FieldDescriptor field) {
        return super.clearField(field);
      }
      @java.lang.Override
      public Builder clearOneof(
          com.google.protobuf.Descriptors.OneofDescriptor oneof) {
        return super.clearOneof(oneof);
      }
      @java.lang.Override
      public Builder setRepeatedField(
          com.google.protobuf.Descriptors.FieldDescriptor field,
          int index, java.lang.Object value) {
        return super.setRepeatedField(field, index, value);
      }
      @java.lang.Override
      public Builder addRepeatedField(
          com.google.protobuf.Descriptors.FieldDescriptor field,
          java.lang.Object value) {
        return super.addRepeatedField(field, value);
      }
      @java.lang.Override
      public Builder mergeFrom(com.google.protobuf.Message other) {
        if (other instanceof org.apache.submarine.server.api.proto.TritonModelConfig.ModelVersionPolicy) {
          return mergeFrom((org.apache.submarine.server.api.proto.TritonModelConfig.ModelVersionPolicy)other);
        } else {
          super.mergeFrom(other);
          return this;
        }
      }

      public Builder mergeFrom(org.apache.submarine.server.api.proto.TritonModelConfig.ModelVersionPolicy other) {
        if (other == org.apache.submarine.server.api.proto.TritonModelConfig.ModelVersionPolicy.getDefaultInstance()) return this;
        switch (other.getPolicyChoiceCase()) {
          case LATEST: {
            mergeLatest(other.getLatest());
            break;
          }
          case ALL: {
            mergeAll(other.getAll());
            break;
          }
          case SPECIFIC: {
            mergeSpecific(other.getSpecific());
            break;
          }
          case POLICYCHOICE_NOT_SET: {
            break;
          }
        }
        this.mergeUnknownFields(other.unknownFields);
        onChanged();
        return this;
      }

      @java.lang.Override
      public final boolean isInitialized() {
        return true;
      }

      @java.lang.Override
      public Builder mergeFrom(
          com.google.protobuf.CodedInputStream input,
          com.google.protobuf.ExtensionRegistryLite extensionRegistry)
          throws java.io.IOException {
        org.apache.submarine.server.api.proto.TritonModelConfig.ModelVersionPolicy parsedMessage = null;
        try {
          parsedMessage = PARSER.parsePartialFrom(input, extensionRegistry);
        } catch (com.google.protobuf.InvalidProtocolBufferException e) {
          parsedMessage = (org.apache.submarine.server.api.proto.TritonModelConfig.ModelVersionPolicy) e.getUnfinishedMessage();
          throw e.unwrapIOException();
        } finally {
          if (parsedMessage != null) {
            mergeFrom(parsedMessage);
          }
        }
        return this;
      }
      private int policyChoiceCase_ = 0;
      private java.lang.Object policyChoice_;
      public PolicyChoiceCase
          getPolicyChoiceCase() {
        return PolicyChoiceCase.forNumber(
            policyChoiceCase_);
      }

      public Builder clearPolicyChoice() {
        policyChoiceCase_ = 0;
        policyChoice_ = null;
        onChanged();
        return this;
      }


      private com.google.protobuf.SingleFieldBuilderV3<
          org.apache.submarine.server.api.proto.TritonModelConfig.ModelVersionPolicy.Latest, org.apache.submarine.server.api.proto.TritonModelConfig.ModelVersionPolicy.Latest.Builder, org.apache.submarine.server.api.proto.TritonModelConfig.ModelVersionPolicy.LatestOrBuilder> latestBuilder_;
      /**
       * <pre>
       *&#64;&#64;    .. cpp:var:: Latest latest
       *&#64;&#64;
       *&#64;&#64;       Serve only latest version(s) of the model.
       *&#64;&#64;
       * </pre>
       *
       * <code>.inference.ModelVersionPolicy.Latest latest = 1;</code>
       * @return Whether the latest field is set.
       */
      @java.lang.Override
      public boolean hasLatest() {
        return policyChoiceCase_ == 1;
      }
      /**
       * <pre>
       *&#64;&#64;    .. cpp:var:: Latest latest
       *&#64;&#64;
       *&#64;&#64;       Serve only latest version(s) of the model.
       *&#64;&#64;
       * </pre>
       *
       * <code>.inference.ModelVersionPolicy.Latest latest = 1;</code>
       * @return The latest.
       */
      @java.lang.Override
      public org.apache.submarine.server.api.proto.TritonModelConfig.ModelVersionPolicy.Latest getLatest() {
        if (latestBuilder_ == null) {
          if (policyChoiceCase_ == 1) {
            return (org.apache.submarine.server.api.proto.TritonModelConfig.ModelVersionPolicy.Latest) policyChoice_;
          }
          return org.apache.submarine.server.api.proto.TritonModelConfig.ModelVersionPolicy.Latest.getDefaultInstance();
        } else {
          if (policyChoiceCase_ == 1) {
            return latestBuilder_.getMessage();
          }
          return org.apache.submarine.server.api.proto.TritonModelConfig.ModelVersionPolicy.Latest.getDefaultInstance();
        }
      }
      /**
       * <pre>
       *&#64;&#64;    .. cpp:var:: Latest latest
       *&#64;&#64;
       *&#64;&#64;       Serve only latest version(s) of the model.
       *&#64;&#64;
       * </pre>
       *
       * <code>.inference.ModelVersionPolicy.Latest latest = 1;</code>
       */
      public Builder setLatest(org.apache.submarine.server.api.proto.TritonModelConfig.ModelVersionPolicy.Latest value) {
        if (latestBuilder_ == null) {
          if (value == null) {
            throw new NullPointerException();
          }
          policyChoice_ = value;
          onChanged();
        } else {
          latestBuilder_.setMessage(value);
        }
        policyChoiceCase_ = 1;
        return this;
      }
      /**
       * <pre>
       *&#64;&#64;    .. cpp:var:: Latest latest
       *&#64;&#64;
       *&#64;&#64;       Serve only latest version(s) of the model.
       *&#64;&#64;
       * </pre>
       *
       * <code>.inference.ModelVersionPolicy.Latest latest = 1;</code>
       */
      public Builder setLatest(
          org.apache.submarine.server.api.proto.TritonModelConfig.ModelVersionPolicy.Latest.Builder builderForValue) {
        if (latestBuilder_ == null) {
          policyChoice_ = builderForValue.build();
          onChanged();
        } else {
          latestBuilder_.setMessage(builderForValue.build());
        }
        policyChoiceCase_ = 1;
        return this;
      }
      /**
       * <pre>
       *&#64;&#64;    .. cpp:var:: Latest latest
       *&#64;&#64;
       *&#64;&#64;       Serve only latest version(s) of the model.
       *&#64;&#64;
       * </pre>
       *
       * <code>.inference.ModelVersionPolicy.Latest latest = 1;</code>
       */
      public Builder mergeLatest(org.apache.submarine.server.api.proto.TritonModelConfig.ModelVersionPolicy.Latest value) {
        if (latestBuilder_ == null) {
          if (policyChoiceCase_ == 1 &&
              policyChoice_ != org.apache.submarine.server.api.proto.TritonModelConfig.ModelVersionPolicy.Latest.getDefaultInstance()) {
            policyChoice_ = org.apache.submarine.server.api.proto.TritonModelConfig.ModelVersionPolicy.Latest.newBuilder((org.apache.submarine.server.api.proto.TritonModelConfig.ModelVersionPolicy.Latest) policyChoice_)
                .mergeFrom(value).buildPartial();
          } else {
            policyChoice_ = value;
          }
          onChanged();
        } else {
          if (policyChoiceCase_ == 1) {
            latestBuilder_.mergeFrom(value);
          }
          latestBuilder_.setMessage(value);
        }
        policyChoiceCase_ = 1;
        return this;
      }
      /**
       * <pre>
       *&#64;&#64;    .. cpp:var:: Latest latest
       *&#64;&#64;
       *&#64;&#64;       Serve only latest version(s) of the model.
       *&#64;&#64;
       * </pre>
       *
       * <code>.inference.ModelVersionPolicy.Latest latest = 1;</code>
       */
      public Builder clearLatest() {
        if (latestBuilder_ == null) {
          if (policyChoiceCase_ == 1) {
            policyChoiceCase_ = 0;
            policyChoice_ = null;
            onChanged();
          }
        } else {
          if (policyChoiceCase_ == 1) {
            policyChoiceCase_ = 0;
            policyChoice_ = null;
          }
          latestBuilder_.clear();
        }
        return this;
      }
      /**
       * <pre>
       *&#64;&#64;    .. cpp:var:: Latest latest
       *&#64;&#64;
       *&#64;&#64;       Serve only latest version(s) of the model.
       *&#64;&#64;
       * </pre>
       *
       * <code>.inference.ModelVersionPolicy.Latest latest = 1;</code>
       */
      public org.apache.submarine.server.api.proto.TritonModelConfig.ModelVersionPolicy.Latest.Builder getLatestBuilder() {
        return getLatestFieldBuilder().getBuilder();
      }
      /**
       * <pre>
       *&#64;&#64;    .. cpp:var:: Latest latest
       *&#64;&#64;
       *&#64;&#64;       Serve only latest version(s) of the model.
       *&#64;&#64;
       * </pre>
       *
       * <code>.inference.ModelVersionPolicy.Latest latest = 1;</code>
       */
      @java.lang.Override
      public org.apache.submarine.server.api.proto.TritonModelConfig.ModelVersionPolicy.LatestOrBuilder getLatestOrBuilder() {
        if ((policyChoiceCase_ == 1) && (latestBuilder_ != null)) {
          return latestBuilder_.getMessageOrBuilder();
        } else {
          if (policyChoiceCase_ == 1) {
            return (org.apache.submarine.server.api.proto.TritonModelConfig.ModelVersionPolicy.Latest) policyChoice_;
          }
          return org.apache.submarine.server.api.proto.TritonModelConfig.ModelVersionPolicy.Latest.getDefaultInstance();
        }
      }
      /**
       * <pre>
       *&#64;&#64;    .. cpp:var:: Latest latest
       *&#64;&#64;
       *&#64;&#64;       Serve only latest version(s) of the model.
       *&#64;&#64;
       * </pre>
       *
       * <code>.inference.ModelVersionPolicy.Latest latest = 1;</code>
       */
      private com.google.protobuf.SingleFieldBuilderV3<
          org.apache.submarine.server.api.proto.TritonModelConfig.ModelVersionPolicy.Latest, org.apache.submarine.server.api.proto.TritonModelConfig.ModelVersionPolicy.Latest.Builder, org.apache.submarine.server.api.proto.TritonModelConfig.ModelVersionPolicy.LatestOrBuilder> 
          getLatestFieldBuilder() {
        if (latestBuilder_ == null) {
          if (!(policyChoiceCase_ == 1)) {
            policyChoice_ = org.apache.submarine.server.api.proto.TritonModelConfig.ModelVersionPolicy.Latest.getDefaultInstance();
          }
          latestBuilder_ = new com.google.protobuf.SingleFieldBuilderV3<
              org.apache.submarine.server.api.proto.TritonModelConfig.ModelVersionPolicy.Latest, org.apache.submarine.server.api.proto.TritonModelConfig.ModelVersionPolicy.Latest.Builder, org.apache.submarine.server.api.proto.TritonModelConfig.ModelVersionPolicy.LatestOrBuilder>(
                  (org.apache.submarine.server.api.proto.TritonModelConfig.ModelVersionPolicy.Latest) policyChoice_,
                  getParentForChildren(),
                  isClean());
          policyChoice_ = null;
        }
        policyChoiceCase_ = 1;
        onChanged();;
        return latestBuilder_;
      }

      private com.google.protobuf.SingleFieldBuilderV3<
          org.apache.submarine.server.api.proto.TritonModelConfig.ModelVersionPolicy.All, org.apache.submarine.server.api.proto.TritonModelConfig.ModelVersionPolicy.All.Builder, org.apache.submarine.server.api.proto.TritonModelConfig.ModelVersionPolicy.AllOrBuilder> allBuilder_;
      /**
       * <pre>
       *&#64;&#64;    .. cpp:var:: All all
       *&#64;&#64;
       *&#64;&#64;       Serve all versions of the model.
       *&#64;&#64;
       * </pre>
       *
       * <code>.inference.ModelVersionPolicy.All all = 2;</code>
       * @return Whether the all field is set.
       */
      @java.lang.Override
      public boolean hasAll() {
        return policyChoiceCase_ == 2;
      }
      /**
       * <pre>
       *&#64;&#64;    .. cpp:var:: All all
       *&#64;&#64;
       *&#64;&#64;       Serve all versions of the model.
       *&#64;&#64;
       * </pre>
       *
       * <code>.inference.ModelVersionPolicy.All all = 2;</code>
       * @return The all.
       */
      @java.lang.Override
      public org.apache.submarine.server.api.proto.TritonModelConfig.ModelVersionPolicy.All getAll() {
        if (allBuilder_ == null) {
          if (policyChoiceCase_ == 2) {
            return (org.apache.submarine.server.api.proto.TritonModelConfig.ModelVersionPolicy.All) policyChoice_;
          }
          return org.apache.submarine.server.api.proto.TritonModelConfig.ModelVersionPolicy.All.getDefaultInstance();
        } else {
          if (policyChoiceCase_ == 2) {
            return allBuilder_.getMessage();
          }
          return org.apache.submarine.server.api.proto.TritonModelConfig.ModelVersionPolicy.All.getDefaultInstance();
        }
      }
      /**
       * <pre>
       *&#64;&#64;    .. cpp:var:: All all
       *&#64;&#64;
       *&#64;&#64;       Serve all versions of the model.
       *&#64;&#64;
       * </pre>
       *
       * <code>.inference.ModelVersionPolicy.All all = 2;</code>
       */
      public Builder setAll(org.apache.submarine.server.api.proto.TritonModelConfig.ModelVersionPolicy.All value) {
        if (allBuilder_ == null) {
          if (value == null) {
            throw new NullPointerException();
          }
          policyChoice_ = value;
          onChanged();
        } else {
          allBuilder_.setMessage(value);
        }
        policyChoiceCase_ = 2;
        return this;
      }
      /**
       * <pre>
       *&#64;&#64;    .. cpp:var:: All all
       *&#64;&#64;
       *&#64;&#64;       Serve all versions of the model.
       *&#64;&#64;
       * </pre>
       *
       * <code>.inference.ModelVersionPolicy.All all = 2;</code>
       */
      public Builder setAll(
          org.apache.submarine.server.api.proto.TritonModelConfig.ModelVersionPolicy.All.Builder builderForValue) {
        if (allBuilder_ == null) {
          policyChoice_ = builderForValue.build();
          onChanged();
        } else {
          allBuilder_.setMessage(builderForValue.build());
        }
        policyChoiceCase_ = 2;
        return this;
      }
      /**
       * <pre>
       *&#64;&#64;    .. cpp:var:: All all
       *&#64;&#64;
       *&#64;&#64;       Serve all versions of the model.
       *&#64;&#64;
       * </pre>
       *
       * <code>.inference.ModelVersionPolicy.All all = 2;</code>
       */
      public Builder mergeAll(org.apache.submarine.server.api.proto.TritonModelConfig.ModelVersionPolicy.All value) {
        if (allBuilder_ == null) {
          if (policyChoiceCase_ == 2 &&
              policyChoice_ != org.apache.submarine.server.api.proto.TritonModelConfig.ModelVersionPolicy.All.getDefaultInstance()) {
            policyChoice_ = org.apache.submarine.server.api.proto.TritonModelConfig.ModelVersionPolicy.All.newBuilder((org.apache.submarine.server.api.proto.TritonModelConfig.ModelVersionPolicy.All) policyChoice_)
                .mergeFrom(value).buildPartial();
          } else {
            policyChoice_ = value;
          }
          onChanged();
        } else {
          if (policyChoiceCase_ == 2) {
            allBuilder_.mergeFrom(value);
          }
          allBuilder_.setMessage(value);
        }
        policyChoiceCase_ = 2;
        return this;
      }
      /**
       * <pre>
       *&#64;&#64;    .. cpp:var:: All all
       *&#64;&#64;
       *&#64;&#64;       Serve all versions of the model.
       *&#64;&#64;
       * </pre>
       *
       * <code>.inference.ModelVersionPolicy.All all = 2;</code>
       */
      public Builder clearAll() {
        if (allBuilder_ == null) {
          if (policyChoiceCase_ == 2) {
            policyChoiceCase_ = 0;
            policyChoice_ = null;
            onChanged();
          }
        } else {
          if (policyChoiceCase_ == 2) {
            policyChoiceCase_ = 0;
            policyChoice_ = null;
          }
          allBuilder_.clear();
        }
        return this;
      }
      /**
       * <pre>
       *&#64;&#64;    .. cpp:var:: All all
       *&#64;&#64;
       *&#64;&#64;       Serve all versions of the model.
       *&#64;&#64;
       * </pre>
       *
       * <code>.inference.ModelVersionPolicy.All all = 2;</code>
       */
      public org.apache.submarine.server.api.proto.TritonModelConfig.ModelVersionPolicy.All.Builder getAllBuilder() {
        return getAllFieldBuilder().getBuilder();
      }
      /**
       * <pre>
       *&#64;&#64;    .. cpp:var:: All all
       *&#64;&#64;
       *&#64;&#64;       Serve all versions of the model.
       *&#64;&#64;
       * </pre>
       *
       * <code>.inference.ModelVersionPolicy.All all = 2;</code>
       */
      @java.lang.Override
      public org.apache.submarine.server.api.proto.TritonModelConfig.ModelVersionPolicy.AllOrBuilder getAllOrBuilder() {
        if ((policyChoiceCase_ == 2) && (allBuilder_ != null)) {
          return allBuilder_.getMessageOrBuilder();
        } else {
          if (policyChoiceCase_ == 2) {
            return (org.apache.submarine.server.api.proto.TritonModelConfig.ModelVersionPolicy.All) policyChoice_;
          }
          return org.apache.submarine.server.api.proto.TritonModelConfig.ModelVersionPolicy.All.getDefaultInstance();
        }
      }
      /**
       * <pre>
       *&#64;&#64;    .. cpp:var:: All all
       *&#64;&#64;
       *&#64;&#64;       Serve all versions of the model.
       *&#64;&#64;
       * </pre>
       *
       * <code>.inference.ModelVersionPolicy.All all = 2;</code>
       */
      private com.google.protobuf.SingleFieldBuilderV3<
          org.apache.submarine.server.api.proto.TritonModelConfig.ModelVersionPolicy.All, org.apache.submarine.server.api.proto.TritonModelConfig.ModelVersionPolicy.All.Builder, org.apache.submarine.server.api.proto.TritonModelConfig.ModelVersionPolicy.AllOrBuilder> 
          getAllFieldBuilder() {
        if (allBuilder_ == null) {
          if (!(policyChoiceCase_ == 2)) {
            policyChoice_ = org.apache.submarine.server.api.proto.TritonModelConfig.ModelVersionPolicy.All.getDefaultInstance();
          }
          allBuilder_ = new com.google.protobuf.SingleFieldBuilderV3<
              org.apache.submarine.server.api.proto.TritonModelConfig.ModelVersionPolicy.All, org.apache.submarine.server.api.proto.TritonModelConfig.ModelVersionPolicy.All.Builder, org.apache.submarine.server.api.proto.TritonModelConfig.ModelVersionPolicy.AllOrBuilder>(
                  (org.apache.submarine.server.api.proto.TritonModelConfig.ModelVersionPolicy.All) policyChoice_,
                  getParentForChildren(),
                  isClean());
          policyChoice_ = null;
        }
        policyChoiceCase_ = 2;
        onChanged();;
        return allBuilder_;
      }

      private com.google.protobuf.SingleFieldBuilderV3<
          org.apache.submarine.server.api.proto.TritonModelConfig.ModelVersionPolicy.Specific, org.apache.submarine.server.api.proto.TritonModelConfig.ModelVersionPolicy.Specific.Builder, org.apache.submarine.server.api.proto.TritonModelConfig.ModelVersionPolicy.SpecificOrBuilder> specificBuilder_;
      /**
       * <pre>
       *&#64;&#64;    .. cpp:var:: Specific specific
       *&#64;&#64;
       *&#64;&#64;       Serve only specific version(s) of the model.
       *&#64;&#64;
       * </pre>
       *
       * <code>.inference.ModelVersionPolicy.Specific specific = 3;</code>
       * @return Whether the specific field is set.
       */
      @java.lang.Override
      public boolean hasSpecific() {
        return policyChoiceCase_ == 3;
      }
      /**
       * <pre>
       *&#64;&#64;    .. cpp:var:: Specific specific
       *&#64;&#64;
       *&#64;&#64;       Serve only specific version(s) of the model.
       *&#64;&#64;
       * </pre>
       *
       * <code>.inference.ModelVersionPolicy.Specific specific = 3;</code>
       * @return The specific.
       */
      @java.lang.Override
      public org.apache.submarine.server.api.proto.TritonModelConfig.ModelVersionPolicy.Specific getSpecific() {
        if (specificBuilder_ == null) {
          if (policyChoiceCase_ == 3) {
            return (org.apache.submarine.server.api.proto.TritonModelConfig.ModelVersionPolicy.Specific) policyChoice_;
          }
          return org.apache.submarine.server.api.proto.TritonModelConfig.ModelVersionPolicy.Specific.getDefaultInstance();
        } else {
          if (policyChoiceCase_ == 3) {
            return specificBuilder_.getMessage();
          }
          return org.apache.submarine.server.api.proto.TritonModelConfig.ModelVersionPolicy.Specific.getDefaultInstance();
        }
      }
      /**
       * <pre>
       *&#64;&#64;    .. cpp:var:: Specific specific
       *&#64;&#64;
       *&#64;&#64;       Serve only specific version(s) of the model.
       *&#64;&#64;
       * </pre>
       *
       * <code>.inference.ModelVersionPolicy.Specific specific = 3;</code>
       */
      public Builder setSpecific(org.apache.submarine.server.api.proto.TritonModelConfig.ModelVersionPolicy.Specific value) {
        if (specificBuilder_ == null) {
          if (value == null) {
            throw new NullPointerException();
          }
          policyChoice_ = value;
          onChanged();
        } else {
          specificBuilder_.setMessage(value);
        }
        policyChoiceCase_ = 3;
        return this;
      }
      /**
       * <pre>
       *&#64;&#64;    .. cpp:var:: Specific specific
       *&#64;&#64;
       *&#64;&#64;       Serve only specific version(s) of the model.
       *&#64;&#64;
       * </pre>
       *
       * <code>.inference.ModelVersionPolicy.Specific specific = 3;</code>
       */
      public Builder setSpecific(
          org.apache.submarine.server.api.proto.TritonModelConfig.ModelVersionPolicy.Specific.Builder builderForValue) {
        if (specificBuilder_ == null) {
          policyChoice_ = builderForValue.build();
          onChanged();
        } else {
          specificBuilder_.setMessage(builderForValue.build());
        }
        policyChoiceCase_ = 3;
        return this;
      }
      /**
       * <pre>
       *&#64;&#64;    .. cpp:var:: Specific specific
       *&#64;&#64;
       *&#64;&#64;       Serve only specific version(s) of the model.
       *&#64;&#64;
       * </pre>
       *
       * <code>.inference.ModelVersionPolicy.Specific specific = 3;</code>
       */
      public Builder mergeSpecific(org.apache.submarine.server.api.proto.TritonModelConfig.ModelVersionPolicy.Specific value) {
        if (specificBuilder_ == null) {
          if (policyChoiceCase_ == 3 &&
              policyChoice_ != org.apache.submarine.server.api.proto.TritonModelConfig.ModelVersionPolicy.Specific.getDefaultInstance()) {
            policyChoice_ = org.apache.submarine.server.api.proto.TritonModelConfig.ModelVersionPolicy.Specific.newBuilder((org.apache.submarine.server.api.proto.TritonModelConfig.ModelVersionPolicy.Specific) policyChoice_)
                .mergeFrom(value).buildPartial();
          } else {
            policyChoice_ = value;
          }
          onChanged();
        } else {
          if (policyChoiceCase_ == 3) {
            specificBuilder_.mergeFrom(value);
          }
          specificBuilder_.setMessage(value);
        }
        policyChoiceCase_ = 3;
        return this;
      }
      /**
       * <pre>
       *&#64;&#64;    .. cpp:var:: Specific specific
       *&#64;&#64;
       *&#64;&#64;       Serve only specific version(s) of the model.
       *&#64;&#64;
       * </pre>
       *
       * <code>.inference.ModelVersionPolicy.Specific specific = 3;</code>
       */
      public Builder clearSpecific() {
        if (specificBuilder_ == null) {
          if (policyChoiceCase_ == 3) {
            policyChoiceCase_ = 0;
            policyChoice_ = null;
            onChanged();
          }
        } else {
          if (policyChoiceCase_ == 3) {
            policyChoiceCase_ = 0;
            policyChoice_ = null;
          }
          specificBuilder_.clear();
        }
        return this;
      }
      /**
       * <pre>
       *&#64;&#64;    .. cpp:var:: Specific specific
       *&#64;&#64;
       *&#64;&#64;       Serve only specific version(s) of the model.
       *&#64;&#64;
       * </pre>
       *
       * <code>.inference.ModelVersionPolicy.Specific specific = 3;</code>
       */
      public org.apache.submarine.server.api.proto.TritonModelConfig.ModelVersionPolicy.Specific.Builder getSpecificBuilder() {
        return getSpecificFieldBuilder().getBuilder();
      }
      /**
       * <pre>
       *&#64;&#64;    .. cpp:var:: Specific specific
       *&#64;&#64;
       *&#64;&#64;       Serve only specific version(s) of the model.
       *&#64;&#64;
       * </pre>
       *
       * <code>.inference.ModelVersionPolicy.Specific specific = 3;</code>
       */
      @java.lang.Override
      public org.apache.submarine.server.api.proto.TritonModelConfig.ModelVersionPolicy.SpecificOrBuilder getSpecificOrBuilder() {
        if ((policyChoiceCase_ == 3) && (specificBuilder_ != null)) {
          return specificBuilder_.getMessageOrBuilder();
        } else {
          if (policyChoiceCase_ == 3) {
            return (org.apache.submarine.server.api.proto.TritonModelConfig.ModelVersionPolicy.Specific) policyChoice_;
          }
          return org.apache.submarine.server.api.proto.TritonModelConfig.ModelVersionPolicy.Specific.getDefaultInstance();
        }
      }
      /**
       * <pre>
       *&#64;&#64;    .. cpp:var:: Specific specific
       *&#64;&#64;
       *&#64;&#64;       Serve only specific version(s) of the model.
       *&#64;&#64;
       * </pre>
       *
       * <code>.inference.ModelVersionPolicy.Specific specific = 3;</code>
       */
      private com.google.protobuf.SingleFieldBuilderV3<
          org.apache.submarine.server.api.proto.TritonModelConfig.ModelVersionPolicy.Specific, org.apache.submarine.server.api.proto.TritonModelConfig.ModelVersionPolicy.Specific.Builder, org.apache.submarine.server.api.proto.TritonModelConfig.ModelVersionPolicy.SpecificOrBuilder> 
          getSpecificFieldBuilder() {
        if (specificBuilder_ == null) {
          if (!(policyChoiceCase_ == 3)) {
            policyChoice_ = org.apache.submarine.server.api.proto.TritonModelConfig.ModelVersionPolicy.Specific.getDefaultInstance();
          }
          specificBuilder_ = new com.google.protobuf.SingleFieldBuilderV3<
              org.apache.submarine.server.api.proto.TritonModelConfig.ModelVersionPolicy.Specific, org.apache.submarine.server.api.proto.TritonModelConfig.ModelVersionPolicy.Specific.Builder, org.apache.submarine.server.api.proto.TritonModelConfig.ModelVersionPolicy.SpecificOrBuilder>(
                  (org.apache.submarine.server.api.proto.TritonModelConfig.ModelVersionPolicy.Specific) policyChoice_,
                  getParentForChildren(),
                  isClean());
          policyChoice_ = null;
        }
        policyChoiceCase_ = 3;
        onChanged();;
        return specificBuilder_;
      }
      @java.lang.Override
      public final Builder setUnknownFields(
          final com.google.protobuf.UnknownFieldSet unknownFields) {
        return super.setUnknownFields(unknownFields);
      }

      @java.lang.Override
      public final Builder mergeUnknownFields(
          final com.google.protobuf.UnknownFieldSet unknownFields) {
        return super.mergeUnknownFields(unknownFields);
      }


      // @@protoc_insertion_point(builder_scope:inference.ModelVersionPolicy)
    }

    // @@protoc_insertion_point(class_scope:inference.ModelVersionPolicy)
    private static final org.apache.submarine.server.api.proto.TritonModelConfig.ModelVersionPolicy DEFAULT_INSTANCE;
    static {
      DEFAULT_INSTANCE = new org.apache.submarine.server.api.proto.TritonModelConfig.ModelVersionPolicy();
    }

    public static org.apache.submarine.server.api.proto.TritonModelConfig.ModelVersionPolicy getDefaultInstance() {
      return DEFAULT_INSTANCE;
    }

    private static final com.google.protobuf.Parser<ModelVersionPolicy>
        PARSER = new com.google.protobuf.AbstractParser<ModelVersionPolicy>() {
      @java.lang.Override
      public ModelVersionPolicy parsePartialFrom(
          com.google.protobuf.CodedInputStream input,
          com.google.protobuf.ExtensionRegistryLite extensionRegistry)
          throws com.google.protobuf.InvalidProtocolBufferException {
        return new ModelVersionPolicy(input, extensionRegistry);
      }
    };

    public static com.google.protobuf.Parser<ModelVersionPolicy> parser() {
      return PARSER;
    }

    @java.lang.Override
    public com.google.protobuf.Parser<ModelVersionPolicy> getParserForType() {
      return PARSER;
    }

    @java.lang.Override
    public org.apache.submarine.server.api.proto.TritonModelConfig.ModelVersionPolicy getDefaultInstanceForType() {
      return DEFAULT_INSTANCE;
    }

  }

  public interface ModelOptimizationPolicyOrBuilder extends
      // @@protoc_insertion_point(interface_extends:inference.ModelOptimizationPolicy)
      com.google.protobuf.MessageOrBuilder {

    /**
     * <pre>
     *&#64;&#64;  .. cpp:var:: Graph graph
     *&#64;&#64;
     *&#64;&#64;     The graph optimization setting for the model. Optional.
     *&#64;&#64;
     * </pre>
     *
     * <code>.inference.ModelOptimizationPolicy.Graph graph = 1;</code>
     * @return Whether the graph field is set.
     */
    boolean hasGraph();
    /**
     * <pre>
     *&#64;&#64;  .. cpp:var:: Graph graph
     *&#64;&#64;
     *&#64;&#64;     The graph optimization setting for the model. Optional.
     *&#64;&#64;
     * </pre>
     *
     * <code>.inference.ModelOptimizationPolicy.Graph graph = 1;</code>
     * @return The graph.
     */
    org.apache.submarine.server.api.proto.TritonModelConfig.ModelOptimizationPolicy.Graph getGraph();
    /**
     * <pre>
     *&#64;&#64;  .. cpp:var:: Graph graph
     *&#64;&#64;
     *&#64;&#64;     The graph optimization setting for the model. Optional.
     *&#64;&#64;
     * </pre>
     *
     * <code>.inference.ModelOptimizationPolicy.Graph graph = 1;</code>
     */
    org.apache.submarine.server.api.proto.TritonModelConfig.ModelOptimizationPolicy.GraphOrBuilder getGraphOrBuilder();

    /**
     * <pre>
     *&#64;&#64;  .. cpp:var:: ModelPriority priority
     *&#64;&#64;
     *&#64;&#64;     The priority setting for the model. Optional.
     *&#64;&#64;
     * </pre>
     *
     * <code>.inference.ModelOptimizationPolicy.ModelPriority priority = 2;</code>
     * @return The enum numeric value on the wire for priority.
     */
    int getPriorityValue();
    /**
     * <pre>
     *&#64;&#64;  .. cpp:var:: ModelPriority priority
     *&#64;&#64;
     *&#64;&#64;     The priority setting for the model. Optional.
     *&#64;&#64;
     * </pre>
     *
     * <code>.inference.ModelOptimizationPolicy.ModelPriority priority = 2;</code>
     * @return The priority.
     */
    org.apache.submarine.server.api.proto.TritonModelConfig.ModelOptimizationPolicy.ModelPriority getPriority();

    /**
     * <pre>
     *&#64;&#64;  .. cpp:var:: Cuda cuda
     *&#64;&#64;
     *&#64;&#64;     CUDA-specific optimization settings. Optional.
     *&#64;&#64;
     * </pre>
     *
     * <code>.inference.ModelOptimizationPolicy.Cuda cuda = 3;</code>
     * @return Whether the cuda field is set.
     */
    boolean hasCuda();
    /**
     * <pre>
     *&#64;&#64;  .. cpp:var:: Cuda cuda
     *&#64;&#64;
     *&#64;&#64;     CUDA-specific optimization settings. Optional.
     *&#64;&#64;
     * </pre>
     *
     * <code>.inference.ModelOptimizationPolicy.Cuda cuda = 3;</code>
     * @return The cuda.
     */
    org.apache.submarine.server.api.proto.TritonModelConfig.ModelOptimizationPolicy.Cuda getCuda();
    /**
     * <pre>
     *&#64;&#64;  .. cpp:var:: Cuda cuda
     *&#64;&#64;
     *&#64;&#64;     CUDA-specific optimization settings. Optional.
     *&#64;&#64;
     * </pre>
     *
     * <code>.inference.ModelOptimizationPolicy.Cuda cuda = 3;</code>
     */
    org.apache.submarine.server.api.proto.TritonModelConfig.ModelOptimizationPolicy.CudaOrBuilder getCudaOrBuilder();

    /**
     * <pre>
     *&#64;&#64;  .. cpp:var:: ExecutionAccelerators execution_accelerators
     *&#64;&#64;
     *&#64;&#64;     The accelerators used for the model. Optional.
     *&#64;&#64;
     * </pre>
     *
     * <code>.inference.ModelOptimizationPolicy.ExecutionAccelerators execution_accelerators = 4;</code>
     * @return Whether the executionAccelerators field is set.
     */
    boolean hasExecutionAccelerators();
    /**
     * <pre>
     *&#64;&#64;  .. cpp:var:: ExecutionAccelerators execution_accelerators
     *&#64;&#64;
     *&#64;&#64;     The accelerators used for the model. Optional.
     *&#64;&#64;
     * </pre>
     *
     * <code>.inference.ModelOptimizationPolicy.ExecutionAccelerators execution_accelerators = 4;</code>
     * @return The executionAccelerators.
     */
    org.apache.submarine.server.api.proto.TritonModelConfig.ModelOptimizationPolicy.ExecutionAccelerators getExecutionAccelerators();
    /**
     * <pre>
     *&#64;&#64;  .. cpp:var:: ExecutionAccelerators execution_accelerators
     *&#64;&#64;
     *&#64;&#64;     The accelerators used for the model. Optional.
     *&#64;&#64;
     * </pre>
     *
     * <code>.inference.ModelOptimizationPolicy.ExecutionAccelerators execution_accelerators = 4;</code>
     */
    org.apache.submarine.server.api.proto.TritonModelConfig.ModelOptimizationPolicy.ExecutionAcceleratorsOrBuilder getExecutionAcceleratorsOrBuilder();

    /**
     * <pre>
     *&#64;&#64;  .. cpp:var:: PinnedMemoryBuffer input_pinned_memory
     *&#64;&#64;
     *&#64;&#64;     Use pinned memory buffer when the data transfer for inputs
     *&#64;&#64;     is between GPU memory and non-pinned system memory.
     *&#64;&#64;     Default is true.
     *&#64;&#64;
     * </pre>
     *
     * <code>.inference.ModelOptimizationPolicy.PinnedMemoryBuffer input_pinned_memory = 5;</code>
     * @return Whether the inputPinnedMemory field is set.
     */
    boolean hasInputPinnedMemory();
    /**
     * <pre>
     *&#64;&#64;  .. cpp:var:: PinnedMemoryBuffer input_pinned_memory
     *&#64;&#64;
     *&#64;&#64;     Use pinned memory buffer when the data transfer for inputs
     *&#64;&#64;     is between GPU memory and non-pinned system memory.
     *&#64;&#64;     Default is true.
     *&#64;&#64;
     * </pre>
     *
     * <code>.inference.ModelOptimizationPolicy.PinnedMemoryBuffer input_pinned_memory = 5;</code>
     * @return The inputPinnedMemory.
     */
    org.apache.submarine.server.api.proto.TritonModelConfig.ModelOptimizationPolicy.PinnedMemoryBuffer getInputPinnedMemory();
    /**
     * <pre>
     *&#64;&#64;  .. cpp:var:: PinnedMemoryBuffer input_pinned_memory
     *&#64;&#64;
     *&#64;&#64;     Use pinned memory buffer when the data transfer for inputs
     *&#64;&#64;     is between GPU memory and non-pinned system memory.
     *&#64;&#64;     Default is true.
     *&#64;&#64;
     * </pre>
     *
     * <code>.inference.ModelOptimizationPolicy.PinnedMemoryBuffer input_pinned_memory = 5;</code>
     */
    org.apache.submarine.server.api.proto.TritonModelConfig.ModelOptimizationPolicy.PinnedMemoryBufferOrBuilder getInputPinnedMemoryOrBuilder();

    /**
     * <pre>
     *&#64;&#64;  .. cpp:var:: PinnedMemoryBuffer output_pinned_memory
     *&#64;&#64;
     *&#64;&#64;     Use pinned memory buffer when the data transfer for outputs
     *&#64;&#64;     is between GPU memory and non-pinned system memory.
     *&#64;&#64;     Default is true.
     *&#64;&#64;
     * </pre>
     *
     * <code>.inference.ModelOptimizationPolicy.PinnedMemoryBuffer output_pinned_memory = 6;</code>
     * @return Whether the outputPinnedMemory field is set.
     */
    boolean hasOutputPinnedMemory();
    /**
     * <pre>
     *&#64;&#64;  .. cpp:var:: PinnedMemoryBuffer output_pinned_memory
     *&#64;&#64;
     *&#64;&#64;     Use pinned memory buffer when the data transfer for outputs
     *&#64;&#64;     is between GPU memory and non-pinned system memory.
     *&#64;&#64;     Default is true.
     *&#64;&#64;
     * </pre>
     *
     * <code>.inference.ModelOptimizationPolicy.PinnedMemoryBuffer output_pinned_memory = 6;</code>
     * @return The outputPinnedMemory.
     */
    org.apache.submarine.server.api.proto.TritonModelConfig.ModelOptimizationPolicy.PinnedMemoryBuffer getOutputPinnedMemory();
    /**
     * <pre>
     *&#64;&#64;  .. cpp:var:: PinnedMemoryBuffer output_pinned_memory
     *&#64;&#64;
     *&#64;&#64;     Use pinned memory buffer when the data transfer for outputs
     *&#64;&#64;     is between GPU memory and non-pinned system memory.
     *&#64;&#64;     Default is true.
     *&#64;&#64;
     * </pre>
     *
     * <code>.inference.ModelOptimizationPolicy.PinnedMemoryBuffer output_pinned_memory = 6;</code>
     */
    org.apache.submarine.server.api.proto.TritonModelConfig.ModelOptimizationPolicy.PinnedMemoryBufferOrBuilder getOutputPinnedMemoryOrBuilder();

    /**
     * <pre>
     *&#64;&#64;  .. cpp:var:: uint32 gather_kernel_buffer_threshold
     *&#64;&#64;
     *&#64;&#64;     The backend may use a gather kernel to gather input data if the
     *&#64;&#64;     device has direct access to the source buffer and the destination
     *&#64;&#64;     buffer. In such case, the gather kernel will be used only if the
     *&#64;&#64;     number of buffers to be gathered is greater or equal to
     *&#64;&#64;     the specifed value. If 0, the gather kernel will be disabled.
     *&#64;&#64;     Default value is 0.
     *&#64;&#64;     Currently only recognized by TensorRT backend.
     *&#64;&#64;
     * </pre>
     *
     * <code>uint32 gather_kernel_buffer_threshold = 7;</code>
     * @return The gatherKernelBufferThreshold.
     */
    int getGatherKernelBufferThreshold();

    /**
     * <pre>
     *&#64;&#64;  .. cpp:var:: bool eager_batching
     *&#64;&#64;
     *&#64;&#64;     Start preparing the next batch before the model instance is ready
     *&#64;&#64;     for the next inference. This option can be used to overlap the
     *&#64;&#64;     batch preparation with model execution, with the trade-off that
     *&#64;&#64;     the next batch might be smaller than what it could have been.
     *&#64;&#64;     Default value is false.
     *&#64;&#64;     Currently only recognized by TensorRT backend.
     *&#64;&#64;
     * </pre>
     *
     * <code>bool eager_batching = 8;</code>
     * @return The eagerBatching.
     */
    boolean getEagerBatching();
  }
  /**
   * <pre>
   *&#64;&#64;
   *&#64;&#64;.. cpp:var:: message ModelOptimizationPolicy
   *&#64;&#64;
   *&#64;&#64;   Optimization settings for a model. These settings control if/how a
   *&#64;&#64;   model is optimized and prioritized by the backend framework when
   *&#64;&#64;   it is loaded.
   *&#64;&#64;
   * </pre>
   *
   * Protobuf type {@code inference.ModelOptimizationPolicy}
   */
  public static final class ModelOptimizationPolicy extends
      com.google.protobuf.GeneratedMessageV3 implements
      // @@protoc_insertion_point(message_implements:inference.ModelOptimizationPolicy)
      ModelOptimizationPolicyOrBuilder {
  private static final long serialVersionUID = 0L;
    // Use ModelOptimizationPolicy.newBuilder() to construct.
    private ModelOptimizationPolicy(com.google.protobuf.GeneratedMessageV3.Builder<?> builder) {
      super(builder);
    }
    private ModelOptimizationPolicy() {
      priority_ = 0;
    }

    @java.lang.Override
    @SuppressWarnings({"unused"})
    protected java.lang.Object newInstance(
        UnusedPrivateParameter unused) {
      return new ModelOptimizationPolicy();
    }

    @java.lang.Override
    public final com.google.protobuf.UnknownFieldSet
    getUnknownFields() {
      return this.unknownFields;
    }
    private ModelOptimizationPolicy(
        com.google.protobuf.CodedInputStream input,
        com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws com.google.protobuf.InvalidProtocolBufferException {
      this();
      if (extensionRegistry == null) {
        throw new java.lang.NullPointerException();
      }
      com.google.protobuf.UnknownFieldSet.Builder unknownFields =
          com.google.protobuf.UnknownFieldSet.newBuilder();
      try {
        boolean done = false;
        while (!done) {
          int tag = input.readTag();
          switch (tag) {
            case 0:
              done = true;
              break;
            case 10: {
              org.apache.submarine.server.api.proto.TritonModelConfig.ModelOptimizationPolicy.Graph.Builder subBuilder = null;
              if (graph_ != null) {
                subBuilder = graph_.toBuilder();
              }
              graph_ = input.readMessage(org.apache.submarine.server.api.proto.TritonModelConfig.ModelOptimizationPolicy.Graph.parser(), extensionRegistry);
              if (subBuilder != null) {
                subBuilder.mergeFrom(graph_);
                graph_ = subBuilder.buildPartial();
              }

              break;
            }
            case 16: {
              int rawValue = input.readEnum();

              priority_ = rawValue;
              break;
            }
            case 26: {
              org.apache.submarine.server.api.proto.TritonModelConfig.ModelOptimizationPolicy.Cuda.Builder subBuilder = null;
              if (cuda_ != null) {
                subBuilder = cuda_.toBuilder();
              }
              cuda_ = input.readMessage(org.apache.submarine.server.api.proto.TritonModelConfig.ModelOptimizationPolicy.Cuda.parser(), extensionRegistry);
              if (subBuilder != null) {
                subBuilder.mergeFrom(cuda_);
                cuda_ = subBuilder.buildPartial();
              }

              break;
            }
            case 34: {
              org.apache.submarine.server.api.proto.TritonModelConfig.ModelOptimizationPolicy.ExecutionAccelerators.Builder subBuilder = null;
              if (executionAccelerators_ != null) {
                subBuilder = executionAccelerators_.toBuilder();
              }
              executionAccelerators_ = input.readMessage(org.apache.submarine.server.api.proto.TritonModelConfig.ModelOptimizationPolicy.ExecutionAccelerators.parser(), extensionRegistry);
              if (subBuilder != null) {
                subBuilder.mergeFrom(executionAccelerators_);
                executionAccelerators_ = subBuilder.buildPartial();
              }

              break;
            }
            case 42: {
              org.apache.submarine.server.api.proto.TritonModelConfig.ModelOptimizationPolicy.PinnedMemoryBuffer.Builder subBuilder = null;
              if (inputPinnedMemory_ != null) {
                subBuilder = inputPinnedMemory_.toBuilder();
              }
              inputPinnedMemory_ = input.readMessage(org.apache.submarine.server.api.proto.TritonModelConfig.ModelOptimizationPolicy.PinnedMemoryBuffer.parser(), extensionRegistry);
              if (subBuilder != null) {
                subBuilder.mergeFrom(inputPinnedMemory_);
                inputPinnedMemory_ = subBuilder.buildPartial();
              }

              break;
            }
            case 50: {
              org.apache.submarine.server.api.proto.TritonModelConfig.ModelOptimizationPolicy.PinnedMemoryBuffer.Builder subBuilder = null;
              if (outputPinnedMemory_ != null) {
                subBuilder = outputPinnedMemory_.toBuilder();
              }
              outputPinnedMemory_ = input.readMessage(org.apache.submarine.server.api.proto.TritonModelConfig.ModelOptimizationPolicy.PinnedMemoryBuffer.parser(), extensionRegistry);
              if (subBuilder != null) {
                subBuilder.mergeFrom(outputPinnedMemory_);
                outputPinnedMemory_ = subBuilder.buildPartial();
              }

              break;
            }
            case 56: {

              gatherKernelBufferThreshold_ = input.readUInt32();
              break;
            }
            case 64: {

              eagerBatching_ = input.readBool();
              break;
            }
            default: {
              if (!parseUnknownField(
                  input, unknownFields, extensionRegistry, tag)) {
                done = true;
              }
              break;
            }
          }
        }
      } catch (com.google.protobuf.InvalidProtocolBufferException e) {
        throw e.setUnfinishedMessage(this);
      } catch (java.io.IOException e) {
        throw new com.google.protobuf.InvalidProtocolBufferException(
            e).setUnfinishedMessage(this);
      } finally {
        this.unknownFields = unknownFields.build();
        makeExtensionsImmutable();
      }
    }
    public static final com.google.protobuf.Descriptors.Descriptor
        getDescriptor() {
      return org.apache.submarine.server.api.proto.TritonModelConfig.internal_static_inference_ModelOptimizationPolicy_descriptor;
    }

    @java.lang.Override
    protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
        internalGetFieldAccessorTable() {
      return org.apache.submarine.server.api.proto.TritonModelConfig.internal_static_inference_ModelOptimizationPolicy_fieldAccessorTable
          .ensureFieldAccessorsInitialized(
              org.apache.submarine.server.api.proto.TritonModelConfig.ModelOptimizationPolicy.class, org.apache.submarine.server.api.proto.TritonModelConfig.ModelOptimizationPolicy.Builder.class);
    }

    /**
     * <pre>
     *&#64;&#64;
     *&#64;&#64;  .. cpp:enum:: ModelPriority
     *&#64;&#64;
     *&#64;&#64;     Model priorities. A model will be given scheduling and execution
     *&#64;&#64;     preference over models at lower priorities. Current model
     *&#64;&#64;     priorities only work for TensorRT models.
     *&#64;&#64;
     * </pre>
     *
     * Protobuf enum {@code inference.ModelOptimizationPolicy.ModelPriority}
     */
    public enum ModelPriority
        implements com.google.protobuf.ProtocolMessageEnum {
      /**
       * <pre>
       *&#64;&#64;    .. cpp:enumerator:: ModelPriority::PRIORITY_DEFAULT = 0
       *&#64;&#64;
       *&#64;&#64;       The default model priority.
       *&#64;&#64;
       * </pre>
       *
       * <code>PRIORITY_DEFAULT = 0;</code>
       */
      PRIORITY_DEFAULT(0),
      /**
       * <pre>
       *&#64;&#64;    .. cpp:enumerator:: ModelPriority::PRIORITY_MAX = 1
       *&#64;&#64;
       *&#64;&#64;       The maximum model priority.
       *&#64;&#64;
       * </pre>
       *
       * <code>PRIORITY_MAX = 1;</code>
       */
      PRIORITY_MAX(1),
      /**
       * <pre>
       *&#64;&#64;    .. cpp:enumerator:: ModelPriority::PRIORITY_MIN = 2
       *&#64;&#64;
       *&#64;&#64;       The minimum model priority.
       *&#64;&#64;
       * </pre>
       *
       * <code>PRIORITY_MIN = 2;</code>
       */
      PRIORITY_MIN(2),
      UNRECOGNIZED(-1),
      ;

      /**
       * <pre>
       *&#64;&#64;    .. cpp:enumerator:: ModelPriority::PRIORITY_DEFAULT = 0
       *&#64;&#64;
       *&#64;&#64;       The default model priority.
       *&#64;&#64;
       * </pre>
       *
       * <code>PRIORITY_DEFAULT = 0;</code>
       */
      public static final int PRIORITY_DEFAULT_VALUE = 0;
      /**
       * <pre>
       *&#64;&#64;    .. cpp:enumerator:: ModelPriority::PRIORITY_MAX = 1
       *&#64;&#64;
       *&#64;&#64;       The maximum model priority.
       *&#64;&#64;
       * </pre>
       *
       * <code>PRIORITY_MAX = 1;</code>
       */
      public static final int PRIORITY_MAX_VALUE = 1;
      /**
       * <pre>
       *&#64;&#64;    .. cpp:enumerator:: ModelPriority::PRIORITY_MIN = 2
       *&#64;&#64;
       *&#64;&#64;       The minimum model priority.
       *&#64;&#64;
       * </pre>
       *
       * <code>PRIORITY_MIN = 2;</code>
       */
      public static final int PRIORITY_MIN_VALUE = 2;


      public final int getNumber() {
        if (this == UNRECOGNIZED) {
          throw new java.lang.IllegalArgumentException(
              "Can't get the number of an unknown enum value.");
        }
        return value;
      }

      /**
       * @param value The numeric wire value of the corresponding enum entry.
       * @return The enum associated with the given numeric wire value.
       * @deprecated Use {@link #forNumber(int)} instead.
       */
      @java.lang.Deprecated
      public static ModelPriority valueOf(int value) {
        return forNumber(value);
      }

      /**
       * @param value The numeric wire value of the corresponding enum entry.
       * @return The enum associated with the given numeric wire value.
       */
      public static ModelPriority forNumber(int value) {
        switch (value) {
          case 0: return PRIORITY_DEFAULT;
          case 1: return PRIORITY_MAX;
          case 2: return PRIORITY_MIN;
          default: return null;
        }
      }

      public static com.google.protobuf.Internal.EnumLiteMap<ModelPriority>
          internalGetValueMap() {
        return internalValueMap;
      }
      private static final com.google.protobuf.Internal.EnumLiteMap<
          ModelPriority> internalValueMap =
            new com.google.protobuf.Internal.EnumLiteMap<ModelPriority>() {
              public ModelPriority findValueByNumber(int number) {
                return ModelPriority.forNumber(number);
              }
            };

      public final com.google.protobuf.Descriptors.EnumValueDescriptor
          getValueDescriptor() {
        if (this == UNRECOGNIZED) {
          throw new java.lang.IllegalStateException(
              "Can't get the descriptor of an unrecognized enum value.");
        }
        return getDescriptor().getValues().get(ordinal());
      }
      public final com.google.protobuf.Descriptors.EnumDescriptor
          getDescriptorForType() {
        return getDescriptor();
      }
      public static final com.google.protobuf.Descriptors.EnumDescriptor
          getDescriptor() {
        return org.apache.submarine.server.api.proto.TritonModelConfig.ModelOptimizationPolicy.getDescriptor().getEnumTypes().get(0);
      }

      private static final ModelPriority[] VALUES = values();

      public static ModelPriority valueOf(
          com.google.protobuf.Descriptors.EnumValueDescriptor desc) {
        if (desc.getType() != getDescriptor()) {
          throw new java.lang.IllegalArgumentException(
            "EnumValueDescriptor is not for this type.");
        }
        if (desc.getIndex() == -1) {
          return UNRECOGNIZED;
        }
        return VALUES[desc.getIndex()];
      }

      private final int value;

      private ModelPriority(int value) {
        this.value = value;
      }

      // @@protoc_insertion_point(enum_scope:inference.ModelOptimizationPolicy.ModelPriority)
    }

    public interface GraphOrBuilder extends
        // @@protoc_insertion_point(interface_extends:inference.ModelOptimizationPolicy.Graph)
        com.google.protobuf.MessageOrBuilder {

      /**
       * <pre>
       *&#64;&#64;    .. cpp:var:: int32 level
       *&#64;&#64;
       *&#64;&#64;       The optimization level. Defaults to 0 (zero) if not specified.
       *&#64;&#64;
       *&#64;&#64;         - -1: Disabled
       *&#64;&#64;         -  0: Framework default
       *&#64;&#64;         -  1+: Enable optimization level (greater values indicate
       *&#64;&#64;            higher optimization levels)
       *&#64;&#64;
       * </pre>
       *
       * <code>int32 level = 1;</code>
       * @return The level.
       */
      int getLevel();
    }
    /**
     * <pre>
     *&#64;&#64;
     *&#64;&#64;  .. cpp:var:: message Graph
     *&#64;&#64;
     *&#64;&#64;     Enable generic graph optimization of the model. If not specified
     *&#64;&#64;     the framework's default level of optimization is used. Supports
     *&#64;&#64;     TensorFlow graphdef and savedmodel and Onnx models. For TensorFlow
     *&#64;&#64;     causes XLA to be enabled/disabled for the model. For Onnx defaults
     *&#64;&#64;     to enabling all optimizations, -1 enables only basic optimizations,
     *&#64;&#64;     +1 enables only basic and extended optimizations.
     *&#64;&#64;
     * </pre>
     *
     * Protobuf type {@code inference.ModelOptimizationPolicy.Graph}
     */
    public static final class Graph extends
        com.google.protobuf.GeneratedMessageV3 implements
        // @@protoc_insertion_point(message_implements:inference.ModelOptimizationPolicy.Graph)
        GraphOrBuilder {
    private static final long serialVersionUID = 0L;
      // Use Graph.newBuilder() to construct.
      private Graph(com.google.protobuf.GeneratedMessageV3.Builder<?> builder) {
        super(builder);
      }
      private Graph() {
      }

      @java.lang.Override
      @SuppressWarnings({"unused"})
      protected java.lang.Object newInstance(
          UnusedPrivateParameter unused) {
        return new Graph();
      }

      @java.lang.Override
      public final com.google.protobuf.UnknownFieldSet
      getUnknownFields() {
        return this.unknownFields;
      }
      private Graph(
          com.google.protobuf.CodedInputStream input,
          com.google.protobuf.ExtensionRegistryLite extensionRegistry)
          throws com.google.protobuf.InvalidProtocolBufferException {
        this();
        if (extensionRegistry == null) {
          throw new java.lang.NullPointerException();
        }
        com.google.protobuf.UnknownFieldSet.Builder unknownFields =
            com.google.protobuf.UnknownFieldSet.newBuilder();
        try {
          boolean done = false;
          while (!done) {
            int tag = input.readTag();
            switch (tag) {
              case 0:
                done = true;
                break;
              case 8: {

                level_ = input.readInt32();
                break;
              }
              default: {
                if (!parseUnknownField(
                    input, unknownFields, extensionRegistry, tag)) {
                  done = true;
                }
                break;
              }
            }
          }
        } catch (com.google.protobuf.InvalidProtocolBufferException e) {
          throw e.setUnfinishedMessage(this);
        } catch (java.io.IOException e) {
          throw new com.google.protobuf.InvalidProtocolBufferException(
              e).setUnfinishedMessage(this);
        } finally {
          this.unknownFields = unknownFields.build();
          makeExtensionsImmutable();
        }
      }
      public static final com.google.protobuf.Descriptors.Descriptor
          getDescriptor() {
        return org.apache.submarine.server.api.proto.TritonModelConfig.internal_static_inference_ModelOptimizationPolicy_Graph_descriptor;
      }

      @java.lang.Override
      protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
          internalGetFieldAccessorTable() {
        return org.apache.submarine.server.api.proto.TritonModelConfig.internal_static_inference_ModelOptimizationPolicy_Graph_fieldAccessorTable
            .ensureFieldAccessorsInitialized(
                org.apache.submarine.server.api.proto.TritonModelConfig.ModelOptimizationPolicy.Graph.class, org.apache.submarine.server.api.proto.TritonModelConfig.ModelOptimizationPolicy.Graph.Builder.class);
      }

      public static final int LEVEL_FIELD_NUMBER = 1;
      private int level_;
      /**
       * <pre>
       *&#64;&#64;    .. cpp:var:: int32 level
       *&#64;&#64;
       *&#64;&#64;       The optimization level. Defaults to 0 (zero) if not specified.
       *&#64;&#64;
       *&#64;&#64;         - -1: Disabled
       *&#64;&#64;         -  0: Framework default
       *&#64;&#64;         -  1+: Enable optimization level (greater values indicate
       *&#64;&#64;            higher optimization levels)
       *&#64;&#64;
       * </pre>
       *
       * <code>int32 level = 1;</code>
       * @return The level.
       */
      @java.lang.Override
      public int getLevel() {
        return level_;
      }

      private byte memoizedIsInitialized = -1;
      @java.lang.Override
      public final boolean isInitialized() {
        byte isInitialized = memoizedIsInitialized;
        if (isInitialized == 1) return true;
        if (isInitialized == 0) return false;

        memoizedIsInitialized = 1;
        return true;
      }

      @java.lang.Override
      public void writeTo(com.google.protobuf.CodedOutputStream output)
                          throws java.io.IOException {
        if (level_ != 0) {
          output.writeInt32(1, level_);
        }
        unknownFields.writeTo(output);
      }

      @java.lang.Override
      public int getSerializedSize() {
        int size = memoizedSize;
        if (size != -1) return size;

        size = 0;
        if (level_ != 0) {
          size += com.google.protobuf.CodedOutputStream
            .computeInt32Size(1, level_);
        }
        size += unknownFields.getSerializedSize();
        memoizedSize = size;
        return size;
      }

      @java.lang.Override
      public boolean equals(final java.lang.Object obj) {
        if (obj == this) {
         return true;
        }
        if (!(obj instanceof org.apache.submarine.server.api.proto.TritonModelConfig.ModelOptimizationPolicy.Graph)) {
          return super.equals(obj);
        }
        org.apache.submarine.server.api.proto.TritonModelConfig.ModelOptimizationPolicy.Graph other = (org.apache.submarine.server.api.proto.TritonModelConfig.ModelOptimizationPolicy.Graph) obj;

        if (getLevel()
            != other.getLevel()) return false;
        if (!unknownFields.equals(other.unknownFields)) return false;
        return true;
      }

      @java.lang.Override
      public int hashCode() {
        if (memoizedHashCode != 0) {
          return memoizedHashCode;
        }
        int hash = 41;
        hash = (19 * hash) + getDescriptor().hashCode();
        hash = (37 * hash) + LEVEL_FIELD_NUMBER;
        hash = (53 * hash) + getLevel();
        hash = (29 * hash) + unknownFields.hashCode();
        memoizedHashCode = hash;
        return hash;
      }

      public static org.apache.submarine.server.api.proto.TritonModelConfig.ModelOptimizationPolicy.Graph parseFrom(
          java.nio.ByteBuffer data)
          throws com.google.protobuf.InvalidProtocolBufferException {
        return PARSER.parseFrom(data);
      }
      public static org.apache.submarine.server.api.proto.TritonModelConfig.ModelOptimizationPolicy.Graph parseFrom(
          java.nio.ByteBuffer data,
          com.google.protobuf.ExtensionRegistryLite extensionRegistry)
          throws com.google.protobuf.InvalidProtocolBufferException {
        return PARSER.parseFrom(data, extensionRegistry);
      }
      public static org.apache.submarine.server.api.proto.TritonModelConfig.ModelOptimizationPolicy.Graph parseFrom(
          com.google.protobuf.ByteString data)
          throws com.google.protobuf.InvalidProtocolBufferException {
        return PARSER.parseFrom(data);
      }
      public static org.apache.submarine.server.api.proto.TritonModelConfig.ModelOptimizationPolicy.Graph parseFrom(
          com.google.protobuf.ByteString data,
          com.google.protobuf.ExtensionRegistryLite extensionRegistry)
          throws com.google.protobuf.InvalidProtocolBufferException {
        return PARSER.parseFrom(data, extensionRegistry);
      }
      public static org.apache.submarine.server.api.proto.TritonModelConfig.ModelOptimizationPolicy.Graph parseFrom(byte[] data)
          throws com.google.protobuf.InvalidProtocolBufferException {
        return PARSER.parseFrom(data);
      }
      public static org.apache.submarine.server.api.proto.TritonModelConfig.ModelOptimizationPolicy.Graph parseFrom(
          byte[] data,
          com.google.protobuf.ExtensionRegistryLite extensionRegistry)
          throws com.google.protobuf.InvalidProtocolBufferException {
        return PARSER.parseFrom(data, extensionRegistry);
      }
      public static org.apache.submarine.server.api.proto.TritonModelConfig.ModelOptimizationPolicy.Graph parseFrom(java.io.InputStream input)
          throws java.io.IOException {
        return com.google.protobuf.GeneratedMessageV3
            .parseWithIOException(PARSER, input);
      }
      public static org.apache.submarine.server.api.proto.TritonModelConfig.ModelOptimizationPolicy.Graph parseFrom(
          java.io.InputStream input,
          com.google.protobuf.ExtensionRegistryLite extensionRegistry)
          throws java.io.IOException {
        return com.google.protobuf.GeneratedMessageV3
            .parseWithIOException(PARSER, input, extensionRegistry);
      }
      public static org.apache.submarine.server.api.proto.TritonModelConfig.ModelOptimizationPolicy.Graph parseDelimitedFrom(java.io.InputStream input)
          throws java.io.IOException {
        return com.google.protobuf.GeneratedMessageV3
            .parseDelimitedWithIOException(PARSER, input);
      }
      public static org.apache.submarine.server.api.proto.TritonModelConfig.ModelOptimizationPolicy.Graph parseDelimitedFrom(
          java.io.InputStream input,
          com.google.protobuf.ExtensionRegistryLite extensionRegistry)
          throws java.io.IOException {
        return com.google.protobuf.GeneratedMessageV3
            .parseDelimitedWithIOException(PARSER, input, extensionRegistry);
      }
      public static org.apache.submarine.server.api.proto.TritonModelConfig.ModelOptimizationPolicy.Graph parseFrom(
          com.google.protobuf.CodedInputStream input)
          throws java.io.IOException {
        return com.google.protobuf.GeneratedMessageV3
            .parseWithIOException(PARSER, input);
      }
      public static org.apache.submarine.server.api.proto.TritonModelConfig.ModelOptimizationPolicy.Graph parseFrom(
          com.google.protobuf.CodedInputStream input,
          com.google.protobuf.ExtensionRegistryLite extensionRegistry)
          throws java.io.IOException {
        return com.google.protobuf.GeneratedMessageV3
            .parseWithIOException(PARSER, input, extensionRegistry);
      }

      @java.lang.Override
      public Builder newBuilderForType() { return newBuilder(); }
      public static Builder newBuilder() {
        return DEFAULT_INSTANCE.toBuilder();
      }
      public static Builder newBuilder(org.apache.submarine.server.api.proto.TritonModelConfig.ModelOptimizationPolicy.Graph prototype) {
        return DEFAULT_INSTANCE.toBuilder().mergeFrom(prototype);
      }
      @java.lang.Override
      public Builder toBuilder() {
        return this == DEFAULT_INSTANCE
            ? new Builder() : new Builder().mergeFrom(this);
      }

      @java.lang.Override
      protected Builder newBuilderForType(
          com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
        Builder builder = new Builder(parent);
        return builder;
      }
      /**
       * <pre>
       *&#64;&#64;
       *&#64;&#64;  .. cpp:var:: message Graph
       *&#64;&#64;
       *&#64;&#64;     Enable generic graph optimization of the model. If not specified
       *&#64;&#64;     the framework's default level of optimization is used. Supports
       *&#64;&#64;     TensorFlow graphdef and savedmodel and Onnx models. For TensorFlow
       *&#64;&#64;     causes XLA to be enabled/disabled for the model. For Onnx defaults
       *&#64;&#64;     to enabling all optimizations, -1 enables only basic optimizations,
       *&#64;&#64;     +1 enables only basic and extended optimizations.
       *&#64;&#64;
       * </pre>
       *
       * Protobuf type {@code inference.ModelOptimizationPolicy.Graph}
       */
      public static final class Builder extends
          com.google.protobuf.GeneratedMessageV3.Builder<Builder> implements
          // @@protoc_insertion_point(builder_implements:inference.ModelOptimizationPolicy.Graph)
          org.apache.submarine.server.api.proto.TritonModelConfig.ModelOptimizationPolicy.GraphOrBuilder {
        public static final com.google.protobuf.Descriptors.Descriptor
            getDescriptor() {
          return org.apache.submarine.server.api.proto.TritonModelConfig.internal_static_inference_ModelOptimizationPolicy_Graph_descriptor;
        }

        @java.lang.Override
        protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
            internalGetFieldAccessorTable() {
          return org.apache.submarine.server.api.proto.TritonModelConfig.internal_static_inference_ModelOptimizationPolicy_Graph_fieldAccessorTable
              .ensureFieldAccessorsInitialized(
                  org.apache.submarine.server.api.proto.TritonModelConfig.ModelOptimizationPolicy.Graph.class, org.apache.submarine.server.api.proto.TritonModelConfig.ModelOptimizationPolicy.Graph.Builder.class);
        }

        // Construct using org.apache.submarine.server.api.proto.TritonModelConfig.ModelOptimizationPolicy.Graph.newBuilder()
        private Builder() {
          maybeForceBuilderInitialization();
        }

        private Builder(
            com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
          super(parent);
          maybeForceBuilderInitialization();
        }
        private void maybeForceBuilderInitialization() {
          if (com.google.protobuf.GeneratedMessageV3
                  .alwaysUseFieldBuilders) {
          }
        }
        @java.lang.Override
        public Builder clear() {
          super.clear();
          level_ = 0;

          return this;
        }

        @java.lang.Override
        public com.google.protobuf.Descriptors.Descriptor
            getDescriptorForType() {
          return org.apache.submarine.server.api.proto.TritonModelConfig.internal_static_inference_ModelOptimizationPolicy_Graph_descriptor;
        }

        @java.lang.Override
        public org.apache.submarine.server.api.proto.TritonModelConfig.ModelOptimizationPolicy.Graph getDefaultInstanceForType() {
          return org.apache.submarine.server.api.proto.TritonModelConfig.ModelOptimizationPolicy.Graph.getDefaultInstance();
        }

        @java.lang.Override
        public org.apache.submarine.server.api.proto.TritonModelConfig.ModelOptimizationPolicy.Graph build() {
          org.apache.submarine.server.api.proto.TritonModelConfig.ModelOptimizationPolicy.Graph result = buildPartial();
          if (!result.isInitialized()) {
            throw newUninitializedMessageException(result);
          }
          return result;
        }

        @java.lang.Override
        public org.apache.submarine.server.api.proto.TritonModelConfig.ModelOptimizationPolicy.Graph buildPartial() {
          org.apache.submarine.server.api.proto.TritonModelConfig.ModelOptimizationPolicy.Graph result = new org.apache.submarine.server.api.proto.TritonModelConfig.ModelOptimizationPolicy.Graph(this);
          result.level_ = level_;
          onBuilt();
          return result;
        }

        @java.lang.Override
        public Builder clone() {
          return super.clone();
        }
        @java.lang.Override
        public Builder setField(
            com.google.protobuf.Descriptors.FieldDescriptor field,
            java.lang.Object value) {
          return super.setField(field, value);
        }
        @java.lang.Override
        public Builder clearField(
            com.google.protobuf.Descriptors.FieldDescriptor field) {
          return super.clearField(field);
        }
        @java.lang.Override
        public Builder clearOneof(
            com.google.protobuf.Descriptors.OneofDescriptor oneof) {
          return super.clearOneof(oneof);
        }
        @java.lang.Override
        public Builder setRepeatedField(
            com.google.protobuf.Descriptors.FieldDescriptor field,
            int index, java.lang.Object value) {
          return super.setRepeatedField(field, index, value);
        }
        @java.lang.Override
        public Builder addRepeatedField(
            com.google.protobuf.Descriptors.FieldDescriptor field,
            java.lang.Object value) {
          return super.addRepeatedField(field, value);
        }
        @java.lang.Override
        public Builder mergeFrom(com.google.protobuf.Message other) {
          if (other instanceof org.apache.submarine.server.api.proto.TritonModelConfig.ModelOptimizationPolicy.Graph) {
            return mergeFrom((org.apache.submarine.server.api.proto.TritonModelConfig.ModelOptimizationPolicy.Graph)other);
          } else {
            super.mergeFrom(other);
            return this;
          }
        }

        public Builder mergeFrom(org.apache.submarine.server.api.proto.TritonModelConfig.ModelOptimizationPolicy.Graph other) {
          if (other == org.apache.submarine.server.api.proto.TritonModelConfig.ModelOptimizationPolicy.Graph.getDefaultInstance()) return this;
          if (other.getLevel() != 0) {
            setLevel(other.getLevel());
          }
          this.mergeUnknownFields(other.unknownFields);
          onChanged();
          return this;
        }

        @java.lang.Override
        public final boolean isInitialized() {
          return true;
        }

        @java.lang.Override
        public Builder mergeFrom(
            com.google.protobuf.CodedInputStream input,
            com.google.protobuf.ExtensionRegistryLite extensionRegistry)
            throws java.io.IOException {
          org.apache.submarine.server.api.proto.TritonModelConfig.ModelOptimizationPolicy.Graph parsedMessage = null;
          try {
            parsedMessage = PARSER.parsePartialFrom(input, extensionRegistry);
          } catch (com.google.protobuf.InvalidProtocolBufferException e) {
            parsedMessage = (org.apache.submarine.server.api.proto.TritonModelConfig.ModelOptimizationPolicy.Graph) e.getUnfinishedMessage();
            throw e.unwrapIOException();
          } finally {
            if (parsedMessage != null) {
              mergeFrom(parsedMessage);
            }
          }
          return this;
        }

        private int level_ ;
        /**
         * <pre>
         *&#64;&#64;    .. cpp:var:: int32 level
         *&#64;&#64;
         *&#64;&#64;       The optimization level. Defaults to 0 (zero) if not specified.
         *&#64;&#64;
         *&#64;&#64;         - -1: Disabled
         *&#64;&#64;         -  0: Framework default
         *&#64;&#64;         -  1+: Enable optimization level (greater values indicate
         *&#64;&#64;            higher optimization levels)
         *&#64;&#64;
         * </pre>
         *
         * <code>int32 level = 1;</code>
         * @return The level.
         */
        @java.lang.Override
        public int getLevel() {
          return level_;
        }
        /**
         * <pre>
         *&#64;&#64;    .. cpp:var:: int32 level
         *&#64;&#64;
         *&#64;&#64;       The optimization level. Defaults to 0 (zero) if not specified.
         *&#64;&#64;
         *&#64;&#64;         - -1: Disabled
         *&#64;&#64;         -  0: Framework default
         *&#64;&#64;         -  1+: Enable optimization level (greater values indicate
         *&#64;&#64;            higher optimization levels)
         *&#64;&#64;
         * </pre>
         *
         * <code>int32 level = 1;</code>
         * @param value The level to set.
         * @return This builder for chaining.
         */
        public Builder setLevel(int value) {
          
          level_ = value;
          onChanged();
          return this;
        }
        /**
         * <pre>
         *&#64;&#64;    .. cpp:var:: int32 level
         *&#64;&#64;
         *&#64;&#64;       The optimization level. Defaults to 0 (zero) if not specified.
         *&#64;&#64;
         *&#64;&#64;         - -1: Disabled
         *&#64;&#64;         -  0: Framework default
         *&#64;&#64;         -  1+: Enable optimization level (greater values indicate
         *&#64;&#64;            higher optimization levels)
         *&#64;&#64;
         * </pre>
         *
         * <code>int32 level = 1;</code>
         * @return This builder for chaining.
         */
        public Builder clearLevel() {
          
          level_ = 0;
          onChanged();
          return this;
        }
        @java.lang.Override
        public final Builder setUnknownFields(
            final com.google.protobuf.UnknownFieldSet unknownFields) {
          return super.setUnknownFields(unknownFields);
        }

        @java.lang.Override
        public final Builder mergeUnknownFields(
            final com.google.protobuf.UnknownFieldSet unknownFields) {
          return super.mergeUnknownFields(unknownFields);
        }


        // @@protoc_insertion_point(builder_scope:inference.ModelOptimizationPolicy.Graph)
      }

      // @@protoc_insertion_point(class_scope:inference.ModelOptimizationPolicy.Graph)
      private static final org.apache.submarine.server.api.proto.TritonModelConfig.ModelOptimizationPolicy.Graph DEFAULT_INSTANCE;
      static {
        DEFAULT_INSTANCE = new org.apache.submarine.server.api.proto.TritonModelConfig.ModelOptimizationPolicy.Graph();
      }

      public static org.apache.submarine.server.api.proto.TritonModelConfig.ModelOptimizationPolicy.Graph getDefaultInstance() {
        return DEFAULT_INSTANCE;
      }

      private static final com.google.protobuf.Parser<Graph>
          PARSER = new com.google.protobuf.AbstractParser<Graph>() {
        @java.lang.Override
        public Graph parsePartialFrom(
            com.google.protobuf.CodedInputStream input,
            com.google.protobuf.ExtensionRegistryLite extensionRegistry)
            throws com.google.protobuf.InvalidProtocolBufferException {
          return new Graph(input, extensionRegistry);
        }
      };

      public static com.google.protobuf.Parser<Graph> parser() {
        return PARSER;
      }

      @java.lang.Override
      public com.google.protobuf.Parser<Graph> getParserForType() {
        return PARSER;
      }

      @java.lang.Override
      public org.apache.submarine.server.api.proto.TritonModelConfig.ModelOptimizationPolicy.Graph getDefaultInstanceForType() {
        return DEFAULT_INSTANCE;
      }

    }

    public interface CudaOrBuilder extends
        // @@protoc_insertion_point(interface_extends:inference.ModelOptimizationPolicy.Cuda)
        com.google.protobuf.MessageOrBuilder {

      /**
       * <pre>
       *&#64;&#64;    .. cpp:var:: bool graphs
       *&#64;&#64;
       *&#64;&#64;       Use CUDA graphs API to capture model operations and execute
       *&#64;&#64;       them more efficiently. Default value is false.
       *&#64;&#64;       Currently only recognized by TensorRT backend.
       *&#64;&#64;
       * </pre>
       *
       * <code>bool graphs = 1;</code>
       * @return The graphs.
       */
      boolean getGraphs();

      /**
       * <pre>
       *&#64;&#64;    .. cpp:var:: bool busy_wait_events
       *&#64;&#64;
       *&#64;&#64;       Use busy-waiting to synchronize CUDA events to achieve minimum
       *&#64;&#64;       latency from event complete to host thread to be notified, with
       *&#64;&#64;       the cost of high CPU load. Default value is false.
       *&#64;&#64;       Currently only recognized by TensorRT backend.
       *&#64;&#64;
       * </pre>
       *
       * <code>bool busy_wait_events = 2;</code>
       * @return The busyWaitEvents.
       */
      boolean getBusyWaitEvents();

      /**
       * <pre>
       *&#64;&#64;    .. cpp:var:: GraphSpec graph_spec (repeated)
       *&#64;&#64;
       *&#64;&#64;       Specification of the CUDA graph to be captured. If not specified
       *&#64;&#64;       and 'graphs' is true, the default CUDA graphs will be captured
       *&#64;&#64;       based on model settings.
       *&#64;&#64;       Currently only recognized by TensorRT backend.
       *&#64;&#64;
       * </pre>
       *
       * <code>repeated .inference.ModelOptimizationPolicy.Cuda.GraphSpec graph_spec = 3;</code>
       */
      java.util.List<org.apache.submarine.server.api.proto.TritonModelConfig.ModelOptimizationPolicy.Cuda.GraphSpec> 
          getGraphSpecList();
      /**
       * <pre>
       *&#64;&#64;    .. cpp:var:: GraphSpec graph_spec (repeated)
       *&#64;&#64;
       *&#64;&#64;       Specification of the CUDA graph to be captured. If not specified
       *&#64;&#64;       and 'graphs' is true, the default CUDA graphs will be captured
       *&#64;&#64;       based on model settings.
       *&#64;&#64;       Currently only recognized by TensorRT backend.
       *&#64;&#64;
       * </pre>
       *
       * <code>repeated .inference.ModelOptimizationPolicy.Cuda.GraphSpec graph_spec = 3;</code>
       */
      org.apache.submarine.server.api.proto.TritonModelConfig.ModelOptimizationPolicy.Cuda.GraphSpec getGraphSpec(int index);
      /**
       * <pre>
       *&#64;&#64;    .. cpp:var:: GraphSpec graph_spec (repeated)
       *&#64;&#64;
       *&#64;&#64;       Specification of the CUDA graph to be captured. If not specified
       *&#64;&#64;       and 'graphs' is true, the default CUDA graphs will be captured
       *&#64;&#64;       based on model settings.
       *&#64;&#64;       Currently only recognized by TensorRT backend.
       *&#64;&#64;
       * </pre>
       *
       * <code>repeated .inference.ModelOptimizationPolicy.Cuda.GraphSpec graph_spec = 3;</code>
       */
      int getGraphSpecCount();
      /**
       * <pre>
       *&#64;&#64;    .. cpp:var:: GraphSpec graph_spec (repeated)
       *&#64;&#64;
       *&#64;&#64;       Specification of the CUDA graph to be captured. If not specified
       *&#64;&#64;       and 'graphs' is true, the default CUDA graphs will be captured
       *&#64;&#64;       based on model settings.
       *&#64;&#64;       Currently only recognized by TensorRT backend.
       *&#64;&#64;
       * </pre>
       *
       * <code>repeated .inference.ModelOptimizationPolicy.Cuda.GraphSpec graph_spec = 3;</code>
       */
      java.util.List<? extends org.apache.submarine.server.api.proto.TritonModelConfig.ModelOptimizationPolicy.Cuda.GraphSpecOrBuilder> 
          getGraphSpecOrBuilderList();
      /**
       * <pre>
       *&#64;&#64;    .. cpp:var:: GraphSpec graph_spec (repeated)
       *&#64;&#64;
       *&#64;&#64;       Specification of the CUDA graph to be captured. If not specified
       *&#64;&#64;       and 'graphs' is true, the default CUDA graphs will be captured
       *&#64;&#64;       based on model settings.
       *&#64;&#64;       Currently only recognized by TensorRT backend.
       *&#64;&#64;
       * </pre>
       *
       * <code>repeated .inference.ModelOptimizationPolicy.Cuda.GraphSpec graph_spec = 3;</code>
       */
      org.apache.submarine.server.api.proto.TritonModelConfig.ModelOptimizationPolicy.Cuda.GraphSpecOrBuilder getGraphSpecOrBuilder(
          int index);

      /**
       * <pre>
       *&#64;&#64;    .. cpp:var:: bool output_copy_stream
       *&#64;&#64;
       *&#64;&#64;       Uses a CUDA stream separate from the inference stream to copy the
       *&#64;&#64;       output to host. However, be aware that setting this option to
       *&#64;&#64;       true will lead to an increase in the memory consumption of the
       *&#64;&#64;       model as Triton will allocate twice as much GPU memory for its
       *&#64;&#64;       I/O tensor buffers. Default value is false.
       *&#64;&#64;       Currently only recognized by TensorRT backend.
       *&#64;&#64;
       * </pre>
       *
       * <code>bool output_copy_stream = 4;</code>
       * @return The outputCopyStream.
       */
      boolean getOutputCopyStream();
    }
    /**
     * <pre>
     *&#64;&#64;
     *&#64;&#64;  .. cpp:var:: message Cuda
     *&#64;&#64;
     *&#64;&#64;     CUDA-specific optimization settings.
     *&#64;&#64;
     * </pre>
     *
     * Protobuf type {@code inference.ModelOptimizationPolicy.Cuda}
     */
    public static final class Cuda extends
        com.google.protobuf.GeneratedMessageV3 implements
        // @@protoc_insertion_point(message_implements:inference.ModelOptimizationPolicy.Cuda)
        CudaOrBuilder {
    private static final long serialVersionUID = 0L;
      // Use Cuda.newBuilder() to construct.
      private Cuda(com.google.protobuf.GeneratedMessageV3.Builder<?> builder) {
        super(builder);
      }
      private Cuda() {
        graphSpec_ = java.util.Collections.emptyList();
      }

      @java.lang.Override
      @SuppressWarnings({"unused"})
      protected java.lang.Object newInstance(
          UnusedPrivateParameter unused) {
        return new Cuda();
      }

      @java.lang.Override
      public final com.google.protobuf.UnknownFieldSet
      getUnknownFields() {
        return this.unknownFields;
      }
      private Cuda(
          com.google.protobuf.CodedInputStream input,
          com.google.protobuf.ExtensionRegistryLite extensionRegistry)
          throws com.google.protobuf.InvalidProtocolBufferException {
        this();
        if (extensionRegistry == null) {
          throw new java.lang.NullPointerException();
        }
        int mutable_bitField0_ = 0;
        com.google.protobuf.UnknownFieldSet.Builder unknownFields =
            com.google.protobuf.UnknownFieldSet.newBuilder();
        try {
          boolean done = false;
          while (!done) {
            int tag = input.readTag();
            switch (tag) {
              case 0:
                done = true;
                break;
              case 8: {

                graphs_ = input.readBool();
                break;
              }
              case 16: {

                busyWaitEvents_ = input.readBool();
                break;
              }
              case 26: {
                if (!((mutable_bitField0_ & 0x00000001) != 0)) {
                  graphSpec_ = new java.util.ArrayList<org.apache.submarine.server.api.proto.TritonModelConfig.ModelOptimizationPolicy.Cuda.GraphSpec>();
                  mutable_bitField0_ |= 0x00000001;
                }
                graphSpec_.add(
                    input.readMessage(org.apache.submarine.server.api.proto.TritonModelConfig.ModelOptimizationPolicy.Cuda.GraphSpec.parser(), extensionRegistry));
                break;
              }
              case 32: {

                outputCopyStream_ = input.readBool();
                break;
              }
              default: {
                if (!parseUnknownField(
                    input, unknownFields, extensionRegistry, tag)) {
                  done = true;
                }
                break;
              }
            }
          }
        } catch (com.google.protobuf.InvalidProtocolBufferException e) {
          throw e.setUnfinishedMessage(this);
        } catch (java.io.IOException e) {
          throw new com.google.protobuf.InvalidProtocolBufferException(
              e).setUnfinishedMessage(this);
        } finally {
          if (((mutable_bitField0_ & 0x00000001) != 0)) {
            graphSpec_ = java.util.Collections.unmodifiableList(graphSpec_);
          }
          this.unknownFields = unknownFields.build();
          makeExtensionsImmutable();
        }
      }
      public static final com.google.protobuf.Descriptors.Descriptor
          getDescriptor() {
        return org.apache.submarine.server.api.proto.TritonModelConfig.internal_static_inference_ModelOptimizationPolicy_Cuda_descriptor;
      }

      @java.lang.Override
      protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
          internalGetFieldAccessorTable() {
        return org.apache.submarine.server.api.proto.TritonModelConfig.internal_static_inference_ModelOptimizationPolicy_Cuda_fieldAccessorTable
            .ensureFieldAccessorsInitialized(
                org.apache.submarine.server.api.proto.TritonModelConfig.ModelOptimizationPolicy.Cuda.class, org.apache.submarine.server.api.proto.TritonModelConfig.ModelOptimizationPolicy.Cuda.Builder.class);
      }

      public interface GraphSpecOrBuilder extends
          // @@protoc_insertion_point(interface_extends:inference.ModelOptimizationPolicy.Cuda.GraphSpec)
          com.google.protobuf.MessageOrBuilder {

        /**
         * <pre>
         *&#64;&#64;      .. cpp:var:: int32 batch_size
         *&#64;&#64;
         *&#64;&#64;         The batch size of the CUDA graph. If 'max_batch_size' is 0,
         *&#64;&#64;         'batch_size' must be set to 0. Otherwise, 'batch_size' must
         *&#64;&#64;         be set to value between 1 and 'max_batch_size'.
         *&#64;&#64;
         * </pre>
         *
         * <code>int32 batch_size = 1;</code>
         * @return The batchSize.
         */
        int getBatchSize();

        /**
         * <pre>
         *&#64;&#64;      .. cpp:var:: map&lt;string, Shape&gt; input
         *&#64;&#64;
         *&#64;&#64;         The specification of the inputs. 'Shape' is the shape of the
         *&#64;&#64;         input without batching dimension.
         *&#64;&#64;
         * </pre>
         *
         * <code>map&lt;string, .inference.ModelOptimizationPolicy.Cuda.GraphSpec.Shape&gt; input = 2;</code>
         */
        int getInputCount();
        /**
         * <pre>
         *&#64;&#64;      .. cpp:var:: map&lt;string, Shape&gt; input
         *&#64;&#64;
         *&#64;&#64;         The specification of the inputs. 'Shape' is the shape of the
         *&#64;&#64;         input without batching dimension.
         *&#64;&#64;
         * </pre>
         *
         * <code>map&lt;string, .inference.ModelOptimizationPolicy.Cuda.GraphSpec.Shape&gt; input = 2;</code>
         */
        boolean containsInput(
            java.lang.String key);
        /**
         * Use {@link #getInputMap()} instead.
         */
        @java.lang.Deprecated
        java.util.Map<java.lang.String, org.apache.submarine.server.api.proto.TritonModelConfig.ModelOptimizationPolicy.Cuda.GraphSpec.Shape>
        getInput();
        /**
         * <pre>
         *&#64;&#64;      .. cpp:var:: map&lt;string, Shape&gt; input
         *&#64;&#64;
         *&#64;&#64;         The specification of the inputs. 'Shape' is the shape of the
         *&#64;&#64;         input without batching dimension.
         *&#64;&#64;
         * </pre>
         *
         * <code>map&lt;string, .inference.ModelOptimizationPolicy.Cuda.GraphSpec.Shape&gt; input = 2;</code>
         */
        java.util.Map<java.lang.String, org.apache.submarine.server.api.proto.TritonModelConfig.ModelOptimizationPolicy.Cuda.GraphSpec.Shape>
        getInputMap();
        /**
         * <pre>
         *&#64;&#64;      .. cpp:var:: map&lt;string, Shape&gt; input
         *&#64;&#64;
         *&#64;&#64;         The specification of the inputs. 'Shape' is the shape of the
         *&#64;&#64;         input without batching dimension.
         *&#64;&#64;
         * </pre>
         *
         * <code>map&lt;string, .inference.ModelOptimizationPolicy.Cuda.GraphSpec.Shape&gt; input = 2;</code>
         */

        org.apache.submarine.server.api.proto.TritonModelConfig.ModelOptimizationPolicy.Cuda.GraphSpec.Shape getInputOrDefault(
            java.lang.String key,
            org.apache.submarine.server.api.proto.TritonModelConfig.ModelOptimizationPolicy.Cuda.GraphSpec.Shape defaultValue);
        /**
         * <pre>
         *&#64;&#64;      .. cpp:var:: map&lt;string, Shape&gt; input
         *&#64;&#64;
         *&#64;&#64;         The specification of the inputs. 'Shape' is the shape of the
         *&#64;&#64;         input without batching dimension.
         *&#64;&#64;
         * </pre>
         *
         * <code>map&lt;string, .inference.ModelOptimizationPolicy.Cuda.GraphSpec.Shape&gt; input = 2;</code>
         */

        org.apache.submarine.server.api.proto.TritonModelConfig.ModelOptimizationPolicy.Cuda.GraphSpec.Shape getInputOrThrow(
            java.lang.String key);

        /**
         * <pre>
         *&#64;&#64;      .. cpp:var:: LowerBound graph_lower_bound
         *&#64;&#64;
         *&#64;&#64;         Specify the lower bound of the CUDA graph. Optional.
         *&#64;&#64;         If specified, the graph can be used for input shapes and
         *&#64;&#64;         batch sizes that are in closed interval between the lower
         *&#64;&#64;         bound specification and graph specification. For dynamic
         *&#64;&#64;         shape model, this allows CUDA graphs to be launched
         *&#64;&#64;         frequently without capturing all possible shape combinations.
         *&#64;&#64;         However, using graph for shape combinations different from
         *&#64;&#64;         the one used for capturing introduces uninitialized data for
         *&#64;&#64;         execution and it may distort the inference result if
         *&#64;&#64;         the model is sensitive to uninitialized data.
         *&#64;&#64;
         * </pre>
         *
         * <code>.inference.ModelOptimizationPolicy.Cuda.GraphSpec.LowerBound graph_lower_bound = 3;</code>
         * @return Whether the graphLowerBound field is set.
         */
        boolean hasGraphLowerBound();
        /**
         * <pre>
         *&#64;&#64;      .. cpp:var:: LowerBound graph_lower_bound
         *&#64;&#64;
         *&#64;&#64;         Specify the lower bound of the CUDA graph. Optional.
         *&#64;&#64;         If specified, the graph can be used for input shapes and
         *&#64;&#64;         batch sizes that are in closed interval between the lower
         *&#64;&#64;         bound specification and graph specification. For dynamic
         *&#64;&#64;         shape model, this allows CUDA graphs to be launched
         *&#64;&#64;         frequently without capturing all possible shape combinations.
         *&#64;&#64;         However, using graph for shape combinations different from
         *&#64;&#64;         the one used for capturing introduces uninitialized data for
         *&#64;&#64;         execution and it may distort the inference result if
         *&#64;&#64;         the model is sensitive to uninitialized data.
         *&#64;&#64;
         * </pre>
         *
         * <code>.inference.ModelOptimizationPolicy.Cuda.GraphSpec.LowerBound graph_lower_bound = 3;</code>
         * @return The graphLowerBound.
         */
        org.apache.submarine.server.api.proto.TritonModelConfig.ModelOptimizationPolicy.Cuda.GraphSpec.LowerBound getGraphLowerBound();
        /**
         * <pre>
         *&#64;&#64;      .. cpp:var:: LowerBound graph_lower_bound
         *&#64;&#64;
         *&#64;&#64;         Specify the lower bound of the CUDA graph. Optional.
         *&#64;&#64;         If specified, the graph can be used for input shapes and
         *&#64;&#64;         batch sizes that are in closed interval between the lower
         *&#64;&#64;         bound specification and graph specification. For dynamic
         *&#64;&#64;         shape model, this allows CUDA graphs to be launched
         *&#64;&#64;         frequently without capturing all possible shape combinations.
         *&#64;&#64;         However, using graph for shape combinations different from
         *&#64;&#64;         the one used for capturing introduces uninitialized data for
         *&#64;&#64;         execution and it may distort the inference result if
         *&#64;&#64;         the model is sensitive to uninitialized data.
         *&#64;&#64;
         * </pre>
         *
         * <code>.inference.ModelOptimizationPolicy.Cuda.GraphSpec.LowerBound graph_lower_bound = 3;</code>
         */
        org.apache.submarine.server.api.proto.TritonModelConfig.ModelOptimizationPolicy.Cuda.GraphSpec.LowerBoundOrBuilder getGraphLowerBoundOrBuilder();
      }
      /**
       * <pre>
       *&#64;&#64;    .. cpp:var:: message GraphSpec
       *&#64;&#64;
       *&#64;&#64;       Specification of the CUDA graph to be captured.
       *&#64;&#64;
       * </pre>
       *
       * Protobuf type {@code inference.ModelOptimizationPolicy.Cuda.GraphSpec}
       */
      public static final class GraphSpec extends
          com.google.protobuf.GeneratedMessageV3 implements
          // @@protoc_insertion_point(message_implements:inference.ModelOptimizationPolicy.Cuda.GraphSpec)
          GraphSpecOrBuilder {
      private static final long serialVersionUID = 0L;
        // Use GraphSpec.newBuilder() to construct.
        private GraphSpec(com.google.protobuf.GeneratedMessageV3.Builder<?> builder) {
          super(builder);
        }
        private GraphSpec() {
        }

        @java.lang.Override
        @SuppressWarnings({"unused"})
        protected java.lang.Object newInstance(
            UnusedPrivateParameter unused) {
          return new GraphSpec();
        }

        @java.lang.Override
        public final com.google.protobuf.UnknownFieldSet
        getUnknownFields() {
          return this.unknownFields;
        }
        private GraphSpec(
            com.google.protobuf.CodedInputStream input,
            com.google.protobuf.ExtensionRegistryLite extensionRegistry)
            throws com.google.protobuf.InvalidProtocolBufferException {
          this();
          if (extensionRegistry == null) {
            throw new java.lang.NullPointerException();
          }
          int mutable_bitField0_ = 0;
          com.google.protobuf.UnknownFieldSet.Builder unknownFields =
              com.google.protobuf.UnknownFieldSet.newBuilder();
          try {
            boolean done = false;
            while (!done) {
              int tag = input.readTag();
              switch (tag) {
                case 0:
                  done = true;
                  break;
                case 8: {

                  batchSize_ = input.readInt32();
                  break;
                }
                case 18: {
                  if (!((mutable_bitField0_ & 0x00000001) != 0)) {
                    input_ = com.google.protobuf.MapField.newMapField(
                        InputDefaultEntryHolder.defaultEntry);
                    mutable_bitField0_ |= 0x00000001;
                  }
                  com.google.protobuf.MapEntry<java.lang.String, org.apache.submarine.server.api.proto.TritonModelConfig.ModelOptimizationPolicy.Cuda.GraphSpec.Shape>
                  input__ = input.readMessage(
                      InputDefaultEntryHolder.defaultEntry.getParserForType(), extensionRegistry);
                  input_.getMutableMap().put(
                      input__.getKey(), input__.getValue());
                  break;
                }
                case 26: {
                  org.apache.submarine.server.api.proto.TritonModelConfig.ModelOptimizationPolicy.Cuda.GraphSpec.LowerBound.Builder subBuilder = null;
                  if (graphLowerBound_ != null) {
                    subBuilder = graphLowerBound_.toBuilder();
                  }
                  graphLowerBound_ = input.readMessage(org.apache.submarine.server.api.proto.TritonModelConfig.ModelOptimizationPolicy.Cuda.GraphSpec.LowerBound.parser(), extensionRegistry);
                  if (subBuilder != null) {
                    subBuilder.mergeFrom(graphLowerBound_);
                    graphLowerBound_ = subBuilder.buildPartial();
                  }

                  break;
                }
                default: {
                  if (!parseUnknownField(
                      input, unknownFields, extensionRegistry, tag)) {
                    done = true;
                  }
                  break;
                }
              }
            }
          } catch (com.google.protobuf.InvalidProtocolBufferException e) {
            throw e.setUnfinishedMessage(this);
          } catch (java.io.IOException e) {
            throw new com.google.protobuf.InvalidProtocolBufferException(
                e).setUnfinishedMessage(this);
          } finally {
            this.unknownFields = unknownFields.build();
            makeExtensionsImmutable();
          }
        }
        public static final com.google.protobuf.Descriptors.Descriptor
            getDescriptor() {
          return org.apache.submarine.server.api.proto.TritonModelConfig.internal_static_inference_ModelOptimizationPolicy_Cuda_GraphSpec_descriptor;
        }

        @SuppressWarnings({"rawtypes"})
        @java.lang.Override
        protected com.google.protobuf.MapField internalGetMapField(
            int number) {
          switch (number) {
            case 2:
              return internalGetInput();
            default:
              throw new RuntimeException(
                  "Invalid map field number: " + number);
          }
        }
        @java.lang.Override
        protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
            internalGetFieldAccessorTable() {
          return org.apache.submarine.server.api.proto.TritonModelConfig.internal_static_inference_ModelOptimizationPolicy_Cuda_GraphSpec_fieldAccessorTable
              .ensureFieldAccessorsInitialized(
                  org.apache.submarine.server.api.proto.TritonModelConfig.ModelOptimizationPolicy.Cuda.GraphSpec.class, org.apache.submarine.server.api.proto.TritonModelConfig.ModelOptimizationPolicy.Cuda.GraphSpec.Builder.class);
        }

        public interface ShapeOrBuilder extends
            // @@protoc_insertion_point(interface_extends:inference.ModelOptimizationPolicy.Cuda.GraphSpec.Shape)
            com.google.protobuf.MessageOrBuilder {

          /**
           * <pre>
           *&#64;&#64;        .. cpp:var:: int64 dim (repeated)
           *&#64;&#64;
           *&#64;&#64;           The dimension.
           *&#64;&#64;
           * </pre>
           *
           * <code>repeated int64 dim = 1;</code>
           * @return A list containing the dim.
           */
          java.util.List<java.lang.Long> getDimList();
          /**
           * <pre>
           *&#64;&#64;        .. cpp:var:: int64 dim (repeated)
           *&#64;&#64;
           *&#64;&#64;           The dimension.
           *&#64;&#64;
           * </pre>
           *
           * <code>repeated int64 dim = 1;</code>
           * @return The count of dim.
           */
          int getDimCount();
          /**
           * <pre>
           *&#64;&#64;        .. cpp:var:: int64 dim (repeated)
           *&#64;&#64;
           *&#64;&#64;           The dimension.
           *&#64;&#64;
           * </pre>
           *
           * <code>repeated int64 dim = 1;</code>
           * @param index The index of the element to return.
           * @return The dim at the given index.
           */
          long getDim(int index);
        }
        /**
         * <pre>
         *&#64;&#64;      .. cpp:var:: message Dims
         *&#64;&#64;
         *&#64;&#64;         Specification of tensor dimension.
         *&#64;&#64;
         * </pre>
         *
         * Protobuf type {@code inference.ModelOptimizationPolicy.Cuda.GraphSpec.Shape}
         */
        public static final class Shape extends
            com.google.protobuf.GeneratedMessageV3 implements
            // @@protoc_insertion_point(message_implements:inference.ModelOptimizationPolicy.Cuda.GraphSpec.Shape)
            ShapeOrBuilder {
        private static final long serialVersionUID = 0L;
          // Use Shape.newBuilder() to construct.
          private Shape(com.google.protobuf.GeneratedMessageV3.Builder<?> builder) {
            super(builder);
          }
          private Shape() {
            dim_ = emptyLongList();
          }

          @java.lang.Override
          @SuppressWarnings({"unused"})
          protected java.lang.Object newInstance(
              UnusedPrivateParameter unused) {
            return new Shape();
          }

          @java.lang.Override
          public final com.google.protobuf.UnknownFieldSet
          getUnknownFields() {
            return this.unknownFields;
          }
          private Shape(
              com.google.protobuf.CodedInputStream input,
              com.google.protobuf.ExtensionRegistryLite extensionRegistry)
              throws com.google.protobuf.InvalidProtocolBufferException {
            this();
            if (extensionRegistry == null) {
              throw new java.lang.NullPointerException();
            }
            int mutable_bitField0_ = 0;
            com.google.protobuf.UnknownFieldSet.Builder unknownFields =
                com.google.protobuf.UnknownFieldSet.newBuilder();
            try {
              boolean done = false;
              while (!done) {
                int tag = input.readTag();
                switch (tag) {
                  case 0:
                    done = true;
                    break;
                  case 8: {
                    if (!((mutable_bitField0_ & 0x00000001) != 0)) {
                      dim_ = newLongList();
                      mutable_bitField0_ |= 0x00000001;
                    }
                    dim_.addLong(input.readInt64());
                    break;
                  }
                  case 10: {
                    int length = input.readRawVarint32();
                    int limit = input.pushLimit(length);
                    if (!((mutable_bitField0_ & 0x00000001) != 0) && input.getBytesUntilLimit() > 0) {
                      dim_ = newLongList();
                      mutable_bitField0_ |= 0x00000001;
                    }
                    while (input.getBytesUntilLimit() > 0) {
                      dim_.addLong(input.readInt64());
                    }
                    input.popLimit(limit);
                    break;
                  }
                  default: {
                    if (!parseUnknownField(
                        input, unknownFields, extensionRegistry, tag)) {
                      done = true;
                    }
                    break;
                  }
                }
              }
            } catch (com.google.protobuf.InvalidProtocolBufferException e) {
              throw e.setUnfinishedMessage(this);
            } catch (java.io.IOException e) {
              throw new com.google.protobuf.InvalidProtocolBufferException(
                  e).setUnfinishedMessage(this);
            } finally {
              if (((mutable_bitField0_ & 0x00000001) != 0)) {
                dim_.makeImmutable(); // C
              }
              this.unknownFields = unknownFields.build();
              makeExtensionsImmutable();
            }
          }
          public static final com.google.protobuf.Descriptors.Descriptor
              getDescriptor() {
            return org.apache.submarine.server.api.proto.TritonModelConfig.internal_static_inference_ModelOptimizationPolicy_Cuda_GraphSpec_Shape_descriptor;
          }

          @java.lang.Override
          protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
              internalGetFieldAccessorTable() {
            return org.apache.submarine.server.api.proto.TritonModelConfig.internal_static_inference_ModelOptimizationPolicy_Cuda_GraphSpec_Shape_fieldAccessorTable
                .ensureFieldAccessorsInitialized(
                    org.apache.submarine.server.api.proto.TritonModelConfig.ModelOptimizationPolicy.Cuda.GraphSpec.Shape.class, org.apache.submarine.server.api.proto.TritonModelConfig.ModelOptimizationPolicy.Cuda.GraphSpec.Shape.Builder.class);
          }

          public static final int DIM_FIELD_NUMBER = 1;
          private com.google.protobuf.Internal.LongList dim_;
          /**
           * <pre>
           *&#64;&#64;        .. cpp:var:: int64 dim (repeated)
           *&#64;&#64;
           *&#64;&#64;           The dimension.
           *&#64;&#64;
           * </pre>
           *
           * <code>repeated int64 dim = 1;</code>
           * @return A list containing the dim.
           */
          @java.lang.Override
          public java.util.List<java.lang.Long>
              getDimList() {
            return dim_;
          }
          /**
           * <pre>
           *&#64;&#64;        .. cpp:var:: int64 dim (repeated)
           *&#64;&#64;
           *&#64;&#64;           The dimension.
           *&#64;&#64;
           * </pre>
           *
           * <code>repeated int64 dim = 1;</code>
           * @return The count of dim.
           */
          public int getDimCount() {
            return dim_.size();
          }
          /**
           * <pre>
           *&#64;&#64;        .. cpp:var:: int64 dim (repeated)
           *&#64;&#64;
           *&#64;&#64;           The dimension.
           *&#64;&#64;
           * </pre>
           *
           * <code>repeated int64 dim = 1;</code>
           * @param index The index of the element to return.
           * @return The dim at the given index.
           */
          public long getDim(int index) {
            return dim_.getLong(index);
          }
          private int dimMemoizedSerializedSize = -1;

          private byte memoizedIsInitialized = -1;
          @java.lang.Override
          public final boolean isInitialized() {
            byte isInitialized = memoizedIsInitialized;
            if (isInitialized == 1) return true;
            if (isInitialized == 0) return false;

            memoizedIsInitialized = 1;
            return true;
          }

          @java.lang.Override
          public void writeTo(com.google.protobuf.CodedOutputStream output)
                              throws java.io.IOException {
            getSerializedSize();
            if (getDimList().size() > 0) {
              output.writeUInt32NoTag(10);
              output.writeUInt32NoTag(dimMemoizedSerializedSize);
            }
            for (int i = 0; i < dim_.size(); i++) {
              output.writeInt64NoTag(dim_.getLong(i));
            }
            unknownFields.writeTo(output);
          }

          @java.lang.Override
          public int getSerializedSize() {
            int size = memoizedSize;
            if (size != -1) return size;

            size = 0;
            {
              int dataSize = 0;
              for (int i = 0; i < dim_.size(); i++) {
                dataSize += com.google.protobuf.CodedOutputStream
                  .computeInt64SizeNoTag(dim_.getLong(i));
              }
              size += dataSize;
              if (!getDimList().isEmpty()) {
                size += 1;
                size += com.google.protobuf.CodedOutputStream
                    .computeInt32SizeNoTag(dataSize);
              }
              dimMemoizedSerializedSize = dataSize;
            }
            size += unknownFields.getSerializedSize();
            memoizedSize = size;
            return size;
          }

          @java.lang.Override
          public boolean equals(final java.lang.Object obj) {
            if (obj == this) {
             return true;
            }
            if (!(obj instanceof org.apache.submarine.server.api.proto.TritonModelConfig.ModelOptimizationPolicy.Cuda.GraphSpec.Shape)) {
              return super.equals(obj);
            }
            org.apache.submarine.server.api.proto.TritonModelConfig.ModelOptimizationPolicy.Cuda.GraphSpec.Shape other = (org.apache.submarine.server.api.proto.TritonModelConfig.ModelOptimizationPolicy.Cuda.GraphSpec.Shape) obj;

            if (!getDimList()
                .equals(other.getDimList())) return false;
            if (!unknownFields.equals(other.unknownFields)) return false;
            return true;
          }

          @java.lang.Override
          public int hashCode() {
            if (memoizedHashCode != 0) {
              return memoizedHashCode;
            }
            int hash = 41;
            hash = (19 * hash) + getDescriptor().hashCode();
            if (getDimCount() > 0) {
              hash = (37 * hash) + DIM_FIELD_NUMBER;
              hash = (53 * hash) + getDimList().hashCode();
            }
            hash = (29 * hash) + unknownFields.hashCode();
            memoizedHashCode = hash;
            return hash;
          }

          public static org.apache.submarine.server.api.proto.TritonModelConfig.ModelOptimizationPolicy.Cuda.GraphSpec.Shape parseFrom(
              java.nio.ByteBuffer data)
              throws com.google.protobuf.InvalidProtocolBufferException {
            return PARSER.parseFrom(data);
          }
          public static org.apache.submarine.server.api.proto.TritonModelConfig.ModelOptimizationPolicy.Cuda.GraphSpec.Shape parseFrom(
              java.nio.ByteBuffer data,
              com.google.protobuf.ExtensionRegistryLite extensionRegistry)
              throws com.google.protobuf.InvalidProtocolBufferException {
            return PARSER.parseFrom(data, extensionRegistry);
          }
          public static org.apache.submarine.server.api.proto.TritonModelConfig.ModelOptimizationPolicy.Cuda.GraphSpec.Shape parseFrom(
              com.google.protobuf.ByteString data)
              throws com.google.protobuf.InvalidProtocolBufferException {
            return PARSER.parseFrom(data);
          }
          public static org.apache.submarine.server.api.proto.TritonModelConfig.ModelOptimizationPolicy.Cuda.GraphSpec.Shape parseFrom(
              com.google.protobuf.ByteString data,
              com.google.protobuf.ExtensionRegistryLite extensionRegistry)
              throws com.google.protobuf.InvalidProtocolBufferException {
            return PARSER.parseFrom(data, extensionRegistry);
          }
          public static org.apache.submarine.server.api.proto.TritonModelConfig.ModelOptimizationPolicy.Cuda.GraphSpec.Shape parseFrom(byte[] data)
              throws com.google.protobuf.InvalidProtocolBufferException {
            return PARSER.parseFrom(data);
          }
          public static org.apache.submarine.server.api.proto.TritonModelConfig.ModelOptimizationPolicy.Cuda.GraphSpec.Shape parseFrom(
              byte[] data,
              com.google.protobuf.ExtensionRegistryLite extensionRegistry)
              throws com.google.protobuf.InvalidProtocolBufferException {
            return PARSER.parseFrom(data, extensionRegistry);
          }
          public static org.apache.submarine.server.api.proto.TritonModelConfig.ModelOptimizationPolicy.Cuda.GraphSpec.Shape parseFrom(java.io.InputStream input)
              throws java.io.IOException {
            return com.google.protobuf.GeneratedMessageV3
                .parseWithIOException(PARSER, input);
          }
          public static org.apache.submarine.server.api.proto.TritonModelConfig.ModelOptimizationPolicy.Cuda.GraphSpec.Shape parseFrom(
              java.io.InputStream input,
              com.google.protobuf.ExtensionRegistryLite extensionRegistry)
              throws java.io.IOException {
            return com.google.protobuf.GeneratedMessageV3
                .parseWithIOException(PARSER, input, extensionRegistry);
          }
          public static org.apache.submarine.server.api.proto.TritonModelConfig.ModelOptimizationPolicy.Cuda.GraphSpec.Shape parseDelimitedFrom(java.io.InputStream input)
              throws java.io.IOException {
            return com.google.protobuf.GeneratedMessageV3
                .parseDelimitedWithIOException(PARSER, input);
          }
          public static org.apache.submarine.server.api.proto.TritonModelConfig.ModelOptimizationPolicy.Cuda.GraphSpec.Shape parseDelimitedFrom(
              java.io.InputStream input,
              com.google.protobuf.ExtensionRegistryLite extensionRegistry)
              throws java.io.IOException {
            return com.google.protobuf.GeneratedMessageV3
                .parseDelimitedWithIOException(PARSER, input, extensionRegistry);
          }
          public static org.apache.submarine.server.api.proto.TritonModelConfig.ModelOptimizationPolicy.Cuda.GraphSpec.Shape parseFrom(
              com.google.protobuf.CodedInputStream input)
              throws java.io.IOException {
            return com.google.protobuf.GeneratedMessageV3
                .parseWithIOException(PARSER, input);
          }
          public static org.apache.submarine.server.api.proto.TritonModelConfig.ModelOptimizationPolicy.Cuda.GraphSpec.Shape parseFrom(
              com.google.protobuf.CodedInputStream input,
              com.google.protobuf.ExtensionRegistryLite extensionRegistry)
              throws java.io.IOException {
            return com.google.protobuf.GeneratedMessageV3
                .parseWithIOException(PARSER, input, extensionRegistry);
          }

          @java.lang.Override
          public Builder newBuilderForType() { return newBuilder(); }
          public static Builder newBuilder() {
            return DEFAULT_INSTANCE.toBuilder();
          }
          public static Builder newBuilder(org.apache.submarine.server.api.proto.TritonModelConfig.ModelOptimizationPolicy.Cuda.GraphSpec.Shape prototype) {
            return DEFAULT_INSTANCE.toBuilder().mergeFrom(prototype);
          }
          @java.lang.Override
          public Builder toBuilder() {
            return this == DEFAULT_INSTANCE
                ? new Builder() : new Builder().mergeFrom(this);
          }

          @java.lang.Override
          protected Builder newBuilderForType(
              com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
            Builder builder = new Builder(parent);
            return builder;
          }
          /**
           * <pre>
           *&#64;&#64;      .. cpp:var:: message Dims
           *&#64;&#64;
           *&#64;&#64;         Specification of tensor dimension.
           *&#64;&#64;
           * </pre>
           *
           * Protobuf type {@code inference.ModelOptimizationPolicy.Cuda.GraphSpec.Shape}
           */
          public static final class Builder extends
              com.google.protobuf.GeneratedMessageV3.Builder<Builder> implements
              // @@protoc_insertion_point(builder_implements:inference.ModelOptimizationPolicy.Cuda.GraphSpec.Shape)
              org.apache.submarine.server.api.proto.TritonModelConfig.ModelOptimizationPolicy.Cuda.GraphSpec.ShapeOrBuilder {
            public static final com.google.protobuf.Descriptors.Descriptor
                getDescriptor() {
              return org.apache.submarine.server.api.proto.TritonModelConfig.internal_static_inference_ModelOptimizationPolicy_Cuda_GraphSpec_Shape_descriptor;
            }

            @java.lang.Override
            protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
                internalGetFieldAccessorTable() {
              return org.apache.submarine.server.api.proto.TritonModelConfig.internal_static_inference_ModelOptimizationPolicy_Cuda_GraphSpec_Shape_fieldAccessorTable
                  .ensureFieldAccessorsInitialized(
                      org.apache.submarine.server.api.proto.TritonModelConfig.ModelOptimizationPolicy.Cuda.GraphSpec.Shape.class, org.apache.submarine.server.api.proto.TritonModelConfig.ModelOptimizationPolicy.Cuda.GraphSpec.Shape.Builder.class);
            }

            // Construct using org.apache.submarine.server.api.proto.TritonModelConfig.ModelOptimizationPolicy.Cuda.GraphSpec.Shape.newBuilder()
            private Builder() {
              maybeForceBuilderInitialization();
            }

            private Builder(
                com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
              super(parent);
              maybeForceBuilderInitialization();
            }
            private void maybeForceBuilderInitialization() {
              if (com.google.protobuf.GeneratedMessageV3
                      .alwaysUseFieldBuilders) {
              }
            }
            @java.lang.Override
            public Builder clear() {
              super.clear();
              dim_ = emptyLongList();
              bitField0_ = (bitField0_ & ~0x00000001);
              return this;
            }

            @java.lang.Override
            public com.google.protobuf.Descriptors.Descriptor
                getDescriptorForType() {
              return org.apache.submarine.server.api.proto.TritonModelConfig.internal_static_inference_ModelOptimizationPolicy_Cuda_GraphSpec_Shape_descriptor;
            }

            @java.lang.Override
            public org.apache.submarine.server.api.proto.TritonModelConfig.ModelOptimizationPolicy.Cuda.GraphSpec.Shape getDefaultInstanceForType() {
              return org.apache.submarine.server.api.proto.TritonModelConfig.ModelOptimizationPolicy.Cuda.GraphSpec.Shape.getDefaultInstance();
            }

            @java.lang.Override
            public org.apache.submarine.server.api.proto.TritonModelConfig.ModelOptimizationPolicy.Cuda.GraphSpec.Shape build() {
              org.apache.submarine.server.api.proto.TritonModelConfig.ModelOptimizationPolicy.Cuda.GraphSpec.Shape result = buildPartial();
              if (!result.isInitialized()) {
                throw newUninitializedMessageException(result);
              }
              return result;
            }

            @java.lang.Override
            public org.apache.submarine.server.api.proto.TritonModelConfig.ModelOptimizationPolicy.Cuda.GraphSpec.Shape buildPartial() {
              org.apache.submarine.server.api.proto.TritonModelConfig.ModelOptimizationPolicy.Cuda.GraphSpec.Shape result = new org.apache.submarine.server.api.proto.TritonModelConfig.ModelOptimizationPolicy.Cuda.GraphSpec.Shape(this);
              int from_bitField0_ = bitField0_;
              if (((bitField0_ & 0x00000001) != 0)) {
                dim_.makeImmutable();
                bitField0_ = (bitField0_ & ~0x00000001);
              }
              result.dim_ = dim_;
              onBuilt();
              return result;
            }

            @java.lang.Override
            public Builder clone() {
              return super.clone();
            }
            @java.lang.Override
            public Builder setField(
                com.google.protobuf.Descriptors.FieldDescriptor field,
                java.lang.Object value) {
              return super.setField(field, value);
            }
            @java.lang.Override
            public Builder clearField(
                com.google.protobuf.Descriptors.FieldDescriptor field) {
              return super.clearField(field);
            }
            @java.lang.Override
            public Builder clearOneof(
                com.google.protobuf.Descriptors.OneofDescriptor oneof) {
              return super.clearOneof(oneof);
            }
            @java.lang.Override
            public Builder setRepeatedField(
                com.google.protobuf.Descriptors.FieldDescriptor field,
                int index, java.lang.Object value) {
              return super.setRepeatedField(field, index, value);
            }
            @java.lang.Override
            public Builder addRepeatedField(
                com.google.protobuf.Descriptors.FieldDescriptor field,
                java.lang.Object value) {
              return super.addRepeatedField(field, value);
            }
            @java.lang.Override
            public Builder mergeFrom(com.google.protobuf.Message other) {
              if (other instanceof org.apache.submarine.server.api.proto.TritonModelConfig.ModelOptimizationPolicy.Cuda.GraphSpec.Shape) {
                return mergeFrom((org.apache.submarine.server.api.proto.TritonModelConfig.ModelOptimizationPolicy.Cuda.GraphSpec.Shape)other);
              } else {
                super.mergeFrom(other);
                return this;
              }
            }

            public Builder mergeFrom(org.apache.submarine.server.api.proto.TritonModelConfig.ModelOptimizationPolicy.Cuda.GraphSpec.Shape other) {
              if (other == org.apache.submarine.server.api.proto.TritonModelConfig.ModelOptimizationPolicy.Cuda.GraphSpec.Shape.getDefaultInstance()) return this;
              if (!other.dim_.isEmpty()) {
                if (dim_.isEmpty()) {
                  dim_ = other.dim_;
                  bitField0_ = (bitField0_ & ~0x00000001);
                } else {
                  ensureDimIsMutable();
                  dim_.addAll(other.dim_);
                }
                onChanged();
              }
              this.mergeUnknownFields(other.unknownFields);
              onChanged();
              return this;
            }

            @java.lang.Override
            public final boolean isInitialized() {
              return true;
            }

            @java.lang.Override
            public Builder mergeFrom(
                com.google.protobuf.CodedInputStream input,
                com.google.protobuf.ExtensionRegistryLite extensionRegistry)
                throws java.io.IOException {
              org.apache.submarine.server.api.proto.TritonModelConfig.ModelOptimizationPolicy.Cuda.GraphSpec.Shape parsedMessage = null;
              try {
                parsedMessage = PARSER.parsePartialFrom(input, extensionRegistry);
              } catch (com.google.protobuf.InvalidProtocolBufferException e) {
                parsedMessage = (org.apache.submarine.server.api.proto.TritonModelConfig.ModelOptimizationPolicy.Cuda.GraphSpec.Shape) e.getUnfinishedMessage();
                throw e.unwrapIOException();
              } finally {
                if (parsedMessage != null) {
                  mergeFrom(parsedMessage);
                }
              }
              return this;
            }
            private int bitField0_;

            private com.google.protobuf.Internal.LongList dim_ = emptyLongList();
            private void ensureDimIsMutable() {
              if (!((bitField0_ & 0x00000001) != 0)) {
                dim_ = mutableCopy(dim_);
                bitField0_ |= 0x00000001;
               }
            }
            /**
             * <pre>
             *&#64;&#64;        .. cpp:var:: int64 dim (repeated)
             *&#64;&#64;
             *&#64;&#64;           The dimension.
             *&#64;&#64;
             * </pre>
             *
             * <code>repeated int64 dim = 1;</code>
             * @return A list containing the dim.
             */
            public java.util.List<java.lang.Long>
                getDimList() {
              return ((bitField0_ & 0x00000001) != 0) ?
                       java.util.Collections.unmodifiableList(dim_) : dim_;
            }
            /**
             * <pre>
             *&#64;&#64;        .. cpp:var:: int64 dim (repeated)
             *&#64;&#64;
             *&#64;&#64;           The dimension.
             *&#64;&#64;
             * </pre>
             *
             * <code>repeated int64 dim = 1;</code>
             * @return The count of dim.
             */
            public int getDimCount() {
              return dim_.size();
            }
            /**
             * <pre>
             *&#64;&#64;        .. cpp:var:: int64 dim (repeated)
             *&#64;&#64;
             *&#64;&#64;           The dimension.
             *&#64;&#64;
             * </pre>
             *
             * <code>repeated int64 dim = 1;</code>
             * @param index The index of the element to return.
             * @return The dim at the given index.
             */
            public long getDim(int index) {
              return dim_.getLong(index);
            }
            /**
             * <pre>
             *&#64;&#64;        .. cpp:var:: int64 dim (repeated)
             *&#64;&#64;
             *&#64;&#64;           The dimension.
             *&#64;&#64;
             * </pre>
             *
             * <code>repeated int64 dim = 1;</code>
             * @param index The index to set the value at.
             * @param value The dim to set.
             * @return This builder for chaining.
             */
            public Builder setDim(
                int index, long value) {
              ensureDimIsMutable();
              dim_.setLong(index, value);
              onChanged();
              return this;
            }
            /**
             * <pre>
             *&#64;&#64;        .. cpp:var:: int64 dim (repeated)
             *&#64;&#64;
             *&#64;&#64;           The dimension.
             *&#64;&#64;
             * </pre>
             *
             * <code>repeated int64 dim = 1;</code>
             * @param value The dim to add.
             * @return This builder for chaining.
             */
            public Builder addDim(long value) {
              ensureDimIsMutable();
              dim_.addLong(value);
              onChanged();
              return this;
            }
            /**
             * <pre>
             *&#64;&#64;        .. cpp:var:: int64 dim (repeated)
             *&#64;&#64;
             *&#64;&#64;           The dimension.
             *&#64;&#64;
             * </pre>
             *
             * <code>repeated int64 dim = 1;</code>
             * @param values The dim to add.
             * @return This builder for chaining.
             */
            public Builder addAllDim(
                java.lang.Iterable<? extends java.lang.Long> values) {
              ensureDimIsMutable();
              com.google.protobuf.AbstractMessageLite.Builder.addAll(
                  values, dim_);
              onChanged();
              return this;
            }
            /**
             * <pre>
             *&#64;&#64;        .. cpp:var:: int64 dim (repeated)
             *&#64;&#64;
             *&#64;&#64;           The dimension.
             *&#64;&#64;
             * </pre>
             *
             * <code>repeated int64 dim = 1;</code>
             * @return This builder for chaining.
             */
            public Builder clearDim() {
              dim_ = emptyLongList();
              bitField0_ = (bitField0_ & ~0x00000001);
              onChanged();
              return this;
            }
            @java.lang.Override
            public final Builder setUnknownFields(
                final com.google.protobuf.UnknownFieldSet unknownFields) {
              return super.setUnknownFields(unknownFields);
            }

            @java.lang.Override
            public final Builder mergeUnknownFields(
                final com.google.protobuf.UnknownFieldSet unknownFields) {
              return super.mergeUnknownFields(unknownFields);
            }


            // @@protoc_insertion_point(builder_scope:inference.ModelOptimizationPolicy.Cuda.GraphSpec.Shape)
          }

          // @@protoc_insertion_point(class_scope:inference.ModelOptimizationPolicy.Cuda.GraphSpec.Shape)
          private static final org.apache.submarine.server.api.proto.TritonModelConfig.ModelOptimizationPolicy.Cuda.GraphSpec.Shape DEFAULT_INSTANCE;
          static {
            DEFAULT_INSTANCE = new org.apache.submarine.server.api.proto.TritonModelConfig.ModelOptimizationPolicy.Cuda.GraphSpec.Shape();
          }

          public static org.apache.submarine.server.api.proto.TritonModelConfig.ModelOptimizationPolicy.Cuda.GraphSpec.Shape getDefaultInstance() {
            return DEFAULT_INSTANCE;
          }

          private static final com.google.protobuf.Parser<Shape>
              PARSER = new com.google.protobuf.AbstractParser<Shape>() {
            @java.lang.Override
            public Shape parsePartialFrom(
                com.google.protobuf.CodedInputStream input,
                com.google.protobuf.ExtensionRegistryLite extensionRegistry)
                throws com.google.protobuf.InvalidProtocolBufferException {
              return new Shape(input, extensionRegistry);
            }
          };

          public static com.google.protobuf.Parser<Shape> parser() {
            return PARSER;
          }

          @java.lang.Override
          public com.google.protobuf.Parser<Shape> getParserForType() {
            return PARSER;
          }

          @java.lang.Override
          public org.apache.submarine.server.api.proto.TritonModelConfig.ModelOptimizationPolicy.Cuda.GraphSpec.Shape getDefaultInstanceForType() {
            return DEFAULT_INSTANCE;
          }

        }

        public interface LowerBoundOrBuilder extends
            // @@protoc_insertion_point(interface_extends:inference.ModelOptimizationPolicy.Cuda.GraphSpec.LowerBound)
            com.google.protobuf.MessageOrBuilder {

          /**
           * <pre>
           *&#64;&#64;      .. cpp:var:: int32 batch_size
           *&#64;&#64;
           *&#64;&#64;         The batch size of the CUDA graph. If 'max_batch_size' is 0,
           *&#64;&#64;         'batch_size' must be set to 0. Otherwise, 'batch_size' must
           *&#64;&#64;         be set to value between 1 and 'max_batch_size'.
           *&#64;&#64;
           * </pre>
           *
           * <code>int32 batch_size = 1;</code>
           * @return The batchSize.
           */
          int getBatchSize();

          /**
           * <pre>
           *&#64;&#64;      .. cpp:var:: map&lt;string, Shape&gt; input
           *&#64;&#64;
           *&#64;&#64;         The specification of the inputs. 'Shape' is the shape of
           *&#64;&#64;         the input without batching dimension.
           *&#64;&#64;
           * </pre>
           *
           * <code>map&lt;string, .inference.ModelOptimizationPolicy.Cuda.GraphSpec.Shape&gt; input = 2;</code>
           */
          int getInputCount();
          /**
           * <pre>
           *&#64;&#64;      .. cpp:var:: map&lt;string, Shape&gt; input
           *&#64;&#64;
           *&#64;&#64;         The specification of the inputs. 'Shape' is the shape of
           *&#64;&#64;         the input without batching dimension.
           *&#64;&#64;
           * </pre>
           *
           * <code>map&lt;string, .inference.ModelOptimizationPolicy.Cuda.GraphSpec.Shape&gt; input = 2;</code>
           */
          boolean containsInput(
              java.lang.String key);
          /**
           * Use {@link #getInputMap()} instead.
           */
          @java.lang.Deprecated
          java.util.Map<java.lang.String, org.apache.submarine.server.api.proto.TritonModelConfig.ModelOptimizationPolicy.Cuda.GraphSpec.Shape>
          getInput();
          /**
           * <pre>
           *&#64;&#64;      .. cpp:var:: map&lt;string, Shape&gt; input
           *&#64;&#64;
           *&#64;&#64;         The specification of the inputs. 'Shape' is the shape of
           *&#64;&#64;         the input without batching dimension.
           *&#64;&#64;
           * </pre>
           *
           * <code>map&lt;string, .inference.ModelOptimizationPolicy.Cuda.GraphSpec.Shape&gt; input = 2;</code>
           */
          java.util.Map<java.lang.String, org.apache.submarine.server.api.proto.TritonModelConfig.ModelOptimizationPolicy.Cuda.GraphSpec.Shape>
          getInputMap();
          /**
           * <pre>
           *&#64;&#64;      .. cpp:var:: map&lt;string, Shape&gt; input
           *&#64;&#64;
           *&#64;&#64;         The specification of the inputs. 'Shape' is the shape of
           *&#64;&#64;         the input without batching dimension.
           *&#64;&#64;
           * </pre>
           *
           * <code>map&lt;string, .inference.ModelOptimizationPolicy.Cuda.GraphSpec.Shape&gt; input = 2;</code>
           */

          org.apache.submarine.server.api.proto.TritonModelConfig.ModelOptimizationPolicy.Cuda.GraphSpec.Shape getInputOrDefault(
              java.lang.String key,
              org.apache.submarine.server.api.proto.TritonModelConfig.ModelOptimizationPolicy.Cuda.GraphSpec.Shape defaultValue);
          /**
           * <pre>
           *&#64;&#64;      .. cpp:var:: map&lt;string, Shape&gt; input
           *&#64;&#64;
           *&#64;&#64;         The specification of the inputs. 'Shape' is the shape of
           *&#64;&#64;         the input without batching dimension.
           *&#64;&#64;
           * </pre>
           *
           * <code>map&lt;string, .inference.ModelOptimizationPolicy.Cuda.GraphSpec.Shape&gt; input = 2;</code>
           */

          org.apache.submarine.server.api.proto.TritonModelConfig.ModelOptimizationPolicy.Cuda.GraphSpec.Shape getInputOrThrow(
              java.lang.String key);
        }
        /**
         * Protobuf type {@code inference.ModelOptimizationPolicy.Cuda.GraphSpec.LowerBound}
         */
        public static final class LowerBound extends
            com.google.protobuf.GeneratedMessageV3 implements
            // @@protoc_insertion_point(message_implements:inference.ModelOptimizationPolicy.Cuda.GraphSpec.LowerBound)
            LowerBoundOrBuilder {
        private static final long serialVersionUID = 0L;
          // Use LowerBound.newBuilder() to construct.
          private LowerBound(com.google.protobuf.GeneratedMessageV3.Builder<?> builder) {
            super(builder);
          }
          private LowerBound() {
          }

          @java.lang.Override
          @SuppressWarnings({"unused"})
          protected java.lang.Object newInstance(
              UnusedPrivateParameter unused) {
            return new LowerBound();
          }

          @java.lang.Override
          public final com.google.protobuf.UnknownFieldSet
          getUnknownFields() {
            return this.unknownFields;
          }
          private LowerBound(
              com.google.protobuf.CodedInputStream input,
              com.google.protobuf.ExtensionRegistryLite extensionRegistry)
              throws com.google.protobuf.InvalidProtocolBufferException {
            this();
            if (extensionRegistry == null) {
              throw new java.lang.NullPointerException();
            }
            int mutable_bitField0_ = 0;
            com.google.protobuf.UnknownFieldSet.Builder unknownFields =
                com.google.protobuf.UnknownFieldSet.newBuilder();
            try {
              boolean done = false;
              while (!done) {
                int tag = input.readTag();
                switch (tag) {
                  case 0:
                    done = true;
                    break;
                  case 8: {

                    batchSize_ = input.readInt32();
                    break;
                  }
                  case 18: {
                    if (!((mutable_bitField0_ & 0x00000001) != 0)) {
                      input_ = com.google.protobuf.MapField.newMapField(
                          InputDefaultEntryHolder.defaultEntry);
                      mutable_bitField0_ |= 0x00000001;
                    }
                    com.google.protobuf.MapEntry<java.lang.String, org.apache.submarine.server.api.proto.TritonModelConfig.ModelOptimizationPolicy.Cuda.GraphSpec.Shape>
                    input__ = input.readMessage(
                        InputDefaultEntryHolder.defaultEntry.getParserForType(), extensionRegistry);
                    input_.getMutableMap().put(
                        input__.getKey(), input__.getValue());
                    break;
                  }
                  default: {
                    if (!parseUnknownField(
                        input, unknownFields, extensionRegistry, tag)) {
                      done = true;
                    }
                    break;
                  }
                }
              }
            } catch (com.google.protobuf.InvalidProtocolBufferException e) {
              throw e.setUnfinishedMessage(this);
            } catch (java.io.IOException e) {
              throw new com.google.protobuf.InvalidProtocolBufferException(
                  e).setUnfinishedMessage(this);
            } finally {
              this.unknownFields = unknownFields.build();
              makeExtensionsImmutable();
            }
          }
          public static final com.google.protobuf.Descriptors.Descriptor
              getDescriptor() {
            return org.apache.submarine.server.api.proto.TritonModelConfig.internal_static_inference_ModelOptimizationPolicy_Cuda_GraphSpec_LowerBound_descriptor;
          }

          @SuppressWarnings({"rawtypes"})
          @java.lang.Override
          protected com.google.protobuf.MapField internalGetMapField(
              int number) {
            switch (number) {
              case 2:
                return internalGetInput();
              default:
                throw new RuntimeException(
                    "Invalid map field number: " + number);
            }
          }
          @java.lang.Override
          protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
              internalGetFieldAccessorTable() {
            return org.apache.submarine.server.api.proto.TritonModelConfig.internal_static_inference_ModelOptimizationPolicy_Cuda_GraphSpec_LowerBound_fieldAccessorTable
                .ensureFieldAccessorsInitialized(
                    org.apache.submarine.server.api.proto.TritonModelConfig.ModelOptimizationPolicy.Cuda.GraphSpec.LowerBound.class, org.apache.submarine.server.api.proto.TritonModelConfig.ModelOptimizationPolicy.Cuda.GraphSpec.LowerBound.Builder.class);
          }

          public static final int BATCH_SIZE_FIELD_NUMBER = 1;
          private int batchSize_;
          /**
           * <pre>
           *&#64;&#64;      .. cpp:var:: int32 batch_size
           *&#64;&#64;
           *&#64;&#64;         The batch size of the CUDA graph. If 'max_batch_size' is 0,
           *&#64;&#64;         'batch_size' must be set to 0. Otherwise, 'batch_size' must
           *&#64;&#64;         be set to value between 1 and 'max_batch_size'.
           *&#64;&#64;
           * </pre>
           *
           * <code>int32 batch_size = 1;</code>
           * @return The batchSize.
           */
          @java.lang.Override
          public int getBatchSize() {
            return batchSize_;
          }

          public static final int INPUT_FIELD_NUMBER = 2;
          private static final class InputDefaultEntryHolder {
            static final com.google.protobuf.MapEntry<
                java.lang.String, org.apache.submarine.server.api.proto.TritonModelConfig.ModelOptimizationPolicy.Cuda.GraphSpec.Shape> defaultEntry =
                    com.google.protobuf.MapEntry
                    .<java.lang.String, org.apache.submarine.server.api.proto.TritonModelConfig.ModelOptimizationPolicy.Cuda.GraphSpec.Shape>newDefaultInstance(
                        org.apache.submarine.server.api.proto.TritonModelConfig.internal_static_inference_ModelOptimizationPolicy_Cuda_GraphSpec_LowerBound_InputEntry_descriptor, 
                        com.google.protobuf.WireFormat.FieldType.STRING,
                        "",
                        com.google.protobuf.WireFormat.FieldType.MESSAGE,
                        org.apache.submarine.server.api.proto.TritonModelConfig.ModelOptimizationPolicy.Cuda.GraphSpec.Shape.getDefaultInstance());
          }
          private com.google.protobuf.MapField<
              java.lang.String, org.apache.submarine.server.api.proto.TritonModelConfig.ModelOptimizationPolicy.Cuda.GraphSpec.Shape> input_;
          private com.google.protobuf.MapField<java.lang.String, org.apache.submarine.server.api.proto.TritonModelConfig.ModelOptimizationPolicy.Cuda.GraphSpec.Shape>
          internalGetInput() {
            if (input_ == null) {
              return com.google.protobuf.MapField.emptyMapField(
                  InputDefaultEntryHolder.defaultEntry);
            }
            return input_;
          }

          public int getInputCount() {
            return internalGetInput().getMap().size();
          }
          /**
           * <pre>
           *&#64;&#64;      .. cpp:var:: map&lt;string, Shape&gt; input
           *&#64;&#64;
           *&#64;&#64;         The specification of the inputs. 'Shape' is the shape of
           *&#64;&#64;         the input without batching dimension.
           *&#64;&#64;
           * </pre>
           *
           * <code>map&lt;string, .inference.ModelOptimizationPolicy.Cuda.GraphSpec.Shape&gt; input = 2;</code>
           */

          @java.lang.Override
          public boolean containsInput(
              java.lang.String key) {
            if (key == null) { throw new java.lang.NullPointerException(); }
            return internalGetInput().getMap().containsKey(key);
          }
          /**
           * Use {@link #getInputMap()} instead.
           */
          @java.lang.Override
          @java.lang.Deprecated
          public java.util.Map<java.lang.String, org.apache.submarine.server.api.proto.TritonModelConfig.ModelOptimizationPolicy.Cuda.GraphSpec.Shape> getInput() {
            return getInputMap();
          }
          /**
           * <pre>
           *&#64;&#64;      .. cpp:var:: map&lt;string, Shape&gt; input
           *&#64;&#64;
           *&#64;&#64;         The specification of the inputs. 'Shape' is the shape of
           *&#64;&#64;         the input without batching dimension.
           *&#64;&#64;
           * </pre>
           *
           * <code>map&lt;string, .inference.ModelOptimizationPolicy.Cuda.GraphSpec.Shape&gt; input = 2;</code>
           */
          @java.lang.Override

          public java.util.Map<java.lang.String, org.apache.submarine.server.api.proto.TritonModelConfig.ModelOptimizationPolicy.Cuda.GraphSpec.Shape> getInputMap() {
            return internalGetInput().getMap();
          }
          /**
           * <pre>
           *&#64;&#64;      .. cpp:var:: map&lt;string, Shape&gt; input
           *&#64;&#64;
           *&#64;&#64;         The specification of the inputs. 'Shape' is the shape of
           *&#64;&#64;         the input without batching dimension.
           *&#64;&#64;
           * </pre>
           *
           * <code>map&lt;string, .inference.ModelOptimizationPolicy.Cuda.GraphSpec.Shape&gt; input = 2;</code>
           */
          @java.lang.Override

          public org.apache.submarine.server.api.proto.TritonModelConfig.ModelOptimizationPolicy.Cuda.GraphSpec.Shape getInputOrDefault(
              java.lang.String key,
              org.apache.submarine.server.api.proto.TritonModelConfig.ModelOptimizationPolicy.Cuda.GraphSpec.Shape defaultValue) {
            if (key == null) { throw new java.lang.NullPointerException(); }
            java.util.Map<java.lang.String, org.apache.submarine.server.api.proto.TritonModelConfig.ModelOptimizationPolicy.Cuda.GraphSpec.Shape> map =
                internalGetInput().getMap();
            return map.containsKey(key) ? map.get(key) : defaultValue;
          }
          /**
           * <pre>
           *&#64;&#64;      .. cpp:var:: map&lt;string, Shape&gt; input
           *&#64;&#64;
           *&#64;&#64;         The specification of the inputs. 'Shape' is the shape of
           *&#64;&#64;         the input without batching dimension.
           *&#64;&#64;
           * </pre>
           *
           * <code>map&lt;string, .inference.ModelOptimizationPolicy.Cuda.GraphSpec.Shape&gt; input = 2;</code>
           */
          @java.lang.Override

          public org.apache.submarine.server.api.proto.TritonModelConfig.ModelOptimizationPolicy.Cuda.GraphSpec.Shape getInputOrThrow(
              java.lang.String key) {
            if (key == null) { throw new java.lang.NullPointerException(); }
            java.util.Map<java.lang.String, org.apache.submarine.server.api.proto.TritonModelConfig.ModelOptimizationPolicy.Cuda.GraphSpec.Shape> map =
                internalGetInput().getMap();
            if (!map.containsKey(key)) {
              throw new java.lang.IllegalArgumentException();
            }
            return map.get(key);
          }

          private byte memoizedIsInitialized = -1;
          @java.lang.Override
          public final boolean isInitialized() {
            byte isInitialized = memoizedIsInitialized;
            if (isInitialized == 1) return true;
            if (isInitialized == 0) return false;

            memoizedIsInitialized = 1;
            return true;
          }

          @java.lang.Override
          public void writeTo(com.google.protobuf.CodedOutputStream output)
                              throws java.io.IOException {
            if (batchSize_ != 0) {
              output.writeInt32(1, batchSize_);
            }
            com.google.protobuf.GeneratedMessageV3
              .serializeStringMapTo(
                output,
                internalGetInput(),
                InputDefaultEntryHolder.defaultEntry,
                2);
            unknownFields.writeTo(output);
          }

          @java.lang.Override
          public int getSerializedSize() {
            int size = memoizedSize;
            if (size != -1) return size;

            size = 0;
            if (batchSize_ != 0) {
              size += com.google.protobuf.CodedOutputStream
                .computeInt32Size(1, batchSize_);
            }
            for (java.util.Map.Entry<java.lang.String, org.apache.submarine.server.api.proto.TritonModelConfig.ModelOptimizationPolicy.Cuda.GraphSpec.Shape> entry
                 : internalGetInput().getMap().entrySet()) {
              com.google.protobuf.MapEntry<java.lang.String, org.apache.submarine.server.api.proto.TritonModelConfig.ModelOptimizationPolicy.Cuda.GraphSpec.Shape>
              input__ = InputDefaultEntryHolder.defaultEntry.newBuilderForType()
                  .setKey(entry.getKey())
                  .setValue(entry.getValue())
                  .build();
              size += com.google.protobuf.CodedOutputStream
                  .computeMessageSize(2, input__);
            }
            size += unknownFields.getSerializedSize();
            memoizedSize = size;
            return size;
          }

          @java.lang.Override
          public boolean equals(final java.lang.Object obj) {
            if (obj == this) {
             return true;
            }
            if (!(obj instanceof org.apache.submarine.server.api.proto.TritonModelConfig.ModelOptimizationPolicy.Cuda.GraphSpec.LowerBound)) {
              return super.equals(obj);
            }
            org.apache.submarine.server.api.proto.TritonModelConfig.ModelOptimizationPolicy.Cuda.GraphSpec.LowerBound other = (org.apache.submarine.server.api.proto.TritonModelConfig.ModelOptimizationPolicy.Cuda.GraphSpec.LowerBound) obj;

            if (getBatchSize()
                != other.getBatchSize()) return false;
            if (!internalGetInput().equals(
                other.internalGetInput())) return false;
            if (!unknownFields.equals(other.unknownFields)) return false;
            return true;
          }

          @java.lang.Override
          public int hashCode() {
            if (memoizedHashCode != 0) {
              return memoizedHashCode;
            }
            int hash = 41;
            hash = (19 * hash) + getDescriptor().hashCode();
            hash = (37 * hash) + BATCH_SIZE_FIELD_NUMBER;
            hash = (53 * hash) + getBatchSize();
            if (!internalGetInput().getMap().isEmpty()) {
              hash = (37 * hash) + INPUT_FIELD_NUMBER;
              hash = (53 * hash) + internalGetInput().hashCode();
            }
            hash = (29 * hash) + unknownFields.hashCode();
            memoizedHashCode = hash;
            return hash;
          }

          public static org.apache.submarine.server.api.proto.TritonModelConfig.ModelOptimizationPolicy.Cuda.GraphSpec.LowerBound parseFrom(
              java.nio.ByteBuffer data)
              throws com.google.protobuf.InvalidProtocolBufferException {
            return PARSER.parseFrom(data);
          }
          public static org.apache.submarine.server.api.proto.TritonModelConfig.ModelOptimizationPolicy.Cuda.GraphSpec.LowerBound parseFrom(
              java.nio.ByteBuffer data,
              com.google.protobuf.ExtensionRegistryLite extensionRegistry)
              throws com.google.protobuf.InvalidProtocolBufferException {
            return PARSER.parseFrom(data, extensionRegistry);
          }
          public static org.apache.submarine.server.api.proto.TritonModelConfig.ModelOptimizationPolicy.Cuda.GraphSpec.LowerBound parseFrom(
              com.google.protobuf.ByteString data)
              throws com.google.protobuf.InvalidProtocolBufferException {
            return PARSER.parseFrom(data);
          }
          public static org.apache.submarine.server.api.proto.TritonModelConfig.ModelOptimizationPolicy.Cuda.GraphSpec.LowerBound parseFrom(
              com.google.protobuf.ByteString data,
              com.google.protobuf.ExtensionRegistryLite extensionRegistry)
              throws com.google.protobuf.InvalidProtocolBufferException {
            return PARSER.parseFrom(data, extensionRegistry);
          }
          public static org.apache.submarine.server.api.proto.TritonModelConfig.ModelOptimizationPolicy.Cuda.GraphSpec.LowerBound parseFrom(byte[] data)
              throws com.google.protobuf.InvalidProtocolBufferException {
            return PARSER.parseFrom(data);
          }
          public static org.apache.submarine.server.api.proto.TritonModelConfig.ModelOptimizationPolicy.Cuda.GraphSpec.LowerBound parseFrom(
              byte[] data,
              com.google.protobuf.ExtensionRegistryLite extensionRegistry)
              throws com.google.protobuf.InvalidProtocolBufferException {
            return PARSER.parseFrom(data, extensionRegistry);
          }
          public static org.apache.submarine.server.api.proto.TritonModelConfig.ModelOptimizationPolicy.Cuda.GraphSpec.LowerBound parseFrom(java.io.InputStream input)
              throws java.io.IOException {
            return com.google.protobuf.GeneratedMessageV3
                .parseWithIOException(PARSER, input);
          }
          public static org.apache.submarine.server.api.proto.TritonModelConfig.ModelOptimizationPolicy.Cuda.GraphSpec.LowerBound parseFrom(
              java.io.InputStream input,
              com.google.protobuf.ExtensionRegistryLite extensionRegistry)
              throws java.io.IOException {
            return com.google.protobuf.GeneratedMessageV3
                .parseWithIOException(PARSER, input, extensionRegistry);
          }
          public static org.apache.submarine.server.api.proto.TritonModelConfig.ModelOptimizationPolicy.Cuda.GraphSpec.LowerBound parseDelimitedFrom(java.io.InputStream input)
              throws java.io.IOException {
            return com.google.protobuf.GeneratedMessageV3
                .parseDelimitedWithIOException(PARSER, input);
          }
          public static org.apache.submarine.server.api.proto.TritonModelConfig.ModelOptimizationPolicy.Cuda.GraphSpec.LowerBound parseDelimitedFrom(
              java.io.InputStream input,
              com.google.protobuf.ExtensionRegistryLite extensionRegistry)
              throws java.io.IOException {
            return com.google.protobuf.GeneratedMessageV3
                .parseDelimitedWithIOException(PARSER, input, extensionRegistry);
          }
          public static org.apache.submarine.server.api.proto.TritonModelConfig.ModelOptimizationPolicy.Cuda.GraphSpec.LowerBound parseFrom(
              com.google.protobuf.CodedInputStream input)
              throws java.io.IOException {
            return com.google.protobuf.GeneratedMessageV3
                .parseWithIOException(PARSER, input);
          }
          public static org.apache.submarine.server.api.proto.TritonModelConfig.ModelOptimizationPolicy.Cuda.GraphSpec.LowerBound parseFrom(
              com.google.protobuf.CodedInputStream input,
              com.google.protobuf.ExtensionRegistryLite extensionRegistry)
              throws java.io.IOException {
            return com.google.protobuf.GeneratedMessageV3
                .parseWithIOException(PARSER, input, extensionRegistry);
          }

          @java.lang.Override
          public Builder newBuilderForType() { return newBuilder(); }
          public static Builder newBuilder() {
            return DEFAULT_INSTANCE.toBuilder();
          }
          public static Builder newBuilder(org.apache.submarine.server.api.proto.TritonModelConfig.ModelOptimizationPolicy.Cuda.GraphSpec.LowerBound prototype) {
            return DEFAULT_INSTANCE.toBuilder().mergeFrom(prototype);
          }
          @java.lang.Override
          public Builder toBuilder() {
            return this == DEFAULT_INSTANCE
                ? new Builder() : new Builder().mergeFrom(this);
          }

          @java.lang.Override
          protected Builder newBuilderForType(
              com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
            Builder builder = new Builder(parent);
            return builder;
          }
          /**
           * Protobuf type {@code inference.ModelOptimizationPolicy.Cuda.GraphSpec.LowerBound}
           */
          public static final class Builder extends
              com.google.protobuf.GeneratedMessageV3.Builder<Builder> implements
              // @@protoc_insertion_point(builder_implements:inference.ModelOptimizationPolicy.Cuda.GraphSpec.LowerBound)
              org.apache.submarine.server.api.proto.TritonModelConfig.ModelOptimizationPolicy.Cuda.GraphSpec.LowerBoundOrBuilder {
            public static final com.google.protobuf.Descriptors.Descriptor
                getDescriptor() {
              return org.apache.submarine.server.api.proto.TritonModelConfig.internal_static_inference_ModelOptimizationPolicy_Cuda_GraphSpec_LowerBound_descriptor;
            }

            @SuppressWarnings({"rawtypes"})
            protected com.google.protobuf.MapField internalGetMapField(
                int number) {
              switch (number) {
                case 2:
                  return internalGetInput();
                default:
                  throw new RuntimeException(
                      "Invalid map field number: " + number);
              }
            }
            @SuppressWarnings({"rawtypes"})
            protected com.google.protobuf.MapField internalGetMutableMapField(
                int number) {
              switch (number) {
                case 2:
                  return internalGetMutableInput();
                default:
                  throw new RuntimeException(
                      "Invalid map field number: " + number);
              }
            }
            @java.lang.Override
            protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
                internalGetFieldAccessorTable() {
              return org.apache.submarine.server.api.proto.TritonModelConfig.internal_static_inference_ModelOptimizationPolicy_Cuda_GraphSpec_LowerBound_fieldAccessorTable
                  .ensureFieldAccessorsInitialized(
                      org.apache.submarine.server.api.proto.TritonModelConfig.ModelOptimizationPolicy.Cuda.GraphSpec.LowerBound.class, org.apache.submarine.server.api.proto.TritonModelConfig.ModelOptimizationPolicy.Cuda.GraphSpec.LowerBound.Builder.class);
            }

            // Construct using org.apache.submarine.server.api.proto.TritonModelConfig.ModelOptimizationPolicy.Cuda.GraphSpec.LowerBound.newBuilder()
            private Builder() {
              maybeForceBuilderInitialization();
            }

            private Builder(
                com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
              super(parent);
              maybeForceBuilderInitialization();
            }
            private void maybeForceBuilderInitialization() {
              if (com.google.protobuf.GeneratedMessageV3
                      .alwaysUseFieldBuilders) {
              }
            }
            @java.lang.Override
            public Builder clear() {
              super.clear();
              batchSize_ = 0;

              internalGetMutableInput().clear();
              return this;
            }

            @java.lang.Override
            public com.google.protobuf.Descriptors.Descriptor
                getDescriptorForType() {
              return org.apache.submarine.server.api.proto.TritonModelConfig.internal_static_inference_ModelOptimizationPolicy_Cuda_GraphSpec_LowerBound_descriptor;
            }

            @java.lang.Override
            public org.apache.submarine.server.api.proto.TritonModelConfig.ModelOptimizationPolicy.Cuda.GraphSpec.LowerBound getDefaultInstanceForType() {
              return org.apache.submarine.server.api.proto.TritonModelConfig.ModelOptimizationPolicy.Cuda.GraphSpec.LowerBound.getDefaultInstance();
            }

            @java.lang.Override
            public org.apache.submarine.server.api.proto.TritonModelConfig.ModelOptimizationPolicy.Cuda.GraphSpec.LowerBound build() {
              org.apache.submarine.server.api.proto.TritonModelConfig.ModelOptimizationPolicy.Cuda.GraphSpec.LowerBound result = buildPartial();
              if (!result.isInitialized()) {
                throw newUninitializedMessageException(result);
              }
              return result;
            }

            @java.lang.Override
            public org.apache.submarine.server.api.proto.TritonModelConfig.ModelOptimizationPolicy.Cuda.GraphSpec.LowerBound buildPartial() {
              org.apache.submarine.server.api.proto.TritonModelConfig.ModelOptimizationPolicy.Cuda.GraphSpec.LowerBound result = new org.apache.submarine.server.api.proto.TritonModelConfig.ModelOptimizationPolicy.Cuda.GraphSpec.LowerBound(this);
              int from_bitField0_ = bitField0_;
              result.batchSize_ = batchSize_;
              result.input_ = internalGetInput();
              result.input_.makeImmutable();
              onBuilt();
              return result;
            }

            @java.lang.Override
            public Builder clone() {
              return super.clone();
            }
            @java.lang.Override
            public Builder setField(
                com.google.protobuf.Descriptors.FieldDescriptor field,
                java.lang.Object value) {
              return super.setField(field, value);
            }
            @java.lang.Override
            public Builder clearField(
                com.google.protobuf.Descriptors.FieldDescriptor field) {
              return super.clearField(field);
            }
            @java.lang.Override
            public Builder clearOneof(
                com.google.protobuf.Descriptors.OneofDescriptor oneof) {
              return super.clearOneof(oneof);
            }
            @java.lang.Override
            public Builder setRepeatedField(
                com.google.protobuf.Descriptors.FieldDescriptor field,
                int index, java.lang.Object value) {
              return super.setRepeatedField(field, index, value);
            }
            @java.lang.Override
            public Builder addRepeatedField(
                com.google.protobuf.Descriptors.FieldDescriptor field,
                java.lang.Object value) {
              return super.addRepeatedField(field, value);
            }
            @java.lang.Override
            public Builder mergeFrom(com.google.protobuf.Message other) {
              if (other instanceof org.apache.submarine.server.api.proto.TritonModelConfig.ModelOptimizationPolicy.Cuda.GraphSpec.LowerBound) {
                return mergeFrom((org.apache.submarine.server.api.proto.TritonModelConfig.ModelOptimizationPolicy.Cuda.GraphSpec.LowerBound)other);
              } else {
                super.mergeFrom(other);
                return this;
              }
            }

            public Builder mergeFrom(org.apache.submarine.server.api.proto.TritonModelConfig.ModelOptimizationPolicy.Cuda.GraphSpec.LowerBound other) {
              if (other == org.apache.submarine.server.api.proto.TritonModelConfig.ModelOptimizationPolicy.Cuda.GraphSpec.LowerBound.getDefaultInstance()) return this;
              if (other.getBatchSize() != 0) {
                setBatchSize(other.getBatchSize());
              }
              internalGetMutableInput().mergeFrom(
                  other.internalGetInput());
              this.mergeUnknownFields(other.unknownFields);
              onChanged();
              return this;
            }

            @java.lang.Override
            public final boolean isInitialized() {
              return true;
            }

            @java.lang.Override
            public Builder mergeFrom(
                com.google.protobuf.CodedInputStream input,
                com.google.protobuf.ExtensionRegistryLite extensionRegistry)
                throws java.io.IOException {
              org.apache.submarine.server.api.proto.TritonModelConfig.ModelOptimizationPolicy.Cuda.GraphSpec.LowerBound parsedMessage = null;
              try {
                parsedMessage = PARSER.parsePartialFrom(input, extensionRegistry);
              } catch (com.google.protobuf.InvalidProtocolBufferException e) {
                parsedMessage = (org.apache.submarine.server.api.proto.TritonModelConfig.ModelOptimizationPolicy.Cuda.GraphSpec.LowerBound) e.getUnfinishedMessage();
                throw e.unwrapIOException();
              } finally {
                if (parsedMessage != null) {
                  mergeFrom(parsedMessage);
                }
              }
              return this;
            }
            private int bitField0_;

            private int batchSize_ ;
            /**
             * <pre>
             *&#64;&#64;      .. cpp:var:: int32 batch_size
             *&#64;&#64;
             *&#64;&#64;         The batch size of the CUDA graph. If 'max_batch_size' is 0,
             *&#64;&#64;         'batch_size' must be set to 0. Otherwise, 'batch_size' must
             *&#64;&#64;         be set to value between 1 and 'max_batch_size'.
             *&#64;&#64;
             * </pre>
             *
             * <code>int32 batch_size = 1;</code>
             * @return The batchSize.
             */
            @java.lang.Override
            public int getBatchSize() {
              return batchSize_;
            }
            /**
             * <pre>
             *&#64;&#64;      .. cpp:var:: int32 batch_size
             *&#64;&#64;
             *&#64;&#64;         The batch size of the CUDA graph. If 'max_batch_size' is 0,
             *&#64;&#64;         'batch_size' must be set to 0. Otherwise, 'batch_size' must
             *&#64;&#64;         be set to value between 1 and 'max_batch_size'.
             *&#64;&#64;
             * </pre>
             *
             * <code>int32 batch_size = 1;</code>
             * @param value The batchSize to set.
             * @return This builder for chaining.
             */
            public Builder setBatchSize(int value) {
              
              batchSize_ = value;
              onChanged();
              return this;
            }
            /**
             * <pre>
             *&#64;&#64;      .. cpp:var:: int32 batch_size
             *&#64;&#64;
             *&#64;&#64;         The batch size of the CUDA graph. If 'max_batch_size' is 0,
             *&#64;&#64;         'batch_size' must be set to 0. Otherwise, 'batch_size' must
             *&#64;&#64;         be set to value between 1 and 'max_batch_size'.
             *&#64;&#64;
             * </pre>
             *
             * <code>int32 batch_size = 1;</code>
             * @return This builder for chaining.
             */
            public Builder clearBatchSize() {
              
              batchSize_ = 0;
              onChanged();
              return this;
            }

            private com.google.protobuf.MapField<
                java.lang.String, org.apache.submarine.server.api.proto.TritonModelConfig.ModelOptimizationPolicy.Cuda.GraphSpec.Shape> input_;
            private com.google.protobuf.MapField<java.lang.String, org.apache.submarine.server.api.proto.TritonModelConfig.ModelOptimizationPolicy.Cuda.GraphSpec.Shape>
            internalGetInput() {
              if (input_ == null) {
                return com.google.protobuf.MapField.emptyMapField(
                    InputDefaultEntryHolder.defaultEntry);
              }
              return input_;
            }
            private com.google.protobuf.MapField<java.lang.String, org.apache.submarine.server.api.proto.TritonModelConfig.ModelOptimizationPolicy.Cuda.GraphSpec.Shape>
            internalGetMutableInput() {
              onChanged();;
              if (input_ == null) {
                input_ = com.google.protobuf.MapField.newMapField(
                    InputDefaultEntryHolder.defaultEntry);
              }
              if (!input_.isMutable()) {
                input_ = input_.copy();
              }
              return input_;
            }

            public int getInputCount() {
              return internalGetInput().getMap().size();
            }
            /**
             * <pre>
             *&#64;&#64;      .. cpp:var:: map&lt;string, Shape&gt; input
             *&#64;&#64;
             *&#64;&#64;         The specification of the inputs. 'Shape' is the shape of
             *&#64;&#64;         the input without batching dimension.
             *&#64;&#64;
             * </pre>
             *
             * <code>map&lt;string, .inference.ModelOptimizationPolicy.Cuda.GraphSpec.Shape&gt; input = 2;</code>
             */

            @java.lang.Override
            public boolean containsInput(
                java.lang.String key) {
              if (key == null) { throw new java.lang.NullPointerException(); }
              return internalGetInput().getMap().containsKey(key);
            }
            /**
             * Use {@link #getInputMap()} instead.
             */
            @java.lang.Override
            @java.lang.Deprecated
            public java.util.Map<java.lang.String, org.apache.submarine.server.api.proto.TritonModelConfig.ModelOptimizationPolicy.Cuda.GraphSpec.Shape> getInput() {
              return getInputMap();
            }
            /**
             * <pre>
             *&#64;&#64;      .. cpp:var:: map&lt;string, Shape&gt; input
             *&#64;&#64;
             *&#64;&#64;         The specification of the inputs. 'Shape' is the shape of
             *&#64;&#64;         the input without batching dimension.
             *&#64;&#64;
             * </pre>
             *
             * <code>map&lt;string, .inference.ModelOptimizationPolicy.Cuda.GraphSpec.Shape&gt; input = 2;</code>
             */
            @java.lang.Override

            public java.util.Map<java.lang.String, org.apache.submarine.server.api.proto.TritonModelConfig.ModelOptimizationPolicy.Cuda.GraphSpec.Shape> getInputMap() {
              return internalGetInput().getMap();
            }
            /**
             * <pre>
             *&#64;&#64;      .. cpp:var:: map&lt;string, Shape&gt; input
             *&#64;&#64;
             *&#64;&#64;         The specification of the inputs. 'Shape' is the shape of
             *&#64;&#64;         the input without batching dimension.
             *&#64;&#64;
             * </pre>
             *
             * <code>map&lt;string, .inference.ModelOptimizationPolicy.Cuda.GraphSpec.Shape&gt; input = 2;</code>
             */
            @java.lang.Override

            public org.apache.submarine.server.api.proto.TritonModelConfig.ModelOptimizationPolicy.Cuda.GraphSpec.Shape getInputOrDefault(
                java.lang.String key,
                org.apache.submarine.server.api.proto.TritonModelConfig.ModelOptimizationPolicy.Cuda.GraphSpec.Shape defaultValue) {
              if (key == null) { throw new java.lang.NullPointerException(); }
              java.util.Map<java.lang.String, org.apache.submarine.server.api.proto.TritonModelConfig.ModelOptimizationPolicy.Cuda.GraphSpec.Shape> map =
                  internalGetInput().getMap();
              return map.containsKey(key) ? map.get(key) : defaultValue;
            }
            /**
             * <pre>
             *&#64;&#64;      .. cpp:var:: map&lt;string, Shape&gt; input
             *&#64;&#64;
             *&#64;&#64;         The specification of the inputs. 'Shape' is the shape of
             *&#64;&#64;         the input without batching dimension.
             *&#64;&#64;
             * </pre>
             *
             * <code>map&lt;string, .inference.ModelOptimizationPolicy.Cuda.GraphSpec.Shape&gt; input = 2;</code>
             */
            @java.lang.Override

            public org.apache.submarine.server.api.proto.TritonModelConfig.ModelOptimizationPolicy.Cuda.GraphSpec.Shape getInputOrThrow(
                java.lang.String key) {
              if (key == null) { throw new java.lang.NullPointerException(); }
              java.util.Map<java.lang.String, org.apache.submarine.server.api.proto.TritonModelConfig.ModelOptimizationPolicy.Cuda.GraphSpec.Shape> map =
                  internalGetInput().getMap();
              if (!map.containsKey(key)) {
                throw new java.lang.IllegalArgumentException();
              }
              return map.get(key);
            }

            public Builder clearInput() {
              internalGetMutableInput().getMutableMap()
                  .clear();
              return this;
            }
            /**
             * <pre>
             *&#64;&#64;      .. cpp:var:: map&lt;string, Shape&gt; input
             *&#64;&#64;
             *&#64;&#64;         The specification of the inputs. 'Shape' is the shape of
             *&#64;&#64;         the input without batching dimension.
             *&#64;&#64;
             * </pre>
             *
             * <code>map&lt;string, .inference.ModelOptimizationPolicy.Cuda.GraphSpec.Shape&gt; input = 2;</code>
             */

            public Builder removeInput(
                java.lang.String key) {
              if (key == null) { throw new java.lang.NullPointerException(); }
              internalGetMutableInput().getMutableMap()
                  .remove(key);
              return this;
            }
            /**
             * Use alternate mutation accessors instead.
             */
            @java.lang.Deprecated
            public java.util.Map<java.lang.String, org.apache.submarine.server.api.proto.TritonModelConfig.ModelOptimizationPolicy.Cuda.GraphSpec.Shape>
            getMutableInput() {
              return internalGetMutableInput().getMutableMap();
            }
            /**
             * <pre>
             *&#64;&#64;      .. cpp:var:: map&lt;string, Shape&gt; input
             *&#64;&#64;
             *&#64;&#64;         The specification of the inputs. 'Shape' is the shape of
             *&#64;&#64;         the input without batching dimension.
             *&#64;&#64;
             * </pre>
             *
             * <code>map&lt;string, .inference.ModelOptimizationPolicy.Cuda.GraphSpec.Shape&gt; input = 2;</code>
             */
            public Builder putInput(
                java.lang.String key,
                org.apache.submarine.server.api.proto.TritonModelConfig.ModelOptimizationPolicy.Cuda.GraphSpec.Shape value) {
              if (key == null) { throw new java.lang.NullPointerException(); }
              if (value == null) { throw new java.lang.NullPointerException(); }
              internalGetMutableInput().getMutableMap()
                  .put(key, value);
              return this;
            }
            /**
             * <pre>
             *&#64;&#64;      .. cpp:var:: map&lt;string, Shape&gt; input
             *&#64;&#64;
             *&#64;&#64;         The specification of the inputs. 'Shape' is the shape of
             *&#64;&#64;         the input without batching dimension.
             *&#64;&#64;
             * </pre>
             *
             * <code>map&lt;string, .inference.ModelOptimizationPolicy.Cuda.GraphSpec.Shape&gt; input = 2;</code>
             */

            public Builder putAllInput(
                java.util.Map<java.lang.String, org.apache.submarine.server.api.proto.TritonModelConfig.ModelOptimizationPolicy.Cuda.GraphSpec.Shape> values) {
              internalGetMutableInput().getMutableMap()
                  .putAll(values);
              return this;
            }
            @java.lang.Override
            public final Builder setUnknownFields(
                final com.google.protobuf.UnknownFieldSet unknownFields) {
              return super.setUnknownFields(unknownFields);
            }

            @java.lang.Override
            public final Builder mergeUnknownFields(
                final com.google.protobuf.UnknownFieldSet unknownFields) {
              return super.mergeUnknownFields(unknownFields);
            }


            // @@protoc_insertion_point(builder_scope:inference.ModelOptimizationPolicy.Cuda.GraphSpec.LowerBound)
          }

          // @@protoc_insertion_point(class_scope:inference.ModelOptimizationPolicy.Cuda.GraphSpec.LowerBound)
          private static final org.apache.submarine.server.api.proto.TritonModelConfig.ModelOptimizationPolicy.Cuda.GraphSpec.LowerBound DEFAULT_INSTANCE;
          static {
            DEFAULT_INSTANCE = new org.apache.submarine.server.api.proto.TritonModelConfig.ModelOptimizationPolicy.Cuda.GraphSpec.LowerBound();
          }

          public static org.apache.submarine.server.api.proto.TritonModelConfig.ModelOptimizationPolicy.Cuda.GraphSpec.LowerBound getDefaultInstance() {
            return DEFAULT_INSTANCE;
          }

          private static final com.google.protobuf.Parser<LowerBound>
              PARSER = new com.google.protobuf.AbstractParser<LowerBound>() {
            @java.lang.Override
            public LowerBound parsePartialFrom(
                com.google.protobuf.CodedInputStream input,
                com.google.protobuf.ExtensionRegistryLite extensionRegistry)
                throws com.google.protobuf.InvalidProtocolBufferException {
              return new LowerBound(input, extensionRegistry);
            }
          };

          public static com.google.protobuf.Parser<LowerBound> parser() {
            return PARSER;
          }

          @java.lang.Override
          public com.google.protobuf.Parser<LowerBound> getParserForType() {
            return PARSER;
          }

          @java.lang.Override
          public org.apache.submarine.server.api.proto.TritonModelConfig.ModelOptimizationPolicy.Cuda.GraphSpec.LowerBound getDefaultInstanceForType() {
            return DEFAULT_INSTANCE;
          }

        }

        public static final int BATCH_SIZE_FIELD_NUMBER = 1;
        private int batchSize_;
        /**
         * <pre>
         *&#64;&#64;      .. cpp:var:: int32 batch_size
         *&#64;&#64;
         *&#64;&#64;         The batch size of the CUDA graph. If 'max_batch_size' is 0,
         *&#64;&#64;         'batch_size' must be set to 0. Otherwise, 'batch_size' must
         *&#64;&#64;         be set to value between 1 and 'max_batch_size'.
         *&#64;&#64;
         * </pre>
         *
         * <code>int32 batch_size = 1;</code>
         * @return The batchSize.
         */
        @java.lang.Override
        public int getBatchSize() {
          return batchSize_;
        }

        public static final int INPUT_FIELD_NUMBER = 2;
        private static final class InputDefaultEntryHolder {
          static final com.google.protobuf.MapEntry<
              java.lang.String, org.apache.submarine.server.api.proto.TritonModelConfig.ModelOptimizationPolicy.Cuda.GraphSpec.Shape> defaultEntry =
                  com.google.protobuf.MapEntry
                  .<java.lang.String, org.apache.submarine.server.api.proto.TritonModelConfig.ModelOptimizationPolicy.Cuda.GraphSpec.Shape>newDefaultInstance(
                      org.apache.submarine.server.api.proto.TritonModelConfig.internal_static_inference_ModelOptimizationPolicy_Cuda_GraphSpec_InputEntry_descriptor, 
                      com.google.protobuf.WireFormat.FieldType.STRING,
                      "",
                      com.google.protobuf.WireFormat.FieldType.MESSAGE,
                      org.apache.submarine.server.api.proto.TritonModelConfig.ModelOptimizationPolicy.Cuda.GraphSpec.Shape.getDefaultInstance());
        }
        private com.google.protobuf.MapField<
            java.lang.String, org.apache.submarine.server.api.proto.TritonModelConfig.ModelOptimizationPolicy.Cuda.GraphSpec.Shape> input_;
        private com.google.protobuf.MapField<java.lang.String, org.apache.submarine.server.api.proto.TritonModelConfig.ModelOptimizationPolicy.Cuda.GraphSpec.Shape>
        internalGetInput() {
          if (input_ == null) {
            return com.google.protobuf.MapField.emptyMapField(
                InputDefaultEntryHolder.defaultEntry);
          }
          return input_;
        }

        public int getInputCount() {
          return internalGetInput().getMap().size();
        }
        /**
         * <pre>
         *&#64;&#64;      .. cpp:var:: map&lt;string, Shape&gt; input
         *&#64;&#64;
         *&#64;&#64;         The specification of the inputs. 'Shape' is the shape of the
         *&#64;&#64;         input without batching dimension.
         *&#64;&#64;
         * </pre>
         *
         * <code>map&lt;string, .inference.ModelOptimizationPolicy.Cuda.GraphSpec.Shape&gt; input = 2;</code>
         */

        @java.lang.Override
        public boolean containsInput(
            java.lang.String key) {
          if (key == null) { throw new java.lang.NullPointerException(); }
          return internalGetInput().getMap().containsKey(key);
        }
        /**
         * Use {@link #getInputMap()} instead.
         */
        @java.lang.Override
        @java.lang.Deprecated
        public java.util.Map<java.lang.String, org.apache.submarine.server.api.proto.TritonModelConfig.ModelOptimizationPolicy.Cuda.GraphSpec.Shape> getInput() {
          return getInputMap();
        }
        /**
         * <pre>
         *&#64;&#64;      .. cpp:var:: map&lt;string, Shape&gt; input
         *&#64;&#64;
         *&#64;&#64;         The specification of the inputs. 'Shape' is the shape of the
         *&#64;&#64;         input without batching dimension.
         *&#64;&#64;
         * </pre>
         *
         * <code>map&lt;string, .inference.ModelOptimizationPolicy.Cuda.GraphSpec.Shape&gt; input = 2;</code>
         */
        @java.lang.Override

        public java.util.Map<java.lang.String, org.apache.submarine.server.api.proto.TritonModelConfig.ModelOptimizationPolicy.Cuda.GraphSpec.Shape> getInputMap() {
          return internalGetInput().getMap();
        }
        /**
         * <pre>
         *&#64;&#64;      .. cpp:var:: map&lt;string, Shape&gt; input
         *&#64;&#64;
         *&#64;&#64;         The specification of the inputs. 'Shape' is the shape of the
         *&#64;&#64;         input without batching dimension.
         *&#64;&#64;
         * </pre>
         *
         * <code>map&lt;string, .inference.ModelOptimizationPolicy.Cuda.GraphSpec.Shape&gt; input = 2;</code>
         */
        @java.lang.Override

        public org.apache.submarine.server.api.proto.TritonModelConfig.ModelOptimizationPolicy.Cuda.GraphSpec.Shape getInputOrDefault(
            java.lang.String key,
            org.apache.submarine.server.api.proto.TritonModelConfig.ModelOptimizationPolicy.Cuda.GraphSpec.Shape defaultValue) {
          if (key == null) { throw new java.lang.NullPointerException(); }
          java.util.Map<java.lang.String, org.apache.submarine.server.api.proto.TritonModelConfig.ModelOptimizationPolicy.Cuda.GraphSpec.Shape> map =
              internalGetInput().getMap();
          return map.containsKey(key) ? map.get(key) : defaultValue;
        }
        /**
         * <pre>
         *&#64;&#64;      .. cpp:var:: map&lt;string, Shape&gt; input
         *&#64;&#64;
         *&#64;&#64;         The specification of the inputs. 'Shape' is the shape of the
         *&#64;&#64;         input without batching dimension.
         *&#64;&#64;
         * </pre>
         *
         * <code>map&lt;string, .inference.ModelOptimizationPolicy.Cuda.GraphSpec.Shape&gt; input = 2;</code>
         */
        @java.lang.Override

        public org.apache.submarine.server.api.proto.TritonModelConfig.ModelOptimizationPolicy.Cuda.GraphSpec.Shape getInputOrThrow(
            java.lang.String key) {
          if (key == null) { throw new java.lang.NullPointerException(); }
          java.util.Map<java.lang.String, org.apache.submarine.server.api.proto.TritonModelConfig.ModelOptimizationPolicy.Cuda.GraphSpec.Shape> map =
              internalGetInput().getMap();
          if (!map.containsKey(key)) {
            throw new java.lang.IllegalArgumentException();
          }
          return map.get(key);
        }

        public static final int GRAPH_LOWER_BOUND_FIELD_NUMBER = 3;
        private org.apache.submarine.server.api.proto.TritonModelConfig.ModelOptimizationPolicy.Cuda.GraphSpec.LowerBound graphLowerBound_;
        /**
         * <pre>
         *&#64;&#64;      .. cpp:var:: LowerBound graph_lower_bound
         *&#64;&#64;
         *&#64;&#64;         Specify the lower bound of the CUDA graph. Optional.
         *&#64;&#64;         If specified, the graph can be used for input shapes and
         *&#64;&#64;         batch sizes that are in closed interval between the lower
         *&#64;&#64;         bound specification and graph specification. For dynamic
         *&#64;&#64;         shape model, this allows CUDA graphs to be launched
         *&#64;&#64;         frequently without capturing all possible shape combinations.
         *&#64;&#64;         However, using graph for shape combinations different from
         *&#64;&#64;         the one used for capturing introduces uninitialized data for
         *&#64;&#64;         execution and it may distort the inference result if
         *&#64;&#64;         the model is sensitive to uninitialized data.
         *&#64;&#64;
         * </pre>
         *
         * <code>.inference.ModelOptimizationPolicy.Cuda.GraphSpec.LowerBound graph_lower_bound = 3;</code>
         * @return Whether the graphLowerBound field is set.
         */
        @java.lang.Override
        public boolean hasGraphLowerBound() {
          return graphLowerBound_ != null;
        }
        /**
         * <pre>
         *&#64;&#64;      .. cpp:var:: LowerBound graph_lower_bound
         *&#64;&#64;
         *&#64;&#64;         Specify the lower bound of the CUDA graph. Optional.
         *&#64;&#64;         If specified, the graph can be used for input shapes and
         *&#64;&#64;         batch sizes that are in closed interval between the lower
         *&#64;&#64;         bound specification and graph specification. For dynamic
         *&#64;&#64;         shape model, this allows CUDA graphs to be launched
         *&#64;&#64;         frequently without capturing all possible shape combinations.
         *&#64;&#64;         However, using graph for shape combinations different from
         *&#64;&#64;         the one used for capturing introduces uninitialized data for
         *&#64;&#64;         execution and it may distort the inference result if
         *&#64;&#64;         the model is sensitive to uninitialized data.
         *&#64;&#64;
         * </pre>
         *
         * <code>.inference.ModelOptimizationPolicy.Cuda.GraphSpec.LowerBound graph_lower_bound = 3;</code>
         * @return The graphLowerBound.
         */
        @java.lang.Override
        public org.apache.submarine.server.api.proto.TritonModelConfig.ModelOptimizationPolicy.Cuda.GraphSpec.LowerBound getGraphLowerBound() {
          return graphLowerBound_ == null ? org.apache.submarine.server.api.proto.TritonModelConfig.ModelOptimizationPolicy.Cuda.GraphSpec.LowerBound.getDefaultInstance() : graphLowerBound_;
        }
        /**
         * <pre>
         *&#64;&#64;      .. cpp:var:: LowerBound graph_lower_bound
         *&#64;&#64;
         *&#64;&#64;         Specify the lower bound of the CUDA graph. Optional.
         *&#64;&#64;         If specified, the graph can be used for input shapes and
         *&#64;&#64;         batch sizes that are in closed interval between the lower
         *&#64;&#64;         bound specification and graph specification. For dynamic
         *&#64;&#64;         shape model, this allows CUDA graphs to be launched
         *&#64;&#64;         frequently without capturing all possible shape combinations.
         *&#64;&#64;         However, using graph for shape combinations different from
         *&#64;&#64;         the one used for capturing introduces uninitialized data for
         *&#64;&#64;         execution and it may distort the inference result if
         *&#64;&#64;         the model is sensitive to uninitialized data.
         *&#64;&#64;
         * </pre>
         *
         * <code>.inference.ModelOptimizationPolicy.Cuda.GraphSpec.LowerBound graph_lower_bound = 3;</code>
         */
        @java.lang.Override
        public org.apache.submarine.server.api.proto.TritonModelConfig.ModelOptimizationPolicy.Cuda.GraphSpec.LowerBoundOrBuilder getGraphLowerBoundOrBuilder() {
          return getGraphLowerBound();
        }

        private byte memoizedIsInitialized = -1;
        @java.lang.Override
        public final boolean isInitialized() {
          byte isInitialized = memoizedIsInitialized;
          if (isInitialized == 1) return true;
          if (isInitialized == 0) return false;

          memoizedIsInitialized = 1;
          return true;
        }

        @java.lang.Override
        public void writeTo(com.google.protobuf.CodedOutputStream output)
                            throws java.io.IOException {
          if (batchSize_ != 0) {
            output.writeInt32(1, batchSize_);
          }
          com.google.protobuf.GeneratedMessageV3
            .serializeStringMapTo(
              output,
              internalGetInput(),
              InputDefaultEntryHolder.defaultEntry,
              2);
          if (graphLowerBound_ != null) {
            output.writeMessage(3, getGraphLowerBound());
          }
          unknownFields.writeTo(output);
        }

        @java.lang.Override
        public int getSerializedSize() {
          int size = memoizedSize;
          if (size != -1) return size;

          size = 0;
          if (batchSize_ != 0) {
            size += com.google.protobuf.CodedOutputStream
              .computeInt32Size(1, batchSize_);
          }
          for (java.util.Map.Entry<java.lang.String, org.apache.submarine.server.api.proto.TritonModelConfig.ModelOptimizationPolicy.Cuda.GraphSpec.Shape> entry
               : internalGetInput().getMap().entrySet()) {
            com.google.protobuf.MapEntry<java.lang.String, org.apache.submarine.server.api.proto.TritonModelConfig.ModelOptimizationPolicy.Cuda.GraphSpec.Shape>
            input__ = InputDefaultEntryHolder.defaultEntry.newBuilderForType()
                .setKey(entry.getKey())
                .setValue(entry.getValue())
                .build();
            size += com.google.protobuf.CodedOutputStream
                .computeMessageSize(2, input__);
          }
          if (graphLowerBound_ != null) {
            size += com.google.protobuf.CodedOutputStream
              .computeMessageSize(3, getGraphLowerBound());
          }
          size += unknownFields.getSerializedSize();
          memoizedSize = size;
          return size;
        }

        @java.lang.Override
        public boolean equals(final java.lang.Object obj) {
          if (obj == this) {
           return true;
          }
          if (!(obj instanceof org.apache.submarine.server.api.proto.TritonModelConfig.ModelOptimizationPolicy.Cuda.GraphSpec)) {
            return super.equals(obj);
          }
          org.apache.submarine.server.api.proto.TritonModelConfig.ModelOptimizationPolicy.Cuda.GraphSpec other = (org.apache.submarine.server.api.proto.TritonModelConfig.ModelOptimizationPolicy.Cuda.GraphSpec) obj;

          if (getBatchSize()
              != other.getBatchSize()) return false;
          if (!internalGetInput().equals(
              other.internalGetInput())) return false;
          if (hasGraphLowerBound() != other.hasGraphLowerBound()) return false;
          if (hasGraphLowerBound()) {
            if (!getGraphLowerBound()
                .equals(other.getGraphLowerBound())) return false;
          }
          if (!unknownFields.equals(other.unknownFields)) return false;
          return true;
        }

        @java.lang.Override
        public int hashCode() {
          if (memoizedHashCode != 0) {
            return memoizedHashCode;
          }
          int hash = 41;
          hash = (19 * hash) + getDescriptor().hashCode();
          hash = (37 * hash) + BATCH_SIZE_FIELD_NUMBER;
          hash = (53 * hash) + getBatchSize();
          if (!internalGetInput().getMap().isEmpty()) {
            hash = (37 * hash) + INPUT_FIELD_NUMBER;
            hash = (53 * hash) + internalGetInput().hashCode();
          }
          if (hasGraphLowerBound()) {
            hash = (37 * hash) + GRAPH_LOWER_BOUND_FIELD_NUMBER;
            hash = (53 * hash) + getGraphLowerBound().hashCode();
          }
          hash = (29 * hash) + unknownFields.hashCode();
          memoizedHashCode = hash;
          return hash;
        }

        public static org.apache.submarine.server.api.proto.TritonModelConfig.ModelOptimizationPolicy.Cuda.GraphSpec parseFrom(
            java.nio.ByteBuffer data)
            throws com.google.protobuf.InvalidProtocolBufferException {
          return PARSER.parseFrom(data);
        }
        public static org.apache.submarine.server.api.proto.TritonModelConfig.ModelOptimizationPolicy.Cuda.GraphSpec parseFrom(
            java.nio.ByteBuffer data,
            com.google.protobuf.ExtensionRegistryLite extensionRegistry)
            throws com.google.protobuf.InvalidProtocolBufferException {
          return PARSER.parseFrom(data, extensionRegistry);
        }
        public static org.apache.submarine.server.api.proto.TritonModelConfig.ModelOptimizationPolicy.Cuda.GraphSpec parseFrom(
            com.google.protobuf.ByteString data)
            throws com.google.protobuf.InvalidProtocolBufferException {
          return PARSER.parseFrom(data);
        }
        public static org.apache.submarine.server.api.proto.TritonModelConfig.ModelOptimizationPolicy.Cuda.GraphSpec parseFrom(
            com.google.protobuf.ByteString data,
            com.google.protobuf.ExtensionRegistryLite extensionRegistry)
            throws com.google.protobuf.InvalidProtocolBufferException {
          return PARSER.parseFrom(data, extensionRegistry);
        }
        public static org.apache.submarine.server.api.proto.TritonModelConfig.ModelOptimizationPolicy.Cuda.GraphSpec parseFrom(byte[] data)
            throws com.google.protobuf.InvalidProtocolBufferException {
          return PARSER.parseFrom(data);
        }
        public static org.apache.submarine.server.api.proto.TritonModelConfig.ModelOptimizationPolicy.Cuda.GraphSpec parseFrom(
            byte[] data,
            com.google.protobuf.ExtensionRegistryLite extensionRegistry)
            throws com.google.protobuf.InvalidProtocolBufferException {
          return PARSER.parseFrom(data, extensionRegistry);
        }
        public static org.apache.submarine.server.api.proto.TritonModelConfig.ModelOptimizationPolicy.Cuda.GraphSpec parseFrom(java.io.InputStream input)
            throws java.io.IOException {
          return com.google.protobuf.GeneratedMessageV3
              .parseWithIOException(PARSER, input);
        }
        public static org.apache.submarine.server.api.proto.TritonModelConfig.ModelOptimizationPolicy.Cuda.GraphSpec parseFrom(
            java.io.InputStream input,
            com.google.protobuf.ExtensionRegistryLite extensionRegistry)
            throws java.io.IOException {
          return com.google.protobuf.GeneratedMessageV3
              .parseWithIOException(PARSER, input, extensionRegistry);
        }
        public static org.apache.submarine.server.api.proto.TritonModelConfig.ModelOptimizationPolicy.Cuda.GraphSpec parseDelimitedFrom(java.io.InputStream input)
            throws java.io.IOException {
          return com.google.protobuf.GeneratedMessageV3
              .parseDelimitedWithIOException(PARSER, input);
        }
        public static org.apache.submarine.server.api.proto.TritonModelConfig.ModelOptimizationPolicy.Cuda.GraphSpec parseDelimitedFrom(
            java.io.InputStream input,
            com.google.protobuf.ExtensionRegistryLite extensionRegistry)
            throws java.io.IOException {
          return com.google.protobuf.GeneratedMessageV3
              .parseDelimitedWithIOException(PARSER, input, extensionRegistry);
        }
        public static org.apache.submarine.server.api.proto.TritonModelConfig.ModelOptimizationPolicy.Cuda.GraphSpec parseFrom(
            com.google.protobuf.CodedInputStream input)
            throws java.io.IOException {
          return com.google.protobuf.GeneratedMessageV3
              .parseWithIOException(PARSER, input);
        }
        public static org.apache.submarine.server.api.proto.TritonModelConfig.ModelOptimizationPolicy.Cuda.GraphSpec parseFrom(
            com.google.protobuf.CodedInputStream input,
            com.google.protobuf.ExtensionRegistryLite extensionRegistry)
            throws java.io.IOException {
          return com.google.protobuf.GeneratedMessageV3
              .parseWithIOException(PARSER, input, extensionRegistry);
        }

        @java.lang.Override
        public Builder newBuilderForType() { return newBuilder(); }
        public static Builder newBuilder() {
          return DEFAULT_INSTANCE.toBuilder();
        }
        public static Builder newBuilder(org.apache.submarine.server.api.proto.TritonModelConfig.ModelOptimizationPolicy.Cuda.GraphSpec prototype) {
          return DEFAULT_INSTANCE.toBuilder().mergeFrom(prototype);
        }
        @java.lang.Override
        public Builder toBuilder() {
          return this == DEFAULT_INSTANCE
              ? new Builder() : new Builder().mergeFrom(this);
        }

        @java.lang.Override
        protected Builder newBuilderForType(
            com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
          Builder builder = new Builder(parent);
          return builder;
        }
        /**
         * <pre>
         *&#64;&#64;    .. cpp:var:: message GraphSpec
         *&#64;&#64;
         *&#64;&#64;       Specification of the CUDA graph to be captured.
         *&#64;&#64;
         * </pre>
         *
         * Protobuf type {@code inference.ModelOptimizationPolicy.Cuda.GraphSpec}
         */
        public static final class Builder extends
            com.google.protobuf.GeneratedMessageV3.Builder<Builder> implements
            // @@protoc_insertion_point(builder_implements:inference.ModelOptimizationPolicy.Cuda.GraphSpec)
            org.apache.submarine.server.api.proto.TritonModelConfig.ModelOptimizationPolicy.Cuda.GraphSpecOrBuilder {
          public static final com.google.protobuf.Descriptors.Descriptor
              getDescriptor() {
            return org.apache.submarine.server.api.proto.TritonModelConfig.internal_static_inference_ModelOptimizationPolicy_Cuda_GraphSpec_descriptor;
          }

          @SuppressWarnings({"rawtypes"})
          protected com.google.protobuf.MapField internalGetMapField(
              int number) {
            switch (number) {
              case 2:
                return internalGetInput();
              default:
                throw new RuntimeException(
                    "Invalid map field number: " + number);
            }
          }
          @SuppressWarnings({"rawtypes"})
          protected com.google.protobuf.MapField internalGetMutableMapField(
              int number) {
            switch (number) {
              case 2:
                return internalGetMutableInput();
              default:
                throw new RuntimeException(
                    "Invalid map field number: " + number);
            }
          }
          @java.lang.Override
          protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
              internalGetFieldAccessorTable() {
            return org.apache.submarine.server.api.proto.TritonModelConfig.internal_static_inference_ModelOptimizationPolicy_Cuda_GraphSpec_fieldAccessorTable
                .ensureFieldAccessorsInitialized(
                    org.apache.submarine.server.api.proto.TritonModelConfig.ModelOptimizationPolicy.Cuda.GraphSpec.class, org.apache.submarine.server.api.proto.TritonModelConfig.ModelOptimizationPolicy.Cuda.GraphSpec.Builder.class);
          }

          // Construct using org.apache.submarine.server.api.proto.TritonModelConfig.ModelOptimizationPolicy.Cuda.GraphSpec.newBuilder()
          private Builder() {
            maybeForceBuilderInitialization();
          }

          private Builder(
              com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
            super(parent);
            maybeForceBuilderInitialization();
          }
          private void maybeForceBuilderInitialization() {
            if (com.google.protobuf.GeneratedMessageV3
                    .alwaysUseFieldBuilders) {
            }
          }
          @java.lang.Override
          public Builder clear() {
            super.clear();
            batchSize_ = 0;

            internalGetMutableInput().clear();
            if (graphLowerBoundBuilder_ == null) {
              graphLowerBound_ = null;
            } else {
              graphLowerBound_ = null;
              graphLowerBoundBuilder_ = null;
            }
            return this;
          }

          @java.lang.Override
          public com.google.protobuf.Descriptors.Descriptor
              getDescriptorForType() {
            return org.apache.submarine.server.api.proto.TritonModelConfig.internal_static_inference_ModelOptimizationPolicy_Cuda_GraphSpec_descriptor;
          }

          @java.lang.Override
          public org.apache.submarine.server.api.proto.TritonModelConfig.ModelOptimizationPolicy.Cuda.GraphSpec getDefaultInstanceForType() {
            return org.apache.submarine.server.api.proto.TritonModelConfig.ModelOptimizationPolicy.Cuda.GraphSpec.getDefaultInstance();
          }

          @java.lang.Override
          public org.apache.submarine.server.api.proto.TritonModelConfig.ModelOptimizationPolicy.Cuda.GraphSpec build() {
            org.apache.submarine.server.api.proto.TritonModelConfig.ModelOptimizationPolicy.Cuda.GraphSpec result = buildPartial();
            if (!result.isInitialized()) {
              throw newUninitializedMessageException(result);
            }
            return result;
          }

          @java.lang.Override
          public org.apache.submarine.server.api.proto.TritonModelConfig.ModelOptimizationPolicy.Cuda.GraphSpec buildPartial() {
            org.apache.submarine.server.api.proto.TritonModelConfig.ModelOptimizationPolicy.Cuda.GraphSpec result = new org.apache.submarine.server.api.proto.TritonModelConfig.ModelOptimizationPolicy.Cuda.GraphSpec(this);
            int from_bitField0_ = bitField0_;
            result.batchSize_ = batchSize_;
            result.input_ = internalGetInput();
            result.input_.makeImmutable();
            if (graphLowerBoundBuilder_ == null) {
              result.graphLowerBound_ = graphLowerBound_;
            } else {
              result.graphLowerBound_ = graphLowerBoundBuilder_.build();
            }
            onBuilt();
            return result;
          }

          @java.lang.Override
          public Builder clone() {
            return super.clone();
          }
          @java.lang.Override
          public Builder setField(
              com.google.protobuf.Descriptors.FieldDescriptor field,
              java.lang.Object value) {
            return super.setField(field, value);
          }
          @java.lang.Override
          public Builder clearField(
              com.google.protobuf.Descriptors.FieldDescriptor field) {
            return super.clearField(field);
          }
          @java.lang.Override
          public Builder clearOneof(
              com.google.protobuf.Descriptors.OneofDescriptor oneof) {
            return super.clearOneof(oneof);
          }
          @java.lang.Override
          public Builder setRepeatedField(
              com.google.protobuf.Descriptors.FieldDescriptor field,
              int index, java.lang.Object value) {
            return super.setRepeatedField(field, index, value);
          }
          @java.lang.Override
          public Builder addRepeatedField(
              com.google.protobuf.Descriptors.FieldDescriptor field,
              java.lang.Object value) {
            return super.addRepeatedField(field, value);
          }
          @java.lang.Override
          public Builder mergeFrom(com.google.protobuf.Message other) {
            if (other instanceof org.apache.submarine.server.api.proto.TritonModelConfig.ModelOptimizationPolicy.Cuda.GraphSpec) {
              return mergeFrom((org.apache.submarine.server.api.proto.TritonModelConfig.ModelOptimizationPolicy.Cuda.GraphSpec)other);
            } else {
              super.mergeFrom(other);
              return this;
            }
          }

          public Builder mergeFrom(org.apache.submarine.server.api.proto.TritonModelConfig.ModelOptimizationPolicy.Cuda.GraphSpec other) {
            if (other == org.apache.submarine.server.api.proto.TritonModelConfig.ModelOptimizationPolicy.Cuda.GraphSpec.getDefaultInstance()) return this;
            if (other.getBatchSize() != 0) {
              setBatchSize(other.getBatchSize());
            }
            internalGetMutableInput().mergeFrom(
                other.internalGetInput());
            if (other.hasGraphLowerBound()) {
              mergeGraphLowerBound(other.getGraphLowerBound());
            }
            this.mergeUnknownFields(other.unknownFields);
            onChanged();
            return this;
          }

          @java.lang.Override
          public final boolean isInitialized() {
            return true;
          }

          @java.lang.Override
          public Builder mergeFrom(
              com.google.protobuf.CodedInputStream input,
              com.google.protobuf.ExtensionRegistryLite extensionRegistry)
              throws java.io.IOException {
            org.apache.submarine.server.api.proto.TritonModelConfig.ModelOptimizationPolicy.Cuda.GraphSpec parsedMessage = null;
            try {
              parsedMessage = PARSER.parsePartialFrom(input, extensionRegistry);
            } catch (com.google.protobuf.InvalidProtocolBufferException e) {
              parsedMessage = (org.apache.submarine.server.api.proto.TritonModelConfig.ModelOptimizationPolicy.Cuda.GraphSpec) e.getUnfinishedMessage();
              throw e.unwrapIOException();
            } finally {
              if (parsedMessage != null) {
                mergeFrom(parsedMessage);
              }
            }
            return this;
          }
          private int bitField0_;

          private int batchSize_ ;
          /**
           * <pre>
           *&#64;&#64;      .. cpp:var:: int32 batch_size
           *&#64;&#64;
           *&#64;&#64;         The batch size of the CUDA graph. If 'max_batch_size' is 0,
           *&#64;&#64;         'batch_size' must be set to 0. Otherwise, 'batch_size' must
           *&#64;&#64;         be set to value between 1 and 'max_batch_size'.
           *&#64;&#64;
           * </pre>
           *
           * <code>int32 batch_size = 1;</code>
           * @return The batchSize.
           */
          @java.lang.Override
          public int getBatchSize() {
            return batchSize_;
          }
          /**
           * <pre>
           *&#64;&#64;      .. cpp:var:: int32 batch_size
           *&#64;&#64;
           *&#64;&#64;         The batch size of the CUDA graph. If 'max_batch_size' is 0,
           *&#64;&#64;         'batch_size' must be set to 0. Otherwise, 'batch_size' must
           *&#64;&#64;         be set to value between 1 and 'max_batch_size'.
           *&#64;&#64;
           * </pre>
           *
           * <code>int32 batch_size = 1;</code>
           * @param value The batchSize to set.
           * @return This builder for chaining.
           */
          public Builder setBatchSize(int value) {
            
            batchSize_ = value;
            onChanged();
            return this;
          }
          /**
           * <pre>
           *&#64;&#64;      .. cpp:var:: int32 batch_size
           *&#64;&#64;
           *&#64;&#64;         The batch size of the CUDA graph. If 'max_batch_size' is 0,
           *&#64;&#64;         'batch_size' must be set to 0. Otherwise, 'batch_size' must
           *&#64;&#64;         be set to value between 1 and 'max_batch_size'.
           *&#64;&#64;
           * </pre>
           *
           * <code>int32 batch_size = 1;</code>
           * @return This builder for chaining.
           */
          public Builder clearBatchSize() {
            
            batchSize_ = 0;
            onChanged();
            return this;
          }

          private com.google.protobuf.MapField<
              java.lang.String, org.apache.submarine.server.api.proto.TritonModelConfig.ModelOptimizationPolicy.Cuda.GraphSpec.Shape> input_;
          private com.google.protobuf.MapField<java.lang.String, org.apache.submarine.server.api.proto.TritonModelConfig.ModelOptimizationPolicy.Cuda.GraphSpec.Shape>
          internalGetInput() {
            if (input_ == null) {
              return com.google.protobuf.MapField.emptyMapField(
                  InputDefaultEntryHolder.defaultEntry);
            }
            return input_;
          }
          private com.google.protobuf.MapField<java.lang.String, org.apache.submarine.server.api.proto.TritonModelConfig.ModelOptimizationPolicy.Cuda.GraphSpec.Shape>
          internalGetMutableInput() {
            onChanged();;
            if (input_ == null) {
              input_ = com.google.protobuf.MapField.newMapField(
                  InputDefaultEntryHolder.defaultEntry);
            }
            if (!input_.isMutable()) {
              input_ = input_.copy();
            }
            return input_;
          }

          public int getInputCount() {
            return internalGetInput().getMap().size();
          }
          /**
           * <pre>
           *&#64;&#64;      .. cpp:var:: map&lt;string, Shape&gt; input
           *&#64;&#64;
           *&#64;&#64;         The specification of the inputs. 'Shape' is the shape of the
           *&#64;&#64;         input without batching dimension.
           *&#64;&#64;
           * </pre>
           *
           * <code>map&lt;string, .inference.ModelOptimizationPolicy.Cuda.GraphSpec.Shape&gt; input = 2;</code>
           */

          @java.lang.Override
          public boolean containsInput(
              java.lang.String key) {
            if (key == null) { throw new java.lang.NullPointerException(); }
            return internalGetInput().getMap().containsKey(key);
          }
          /**
           * Use {@link #getInputMap()} instead.
           */
          @java.lang.Override
          @java.lang.Deprecated
          public java.util.Map<java.lang.String, org.apache.submarine.server.api.proto.TritonModelConfig.ModelOptimizationPolicy.Cuda.GraphSpec.Shape> getInput() {
            return getInputMap();
          }
          /**
           * <pre>
           *&#64;&#64;      .. cpp:var:: map&lt;string, Shape&gt; input
           *&#64;&#64;
           *&#64;&#64;         The specification of the inputs. 'Shape' is the shape of the
           *&#64;&#64;         input without batching dimension.
           *&#64;&#64;
           * </pre>
           *
           * <code>map&lt;string, .inference.ModelOptimizationPolicy.Cuda.GraphSpec.Shape&gt; input = 2;</code>
           */
          @java.lang.Override

          public java.util.Map<java.lang.String, org.apache.submarine.server.api.proto.TritonModelConfig.ModelOptimizationPolicy.Cuda.GraphSpec.Shape> getInputMap() {
            return internalGetInput().getMap();
          }
          /**
           * <pre>
           *&#64;&#64;      .. cpp:var:: map&lt;string, Shape&gt; input
           *&#64;&#64;
           *&#64;&#64;         The specification of the inputs. 'Shape' is the shape of the
           *&#64;&#64;         input without batching dimension.
           *&#64;&#64;
           * </pre>
           *
           * <code>map&lt;string, .inference.ModelOptimizationPolicy.Cuda.GraphSpec.Shape&gt; input = 2;</code>
           */
          @java.lang.Override

          public org.apache.submarine.server.api.proto.TritonModelConfig.ModelOptimizationPolicy.Cuda.GraphSpec.Shape getInputOrDefault(
              java.lang.String key,
              org.apache.submarine.server.api.proto.TritonModelConfig.ModelOptimizationPolicy.Cuda.GraphSpec.Shape defaultValue) {
            if (key == null) { throw new java.lang.NullPointerException(); }
            java.util.Map<java.lang.String, org.apache.submarine.server.api.proto.TritonModelConfig.ModelOptimizationPolicy.Cuda.GraphSpec.Shape> map =
                internalGetInput().getMap();
            return map.containsKey(key) ? map.get(key) : defaultValue;
          }
          /**
           * <pre>
           *&#64;&#64;      .. cpp:var:: map&lt;string, Shape&gt; input
           *&#64;&#64;
           *&#64;&#64;         The specification of the inputs. 'Shape' is the shape of the
           *&#64;&#64;         input without batching dimension.
           *&#64;&#64;
           * </pre>
           *
           * <code>map&lt;string, .inference.ModelOptimizationPolicy.Cuda.GraphSpec.Shape&gt; input = 2;</code>
           */
          @java.lang.Override

          public org.apache.submarine.server.api.proto.TritonModelConfig.ModelOptimizationPolicy.Cuda.GraphSpec.Shape getInputOrThrow(
              java.lang.String key) {
            if (key == null) { throw new java.lang.NullPointerException(); }
            java.util.Map<java.lang.String, org.apache.submarine.server.api.proto.TritonModelConfig.ModelOptimizationPolicy.Cuda.GraphSpec.Shape> map =
                internalGetInput().getMap();
            if (!map.containsKey(key)) {
              throw new java.lang.IllegalArgumentException();
            }
            return map.get(key);
          }

          public Builder clearInput() {
            internalGetMutableInput().getMutableMap()
                .clear();
            return this;
          }
          /**
           * <pre>
           *&#64;&#64;      .. cpp:var:: map&lt;string, Shape&gt; input
           *&#64;&#64;
           *&#64;&#64;         The specification of the inputs. 'Shape' is the shape of the
           *&#64;&#64;         input without batching dimension.
           *&#64;&#64;
           * </pre>
           *
           * <code>map&lt;string, .inference.ModelOptimizationPolicy.Cuda.GraphSpec.Shape&gt; input = 2;</code>
           */

          public Builder removeInput(
              java.lang.String key) {
            if (key == null) { throw new java.lang.NullPointerException(); }
            internalGetMutableInput().getMutableMap()
                .remove(key);
            return this;
          }
          /**
           * Use alternate mutation accessors instead.
           */
          @java.lang.Deprecated
          public java.util.Map<java.lang.String, org.apache.submarine.server.api.proto.TritonModelConfig.ModelOptimizationPolicy.Cuda.GraphSpec.Shape>
          getMutableInput() {
            return internalGetMutableInput().getMutableMap();
          }
          /**
           * <pre>
           *&#64;&#64;      .. cpp:var:: map&lt;string, Shape&gt; input
           *&#64;&#64;
           *&#64;&#64;         The specification of the inputs. 'Shape' is the shape of the
           *&#64;&#64;         input without batching dimension.
           *&#64;&#64;
           * </pre>
           *
           * <code>map&lt;string, .inference.ModelOptimizationPolicy.Cuda.GraphSpec.Shape&gt; input = 2;</code>
           */
          public Builder putInput(
              java.lang.String key,
              org.apache.submarine.server.api.proto.TritonModelConfig.ModelOptimizationPolicy.Cuda.GraphSpec.Shape value) {
            if (key == null) { throw new java.lang.NullPointerException(); }
            if (value == null) { throw new java.lang.NullPointerException(); }
            internalGetMutableInput().getMutableMap()
                .put(key, value);
            return this;
          }
          /**
           * <pre>
           *&#64;&#64;      .. cpp:var:: map&lt;string, Shape&gt; input
           *&#64;&#64;
           *&#64;&#64;         The specification of the inputs. 'Shape' is the shape of the
           *&#64;&#64;         input without batching dimension.
           *&#64;&#64;
           * </pre>
           *
           * <code>map&lt;string, .inference.ModelOptimizationPolicy.Cuda.GraphSpec.Shape&gt; input = 2;</code>
           */

          public Builder putAllInput(
              java.util.Map<java.lang.String, org.apache.submarine.server.api.proto.TritonModelConfig.ModelOptimizationPolicy.Cuda.GraphSpec.Shape> values) {
            internalGetMutableInput().getMutableMap()
                .putAll(values);
            return this;
          }

          private org.apache.submarine.server.api.proto.TritonModelConfig.ModelOptimizationPolicy.Cuda.GraphSpec.LowerBound graphLowerBound_;
          private com.google.protobuf.SingleFieldBuilderV3<
              org.apache.submarine.server.api.proto.TritonModelConfig.ModelOptimizationPolicy.Cuda.GraphSpec.LowerBound, org.apache.submarine.server.api.proto.TritonModelConfig.ModelOptimizationPolicy.Cuda.GraphSpec.LowerBound.Builder, org.apache.submarine.server.api.proto.TritonModelConfig.ModelOptimizationPolicy.Cuda.GraphSpec.LowerBoundOrBuilder> graphLowerBoundBuilder_;
          /**
           * <pre>
           *&#64;&#64;      .. cpp:var:: LowerBound graph_lower_bound
           *&#64;&#64;
           *&#64;&#64;         Specify the lower bound of the CUDA graph. Optional.
           *&#64;&#64;         If specified, the graph can be used for input shapes and
           *&#64;&#64;         batch sizes that are in closed interval between the lower
           *&#64;&#64;         bound specification and graph specification. For dynamic
           *&#64;&#64;         shape model, this allows CUDA graphs to be launched
           *&#64;&#64;         frequently without capturing all possible shape combinations.
           *&#64;&#64;         However, using graph for shape combinations different from
           *&#64;&#64;         the one used for capturing introduces uninitialized data for
           *&#64;&#64;         execution and it may distort the inference result if
           *&#64;&#64;         the model is sensitive to uninitialized data.
           *&#64;&#64;
           * </pre>
           *
           * <code>.inference.ModelOptimizationPolicy.Cuda.GraphSpec.LowerBound graph_lower_bound = 3;</code>
           * @return Whether the graphLowerBound field is set.
           */
          public boolean hasGraphLowerBound() {
            return graphLowerBoundBuilder_ != null || graphLowerBound_ != null;
          }
          /**
           * <pre>
           *&#64;&#64;      .. cpp:var:: LowerBound graph_lower_bound
           *&#64;&#64;
           *&#64;&#64;         Specify the lower bound of the CUDA graph. Optional.
           *&#64;&#64;         If specified, the graph can be used for input shapes and
           *&#64;&#64;         batch sizes that are in closed interval between the lower
           *&#64;&#64;         bound specification and graph specification. For dynamic
           *&#64;&#64;         shape model, this allows CUDA graphs to be launched
           *&#64;&#64;         frequently without capturing all possible shape combinations.
           *&#64;&#64;         However, using graph for shape combinations different from
           *&#64;&#64;         the one used for capturing introduces uninitialized data for
           *&#64;&#64;         execution and it may distort the inference result if
           *&#64;&#64;         the model is sensitive to uninitialized data.
           *&#64;&#64;
           * </pre>
           *
           * <code>.inference.ModelOptimizationPolicy.Cuda.GraphSpec.LowerBound graph_lower_bound = 3;</code>
           * @return The graphLowerBound.
           */
          public org.apache.submarine.server.api.proto.TritonModelConfig.ModelOptimizationPolicy.Cuda.GraphSpec.LowerBound getGraphLowerBound() {
            if (graphLowerBoundBuilder_ == null) {
              return graphLowerBound_ == null ? org.apache.submarine.server.api.proto.TritonModelConfig.ModelOptimizationPolicy.Cuda.GraphSpec.LowerBound.getDefaultInstance() : graphLowerBound_;
            } else {
              return graphLowerBoundBuilder_.getMessage();
            }
          }
          /**
           * <pre>
           *&#64;&#64;      .. cpp:var:: LowerBound graph_lower_bound
           *&#64;&#64;
           *&#64;&#64;         Specify the lower bound of the CUDA graph. Optional.
           *&#64;&#64;         If specified, the graph can be used for input shapes and
           *&#64;&#64;         batch sizes that are in closed interval between the lower
           *&#64;&#64;         bound specification and graph specification. For dynamic
           *&#64;&#64;         shape model, this allows CUDA graphs to be launched
           *&#64;&#64;         frequently without capturing all possible shape combinations.
           *&#64;&#64;         However, using graph for shape combinations different from
           *&#64;&#64;         the one used for capturing introduces uninitialized data for
           *&#64;&#64;         execution and it may distort the inference result if
           *&#64;&#64;         the model is sensitive to uninitialized data.
           *&#64;&#64;
           * </pre>
           *
           * <code>.inference.ModelOptimizationPolicy.Cuda.GraphSpec.LowerBound graph_lower_bound = 3;</code>
           */
          public Builder setGraphLowerBound(org.apache.submarine.server.api.proto.TritonModelConfig.ModelOptimizationPolicy.Cuda.GraphSpec.LowerBound value) {
            if (graphLowerBoundBuilder_ == null) {
              if (value == null) {
                throw new NullPointerException();
              }
              graphLowerBound_ = value;
              onChanged();
            } else {
              graphLowerBoundBuilder_.setMessage(value);
            }

            return this;
          }
          /**
           * <pre>
           *&#64;&#64;      .. cpp:var:: LowerBound graph_lower_bound
           *&#64;&#64;
           *&#64;&#64;         Specify the lower bound of the CUDA graph. Optional.
           *&#64;&#64;         If specified, the graph can be used for input shapes and
           *&#64;&#64;         batch sizes that are in closed interval between the lower
           *&#64;&#64;         bound specification and graph specification. For dynamic
           *&#64;&#64;         shape model, this allows CUDA graphs to be launched
           *&#64;&#64;         frequently without capturing all possible shape combinations.
           *&#64;&#64;         However, using graph for shape combinations different from
           *&#64;&#64;         the one used for capturing introduces uninitialized data for
           *&#64;&#64;         execution and it may distort the inference result if
           *&#64;&#64;         the model is sensitive to uninitialized data.
           *&#64;&#64;
           * </pre>
           *
           * <code>.inference.ModelOptimizationPolicy.Cuda.GraphSpec.LowerBound graph_lower_bound = 3;</code>
           */
          public Builder setGraphLowerBound(
              org.apache.submarine.server.api.proto.TritonModelConfig.ModelOptimizationPolicy.Cuda.GraphSpec.LowerBound.Builder builderForValue) {
            if (graphLowerBoundBuilder_ == null) {
              graphLowerBound_ = builderForValue.build();
              onChanged();
            } else {
              graphLowerBoundBuilder_.setMessage(builderForValue.build());
            }

            return this;
          }
          /**
           * <pre>
           *&#64;&#64;      .. cpp:var:: LowerBound graph_lower_bound
           *&#64;&#64;
           *&#64;&#64;         Specify the lower bound of the CUDA graph. Optional.
           *&#64;&#64;         If specified, the graph can be used for input shapes and
           *&#64;&#64;         batch sizes that are in closed interval between the lower
           *&#64;&#64;         bound specification and graph specification. For dynamic
           *&#64;&#64;         shape model, this allows CUDA graphs to be launched
           *&#64;&#64;         frequently without capturing all possible shape combinations.
           *&#64;&#64;         However, using graph for shape combinations different from
           *&#64;&#64;         the one used for capturing introduces uninitialized data for
           *&#64;&#64;         execution and it may distort the inference result if
           *&#64;&#64;         the model is sensitive to uninitialized data.
           *&#64;&#64;
           * </pre>
           *
           * <code>.inference.ModelOptimizationPolicy.Cuda.GraphSpec.LowerBound graph_lower_bound = 3;</code>
           */
          public Builder mergeGraphLowerBound(org.apache.submarine.server.api.proto.TritonModelConfig.ModelOptimizationPolicy.Cuda.GraphSpec.LowerBound value) {
            if (graphLowerBoundBuilder_ == null) {
              if (graphLowerBound_ != null) {
                graphLowerBound_ =
                  org.apache.submarine.server.api.proto.TritonModelConfig.ModelOptimizationPolicy.Cuda.GraphSpec.LowerBound.newBuilder(graphLowerBound_).mergeFrom(value).buildPartial();
              } else {
                graphLowerBound_ = value;
              }
              onChanged();
            } else {
              graphLowerBoundBuilder_.mergeFrom(value);
            }

            return this;
          }
          /**
           * <pre>
           *&#64;&#64;      .. cpp:var:: LowerBound graph_lower_bound
           *&#64;&#64;
           *&#64;&#64;         Specify the lower bound of the CUDA graph. Optional.
           *&#64;&#64;         If specified, the graph can be used for input shapes and
           *&#64;&#64;         batch sizes that are in closed interval between the lower
           *&#64;&#64;         bound specification and graph specification. For dynamic
           *&#64;&#64;         shape model, this allows CUDA graphs to be launched
           *&#64;&#64;         frequently without capturing all possible shape combinations.
           *&#64;&#64;         However, using graph for shape combinations different from
           *&#64;&#64;         the one used for capturing introduces uninitialized data for
           *&#64;&#64;         execution and it may distort the inference result if
           *&#64;&#64;         the model is sensitive to uninitialized data.
           *&#64;&#64;
           * </pre>
           *
           * <code>.inference.ModelOptimizationPolicy.Cuda.GraphSpec.LowerBound graph_lower_bound = 3;</code>
           */
          public Builder clearGraphLowerBound() {
            if (graphLowerBoundBuilder_ == null) {
              graphLowerBound_ = null;
              onChanged();
            } else {
              graphLowerBound_ = null;
              graphLowerBoundBuilder_ = null;
            }

            return this;
          }
          /**
           * <pre>
           *&#64;&#64;      .. cpp:var:: LowerBound graph_lower_bound
           *&#64;&#64;
           *&#64;&#64;         Specify the lower bound of the CUDA graph. Optional.
           *&#64;&#64;         If specified, the graph can be used for input shapes and
           *&#64;&#64;         batch sizes that are in closed interval between the lower
           *&#64;&#64;         bound specification and graph specification. For dynamic
           *&#64;&#64;         shape model, this allows CUDA graphs to be launched
           *&#64;&#64;         frequently without capturing all possible shape combinations.
           *&#64;&#64;         However, using graph for shape combinations different from
           *&#64;&#64;         the one used for capturing introduces uninitialized data for
           *&#64;&#64;         execution and it may distort the inference result if
           *&#64;&#64;         the model is sensitive to uninitialized data.
           *&#64;&#64;
           * </pre>
           *
           * <code>.inference.ModelOptimizationPolicy.Cuda.GraphSpec.LowerBound graph_lower_bound = 3;</code>
           */
          public org.apache.submarine.server.api.proto.TritonModelConfig.ModelOptimizationPolicy.Cuda.GraphSpec.LowerBound.Builder getGraphLowerBoundBuilder() {
            
            onChanged();
            return getGraphLowerBoundFieldBuilder().getBuilder();
          }
          /**
           * <pre>
           *&#64;&#64;      .. cpp:var:: LowerBound graph_lower_bound
           *&#64;&#64;
           *&#64;&#64;         Specify the lower bound of the CUDA graph. Optional.
           *&#64;&#64;         If specified, the graph can be used for input shapes and
           *&#64;&#64;         batch sizes that are in closed interval between the lower
           *&#64;&#64;         bound specification and graph specification. For dynamic
           *&#64;&#64;         shape model, this allows CUDA graphs to be launched
           *&#64;&#64;         frequently without capturing all possible shape combinations.
           *&#64;&#64;         However, using graph for shape combinations different from
           *&#64;&#64;         the one used for capturing introduces uninitialized data for
           *&#64;&#64;         execution and it may distort the inference result if
           *&#64;&#64;         the model is sensitive to uninitialized data.
           *&#64;&#64;
           * </pre>
           *
           * <code>.inference.ModelOptimizationPolicy.Cuda.GraphSpec.LowerBound graph_lower_bound = 3;</code>
           */
          public org.apache.submarine.server.api.proto.TritonModelConfig.ModelOptimizationPolicy.Cuda.GraphSpec.LowerBoundOrBuilder getGraphLowerBoundOrBuilder() {
            if (graphLowerBoundBuilder_ != null) {
              return graphLowerBoundBuilder_.getMessageOrBuilder();
            } else {
              return graphLowerBound_ == null ?
                  org.apache.submarine.server.api.proto.TritonModelConfig.ModelOptimizationPolicy.Cuda.GraphSpec.LowerBound.getDefaultInstance() : graphLowerBound_;
            }
          }
          /**
           * <pre>
           *&#64;&#64;      .. cpp:var:: LowerBound graph_lower_bound
           *&#64;&#64;
           *&#64;&#64;         Specify the lower bound of the CUDA graph. Optional.
           *&#64;&#64;         If specified, the graph can be used for input shapes and
           *&#64;&#64;         batch sizes that are in closed interval between the lower
           *&#64;&#64;         bound specification and graph specification. For dynamic
           *&#64;&#64;         shape model, this allows CUDA graphs to be launched
           *&#64;&#64;         frequently without capturing all possible shape combinations.
           *&#64;&#64;         However, using graph for shape combinations different from
           *&#64;&#64;         the one used for capturing introduces uninitialized data for
           *&#64;&#64;         execution and it may distort the inference result if
           *&#64;&#64;         the model is sensitive to uninitialized data.
           *&#64;&#64;
           * </pre>
           *
           * <code>.inference.ModelOptimizationPolicy.Cuda.GraphSpec.LowerBound graph_lower_bound = 3;</code>
           */
          private com.google.protobuf.SingleFieldBuilderV3<
              org.apache.submarine.server.api.proto.TritonModelConfig.ModelOptimizationPolicy.Cuda.GraphSpec.LowerBound, org.apache.submarine.server.api.proto.TritonModelConfig.ModelOptimizationPolicy.Cuda.GraphSpec.LowerBound.Builder, org.apache.submarine.server.api.proto.TritonModelConfig.ModelOptimizationPolicy.Cuda.GraphSpec.LowerBoundOrBuilder> 
              getGraphLowerBoundFieldBuilder() {
            if (graphLowerBoundBuilder_ == null) {
              graphLowerBoundBuilder_ = new com.google.protobuf.SingleFieldBuilderV3<
                  org.apache.submarine.server.api.proto.TritonModelConfig.ModelOptimizationPolicy.Cuda.GraphSpec.LowerBound, org.apache.submarine.server.api.proto.TritonModelConfig.ModelOptimizationPolicy.Cuda.GraphSpec.LowerBound.Builder, org.apache.submarine.server.api.proto.TritonModelConfig.ModelOptimizationPolicy.Cuda.GraphSpec.LowerBoundOrBuilder>(
                      getGraphLowerBound(),
                      getParentForChildren(),
                      isClean());
              graphLowerBound_ = null;
            }
            return graphLowerBoundBuilder_;
          }
          @java.lang.Override
          public final Builder setUnknownFields(
              final com.google.protobuf.UnknownFieldSet unknownFields) {
            return super.setUnknownFields(unknownFields);
          }

          @java.lang.Override
          public final Builder mergeUnknownFields(
              final com.google.protobuf.UnknownFieldSet unknownFields) {
            return super.mergeUnknownFields(unknownFields);
          }


          // @@protoc_insertion_point(builder_scope:inference.ModelOptimizationPolicy.Cuda.GraphSpec)
        }

        // @@protoc_insertion_point(class_scope:inference.ModelOptimizationPolicy.Cuda.GraphSpec)
        private static final org.apache.submarine.server.api.proto.TritonModelConfig.ModelOptimizationPolicy.Cuda.GraphSpec DEFAULT_INSTANCE;
        static {
          DEFAULT_INSTANCE = new org.apache.submarine.server.api.proto.TritonModelConfig.ModelOptimizationPolicy.Cuda.GraphSpec();
        }

        public static org.apache.submarine.server.api.proto.TritonModelConfig.ModelOptimizationPolicy.Cuda.GraphSpec getDefaultInstance() {
          return DEFAULT_INSTANCE;
        }

        private static final com.google.protobuf.Parser<GraphSpec>
            PARSER = new com.google.protobuf.AbstractParser<GraphSpec>() {
          @java.lang.Override
          public GraphSpec parsePartialFrom(
              com.google.protobuf.CodedInputStream input,
              com.google.protobuf.ExtensionRegistryLite extensionRegistry)
              throws com.google.protobuf.InvalidProtocolBufferException {
            return new GraphSpec(input, extensionRegistry);
          }
        };

        public static com.google.protobuf.Parser<GraphSpec> parser() {
          return PARSER;
        }

        @java.lang.Override
        public com.google.protobuf.Parser<GraphSpec> getParserForType() {
          return PARSER;
        }

        @java.lang.Override
        public org.apache.submarine.server.api.proto.TritonModelConfig.ModelOptimizationPolicy.Cuda.GraphSpec getDefaultInstanceForType() {
          return DEFAULT_INSTANCE;
        }

      }

      public static final int GRAPHS_FIELD_NUMBER = 1;
      private boolean graphs_;
      /**
       * <pre>
       *&#64;&#64;    .. cpp:var:: bool graphs
       *&#64;&#64;
       *&#64;&#64;       Use CUDA graphs API to capture model operations and execute
       *&#64;&#64;       them more efficiently. Default value is false.
       *&#64;&#64;       Currently only recognized by TensorRT backend.
       *&#64;&#64;
       * </pre>
       *
       * <code>bool graphs = 1;</code>
       * @return The graphs.
       */
      @java.lang.Override
      public boolean getGraphs() {
        return graphs_;
      }

      public static final int BUSY_WAIT_EVENTS_FIELD_NUMBER = 2;
      private boolean busyWaitEvents_;
      /**
       * <pre>
       *&#64;&#64;    .. cpp:var:: bool busy_wait_events
       *&#64;&#64;
       *&#64;&#64;       Use busy-waiting to synchronize CUDA events to achieve minimum
       *&#64;&#64;       latency from event complete to host thread to be notified, with
       *&#64;&#64;       the cost of high CPU load. Default value is false.
       *&#64;&#64;       Currently only recognized by TensorRT backend.
       *&#64;&#64;
       * </pre>
       *
       * <code>bool busy_wait_events = 2;</code>
       * @return The busyWaitEvents.
       */
      @java.lang.Override
      public boolean getBusyWaitEvents() {
        return busyWaitEvents_;
      }

      public static final int GRAPH_SPEC_FIELD_NUMBER = 3;
      private java.util.List<org.apache.submarine.server.api.proto.TritonModelConfig.ModelOptimizationPolicy.Cuda.GraphSpec> graphSpec_;
      /**
       * <pre>
       *&#64;&#64;    .. cpp:var:: GraphSpec graph_spec (repeated)
       *&#64;&#64;
       *&#64;&#64;       Specification of the CUDA graph to be captured. If not specified
       *&#64;&#64;       and 'graphs' is true, the default CUDA graphs will be captured
       *&#64;&#64;       based on model settings.
       *&#64;&#64;       Currently only recognized by TensorRT backend.
       *&#64;&#64;
       * </pre>
       *
       * <code>repeated .inference.ModelOptimizationPolicy.Cuda.GraphSpec graph_spec = 3;</code>
       */
      @java.lang.Override
      public java.util.List<org.apache.submarine.server.api.proto.TritonModelConfig.ModelOptimizationPolicy.Cuda.GraphSpec> getGraphSpecList() {
        return graphSpec_;
      }
      /**
       * <pre>
       *&#64;&#64;    .. cpp:var:: GraphSpec graph_spec (repeated)
       *&#64;&#64;
       *&#64;&#64;       Specification of the CUDA graph to be captured. If not specified
       *&#64;&#64;       and 'graphs' is true, the default CUDA graphs will be captured
       *&#64;&#64;       based on model settings.
       *&#64;&#64;       Currently only recognized by TensorRT backend.
       *&#64;&#64;
       * </pre>
       *
       * <code>repeated .inference.ModelOptimizationPolicy.Cuda.GraphSpec graph_spec = 3;</code>
       */
      @java.lang.Override
      public java.util.List<? extends org.apache.submarine.server.api.proto.TritonModelConfig.ModelOptimizationPolicy.Cuda.GraphSpecOrBuilder> 
          getGraphSpecOrBuilderList() {
        return graphSpec_;
      }
      /**
       * <pre>
       *&#64;&#64;    .. cpp:var:: GraphSpec graph_spec (repeated)
       *&#64;&#64;
       *&#64;&#64;       Specification of the CUDA graph to be captured. If not specified
       *&#64;&#64;       and 'graphs' is true, the default CUDA graphs will be captured
       *&#64;&#64;       based on model settings.
       *&#64;&#64;       Currently only recognized by TensorRT backend.
       *&#64;&#64;
       * </pre>
       *
       * <code>repeated .inference.ModelOptimizationPolicy.Cuda.GraphSpec graph_spec = 3;</code>
       */
      @java.lang.Override
      public int getGraphSpecCount() {
        return graphSpec_.size();
      }
      /**
       * <pre>
       *&#64;&#64;    .. cpp:var:: GraphSpec graph_spec (repeated)
       *&#64;&#64;
       *&#64;&#64;       Specification of the CUDA graph to be captured. If not specified
       *&#64;&#64;       and 'graphs' is true, the default CUDA graphs will be captured
       *&#64;&#64;       based on model settings.
       *&#64;&#64;       Currently only recognized by TensorRT backend.
       *&#64;&#64;
       * </pre>
       *
       * <code>repeated .inference.ModelOptimizationPolicy.Cuda.GraphSpec graph_spec = 3;</code>
       */
      @java.lang.Override
      public org.apache.submarine.server.api.proto.TritonModelConfig.ModelOptimizationPolicy.Cuda.GraphSpec getGraphSpec(int index) {
        return graphSpec_.get(index);
      }
      /**
       * <pre>
       *&#64;&#64;    .. cpp:var:: GraphSpec graph_spec (repeated)
       *&#64;&#64;
       *&#64;&#64;       Specification of the CUDA graph to be captured. If not specified
       *&#64;&#64;       and 'graphs' is true, the default CUDA graphs will be captured
       *&#64;&#64;       based on model settings.
       *&#64;&#64;       Currently only recognized by TensorRT backend.
       *&#64;&#64;
       * </pre>
       *
       * <code>repeated .inference.ModelOptimizationPolicy.Cuda.GraphSpec graph_spec = 3;</code>
       */
      @java.lang.Override
      public org.apache.submarine.server.api.proto.TritonModelConfig.ModelOptimizationPolicy.Cuda.GraphSpecOrBuilder getGraphSpecOrBuilder(
          int index) {
        return graphSpec_.get(index);
      }

      public static final int OUTPUT_COPY_STREAM_FIELD_NUMBER = 4;
      private boolean outputCopyStream_;
      /**
       * <pre>
       *&#64;&#64;    .. cpp:var:: bool output_copy_stream
       *&#64;&#64;
       *&#64;&#64;       Uses a CUDA stream separate from the inference stream to copy the
       *&#64;&#64;       output to host. However, be aware that setting this option to
       *&#64;&#64;       true will lead to an increase in the memory consumption of the
       *&#64;&#64;       model as Triton will allocate twice as much GPU memory for its
       *&#64;&#64;       I/O tensor buffers. Default value is false.
       *&#64;&#64;       Currently only recognized by TensorRT backend.
       *&#64;&#64;
       * </pre>
       *
       * <code>bool output_copy_stream = 4;</code>
       * @return The outputCopyStream.
       */
      @java.lang.Override
      public boolean getOutputCopyStream() {
        return outputCopyStream_;
      }

      private byte memoizedIsInitialized = -1;
      @java.lang.Override
      public final boolean isInitialized() {
        byte isInitialized = memoizedIsInitialized;
        if (isInitialized == 1) return true;
        if (isInitialized == 0) return false;

        memoizedIsInitialized = 1;
        return true;
      }

      @java.lang.Override
      public void writeTo(com.google.protobuf.CodedOutputStream output)
                          throws java.io.IOException {
        if (graphs_ != false) {
          output.writeBool(1, graphs_);
        }
        if (busyWaitEvents_ != false) {
          output.writeBool(2, busyWaitEvents_);
        }
        for (int i = 0; i < graphSpec_.size(); i++) {
          output.writeMessage(3, graphSpec_.get(i));
        }
        if (outputCopyStream_ != false) {
          output.writeBool(4, outputCopyStream_);
        }
        unknownFields.writeTo(output);
      }

      @java.lang.Override
      public int getSerializedSize() {
        int size = memoizedSize;
        if (size != -1) return size;

        size = 0;
        if (graphs_ != false) {
          size += com.google.protobuf.CodedOutputStream
            .computeBoolSize(1, graphs_);
        }
        if (busyWaitEvents_ != false) {
          size += com.google.protobuf.CodedOutputStream
            .computeBoolSize(2, busyWaitEvents_);
        }
        for (int i = 0; i < graphSpec_.size(); i++) {
          size += com.google.protobuf.CodedOutputStream
            .computeMessageSize(3, graphSpec_.get(i));
        }
        if (outputCopyStream_ != false) {
          size += com.google.protobuf.CodedOutputStream
            .computeBoolSize(4, outputCopyStream_);
        }
        size += unknownFields.getSerializedSize();
        memoizedSize = size;
        return size;
      }

      @java.lang.Override
      public boolean equals(final java.lang.Object obj) {
        if (obj == this) {
         return true;
        }
        if (!(obj instanceof org.apache.submarine.server.api.proto.TritonModelConfig.ModelOptimizationPolicy.Cuda)) {
          return super.equals(obj);
        }
        org.apache.submarine.server.api.proto.TritonModelConfig.ModelOptimizationPolicy.Cuda other = (org.apache.submarine.server.api.proto.TritonModelConfig.ModelOptimizationPolicy.Cuda) obj;

        if (getGraphs()
            != other.getGraphs()) return false;
        if (getBusyWaitEvents()
            != other.getBusyWaitEvents()) return false;
        if (!getGraphSpecList()
            .equals(other.getGraphSpecList())) return false;
        if (getOutputCopyStream()
            != other.getOutputCopyStream()) return false;
        if (!unknownFields.equals(other.unknownFields)) return false;
        return true;
      }

      @java.lang.Override
      public int hashCode() {
        if (memoizedHashCode != 0) {
          return memoizedHashCode;
        }
        int hash = 41;
        hash = (19 * hash) + getDescriptor().hashCode();
        hash = (37 * hash) + GRAPHS_FIELD_NUMBER;
        hash = (53 * hash) + com.google.protobuf.Internal.hashBoolean(
            getGraphs());
        hash = (37 * hash) + BUSY_WAIT_EVENTS_FIELD_NUMBER;
        hash = (53 * hash) + com.google.protobuf.Internal.hashBoolean(
            getBusyWaitEvents());
        if (getGraphSpecCount() > 0) {
          hash = (37 * hash) + GRAPH_SPEC_FIELD_NUMBER;
          hash = (53 * hash) + getGraphSpecList().hashCode();
        }
        hash = (37 * hash) + OUTPUT_COPY_STREAM_FIELD_NUMBER;
        hash = (53 * hash) + com.google.protobuf.Internal.hashBoolean(
            getOutputCopyStream());
        hash = (29 * hash) + unknownFields.hashCode();
        memoizedHashCode = hash;
        return hash;
      }

      public static org.apache.submarine.server.api.proto.TritonModelConfig.ModelOptimizationPolicy.Cuda parseFrom(
          java.nio.ByteBuffer data)
          throws com.google.protobuf.InvalidProtocolBufferException {
        return PARSER.parseFrom(data);
      }
      public static org.apache.submarine.server.api.proto.TritonModelConfig.ModelOptimizationPolicy.Cuda parseFrom(
          java.nio.ByteBuffer data,
          com.google.protobuf.ExtensionRegistryLite extensionRegistry)
          throws com.google.protobuf.InvalidProtocolBufferException {
        return PARSER.parseFrom(data, extensionRegistry);
      }
      public static org.apache.submarine.server.api.proto.TritonModelConfig.ModelOptimizationPolicy.Cuda parseFrom(
          com.google.protobuf.ByteString data)
          throws com.google.protobuf.InvalidProtocolBufferException {
        return PARSER.parseFrom(data);
      }
      public static org.apache.submarine.server.api.proto.TritonModelConfig.ModelOptimizationPolicy.Cuda parseFrom(
          com.google.protobuf.ByteString data,
          com.google.protobuf.ExtensionRegistryLite extensionRegistry)
          throws com.google.protobuf.InvalidProtocolBufferException {
        return PARSER.parseFrom(data, extensionRegistry);
      }
      public static org.apache.submarine.server.api.proto.TritonModelConfig.ModelOptimizationPolicy.Cuda parseFrom(byte[] data)
          throws com.google.protobuf.InvalidProtocolBufferException {
        return PARSER.parseFrom(data);
      }
      public static org.apache.submarine.server.api.proto.TritonModelConfig.ModelOptimizationPolicy.Cuda parseFrom(
          byte[] data,
          com.google.protobuf.ExtensionRegistryLite extensionRegistry)
          throws com.google.protobuf.InvalidProtocolBufferException {
        return PARSER.parseFrom(data, extensionRegistry);
      }
      public static org.apache.submarine.server.api.proto.TritonModelConfig.ModelOptimizationPolicy.Cuda parseFrom(java.io.InputStream input)
          throws java.io.IOException {
        return com.google.protobuf.GeneratedMessageV3
            .parseWithIOException(PARSER, input);
      }
      public static org.apache.submarine.server.api.proto.TritonModelConfig.ModelOptimizationPolicy.Cuda parseFrom(
          java.io.InputStream input,
          com.google.protobuf.ExtensionRegistryLite extensionRegistry)
          throws java.io.IOException {
        return com.google.protobuf.GeneratedMessageV3
            .parseWithIOException(PARSER, input, extensionRegistry);
      }
      public static org.apache.submarine.server.api.proto.TritonModelConfig.ModelOptimizationPolicy.Cuda parseDelimitedFrom(java.io.InputStream input)
          throws java.io.IOException {
        return com.google.protobuf.GeneratedMessageV3
            .parseDelimitedWithIOException(PARSER, input);
      }
      public static org.apache.submarine.server.api.proto.TritonModelConfig.ModelOptimizationPolicy.Cuda parseDelimitedFrom(
          java.io.InputStream input,
          com.google.protobuf.ExtensionRegistryLite extensionRegistry)
          throws java.io.IOException {
        return com.google.protobuf.GeneratedMessageV3
            .parseDelimitedWithIOException(PARSER, input, extensionRegistry);
      }
      public static org.apache.submarine.server.api.proto.TritonModelConfig.ModelOptimizationPolicy.Cuda parseFrom(
          com.google.protobuf.CodedInputStream input)
          throws java.io.IOException {
        return com.google.protobuf.GeneratedMessageV3
            .parseWithIOException(PARSER, input);
      }
      public static org.apache.submarine.server.api.proto.TritonModelConfig.ModelOptimizationPolicy.Cuda parseFrom(
          com.google.protobuf.CodedInputStream input,
          com.google.protobuf.ExtensionRegistryLite extensionRegistry)
          throws java.io.IOException {
        return com.google.protobuf.GeneratedMessageV3
            .parseWithIOException(PARSER, input, extensionRegistry);
      }

      @java.lang.Override
      public Builder newBuilderForType() { return newBuilder(); }
      public static Builder newBuilder() {
        return DEFAULT_INSTANCE.toBuilder();
      }
      public static Builder newBuilder(org.apache.submarine.server.api.proto.TritonModelConfig.ModelOptimizationPolicy.Cuda prototype) {
        return DEFAULT_INSTANCE.toBuilder().mergeFrom(prototype);
      }
      @java.lang.Override
      public Builder toBuilder() {
        return this == DEFAULT_INSTANCE
            ? new Builder() : new Builder().mergeFrom(this);
      }

      @java.lang.Override
      protected Builder newBuilderForType(
          com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
        Builder builder = new Builder(parent);
        return builder;
      }
      /**
       * <pre>
       *&#64;&#64;
       *&#64;&#64;  .. cpp:var:: message Cuda
       *&#64;&#64;
       *&#64;&#64;     CUDA-specific optimization settings.
       *&#64;&#64;
       * </pre>
       *
       * Protobuf type {@code inference.ModelOptimizationPolicy.Cuda}
       */
      public static final class Builder extends
          com.google.protobuf.GeneratedMessageV3.Builder<Builder> implements
          // @@protoc_insertion_point(builder_implements:inference.ModelOptimizationPolicy.Cuda)
          org.apache.submarine.server.api.proto.TritonModelConfig.ModelOptimizationPolicy.CudaOrBuilder {
        public static final com.google.protobuf.Descriptors.Descriptor
            getDescriptor() {
          return org.apache.submarine.server.api.proto.TritonModelConfig.internal_static_inference_ModelOptimizationPolicy_Cuda_descriptor;
        }

        @java.lang.Override
        protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
            internalGetFieldAccessorTable() {
          return org.apache.submarine.server.api.proto.TritonModelConfig.internal_static_inference_ModelOptimizationPolicy_Cuda_fieldAccessorTable
              .ensureFieldAccessorsInitialized(
                  org.apache.submarine.server.api.proto.TritonModelConfig.ModelOptimizationPolicy.Cuda.class, org.apache.submarine.server.api.proto.TritonModelConfig.ModelOptimizationPolicy.Cuda.Builder.class);
        }

        // Construct using org.apache.submarine.server.api.proto.TritonModelConfig.ModelOptimizationPolicy.Cuda.newBuilder()
        private Builder() {
          maybeForceBuilderInitialization();
        }

        private Builder(
            com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
          super(parent);
          maybeForceBuilderInitialization();
        }
        private void maybeForceBuilderInitialization() {
          if (com.google.protobuf.GeneratedMessageV3
                  .alwaysUseFieldBuilders) {
            getGraphSpecFieldBuilder();
          }
        }
        @java.lang.Override
        public Builder clear() {
          super.clear();
          graphs_ = false;

          busyWaitEvents_ = false;

          if (graphSpecBuilder_ == null) {
            graphSpec_ = java.util.Collections.emptyList();
            bitField0_ = (bitField0_ & ~0x00000001);
          } else {
            graphSpecBuilder_.clear();
          }
          outputCopyStream_ = false;

          return this;
        }

        @java.lang.Override
        public com.google.protobuf.Descriptors.Descriptor
            getDescriptorForType() {
          return org.apache.submarine.server.api.proto.TritonModelConfig.internal_static_inference_ModelOptimizationPolicy_Cuda_descriptor;
        }

        @java.lang.Override
        public org.apache.submarine.server.api.proto.TritonModelConfig.ModelOptimizationPolicy.Cuda getDefaultInstanceForType() {
          return org.apache.submarine.server.api.proto.TritonModelConfig.ModelOptimizationPolicy.Cuda.getDefaultInstance();
        }

        @java.lang.Override
        public org.apache.submarine.server.api.proto.TritonModelConfig.ModelOptimizationPolicy.Cuda build() {
          org.apache.submarine.server.api.proto.TritonModelConfig.ModelOptimizationPolicy.Cuda result = buildPartial();
          if (!result.isInitialized()) {
            throw newUninitializedMessageException(result);
          }
          return result;
        }

        @java.lang.Override
        public org.apache.submarine.server.api.proto.TritonModelConfig.ModelOptimizationPolicy.Cuda buildPartial() {
          org.apache.submarine.server.api.proto.TritonModelConfig.ModelOptimizationPolicy.Cuda result = new org.apache.submarine.server.api.proto.TritonModelConfig.ModelOptimizationPolicy.Cuda(this);
          int from_bitField0_ = bitField0_;
          result.graphs_ = graphs_;
          result.busyWaitEvents_ = busyWaitEvents_;
          if (graphSpecBuilder_ == null) {
            if (((bitField0_ & 0x00000001) != 0)) {
              graphSpec_ = java.util.Collections.unmodifiableList(graphSpec_);
              bitField0_ = (bitField0_ & ~0x00000001);
            }
            result.graphSpec_ = graphSpec_;
          } else {
            result.graphSpec_ = graphSpecBuilder_.build();
          }
          result.outputCopyStream_ = outputCopyStream_;
          onBuilt();
          return result;
        }

        @java.lang.Override
        public Builder clone() {
          return super.clone();
        }
        @java.lang.Override
        public Builder setField(
            com.google.protobuf.Descriptors.FieldDescriptor field,
            java.lang.Object value) {
          return super.setField(field, value);
        }
        @java.lang.Override
        public Builder clearField(
            com.google.protobuf.Descriptors.FieldDescriptor field) {
          return super.clearField(field);
        }
        @java.lang.Override
        public Builder clearOneof(
            com.google.protobuf.Descriptors.OneofDescriptor oneof) {
          return super.clearOneof(oneof);
        }
        @java.lang.Override
        public Builder setRepeatedField(
            com.google.protobuf.Descriptors.FieldDescriptor field,
            int index, java.lang.Object value) {
          return super.setRepeatedField(field, index, value);
        }
        @java.lang.Override
        public Builder addRepeatedField(
            com.google.protobuf.Descriptors.FieldDescriptor field,
            java.lang.Object value) {
          return super.addRepeatedField(field, value);
        }
        @java.lang.Override
        public Builder mergeFrom(com.google.protobuf.Message other) {
          if (other instanceof org.apache.submarine.server.api.proto.TritonModelConfig.ModelOptimizationPolicy.Cuda) {
            return mergeFrom((org.apache.submarine.server.api.proto.TritonModelConfig.ModelOptimizationPolicy.Cuda)other);
          } else {
            super.mergeFrom(other);
            return this;
          }
        }

        public Builder mergeFrom(org.apache.submarine.server.api.proto.TritonModelConfig.ModelOptimizationPolicy.Cuda other) {
          if (other == org.apache.submarine.server.api.proto.TritonModelConfig.ModelOptimizationPolicy.Cuda.getDefaultInstance()) return this;
          if (other.getGraphs() != false) {
            setGraphs(other.getGraphs());
          }
          if (other.getBusyWaitEvents() != false) {
            setBusyWaitEvents(other.getBusyWaitEvents());
          }
          if (graphSpecBuilder_ == null) {
            if (!other.graphSpec_.isEmpty()) {
              if (graphSpec_.isEmpty()) {
                graphSpec_ = other.graphSpec_;
                bitField0_ = (bitField0_ & ~0x00000001);
              } else {
                ensureGraphSpecIsMutable();
                graphSpec_.addAll(other.graphSpec_);
              }
              onChanged();
            }
          } else {
            if (!other.graphSpec_.isEmpty()) {
              if (graphSpecBuilder_.isEmpty()) {
                graphSpecBuilder_.dispose();
                graphSpecBuilder_ = null;
                graphSpec_ = other.graphSpec_;
                bitField0_ = (bitField0_ & ~0x00000001);
                graphSpecBuilder_ = 
                  com.google.protobuf.GeneratedMessageV3.alwaysUseFieldBuilders ?
                     getGraphSpecFieldBuilder() : null;
              } else {
                graphSpecBuilder_.addAllMessages(other.graphSpec_);
              }
            }
          }
          if (other.getOutputCopyStream() != false) {
            setOutputCopyStream(other.getOutputCopyStream());
          }
          this.mergeUnknownFields(other.unknownFields);
          onChanged();
          return this;
        }

        @java.lang.Override
        public final boolean isInitialized() {
          return true;
        }

        @java.lang.Override
        public Builder mergeFrom(
            com.google.protobuf.CodedInputStream input,
            com.google.protobuf.ExtensionRegistryLite extensionRegistry)
            throws java.io.IOException {
          org.apache.submarine.server.api.proto.TritonModelConfig.ModelOptimizationPolicy.Cuda parsedMessage = null;
          try {
            parsedMessage = PARSER.parsePartialFrom(input, extensionRegistry);
          } catch (com.google.protobuf.InvalidProtocolBufferException e) {
            parsedMessage = (org.apache.submarine.server.api.proto.TritonModelConfig.ModelOptimizationPolicy.Cuda) e.getUnfinishedMessage();
            throw e.unwrapIOException();
          } finally {
            if (parsedMessage != null) {
              mergeFrom(parsedMessage);
            }
          }
          return this;
        }
        private int bitField0_;

        private boolean graphs_ ;
        /**
         * <pre>
         *&#64;&#64;    .. cpp:var:: bool graphs
         *&#64;&#64;
         *&#64;&#64;       Use CUDA graphs API to capture model operations and execute
         *&#64;&#64;       them more efficiently. Default value is false.
         *&#64;&#64;       Currently only recognized by TensorRT backend.
         *&#64;&#64;
         * </pre>
         *
         * <code>bool graphs = 1;</code>
         * @return The graphs.
         */
        @java.lang.Override
        public boolean getGraphs() {
          return graphs_;
        }
        /**
         * <pre>
         *&#64;&#64;    .. cpp:var:: bool graphs
         *&#64;&#64;
         *&#64;&#64;       Use CUDA graphs API to capture model operations and execute
         *&#64;&#64;       them more efficiently. Default value is false.
         *&#64;&#64;       Currently only recognized by TensorRT backend.
         *&#64;&#64;
         * </pre>
         *
         * <code>bool graphs = 1;</code>
         * @param value The graphs to set.
         * @return This builder for chaining.
         */
        public Builder setGraphs(boolean value) {
          
          graphs_ = value;
          onChanged();
          return this;
        }
        /**
         * <pre>
         *&#64;&#64;    .. cpp:var:: bool graphs
         *&#64;&#64;
         *&#64;&#64;       Use CUDA graphs API to capture model operations and execute
         *&#64;&#64;       them more efficiently. Default value is false.
         *&#64;&#64;       Currently only recognized by TensorRT backend.
         *&#64;&#64;
         * </pre>
         *
         * <code>bool graphs = 1;</code>
         * @return This builder for chaining.
         */
        public Builder clearGraphs() {
          
          graphs_ = false;
          onChanged();
          return this;
        }

        private boolean busyWaitEvents_ ;
        /**
         * <pre>
         *&#64;&#64;    .. cpp:var:: bool busy_wait_events
         *&#64;&#64;
         *&#64;&#64;       Use busy-waiting to synchronize CUDA events to achieve minimum
         *&#64;&#64;       latency from event complete to host thread to be notified, with
         *&#64;&#64;       the cost of high CPU load. Default value is false.
         *&#64;&#64;       Currently only recognized by TensorRT backend.
         *&#64;&#64;
         * </pre>
         *
         * <code>bool busy_wait_events = 2;</code>
         * @return The busyWaitEvents.
         */
        @java.lang.Override
        public boolean getBusyWaitEvents() {
          return busyWaitEvents_;
        }
        /**
         * <pre>
         *&#64;&#64;    .. cpp:var:: bool busy_wait_events
         *&#64;&#64;
         *&#64;&#64;       Use busy-waiting to synchronize CUDA events to achieve minimum
         *&#64;&#64;       latency from event complete to host thread to be notified, with
         *&#64;&#64;       the cost of high CPU load. Default value is false.
         *&#64;&#64;       Currently only recognized by TensorRT backend.
         *&#64;&#64;
         * </pre>
         *
         * <code>bool busy_wait_events = 2;</code>
         * @param value The busyWaitEvents to set.
         * @return This builder for chaining.
         */
        public Builder setBusyWaitEvents(boolean value) {
          
          busyWaitEvents_ = value;
          onChanged();
          return this;
        }
        /**
         * <pre>
         *&#64;&#64;    .. cpp:var:: bool busy_wait_events
         *&#64;&#64;
         *&#64;&#64;       Use busy-waiting to synchronize CUDA events to achieve minimum
         *&#64;&#64;       latency from event complete to host thread to be notified, with
         *&#64;&#64;       the cost of high CPU load. Default value is false.
         *&#64;&#64;       Currently only recognized by TensorRT backend.
         *&#64;&#64;
         * </pre>
         *
         * <code>bool busy_wait_events = 2;</code>
         * @return This builder for chaining.
         */
        public Builder clearBusyWaitEvents() {
          
          busyWaitEvents_ = false;
          onChanged();
          return this;
        }

        private java.util.List<org.apache.submarine.server.api.proto.TritonModelConfig.ModelOptimizationPolicy.Cuda.GraphSpec> graphSpec_ =
          java.util.Collections.emptyList();
        private void ensureGraphSpecIsMutable() {
          if (!((bitField0_ & 0x00000001) != 0)) {
            graphSpec_ = new java.util.ArrayList<org.apache.submarine.server.api.proto.TritonModelConfig.ModelOptimizationPolicy.Cuda.GraphSpec>(graphSpec_);
            bitField0_ |= 0x00000001;
           }
        }

        private com.google.protobuf.RepeatedFieldBuilderV3<
            org.apache.submarine.server.api.proto.TritonModelConfig.ModelOptimizationPolicy.Cuda.GraphSpec, org.apache.submarine.server.api.proto.TritonModelConfig.ModelOptimizationPolicy.Cuda.GraphSpec.Builder, org.apache.submarine.server.api.proto.TritonModelConfig.ModelOptimizationPolicy.Cuda.GraphSpecOrBuilder> graphSpecBuilder_;

        /**
         * <pre>
         *&#64;&#64;    .. cpp:var:: GraphSpec graph_spec (repeated)
         *&#64;&#64;
         *&#64;&#64;       Specification of the CUDA graph to be captured. If not specified
         *&#64;&#64;       and 'graphs' is true, the default CUDA graphs will be captured
         *&#64;&#64;       based on model settings.
         *&#64;&#64;       Currently only recognized by TensorRT backend.
         *&#64;&#64;
         * </pre>
         *
         * <code>repeated .inference.ModelOptimizationPolicy.Cuda.GraphSpec graph_spec = 3;</code>
         */
        public java.util.List<org.apache.submarine.server.api.proto.TritonModelConfig.ModelOptimizationPolicy.Cuda.GraphSpec> getGraphSpecList() {
          if (graphSpecBuilder_ == null) {
            return java.util.Collections.unmodifiableList(graphSpec_);
          } else {
            return graphSpecBuilder_.getMessageList();
          }
        }
        /**
         * <pre>
         *&#64;&#64;    .. cpp:var:: GraphSpec graph_spec (repeated)
         *&#64;&#64;
         *&#64;&#64;       Specification of the CUDA graph to be captured. If not specified
         *&#64;&#64;       and 'graphs' is true, the default CUDA graphs will be captured
         *&#64;&#64;       based on model settings.
         *&#64;&#64;       Currently only recognized by TensorRT backend.
         *&#64;&#64;
         * </pre>
         *
         * <code>repeated .inference.ModelOptimizationPolicy.Cuda.GraphSpec graph_spec = 3;</code>
         */
        public int getGraphSpecCount() {
          if (graphSpecBuilder_ == null) {
            return graphSpec_.size();
          } else {
            return graphSpecBuilder_.getCount();
          }
        }
        /**
         * <pre>
         *&#64;&#64;    .. cpp:var:: GraphSpec graph_spec (repeated)
         *&#64;&#64;
         *&#64;&#64;       Specification of the CUDA graph to be captured. If not specified
         *&#64;&#64;       and 'graphs' is true, the default CUDA graphs will be captured
         *&#64;&#64;       based on model settings.
         *&#64;&#64;       Currently only recognized by TensorRT backend.
         *&#64;&#64;
         * </pre>
         *
         * <code>repeated .inference.ModelOptimizationPolicy.Cuda.GraphSpec graph_spec = 3;</code>
         */
        public org.apache.submarine.server.api.proto.TritonModelConfig.ModelOptimizationPolicy.Cuda.GraphSpec getGraphSpec(int index) {
          if (graphSpecBuilder_ == null) {
            return graphSpec_.get(index);
          } else {
            return graphSpecBuilder_.getMessage(index);
          }
        }
        /**
         * <pre>
         *&#64;&#64;    .. cpp:var:: GraphSpec graph_spec (repeated)
         *&#64;&#64;
         *&#64;&#64;       Specification of the CUDA graph to be captured. If not specified
         *&#64;&#64;       and 'graphs' is true, the default CUDA graphs will be captured
         *&#64;&#64;       based on model settings.
         *&#64;&#64;       Currently only recognized by TensorRT backend.
         *&#64;&#64;
         * </pre>
         *
         * <code>repeated .inference.ModelOptimizationPolicy.Cuda.GraphSpec graph_spec = 3;</code>
         */
        public Builder setGraphSpec(
            int index, org.apache.submarine.server.api.proto.TritonModelConfig.ModelOptimizationPolicy.Cuda.GraphSpec value) {
          if (graphSpecBuilder_ == null) {
            if (value == null) {
              throw new NullPointerException();
            }
            ensureGraphSpecIsMutable();
            graphSpec_.set(index, value);
            onChanged();
          } else {
            graphSpecBuilder_.setMessage(index, value);
          }
          return this;
        }
        /**
         * <pre>
         *&#64;&#64;    .. cpp:var:: GraphSpec graph_spec (repeated)
         *&#64;&#64;
         *&#64;&#64;       Specification of the CUDA graph to be captured. If not specified
         *&#64;&#64;       and 'graphs' is true, the default CUDA graphs will be captured
         *&#64;&#64;       based on model settings.
         *&#64;&#64;       Currently only recognized by TensorRT backend.
         *&#64;&#64;
         * </pre>
         *
         * <code>repeated .inference.ModelOptimizationPolicy.Cuda.GraphSpec graph_spec = 3;</code>
         */
        public Builder setGraphSpec(
            int index, org.apache.submarine.server.api.proto.TritonModelConfig.ModelOptimizationPolicy.Cuda.GraphSpec.Builder builderForValue) {
          if (graphSpecBuilder_ == null) {
            ensureGraphSpecIsMutable();
            graphSpec_.set(index, builderForValue.build());
            onChanged();
          } else {
            graphSpecBuilder_.setMessage(index, builderForValue.build());
          }
          return this;
        }
        /**
         * <pre>
         *&#64;&#64;    .. cpp:var:: GraphSpec graph_spec (repeated)
         *&#64;&#64;
         *&#64;&#64;       Specification of the CUDA graph to be captured. If not specified
         *&#64;&#64;       and 'graphs' is true, the default CUDA graphs will be captured
         *&#64;&#64;       based on model settings.
         *&#64;&#64;       Currently only recognized by TensorRT backend.
         *&#64;&#64;
         * </pre>
         *
         * <code>repeated .inference.ModelOptimizationPolicy.Cuda.GraphSpec graph_spec = 3;</code>
         */
        public Builder addGraphSpec(org.apache.submarine.server.api.proto.TritonModelConfig.ModelOptimizationPolicy.Cuda.GraphSpec value) {
          if (graphSpecBuilder_ == null) {
            if (value == null) {
              throw new NullPointerException();
            }
            ensureGraphSpecIsMutable();
            graphSpec_.add(value);
            onChanged();
          } else {
            graphSpecBuilder_.addMessage(value);
          }
          return this;
        }
        /**
         * <pre>
         *&#64;&#64;    .. cpp:var:: GraphSpec graph_spec (repeated)
         *&#64;&#64;
         *&#64;&#64;       Specification of the CUDA graph to be captured. If not specified
         *&#64;&#64;       and 'graphs' is true, the default CUDA graphs will be captured
         *&#64;&#64;       based on model settings.
         *&#64;&#64;       Currently only recognized by TensorRT backend.
         *&#64;&#64;
         * </pre>
         *
         * <code>repeated .inference.ModelOptimizationPolicy.Cuda.GraphSpec graph_spec = 3;</code>
         */
        public Builder addGraphSpec(
            int index, org.apache.submarine.server.api.proto.TritonModelConfig.ModelOptimizationPolicy.Cuda.GraphSpec value) {
          if (graphSpecBuilder_ == null) {
            if (value == null) {
              throw new NullPointerException();
            }
            ensureGraphSpecIsMutable();
            graphSpec_.add(index, value);
            onChanged();
          } else {
            graphSpecBuilder_.addMessage(index, value);
          }
          return this;
        }
        /**
         * <pre>
         *&#64;&#64;    .. cpp:var:: GraphSpec graph_spec (repeated)
         *&#64;&#64;
         *&#64;&#64;       Specification of the CUDA graph to be captured. If not specified
         *&#64;&#64;       and 'graphs' is true, the default CUDA graphs will be captured
         *&#64;&#64;       based on model settings.
         *&#64;&#64;       Currently only recognized by TensorRT backend.
         *&#64;&#64;
         * </pre>
         *
         * <code>repeated .inference.ModelOptimizationPolicy.Cuda.GraphSpec graph_spec = 3;</code>
         */
        public Builder addGraphSpec(
            org.apache.submarine.server.api.proto.TritonModelConfig.ModelOptimizationPolicy.Cuda.GraphSpec.Builder builderForValue) {
          if (graphSpecBuilder_ == null) {
            ensureGraphSpecIsMutable();
            graphSpec_.add(builderForValue.build());
            onChanged();
          } else {
            graphSpecBuilder_.addMessage(builderForValue.build());
          }
          return this;
        }
        /**
         * <pre>
         *&#64;&#64;    .. cpp:var:: GraphSpec graph_spec (repeated)
         *&#64;&#64;
         *&#64;&#64;       Specification of the CUDA graph to be captured. If not specified
         *&#64;&#64;       and 'graphs' is true, the default CUDA graphs will be captured
         *&#64;&#64;       based on model settings.
         *&#64;&#64;       Currently only recognized by TensorRT backend.
         *&#64;&#64;
         * </pre>
         *
         * <code>repeated .inference.ModelOptimizationPolicy.Cuda.GraphSpec graph_spec = 3;</code>
         */
        public Builder addGraphSpec(
            int index, org.apache.submarine.server.api.proto.TritonModelConfig.ModelOptimizationPolicy.Cuda.GraphSpec.Builder builderForValue) {
          if (graphSpecBuilder_ == null) {
            ensureGraphSpecIsMutable();
            graphSpec_.add(index, builderForValue.build());
            onChanged();
          } else {
            graphSpecBuilder_.addMessage(index, builderForValue.build());
          }
          return this;
        }
        /**
         * <pre>
         *&#64;&#64;    .. cpp:var:: GraphSpec graph_spec (repeated)
         *&#64;&#64;
         *&#64;&#64;       Specification of the CUDA graph to be captured. If not specified
         *&#64;&#64;       and 'graphs' is true, the default CUDA graphs will be captured
         *&#64;&#64;       based on model settings.
         *&#64;&#64;       Currently only recognized by TensorRT backend.
         *&#64;&#64;
         * </pre>
         *
         * <code>repeated .inference.ModelOptimizationPolicy.Cuda.GraphSpec graph_spec = 3;</code>
         */
        public Builder addAllGraphSpec(
            java.lang.Iterable<? extends org.apache.submarine.server.api.proto.TritonModelConfig.ModelOptimizationPolicy.Cuda.GraphSpec> values) {
          if (graphSpecBuilder_ == null) {
            ensureGraphSpecIsMutable();
            com.google.protobuf.AbstractMessageLite.Builder.addAll(
                values, graphSpec_);
            onChanged();
          } else {
            graphSpecBuilder_.addAllMessages(values);
          }
          return this;
        }
        /**
         * <pre>
         *&#64;&#64;    .. cpp:var:: GraphSpec graph_spec (repeated)
         *&#64;&#64;
         *&#64;&#64;       Specification of the CUDA graph to be captured. If not specified
         *&#64;&#64;       and 'graphs' is true, the default CUDA graphs will be captured
         *&#64;&#64;       based on model settings.
         *&#64;&#64;       Currently only recognized by TensorRT backend.
         *&#64;&#64;
         * </pre>
         *
         * <code>repeated .inference.ModelOptimizationPolicy.Cuda.GraphSpec graph_spec = 3;</code>
         */
        public Builder clearGraphSpec() {
          if (graphSpecBuilder_ == null) {
            graphSpec_ = java.util.Collections.emptyList();
            bitField0_ = (bitField0_ & ~0x00000001);
            onChanged();
          } else {
            graphSpecBuilder_.clear();
          }
          return this;
        }
        /**
         * <pre>
         *&#64;&#64;    .. cpp:var:: GraphSpec graph_spec (repeated)
         *&#64;&#64;
         *&#64;&#64;       Specification of the CUDA graph to be captured. If not specified
         *&#64;&#64;       and 'graphs' is true, the default CUDA graphs will be captured
         *&#64;&#64;       based on model settings.
         *&#64;&#64;       Currently only recognized by TensorRT backend.
         *&#64;&#64;
         * </pre>
         *
         * <code>repeated .inference.ModelOptimizationPolicy.Cuda.GraphSpec graph_spec = 3;</code>
         */
        public Builder removeGraphSpec(int index) {
          if (graphSpecBuilder_ == null) {
            ensureGraphSpecIsMutable();
            graphSpec_.remove(index);
            onChanged();
          } else {
            graphSpecBuilder_.remove(index);
          }
          return this;
        }
        /**
         * <pre>
         *&#64;&#64;    .. cpp:var:: GraphSpec graph_spec (repeated)
         *&#64;&#64;
         *&#64;&#64;       Specification of the CUDA graph to be captured. If not specified
         *&#64;&#64;       and 'graphs' is true, the default CUDA graphs will be captured
         *&#64;&#64;       based on model settings.
         *&#64;&#64;       Currently only recognized by TensorRT backend.
         *&#64;&#64;
         * </pre>
         *
         * <code>repeated .inference.ModelOptimizationPolicy.Cuda.GraphSpec graph_spec = 3;</code>
         */
        public org.apache.submarine.server.api.proto.TritonModelConfig.ModelOptimizationPolicy.Cuda.GraphSpec.Builder getGraphSpecBuilder(
            int index) {
          return getGraphSpecFieldBuilder().getBuilder(index);
        }
        /**
         * <pre>
         *&#64;&#64;    .. cpp:var:: GraphSpec graph_spec (repeated)
         *&#64;&#64;
         *&#64;&#64;       Specification of the CUDA graph to be captured. If not specified
         *&#64;&#64;       and 'graphs' is true, the default CUDA graphs will be captured
         *&#64;&#64;       based on model settings.
         *&#64;&#64;       Currently only recognized by TensorRT backend.
         *&#64;&#64;
         * </pre>
         *
         * <code>repeated .inference.ModelOptimizationPolicy.Cuda.GraphSpec graph_spec = 3;</code>
         */
        public org.apache.submarine.server.api.proto.TritonModelConfig.ModelOptimizationPolicy.Cuda.GraphSpecOrBuilder getGraphSpecOrBuilder(
            int index) {
          if (graphSpecBuilder_ == null) {
            return graphSpec_.get(index);  } else {
            return graphSpecBuilder_.getMessageOrBuilder(index);
          }
        }
        /**
         * <pre>
         *&#64;&#64;    .. cpp:var:: GraphSpec graph_spec (repeated)
         *&#64;&#64;
         *&#64;&#64;       Specification of the CUDA graph to be captured. If not specified
         *&#64;&#64;       and 'graphs' is true, the default CUDA graphs will be captured
         *&#64;&#64;       based on model settings.
         *&#64;&#64;       Currently only recognized by TensorRT backend.
         *&#64;&#64;
         * </pre>
         *
         * <code>repeated .inference.ModelOptimizationPolicy.Cuda.GraphSpec graph_spec = 3;</code>
         */
        public java.util.List<? extends org.apache.submarine.server.api.proto.TritonModelConfig.ModelOptimizationPolicy.Cuda.GraphSpecOrBuilder> 
             getGraphSpecOrBuilderList() {
          if (graphSpecBuilder_ != null) {
            return graphSpecBuilder_.getMessageOrBuilderList();
          } else {
            return java.util.Collections.unmodifiableList(graphSpec_);
          }
        }
        /**
         * <pre>
         *&#64;&#64;    .. cpp:var:: GraphSpec graph_spec (repeated)
         *&#64;&#64;
         *&#64;&#64;       Specification of the CUDA graph to be captured. If not specified
         *&#64;&#64;       and 'graphs' is true, the default CUDA graphs will be captured
         *&#64;&#64;       based on model settings.
         *&#64;&#64;       Currently only recognized by TensorRT backend.
         *&#64;&#64;
         * </pre>
         *
         * <code>repeated .inference.ModelOptimizationPolicy.Cuda.GraphSpec graph_spec = 3;</code>
         */
        public org.apache.submarine.server.api.proto.TritonModelConfig.ModelOptimizationPolicy.Cuda.GraphSpec.Builder addGraphSpecBuilder() {
          return getGraphSpecFieldBuilder().addBuilder(
              org.apache.submarine.server.api.proto.TritonModelConfig.ModelOptimizationPolicy.Cuda.GraphSpec.getDefaultInstance());
        }
        /**
         * <pre>
         *&#64;&#64;    .. cpp:var:: GraphSpec graph_spec (repeated)
         *&#64;&#64;
         *&#64;&#64;       Specification of the CUDA graph to be captured. If not specified
         *&#64;&#64;       and 'graphs' is true, the default CUDA graphs will be captured
         *&#64;&#64;       based on model settings.
         *&#64;&#64;       Currently only recognized by TensorRT backend.
         *&#64;&#64;
         * </pre>
         *
         * <code>repeated .inference.ModelOptimizationPolicy.Cuda.GraphSpec graph_spec = 3;</code>
         */
        public org.apache.submarine.server.api.proto.TritonModelConfig.ModelOptimizationPolicy.Cuda.GraphSpec.Builder addGraphSpecBuilder(
            int index) {
          return getGraphSpecFieldBuilder().addBuilder(
              index, org.apache.submarine.server.api.proto.TritonModelConfig.ModelOptimizationPolicy.Cuda.GraphSpec.getDefaultInstance());
        }
        /**
         * <pre>
         *&#64;&#64;    .. cpp:var:: GraphSpec graph_spec (repeated)
         *&#64;&#64;
         *&#64;&#64;       Specification of the CUDA graph to be captured. If not specified
         *&#64;&#64;       and 'graphs' is true, the default CUDA graphs will be captured
         *&#64;&#64;       based on model settings.
         *&#64;&#64;       Currently only recognized by TensorRT backend.
         *&#64;&#64;
         * </pre>
         *
         * <code>repeated .inference.ModelOptimizationPolicy.Cuda.GraphSpec graph_spec = 3;</code>
         */
        public java.util.List<org.apache.submarine.server.api.proto.TritonModelConfig.ModelOptimizationPolicy.Cuda.GraphSpec.Builder> 
             getGraphSpecBuilderList() {
          return getGraphSpecFieldBuilder().getBuilderList();
        }
        private com.google.protobuf.RepeatedFieldBuilderV3<
            org.apache.submarine.server.api.proto.TritonModelConfig.ModelOptimizationPolicy.Cuda.GraphSpec, org.apache.submarine.server.api.proto.TritonModelConfig.ModelOptimizationPolicy.Cuda.GraphSpec.Builder, org.apache.submarine.server.api.proto.TritonModelConfig.ModelOptimizationPolicy.Cuda.GraphSpecOrBuilder> 
            getGraphSpecFieldBuilder() {
          if (graphSpecBuilder_ == null) {
            graphSpecBuilder_ = new com.google.protobuf.RepeatedFieldBuilderV3<
                org.apache.submarine.server.api.proto.TritonModelConfig.ModelOptimizationPolicy.Cuda.GraphSpec, org.apache.submarine.server.api.proto.TritonModelConfig.ModelOptimizationPolicy.Cuda.GraphSpec.Builder, org.apache.submarine.server.api.proto.TritonModelConfig.ModelOptimizationPolicy.Cuda.GraphSpecOrBuilder>(
                    graphSpec_,
                    ((bitField0_ & 0x00000001) != 0),
                    getParentForChildren(),
                    isClean());
            graphSpec_ = null;
          }
          return graphSpecBuilder_;
        }

        private boolean outputCopyStream_ ;
        /**
         * <pre>
         *&#64;&#64;    .. cpp:var:: bool output_copy_stream
         *&#64;&#64;
         *&#64;&#64;       Uses a CUDA stream separate from the inference stream to copy the
         *&#64;&#64;       output to host. However, be aware that setting this option to
         *&#64;&#64;       true will lead to an increase in the memory consumption of the
         *&#64;&#64;       model as Triton will allocate twice as much GPU memory for its
         *&#64;&#64;       I/O tensor buffers. Default value is false.
         *&#64;&#64;       Currently only recognized by TensorRT backend.
         *&#64;&#64;
         * </pre>
         *
         * <code>bool output_copy_stream = 4;</code>
         * @return The outputCopyStream.
         */
        @java.lang.Override
        public boolean getOutputCopyStream() {
          return outputCopyStream_;
        }
        /**
         * <pre>
         *&#64;&#64;    .. cpp:var:: bool output_copy_stream
         *&#64;&#64;
         *&#64;&#64;       Uses a CUDA stream separate from the inference stream to copy the
         *&#64;&#64;       output to host. However, be aware that setting this option to
         *&#64;&#64;       true will lead to an increase in the memory consumption of the
         *&#64;&#64;       model as Triton will allocate twice as much GPU memory for its
         *&#64;&#64;       I/O tensor buffers. Default value is false.
         *&#64;&#64;       Currently only recognized by TensorRT backend.
         *&#64;&#64;
         * </pre>
         *
         * <code>bool output_copy_stream = 4;</code>
         * @param value The outputCopyStream to set.
         * @return This builder for chaining.
         */
        public Builder setOutputCopyStream(boolean value) {
          
          outputCopyStream_ = value;
          onChanged();
          return this;
        }
        /**
         * <pre>
         *&#64;&#64;    .. cpp:var:: bool output_copy_stream
         *&#64;&#64;
         *&#64;&#64;       Uses a CUDA stream separate from the inference stream to copy the
         *&#64;&#64;       output to host. However, be aware that setting this option to
         *&#64;&#64;       true will lead to an increase in the memory consumption of the
         *&#64;&#64;       model as Triton will allocate twice as much GPU memory for its
         *&#64;&#64;       I/O tensor buffers. Default value is false.
         *&#64;&#64;       Currently only recognized by TensorRT backend.
         *&#64;&#64;
         * </pre>
         *
         * <code>bool output_copy_stream = 4;</code>
         * @return This builder for chaining.
         */
        public Builder clearOutputCopyStream() {
          
          outputCopyStream_ = false;
          onChanged();
          return this;
        }
        @java.lang.Override
        public final Builder setUnknownFields(
            final com.google.protobuf.UnknownFieldSet unknownFields) {
          return super.setUnknownFields(unknownFields);
        }

        @java.lang.Override
        public final Builder mergeUnknownFields(
            final com.google.protobuf.UnknownFieldSet unknownFields) {
          return super.mergeUnknownFields(unknownFields);
        }


        // @@protoc_insertion_point(builder_scope:inference.ModelOptimizationPolicy.Cuda)
      }

      // @@protoc_insertion_point(class_scope:inference.ModelOptimizationPolicy.Cuda)
      private static final org.apache.submarine.server.api.proto.TritonModelConfig.ModelOptimizationPolicy.Cuda DEFAULT_INSTANCE;
      static {
        DEFAULT_INSTANCE = new org.apache.submarine.server.api.proto.TritonModelConfig.ModelOptimizationPolicy.Cuda();
      }

      public static org.apache.submarine.server.api.proto.TritonModelConfig.ModelOptimizationPolicy.Cuda getDefaultInstance() {
        return DEFAULT_INSTANCE;
      }

      private static final com.google.protobuf.Parser<Cuda>
          PARSER = new com.google.protobuf.AbstractParser<Cuda>() {
        @java.lang.Override
        public Cuda parsePartialFrom(
            com.google.protobuf.CodedInputStream input,
            com.google.protobuf.ExtensionRegistryLite extensionRegistry)
            throws com.google.protobuf.InvalidProtocolBufferException {
          return new Cuda(input, extensionRegistry);
        }
      };

      public static com.google.protobuf.Parser<Cuda> parser() {
        return PARSER;
      }

      @java.lang.Override
      public com.google.protobuf.Parser<Cuda> getParserForType() {
        return PARSER;
      }

      @java.lang.Override
      public org.apache.submarine.server.api.proto.TritonModelConfig.ModelOptimizationPolicy.Cuda getDefaultInstanceForType() {
        return DEFAULT_INSTANCE;
      }

    }

    public interface ExecutionAcceleratorsOrBuilder extends
        // @@protoc_insertion_point(interface_extends:inference.ModelOptimizationPolicy.ExecutionAccelerators)
        com.google.protobuf.MessageOrBuilder {

      /**
       * <pre>
       *&#64;&#64;    .. cpp:var:: Accelerator gpu_execution_accelerator (repeated)
       *&#64;&#64;
       *&#64;&#64;       The preferred execution provider to be used if the model instance
       *&#64;&#64;       is deployed on GPU.
       *&#64;&#64;
       *&#64;&#64;       For ONNX Runtime backend, possible value is "tensorrt" as name,
       *&#64;&#64;       and no parameters are required.
       *&#64;&#64;
       *&#64;&#64;       For TensorFlow backend, possible values are "tensorrt",
       *&#64;&#64;       "auto_mixed_precision", "gpu_io".
       *&#64;&#64;
       *&#64;&#64;       For "tensorrt", the following parameters can be specified:
       *&#64;&#64;         "precision_mode": The precision used for optimization.
       *&#64;&#64;         Allowed values are "FP32" and "FP16". Default value is "FP32".
       *&#64;&#64;
       *&#64;&#64;         "max_cached_engines": The maximum number of cached TensorRT
       *&#64;&#64;         engines in dynamic TensorRT ops. Default value is 100.
       *&#64;&#64;
       *&#64;&#64;         "minimum_segment_size": The smallest model subgraph that will
       *&#64;&#64;         be considered for optimization by TensorRT. Default value is 3.
       *&#64;&#64;
       *&#64;&#64;         "max_workspace_size_bytes": The maximum GPU memory the model
       *&#64;&#64;         can use temporarily during execution. Default value is 1GB.
       *&#64;&#64;
       *&#64;&#64;       For "auto_mixed_precision", no parameters are required. If set,
       *&#64;&#64;       the model will try to use FP16 for better performance.
       *&#64;&#64;       This optimization can not be set with "tensorrt".
       *&#64;&#64;
       *&#64;&#64;       For "gpu_io", no parameters are required. If set, the model will
       *&#64;&#64;       be executed using TensorFlow Callable API to set input and output
       *&#64;&#64;       tensors in GPU memory if possible, which can reduce data transfer
       *&#64;&#64;       overhead if the model is used in ensemble. However, the Callable
       *&#64;&#64;       object will be created on model creation and it will request all
       *&#64;&#64;       outputs for every model execution, which may impact the
       *&#64;&#64;       performance if a request does not require all outputs. This
       *&#64;&#64;       optimization will only take affect if the model instance is
       *&#64;&#64;       created with KIND_GPU.
       *&#64;&#64;
       * </pre>
       *
       * <code>repeated .inference.ModelOptimizationPolicy.ExecutionAccelerators.Accelerator gpu_execution_accelerator = 1;</code>
       */
      java.util.List<org.apache.submarine.server.api.proto.TritonModelConfig.ModelOptimizationPolicy.ExecutionAccelerators.Accelerator> 
          getGpuExecutionAcceleratorList();
      /**
       * <pre>
       *&#64;&#64;    .. cpp:var:: Accelerator gpu_execution_accelerator (repeated)
       *&#64;&#64;
       *&#64;&#64;       The preferred execution provider to be used if the model instance
       *&#64;&#64;       is deployed on GPU.
       *&#64;&#64;
       *&#64;&#64;       For ONNX Runtime backend, possible value is "tensorrt" as name,
       *&#64;&#64;       and no parameters are required.
       *&#64;&#64;
       *&#64;&#64;       For TensorFlow backend, possible values are "tensorrt",
       *&#64;&#64;       "auto_mixed_precision", "gpu_io".
       *&#64;&#64;
       *&#64;&#64;       For "tensorrt", the following parameters can be specified:
       *&#64;&#64;         "precision_mode": The precision used for optimization.
       *&#64;&#64;         Allowed values are "FP32" and "FP16". Default value is "FP32".
       *&#64;&#64;
       *&#64;&#64;         "max_cached_engines": The maximum number of cached TensorRT
       *&#64;&#64;         engines in dynamic TensorRT ops. Default value is 100.
       *&#64;&#64;
       *&#64;&#64;         "minimum_segment_size": The smallest model subgraph that will
       *&#64;&#64;         be considered for optimization by TensorRT. Default value is 3.
       *&#64;&#64;
       *&#64;&#64;         "max_workspace_size_bytes": The maximum GPU memory the model
       *&#64;&#64;         can use temporarily during execution. Default value is 1GB.
       *&#64;&#64;
       *&#64;&#64;       For "auto_mixed_precision", no parameters are required. If set,
       *&#64;&#64;       the model will try to use FP16 for better performance.
       *&#64;&#64;       This optimization can not be set with "tensorrt".
       *&#64;&#64;
       *&#64;&#64;       For "gpu_io", no parameters are required. If set, the model will
       *&#64;&#64;       be executed using TensorFlow Callable API to set input and output
       *&#64;&#64;       tensors in GPU memory if possible, which can reduce data transfer
       *&#64;&#64;       overhead if the model is used in ensemble. However, the Callable
       *&#64;&#64;       object will be created on model creation and it will request all
       *&#64;&#64;       outputs for every model execution, which may impact the
       *&#64;&#64;       performance if a request does not require all outputs. This
       *&#64;&#64;       optimization will only take affect if the model instance is
       *&#64;&#64;       created with KIND_GPU.
       *&#64;&#64;
       * </pre>
       *
       * <code>repeated .inference.ModelOptimizationPolicy.ExecutionAccelerators.Accelerator gpu_execution_accelerator = 1;</code>
       */
      org.apache.submarine.server.api.proto.TritonModelConfig.ModelOptimizationPolicy.ExecutionAccelerators.Accelerator getGpuExecutionAccelerator(int index);
      /**
       * <pre>
       *&#64;&#64;    .. cpp:var:: Accelerator gpu_execution_accelerator (repeated)
       *&#64;&#64;
       *&#64;&#64;       The preferred execution provider to be used if the model instance
       *&#64;&#64;       is deployed on GPU.
       *&#64;&#64;
       *&#64;&#64;       For ONNX Runtime backend, possible value is "tensorrt" as name,
       *&#64;&#64;       and no parameters are required.
       *&#64;&#64;
       *&#64;&#64;       For TensorFlow backend, possible values are "tensorrt",
       *&#64;&#64;       "auto_mixed_precision", "gpu_io".
       *&#64;&#64;
       *&#64;&#64;       For "tensorrt", the following parameters can be specified:
       *&#64;&#64;         "precision_mode": The precision used for optimization.
       *&#64;&#64;         Allowed values are "FP32" and "FP16". Default value is "FP32".
       *&#64;&#64;
       *&#64;&#64;         "max_cached_engines": The maximum number of cached TensorRT
       *&#64;&#64;         engines in dynamic TensorRT ops. Default value is 100.
       *&#64;&#64;
       *&#64;&#64;         "minimum_segment_size": The smallest model subgraph that will
       *&#64;&#64;         be considered for optimization by TensorRT. Default value is 3.
       *&#64;&#64;
       *&#64;&#64;         "max_workspace_size_bytes": The maximum GPU memory the model
       *&#64;&#64;         can use temporarily during execution. Default value is 1GB.
       *&#64;&#64;
       *&#64;&#64;       For "auto_mixed_precision", no parameters are required. If set,
       *&#64;&#64;       the model will try to use FP16 for better performance.
       *&#64;&#64;       This optimization can not be set with "tensorrt".
       *&#64;&#64;
       *&#64;&#64;       For "gpu_io", no parameters are required. If set, the model will
       *&#64;&#64;       be executed using TensorFlow Callable API to set input and output
       *&#64;&#64;       tensors in GPU memory if possible, which can reduce data transfer
       *&#64;&#64;       overhead if the model is used in ensemble. However, the Callable
       *&#64;&#64;       object will be created on model creation and it will request all
       *&#64;&#64;       outputs for every model execution, which may impact the
       *&#64;&#64;       performance if a request does not require all outputs. This
       *&#64;&#64;       optimization will only take affect if the model instance is
       *&#64;&#64;       created with KIND_GPU.
       *&#64;&#64;
       * </pre>
       *
       * <code>repeated .inference.ModelOptimizationPolicy.ExecutionAccelerators.Accelerator gpu_execution_accelerator = 1;</code>
       */
      int getGpuExecutionAcceleratorCount();
      /**
       * <pre>
       *&#64;&#64;    .. cpp:var:: Accelerator gpu_execution_accelerator (repeated)
       *&#64;&#64;
       *&#64;&#64;       The preferred execution provider to be used if the model instance
       *&#64;&#64;       is deployed on GPU.
       *&#64;&#64;
       *&#64;&#64;       For ONNX Runtime backend, possible value is "tensorrt" as name,
       *&#64;&#64;       and no parameters are required.
       *&#64;&#64;
       *&#64;&#64;       For TensorFlow backend, possible values are "tensorrt",
       *&#64;&#64;       "auto_mixed_precision", "gpu_io".
       *&#64;&#64;
       *&#64;&#64;       For "tensorrt", the following parameters can be specified:
       *&#64;&#64;         "precision_mode": The precision used for optimization.
       *&#64;&#64;         Allowed values are "FP32" and "FP16". Default value is "FP32".
       *&#64;&#64;
       *&#64;&#64;         "max_cached_engines": The maximum number of cached TensorRT
       *&#64;&#64;         engines in dynamic TensorRT ops. Default value is 100.
       *&#64;&#64;
       *&#64;&#64;         "minimum_segment_size": The smallest model subgraph that will
       *&#64;&#64;         be considered for optimization by TensorRT. Default value is 3.
       *&#64;&#64;
       *&#64;&#64;         "max_workspace_size_bytes": The maximum GPU memory the model
       *&#64;&#64;         can use temporarily during execution. Default value is 1GB.
       *&#64;&#64;
       *&#64;&#64;       For "auto_mixed_precision", no parameters are required. If set,
       *&#64;&#64;       the model will try to use FP16 for better performance.
       *&#64;&#64;       This optimization can not be set with "tensorrt".
       *&#64;&#64;
       *&#64;&#64;       For "gpu_io", no parameters are required. If set, the model will
       *&#64;&#64;       be executed using TensorFlow Callable API to set input and output
       *&#64;&#64;       tensors in GPU memory if possible, which can reduce data transfer
       *&#64;&#64;       overhead if the model is used in ensemble. However, the Callable
       *&#64;&#64;       object will be created on model creation and it will request all
       *&#64;&#64;       outputs for every model execution, which may impact the
       *&#64;&#64;       performance if a request does not require all outputs. This
       *&#64;&#64;       optimization will only take affect if the model instance is
       *&#64;&#64;       created with KIND_GPU.
       *&#64;&#64;
       * </pre>
       *
       * <code>repeated .inference.ModelOptimizationPolicy.ExecutionAccelerators.Accelerator gpu_execution_accelerator = 1;</code>
       */
      java.util.List<? extends org.apache.submarine.server.api.proto.TritonModelConfig.ModelOptimizationPolicy.ExecutionAccelerators.AcceleratorOrBuilder> 
          getGpuExecutionAcceleratorOrBuilderList();
      /**
       * <pre>
       *&#64;&#64;    .. cpp:var:: Accelerator gpu_execution_accelerator (repeated)
       *&#64;&#64;
       *&#64;&#64;       The preferred execution provider to be used if the model instance
       *&#64;&#64;       is deployed on GPU.
       *&#64;&#64;
       *&#64;&#64;       For ONNX Runtime backend, possible value is "tensorrt" as name,
       *&#64;&#64;       and no parameters are required.
       *&#64;&#64;
       *&#64;&#64;       For TensorFlow backend, possible values are "tensorrt",
       *&#64;&#64;       "auto_mixed_precision", "gpu_io".
       *&#64;&#64;
       *&#64;&#64;       For "tensorrt", the following parameters can be specified:
       *&#64;&#64;         "precision_mode": The precision used for optimization.
       *&#64;&#64;         Allowed values are "FP32" and "FP16". Default value is "FP32".
       *&#64;&#64;
       *&#64;&#64;         "max_cached_engines": The maximum number of cached TensorRT
       *&#64;&#64;         engines in dynamic TensorRT ops. Default value is 100.
       *&#64;&#64;
       *&#64;&#64;         "minimum_segment_size": The smallest model subgraph that will
       *&#64;&#64;         be considered for optimization by TensorRT. Default value is 3.
       *&#64;&#64;
       *&#64;&#64;         "max_workspace_size_bytes": The maximum GPU memory the model
       *&#64;&#64;         can use temporarily during execution. Default value is 1GB.
       *&#64;&#64;
       *&#64;&#64;       For "auto_mixed_precision", no parameters are required. If set,
       *&#64;&#64;       the model will try to use FP16 for better performance.
       *&#64;&#64;       This optimization can not be set with "tensorrt".
       *&#64;&#64;
       *&#64;&#64;       For "gpu_io", no parameters are required. If set, the model will
       *&#64;&#64;       be executed using TensorFlow Callable API to set input and output
       *&#64;&#64;       tensors in GPU memory if possible, which can reduce data transfer
       *&#64;&#64;       overhead if the model is used in ensemble. However, the Callable
       *&#64;&#64;       object will be created on model creation and it will request all
       *&#64;&#64;       outputs for every model execution, which may impact the
       *&#64;&#64;       performance if a request does not require all outputs. This
       *&#64;&#64;       optimization will only take affect if the model instance is
       *&#64;&#64;       created with KIND_GPU.
       *&#64;&#64;
       * </pre>
       *
       * <code>repeated .inference.ModelOptimizationPolicy.ExecutionAccelerators.Accelerator gpu_execution_accelerator = 1;</code>
       */
      org.apache.submarine.server.api.proto.TritonModelConfig.ModelOptimizationPolicy.ExecutionAccelerators.AcceleratorOrBuilder getGpuExecutionAcceleratorOrBuilder(
          int index);

      /**
       * <pre>
       *&#64;&#64;    .. cpp:var:: Accelerator cpu_execution_accelerator (repeated)
       *&#64;&#64;
       *&#64;&#64;       The preferred execution provider to be used if the model instance
       *&#64;&#64;       is deployed on CPU.
       *&#64;&#64;
       *&#64;&#64;       For ONNX Runtime backend, possible value is "openvino" as name,
       *&#64;&#64;       and no parameters are required.
       *&#64;&#64;
       * </pre>
       *
       * <code>repeated .inference.ModelOptimizationPolicy.ExecutionAccelerators.Accelerator cpu_execution_accelerator = 2;</code>
       */
      java.util.List<org.apache.submarine.server.api.proto.TritonModelConfig.ModelOptimizationPolicy.ExecutionAccelerators.Accelerator> 
          getCpuExecutionAcceleratorList();
      /**
       * <pre>
       *&#64;&#64;    .. cpp:var:: Accelerator cpu_execution_accelerator (repeated)
       *&#64;&#64;
       *&#64;&#64;       The preferred execution provider to be used if the model instance
       *&#64;&#64;       is deployed on CPU.
       *&#64;&#64;
       *&#64;&#64;       For ONNX Runtime backend, possible value is "openvino" as name,
       *&#64;&#64;       and no parameters are required.
       *&#64;&#64;
       * </pre>
       *
       * <code>repeated .inference.ModelOptimizationPolicy.ExecutionAccelerators.Accelerator cpu_execution_accelerator = 2;</code>
       */
      org.apache.submarine.server.api.proto.TritonModelConfig.ModelOptimizationPolicy.ExecutionAccelerators.Accelerator getCpuExecutionAccelerator(int index);
      /**
       * <pre>
       *&#64;&#64;    .. cpp:var:: Accelerator cpu_execution_accelerator (repeated)
       *&#64;&#64;
       *&#64;&#64;       The preferred execution provider to be used if the model instance
       *&#64;&#64;       is deployed on CPU.
       *&#64;&#64;
       *&#64;&#64;       For ONNX Runtime backend, possible value is "openvino" as name,
       *&#64;&#64;       and no parameters are required.
       *&#64;&#64;
       * </pre>
       *
       * <code>repeated .inference.ModelOptimizationPolicy.ExecutionAccelerators.Accelerator cpu_execution_accelerator = 2;</code>
       */
      int getCpuExecutionAcceleratorCount();
      /**
       * <pre>
       *&#64;&#64;    .. cpp:var:: Accelerator cpu_execution_accelerator (repeated)
       *&#64;&#64;
       *&#64;&#64;       The preferred execution provider to be used if the model instance
       *&#64;&#64;       is deployed on CPU.
       *&#64;&#64;
       *&#64;&#64;       For ONNX Runtime backend, possible value is "openvino" as name,
       *&#64;&#64;       and no parameters are required.
       *&#64;&#64;
       * </pre>
       *
       * <code>repeated .inference.ModelOptimizationPolicy.ExecutionAccelerators.Accelerator cpu_execution_accelerator = 2;</code>
       */
      java.util.List<? extends org.apache.submarine.server.api.proto.TritonModelConfig.ModelOptimizationPolicy.ExecutionAccelerators.AcceleratorOrBuilder> 
          getCpuExecutionAcceleratorOrBuilderList();
      /**
       * <pre>
       *&#64;&#64;    .. cpp:var:: Accelerator cpu_execution_accelerator (repeated)
       *&#64;&#64;
       *&#64;&#64;       The preferred execution provider to be used if the model instance
       *&#64;&#64;       is deployed on CPU.
       *&#64;&#64;
       *&#64;&#64;       For ONNX Runtime backend, possible value is "openvino" as name,
       *&#64;&#64;       and no parameters are required.
       *&#64;&#64;
       * </pre>
       *
       * <code>repeated .inference.ModelOptimizationPolicy.ExecutionAccelerators.Accelerator cpu_execution_accelerator = 2;</code>
       */
      org.apache.submarine.server.api.proto.TritonModelConfig.ModelOptimizationPolicy.ExecutionAccelerators.AcceleratorOrBuilder getCpuExecutionAcceleratorOrBuilder(
          int index);
    }
    /**
     * <pre>
     *&#64;&#64;
     *&#64;&#64;  .. cpp:var:: message ExecutionAccelerators
     *&#64;&#64;
     *&#64;&#64;     Specify the preferred execution accelerators to be used to execute
     *&#64;&#64;     the model. Currently only recognized by ONNX Runtime backend and
     *&#64;&#64;     TensorFlow backend.
     *&#64;&#64;
     *&#64;&#64;     For ONNX Runtime backend, it will deploy the model with the execution
     *&#64;&#64;     accelerators by priority, the priority is determined based on the
     *&#64;&#64;     order that they are set, i.e. the provider at the front has highest
     *&#64;&#64;     priority. Overall, the priority will be in the following order:
     *&#64;&#64;         &lt;gpu_execution_accelerator&gt; (if instance is on GPU)
     *&#64;&#64;         CUDA Execution Provider     (if instance is on GPU)
     *&#64;&#64;         &lt;cpu_execution_accelerator&gt;
     *&#64;&#64;         Default CPU Execution Provider
     *&#64;&#64;
     * </pre>
     *
     * Protobuf type {@code inference.ModelOptimizationPolicy.ExecutionAccelerators}
     */
    public static final class ExecutionAccelerators extends
        com.google.protobuf.GeneratedMessageV3 implements
        // @@protoc_insertion_point(message_implements:inference.ModelOptimizationPolicy.ExecutionAccelerators)
        ExecutionAcceleratorsOrBuilder {
    private static final long serialVersionUID = 0L;
      // Use ExecutionAccelerators.newBuilder() to construct.
      private ExecutionAccelerators(com.google.protobuf.GeneratedMessageV3.Builder<?> builder) {
        super(builder);
      }
      private ExecutionAccelerators() {
        gpuExecutionAccelerator_ = java.util.Collections.emptyList();
        cpuExecutionAccelerator_ = java.util.Collections.emptyList();
      }

      @java.lang.Override
      @SuppressWarnings({"unused"})
      protected java.lang.Object newInstance(
          UnusedPrivateParameter unused) {
        return new ExecutionAccelerators();
      }

      @java.lang.Override
      public final com.google.protobuf.UnknownFieldSet
      getUnknownFields() {
        return this.unknownFields;
      }
      private ExecutionAccelerators(
          com.google.protobuf.CodedInputStream input,
          com.google.protobuf.ExtensionRegistryLite extensionRegistry)
          throws com.google.protobuf.InvalidProtocolBufferException {
        this();
        if (extensionRegistry == null) {
          throw new java.lang.NullPointerException();
        }
        int mutable_bitField0_ = 0;
        com.google.protobuf.UnknownFieldSet.Builder unknownFields =
            com.google.protobuf.UnknownFieldSet.newBuilder();
        try {
          boolean done = false;
          while (!done) {
            int tag = input.readTag();
            switch (tag) {
              case 0:
                done = true;
                break;
              case 10: {
                if (!((mutable_bitField0_ & 0x00000001) != 0)) {
                  gpuExecutionAccelerator_ = new java.util.ArrayList<org.apache.submarine.server.api.proto.TritonModelConfig.ModelOptimizationPolicy.ExecutionAccelerators.Accelerator>();
                  mutable_bitField0_ |= 0x00000001;
                }
                gpuExecutionAccelerator_.add(
                    input.readMessage(org.apache.submarine.server.api.proto.TritonModelConfig.ModelOptimizationPolicy.ExecutionAccelerators.Accelerator.parser(), extensionRegistry));
                break;
              }
              case 18: {
                if (!((mutable_bitField0_ & 0x00000002) != 0)) {
                  cpuExecutionAccelerator_ = new java.util.ArrayList<org.apache.submarine.server.api.proto.TritonModelConfig.ModelOptimizationPolicy.ExecutionAccelerators.Accelerator>();
                  mutable_bitField0_ |= 0x00000002;
                }
                cpuExecutionAccelerator_.add(
                    input.readMessage(org.apache.submarine.server.api.proto.TritonModelConfig.ModelOptimizationPolicy.ExecutionAccelerators.Accelerator.parser(), extensionRegistry));
                break;
              }
              default: {
                if (!parseUnknownField(
                    input, unknownFields, extensionRegistry, tag)) {
                  done = true;
                }
                break;
              }
            }
          }
        } catch (com.google.protobuf.InvalidProtocolBufferException e) {
          throw e.setUnfinishedMessage(this);
        } catch (java.io.IOException e) {
          throw new com.google.protobuf.InvalidProtocolBufferException(
              e).setUnfinishedMessage(this);
        } finally {
          if (((mutable_bitField0_ & 0x00000001) != 0)) {
            gpuExecutionAccelerator_ = java.util.Collections.unmodifiableList(gpuExecutionAccelerator_);
          }
          if (((mutable_bitField0_ & 0x00000002) != 0)) {
            cpuExecutionAccelerator_ = java.util.Collections.unmodifiableList(cpuExecutionAccelerator_);
          }
          this.unknownFields = unknownFields.build();
          makeExtensionsImmutable();
        }
      }
      public static final com.google.protobuf.Descriptors.Descriptor
          getDescriptor() {
        return org.apache.submarine.server.api.proto.TritonModelConfig.internal_static_inference_ModelOptimizationPolicy_ExecutionAccelerators_descriptor;
      }

      @java.lang.Override
      protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
          internalGetFieldAccessorTable() {
        return org.apache.submarine.server.api.proto.TritonModelConfig.internal_static_inference_ModelOptimizationPolicy_ExecutionAccelerators_fieldAccessorTable
            .ensureFieldAccessorsInitialized(
                org.apache.submarine.server.api.proto.TritonModelConfig.ModelOptimizationPolicy.ExecutionAccelerators.class, org.apache.submarine.server.api.proto.TritonModelConfig.ModelOptimizationPolicy.ExecutionAccelerators.Builder.class);
      }

      public interface AcceleratorOrBuilder extends
          // @@protoc_insertion_point(interface_extends:inference.ModelOptimizationPolicy.ExecutionAccelerators.Accelerator)
          com.google.protobuf.MessageOrBuilder {

        /**
         * <pre>
         *&#64;&#64;    .. cpp:var:: string name
         *&#64;&#64;
         *&#64;&#64;       The name of the execution accelerator.
         *&#64;&#64;
         * </pre>
         *
         * <code>string name = 1;</code>
         * @return The name.
         */
        java.lang.String getName();
        /**
         * <pre>
         *&#64;&#64;    .. cpp:var:: string name
         *&#64;&#64;
         *&#64;&#64;       The name of the execution accelerator.
         *&#64;&#64;
         * </pre>
         *
         * <code>string name = 1;</code>
         * @return The bytes for name.
         */
        com.google.protobuf.ByteString
            getNameBytes();

        /**
         * <pre>
         *&#64;&#64;    .. cpp:var:: map&lt;string, string&gt; parameters
         *&#64;&#64;
         *&#64;&#64;       Additional paremeters used to configure the accelerator.
         *&#64;&#64;
         * </pre>
         *
         * <code>map&lt;string, string&gt; parameters = 2;</code>
         */
        int getParametersCount();
        /**
         * <pre>
         *&#64;&#64;    .. cpp:var:: map&lt;string, string&gt; parameters
         *&#64;&#64;
         *&#64;&#64;       Additional paremeters used to configure the accelerator.
         *&#64;&#64;
         * </pre>
         *
         * <code>map&lt;string, string&gt; parameters = 2;</code>
         */
        boolean containsParameters(
            java.lang.String key);
        /**
         * Use {@link #getParametersMap()} instead.
         */
        @java.lang.Deprecated
        java.util.Map<java.lang.String, java.lang.String>
        getParameters();
        /**
         * <pre>
         *&#64;&#64;    .. cpp:var:: map&lt;string, string&gt; parameters
         *&#64;&#64;
         *&#64;&#64;       Additional paremeters used to configure the accelerator.
         *&#64;&#64;
         * </pre>
         *
         * <code>map&lt;string, string&gt; parameters = 2;</code>
         */
        java.util.Map<java.lang.String, java.lang.String>
        getParametersMap();
        /**
         * <pre>
         *&#64;&#64;    .. cpp:var:: map&lt;string, string&gt; parameters
         *&#64;&#64;
         *&#64;&#64;       Additional paremeters used to configure the accelerator.
         *&#64;&#64;
         * </pre>
         *
         * <code>map&lt;string, string&gt; parameters = 2;</code>
         */

        java.lang.String getParametersOrDefault(
            java.lang.String key,
            java.lang.String defaultValue);
        /**
         * <pre>
         *&#64;&#64;    .. cpp:var:: map&lt;string, string&gt; parameters
         *&#64;&#64;
         *&#64;&#64;       Additional paremeters used to configure the accelerator.
         *&#64;&#64;
         * </pre>
         *
         * <code>map&lt;string, string&gt; parameters = 2;</code>
         */

        java.lang.String getParametersOrThrow(
            java.lang.String key);
      }
      /**
       * <pre>
       *&#64;&#64;
       *&#64;&#64;  .. cpp:var:: message Accelerator
       *&#64;&#64;
       *&#64;&#64;     Specify the accelerator to be used to execute the model.
       *&#64;&#64;     Accelerator with the same name may accept different parameters
       *&#64;&#64;     depending on the backends.
       *&#64;&#64;
       * </pre>
       *
       * Protobuf type {@code inference.ModelOptimizationPolicy.ExecutionAccelerators.Accelerator}
       */
      public static final class Accelerator extends
          com.google.protobuf.GeneratedMessageV3 implements
          // @@protoc_insertion_point(message_implements:inference.ModelOptimizationPolicy.ExecutionAccelerators.Accelerator)
          AcceleratorOrBuilder {
      private static final long serialVersionUID = 0L;
        // Use Accelerator.newBuilder() to construct.
        private Accelerator(com.google.protobuf.GeneratedMessageV3.Builder<?> builder) {
          super(builder);
        }
        private Accelerator() {
          name_ = "";
        }

        @java.lang.Override
        @SuppressWarnings({"unused"})
        protected java.lang.Object newInstance(
            UnusedPrivateParameter unused) {
          return new Accelerator();
        }

        @java.lang.Override
        public final com.google.protobuf.UnknownFieldSet
        getUnknownFields() {
          return this.unknownFields;
        }
        private Accelerator(
            com.google.protobuf.CodedInputStream input,
            com.google.protobuf.ExtensionRegistryLite extensionRegistry)
            throws com.google.protobuf.InvalidProtocolBufferException {
          this();
          if (extensionRegistry == null) {
            throw new java.lang.NullPointerException();
          }
          int mutable_bitField0_ = 0;
          com.google.protobuf.UnknownFieldSet.Builder unknownFields =
              com.google.protobuf.UnknownFieldSet.newBuilder();
          try {
            boolean done = false;
            while (!done) {
              int tag = input.readTag();
              switch (tag) {
                case 0:
                  done = true;
                  break;
                case 10: {
                  java.lang.String s = input.readStringRequireUtf8();

                  name_ = s;
                  break;
                }
                case 18: {
                  if (!((mutable_bitField0_ & 0x00000001) != 0)) {
                    parameters_ = com.google.protobuf.MapField.newMapField(
                        ParametersDefaultEntryHolder.defaultEntry);
                    mutable_bitField0_ |= 0x00000001;
                  }
                  com.google.protobuf.MapEntry<java.lang.String, java.lang.String>
                  parameters__ = input.readMessage(
                      ParametersDefaultEntryHolder.defaultEntry.getParserForType(), extensionRegistry);
                  parameters_.getMutableMap().put(
                      parameters__.getKey(), parameters__.getValue());
                  break;
                }
                default: {
                  if (!parseUnknownField(
                      input, unknownFields, extensionRegistry, tag)) {
                    done = true;
                  }
                  break;
                }
              }
            }
          } catch (com.google.protobuf.InvalidProtocolBufferException e) {
            throw e.setUnfinishedMessage(this);
          } catch (java.io.IOException e) {
            throw new com.google.protobuf.InvalidProtocolBufferException(
                e).setUnfinishedMessage(this);
          } finally {
            this.unknownFields = unknownFields.build();
            makeExtensionsImmutable();
          }
        }
        public static final com.google.protobuf.Descriptors.Descriptor
            getDescriptor() {
          return org.apache.submarine.server.api.proto.TritonModelConfig.internal_static_inference_ModelOptimizationPolicy_ExecutionAccelerators_Accelerator_descriptor;
        }

        @SuppressWarnings({"rawtypes"})
        @java.lang.Override
        protected com.google.protobuf.MapField internalGetMapField(
            int number) {
          switch (number) {
            case 2:
              return internalGetParameters();
            default:
              throw new RuntimeException(
                  "Invalid map field number: " + number);
          }
        }
        @java.lang.Override
        protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
            internalGetFieldAccessorTable() {
          return org.apache.submarine.server.api.proto.TritonModelConfig.internal_static_inference_ModelOptimizationPolicy_ExecutionAccelerators_Accelerator_fieldAccessorTable
              .ensureFieldAccessorsInitialized(
                  org.apache.submarine.server.api.proto.TritonModelConfig.ModelOptimizationPolicy.ExecutionAccelerators.Accelerator.class, org.apache.submarine.server.api.proto.TritonModelConfig.ModelOptimizationPolicy.ExecutionAccelerators.Accelerator.Builder.class);
        }

        public static final int NAME_FIELD_NUMBER = 1;
        private volatile java.lang.Object name_;
        /**
         * <pre>
         *&#64;&#64;    .. cpp:var:: string name
         *&#64;&#64;
         *&#64;&#64;       The name of the execution accelerator.
         *&#64;&#64;
         * </pre>
         *
         * <code>string name = 1;</code>
         * @return The name.
         */
        @java.lang.Override
        public java.lang.String getName() {
          java.lang.Object ref = name_;
          if (ref instanceof java.lang.String) {
            return (java.lang.String) ref;
          } else {
            com.google.protobuf.ByteString bs = 
                (com.google.protobuf.ByteString) ref;
            java.lang.String s = bs.toStringUtf8();
            name_ = s;
            return s;
          }
        }
        /**
         * <pre>
         *&#64;&#64;    .. cpp:var:: string name
         *&#64;&#64;
         *&#64;&#64;       The name of the execution accelerator.
         *&#64;&#64;
         * </pre>
         *
         * <code>string name = 1;</code>
         * @return The bytes for name.
         */
        @java.lang.Override
        public com.google.protobuf.ByteString
            getNameBytes() {
          java.lang.Object ref = name_;
          if (ref instanceof java.lang.String) {
            com.google.protobuf.ByteString b = 
                com.google.protobuf.ByteString.copyFromUtf8(
                    (java.lang.String) ref);
            name_ = b;
            return b;
          } else {
            return (com.google.protobuf.ByteString) ref;
          }
        }

        public static final int PARAMETERS_FIELD_NUMBER = 2;
        private static final class ParametersDefaultEntryHolder {
          static final com.google.protobuf.MapEntry<
              java.lang.String, java.lang.String> defaultEntry =
                  com.google.protobuf.MapEntry
                  .<java.lang.String, java.lang.String>newDefaultInstance(
                      org.apache.submarine.server.api.proto.TritonModelConfig.internal_static_inference_ModelOptimizationPolicy_ExecutionAccelerators_Accelerator_ParametersEntry_descriptor, 
                      com.google.protobuf.WireFormat.FieldType.STRING,
                      "",
                      com.google.protobuf.WireFormat.FieldType.STRING,
                      "");
        }
        private com.google.protobuf.MapField<
            java.lang.String, java.lang.String> parameters_;
        private com.google.protobuf.MapField<java.lang.String, java.lang.String>
        internalGetParameters() {
          if (parameters_ == null) {
            return com.google.protobuf.MapField.emptyMapField(
                ParametersDefaultEntryHolder.defaultEntry);
          }
          return parameters_;
        }

        public int getParametersCount() {
          return internalGetParameters().getMap().size();
        }
        /**
         * <pre>
         *&#64;&#64;    .. cpp:var:: map&lt;string, string&gt; parameters
         *&#64;&#64;
         *&#64;&#64;       Additional paremeters used to configure the accelerator.
         *&#64;&#64;
         * </pre>
         *
         * <code>map&lt;string, string&gt; parameters = 2;</code>
         */

        @java.lang.Override
        public boolean containsParameters(
            java.lang.String key) {
          if (key == null) { throw new java.lang.NullPointerException(); }
          return internalGetParameters().getMap().containsKey(key);
        }
        /**
         * Use {@link #getParametersMap()} instead.
         */
        @java.lang.Override
        @java.lang.Deprecated
        public java.util.Map<java.lang.String, java.lang.String> getParameters() {
          return getParametersMap();
        }
        /**
         * <pre>
         *&#64;&#64;    .. cpp:var:: map&lt;string, string&gt; parameters
         *&#64;&#64;
         *&#64;&#64;       Additional paremeters used to configure the accelerator.
         *&#64;&#64;
         * </pre>
         *
         * <code>map&lt;string, string&gt; parameters = 2;</code>
         */
        @java.lang.Override

        public java.util.Map<java.lang.String, java.lang.String> getParametersMap() {
          return internalGetParameters().getMap();
        }
        /**
         * <pre>
         *&#64;&#64;    .. cpp:var:: map&lt;string, string&gt; parameters
         *&#64;&#64;
         *&#64;&#64;       Additional paremeters used to configure the accelerator.
         *&#64;&#64;
         * </pre>
         *
         * <code>map&lt;string, string&gt; parameters = 2;</code>
         */
        @java.lang.Override

        public java.lang.String getParametersOrDefault(
            java.lang.String key,
            java.lang.String defaultValue) {
          if (key == null) { throw new java.lang.NullPointerException(); }
          java.util.Map<java.lang.String, java.lang.String> map =
              internalGetParameters().getMap();
          return map.containsKey(key) ? map.get(key) : defaultValue;
        }
        /**
         * <pre>
         *&#64;&#64;    .. cpp:var:: map&lt;string, string&gt; parameters
         *&#64;&#64;
         *&#64;&#64;       Additional paremeters used to configure the accelerator.
         *&#64;&#64;
         * </pre>
         *
         * <code>map&lt;string, string&gt; parameters = 2;</code>
         */
        @java.lang.Override

        public java.lang.String getParametersOrThrow(
            java.lang.String key) {
          if (key == null) { throw new java.lang.NullPointerException(); }
          java.util.Map<java.lang.String, java.lang.String> map =
              internalGetParameters().getMap();
          if (!map.containsKey(key)) {
            throw new java.lang.IllegalArgumentException();
          }
          return map.get(key);
        }

        private byte memoizedIsInitialized = -1;
        @java.lang.Override
        public final boolean isInitialized() {
          byte isInitialized = memoizedIsInitialized;
          if (isInitialized == 1) return true;
          if (isInitialized == 0) return false;

          memoizedIsInitialized = 1;
          return true;
        }

        @java.lang.Override
        public void writeTo(com.google.protobuf.CodedOutputStream output)
                            throws java.io.IOException {
          if (!getNameBytes().isEmpty()) {
            com.google.protobuf.GeneratedMessageV3.writeString(output, 1, name_);
          }
          com.google.protobuf.GeneratedMessageV3
            .serializeStringMapTo(
              output,
              internalGetParameters(),
              ParametersDefaultEntryHolder.defaultEntry,
              2);
          unknownFields.writeTo(output);
        }

        @java.lang.Override
        public int getSerializedSize() {
          int size = memoizedSize;
          if (size != -1) return size;

          size = 0;
          if (!getNameBytes().isEmpty()) {
            size += com.google.protobuf.GeneratedMessageV3.computeStringSize(1, name_);
          }
          for (java.util.Map.Entry<java.lang.String, java.lang.String> entry
               : internalGetParameters().getMap().entrySet()) {
            com.google.protobuf.MapEntry<java.lang.String, java.lang.String>
            parameters__ = ParametersDefaultEntryHolder.defaultEntry.newBuilderForType()
                .setKey(entry.getKey())
                .setValue(entry.getValue())
                .build();
            size += com.google.protobuf.CodedOutputStream
                .computeMessageSize(2, parameters__);
          }
          size += unknownFields.getSerializedSize();
          memoizedSize = size;
          return size;
        }

        @java.lang.Override
        public boolean equals(final java.lang.Object obj) {
          if (obj == this) {
           return true;
          }
          if (!(obj instanceof org.apache.submarine.server.api.proto.TritonModelConfig.ModelOptimizationPolicy.ExecutionAccelerators.Accelerator)) {
            return super.equals(obj);
          }
          org.apache.submarine.server.api.proto.TritonModelConfig.ModelOptimizationPolicy.ExecutionAccelerators.Accelerator other = (org.apache.submarine.server.api.proto.TritonModelConfig.ModelOptimizationPolicy.ExecutionAccelerators.Accelerator) obj;

          if (!getName()
              .equals(other.getName())) return false;
          if (!internalGetParameters().equals(
              other.internalGetParameters())) return false;
          if (!unknownFields.equals(other.unknownFields)) return false;
          return true;
        }

        @java.lang.Override
        public int hashCode() {
          if (memoizedHashCode != 0) {
            return memoizedHashCode;
          }
          int hash = 41;
          hash = (19 * hash) + getDescriptor().hashCode();
          hash = (37 * hash) + NAME_FIELD_NUMBER;
          hash = (53 * hash) + getName().hashCode();
          if (!internalGetParameters().getMap().isEmpty()) {
            hash = (37 * hash) + PARAMETERS_FIELD_NUMBER;
            hash = (53 * hash) + internalGetParameters().hashCode();
          }
          hash = (29 * hash) + unknownFields.hashCode();
          memoizedHashCode = hash;
          return hash;
        }

        public static org.apache.submarine.server.api.proto.TritonModelConfig.ModelOptimizationPolicy.ExecutionAccelerators.Accelerator parseFrom(
            java.nio.ByteBuffer data)
            throws com.google.protobuf.InvalidProtocolBufferException {
          return PARSER.parseFrom(data);
        }
        public static org.apache.submarine.server.api.proto.TritonModelConfig.ModelOptimizationPolicy.ExecutionAccelerators.Accelerator parseFrom(
            java.nio.ByteBuffer data,
            com.google.protobuf.ExtensionRegistryLite extensionRegistry)
            throws com.google.protobuf.InvalidProtocolBufferException {
          return PARSER.parseFrom(data, extensionRegistry);
        }
        public static org.apache.submarine.server.api.proto.TritonModelConfig.ModelOptimizationPolicy.ExecutionAccelerators.Accelerator parseFrom(
            com.google.protobuf.ByteString data)
            throws com.google.protobuf.InvalidProtocolBufferException {
          return PARSER.parseFrom(data);
        }
        public static org.apache.submarine.server.api.proto.TritonModelConfig.ModelOptimizationPolicy.ExecutionAccelerators.Accelerator parseFrom(
            com.google.protobuf.ByteString data,
            com.google.protobuf.ExtensionRegistryLite extensionRegistry)
            throws com.google.protobuf.InvalidProtocolBufferException {
          return PARSER.parseFrom(data, extensionRegistry);
        }
        public static org.apache.submarine.server.api.proto.TritonModelConfig.ModelOptimizationPolicy.ExecutionAccelerators.Accelerator parseFrom(byte[] data)
            throws com.google.protobuf.InvalidProtocolBufferException {
          return PARSER.parseFrom(data);
        }
        public static org.apache.submarine.server.api.proto.TritonModelConfig.ModelOptimizationPolicy.ExecutionAccelerators.Accelerator parseFrom(
            byte[] data,
            com.google.protobuf.ExtensionRegistryLite extensionRegistry)
            throws com.google.protobuf.InvalidProtocolBufferException {
          return PARSER.parseFrom(data, extensionRegistry);
        }
        public static org.apache.submarine.server.api.proto.TritonModelConfig.ModelOptimizationPolicy.ExecutionAccelerators.Accelerator parseFrom(java.io.InputStream input)
            throws java.io.IOException {
          return com.google.protobuf.GeneratedMessageV3
              .parseWithIOException(PARSER, input);
        }
        public static org.apache.submarine.server.api.proto.TritonModelConfig.ModelOptimizationPolicy.ExecutionAccelerators.Accelerator parseFrom(
            java.io.InputStream input,
            com.google.protobuf.ExtensionRegistryLite extensionRegistry)
            throws java.io.IOException {
          return com.google.protobuf.GeneratedMessageV3
              .parseWithIOException(PARSER, input, extensionRegistry);
        }
        public static org.apache.submarine.server.api.proto.TritonModelConfig.ModelOptimizationPolicy.ExecutionAccelerators.Accelerator parseDelimitedFrom(java.io.InputStream input)
            throws java.io.IOException {
          return com.google.protobuf.GeneratedMessageV3
              .parseDelimitedWithIOException(PARSER, input);
        }
        public static org.apache.submarine.server.api.proto.TritonModelConfig.ModelOptimizationPolicy.ExecutionAccelerators.Accelerator parseDelimitedFrom(
            java.io.InputStream input,
            com.google.protobuf.ExtensionRegistryLite extensionRegistry)
            throws java.io.IOException {
          return com.google.protobuf.GeneratedMessageV3
              .parseDelimitedWithIOException(PARSER, input, extensionRegistry);
        }
        public static org.apache.submarine.server.api.proto.TritonModelConfig.ModelOptimizationPolicy.ExecutionAccelerators.Accelerator parseFrom(
            com.google.protobuf.CodedInputStream input)
            throws java.io.IOException {
          return com.google.protobuf.GeneratedMessageV3
              .parseWithIOException(PARSER, input);
        }
        public static org.apache.submarine.server.api.proto.TritonModelConfig.ModelOptimizationPolicy.ExecutionAccelerators.Accelerator parseFrom(
            com.google.protobuf.CodedInputStream input,
            com.google.protobuf.ExtensionRegistryLite extensionRegistry)
            throws java.io.IOException {
          return com.google.protobuf.GeneratedMessageV3
              .parseWithIOException(PARSER, input, extensionRegistry);
        }

        @java.lang.Override
        public Builder newBuilderForType() { return newBuilder(); }
        public static Builder newBuilder() {
          return DEFAULT_INSTANCE.toBuilder();
        }
        public static Builder newBuilder(org.apache.submarine.server.api.proto.TritonModelConfig.ModelOptimizationPolicy.ExecutionAccelerators.Accelerator prototype) {
          return DEFAULT_INSTANCE.toBuilder().mergeFrom(prototype);
        }
        @java.lang.Override
        public Builder toBuilder() {
          return this == DEFAULT_INSTANCE
              ? new Builder() : new Builder().mergeFrom(this);
        }

        @java.lang.Override
        protected Builder newBuilderForType(
            com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
          Builder builder = new Builder(parent);
          return builder;
        }
        /**
         * <pre>
         *&#64;&#64;
         *&#64;&#64;  .. cpp:var:: message Accelerator
         *&#64;&#64;
         *&#64;&#64;     Specify the accelerator to be used to execute the model.
         *&#64;&#64;     Accelerator with the same name may accept different parameters
         *&#64;&#64;     depending on the backends.
         *&#64;&#64;
         * </pre>
         *
         * Protobuf type {@code inference.ModelOptimizationPolicy.ExecutionAccelerators.Accelerator}
         */
        public static final class Builder extends
            com.google.protobuf.GeneratedMessageV3.Builder<Builder> implements
            // @@protoc_insertion_point(builder_implements:inference.ModelOptimizationPolicy.ExecutionAccelerators.Accelerator)
            org.apache.submarine.server.api.proto.TritonModelConfig.ModelOptimizationPolicy.ExecutionAccelerators.AcceleratorOrBuilder {
          public static final com.google.protobuf.Descriptors.Descriptor
              getDescriptor() {
            return org.apache.submarine.server.api.proto.TritonModelConfig.internal_static_inference_ModelOptimizationPolicy_ExecutionAccelerators_Accelerator_descriptor;
          }

          @SuppressWarnings({"rawtypes"})
          protected com.google.protobuf.MapField internalGetMapField(
              int number) {
            switch (number) {
              case 2:
                return internalGetParameters();
              default:
                throw new RuntimeException(
                    "Invalid map field number: " + number);
            }
          }
          @SuppressWarnings({"rawtypes"})
          protected com.google.protobuf.MapField internalGetMutableMapField(
              int number) {
            switch (number) {
              case 2:
                return internalGetMutableParameters();
              default:
                throw new RuntimeException(
                    "Invalid map field number: " + number);
            }
          }
          @java.lang.Override
          protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
              internalGetFieldAccessorTable() {
            return org.apache.submarine.server.api.proto.TritonModelConfig.internal_static_inference_ModelOptimizationPolicy_ExecutionAccelerators_Accelerator_fieldAccessorTable
                .ensureFieldAccessorsInitialized(
                    org.apache.submarine.server.api.proto.TritonModelConfig.ModelOptimizationPolicy.ExecutionAccelerators.Accelerator.class, org.apache.submarine.server.api.proto.TritonModelConfig.ModelOptimizationPolicy.ExecutionAccelerators.Accelerator.Builder.class);
          }

          // Construct using org.apache.submarine.server.api.proto.TritonModelConfig.ModelOptimizationPolicy.ExecutionAccelerators.Accelerator.newBuilder()
          private Builder() {
            maybeForceBuilderInitialization();
          }

          private Builder(
              com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
            super(parent);
            maybeForceBuilderInitialization();
          }
          private void maybeForceBuilderInitialization() {
            if (com.google.protobuf.GeneratedMessageV3
                    .alwaysUseFieldBuilders) {
            }
          }
          @java.lang.Override
          public Builder clear() {
            super.clear();
            name_ = "";

            internalGetMutableParameters().clear();
            return this;
          }

          @java.lang.Override
          public com.google.protobuf.Descriptors.Descriptor
              getDescriptorForType() {
            return org.apache.submarine.server.api.proto.TritonModelConfig.internal_static_inference_ModelOptimizationPolicy_ExecutionAccelerators_Accelerator_descriptor;
          }

          @java.lang.Override
          public org.apache.submarine.server.api.proto.TritonModelConfig.ModelOptimizationPolicy.ExecutionAccelerators.Accelerator getDefaultInstanceForType() {
            return org.apache.submarine.server.api.proto.TritonModelConfig.ModelOptimizationPolicy.ExecutionAccelerators.Accelerator.getDefaultInstance();
          }

          @java.lang.Override
          public org.apache.submarine.server.api.proto.TritonModelConfig.ModelOptimizationPolicy.ExecutionAccelerators.Accelerator build() {
            org.apache.submarine.server.api.proto.TritonModelConfig.ModelOptimizationPolicy.ExecutionAccelerators.Accelerator result = buildPartial();
            if (!result.isInitialized()) {
              throw newUninitializedMessageException(result);
            }
            return result;
          }

          @java.lang.Override
          public org.apache.submarine.server.api.proto.TritonModelConfig.ModelOptimizationPolicy.ExecutionAccelerators.Accelerator buildPartial() {
            org.apache.submarine.server.api.proto.TritonModelConfig.ModelOptimizationPolicy.ExecutionAccelerators.Accelerator result = new org.apache.submarine.server.api.proto.TritonModelConfig.ModelOptimizationPolicy.ExecutionAccelerators.Accelerator(this);
            int from_bitField0_ = bitField0_;
            result.name_ = name_;
            result.parameters_ = internalGetParameters();
            result.parameters_.makeImmutable();
            onBuilt();
            return result;
          }

          @java.lang.Override
          public Builder clone() {
            return super.clone();
          }
          @java.lang.Override
          public Builder setField(
              com.google.protobuf.Descriptors.FieldDescriptor field,
              java.lang.Object value) {
            return super.setField(field, value);
          }
          @java.lang.Override
          public Builder clearField(
              com.google.protobuf.Descriptors.FieldDescriptor field) {
            return super.clearField(field);
          }
          @java.lang.Override
          public Builder clearOneof(
              com.google.protobuf.Descriptors.OneofDescriptor oneof) {
            return super.clearOneof(oneof);
          }
          @java.lang.Override
          public Builder setRepeatedField(
              com.google.protobuf.Descriptors.FieldDescriptor field,
              int index, java.lang.Object value) {
            return super.setRepeatedField(field, index, value);
          }
          @java.lang.Override
          public Builder addRepeatedField(
              com.google.protobuf.Descriptors.FieldDescriptor field,
              java.lang.Object value) {
            return super.addRepeatedField(field, value);
          }
          @java.lang.Override
          public Builder mergeFrom(com.google.protobuf.Message other) {
            if (other instanceof org.apache.submarine.server.api.proto.TritonModelConfig.ModelOptimizationPolicy.ExecutionAccelerators.Accelerator) {
              return mergeFrom((org.apache.submarine.server.api.proto.TritonModelConfig.ModelOptimizationPolicy.ExecutionAccelerators.Accelerator)other);
            } else {
              super.mergeFrom(other);
              return this;
            }
          }

          public Builder mergeFrom(org.apache.submarine.server.api.proto.TritonModelConfig.ModelOptimizationPolicy.ExecutionAccelerators.Accelerator other) {
            if (other == org.apache.submarine.server.api.proto.TritonModelConfig.ModelOptimizationPolicy.ExecutionAccelerators.Accelerator.getDefaultInstance()) return this;
            if (!other.getName().isEmpty()) {
              name_ = other.name_;
              onChanged();
            }
            internalGetMutableParameters().mergeFrom(
                other.internalGetParameters());
            this.mergeUnknownFields(other.unknownFields);
            onChanged();
            return this;
          }

          @java.lang.Override
          public final boolean isInitialized() {
            return true;
          }

          @java.lang.Override
          public Builder mergeFrom(
              com.google.protobuf.CodedInputStream input,
              com.google.protobuf.ExtensionRegistryLite extensionRegistry)
              throws java.io.IOException {
            org.apache.submarine.server.api.proto.TritonModelConfig.ModelOptimizationPolicy.ExecutionAccelerators.Accelerator parsedMessage = null;
            try {
              parsedMessage = PARSER.parsePartialFrom(input, extensionRegistry);
            } catch (com.google.protobuf.InvalidProtocolBufferException e) {
              parsedMessage = (org.apache.submarine.server.api.proto.TritonModelConfig.ModelOptimizationPolicy.ExecutionAccelerators.Accelerator) e.getUnfinishedMessage();
              throw e.unwrapIOException();
            } finally {
              if (parsedMessage != null) {
                mergeFrom(parsedMessage);
              }
            }
            return this;
          }
          private int bitField0_;

          private java.lang.Object name_ = "";
          /**
           * <pre>
           *&#64;&#64;    .. cpp:var:: string name
           *&#64;&#64;
           *&#64;&#64;       The name of the execution accelerator.
           *&#64;&#64;
           * </pre>
           *
           * <code>string name = 1;</code>
           * @return The name.
           */
          public java.lang.String getName() {
            java.lang.Object ref = name_;
            if (!(ref instanceof java.lang.String)) {
              com.google.protobuf.ByteString bs =
                  (com.google.protobuf.ByteString) ref;
              java.lang.String s = bs.toStringUtf8();
              name_ = s;
              return s;
            } else {
              return (java.lang.String) ref;
            }
          }
          /**
           * <pre>
           *&#64;&#64;    .. cpp:var:: string name
           *&#64;&#64;
           *&#64;&#64;       The name of the execution accelerator.
           *&#64;&#64;
           * </pre>
           *
           * <code>string name = 1;</code>
           * @return The bytes for name.
           */
          public com.google.protobuf.ByteString
              getNameBytes() {
            java.lang.Object ref = name_;
            if (ref instanceof String) {
              com.google.protobuf.ByteString b = 
                  com.google.protobuf.ByteString.copyFromUtf8(
                      (java.lang.String) ref);
              name_ = b;
              return b;
            } else {
              return (com.google.protobuf.ByteString) ref;
            }
          }
          /**
           * <pre>
           *&#64;&#64;    .. cpp:var:: string name
           *&#64;&#64;
           *&#64;&#64;       The name of the execution accelerator.
           *&#64;&#64;
           * </pre>
           *
           * <code>string name = 1;</code>
           * @param value The name to set.
           * @return This builder for chaining.
           */
          public Builder setName(
              java.lang.String value) {
            if (value == null) {
    throw new NullPointerException();
  }
  
            name_ = value;
            onChanged();
            return this;
          }
          /**
           * <pre>
           *&#64;&#64;    .. cpp:var:: string name
           *&#64;&#64;
           *&#64;&#64;       The name of the execution accelerator.
           *&#64;&#64;
           * </pre>
           *
           * <code>string name = 1;</code>
           * @return This builder for chaining.
           */
          public Builder clearName() {
            
            name_ = getDefaultInstance().getName();
            onChanged();
            return this;
          }
          /**
           * <pre>
           *&#64;&#64;    .. cpp:var:: string name
           *&#64;&#64;
           *&#64;&#64;       The name of the execution accelerator.
           *&#64;&#64;
           * </pre>
           *
           * <code>string name = 1;</code>
           * @param value The bytes for name to set.
           * @return This builder for chaining.
           */
          public Builder setNameBytes(
              com.google.protobuf.ByteString value) {
            if (value == null) {
    throw new NullPointerException();
  }
  checkByteStringIsUtf8(value);
            
            name_ = value;
            onChanged();
            return this;
          }

          private com.google.protobuf.MapField<
              java.lang.String, java.lang.String> parameters_;
          private com.google.protobuf.MapField<java.lang.String, java.lang.String>
          internalGetParameters() {
            if (parameters_ == null) {
              return com.google.protobuf.MapField.emptyMapField(
                  ParametersDefaultEntryHolder.defaultEntry);
            }
            return parameters_;
          }
          private com.google.protobuf.MapField<java.lang.String, java.lang.String>
          internalGetMutableParameters() {
            onChanged();;
            if (parameters_ == null) {
              parameters_ = com.google.protobuf.MapField.newMapField(
                  ParametersDefaultEntryHolder.defaultEntry);
            }
            if (!parameters_.isMutable()) {
              parameters_ = parameters_.copy();
            }
            return parameters_;
          }

          public int getParametersCount() {
            return internalGetParameters().getMap().size();
          }
          /**
           * <pre>
           *&#64;&#64;    .. cpp:var:: map&lt;string, string&gt; parameters
           *&#64;&#64;
           *&#64;&#64;       Additional paremeters used to configure the accelerator.
           *&#64;&#64;
           * </pre>
           *
           * <code>map&lt;string, string&gt; parameters = 2;</code>
           */

          @java.lang.Override
          public boolean containsParameters(
              java.lang.String key) {
            if (key == null) { throw new java.lang.NullPointerException(); }
            return internalGetParameters().getMap().containsKey(key);
          }
          /**
           * Use {@link #getParametersMap()} instead.
           */
          @java.lang.Override
          @java.lang.Deprecated
          public java.util.Map<java.lang.String, java.lang.String> getParameters() {
            return getParametersMap();
          }
          /**
           * <pre>
           *&#64;&#64;    .. cpp:var:: map&lt;string, string&gt; parameters
           *&#64;&#64;
           *&#64;&#64;       Additional paremeters used to configure the accelerator.
           *&#64;&#64;
           * </pre>
           *
           * <code>map&lt;string, string&gt; parameters = 2;</code>
           */
          @java.lang.Override

          public java.util.Map<java.lang.String, java.lang.String> getParametersMap() {
            return internalGetParameters().getMap();
          }
          /**
           * <pre>
           *&#64;&#64;    .. cpp:var:: map&lt;string, string&gt; parameters
           *&#64;&#64;
           *&#64;&#64;       Additional paremeters used to configure the accelerator.
           *&#64;&#64;
           * </pre>
           *
           * <code>map&lt;string, string&gt; parameters = 2;</code>
           */
          @java.lang.Override

          public java.lang.String getParametersOrDefault(
              java.lang.String key,
              java.lang.String defaultValue) {
            if (key == null) { throw new java.lang.NullPointerException(); }
            java.util.Map<java.lang.String, java.lang.String> map =
                internalGetParameters().getMap();
            return map.containsKey(key) ? map.get(key) : defaultValue;
          }
          /**
           * <pre>
           *&#64;&#64;    .. cpp:var:: map&lt;string, string&gt; parameters
           *&#64;&#64;
           *&#64;&#64;       Additional paremeters used to configure the accelerator.
           *&#64;&#64;
           * </pre>
           *
           * <code>map&lt;string, string&gt; parameters = 2;</code>
           */
          @java.lang.Override

          public java.lang.String getParametersOrThrow(
              java.lang.String key) {
            if (key == null) { throw new java.lang.NullPointerException(); }
            java.util.Map<java.lang.String, java.lang.String> map =
                internalGetParameters().getMap();
            if (!map.containsKey(key)) {
              throw new java.lang.IllegalArgumentException();
            }
            return map.get(key);
          }

          public Builder clearParameters() {
            internalGetMutableParameters().getMutableMap()
                .clear();
            return this;
          }
          /**
           * <pre>
           *&#64;&#64;    .. cpp:var:: map&lt;string, string&gt; parameters
           *&#64;&#64;
           *&#64;&#64;       Additional paremeters used to configure the accelerator.
           *&#64;&#64;
           * </pre>
           *
           * <code>map&lt;string, string&gt; parameters = 2;</code>
           */

          public Builder removeParameters(
              java.lang.String key) {
            if (key == null) { throw new java.lang.NullPointerException(); }
            internalGetMutableParameters().getMutableMap()
                .remove(key);
            return this;
          }
          /**
           * Use alternate mutation accessors instead.
           */
          @java.lang.Deprecated
          public java.util.Map<java.lang.String, java.lang.String>
          getMutableParameters() {
            return internalGetMutableParameters().getMutableMap();
          }
          /**
           * <pre>
           *&#64;&#64;    .. cpp:var:: map&lt;string, string&gt; parameters
           *&#64;&#64;
           *&#64;&#64;       Additional paremeters used to configure the accelerator.
           *&#64;&#64;
           * </pre>
           *
           * <code>map&lt;string, string&gt; parameters = 2;</code>
           */
          public Builder putParameters(
              java.lang.String key,
              java.lang.String value) {
            if (key == null) { throw new java.lang.NullPointerException(); }
            if (value == null) { throw new java.lang.NullPointerException(); }
            internalGetMutableParameters().getMutableMap()
                .put(key, value);
            return this;
          }
          /**
           * <pre>
           *&#64;&#64;    .. cpp:var:: map&lt;string, string&gt; parameters
           *&#64;&#64;
           *&#64;&#64;       Additional paremeters used to configure the accelerator.
           *&#64;&#64;
           * </pre>
           *
           * <code>map&lt;string, string&gt; parameters = 2;</code>
           */

          public Builder putAllParameters(
              java.util.Map<java.lang.String, java.lang.String> values) {
            internalGetMutableParameters().getMutableMap()
                .putAll(values);
            return this;
          }
          @java.lang.Override
          public final Builder setUnknownFields(
              final com.google.protobuf.UnknownFieldSet unknownFields) {
            return super.setUnknownFields(unknownFields);
          }

          @java.lang.Override
          public final Builder mergeUnknownFields(
              final com.google.protobuf.UnknownFieldSet unknownFields) {
            return super.mergeUnknownFields(unknownFields);
          }


          // @@protoc_insertion_point(builder_scope:inference.ModelOptimizationPolicy.ExecutionAccelerators.Accelerator)
        }

        // @@protoc_insertion_point(class_scope:inference.ModelOptimizationPolicy.ExecutionAccelerators.Accelerator)
        private static final org.apache.submarine.server.api.proto.TritonModelConfig.ModelOptimizationPolicy.ExecutionAccelerators.Accelerator DEFAULT_INSTANCE;
        static {
          DEFAULT_INSTANCE = new org.apache.submarine.server.api.proto.TritonModelConfig.ModelOptimizationPolicy.ExecutionAccelerators.Accelerator();
        }

        public static org.apache.submarine.server.api.proto.TritonModelConfig.ModelOptimizationPolicy.ExecutionAccelerators.Accelerator getDefaultInstance() {
          return DEFAULT_INSTANCE;
        }

        private static final com.google.protobuf.Parser<Accelerator>
            PARSER = new com.google.protobuf.AbstractParser<Accelerator>() {
          @java.lang.Override
          public Accelerator parsePartialFrom(
              com.google.protobuf.CodedInputStream input,
              com.google.protobuf.ExtensionRegistryLite extensionRegistry)
              throws com.google.protobuf.InvalidProtocolBufferException {
            return new Accelerator(input, extensionRegistry);
          }
        };

        public static com.google.protobuf.Parser<Accelerator> parser() {
          return PARSER;
        }

        @java.lang.Override
        public com.google.protobuf.Parser<Accelerator> getParserForType() {
          return PARSER;
        }

        @java.lang.Override
        public org.apache.submarine.server.api.proto.TritonModelConfig.ModelOptimizationPolicy.ExecutionAccelerators.Accelerator getDefaultInstanceForType() {
          return DEFAULT_INSTANCE;
        }

      }

      public static final int GPU_EXECUTION_ACCELERATOR_FIELD_NUMBER = 1;
      private java.util.List<org.apache.submarine.server.api.proto.TritonModelConfig.ModelOptimizationPolicy.ExecutionAccelerators.Accelerator> gpuExecutionAccelerator_;
      /**
       * <pre>
       *&#64;&#64;    .. cpp:var:: Accelerator gpu_execution_accelerator (repeated)
       *&#64;&#64;
       *&#64;&#64;       The preferred execution provider to be used if the model instance
       *&#64;&#64;       is deployed on GPU.
       *&#64;&#64;
       *&#64;&#64;       For ONNX Runtime backend, possible value is "tensorrt" as name,
       *&#64;&#64;       and no parameters are required.
       *&#64;&#64;
       *&#64;&#64;       For TensorFlow backend, possible values are "tensorrt",
       *&#64;&#64;       "auto_mixed_precision", "gpu_io".
       *&#64;&#64;
       *&#64;&#64;       For "tensorrt", the following parameters can be specified:
       *&#64;&#64;         "precision_mode": The precision used for optimization.
       *&#64;&#64;         Allowed values are "FP32" and "FP16". Default value is "FP32".
       *&#64;&#64;
       *&#64;&#64;         "max_cached_engines": The maximum number of cached TensorRT
       *&#64;&#64;         engines in dynamic TensorRT ops. Default value is 100.
       *&#64;&#64;
       *&#64;&#64;         "minimum_segment_size": The smallest model subgraph that will
       *&#64;&#64;         be considered for optimization by TensorRT. Default value is 3.
       *&#64;&#64;
       *&#64;&#64;         "max_workspace_size_bytes": The maximum GPU memory the model
       *&#64;&#64;         can use temporarily during execution. Default value is 1GB.
       *&#64;&#64;
       *&#64;&#64;       For "auto_mixed_precision", no parameters are required. If set,
       *&#64;&#64;       the model will try to use FP16 for better performance.
       *&#64;&#64;       This optimization can not be set with "tensorrt".
       *&#64;&#64;
       *&#64;&#64;       For "gpu_io", no parameters are required. If set, the model will
       *&#64;&#64;       be executed using TensorFlow Callable API to set input and output
       *&#64;&#64;       tensors in GPU memory if possible, which can reduce data transfer
       *&#64;&#64;       overhead if the model is used in ensemble. However, the Callable
       *&#64;&#64;       object will be created on model creation and it will request all
       *&#64;&#64;       outputs for every model execution, which may impact the
       *&#64;&#64;       performance if a request does not require all outputs. This
       *&#64;&#64;       optimization will only take affect if the model instance is
       *&#64;&#64;       created with KIND_GPU.
       *&#64;&#64;
       * </pre>
       *
       * <code>repeated .inference.ModelOptimizationPolicy.ExecutionAccelerators.Accelerator gpu_execution_accelerator = 1;</code>
       */
      @java.lang.Override
      public java.util.List<org.apache.submarine.server.api.proto.TritonModelConfig.ModelOptimizationPolicy.ExecutionAccelerators.Accelerator> getGpuExecutionAcceleratorList() {
        return gpuExecutionAccelerator_;
      }
      /**
       * <pre>
       *&#64;&#64;    .. cpp:var:: Accelerator gpu_execution_accelerator (repeated)
       *&#64;&#64;
       *&#64;&#64;       The preferred execution provider to be used if the model instance
       *&#64;&#64;       is deployed on GPU.
       *&#64;&#64;
       *&#64;&#64;       For ONNX Runtime backend, possible value is "tensorrt" as name,
       *&#64;&#64;       and no parameters are required.
       *&#64;&#64;
       *&#64;&#64;       For TensorFlow backend, possible values are "tensorrt",
       *&#64;&#64;       "auto_mixed_precision", "gpu_io".
       *&#64;&#64;
       *&#64;&#64;       For "tensorrt", the following parameters can be specified:
       *&#64;&#64;         "precision_mode": The precision used for optimization.
       *&#64;&#64;         Allowed values are "FP32" and "FP16". Default value is "FP32".
       *&#64;&#64;
       *&#64;&#64;         "max_cached_engines": The maximum number of cached TensorRT
       *&#64;&#64;         engines in dynamic TensorRT ops. Default value is 100.
       *&#64;&#64;
       *&#64;&#64;         "minimum_segment_size": The smallest model subgraph that will
       *&#64;&#64;         be considered for optimization by TensorRT. Default value is 3.
       *&#64;&#64;
       *&#64;&#64;         "max_workspace_size_bytes": The maximum GPU memory the model
       *&#64;&#64;         can use temporarily during execution. Default value is 1GB.
       *&#64;&#64;
       *&#64;&#64;       For "auto_mixed_precision", no parameters are required. If set,
       *&#64;&#64;       the model will try to use FP16 for better performance.
       *&#64;&#64;       This optimization can not be set with "tensorrt".
       *&#64;&#64;
       *&#64;&#64;       For "gpu_io", no parameters are required. If set, the model will
       *&#64;&#64;       be executed using TensorFlow Callable API to set input and output
       *&#64;&#64;       tensors in GPU memory if possible, which can reduce data transfer
       *&#64;&#64;       overhead if the model is used in ensemble. However, the Callable
       *&#64;&#64;       object will be created on model creation and it will request all
       *&#64;&#64;       outputs for every model execution, which may impact the
       *&#64;&#64;       performance if a request does not require all outputs. This
       *&#64;&#64;       optimization will only take affect if the model instance is
       *&#64;&#64;       created with KIND_GPU.
       *&#64;&#64;
       * </pre>
       *
       * <code>repeated .inference.ModelOptimizationPolicy.ExecutionAccelerators.Accelerator gpu_execution_accelerator = 1;</code>
       */
      @java.lang.Override
      public java.util.List<? extends org.apache.submarine.server.api.proto.TritonModelConfig.ModelOptimizationPolicy.ExecutionAccelerators.AcceleratorOrBuilder> 
          getGpuExecutionAcceleratorOrBuilderList() {
        return gpuExecutionAccelerator_;
      }
      /**
       * <pre>
       *&#64;&#64;    .. cpp:var:: Accelerator gpu_execution_accelerator (repeated)
       *&#64;&#64;
       *&#64;&#64;       The preferred execution provider to be used if the model instance
       *&#64;&#64;       is deployed on GPU.
       *&#64;&#64;
       *&#64;&#64;       For ONNX Runtime backend, possible value is "tensorrt" as name,
       *&#64;&#64;       and no parameters are required.
       *&#64;&#64;
       *&#64;&#64;       For TensorFlow backend, possible values are "tensorrt",
       *&#64;&#64;       "auto_mixed_precision", "gpu_io".
       *&#64;&#64;
       *&#64;&#64;       For "tensorrt", the following parameters can be specified:
       *&#64;&#64;         "precision_mode": The precision used for optimization.
       *&#64;&#64;         Allowed values are "FP32" and "FP16". Default value is "FP32".
       *&#64;&#64;
       *&#64;&#64;         "max_cached_engines": The maximum number of cached TensorRT
       *&#64;&#64;         engines in dynamic TensorRT ops. Default value is 100.
       *&#64;&#64;
       *&#64;&#64;         "minimum_segment_size": The smallest model subgraph that will
       *&#64;&#64;         be considered for optimization by TensorRT. Default value is 3.
       *&#64;&#64;
       *&#64;&#64;         "max_workspace_size_bytes": The maximum GPU memory the model
       *&#64;&#64;         can use temporarily during execution. Default value is 1GB.
       *&#64;&#64;
       *&#64;&#64;       For "auto_mixed_precision", no parameters are required. If set,
       *&#64;&#64;       the model will try to use FP16 for better performance.
       *&#64;&#64;       This optimization can not be set with "tensorrt".
       *&#64;&#64;
       *&#64;&#64;       For "gpu_io", no parameters are required. If set, the model will
       *&#64;&#64;       be executed using TensorFlow Callable API to set input and output
       *&#64;&#64;       tensors in GPU memory if possible, which can reduce data transfer
       *&#64;&#64;       overhead if the model is used in ensemble. However, the Callable
       *&#64;&#64;       object will be created on model creation and it will request all
       *&#64;&#64;       outputs for every model execution, which may impact the
       *&#64;&#64;       performance if a request does not require all outputs. This
       *&#64;&#64;       optimization will only take affect if the model instance is
       *&#64;&#64;       created with KIND_GPU.
       *&#64;&#64;
       * </pre>
       *
       * <code>repeated .inference.ModelOptimizationPolicy.ExecutionAccelerators.Accelerator gpu_execution_accelerator = 1;</code>
       */
      @java.lang.Override
      public int getGpuExecutionAcceleratorCount() {
        return gpuExecutionAccelerator_.size();
      }
      /**
       * <pre>
       *&#64;&#64;    .. cpp:var:: Accelerator gpu_execution_accelerator (repeated)
       *&#64;&#64;
       *&#64;&#64;       The preferred execution provider to be used if the model instance
       *&#64;&#64;       is deployed on GPU.
       *&#64;&#64;
       *&#64;&#64;       For ONNX Runtime backend, possible value is "tensorrt" as name,
       *&#64;&#64;       and no parameters are required.
       *&#64;&#64;
       *&#64;&#64;       For TensorFlow backend, possible values are "tensorrt",
       *&#64;&#64;       "auto_mixed_precision", "gpu_io".
       *&#64;&#64;
       *&#64;&#64;       For "tensorrt", the following parameters can be specified:
       *&#64;&#64;         "precision_mode": The precision used for optimization.
       *&#64;&#64;         Allowed values are "FP32" and "FP16". Default value is "FP32".
       *&#64;&#64;
       *&#64;&#64;         "max_cached_engines": The maximum number of cached TensorRT
       *&#64;&#64;         engines in dynamic TensorRT ops. Default value is 100.
       *&#64;&#64;
       *&#64;&#64;         "minimum_segment_size": The smallest model subgraph that will
       *&#64;&#64;         be considered for optimization by TensorRT. Default value is 3.
       *&#64;&#64;
       *&#64;&#64;         "max_workspace_size_bytes": The maximum GPU memory the model
       *&#64;&#64;         can use temporarily during execution. Default value is 1GB.
       *&#64;&#64;
       *&#64;&#64;       For "auto_mixed_precision", no parameters are required. If set,
       *&#64;&#64;       the model will try to use FP16 for better performance.
       *&#64;&#64;       This optimization can not be set with "tensorrt".
       *&#64;&#64;
       *&#64;&#64;       For "gpu_io", no parameters are required. If set, the model will
       *&#64;&#64;       be executed using TensorFlow Callable API to set input and output
       *&#64;&#64;       tensors in GPU memory if possible, which can reduce data transfer
       *&#64;&#64;       overhead if the model is used in ensemble. However, the Callable
       *&#64;&#64;       object will be created on model creation and it will request all
       *&#64;&#64;       outputs for every model execution, which may impact the
       *&#64;&#64;       performance if a request does not require all outputs. This
       *&#64;&#64;       optimization will only take affect if the model instance is
       *&#64;&#64;       created with KIND_GPU.
       *&#64;&#64;
       * </pre>
       *
       * <code>repeated .inference.ModelOptimizationPolicy.ExecutionAccelerators.Accelerator gpu_execution_accelerator = 1;</code>
       */
      @java.lang.Override
      public org.apache.submarine.server.api.proto.TritonModelConfig.ModelOptimizationPolicy.ExecutionAccelerators.Accelerator getGpuExecutionAccelerator(int index) {
        return gpuExecutionAccelerator_.get(index);
      }
      /**
       * <pre>
       *&#64;&#64;    .. cpp:var:: Accelerator gpu_execution_accelerator (repeated)
       *&#64;&#64;
       *&#64;&#64;       The preferred execution provider to be used if the model instance
       *&#64;&#64;       is deployed on GPU.
       *&#64;&#64;
       *&#64;&#64;       For ONNX Runtime backend, possible value is "tensorrt" as name,
       *&#64;&#64;       and no parameters are required.
       *&#64;&#64;
       *&#64;&#64;       For TensorFlow backend, possible values are "tensorrt",
       *&#64;&#64;       "auto_mixed_precision", "gpu_io".
       *&#64;&#64;
       *&#64;&#64;       For "tensorrt", the following parameters can be specified:
       *&#64;&#64;         "precision_mode": The precision used for optimization.
       *&#64;&#64;         Allowed values are "FP32" and "FP16". Default value is "FP32".
       *&#64;&#64;
       *&#64;&#64;         "max_cached_engines": The maximum number of cached TensorRT
       *&#64;&#64;         engines in dynamic TensorRT ops. Default value is 100.
       *&#64;&#64;
       *&#64;&#64;         "minimum_segment_size": The smallest model subgraph that will
       *&#64;&#64;         be considered for optimization by TensorRT. Default value is 3.
       *&#64;&#64;
       *&#64;&#64;         "max_workspace_size_bytes": The maximum GPU memory the model
       *&#64;&#64;         can use temporarily during execution. Default value is 1GB.
       *&#64;&#64;
       *&#64;&#64;       For "auto_mixed_precision", no parameters are required. If set,
       *&#64;&#64;       the model will try to use FP16 for better performance.
       *&#64;&#64;       This optimization can not be set with "tensorrt".
       *&#64;&#64;
       *&#64;&#64;       For "gpu_io", no parameters are required. If set, the model will
       *&#64;&#64;       be executed using TensorFlow Callable API to set input and output
       *&#64;&#64;       tensors in GPU memory if possible, which can reduce data transfer
       *&#64;&#64;       overhead if the model is used in ensemble. However, the Callable
       *&#64;&#64;       object will be created on model creation and it will request all
       *&#64;&#64;       outputs for every model execution, which may impact the
       *&#64;&#64;       performance if a request does not require all outputs. This
       *&#64;&#64;       optimization will only take affect if the model instance is
       *&#64;&#64;       created with KIND_GPU.
       *&#64;&#64;
       * </pre>
       *
       * <code>repeated .inference.ModelOptimizationPolicy.ExecutionAccelerators.Accelerator gpu_execution_accelerator = 1;</code>
       */
      @java.lang.Override
      public org.apache.submarine.server.api.proto.TritonModelConfig.ModelOptimizationPolicy.ExecutionAccelerators.AcceleratorOrBuilder getGpuExecutionAcceleratorOrBuilder(
          int index) {
        return gpuExecutionAccelerator_.get(index);
      }

      public static final int CPU_EXECUTION_ACCELERATOR_FIELD_NUMBER = 2;
      private java.util.List<org.apache.submarine.server.api.proto.TritonModelConfig.ModelOptimizationPolicy.ExecutionAccelerators.Accelerator> cpuExecutionAccelerator_;
      /**
       * <pre>
       *&#64;&#64;    .. cpp:var:: Accelerator cpu_execution_accelerator (repeated)
       *&#64;&#64;
       *&#64;&#64;       The preferred execution provider to be used if the model instance
       *&#64;&#64;       is deployed on CPU.
       *&#64;&#64;
       *&#64;&#64;       For ONNX Runtime backend, possible value is "openvino" as name,
       *&#64;&#64;       and no parameters are required.
       *&#64;&#64;
       * </pre>
       *
       * <code>repeated .inference.ModelOptimizationPolicy.ExecutionAccelerators.Accelerator cpu_execution_accelerator = 2;</code>
       */
      @java.lang.Override
      public java.util.List<org.apache.submarine.server.api.proto.TritonModelConfig.ModelOptimizationPolicy.ExecutionAccelerators.Accelerator> getCpuExecutionAcceleratorList() {
        return cpuExecutionAccelerator_;
      }
      /**
       * <pre>
       *&#64;&#64;    .. cpp:var:: Accelerator cpu_execution_accelerator (repeated)
       *&#64;&#64;
       *&#64;&#64;       The preferred execution provider to be used if the model instance
       *&#64;&#64;       is deployed on CPU.
       *&#64;&#64;
       *&#64;&#64;       For ONNX Runtime backend, possible value is "openvino" as name,
       *&#64;&#64;       and no parameters are required.
       *&#64;&#64;
       * </pre>
       *
       * <code>repeated .inference.ModelOptimizationPolicy.ExecutionAccelerators.Accelerator cpu_execution_accelerator = 2;</code>
       */
      @java.lang.Override
      public java.util.List<? extends org.apache.submarine.server.api.proto.TritonModelConfig.ModelOptimizationPolicy.ExecutionAccelerators.AcceleratorOrBuilder> 
          getCpuExecutionAcceleratorOrBuilderList() {
        return cpuExecutionAccelerator_;
      }
      /**
       * <pre>
       *&#64;&#64;    .. cpp:var:: Accelerator cpu_execution_accelerator (repeated)
       *&#64;&#64;
       *&#64;&#64;       The preferred execution provider to be used if the model instance
       *&#64;&#64;       is deployed on CPU.
       *&#64;&#64;
       *&#64;&#64;       For ONNX Runtime backend, possible value is "openvino" as name,
       *&#64;&#64;       and no parameters are required.
       *&#64;&#64;
       * </pre>
       *
       * <code>repeated .inference.ModelOptimizationPolicy.ExecutionAccelerators.Accelerator cpu_execution_accelerator = 2;</code>
       */
      @java.lang.Override
      public int getCpuExecutionAcceleratorCount() {
        return cpuExecutionAccelerator_.size();
      }
      /**
       * <pre>
       *&#64;&#64;    .. cpp:var:: Accelerator cpu_execution_accelerator (repeated)
       *&#64;&#64;
       *&#64;&#64;      