# Licensed to the Apache Software Foundation (ASF) under one or more
# contributor license agreements.  See the NOTICE file distributed with
# this work for additional information regarding copyright ownership.
# The ASF licenses this file to You under the Apache License, Version 2.0
# (the "License"); you may not use this file except in compliance with
# the License.  You may obtain a copy of the License at
#
#     http://www.apache.org/licenses/LICENSE-2.0
#
# Unless required by applicable law or agreed to in writing, software
# distributed under the License is distributed on an "AS IS" BASIS,
# WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
# See the License for the specific language governing permissions and
# limitations under the License.

# coding: utf-8

"""
    Submarine API

    The Submarine REST API allows you to access Submarine resources such as,  experiments, environments and notebooks. The  API is hosted under the /v1 path on the Submarine server. For example,  to list experiments on a server hosted at http://localhost:8080, access http://localhost:8080/api/v1/experiment/  # noqa: E501

    The version of the OpenAPI document: 0.9.0-SNAPSHOT
    Contact: dev@submarine.apache.org
    Generated by: https://openapi-generator.tech
"""


import pprint
import re  # noqa: F401

import six

from submarine.client.configuration import Configuration


class ModelVersionEntity(object):
    """NOTE: This class is auto generated by OpenAPI Generator.
    Ref: https://openapi-generator.tech

    Do not edit the class manually.
    """

    """
    Attributes:
      openapi_types (dict): The key is attribute name
                            and the value is attribute type.
      attribute_map (dict): The key is attribute name
                            and the value is json key in definition.
    """
    openapi_types = {
        'creation_time': 'datetime',
        'current_stage': 'str',
        'dataset': 'str',
        'description': 'str',
        'experiment_id': 'str',
        'id': 'str',
        'last_updated_time': 'datetime',
        'model_type': 'str',
        'model_version_id': 'int',
        'name': 'str',
        'tags': 'list[str]',
        'user_id': 'str',
        'version': 'int',
    }

    attribute_map = {
        'creation_time': 'creationTime',
        'current_stage': 'currentStage',
        'dataset': 'dataset',
        'description': 'description',
        'experiment_id': 'experimentId',
        'id': 'id',
        'last_updated_time': 'lastUpdatedTime',
        'model_type': 'modelType',
        'model_version_id': 'modelVersionId',
        'name': 'name',
        'tags': 'tags',
        'user_id': 'userId',
        'version': 'version',
    }

    def __init__(
        self,
        creation_time=None,
        current_stage=None,
        dataset=None,
        description=None,
        experiment_id=None,
        id=None,
        last_updated_time=None,
        model_type=None,
        model_version_id=None,
        name=None,
        tags=None,
        user_id=None,
        version=None,
        local_vars_configuration=None,
    ):  # noqa: E501
        """ModelVersionEntity - a model defined in OpenAPI"""  # noqa: E501
        if local_vars_configuration is None:
            local_vars_configuration = Configuration()
        self.local_vars_configuration = local_vars_configuration

        self._creation_time = None
        self._current_stage = None
        self._dataset = None
        self._description = None
        self._experiment_id = None
        self._id = None
        self._last_updated_time = None
        self._model_type = None
        self._model_version_id = None
        self._name = None
        self._tags = None
        self._user_id = None
        self._version = None
        self.discriminator = None

        if creation_time is not None:
            self.creation_time = creation_time
        if current_stage is not None:
            self.current_stage = current_stage
        if dataset is not None:
            self.dataset = dataset
        if description is not None:
            self.description = description
        if experiment_id is not None:
            self.experiment_id = experiment_id
        if id is not None:
            self.id = id
        if last_updated_time is not None:
            self.last_updated_time = last_updated_time
        if model_type is not None:
            self.model_type = model_type
        if model_version_id is not None:
            self.model_version_id = model_version_id
        if name is not None:
            self.name = name
        if tags is not None:
            self.tags = tags
        if user_id is not None:
            self.user_id = user_id
        if version is not None:
            self.version = version

    @property
    def creation_time(self):
        """Gets the creation_time of this ModelVersionEntity.  # noqa: E501


        :return: The creation_time of this ModelVersionEntity.  # noqa: E501
        :rtype: datetime
        """
        return self._creation_time

    @creation_time.setter
    def creation_time(self, creation_time):
        """Sets the creation_time of this ModelVersionEntity.


        :param creation_time: The creation_time of this ModelVersionEntity.  # noqa: E501
        :type: datetime
        """

        self._creation_time = creation_time

    @property
    def current_stage(self):
        """Gets the current_stage of this ModelVersionEntity.  # noqa: E501


        :return: The current_stage of this ModelVersionEntity.  # noqa: E501
        :rtype: str
        """
        return self._current_stage

    @current_stage.setter
    def current_stage(self, current_stage):
        """Sets the current_stage of this ModelVersionEntity.


        :param current_stage: The current_stage of this ModelVersionEntity.  # noqa: E501
        :type: str
        """

        self._current_stage = current_stage

    @property
    def dataset(self):
        """Gets the dataset of this ModelVersionEntity.  # noqa: E501


        :return: The dataset of this ModelVersionEntity.  # noqa: E501
        :rtype: str
        """
        return self._dataset

    @dataset.setter
    def dataset(self, dataset):
        """Sets the dataset of this ModelVersionEntity.


        :param dataset: The dataset of this ModelVersionEntity.  # noqa: E501
        :type: str
        """

        self._dataset = dataset

    @property
    def description(self):
        """Gets the description of this ModelVersionEntity.  # noqa: E501


        :return: The description of this ModelVersionEntity.  # noqa: E501
        :rtype: str
        """
        return self._description

    @description.setter
    def description(self, description):
        """Sets the description of this ModelVersionEntity.


        :param description: The description of this ModelVersionEntity.  # noqa: E501
        :type: str
        """

        self._description = description

    @property
    def experiment_id(self):
        """Gets the experiment_id of this ModelVersionEntity.  # noqa: E501


        :return: The experiment_id of this ModelVersionEntity.  # noqa: E501
        :rtype: str
        """
        return self._experiment_id

    @experiment_id.setter
    def experiment_id(self, experiment_id):
        """Sets the experiment_id of this ModelVersionEntity.


        :param experiment_id: The experiment_id of this ModelVersionEntity.  # noqa: E501
        :type: str
        """

        self._experiment_id = experiment_id

    @property
    def id(self):
        """Gets the id of this ModelVersionEntity.  # noqa: E501


        :return: The id of this ModelVersionEntity.  # noqa: E501
        :rtype: str
        """
        return self._id

    @id.setter
    def id(self, id):
        """Sets the id of this ModelVersionEntity.


        :param id: The id of this ModelVersionEntity.  # noqa: E501
        :type: str
        """

        self._id = id

    @property
    def last_updated_time(self):
        """Gets the last_updated_time of this ModelVersionEntity.  # noqa: E501


        :return: The last_updated_time of this ModelVersionEntity.  # noqa: E501
        :rtype: datetime
        """
        return self._last_updated_time

    @last_updated_time.setter
    def last_updated_time(self, last_updated_time):
        """Sets the last_updated_time of this ModelVersionEntity.


        :param last_updated_time: The last_updated_time of this ModelVersionEntity.  # noqa: E501
        :type: datetime
        """

        self._last_updated_time = last_updated_time

    @property
    def model_type(self):
        """Gets the model_type of this ModelVersionEntity.  # noqa: E501


        :return: The model_type of this ModelVersionEntity.  # noqa: E501
        :rtype: str
        """
        return self._model_type

    @model_type.setter
    def model_type(self, model_type):
        """Sets the model_type of this ModelVersionEntity.


        :param model_type: The model_type of this ModelVersionEntity.  # noqa: E501
        :type: str
        """

        self._model_type = model_type

    @property
    def model_version_id(self):
        """Gets the model_version_id of this ModelVersionEntity.  # noqa: E501


        :return: The model_version_id of this ModelVersionEntity.  # noqa: E501
        :rtype: int
        """
        return self._model_version_id

    @model_version_id.setter
    def model_version_id(self, model_version_id):
        """Sets the model_version_id of this ModelVersionEntity.


        :param model_version_id: The model_version_id of this ModelVersionEntity.  # noqa: E501
        :type: int
        """

        self._model_version_id = model_version_id

    @property
    def name(self):
        """Gets the name of this ModelVersionEntity.  # noqa: E501


        :return: The name of this ModelVersionEntity.  # noqa: E501
        :rtype: str
        """
        return self._name

    @name.setter
    def name(self, name):
        """Sets the name of this ModelVersionEntity.


        :param name: The name of this ModelVersionEntity.  # noqa: E501
        :type: str
        """

        self._name = name

    @property
    def tags(self):
        """Gets the tags of this ModelVersionEntity.  # noqa: E501


        :return: The tags of this ModelVersionEntity.  # noqa: E501
        :rtype: list[str]
        """
        return self._tags

    @tags.setter
    def tags(self, tags):
        """Sets the tags of this ModelVersionEntity.


        :param tags: The tags of this ModelVersionEntity.  # noqa: E501
        :type: list[str]
        """

        self._tags = tags

    @property
    def user_id(self):
        """Gets the user_id of this ModelVersionEntity.  # noqa: E501


        :return: The user_id of this ModelVersionEntity.  # noqa: E501
        :rtype: str
        """
        return self._user_id

    @user_id.setter
    def user_id(self, user_id):
        """Sets the user_id of this ModelVersionEntity.


        :param user_id: The user_id of this ModelVersionEntity.  # noqa: E501
        :type: str
        """

        self._user_id = user_id

    @property
    def version(self):
        """Gets the version of this ModelVersionEntity.  # noqa: E501


        :return: The version of this ModelVersionEntity.  # noqa: E501
        :rtype: int
        """
        return self._version

    @version.setter
    def version(self, version):
        """Sets the version of this ModelVersionEntity.


        :param version: The version of this ModelVersionEntity.  # noqa: E501
        :type: int
        """

        self._version = version

    def to_dict(self):
        """Returns the model properties as a dict"""
        result = {}

        for attr, _ in six.iteritems(self.openapi_types):
            value = getattr(self, attr)
            if isinstance(value, list):
                result[attr] = list(map(lambda x: x.to_dict() if hasattr(x, "to_dict") else x, value))
            elif hasattr(value, "to_dict"):
                result[attr] = value.to_dict()
            elif isinstance(value, dict):
                result[attr] = dict(
                    map(
                        lambda item: (item[0], item[1].to_dict()) if hasattr(item[1], "to_dict") else item,
                        value.items(),
                    )
                )
            else:
                result[attr] = value

        return result

    def to_str(self):
        """Returns the string representation of the model"""
        return pprint.pformat(self.to_dict())

    def __repr__(self):
        """For `print` and `pprint`"""
        return self.to_str()

    def __eq__(self, other):
        """Returns true if both objects are equal"""
        if not isinstance(other, ModelVersionEntity):
            return False

        return self.to_dict() == other.to_dict()

    def __ne__(self, other):
        """Returns true if both objects are not equal"""
        if not isinstance(other, ModelVersionEntity):
            return True

        return self.to_dict() != other.to_dict()
