# Licensed to the Apache Software Foundation (ASF) under one or more
# contributor license agreements.  See the NOTICE file distributed with
# this work for additional information regarding copyright ownership.
# The ASF licenses this file to You under the Apache License, Version 2.0
# (the "License"); you may not use this file except in compliance with
# the License.  You may obtain a copy of the License at
#
#     http://www.apache.org/licenses/LICENSE-2.0
#
# Unless required by applicable law or agreed to in writing, software
# distributed under the License is distributed on an "AS IS" BASIS,
# WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
# See the License for the specific language governing permissions and
# limitations under the License.

# coding: utf-8

"""
    Submarine API

    The Submarine REST API allows you to access Submarine resources such as,  experiments, environments and notebooks. The  API is hosted under the /v1 path on the Submarine server. For example,  to list experiments on a server hosted at http://localhost:8080, access http://localhost:8080/api/v1/experiment/  # noqa: E501

    The version of the OpenAPI document: 0.9.0-SNAPSHOT
    Contact: dev@submarine.apache.org
    Generated by: https://openapi-generator.tech
"""


import pprint
import re  # noqa: F401

import six

from submarine.client.configuration import Configuration


class ExperimentTemplateSpec(object):
    """NOTE: This class is auto generated by OpenAPI Generator.
    Ref: https://openapi-generator.tech

    Do not edit the class manually.
    """

    """
    Attributes:
      openapi_types (dict): The key is attribute name
                            and the value is attribute type.
      attribute_map (dict): The key is attribute name
                            and the value is json key in definition.
    """
    openapi_types = {
        'author': 'str',
        'description': 'str',
        'experiment_spec': 'ExperimentSpec',
        'experiment_template_param_spec': 'list[ExperimentTemplateParamSpec]',
        'name': 'str',
        'parameters': 'list[ExperimentTemplateParamSpec]',
    }

    attribute_map = {
        'author': 'author',
        'description': 'description',
        'experiment_spec': 'experimentSpec',
        'experiment_template_param_spec': 'experimentTemplateParamSpec',
        'name': 'name',
        'parameters': 'parameters',
    }

    def __init__(
        self,
        author=None,
        description=None,
        experiment_spec=None,
        experiment_template_param_spec=None,
        name=None,
        parameters=None,
        local_vars_configuration=None,
    ):  # noqa: E501
        """ExperimentTemplateSpec - a model defined in OpenAPI"""  # noqa: E501
        if local_vars_configuration is None:
            local_vars_configuration = Configuration()
        self.local_vars_configuration = local_vars_configuration

        self._author = None
        self._description = None
        self._experiment_spec = None
        self._experiment_template_param_spec = None
        self._name = None
        self._parameters = None
        self.discriminator = None

        if author is not None:
            self.author = author
        if description is not None:
            self.description = description
        if experiment_spec is not None:
            self.experiment_spec = experiment_spec
        if experiment_template_param_spec is not None:
            self.experiment_template_param_spec = experiment_template_param_spec
        if name is not None:
            self.name = name
        if parameters is not None:
            self.parameters = parameters

    @property
    def author(self):
        """Gets the author of this ExperimentTemplateSpec.  # noqa: E501


        :return: The author of this ExperimentTemplateSpec.  # noqa: E501
        :rtype: str
        """
        return self._author

    @author.setter
    def author(self, author):
        """Sets the author of this ExperimentTemplateSpec.


        :param author: The author of this ExperimentTemplateSpec.  # noqa: E501
        :type: str
        """

        self._author = author

    @property
    def description(self):
        """Gets the description of this ExperimentTemplateSpec.  # noqa: E501


        :return: The description of this ExperimentTemplateSpec.  # noqa: E501
        :rtype: str
        """
        return self._description

    @description.setter
    def description(self, description):
        """Sets the description of this ExperimentTemplateSpec.


        :param description: The description of this ExperimentTemplateSpec.  # noqa: E501
        :type: str
        """

        self._description = description

    @property
    def experiment_spec(self):
        """Gets the experiment_spec of this ExperimentTemplateSpec.  # noqa: E501


        :return: The experiment_spec of this ExperimentTemplateSpec.  # noqa: E501
        :rtype: ExperimentSpec
        """
        return self._experiment_spec

    @experiment_spec.setter
    def experiment_spec(self, experiment_spec):
        """Sets the experiment_spec of this ExperimentTemplateSpec.


        :param experiment_spec: The experiment_spec of this ExperimentTemplateSpec.  # noqa: E501
        :type: ExperimentSpec
        """

        self._experiment_spec = experiment_spec

    @property
    def experiment_template_param_spec(self):
        """Gets the experiment_template_param_spec of this ExperimentTemplateSpec.  # noqa: E501


        :return: The experiment_template_param_spec of this ExperimentTemplateSpec.  # noqa: E501
        :rtype: list[ExperimentTemplateParamSpec]
        """
        return self._experiment_template_param_spec

    @experiment_template_param_spec.setter
    def experiment_template_param_spec(self, experiment_template_param_spec):
        """Sets the experiment_template_param_spec of this ExperimentTemplateSpec.


        :param experiment_template_param_spec: The experiment_template_param_spec of this ExperimentTemplateSpec.  # noqa: E501
        :type: list[ExperimentTemplateParamSpec]
        """

        self._experiment_template_param_spec = experiment_template_param_spec

    @property
    def name(self):
        """Gets the name of this ExperimentTemplateSpec.  # noqa: E501


        :return: The name of this ExperimentTemplateSpec.  # noqa: E501
        :rtype: str
        """
        return self._name

    @name.setter
    def name(self, name):
        """Sets the name of this ExperimentTemplateSpec.


        :param name: The name of this ExperimentTemplateSpec.  # noqa: E501
        :type: str
        """

        self._name = name

    @property
    def parameters(self):
        """Gets the parameters of this ExperimentTemplateSpec.  # noqa: E501


        :return: The parameters of this ExperimentTemplateSpec.  # noqa: E501
        :rtype: list[ExperimentTemplateParamSpec]
        """
        return self._parameters

    @parameters.setter
    def parameters(self, parameters):
        """Sets the parameters of this ExperimentTemplateSpec.


        :param parameters: The parameters of this ExperimentTemplateSpec.  # noqa: E501
        :type: list[ExperimentTemplateParamSpec]
        """

        self._parameters = parameters

    def to_dict(self):
        """Returns the model properties as a dict"""
        result = {}

        for attr, _ in six.iteritems(self.openapi_types):
            value = getattr(self, attr)
            if isinstance(value, list):
                result[attr] = list(map(lambda x: x.to_dict() if hasattr(x, "to_dict") else x, value))
            elif hasattr(value, "to_dict"):
                result[attr] = value.to_dict()
            elif isinstance(value, dict):
                result[attr] = dict(
                    map(
                        lambda item: (item[0], item[1].to_dict()) if hasattr(item[1], "to_dict") else item,
                        value.items(),
                    )
                )
            else:
                result[attr] = value

        return result

    def to_str(self):
        """Returns the string representation of the model"""
        return pprint.pformat(self.to_dict())

    def __repr__(self):
        """For `print` and `pprint`"""
        return self.to_str()

    def __eq__(self, other):
        """Returns true if both objects are equal"""
        if not isinstance(other, ExperimentTemplateSpec):
            return False

        return self.to_dict() == other.to_dict()

    def __ne__(self, other):
        """Returns true if both objects are not equal"""
        if not isinstance(other, ExperimentTemplateSpec):
            return True

        return self.to_dict() != other.to_dict()
