/*
 * Licensed to the Apache Software Foundation (ASF) under one or more
 * contributor license agreements.  See the NOTICE file distributed with
 * this work for additional information regarding copyright ownership.
 * The ASF licenses this file to You under the Apache License, Version 2.0
 * (the "License"); you may not use this file except in compliance with
 * the License.  You may obtain a copy of the License at
 *
 *    http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

// Code generated by client-gen. DO NOT EDIT.

package v1alpha1

import (
	"context"
	"time"

	v1alpha1 "github.com/apache/submarine/submarine-cloud-v2/pkg/apis/submarine/v1alpha1"
	scheme "github.com/apache/submarine/submarine-cloud-v2/pkg/client/clientset/versioned/scheme"
	v1 "k8s.io/apimachinery/pkg/apis/meta/v1"
	types "k8s.io/apimachinery/pkg/types"
	watch "k8s.io/apimachinery/pkg/watch"
	rest "k8s.io/client-go/rest"
)

// SubmarinesGetter has a method to return a SubmarineInterface.
// A group's client should implement this interface.
type SubmarinesGetter interface {
	Submarines(namespace string) SubmarineInterface
}

// SubmarineInterface has methods to work with Submarine resources.
type SubmarineInterface interface {
	Create(ctx context.Context, submarine *v1alpha1.Submarine, opts v1.CreateOptions) (*v1alpha1.Submarine, error)
	Update(ctx context.Context, submarine *v1alpha1.Submarine, opts v1.UpdateOptions) (*v1alpha1.Submarine, error)
	UpdateStatus(ctx context.Context, submarine *v1alpha1.Submarine, opts v1.UpdateOptions) (*v1alpha1.Submarine, error)
	Delete(ctx context.Context, name string, opts v1.DeleteOptions) error
	DeleteCollection(ctx context.Context, opts v1.DeleteOptions, listOpts v1.ListOptions) error
	Get(ctx context.Context, name string, opts v1.GetOptions) (*v1alpha1.Submarine, error)
	List(ctx context.Context, opts v1.ListOptions) (*v1alpha1.SubmarineList, error)
	Watch(ctx context.Context, opts v1.ListOptions) (watch.Interface, error)
	Patch(ctx context.Context, name string, pt types.PatchType, data []byte, opts v1.PatchOptions, subresources ...string) (result *v1alpha1.Submarine, err error)
	SubmarineExpansion
}

// submarines implements SubmarineInterface
type submarines struct {
	client rest.Interface
	ns     string
}

// newSubmarines returns a Submarines
func newSubmarines(c *SubmarineV1alpha1Client, namespace string) *submarines {
	return &submarines{
		client: c.RESTClient(),
		ns:     namespace,
	}
}

// Get takes name of the submarine, and returns the corresponding submarine object, and an error if there is any.
func (c *submarines) Get(ctx context.Context, name string, options v1.GetOptions) (result *v1alpha1.Submarine, err error) {
	result = &v1alpha1.Submarine{}
	err = c.client.Get().
		Namespace(c.ns).
		Resource("submarines").
		Name(name).
		VersionedParams(&options, scheme.ParameterCodec).
		Do(ctx).
		Into(result)
	return
}

// List takes label and field selectors, and returns the list of Submarines that match those selectors.
func (c *submarines) List(ctx context.Context, opts v1.ListOptions) (result *v1alpha1.SubmarineList, err error) {
	var timeout time.Duration
	if opts.TimeoutSeconds != nil {
		timeout = time.Duration(*opts.TimeoutSeconds) * time.Second
	}
	result = &v1alpha1.SubmarineList{}
	err = c.client.Get().
		Namespace(c.ns).
		Resource("submarines").
		VersionedParams(&opts, scheme.ParameterCodec).
		Timeout(timeout).
		Do(ctx).
		Into(result)
	return
}

// Watch returns a watch.Interface that watches the requested submarines.
func (c *submarines) Watch(ctx context.Context, opts v1.ListOptions) (watch.Interface, error) {
	var timeout time.Duration
	if opts.TimeoutSeconds != nil {
		timeout = time.Duration(*opts.TimeoutSeconds) * time.Second
	}
	opts.Watch = true
	return c.client.Get().
		Namespace(c.ns).
		Resource("submarines").
		VersionedParams(&opts, scheme.ParameterCodec).
		Timeout(timeout).
		Watch(ctx)
}

// Create takes the representation of a submarine and creates it.  Returns the server's representation of the submarine, and an error, if there is any.
func (c *submarines) Create(ctx context.Context, submarine *v1alpha1.Submarine, opts v1.CreateOptions) (result *v1alpha1.Submarine, err error) {
	result = &v1alpha1.Submarine{}
	err = c.client.Post().
		Namespace(c.ns).
		Resource("submarines").
		VersionedParams(&opts, scheme.ParameterCodec).
		Body(submarine).
		Do(ctx).
		Into(result)
	return
}

// Update takes the representation of a submarine and updates it. Returns the server's representation of the submarine, and an error, if there is any.
func (c *submarines) Update(ctx context.Context, submarine *v1alpha1.Submarine, opts v1.UpdateOptions) (result *v1alpha1.Submarine, err error) {
	result = &v1alpha1.Submarine{}
	err = c.client.Put().
		Namespace(c.ns).
		Resource("submarines").
		Name(submarine.Name).
		VersionedParams(&opts, scheme.ParameterCodec).
		Body(submarine).
		Do(ctx).
		Into(result)
	return
}

// UpdateStatus was generated because the type contains a Status member.
// Add a +genclient:noStatus comment above the type to avoid generating UpdateStatus().
func (c *submarines) UpdateStatus(ctx context.Context, submarine *v1alpha1.Submarine, opts v1.UpdateOptions) (result *v1alpha1.Submarine, err error) {
	result = &v1alpha1.Submarine{}
	err = c.client.Put().
		Namespace(c.ns).
		Resource("submarines").
		Name(submarine.Name).
		SubResource("status").
		VersionedParams(&opts, scheme.ParameterCodec).
		Body(submarine).
		Do(ctx).
		Into(result)
	return
}

// Delete takes name of the submarine and deletes it. Returns an error if one occurs.
func (c *submarines) Delete(ctx context.Context, name string, opts v1.DeleteOptions) error {
	return c.client.Delete().
		Namespace(c.ns).
		Resource("submarines").
		Name(name).
		Body(&opts).
		Do(ctx).
		Error()
}

// DeleteCollection deletes a collection of objects.
func (c *submarines) DeleteCollection(ctx context.Context, opts v1.DeleteOptions, listOpts v1.ListOptions) error {
	var timeout time.Duration
	if listOpts.TimeoutSeconds != nil {
		timeout = time.Duration(*listOpts.TimeoutSeconds) * time.Second
	}
	return c.client.Delete().
		Namespace(c.ns).
		Resource("submarines").
		VersionedParams(&listOpts, scheme.ParameterCodec).
		Timeout(timeout).
		Body(&opts).
		Do(ctx).
		Error()
}

// Patch applies the patch and returns the patched submarine.
func (c *submarines) Patch(ctx context.Context, name string, pt types.PatchType, data []byte, opts v1.PatchOptions, subresources ...string) (result *v1alpha1.Submarine, err error) {
	result = &v1alpha1.Submarine{}
	err = c.client.Patch(pt).
		Namespace(c.ns).
		Resource("submarines").
		Name(name).
		SubResource(subresources...).
		VersionedParams(&opts, scheme.ParameterCodec).
		Body(data).
		Do(ctx).
		Into(result)
	return
}
