---
title: Local Model
keywords: ["Local Model"]
description: Local Model
---

## Description

* Standalone environment, then use the local `API` to update the apache shenyu gateway data。

* Common result:

```
success
```

* Common preFix: `localhost:9095/shenyu`

* Common Header: `localKey: 123456`

## Plugin

### saveOrUpdate

save or update plugin data

##### Request Method

POST

##### Path

/plugin/saveOrUpdate

##### Request Parameters

|Name|Type|Required|Default|Description|
|---|---|---|---|---|
|**PluginData**|[PluginData](#PluginData)|True| |Plugin data object (pass Json object inside Body)|

##### <div id="PluginData">PluginData</div>

|Name|Type|Required|Default|Description|
|---|---|---|---|---|
|**id**|String|False| |plugin id|
|**name**|String|True| |plugin name|
|**config**|String|False| |plugin configuration (Json format)|
|**role**|String|False| |plugin role |
|**enabled**|Boolean|False| |whether to turn on|

##### Example

POST body

```
{"id":3,"name":"divide","enabled":"true"}

```

### CleanAll

Clear all data (plugins, selectors, rules)

##### Request Method

GET

##### Path

/cleanAll

### Clean Plugin

Clear plugin data（selector, rule）

##### Request Method

GET

##### Path

/cleanPlugin?name = xxxx

##### RequestParam

|Name|Type|Required|Default|Description|
|---|---|---|---|---|
|**name**|String|true| |plugin name |

### Delete plugin

Remove plugin data (not included, the selectors and rules data)

##### Request Method

GET

##### Path

/plugin/delete?name = xxxx

##### RequestParam

|Name|Type|Required|Default|Description|
|---|---|---|---|---|
|**name**|String|true| |plugin name |

### Delete All Plugin

Remove all plugin data (not included, the selectors and rules data)

##### Request Method

GET

##### Path

/plugin/deleteAll

### Find plugin by name

Find plugin by name

##### Request Method

GET

##### Path

/plugin/findByName?name=xxxx

##### RequestParam

|Name|Type|Required|Default|Description|
|---|---|---|---|---|
|**name**|String|true| |plugin name |

### Save or Update Selector

Save or Update Selector

##### Request Method

POST

##### Path

/plugin/selector/saveOrUpdate

##### RequestParam

|Name|Type|Required|Default|Description|
|---|---|---|---|---|
|**SelectorData**|[SelectorData](#SelectorData)|True| |Selector object (pass Json object inside Body)|

##### <div id="SelectorData">SelectorData</div>

|Name|Type|Required|Default|Description|
|---|---|---|---|---|
|**id**|String|False| |selector id|
|**pluginName**|String|True| |plugin name|
|**name**|String|False| |Selector name (default is plugin:selector+random number if not filled)|
|**matchMode**|Integer|False| |Matching mode (0:and;1:or), not filled with the default generation And mode|
|**type**|Integer|False| |Traffic type（0: full traffic; 1: custom traffic) do not fill in the default generation of full traffic|
|**sort**|Integer|False| |Sort by, not filled by default generate 10|
|**enabled**|Boolean|False| |Whether to turn on, not fill in the default generation true|
|**logged**|Boolean|False| |Whether or not to print the log, do not fill in the default generated into false|
|**handle**|String|False| |Selector handler (Json objects, depending on each plug-in, different objects are passed)|
|**conditionList**|[Condition](#Condition)|False| |Conditional collection, custom traffic needs to be passed, full traffic does not need to be passed (Json List object)|

##### <div id="Condition">Condition</div>

|Name|Type|Required|Default|Description|
|---|---|---|---|---|
|**paramType**|String|True| |param type（post，uri，query，host，header，cookie，req_method，domain）|
|**operator**|String|True| |operator （match，=，regex，>，<，contains，SpEL，Groovy，TimeBefore，TimeAfter）|
|**paramName**|String|False| |param mame（The uri parameter type can be passed without）|
|**paramValue**|Integer|False| |param value|


##### Example

POST body

```
{
	"pluginName": "divide",
	"type": 1,
	"handle": "[{\"upstreamUrl\":\"127.0.0.1:8089\"}]",
	"conditionDataList": [{
		"paramType": "uri",
		"operator": "match",
		"paramName": null,
		"paramValue": "/**"
	}]
}

```

##### Result

Is selector id

```
xxxxx
```

### Add Selector And Rules

Add a selector with multiple rules

##### Request Method

POST

##### Path

/plugin/selectorAndRules

##### RequestParam

|Name|Type|Required|Default|Description|
|---|---|---|---|---|
|**SelectorRulesData**|[SelectorRulesData](#SelectorRulesData)|True| |Selector rule object (Body inside pass Json object)|

##### <div id="SelectorRulesData">SelectorRulesData</div>

|Name|Type|Required|Default|Description|
|---|---|---|---|---|
|**pluginName**|String|True| |plugin name|
|**selectorName**|String|False| |Selector name (if not filled in, it is generated by default plugin:selector+random number)|
|**matchMode**|Integer|False| |Matching mode (0:and;1:or), not filled with the default generation And mode|
|**selectorHandler**|String|False| |Selector handler (Json objects, depending on each plug-in, different objects are passed)|
|**conditionList**|[ConditionData](#ConditionData)|True| |Selector condition collection (Json List object)|
|**ruleDataList**|[RuleLocalData](#RuleLocalData)|True| |Rule condition collection (Json List object)|

##### <div id="RuleLocalData">RuleLocalData</div>

|Name|Type|Required|Default|Description|
|---|---|---|---|---|
|**ruleName**|String|False| |rule name|
|**ruleHandler**|String|True| |Rule handler (different plugins pass different values)）|
|**matchMode**|Integer|False| |Matching pattern (0:and;1:or)|
|**conditionList**|[ConditionData](#ConditionData)|True| |Rule condition collection (Json List object)|

##### <div id="ConditionData">ConditionData</div>

|Name|Type|Required|Default|Description|
|---|---|---|---|---|
|**paramType**|String|True| |param type（post，uri，query，host，header，cookie，req_method，domain）|
|**operator**|String|True| |operator （match，=，regex，>，<，contains，SpEL，Groovy，TimeBefore，TimeAfter）|
|**paramName**|String|False| |param mame（The uri parameter type can be passed without）|
|**paramValue**|Integer|False| |param value|

##### Example

POST body

```
{
	"pluginName": "divide",
	"selectorHandler": "[{\"upstreamUrl\":\"127.0.0.1:8089\"}]",
	"conditionDataList": [{
		"paramType": "uri",
		"operator": "match",
		"paramValue": "/http/**"
	}],
	"ruleDataList": [{
		"ruleHandler": "{\"loadBalance\":\"random\"}",
		"conditionDataList": [{
			"paramType": "uri",
			"operator": "=",
			"paramValue": "/http/test/payment"
		}]
	}, {
		"ruleHandler": "{\"loadBalance\":\"random\"}",
		"conditionDataList": [{
			"paramType": "uri",
			"operator": "=",
			"paramValue": "/http/order/save"
		}]
	}]
}

```

### Delete Selector

Delete selectors based on selector id and plugin name

##### Request Method

GET

##### Path

/plugin/selector/delete?pluginName=xxxx&&id=xxxx

##### RequestParam

|Name|Type|Required|Default|Description|
|---|---|---|---|---|
|**pluginName**|String|true| |plugin name |
|**id**|String|true| |selector id |

### Find All Selector

Get all selectors by plugin name

##### Request Method

GET

##### Path

/plugin/selector/findList?pluginName=xxxx

##### RequestParam

|Name|Type|Required|Default|Description|
|---|---|---|---|---|
|**pluginName**|String|true| |plugin name |

### Save or Update Rule Data

Save or Update Rule Data

##### Request Method

POST

##### Path

/plugin/rule/saveOrUpdate

##### RequestParam

|Name|Type|Required|Default|Description|
|---|---|---|---|---|
|**RuleData**|[RuleData](#RuleData)|True| |Rule object (pass Json object inside Body)|

##### <div id="RuleData">RuleData</div>

|Name|Type|Required|Default|Description|
|---|---|---|---|---|
|**id**|String|False| |rule id|
|**pluginName**|String|True| |plugin name|
|**name**|String|False| |Rule name (default generation if not filled plugin:rule+random number)|
|**selectorId**|String|True| |Selector id|
|**matchMode**|Integer|False| |Matching mode (0:and;1:or), not filled with the default generation And mode|
|**sort**|Integer|False| |Sort by , not filled by default generate 10|
|**enabled**|Boolean|False| |Whether to turn on, not fill in the default generation true|
|**logged**|Boolean|False| |Whether or not to print the log, do not fill in the default generated into false|
|**handle**|String|False| |Rule handler (Json objects, depending on each plug-in, different objects are passed)|
|**conditionList**|[ConditionData](#ConditionData)|False| |Conditional collections (Json List objects)|

##### <div id="conditionList">conditionList</div>

|Name|Type|Required|Default|Description|
|---|---|---|---|---|
|**paramType**|String|True| |param type（post，uri，query，host，header，cookie，req_method，domain）|
|**operator**|String|True| |operator （match，=，regex，>，<，contains，SpEL，Groovy，TimeBefore，TimeAfter）|
|**paramName**|String|False| |param mame（The uri parameter type can be passed without）|
|**paramValue**|Integer|False| |param value|

##### Example

POST body

```
{
	"pluginName": "divide",
	"selectorId": 123456,
	"handle": "{\"loadBalance\":\"random\"}",
	"conditionDataList": [{
		"paramType": "uri",
		"operator": "=",
		"paramValue": "/test"
	}]
}

```

##### Result

Is rule id

```
xxxxx
```

### Delete rule data

Delete rules based on selector id and rule id

##### Request Method

GET

##### Path

/plugin/rule/delete?selectorId=xxxx&&id=xxxx

##### RequestParam

|Name|Type|Required|Default|Description|
|---|---|---|---|---|
|**selectorId**|String|true| |selector ID |
|**id**|String|true| |rule ID |

### Find Rule data List

Get all rules by selector ID

##### Request Method

GET

##### Path

/plugin/rule/findList?selectorId=xxxx

##### RequestParam

|Name|Type|Required|Default|Description|
|---|---|---|---|---|
|**selectorId**|String|true| |selector id |

## Meta data

### Save Or Update

Save Or Update Meta data

##### Request Method

POST

##### Path

/meta/saveOrUpdate

##### RequestParam

|Name|Type|Required|Default|Description|
|---|---|---|---|---|
|**MetaData**|[MetaData](#MetaData)|True| |Metadata object (pass Json object inside Body)|

##### <div id="MetaData">MetaData</div>

|Name|Type|Required|Default|Description|
|---|---|---|---|---|
|**id**|String|False| |ID|
|**appName**|String|True| |app name|
|**contextPath**|String|True| |contextPath|
|**path**|String|True| |path|
|**rpcType**|String|True| |rpc type（dubbo，sofa，tars，springCloud，motan，grpc）|
|**serviceName**|String|True| |service name|
|**methodName**|String|True| |method name|
|**parameterTypes**|String|True| |parameter types|
|**rpcExt**|String|False| |rpc extension parameters (json objects)|
|**enabled**|Boolean|False| |Whether to turn on|

### Delete

Delete Meta data

##### Request Method

GET

##### Path

/meta/delete?rpcType=xxxx&&path=xxx

##### RequestParam

|Name|Type|Required|Default|Description|
|---|---|---|---|---|
|**rpcType**|String|true| |rpc type（dubbo，sofa，tars，springCloud，motan，grpc） |
|**path**|String|true| |path |

## App Sign Data

### Save Or Update

Save Or Update App Sign Data

##### Request Method

POST

##### Path

/auth/saveOrUpdate

##### RequestParam

|Name|Type|Required|Default|Description|
|---|---|---|---|---|
|**AppAuthData**|[AppAuthData](#AppAuthData)|True| |Signature object (Json object passed inside the Body)|

##### <div id="AppAuthData">AppAuthData</div>

|Name|Type|Required|Default|Description|
|---|---|---|---|---|
|**appKey**|String|True| |app key|
|**appSecret**|String|True| |app secret|
|**enabled**|Boolean|False| |Whether to turn on|
|**open**|Boolean|False| |is open|
|**paramDataList**|[AuthParamData](#AuthParamData)|false| |Parameter set, open is true when you need to pass (Json list object)|
|**AuthPathData**|[AuthPathData](#AuthPathData)|false| |Path collection, open is true when you need to pass (Json list object)|

##### <div id="AuthParamData">AuthParamData</div>

|Name|Type|Required|Default|Description|
|---|---|---|---|---|
|**appName**|String|True| |app name|
|**appParam**|String|True| |app param|

##### <div id="AuthPathData">AuthPathData</div>

|Name|Type|Required|Default|Description|
|---|---|---|---|---|
|**appName**|String|True| |app name|
|**path**|String|True| |path|
|**enabled**|Boolean|False| |Whether to turn on|

### Delete

Delete App Sign Data

##### Request Method

GET

##### Path

/auth/delete?appKey=xxxx

##### RequestParam

|Name|Type|Required|Default|Description|
|---|---|---|---|---|
|**appKey**|String|true| |app key |
