---
title: "Start small, become a Committer"
author: "achao"
description: "Start small, become a Committer"
categories: "Apache ShenYu Committers"
tags: ["Apache ShenYu"]
date: 2024-08-14
---

### Personal Introduction

- **Name**: Achao
- **GitHub**: [VampireAchao](https://github.com/VampireAchao)
- **Email**: [achao@apache.org](mailto:achao@apache.org)

### First Encounter with Apache ShenYu Gateway

When I first came into contact with Apache ShenYu, I was involved in development work with the Dromara community. At that time, Yu Xiao (the founder and VP of Apache ShenYu) initiated a frontend development request within the community. Since I was familiar with the React technology used by ShenYu, I decided to join the contributors. Although I was not a direct user of ShenYu, contributing my frontend skills to the community felt like a very natural choice.

### The Path of Open Source Contribution

During my contributions to the ShenYu project, I gradually clarified my direction and deepened my understanding of the project structure by reading the source code. In this process, I actively submitted code and performed fixes. Here are some of my contributions to the ShenYu project:

#### ShenYu

> [13 commits](https://github.com/apache/shenyu/commits?author=VampireAchao)  
> 6,084 ++    2,379 --

- **Feature Development**: Implemented client ID validation to invalidate old tokens on new login (#5600)
- **Feature Addition**: Added menu buttons and permissions for the alert module (#5156)
- **Testing Expansion**: Added unit test cases for PortUtils.findPort (#4604)
- **Default Configuration Improvement**: Set NettyClient as the default HttpClient (#5200)
- **Bug Fix**: Fixed routing mismatch issues due to context-path updates (#5510)
- **Time Format Correction**: Resolved LocalDateTime formatting issues in the alert module (#5180)

#### ShenYu Dashboard

> [27 commits](https://github.com/apache/shenyu-dashboard/commits?author=VampireAchao)  
> 1,780 ++    402 --

- **Feature Development**: Enabled token invalidation on new login to enhance security (#467)
- **New Feature**: Added namespace selection for common components (#462)
- **Security Enhancement**: Required verification code after multiple incorrect password attempts (#465)
- **UI Optimization**: Removed unnecessary admin info edit buttons to simplify the interface (#463)
- **Batch Operation Support**: Added batch enable/disable functionality for selectors and rules (#452)
- **User Experience Improvement**: Enhanced the JSON editor experience (#374)
- **Performance Optimization**: Improved React lifecycle management to boost Dashboard responsiveness (#369)
- **Module Improvement**: Key optimizations for the alert module (#346)
- **Integration Enhancement**: Integrated management interface and functions for the alert module (#333)
- **Parameter Management**: Automatically use default parameters from documentation when API request parameters are missing (#332)
- **Documentation Standardization**: Unified API documentation format and fixed multiple integration issues (#303)
- **Documentation Improvement**: Comprehensive optimization of API documentation (#301)
- **Navigation Feature**: Added system and resource search functionality in menu navigation (#279)
- **Routing Fix**: Corrected routing mismatch issues after context-path updates (#428)
- **Tag Management**: Resolved issues with tag deletion in the alert module (#377)
- **Deletion Confirmation**: Added confirmation step for API tag deletion to prevent accidental deletions (#375)
- **Page Error Fix**: Fixed proxy page errors caused by component mounting (#351)
- **Query Rendering Fix**: Resolved query rendering issues in HeadersEditor (#331)

### Community Participation and Growth

By participating in ShenYu's community meetings and contributing code, I not only improved my technical skills but also learned how to collaborate more effectively in open source projects. Working with community members gave me a deep appreciation for the openness and inclusiveness of the open source community.

### Advice for Open Source Developers

For developers looking to join open source projects, my advice is: start with small tasks and don't be afraid of the small things. As long as it contributes to the project, every contribution will be valued by the community. Continuously learn and keep trying, and you will eventually find the contribution path that suits you.

### Contributing to ShenYu Together

If you want to contribute to Apache ShenYu, you can start with the following:

- Read the [Contributor Guide](https://shenyu.apache.org/zh/community/contributor-guide)
- Participate in [GitHub Issues](https://github.com/apache/shenyu/issues) discussions to find suitable contribution opportunities

### Conclusion

Being nominated as a ShenYu Committer is a significant milestone for me. I will continue to contribute to ShenYu and look forward to more developers joining us to drive ShenYu's development forward.
