---
title: "[My Open Source Journey with Apache ShenYu]"
author: "Hongyu Liu"
description: "My Open Source Journey with Apache ShenYu"
categories: "Apache ShenYu Committers"
tags: ["Apache ShenYu"]
date: 2024-08-08
---

### Personal Introduction

Name: Liu Hongyu

GitHub: https://github.com/Aias00/

Email: liuhongyu@apache.org

### First Encounter with Apache ShenYu Gateway

I first came across the Apache ShenYu Gateway during a business transformation project at my company when we were evaluating gateway technologies. At that time, Apache ShenYu was still in the Apache Incubator. Compared to other similar products, Apache ShenYu offered a user-friendly control management interface, rich plugin features, and a perfect match with our technology stack. The active community was the icing on the cake, making Apache ShenYu our ultimate choice for the gateway solution. It has been widely used in various business scenarios since then.

### The Journey of Open Source Contributions

As I applied Apache ShenYu in my work, I gradually went from a simple user to a deep understanding of the system. In order to solve some potential problems and customize some business plugins, I started reading ShenYu's source code and learning its design ideas and implementation principles.

After Apache ShenYu graduated from the Incubator, I aspired to transition from a regular user to a contributor and make some contributions to the ShenYu community.

I started by reading the contributor guide, subscribing to the developer mailing list, and following the ShenYu GitHub repository to check issues and pull requests.

After reading a few issues, I found one about supplementing unit tests, so I decided to give it a try. I forked the ShenYu repository, cloned it locally, modified the unit test content, and submitted a pull request. This PR was merged quickly, marking my first contribution to the ShenYu community.

When I saw my code merged into the main branch, I was overwhelmed with excitement. This experience solidified my determination to "become a ShenYu Committer."

Subsequently, I started to delve deeper into the project by reading documents and source code, as well as participating in bi-weekly meetings. I started with simple issue tasks, continuously learning, and gradually took on more challenging tasks. My main contributions include:

- Added batch import and export functionality for configurations
- Upgraded the Sofa Rpc version
- Removed Alibaba Dubbo dependency
- Upgraded the Apache Dubbo version
- Upgraded from JDK8 to JDK17 in collaboration with community partners
- Fixed some issues encountered during GitHub pipeline execution
- Added Shenyu Admin cluster functionality
- Upgraded the SpringBoot version
- Developed the KubeSphere extension for Apache ShenYu

### Community Participation and Growth

Apache ShenYu contributors have a fixed online meeting every other Thursday evening. The meeting mainly discusses features in the Roadmap and some issues raised by the community. At the same time, we can also speak freely if we have any questions or ideas.

In these meetings, I met many partners who are passionate about open source. Through meeting discussions and task assignments, I continuously learn new knowledge and have the opportunity to contribute my strength to the community and the industry.

In this process, I not only improved my technical skills but also learned how to collaborate with others, how to communicate and cooperate better.

I would like to express my sincere gratitude to the partners who have helped me in the community. Thanks to their patient guidance and assistance, I was able to integrate into the community more quickly and better contribute to the community.

### Suggestions for Open Source Developers

Open source development is a meaningful but challenging endeavor that requires a significant investment of time and energy. It involves continuous learning and experimentation, but it also brings a lot of satisfaction and happiness.

Sometimes you may encounter various problems, but don't give up. Try more, think more, and you will find that the problem is not that difficult to solve.

At the same time, participate more in community activities and communicate more with community partners. You will find that the open source community is a place full of love and kindness, where everyone helps each other and makes progress together.

### How to Participate in ShenYu

If you also want to join the Apache ShenYu community, you can refer to the following methods:

1. Check the contributor guide provided on the Apache ShenYu official website: https://shenyu.apache.org/zh/community/contributor-guide

2. Follow ShenYu's GitHub Issues and participate in feature development and bug fixing: https://github.com/apache/shenyu/issues

### Conclusion

Becoming a Committer is a new starting point. I hope to keep my original intention and continue to contribute to the open source cause. I also hope that more friends can join the Apache ShenYu community and work together to contribute to the open source cause.
