---
title: "[Co-authoring the future with ShenYu]"
author: "kerwin612"
description: "Co-authoring the future with ShenYu"
categories: "Apache ShenYu Committers"
tags: ["Apache ShenYu"]
date: 2024-04-08
---

### Self Introduction:

Hello everyone, I'm Le Zhang, with the github-id: [kerwin612](https://github.com/kerwin612). I am extremely grateful to the Apache ShenYu community for recognizing my contributions and giving me the opportunity to become a Committer for this outstanding open-source project. Today, I would like to share my experience participating in the Apache ShenYu project, the growth I have achieved, and some suggestions.

### Getting to know Apache ShenYu

My journey with Apache ShenYu began during my exploration of gateway technology options for my company. Upon discovering the ShenYu project, I was immediately intrigued by its high performance, multi-protocol support, easy scalability, and the wealth of ready-to-use plugins it offered. As a result, I decided to delve deeper into it and successfully ran the dev version of ShenYu in my local environment.

### My way to Open source

As a full-stack engineer, I have a certain understanding of both front-end and back-end technologies, which enabled me to comprehensively understand and experience ShenYu. During my trial period, I identified numerous areas for optimization and decided to take action. I created a task list, tackled each issue one by one, and submitted my improvements to the community.

On the front-end side, my optimizations primarily included:

* Thoroughly reviewing the entire website's styling and fixing multiple style anomalies. Although these anomalies seemed minor, they directly impacted users' visual experience. By addressing these issues, I was able to enhance the cleanliness and aesthetics of ShenYu's front-end interface, thereby improving users' overall experience.

* Implementing multiple experience enhancements. These enhancements ranged from adjusting the position of a button to improving the interaction logic of an interface. By making these optimizations, I made ShenYu's front-end interface more intuitive and significantly enhanced users' convenience.

* Actively addressing over twenty front-end-related issues. These issues included both problems encountered by users during their usage and suggestions for improvement proposed by community members. I carefully analyzed the causes of each issue and successfully resolved them, contributing to the stability of ShenYu's front-end.

On the back-end side, my contributions mainly focused on:

* Handling over ten back-end-related issues. These issues encompassed bug fixes and feature enhancements. Through referencing documentation, debugging code, and ultimately seeking feedback from project managers, I resolved each issue.

* Implementing a new [`isBlank`](https://github.com/apache/shenyu/pull/4983) conditional judgment function. This function facilitates the determination of whether a request contains a specific parameter, providing convenience for back-end logical processing.

* Developing a new plugin, [`basic-auth`](https://github.com/apache/shenyu/pull/5258). This plugin enables basic authentication and authorization functionality. Through collaboration with other community members, I successfully completed the plugin's development and testing, integrating it into ShenYu.

# My experience in Apahce ShenYu Community

As I submitted more and more pull requests, I gradually delved deeper into the core of the Apache ShenYu community. Here, I felt the enthusiasm and openness of the community members. They were always willing to share knowledge and experience, helping me better understand and use ShenYu. After a period of hard work and accumulation, I received an invitation from the ShenYu community to officially become a Committer of this outstanding team.

Becoming an Apache Committer is not only an honor for me but also a responsibility and commitment. It represents the community's trust and recognition of me, and it also strengthened my determination to contribute to the community. I am well aware that becoming a Committer is merely a new starting point. In the days ahead, I will continue to participate in ShenYu's optimization and development work, constantly enhancing my skills and capabilities. I will keep up with community updates and demands, actively participate in community activities and discussions, and contribute even more to ShenYu's growth.

Moreover, I plan to further delve into the technical details and architectural principles of Apache ShenYu, enabling me to better provide technical support and solutions to the community. I believe that through continuous learning and practice, I can become a more accomplished Committer and make even greater contributions to Apache ShenYu's development.

Finally, I want to express my gratitude to the Apache ShenYu community for giving me this opportunity and trust, as well as to all community members for their support and assistance. I am confident that with our collective efforts, Apache ShenYu will continue to excel!

Thanks all!
