---
sidebar_position: 3
title: 选择器规则详解
keywords: ["soul"]
description: 选择器规则详解
---

## 说明

* 选择器和规则是soul网关中最灵魂的设计。掌握好它，你可以对任何流量进行管理。
* 本篇主要详解soul网关中，选择器与规则的概念，以及如何使用。


## 大体理解

* 一个插件有多个选择器，一个选择器对应多种规则。选择器相当于是对流量的一级筛选，规则就是最终的筛选。
* 我们想象一下，在一个插件里面，我们是不是希望根据我们的配置，达到满足条件的流量，我们插件才去执行它？
* 选择器和规则就是为了让流量在满足特定的条件下，才去执行我们想要的，这种规则我们首先要明白。
* 数据结构可以参考之前的 [数据库设计](../design/database-design.md)

## 选择器 

![](https://yu199195.github.io/images/soul/selector.png)

* 选择器详解：
 
  * 名称：为你的选择器起一个容易分辨的名字
  * 类型：custom flow 是自定义流量。full flow 是全流量。自定义流量就是请求会走你下面的匹配方式与条件。全流量则不走。
  * 匹配方式：and 或者or 是指下面多个条件是按照and 还是or的方式来组合。
  * 条件：
    * uri：是指你根据uri的方式来筛选流量，match的方式支持模糊匹配（/**）
    * header：是指根据请求头里面的字段来筛选流量。
    * query：是指根据uri的查询条件来进行筛选流量。
    * ip：是指根据你请求的真实ip，来筛选流量。
    * host：是指根据你请求的真实host，来筛选流量。
    * post：建议不要使用。
    * 条件匹配：
      * match：模糊匹配，建议和uri条件搭配，支持 restful风格的匹配。（/test/**）
      * =：前后值相等，才能匹配。
      * regEx：正则匹配，表示前面一个值去匹配后面的正则表达式。
      * like：字符串模糊匹配。         
  * 是否开启：打开才会生效
  * 打印日志：打开的时候，当匹配上的时候，会打印匹配日志。
  * 执行顺序：当多个选择器的时候，执行顺序小的优先执行。
  
* 上述图片中表示:当请求的`uri`前缀是 `/test`，并且`header` 头上 `module` 字段值为`test` 的时候，会转发到 `1.1.1.1:8080` 这个服务。    

* 选择器建议：可以`uri` 条件， `match` 前缀 （/contextPath），进行第一道流量筛选。
 
## 规则

 ![](https://yu199195.github.io/images/soul/rule.png)
 
* 当流量经过选择器匹配成功之后，会进入规则来进行最终的流量匹配。
 
* 规则是对流量最终执行逻辑的确认。
 
* 规则详解：
  * 名称：为你的规则起一个容易分辨的名字
  * 匹配方式：and 或者or 是指下面多个条件是按照and 还是or。
  * 条件：
    * uri：是指你根据uri的方式来筛选流量，match的方式支持模糊匹配（/**）
    * header：是指根据请求头里面的字段来筛选流量。
    * query：是指根据uri的查询条件来进行筛选流量。
    * ip：是指根据你请求的真实ip，来筛选流量。
    * host：是指根据你请求的真实host，来筛选流量。
    * post：建议不要使用。
    * 条件匹配:
      * match : 模糊匹配，建议和uri条件搭配，支持 restful风格的匹配。（/test/**）
      * = : 前后值相等，才能匹配。
      * regEx : 正则匹配，表示前面一个值去匹配后面的正则表达式。
      * like ：字符串模糊匹配。 
  * 是否开启：打开才会生效。
  * 打印日志：打开的时候，当匹配上的时候，会打印匹配日志。
  * 执行顺序：当多个规则的时候，执行顺序小的优先执行。 
  * 处理：每个插件的规则处理不一样，具体的差有具体的处理，具体请查看每个对应插件的处理。

* 上图表示：当 `uri` 等于  `/http/order/save` 的时候该规则被匹配，就会执行该规则中，负载策略是 `random`。

* 联合选择器，我们来表述一下：当一个 请求的 `uri` 为 `/http/order/save`，会通过 `random` 的方式，转发到 `1.1.1.1:8080`。

* 规则建议：可以`uri` 条件， `match` 最真实的`uri路径`，进行流量的最终筛选 。
    
    
## 条件详解

* uri 匹配 （推荐）

  * uri匹配是根据你请求路径中的uri来进行匹配，在接入网关的时候，前端几乎不用做任何更改。
  
  * 当使用 `match` 方式匹配时候，同 `springmvc` 模糊匹配原理相同。
  
  * 在选择器中，推荐使用uri中的前缀来进行匹配，而在规则中，则使用具体路径来进行匹配。
  
  * 该匹配方式的时候，在匹配字段名称可以任意填写，匹配字段值需要正确填写。
  
* header 匹配

  * header是根据你的`http` 请求头中的字段值来匹配。
  
* query 匹配

  * 这个是根据你的uri中的查询参数来进行匹配，比如 /test?a=1&&b=2 ，那么可以选择该匹配方式。
   
  * 上述就可以新增一个条件，选取 query方式  , a   =  1  。
   
* ip匹配

  * 这个是根据 http调用方的 ip来进行匹配。
  
  * 尤其是在waf插件里面，如果发现一个ip地址有攻击，可以新增一条匹配条件，填上该ip，拒绝该ip的访问。
  
  * 如果在soul前面使用了nginx代理，为了获取正确的ip，你可能要参考 [parsing-ip-and-host](../developer-guide/custom-parsing-ip-and-host)
 
* host匹配

  * 这个是根据 http调用方的host来进行匹配。
    
  * 尤其是在waf插件里面，如果发现一个host地址有攻击，可以新增一条匹配条件，填上该host，拒绝该host的访问。
    
  * 如果在soul前面使用了nginx代理，为了获取正确的host，你可能要参考 [parsing-ip-and-host](../developer-guide/custom-parsing-ip-and-host)
    
* post匹配

  * 不推荐使用。

