---
title: 2.6.1
sidebar_position: 3
keywords: ["release-notes"]
description: release-notes
---

## 2.6.1

### New Features

1. 添加Dubbo添加Ingress controller支持

2. 支持插件生命周期

3. 添加shenyu-sdk-openfeign模块

4. 添加Motan和Spring Cloud添加Ingress controller支持

5. shenyu支持告警功能

6. shenyu client添加discovery的注册中心

7. 添加shenyu context-path Ingress controller

8. 添加shenyu grpc Ingress controller

9. 添加shenyu sofa Ingress controller

10. 添加nacos, etcd, eureka作为shenyu discovery服务注册中心

11. 添加新的插件：basic-plugin

12. 添加新插件：shenyu-rabbitmq-logging plugin

13. 通过shenyu-discovery绑定selector

### API Changes

1. 重构shenyu数据同步的数据结构

   ```
   plugin.list ["plugin.sign", "plugin.dubbo", "plugin.pluginName"]
   -> plugin.sign
   -> plugin.dubbo
   -> plugin.pluginName
   
   examples data:
   selector.key1.list ["selector.key1.value1", "selector.key1.value2", "selector.key1.value3"]
   -> selector.key1.value1
   -> selector.key1.value2
   -> selector.key1.value3
   
   selector.key2.list ["selector.key2.value1", "selector.key2.value2", "selector.key2.value3"]
   -> selector.key2.value4
   -> selector.key2.value5
   -> selector.key2.value6
   ```

2. 使用netty作为默认的httpclient

3. 重构shenyu-admin-listener来支持shenyu admin数据同步

4. 删除shenyu对brpc的支持，包括brpc插件，brpc示例，brpc集成测试

5. 移除Apollo的依赖以便支持Java 17(自行添加依赖)

6. 删除shenyu的中间件register center

### Enhancement

1. 为shenyu model event添加测试用例
2. 添加shenyu selector测试用例
3. 添加motan的端到端测试用例
4. 支持motan插件选择协议
5. 添加Grpc的端到端测试用例
6. 升级apache-rat-plugin版本到0.15
7. 在匹配时地址isBlank条件匹配
8. Clickhouse支持ttl字段
9. 支持HttpUtils的日志级别判断
10. 为Ingress Reconciler添加单元测试
11. 当软件包分发时自动checksum
12. 在tcp插件中实现零拷贝
13. shenyu-client-springmvc支持默认的appname和context-path
14. 添加sdk-feign的示例和集成测试
15. es log插件支持用户自定义的索引
16. 增强grpc插件支持shenyu-loadbalancer负载均衡算法
17. 支持http2协议的下游服务
18. 重构增强dubbo插件支持shenyu-loadbalancer负载均衡算法
19. 添加ingress controller的springcloud集成测试
20. 添加WebSocket插件代理ping的功能
21. 添加ingress controller的websocket集成测试
22. Rewrite插件支持百分比重写
23. Admin使用discovery config初始化discovery server
24. Divide插件适配shenyu discovery
25. Alert支持多个admin的集群
26. WebSocket插件适配shenyu discovery
27. 注册服务实例到shenyu discovery
28. ShenYu Admin适配shenyu-discovery的local模式
29. 添加shenyu sdk core的测试用例
30. 添加shenyu-discovery的测试用例
31. 添加opengauss的e2e测试
32. 添加上传插件包大小的限制
33. 添加shenyu-client-websocket的测试用例
34. 34 升级shiro到安全版本(1.18.0)
35. 升级SpringBoot版本到2.7.17，更新license
36. 添加网关异常时发送通知到shenyu-alert
37. 添加EurekaDiscoveryService单元测试

### Refactor

1. 重构整理2.6.1版本(pom.xml)
2. 使用computeIfAbsent重构Map的操作
3. 重构polaris测试用例
4. 迁移Maven Wrapper到官方镜像
5. 在WebClientMessageWriter中编译过的Pattern
6. 重构HttpUtils的请求方法
7. 升级github action版本
8. 重构数据同步的抽象模板方法
9. 重构MenuProject, MenuModule, MenuDocItem为VO对象
10. 统一dubbo版本
11. 重构HttpClient的目录
12. 重构github action ci缓存
13. 重构motan插件支持pojo对象作为方法参数
14. 升级kafka-client版本到3.4.0
15. 迁移admin swagger springfox到springdoc
16. 升级dubbo版本到3.2.5并重构过期方法
17. 重构AbstractShenyuSdkClient getOrDefault方法
18. 重构HttpClient的参数
19. 重构webclient插件的实现
20. 升级guava版本到32.0.0-jre
21. 支持k8s作为e2e的测试环境
22. 使用@Restapi作为rest api的请求路径映射
23. 使用StringBuilder作为字符串连接器
24. 设置netty allocator参数为unpooled
25. 重构启动的banner
26. 删除重复的代码并且将部分代码作为公用
27. 重构null的判断方法
28. 重构日志插件的选择器处理器
29. 重构自定义插件类加载器
30. 重构日志插件支持插件级别的采样比率
31. 重构Context-path避免重复注册(使用selector for update)

### Bug Fix

1. 避免创建TimeoutException的永久开销
2. 修复示例模块的主类路径
3. 修复插件排序问题
4. 修复Makefile Snapshot版本问题
5. 修复RELEASE-NOTES.md的拼写错误
6. 修复示例中的错误包名
7. 修复密码验证规则，并且添加#和.的支持
8. 修复e2e中zookeeper:3.8.0的健康检查
9. 修复不稳定的ci检验
10. 添加e2e WaitForHelper异常日志
11. 修复springcloud在某些注册中心中间件不能获取scheme
12. 修复javadoc编译错误
13. 修复HttpUtils中错误的请求类型
14. 修复更新auth时未更新用户id
15. 修复TCP插件的eventloop线程泄漏
16. 格式化shenyu-integrated-test中的quickstart
17. 修复SQL脚本错误
18. 修复uri插件path错误，并且使用rawpath替代path
19. 修复websocket插件对rewrite插件的支持
20. 修复ElasticSearchLog Plugin索引名称无效
21. 修复context-path插件的错误
22. 修复shenyu-admin的cpu占用过高问题
23. 修复alert中LocalDateTime的格式化问题
24. 修复shenyu-client的apiDoc的错误重试问题
25. 修复applicationContextAware初始化顺序过晚
26. 修复重复的response header
27. 设置k8s的最大等待时间
28. 修改clickhouse日志插件的status字段类型
29. 修复response write plugin可能造成的内存泄漏
30. 修复dataType字段选择错误
31. 修复http数据同步错误
32. 修复单词拼写错误
33. 修复shenyu dubbo代理插件的注册状态
34. 修复buildDiscoveryUpstreamPath造成多个`/`
35. 修复shenyu-registry的eureka注册错误逻辑
36. 修复AbstractLogPluginDataHandler hashcode错误
37. 修复ratelimit插件在集群模式下的key错误
38. 修复同一个应用多个shenyu-client重复注册context-path的错误
39. 修复在插件关闭后不会重新加载插件
40. 修复shenyu admin上传插件的错误
41. 修复shenyu不能加载resource目录下的资源
42. 修复Admin来展示字典值
43. 修复Authorization在sign插件中的冲突
44. 修复签名插件的context-path路径匹配错误
