---
title: How to use Apache email
sidebar_position: 6
description: apache email usage tutorial
categories: "Apache ShenYu"
tags: ["use-apache-email"]
---

## Apache email usage based on gmail

> When you become a committer, you will have an apache email. This tutorial uses apache email based on `gmail`.

#### 1. Login to Gmail

* [Gmail official website](https://gmail.google.com) is here

#### 2. Set up your Apache email

#### 3. Click on settings

![](/img/email/gmail-setting.png)

#### 4. Find your Apache email

You should have an email from `root@apache.org` like this in your mailbox:
* Titled `Welcome to the Apache Software Foundation`
* The content is as follows
  
    ```text
    Dear YYYY,

    Good news! We have created your Apache Software Foundation (ASF) committer account, and it is now ready for you.

    Your ApacheID is: xxxx
  
    ......
    ```
  
* Apparently your Apache email is `xxxx@apache.org`

#### 5. Add Apache email

![](/img/email/add-apache-email.png)

## Apache email usage based on 163/126-email

> When you become a committer, you will have an apache email. This tutorial uses apache email based on `126-email`.

#### 1. Login to 163/126-email

* [163 email website](https://mail.163.com) is here
* [126 email website](https://mail.126.com/) is here

#### 2. Set your Apache email forward address

![](/img/email/apache-email-forward.png)

after set this step, you can receive your apache email

#### 3. Settings for 126 email

![](/img/email/126email-settings.png)

1. choose settings
2. add email sender
3. write your apache email information and next step

![](/img/email/126email-settings-2.png)

4. choose next step

![](/img/email/126-default-sender.png)

5. set apache email as default sender

#### 4. Send email

![](/img/email/126-send-email.png)

you can choose your email sender
