---
title: "HugeGraph Gremlin"
linkTitle: "Gremlin Query Language"
weight: 1
---

### Overview

HugeGraph supports [Gremlin](https://tinkerpop.apache.org/gremlin.html), a graph traversal query language of [Apache TinkerPop3](https://tinkerpop.apache.org). While SQL is a query language for relational databases, Gremlin is a general-purpose query language for graph databases. Gremlin can be used to create entities (Vertex and Edge) of a graph, modify the properties of entities, delete entities, as well as perform graph queries.

Gremlin can be used to create entities (Vertex and Edge) of a graph, modify the properties of entities, and delete entities. More importantly, it can be used to perform graph querying and analysis operations.

### TinkerPop Features

HugeGraph implements the TinkerPop framework, but not all TinkerPop features are implemented.

The table below lists the support status of various TinkerPop features in HugeGraph:

### Graph Features

| Name                 | Description                                                                                                                                                                                                                                                                                                                                                                                                                                                   | Support |
|----------------------|---------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------|---------|
| Computer             | Determines if the {@code Graph} implementation supports {@link GraphComputer} based processing                                                                                                                                                                                                                                                                                                                                                                | false   |
| Transactions         | Determines if the {@code Graph} implementations supports transactions.                                                                                                                                                                                                                                                                                                                                                                                        | true    |
| Persistence          | Determines if the {@code Graph} implementation supports persisting it's contents natively to disk.This feature does not refer to every graph's ability to write to disk via the Gremlin IO packages(.e.g. GraphML), unless the graph natively persists to disk via those options somehow. For example,TinkerGraph does not support this feature as it is a pure in-sideEffects graph.                                                                         | true    |
| ThreadedTransactions | Determines if the {@code Graph} implementation supports threaded transactions which allow a transaction be executed across multiple threads via {@link Transaction#createThreadedTx()}.                                                                                                                                                                                                                                                                       | false   |
| ConcurrentAccess     | Determines if the {@code Graph} implementation supports more than one connection to the same instance at the same time. For example, Neo4j embedded does not support this feature because concurrent access to the same database files by multiple instances is not possible. However, Neo4j HA could support this feature as each new {@code Graph} instance coordinates with the Neo4j cluster allowing multiple instances to operate on the same database. | false   |

### Vertex Features

| Name                     | Description                                                                                                                                                                                                                                                                                                                                                                                                                                                                                     | Support |
|--------------------------|-------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------|---------|
| UserSuppliedIds          | Determines if an {@link Element} can have a user defined identifier. Implementation that do not support this feature will be expected to auto-generate unique identifiers. In other words, if the {@link Graph} allows {@code graph.addVertex(id,x)} to work and thus set the identifier of the newly added {@link Vertex} to the value of {@code x} then this feature should return true. In this case, {@code x} is assumed to be an identifier data type that the {@link Graph} will accept. | false   |
| NumericIds               | Determines if an {@link Element} has numeric identifiers as their internal representation. In other words,if the value returned from {@link Element#id()} is a numeric value then this method should be return {@code true}. Note that this feature is most generally used for determining the appropriate tests to execute in the Gremlin Test Suite.                                                                                                                                          | false   |
| StringIds                | Determines if an {@link Element} has string identifiers as their internal representation. In other words, if the value returned from {@link Element#id()} is a string value then this method should be return {@code true}. Note that this feature is most generally used for determining the appropriate tests to execute in the Gremlin Test Suite.                                                                                                                                           | false   |
| UuidIds                  | Determines if an {@link Element} has UUID identifiers as their internal representation. In other words,if the value returned from {@link Element#id()} is a {@link UUID} value then this method should be return {@code true}.Note that this feature is most generally used for determining the appropriate tests to execute in the Gremlin Test Suite.                                                                                                                                         | false   |
| CustomIds                | Determines if an {@link Element} has a specific custom object as their internal representation.In other words, if the value returned from {@link Element#id()} is a type defined by the graph implementations, such as OrientDB's {@code Rid}, then this method should be return {@code true}.Note that this feature is most generally used for determining the appropriate tests to execute in the Gremlin Test Suite.                                                                         | false   |
| AnyIds                   | Determines if an {@link Element} any Java object is a suitable identifier. TinkerGraph is a good example of a {@link Graph} that can support this feature, as it can use any {@link Object} as a value for the identifier. Note that this feature is most generally used for determining the appropriate tests to execute in the Gremlin Test Suite. This setting should only return {@code true} if {@link #supportsUserSuppliedIds()} is {@code true}.                                        | false   |
| AddProperty              | Determines if an {@link Element} allows properties to be added. This feature is set independently from supporting "data types" and refers to support of calls to {@link Element#property(String, Object)}.                                                                                                                                                                                                                                                                                      | true    |
| RemoveProperty           | Determines if an {@link Element} allows properties to be removed.                                                                                                                                                                                                                                                                                                                                                                                                                               | true    |
| AddVertices              | Determines if a {@link Vertex} can be added to the {@code Graph}.                                                                                                                                                                                                                                                                                                                                                                                                                               | true    |
| MultiProperties          | Determines if a {@link Vertex} can support multiple properties with the same key.                                                                                                                                                                                                                                                                                                                                                                                                               | false   |
| DuplicateMultiProperties | Determines if a {@link Vertex} can support non-unique values on the same key. For this value to be {@code true}, then {@link #supportsMetaProperties()} must also return true. By default this method, just returns what {@link #supportsMultiProperties()} returns.                                                                                                                                                                                                                            | false   |
| MetaProperties           | Determines if a {@link Vertex} can support properties on vertex properties. It is assumed that a graph will support all the same data types for meta-properties that are supported for regular properties.                                                                                                                                                                                                                                                                                      | false   |
| RemoveVertices           | Determines if a {@link Vertex} can be removed from the {@code Graph}.                                                                                                                                                                                                                                                                                                                                                                                                                           | true    |

### Edge Features

| Name            | Description                                                                                                                                                                                                                                                                                                                                                                                                                                                                                     | Support |
|-----------------|-------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------|---------|
| UserSuppliedIds | Determines if an {@link Element} can have a user defined identifier. Implementation that do not support this feature will be expected to auto-generate unique identifiers. In other words, if the {@link Graph} allows {@code graph.addVertex(id,x)} to work and thus set the identifier of the newly added {@link Vertex} to the value of {@code x} then this feature should return true. In this case, {@code x} is assumed to be an identifier data type that the {@link Graph} will accept. | false   |
| NumericIds      | Determines if an {@link Element} has numeric identifiers as their internal representation. In other words,if the value returned from {@link Element#id()} is a numeric value then this method should be return {@code true}. Note that this feature is most generally used for determining the appropriate tests to execute in the Gremlin Test Suite.                                                                                                                                          | false   |
| StringIds       | Determines if an {@link Element} has string identifiers as their internal representation. In other words, if the value returned from {@link Element#id()} is a string value then this method should be return {@code true}. Note that this feature is most generally used for determining the appropriate tests to execute in the Gremlin Test Suite.                                                                                                                                           | false   |
| UuidIds         | Determines if an {@link Element} has UUID identifiers as their internal representation. In other words,if the value returned from {@link Element#id()} is a {@link UUID} value then this method should be return {@code true}.Note that this feature is most generally used for determining the appropriate tests to execute in the Gremlin Test Suite.                                                                                                                                         | false   |
| CustomIds       | Determines if an {@link Element} has a specific custom object as their internal representation.In other words, if the value returned from {@link Element#id()} is a type defined by the graph implementations, such as OrientDB's {@code Rid}, then this method should be return {@code true}.Note that this feature is most generally used for determining the appropriate tests to execute in the Gremlin Test Suite.                                                                         | false   |
| AnyIds          | Determines if an {@link Element} any Java object is a suitable identifier. TinkerGraph is a good example of a {@link Graph} that can support this feature, as it can use any {@link Object} as a value for the identifier. Note that this feature is most generally used for determining the appropriate tests to execute in the Gremlin Test Suite. This setting should only return {@code true} if {@link #supportsUserSuppliedIds()} is {@code true}.                                        | false   |
| AddProperty     | Determines if an {@link Element} allows properties to be added. This feature is set independently from supporting "data types" and refers to support of calls to {@link Element#property(String, Object)}.                                                                                                                                                                                                                                                                                      | true    |
| RemoveProperty  | Determines if an {@link Element} allows properties to be removed.                                                                                                                                                                                                                                                                                                                                                                                                                               | true    |
| AddEdges        | Determines if an {@link Edge} can be added to a {@code Vertex}.                                                                                                                                                                                                                                                                                                                                                                                                                                 | true    |
| RemoveEdges     | Determines if an {@link Edge} can be removed from a {@code Vertex}.                                                                                                                                                                                                                                                                                                                                                                                                                             | true    |

### Data Type Features

| Name               | Description                                                                                                                                                                                                                                                          | Support |
|--------------------|----------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------|---------|
| BooleanValues      |                                                                                                                                                                                                                                                                      | true    |
| ByteValues         |                                                                                                                                                                                                                                                                      | true    |
| DoubleValues       |                                                                                                                                                                                                                                                                      | true    |
| FloatValues        |                                                                                                                                                                                                                                                                      | true    |
| IntegerValues      |                                                                                                                                                                                                                                                                      | true    |
| LongValues         |                                                                                                                                                                                                                                                                      | true    |
| MapValues          | Supports setting of a {@code Map} value. The assumption is that the {@code Map} can contain arbitrary serializable values that may or may not be defined as a feature itself                                                                                         | false   |
| MixedListValues    | Supports setting of a {@code List} value. The assumption is that the {@code List} can contain arbitrary serializable values that may or may not be defined as a feature itself. As this{@code List} is "mixed" it does not need to contain objects of the same type. | false   |
| BooleanArrayValues |                                                                                                                                                                                                                                                                      | false   |
| ByteArrayValues    |                                                                                                                                                                                                                                                                      | true    |
| DoubleArrayValues  |                                                                                                                                                                                                                                                                      | false   |
| FloatArrayValues   |                                                                                                                                                                                                                                                                      | false   |
| IntegerArrayValues |                                                                                                                                                                                                                                                                      | false   |
| LongArrayValues    |                                                                                                                                                                                                                                                                      | false   |
| SerializableValues |                                                                                                                                                                                                                                                                      | false   |
| StringArrayValues  |                                                                                                                                                                                                                                                                      | false   |
| StringValues       |                                                                                                                                                                                                                                                                      | true    |
| UniformListValues  | Supports setting of a {@code List} value. The assumption is that the {@code List} can contain arbitrary serializable values that may or may not be defined as a feature itself. As this{@code List} is "uniform" it must contain objects of the same type.           | false   |

### Gremlin Steps

HugeGraph supports all steps of Gremlin. For complete reference information about Gremlin, please refer to the [Gremlin official website](http://tinkerpop.apache.org/docs/current/reference/).

| Step       | Description                                                                                     | Documentation                                                                           |
|------------|-------------------------------------------------------------------------------------------------|----------------------------------------------------------------------------------------|
| addE       | Add an edge between two vertices.                                                                      | [addE step](http://tinkerpop.apache.org/docs/current/reference/#addedge-step)          |
| addV       | add vertices to graph.                                                                                        | [addV step](http://tinkerpop.apache.org/docs/current/reference/#addvertex-step)        |
| and        | Make sure all traversals return values.	                                                                                      | [and step](http://tinkerpop.apache.org/docs/current/reference/#add-step)               |
| as         | Step modulator for assigning variables to the step's output.	                                                                              | [as step](http://tinkerpop.apache.org/docs/current/reference/#as-step)                 |
| by         | Step Modulators used in conjunction with group and order.                                                                   | [by step](http://tinkerpop.apache.org/docs/current/reference/#by-step)                 |
| coalesce   | Returns the first traversal that returns a result.                                                                                    | [coalesce step](http://tinkerpop.apache.org/docs/current/reference/#coalesce-step)     |
| constant   | Returns a constant value. Used in conjunction with coalesce.                                                                          | [constant step](http://tinkerpop.apache.org/docs/current/reference/#constant-step)     |
| count      | Returns a count from the traversal.                                                                                         | [count step](http://tinkerpop.apache.org/docs/current/reference/#addedge-step)         |
| dedup      | Returns values with duplicates removed.                                                                                     | [dedup step](http://tinkerpop.apache.org/docs/current/reference/#dedup-step)           |
| drop       | Discards a value (vertex/edge).                                                                                      | [drop step](http://tinkerpop.apache.org/docs/current/reference/#drop-step)             |
| fold       | Acts as a barrier for computing aggregated values from results.                                                                                  | [fold step](http://tinkerpop.apache.org/docs/current/reference/#fold-step)             |
| group      | Groups values based on specified labels.                                                                                     | [group step](http://tinkerpop.apache.org/docs/current/reference/#group-step)           |
| has        | Used to filter properties, vertices, and edges. Supports `hasLabel`, `hasId`, `hasNot`, and `has` variants.                                          | [has step](http://tinkerpop.apache.org/docs/current/reference/#has-step)               |
| inject     | Injects values into the stream.                                                                                          | [inject step](http://tinkerpop.apache.org/docs/current/reference/#inject-step)         |
| is         | Used to filter by a Boolean expression.                                                                                  | [is step](http://tinkerpop.apache.org/docs/current/reference/#is-step)                 |
| limit      | Used to limit the number of items in a traversal.                                                                                      | [limit step](http://tinkerpop.apache.org/docs/current/reference/#limit-step)           |
| local      | Locally wraps a part of a traversal, similar to a subquery.                                                                              | [local step](http://tinkerpop.apache.org/docs/current/reference/#local-step)           |
| not        | Used to generate the negation result of a filter.                                                                                    | [not step](http://tinkerpop.apache.org/docs/current/reference/#not-step)               |
| optional   | Returns the result of a specified traversal if it generates any results, otherwise returns the calling element.                                                                   | [optional step](http://tinkerpop.apache.org/docs/current/reference/#optional-step)     |
| or         | Ensures that at least one traversal returns a value.                                                                                   | [or step](http://tinkerpop.apache.org/docs/current/reference/#or-step)                 |
| order      | Returns results in the specified order.                                                                                    | [order step](http://tinkerpop.apache.org/docs/current/reference/#order-step)           |
| path       | Returns the full path of the traversal.                                                                                       | [path step](http://tinkerpop.apache.org/docs/current/reference/#addedge-step)          |
| project    | Projects properties as a map.                                                                                        | [project step](http://tinkerpop.apache.org/docs/current/reference/#project-step)       |
| properties | Returns properties with specified labels.                                                                                       | [properties step](http://tinkerpop.apache.org/docs/current/reference/#properties-step) |
| range      | Filters based on a specified range of values.                                                                                    | [range step](http://tinkerpop.apache.org/docs/current/reference/#range-step)           |
| repeat     | Repeats a step a specified number of times. Used for looping.                                                                                | [repeat step](http://tinkerpop.apache.org/docs/current/reference/#repeat-step)         |
| sample     | Used to sample results returned by the traversal.                                                                                    | [sample step](http://tinkerpop.apache.org/docs/current/reference/#sample-step)         |
| select     | Used to project the results returned by the traversal.                                                                                     | [select step](http://tinkerpop.apache.org/docs/current/reference/#select-step)         |
| store      | This step is used fo.r non-blocking aggregation of results returned by traversal                                                                                    | [store step](http://tinkerpop.apache.org/docs/current/reference/#store-step)           |
| tree       | Aggregate the paths in vertices into a tree.                                                                                    | [tree step](http://tinkerpop.apac.he.org/docs/current/reference/#tree-step)             |
| unfold     | Unfolds an iterator as a step.                                                                                      | [unfold step](http://tinkerpop.apache.org/docs/c.urrent/reference/#unfold-step)         |
| union      | Merge the results returned by multiple traversals.                                                                                     | [union step](http://tinkerpop.apache.org/docs/current/reference/#union-step)           |
| V          | These are the steps required for traversing between vertices and edges: `V`, `E`, `out`, `in`, `both`, `outE`, `inE`, `bothE`, `outV`, `inV`, `bothV`, and `otherV`. | [order step](http://tinkerpop.apache.org/docs/current/reference/#vertex-steps)         |
| where      | Used to filter the results returned by a traversal. Supports `eq`, `neq`, `lt`, `lte`, `gt`, `gte`, and `between` operators.                              | [where step](http://tinkerpop.apache.org/docs/current/reference/#where-step)           |
