---
title: "HugeGraph 0.2 Release Notes"
linkTitle: "Release-0.2.4"
draft: true
weight: 23
---

### API & Java Client

#### 功能更新
0.2版实现了图数据库基本功能，提供如下功能：

### 元数据（Schema）

#### 顶点类型（Vertex Label）

- 创建顶点类型
- 删除顶点类型
- 查询顶点类型
- 增加顶点类型的属性

#### 边类型（Edge Label）

- 创建边类型
- 删除边类型
- 查询边类型
- 增加边类型的属性

#### 属性（Property Key）

- 创建属性
- 删除属性
- 查询属性

#### 索引（Index Label）

- 创建索引
- 删除索引
- 查询索引

#### 元数据检查

- 元数据依赖的其它元数据检查（如Vertex Label依赖Property Key）
- 数据依赖的元数据检查（如Vertex依赖Vertex Label）

### 图数据

#### 顶点（Vertex）

- 增加顶点
- 删除顶点
- 增加顶点属性
- 删除顶点属性（必须为非索引列）
- 批量插入顶点
- 查询
- 批量查询
- 顶点ID策略

  - 用户指定ID（字符串）
  - 用户指定某些属性组合作为ID（拼接为可见字符串）
  - 自动生成ID

#### 边（Edge）

- 增加边
- 增加多条同类型边到指定的两个节点（SortKey）
- 删除边
- 增加边属性
- 删除边属性（必须为非索引列）
- 批量插入边
- 查询
- 批量查询

#### 顶点/边属性

- 属性类型支持

  - text
  - boolean
  - byte、blob
  - int、long
  - float、double
  - timestamp
  - uuid

- 支持单值属性

- 支持多值属性：List、Set（_注意：非嵌套属性_）

### 事务

- 原子性级别保证（_依赖后端_）
- 自动提交事务
- 手动提交事务
- 并行事务

### 索引

#### 索引类型

- 二级索引
- 范围索引（数字类型）

#### 索引操作

- 为指定类型的顶点/边创建单列索引（不支持List或Set列创建索引）
- 为指定类型的顶点/边创建复合索引（不支持List或Set列创建索引，复合索引为前缀索引）
- 删除指定类型顶点/边的索引（部分或全部索引均可）
- 重建指定类型顶点/边的索引（部分或全部索引均可）

### 查询/遍历

- 列出所有元数据、图数据（支持Limit，不支持分页）
- 根据ID查询元数据、图数据
- 根据指定属性的值查询图数据
- 根据指定属性的值范围查询图数据（属性必须为数字类型）
- 根据指定顶点/边类型、指定属性的值查询顶点/边
- 根据指定顶点/边类型、指定属性的值范围查询顶点（属性必须为数字类型）
- 根据顶点类型（Vertex Label）查询顶点
- 根据边类型（Edge Label）查询边
- 根据顶点查询边

  - 查询顶点的所有边
  - 查询顶点的指定方向边（出边、入边）
  - 查询顶点的指定方向、指定类型边
  - 查询两个顶点的同类型边中的某条边（SortKey）

- 标准Gremlin遍历

### 缓存

#### 可缓存内容

- 元数据缓存
- 顶点缓存

#### 缓存特性

- LRU策略
- 高性能并发访问
- 支持超时过期机制

### 接口（RESTful API）

- 版本号接口
- 图实例接口
- 元数据接口
- 图数据接口
- Gremlin接口

更多细节详见[API文档](/clients/hugegraph-api.html)

### 后端支持

#### 支持Cassandra后端

- 持久化
- CQL3
- 集群

#### 支持Memory后端（仅用于测试）

- 非持久化
- 部分特性无法支持（如：更新边属性、根据边类型查询边）

### 其它

#### 支持配置项

- 后端存储类型
- 序列化方式
- 缓存参数

#### 支持多图实例

- 静态方式（_增加多个图配置文件_）

#### 版本检查

- 内部依赖包匹配版本检查
- API匹配版本检查
