---
title: Glossary
order: 7
---

| Term      | Explanation                                                                                                                        |
| --------- | ---------------------------------------------------------------------------------------------------------------------------------- |
| Graph     | A concept in graph theory, specifically refers to the class used to instantiate the canvas in `G6`                                 |
| Element   | Refers to `node`, `edge`, and `combo` in a general sense                                                                           |
| Node      | Represents a single or composite shape in a Graph, denoting an independently existing entity                                       |
| Edge      | Represents a `line` connecting nodes in a Graph, indicating a relationship between two nodes                                       |
| Combo     | A collection of nodes that can include sub-combos                                                                                  |
| State     | The state in which an element exists, such as selected, hovered, activated, etc.                                                   |
| Layout    | The process of arranging elements in a graph according to certain rules                                                            |
| Behavior  | A series of operational behaviors between the user and the canvas or elements, such as dragging, scaling, panning, selecting, etc. |
| Plugin    | A flexible extension mechanism provided by G6                                                                                      |
| Extension | A collective term for all registrable content, including elements, behaviors, layouts, plugins, etc.                               |
| Canvas    | The content area where the Graph is drawn                                                                                          |
| Viewport  | The area observed by the camera, i.e., the current visible range of the user                                                       |
| Shape     | Basic shapes provided by G, including circles, rectangles, text, etc.                                                              |
