---
title: Installation
order: 1
---

## npm

```bash
# npm
npm install @antv/g6 --save

# pnpm
pnpm add @antv/g6

# yarn
yarn add @antv/g6
```

Import G6 in the code:

```js
import { Graph } from '@antv/g6';
```

Visit [G6 npm Example](https://codesandbox.io/p/sandbox/using-g6-from-npm-d9spnr) to view the complete example code.

## CDN

`@antv/g6` Available on multiple CDNs:

- unpkg: https://unpkg.com/@antv/g6@5/dist/g6.min.js
- jsDelivr: https://cdn.jsdelivr.net/npm/@antv/g6@5/dist/g6.min.js
- npmmirror: https://registry.npmmirror.com/@antv/g6/5/files/dist/g6.min.js

Import G6 using a `script` tag:

```html
<script src="https://unpkg.com/@antv/g6@5/dist/g6.min.js"></script>
```

Visit [G6 CDN Example](https://codesandbox.io/p/sandbox/using-g6-from-cdn-xt9ty6) to view the complete example code.
