---
title: 使用 3D
order: 5
---

## 安装依赖

在使用 3D 能力之前，请首先安装 3D 扩展包：

```bash
npm install @antv/g6-extension-3d --save
```

该扩展包导出了以下内容：

- renderer：3D 渲染器

**元素**

- Capsule：胶囊节点
- Cone：圆锥节点
- Cube：立方体节点
- Cylinder：圆柱节点
- Sphere：球体节点
- Torus：圆环节点
- Line3D：3D 线

**布局**

- D3Force3DLayout：3D 力导向布局

**交互**

- DragCanvas3D：拖拽画布
- ObserveCanvas3D：观察画布
- RollCanvas3D：旋转画布
- ZoomCanvas3D：缩放画布

**插件**

- Light：光源

## 注册扩展

其中下列扩展是必须的：

- renderer
- 至少一个 3D 节点
- Line3D
- Light

> renderer 无需注册，实例化 Graph 过程中传入即可。

使用如下方式进行注册：

```ts
import { register, ExtensionCategory } from '@antv/g6';
import { Sphere, Line3D, Light } from '@antv/g6-extension-3d';

register(ExtensionCategory.NODE, 'sphere', Sphere);
register(ExtensionCategory.EDGE, 'line3d', Line3D);
register(ExtensionCategory.PLUGIN, 'light', Light);
```

## 创建 3D 图

完成上述步骤后，即可创建 3D 图：

```ts
import { Graph } from '@antv/g6';
import { renderer } from '@antv/g6-extension-3d';

const graph = new Graph({
  // ... 其他配置
  // 使用 3D 渲染器
  renderer,
  node: {
    type: 'sphere', // 使用 3D 节点
    style: {
      materialType: 'phong', // 使用 Phong 材质
    },
  },
  edge: {
    type: 'line3d', // 使用 3D 边
  },
  plugins: [
    {
      type: 'light', // 添加光源
      // 配置方向光
      directional: {
        direction: [0, 0, 1],
      },
    },
  ],
});

graph.render();
```

你可以参考以下示例：

- [精简太阳系](/examples/feature/default/#lite-solar-system)
- [3D 力导向布局](/examples/layout/force-directed/#3d-force)

## 其他

`@antv/g6` 中内置注册了 `CameraSetting` 插件，可用于配置相机，具体可参考[插件](/api/plugins/camera-setting)。

```typescript
{
  plugins: [
    {
      type: 'camera-setting',
      projectionMode: 'perspective',
      near: 0.1,
      far: 1000,
      fov: 45,
      aspect: 1,
    },
  ];
}
```
