---
title: Use 3D
order: 5
---

## Install Dependencies

Before using 3D capabilities, please install the 3D extension package first:

```bash
npm install @antv/g6-extension-3d --save
```

The extension package exports the following:

- renderer: 3D renderer

**Elements**

- Capsule: capsule node
- Cone: cone node
- Cube: cube node
- Cylinder: cylinder node
- Sphere: sphere node
- Torus: torus node
- Line3D: 3D line

**Layout**

- D3Force3DLayout: 3D force-directed layout

**Behaviors**

- DragCanvas3D: drag canvas
- ObserveCanvas3D: observe canvas
- RollCanvas3D: rotate canvas
- ZoomCanvas3D: zoom canvas

**Plugin**

- Light: light source

## Register Extensions

The following extensions are required:

- renderer
- at least one 3D node
- Line3D
- Light

> The renderer does not need to be registered, it can be passed in during the instantiation of Graph.

Register as follows:

```ts
import { register, ExtensionCategory } from '@antv/g6';
import { Sphere, Line3D, Light } from '@antv/g6-extension-3d';

register(ExtensionCategory.NODE, 'sphere', Sphere);
register(ExtensionCategory.EDGE, 'line3d', Line3D);
register(ExtensionCategory.PLUGIN, 'light', Light);
```

## Create 3D Graph

After completing the above steps, you can create a 3D graph:

```ts
import { Graph } from '@antv/g6';
import { renderer } from '@antv/g6-extension-3d';

const graph = new Graph({
  // ... other options
  // use 3d renderer
  renderer,
  node: {
    type: 'sphere', // use 3d node
    style: {
      materialType: 'phong', // use Phong material
    },
  },
  edge: {
    type: 'line3d', // use 3D edge
  },
  plugins: [
    {
      type: 'light', // Add light source
      // configure directional light
      directional: {
        direction: [0, 0, 1],
      },
    },
  ],
});

graph.render();
```

You can also refer to:

- [Lite Solar System](/examples/feature/default/#lite-solar-system)
- [3D Force Layout](/examples/layout/force-directed/#3d-force)

## Tips

`@antv/g6` has a built-in registered plugin for CameraSetting for camera configuration, refer to [plugin](/api/plugins/camera-setting).

```typescript
{
  plugins: [
    {
      type: 'camera-setting',
      projectionMode: 'perspective',
      near: 0.1,
      far: 1000,
      fov: 45,
      aspect: 1,
    },
  ];
}
```
