program Console;

{$APPTYPE CONSOLE}

{$R *.res}

uses
  System.SysUtils,
  System.Classes,
  Data.DB,
  FireDAC.Stan.Intf,
  FireDAC.Stan.Option,
  FireDAC.Stan.Error,
  FireDAC.UI.Intf,
  FireDAC.Phys.Intf,
  FireDAC.Stan.Def,
  FireDAC.Stan.Pool,
  FireDAC.Stan.Async,
  FireDAC.Phys,
  FireDAC.VCLUI.Wait,
  FireDAC.Comp.Client,
  FireDAC.Stan.Param,
  FireDAC.DatS,
  FireDAC.DApt.Intf,
  FireDAC.DApt,
  FireDAC.Comp.DataSet,
  frxClass,
  FRPrinter,
  FRPrinter.Types,
  Utils in '..\Utils\Utils.pas',
  Data in '..\Utils\Data.pas';

var
  lFDConnection: TFDConnection;
  lQryEstadosBrasil: TFDQuery;
  lQryMunicipioEstado: TFDQuery;
  lQryMunicipioRegiao: TFDQuery;
  lQryEstadoRegiao: TFDQuery;
  lQryMunicipios: TFDQuery;
  lPrinted: Boolean;
  lError: string;
begin
  {$IFDEF MSWINDOWS}
  IsConsole := False;
  ReportMemoryLeaksOnShutdown := True;
  {$ENDIF}

  Writeln('Impresso Fast Report.');
  Writeln('');

  lFDConnection := nil;
  try
    lFDConnection := TFDConnection.Create(nil);

    //CONEXO COM O BANCO DE DADOS DE EXEMPLO
    if not TUtils.ConnectDB('127.0.0.1', TUtils.PathAppFileDB, lFDConnection, lError) then
    begin
      Writeln('Erro de conexo: ' + lError);
      Readln;
      Exit;
    end;

    //CONSULTA BANCO DE DADOS
    try
      TData.QryEstadosBrasil(lFDConnection, lQryEstadosBrasil);
      TData.QryMunicipioEstado(lFDConnection, lQryMunicipioEstado);
      TData.QryMunicipioRegiao(lFDConnection, lQryMunicipioRegiao);
      TData.QryEstadoRegiao(lFDConnection, lQryEstadoRegiao);
      TData.QryMunicipios(lFDConnection, lQryMunicipios);
    except
      on E: Exception do
      begin
        Writeln(E.Message);
        Readln;
        Exit;
      end;
    end;

    //CLASSE DE IMPRESSO
    try
      lPrinted := TFRPrinter.New.
      DataSets.
        SetDataSet(lQryEstadosBrasil, 'EstadosBrasil').
        SetDataSet(lQryMunicipioEstado, 'MunicipioEstado').
        SetDataSet(lQryMunicipioRegiao, 'MunicipioRegiao').
        SetDataSet(lQryEstadoRegiao, 'EstadoRegiao').
        SetDataSet(lQryMunicipios, 'Municipios').
      &End.
      Print.
        SetPrinter('Microsoft Print to PDF'). //QUANDO NO INFORMADO UTILIZA A IMPRESSORA CONFIGURADA NO RELATRIO *.fr3
        SetFileReport(TUtils.PathAppFileReport). //LOCAL DO RELATRIO *.fr3
        Report(procedure(pfrxReport: TfrxReport) //CONFIGURAO DO COMPONENTE DE RELATRIO DO FAST REPORT
        var
          lfrxComponent: TfrxComponent;
          lfrxMemoView: TfrxMemoView absolute lfrxComponent;
        begin
          //CONFIGURAO DO COMPONENTE

          pfrxReport.ReportOptions.Name := 'API de localidades IBGE'; //NOME PARA IDENTIFICAO NA IMPRESSO DO RELATRIO
          pfrxReport.ReportOptions.Author := 'Antnio Jos Medeiros Schneider';

          //PASSAGEM DE PARMETRO PARA O RELATRIO
          lfrxComponent := pfrxReport.FindObject('mmoProcess');
          if Assigned(lfrxComponent) then
          begin
            lfrxMemoView.Memo.Clear;
            lfrxMemoView.Memo.Text := Format('Aplicativo de Exemplo: %s', ['CONSOLE']);
          end;
        end).
        Execute; //PROCESSAMENTO DO RELATRIO/IMPRESSO
    except
      on E: Exception do
      begin
        if E is EFRPrinter then
          Writeln('Erro de impresso: ' + E.ToString)
        else
          Writeln('Erro de impresso: ' + E.Message);

        Readln;
        Exit;
      end;
    end;

    if lPrinted then
      Writeln('Impresso')
    else
      Writeln('Falha de impresso');

    Readln;
  finally
    lFDConnection.Free;
  end;
end.
