import { isNumber, isPlainObject, isPromise } from './validator'
export function isDef(value) {
  return value !== undefined && value !== null
}
export function isObj(x) {
  const type = typeof x
  return x !== null && (type === 'object' || type === 'function')
}
export function range(num, min, max) {
  return Math.min(Math.max(num, min), max)
}
export function nextTick(fn) {
  setTimeout(() => {
    fn()
  }, 1000 / 30)
}
let systemInfo
export function getSystemInfoSync() {
  if (systemInfo == null) {
    systemInfo = wx.getSystemInfoSync()
  }
  return systemInfo
}
export function addUnit(value) {
  if (!isDef(value)) {
    return undefined
  }
  value = String(value)
  return isNumber(value) ? `${value}px` : value
}
export function requestAnimationFrame(cb) {
  const systemInfo = getSystemInfoSync()
  if (systemInfo.platform === 'devtools') {
    return nextTick(cb)
  }
  return wx
    .createSelectorQuery()
    .selectViewport()
    .boundingClientRect()
    .exec(() => {
      cb()
    })
}
export function pickExclude(obj, keys) {
  if (!isPlainObject(obj)) {
    return {}
  }
  return Object.keys(obj).reduce((prev, key) => {
    if (!keys.includes(key)) {
      prev[key] = obj[key]
    }
    return prev
  }, {})
}
export function getRect(selector) {
  return new Promise((resolve) => {
    wx.createSelectorQuery()
      .in(this)
      .select(selector)
      .boundingClientRect()
      .exec((rect = []) => resolve(rect[0]))
  })
}
export function getAllRect(selector) {
  return new Promise((resolve) => {
    wx.createSelectorQuery()
      .in(this)
      .selectAll(selector)
      .boundingClientRect()
      .exec((rect = []) => resolve(rect[0]))
  })
}
export function toPromise(promiseLike) {
  if (isPromise(promiseLike)) {
    return promiseLike
  }
  return Promise.resolve(promiseLike)
}
