my.setStorageSync({
    key: "activeComponent",
    data: {
        is: "dist/action-sheet/index"
    }
});
import { VantComponent } from "../common/component";
import { safeArea } from "../mixins/safe-area";
VantComponent({
    mixins: [safeArea()],
    props: {
        show: Boolean,
        title: String,
        cancelText: String,
        zIndex: {
            type: Number,
            value: 100
        },
        actions: {
            type: Array,
            value: []
        },
        overlay: {
            type: Boolean,
            value: true
        },
        closeOnClickOverlay: {
            type: Boolean,
            value: true
        }
    },
    methods: {
        onSelect(event) {
            const { index } = event.currentTarget.dataset;
            const item = this.data.actions[index];

            if (item && !item.disabled && !item.loading) {
                this.$emit("select", item);
            }
        },

        onCancel() {
            this.$emit("cancel");
        },

        onClose() {
            this.$emit("close");
        }
    }
});
