---
title: 转载-如何提交无法解答的问题
date: 2023-02-22
author: afc163
---

初次到社区提交 issue 时会遇到一些常见的错误，而使得维护者很难帮助解决问题。转载一篇旧文章，希望在博君一笑的同时也能帮助到大家 :)

> 原文链接：[如何向开源项目提交无法解答的问题](https://zhuanlan.zhihu.com/p/25795393)

---

作为一名互联网开发者，本人使用和参与过许多开源项目。开源社区里，提问和回答是最有趣的组成部分，有些你来我往，有些则石沉大海。人们提问的方式有许多迷人和实用的共通之处。我把它们提炼出来，希望能帮助到那些像我一样充满了好奇心、且愿意付诸行动去惹恼开源项目维护者的人们。

以下是『如何提出无法解答的问题』的十三个小技巧：

## 1. 惜字如金

『言多必失，不如闷声发大财』

压缩问题的字节数，不要让对方觉得你啰嗦。用最简单的字词描述你的问题，提炼关键字，简化掉冗长的过程和繁琐的细节。

#### 😈 “正确示范”

```
样式编译报错
```

#### 👼 “错误示范”

```
在我的项目里引入了 xxx.css，编译时出错了，报错信息如下：

Module build failed: SyntaxError: Unexpected token

我是这么引用的：

import 'xxx.css';

balalalala .....
```

## 2. 缓兵之计

『和他成为长期笔友。』

如果维护者答复你了，通常他们会索要进一步的信息。记住不要着急回复，那样显得你像个工作狂（时时刻刻泡在电脑边，可怜巴巴的等待回复）。你还有其他生活，喝杯咖啡，聊个微信，隔上十天半个月再回复。相信我，他们很快会失去耐心而关掉这个问题，或者因为一时关不了而心情郁闷。

#### 😈 “正确示范”

```
你：使用 Button 时发现控制台报错，提示如下。
维护者（两天内）：我没有重现出你的例子，可以提供一份可重现的示例么？
维护者（三天后）：@你
维护者（一周后）：ping~
你（两周后）：哎呀抱歉，没有及时回复，我的代码在这里。
```

#### 👼 “错误示范”

```
你：使用 Button 时发现控制台报错，提示如下。
维护者（两天内）：我没有重现出你的例子，可以提供一份可重现的示例么？
你（两天内）：可能我的情况有些不同，这里是重现代码。
```

## 3. 夹带私货

『我哪有时间排查，这绝对是你的锅。』

在一个中型或者大型项目中引入开源模块容易遇到奇怪的问题。几十个文件上百个业务模块，项目工期又紧张，一一排查太辛苦了，还是另请高明吧，赶紧打个包发给对方。

#### 😈 “正确示范”

```
我的数据库项目出现了一个前端组件问题，这里是我的代码，有人能帮我看看么？
附件：db-service-app.rar (434MB)
```

#### 👼 “错误示范”

```
我的项目里出现了一个前端组件问题，我简化了一下代码，
发现是 xxx 组件和 yyy 组件同时使用时出现的，这里有个简单的重现例子。
附件：component-xxx-yyy-bug.zip (10KB)
```

## 4. 卖个关子

『欲知后事如何，且听下回分解』

总是留个后手，不要一次性把话说完，让你的问题充满神秘感，充分调动起读者的好奇心。

#### 😈 “正确示范”

```
你：我的代码出错了，不知道该怎么办？
你：我这里有一个问题，有人能帮我解决么？
你：在吗？
```

#### 👼 “错误示范”

```
你：我使用了刚刚发布的 xxx 最新版本，控制台出现如下错误...
我是这么调用的...
我的代码仓库在这里...
```

## 5. 弄乱格式

『怕他轻易看懂我的问题，我必须要做点什么』

从来，永远不要格式化问题。你又不是美工，美化格式不是你的特长。你的精力要用在项目开发中，也没有时间去学习什么格式化语法。至于对方能不能看明白，你才不需要关心。

#### 😈 “正确示范”

```tsx
renderBatchButton() {

return(



<Dropdown overlay={this.renderExportMenu("2")}>





导出出库单

);

}


renderExportMenu(category) {

let exportFile=({key})=>{

console.log(key)

}

let items=[];

if(this.props.global.template_list){

items=this.props.global.template_list.map((item)=>{

if(category===item.category){

return <Menu.Item key={item.id}>{item.name}</Menu.Item>;

}

});

}
```

#### 👼 “错误示范”

```tsx
import React from 'react';
import { Menu } from 'antd';

const Demo: React.FC = () => {
  const [collapsed, setCollapsed] = useState<boolean>(false);

  const toggle = () => setCollapsed(!collapsed);

  return <Menu>...</Menu>;
};

export default Demo;
```

## 6. 遗漏关键信息

『诶？我忘了说我没插电源了么？』

项目代码一开始总是跑的好好的，你做了某个操作、或改动了某些代码、或者在一个特殊的环境下，问题出现了。 这个区别往往是问题的关键，把它留在心里就好，不要轻易说出来。

#### 😈 “正确示范”

```
你：我的代码出错了。
维护者：我尝试了各种方式都没有重现出来，麻烦提供下重现？
你（很久以后）：哦！我是在 chrome 35 中出现的这个问题。
```

#### 👼 “错误示范”

```
你：我的代码在 chrome 35 出错了。
维护者：好的，我也重现了，我看看怎么修复。
```

## 7. 提供错误的信息

『在错误的信息上解决问题才能体现你牛逼嘛！哈哈哈』

有时候需要做一些误导，有意或者无意，总之制造困难是你的强项

#### 😈 “正确示范”

```
你：我的代码出错了。
维护者：你使用了什么版本？
你：0.8.4（实际上本地是 0.8.3）
维护者：你确定么，0.8.4 应该已经修复过这个问题。我再看看...
```

#### 👼 “错误示范”

```
你：我的代码在 0.8.3 版本里出错了。
维护者：0.8.4 应该已经修复过这个问题，升级到新版即可解决。
```

## 8. 尽情宣泄情绪

『你们把我项目搞挂了，狗屎！』

开源项目导致了你的项目出现 BUG，导致了你周六晚上还要加班，导致了男友/女友抱怨你不理他/她，这必须要有人负责。你的工作和生活被他们毁了，也别让他们好过。

#### 😈 “正确示范”

```
这个项目烂透了，用起来全是坑，文档也太简略了，这样做开源真是呵呵了
```

#### 👼 “错误示范”

```
这个项目有很多细节问题，文档也不完善，请问有改进的计划么？
我收集了以下具体问题，希望持续完善。
```

## 9. 构思宏伟蓝图

『我要造一台汽车，该怎么做？』

尝试问一个具有宏大目标的问题，只有那些祖母般慈祥的维护者才会尝试回答你（这简直不可能发生）。而且由于你表现出了在所有技术细节上的毫无准备以及极端无知，对方的回答也没办法让你满意。

#### 😈 “正确示范”

```
请问怎么打包发布？
```

#### 👼 “错误示范”

```
我要开发一个前端单页项目，后端是 php，架构是前后端完全分离的方式。
我尝试使用 xxx 进行打包构建时遇到一个问题...（省略五十字）请问这时我应该做什么？
```

## 10. 自由发挥

『八股文的时代早就过去了！』

很多开源项目的维护者都是傲慢、迂腐、喜欢设定各种规矩的怪胎。例如他们常常会提供奇怪的问题模板，让你在一个又臭又长的表单里填空。一旦你不按他们说的来，他们就会视你为捣乱分子，把你批判一番。你哪里受得了这些拘束，想怎么写就怎么写，让他们和他们的模板都见鬼去吧！

#### 😈 “正确示范”

```
调用 `xxx.close` 没有关闭浮层，求解决
```

#### 👼 “错误示范”

```
xxx 组件浮层没有关闭

- 使用版本：1.0.0
- 浏览器：Chrome 56.0987
- 操作系统：Windows 10

## 你做了什么？

我引入了组件 xxx，代码如下，我点击组件后打开浮层，做了如下操作。

## 你期待的是什么？

浮层应该关闭。

## 实际上的情况是？

浮层短暂关闭后又再次弹出。

[GIF截图]

## 可重现的在线演示

https://codesandbox.io/xxx
```

## 11. 重复提问

『重要的事要说三遍』

在不同的地方重复你提过的问题，加深对方的印象，颠覆对方的想象！

#### 😈 “正确示范”

```
问题一：发请求时报错：`405 Method not allowed`。
问题二：您好，我这里出现了 `405 Method not allowed` 的问题。
问题三：请求 405 错误，请问我该怎么办？
问题 n：...
```

#### 👼 “错误示范”

```
问题一：发请求时报错：`405 Method not allowed`
你：+1 我也出现了这个问题。
```

## 12. 出其不意

『到全世界提问，到他们想不到的地方提问』

即使你知道有官方渠道，也推荐用其他方式向维护者提问：微博、Twitter、知乎私信、知乎评论区、Email、微信、个人博客、蚂蚁森林、朋友圈，今日头条娱乐版的评论区……到一切你能找到他的地方去提问。

#### 😈 “正确示范”

```
未关注人私信：你好，我们项目用的是你们的框架，我想问下可以让 xxx 组件获取到焦点吗？因为要做键盘切换
```

#### 👼 “错误示范”

```
官方渠道：你好，我们项目用的是你们的框架，我想问下可以让 xxx 组件获取到焦点吗？因为要做键盘切换
```

## 13. 上纲上线

『接连便是难懂的话，什么"KPI"，"绩效"，"弃坑"之类，引得众人都哄笑起来』

把你的问题拔高一个层次，站在道德高地进行指责，让他们便百口莫辩。

#### 😈 “正确示范”

```
原来大公司团队也就这样啊，都不好好测试的么？就这玩意还好意思拿出来，就是个 KPI 产物，晋升完就不管了。
```

#### 👼 “错误示范”

```
这个项目虽然是大公司的产品，在以下方面比起竞品还有劣势，个人不建议使用。
```

## 总结

总而言之，开源项目的维护者在尝试解答和解决问题时，总是希望能亲眼看到问题发生，**不要让他们得逞**。另外，他们大多对未关闭的问题有强迫症，尽量多制造一些这样的问题。
