import React from 'react';
import { Button, ConfigProvider, Result } from 'antd';

const App: React.FC = () => (
  <ConfigProvider
    theme={{
      components: {
        Result: {
          titleFontSize: 18,
          subtitleFontSize: 14,
          iconFontSize: 48,
          extraMargin: `12px 0 0 0`,
        },
      },
    }}
  >
    <Result
      status="success"
      title="Successfully Purchased Cloud Server ECS!"
      subTitle="Order number: 2017182818828182881 Cloud server configuration takes 1-5 minutes, please wait."
      extra={[
        <Button type="primary" key="console">
          Go Console
        </Button>,
        <Button key="buy">Buy Again</Button>,
      ]}
    />
  </ConfigProvider>
);

export default App;
