import React from 'react';
import Icon from '@ant-design/icons';

interface ExternalIconProps {
  className?: string;
  color?: string;
}

const SVGIcon: React.FC<{ color?: string }> = ({ color = 'currentColor' }) => (
  <svg viewBox="0 0 1024 1024" width="1em" height="1em" fill={color}>
    <title>External Link Icon</title>
    <path d="M853.333 469.333A42.667 42.667 0 0 0 810.667 512v256A42.667 42.667 0 0 1 768 810.667H256A42.667 42.667 0 0 1 213.333 768V256A42.667 42.667 0 0 1 256 213.333h256A42.667 42.667 0 0 0 512 128H256a128 128 0 0 0-128 128v512a128 128 0 0 0 128 128h512a128 128 0 0 0 128-128V512a42.667 42.667 0 0 0-42.667-42.667z" />
    <path d="M682.667 213.333h67.413L481.707 481.28a42.667 42.667 0 0 0 0 60.587 42.667 42.667 0 0 0 60.586 0L810.667 273.92v67.413A42.667 42.667 0 0 0 853.333 384 42.667 42.667 0 0 0 896 341.333V170.667A42.667 42.667 0 0 0 853.333 128H682.667a42.667 42.667 0 0 0 0 85.333z" />
  </svg>
);

const ExternalLinkIcon = React.forwardRef<HTMLSpanElement, ExternalIconProps>((props, ref) => (
  <Icon component={() => <SVGIcon color={props.color} />} ref={ref} {...props} />
));

export default ExternalLinkIcon;
