var typescript = (function (fs,path,os,crypto,module$1) {
fs = fs && fs.hasOwnProperty('default') ? fs['default'] : fs;
path = path && path.hasOwnProperty('default') ? path['default'] : path;
os = os && os.hasOwnProperty('default') ? os['default'] : os;
crypto = crypto && crypto.hasOwnProperty('default') ? crypto['default'] : crypto;
module$1 = module$1 && module$1.hasOwnProperty('default') ? module$1['default'] : module$1;

var global$1 = typeof global !== "undefined" ? global :
            typeof self !== "undefined" ? self :
            typeof window !== "undefined" ? window : {};

// shim for using process in browser
// based off https://github.com/defunctzombie/node-process/blob/master/browser.js

function defaultSetTimout() {
    throw new Error('setTimeout has not been defined');
}
function defaultClearTimeout () {
    throw new Error('clearTimeout has not been defined');
}
var cachedSetTimeout = defaultSetTimout;
var cachedClearTimeout = defaultClearTimeout;
if (typeof global$1.setTimeout === 'function') {
    cachedSetTimeout = setTimeout;
}
if (typeof global$1.clearTimeout === 'function') {
    cachedClearTimeout = clearTimeout;
}

function runTimeout(fun) {
    if (cachedSetTimeout === setTimeout) {
        //normal enviroments in sane situations
        return setTimeout(fun, 0);
    }
    // if setTimeout wasn't available but was latter defined
    if ((cachedSetTimeout === defaultSetTimout || !cachedSetTimeout) && setTimeout) {
        cachedSetTimeout = setTimeout;
        return setTimeout(fun, 0);
    }
    try {
        // when when somebody has screwed with setTimeout but no I.E. maddness
        return cachedSetTimeout(fun, 0);
    } catch(e){
        try {
            // When we are in I.E. but the script has been evaled so I.E. doesn't trust the global object when called normally
            return cachedSetTimeout.call(null, fun, 0);
        } catch(e){
            // same as above but when it's a version of I.E. that must have the global object for 'this', hopfully our context correct otherwise it will throw a global error
            return cachedSetTimeout.call(this, fun, 0);
        }
    }


}
function runClearTimeout(marker) {
    if (cachedClearTimeout === clearTimeout) {
        //normal enviroments in sane situations
        return clearTimeout(marker);
    }
    // if clearTimeout wasn't available but was latter defined
    if ((cachedClearTimeout === defaultClearTimeout || !cachedClearTimeout) && clearTimeout) {
        cachedClearTimeout = clearTimeout;
        return clearTimeout(marker);
    }
    try {
        // when when somebody has screwed with setTimeout but no I.E. maddness
        return cachedClearTimeout(marker);
    } catch (e){
        try {
            // When we are in I.E. but the script has been evaled so I.E. doesn't  trust the global object when called normally
            return cachedClearTimeout.call(null, marker);
        } catch (e){
            // same as above but when it's a version of I.E. that must have the global object for 'this', hopfully our context correct otherwise it will throw a global error.
            // Some versions of I.E. have different rules for clearTimeout vs setTimeout
            return cachedClearTimeout.call(this, marker);
        }
    }



}
var queue = [];
var draining = false;
var currentQueue;
var queueIndex = -1;

function cleanUpNextTick() {
    if (!draining || !currentQueue) {
        return;
    }
    draining = false;
    if (currentQueue.length) {
        queue = currentQueue.concat(queue);
    } else {
        queueIndex = -1;
    }
    if (queue.length) {
        drainQueue();
    }
}

function drainQueue() {
    if (draining) {
        return;
    }
    var timeout = runTimeout(cleanUpNextTick);
    draining = true;

    var len = queue.length;
    while(len) {
        currentQueue = queue;
        queue = [];
        while (++queueIndex < len) {
            if (currentQueue) {
                currentQueue[queueIndex].run();
            }
        }
        queueIndex = -1;
        len = queue.length;
    }
    currentQueue = null;
    draining = false;
    runClearTimeout(timeout);
}
function nextTick(fun) {
    var args = new Array(arguments.length - 1);
    if (arguments.length > 1) {
        for (var i = 1; i < arguments.length; i++) {
            args[i - 1] = arguments[i];
        }
    }
    queue.push(new Item(fun, args));
    if (queue.length === 1 && !draining) {
        runTimeout(drainQueue);
    }
}
// v8 likes predictible objects
function Item(fun, array) {
    this.fun = fun;
    this.array = array;
}
Item.prototype.run = function () {
    this.fun.apply(null, this.array);
};
var title = 'browser';
var platform = 'browser';
var browser = true;
var env = {};
var argv = [];
var version = ''; // empty string to avoid regexp issues
var versions = {};
var release = {};
var config = {};

function noop() {}

var on = noop;
var addListener = noop;
var once = noop;
var off = noop;
var removeListener = noop;
var removeAllListeners = noop;
var emit = noop;

function binding(name) {
    throw new Error('process.binding is not supported');
}

function cwd () { return '/' }
function chdir (dir) {
    throw new Error('process.chdir is not supported');
}
function umask() { return 0; }

// from https://github.com/kumavis/browser-process-hrtime/blob/master/index.js
var performance$1 = global$1.performance || {};
var performanceNow =
  performance$1.now        ||
  performance$1.mozNow     ||
  performance$1.msNow      ||
  performance$1.oNow       ||
  performance$1.webkitNow  ||
  function(){ return (new Date()).getTime() };

// generate timestamp or delta
// see http://nodejs.org/api/process.html#process_process_hrtime
function hrtime(previousTimestamp){
  var clocktime = performanceNow.call(performance$1)*1e-3;
  var seconds = Math.floor(clocktime);
  var nanoseconds = Math.floor((clocktime%1)*1e9);
  if (previousTimestamp) {
    seconds = seconds - previousTimestamp[0];
    nanoseconds = nanoseconds - previousTimestamp[1];
    if (nanoseconds<0) {
      seconds--;
      nanoseconds += 1e9;
    }
  }
  return [seconds,nanoseconds]
}

var startTime = new Date();
function uptime() {
  var currentTime = new Date();
  var dif = currentTime - startTime;
  return dif / 1000;
}

var process = {
  nextTick: nextTick,
  title: title,
  browser: browser,
  env: env,
  argv: argv,
  version: version,
  versions: versions,
  on: on,
  addListener: addListener,
  once: once,
  off: off,
  removeListener: removeListener,
  removeAllListeners: removeAllListeners,
  emit: emit,
  binding: binding,
  cwd: cwd,
  chdir: chdir,
  umask: umask,
  hrtime: hrtime,
  platform: platform,
  release: release,
  config: config,
  uptime: uptime
};

var __dirname = '/Users/jljsj/Documents/web/prettier/node_modules/prettier';

var __filename = '/Users/jljsj/Documents/web/prettier/node_modules/prettier/parser-typescript.js';

var browser$1 = true;

var lookup = [];
var revLookup = [];
var Arr = typeof Uint8Array !== 'undefined' ? Uint8Array : Array;
var inited = false;
function init () {
  inited = true;
  var code = 'ABCDEFGHIJKLMNOPQRSTUVWXYZabcdefghijklmnopqrstuvwxyz0123456789+/';
  for (var i = 0, len = code.length; i < len; ++i) {
    lookup[i] = code[i];
    revLookup[code.charCodeAt(i)] = i;
  }

  revLookup['-'.charCodeAt(0)] = 62;
  revLookup['_'.charCodeAt(0)] = 63;
}

function toByteArray (b64) {
  if (!inited) {
    init();
  }
  var i, j, l, tmp, placeHolders, arr;
  var len = b64.length;

  if (len % 4 > 0) {
    throw new Error('Invalid string. Length must be a multiple of 4')
  }

  // the number of equal signs (place holders)
  // if there are two placeholders, than the two characters before it
  // represent one byte
  // if there is only one, then the three characters before it represent 2 bytes
  // this is just a cheap hack to not do indexOf twice
  placeHolders = b64[len - 2] === '=' ? 2 : b64[len - 1] === '=' ? 1 : 0;

  // base64 is 4/3 + up to two characters of the original data
  arr = new Arr(len * 3 / 4 - placeHolders);

  // if there are placeholders, only get up to the last complete 4 chars
  l = placeHolders > 0 ? len - 4 : len;

  var L = 0;

  for (i = 0, j = 0; i < l; i += 4, j += 3) {
    tmp = (revLookup[b64.charCodeAt(i)] << 18) | (revLookup[b64.charCodeAt(i + 1)] << 12) | (revLookup[b64.charCodeAt(i + 2)] << 6) | revLookup[b64.charCodeAt(i + 3)];
    arr[L++] = (tmp >> 16) & 0xFF;
    arr[L++] = (tmp >> 8) & 0xFF;
    arr[L++] = tmp & 0xFF;
  }

  if (placeHolders === 2) {
    tmp = (revLookup[b64.charCodeAt(i)] << 2) | (revLookup[b64.charCodeAt(i + 1)] >> 4);
    arr[L++] = tmp & 0xFF;
  } else if (placeHolders === 1) {
    tmp = (revLookup[b64.charCodeAt(i)] << 10) | (revLookup[b64.charCodeAt(i + 1)] << 4) | (revLookup[b64.charCodeAt(i + 2)] >> 2);
    arr[L++] = (tmp >> 8) & 0xFF;
    arr[L++] = tmp & 0xFF;
  }

  return arr
}

function tripletToBase64 (num) {
  return lookup[num >> 18 & 0x3F] + lookup[num >> 12 & 0x3F] + lookup[num >> 6 & 0x3F] + lookup[num & 0x3F]
}

function encodeChunk (uint8, start, end) {
  var tmp;
  var output = [];
  for (var i = start; i < end; i += 3) {
    tmp = (uint8[i] << 16) + (uint8[i + 1] << 8) + (uint8[i + 2]);
    output.push(tripletToBase64(tmp));
  }
  return output.join('')
}

function fromByteArray (uint8) {
  if (!inited) {
    init();
  }
  var tmp;
  var len = uint8.length;
  var extraBytes = len % 3; // if we have 1 byte left, pad 2 bytes
  var output = '';
  var parts = [];
  var maxChunkLength = 16383; // must be multiple of 3

  // go through the array every three bytes, we'll deal with trailing stuff later
  for (var i = 0, len2 = len - extraBytes; i < len2; i += maxChunkLength) {
    parts.push(encodeChunk(uint8, i, (i + maxChunkLength) > len2 ? len2 : (i + maxChunkLength)));
  }

  // pad the end with zeros, but make sure to not forget the extra bytes
  if (extraBytes === 1) {
    tmp = uint8[len - 1];
    output += lookup[tmp >> 2];
    output += lookup[(tmp << 4) & 0x3F];
    output += '==';
  } else if (extraBytes === 2) {
    tmp = (uint8[len - 2] << 8) + (uint8[len - 1]);
    output += lookup[tmp >> 10];
    output += lookup[(tmp >> 4) & 0x3F];
    output += lookup[(tmp << 2) & 0x3F];
    output += '=';
  }

  parts.push(output);

  return parts.join('')
}

function read (buffer, offset, isLE, mLen, nBytes) {
  var e, m;
  var eLen = nBytes * 8 - mLen - 1;
  var eMax = (1 << eLen) - 1;
  var eBias = eMax >> 1;
  var nBits = -7;
  var i = isLE ? (nBytes - 1) : 0;
  var d = isLE ? -1 : 1;
  var s = buffer[offset + i];

  i += d;

  e = s & ((1 << (-nBits)) - 1);
  s >>= (-nBits);
  nBits += eLen;
  for (; nBits > 0; e = e * 256 + buffer[offset + i], i += d, nBits -= 8) {}

  m = e & ((1 << (-nBits)) - 1);
  e >>= (-nBits);
  nBits += mLen;
  for (; nBits > 0; m = m * 256 + buffer[offset + i], i += d, nBits -= 8) {}

  if (e === 0) {
    e = 1 - eBias;
  } else if (e === eMax) {
    return m ? NaN : ((s ? -1 : 1) * Infinity)
  } else {
    m = m + Math.pow(2, mLen);
    e = e - eBias;
  }
  return (s ? -1 : 1) * m * Math.pow(2, e - mLen)
}

function write (buffer, value, offset, isLE, mLen, nBytes) {
  var e, m, c;
  var eLen = nBytes * 8 - mLen - 1;
  var eMax = (1 << eLen) - 1;
  var eBias = eMax >> 1;
  var rt = (mLen === 23 ? Math.pow(2, -24) - Math.pow(2, -77) : 0);
  var i = isLE ? 0 : (nBytes - 1);
  var d = isLE ? 1 : -1;
  var s = value < 0 || (value === 0 && 1 / value < 0) ? 1 : 0;

  value = Math.abs(value);

  if (isNaN(value) || value === Infinity) {
    m = isNaN(value) ? 1 : 0;
    e = eMax;
  } else {
    e = Math.floor(Math.log(value) / Math.LN2);
    if (value * (c = Math.pow(2, -e)) < 1) {
      e--;
      c *= 2;
    }
    if (e + eBias >= 1) {
      value += rt / c;
    } else {
      value += rt * Math.pow(2, 1 - eBias);
    }
    if (value * c >= 2) {
      e++;
      c /= 2;
    }

    if (e + eBias >= eMax) {
      m = 0;
      e = eMax;
    } else if (e + eBias >= 1) {
      m = (value * c - 1) * Math.pow(2, mLen);
      e = e + eBias;
    } else {
      m = value * Math.pow(2, eBias - 1) * Math.pow(2, mLen);
      e = 0;
    }
  }

  for (; mLen >= 8; buffer[offset + i] = m & 0xff, i += d, m /= 256, mLen -= 8) {}

  e = (e << mLen) | m;
  eLen += mLen;
  for (; eLen > 0; buffer[offset + i] = e & 0xff, i += d, e /= 256, eLen -= 8) {}

  buffer[offset + i - d] |= s * 128;
}

var toString = {}.toString;

var isArray = Array.isArray || function (arr) {
  return toString.call(arr) == '[object Array]';
};

/*!
 * The buffer module from node.js, for the browser.
 *
 * @author   Feross Aboukhadijeh <feross@feross.org> <http://feross.org>
 * @license  MIT
 */
/* eslint-disable no-proto */


var INSPECT_MAX_BYTES = 50;

/**
 * If `Buffer.TYPED_ARRAY_SUPPORT`:
 *   === true    Use Uint8Array implementation (fastest)
 *   === false   Use Object implementation (most compatible, even IE6)
 *
 * Browsers that support typed arrays are IE 10+, Firefox 4+, Chrome 7+, Safari 5.1+,
 * Opera 11.6+, iOS 4.2+.
 *
 * Due to various browser bugs, sometimes the Object implementation will be used even
 * when the browser supports typed arrays.
 *
 * Note:
 *
 *   - Firefox 4-29 lacks support for adding new properties to `Uint8Array` instances,
 *     See: https://bugzilla.mozilla.org/show_bug.cgi?id=695438.
 *
 *   - Chrome 9-10 is missing the `TypedArray.prototype.subarray` function.
 *
 *   - IE10 has a broken `TypedArray.prototype.subarray` function which returns arrays of
 *     incorrect length in some situations.

 * We detect these buggy browsers and set `Buffer.TYPED_ARRAY_SUPPORT` to `false` so they
 * get the Object implementation, which is slower but behaves correctly.
 */
Buffer.TYPED_ARRAY_SUPPORT = global$1.TYPED_ARRAY_SUPPORT !== undefined
  ? global$1.TYPED_ARRAY_SUPPORT
  : true;

function kMaxLength () {
  return Buffer.TYPED_ARRAY_SUPPORT
    ? 0x7fffffff
    : 0x3fffffff
}

function createBuffer (that, length) {
  if (kMaxLength() < length) {
    throw new RangeError('Invalid typed array length')
  }
  if (Buffer.TYPED_ARRAY_SUPPORT) {
    // Return an augmented `Uint8Array` instance, for best performance
    that = new Uint8Array(length);
    that.__proto__ = Buffer.prototype;
  } else {
    // Fallback: Return an object instance of the Buffer class
    if (that === null) {
      that = new Buffer(length);
    }
    that.length = length;
  }

  return that
}

/**
 * The Buffer constructor returns instances of `Uint8Array` that have their
 * prototype changed to `Buffer.prototype`. Furthermore, `Buffer` is a subclass of
 * `Uint8Array`, so the returned instances will have all the node `Buffer` methods
 * and the `Uint8Array` methods. Square bracket notation works as expected -- it
 * returns a single octet.
 *
 * The `Uint8Array` prototype remains unmodified.
 */

function Buffer (arg, encodingOrOffset, length) {
  if (!Buffer.TYPED_ARRAY_SUPPORT && !(this instanceof Buffer)) {
    return new Buffer(arg, encodingOrOffset, length)
  }

  // Common case.
  if (typeof arg === 'number') {
    if (typeof encodingOrOffset === 'string') {
      throw new Error(
        'If encoding is specified then the first argument must be a string'
      )
    }
    return allocUnsafe(this, arg)
  }
  return from(this, arg, encodingOrOffset, length)
}

Buffer.poolSize = 8192; // not used by this implementation

// TODO: Legacy, not needed anymore. Remove in next major version.
Buffer._augment = function (arr) {
  arr.__proto__ = Buffer.prototype;
  return arr
};

function from (that, value, encodingOrOffset, length) {
  if (typeof value === 'number') {
    throw new TypeError('"value" argument must not be a number')
  }

  if (typeof ArrayBuffer !== 'undefined' && value instanceof ArrayBuffer) {
    return fromArrayBuffer(that, value, encodingOrOffset, length)
  }

  if (typeof value === 'string') {
    return fromString(that, value, encodingOrOffset)
  }

  return fromObject(that, value)
}

/**
 * Functionally equivalent to Buffer(arg, encoding) but throws a TypeError
 * if value is a number.
 * Buffer.from(str[, encoding])
 * Buffer.from(array)
 * Buffer.from(buffer)
 * Buffer.from(arrayBuffer[, byteOffset[, length]])
 **/
Buffer.from = function (value, encodingOrOffset, length) {
  return from(null, value, encodingOrOffset, length)
};

if (Buffer.TYPED_ARRAY_SUPPORT) {
  Buffer.prototype.__proto__ = Uint8Array.prototype;
  Buffer.__proto__ = Uint8Array;
  if (typeof Symbol !== 'undefined' && Symbol.species &&
      Buffer[Symbol.species] === Buffer) {
    // Fix subarray() in ES2016. See: https://github.com/feross/buffer/pull/97
    // Object.defineProperty(Buffer, Symbol.species, {
    //   value: null,
    //   configurable: true
    // })
  }
}

function assertSize (size) {
  if (typeof size !== 'number') {
    throw new TypeError('"size" argument must be a number')
  } else if (size < 0) {
    throw new RangeError('"size" argument must not be negative')
  }
}

function alloc (that, size, fill, encoding) {
  assertSize(size);
  if (size <= 0) {
    return createBuffer(that, size)
  }
  if (fill !== undefined) {
    // Only pay attention to encoding if it's a string. This
    // prevents accidentally sending in a number that would
    // be interpretted as a start offset.
    return typeof encoding === 'string'
      ? createBuffer(that, size).fill(fill, encoding)
      : createBuffer(that, size).fill(fill)
  }
  return createBuffer(that, size)
}

/**
 * Creates a new filled Buffer instance.
 * alloc(size[, fill[, encoding]])
 **/
Buffer.alloc = function (size, fill, encoding) {
  return alloc(null, size, fill, encoding)
};

function allocUnsafe (that, size) {
  assertSize(size);
  that = createBuffer(that, size < 0 ? 0 : checked(size) | 0);
  if (!Buffer.TYPED_ARRAY_SUPPORT) {
    for (var i = 0; i < size; ++i) {
      that[i] = 0;
    }
  }
  return that
}

/**
 * Equivalent to Buffer(num), by default creates a non-zero-filled Buffer instance.
 * */
Buffer.allocUnsafe = function (size) {
  return allocUnsafe(null, size)
};
/**
 * Equivalent to SlowBuffer(num), by default creates a non-zero-filled Buffer instance.
 */
Buffer.allocUnsafeSlow = function (size) {
  return allocUnsafe(null, size)
};

function fromString (that, string, encoding) {
  if (typeof encoding !== 'string' || encoding === '') {
    encoding = 'utf8';
  }

  if (!Buffer.isEncoding(encoding)) {
    throw new TypeError('"encoding" must be a valid string encoding')
  }

  var length = byteLength(string, encoding) | 0;
  that = createBuffer(that, length);

  var actual = that.write(string, encoding);

  if (actual !== length) {
    // Writing a hex string, for example, that contains invalid characters will
    // cause everything after the first invalid character to be ignored. (e.g.
    // 'abxxcd' will be treated as 'ab')
    that = that.slice(0, actual);
  }

  return that
}

function fromArrayLike (that, array) {
  var length = array.length < 0 ? 0 : checked(array.length) | 0;
  that = createBuffer(that, length);
  for (var i = 0; i < length; i += 1) {
    that[i] = array[i] & 255;
  }
  return that
}

function fromArrayBuffer (that, array, byteOffset, length) {
  array.byteLength; // this throws if `array` is not a valid ArrayBuffer

  if (byteOffset < 0 || array.byteLength < byteOffset) {
    throw new RangeError('\'offset\' is out of bounds')
  }

  if (array.byteLength < byteOffset + (length || 0)) {
    throw new RangeError('\'length\' is out of bounds')
  }

  if (byteOffset === undefined && length === undefined) {
    array = new Uint8Array(array);
  } else if (length === undefined) {
    array = new Uint8Array(array, byteOffset);
  } else {
    array = new Uint8Array(array, byteOffset, length);
  }

  if (Buffer.TYPED_ARRAY_SUPPORT) {
    // Return an augmented `Uint8Array` instance, for best performance
    that = array;
    that.__proto__ = Buffer.prototype;
  } else {
    // Fallback: Return an object instance of the Buffer class
    that = fromArrayLike(that, array);
  }
  return that
}

function fromObject (that, obj) {
  if (internalIsBuffer(obj)) {
    var len = checked(obj.length) | 0;
    that = createBuffer(that, len);

    if (that.length === 0) {
      return that
    }

    obj.copy(that, 0, 0, len);
    return that
  }

  if (obj) {
    if ((typeof ArrayBuffer !== 'undefined' &&
        obj.buffer instanceof ArrayBuffer) || 'length' in obj) {
      if (typeof obj.length !== 'number' || isnan(obj.length)) {
        return createBuffer(that, 0)
      }
      return fromArrayLike(that, obj)
    }

    if (obj.type === 'Buffer' && isArray(obj.data)) {
      return fromArrayLike(that, obj.data)
    }
  }

  throw new TypeError('First argument must be a string, Buffer, ArrayBuffer, Array, or array-like object.')
}

function checked (length) {
  // Note: cannot use `length < kMaxLength()` here because that fails when
  // length is NaN (which is otherwise coerced to zero.)
  if (length >= kMaxLength()) {
    throw new RangeError('Attempt to allocate Buffer larger than maximum ' +
                         'size: 0x' + kMaxLength().toString(16) + ' bytes')
  }
  return length | 0
}


Buffer.isBuffer = isBuffer;
function internalIsBuffer (b) {
  return !!(b != null && b._isBuffer)
}

Buffer.compare = function compare (a, b) {
  if (!internalIsBuffer(a) || !internalIsBuffer(b)) {
    throw new TypeError('Arguments must be Buffers')
  }

  if (a === b) return 0

  var x = a.length;
  var y = b.length;

  for (var i = 0, len = Math.min(x, y); i < len; ++i) {
    if (a[i] !== b[i]) {
      x = a[i];
      y = b[i];
      break
    }
  }

  if (x < y) return -1
  if (y < x) return 1
  return 0
};

Buffer.isEncoding = function isEncoding (encoding) {
  switch (String(encoding).toLowerCase()) {
    case 'hex':
    case 'utf8':
    case 'utf-8':
    case 'ascii':
    case 'latin1':
    case 'binary':
    case 'base64':
    case 'ucs2':
    case 'ucs-2':
    case 'utf16le':
    case 'utf-16le':
      return true
    default:
      return false
  }
};

Buffer.concat = function concat (list, length) {
  if (!isArray(list)) {
    throw new TypeError('"list" argument must be an Array of Buffers')
  }

  if (list.length === 0) {
    return Buffer.alloc(0)
  }

  var i;
  if (length === undefined) {
    length = 0;
    for (i = 0; i < list.length; ++i) {
      length += list[i].length;
    }
  }

  var buffer = Buffer.allocUnsafe(length);
  var pos = 0;
  for (i = 0; i < list.length; ++i) {
    var buf = list[i];
    if (!internalIsBuffer(buf)) {
      throw new TypeError('"list" argument must be an Array of Buffers')
    }
    buf.copy(buffer, pos);
    pos += buf.length;
  }
  return buffer
};

function byteLength (string, encoding) {
  if (internalIsBuffer(string)) {
    return string.length
  }
  if (typeof ArrayBuffer !== 'undefined' && typeof ArrayBuffer.isView === 'function' &&
      (ArrayBuffer.isView(string) || string instanceof ArrayBuffer)) {
    return string.byteLength
  }
  if (typeof string !== 'string') {
    string = '' + string;
  }

  var len = string.length;
  if (len === 0) return 0

  // Use a for loop to avoid recursion
  var loweredCase = false;
  for (;;) {
    switch (encoding) {
      case 'ascii':
      case 'latin1':
      case 'binary':
        return len
      case 'utf8':
      case 'utf-8':
      case undefined:
        return utf8ToBytes(string).length
      case 'ucs2':
      case 'ucs-2':
      case 'utf16le':
      case 'utf-16le':
        return len * 2
      case 'hex':
        return len >>> 1
      case 'base64':
        return base64ToBytes(string).length
      default:
        if (loweredCase) return utf8ToBytes(string).length // assume utf8
        encoding = ('' + encoding).toLowerCase();
        loweredCase = true;
    }
  }
}
Buffer.byteLength = byteLength;

function slowToString (encoding, start, end) {
  var loweredCase = false;

  // No need to verify that "this.length <= MAX_UINT32" since it's a read-only
  // property of a typed array.

  // This behaves neither like String nor Uint8Array in that we set start/end
  // to their upper/lower bounds if the value passed is out of range.
  // undefined is handled specially as per ECMA-262 6th Edition,
  // Section 13.3.3.7 Runtime Semantics: KeyedBindingInitialization.
  if (start === undefined || start < 0) {
    start = 0;
  }
  // Return early if start > this.length. Done here to prevent potential uint32
  // coercion fail below.
  if (start > this.length) {
    return ''
  }

  if (end === undefined || end > this.length) {
    end = this.length;
  }

  if (end <= 0) {
    return ''
  }

  // Force coersion to uint32. This will also coerce falsey/NaN values to 0.
  end >>>= 0;
  start >>>= 0;

  if (end <= start) {
    return ''
  }

  if (!encoding) encoding = 'utf8';

  while (true) {
    switch (encoding) {
      case 'hex':
        return hexSlice(this, start, end)

      case 'utf8':
      case 'utf-8':
        return utf8Slice(this, start, end)

      case 'ascii':
        return asciiSlice(this, start, end)

      case 'latin1':
      case 'binary':
        return latin1Slice(this, start, end)

      case 'base64':
        return base64Slice(this, start, end)

      case 'ucs2':
      case 'ucs-2':
      case 'utf16le':
      case 'utf-16le':
        return utf16leSlice(this, start, end)

      default:
        if (loweredCase) throw new TypeError('Unknown encoding: ' + encoding)
        encoding = (encoding + '').toLowerCase();
        loweredCase = true;
    }
  }
}

// The property is used by `Buffer.isBuffer` and `is-buffer` (in Safari 5-7) to detect
// Buffer instances.
Buffer.prototype._isBuffer = true;

function swap (b, n, m) {
  var i = b[n];
  b[n] = b[m];
  b[m] = i;
}

Buffer.prototype.swap16 = function swap16 () {
  var len = this.length;
  if (len % 2 !== 0) {
    throw new RangeError('Buffer size must be a multiple of 16-bits')
  }
  for (var i = 0; i < len; i += 2) {
    swap(this, i, i + 1);
  }
  return this
};

Buffer.prototype.swap32 = function swap32 () {
  var len = this.length;
  if (len % 4 !== 0) {
    throw new RangeError('Buffer size must be a multiple of 32-bits')
  }
  for (var i = 0; i < len; i += 4) {
    swap(this, i, i + 3);
    swap(this, i + 1, i + 2);
  }
  return this
};

Buffer.prototype.swap64 = function swap64 () {
  var len = this.length;
  if (len % 8 !== 0) {
    throw new RangeError('Buffer size must be a multiple of 64-bits')
  }
  for (var i = 0; i < len; i += 8) {
    swap(this, i, i + 7);
    swap(this, i + 1, i + 6);
    swap(this, i + 2, i + 5);
    swap(this, i + 3, i + 4);
  }
  return this
};

Buffer.prototype.toString = function toString () {
  var length = this.length | 0;
  if (length === 0) return ''
  if (arguments.length === 0) return utf8Slice(this, 0, length)
  return slowToString.apply(this, arguments)
};

Buffer.prototype.equals = function equals (b) {
  if (!internalIsBuffer(b)) throw new TypeError('Argument must be a Buffer')
  if (this === b) return true
  return Buffer.compare(this, b) === 0
};

Buffer.prototype.inspect = function inspect () {
  var str = '';
  var max = INSPECT_MAX_BYTES;
  if (this.length > 0) {
    str = this.toString('hex', 0, max).match(/.{2}/g).join(' ');
    if (this.length > max) str += ' ... ';
  }
  return '<Buffer ' + str + '>'
};

Buffer.prototype.compare = function compare (target, start, end, thisStart, thisEnd) {
  if (!internalIsBuffer(target)) {
    throw new TypeError('Argument must be a Buffer')
  }

  if (start === undefined) {
    start = 0;
  }
  if (end === undefined) {
    end = target ? target.length : 0;
  }
  if (thisStart === undefined) {
    thisStart = 0;
  }
  if (thisEnd === undefined) {
    thisEnd = this.length;
  }

  if (start < 0 || end > target.length || thisStart < 0 || thisEnd > this.length) {
    throw new RangeError('out of range index')
  }

  if (thisStart >= thisEnd && start >= end) {
    return 0
  }
  if (thisStart >= thisEnd) {
    return -1
  }
  if (start >= end) {
    return 1
  }

  start >>>= 0;
  end >>>= 0;
  thisStart >>>= 0;
  thisEnd >>>= 0;

  if (this === target) return 0

  var x = thisEnd - thisStart;
  var y = end - start;
  var len = Math.min(x, y);

  var thisCopy = this.slice(thisStart, thisEnd);
  var targetCopy = target.slice(start, end);

  for (var i = 0; i < len; ++i) {
    if (thisCopy[i] !== targetCopy[i]) {
      x = thisCopy[i];
      y = targetCopy[i];
      break
    }
  }

  if (x < y) return -1
  if (y < x) return 1
  return 0
};

// Finds either the first index of `val` in `buffer` at offset >= `byteOffset`,
// OR the last index of `val` in `buffer` at offset <= `byteOffset`.
//
// Arguments:
// - buffer - a Buffer to search
// - val - a string, Buffer, or number
// - byteOffset - an index into `buffer`; will be clamped to an int32
// - encoding - an optional encoding, relevant is val is a string
// - dir - true for indexOf, false for lastIndexOf
function bidirectionalIndexOf (buffer, val, byteOffset, encoding, dir) {
  // Empty buffer means no match
  if (buffer.length === 0) return -1

  // Normalize byteOffset
  if (typeof byteOffset === 'string') {
    encoding = byteOffset;
    byteOffset = 0;
  } else if (byteOffset > 0x7fffffff) {
    byteOffset = 0x7fffffff;
  } else if (byteOffset < -0x80000000) {
    byteOffset = -0x80000000;
  }
  byteOffset = +byteOffset;  // Coerce to Number.
  if (isNaN(byteOffset)) {
    // byteOffset: it it's undefined, null, NaN, "foo", etc, search whole buffer
    byteOffset = dir ? 0 : (buffer.length - 1);
  }

  // Normalize byteOffset: negative offsets start from the end of the buffer
  if (byteOffset < 0) byteOffset = buffer.length + byteOffset;
  if (byteOffset >= buffer.length) {
    if (dir) return -1
    else byteOffset = buffer.length - 1;
  } else if (byteOffset < 0) {
    if (dir) byteOffset = 0;
    else return -1
  }

  // Normalize val
  if (typeof val === 'string') {
    val = Buffer.from(val, encoding);
  }

  // Finally, search either indexOf (if dir is true) or lastIndexOf
  if (internalIsBuffer(val)) {
    // Special case: looking for empty string/buffer always fails
    if (val.length === 0) {
      return -1
    }
    return arrayIndexOf(buffer, val, byteOffset, encoding, dir)
  } else if (typeof val === 'number') {
    val = val & 0xFF; // Search for a byte value [0-255]
    if (Buffer.TYPED_ARRAY_SUPPORT &&
        typeof Uint8Array.prototype.indexOf === 'function') {
      if (dir) {
        return Uint8Array.prototype.indexOf.call(buffer, val, byteOffset)
      } else {
        return Uint8Array.prototype.lastIndexOf.call(buffer, val, byteOffset)
      }
    }
    return arrayIndexOf(buffer, [ val ], byteOffset, encoding, dir)
  }

  throw new TypeError('val must be string, number or Buffer')
}

function arrayIndexOf (arr, val, byteOffset, encoding, dir) {
  var indexSize = 1;
  var arrLength = arr.length;
  var valLength = val.length;

  if (encoding !== undefined) {
    encoding = String(encoding).toLowerCase();
    if (encoding === 'ucs2' || encoding === 'ucs-2' ||
        encoding === 'utf16le' || encoding === 'utf-16le') {
      if (arr.length < 2 || val.length < 2) {
        return -1
      }
      indexSize = 2;
      arrLength /= 2;
      valLength /= 2;
      byteOffset /= 2;
    }
  }

  function read$$1 (buf, i) {
    if (indexSize === 1) {
      return buf[i]
    } else {
      return buf.readUInt16BE(i * indexSize)
    }
  }

  var i;
  if (dir) {
    var foundIndex = -1;
    for (i = byteOffset; i < arrLength; i++) {
      if (read$$1(arr, i) === read$$1(val, foundIndex === -1 ? 0 : i - foundIndex)) {
        if (foundIndex === -1) foundIndex = i;
        if (i - foundIndex + 1 === valLength) return foundIndex * indexSize
      } else {
        if (foundIndex !== -1) i -= i - foundIndex;
        foundIndex = -1;
      }
    }
  } else {
    if (byteOffset + valLength > arrLength) byteOffset = arrLength - valLength;
    for (i = byteOffset; i >= 0; i--) {
      var found = true;
      for (var j = 0; j < valLength; j++) {
        if (read$$1(arr, i + j) !== read$$1(val, j)) {
          found = false;
          break
        }
      }
      if (found) return i
    }
  }

  return -1
}

Buffer.prototype.includes = function includes (val, byteOffset, encoding) {
  return this.indexOf(val, byteOffset, encoding) !== -1
};

Buffer.prototype.indexOf = function indexOf (val, byteOffset, encoding) {
  return bidirectionalIndexOf(this, val, byteOffset, encoding, true)
};

Buffer.prototype.lastIndexOf = function lastIndexOf (val, byteOffset, encoding) {
  return bidirectionalIndexOf(this, val, byteOffset, encoding, false)
};

function hexWrite (buf, string, offset, length) {
  offset = Number(offset) || 0;
  var remaining = buf.length - offset;
  if (!length) {
    length = remaining;
  } else {
    length = Number(length);
    if (length > remaining) {
      length = remaining;
    }
  }

  // must be an even number of digits
  var strLen = string.length;
  if (strLen % 2 !== 0) throw new TypeError('Invalid hex string')

  if (length > strLen / 2) {
    length = strLen / 2;
  }
  for (var i = 0; i < length; ++i) {
    var parsed = parseInt(string.substr(i * 2, 2), 16);
    if (isNaN(parsed)) return i
    buf[offset + i] = parsed;
  }
  return i
}

function utf8Write (buf, string, offset, length) {
  return blitBuffer(utf8ToBytes(string, buf.length - offset), buf, offset, length)
}

function asciiWrite (buf, string, offset, length) {
  return blitBuffer(asciiToBytes(string), buf, offset, length)
}

function latin1Write (buf, string, offset, length) {
  return asciiWrite(buf, string, offset, length)
}

function base64Write (buf, string, offset, length) {
  return blitBuffer(base64ToBytes(string), buf, offset, length)
}

function ucs2Write (buf, string, offset, length) {
  return blitBuffer(utf16leToBytes(string, buf.length - offset), buf, offset, length)
}

Buffer.prototype.write = function write$$1 (string, offset, length, encoding) {
  // Buffer#write(string)
  if (offset === undefined) {
    encoding = 'utf8';
    length = this.length;
    offset = 0;
  // Buffer#write(string, encoding)
  } else if (length === undefined && typeof offset === 'string') {
    encoding = offset;
    length = this.length;
    offset = 0;
  // Buffer#write(string, offset[, length][, encoding])
  } else if (isFinite(offset)) {
    offset = offset | 0;
    if (isFinite(length)) {
      length = length | 0;
      if (encoding === undefined) encoding = 'utf8';
    } else {
      encoding = length;
      length = undefined;
    }
  // legacy write(string, encoding, offset, length) - remove in v0.13
  } else {
    throw new Error(
      'Buffer.write(string, encoding, offset[, length]) is no longer supported'
    )
  }

  var remaining = this.length - offset;
  if (length === undefined || length > remaining) length = remaining;

  if ((string.length > 0 && (length < 0 || offset < 0)) || offset > this.length) {
    throw new RangeError('Attempt to write outside buffer bounds')
  }

  if (!encoding) encoding = 'utf8';

  var loweredCase = false;
  for (;;) {
    switch (encoding) {
      case 'hex':
        return hexWrite(this, string, offset, length)

      case 'utf8':
      case 'utf-8':
        return utf8Write(this, string, offset, length)

      case 'ascii':
        return asciiWrite(this, string, offset, length)

      case 'latin1':
      case 'binary':
        return latin1Write(this, string, offset, length)

      case 'base64':
        // Warning: maxLength not taken into account in base64Write
        return base64Write(this, string, offset, length)

      case 'ucs2':
      case 'ucs-2':
      case 'utf16le':
      case 'utf-16le':
        return ucs2Write(this, string, offset, length)

      default:
        if (loweredCase) throw new TypeError('Unknown encoding: ' + encoding)
        encoding = ('' + encoding).toLowerCase();
        loweredCase = true;
    }
  }
};

Buffer.prototype.toJSON = function toJSON () {
  return {
    type: 'Buffer',
    data: Array.prototype.slice.call(this._arr || this, 0)
  }
};

function base64Slice (buf, start, end) {
  if (start === 0 && end === buf.length) {
    return fromByteArray(buf)
  } else {
    return fromByteArray(buf.slice(start, end))
  }
}

function utf8Slice (buf, start, end) {
  end = Math.min(buf.length, end);
  var res = [];

  var i = start;
  while (i < end) {
    var firstByte = buf[i];
    var codePoint = null;
    var bytesPerSequence = (firstByte > 0xEF) ? 4
      : (firstByte > 0xDF) ? 3
      : (firstByte > 0xBF) ? 2
      : 1;

    if (i + bytesPerSequence <= end) {
      var secondByte, thirdByte, fourthByte, tempCodePoint;

      switch (bytesPerSequence) {
        case 1:
          if (firstByte < 0x80) {
            codePoint = firstByte;
          }
          break
        case 2:
          secondByte = buf[i + 1];
          if ((secondByte & 0xC0) === 0x80) {
            tempCodePoint = (firstByte & 0x1F) << 0x6 | (secondByte & 0x3F);
            if (tempCodePoint > 0x7F) {
              codePoint = tempCodePoint;
            }
          }
          break
        case 3:
          secondByte = buf[i + 1];
          thirdByte = buf[i + 2];
          if ((secondByte & 0xC0) === 0x80 && (thirdByte & 0xC0) === 0x80) {
            tempCodePoint = (firstByte & 0xF) << 0xC | (secondByte & 0x3F) << 0x6 | (thirdByte & 0x3F);
            if (tempCodePoint > 0x7FF && (tempCodePoint < 0xD800 || tempCodePoint > 0xDFFF)) {
              codePoint = tempCodePoint;
            }
          }
          break
        case 4:
          secondByte = buf[i + 1];
          thirdByte = buf[i + 2];
          fourthByte = buf[i + 3];
          if ((secondByte & 0xC0) === 0x80 && (thirdByte & 0xC0) === 0x80 && (fourthByte & 0xC0) === 0x80) {
            tempCodePoint = (firstByte & 0xF) << 0x12 | (secondByte & 0x3F) << 0xC | (thirdByte & 0x3F) << 0x6 | (fourthByte & 0x3F);
            if (tempCodePoint > 0xFFFF && tempCodePoint < 0x110000) {
              codePoint = tempCodePoint;
            }
          }
      }
    }

    if (codePoint === null) {
      // we did not generate a valid codePoint so insert a
      // replacement char (U+FFFD) and advance only 1 byte
      codePoint = 0xFFFD;
      bytesPerSequence = 1;
    } else if (codePoint > 0xFFFF) {
      // encode to utf16 (surrogate pair dance)
      codePoint -= 0x10000;
      res.push(codePoint >>> 10 & 0x3FF | 0xD800);
      codePoint = 0xDC00 | codePoint & 0x3FF;
    }

    res.push(codePoint);
    i += bytesPerSequence;
  }

  return decodeCodePointsArray(res)
}

// Based on http://stackoverflow.com/a/22747272/680742, the browser with
// the lowest limit is Chrome, with 0x10000 args.
// We go 1 magnitude less, for safety
var MAX_ARGUMENTS_LENGTH = 0x1000;

function decodeCodePointsArray (codePoints) {
  var len = codePoints.length;
  if (len <= MAX_ARGUMENTS_LENGTH) {
    return String.fromCharCode.apply(String, codePoints) // avoid extra slice()
  }

  // Decode in chunks to avoid "call stack size exceeded".
  var res = '';
  var i = 0;
  while (i < len) {
    res += String.fromCharCode.apply(
      String,
      codePoints.slice(i, i += MAX_ARGUMENTS_LENGTH)
    );
  }
  return res
}

function asciiSlice (buf, start, end) {
  var ret = '';
  end = Math.min(buf.length, end);

  for (var i = start; i < end; ++i) {
    ret += String.fromCharCode(buf[i] & 0x7F);
  }
  return ret
}

function latin1Slice (buf, start, end) {
  var ret = '';
  end = Math.min(buf.length, end);

  for (var i = start; i < end; ++i) {
    ret += String.fromCharCode(buf[i]);
  }
  return ret
}

function hexSlice (buf, start, end) {
  var len = buf.length;

  if (!start || start < 0) start = 0;
  if (!end || end < 0 || end > len) end = len;

  var out = '';
  for (var i = start; i < end; ++i) {
    out += toHex(buf[i]);
  }
  return out
}

function utf16leSlice (buf, start, end) {
  var bytes = buf.slice(start, end);
  var res = '';
  for (var i = 0; i < bytes.length; i += 2) {
    res += String.fromCharCode(bytes[i] + bytes[i + 1] * 256);
  }
  return res
}

Buffer.prototype.slice = function slice (start, end) {
  var len = this.length;
  start = ~~start;
  end = end === undefined ? len : ~~end;

  if (start < 0) {
    start += len;
    if (start < 0) start = 0;
  } else if (start > len) {
    start = len;
  }

  if (end < 0) {
    end += len;
    if (end < 0) end = 0;
  } else if (end > len) {
    end = len;
  }

  if (end < start) end = start;

  var newBuf;
  if (Buffer.TYPED_ARRAY_SUPPORT) {
    newBuf = this.subarray(start, end);
    newBuf.__proto__ = Buffer.prototype;
  } else {
    var sliceLen = end - start;
    newBuf = new Buffer(sliceLen, undefined);
    for (var i = 0; i < sliceLen; ++i) {
      newBuf[i] = this[i + start];
    }
  }

  return newBuf
};

/*
 * Need to make sure that buffer isn't trying to write out of bounds.
 */
function checkOffset (offset, ext, length) {
  if ((offset % 1) !== 0 || offset < 0) throw new RangeError('offset is not uint')
  if (offset + ext > length) throw new RangeError('Trying to access beyond buffer length')
}

Buffer.prototype.readUIntLE = function readUIntLE (offset, byteLength, noAssert) {
  offset = offset | 0;
  byteLength = byteLength | 0;
  if (!noAssert) checkOffset(offset, byteLength, this.length);

  var val = this[offset];
  var mul = 1;
  var i = 0;
  while (++i < byteLength && (mul *= 0x100)) {
    val += this[offset + i] * mul;
  }

  return val
};

Buffer.prototype.readUIntBE = function readUIntBE (offset, byteLength, noAssert) {
  offset = offset | 0;
  byteLength = byteLength | 0;
  if (!noAssert) {
    checkOffset(offset, byteLength, this.length);
  }

  var val = this[offset + --byteLength];
  var mul = 1;
  while (byteLength > 0 && (mul *= 0x100)) {
    val += this[offset + --byteLength] * mul;
  }

  return val
};

Buffer.prototype.readUInt8 = function readUInt8 (offset, noAssert) {
  if (!noAssert) checkOffset(offset, 1, this.length);
  return this[offset]
};

Buffer.prototype.readUInt16LE = function readUInt16LE (offset, noAssert) {
  if (!noAssert) checkOffset(offset, 2, this.length);
  return this[offset] | (this[offset + 1] << 8)
};

Buffer.prototype.readUInt16BE = function readUInt16BE (offset, noAssert) {
  if (!noAssert) checkOffset(offset, 2, this.length);
  return (this[offset] << 8) | this[offset + 1]
};

Buffer.prototype.readUInt32LE = function readUInt32LE (offset, noAssert) {
  if (!noAssert) checkOffset(offset, 4, this.length);

  return ((this[offset]) |
      (this[offset + 1] << 8) |
      (this[offset + 2] << 16)) +
      (this[offset + 3] * 0x1000000)
};

Buffer.prototype.readUInt32BE = function readUInt32BE (offset, noAssert) {
  if (!noAssert) checkOffset(offset, 4, this.length);

  return (this[offset] * 0x1000000) +
    ((this[offset + 1] << 16) |
    (this[offset + 2] << 8) |
    this[offset + 3])
};

Buffer.prototype.readIntLE = function readIntLE (offset, byteLength, noAssert) {
  offset = offset | 0;
  byteLength = byteLength | 0;
  if (!noAssert) checkOffset(offset, byteLength, this.length);

  var val = this[offset];
  var mul = 1;
  var i = 0;
  while (++i < byteLength && (mul *= 0x100)) {
    val += this[offset + i] * mul;
  }
  mul *= 0x80;

  if (val >= mul) val -= Math.pow(2, 8 * byteLength);

  return val
};

Buffer.prototype.readIntBE = function readIntBE (offset, byteLength, noAssert) {
  offset = offset | 0;
  byteLength = byteLength | 0;
  if (!noAssert) checkOffset(offset, byteLength, this.length);

  var i = byteLength;
  var mul = 1;
  var val = this[offset + --i];
  while (i > 0 && (mul *= 0x100)) {
    val += this[offset + --i] * mul;
  }
  mul *= 0x80;

  if (val >= mul) val -= Math.pow(2, 8 * byteLength);

  return val
};

Buffer.prototype.readInt8 = function readInt8 (offset, noAssert) {
  if (!noAssert) checkOffset(offset, 1, this.length);
  if (!(this[offset] & 0x80)) return (this[offset])
  return ((0xff - this[offset] + 1) * -1)
};

Buffer.prototype.readInt16LE = function readInt16LE (offset, noAssert) {
  if (!noAssert) checkOffset(offset, 2, this.length);
  var val = this[offset] | (this[offset + 1] << 8);
  return (val & 0x8000) ? val | 0xFFFF0000 : val
};

Buffer.prototype.readInt16BE = function readInt16BE (offset, noAssert) {
  if (!noAssert) checkOffset(offset, 2, this.length);
  var val = this[offset + 1] | (this[offset] << 8);
  return (val & 0x8000) ? val | 0xFFFF0000 : val
};

Buffer.prototype.readInt32LE = function readInt32LE (offset, noAssert) {
  if (!noAssert) checkOffset(offset, 4, this.length);

  return (this[offset]) |
    (this[offset + 1] << 8) |
    (this[offset + 2] << 16) |
    (this[offset + 3] << 24)
};

Buffer.prototype.readInt32BE = function readInt32BE (offset, noAssert) {
  if (!noAssert) checkOffset(offset, 4, this.length);

  return (this[offset] << 24) |
    (this[offset + 1] << 16) |
    (this[offset + 2] << 8) |
    (this[offset + 3])
};

Buffer.prototype.readFloatLE = function readFloatLE (offset, noAssert) {
  if (!noAssert) checkOffset(offset, 4, this.length);
  return read(this, offset, true, 23, 4)
};

Buffer.prototype.readFloatBE = function readFloatBE (offset, noAssert) {
  if (!noAssert) checkOffset(offset, 4, this.length);
  return read(this, offset, false, 23, 4)
};

Buffer.prototype.readDoubleLE = function readDoubleLE (offset, noAssert) {
  if (!noAssert) checkOffset(offset, 8, this.length);
  return read(this, offset, true, 52, 8)
};

Buffer.prototype.readDoubleBE = function readDoubleBE (offset, noAssert) {
  if (!noAssert) checkOffset(offset, 8, this.length);
  return read(this, offset, false, 52, 8)
};

function checkInt (buf, value, offset, ext, max, min) {
  if (!internalIsBuffer(buf)) throw new TypeError('"buffer" argument must be a Buffer instance')
  if (value > max || value < min) throw new RangeError('"value" argument is out of bounds')
  if (offset + ext > buf.length) throw new RangeError('Index out of range')
}

Buffer.prototype.writeUIntLE = function writeUIntLE (value, offset, byteLength, noAssert) {
  value = +value;
  offset = offset | 0;
  byteLength = byteLength | 0;
  if (!noAssert) {
    var maxBytes = Math.pow(2, 8 * byteLength) - 1;
    checkInt(this, value, offset, byteLength, maxBytes, 0);
  }

  var mul = 1;
  var i = 0;
  this[offset] = value & 0xFF;
  while (++i < byteLength && (mul *= 0x100)) {
    this[offset + i] = (value / mul) & 0xFF;
  }

  return offset + byteLength
};

Buffer.prototype.writeUIntBE = function writeUIntBE (value, offset, byteLength, noAssert) {
  value = +value;
  offset = offset | 0;
  byteLength = byteLength | 0;
  if (!noAssert) {
    var maxBytes = Math.pow(2, 8 * byteLength) - 1;
    checkInt(this, value, offset, byteLength, maxBytes, 0);
  }

  var i = byteLength - 1;
  var mul = 1;
  this[offset + i] = value & 0xFF;
  while (--i >= 0 && (mul *= 0x100)) {
    this[offset + i] = (value / mul) & 0xFF;
  }

  return offset + byteLength
};

Buffer.prototype.writeUInt8 = function writeUInt8 (value, offset, noAssert) {
  value = +value;
  offset = offset | 0;
  if (!noAssert) checkInt(this, value, offset, 1, 0xff, 0);
  if (!Buffer.TYPED_ARRAY_SUPPORT) value = Math.floor(value);
  this[offset] = (value & 0xff);
  return offset + 1
};

function objectWriteUInt16 (buf, value, offset, littleEndian) {
  if (value < 0) value = 0xffff + value + 1;
  for (var i = 0, j = Math.min(buf.length - offset, 2); i < j; ++i) {
    buf[offset + i] = (value & (0xff << (8 * (littleEndian ? i : 1 - i)))) >>>
      (littleEndian ? i : 1 - i) * 8;
  }
}

Buffer.prototype.writeUInt16LE = function writeUInt16LE (value, offset, noAssert) {
  value = +value;
  offset = offset | 0;
  if (!noAssert) checkInt(this, value, offset, 2, 0xffff, 0);
  if (Buffer.TYPED_ARRAY_SUPPORT) {
    this[offset] = (value & 0xff);
    this[offset + 1] = (value >>> 8);
  } else {
    objectWriteUInt16(this, value, offset, true);
  }
  return offset + 2
};

Buffer.prototype.writeUInt16BE = function writeUInt16BE (value, offset, noAssert) {
  value = +value;
  offset = offset | 0;
  if (!noAssert) checkInt(this, value, offset, 2, 0xffff, 0);
  if (Buffer.TYPED_ARRAY_SUPPORT) {
    this[offset] = (value >>> 8);
    this[offset + 1] = (value & 0xff);
  } else {
    objectWriteUInt16(this, value, offset, false);
  }
  return offset + 2
};

function objectWriteUInt32 (buf, value, offset, littleEndian) {
  if (value < 0) value = 0xffffffff + value + 1;
  for (var i = 0, j = Math.min(buf.length - offset, 4); i < j; ++i) {
    buf[offset + i] = (value >>> (littleEndian ? i : 3 - i) * 8) & 0xff;
  }
}

Buffer.prototype.writeUInt32LE = function writeUInt32LE (value, offset, noAssert) {
  value = +value;
  offset = offset | 0;
  if (!noAssert) checkInt(this, value, offset, 4, 0xffffffff, 0);
  if (Buffer.TYPED_ARRAY_SUPPORT) {
    this[offset + 3] = (value >>> 24);
    this[offset + 2] = (value >>> 16);
    this[offset + 1] = (value >>> 8);
    this[offset] = (value & 0xff);
  } else {
    objectWriteUInt32(this, value, offset, true);
  }
  return offset + 4
};

Buffer.prototype.writeUInt32BE = function writeUInt32BE (value, offset, noAssert) {
  value = +value;
  offset = offset | 0;
  if (!noAssert) checkInt(this, value, offset, 4, 0xffffffff, 0);
  if (Buffer.TYPED_ARRAY_SUPPORT) {
    this[offset] = (value >>> 24);
    this[offset + 1] = (value >>> 16);
    this[offset + 2] = (value >>> 8);
    this[offset + 3] = (value & 0xff);
  } else {
    objectWriteUInt32(this, value, offset, false);
  }
  return offset + 4
};

Buffer.prototype.writeIntLE = function writeIntLE (value, offset, byteLength, noAssert) {
  value = +value;
  offset = offset | 0;
  if (!noAssert) {
    var limit = Math.pow(2, 8 * byteLength - 1);

    checkInt(this, value, offset, byteLength, limit - 1, -limit);
  }

  var i = 0;
  var mul = 1;
  var sub = 0;
  this[offset] = value & 0xFF;
  while (++i < byteLength && (mul *= 0x100)) {
    if (value < 0 && sub === 0 && this[offset + i - 1] !== 0) {
      sub = 1;
    }
    this[offset + i] = ((value / mul) >> 0) - sub & 0xFF;
  }

  return offset + byteLength
};

Buffer.prototype.writeIntBE = function writeIntBE (value, offset, byteLength, noAssert) {
  value = +value;
  offset = offset | 0;
  if (!noAssert) {
    var limit = Math.pow(2, 8 * byteLength - 1);

    checkInt(this, value, offset, byteLength, limit - 1, -limit);
  }

  var i = byteLength - 1;
  var mul = 1;
  var sub = 0;
  this[offset + i] = value & 0xFF;
  while (--i >= 0 && (mul *= 0x100)) {
    if (value < 0 && sub === 0 && this[offset + i + 1] !== 0) {
      sub = 1;
    }
    this[offset + i] = ((value / mul) >> 0) - sub & 0xFF;
  }

  return offset + byteLength
};

Buffer.prototype.writeInt8 = function writeInt8 (value, offset, noAssert) {
  value = +value;
  offset = offset | 0;
  if (!noAssert) checkInt(this, value, offset, 1, 0x7f, -0x80);
  if (!Buffer.TYPED_ARRAY_SUPPORT) value = Math.floor(value);
  if (value < 0) value = 0xff + value + 1;
  this[offset] = (value & 0xff);
  return offset + 1
};

Buffer.prototype.writeInt16LE = function writeInt16LE (value, offset, noAssert) {
  value = +value;
  offset = offset | 0;
  if (!noAssert) checkInt(this, value, offset, 2, 0x7fff, -0x8000);
  if (Buffer.TYPED_ARRAY_SUPPORT) {
    this[offset] = (value & 0xff);
    this[offset + 1] = (value >>> 8);
  } else {
    objectWriteUInt16(this, value, offset, true);
  }
  return offset + 2
};

Buffer.prototype.writeInt16BE = function writeInt16BE (value, offset, noAssert) {
  value = +value;
  offset = offset | 0;
  if (!noAssert) checkInt(this, value, offset, 2, 0x7fff, -0x8000);
  if (Buffer.TYPED_ARRAY_SUPPORT) {
    this[offset] = (value >>> 8);
    this[offset + 1] = (value & 0xff);
  } else {
    objectWriteUInt16(this, value, offset, false);
  }
  return offset + 2
};

Buffer.prototype.writeInt32LE = function writeInt32LE (value, offset, noAssert) {
  value = +value;
  offset = offset | 0;
  if (!noAssert) checkInt(this, value, offset, 4, 0x7fffffff, -0x80000000);
  if (Buffer.TYPED_ARRAY_SUPPORT) {
    this[offset] = (value & 0xff);
    this[offset + 1] = (value >>> 8);
    this[offset + 2] = (value >>> 16);
    this[offset + 3] = (value >>> 24);
  } else {
    objectWriteUInt32(this, value, offset, true);
  }
  return offset + 4
};

Buffer.prototype.writeInt32BE = function writeInt32BE (value, offset, noAssert) {
  value = +value;
  offset = offset | 0;
  if (!noAssert) checkInt(this, value, offset, 4, 0x7fffffff, -0x80000000);
  if (value < 0) value = 0xffffffff + value + 1;
  if (Buffer.TYPED_ARRAY_SUPPORT) {
    this[offset] = (value >>> 24);
    this[offset + 1] = (value >>> 16);
    this[offset + 2] = (value >>> 8);
    this[offset + 3] = (value & 0xff);
  } else {
    objectWriteUInt32(this, value, offset, false);
  }
  return offset + 4
};

function checkIEEE754 (buf, value, offset, ext, max, min) {
  if (offset + ext > buf.length) throw new RangeError('Index out of range')
  if (offset < 0) throw new RangeError('Index out of range')
}

function writeFloat (buf, value, offset, littleEndian, noAssert) {
  if (!noAssert) {
    checkIEEE754(buf, value, offset, 4, 3.4028234663852886e+38, -3.4028234663852886e+38);
  }
  write(buf, value, offset, littleEndian, 23, 4);
  return offset + 4
}

Buffer.prototype.writeFloatLE = function writeFloatLE (value, offset, noAssert) {
  return writeFloat(this, value, offset, true, noAssert)
};

Buffer.prototype.writeFloatBE = function writeFloatBE (value, offset, noAssert) {
  return writeFloat(this, value, offset, false, noAssert)
};

function writeDouble (buf, value, offset, littleEndian, noAssert) {
  if (!noAssert) {
    checkIEEE754(buf, value, offset, 8, 1.7976931348623157E+308, -1.7976931348623157E+308);
  }
  write(buf, value, offset, littleEndian, 52, 8);
  return offset + 8
}

Buffer.prototype.writeDoubleLE = function writeDoubleLE (value, offset, noAssert) {
  return writeDouble(this, value, offset, true, noAssert)
};

Buffer.prototype.writeDoubleBE = function writeDoubleBE (value, offset, noAssert) {
  return writeDouble(this, value, offset, false, noAssert)
};

// copy(targetBuffer, targetStart=0, sourceStart=0, sourceEnd=buffer.length)
Buffer.prototype.copy = function copy (target, targetStart, start, end) {
  if (!start) start = 0;
  if (!end && end !== 0) end = this.length;
  if (targetStart >= target.length) targetStart = target.length;
  if (!targetStart) targetStart = 0;
  if (end > 0 && end < start) end = start;

  // Copy 0 bytes; we're done
  if (end === start) return 0
  if (target.length === 0 || this.length === 0) return 0

  // Fatal error conditions
  if (targetStart < 0) {
    throw new RangeError('targetStart out of bounds')
  }
  if (start < 0 || start >= this.length) throw new RangeError('sourceStart out of bounds')
  if (end < 0) throw new RangeError('sourceEnd out of bounds')

  // Are we oob?
  if (end > this.length) end = this.length;
  if (target.length - targetStart < end - start) {
    end = target.length - targetStart + start;
  }

  var len = end - start;
  var i;

  if (this === target && start < targetStart && targetStart < end) {
    // descending copy from end
    for (i = len - 1; i >= 0; --i) {
      target[i + targetStart] = this[i + start];
    }
  } else if (len < 1000 || !Buffer.TYPED_ARRAY_SUPPORT) {
    // ascending copy from start
    for (i = 0; i < len; ++i) {
      target[i + targetStart] = this[i + start];
    }
  } else {
    Uint8Array.prototype.set.call(
      target,
      this.subarray(start, start + len),
      targetStart
    );
  }

  return len
};

// Usage:
//    buffer.fill(number[, offset[, end]])
//    buffer.fill(buffer[, offset[, end]])
//    buffer.fill(string[, offset[, end]][, encoding])
Buffer.prototype.fill = function fill (val, start, end, encoding) {
  // Handle string cases:
  if (typeof val === 'string') {
    if (typeof start === 'string') {
      encoding = start;
      start = 0;
      end = this.length;
    } else if (typeof end === 'string') {
      encoding = end;
      end = this.length;
    }
    if (val.length === 1) {
      var code = val.charCodeAt(0);
      if (code < 256) {
        val = code;
      }
    }
    if (encoding !== undefined && typeof encoding !== 'string') {
      throw new TypeError('encoding must be a string')
    }
    if (typeof encoding === 'string' && !Buffer.isEncoding(encoding)) {
      throw new TypeError('Unknown encoding: ' + encoding)
    }
  } else if (typeof val === 'number') {
    val = val & 255;
  }

  // Invalid ranges are not set to a default, so can range check early.
  if (start < 0 || this.length < start || this.length < end) {
    throw new RangeError('Out of range index')
  }

  if (end <= start) {
    return this
  }

  start = start >>> 0;
  end = end === undefined ? this.length : end >>> 0;

  if (!val) val = 0;

  var i;
  if (typeof val === 'number') {
    for (i = start; i < end; ++i) {
      this[i] = val;
    }
  } else {
    var bytes = internalIsBuffer(val)
      ? val
      : utf8ToBytes(new Buffer(val, encoding).toString());
    var len = bytes.length;
    for (i = 0; i < end - start; ++i) {
      this[i + start] = bytes[i % len];
    }
  }

  return this
};

// HELPER FUNCTIONS
// ================

var INVALID_BASE64_RE = /[^+\/0-9A-Za-z-_]/g;

function base64clean (str) {
  // Node strips out invalid characters like \n and \t from the string, base64-js does not
  str = stringtrim(str).replace(INVALID_BASE64_RE, '');
  // Node converts strings with length < 2 to ''
  if (str.length < 2) return ''
  // Node allows for non-padded base64 strings (missing trailing ===), base64-js does not
  while (str.length % 4 !== 0) {
    str = str + '=';
  }
  return str
}

function stringtrim (str) {
  if (str.trim) return str.trim()
  return str.replace(/^\s+|\s+$/g, '')
}

function toHex (n) {
  if (n < 16) return '0' + n.toString(16)
  return n.toString(16)
}

function utf8ToBytes (string, units) {
  units = units || Infinity;
  var codePoint;
  var length = string.length;
  var leadSurrogate = null;
  var bytes = [];

  for (var i = 0; i < length; ++i) {
    codePoint = string.charCodeAt(i);

    // is surrogate component
    if (codePoint > 0xD7FF && codePoint < 0xE000) {
      // last char was a lead
      if (!leadSurrogate) {
        // no lead yet
        if (codePoint > 0xDBFF) {
          // unexpected trail
          if ((units -= 3) > -1) bytes.push(0xEF, 0xBF, 0xBD);
          continue
        } else if (i + 1 === length) {
          // unpaired lead
          if ((units -= 3) > -1) bytes.push(0xEF, 0xBF, 0xBD);
          continue
        }

        // valid lead
        leadSurrogate = codePoint;

        continue
      }

      // 2 leads in a row
      if (codePoint < 0xDC00) {
        if ((units -= 3) > -1) bytes.push(0xEF, 0xBF, 0xBD);
        leadSurrogate = codePoint;
        continue
      }

      // valid surrogate pair
      codePoint = (leadSurrogate - 0xD800 << 10 | codePoint - 0xDC00) + 0x10000;
    } else if (leadSurrogate) {
      // valid bmp char, but last char was a lead
      if ((units -= 3) > -1) bytes.push(0xEF, 0xBF, 0xBD);
    }

    leadSurrogate = null;

    // encode utf8
    if (codePoint < 0x80) {
      if ((units -= 1) < 0) break
      bytes.push(codePoint);
    } else if (codePoint < 0x800) {
      if ((units -= 2) < 0) break
      bytes.push(
        codePoint >> 0x6 | 0xC0,
        codePoint & 0x3F | 0x80
      );
    } else if (codePoint < 0x10000) {
      if ((units -= 3) < 0) break
      bytes.push(
        codePoint >> 0xC | 0xE0,
        codePoint >> 0x6 & 0x3F | 0x80,
        codePoint & 0x3F | 0x80
      );
    } else if (codePoint < 0x110000) {
      if ((units -= 4) < 0) break
      bytes.push(
        codePoint >> 0x12 | 0xF0,
        codePoint >> 0xC & 0x3F | 0x80,
        codePoint >> 0x6 & 0x3F | 0x80,
        codePoint & 0x3F | 0x80
      );
    } else {
      throw new Error('Invalid code point')
    }
  }

  return bytes
}

function asciiToBytes (str) {
  var byteArray = [];
  for (var i = 0; i < str.length; ++i) {
    // Node's code seems to be doing this and not & 0x7F..
    byteArray.push(str.charCodeAt(i) & 0xFF);
  }
  return byteArray
}

function utf16leToBytes (str, units) {
  var c, hi, lo;
  var byteArray = [];
  for (var i = 0; i < str.length; ++i) {
    if ((units -= 2) < 0) break

    c = str.charCodeAt(i);
    hi = c >> 8;
    lo = c % 256;
    byteArray.push(lo);
    byteArray.push(hi);
  }

  return byteArray
}


function base64ToBytes (str) {
  return toByteArray(base64clean(str))
}

function blitBuffer (src, dst, offset, length) {
  for (var i = 0; i < length; ++i) {
    if ((i + offset >= dst.length) || (i >= src.length)) break
    dst[i + offset] = src[i];
  }
  return i
}

function isnan (val) {
  return val !== val // eslint-disable-line no-self-compare
}


// the following is from is-buffer, also by Feross Aboukhadijeh and with same lisence
// The _isBuffer check is for Safari 5-7 support, because it's missing
// Object.prototype.constructor. Remove this eventually
function isBuffer(obj) {
  return obj != null && (!!obj._isBuffer || isFastBuffer(obj) || isSlowBuffer(obj))
}

function isFastBuffer (obj) {
  return !!obj.constructor && typeof obj.constructor.isBuffer === 'function' && obj.constructor.isBuffer(obj)
}

// For Node v0.10 support. Remove this eventually.
function isSlowBuffer (obj) {
  return typeof obj.readFloatLE === 'function' && typeof obj.slice === 'function' && isFastBuffer(obj.slice(0, 0))
}

var commonjsGlobal = typeof window !== 'undefined' ? window : typeof global !== 'undefined' ? global : typeof self !== 'undefined' ? self : {};



function unwrapExports (x) {
	return x && x.__esModule && Object.prototype.hasOwnProperty.call(x, 'default') ? x['default'] : x;
}

function createCommonjsModule(fn, module) {
	return module = { exports: {} }, fn(module, module.exports), module.exports;
}

var parserTypescript_1 = createCommonjsModule(function (module) {
"use strict";function _interopDefault(e){return e&&"object"==typeof e&&"default"in e?e.default:e}var fs$$1=_interopDefault(fs),path$$1=_interopDefault(path),os$$1=_interopDefault(os),crypto$$1=_interopDefault(crypto),module$1$$1=_interopDefault(module$1);function createError(e,t){const r=new SyntaxError(e+" ("+t.start.line+":"+t.start.column+")");return r.loc=t,r}var parserCreateError=createError;function includeShebang(e,t){if(!e.startsWith("#!"))return;const r=e.indexOf("\n"),n={type:"Line",value:e.slice(2,r),range:[0,r],loc:{source:null,start:{line:1,column:0},end:{line:1,column:r}}};t.comments=[n].concat(t.comments);}var parserIncludeShebang=includeShebang,astNodeTypes={ArrayExpression:"ArrayExpression",ArrayPattern:"ArrayPattern",ArrowFunctionExpression:"ArrowFunctionExpression",AssignmentExpression:"AssignmentExpression",AssignmentPattern:"AssignmentPattern",AwaitExpression:"AwaitExpression",BinaryExpression:"BinaryExpression",BlockStatement:"BlockStatement",BreakStatement:"BreakStatement",CallExpression:"CallExpression",CatchClause:"CatchClause",ClassBody:"ClassBody",ClassDeclaration:"ClassDeclaration",ClassExpression:"ClassExpression",ClassImplements:"ClassImplements",ClassProperty:"ClassProperty",ConditionalExpression:"ConditionalExpression",ContinueStatement:"ContinueStatement",DebuggerStatement:"DebuggerStatement",DeclareFunction:"DeclareFunction",Decorator:"Decorator",DoWhileStatement:"DoWhileStatement",EmptyStatement:"EmptyStatement",ExperimentalRestProperty:"ExperimentalRestProperty",ExperimentalSpreadProperty:"ExperimentalSpreadProperty",ExportAllDeclaration:"ExportAllDeclaration",ExportDefaultDeclaration:"ExportDefaultDeclaration",ExportNamedDeclaration:"ExportNamedDeclaration",ExportSpecifier:"ExportSpecifier",ExpressionStatement:"ExpressionStatement",ForInStatement:"ForInStatement",ForOfStatement:"ForOfStatement",ForStatement:"ForStatement",FunctionDeclaration:"FunctionDeclaration",FunctionExpression:"FunctionExpression",GenericTypeAnnotation:"GenericTypeAnnotation",Identifier:"Identifier",IfStatement:"IfStatement",Import:"Import",ImportDeclaration:"ImportDeclaration",ImportDefaultSpecifier:"ImportDefaultSpecifier",ImportNamespaceSpecifier:"ImportNamespaceSpecifier",ImportSpecifier:"ImportSpecifier",JSXAttribute:"JSXAttribute",JSXClosingElement:"JSXClosingElement",JSXElement:"JSXElement",JSXEmptyExpression:"JSXEmptyExpression",JSXExpressionContainer:"JSXExpressionContainer",JSXIdentifier:"JSXIdentifier",JSXMemberExpression:"JSXMemberExpression",JSXNamespacedName:"JSXNamespacedName",JSXOpeningElement:"JSXOpeningElement",JSXSpreadAttribute:"JSXSpreadAttribute",JSXText:"JSXText",LabeledStatement:"LabeledStatement",Literal:"Literal",LogicalExpression:"LogicalExpression",MemberExpression:"MemberExpression",MetaProperty:"MetaProperty",MethodDefinition:"MethodDefinition",NewExpression:"NewExpression",ObjectExpression:"ObjectExpression",ObjectPattern:"ObjectPattern",Program:"Program",Property:"Property",RestElement:"RestElement",ReturnStatement:"ReturnStatement",SequenceExpression:"SequenceExpression",SpreadElement:"SpreadElement",Super:"Super",SwitchCase:"SwitchCase",SwitchStatement:"SwitchStatement",TaggedTemplateExpression:"TaggedTemplateExpression",TemplateElement:"TemplateElement",TemplateLiteral:"TemplateLiteral",ThisExpression:"ThisExpression",ThrowStatement:"ThrowStatement",TryStatement:"TryStatement",TSAbstractClassProperty:"TSAbstractClassProperty",TSAbstractKeyword:"TSAbstractKeyword",TSAbstractMethodDefinition:"TSAbstractMethodDefinition",TSAnyKeyword:"TSAnyKeyword",TSArrayType:"TSArrayType",TSAsyncKeyword:"TSAsyncKeyword",TSBooleanKeyword:"TSBooleanKeyword",TSConstructorType:"TSConstructorType",TSConstructSignature:"TSConstructSignature",TSDeclareKeyword:"TSDeclareKeyword",TSEnumDeclaration:"TSEnumDeclaration",TSEnumMember:"TSEnumMember",TSExportAssignment:"TSExportAssignment",TSExportKeyword:"TSExportKeyword",TSIndexSignature:"TSIndexSignature",TSInterfaceBody:"TSInterfaceBody",TSInterfaceDeclaration:"TSInterfaceDeclaration",TSInterfaceHeritage:"TSInterfaceHeritage",TSFunctionType:"TSFunctionType",TSMethodSignature:"TSMethodSignature",TSModuleBlock:"TSModuleBlock",TSModuleDeclaration:"TSModuleDeclaration",TSNamespaceFunctionDeclaration:"TSNamespaceFunctionDeclaration",TSNonNullExpression:"TSNonNullExpression",TSNeverKeyword:"TSNeverKeyword",TSNullKeyword:"TSNullKeyword",TSNumberKeyword:"TSNumberKeyword",TSObjectKeyword:"TSObjectKeyword",TSParameterProperty:"TSParameterProperty",TSPrivateKeyword:"TSPrivateKeyword",TSPropertySignature:"TSPropertySignature",TSProtectedKeyword:"TSProtectedKeyword",TSPublicKeyword:"TSPublicKeyword",TSQualifiedName:"TSQualifiedName",TSQuestionToken:"TSQuestionToken",TSReadonlyKeyword:"TSReadonlyKeyword",TSStaticKeyword:"TSStaticKeyword",TSStringKeyword:"TSStringKeyword",TSSymbolKeyword:"TSSymbolKeyword",TSTypeAnnotation:"TSTypeAnnotation",TSTypeLiteral:"TSTypeLiteral",TSTypeOperator:"TSTypeOperator",TSTypeParameter:"TSTypeParameter",TSTypeParameterDeclaration:"TSTypeParameterDeclaration",TSTypeParameterInstantiation:"TSTypeParameterInstantiation",TSTypePredicate:"TSTypePredicate",TSTypeReference:"TSTypeReference",TSUnionType:"TSUnionType",TSUndefinedKeyword:"TSUndefinedKeyword",TSVoidKeyword:"TSVoidKeyword",UnaryExpression:"UnaryExpression",UpdateExpression:"UpdateExpression",VariableDeclaration:"VariableDeclaration",VariableDeclarator:"VariableDeclarator",WhileStatement:"WhileStatement",WithStatement:"WithStatement",YieldExpression:"YieldExpression"},commonjsGlobal$$1="undefined"!=typeof window?window:"undefined"!=typeof commonjsGlobal?commonjsGlobal:"undefined"!=typeof self?self:{};function commonjsRequire$$1(){throw new Error("Dynamic requires are not currently supported by rollup-plugin-commonjs")}function unwrapExports$$1(e){return e&&e.__esModule&&Object.prototype.hasOwnProperty.call(e,"default")?e.default:e}function createCommonjsModule$$1(e,t){return e(t={exports:{}},t.exports),t.exports}var intToCharMap="ABCDEFGHIJKLMNOPQRSTUVWXYZabcdefghijklmnopqrstuvwxyz0123456789+/".split(""),encode$1=function(e){if(0<=e&&e<intToCharMap.length)return intToCharMap[e];throw new TypeError("Must be between 0 and 63: "+e)},decode$1=function(e){return 65<=e&&e<=90?e-65:97<=e&&e<=122?e-97+26:48<=e&&e<=57?e-48+52:43==e?62:47==e?63:-1},base64={encode:encode$1,decode:decode$1},VLQ_BASE_SHIFT=5,VLQ_BASE=1<<VLQ_BASE_SHIFT,VLQ_BASE_MASK=VLQ_BASE-1,VLQ_CONTINUATION_BIT=VLQ_BASE;function toVLQSigned(e){return e<0?1+(-e<<1):0+(e<<1)}function fromVLQSigned(e){var t=e>>1;return 1==(1&e)?-t:t}var encode=function(e){var t,r="",n=toVLQSigned(e);do{t=n&VLQ_BASE_MASK,(n>>>=VLQ_BASE_SHIFT)>0&&(t|=VLQ_CONTINUATION_BIT),r+=base64.encode(t);}while(n>0);return r},decode=function(e,t,r){var n,i,a=e.length,o=0,s=0;do{if(t>=a)throw new Error("Expected more digits in base 64 VLQ value.");if(-1===(i=base64.decode(e.charCodeAt(t++))))throw new Error("Invalid base64 digit: "+e.charAt(t-1));n=!!(i&VLQ_CONTINUATION_BIT),o+=(i&=VLQ_BASE_MASK)<<s,s+=VLQ_BASE_SHIFT;}while(n);r.value=fromVLQSigned(o),r.rest=t;},base64Vlq={encode:encode,decode:decode},util=createCommonjsModule$$1(function(e,t){t.getArg=function(e,t,r){if(t in e)return e[t];if(3===arguments.length)return r;throw new Error('"'+t+'" is a required argument.')};var r=/^(?:([\w+\-.]+):)?\/\/(?:(\w+:\w+)@)?([\w.]*)(?::(\d+))?(\S*)$/,n=/^data:.+\,.+$/;function i(e){var t=e.match(r);return t?{scheme:t[1],auth:t[2],host:t[3],port:t[4],path:t[5]}:null}function a(e){var t="";return e.scheme&&(t+=e.scheme+":"),t+="//",e.auth&&(t+=e.auth+"@"),e.host&&(t+=e.host),e.port&&(t+=":"+e.port),e.path&&(t+=e.path),t}function o(e){var r=e,n=i(e);if(n){if(!n.path)return e;r=n.path;}for(var o,s=t.isAbsolute(r),c=r.split(/\/+/),u=0,l=c.length-1;l>=0;l--)"."===(o=c[l])?c.splice(l,1):".."===o?u++:u>0&&(""===o?(c.splice(l+1,u),u=0):(c.splice(l,2),u--));return""===(r=c.join("/"))&&(r=s?"/":"."),n?(n.path=r,a(n)):r}t.urlParse=i,t.urlGenerate=a,t.normalize=o,t.join=function(e,t){""===e&&(e="."),""===t&&(t=".");var r=i(t),s=i(e);if(s&&(e=s.path||"/"),r&&!r.scheme)return s&&(r.scheme=s.scheme),a(r);if(r||t.match(n))return t;if(s&&!s.host&&!s.path)return s.host=t,a(s);var c="/"===t.charAt(0)?t:o(e.replace(/\/+$/,"")+"/"+t);return s?(s.path=c,a(s)):c},t.isAbsolute=function(e){return"/"===e.charAt(0)||!!e.match(r)},t.relative=function(e,t){""===e&&(e="."),e=e.replace(/\/$/,"");for(var r=0;0!==t.indexOf(e+"/");){var n=e.lastIndexOf("/");if(n<0)return t;if((e=e.slice(0,n)).match(/^([^\/]+:\/)?\/*$/))return t;++r;}return Array(r+1).join("../")+t.substr(e.length+1)};var s=!("__proto__"in Object.create(null));function c(e){return e}function u(e){if(!e)return!1;var t=e.length;if(t<9)return!1;if(95!==e.charCodeAt(t-1)||95!==e.charCodeAt(t-2)||111!==e.charCodeAt(t-3)||116!==e.charCodeAt(t-4)||111!==e.charCodeAt(t-5)||114!==e.charCodeAt(t-6)||112!==e.charCodeAt(t-7)||95!==e.charCodeAt(t-8)||95!==e.charCodeAt(t-9))return!1;for(var r=t-10;r>=0;r--)if(36!==e.charCodeAt(r))return!1;return!0}function l(e,t){return e===t?0:e>t?1:-1}t.toSetString=s?c:function(e){return u(e)?"$"+e:e},t.fromSetString=s?c:function(e){return u(e)?e.slice(1):e},t.compareByOriginalPositions=function(e,t,r){var n=e.source-t.source;return 0!==n?n:0!=(n=e.originalLine-t.originalLine)?n:0!=(n=e.originalColumn-t.originalColumn)||r?n:0!=(n=e.generatedColumn-t.generatedColumn)?n:0!=(n=e.generatedLine-t.generatedLine)?n:e.name-t.name},t.compareByGeneratedPositionsDeflated=function(e,t,r){var n=e.generatedLine-t.generatedLine;return 0!==n?n:0!=(n=e.generatedColumn-t.generatedColumn)||r?n:0!=(n=e.source-t.source)?n:0!=(n=e.originalLine-t.originalLine)?n:0!=(n=e.originalColumn-t.originalColumn)?n:e.name-t.name},t.compareByGeneratedPositionsInflated=function(e,t){var r=e.generatedLine-t.generatedLine;return 0!==r?r:0!=(r=e.generatedColumn-t.generatedColumn)?r:0!==(r=l(e.source,t.source))?r:0!=(r=e.originalLine-t.originalLine)?r:0!=(r=e.originalColumn-t.originalColumn)?r:l(e.name,t.name)};}),has=Object.prototype.hasOwnProperty;function ArraySet$1(){this._array=[],this._set=Object.create(null);}ArraySet$1.fromArray=function(e,t){for(var r=new ArraySet$1,n=0,i=e.length;n<i;n++)r.add(e[n],t);return r},ArraySet$1.prototype.size=function(){return Object.getOwnPropertyNames(this._set).length},ArraySet$1.prototype.add=function(e,t){var r=util.toSetString(e),n=has.call(this._set,r),i=this._array.length;n&&!t||this._array.push(e),n||(this._set[r]=i);},ArraySet$1.prototype.has=function(e){var t=util.toSetString(e);return has.call(this._set,t)},ArraySet$1.prototype.indexOf=function(e){var t=util.toSetString(e);if(has.call(this._set,t))return this._set[t];throw new Error('"'+e+'" is not in the set.')},ArraySet$1.prototype.at=function(e){if(e>=0&&e<this._array.length)return this._array[e];throw new Error("No element indexed by "+e)},ArraySet$1.prototype.toArray=function(){return this._array.slice()};var ArraySet_1=ArraySet$1,arraySet={ArraySet:ArraySet_1};function generatedPositionAfter(e,t){var r=e.generatedLine,n=t.generatedLine,i=e.generatedColumn,a=t.generatedColumn;return n>r||n==r&&a>=i||util.compareByGeneratedPositionsInflated(e,t)<=0}function MappingList$1(){this._array=[],this._sorted=!0,this._last={generatedLine:-1,generatedColumn:0};}MappingList$1.prototype.unsortedForEach=function(e,t){this._array.forEach(e,t);},MappingList$1.prototype.add=function(e){generatedPositionAfter(this._last,e)?(this._last=e,this._array.push(e)):(this._sorted=!1,this._array.push(e));},MappingList$1.prototype.toArray=function(){return this._sorted||(this._array.sort(util.compareByGeneratedPositionsInflated),this._sorted=!0),this._array};var MappingList_1=MappingList$1,mappingList={MappingList:MappingList_1},ArraySet=arraySet.ArraySet,MappingList=mappingList.MappingList;function SourceMapGenerator$1(e){e||(e={}),this._file=util.getArg(e,"file",null),this._sourceRoot=util.getArg(e,"sourceRoot",null),this._skipValidation=util.getArg(e,"skipValidation",!1),this._sources=new ArraySet,this._names=new ArraySet,this._mappings=new MappingList,this._sourcesContents=null;}SourceMapGenerator$1.prototype._version=3,SourceMapGenerator$1.fromSourceMap=function(e){var t=e.sourceRoot,r=new SourceMapGenerator$1({file:e.file,sourceRoot:t});return e.eachMapping(function(e){var n={generated:{line:e.generatedLine,column:e.generatedColumn}};null!=e.source&&(n.source=e.source,null!=t&&(n.source=util.relative(t,n.source)),n.original={line:e.originalLine,column:e.originalColumn},null!=e.name&&(n.name=e.name)),r.addMapping(n);}),e.sources.forEach(function(t){var n=e.sourceContentFor(t);null!=n&&r.setSourceContent(t,n);}),r},SourceMapGenerator$1.prototype.addMapping=function(e){var t=util.getArg(e,"generated"),r=util.getArg(e,"original",null),n=util.getArg(e,"source",null),i=util.getArg(e,"name",null);this._skipValidation||this._validateMapping(t,r,n,i),null!=n&&(n=String(n),this._sources.has(n)||this._sources.add(n)),null!=i&&(i=String(i),this._names.has(i)||this._names.add(i)),this._mappings.add({generatedLine:t.line,generatedColumn:t.column,originalLine:null!=r&&r.line,originalColumn:null!=r&&r.column,source:n,name:i});},SourceMapGenerator$1.prototype.setSourceContent=function(e,t){var r=e;null!=this._sourceRoot&&(r=util.relative(this._sourceRoot,r)),null!=t?(this._sourcesContents||(this._sourcesContents=Object.create(null)),this._sourcesContents[util.toSetString(r)]=t):this._sourcesContents&&(delete this._sourcesContents[util.toSetString(r)],0===Object.keys(this._sourcesContents).length&&(this._sourcesContents=null));},SourceMapGenerator$1.prototype.applySourceMap=function(e,t,r){var n=t;if(null==t){if(null==e.file)throw new Error('SourceMapGenerator.prototype.applySourceMap requires either an explicit source file, or the source map\'s "file" property. Both were omitted.');n=e.file;}var i=this._sourceRoot;null!=i&&(n=util.relative(i,n));var a=new ArraySet,o=new ArraySet;this._mappings.unsortedForEach(function(t){if(t.source===n&&null!=t.originalLine){var s=e.originalPositionFor({line:t.originalLine,column:t.originalColumn});null!=s.source&&(t.source=s.source,null!=r&&(t.source=util.join(r,t.source)),null!=i&&(t.source=util.relative(i,t.source)),t.originalLine=s.line,t.originalColumn=s.column,null!=s.name&&(t.name=s.name));}var c=t.source;null==c||a.has(c)||a.add(c);var u=t.name;null==u||o.has(u)||o.add(u);},this),this._sources=a,this._names=o,e.sources.forEach(function(t){var n=e.sourceContentFor(t);null!=n&&(null!=r&&(t=util.join(r,t)),null!=i&&(t=util.relative(i,t)),this.setSourceContent(t,n));},this);},SourceMapGenerator$1.prototype._validateMapping=function(e,t,r,n){if((!(e&&"line"in e&&"column"in e&&e.line>0&&e.column>=0)||t||r||n)&&!(e&&"line"in e&&"column"in e&&t&&"line"in t&&"column"in t&&e.line>0&&e.column>=0&&t.line>0&&t.column>=0&&r))throw new Error("Invalid mapping: "+JSON.stringify({generated:e,source:r,original:t,name:n}))},SourceMapGenerator$1.prototype._serializeMappings=function(){for(var e,t,r,n,i=0,a=1,o=0,s=0,c=0,u=0,l="",_=this._mappings.toArray(),d=0,p=_.length;d<p;d++){if(e="",(t=_[d]).generatedLine!==a)for(i=0;t.generatedLine!==a;)e+=";",a++;else if(d>0){if(!util.compareByGeneratedPositionsInflated(t,_[d-1]))continue;e+=",";}e+=base64Vlq.encode(t.generatedColumn-i),i=t.generatedColumn,null!=t.source&&(n=this._sources.indexOf(t.source),e+=base64Vlq.encode(n-u),u=n,e+=base64Vlq.encode(t.originalLine-1-s),s=t.originalLine-1,e+=base64Vlq.encode(t.originalColumn-o),o=t.originalColumn,null!=t.name&&(r=this._names.indexOf(t.name),e+=base64Vlq.encode(r-c),c=r)),l+=e;}return l},SourceMapGenerator$1.prototype._generateSourcesContent=function(e,t){return e.map(function(e){if(!this._sourcesContents)return null;null!=t&&(e=util.relative(t,e));var r=util.toSetString(e);return Object.prototype.hasOwnProperty.call(this._sourcesContents,r)?this._sourcesContents[r]:null},this)},SourceMapGenerator$1.prototype.toJSON=function(){var e={version:this._version,sources:this._sources.toArray(),names:this._names.toArray(),mappings:this._serializeMappings()};return null!=this._file&&(e.file=this._file),null!=this._sourceRoot&&(e.sourceRoot=this._sourceRoot),this._sourcesContents&&(e.sourcesContent=this._generateSourcesContent(e.sources,e.sourceRoot)),e},SourceMapGenerator$1.prototype.toString=function(){return JSON.stringify(this.toJSON())};var SourceMapGenerator_1=SourceMapGenerator$1,sourceMapGenerator={SourceMapGenerator:SourceMapGenerator_1},binarySearch=createCommonjsModule$$1(function(e,t){t.GREATEST_LOWER_BOUND=1,t.LEAST_UPPER_BOUND=2,t.search=function(e,r,n,i){if(0===r.length)return-1;var a=function e(r,n,i,a,o,s){var c=Math.floor((n-r)/2)+r,u=o(i,a[c],!0);return 0===u?c:u>0?n-c>1?e(c,n,i,a,o,s):s==t.LEAST_UPPER_BOUND?n<a.length?n:-1:c:c-r>1?e(r,c,i,a,o,s):s==t.LEAST_UPPER_BOUND?c:r<0?-1:r}(-1,r.length,e,r,n,i||t.GREATEST_LOWER_BOUND);if(a<0)return-1;for(;a-1>=0&&0===n(r[a],r[a-1],!0);)--a;return a};});function swap(e,t,r){var n=e[t];e[t]=e[r],e[r]=n;}function randomIntInRange(e,t){return Math.round(e+Math.random()*(t-e))}function doQuickSort(e,t,r,n){if(r<n){var i=r-1;swap(e,randomIntInRange(r,n),n);for(var a=e[n],o=r;o<n;o++)t(e[o],a)<=0&&swap(e,i+=1,o);swap(e,i+1,o);var s=i+1;doQuickSort(e,t,r,s-1),doQuickSort(e,t,s+1,n);}}var quickSort_1=function(e,t){doQuickSort(e,t,0,e.length-1);},quickSort$1={quickSort:quickSort_1},ArraySet$2=arraySet.ArraySet,quickSort=quickSort$1.quickSort;function SourceMapConsumer$2(e){var t=e;return"string"==typeof e&&(t=JSON.parse(e.replace(/^\)\]\}'/,""))),null!=t.sections?new IndexedSourceMapConsumer(t):new BasicSourceMapConsumer(t)}SourceMapConsumer$2.fromSourceMap=function(e){return BasicSourceMapConsumer.fromSourceMap(e)},SourceMapConsumer$2.prototype._version=3,SourceMapConsumer$2.prototype.__generatedMappings=null,Object.defineProperty(SourceMapConsumer$2.prototype,"_generatedMappings",{get:function(){return this.__generatedMappings||this._parseMappings(this._mappings,this.sourceRoot),this.__generatedMappings}}),SourceMapConsumer$2.prototype.__originalMappings=null,Object.defineProperty(SourceMapConsumer$2.prototype,"_originalMappings",{get:function(){return this.__originalMappings||this._parseMappings(this._mappings,this.sourceRoot),this.__originalMappings}}),SourceMapConsumer$2.prototype._charIsMappingSeparator=function(e,t){var r=e.charAt(t);return";"===r||","===r},SourceMapConsumer$2.prototype._parseMappings=function(e,t){throw new Error("Subclasses must implement _parseMappings")},SourceMapConsumer$2.GENERATED_ORDER=1,SourceMapConsumer$2.ORIGINAL_ORDER=2,SourceMapConsumer$2.GREATEST_LOWER_BOUND=1,SourceMapConsumer$2.LEAST_UPPER_BOUND=2,SourceMapConsumer$2.prototype.eachMapping=function(e,t,r){var n,i=t||null;switch(r||SourceMapConsumer$2.GENERATED_ORDER){case SourceMapConsumer$2.GENERATED_ORDER:n=this._generatedMappings;break;case SourceMapConsumer$2.ORIGINAL_ORDER:n=this._originalMappings;break;default:throw new Error("Unknown order of iteration.")}var a=this.sourceRoot;n.map(function(e){var t=null===e.source?null:this._sources.at(e.source);return null!=t&&null!=a&&(t=util.join(a,t)),{source:t,generatedLine:e.generatedLine,generatedColumn:e.generatedColumn,originalLine:e.originalLine,originalColumn:e.originalColumn,name:null===e.name?null:this._names.at(e.name)}},this).forEach(e,i);},SourceMapConsumer$2.prototype.allGeneratedPositionsFor=function(e){var t=util.getArg(e,"line"),r={source:util.getArg(e,"source"),originalLine:t,originalColumn:util.getArg(e,"column",0)};if(null!=this.sourceRoot&&(r.source=util.relative(this.sourceRoot,r.source)),!this._sources.has(r.source))return[];r.source=this._sources.indexOf(r.source);var n=[],i=this._findMapping(r,this._originalMappings,"originalLine","originalColumn",util.compareByOriginalPositions,binarySearch.LEAST_UPPER_BOUND);if(i>=0){var a=this._originalMappings[i];if(void 0===e.column)for(var o=a.originalLine;a&&a.originalLine===o;)n.push({line:util.getArg(a,"generatedLine",null),column:util.getArg(a,"generatedColumn",null),lastColumn:util.getArg(a,"lastGeneratedColumn",null)}),a=this._originalMappings[++i];else for(var s=a.originalColumn;a&&a.originalLine===t&&a.originalColumn==s;)n.push({line:util.getArg(a,"generatedLine",null),column:util.getArg(a,"generatedColumn",null),lastColumn:util.getArg(a,"lastGeneratedColumn",null)}),a=this._originalMappings[++i];}return n};var SourceMapConsumer_1=SourceMapConsumer$2;function BasicSourceMapConsumer(e){var t=e;"string"==typeof e&&(t=JSON.parse(e.replace(/^\)\]\}'/,"")));var r=util.getArg(t,"version"),n=util.getArg(t,"sources"),i=util.getArg(t,"names",[]),a=util.getArg(t,"sourceRoot",null),o=util.getArg(t,"sourcesContent",null),s=util.getArg(t,"mappings"),c=util.getArg(t,"file",null);if(r!=this._version)throw new Error("Unsupported version: "+r);n=n.map(String).map(util.normalize).map(function(e){return a&&util.isAbsolute(a)&&util.isAbsolute(e)?util.relative(a,e):e}),this._names=ArraySet$2.fromArray(i.map(String),!0),this._sources=ArraySet$2.fromArray(n,!0),this.sourceRoot=a,this.sourcesContent=o,this._mappings=s,this.file=c;}function Mapping(){this.generatedLine=0,this.generatedColumn=0,this.source=null,this.originalLine=null,this.originalColumn=null,this.name=null;}BasicSourceMapConsumer.prototype=Object.create(SourceMapConsumer$2.prototype),BasicSourceMapConsumer.prototype.consumer=SourceMapConsumer$2,BasicSourceMapConsumer.fromSourceMap=function(e){var t=Object.create(BasicSourceMapConsumer.prototype),r=t._names=ArraySet$2.fromArray(e._names.toArray(),!0),n=t._sources=ArraySet$2.fromArray(e._sources.toArray(),!0);t.sourceRoot=e._sourceRoot,t.sourcesContent=e._generateSourcesContent(t._sources.toArray(),t.sourceRoot),t.file=e._file;for(var i=e._mappings.toArray().slice(),a=t.__generatedMappings=[],o=t.__originalMappings=[],s=0,c=i.length;s<c;s++){var u=i[s],l=new Mapping;l.generatedLine=u.generatedLine,l.generatedColumn=u.generatedColumn,u.source&&(l.source=n.indexOf(u.source),l.originalLine=u.originalLine,l.originalColumn=u.originalColumn,u.name&&(l.name=r.indexOf(u.name)),o.push(l)),a.push(l);}return quickSort(t.__originalMappings,util.compareByOriginalPositions),t},BasicSourceMapConsumer.prototype._version=3,Object.defineProperty(BasicSourceMapConsumer.prototype,"sources",{get:function(){return this._sources.toArray().map(function(e){return null!=this.sourceRoot?util.join(this.sourceRoot,e):e},this)}}),BasicSourceMapConsumer.prototype._parseMappings=function(e,t){for(var r,n,i,a,o,s=1,c=0,u=0,l=0,_=0,d=0,p=e.length,f=0,m={},g={},y=[],h=[];f<p;)if(";"===e.charAt(f))s++,f++,c=0;else if(","===e.charAt(f))f++;else{for((r=new Mapping).generatedLine=s,a=f;a<p&&!this._charIsMappingSeparator(e,a);a++);if(i=m[n=e.slice(f,a)])f+=n.length;else{for(i=[];f<a;)base64Vlq.decode(e,f,g),o=g.value,f=g.rest,i.push(o);if(2===i.length)throw new Error("Found a source, but no line and column");if(3===i.length)throw new Error("Found a source and line, but no column");m[n]=i;}r.generatedColumn=c+i[0],c=r.generatedColumn,i.length>1&&(r.source=_+i[1],_+=i[1],r.originalLine=u+i[2],u=r.originalLine,r.originalLine+=1,r.originalColumn=l+i[3],l=r.originalColumn,i.length>4&&(r.name=d+i[4],d+=i[4])),h.push(r),"number"==typeof r.originalLine&&y.push(r);}quickSort(h,util.compareByGeneratedPositionsDeflated),this.__generatedMappings=h,quickSort(y,util.compareByOriginalPositions),this.__originalMappings=y;},BasicSourceMapConsumer.prototype._findMapping=function(e,t,r,n,i,a){if(e[r]<=0)throw new TypeError("Line must be greater than or equal to 1, got "+e[r]);if(e[n]<0)throw new TypeError("Column must be greater than or equal to 0, got "+e[n]);return binarySearch.search(e,t,i,a)},BasicSourceMapConsumer.prototype.computeColumnSpans=function(){for(var e=0;e<this._generatedMappings.length;++e){var t=this._generatedMappings[e];if(e+1<this._generatedMappings.length){var r=this._generatedMappings[e+1];if(t.generatedLine===r.generatedLine){t.lastGeneratedColumn=r.generatedColumn-1;continue}}t.lastGeneratedColumn=1/0;}},BasicSourceMapConsumer.prototype.originalPositionFor=function(e){var t={generatedLine:util.getArg(e,"line"),generatedColumn:util.getArg(e,"column")},r=this._findMapping(t,this._generatedMappings,"generatedLine","generatedColumn",util.compareByGeneratedPositionsDeflated,util.getArg(e,"bias",SourceMapConsumer$2.GREATEST_LOWER_BOUND));if(r>=0){var n=this._generatedMappings[r];if(n.generatedLine===t.generatedLine){var i=util.getArg(n,"source",null);null!==i&&(i=this._sources.at(i),null!=this.sourceRoot&&(i=util.join(this.sourceRoot,i)));var a=util.getArg(n,"name",null);return null!==a&&(a=this._names.at(a)),{source:i,line:util.getArg(n,"originalLine",null),column:util.getArg(n,"originalColumn",null),name:a}}}return{source:null,line:null,column:null,name:null}},BasicSourceMapConsumer.prototype.hasContentsOfAllSources=function(){return!!this.sourcesContent&&(this.sourcesContent.length>=this._sources.size()&&!this.sourcesContent.some(function(e){return null==e}))},BasicSourceMapConsumer.prototype.sourceContentFor=function(e,t){if(!this.sourcesContent)return null;if(null!=this.sourceRoot&&(e=util.relative(this.sourceRoot,e)),this._sources.has(e))return this.sourcesContent[this._sources.indexOf(e)];var r;if(null!=this.sourceRoot&&(r=util.urlParse(this.sourceRoot))){var n=e.replace(/^file:\/\//,"");if("file"==r.scheme&&this._sources.has(n))return this.sourcesContent[this._sources.indexOf(n)];if((!r.path||"/"==r.path)&&this._sources.has("/"+e))return this.sourcesContent[this._sources.indexOf("/"+e)]}if(t)return null;throw new Error('"'+e+'" is not in the SourceMap.')},BasicSourceMapConsumer.prototype.generatedPositionFor=function(e){var t=util.getArg(e,"source");if(null!=this.sourceRoot&&(t=util.relative(this.sourceRoot,t)),!this._sources.has(t))return{line:null,column:null,lastColumn:null};var r={source:t=this._sources.indexOf(t),originalLine:util.getArg(e,"line"),originalColumn:util.getArg(e,"column")},n=this._findMapping(r,this._originalMappings,"originalLine","originalColumn",util.compareByOriginalPositions,util.getArg(e,"bias",SourceMapConsumer$2.GREATEST_LOWER_BOUND));if(n>=0){var i=this._originalMappings[n];if(i.source===r.source)return{line:util.getArg(i,"generatedLine",null),column:util.getArg(i,"generatedColumn",null),lastColumn:util.getArg(i,"lastGeneratedColumn",null)}}return{line:null,column:null,lastColumn:null}};var BasicSourceMapConsumer_1=BasicSourceMapConsumer;function IndexedSourceMapConsumer(e){var t=e;"string"==typeof e&&(t=JSON.parse(e.replace(/^\)\]\}'/,"")));var r=util.getArg(t,"version"),n=util.getArg(t,"sections");if(r!=this._version)throw new Error("Unsupported version: "+r);this._sources=new ArraySet$2,this._names=new ArraySet$2;var i={line:-1,column:0};this._sections=n.map(function(e){if(e.url)throw new Error("Support for url field in sections not implemented.");var t=util.getArg(e,"offset"),r=util.getArg(t,"line"),n=util.getArg(t,"column");if(r<i.line||r===i.line&&n<i.column)throw new Error("Section offsets must be ordered and non-overlapping.");return i=t,{generatedOffset:{generatedLine:r+1,generatedColumn:n+1},consumer:new SourceMapConsumer$2(util.getArg(e,"map"))}});}IndexedSourceMapConsumer.prototype=Object.create(SourceMapConsumer$2.prototype),IndexedSourceMapConsumer.prototype.constructor=SourceMapConsumer$2,IndexedSourceMapConsumer.prototype._version=3,Object.defineProperty(IndexedSourceMapConsumer.prototype,"sources",{get:function(){for(var e=[],t=0;t<this._sections.length;t++)for(var r=0;r<this._sections[t].consumer.sources.length;r++)e.push(this._sections[t].consumer.sources[r]);return e}}),IndexedSourceMapConsumer.prototype.originalPositionFor=function(e){var t={generatedLine:util.getArg(e,"line"),generatedColumn:util.getArg(e,"column")},r=binarySearch.search(t,this._sections,function(e,t){var r=e.generatedLine-t.generatedOffset.generatedLine;return r||e.generatedColumn-t.generatedOffset.generatedColumn}),n=this._sections[r];return n?n.consumer.originalPositionFor({line:t.generatedLine-(n.generatedOffset.generatedLine-1),column:t.generatedColumn-(n.generatedOffset.generatedLine===t.generatedLine?n.generatedOffset.generatedColumn-1:0),bias:e.bias}):{source:null,line:null,column:null,name:null}},IndexedSourceMapConsumer.prototype.hasContentsOfAllSources=function(){return this._sections.every(function(e){return e.consumer.hasContentsOfAllSources()})},IndexedSourceMapConsumer.prototype.sourceContentFor=function(e,t){for(var r=0;r<this._sections.length;r++){var n=this._sections[r].consumer.sourceContentFor(e,!0);if(n)return n}if(t)return null;throw new Error('"'+e+'" is not in the SourceMap.')},IndexedSourceMapConsumer.prototype.generatedPositionFor=function(e){for(var t=0;t<this._sections.length;t++){var r=this._sections[t];if(-1!==r.consumer.sources.indexOf(util.getArg(e,"source"))){var n=r.consumer.generatedPositionFor(e);if(n)return{line:n.line+(r.generatedOffset.generatedLine-1),column:n.column+(r.generatedOffset.generatedLine===n.line?r.generatedOffset.generatedColumn-1:0)}}}return{line:null,column:null}},IndexedSourceMapConsumer.prototype._parseMappings=function(e,t){this.__generatedMappings=[],this.__originalMappings=[];for(var r=0;r<this._sections.length;r++)for(var n=this._sections[r],i=n.consumer._generatedMappings,a=0;a<i.length;a++){var o=i[a],s=n.consumer._sources.at(o.source);null!==n.consumer.sourceRoot&&(s=util.join(n.consumer.sourceRoot,s)),this._sources.add(s),s=this._sources.indexOf(s);var c=n.consumer._names.at(o.name);this._names.add(c),c=this._names.indexOf(c);var u={source:s,generatedLine:o.generatedLine+(n.generatedOffset.generatedLine-1),generatedColumn:o.generatedColumn+(n.generatedOffset.generatedLine===o.generatedLine?n.generatedOffset.generatedColumn-1:0),originalLine:o.originalLine,originalColumn:o.originalColumn,name:c};this.__generatedMappings.push(u),"number"==typeof u.originalLine&&this.__originalMappings.push(u);}quickSort(this.__generatedMappings,util.compareByGeneratedPositionsDeflated),quickSort(this.__originalMappings,util.compareByOriginalPositions);};var IndexedSourceMapConsumer_1=IndexedSourceMapConsumer,sourceMapConsumer={SourceMapConsumer:SourceMapConsumer_1,BasicSourceMapConsumer:BasicSourceMapConsumer_1,IndexedSourceMapConsumer:IndexedSourceMapConsumer_1},SourceMapGenerator$2=sourceMapGenerator.SourceMapGenerator,REGEX_NEWLINE=/(\r?\n)/,NEWLINE_CODE=10,isSourceNode="$$$isSourceNode$$$";function SourceNode$1(e,t,r,n,i){this.children=[],this.sourceContents={},this.line=null==e?null:e,this.column=null==t?null:t,this.source=null==r?null:r,this.name=null==i?null:i,this[isSourceNode]=!0,null!=n&&this.add(n);}SourceNode$1.fromStringWithSourceMap=function(e,t,r){var n=new SourceNode$1,i=e.split(REGEX_NEWLINE),a=function(){return i.shift()+(i.shift()||"")},o=1,s=0,c=null;return t.eachMapping(function(e){if(null!==c){if(!(o<e.generatedLine)){var t=(r=i[0]).substr(0,e.generatedColumn-s);return i[0]=r.substr(e.generatedColumn-s),s=e.generatedColumn,u(c,t),void(c=e)}u(c,a()),o++,s=0;}for(;o<e.generatedLine;)n.add(a()),o++;if(s<e.generatedColumn){var r=i[0];n.add(r.substr(0,e.generatedColumn)),i[0]=r.substr(e.generatedColumn),s=e.generatedColumn;}c=e;},this),i.length>0&&(c&&u(c,a()),n.add(i.join(""))),t.sources.forEach(function(e){var i=t.sourceContentFor(e);null!=i&&(null!=r&&(e=util.join(r,e)),n.setSourceContent(e,i));}),n;function u(e,t){if(null===e||void 0===e.source)n.add(t);else{var i=r?util.join(r,e.source):e.source;n.add(new SourceNode$1(e.originalLine,e.originalColumn,i,t,e.name));}}},SourceNode$1.prototype.add=function(e){if(Array.isArray(e))e.forEach(function(e){this.add(e);},this);else{if(!e[isSourceNode]&&"string"!=typeof e)throw new TypeError("Expected a SourceNode, string, or an array of SourceNodes and strings. Got "+e);e&&this.children.push(e);}return this},SourceNode$1.prototype.prepend=function(e){if(Array.isArray(e))for(var t=e.length-1;t>=0;t--)this.prepend(e[t]);else{if(!e[isSourceNode]&&"string"!=typeof e)throw new TypeError("Expected a SourceNode, string, or an array of SourceNodes and strings. Got "+e);this.children.unshift(e);}return this},SourceNode$1.prototype.walk=function(e){for(var t,r=0,n=this.children.length;r<n;r++)(t=this.children[r])[isSourceNode]?t.walk(e):""!==t&&e(t,{source:this.source,line:this.line,column:this.column,name:this.name});},SourceNode$1.prototype.join=function(e){var t,r,n=this.children.length;if(n>0){for(t=[],r=0;r<n-1;r++)t.push(this.children[r]),t.push(e);t.push(this.children[r]),this.children=t;}return this},SourceNode$1.prototype.replaceRight=function(e,t){var r=this.children[this.children.length-1];return r[isSourceNode]?r.replaceRight(e,t):"string"==typeof r?this.children[this.children.length-1]=r.replace(e,t):this.children.push("".replace(e,t)),this},SourceNode$1.prototype.setSourceContent=function(e,t){this.sourceContents[util.toSetString(e)]=t;},SourceNode$1.prototype.walkSourceContents=function(e){for(var t=0,r=this.children.length;t<r;t++)this.children[t][isSourceNode]&&this.children[t].walkSourceContents(e);var n=Object.keys(this.sourceContents);for(t=0,r=n.length;t<r;t++)e(util.fromSetString(n[t]),this.sourceContents[n[t]]);},SourceNode$1.prototype.toString=function(){var e="";return this.walk(function(t){e+=t;}),e},SourceNode$1.prototype.toStringWithSourceMap=function(e){var t={code:"",line:1,column:0},r=new SourceMapGenerator$2(e),n=!1,i=null,a=null,o=null,s=null;return this.walk(function(e,c){t.code+=e,null!==c.source&&null!==c.line&&null!==c.column?(i===c.source&&a===c.line&&o===c.column&&s===c.name||r.addMapping({source:c.source,original:{line:c.line,column:c.column},generated:{line:t.line,column:t.column},name:c.name}),i=c.source,a=c.line,o=c.column,s=c.name,n=!0):n&&(r.addMapping({generated:{line:t.line,column:t.column}}),i=null,n=!1);for(var u=0,l=e.length;u<l;u++)e.charCodeAt(u)===NEWLINE_CODE?(t.line++,t.column=0,u+1===l?(i=null,n=!1):n&&r.addMapping({source:c.source,original:{line:c.line,column:c.column},generated:{line:t.line,column:t.column},name:c.name})):t.column++;}),this.walkSourceContents(function(e,t){r.setSourceContent(e,t);}),{code:t.code,map:r}};var fs$1,SourceNode_1=SourceNode$1,sourceNode={SourceNode:SourceNode_1},SourceMapGenerator=sourceMapGenerator.SourceMapGenerator,SourceMapConsumer$1=sourceMapConsumer.SourceMapConsumer,SourceNode=sourceNode.SourceNode,sourceMap={SourceMapGenerator:SourceMapGenerator,SourceMapConsumer:SourceMapConsumer$1,SourceNode:SourceNode},SourceMapConsumer=sourceMap.SourceMapConsumer,path$1=path$$1;try{(fs$1=fs$$1).existsSync&&fs$1.readFileSync||(fs$1=null);}catch(e){}var errorFormatterInstalled=!1,uncaughtShimInstalled=!1,emptyCacheBetweenOperations=!1,environment="auto",fileContentsCache={},sourceMapCache={},reSourceMap=/^data:application\/json[^,]+base64,/,retrieveFileHandlers=[],retrieveMapHandlers=[];function isInBrowser(){return"browser"===environment||"node"!==environment&&("undefined"!=typeof window&&"function"==typeof XMLHttpRequest&&!(window.require&&window.module&&window.process&&"renderer"===window.process.type))}function hasGlobalProcessEventEmitter(){return"object"==typeof process&&null!==process&&"function"==typeof process.on}function handlerExec(e){return function(t){for(var r=0;r<e.length;r++){var n=e[r](t);if(n)return n}return null}}var retrieveFile=handlerExec(retrieveFileHandlers);function supportRelativeURL(e,t){if(!e)return t;var r=path$1.dirname(e),n=/^\w+:\/\/[^\/]*/.exec(r),i=n?n[0]:"";return i+path$1.resolve(r.slice(i.length),t)}function retrieveSourceMapURL(e){var t;if(isInBrowser())try{var r=new XMLHttpRequest;r.open("GET",e,!1),r.send(null),t=4===r.readyState?r.responseText:null;var n=r.getResponseHeader("SourceMap")||r.getResponseHeader("X-SourceMap");if(n)return n}catch(e){}t=retrieveFile(e);for(var i,a,o=/(?:\/\/[@#][ \t]+sourceMappingURL=([^\s'"]+?)[ \t]*$)|(?:\/\*[@#][ \t]+sourceMappingURL=([^\*]+?)[ \t]*(?:\*\/)[ \t]*$)/gm;a=o.exec(t);)i=a;return i?i[1]:null}retrieveFileHandlers.push(function(e){if((e=e.trim())in fileContentsCache)return fileContentsCache[e];var t=null;if(fs$1)fs$1.existsSync(e)&&(t=fs$1.readFileSync(e,"utf8"));else{var r=new XMLHttpRequest;r.open("GET",e,!1),r.send(null);t=null;4===r.readyState&&200===r.status&&(t=r.responseText);}return fileContentsCache[e]=t});var retrieveSourceMap=handlerExec(retrieveMapHandlers);function mapSourcePosition(e){var t=sourceMapCache[e.source];if(!t){var r=retrieveSourceMap(e.source);r?(t=sourceMapCache[e.source]={url:r.url,map:new SourceMapConsumer(r.map)}).map.sourcesContent&&t.map.sources.forEach(function(e,r){var n=t.map.sourcesContent[r];if(n){var i=supportRelativeURL(t.url,e);fileContentsCache[i]=n;}}):t=sourceMapCache[e.source]={url:null,map:null};}if(t&&t.map){var n=t.map.originalPositionFor(e);if(null!==n.source)return n.source=supportRelativeURL(t.url,n.source),n}return e}function mapEvalOrigin(e){var t=/^eval at ([^(]+) \((.+):(\d+):(\d+)\)$/.exec(e);if(t){var r=mapSourcePosition({source:t[2],line:+t[3],column:t[4]-1});return"eval at "+t[1]+" ("+r.source+":"+r.line+":"+(r.column+1)+")"}return(t=/^eval at ([^(]+) \((.+)\)$/.exec(e))?"eval at "+t[1]+" ("+mapEvalOrigin(t[2])+")":e}function CallSiteToString(){var e,t="";if(this.isNative())t="native";else{!(e=this.getScriptNameOrSourceURL())&&this.isEval()&&(t=this.getEvalOrigin(),t+=", "),t+=e||"<anonymous>";var r=this.getLineNumber();if(null!=r){t+=":"+r;var n=this.getColumnNumber();n&&(t+=":"+n);}}var i="",a=this.getFunctionName(),o=!0,s=this.isConstructor();if(!(this.isToplevel()||s)){var c=this.getTypeName();"[object Object]"===c&&(c="null");var u=this.getMethodName();a?(c&&0!=a.indexOf(c)&&(i+=c+"."),i+=a,u&&a.indexOf("."+u)!=a.length-u.length-1&&(i+=" [as "+u+"]")):i+=c+"."+(u||"<anonymous>");}else s?i+="new "+(a||"<anonymous>"):a?i+=a:(i+=t,o=!1);return o&&(i+=" ("+t+")"),i}function cloneCallSite(e){var t={};return Object.getOwnPropertyNames(Object.getPrototypeOf(e)).forEach(function(r){t[r]=/^(?:is|get)/.test(r)?function(){return e[r].call(e)}:e[r];}),t.toString=CallSiteToString,t}function wrapCallSite(e){if(e.isNative())return e;var t=e.getFileName()||e.getScriptNameOrSourceURL();if(t){var r=e.getLineNumber(),n=e.getColumnNumber()-1;1!==r||isInBrowser()||e.isEval()||(n-=62);var i=mapSourcePosition({source:t,line:r,column:n});return(e=cloneCallSite(e)).getFileName=function(){return i.source},e.getLineNumber=function(){return i.line},e.getColumnNumber=function(){return i.column+1},e.getScriptNameOrSourceURL=function(){return i.source},e}var a=e.isEval()&&e.getEvalOrigin();return a?(a=mapEvalOrigin(a),(e=cloneCallSite(e)).getEvalOrigin=function(){return a},e):e}function prepareStackTrace(e,t){return emptyCacheBetweenOperations&&(fileContentsCache={},sourceMapCache={}),e+t.map(function(e){return"\n    at "+wrapCallSite(e)}).join("")}function getErrorSource(e){var t=/\n    at [^(]+ \((.*):(\d+):(\d+)\)/.exec(e.stack);if(t){var r=t[1],n=+t[2],i=+t[3],a=fileContentsCache[r];if(!a&&fs$1&&fs$1.existsSync(r)&&(a=fs$1.readFileSync(r,"utf8")),a){var o=a.split(/(?:\r\n|\r|\n)/)[n-1];if(o)return r+":"+n+"\n"+o+"\n"+new Array(i).join(" ")+"^"}}return null}function printErrorAndExit(e){var t=getErrorSource(e);t&&(console.error(),console.error(t)),console.error(e.stack),process.exit(1);}function shimEmitUncaughtException(){var e=process.emit;process.emit=function(t){if("uncaughtException"===t){var r=arguments[1]&&arguments[1].stack,n=this.listeners(t).length>0;if(r&&!n)return printErrorAndExit(arguments[1])}return e.apply(this,arguments)};}retrieveMapHandlers.push(function(e){var t,r=retrieveSourceMapURL(e);if(!r)return null;if(reSourceMap.test(r)){var n=r.slice(r.indexOf(",")+1);t=new Buffer(n,"base64").toString(),r=e;}else r=supportRelativeURL(e,r),t=retrieveFile(r);return t?{url:r,map:t}:null});var wrapCallSite_1=wrapCallSite,getErrorSource_1=getErrorSource,mapSourcePosition_1=mapSourcePosition,retrieveSourceMap_1=retrieveSourceMap,install=function(e){if((e=e||{}).environment&&(environment=e.environment,-1===["node","browser","auto"].indexOf(environment)))throw new Error("environment "+environment+" was unknown. Available options are {auto, browser, node}");if(e.retrieveFile&&(e.overrideRetrieveFile&&(retrieveFileHandlers.length=0),retrieveFileHandlers.unshift(e.retrieveFile)),e.retrieveSourceMap&&(e.overrideRetrieveSourceMap&&(retrieveMapHandlers.length=0),retrieveMapHandlers.unshift(e.retrieveSourceMap)),e.hookRequire&&!isInBrowser()){var t;try{t=module$1$$1;}catch(e){}var r=t.prototype._compile;r.__sourceMapSupport||(t.prototype._compile=function(e,t){return fileContentsCache[t]=e,sourceMapCache[t]=void 0,r.call(this,e,t)},t.prototype._compile.__sourceMapSupport=!0);}(emptyCacheBetweenOperations||(emptyCacheBetweenOperations="emptyCacheBetweenOperations"in e&&e.emptyCacheBetweenOperations),errorFormatterInstalled||(errorFormatterInstalled=!0,Error.prepareStackTrace=prepareStackTrace),uncaughtShimInstalled)||(!("handleUncaughtExceptions"in e)||e.handleUncaughtExceptions)&&hasGlobalProcessEventEmitter()&&(uncaughtShimInstalled=!0,shimEmitUncaughtException());},sourceMapSupport={wrapCallSite:wrapCallSite_1,getErrorSource:getErrorSource_1,mapSourcePosition:mapSourcePosition_1,retrieveSourceMap:retrieveSourceMap_1,install:install},typescript=createCommonjsModule$$1(function(e){var t,r=commonjsGlobal$$1&&commonjsGlobal$$1.__assign||Object.assign||function(e){for(var t,r=1,n=arguments.length;r<n;r++)for(var i in t=arguments[r])Object.prototype.hasOwnProperty.call(t,i)&&(e[i]=t[i]);return e},n=commonjsGlobal$$1&&commonjsGlobal$$1.__extends||(t=Object.setPrototypeOf||{__proto__:[]}instanceof Array&&function(e,t){e.__proto__=t;}||function(e,t){for(var r in t)t.hasOwnProperty(r)&&(e[r]=t[r]);},function(e,r){function n(){this.constructor=e;}t(e,r),e.prototype=null===r?Object.create(r):(n.prototype=r.prototype,new n);});!function(e){!function(e){e[e.LessThan=-1]="LessThan",e[e.EqualTo=0]="EqualTo",e[e.GreaterThan=1]="GreaterThan";}(e.Comparison||(e.Comparison={})),function(e){e[e.Unknown=0]="Unknown",e[e.EndOfFileToken=1]="EndOfFileToken",e[e.SingleLineCommentTrivia=2]="SingleLineCommentTrivia",e[e.MultiLineCommentTrivia=3]="MultiLineCommentTrivia",e[e.NewLineTrivia=4]="NewLineTrivia",e[e.WhitespaceTrivia=5]="WhitespaceTrivia",e[e.ShebangTrivia=6]="ShebangTrivia",e[e.ConflictMarkerTrivia=7]="ConflictMarkerTrivia",e[e.NumericLiteral=8]="NumericLiteral",e[e.StringLiteral=9]="StringLiteral",e[e.JsxText=10]="JsxText",e[e.JsxTextAllWhiteSpaces=11]="JsxTextAllWhiteSpaces",e[e.RegularExpressionLiteral=12]="RegularExpressionLiteral",e[e.NoSubstitutionTemplateLiteral=13]="NoSubstitutionTemplateLiteral",e[e.TemplateHead=14]="TemplateHead",e[e.TemplateMiddle=15]="TemplateMiddle",e[e.TemplateTail=16]="TemplateTail",e[e.OpenBraceToken=17]="OpenBraceToken",e[e.CloseBraceToken=18]="CloseBraceToken",e[e.OpenParenToken=19]="OpenParenToken",e[e.CloseParenToken=20]="CloseParenToken",e[e.OpenBracketToken=21]="OpenBracketToken",e[e.CloseBracketToken=22]="CloseBracketToken",e[e.DotToken=23]="DotToken",e[e.DotDotDotToken=24]="DotDotDotToken",e[e.SemicolonToken=25]="SemicolonToken",e[e.CommaToken=26]="CommaToken",e[e.LessThanToken=27]="LessThanToken",e[e.LessThanSlashToken=28]="LessThanSlashToken",e[e.GreaterThanToken=29]="GreaterThanToken",e[e.LessThanEqualsToken=30]="LessThanEqualsToken",e[e.GreaterThanEqualsToken=31]="GreaterThanEqualsToken",e[e.EqualsEqualsToken=32]="EqualsEqualsToken",e[e.ExclamationEqualsToken=33]="ExclamationEqualsToken",e[e.EqualsEqualsEqualsToken=34]="EqualsEqualsEqualsToken",e[e.ExclamationEqualsEqualsToken=35]="ExclamationEqualsEqualsToken",e[e.EqualsGreaterThanToken=36]="EqualsGreaterThanToken",e[e.PlusToken=37]="PlusToken",e[e.MinusToken=38]="MinusToken",e[e.AsteriskToken=39]="AsteriskToken",e[e.AsteriskAsteriskToken=40]="AsteriskAsteriskToken",e[e.SlashToken=41]="SlashToken",e[e.PercentToken=42]="PercentToken",e[e.PlusPlusToken=43]="PlusPlusToken",e[e.MinusMinusToken=44]="MinusMinusToken",e[e.LessThanLessThanToken=45]="LessThanLessThanToken",e[e.GreaterThanGreaterThanToken=46]="GreaterThanGreaterThanToken",e[e.GreaterThanGreaterThanGreaterThanToken=47]="GreaterThanGreaterThanGreaterThanToken",e[e.AmpersandToken=48]="AmpersandToken",e[e.BarToken=49]="BarToken",e[e.CaretToken=50]="CaretToken",e[e.ExclamationToken=51]="ExclamationToken",e[e.TildeToken=52]="TildeToken",e[e.AmpersandAmpersandToken=53]="AmpersandAmpersandToken",e[e.BarBarToken=54]="BarBarToken",e[e.QuestionToken=55]="QuestionToken",e[e.ColonToken=56]="ColonToken",e[e.AtToken=57]="AtToken",e[e.EqualsToken=58]="EqualsToken",e[e.PlusEqualsToken=59]="PlusEqualsToken",e[e.MinusEqualsToken=60]="MinusEqualsToken",e[e.AsteriskEqualsToken=61]="AsteriskEqualsToken",e[e.AsteriskAsteriskEqualsToken=62]="AsteriskAsteriskEqualsToken",e[e.SlashEqualsToken=63]="SlashEqualsToken",e[e.PercentEqualsToken=64]="PercentEqualsToken",e[e.LessThanLessThanEqualsToken=65]="LessThanLessThanEqualsToken",e[e.GreaterThanGreaterThanEqualsToken=66]="GreaterThanGreaterThanEqualsToken",e[e.GreaterThanGreaterThanGreaterThanEqualsToken=67]="GreaterThanGreaterThanGreaterThanEqualsToken",e[e.AmpersandEqualsToken=68]="AmpersandEqualsToken",e[e.BarEqualsToken=69]="BarEqualsToken",e[e.CaretEqualsToken=70]="CaretEqualsToken",e[e.Identifier=71]="Identifier",e[e.BreakKeyword=72]="BreakKeyword",e[e.CaseKeyword=73]="CaseKeyword",e[e.CatchKeyword=74]="CatchKeyword",e[e.ClassKeyword=75]="ClassKeyword",e[e.ConstKeyword=76]="ConstKeyword",e[e.ContinueKeyword=77]="ContinueKeyword",e[e.DebuggerKeyword=78]="DebuggerKeyword",e[e.DefaultKeyword=79]="DefaultKeyword",e[e.DeleteKeyword=80]="DeleteKeyword",e[e.DoKeyword=81]="DoKeyword",e[e.ElseKeyword=82]="ElseKeyword",e[e.EnumKeyword=83]="EnumKeyword",e[e.ExportKeyword=84]="ExportKeyword",e[e.ExtendsKeyword=85]="ExtendsKeyword",e[e.FalseKeyword=86]="FalseKeyword",e[e.FinallyKeyword=87]="FinallyKeyword",e[e.ForKeyword=88]="ForKeyword",e[e.FunctionKeyword=89]="FunctionKeyword",e[e.IfKeyword=90]="IfKeyword",e[e.ImportKeyword=91]="ImportKeyword",e[e.InKeyword=92]="InKeyword",e[e.InstanceOfKeyword=93]="InstanceOfKeyword",e[e.NewKeyword=94]="NewKeyword",e[e.NullKeyword=95]="NullKeyword",e[e.ReturnKeyword=96]="ReturnKeyword",e[e.SuperKeyword=97]="SuperKeyword",e[e.SwitchKeyword=98]="SwitchKeyword",e[e.ThisKeyword=99]="ThisKeyword",e[e.ThrowKeyword=100]="ThrowKeyword",e[e.TrueKeyword=101]="TrueKeyword",e[e.TryKeyword=102]="TryKeyword",e[e.TypeOfKeyword=103]="TypeOfKeyword",e[e.VarKeyword=104]="VarKeyword",e[e.VoidKeyword=105]="VoidKeyword",e[e.WhileKeyword=106]="WhileKeyword",e[e.WithKeyword=107]="WithKeyword",e[e.ImplementsKeyword=108]="ImplementsKeyword",e[e.InterfaceKeyword=109]="InterfaceKeyword",e[e.LetKeyword=110]="LetKeyword",e[e.PackageKeyword=111]="PackageKeyword",e[e.PrivateKeyword=112]="PrivateKeyword",e[e.ProtectedKeyword=113]="ProtectedKeyword",e[e.PublicKeyword=114]="PublicKeyword",e[e.StaticKeyword=115]="StaticKeyword",e[e.YieldKeyword=116]="YieldKeyword",e[e.AbstractKeyword=117]="AbstractKeyword",e[e.AsKeyword=118]="AsKeyword",e[e.AnyKeyword=119]="AnyKeyword",e[e.AsyncKeyword=120]="AsyncKeyword",e[e.AwaitKeyword=121]="AwaitKeyword",e[e.BooleanKeyword=122]="BooleanKeyword",e[e.ConstructorKeyword=123]="ConstructorKeyword",e[e.DeclareKeyword=124]="DeclareKeyword",e[e.GetKeyword=125]="GetKeyword",e[e.InferKeyword=126]="InferKeyword",e[e.IsKeyword=127]="IsKeyword",e[e.KeyOfKeyword=128]="KeyOfKeyword",e[e.ModuleKeyword=129]="ModuleKeyword",e[e.NamespaceKeyword=130]="NamespaceKeyword",e[e.NeverKeyword=131]="NeverKeyword",e[e.ReadonlyKeyword=132]="ReadonlyKeyword",e[e.RequireKeyword=133]="RequireKeyword",e[e.NumberKeyword=134]="NumberKeyword",e[e.ObjectKeyword=135]="ObjectKeyword",e[e.SetKeyword=136]="SetKeyword",e[e.StringKeyword=137]="StringKeyword",e[e.SymbolKeyword=138]="SymbolKeyword",e[e.TypeKeyword=139]="TypeKeyword",e[e.UndefinedKeyword=140]="UndefinedKeyword",e[e.UniqueKeyword=141]="UniqueKeyword",e[e.FromKeyword=142]="FromKeyword",e[e.GlobalKeyword=143]="GlobalKeyword",e[e.OfKeyword=144]="OfKeyword",e[e.QualifiedName=145]="QualifiedName",e[e.ComputedPropertyName=146]="ComputedPropertyName",e[e.TypeParameter=147]="TypeParameter",e[e.Parameter=148]="Parameter",e[e.Decorator=149]="Decorator",e[e.PropertySignature=150]="PropertySignature",e[e.PropertyDeclaration=151]="PropertyDeclaration",e[e.MethodSignature=152]="MethodSignature",e[e.MethodDeclaration=153]="MethodDeclaration",e[e.Constructor=154]="Constructor",e[e.GetAccessor=155]="GetAccessor",e[e.SetAccessor=156]="SetAccessor",e[e.CallSignature=157]="CallSignature",e[e.ConstructSignature=158]="ConstructSignature",e[e.IndexSignature=159]="IndexSignature",e[e.TypePredicate=160]="TypePredicate",e[e.TypeReference=161]="TypeReference",e[e.FunctionType=162]="FunctionType",e[e.ConstructorType=163]="ConstructorType",e[e.TypeQuery=164]="TypeQuery",e[e.TypeLiteral=165]="TypeLiteral",e[e.ArrayType=166]="ArrayType",e[e.TupleType=167]="TupleType",e[e.UnionType=168]="UnionType",e[e.IntersectionType=169]="IntersectionType",e[e.ConditionalType=170]="ConditionalType",e[e.InferType=171]="InferType",e[e.ParenthesizedType=172]="ParenthesizedType",e[e.ThisType=173]="ThisType",e[e.TypeOperator=174]="TypeOperator",e[e.IndexedAccessType=175]="IndexedAccessType",e[e.MappedType=176]="MappedType",e[e.LiteralType=177]="LiteralType",e[e.ObjectBindingPattern=178]="ObjectBindingPattern",e[e.ArrayBindingPattern=179]="ArrayBindingPattern",e[e.BindingElement=180]="BindingElement",e[e.ArrayLiteralExpression=181]="ArrayLiteralExpression",e[e.ObjectLiteralExpression=182]="ObjectLiteralExpression",e[e.PropertyAccessExpression=183]="PropertyAccessExpression",e[e.ElementAccessExpression=184]="ElementAccessExpression",e[e.CallExpression=185]="CallExpression",e[e.NewExpression=186]="NewExpression",e[e.TaggedTemplateExpression=187]="TaggedTemplateExpression",e[e.TypeAssertionExpression=188]="TypeAssertionExpression",e[e.ParenthesizedExpression=189]="ParenthesizedExpression",e[e.FunctionExpression=190]="FunctionExpression",e[e.ArrowFunction=191]="ArrowFunction",e[e.DeleteExpression=192]="DeleteExpression",e[e.TypeOfExpression=193]="TypeOfExpression",e[e.VoidExpression=194]="VoidExpression",e[e.AwaitExpression=195]="AwaitExpression",e[e.PrefixUnaryExpression=196]="PrefixUnaryExpression",e[e.PostfixUnaryExpression=197]="PostfixUnaryExpression",e[e.BinaryExpression=198]="BinaryExpression",e[e.ConditionalExpression=199]="ConditionalExpression",e[e.TemplateExpression=200]="TemplateExpression",e[e.YieldExpression=201]="YieldExpression",e[e.SpreadElement=202]="SpreadElement",e[e.ClassExpression=203]="ClassExpression",e[e.OmittedExpression=204]="OmittedExpression",e[e.ExpressionWithTypeArguments=205]="ExpressionWithTypeArguments",e[e.AsExpression=206]="AsExpression",e[e.NonNullExpression=207]="NonNullExpression",e[e.MetaProperty=208]="MetaProperty",e[e.TemplateSpan=209]="TemplateSpan",e[e.SemicolonClassElement=210]="SemicolonClassElement",e[e.Block=211]="Block",e[e.VariableStatement=212]="VariableStatement",e[e.EmptyStatement=213]="EmptyStatement",e[e.ExpressionStatement=214]="ExpressionStatement",e[e.IfStatement=215]="IfStatement",e[e.DoStatement=216]="DoStatement",e[e.WhileStatement=217]="WhileStatement",e[e.ForStatement=218]="ForStatement",e[e.ForInStatement=219]="ForInStatement",e[e.ForOfStatement=220]="ForOfStatement",e[e.ContinueStatement=221]="ContinueStatement",e[e.BreakStatement=222]="BreakStatement",e[e.ReturnStatement=223]="ReturnStatement",e[e.WithStatement=224]="WithStatement",e[e.SwitchStatement=225]="SwitchStatement",e[e.LabeledStatement=226]="LabeledStatement",e[e.ThrowStatement=227]="ThrowStatement",e[e.TryStatement=228]="TryStatement",e[e.DebuggerStatement=229]="DebuggerStatement",e[e.VariableDeclaration=230]="VariableDeclaration",e[e.VariableDeclarationList=231]="VariableDeclarationList",e[e.FunctionDeclaration=232]="FunctionDeclaration",e[e.ClassDeclaration=233]="ClassDeclaration",e[e.InterfaceDeclaration=234]="InterfaceDeclaration",e[e.TypeAliasDeclaration=235]="TypeAliasDeclaration",e[e.EnumDeclaration=236]="EnumDeclaration",e[e.ModuleDeclaration=237]="ModuleDeclaration",e[e.ModuleBlock=238]="ModuleBlock",e[e.CaseBlock=239]="CaseBlock",e[e.NamespaceExportDeclaration=240]="NamespaceExportDeclaration",e[e.ImportEqualsDeclaration=241]="ImportEqualsDeclaration",e[e.ImportDeclaration=242]="ImportDeclaration",e[e.ImportClause=243]="ImportClause",e[e.NamespaceImport=244]="NamespaceImport",e[e.NamedImports=245]="NamedImports",e[e.ImportSpecifier=246]="ImportSpecifier",e[e.ExportAssignment=247]="ExportAssignment",e[e.ExportDeclaration=248]="ExportDeclaration",e[e.NamedExports=249]="NamedExports",e[e.ExportSpecifier=250]="ExportSpecifier",e[e.MissingDeclaration=251]="MissingDeclaration",e[e.ExternalModuleReference=252]="ExternalModuleReference",e[e.JsxElement=253]="JsxElement",e[e.JsxSelfClosingElement=254]="JsxSelfClosingElement",e[e.JsxOpeningElement=255]="JsxOpeningElement",e[e.JsxClosingElement=256]="JsxClosingElement",e[e.JsxFragment=257]="JsxFragment",e[e.JsxOpeningFragment=258]="JsxOpeningFragment",e[e.JsxClosingFragment=259]="JsxClosingFragment",e[e.JsxAttribute=260]="JsxAttribute",e[e.JsxAttributes=261]="JsxAttributes",e[e.JsxSpreadAttribute=262]="JsxSpreadAttribute",e[e.JsxExpression=263]="JsxExpression",e[e.CaseClause=264]="CaseClause",e[e.DefaultClause=265]="DefaultClause",e[e.HeritageClause=266]="HeritageClause",e[e.CatchClause=267]="CatchClause",e[e.PropertyAssignment=268]="PropertyAssignment",e[e.ShorthandPropertyAssignment=269]="ShorthandPropertyAssignment",e[e.SpreadAssignment=270]="SpreadAssignment",e[e.EnumMember=271]="EnumMember",e[e.SourceFile=272]="SourceFile",e[e.Bundle=273]="Bundle",e[e.JSDocTypeExpression=274]="JSDocTypeExpression",e[e.JSDocAllType=275]="JSDocAllType",e[e.JSDocUnknownType=276]="JSDocUnknownType",e[e.JSDocNullableType=277]="JSDocNullableType",e[e.JSDocNonNullableType=278]="JSDocNonNullableType",e[e.JSDocOptionalType=279]="JSDocOptionalType",e[e.JSDocFunctionType=280]="JSDocFunctionType",e[e.JSDocVariadicType=281]="JSDocVariadicType",e[e.JSDocComment=282]="JSDocComment",e[e.JSDocTypeLiteral=283]="JSDocTypeLiteral",e[e.JSDocTag=284]="JSDocTag",e[e.JSDocAugmentsTag=285]="JSDocAugmentsTag",e[e.JSDocClassTag=286]="JSDocClassTag",e[e.JSDocParameterTag=287]="JSDocParameterTag",e[e.JSDocReturnTag=288]="JSDocReturnTag",e[e.JSDocTypeTag=289]="JSDocTypeTag",e[e.JSDocTemplateTag=290]="JSDocTemplateTag",e[e.JSDocTypedefTag=291]="JSDocTypedefTag",e[e.JSDocPropertyTag=292]="JSDocPropertyTag",e[e.SyntaxList=293]="SyntaxList",e[e.NotEmittedStatement=294]="NotEmittedStatement",e[e.PartiallyEmittedExpression=295]="PartiallyEmittedExpression",e[e.CommaListExpression=296]="CommaListExpression",e[e.MergeDeclarationMarker=297]="MergeDeclarationMarker",e[e.EndOfDeclarationMarker=298]="EndOfDeclarationMarker",e[e.Count=299]="Count",e[e.FirstAssignment=58]="FirstAssignment",e[e.LastAssignment=70]="LastAssignment",e[e.FirstCompoundAssignment=59]="FirstCompoundAssignment",e[e.LastCompoundAssignment=70]="LastCompoundAssignment",e[e.FirstReservedWord=72]="FirstReservedWord",e[e.LastReservedWord=107]="LastReservedWord",e[e.FirstKeyword=72]="FirstKeyword",e[e.LastKeyword=144]="LastKeyword",e[e.FirstFutureReservedWord=108]="FirstFutureReservedWord",e[e.LastFutureReservedWord=116]="LastFutureReservedWord",e[e.FirstTypeNode=160]="FirstTypeNode",e[e.LastTypeNode=177]="LastTypeNode",e[e.FirstPunctuation=17]="FirstPunctuation",e[e.LastPunctuation=70]="LastPunctuation",e[e.FirstToken=0]="FirstToken",e[e.LastToken=144]="LastToken",e[e.FirstTriviaToken=2]="FirstTriviaToken",e[e.LastTriviaToken=7]="LastTriviaToken",e[e.FirstLiteralToken=8]="FirstLiteralToken",e[e.LastLiteralToken=13]="LastLiteralToken",e[e.FirstTemplateToken=13]="FirstTemplateToken",e[e.LastTemplateToken=16]="LastTemplateToken",e[e.FirstBinaryOperator=27]="FirstBinaryOperator",e[e.LastBinaryOperator=70]="LastBinaryOperator",e[e.FirstNode=145]="FirstNode",e[e.FirstJSDocNode=274]="FirstJSDocNode",e[e.LastJSDocNode=292]="LastJSDocNode",e[e.FirstJSDocTagNode=284]="FirstJSDocTagNode",e[e.LastJSDocTagNode=292]="LastJSDocTagNode",e[e.FirstContextualKeyword=117]="FirstContextualKeyword",e[e.LastContextualKeyword=144]="LastContextualKeyword";}(e.SyntaxKind||(e.SyntaxKind={})),function(e){e[e.None=0]="None",e[e.Let=1]="Let",e[e.Const=2]="Const",e[e.NestedNamespace=4]="NestedNamespace",e[e.Synthesized=8]="Synthesized",e[e.Namespace=16]="Namespace",e[e.ExportContext=32]="ExportContext",e[e.ContainsThis=64]="ContainsThis",e[e.HasImplicitReturn=128]="HasImplicitReturn",e[e.HasExplicitReturn=256]="HasExplicitReturn",e[e.GlobalAugmentation=512]="GlobalAugmentation",e[e.HasAsyncFunctions=1024]="HasAsyncFunctions",e[e.DisallowInContext=2048]="DisallowInContext",e[e.YieldContext=4096]="YieldContext",e[e.DecoratorContext=8192]="DecoratorContext",e[e.AwaitContext=16384]="AwaitContext",e[e.ThisNodeHasError=32768]="ThisNodeHasError",e[e.JavaScriptFile=65536]="JavaScriptFile",e[e.ThisNodeOrAnySubNodesHasError=131072]="ThisNodeOrAnySubNodesHasError",e[e.HasAggregatedChildData=262144]="HasAggregatedChildData",e[e.PossiblyContainsDynamicImport=524288]="PossiblyContainsDynamicImport",e[e.JSDoc=1048576]="JSDoc",e[e.Ambient=2097152]="Ambient",e[e.InWithStatement=4194304]="InWithStatement",e[e.BlockScoped=3]="BlockScoped",e[e.ReachabilityCheckFlags=384]="ReachabilityCheckFlags",e[e.ReachabilityAndEmitFlags=1408]="ReachabilityAndEmitFlags",e[e.ContextFlags=6387712]="ContextFlags",e[e.TypeExcludesFlags=20480]="TypeExcludesFlags";}(e.NodeFlags||(e.NodeFlags={})),function(e){e[e.None=0]="None",e[e.Export=1]="Export",e[e.Ambient=2]="Ambient",e[e.Public=4]="Public",e[e.Private=8]="Private",e[e.Protected=16]="Protected",e[e.Static=32]="Static",e[e.Readonly=64]="Readonly",e[e.Abstract=128]="Abstract",e[e.Async=256]="Async",e[e.Default=512]="Default",e[e.Const=2048]="Const",e[e.HasComputedFlags=536870912]="HasComputedFlags",e[e.AccessibilityModifier=28]="AccessibilityModifier",e[e.ParameterPropertyModifier=92]="ParameterPropertyModifier",e[e.NonPublicAccessibilityModifier=24]="NonPublicAccessibilityModifier",e[e.TypeScriptModifier=2270]="TypeScriptModifier",e[e.ExportDefault=513]="ExportDefault";}(e.ModifierFlags||(e.ModifierFlags={})),function(e){e[e.None=0]="None",e[e.IntrinsicNamedElement=1]="IntrinsicNamedElement",e[e.IntrinsicIndexedElement=2]="IntrinsicIndexedElement",e[e.IntrinsicElement=3]="IntrinsicElement";}(e.JsxFlags||(e.JsxFlags={})),function(e){e[e.Succeeded=1]="Succeeded",e[e.Failed=2]="Failed",e[e.FailedAndReported=3]="FailedAndReported";}(e.RelationComparisonResult||(e.RelationComparisonResult={})),function(e){e[e.None=0]="None",e[e.Auto=1]="Auto",e[e.Loop=2]="Loop",e[e.Unique=3]="Unique",e[e.Node=4]="Node",e[e.KindMask=7]="KindMask",e[e.SkipNameGenerationScope=8]="SkipNameGenerationScope",e[e.ReservedInNestedScopes=16]="ReservedInNestedScopes";}(e.GeneratedIdentifierFlags||(e.GeneratedIdentifierFlags={})),function(e){e[e.None=0]="None",e[e.PrecedingLineBreak=1]="PrecedingLineBreak",e[e.PrecedingJSDocComment=2]="PrecedingJSDocComment",e[e.Unterminated=4]="Unterminated",e[e.ExtendedUnicodeEscape=8]="ExtendedUnicodeEscape",e[e.Scientific=16]="Scientific",e[e.Octal=32]="Octal",e[e.HexSpecifier=64]="HexSpecifier",e[e.BinarySpecifier=128]="BinarySpecifier",e[e.OctalSpecifier=256]="OctalSpecifier",e[e.ContainsSeparator=512]="ContainsSeparator",e[e.BinaryOrOctalSpecifier=384]="BinaryOrOctalSpecifier",e[e.NumericLiteralFlags=1008]="NumericLiteralFlags";}(e.TokenFlags||(e.TokenFlags={})),function(e){e[e.Unreachable=1]="Unreachable",e[e.Start=2]="Start",e[e.BranchLabel=4]="BranchLabel",e[e.LoopLabel=8]="LoopLabel",e[e.Assignment=16]="Assignment",e[e.TrueCondition=32]="TrueCondition",e[e.FalseCondition=64]="FalseCondition",e[e.SwitchClause=128]="SwitchClause",e[e.ArrayMutation=256]="ArrayMutation",e[e.Referenced=512]="Referenced",e[e.Shared=1024]="Shared",e[e.PreFinally=2048]="PreFinally",e[e.AfterFinally=4096]="AfterFinally",e[e.Label=12]="Label",e[e.Condition=96]="Condition";}(e.FlowFlags||(e.FlowFlags={}));var t,r=function(){return function(){}}();e.OperationCanceledException=r,function(e){e[e.Not=0]="Not",e[e.SafeModules=1]="SafeModules",e[e.Completely=2]="Completely";}(e.StructureIsReused||(e.StructureIsReused={})),function(e){e[e.Success=0]="Success",e[e.DiagnosticsPresent_OutputsSkipped=1]="DiagnosticsPresent_OutputsSkipped",e[e.DiagnosticsPresent_OutputsGenerated=2]="DiagnosticsPresent_OutputsGenerated";}(e.ExitStatus||(e.ExitStatus={})),function(e){e[e.None=0]="None",e[e.Literal=1]="Literal",e[e.Subtype=2]="Subtype";}(e.UnionReduction||(e.UnionReduction={})),function(e){e[e.None=0]="None",e[e.NoTruncation=1]="NoTruncation",e[e.WriteArrayAsGenericType=2]="WriteArrayAsGenericType",e[e.UseStructuralFallback=8]="UseStructuralFallback",e[e.WriteTypeArgumentsOfSignature=32]="WriteTypeArgumentsOfSignature",e[e.UseFullyQualifiedType=64]="UseFullyQualifiedType",e[e.UseOnlyExternalAliasing=128]="UseOnlyExternalAliasing",e[e.SuppressAnyReturnType=256]="SuppressAnyReturnType",e[e.WriteTypeParametersInQualifiedName=512]="WriteTypeParametersInQualifiedName",e[e.MultilineObjectLiterals=1024]="MultilineObjectLiterals",e[e.WriteClassExpressionAsTypeLiteral=2048]="WriteClassExpressionAsTypeLiteral",e[e.UseTypeOfFunction=4096]="UseTypeOfFunction",e[e.OmitParameterModifiers=8192]="OmitParameterModifiers",e[e.UseAliasDefinedOutsideCurrentScope=16384]="UseAliasDefinedOutsideCurrentScope",e[e.AllowThisInObjectLiteral=32768]="AllowThisInObjectLiteral",e[e.AllowQualifedNameInPlaceOfIdentifier=65536]="AllowQualifedNameInPlaceOfIdentifier",e[e.AllowAnonymousIdentifier=131072]="AllowAnonymousIdentifier",e[e.AllowEmptyUnionOrIntersection=262144]="AllowEmptyUnionOrIntersection",e[e.AllowEmptyTuple=524288]="AllowEmptyTuple",e[e.AllowUniqueESSymbolType=1048576]="AllowUniqueESSymbolType",e[e.AllowEmptyIndexInfoType=2097152]="AllowEmptyIndexInfoType",e[e.IgnoreErrors=3112960]="IgnoreErrors",e[e.InObjectTypeLiteral=4194304]="InObjectTypeLiteral",e[e.InTypeAlias=8388608]="InTypeAlias",e[e.InInitialEntityName=16777216]="InInitialEntityName",e[e.InReverseMappedType=33554432]="InReverseMappedType";}(e.NodeBuilderFlags||(e.NodeBuilderFlags={})),function(e){e[e.None=0]="None",e[e.NoTruncation=1]="NoTruncation",e[e.WriteArrayAsGenericType=2]="WriteArrayAsGenericType",e[e.UseStructuralFallback=8]="UseStructuralFallback",e[e.WriteTypeArgumentsOfSignature=32]="WriteTypeArgumentsOfSignature",e[e.UseFullyQualifiedType=64]="UseFullyQualifiedType",e[e.SuppressAnyReturnType=256]="SuppressAnyReturnType",e[e.MultilineObjectLiterals=1024]="MultilineObjectLiterals",e[e.WriteClassExpressionAsTypeLiteral=2048]="WriteClassExpressionAsTypeLiteral",e[e.UseTypeOfFunction=4096]="UseTypeOfFunction",e[e.OmitParameterModifiers=8192]="OmitParameterModifiers",e[e.UseAliasDefinedOutsideCurrentScope=16384]="UseAliasDefinedOutsideCurrentScope",e[e.AllowUniqueESSymbolType=1048576]="AllowUniqueESSymbolType",e[e.AddUndefined=131072]="AddUndefined",e[e.WriteArrowStyleSignature=262144]="WriteArrowStyleSignature",e[e.InArrayType=524288]="InArrayType",e[e.InElementType=2097152]="InElementType",e[e.InFirstTypeArgument=4194304]="InFirstTypeArgument",e[e.InTypeAlias=8388608]="InTypeAlias",e[e.WriteOwnNameForAnyLike=0]="WriteOwnNameForAnyLike",e[e.NodeBuilderFlagsMask=9469291]="NodeBuilderFlagsMask";}(e.TypeFormatFlags||(e.TypeFormatFlags={})),function(e){e[e.None=0]="None",e[e.WriteTypeParametersOrArguments=1]="WriteTypeParametersOrArguments",e[e.UseOnlyExternalAliasing=2]="UseOnlyExternalAliasing",e[e.AllowAnyNodeKind=4]="AllowAnyNodeKind",e[e.UseAliasDefinedOutsideCurrentScope=8]="UseAliasDefinedOutsideCurrentScope";}(e.SymbolFormatFlags||(e.SymbolFormatFlags={})),function(e){e[e.Accessible=0]="Accessible",e[e.NotAccessible=1]="NotAccessible",e[e.CannotBeNamed=2]="CannotBeNamed";}(e.SymbolAccessibility||(e.SymbolAccessibility={})),function(e){e[e.UnionOrIntersection=0]="UnionOrIntersection",e[e.Spread=1]="Spread";}(e.SyntheticSymbolKind||(e.SyntheticSymbolKind={})),function(e){e[e.This=0]="This",e[e.Identifier=1]="Identifier";}(e.TypePredicateKind||(e.TypePredicateKind={})),function(e){e[e.Unknown=0]="Unknown",e[e.TypeWithConstructSignatureAndValue=1]="TypeWithConstructSignatureAndValue",e[e.VoidNullableOrNeverType=2]="VoidNullableOrNeverType",e[e.NumberLikeType=3]="NumberLikeType",e[e.StringLikeType=4]="StringLikeType",e[e.BooleanType=5]="BooleanType",e[e.ArrayLikeType=6]="ArrayLikeType",e[e.ESSymbolType=7]="ESSymbolType",e[e.Promise=8]="Promise",e[e.TypeWithCallSignature=9]="TypeWithCallSignature",e[e.ObjectType=10]="ObjectType";}(e.TypeReferenceSerializationKind||(e.TypeReferenceSerializationKind={})),function(e){e[e.None=0]="None",e[e.FunctionScopedVariable=1]="FunctionScopedVariable",e[e.BlockScopedVariable=2]="BlockScopedVariable",e[e.Property=4]="Property",e[e.EnumMember=8]="EnumMember",e[e.Function=16]="Function",e[e.Class=32]="Class",e[e.Interface=64]="Interface",e[e.ConstEnum=128]="ConstEnum",e[e.RegularEnum=256]="RegularEnum",e[e.ValueModule=512]="ValueModule",e[e.NamespaceModule=1024]="NamespaceModule",e[e.TypeLiteral=2048]="TypeLiteral",e[e.ObjectLiteral=4096]="ObjectLiteral",e[e.Method=8192]="Method",e[e.Constructor=16384]="Constructor",e[e.GetAccessor=32768]="GetAccessor",e[e.SetAccessor=65536]="SetAccessor",e[e.Signature=131072]="Signature",e[e.TypeParameter=262144]="TypeParameter",e[e.TypeAlias=524288]="TypeAlias",e[e.ExportValue=1048576]="ExportValue",e[e.Alias=2097152]="Alias",e[e.Prototype=4194304]="Prototype",e[e.ExportStar=8388608]="ExportStar",e[e.Optional=16777216]="Optional",e[e.Transient=33554432]="Transient",e[e.JSContainer=67108864]="JSContainer",e[e.All=67108863]="All",e[e.Enum=384]="Enum",e[e.Variable=3]="Variable",e[e.Value=67216319]="Value",e[e.Type=67901928]="Type",e[e.Namespace=1920]="Namespace",e[e.Module=1536]="Module",e[e.Accessor=98304]="Accessor",e[e.FunctionScopedVariableExcludes=67216318]="FunctionScopedVariableExcludes",e[e.BlockScopedVariableExcludes=67216319]="BlockScopedVariableExcludes",e[e.ParameterExcludes=67216319]="ParameterExcludes",e[e.PropertyExcludes=0]="PropertyExcludes",e[e.EnumMemberExcludes=68008959]="EnumMemberExcludes",e[e.FunctionExcludes=67215791]="FunctionExcludes",e[e.ClassExcludes=68008383]="ClassExcludes",e[e.InterfaceExcludes=67901832]="InterfaceExcludes",e[e.RegularEnumExcludes=68008191]="RegularEnumExcludes",e[e.ConstEnumExcludes=68008831]="ConstEnumExcludes",e[e.ValueModuleExcludes=67215503]="ValueModuleExcludes",e[e.NamespaceModuleExcludes=0]="NamespaceModuleExcludes",e[e.MethodExcludes=67208127]="MethodExcludes",e[e.GetAccessorExcludes=67150783]="GetAccessorExcludes",e[e.SetAccessorExcludes=67183551]="SetAccessorExcludes",e[e.TypeParameterExcludes=67639784]="TypeParameterExcludes",e[e.TypeAliasExcludes=67901928]="TypeAliasExcludes",e[e.AliasExcludes=2097152]="AliasExcludes",e[e.ModuleMember=2623475]="ModuleMember",e[e.ExportHasLocal=944]="ExportHasLocal",e[e.HasExports=1952]="HasExports",e[e.HasMembers=6240]="HasMembers",e[e.BlockScoped=418]="BlockScoped",e[e.PropertyOrAccessor=98308]="PropertyOrAccessor",e[e.ClassMember=106500]="ClassMember",e[e.Classifiable=2885600]="Classifiable",e[e.LateBindingContainer=6240]="LateBindingContainer";}(e.SymbolFlags||(e.SymbolFlags={})),function(e){e[e.Numeric=0]="Numeric",e[e.Literal=1]="Literal";}(e.EnumKind||(e.EnumKind={})),function(e){e[e.Instantiated=1]="Instantiated",e[e.SyntheticProperty=2]="SyntheticProperty",e[e.SyntheticMethod=4]="SyntheticMethod",e[e.Readonly=8]="Readonly",e[e.Partial=16]="Partial",e[e.HasNonUniformType=32]="HasNonUniformType",e[e.ContainsPublic=64]="ContainsPublic",e[e.ContainsProtected=128]="ContainsProtected",e[e.ContainsPrivate=256]="ContainsPrivate",e[e.ContainsStatic=512]="ContainsStatic",e[e.Late=1024]="Late",e[e.ReverseMapped=2048]="ReverseMapped",e[e.Synthetic=6]="Synthetic";}(e.CheckFlags||(e.CheckFlags={})),function(e){e.Call="__call",e.Constructor="__constructor",e.New="__new",e.Index="__index",e.ExportStar="__export",e.Global="__global",e.Missing="__missing",e.Type="__type",e.Object="__object",e.JSXAttributes="__jsxAttributes",e.Class="__class",e.Function="__function",e.Computed="__computed",e.Resolving="__resolving__",e.ExportEquals="export=",e.Default="default";}(e.InternalSymbolName||(e.InternalSymbolName={})),function(e){e[e.TypeChecked=1]="TypeChecked",e[e.LexicalThis=2]="LexicalThis",e[e.CaptureThis=4]="CaptureThis",e[e.CaptureNewTarget=8]="CaptureNewTarget",e[e.SuperInstance=256]="SuperInstance",e[e.SuperStatic=512]="SuperStatic",e[e.ContextChecked=1024]="ContextChecked",e[e.AsyncMethodWithSuper=2048]="AsyncMethodWithSuper",e[e.AsyncMethodWithSuperBinding=4096]="AsyncMethodWithSuperBinding",e[e.CaptureArguments=8192]="CaptureArguments",e[e.EnumValuesComputed=16384]="EnumValuesComputed",e[e.LexicalModuleMergesWithClass=32768]="LexicalModuleMergesWithClass",e[e.LoopWithCapturedBlockScopedBinding=65536]="LoopWithCapturedBlockScopedBinding",e[e.CapturedBlockScopedBinding=131072]="CapturedBlockScopedBinding",e[e.BlockScopedBindingInLoop=262144]="BlockScopedBindingInLoop",e[e.ClassWithBodyScopedClassBinding=524288]="ClassWithBodyScopedClassBinding",e[e.BodyScopedClassBinding=1048576]="BodyScopedClassBinding",e[e.NeedsLoopOutParameter=2097152]="NeedsLoopOutParameter",e[e.AssignmentsMarked=4194304]="AssignmentsMarked",e[e.ClassWithConstructorReference=8388608]="ClassWithConstructorReference",e[e.ConstructorReferenceInClass=16777216]="ConstructorReferenceInClass";}(e.NodeCheckFlags||(e.NodeCheckFlags={})),function(e){e[e.Any=1]="Any",e[e.String=2]="String",e[e.Number=4]="Number",e[e.Boolean=8]="Boolean",e[e.Enum=16]="Enum",e[e.StringLiteral=32]="StringLiteral",e[e.NumberLiteral=64]="NumberLiteral",e[e.BooleanLiteral=128]="BooleanLiteral",e[e.EnumLiteral=256]="EnumLiteral",e[e.ESSymbol=512]="ESSymbol",e[e.UniqueESSymbol=1024]="UniqueESSymbol",e[e.Void=2048]="Void",e[e.Undefined=4096]="Undefined",e[e.Null=8192]="Null",e[e.Never=16384]="Never",e[e.TypeParameter=32768]="TypeParameter",e[e.Object=65536]="Object",e[e.Union=131072]="Union",e[e.Intersection=262144]="Intersection",e[e.Index=524288]="Index",e[e.IndexedAccess=1048576]="IndexedAccess",e[e.Conditional=2097152]="Conditional",e[e.Substitution=4194304]="Substitution",e[e.FreshLiteral=8388608]="FreshLiteral",e[e.ContainsWideningType=16777216]="ContainsWideningType",e[e.ContainsObjectLiteral=33554432]="ContainsObjectLiteral",e[e.ContainsAnyFunctionType=67108864]="ContainsAnyFunctionType",e[e.NonPrimitive=134217728]="NonPrimitive",e[e.GenericMappedType=536870912]="GenericMappedType",e[e.Nullable=12288]="Nullable",e[e.Literal=224]="Literal",e[e.Unit=13536]="Unit",e[e.StringOrNumberLiteral=96]="StringOrNumberLiteral",e[e.StringOrNumberLiteralOrUnique=1120]="StringOrNumberLiteralOrUnique",e[e.DefinitelyFalsy=14560]="DefinitelyFalsy",e[e.PossiblyFalsy=14574]="PossiblyFalsy",e[e.Intrinsic=134249103]="Intrinsic",e[e.Primitive=16382]="Primitive",e[e.StringLike=524322]="StringLike",e[e.NumberLike=84]="NumberLike",e[e.BooleanLike=136]="BooleanLike",e[e.EnumLike=272]="EnumLike",e[e.ESSymbolLike=1536]="ESSymbolLike",e[e.UnionOrIntersection=393216]="UnionOrIntersection",e[e.StructuredType=458752]="StructuredType",e[e.TypeVariable=1081344]="TypeVariable",e[e.InstantiableNonPrimitive=7372800]="InstantiableNonPrimitive",e[e.InstantiablePrimitive=524288]="InstantiablePrimitive",e[e.Instantiable=7897088]="Instantiable",e[e.StructuredOrInstantiable=8355840]="StructuredOrInstantiable",e[e.Narrowable=142575359]="Narrowable",e[e.NotUnionOrUnit=134283777]="NotUnionOrUnit",e[e.RequiresWidening=50331648]="RequiresWidening",e[e.PropagatingFlags=117440512]="PropagatingFlags";}(e.TypeFlags||(e.TypeFlags={})),function(e){e[e.Class=1]="Class",e[e.Interface=2]="Interface",e[e.Reference=4]="Reference",e[e.Tuple=8]="Tuple",e[e.Anonymous=16]="Anonymous",e[e.Mapped=32]="Mapped",e[e.Instantiated=64]="Instantiated",e[e.ObjectLiteral=128]="ObjectLiteral",e[e.EvolvingArray=256]="EvolvingArray",e[e.ObjectLiteralPatternWithComputedProperties=512]="ObjectLiteralPatternWithComputedProperties",e[e.ContainsSpread=1024]="ContainsSpread",e[e.ReverseMapped=2048]="ReverseMapped",e[e.JsxAttributes=4096]="JsxAttributes",e[e.MarkerType=8192]="MarkerType",e[e.ClassOrInterface=3]="ClassOrInterface";}(e.ObjectFlags||(e.ObjectFlags={})),function(e){e[e.Invariant=0]="Invariant",e[e.Covariant=1]="Covariant",e[e.Contravariant=2]="Contravariant",e[e.Bivariant=3]="Bivariant",e[e.Independent=4]="Independent";}(e.Variance||(e.Variance={})),function(e){e[e.Call=0]="Call",e[e.Construct=1]="Construct";}(e.SignatureKind||(e.SignatureKind={})),function(e){e[e.String=0]="String",e[e.Number=1]="Number";}(e.IndexKind||(e.IndexKind={})),function(e){e[e.NakedTypeVariable=1]="NakedTypeVariable",e[e.HomomorphicMappedType=2]="HomomorphicMappedType",e[e.MappedTypeConstraint=4]="MappedTypeConstraint",e[e.ReturnType=8]="ReturnType",e[e.NoConstraints=16]="NoConstraints",e[e.AlwaysStrict=32]="AlwaysStrict",e[e.PriorityImpliesUnion=12]="PriorityImpliesUnion";}(e.InferencePriority||(e.InferencePriority={})),function(e){e[e.None=0]="None",e[e.InferUnionTypes=1]="InferUnionTypes",e[e.NoDefault=2]="NoDefault",e[e.AnyDefault=4]="AnyDefault";}(e.InferenceFlags||(e.InferenceFlags={})),function(e){e[e.False=0]="False",e[e.Maybe=1]="Maybe",e[e.True=-1]="True";}(e.Ternary||(e.Ternary={})),function(e){e[e.None=0]="None",e[e.ExportsProperty=1]="ExportsProperty",e[e.ModuleExports=2]="ModuleExports",e[e.PrototypeProperty=3]="PrototypeProperty",e[e.ThisProperty=4]="ThisProperty",e[e.Property=5]="Property",e[e.Prototype=6]="Prototype";}(e.SpecialPropertyAssignmentKind||(e.SpecialPropertyAssignmentKind={})),function(e){e[e.Warning=0]="Warning",e[e.Error=1]="Error",e[e.Suggestion=2]="Suggestion",e[e.Message=3]="Message";}(t=e.DiagnosticCategory||(e.DiagnosticCategory={})),e.diagnosticCategoryName=function(e,r){void 0===r&&(r=!0);var n=t[e.category];return r?n.toLowerCase():n},function(e){e[e.Classic=1]="Classic",e[e.NodeJs=2]="NodeJs";}(e.ModuleResolutionKind||(e.ModuleResolutionKind={})),function(e){e[e.None=0]="None",e[e.CommonJS=1]="CommonJS",e[e.AMD=2]="AMD",e[e.UMD=3]="UMD",e[e.System=4]="System",e[e.ES2015=5]="ES2015",e[e.ESNext=6]="ESNext";}(e.ModuleKind||(e.ModuleKind={})),function(e){e[e.None=0]="None",e[e.Preserve=1]="Preserve",e[e.React=2]="React",e[e.ReactNative=3]="ReactNative";}(e.JsxEmit||(e.JsxEmit={})),function(e){e[e.CarriageReturnLineFeed=0]="CarriageReturnLineFeed",e[e.LineFeed=1]="LineFeed";}(e.NewLineKind||(e.NewLineKind={})),function(e){e[e.Unknown=0]="Unknown",e[e.JS=1]="JS",e[e.JSX=2]="JSX",e[e.TS=3]="TS",e[e.TSX=4]="TSX",e[e.External=5]="External",e[e.JSON=6]="JSON";}(e.ScriptKind||(e.ScriptKind={})),function(e){e[e.ES3=0]="ES3",e[e.ES5=1]="ES5",e[e.ES2015=2]="ES2015",e[e.ES2016=3]="ES2016",e[e.ES2017=4]="ES2017",e[e.ES2018=5]="ES2018",e[e.ESNext=6]="ESNext",e[e.Latest=6]="Latest";}(e.ScriptTarget||(e.ScriptTarget={})),function(e){e[e.Standard=0]="Standard",e[e.JSX=1]="JSX";}(e.LanguageVariant||(e.LanguageVariant={})),function(e){e[e.Simple=0]="Simple",e[e.Pretty=1]="Pretty";}(e.DiagnosticStyle||(e.DiagnosticStyle={})),function(e){e[e.None=0]="None",e[e.Recursive=1]="Recursive";}(e.WatchDirectoryFlags||(e.WatchDirectoryFlags={})),function(e){e[e.nullCharacter=0]="nullCharacter",e[e.maxAsciiCharacter=127]="maxAsciiCharacter",e[e.lineFeed=10]="lineFeed",e[e.carriageReturn=13]="carriageReturn",e[e.lineSeparator=8232]="lineSeparator",e[e.paragraphSeparator=8233]="paragraphSeparator",e[e.nextLine=133]="nextLine",e[e.space=32]="space",e[e.nonBreakingSpace=160]="nonBreakingSpace",e[e.enQuad=8192]="enQuad",e[e.emQuad=8193]="emQuad",e[e.enSpace=8194]="enSpace",e[e.emSpace=8195]="emSpace",e[e.threePerEmSpace=8196]="threePerEmSpace",e[e.fourPerEmSpace=8197]="fourPerEmSpace",e[e.sixPerEmSpace=8198]="sixPerEmSpace",e[e.figureSpace=8199]="figureSpace",e[e.punctuationSpace=8200]="punctuationSpace",e[e.thinSpace=8201]="thinSpace",e[e.hairSpace=8202]="hairSpace",e[e.zeroWidthSpace=8203]="zeroWidthSpace",e[e.narrowNoBreakSpace=8239]="narrowNoBreakSpace",e[e.ideographicSpace=12288]="ideographicSpace",e[e.mathematicalSpace=8287]="mathematicalSpace",e[e.ogham=5760]="ogham",e[e._=95]="_",e[e.$=36]="$",e[e._0=48]="_0",e[e._1=49]="_1",e[e._2=50]="_2",e[e._3=51]="_3",e[e._4=52]="_4",e[e._5=53]="_5",e[e._6=54]="_6",e[e._7=55]="_7",e[e._8=56]="_8",e[e._9=57]="_9",e[e.a=97]="a",e[e.b=98]="b",e[e.c=99]="c",e[e.d=100]="d",e[e.e=101]="e",e[e.f=102]="f",e[e.g=103]="g",e[e.h=104]="h",e[e.i=105]="i",e[e.j=106]="j",e[e.k=107]="k",e[e.l=108]="l",e[e.m=109]="m",e[e.n=110]="n",e[e.o=111]="o",e[e.p=112]="p",e[e.q=113]="q",e[e.r=114]="r",e[e.s=115]="s",e[e.t=116]="t",e[e.u=117]="u",e[e.v=118]="v",e[e.w=119]="w",e[e.x=120]="x",e[e.y=121]="y",e[e.z=122]="z",e[e.A=65]="A",e[e.B=66]="B",e[e.C=67]="C",e[e.D=68]="D",e[e.E=69]="E",e[e.F=70]="F",e[e.G=71]="G",e[e.H=72]="H",e[e.I=73]="I",e[e.J=74]="J",e[e.K=75]="K",e[e.L=76]="L",e[e.M=77]="M",e[e.N=78]="N",e[e.O=79]="O",e[e.P=80]="P",e[e.Q=81]="Q",e[e.R=82]="R",e[e.S=83]="S",e[e.T=84]="T",e[e.U=85]="U",e[e.V=86]="V",e[e.W=87]="W",e[e.X=88]="X",e[e.Y=89]="Y",e[e.Z=90]="Z",e[e.ampersand=38]="ampersand",e[e.asterisk=42]="asterisk",e[e.at=64]="at",e[e.backslash=92]="backslash",e[e.backtick=96]="backtick",e[e.bar=124]="bar",e[e.caret=94]="caret",e[e.closeBrace=125]="closeBrace",e[e.closeBracket=93]="closeBracket",e[e.closeParen=41]="closeParen",e[e.colon=58]="colon",e[e.comma=44]="comma",e[e.dot=46]="dot",e[e.doubleQuote=34]="doubleQuote",e[e.equals=61]="equals",e[e.exclamation=33]="exclamation",e[e.greaterThan=62]="greaterThan",e[e.hash=35]="hash",e[e.lessThan=60]="lessThan",e[e.minus=45]="minus",e[e.openBrace=123]="openBrace",e[e.openBracket=91]="openBracket",e[e.openParen=40]="openParen",e[e.percent=37]="percent",e[e.plus=43]="plus",e[e.question=63]="question",e[e.semicolon=59]="semicolon",e[e.singleQuote=39]="singleQuote",e[e.slash=47]="slash",e[e.tilde=126]="tilde",e[e.backspace=8]="backspace",e[e.formFeed=12]="formFeed",e[e.byteOrderMark=65279]="byteOrderMark",e[e.tab=9]="tab",e[e.verticalTab=11]="verticalTab";}(e.CharacterCodes||(e.CharacterCodes={})),function(e){e.Ts=".ts",e.Tsx=".tsx",e.Dts=".d.ts",e.Js=".js",e.Jsx=".jsx",e.Json=".json";}(e.Extension||(e.Extension={})),function(e){e[e.None=0]="None",e[e.TypeScript=1]="TypeScript",e[e.ContainsTypeScript=2]="ContainsTypeScript",e[e.ContainsJsx=4]="ContainsJsx",e[e.ContainsESNext=8]="ContainsESNext",e[e.ContainsES2017=16]="ContainsES2017",e[e.ContainsES2016=32]="ContainsES2016",e[e.ES2015=64]="ES2015",e[e.ContainsES2015=128]="ContainsES2015",e[e.Generator=256]="Generator",e[e.ContainsGenerator=512]="ContainsGenerator",e[e.DestructuringAssignment=1024]="DestructuringAssignment",e[e.ContainsDestructuringAssignment=2048]="ContainsDestructuringAssignment",e[e.ContainsDecorators=4096]="ContainsDecorators",e[e.ContainsPropertyInitializer=8192]="ContainsPropertyInitializer",e[e.ContainsLexicalThis=16384]="ContainsLexicalThis",e[e.ContainsCapturedLexicalThis=32768]="ContainsCapturedLexicalThis",e[e.ContainsLexicalThisInComputedPropertyName=65536]="ContainsLexicalThisInComputedPropertyName",e[e.ContainsDefaultValueAssignments=131072]="ContainsDefaultValueAssignments",e[e.ContainsParameterPropertyAssignments=262144]="ContainsParameterPropertyAssignments",e[e.ContainsSpread=524288]="ContainsSpread",e[e.ContainsObjectSpread=1048576]="ContainsObjectSpread",e[e.ContainsRest=524288]="ContainsRest",e[e.ContainsObjectRest=1048576]="ContainsObjectRest",e[e.ContainsComputedPropertyName=2097152]="ContainsComputedPropertyName",e[e.ContainsBlockScopedBinding=4194304]="ContainsBlockScopedBinding",e[e.ContainsBindingPattern=8388608]="ContainsBindingPattern",e[e.ContainsYield=16777216]="ContainsYield",e[e.ContainsHoistedDeclarationOrCompletion=33554432]="ContainsHoistedDeclarationOrCompletion",e[e.ContainsDynamicImport=67108864]="ContainsDynamicImport",e[e.Super=134217728]="Super",e[e.ContainsSuper=268435456]="ContainsSuper",e[e.HasComputedFlags=536870912]="HasComputedFlags",e[e.AssertTypeScript=3]="AssertTypeScript",e[e.AssertJsx=4]="AssertJsx",e[e.AssertESNext=8]="AssertESNext",e[e.AssertES2017=16]="AssertES2017",e[e.AssertES2016=32]="AssertES2016",e[e.AssertES2015=192]="AssertES2015",e[e.AssertGenerator=768]="AssertGenerator",e[e.AssertDestructuringAssignment=3072]="AssertDestructuringAssignment",e[e.OuterExpressionExcludes=536872257]="OuterExpressionExcludes",e[e.PropertyAccessExcludes=671089985]="PropertyAccessExcludes",e[e.NodeExcludes=939525441]="NodeExcludes",e[e.ArrowFunctionExcludes=1003902273]="ArrowFunctionExcludes",e[e.FunctionExcludes=1003935041]="FunctionExcludes",e[e.ConstructorExcludes=1003668801]="ConstructorExcludes",e[e.MethodOrAccessorExcludes=1003668801]="MethodOrAccessorExcludes",e[e.ClassExcludes=942011713]="ClassExcludes",e[e.ModuleExcludes=977327425]="ModuleExcludes",e[e.TypeExcludes=-3]="TypeExcludes",e[e.ObjectLiteralExcludes=942740801]="ObjectLiteralExcludes",e[e.ArrayLiteralOrCallOrNewExcludes=940049729]="ArrayLiteralOrCallOrNewExcludes",e[e.VariableDeclarationListExcludes=948962625]="VariableDeclarationListExcludes",e[e.ParameterExcludes=939525441]="ParameterExcludes",e[e.CatchClauseExcludes=940574017]="CatchClauseExcludes",e[e.BindingPatternExcludes=940049729]="BindingPatternExcludes",e[e.TypeScriptClassSyntaxMask=274432]="TypeScriptClassSyntaxMask",e[e.ES2015FunctionSyntaxMask=163840]="ES2015FunctionSyntaxMask";}(e.TransformFlags||(e.TransformFlags={})),function(e){e[e.SingleLine=1]="SingleLine",e[e.AdviseOnEmitNode=2]="AdviseOnEmitNode",e[e.NoSubstitution=4]="NoSubstitution",e[e.CapturesThis=8]="CapturesThis",e[e.NoLeadingSourceMap=16]="NoLeadingSourceMap",e[e.NoTrailingSourceMap=32]="NoTrailingSourceMap",e[e.NoSourceMap=48]="NoSourceMap",e[e.NoNestedSourceMaps=64]="NoNestedSourceMaps",e[e.NoTokenLeadingSourceMaps=128]="NoTokenLeadingSourceMaps",e[e.NoTokenTrailingSourceMaps=256]="NoTokenTrailingSourceMaps",e[e.NoTokenSourceMaps=384]="NoTokenSourceMaps",e[e.NoLeadingComments=512]="NoLeadingComments",e[e.NoTrailingComments=1024]="NoTrailingComments",e[e.NoComments=1536]="NoComments",e[e.NoNestedComments=2048]="NoNestedComments",e[e.HelperName=4096]="HelperName",e[e.ExportName=8192]="ExportName",e[e.LocalName=16384]="LocalName",e[e.InternalName=32768]="InternalName",e[e.Indented=65536]="Indented",e[e.NoIndentation=131072]="NoIndentation",e[e.AsyncFunctionBody=262144]="AsyncFunctionBody",e[e.ReuseTempVariableScope=524288]="ReuseTempVariableScope",e[e.CustomPrologue=1048576]="CustomPrologue",e[e.NoHoisting=2097152]="NoHoisting",e[e.HasEndOfDeclarationMarker=4194304]="HasEndOfDeclarationMarker",e[e.Iterator=8388608]="Iterator",e[e.NoAsciiEscaping=16777216]="NoAsciiEscaping",e[e.TypeScriptClassWrapper=33554432]="TypeScriptClassWrapper",e[e.NeverApplyImportHelper=67108864]="NeverApplyImportHelper";}(e.EmitFlags||(e.EmitFlags={})),function(e){e[e.Extends=1]="Extends",e[e.Assign=2]="Assign",e[e.Rest=4]="Rest",e[e.Decorate=8]="Decorate",e[e.Metadata=16]="Metadata",e[e.Param=32]="Param",e[e.Awaiter=64]="Awaiter",e[e.Generator=128]="Generator",e[e.Values=256]="Values",e[e.Read=512]="Read",e[e.Spread=1024]="Spread",e[e.Await=2048]="Await",e[e.AsyncGenerator=4096]="AsyncGenerator",e[e.AsyncDelegator=8192]="AsyncDelegator",e[e.AsyncValues=16384]="AsyncValues",e[e.ExportStar=32768]="ExportStar",e[e.MakeTemplateObject=65536]="MakeTemplateObject",e[e.FirstEmitHelper=1]="FirstEmitHelper",e[e.LastEmitHelper=65536]="LastEmitHelper",e[e.ForOfIncludes=256]="ForOfIncludes",e[e.ForAwaitOfIncludes=16384]="ForAwaitOfIncludes",e[e.AsyncGeneratorIncludes=6144]="AsyncGeneratorIncludes",e[e.AsyncDelegatorIncludes=26624]="AsyncDelegatorIncludes",e[e.SpreadIncludes=1536]="SpreadIncludes";}(e.ExternalEmitHelpers||(e.ExternalEmitHelpers={})),function(e){e[e.SourceFile=0]="SourceFile",e[e.Expression=1]="Expression",e[e.IdentifierName=2]="IdentifierName",e[e.MappedTypeParameter=3]="MappedTypeParameter",e[e.Unspecified=4]="Unspecified";}(e.EmitHint||(e.EmitHint={})),function(e){e[e.None=0]="None",e[e.SingleLine=0]="SingleLine",e[e.MultiLine=1]="MultiLine",e[e.PreserveLines=2]="PreserveLines",e[e.LinesMask=3]="LinesMask",e[e.NotDelimited=0]="NotDelimited",e[e.BarDelimited=4]="BarDelimited",e[e.AmpersandDelimited=8]="AmpersandDelimited",e[e.CommaDelimited=16]="CommaDelimited",e[e.DelimitersMask=28]="DelimitersMask",e[e.AllowTrailingComma=32]="AllowTrailingComma",e[e.Indented=64]="Indented",e[e.SpaceBetweenBraces=128]="SpaceBetweenBraces",e[e.SpaceBetweenSiblings=256]="SpaceBetweenSiblings",e[e.Braces=512]="Braces",e[e.Parenthesis=1024]="Parenthesis",e[e.AngleBrackets=2048]="AngleBrackets",e[e.SquareBrackets=4096]="SquareBrackets",e[e.BracketsMask=7680]="BracketsMask",e[e.OptionalIfUndefined=8192]="OptionalIfUndefined",e[e.OptionalIfEmpty=16384]="OptionalIfEmpty",e[e.Optional=24576]="Optional",e[e.PreferNewLine=32768]="PreferNewLine",e[e.NoTrailingNewLine=65536]="NoTrailingNewLine",e[e.NoInterveningComments=131072]="NoInterveningComments",e[e.NoSpaceIfEmpty=262144]="NoSpaceIfEmpty",e[e.SingleElement=524288]="SingleElement",e[e.Modifiers=131328]="Modifiers",e[e.HeritageClauses=256]="HeritageClauses",e[e.SingleLineTypeLiteralMembers=448]="SingleLineTypeLiteralMembers",e[e.MultiLineTypeLiteralMembers=65]="MultiLineTypeLiteralMembers",e[e.TupleTypeElements=336]="TupleTypeElements",e[e.UnionTypeConstituents=260]="UnionTypeConstituents",e[e.IntersectionTypeConstituents=264]="IntersectionTypeConstituents",e[e.ObjectBindingPatternElements=262576]="ObjectBindingPatternElements",e[e.ArrayBindingPatternElements=262448]="ArrayBindingPatternElements",e[e.ObjectLiteralExpressionProperties=263122]="ObjectLiteralExpressionProperties",e[e.ArrayLiteralExpressionElements=4466]="ArrayLiteralExpressionElements",e[e.CommaListElements=272]="CommaListElements",e[e.CallExpressionArguments=1296]="CallExpressionArguments",e[e.NewExpressionArguments=9488]="NewExpressionArguments",e[e.TemplateExpressionSpans=131072]="TemplateExpressionSpans",e[e.SingleLineBlockStatements=384]="SingleLineBlockStatements",e[e.MultiLineBlockStatements=65]="MultiLineBlockStatements",e[e.VariableDeclarationList=272]="VariableDeclarationList",e[e.SingleLineFunctionBodyStatements=384]="SingleLineFunctionBodyStatements",e[e.MultiLineFunctionBodyStatements=1]="MultiLineFunctionBodyStatements",e[e.ClassHeritageClauses=256]="ClassHeritageClauses",e[e.ClassMembers=65]="ClassMembers",e[e.InterfaceMembers=65]="InterfaceMembers",e[e.EnumMembers=81]="EnumMembers",e[e.CaseBlockClauses=65]="CaseBlockClauses",e[e.NamedImportsOrExportsElements=432]="NamedImportsOrExportsElements",e[e.JsxElementOrFragmentChildren=131072]="JsxElementOrFragmentChildren",e[e.JsxElementAttributes=131328]="JsxElementAttributes",e[e.CaseOrDefaultClauseStatements=81985]="CaseOrDefaultClauseStatements",e[e.HeritageClauseTypes=272]="HeritageClauseTypes",e[e.SourceFileStatements=65537]="SourceFileStatements",e[e.Decorators=24577]="Decorators",e[e.TypeArguments=26896]="TypeArguments",e[e.TypeParameters=26896]="TypeParameters",e[e.Parameters=1296]="Parameters",e[e.IndexSignatureParameters=4432]="IndexSignatureParameters";}(e.ListFormat||(e.ListFormat={})),function(e){e[e.None=0]="None",e[e.TripleSlashXML=1]="TripleSlashXML",e[e.SingleLine=2]="SingleLine",e[e.MultiLine=4]="MultiLine",e[e.All=7]="All",e[e.Default=7]="Default";}(e.PragmaKindFlags||(e.PragmaKindFlags={})),e.commentPragmas={reference:{args:[{name:"types",optional:!0,captureSpan:!0},{name:"path",optional:!0,captureSpan:!0},{name:"no-default-lib",optional:!0}],kind:1},"amd-dependency":{args:[{name:"path"},{name:"name",optional:!0}],kind:1},"amd-module":{args:[{name:"name"}],kind:1},"ts-check":{kind:2},"ts-nocheck":{kind:2},jsx:{args:[{name:"factory"}],kind:4}};}(i||(i={})),function(e){e.timestamp="undefined"!=typeof performance&&performance.now?function(){return performance.now()}:Date.now?Date.now:function(){return+new Date};}(i||(i={})),function(e){!function(t){var r,n,i,a="function"==typeof onProfilerEvent&&!0===onProfilerEvent.profiler?onProfilerEvent:function(){},o=!1,s=0;t.mark=function(t){o&&(n.set(t,e.timestamp()),r.set(t,(r.get(t)||0)+1),a(t));},t.measure=function(t,r,a){if(o){var c=a&&n.get(a)||e.timestamp(),u=r&&n.get(r)||s;i.set(t,(i.get(t)||0)+(c-u));}},t.getCount=function(e){return r&&r.get(e)||0},t.getDuration=function(e){return i&&i.get(e)||0},t.forEachMeasure=function(e){i.forEach(function(t,r){e(r,t);});},t.enable=function(){r=e.createMap(),n=e.createMap(),i=e.createMap(),o=!0,s=e.timestamp();},t.disable=function(){o=!1;};}(e.performance||(e.performance={}));}(i||(i={})),function(e){e.versionMajorMinor="2.8",e.version=e.versionMajorMinor+".0-rc";}(i||(i={})),function(e){e.isExternalModuleNameRelative=function(t){return e.pathIsRelative(t)||e.isRootedDiskPath(t)},e.sortAndDeduplicateDiagnostics=function(t){return e.sortAndDeduplicate(t,e.compareDiagnostics)};}(i||(i={})),function(e){function t(){var e=Object.create(null);return e.__=void 0,delete e.__,e}function r(){return new i}e.emptyArray=[],e.closeFileWatcher=function(e){e.close();},e.createMap=r,e.createUnderscoreEscapedMap=function(){return new i},e.createSymbolTable=function(e){var t=r();if(e)for(var n=0,i=e;n<i.length;n++){var a=i[n];t.set(a.escapedName,a);}return t},e.createMapFromTemplate=function(e){var t=new i;for(var r in e)E.call(e,r)&&t.set(r,e[r]);return t};var n,i="undefined"!=typeof Map&&"entries"in Map.prototype?Map:(n=function(){function e(e,t){this.index=0,this.data=e,this.selector=t,this.keys=Object.keys(e);}return e.prototype.next=function(){var e=this.index;return e<this.keys.length?(this.index++,{value:this.selector(this.data,this.keys[e]),done:!1}):{value:void 0,done:!0}},e}(),function(){function e(){this.data=t(),this.size=0;}return e.prototype.get=function(e){return this.data[e]},e.prototype.set=function(e,t){return this.has(e)||this.size++,this.data[e]=t,this},e.prototype.has=function(e){return e in this.data},e.prototype.delete=function(e){return!!this.has(e)&&(this.size--,delete this.data[e],!0)},e.prototype.clear=function(){this.data=t(),this.size=0;},e.prototype.keys=function(){return new n(this.data,function(e,t){return t})},e.prototype.values=function(){return new n(this.data,function(e,t){return e[t]})},e.prototype.entries=function(){return new n(this.data,function(e,t){return[t,e[t]]})},e.prototype.forEach=function(e){for(var t in this.data)e(this.data[t],t);},e}());function a(e,t){if(e)for(var r=0;r<e.length;r++){var n=t(e[r],r);if(n)return n}}function o(e,t){if(e)for(var r=0;r<e.length;r++)if(!t(e[r],r))return!1;return!0}function s(e,t){for(var r=0;r<e.length;r++){var n=e[r];if(t(n,r))return n}}function c(e,t){for(var r=0;r<e.length;r++)if(t(e[r],r))return r;return-1}function u(e,t,r){if(void 0===r&&(r=V),e)for(var n=0,i=e;n<i.length;n++){if(r(i[n],t))return!0}return!1}function l(e,t,r){for(var n=r||0;n<e.length;n++)if(u(t,e.charCodeAt(n)))return n;return-1}function _(e,t){var r;if(e){r=[];for(var n=0;n<e.length;n++)r.push(t(e[n],n));}return r}function d(e){var t;if(e){t=[];for(var r=0,n=e;r<n.length;r++){var i=n[r];i&&(R(i)?h(t,i):t.push(i));}}return t}function p(e,t){var r;if(e){r=[];for(var n=0;n<e.length;n++){var i=t(e[n],n);i&&(R(i)?h(r,i):r.push(i));}}return r}function f(e,t){if(e){if(!t)return e.length>0;for(var r=0,n=e;r<n.length;r++){if(t(n[r]))return!0}}return!1}function m(e,t,r){return e?0===e.length?[]:1===e.length?e.slice():r?function(e,t,r){var n=e.map(function(e,t){return t});b(e,n,r);for(var i=e[n[0]],a=[n[0]],o=1;o<n.length;o++){var s=n[o],c=e[s];t(i,c)||(a.push(s),i=c);}return a.sort(),a.map(function(t){return e[t]})}(e,t,r):function(e,t){for(var r=[],n=0,i=e;n<i.length;n++)v(r,i[n],t);return r}(e,t):void 0}function g(e,t,r){if(void 0===r&&(r=V),!e||!t)return e===t;if(e.length!==t.length)return!1;for(var n=0;n<e.length;n++)if(!r(e[n],t[n]))return!1;return!0}function y(e,t){return t<0?e.length+t:t}function h(e,t,r,n){if(void 0===t||0===t.length)return e;if(void 0===e)return t.slice(r,n);r=void 0===r?0:y(t,r),n=void 0===n?t.length:y(t,n);for(var i=r;i<n&&i<t.length;i++)void 0!==t[i]&&e.push(t[i]);return e}function v(e,t,r){return!u(e,t,r)&&(e.push(t),!0)}function b(e,t,r){t.sort(function(t,n){return r(e[t],e[n])||$(t,n)});}function x(e,t){return e.slice().sort(t)}function S(e){var t=0;return{next:function(){return t===e.length?{value:void 0,done:!0}:{value:e[++t-1],done:!1}}}}function k(e,t){if(e&&(t=y(e,t))<e.length)return e[t]}function T(e){return k(e,-1)}function D(e,t,r,n,i){if(!e||0===e.length)return-1;for(var a=i||0,o=e.length-1,s=r(t);a<=o;){var c=a+(o-a>>1);switch(n(r(e[c]),s)){case-1:a=c+1;break;case 0:return c;case 1:o=c-1;}}return~a}function C(e,t,r,n,i){if(e&&e.length>0){var a=e.length;if(a>0){var o=void 0===n||n<0?0:n,s=void 0===i||o+i>a-1?a-1:o+i,c=void 0;for(arguments.length<=2?(c=e[o],o++):c=r;o<=s;)c=t(c,e[o],o),o++;return c}}return r}e.toPath=function(e,t,r){return r(fe(e)?oe(e):ye(e,t))},e.length=function(e){return e?e.length:0},e.forEach=a,e.firstDefined=function(e,t){if(void 0!==e)for(var r=0;r<e.length;r++){var n=t(e[r],r);if(void 0!==n)return n}},e.firstDefinedIterator=function(e,t){for(;;){var r=e.next(),n=r.value;if(r.done)return;var i=t(n);if(void 0!==i)return i}},e.findAncestor=function(e,t){for(;e;){var r=t(e);if("quit"===r)return;if(r)return e;e=e.parent;}},e.zipWith=function(e,t,r){var n=[];Ge.assertEqual(e.length,t.length);for(var i=0;i<e.length;i++)n.push(r(e[i],t[i],i));return n},e.zipToIterator=function(e,t){Ge.assertEqual(e.length,t.length);var r=0;return{next:function(){return r===e.length?{value:void 0,done:!0}:{value:[e[++r-1],t[r-1]],done:!1}}}},e.zipToMap=function(e,t){Ge.assert(e.length===t.length);for(var n=r(),i=0;i<e.length;++i)n.set(e[i],t[i]);return n},e.every=o,e.find=s,e.findLast=function(e,t){for(var r=e.length-1;r>=0;r--){var n=e[r];if(t(n,r))return n}},e.findIndex=c,e.findMap=function(e,t){for(var r=0;r<e.length;r++){var n=t(e[r],r);if(n)return n}Ge.fail();},e.contains=u,e.arraysEqual=function(e,t,r){return void 0===r&&(r=V),e.length===t.length&&e.every(function(e,n){return r(e,t[n])})},e.indexOfAnyCharCode=l,e.countWhere=function(e,t){var r=0;if(e)for(var n=0;n<e.length;n++)t(e[n],n)&&r++;return r},e.filter=function(e,t){if(e){for(var r=e.length,n=0;n<r&&t(e[n]);)n++;if(n<r){var i=e.slice(0,n);for(n++;n<r;){var a=e[n];t(a)&&i.push(a),n++;}return i}}return e},e.filterMutate=function(e,t){for(var r=0,n=0;n<e.length;n++)t(e[n],n,e)&&(e[r]=e[n],r++);e.length=r;},e.clear=function(e){e.length=0;},e.map=_,e.mapIterator=function(e,t){return{next:function(){var r=e.next();return r.done?r:{value:t(r.value),done:!1}}}},e.sameMap=function(e,t){if(e)for(var r=0;r<e.length;r++){var n=e[r],i=t(n,r);if(n!==i){var a=e.slice(0,r);for(a.push(i),r++;r<e.length;r++)a.push(t(e[r],r));return a}}return e},e.flatten=d,e.flatMap=p,e.flatMapIterator=function(t,r){var n=t.next();if(n.done)return e.emptyIterator;var i=a(n.value);return{next:function(){for(;;){var e=i.next();if(!e.done)return e;var r=t.next();if(r.done)return r;i=a(r.value);}}};function a(t){var n=r(t);return void 0===n?e.emptyIterator:R(n)?S(n):n}},e.sameFlatMap=function(e,t){var r;if(e)for(var n=0;n<e.length;n++){var i=e[n],a=t(i,n);(r||i!==a||R(a))&&(r||(r=e.slice(0,n)),R(a)?h(r,a):r.push(a));}return r||e},e.mapAllOrFail=function(e,t){for(var r=[],n=0;n<e.length;n++){var i=t(e[n],n);if(void 0===i)return;r.push(i);}return r},e.mapDefined=function(e,t){var r=[];if(e)for(var n=0;n<e.length;n++){var i=t(e[n],n);void 0!==i&&r.push(i);}return r},e.mapDefinedIterator=function(e,t){return{next:function(){for(;;){var r=e.next();if(r.done)return r;var n=t(r.value);if(void 0!==n)return{value:n,done:!1}}}}},e.emptyIterator={next:function(){return{value:void 0,done:!0}}},e.singleIterator=function(e){var t=!1;return{next:function(){var r=t;return t=!0,r?{value:void 0,done:!0}:{value:e,done:!1}}}},e.span=function(e,t){if(e){for(var r=0;r<e.length;r++)if(!t(e[r],r))return[e.slice(0,r),e.slice(r)];return[e.slice(0),[]]}},e.spanMap=function(e,t,r){var n;if(e){n=[];for(var i=e.length,a=void 0,o=void 0,s=0,c=0;s<i;){for(;c<i;){if(o=t(e[c],c),0===c)a=o;else if(o!==a)break;c++;}if(s<c){var u=r(e.slice(s,c),a,s,c);u&&n.push(u),s=c;}a=o,c++;}}return n},e.mapEntries=function(e,t){if(e){var n=r();return e.forEach(function(e,r){var i=t(r,e),a=i[0],o=i[1];n.set(a,o);}),n}},e.some=f,e.concatenate=function(e,t){return f(t)?f(e)?e.concat(t):t:e},e.deduplicate=m,e.insertSorted=function(e,t,r){if(0!==e.length){var n=D(e,t,j,r);n<0&&e.splice(~n,0,t);}else e.push(t);},e.sortAndDeduplicate=function(e,t,r){return function(e,t){if(e){if(0===e.length)return[];for(var r=e[0],n=[r],i=1;i<e.length;i++){var a=e[i];switch(t(a,r)){case!0:case 0:continue;case-1:return Ge.fail("Array is unsorted.")}n.push(r=a);}return n}}(x(e,t),r||t)},e.arrayIsEqualTo=g,e.changesAffectModuleResolution=function(e,t){return!(e&&e.module===t.module&&e.moduleResolution===t.moduleResolution&&e.noResolve===t.noResolve&&e.target===t.target&&e.noLib===t.noLib&&e.jsx===t.jsx&&e.allowJs===t.allowJs&&e.rootDir===t.rootDir&&e.configFilePath===t.configFilePath&&e.baseUrl===t.baseUrl&&e.maxNodeModuleJsDepth===t.maxNodeModuleJsDepth&&g(e.lib,t.lib)&&g(e.typeRoots,t.typeRoots)&&g(e.rootDirs,t.rootDirs)&&w(e.paths,t.paths))},e.compact=function(e){var t;if(e)for(var r=0;r<e.length;r++){var n=e[r];!t&&n||(t||(t=e.slice(0,r)),n&&t.push(n));}return t||e},e.relativeComplement=function(e,t,r){if(!t||!e||0===t.length||0===e.length)return t;var n=[];e:for(var i=0,a=0;a<t.length;a++){a>0&&Ge.assertGreaterThanOrEqual(r(t[a],t[a-1]),0);t:for(var o=i;i<e.length;i++)switch(i>o&&Ge.assertGreaterThanOrEqual(r(e[i],e[i-1]),0),r(t[a],e[i])){case-1:n.push(t[a]);continue e;case 0:continue e;case 1:continue t}}return n},e.sum=function(e,t){for(var r=0,n=0,i=e;n<i.length;n++)r+=i[n][t];return r},e.append=function(e,t){return void 0===t?e:void 0===e?[t]:(e.push(t),e)},e.addRange=h,e.pushIfUnique=v,e.appendIfUnique=function(e,t,r){return e?(v(e,t,r),e):[t]},e.sort=x,e.best=function(e,t){var r=e.next();if(!r.done)for(var n=r.value;;){var i=e.next(),a=i.value;if(i.done)return n;t(a,n)&&(n=a);}},e.arrayIterator=S,e.stableSort=function(e,t){var r=e.map(function(e,t){return t});return b(e,r,t),r.map(function(t){return e[t]})},e.rangeEquals=function(e,t,r,n){for(;r<n;){if(e[r]!==t[r])return!1;r++;}return!0},e.elementAt=k,e.firstOrUndefined=function(e){return k(e,0)},e.first=function(e){return Ge.assert(0!==e.length),e[0]},e.lastOrUndefined=T,e.last=function(e){return Ge.assert(0!==e.length),e[e.length-1]},e.singleOrUndefined=function(e){return e&&1===e.length?e[0]:void 0},e.singleOrMany=function(e){return e&&1===e.length?e[0]:e},e.replaceElement=function(e,t,r){var n=e.slice(0);return n[t]=r,n},e.binarySearch=D,e.reduceLeft=C;var E=Object.prototype.hasOwnProperty;function N(e,t){return E.call(e,t)}function A(e,t){for(var r,n=[],i=e.next(),a=i.value,o=i.done;!o;a=(r=e.next()).value,o=r.done,r)n.push(t?t(a):a);return n}function P(e,t){e.forEach(function(e,r){t.set(r,e);});}function w(e,t,r){if(void 0===r&&(r=V),e===t)return!0;if(!e||!t)return!1;for(var n in e)if(E.call(e,n)){if(void 0===!E.call(t,n))return!1;if(!r(e[n],t[n]))return!1}for(var n in t)if(E.call(t,n)&&!E.call(e,n))return!1;return!0}function F(e,t,n){void 0===n&&(n=j);for(var i=r(),a=0,o=e;a<o.length;a++){var s=o[a];i.set(t(s),n(s));}return i}function O(e,t,r){void 0===r&&(r=j);for(var n=I(),i=0,a=e;i<a.length;i++){var o=a[i];n.add(t(o),r(o));}return n}function I(){var e=r();return e.add=M,e.remove=L,e}function M(e,t){var r=this.get(e);return r?r.push(t):this.set(e,r=[t]),r}function L(e,t){var r=this.get(e);r&&(ot(r,t),r.length||this.delete(e));}function R(e){return Array.isArray?Array.isArray(e):e instanceof Array}function B(e){return"string"==typeof e}function K(e){}function j(e){return e}function J(e){return e.toLowerCase()}function z(e,t,r,n,i){if(i){for(var a=[],o=0;o<arguments.length;o++)a[o]=arguments[o];return function(e){return C(a,function(e,t){return t(e)},e)}}return n?function(i){return n(r(t(e(i))))}:r?function(n){return r(t(e(n)))}:t?function(r){return t(e(r))}:e?function(t){return e(t)}:function(e){return e}}function U(e,t,r){return r=r||0,e.replace(/{(\d+)}/g,function(e,n){return t[+n+r]})}function q(t){return e.localizedDiagnosticMessages&&e.localizedDiagnosticMessages[t.key]||t.message}function V(e,t){return e===t}function W(e,t){return e===t||void 0!==e&&void 0!==t&&e.toUpperCase()===t.toUpperCase()}function H(e,t){return V(e,t)}function G(e,t){return e===t?0:void 0===e?-1:void 0===t?1:e<t?-1:1}function $(e,t){return G(e,t)}function X(e,t){return e===t?0:void 0===e?-1:void 0===t?1:(e=e.toUpperCase())<(t=t.toUpperCase())?-1:e>t?1:0}function Q(e,t){return G(e,t)}e.hasProperty=N,e.getProperty=function(e,t){return E.call(e,t)?e[t]:void 0},e.getOwnKeys=function(e){var t=[];for(var r in e)E.call(e,r)&&t.push(r);return t},e.getOwnValues=function(e){var t=[];for(var r in e)E.call(e,r)&&t.push(e[r]);return t},e.arrayFrom=A,e.forEachEntry=function(e,t){for(var r,n=e.entries(),i=n.next(),a=i.value,o=i.done;!o;a=(r=n.next()).value,o=r.done,r){var s=a[0],c=t(a[1],s);if(c)return c}},e.forEachKey=function(e,t){for(var r,n=e.keys(),i=n.next(),a=i.value,o=i.done;!o;a=(r=n.next()).value,o=r.done,r){var s=t(a);if(s)return s}},e.copyEntries=P,e.assign=function(e){for(var t=[],r=1;r<arguments.length;r++)t[r-1]=arguments[r];for(var n=0,i=t;n<i.length;n++){var a=i[n];for(var o in a)N(a,o)&&(e[o]=a[o]);}return e},e.equalOwnProperties=w,e.arrayToMap=F,e.arrayToNumericMap=function(e,t,r){void 0===r&&(r=j);for(var n=[],i=0,a=e;i<a.length;i++){var o=a[i];n[t(o)]=r(o);}return n},e.arrayToSet=function(e,t){return F(e,t||function(e){return e},function(){return!0})},e.arrayToMultiMap=O,e.group=function(e,t){return A(O(e,t).values())},e.cloneMap=function(e){var t=r();return P(e,t),t},e.clone=function(e){var t={};for(var r in e)E.call(e,r)&&(t[r]=e[r]);return t},e.extend=function(e,t){var r={};for(var n in t)E.call(t,n)&&(r[n]=t[n]);for(var n in e)E.call(e,n)&&(r[n]=e[n]);return r},e.createMultiMap=I,e.isArray=R,e.toArray=function(e){return R(e)?e:[e]},e.isString=B,e.tryCast=function(e,t){return void 0!==e&&t(e)?e:void 0},e.cast=function(e,t){if(void 0!==e&&t(e))return e;e&&"number"==typeof e.kind?Ge.fail("Invalid cast. The supplied "+Ge.showSyntaxKind(e)+" did not pass the test '"+Ge.getFunctionName(t)+"'."):Ge.fail("Invalid cast. The supplied value did not pass the test '"+Ge.getFunctionName(t)+"'.");},e.noop=K,e.returnFalse=function(){return!1},e.returnTrue=function(){return!0},e.identity=j,e.toLowerCase=J,e.notImplemented=function(){throw new Error("Not implemented")},e.memoize=function(e){var t;return function(){return e&&(t=e(),e=void 0),t}},e.chain=function(e,t,r,n,i){if(i){for(var a=[],o=0;o<arguments.length;o++)a[o]=arguments[o];return function(e){return z.apply(void 0,_(a,function(t){return t(e)}))}}return n?function(i){return z(e(i),t(i),r(i),n(i))}:r?function(n){return z(e(n),t(n),r(n))}:t?function(r){return z(e(r),t(r))}:e?function(t){return z(e(t))}:function(e){return function(e){return e}}},e.compose=z,e.formatStringFromArgs=U,e.getLocaleSpecificMessage=q,e.createFileDiagnostic=function(e,t,r,n){Ge.assertGreaterThanOrEqual(t,0),Ge.assertGreaterThanOrEqual(r,0),e&&(Ge.assertLessThanOrEqual(t,e.text.length),Ge.assertLessThanOrEqual(t+r,e.text.length));var i=q(n);return arguments.length>4&&(i=U(i,arguments,4)),{file:e,start:t,length:r,messageText:i,category:n.category,code:n.code}},e.formatMessage=function(e,t){var r=q(t);return arguments.length>2&&(r=U(r,arguments,2)),r},e.createCompilerDiagnostic=function(e){var t=q(e);return arguments.length>1&&(t=U(t,arguments,1)),{file:void 0,start:void 0,length:void 0,messageText:t,category:e.category,code:e.code}},e.createCompilerDiagnosticFromMessageChain=function(e){return{file:void 0,start:void 0,length:void 0,code:e.code,category:e.category,messageText:e.next?e:e.messageText}},e.chainDiagnosticMessages=function(e,t){var r=q(t);return arguments.length>2&&(r=U(r,arguments,2)),{messageText:r,category:t.category,code:t.code,next:e}},e.concatenateDiagnosticMessageChains=function(e,t){for(var r=e;r.next;)r=r.next;return r.next=t,e},e.equateValues=V,e.equateStringsCaseInsensitive=W,e.equateStringsCaseSensitive=H,e.compareValues=$,e.compareStringsCaseInsensitive=X,e.compareStringsCaseSensitive=Q;var Y,Z,ee=function(){var e,t,r=function(){if("object"==typeof Intl&&"function"==typeof Intl.Collator)return i;if("function"==typeof String.prototype.localeCompare&&"function"==typeof String.prototype.toLocaleUpperCase&&"a".localeCompare("B")<0)return a;return o}();return function(n){return void 0===n?e||(e=r(n)):"en-US"===n?t||(t=r(n)):r(n)};function n(e,t,r){if(e===t)return 0;if(void 0===e)return-1;if(void 0===t)return 1;var n=r(e,t);return n<0?-1:n>0?1:0}function i(e){var t=new Intl.Collator(e,{usage:"sort",sensitivity:"variant"}).compare;return function(e,r){return n(e,r,t)}}function a(e){return void 0!==e?o():function(e,r){return n(e,r,t)};function t(e,t){return e.localeCompare(t)}}function o(){return function(t,r){return n(t,r,e)};function e(e,r){return t(e.toUpperCase(),r.toUpperCase())||t(e,r)}function t(e,t){return e<t?-1:e>t?1:0}}}();function te(e){return e.file?e.file.fileName:void 0}function re(e){return e.replace(/\\/g,"/")}function ne(e){if(47===e.charCodeAt(0)){if(47!==e.charCodeAt(1))return 1;var t=e.indexOf("/",2);if(t<0)return 2;var r=e.indexOf("/",t+1);return r<0?t+1:r+1}if(58===e.charCodeAt(1)&&(47===e.charCodeAt(2)||92===e.charCodeAt(2)))return 3;if(0===e.lastIndexOf("file:///",0))return"file:///".length;var n=e.indexOf("://");return-1!==n?n+"://".length:0}e.getUILocale=function(){return Z},e.setUILocale=function(e){Z!==e&&(Z=e,Y=void 0);},e.compareStringsCaseSensitiveUI=function(e,t){return(Y||(Y=ee(Z)))(e,t)},e.compareProperties=function(e,t,r,n){return e===t?0:void 0===e?-1:void 0===t?1:n(e[r],t[r])},e.compareDiagnostics=function(e,t){return Q(te(e),te(t))||$(e.start,t.start)||$(e.length,t.length)||$(e.code,t.code)||function(e,t){for(;e&&t;){var r=B(e)?e:e.messageText,n=B(t)?t:t.messageText,i=Q(r,n);if(i)return i;e=B(e)?void 0:e.next,t=B(t)?void 0:t.next;}return e||t?e?1:-1:0}(e.messageText,t.messageText)||0},e.compareBooleans=function(e,t){return $(e?1:0,t?1:0)},e.normalizeSlashes=re,e.getRootLength=ne,e.directorySeparator="/";var ie=47;function ae(t,r){for(var n=[],i=0,a=t.substr(r).split(e.directorySeparator);i<a.length;i++){var o=a[i];"."!==o&&(".."===o&&n.length>0&&".."!==T(n)?n.pop():o&&n.push(o));}return n}function oe(e){return se(e).path}function se(t){var r=ne(t=re(t)),n=t.substr(0,r),i=ae(t,r);if(i.length){var a=n+i.join(e.directorySeparator);return{path:ce(t)?a+e.directorySeparator:a,parts:i}}return{path:n,parts:i}}function ce(e){return e.charCodeAt(e.length-1)===ie}function ue(t){return t.substr(0,Math.max(ne(t),t.lastIndexOf(e.directorySeparator)))}function le(e){return e&&!fe(e)&&Ee(e,"://")}function _e(e){return e.target||0}function de(t){return"number"==typeof t.module?t.module:_e(t)>=2?e.ModuleKind.ES2015:e.ModuleKind.CommonJS}function pe(e){for(var t=!1,r=0;r<e.length;r++)if(42===e.charCodeAt(r)){if(t)return!1;t=!0;}return!0}function fe(e){return e&&0!==ne(e)}function me(e,t){var r=ae(e,t);return[e.substr(0,t)].concat(r)}function ge(e,t){var r=ne(e=re(e));return 0===r&&(r=ne(e=Se(re(t),e))),me(e,r)}function ye(e,t){return he(ge(e,t))}function he(t){if(t&&t.length)return t[0]+t.slice(1).join(e.directorySeparator)}function ve(t,r){return le(t)?function(t){for(var r=t.length,n=t.indexOf("://")+"://".length;n<r&&47===t.charCodeAt(n);)n++;if(n===r)return[t];var i=t.indexOf(e.directorySeparator,n);return-1!==i?me(t,n=i+1):[t+e.directorySeparator]}(t):ge(t,r)}function be(t,r,n,i,a){var o,s=ve(r,n),c=ve(t,n);for(c.length>1&&""===T(c)&&c.pop(),o=0;o<s.length&&o<c.length&&i(c[o])===i(s[o]);o++);if(o){for(var u="",l=s.slice(o,s.length);o<c.length;o++)""!==c[o]&&(u=u+".."+e.directorySeparator);return u+l.join(e.directorySeparator)}var _=he(s);return a&&fe(_)&&(_="file:///"+_),_}function xe(t){if(void 0!==t){var r=t.lastIndexOf(e.directorySeparator);return r<0?t:t.substring(r+1)}}function Se(t,r){return t&&t.length?r&&r.length?0!==ne(r)?r:t.charAt(t.length-1)===e.directorySeparator?t+r:t+e.directorySeparator+r:t:r}function ke(t){return t.charAt(t.length-1)===e.directorySeparator?t.substr(0,t.length-1):t}function Te(e,t,r,n){if(void 0===e||void 0===t)return!1;if(e===t)return!0;if((e=ke(e))===(t=ke(t)))return!0;var i=ge(e,r),a=ge(t,r);if(a.length<i.length)return!1;for(var o=n?W:H,s=0;s<i.length;s++)if(!o(i[s],a[s]))return!1;return!0}function De(e,t){return 0===e.lastIndexOf(t,0)}function Ce(e,t){var r=e.length-t.length;return r>=0&&e.indexOf(t,r)===r}function Ee(e,t){return-1!==e.indexOf(t)}function Ne(e){return Ee(xe(e),".")}function Ae(e,t){return e.length>t.length&&Ce(e,t)}function Pe(e,t){for(var r=0,n=t;r<n.length;r++){if(Ae(e,n[r]))return!0}return!1}e.normalizePath=oe,e.normalizePathAndParts=se,e.pathEndsWithDirectorySeparator=ce,e.getDirectoryPath=ue,e.isUrl=le,e.pathIsRelative=function(e){return/^\.\.?($|[\\/])/.test(e)},e.getEmitScriptTarget=_e,e.getEmitModuleKind=de,e.getEmitModuleResolutionKind=function(t){var r=t.moduleResolution;return void 0===r&&(r=de(t)===e.ModuleKind.CommonJS?e.ModuleResolutionKind.NodeJs:e.ModuleResolutionKind.Classic),r},e.getAllowSyntheticDefaultImports=function(t){var r=de(t);return void 0!==t.allowSyntheticDefaultImports?t.allowSyntheticDefaultImports:t.esModuleInterop?r!==e.ModuleKind.None&&r<e.ModuleKind.ES2015:r===e.ModuleKind.System},e.getStrictOptionValue=function(e,t){return void 0===e[t]?e.strict:e[t]},e.hasZeroOrOneAsteriskCharacter=pe,e.isRootedDiskPath=fe,e.convertToRelativePath=function(e,t,r){return fe(e)?be(t,e,t,r,!1):e},e.getNormalizedPathComponents=ge,e.getNormalizedAbsolutePath=ye,e.getNormalizedPathFromPathComponents=he,e.getRelativePathToDirectoryOrUrl=be,e.getBaseFileName=xe,e.combinePaths=Se,e.removeTrailingDirectorySeparator=ke,e.ensureTrailingDirectorySeparator=function(t){return t.charAt(t.length-1)!==e.directorySeparator?t+e.directorySeparator:t},e.comparePaths=function(e,t,r,n){if(e===t)return 0;if(void 0===e)return-1;if(void 0===t)return 1;e=ke(e),t=ke(t);for(var i=ge(e,r),a=ge(t,r),o=Math.min(i.length,a.length),s=n?X:Q,c=0;c<o;c++){var u=s(i[c],a[c]);if(0!==u)return u}return $(i.length,a.length)},e.containsPath=Te,e.startsWith=De,e.removePrefix=function(e,t){return De(e,t)?e.substr(t.length):e},e.endsWith=Ce,e.removeSuffix=function(e,t){return Ce(e,t)?e.slice(0,e.length-t.length):e},e.stringContains=Ee,e.hasExtension=Ne,e.fileExtensionIs=Ae,e.fileExtensionIsOneOf=Pe;var we=/[^\w\s\/]/g,Fe=[42,63];e.commonPackageFolders=["node_modules","bower_components","jspm_packages"];var Oe="(?!("+e.commonPackageFolders.join("|")+")(/|$))",Ie={singleAsteriskRegexFragment:"([^./]|(\\.(?!min\\.js$))?)*",doubleAsteriskRegexFragment:"(/"+Oe+"[^/.][^/]*)*?",replaceWildcardCharacter:function(e){return Je(e,Ie.singleAsteriskRegexFragment)}},Me={singleAsteriskRegexFragment:"[^/]*",doubleAsteriskRegexFragment:"(/"+Oe+"[^/.][^/]*)*?",replaceWildcardCharacter:function(e){return Je(e,Me.singleAsteriskRegexFragment)}},Le={singleAsteriskRegexFragment:"[^/]*",doubleAsteriskRegexFragment:"(/.+?)?",replaceWildcardCharacter:function(e){return Je(e,Le.singleAsteriskRegexFragment)}},Re={files:Ie,directories:Me,exclude:Le};function Be(e,t,r){var n=Ke(e,t,r);if(n&&n.length)return"^("+n.map(function(e){return"("+e+")"}).join("|")+")"+("exclude"===r?"($|/)":"$")}function Ke(t,r,n){if(void 0!==t&&0!==t.length)return p(t,function(t){return t&&function(t,r,n,i){var a=i.singleAsteriskRegexFragment,o=i.doubleAsteriskRegexFragment,s=i.replaceWildcardCharacter,c="",u=!1,l=ge(t,r),_=T(l);if("exclude"!==n&&"**"===_)return;l[0]=ke(l[0]),je(_)&&l.push("**","*");for(var d=0,p=0,f=l;p<f.length;p++){var m=f[p];if("**"===m)c+=o;else if("directories"===n&&(c+="(",d++),u&&(c+=e.directorySeparator),"exclude"!==n){var g="";42===m.charCodeAt(0)?(g+="([^./]"+a+")?",m=m.substr(1)):63===m.charCodeAt(0)&&(g+="[^./]",m=m.substr(1)),(g+=m.replace(we,s))!==m&&(c+=Oe),c+=g;}else c+=m.replace(we,s);u=!0;}for(;d>0;)c+=")?",d--;return c}(t,r,n,Re[n])})}function je(e){return!/[.*?]/.test(e)}function Je(e,t){return"*"===e?t:"?"===e?"[^/]":"\\"+e}function ze(e,t,r,n,i){e=oe(e);var a=Se(i=oe(i),e);return{includeFilePatterns:_(Ke(r,a,"files"),function(e){return"^"+e+"$"}),includeFilePattern:Be(r,a,"files"),includeDirectoryPattern:Be(r,a,"directories"),excludePattern:Be(t,a,"exclude"),basePaths:function(e,t,r){var n=[e];if(t){for(var i=[],a=0,s=t;a<s.length;a++){var c=s[a],u=fe(c)?c:oe(Se(e,c));i.push(Ue(u));}i.sort(r?Q:X);for(var l=function(t){o(n,function(n){return!Te(n,t,e,!r)})&&n.push(t);},_=0,d=i;_<d.length;_++){var p=d[_];l(p);}}return n}(e,r,n)}}function Ue(t){var r=l(t,Fe);return r<0?Ne(t)?ke(ue(t)):t:t.substring(0,t.lastIndexOf(e.directorySeparator,r))}function qe(e){switch(e.substr(e.lastIndexOf(".")).toLowerCase()){case".js":return 1;case".jsx":return 2;case".ts":return 3;case".tsx":return 4;case".json":return 6;default:return 0}}e.getRegularExpressionForWildcard=Be,e.isImplicitGlob=je,e.getFileMatcherPatterns=ze,e.matchFiles=function(e,t,r,n,i,a,o,s){for(var u=ze(e=oe(e),r,n,i,a=oe(a)),l=i?"":"i",_=u.includeFilePatterns&&u.includeFilePatterns.map(function(e){return new RegExp(e,l)}),p=u.includeDirectoryPattern&&new RegExp(u.includeDirectoryPattern,l),f=u.excludePattern&&new RegExp(u.excludePattern,l),m=_?_.map(function(){return[]}):[[]],g=0,y=u.basePaths;g<y.length;g++){var h=y[g];v(h,Se(a,h),o);}return d(m);function v(e,r,n){for(var i=s(e),a=i.files,o=i.directories,u=function(n){var i=Se(e,n),a=Se(r,n);if(t&&!Pe(i,t))return"continue";if(f&&f.test(a))return"continue";if(_){var o=c(_,function(e){return e.test(a)});-1!==o&&m[o].push(i);}else m[0].push(i);},l=0,d=x(a,Q);l<d.length;l++)u(h=d[l]);if(void 0===n||0!=--n)for(var g=0,y=x(o,Q);g<y.length;g++){var h=y[g],b=Se(e,h),S=Se(r,h);p&&!p.test(S)||f&&f.test(S)||v(b,S,n);}}},e.ensureScriptKind=function(e,t){return t||qe(e)||3},e.getScriptKindFromFileName=qe,e.supportedTypeScriptExtensions=[".ts",".tsx",".d.ts"],e.supportedTypescriptExtensionsForExtractExtension=[".d.ts",".ts",".tsx"],e.supportedJavascriptExtensions=[".js",".jsx"];var Ve=e.supportedTypeScriptExtensions.concat(e.supportedJavascriptExtensions);function We(t,r){var n=t&&t.allowJs;return r&&0!==r.length&&n?m(Ve.concat(r.map(function(e){return e.extension})),H,Q):n?Ve:e.supportedTypeScriptExtensions}function He(e,t){return e<2?0:e<t.length?2:t.length}e.getSupportedExtensions=We,e.hasJavaScriptFileExtension=function(t){return a(e.supportedJavascriptExtensions,function(e){return Ae(t,e)})},e.hasTypeScriptFileExtension=function(t){return a(e.supportedTypeScriptExtensions,function(e){return Ae(t,e)})},e.isSupportedSourceFileName=function(e,t,r){if(!e)return!1;for(var n=0,i=We(t,r);n<i.length;n++)if(Ae(e,i[n]))return!0;return!1},function(e){e[e.TypeScriptFiles=0]="TypeScriptFiles",e[e.DeclarationAndJavaScriptFiles=2]="DeclarationAndJavaScriptFiles",e[e.Highest=0]="Highest",e[e.Lowest=2]="Lowest";}(e.ExtensionPriority||(e.ExtensionPriority={})),e.getExtensionPriority=function(e,t){for(var r=t.length-1;r>=0;r--)if(Ae(e,t[r]))return He(r,t);return 0},e.adjustExtensionPriority=He,e.getNextLowestExtensionPriority=function(e,t){return e<2?2:t.length};var Ge,$e=[".d.ts",".ts",".js",".tsx",".jsx"];function Xe(e){for(var t=0,r=$e;t<r.length;t++){var n=Qe(e,r[t]);if(void 0!==n)return n}return e}function Qe(e,t){return Ae(e,t)?Ye(e,t):void 0}function Ye(e,t){return e.substring(0,e.length-t.length)}function Ze(e,t){this.flags=e,this.escapedName=t,this.declarations=void 0,this.valueDeclaration=void 0,this.id=void 0,this.mergeId=void 0,this.parent=void 0;}function et(e,t){this.flags=t,Ge.isDebugging&&(this.checker=e);}function tt(){}function rt(e,t,r){this.pos=t,this.end=r,this.kind=e,this.id=0,this.flags=0,this.modifierFlagsCache=0,this.transformFlags=0,this.parent=void 0,this.original=void 0;}function nt(e,t,r){this.fileName=e,this.text=t,this.skipTrivia=r||function(e){return e};}function it(e,t){for(var r=t;r<e.length-1;r++)e[r]=e[r+1];e.pop();}function at(e,t){e[t]=e[e.length-1],e.pop();}function ot(e,t){!function(e,t){for(var r=0;r<e.length;r++)if(t(e[r])){at(e,r);break}}(e,function(e){return e===t});}function st(e,t,r){for(var n,i=-1,a=0,o=e;a<o.length;a++){var s=o[a],c=t(s);ct(c,r)&&c.prefix.length>i&&(i=c.prefix.length,n=s);}return n}function ct(e,t){var r=e.prefix,n=e.suffix;return t.length>=r.length+n.length&&De(t,r)&&Ce(t,n)}function ut(e){Ge.assert(pe(e));var t=e.indexOf("*");return-1===t?void 0:{prefix:e.substr(0,t),suffix:e.substr(t+1)}}function lt(t){return s(e.supportedTypescriptExtensionsForExtractExtension,function(e){return Ae(t,e)})||s(e.supportedJavascriptExtensions,function(e){return Ae(t,e)})}e.removeFileExtension=Xe,e.tryRemoveExtension=Qe,e.removeExtension=Ye,e.changeExtension=function(e,t){return Xe(e)+t},e.removeMinAndVersionNumbers=function(e){var t=/[.-]((min)|(\d+(\.\d+)*))$/;return e.replace(t,"").replace(t,"")},e.objectAllocator={getNodeConstructor:function(){return rt},getTokenConstructor:function(){return rt},getIdentifierConstructor:function(){return rt},getSourceFileConstructor:function(){return rt},getSymbolConstructor:function(){return Ze},getTypeConstructor:function(){return et},getSignatureConstructor:function(){return tt},getSourceMapSourceConstructor:function(){return nt}},function(e){e[e.None=0]="None",e[e.Normal=1]="Normal",e[e.Aggressive=2]="Aggressive",e[e.VeryAggressive=3]="VeryAggressive";}(e.AssertionLevel||(e.AssertionLevel={})),function(t){function r(e,t,i,a){e||(i&&(t+="\r\nVerbose Debug Information: "+("string"==typeof i?i:i())),n(t?"False expression: "+t:"False expression.",a||r));}function n(e,t){var r=new Error(e?"Debug Failure. "+e:"Debug Failure.");throw Error.captureStackTrace&&Error.captureStackTrace(r,t||n),r}function i(e,t){return r(void 0!==e&&null!==e,t),e}function a(t){var r=e.SyntaxKind;return r?r[t.kind]:t.kind.toString()}t.currentAssertionLevel=0,t.isDebugging=!1,t.shouldAssert=function(e){return t.currentAssertionLevel>=e},t.assert=r,t.assertEqual=function(e,t,r,i){e!==t&&n("Expected "+e+" === "+t+". "+(r?i?r+" "+i:r:""));},t.assertLessThan=function(e,t,r){e>=t&&n("Expected "+e+" < "+t+". "+(r||""));},t.assertLessThanOrEqual=function(e,t){e>t&&n("Expected "+e+" <= "+t);},t.assertGreaterThanOrEqual=function(e,t){e<t&&n("Expected "+e+" >= "+t);},t.fail=n,t.assertDefined=i,t.assertEachDefined=function(e,t){for(var r=0,n=e;r<n.length;r++)i(n[r],t);return e},t.assertNever=function e(t,r,i){return n(r||"Illegal value: "+t,i||e)},t.getFunctionName=function(e){if("function"!=typeof e)return"";if(e.hasOwnProperty("name"))return e.name;var t=Function.prototype.toString.call(e),r=/^function\s+([\w\$]+)\s*\(/.exec(t);return r?r[1]:""},t.showSymbol=function(t){var r=e.SymbolFlags;return"{ flags: "+(r?function(e,t){for(var r=[],n=0;n<=30;n++){var i=1<<n;e&i&&r.push(t[i]);}return r.join("|")}(t.flags,r):t.flags)+"; declarations: "+_(t.declarations,a)+" }"},t.showSyntaxKind=a;}(Ge=e.Debug||(e.Debug={})),e.orderedRemoveItem=function(e,t){for(var r=0;r<e.length;r++)if(e[r]===t)return it(e,r),!0;return!1},e.orderedRemoveItemAt=it,e.unorderedRemoveItemAt=at,e.unorderedRemoveItem=ot,e.createGetCanonicalFileName=function(e){return e?j:J},e.matchPatternOrExact=function(e,t){for(var r=[],n=0,i=e;n<i.length;n++){var a=i[n],o=ut(a);if(o)r.push(o);else if(a===t)return a}return st(r,function(e){return e},t)},e.patternText=function(e){return e.prefix+"*"+e.suffix},e.matchedText=function(e,t){return Ge.assert(ct(e,t)),t.substring(e.prefix.length,t.length-e.suffix.length)},e.findBestPatternMatch=st,e.tryParsePattern=ut,e.positionIsSynthesized=function(e){return!(e>=0)},e.extensionIsTypeScript=function(e){return".ts"===e||".tsx"===e||".d.ts"===e},e.extensionFromPath=function(e){var t=lt(e);if(void 0!==t)return t;Ge.fail("File "+e+" has unknown extension.");},e.isAnySupportedFileExtension=function(e){return void 0!==lt(e)},e.tryGetExtensionFromPath=lt,e.getAnyExtensionFromPath=function(e){var t=xe(e),r=t.lastIndexOf(".");if(r>=0)return t.substring(r)},e.isCheckJsEnabledForFile=function(e,t){return e.checkJsDirective?e.checkJsDirective.enabled:t.checkJs},e.and=function(e,t){return function(r){return e(r)&&t(r)}},e.or=function(e,t){return function(r){return e(r)||t(r)}},e.assertTypeIsNever=function(e){},e.emptyFileSystemEntries={files:e.emptyArray,directories:e.emptyArray},e.singleElementArray=function(e){return void 0===e?void 0:[e]},e.enumerateInsertsAndDeletes=function(e,t,r,n,i,a){a=a||K;for(var o=0,s=0,c=e.length,u=t.length;o<c&&s<u;){var l=e[o],_=t[s],d=r(l,_);-1===d?(n(l),o++):1===d?(i(_),s++):(a(_,l),o++,s++);}for(;o<c;)n(e[o++]);for(;s<u;)i(t[s++]);};}(i||(i={})),function(e){var t,n;e.setStackTraceLimit=function(){Error.stackTraceLimit<100&&(Error.stackTraceLimit=100);},function(e){e[e.Created=0]="Created",e[e.Changed=1]="Changed",e[e.Deleted=2]="Deleted";}(t=e.FileWatcherEventKind||(e.FileWatcherEventKind={})),function(e){e[e.High=2e3]="High",e[e.Medium=500]="Medium",e[e.Low=250]="Low";}(n=e.PollingInterval||(e.PollingInterval={}));var i,a,o=[i=250,a=2*i,4*a];function s(e){return(t={})[n.Low]=e.Low,t[n.Medium]=e.Medium,t[n.High]=e.High,t;var t;}e.watchFileUsingPriorityPollingInterval=function(e,t,r,n){return e.watchFile(t,r,function(e){return o[e]}(n))},e.missingFileModifiedTime=new Date(0);var c={Low:32,Medium:64,High:256},u=s(c);function l(t){if(t.getEnvironmentVariable){var i=function(e,t){var r=a(e);if(r)return n("Low"),n("Medium"),n("High"),!0;return!1;function n(e){t[e]=r[e]||t[e];}}("TSC_WATCH_POLLINGINTERVAL",n);u=o("TSC_WATCH_POLLINGCHUNKSIZE",c)||u,e.unchangedPollThresholds=o("TSC_WATCH_UNCHANGEDPOLLTHRESHOLDS",c)||e.unchangedPollThresholds;}function a(e){var r;return n("Low"),n("Medium"),n("High"),r;function n(n){var i=function(e,r){return t.getEnvironmentVariable(e+"_"+r.toUpperCase())}(e,n);i&&((r||(r={}))[n]=Number(i));}}function o(e,t){var n=a(e);return(i||n)&&s(n?r({},t,n):t)}}function _(t){var r=[],i=[],a=c(n.Low),o=c(n.Medium),s=c(n.High);return function(t,n,i){var a={fileName:t,callback:n,unchangedPolls:0,mtime:v(t)};return r.push(a),m(a,i),{close:function(){a.isClosed=!0,e.unorderedRemoveItem(r,a);}}};function c(e){var t=[];return t.pollingInterval=e,t.pollIndex=0,t.pollScheduled=!1,t}function l(t){t.pollIndex=p(t,t.pollingInterval,t.pollIndex,u[t.pollingInterval]),t.length?h(t.pollingInterval):(e.Debug.assert(0===t.pollIndex),t.pollScheduled=!1);}function _(e){p(i,n.Low,0,i.length),l(e),!e.pollScheduled&&i.length&&h(n.Low);}function p(t,r,a,o){for(var s=t.length,c=a,u=0;u<o&&s>0;p(),s--){var l=t[a];if(l)if(l.isClosed)t[a]=void 0;else{u++;var _=d(l,v(l.fileName));l.isClosed?t[a]=void 0:_?(l.unchangedPolls=0,t!==i&&(t[a]=void 0,g(l))):l.unchangedPolls!==e.unchangedPollThresholds[r]?l.unchangedPolls++:t===i?(l.unchangedPolls=1,t[a]=void 0,m(l,n.Low)):r!==n.High&&(l.unchangedPolls++,t[a]=void 0,m(l,r===n.Low?n.Medium:n.High)),t[a]&&(c<a&&(t[c]=l,t[a]=void 0),c++);}}return a;function p(){++a===t.length&&(c<a&&(t.length=c),a=0,c=0);}}function f(e){switch(e){case n.Low:return a;case n.Medium:return o;case n.High:return s}}function m(e,t){f(t).push(e),y(t);}function g(e){i.push(e),y(n.Low);}function y(e){f(e).pollScheduled||h(e);}function h(e){f(e).pollScheduled=t.setTimeout(e===n.Low?_:l,e,f(e));}function v(r){return t.getModifiedTime(r)||e.missingFileModifiedTime}}function d(e,r){var n=e.mtime.getTime(),i=r.getTime();if(n!==i){e.mtime=r;var a=0===n?t.Created:0===i?t.Deleted:t.Changed;return e.callback(e.fileName,a),!0}return!1}function p(t){return r;function r(r,i){var a=t.watchDirectory(r,function(e){i(e),n(o,i);}),o={close:function(){a.close(),o.childWatches.forEach(e.closeFileWatcher),o=void 0;},dirName:r,childWatches:e.emptyArray};return n(o,i),o}function n(n,i){n&&(n.childWatches=function(n,i,a){var o;return e.enumerateInsertsAndDeletes(t.directoryExists(n)?t.getAccessileSortedChildDirectories(n):e.emptyArray,i,function(r,i){return t.filePathComparer(e.getNormalizedAbsolutePath(r,n),i.dirName)},function(t){s(r(e.getNormalizedAbsolutePath(t,n),a));},e.closeFileWatcher,s),o||e.emptyArray;function s(e){(o||(o=[])).push(e);}}(n.dirName,n.childWatches,i));}}function f(){if("undefined"!=typeof process){var e=process.version;if(e){var t=e.indexOf(".");if(-1!==t)return parseInt(e.substring(1,t))}}}e.unchangedPollThresholds=s(c),e.setCustomPollingValues=l,e.createDynamicPriorityPollingWatchFile=_,e.onWatchedFileStat=d,e.createRecursiveDirectoryWatcher=p,e.getNodeMajorVersion=f,e.sys=function(){var r,i,a="\ufeff";if("undefined"!=typeof ChakraHost?(i=ChakraHost.realpath&&function(e){return ChakraHost.realpath(e)},r={newLine:ChakraHost.newLine||"\r\n",args:ChakraHost.args,useCaseSensitiveFileNames:!!ChakraHost.useCaseSensitiveFileNames,write:ChakraHost.echo,readFile:function(e,t){return ChakraHost.readFile(e)},writeFile:function(e,t,r){r&&(t=a+t),ChakraHost.writeFile(e,t);},resolvePath:ChakraHost.resolvePath,fileExists:ChakraHost.fileExists,directoryExists:ChakraHost.directoryExists,createDirectory:ChakraHost.createDirectory,getExecutingFilePath:function(){return ChakraHost.executingFile},getCurrentDirectory:function(){return ChakraHost.currentDirectory},getDirectories:ChakraHost.getDirectories,getEnvironmentVariable:ChakraHost.getEnvironmentVariable||function(){return""},readDirectory:function(t,r,n,i,a){var o=e.getFileMatcherPatterns(t,n,i,!!ChakraHost.useCaseSensitiveFileNames,ChakraHost.currentDirectory);return ChakraHost.readDirectory(t,r,o.basePaths,o.excludePattern,o.includeFilePattern,o.includeDirectoryPattern)},exit:ChakraHost.quit,realpath:i}):"undefined"!=typeof process&&nextTick&&!browser$1&&void 0!==commonjsRequire$$1&&(r=function(){var r,i=fs$$1,o=path$$1,s=os$$1;try{r=crypto$$1;}catch(e){r=void 0;}var c,u=f()>=4,l=s.platform(),d="win32"!==l&&"win64"!==l&&!w((m=__filename,m.replace(/\w/g,function(e){var t=e.toUpperCase();return e===t?e.toLowerCase():t})));var m;!function(e){e[e.File=0]="File",e[e.Directory=1]="Directory";}(c||(c={}));var g,y=process.env.TSC_NONPOLLING_WATCHER,h=process.env.TSC_WATCHFILE,v=process.env.TSC_WATCHDIRECTORY,b={args:process.argv.slice(2),newLine:s.EOL,useCaseSensitiveFileNames:d,write:function(e){process.stdout.write(e);},readFile:function(e,t){if(w(e)){var r=i.readFileSync(e),n=r.length;if(n>=2&&254===r[0]&&255===r[1]){n&=-2;for(var a=0;a<n;a+=2){var o=r[a];r[a]=r[a+1],r[a+1]=o;}return r.toString("utf16le",2)}return n>=2&&255===r[0]&&254===r[1]?r.toString("utf16le",2):n>=3&&239===r[0]&&187===r[1]&&191===r[2]?r.toString("utf8",3):r.toString("utf8")}},writeFile:function(e,t,r){var n;r&&(t=a+t);try{n=i.openSync(e,"w"),i.writeSync(n,t,void 0,"utf8");}finally{void 0!==n&&i.closeSync(n);}},watchFile:function(){switch(h){case"PriorityPollingInterval":return S;case"DynamicPriorityPolling":return _({getModifiedTime:O,setTimeout:setTimeout});case"UseFsEvents":return D;case"UseFsEventsWithFallbackDynamicPolling":return g=_({getModifiedTime:O,setTimeout:setTimeout}),e=g,function(t,r,n){return T(t,0,k(t,r),!1,e,n)};case"UseFsEventsOnParentDirectory":return x()}var e;return y?x():function(e,t){return S(e,t)}}(),watchDirectory:function(){if(u&&("win32"===process.platform||"darwin"===process.platform))return E;var t="RecursiveDirectoryUsingFsWatchFile"===v?N(S):"RecursiveDirectoryUsingDynamicPriorityPolling"===v?N(g||_({getModifiedTime:O,setTimeout:setTimeout})):E,r=p({filePathComparer:d?e.compareStringsCaseSensitive:e.compareStringsCaseInsensitive,directoryExists:F,getAccessileSortedChildDirectories:function(e){return A(e).directories},watchDirectory:t});return function(e,n,i){if(i)return r(e,n);t(e,n);}}(),resolvePath:function(e){return o.resolve(e)},fileExists:w,directoryExists:F,createDirectory:function(e){b.directoryExists(e)||i.mkdirSync(e);},getExecutingFilePath:function(){return __filename},getCurrentDirectory:function(){return process.cwd()},getDirectories:function(t){return e.filter(i.readdirSync(t),function(r){return P(e.combinePaths(t,r),1)})},getEnvironmentVariable:function(e){return process.env[e]||""},readDirectory:function(t,r,n,i,a){return e.matchFiles(t,r,n,i,d,process.cwd(),a,A)},getModifiedTime:O,createHash:r?function(e){var t=r.createHash("md5");return t.update(e),t.digest("hex")}:function(e){return""+e.split("").map(function(e){return e.charCodeAt(0)}).reduce(function(e,t){return(e<<5)+e+t},5381)},getMemoryUsage:function(){return commonjsGlobal$$1.gc&&commonjsGlobal$$1.gc(),process.memoryUsage().heapUsed},getFileSize:function(e){try{var t=i.statSync(e);if(t.isFile())return t.size}catch(e){}return 0},exit:function(e){process.exit(e);},realpath:function(e){try{return i.realpathSync(e)}catch(t){return e}},debugMode:e.some(process.execArgv,function(e){return/^--(inspect|debug)(-brk)?(=\d+)?$/i.test(e)}),tryEnableSourceMapsForHost:function(){try{sourceMapSupport.install();}catch(e){}},setTimeout:setTimeout,clearTimeout:clearTimeout,clearScreen:function(){process.stdout.write("c");},setBlocking:function(){process.stdout&&process.stdout._handle&&process.stdout._handle.setBlocking&&process.stdout._handle.setBlocking(!0);}};return b;function x(){var r=e.createMultiMap(),n=e.createMap(),i=e.createGetCanonicalFileName(d);return function(a,o){var s=i(a);r.add(s,o);var c=e.getDirectoryPath(s)||".",u=n.get(c)||function(a,o){var s=C(a,function(n,o){var s=e.isString(o)?e.getNormalizedAbsolutePath(o,a):void 0,c=r.get(i(s));if(c)for(var u=0,l=c;u<l.length;u++){var _=l[u];_(s,t.Changed);}});return s.referenceCount=0,n.set(o,s),s}(e.getDirectoryPath(a)||".",c);return u.referenceCount++,{close:function(){1===u.referenceCount?(u.close(),n.delete(c)):u.referenceCount--,r.remove(s,o);}}}}function S(e,r,n){var a;return i.watchFile(e,{persistent:!0,interval:n||250},o),{close:function(){return i.unwatchFile(e,o)}};function o(n,i){if(0==+n.mtime)a=t.Deleted;else if(0==+i.mtime||a===t.Deleted)a=t.Created;else{if(+n.mtime==+i.mtime)return;a=t.Changed;}r(e,a);}}function k(e,r){return function(n){r(e,"rename"===n?w(e)?t.Created:t.Deleted:t.Changed);}}function T(e,r,n,a,o,s){var c,l=P(e,r)?d():p();return{close:function(){l.close(),l=void 0;}};function _(e){n("rename",""),l&&(l.close(),l=e());}function d(){void 0===c&&(c=!u||"win32"!==process.platform&&"darwin"!==process.platform?{persistent:!0}:{persistent:!0,recursive:!!a});try{var r=i.watch(e,c,n);return r.on("error",function(){return _(p)}),r}catch(r){return o(e,function(e){return function(r,n){return e(n===t.Changed?"change":"rename","")}}(n),s)}}function p(){return o(e,function(n,i){i===t.Created&&P(e,r)&&_(d);},s)}}function D(e,t,r){return T(e,0,k(e,t),!1,S,r)}function C(e,t,r){return T(e,1,t,!!r,S)}function E(t,r,n){return C(t,function(t,r){return function(n,i){"rename"===n&&r(i?e.normalizePath(e.combinePaths(t,i)):t);}}(t,r),n)}function N(e){return function(t,r){return e(t,function(){return r(t)},n.Medium)}}function A(t){try{for(var r=i.readdirSync(t||".").sort(),n=[],a=[],o=0,s=r;o<s.length;o++){var c=s[o];if("."!==c&&".."!==c){var u=e.combinePaths(t,c),l=void 0;try{l=i.statSync(u);}catch(e){continue}l.isFile()?n.push(c):l.isDirectory()&&a.push(c);}}return{files:n,directories:a}}catch(t){return e.emptyFileSystemEntries}}function P(e,t){try{var r=i.statSync(e);switch(t){case 0:return r.isFile();case 1:return r.isDirectory()}}catch(e){return!1}}function w(e){return P(e,0)}function F(e){return P(e,1)}function O(e){try{return i.statSync(e).mtime}catch(e){return}}}()),r){var o=r.writeFile;r.writeFile=function(t,n,i){var a=e.getDirectoryPath(e.normalizeSlashes(t));a&&!r.directoryExists(a)&&function t(r,n){var i=e.getDirectoryPath(r),a=""!==i&&r!==i&&!n.directoryExists(i);a&&t(i,n),!a&&n.directoryExists(r)||n.createDirectory(r);}(a,r),o.call(r,t,n,i);};}return r}(),e.sys&&e.sys.getEnvironmentVariable&&(l(e.sys),e.Debug.currentAssertionLevel=/^development$/i.test(e.sys.getEnvironmentVariable("NODE_ENV"))?1:0),e.sys&&e.sys.debugMode&&(e.Debug.isDebugging=!0);}(i||(i={})),function(e){function t(e,t,r,n){return{code:e,category:t,key:r,message:n}}e.Diagnostics={Unterminated_string_literal:t(1002,e.DiagnosticCategory.Error,"Unterminated_string_literal_1002","Unterminated string literal."),Identifier_expected:t(1003,e.DiagnosticCategory.Error,"Identifier_expected_1003","Identifier expected."),_0_expected:t(1005,e.DiagnosticCategory.Error,"_0_expected_1005","'{0}' expected."),A_file_cannot_have_a_reference_to_itself:t(1006,e.DiagnosticCategory.Error,"A_file_cannot_have_a_reference_to_itself_1006","A file cannot have a reference to itself."),Trailing_comma_not_allowed:t(1009,e.DiagnosticCategory.Error,"Trailing_comma_not_allowed_1009","Trailing comma not allowed."),Asterisk_Slash_expected:t(1010,e.DiagnosticCategory.Error,"Asterisk_Slash_expected_1010","'*/' expected."),Unexpected_token:t(1012,e.DiagnosticCategory.Error,"Unexpected_token_1012","Unexpected token."),A_rest_parameter_must_be_last_in_a_parameter_list:t(1014,e.DiagnosticCategory.Error,"A_rest_parameter_must_be_last_in_a_parameter_list_1014","A rest parameter must be last in a parameter list."),Parameter_cannot_have_question_mark_and_initializer:t(1015,e.DiagnosticCategory.Error,"Parameter_cannot_have_question_mark_and_initializer_1015","Parameter cannot have question mark and initializer."),A_required_parameter_cannot_follow_an_optional_parameter:t(1016,e.DiagnosticCategory.Error,"A_required_parameter_cannot_follow_an_optional_parameter_1016","A required parameter cannot follow an optional parameter."),An_index_signature_cannot_have_a_rest_parameter:t(1017,e.DiagnosticCategory.Error,"An_index_signature_cannot_have_a_rest_parameter_1017","An index signature cannot have a rest parameter."),An_index_signature_parameter_cannot_have_an_accessibility_modifier:t(1018,e.DiagnosticCategory.Error,"An_index_signature_parameter_cannot_have_an_accessibility_modifier_1018","An index signature parameter cannot have an accessibility modifier."),An_index_signature_parameter_cannot_have_a_question_mark:t(1019,e.DiagnosticCategory.Error,"An_index_signature_parameter_cannot_have_a_question_mark_1019","An index signature parameter cannot have a question mark."),An_index_signature_parameter_cannot_have_an_initializer:t(1020,e.DiagnosticCategory.Error,"An_index_signature_parameter_cannot_have_an_initializer_1020","An index signature parameter cannot have an initializer."),An_index_signature_must_have_a_type_annotation:t(1021,e.DiagnosticCategory.Error,"An_index_signature_must_have_a_type_annotation_1021","An index signature must have a type annotation."),An_index_signature_parameter_must_have_a_type_annotation:t(1022,e.DiagnosticCategory.Error,"An_index_signature_parameter_must_have_a_type_annotation_1022","An index signature parameter must have a type annotation."),An_index_signature_parameter_type_must_be_string_or_number:t(1023,e.DiagnosticCategory.Error,"An_index_signature_parameter_type_must_be_string_or_number_1023","An index signature parameter type must be 'string' or 'number'."),readonly_modifier_can_only_appear_on_a_property_declaration_or_index_signature:t(1024,e.DiagnosticCategory.Error,"readonly_modifier_can_only_appear_on_a_property_declaration_or_index_signature_1024","'readonly' modifier can only appear on a property declaration or index signature."),Accessibility_modifier_already_seen:t(1028,e.DiagnosticCategory.Error,"Accessibility_modifier_already_seen_1028","Accessibility modifier already seen."),_0_modifier_must_precede_1_modifier:t(1029,e.DiagnosticCategory.Error,"_0_modifier_must_precede_1_modifier_1029","'{0}' modifier must precede '{1}' modifier."),_0_modifier_already_seen:t(1030,e.DiagnosticCategory.Error,"_0_modifier_already_seen_1030","'{0}' modifier already seen."),_0_modifier_cannot_appear_on_a_class_element:t(1031,e.DiagnosticCategory.Error,"_0_modifier_cannot_appear_on_a_class_element_1031","'{0}' modifier cannot appear on a class element."),super_must_be_followed_by_an_argument_list_or_member_access:t(1034,e.DiagnosticCategory.Error,"super_must_be_followed_by_an_argument_list_or_member_access_1034","'super' must be followed by an argument list or member access."),Only_ambient_modules_can_use_quoted_names:t(1035,e.DiagnosticCategory.Error,"Only_ambient_modules_can_use_quoted_names_1035","Only ambient modules can use quoted names."),Statements_are_not_allowed_in_ambient_contexts:t(1036,e.DiagnosticCategory.Error,"Statements_are_not_allowed_in_ambient_contexts_1036","Statements are not allowed in ambient contexts."),A_declare_modifier_cannot_be_used_in_an_already_ambient_context:t(1038,e.DiagnosticCategory.Error,"A_declare_modifier_cannot_be_used_in_an_already_ambient_context_1038","A 'declare' modifier cannot be used in an already ambient context."),Initializers_are_not_allowed_in_ambient_contexts:t(1039,e.DiagnosticCategory.Error,"Initializers_are_not_allowed_in_ambient_contexts_1039","Initializers are not allowed in ambient contexts."),_0_modifier_cannot_be_used_in_an_ambient_context:t(1040,e.DiagnosticCategory.Error,"_0_modifier_cannot_be_used_in_an_ambient_context_1040","'{0}' modifier cannot be used in an ambient context."),_0_modifier_cannot_be_used_with_a_class_declaration:t(1041,e.DiagnosticCategory.Error,"_0_modifier_cannot_be_used_with_a_class_declaration_1041","'{0}' modifier cannot be used with a class declaration."),_0_modifier_cannot_be_used_here:t(1042,e.DiagnosticCategory.Error,"_0_modifier_cannot_be_used_here_1042","'{0}' modifier cannot be used here."),_0_modifier_cannot_appear_on_a_data_property:t(1043,e.DiagnosticCategory.Error,"_0_modifier_cannot_appear_on_a_data_property_1043","'{0}' modifier cannot appear on a data property."),_0_modifier_cannot_appear_on_a_module_or_namespace_element:t(1044,e.DiagnosticCategory.Error,"_0_modifier_cannot_appear_on_a_module_or_namespace_element_1044","'{0}' modifier cannot appear on a module or namespace element."),A_0_modifier_cannot_be_used_with_an_interface_declaration:t(1045,e.DiagnosticCategory.Error,"A_0_modifier_cannot_be_used_with_an_interface_declaration_1045","A '{0}' modifier cannot be used with an interface declaration."),A_declare_modifier_is_required_for_a_top_level_declaration_in_a_d_ts_file:t(1046,e.DiagnosticCategory.Error,"A_declare_modifier_is_required_for_a_top_level_declaration_in_a_d_ts_file_1046","A 'declare' modifier is required for a top level declaration in a .d.ts file."),A_rest_parameter_cannot_be_optional:t(1047,e.DiagnosticCategory.Error,"A_rest_parameter_cannot_be_optional_1047","A rest parameter cannot be optional."),A_rest_parameter_cannot_have_an_initializer:t(1048,e.DiagnosticCategory.Error,"A_rest_parameter_cannot_have_an_initializer_1048","A rest parameter cannot have an initializer."),A_set_accessor_must_have_exactly_one_parameter:t(1049,e.DiagnosticCategory.Error,"A_set_accessor_must_have_exactly_one_parameter_1049","A 'set' accessor must have exactly one parameter."),A_set_accessor_cannot_have_an_optional_parameter:t(1051,e.DiagnosticCategory.Error,"A_set_accessor_cannot_have_an_optional_parameter_1051","A 'set' accessor cannot have an optional parameter."),A_set_accessor_parameter_cannot_have_an_initializer:t(1052,e.DiagnosticCategory.Error,"A_set_accessor_parameter_cannot_have_an_initializer_1052","A 'set' accessor parameter cannot have an initializer."),A_set_accessor_cannot_have_rest_parameter:t(1053,e.DiagnosticCategory.Error,"A_set_accessor_cannot_have_rest_parameter_1053","A 'set' accessor cannot have rest parameter."),A_get_accessor_cannot_have_parameters:t(1054,e.DiagnosticCategory.Error,"A_get_accessor_cannot_have_parameters_1054","A 'get' accessor cannot have parameters."),Type_0_is_not_a_valid_async_function_return_type_in_ES5_SlashES3_because_it_does_not_refer_to_a_Promise_compatible_constructor_value:t(1055,e.DiagnosticCategory.Error,"Type_0_is_not_a_valid_async_function_return_type_in_ES5_SlashES3_because_it_does_not_refer_to_a_Prom_1055","Type '{0}' is not a valid async function return type in ES5/ES3 because it does not refer to a Promise-compatible constructor value."),Accessors_are_only_available_when_targeting_ECMAScript_5_and_higher:t(1056,e.DiagnosticCategory.Error,"Accessors_are_only_available_when_targeting_ECMAScript_5_and_higher_1056","Accessors are only available when targeting ECMAScript 5 and higher."),An_async_function_or_method_must_have_a_valid_awaitable_return_type:t(1057,e.DiagnosticCategory.Error,"An_async_function_or_method_must_have_a_valid_awaitable_return_type_1057","An async function or method must have a valid awaitable return type."),The_return_type_of_an_async_function_must_either_be_a_valid_promise_or_must_not_contain_a_callable_then_member:t(1058,e.DiagnosticCategory.Error,"The_return_type_of_an_async_function_must_either_be_a_valid_promise_or_must_not_contain_a_callable_t_1058","The return type of an async function must either be a valid promise or must not contain a callable 'then' member."),A_promise_must_have_a_then_method:t(1059,e.DiagnosticCategory.Error,"A_promise_must_have_a_then_method_1059","A promise must have a 'then' method."),The_first_parameter_of_the_then_method_of_a_promise_must_be_a_callback:t(1060,e.DiagnosticCategory.Error,"The_first_parameter_of_the_then_method_of_a_promise_must_be_a_callback_1060","The first parameter of the 'then' method of a promise must be a callback."),Enum_member_must_have_initializer:t(1061,e.DiagnosticCategory.Error,"Enum_member_must_have_initializer_1061","Enum member must have initializer."),Type_is_referenced_directly_or_indirectly_in_the_fulfillment_callback_of_its_own_then_method:t(1062,e.DiagnosticCategory.Error,"Type_is_referenced_directly_or_indirectly_in_the_fulfillment_callback_of_its_own_then_method_1062","Type is referenced directly or indirectly in the fulfillment callback of its own 'then' method."),An_export_assignment_cannot_be_used_in_a_namespace:t(1063,e.DiagnosticCategory.Error,"An_export_assignment_cannot_be_used_in_a_namespace_1063","An export assignment cannot be used in a namespace."),The_return_type_of_an_async_function_or_method_must_be_the_global_Promise_T_type:t(1064,e.DiagnosticCategory.Error,"The_return_type_of_an_async_function_or_method_must_be_the_global_Promise_T_type_1064","The return type of an async function or method must be the global Promise<T> type."),In_ambient_enum_declarations_member_initializer_must_be_constant_expression:t(1066,e.DiagnosticCategory.Error,"In_ambient_enum_declarations_member_initializer_must_be_constant_expression_1066","In ambient enum declarations member initializer must be constant expression."),Unexpected_token_A_constructor_method_accessor_or_property_was_expected:t(1068,e.DiagnosticCategory.Error,"Unexpected_token_A_constructor_method_accessor_or_property_was_expected_1068","Unexpected token. A constructor, method, accessor, or property was expected."),_0_modifier_cannot_appear_on_a_type_member:t(1070,e.DiagnosticCategory.Error,"_0_modifier_cannot_appear_on_a_type_member_1070","'{0}' modifier cannot appear on a type member."),_0_modifier_cannot_appear_on_an_index_signature:t(1071,e.DiagnosticCategory.Error,"_0_modifier_cannot_appear_on_an_index_signature_1071","'{0}' modifier cannot appear on an index signature."),A_0_modifier_cannot_be_used_with_an_import_declaration:t(1079,e.DiagnosticCategory.Error,"A_0_modifier_cannot_be_used_with_an_import_declaration_1079","A '{0}' modifier cannot be used with an import declaration."),Invalid_reference_directive_syntax:t(1084,e.DiagnosticCategory.Error,"Invalid_reference_directive_syntax_1084","Invalid 'reference' directive syntax."),Octal_literals_are_not_available_when_targeting_ECMAScript_5_and_higher_Use_the_syntax_0:t(1085,e.DiagnosticCategory.Error,"Octal_literals_are_not_available_when_targeting_ECMAScript_5_and_higher_Use_the_syntax_0_1085","Octal literals are not available when targeting ECMAScript 5 and higher. Use the syntax '{0}'."),An_accessor_cannot_be_declared_in_an_ambient_context:t(1086,e.DiagnosticCategory.Error,"An_accessor_cannot_be_declared_in_an_ambient_context_1086","An accessor cannot be declared in an ambient context."),_0_modifier_cannot_appear_on_a_constructor_declaration:t(1089,e.DiagnosticCategory.Error,"_0_modifier_cannot_appear_on_a_constructor_declaration_1089","'{0}' modifier cannot appear on a constructor declaration."),_0_modifier_cannot_appear_on_a_parameter:t(1090,e.DiagnosticCategory.Error,"_0_modifier_cannot_appear_on_a_parameter_1090","'{0}' modifier cannot appear on a parameter."),Only_a_single_variable_declaration_is_allowed_in_a_for_in_statement:t(1091,e.DiagnosticCategory.Error,"Only_a_single_variable_declaration_is_allowed_in_a_for_in_statement_1091","Only a single variable declaration is allowed in a 'for...in' statement."),Type_parameters_cannot_appear_on_a_constructor_declaration:t(1092,e.DiagnosticCategory.Error,"Type_parameters_cannot_appear_on_a_constructor_declaration_1092","Type parameters cannot appear on a constructor declaration."),Type_annotation_cannot_appear_on_a_constructor_declaration:t(1093,e.DiagnosticCategory.Error,"Type_annotation_cannot_appear_on_a_constructor_declaration_1093","Type annotation cannot appear on a constructor declaration."),An_accessor_cannot_have_type_parameters:t(1094,e.DiagnosticCategory.Error,"An_accessor_cannot_have_type_parameters_1094","An accessor cannot have type parameters."),A_set_accessor_cannot_have_a_return_type_annotation:t(1095,e.DiagnosticCategory.Error,"A_set_accessor_cannot_have_a_return_type_annotation_1095","A 'set' accessor cannot have a return type annotation."),An_index_signature_must_have_exactly_one_parameter:t(1096,e.DiagnosticCategory.Error,"An_index_signature_must_have_exactly_one_parameter_1096","An index signature must have exactly one parameter."),_0_list_cannot_be_empty:t(1097,e.DiagnosticCategory.Error,"_0_list_cannot_be_empty_1097","'{0}' list cannot be empty."),Type_parameter_list_cannot_be_empty:t(1098,e.DiagnosticCategory.Error,"Type_parameter_list_cannot_be_empty_1098","Type parameter list cannot be empty."),Type_argument_list_cannot_be_empty:t(1099,e.DiagnosticCategory.Error,"Type_argument_list_cannot_be_empty_1099","Type argument list cannot be empty."),Invalid_use_of_0_in_strict_mode:t(1100,e.DiagnosticCategory.Error,"Invalid_use_of_0_in_strict_mode_1100","Invalid use of '{0}' in strict mode."),with_statements_are_not_allowed_in_strict_mode:t(1101,e.DiagnosticCategory.Error,"with_statements_are_not_allowed_in_strict_mode_1101","'with' statements are not allowed in strict mode."),delete_cannot_be_called_on_an_identifier_in_strict_mode:t(1102,e.DiagnosticCategory.Error,"delete_cannot_be_called_on_an_identifier_in_strict_mode_1102","'delete' cannot be called on an identifier in strict mode."),A_for_await_of_statement_is_only_allowed_within_an_async_function_or_async_generator:t(1103,e.DiagnosticCategory.Error,"A_for_await_of_statement_is_only_allowed_within_an_async_function_or_async_generator_1103","A 'for-await-of' statement is only allowed within an async function or async generator."),A_continue_statement_can_only_be_used_within_an_enclosing_iteration_statement:t(1104,e.DiagnosticCategory.Error,"A_continue_statement_can_only_be_used_within_an_enclosing_iteration_statement_1104","A 'continue' statement can only be used within an enclosing iteration statement."),A_break_statement_can_only_be_used_within_an_enclosing_iteration_or_switch_statement:t(1105,e.DiagnosticCategory.Error,"A_break_statement_can_only_be_used_within_an_enclosing_iteration_or_switch_statement_1105","A 'break' statement can only be used within an enclosing iteration or switch statement."),Jump_target_cannot_cross_function_boundary:t(1107,e.DiagnosticCategory.Error,"Jump_target_cannot_cross_function_boundary_1107","Jump target cannot cross function boundary."),A_return_statement_can_only_be_used_within_a_function_body:t(1108,e.DiagnosticCategory.Error,"A_return_statement_can_only_be_used_within_a_function_body_1108","A 'return' statement can only be used within a function body."),Expression_expected:t(1109,e.DiagnosticCategory.Error,"Expression_expected_1109","Expression expected."),Type_expected:t(1110,e.DiagnosticCategory.Error,"Type_expected_1110","Type expected."),A_default_clause_cannot_appear_more_than_once_in_a_switch_statement:t(1113,e.DiagnosticCategory.Error,"A_default_clause_cannot_appear_more_than_once_in_a_switch_statement_1113","A 'default' clause cannot appear more than once in a 'switch' statement."),Duplicate_label_0:t(1114,e.DiagnosticCategory.Error,"Duplicate_label_0_1114","Duplicate label '{0}'."),A_continue_statement_can_only_jump_to_a_label_of_an_enclosing_iteration_statement:t(1115,e.DiagnosticCategory.Error,"A_continue_statement_can_only_jump_to_a_label_of_an_enclosing_iteration_statement_1115","A 'continue' statement can only jump to a label of an enclosing iteration statement."),A_break_statement_can_only_jump_to_a_label_of_an_enclosing_statement:t(1116,e.DiagnosticCategory.Error,"A_break_statement_can_only_jump_to_a_label_of_an_enclosing_statement_1116","A 'break' statement can only jump to a label of an enclosing statement."),An_object_literal_cannot_have_multiple_properties_with_the_same_name_in_strict_mode:t(1117,e.DiagnosticCategory.Error,"An_object_literal_cannot_have_multiple_properties_with_the_same_name_in_strict_mode_1117","An object literal cannot have multiple properties with the same name in strict mode."),An_object_literal_cannot_have_multiple_get_Slashset_accessors_with_the_same_name:t(1118,e.DiagnosticCategory.Error,"An_object_literal_cannot_have_multiple_get_Slashset_accessors_with_the_same_name_1118","An object literal cannot have multiple get/set accessors with the same name."),An_object_literal_cannot_have_property_and_accessor_with_the_same_name:t(1119,e.DiagnosticCategory.Error,"An_object_literal_cannot_have_property_and_accessor_with_the_same_name_1119","An object literal cannot have property and accessor with the same name."),An_export_assignment_cannot_have_modifiers:t(1120,e.DiagnosticCategory.Error,"An_export_assignment_cannot_have_modifiers_1120","An export assignment cannot have modifiers."),Octal_literals_are_not_allowed_in_strict_mode:t(1121,e.DiagnosticCategory.Error,"Octal_literals_are_not_allowed_in_strict_mode_1121","Octal literals are not allowed in strict mode."),A_tuple_type_element_list_cannot_be_empty:t(1122,e.DiagnosticCategory.Error,"A_tuple_type_element_list_cannot_be_empty_1122","A tuple type element list cannot be empty."),Variable_declaration_list_cannot_be_empty:t(1123,e.DiagnosticCategory.Error,"Variable_declaration_list_cannot_be_empty_1123","Variable declaration list cannot be empty."),Digit_expected:t(1124,e.DiagnosticCategory.Error,"Digit_expected_1124","Digit expected."),Hexadecimal_digit_expected:t(1125,e.DiagnosticCategory.Error,"Hexadecimal_digit_expected_1125","Hexadecimal digit expected."),Unexpected_end_of_text:t(1126,e.DiagnosticCategory.Error,"Unexpected_end_of_text_1126","Unexpected end of text."),Invalid_character:t(1127,e.DiagnosticCategory.Error,"Invalid_character_1127","Invalid character."),Declaration_or_statement_expected:t(1128,e.DiagnosticCategory.Error,"Declaration_or_statement_expected_1128","Declaration or statement expected."),Statement_expected:t(1129,e.DiagnosticCategory.Error,"Statement_expected_1129","Statement expected."),case_or_default_expected:t(1130,e.DiagnosticCategory.Error,"case_or_default_expected_1130","'case' or 'default' expected."),Property_or_signature_expected:t(1131,e.DiagnosticCategory.Error,"Property_or_signature_expected_1131","Property or signature expected."),Enum_member_expected:t(1132,e.DiagnosticCategory.Error,"Enum_member_expected_1132","Enum member expected."),Variable_declaration_expected:t(1134,e.DiagnosticCategory.Error,"Variable_declaration_expected_1134","Variable declaration expected."),Argument_expression_expected:t(1135,e.DiagnosticCategory.Error,"Argument_expression_expected_1135","Argument expression expected."),Property_assignment_expected:t(1136,e.DiagnosticCategory.Error,"Property_assignment_expected_1136","Property assignment expected."),Expression_or_comma_expected:t(1137,e.DiagnosticCategory.Error,"Expression_or_comma_expected_1137","Expression or comma expected."),Parameter_declaration_expected:t(1138,e.DiagnosticCategory.Error,"Parameter_declaration_expected_1138","Parameter declaration expected."),Type_parameter_declaration_expected:t(1139,e.DiagnosticCategory.Error,"Type_parameter_declaration_expected_1139","Type parameter declaration expected."),Type_argument_expected:t(1140,e.DiagnosticCategory.Error,"Type_argument_expected_1140","Type argument expected."),String_literal_expected:t(1141,e.DiagnosticCategory.Error,"String_literal_expected_1141","String literal expected."),Line_break_not_permitted_here:t(1142,e.DiagnosticCategory.Error,"Line_break_not_permitted_here_1142","Line break not permitted here."),or_expected:t(1144,e.DiagnosticCategory.Error,"or_expected_1144","'{' or ';' expected."),Declaration_expected:t(1146,e.DiagnosticCategory.Error,"Declaration_expected_1146","Declaration expected."),Import_declarations_in_a_namespace_cannot_reference_a_module:t(1147,e.DiagnosticCategory.Error,"Import_declarations_in_a_namespace_cannot_reference_a_module_1147","Import declarations in a namespace cannot reference a module."),Cannot_use_imports_exports_or_module_augmentations_when_module_is_none:t(1148,e.DiagnosticCategory.Error,"Cannot_use_imports_exports_or_module_augmentations_when_module_is_none_1148","Cannot use imports, exports, or module augmentations when '--module' is 'none'."),File_name_0_differs_from_already_included_file_name_1_only_in_casing:t(1149,e.DiagnosticCategory.Error,"File_name_0_differs_from_already_included_file_name_1_only_in_casing_1149","File name '{0}' differs from already included file name '{1}' only in casing."),new_T_cannot_be_used_to_create_an_array_Use_new_Array_T_instead:t(1150,e.DiagnosticCategory.Error,"new_T_cannot_be_used_to_create_an_array_Use_new_Array_T_instead_1150","'new T[]' cannot be used to create an array. Use 'new Array<T>()' instead."),const_declarations_must_be_initialized:t(1155,e.DiagnosticCategory.Error,"const_declarations_must_be_initialized_1155","'const' declarations must be initialized."),const_declarations_can_only_be_declared_inside_a_block:t(1156,e.DiagnosticCategory.Error,"const_declarations_can_only_be_declared_inside_a_block_1156","'const' declarations can only be declared inside a block."),let_declarations_can_only_be_declared_inside_a_block:t(1157,e.DiagnosticCategory.Error,"let_declarations_can_only_be_declared_inside_a_block_1157","'let' declarations can only be declared inside a block."),Unterminated_template_literal:t(1160,e.DiagnosticCategory.Error,"Unterminated_template_literal_1160","Unterminated template literal."),Unterminated_regular_expression_literal:t(1161,e.DiagnosticCategory.Error,"Unterminated_regular_expression_literal_1161","Unterminated regular expression literal."),An_object_member_cannot_be_declared_optional:t(1162,e.DiagnosticCategory.Error,"An_object_member_cannot_be_declared_optional_1162","An object member cannot be declared optional."),A_yield_expression_is_only_allowed_in_a_generator_body:t(1163,e.DiagnosticCategory.Error,"A_yield_expression_is_only_allowed_in_a_generator_body_1163","A 'yield' expression is only allowed in a generator body."),Computed_property_names_are_not_allowed_in_enums:t(1164,e.DiagnosticCategory.Error,"Computed_property_names_are_not_allowed_in_enums_1164","Computed property names are not allowed in enums."),A_computed_property_name_in_an_ambient_context_must_refer_to_an_expression_whose_type_is_a_literal_type_or_a_unique_symbol_type:t(1165,e.DiagnosticCategory.Error,"A_computed_property_name_in_an_ambient_context_must_refer_to_an_expression_whose_type_is_a_literal_t_1165","A computed property name in an ambient context must refer to an expression whose type is a literal type or a 'unique symbol' type."),A_computed_property_name_in_a_class_property_declaration_must_refer_to_an_expression_whose_type_is_a_literal_type_or_a_unique_symbol_type:t(1166,e.DiagnosticCategory.Error,"A_computed_property_name_in_a_class_property_declaration_must_refer_to_an_expression_whose_type_is_a_1166","A computed property name in a class property declaration must refer to an expression whose type is a literal type or a 'unique symbol' type."),A_computed_property_name_in_a_method_overload_must_refer_to_an_expression_whose_type_is_a_literal_type_or_a_unique_symbol_type:t(1168,e.DiagnosticCategory.Error,"A_computed_property_name_in_a_method_overload_must_refer_to_an_expression_whose_type_is_a_literal_ty_1168","A computed property name in a method overload must refer to an expression whose type is a literal type or a 'unique symbol' type."),A_computed_property_name_in_an_interface_must_refer_to_an_expression_whose_type_is_a_literal_type_or_a_unique_symbol_type:t(1169,e.DiagnosticCategory.Error,"A_computed_property_name_in_an_interface_must_refer_to_an_expression_whose_type_is_a_literal_type_or_1169","A computed property name in an interface must refer to an expression whose type is a literal type or a 'unique symbol' type."),A_computed_property_name_in_a_type_literal_must_refer_to_an_expression_whose_type_is_a_literal_type_or_a_unique_symbol_type:t(1170,e.DiagnosticCategory.Error,"A_computed_property_name_in_a_type_literal_must_refer_to_an_expression_whose_type_is_a_literal_type__1170","A computed property name in a type literal must refer to an expression whose type is a literal type or a 'unique symbol' type."),A_comma_expression_is_not_allowed_in_a_computed_property_name:t(1171,e.DiagnosticCategory.Error,"A_comma_expression_is_not_allowed_in_a_computed_property_name_1171","A comma expression is not allowed in a computed property name."),extends_clause_already_seen:t(1172,e.DiagnosticCategory.Error,"extends_clause_already_seen_1172","'extends' clause already seen."),extends_clause_must_precede_implements_clause:t(1173,e.DiagnosticCategory.Error,"extends_clause_must_precede_implements_clause_1173","'extends' clause must precede 'implements' clause."),Classes_can_only_extend_a_single_class:t(1174,e.DiagnosticCategory.Error,"Classes_can_only_extend_a_single_class_1174","Classes can only extend a single class."),implements_clause_already_seen:t(1175,e.DiagnosticCategory.Error,"implements_clause_already_seen_1175","'implements' clause already seen."),Interface_declaration_cannot_have_implements_clause:t(1176,e.DiagnosticCategory.Error,"Interface_declaration_cannot_have_implements_clause_1176","Interface declaration cannot have 'implements' clause."),Binary_digit_expected:t(1177,e.DiagnosticCategory.Error,"Binary_digit_expected_1177","Binary digit expected."),Octal_digit_expected:t(1178,e.DiagnosticCategory.Error,"Octal_digit_expected_1178","Octal digit expected."),Unexpected_token_expected:t(1179,e.DiagnosticCategory.Error,"Unexpected_token_expected_1179","Unexpected token. '{' expected."),Property_destructuring_pattern_expected:t(1180,e.DiagnosticCategory.Error,"Property_destructuring_pattern_expected_1180","Property destructuring pattern expected."),Array_element_destructuring_pattern_expected:t(1181,e.DiagnosticCategory.Error,"Array_element_destructuring_pattern_expected_1181","Array element destructuring pattern expected."),A_destructuring_declaration_must_have_an_initializer:t(1182,e.DiagnosticCategory.Error,"A_destructuring_declaration_must_have_an_initializer_1182","A destructuring declaration must have an initializer."),An_implementation_cannot_be_declared_in_ambient_contexts:t(1183,e.DiagnosticCategory.Error,"An_implementation_cannot_be_declared_in_ambient_contexts_1183","An implementation cannot be declared in ambient contexts."),Modifiers_cannot_appear_here:t(1184,e.DiagnosticCategory.Error,"Modifiers_cannot_appear_here_1184","Modifiers cannot appear here."),Merge_conflict_marker_encountered:t(1185,e.DiagnosticCategory.Error,"Merge_conflict_marker_encountered_1185","Merge conflict marker encountered."),A_rest_element_cannot_have_an_initializer:t(1186,e.DiagnosticCategory.Error,"A_rest_element_cannot_have_an_initializer_1186","A rest element cannot have an initializer."),A_parameter_property_may_not_be_declared_using_a_binding_pattern:t(1187,e.DiagnosticCategory.Error,"A_parameter_property_may_not_be_declared_using_a_binding_pattern_1187","A parameter property may not be declared using a binding pattern."),Only_a_single_variable_declaration_is_allowed_in_a_for_of_statement:t(1188,e.DiagnosticCategory.Error,"Only_a_single_variable_declaration_is_allowed_in_a_for_of_statement_1188","Only a single variable declaration is allowed in a 'for...of' statement."),The_variable_declaration_of_a_for_in_statement_cannot_have_an_initializer:t(1189,e.DiagnosticCategory.Error,"The_variable_declaration_of_a_for_in_statement_cannot_have_an_initializer_1189","The variable declaration of a 'for...in' statement cannot have an initializer."),The_variable_declaration_of_a_for_of_statement_cannot_have_an_initializer:t(1190,e.DiagnosticCategory.Error,"The_variable_declaration_of_a_for_of_statement_cannot_have_an_initializer_1190","The variable declaration of a 'for...of' statement cannot have an initializer."),An_import_declaration_cannot_have_modifiers:t(1191,e.DiagnosticCategory.Error,"An_import_declaration_cannot_have_modifiers_1191","An import declaration cannot have modifiers."),Module_0_has_no_default_export:t(1192,e.DiagnosticCategory.Error,"Module_0_has_no_default_export_1192","Module '{0}' has no default export."),An_export_declaration_cannot_have_modifiers:t(1193,e.DiagnosticCategory.Error,"An_export_declaration_cannot_have_modifiers_1193","An export declaration cannot have modifiers."),Export_declarations_are_not_permitted_in_a_namespace:t(1194,e.DiagnosticCategory.Error,"Export_declarations_are_not_permitted_in_a_namespace_1194","Export declarations are not permitted in a namespace."),Catch_clause_variable_cannot_have_a_type_annotation:t(1196,e.DiagnosticCategory.Error,"Catch_clause_variable_cannot_have_a_type_annotation_1196","Catch clause variable cannot have a type annotation."),Catch_clause_variable_cannot_have_an_initializer:t(1197,e.DiagnosticCategory.Error,"Catch_clause_variable_cannot_have_an_initializer_1197","Catch clause variable cannot have an initializer."),An_extended_Unicode_escape_value_must_be_between_0x0_and_0x10FFFF_inclusive:t(1198,e.DiagnosticCategory.Error,"An_extended_Unicode_escape_value_must_be_between_0x0_and_0x10FFFF_inclusive_1198","An extended Unicode escape value must be between 0x0 and 0x10FFFF inclusive."),Unterminated_Unicode_escape_sequence:t(1199,e.DiagnosticCategory.Error,"Unterminated_Unicode_escape_sequence_1199","Unterminated Unicode escape sequence."),Line_terminator_not_permitted_before_arrow:t(1200,e.DiagnosticCategory.Error,"Line_terminator_not_permitted_before_arrow_1200","Line terminator not permitted before arrow."),Import_assignment_cannot_be_used_when_targeting_ECMAScript_modules_Consider_using_import_Asterisk_as_ns_from_mod_import_a_from_mod_import_d_from_mod_or_another_module_format_instead:t(1202,e.DiagnosticCategory.Error,"Import_assignment_cannot_be_used_when_targeting_ECMAScript_modules_Consider_using_import_Asterisk_as_1202","Import assignment cannot be used when targeting ECMAScript modules. Consider using 'import * as ns from \"mod\"', 'import {a} from \"mod\"', 'import d from \"mod\"', or another module format instead."),Export_assignment_cannot_be_used_when_targeting_ECMAScript_modules_Consider_using_export_default_or_another_module_format_instead:t(1203,e.DiagnosticCategory.Error,"Export_assignment_cannot_be_used_when_targeting_ECMAScript_modules_Consider_using_export_default_or__1203","Export assignment cannot be used when targeting ECMAScript modules. Consider using 'export default' or another module format instead."),Cannot_re_export_a_type_when_the_isolatedModules_flag_is_provided:t(1205,e.DiagnosticCategory.Error,"Cannot_re_export_a_type_when_the_isolatedModules_flag_is_provided_1205","Cannot re-export a type when the '--isolatedModules' flag is provided."),Decorators_are_not_valid_here:t(1206,e.DiagnosticCategory.Error,"Decorators_are_not_valid_here_1206","Decorators are not valid here."),Decorators_cannot_be_applied_to_multiple_get_Slashset_accessors_of_the_same_name:t(1207,e.DiagnosticCategory.Error,"Decorators_cannot_be_applied_to_multiple_get_Slashset_accessors_of_the_same_name_1207","Decorators cannot be applied to multiple get/set accessors of the same name."),Cannot_compile_namespaces_when_the_isolatedModules_flag_is_provided:t(1208,e.DiagnosticCategory.Error,"Cannot_compile_namespaces_when_the_isolatedModules_flag_is_provided_1208","Cannot compile namespaces when the '--isolatedModules' flag is provided."),Ambient_const_enums_are_not_allowed_when_the_isolatedModules_flag_is_provided:t(1209,e.DiagnosticCategory.Error,"Ambient_const_enums_are_not_allowed_when_the_isolatedModules_flag_is_provided_1209","Ambient const enums are not allowed when the '--isolatedModules' flag is provided."),Invalid_use_of_0_Class_definitions_are_automatically_in_strict_mode:t(1210,e.DiagnosticCategory.Error,"Invalid_use_of_0_Class_definitions_are_automatically_in_strict_mode_1210","Invalid use of '{0}'. Class definitions are automatically in strict mode."),A_class_declaration_without_the_default_modifier_must_have_a_name:t(1211,e.DiagnosticCategory.Error,"A_class_declaration_without_the_default_modifier_must_have_a_name_1211","A class declaration without the 'default' modifier must have a name."),Identifier_expected_0_is_a_reserved_word_in_strict_mode:t(1212,e.DiagnosticCategory.Error,"Identifier_expected_0_is_a_reserved_word_in_strict_mode_1212","Identifier expected. '{0}' is a reserved word in strict mode."),Identifier_expected_0_is_a_reserved_word_in_strict_mode_Class_definitions_are_automatically_in_strict_mode:t(1213,e.DiagnosticCategory.Error,"Identifier_expected_0_is_a_reserved_word_in_strict_mode_Class_definitions_are_automatically_in_stric_1213","Identifier expected. '{0}' is a reserved word in strict mode. Class definitions are automatically in strict mode."),Identifier_expected_0_is_a_reserved_word_in_strict_mode_Modules_are_automatically_in_strict_mode:t(1214,e.DiagnosticCategory.Error,"Identifier_expected_0_is_a_reserved_word_in_strict_mode_Modules_are_automatically_in_strict_mode_1214","Identifier expected. '{0}' is a reserved word in strict mode. Modules are automatically in strict mode."),Invalid_use_of_0_Modules_are_automatically_in_strict_mode:t(1215,e.DiagnosticCategory.Error,"Invalid_use_of_0_Modules_are_automatically_in_strict_mode_1215","Invalid use of '{0}'. Modules are automatically in strict mode."),Identifier_expected_esModule_is_reserved_as_an_exported_marker_when_transforming_ECMAScript_modules:t(1216,e.DiagnosticCategory.Error,"Identifier_expected_esModule_is_reserved_as_an_exported_marker_when_transforming_ECMAScript_modules_1216","Identifier expected. '__esModule' is reserved as an exported marker when transforming ECMAScript modules."),Export_assignment_is_not_supported_when_module_flag_is_system:t(1218,e.DiagnosticCategory.Error,"Export_assignment_is_not_supported_when_module_flag_is_system_1218","Export assignment is not supported when '--module' flag is 'system'."),Experimental_support_for_decorators_is_a_feature_that_is_subject_to_change_in_a_future_release_Set_the_experimentalDecorators_option_to_remove_this_warning:t(1219,e.DiagnosticCategory.Error,"Experimental_support_for_decorators_is_a_feature_that_is_subject_to_change_in_a_future_release_Set_t_1219","Experimental support for decorators is a feature that is subject to change in a future release. Set the 'experimentalDecorators' option to remove this warning."),Generators_are_only_available_when_targeting_ECMAScript_2015_or_higher:t(1220,e.DiagnosticCategory.Error,"Generators_are_only_available_when_targeting_ECMAScript_2015_or_higher_1220","Generators are only available when targeting ECMAScript 2015 or higher."),Generators_are_not_allowed_in_an_ambient_context:t(1221,e.DiagnosticCategory.Error,"Generators_are_not_allowed_in_an_ambient_context_1221","Generators are not allowed in an ambient context."),An_overload_signature_cannot_be_declared_as_a_generator:t(1222,e.DiagnosticCategory.Error,"An_overload_signature_cannot_be_declared_as_a_generator_1222","An overload signature cannot be declared as a generator."),_0_tag_already_specified:t(1223,e.DiagnosticCategory.Error,"_0_tag_already_specified_1223","'{0}' tag already specified."),Signature_0_must_be_a_type_predicate:t(1224,e.DiagnosticCategory.Error,"Signature_0_must_be_a_type_predicate_1224","Signature '{0}' must be a type predicate."),Cannot_find_parameter_0:t(1225,e.DiagnosticCategory.Error,"Cannot_find_parameter_0_1225","Cannot find parameter '{0}'."),Type_predicate_0_is_not_assignable_to_1:t(1226,e.DiagnosticCategory.Error,"Type_predicate_0_is_not_assignable_to_1_1226","Type predicate '{0}' is not assignable to '{1}'."),Parameter_0_is_not_in_the_same_position_as_parameter_1:t(1227,e.DiagnosticCategory.Error,"Parameter_0_is_not_in_the_same_position_as_parameter_1_1227","Parameter '{0}' is not in the same position as parameter '{1}'."),A_type_predicate_is_only_allowed_in_return_type_position_for_functions_and_methods:t(1228,e.DiagnosticCategory.Error,"A_type_predicate_is_only_allowed_in_return_type_position_for_functions_and_methods_1228","A type predicate is only allowed in return type position for functions and methods."),A_type_predicate_cannot_reference_a_rest_parameter:t(1229,e.DiagnosticCategory.Error,"A_type_predicate_cannot_reference_a_rest_parameter_1229","A type predicate cannot reference a rest parameter."),A_type_predicate_cannot_reference_element_0_in_a_binding_pattern:t(1230,e.DiagnosticCategory.Error,"A_type_predicate_cannot_reference_element_0_in_a_binding_pattern_1230","A type predicate cannot reference element '{0}' in a binding pattern."),An_export_assignment_can_only_be_used_in_a_module:t(1231,e.DiagnosticCategory.Error,"An_export_assignment_can_only_be_used_in_a_module_1231","An export assignment can only be used in a module."),An_import_declaration_can_only_be_used_in_a_namespace_or_module:t(1232,e.DiagnosticCategory.Error,"An_import_declaration_can_only_be_used_in_a_namespace_or_module_1232","An import declaration can only be used in a namespace or module."),An_export_declaration_can_only_be_used_in_a_module:t(1233,e.DiagnosticCategory.Error,"An_export_declaration_can_only_be_used_in_a_module_1233","An export declaration can only be used in a module."),An_ambient_module_declaration_is_only_allowed_at_the_top_level_in_a_file:t(1234,e.DiagnosticCategory.Error,"An_ambient_module_declaration_is_only_allowed_at_the_top_level_in_a_file_1234","An ambient module declaration is only allowed at the top level in a file."),A_namespace_declaration_is_only_allowed_in_a_namespace_or_module:t(1235,e.DiagnosticCategory.Error,"A_namespace_declaration_is_only_allowed_in_a_namespace_or_module_1235","A namespace declaration is only allowed in a namespace or module."),The_return_type_of_a_property_decorator_function_must_be_either_void_or_any:t(1236,e.DiagnosticCategory.Error,"The_return_type_of_a_property_decorator_function_must_be_either_void_or_any_1236","The return type of a property decorator function must be either 'void' or 'any'."),The_return_type_of_a_parameter_decorator_function_must_be_either_void_or_any:t(1237,e.DiagnosticCategory.Error,"The_return_type_of_a_parameter_decorator_function_must_be_either_void_or_any_1237","The return type of a parameter decorator function must be either 'void' or 'any'."),Unable_to_resolve_signature_of_class_decorator_when_called_as_an_expression:t(1238,e.DiagnosticCategory.Error,"Unable_to_resolve_signature_of_class_decorator_when_called_as_an_expression_1238","Unable to resolve signature of class decorator when called as an expression."),Unable_to_resolve_signature_of_parameter_decorator_when_called_as_an_expression:t(1239,e.DiagnosticCategory.Error,"Unable_to_resolve_signature_of_parameter_decorator_when_called_as_an_expression_1239","Unable to resolve signature of parameter decorator when called as an expression."),Unable_to_resolve_signature_of_property_decorator_when_called_as_an_expression:t(1240,e.DiagnosticCategory.Error,"Unable_to_resolve_signature_of_property_decorator_when_called_as_an_expression_1240","Unable to resolve signature of property decorator when called as an expression."),Unable_to_resolve_signature_of_method_decorator_when_called_as_an_expression:t(1241,e.DiagnosticCategory.Error,"Unable_to_resolve_signature_of_method_decorator_when_called_as_an_expression_1241","Unable to resolve signature of method decorator when called as an expression."),abstract_modifier_can_only_appear_on_a_class_method_or_property_declaration:t(1242,e.DiagnosticCategory.Error,"abstract_modifier_can_only_appear_on_a_class_method_or_property_declaration_1242","'abstract' modifier can only appear on a class, method, or property declaration."),_0_modifier_cannot_be_used_with_1_modifier:t(1243,e.DiagnosticCategory.Error,"_0_modifier_cannot_be_used_with_1_modifier_1243","'{0}' modifier cannot be used with '{1}' modifier."),Abstract_methods_can_only_appear_within_an_abstract_class:t(1244,e.DiagnosticCategory.Error,"Abstract_methods_can_only_appear_within_an_abstract_class_1244","Abstract methods can only appear within an abstract class."),Method_0_cannot_have_an_implementation_because_it_is_marked_abstract:t(1245,e.DiagnosticCategory.Error,"Method_0_cannot_have_an_implementation_because_it_is_marked_abstract_1245","Method '{0}' cannot have an implementation because it is marked abstract."),An_interface_property_cannot_have_an_initializer:t(1246,e.DiagnosticCategory.Error,"An_interface_property_cannot_have_an_initializer_1246","An interface property cannot have an initializer."),A_type_literal_property_cannot_have_an_initializer:t(1247,e.DiagnosticCategory.Error,"A_type_literal_property_cannot_have_an_initializer_1247","A type literal property cannot have an initializer."),A_class_member_cannot_have_the_0_keyword:t(1248,e.DiagnosticCategory.Error,"A_class_member_cannot_have_the_0_keyword_1248","A class member cannot have the '{0}' keyword."),A_decorator_can_only_decorate_a_method_implementation_not_an_overload:t(1249,e.DiagnosticCategory.Error,"A_decorator_can_only_decorate_a_method_implementation_not_an_overload_1249","A decorator can only decorate a method implementation, not an overload."),Function_declarations_are_not_allowed_inside_blocks_in_strict_mode_when_targeting_ES3_or_ES5:t(1250,e.DiagnosticCategory.Error,"Function_declarations_are_not_allowed_inside_blocks_in_strict_mode_when_targeting_ES3_or_ES5_1250","Function declarations are not allowed inside blocks in strict mode when targeting 'ES3' or 'ES5'."),Function_declarations_are_not_allowed_inside_blocks_in_strict_mode_when_targeting_ES3_or_ES5_Class_definitions_are_automatically_in_strict_mode:t(1251,e.DiagnosticCategory.Error,"Function_declarations_are_not_allowed_inside_blocks_in_strict_mode_when_targeting_ES3_or_ES5_Class_d_1251","Function declarations are not allowed inside blocks in strict mode when targeting 'ES3' or 'ES5'. Class definitions are automatically in strict mode."),Function_declarations_are_not_allowed_inside_blocks_in_strict_mode_when_targeting_ES3_or_ES5_Modules_are_automatically_in_strict_mode:t(1252,e.DiagnosticCategory.Error,"Function_declarations_are_not_allowed_inside_blocks_in_strict_mode_when_targeting_ES3_or_ES5_Modules_1252","Function declarations are not allowed inside blocks in strict mode when targeting 'ES3' or 'ES5'. Modules are automatically in strict mode."),_0_tag_cannot_be_used_independently_as_a_top_level_JSDoc_tag:t(1253,e.DiagnosticCategory.Error,"_0_tag_cannot_be_used_independently_as_a_top_level_JSDoc_tag_1253","'{0}' tag cannot be used independently as a top level JSDoc tag."),A_const_initializer_in_an_ambient_context_must_be_a_string_or_numeric_literal:t(1254,e.DiagnosticCategory.Error,"A_const_initializer_in_an_ambient_context_must_be_a_string_or_numeric_literal_1254","A 'const' initializer in an ambient context must be a string or numeric literal."),A_definite_assignment_assertion_is_not_permitted_in_this_context:t(1255,e.DiagnosticCategory.Error,"A_definite_assignment_assertion_is_not_permitted_in_this_context_1255","A definite assignment assertion '!' is not permitted in this context."),with_statements_are_not_allowed_in_an_async_function_block:t(1300,e.DiagnosticCategory.Error,"with_statements_are_not_allowed_in_an_async_function_block_1300","'with' statements are not allowed in an async function block."),await_expression_is_only_allowed_within_an_async_function:t(1308,e.DiagnosticCategory.Error,"await_expression_is_only_allowed_within_an_async_function_1308","'await' expression is only allowed within an async function."),can_only_be_used_in_an_object_literal_property_inside_a_destructuring_assignment:t(1312,e.DiagnosticCategory.Error,"can_only_be_used_in_an_object_literal_property_inside_a_destructuring_assignment_1312","'=' can only be used in an object literal property inside a destructuring assignment."),The_body_of_an_if_statement_cannot_be_the_empty_statement:t(1313,e.DiagnosticCategory.Error,"The_body_of_an_if_statement_cannot_be_the_empty_statement_1313","The body of an 'if' statement cannot be the empty statement."),Global_module_exports_may_only_appear_in_module_files:t(1314,e.DiagnosticCategory.Error,"Global_module_exports_may_only_appear_in_module_files_1314","Global module exports may only appear in module files."),Global_module_exports_may_only_appear_in_declaration_files:t(1315,e.DiagnosticCategory.Error,"Global_module_exports_may_only_appear_in_declaration_files_1315","Global module exports may only appear in declaration files."),Global_module_exports_may_only_appear_at_top_level:t(1316,e.DiagnosticCategory.Error,"Global_module_exports_may_only_appear_at_top_level_1316","Global module exports may only appear at top level."),A_parameter_property_cannot_be_declared_using_a_rest_parameter:t(1317,e.DiagnosticCategory.Error,"A_parameter_property_cannot_be_declared_using_a_rest_parameter_1317","A parameter property cannot be declared using a rest parameter."),An_abstract_accessor_cannot_have_an_implementation:t(1318,e.DiagnosticCategory.Error,"An_abstract_accessor_cannot_have_an_implementation_1318","An abstract accessor cannot have an implementation."),A_default_export_can_only_be_used_in_an_ECMAScript_style_module:t(1319,e.DiagnosticCategory.Error,"A_default_export_can_only_be_used_in_an_ECMAScript_style_module_1319","A default export can only be used in an ECMAScript-style module."),Type_of_await_operand_must_either_be_a_valid_promise_or_must_not_contain_a_callable_then_member:t(1320,e.DiagnosticCategory.Error,"Type_of_await_operand_must_either_be_a_valid_promise_or_must_not_contain_a_callable_then_member_1320","Type of 'await' operand must either be a valid promise or must not contain a callable 'then' member."),Type_of_yield_operand_in_an_async_generator_must_either_be_a_valid_promise_or_must_not_contain_a_callable_then_member:t(1321,e.DiagnosticCategory.Error,"Type_of_yield_operand_in_an_async_generator_must_either_be_a_valid_promise_or_must_not_contain_a_cal_1321","Type of 'yield' operand in an async generator must either be a valid promise or must not contain a callable 'then' member."),Type_of_iterated_elements_of_a_yield_Asterisk_operand_must_either_be_a_valid_promise_or_must_not_contain_a_callable_then_member:t(1322,e.DiagnosticCategory.Error,"Type_of_iterated_elements_of_a_yield_Asterisk_operand_must_either_be_a_valid_promise_or_must_not_con_1322","Type of iterated elements of a 'yield*' operand must either be a valid promise or must not contain a callable 'then' member."),Dynamic_import_cannot_be_used_when_targeting_ECMAScript_2015_modules:t(1323,e.DiagnosticCategory.Error,"Dynamic_import_cannot_be_used_when_targeting_ECMAScript_2015_modules_1323","Dynamic import cannot be used when targeting ECMAScript 2015 modules."),Dynamic_import_must_have_one_specifier_as_an_argument:t(1324,e.DiagnosticCategory.Error,"Dynamic_import_must_have_one_specifier_as_an_argument_1324","Dynamic import must have one specifier as an argument."),Specifier_of_dynamic_import_cannot_be_spread_element:t(1325,e.DiagnosticCategory.Error,"Specifier_of_dynamic_import_cannot_be_spread_element_1325","Specifier of dynamic import cannot be spread element."),Dynamic_import_cannot_have_type_arguments:t(1326,e.DiagnosticCategory.Error,"Dynamic_import_cannot_have_type_arguments_1326","Dynamic import cannot have type arguments"),String_literal_with_double_quotes_expected:t(1327,e.DiagnosticCategory.Error,"String_literal_with_double_quotes_expected_1327","String literal with double quotes expected."),Property_value_can_only_be_string_literal_numeric_literal_true_false_null_object_literal_or_array_literal:t(1328,e.DiagnosticCategory.Error,"Property_value_can_only_be_string_literal_numeric_literal_true_false_null_object_literal_or_array_li_1328","Property value can only be string literal, numeric literal, 'true', 'false', 'null', object literal or array literal."),_0_accepts_too_few_arguments_to_be_used_as_a_decorator_here_Did_you_mean_to_call_it_first_and_write_0:t(1329,e.DiagnosticCategory.Error,"_0_accepts_too_few_arguments_to_be_used_as_a_decorator_here_Did_you_mean_to_call_it_first_and_write__1329","'{0}' accepts too few arguments to be used as a decorator here. Did you mean to call it first and write '@{0}()'?"),A_property_of_an_interface_or_type_literal_whose_type_is_a_unique_symbol_type_must_be_readonly:t(1330,e.DiagnosticCategory.Error,"A_property_of_an_interface_or_type_literal_whose_type_is_a_unique_symbol_type_must_be_readonly_1330","A property of an interface or type literal whose type is a 'unique symbol' type must be 'readonly'."),A_property_of_a_class_whose_type_is_a_unique_symbol_type_must_be_both_static_and_readonly:t(1331,e.DiagnosticCategory.Error,"A_property_of_a_class_whose_type_is_a_unique_symbol_type_must_be_both_static_and_readonly_1331","A property of a class whose type is a 'unique symbol' type must be both 'static' and 'readonly'."),A_variable_whose_type_is_a_unique_symbol_type_must_be_const:t(1332,e.DiagnosticCategory.Error,"A_variable_whose_type_is_a_unique_symbol_type_must_be_const_1332","A variable whose type is a 'unique symbol' type must be 'const'."),unique_symbol_types_may_not_be_used_on_a_variable_declaration_with_a_binding_name:t(1333,e.DiagnosticCategory.Error,"unique_symbol_types_may_not_be_used_on_a_variable_declaration_with_a_binding_name_1333","'unique symbol' types may not be used on a variable declaration with a binding name."),unique_symbol_types_are_only_allowed_on_variables_in_a_variable_statement:t(1334,e.DiagnosticCategory.Error,"unique_symbol_types_are_only_allowed_on_variables_in_a_variable_statement_1334","'unique symbol' types are only allowed on variables in a variable statement."),unique_symbol_types_are_not_allowed_here:t(1335,e.DiagnosticCategory.Error,"unique_symbol_types_are_not_allowed_here_1335","'unique symbol' types are not allowed here."),An_index_signature_parameter_type_cannot_be_a_type_alias_Consider_writing_0_Colon_1_Colon_2_instead:t(1336,e.DiagnosticCategory.Error,"An_index_signature_parameter_type_cannot_be_a_type_alias_Consider_writing_0_Colon_1_Colon_2_instead_1336","An index signature parameter type cannot be a type alias. Consider writing '[{0}: {1}]: {2}' instead."),An_index_signature_parameter_type_cannot_be_a_union_type_Consider_using_a_mapped_object_type_instead:t(1337,e.DiagnosticCategory.Error,"An_index_signature_parameter_type_cannot_be_a_union_type_Consider_using_a_mapped_object_type_instead_1337","An index signature parameter type cannot be a union type. Consider using a mapped object type instead."),infer_declarations_are_only_permitted_in_the_extends_clause_of_a_conditional_type:t(1338,e.DiagnosticCategory.Error,"infer_declarations_are_only_permitted_in_the_extends_clause_of_a_conditional_type_1338","'infer' declarations are only permitted in the 'extends' clause of a conditional type."),Duplicate_identifier_0:t(2300,e.DiagnosticCategory.Error,"Duplicate_identifier_0_2300","Duplicate identifier '{0}'."),Initializer_of_instance_member_variable_0_cannot_reference_identifier_1_declared_in_the_constructor:t(2301,e.DiagnosticCategory.Error,"Initializer_of_instance_member_variable_0_cannot_reference_identifier_1_declared_in_the_constructor_2301","Initializer of instance member variable '{0}' cannot reference identifier '{1}' declared in the constructor."),Static_members_cannot_reference_class_type_parameters:t(2302,e.DiagnosticCategory.Error,"Static_members_cannot_reference_class_type_parameters_2302","Static members cannot reference class type parameters."),Circular_definition_of_import_alias_0:t(2303,e.DiagnosticCategory.Error,"Circular_definition_of_import_alias_0_2303","Circular definition of import alias '{0}'."),Cannot_find_name_0:t(2304,e.DiagnosticCategory.Error,"Cannot_find_name_0_2304","Cannot find name '{0}'."),Module_0_has_no_exported_member_1:t(2305,e.DiagnosticCategory.Error,"Module_0_has_no_exported_member_1_2305","Module '{0}' has no exported member '{1}'."),File_0_is_not_a_module:t(2306,e.DiagnosticCategory.Error,"File_0_is_not_a_module_2306","File '{0}' is not a module."),Cannot_find_module_0:t(2307,e.DiagnosticCategory.Error,"Cannot_find_module_0_2307","Cannot find module '{0}'."),Module_0_has_already_exported_a_member_named_1_Consider_explicitly_re_exporting_to_resolve_the_ambiguity:t(2308,e.DiagnosticCategory.Error,"Module_0_has_already_exported_a_member_named_1_Consider_explicitly_re_exporting_to_resolve_the_ambig_2308","Module {0} has already exported a member named '{1}'. Consider explicitly re-exporting to resolve the ambiguity."),An_export_assignment_cannot_be_used_in_a_module_with_other_exported_elements:t(2309,e.DiagnosticCategory.Error,"An_export_assignment_cannot_be_used_in_a_module_with_other_exported_elements_2309","An export assignment cannot be used in a module with other exported elements."),Type_0_recursively_references_itself_as_a_base_type:t(2310,e.DiagnosticCategory.Error,"Type_0_recursively_references_itself_as_a_base_type_2310","Type '{0}' recursively references itself as a base type."),A_class_may_only_extend_another_class:t(2311,e.DiagnosticCategory.Error,"A_class_may_only_extend_another_class_2311","A class may only extend another class."),An_interface_may_only_extend_a_class_or_another_interface:t(2312,e.DiagnosticCategory.Error,"An_interface_may_only_extend_a_class_or_another_interface_2312","An interface may only extend a class or another interface."),Type_parameter_0_has_a_circular_constraint:t(2313,e.DiagnosticCategory.Error,"Type_parameter_0_has_a_circular_constraint_2313","Type parameter '{0}' has a circular constraint."),Generic_type_0_requires_1_type_argument_s:t(2314,e.DiagnosticCategory.Error,"Generic_type_0_requires_1_type_argument_s_2314","Generic type '{0}' requires {1} type argument(s)."),Type_0_is_not_generic:t(2315,e.DiagnosticCategory.Error,"Type_0_is_not_generic_2315","Type '{0}' is not generic."),Global_type_0_must_be_a_class_or_interface_type:t(2316,e.DiagnosticCategory.Error,"Global_type_0_must_be_a_class_or_interface_type_2316","Global type '{0}' must be a class or interface type."),Global_type_0_must_have_1_type_parameter_s:t(2317,e.DiagnosticCategory.Error,"Global_type_0_must_have_1_type_parameter_s_2317","Global type '{0}' must have {1} type parameter(s)."),Cannot_find_global_type_0:t(2318,e.DiagnosticCategory.Error,"Cannot_find_global_type_0_2318","Cannot find global type '{0}'."),Named_property_0_of_types_1_and_2_are_not_identical:t(2319,e.DiagnosticCategory.Error,"Named_property_0_of_types_1_and_2_are_not_identical_2319","Named property '{0}' of types '{1}' and '{2}' are not identical."),Interface_0_cannot_simultaneously_extend_types_1_and_2:t(2320,e.DiagnosticCategory.Error,"Interface_0_cannot_simultaneously_extend_types_1_and_2_2320","Interface '{0}' cannot simultaneously extend types '{1}' and '{2}'."),Excessive_stack_depth_comparing_types_0_and_1:t(2321,e.DiagnosticCategory.Error,"Excessive_stack_depth_comparing_types_0_and_1_2321","Excessive stack depth comparing types '{0}' and '{1}'."),Type_0_is_not_assignable_to_type_1:t(2322,e.DiagnosticCategory.Error,"Type_0_is_not_assignable_to_type_1_2322","Type '{0}' is not assignable to type '{1}'."),Cannot_redeclare_exported_variable_0:t(2323,e.DiagnosticCategory.Error,"Cannot_redeclare_exported_variable_0_2323","Cannot redeclare exported variable '{0}'."),Property_0_is_missing_in_type_1:t(2324,e.DiagnosticCategory.Error,"Property_0_is_missing_in_type_1_2324","Property '{0}' is missing in type '{1}'."),Property_0_is_private_in_type_1_but_not_in_type_2:t(2325,e.DiagnosticCategory.Error,"Property_0_is_private_in_type_1_but_not_in_type_2_2325","Property '{0}' is private in type '{1}' but not in type '{2}'."),Types_of_property_0_are_incompatible:t(2326,e.DiagnosticCategory.Error,"Types_of_property_0_are_incompatible_2326","Types of property '{0}' are incompatible."),Property_0_is_optional_in_type_1_but_required_in_type_2:t(2327,e.DiagnosticCategory.Error,"Property_0_is_optional_in_type_1_but_required_in_type_2_2327","Property '{0}' is optional in type '{1}' but required in type '{2}'."),Types_of_parameters_0_and_1_are_incompatible:t(2328,e.DiagnosticCategory.Error,"Types_of_parameters_0_and_1_are_incompatible_2328","Types of parameters '{0}' and '{1}' are incompatible."),Index_signature_is_missing_in_type_0:t(2329,e.DiagnosticCategory.Error,"Index_signature_is_missing_in_type_0_2329","Index signature is missing in type '{0}'."),Index_signatures_are_incompatible:t(2330,e.DiagnosticCategory.Error,"Index_signatures_are_incompatible_2330","Index signatures are incompatible."),this_cannot_be_referenced_in_a_module_or_namespace_body:t(2331,e.DiagnosticCategory.Error,"this_cannot_be_referenced_in_a_module_or_namespace_body_2331","'this' cannot be referenced in a module or namespace body."),this_cannot_be_referenced_in_current_location:t(2332,e.DiagnosticCategory.Error,"this_cannot_be_referenced_in_current_location_2332","'this' cannot be referenced in current location."),this_cannot_be_referenced_in_constructor_arguments:t(2333,e.DiagnosticCategory.Error,"this_cannot_be_referenced_in_constructor_arguments_2333","'this' cannot be referenced in constructor arguments."),this_cannot_be_referenced_in_a_static_property_initializer:t(2334,e.DiagnosticCategory.Error,"this_cannot_be_referenced_in_a_static_property_initializer_2334","'this' cannot be referenced in a static property initializer."),super_can_only_be_referenced_in_a_derived_class:t(2335,e.DiagnosticCategory.Error,"super_can_only_be_referenced_in_a_derived_class_2335","'super' can only be referenced in a derived class."),super_cannot_be_referenced_in_constructor_arguments:t(2336,e.DiagnosticCategory.Error,"super_cannot_be_referenced_in_constructor_arguments_2336","'super' cannot be referenced in constructor arguments."),Super_calls_are_not_permitted_outside_constructors_or_in_nested_functions_inside_constructors:t(2337,e.DiagnosticCategory.Error,"Super_calls_are_not_permitted_outside_constructors_or_in_nested_functions_inside_constructors_2337","Super calls are not permitted outside constructors or in nested functions inside constructors."),super_property_access_is_permitted_only_in_a_constructor_member_function_or_member_accessor_of_a_derived_class:t(2338,e.DiagnosticCategory.Error,"super_property_access_is_permitted_only_in_a_constructor_member_function_or_member_accessor_of_a_der_2338","'super' property access is permitted only in a constructor, member function, or member accessor of a derived class."),Property_0_does_not_exist_on_type_1:t(2339,e.DiagnosticCategory.Error,"Property_0_does_not_exist_on_type_1_2339","Property '{0}' does not exist on type '{1}'."),Only_public_and_protected_methods_of_the_base_class_are_accessible_via_the_super_keyword:t(2340,e.DiagnosticCategory.Error,"Only_public_and_protected_methods_of_the_base_class_are_accessible_via_the_super_keyword_2340","Only public and protected methods of the base class are accessible via the 'super' keyword."),Property_0_is_private_and_only_accessible_within_class_1:t(2341,e.DiagnosticCategory.Error,"Property_0_is_private_and_only_accessible_within_class_1_2341","Property '{0}' is private and only accessible within class '{1}'."),An_index_expression_argument_must_be_of_type_string_number_symbol_or_any:t(2342,e.DiagnosticCategory.Error,"An_index_expression_argument_must_be_of_type_string_number_symbol_or_any_2342","An index expression argument must be of type 'string', 'number', 'symbol', or 'any'."),This_syntax_requires_an_imported_helper_named_1_but_module_0_has_no_exported_member_1:t(2343,e.DiagnosticCategory.Error,"This_syntax_requires_an_imported_helper_named_1_but_module_0_has_no_exported_member_1_2343","This syntax requires an imported helper named '{1}', but module '{0}' has no exported member '{1}'."),Type_0_does_not_satisfy_the_constraint_1:t(2344,e.DiagnosticCategory.Error,"Type_0_does_not_satisfy_the_constraint_1_2344","Type '{0}' does not satisfy the constraint '{1}'."),Argument_of_type_0_is_not_assignable_to_parameter_of_type_1:t(2345,e.DiagnosticCategory.Error,"Argument_of_type_0_is_not_assignable_to_parameter_of_type_1_2345","Argument of type '{0}' is not assignable to parameter of type '{1}'."),Call_target_does_not_contain_any_signatures:t(2346,e.DiagnosticCategory.Error,"Call_target_does_not_contain_any_signatures_2346","Call target does not contain any signatures."),Untyped_function_calls_may_not_accept_type_arguments:t(2347,e.DiagnosticCategory.Error,"Untyped_function_calls_may_not_accept_type_arguments_2347","Untyped function calls may not accept type arguments."),Value_of_type_0_is_not_callable_Did_you_mean_to_include_new:t(2348,e.DiagnosticCategory.Error,"Value_of_type_0_is_not_callable_Did_you_mean_to_include_new_2348","Value of type '{0}' is not callable. Did you mean to include 'new'?"),Cannot_invoke_an_expression_whose_type_lacks_a_call_signature_Type_0_has_no_compatible_call_signatures:t(2349,e.DiagnosticCategory.Error,"Cannot_invoke_an_expression_whose_type_lacks_a_call_signature_Type_0_has_no_compatible_call_signatur_2349","Cannot invoke an expression whose type lacks a call signature. Type '{0}' has no compatible call signatures."),Only_a_void_function_can_be_called_with_the_new_keyword:t(2350,e.DiagnosticCategory.Error,"Only_a_void_function_can_be_called_with_the_new_keyword_2350","Only a void function can be called with the 'new' keyword."),Cannot_use_new_with_an_expression_whose_type_lacks_a_call_or_construct_signature:t(2351,e.DiagnosticCategory.Error,"Cannot_use_new_with_an_expression_whose_type_lacks_a_call_or_construct_signature_2351","Cannot use 'new' with an expression whose type lacks a call or construct signature."),Type_0_cannot_be_converted_to_type_1:t(2352,e.DiagnosticCategory.Error,"Type_0_cannot_be_converted_to_type_1_2352","Type '{0}' cannot be converted to type '{1}'."),Object_literal_may_only_specify_known_properties_and_0_does_not_exist_in_type_1:t(2353,e.DiagnosticCategory.Error,"Object_literal_may_only_specify_known_properties_and_0_does_not_exist_in_type_1_2353","Object literal may only specify known properties, and '{0}' does not exist in type '{1}'."),This_syntax_requires_an_imported_helper_but_module_0_cannot_be_found:t(2354,e.DiagnosticCategory.Error,"This_syntax_requires_an_imported_helper_but_module_0_cannot_be_found_2354","This syntax requires an imported helper but module '{0}' cannot be found."),A_function_whose_declared_type_is_neither_void_nor_any_must_return_a_value:t(2355,e.DiagnosticCategory.Error,"A_function_whose_declared_type_is_neither_void_nor_any_must_return_a_value_2355","A function whose declared type is neither 'void' nor 'any' must return a value."),An_arithmetic_operand_must_be_of_type_any_number_or_an_enum_type:t(2356,e.DiagnosticCategory.Error,"An_arithmetic_operand_must_be_of_type_any_number_or_an_enum_type_2356","An arithmetic operand must be of type 'any', 'number' or an enum type."),The_operand_of_an_increment_or_decrement_operator_must_be_a_variable_or_a_property_access:t(2357,e.DiagnosticCategory.Error,"The_operand_of_an_increment_or_decrement_operator_must_be_a_variable_or_a_property_access_2357","The operand of an increment or decrement operator must be a variable or a property access."),The_left_hand_side_of_an_instanceof_expression_must_be_of_type_any_an_object_type_or_a_type_parameter:t(2358,e.DiagnosticCategory.Error,"The_left_hand_side_of_an_instanceof_expression_must_be_of_type_any_an_object_type_or_a_type_paramete_2358","The left-hand side of an 'instanceof' expression must be of type 'any', an object type or a type parameter."),The_right_hand_side_of_an_instanceof_expression_must_be_of_type_any_or_of_a_type_assignable_to_the_Function_interface_type:t(2359,e.DiagnosticCategory.Error,"The_right_hand_side_of_an_instanceof_expression_must_be_of_type_any_or_of_a_type_assignable_to_the_F_2359","The right-hand side of an 'instanceof' expression must be of type 'any' or of a type assignable to the 'Function' interface type."),The_left_hand_side_of_an_in_expression_must_be_of_type_any_string_number_or_symbol:t(2360,e.DiagnosticCategory.Error,"The_left_hand_side_of_an_in_expression_must_be_of_type_any_string_number_or_symbol_2360","The left-hand side of an 'in' expression must be of type 'any', 'string', 'number', or 'symbol'."),The_right_hand_side_of_an_in_expression_must_be_of_type_any_an_object_type_or_a_type_parameter:t(2361,e.DiagnosticCategory.Error,"The_right_hand_side_of_an_in_expression_must_be_of_type_any_an_object_type_or_a_type_parameter_2361","The right-hand side of an 'in' expression must be of type 'any', an object type or a type parameter."),The_left_hand_side_of_an_arithmetic_operation_must_be_of_type_any_number_or_an_enum_type:t(2362,e.DiagnosticCategory.Error,"The_left_hand_side_of_an_arithmetic_operation_must_be_of_type_any_number_or_an_enum_type_2362","The left-hand side of an arithmetic operation must be of type 'any', 'number' or an enum type."),The_right_hand_side_of_an_arithmetic_operation_must_be_of_type_any_number_or_an_enum_type:t(2363,e.DiagnosticCategory.Error,"The_right_hand_side_of_an_arithmetic_operation_must_be_of_type_any_number_or_an_enum_type_2363","The right-hand side of an arithmetic operation must be of type 'any', 'number' or an enum type."),The_left_hand_side_of_an_assignment_expression_must_be_a_variable_or_a_property_access:t(2364,e.DiagnosticCategory.Error,"The_left_hand_side_of_an_assignment_expression_must_be_a_variable_or_a_property_access_2364","The left-hand side of an assignment expression must be a variable or a property access."),Operator_0_cannot_be_applied_to_types_1_and_2:t(2365,e.DiagnosticCategory.Error,"Operator_0_cannot_be_applied_to_types_1_and_2_2365","Operator '{0}' cannot be applied to types '{1}' and '{2}'."),Function_lacks_ending_return_statement_and_return_type_does_not_include_undefined:t(2366,e.DiagnosticCategory.Error,"Function_lacks_ending_return_statement_and_return_type_does_not_include_undefined_2366","Function lacks ending return statement and return type does not include 'undefined'."),Type_parameter_name_cannot_be_0:t(2368,e.DiagnosticCategory.Error,"Type_parameter_name_cannot_be_0_2368","Type parameter name cannot be '{0}'."),A_parameter_property_is_only_allowed_in_a_constructor_implementation:t(2369,e.DiagnosticCategory.Error,"A_parameter_property_is_only_allowed_in_a_constructor_implementation_2369","A parameter property is only allowed in a constructor implementation."),A_rest_parameter_must_be_of_an_array_type:t(2370,e.DiagnosticCategory.Error,"A_rest_parameter_must_be_of_an_array_type_2370","A rest parameter must be of an array type."),A_parameter_initializer_is_only_allowed_in_a_function_or_constructor_implementation:t(2371,e.DiagnosticCategory.Error,"A_parameter_initializer_is_only_allowed_in_a_function_or_constructor_implementation_2371","A parameter initializer is only allowed in a function or constructor implementation."),Parameter_0_cannot_be_referenced_in_its_initializer:t(2372,e.DiagnosticCategory.Error,"Parameter_0_cannot_be_referenced_in_its_initializer_2372","Parameter '{0}' cannot be referenced in its initializer."),Initializer_of_parameter_0_cannot_reference_identifier_1_declared_after_it:t(2373,e.DiagnosticCategory.Error,"Initializer_of_parameter_0_cannot_reference_identifier_1_declared_after_it_2373","Initializer of parameter '{0}' cannot reference identifier '{1}' declared after it."),Duplicate_string_index_signature:t(2374,e.DiagnosticCategory.Error,"Duplicate_string_index_signature_2374","Duplicate string index signature."),Duplicate_number_index_signature:t(2375,e.DiagnosticCategory.Error,"Duplicate_number_index_signature_2375","Duplicate number index signature."),A_super_call_must_be_the_first_statement_in_the_constructor_when_a_class_contains_initialized_properties_or_has_parameter_properties:t(2376,e.DiagnosticCategory.Error,"A_super_call_must_be_the_first_statement_in_the_constructor_when_a_class_contains_initialized_proper_2376","A 'super' call must be the first statement in the constructor when a class contains initialized properties or has parameter properties."),Constructors_for_derived_classes_must_contain_a_super_call:t(2377,e.DiagnosticCategory.Error,"Constructors_for_derived_classes_must_contain_a_super_call_2377","Constructors for derived classes must contain a 'super' call."),A_get_accessor_must_return_a_value:t(2378,e.DiagnosticCategory.Error,"A_get_accessor_must_return_a_value_2378","A 'get' accessor must return a value."),Getter_and_setter_accessors_do_not_agree_in_visibility:t(2379,e.DiagnosticCategory.Error,"Getter_and_setter_accessors_do_not_agree_in_visibility_2379","Getter and setter accessors do not agree in visibility."),get_and_set_accessor_must_have_the_same_type:t(2380,e.DiagnosticCategory.Error,"get_and_set_accessor_must_have_the_same_type_2380","'get' and 'set' accessor must have the same type."),A_signature_with_an_implementation_cannot_use_a_string_literal_type:t(2381,e.DiagnosticCategory.Error,"A_signature_with_an_implementation_cannot_use_a_string_literal_type_2381","A signature with an implementation cannot use a string literal type."),Specialized_overload_signature_is_not_assignable_to_any_non_specialized_signature:t(2382,e.DiagnosticCategory.Error,"Specialized_overload_signature_is_not_assignable_to_any_non_specialized_signature_2382","Specialized overload signature is not assignable to any non-specialized signature."),Overload_signatures_must_all_be_exported_or_non_exported:t(2383,e.DiagnosticCategory.Error,"Overload_signatures_must_all_be_exported_or_non_exported_2383","Overload signatures must all be exported or non-exported."),Overload_signatures_must_all_be_ambient_or_non_ambient:t(2384,e.DiagnosticCategory.Error,"Overload_signatures_must_all_be_ambient_or_non_ambient_2384","Overload signatures must all be ambient or non-ambient."),Overload_signatures_must_all_be_public_private_or_protected:t(2385,e.DiagnosticCategory.Error,"Overload_signatures_must_all_be_public_private_or_protected_2385","Overload signatures must all be public, private or protected."),Overload_signatures_must_all_be_optional_or_required:t(2386,e.DiagnosticCategory.Error,"Overload_signatures_must_all_be_optional_or_required_2386","Overload signatures must all be optional or required."),Function_overload_must_be_static:t(2387,e.DiagnosticCategory.Error,"Function_overload_must_be_static_2387","Function overload must be static."),Function_overload_must_not_be_static:t(2388,e.DiagnosticCategory.Error,"Function_overload_must_not_be_static_2388","Function overload must not be static."),Function_implementation_name_must_be_0:t(2389,e.DiagnosticCategory.Error,"Function_implementation_name_must_be_0_2389","Function implementation name must be '{0}'."),Constructor_implementation_is_missing:t(2390,e.DiagnosticCategory.Error,"Constructor_implementation_is_missing_2390","Constructor implementation is missing."),Function_implementation_is_missing_or_not_immediately_following_the_declaration:t(2391,e.DiagnosticCategory.Error,"Function_implementation_is_missing_or_not_immediately_following_the_declaration_2391","Function implementation is missing or not immediately following the declaration."),Multiple_constructor_implementations_are_not_allowed:t(2392,e.DiagnosticCategory.Error,"Multiple_constructor_implementations_are_not_allowed_2392","Multiple constructor implementations are not allowed."),Duplicate_function_implementation:t(2393,e.DiagnosticCategory.Error,"Duplicate_function_implementation_2393","Duplicate function implementation."),Overload_signature_is_not_compatible_with_function_implementation:t(2394,e.DiagnosticCategory.Error,"Overload_signature_is_not_compatible_with_function_implementation_2394","Overload signature is not compatible with function implementation."),Individual_declarations_in_merged_declaration_0_must_be_all_exported_or_all_local:t(2395,e.DiagnosticCategory.Error,"Individual_declarations_in_merged_declaration_0_must_be_all_exported_or_all_local_2395","Individual declarations in merged declaration '{0}' must be all exported or all local."),Duplicate_identifier_arguments_Compiler_uses_arguments_to_initialize_rest_parameters:t(2396,e.DiagnosticCategory.Error,"Duplicate_identifier_arguments_Compiler_uses_arguments_to_initialize_rest_parameters_2396","Duplicate identifier 'arguments'. Compiler uses 'arguments' to initialize rest parameters."),Declaration_name_conflicts_with_built_in_global_identifier_0:t(2397,e.DiagnosticCategory.Error,"Declaration_name_conflicts_with_built_in_global_identifier_0_2397","Declaration name conflicts with built-in global identifier '{0}'."),Duplicate_identifier_this_Compiler_uses_variable_declaration_this_to_capture_this_reference:t(2399,e.DiagnosticCategory.Error,"Duplicate_identifier_this_Compiler_uses_variable_declaration_this_to_capture_this_reference_2399","Duplicate identifier '_this'. Compiler uses variable declaration '_this' to capture 'this' reference."),Expression_resolves_to_variable_declaration_this_that_compiler_uses_to_capture_this_reference:t(2400,e.DiagnosticCategory.Error,"Expression_resolves_to_variable_declaration_this_that_compiler_uses_to_capture_this_reference_2400","Expression resolves to variable declaration '_this' that compiler uses to capture 'this' reference."),Duplicate_identifier_super_Compiler_uses_super_to_capture_base_class_reference:t(2401,e.DiagnosticCategory.Error,"Duplicate_identifier_super_Compiler_uses_super_to_capture_base_class_reference_2401","Duplicate identifier '_super'. Compiler uses '_super' to capture base class reference."),Expression_resolves_to_super_that_compiler_uses_to_capture_base_class_reference:t(2402,e.DiagnosticCategory.Error,"Expression_resolves_to_super_that_compiler_uses_to_capture_base_class_reference_2402","Expression resolves to '_super' that compiler uses to capture base class reference."),Subsequent_variable_declarations_must_have_the_same_type_Variable_0_must_be_of_type_1_but_here_has_type_2:t(2403,e.DiagnosticCategory.Error,"Subsequent_variable_declarations_must_have_the_same_type_Variable_0_must_be_of_type_1_but_here_has_t_2403","Subsequent variable declarations must have the same type.  Variable '{0}' must be of type '{1}', but here has type '{2}'."),The_left_hand_side_of_a_for_in_statement_cannot_use_a_type_annotation:t(2404,e.DiagnosticCategory.Error,"The_left_hand_side_of_a_for_in_statement_cannot_use_a_type_annotation_2404","The left-hand side of a 'for...in' statement cannot use a type annotation."),The_left_hand_side_of_a_for_in_statement_must_be_of_type_string_or_any:t(2405,e.DiagnosticCategory.Error,"The_left_hand_side_of_a_for_in_statement_must_be_of_type_string_or_any_2405","The left-hand side of a 'for...in' statement must be of type 'string' or 'any'."),The_left_hand_side_of_a_for_in_statement_must_be_a_variable_or_a_property_access:t(2406,e.DiagnosticCategory.Error,"The_left_hand_side_of_a_for_in_statement_must_be_a_variable_or_a_property_access_2406","The left-hand side of a 'for...in' statement must be a variable or a property access."),The_right_hand_side_of_a_for_in_statement_must_be_of_type_any_an_object_type_or_a_type_parameter:t(2407,e.DiagnosticCategory.Error,"The_right_hand_side_of_a_for_in_statement_must_be_of_type_any_an_object_type_or_a_type_parameter_2407","The right-hand side of a 'for...in' statement must be of type 'any', an object type or a type parameter."),Setters_cannot_return_a_value:t(2408,e.DiagnosticCategory.Error,"Setters_cannot_return_a_value_2408","Setters cannot return a value."),Return_type_of_constructor_signature_must_be_assignable_to_the_instance_type_of_the_class:t(2409,e.DiagnosticCategory.Error,"Return_type_of_constructor_signature_must_be_assignable_to_the_instance_type_of_the_class_2409","Return type of constructor signature must be assignable to the instance type of the class."),The_with_statement_is_not_supported_All_symbols_in_a_with_block_will_have_type_any:t(2410,e.DiagnosticCategory.Error,"The_with_statement_is_not_supported_All_symbols_in_a_with_block_will_have_type_any_2410","The 'with' statement is not supported. All symbols in a 'with' block will have type 'any'."),Property_0_of_type_1_is_not_assignable_to_string_index_type_2:t(2411,e.DiagnosticCategory.Error,"Property_0_of_type_1_is_not_assignable_to_string_index_type_2_2411","Property '{0}' of type '{1}' is not assignable to string index type '{2}'."),Property_0_of_type_1_is_not_assignable_to_numeric_index_type_2:t(2412,e.DiagnosticCategory.Error,"Property_0_of_type_1_is_not_assignable_to_numeric_index_type_2_2412","Property '{0}' of type '{1}' is not assignable to numeric index type '{2}'."),Numeric_index_type_0_is_not_assignable_to_string_index_type_1:t(2413,e.DiagnosticCategory.Error,"Numeric_index_type_0_is_not_assignable_to_string_index_type_1_2413","Numeric index type '{0}' is not assignable to string index type '{1}'."),Class_name_cannot_be_0:t(2414,e.DiagnosticCategory.Error,"Class_name_cannot_be_0_2414","Class name cannot be '{0}'."),Class_0_incorrectly_extends_base_class_1:t(2415,e.DiagnosticCategory.Error,"Class_0_incorrectly_extends_base_class_1_2415","Class '{0}' incorrectly extends base class '{1}'."),Property_0_in_type_1_is_not_assignable_to_the_same_property_in_base_type_2:t(2416,e.DiagnosticCategory.Error,"Property_0_in_type_1_is_not_assignable_to_the_same_property_in_base_type_2_2416","Property '{0}' in type '{1}' is not assignable to the same property in base type '{2}'."),Class_static_side_0_incorrectly_extends_base_class_static_side_1:t(2417,e.DiagnosticCategory.Error,"Class_static_side_0_incorrectly_extends_base_class_static_side_1_2417","Class static side '{0}' incorrectly extends base class static side '{1}'."),Class_0_incorrectly_implements_interface_1:t(2420,e.DiagnosticCategory.Error,"Class_0_incorrectly_implements_interface_1_2420","Class '{0}' incorrectly implements interface '{1}'."),A_class_may_only_implement_another_class_or_interface:t(2422,e.DiagnosticCategory.Error,"A_class_may_only_implement_another_class_or_interface_2422","A class may only implement another class or interface."),Class_0_defines_instance_member_function_1_but_extended_class_2_defines_it_as_instance_member_accessor:t(2423,e.DiagnosticCategory.Error,"Class_0_defines_instance_member_function_1_but_extended_class_2_defines_it_as_instance_member_access_2423","Class '{0}' defines instance member function '{1}', but extended class '{2}' defines it as instance member accessor."),Class_0_defines_instance_member_function_1_but_extended_class_2_defines_it_as_instance_member_property:t(2424,e.DiagnosticCategory.Error,"Class_0_defines_instance_member_function_1_but_extended_class_2_defines_it_as_instance_member_proper_2424","Class '{0}' defines instance member function '{1}', but extended class '{2}' defines it as instance member property."),Class_0_defines_instance_member_property_1_but_extended_class_2_defines_it_as_instance_member_function:t(2425,e.DiagnosticCategory.Error,"Class_0_defines_instance_member_property_1_but_extended_class_2_defines_it_as_instance_member_functi_2425","Class '{0}' defines instance member property '{1}', but extended class '{2}' defines it as instance member function."),Class_0_defines_instance_member_accessor_1_but_extended_class_2_defines_it_as_instance_member_function:t(2426,e.DiagnosticCategory.Error,"Class_0_defines_instance_member_accessor_1_but_extended_class_2_defines_it_as_instance_member_functi_2426","Class '{0}' defines instance member accessor '{1}', but extended class '{2}' defines it as instance member function."),Interface_name_cannot_be_0:t(2427,e.DiagnosticCategory.Error,"Interface_name_cannot_be_0_2427","Interface name cannot be '{0}'."),All_declarations_of_0_must_have_identical_type_parameters:t(2428,e.DiagnosticCategory.Error,"All_declarations_of_0_must_have_identical_type_parameters_2428","All declarations of '{0}' must have identical type parameters."),Interface_0_incorrectly_extends_interface_1:t(2430,e.DiagnosticCategory.Error,"Interface_0_incorrectly_extends_interface_1_2430","Interface '{0}' incorrectly extends interface '{1}'."),Enum_name_cannot_be_0:t(2431,e.DiagnosticCategory.Error,"Enum_name_cannot_be_0_2431","Enum name cannot be '{0}'."),In_an_enum_with_multiple_declarations_only_one_declaration_can_omit_an_initializer_for_its_first_enum_element:t(2432,e.DiagnosticCategory.Error,"In_an_enum_with_multiple_declarations_only_one_declaration_can_omit_an_initializer_for_its_first_enu_2432","In an enum with multiple declarations, only one declaration can omit an initializer for its first enum element."),A_namespace_declaration_cannot_be_in_a_different_file_from_a_class_or_function_with_which_it_is_merged:t(2433,e.DiagnosticCategory.Error,"A_namespace_declaration_cannot_be_in_a_different_file_from_a_class_or_function_with_which_it_is_merg_2433","A namespace declaration cannot be in a different file from a class or function with which it is merged."),A_namespace_declaration_cannot_be_located_prior_to_a_class_or_function_with_which_it_is_merged:t(2434,e.DiagnosticCategory.Error,"A_namespace_declaration_cannot_be_located_prior_to_a_class_or_function_with_which_it_is_merged_2434","A namespace declaration cannot be located prior to a class or function with which it is merged."),Ambient_modules_cannot_be_nested_in_other_modules_or_namespaces:t(2435,e.DiagnosticCategory.Error,"Ambient_modules_cannot_be_nested_in_other_modules_or_namespaces_2435","Ambient modules cannot be nested in other modules or namespaces."),Ambient_module_declaration_cannot_specify_relative_module_name:t(2436,e.DiagnosticCategory.Error,"Ambient_module_declaration_cannot_specify_relative_module_name_2436","Ambient module declaration cannot specify relative module name."),Module_0_is_hidden_by_a_local_declaration_with_the_same_name:t(2437,e.DiagnosticCategory.Error,"Module_0_is_hidden_by_a_local_declaration_with_the_same_name_2437","Module '{0}' is hidden by a local declaration with the same name."),Import_name_cannot_be_0:t(2438,e.DiagnosticCategory.Error,"Import_name_cannot_be_0_2438","Import name cannot be '{0}'."),Import_or_export_declaration_in_an_ambient_module_declaration_cannot_reference_module_through_relative_module_name:t(2439,e.DiagnosticCategory.Error,"Import_or_export_declaration_in_an_ambient_module_declaration_cannot_reference_module_through_relati_2439","Import or export declaration in an ambient module declaration cannot reference module through relative module name."),Import_declaration_conflicts_with_local_declaration_of_0:t(2440,e.DiagnosticCategory.Error,"Import_declaration_conflicts_with_local_declaration_of_0_2440","Import declaration conflicts with local declaration of '{0}'."),Duplicate_identifier_0_Compiler_reserves_name_1_in_top_level_scope_of_a_module:t(2441,e.DiagnosticCategory.Error,"Duplicate_identifier_0_Compiler_reserves_name_1_in_top_level_scope_of_a_module_2441","Duplicate identifier '{0}'. Compiler reserves name '{1}' in top level scope of a module."),Types_have_separate_declarations_of_a_private_property_0:t(2442,e.DiagnosticCategory.Error,"Types_have_separate_declarations_of_a_private_property_0_2442","Types have separate declarations of a private property '{0}'."),Property_0_is_protected_but_type_1_is_not_a_class_derived_from_2:t(2443,e.DiagnosticCategory.Error,"Property_0_is_protected_but_type_1_is_not_a_class_derived_from_2_2443","Property '{0}' is protected but type '{1}' is not a class derived from '{2}'."),Property_0_is_protected_in_type_1_but_public_in_type_2:t(2444,e.DiagnosticCategory.Error,"Property_0_is_protected_in_type_1_but_public_in_type_2_2444","Property '{0}' is protected in type '{1}' but public in type '{2}'."),Property_0_is_protected_and_only_accessible_within_class_1_and_its_subclasses:t(2445,e.DiagnosticCategory.Error,"Property_0_is_protected_and_only_accessible_within_class_1_and_its_subclasses_2445","Property '{0}' is protected and only accessible within class '{1}' and its subclasses."),Property_0_is_protected_and_only_accessible_through_an_instance_of_class_1:t(2446,e.DiagnosticCategory.Error,"Property_0_is_protected_and_only_accessible_through_an_instance_of_class_1_2446","Property '{0}' is protected and only accessible through an instance of class '{1}'."),The_0_operator_is_not_allowed_for_boolean_types_Consider_using_1_instead:t(2447,e.DiagnosticCategory.Error,"The_0_operator_is_not_allowed_for_boolean_types_Consider_using_1_instead_2447","The '{0}' operator is not allowed for boolean types. Consider using '{1}' instead."),Block_scoped_variable_0_used_before_its_declaration:t(2448,e.DiagnosticCategory.Error,"Block_scoped_variable_0_used_before_its_declaration_2448","Block-scoped variable '{0}' used before its declaration."),Class_0_used_before_its_declaration:t(2449,e.DiagnosticCategory.Error,"Class_0_used_before_its_declaration_2449","Class '{0}' used before its declaration."),Enum_0_used_before_its_declaration:t(2450,e.DiagnosticCategory.Error,"Enum_0_used_before_its_declaration_2450","Enum '{0}' used before its declaration."),Cannot_redeclare_block_scoped_variable_0:t(2451,e.DiagnosticCategory.Error,"Cannot_redeclare_block_scoped_variable_0_2451","Cannot redeclare block-scoped variable '{0}'."),An_enum_member_cannot_have_a_numeric_name:t(2452,e.DiagnosticCategory.Error,"An_enum_member_cannot_have_a_numeric_name_2452","An enum member cannot have a numeric name."),The_type_argument_for_type_parameter_0_cannot_be_inferred_from_the_usage_Consider_specifying_the_type_arguments_explicitly:t(2453,e.DiagnosticCategory.Error,"The_type_argument_for_type_parameter_0_cannot_be_inferred_from_the_usage_Consider_specifying_the_typ_2453","The type argument for type parameter '{0}' cannot be inferred from the usage. Consider specifying the type arguments explicitly."),Variable_0_is_used_before_being_assigned:t(2454,e.DiagnosticCategory.Error,"Variable_0_is_used_before_being_assigned_2454","Variable '{0}' is used before being assigned."),Type_argument_candidate_1_is_not_a_valid_type_argument_because_it_is_not_a_supertype_of_candidate_0:t(2455,e.DiagnosticCategory.Error,"Type_argument_candidate_1_is_not_a_valid_type_argument_because_it_is_not_a_supertype_of_candidate_0_2455","Type argument candidate '{1}' is not a valid type argument because it is not a supertype of candidate '{0}'."),Type_alias_0_circularly_references_itself:t(2456,e.DiagnosticCategory.Error,"Type_alias_0_circularly_references_itself_2456","Type alias '{0}' circularly references itself."),Type_alias_name_cannot_be_0:t(2457,e.DiagnosticCategory.Error,"Type_alias_name_cannot_be_0_2457","Type alias name cannot be '{0}'."),An_AMD_module_cannot_have_multiple_name_assignments:t(2458,e.DiagnosticCategory.Error,"An_AMD_module_cannot_have_multiple_name_assignments_2458","An AMD module cannot have multiple name assignments."),Type_0_has_no_property_1_and_no_string_index_signature:t(2459,e.DiagnosticCategory.Error,"Type_0_has_no_property_1_and_no_string_index_signature_2459","Type '{0}' has no property '{1}' and no string index signature."),Type_0_has_no_property_1:t(2460,e.DiagnosticCategory.Error,"Type_0_has_no_property_1_2460","Type '{0}' has no property '{1}'."),Type_0_is_not_an_array_type:t(2461,e.DiagnosticCategory.Error,"Type_0_is_not_an_array_type_2461","Type '{0}' is not an array type."),A_rest_element_must_be_last_in_a_destructuring_pattern:t(2462,e.DiagnosticCategory.Error,"A_rest_element_must_be_last_in_a_destructuring_pattern_2462","A rest element must be last in a destructuring pattern."),A_binding_pattern_parameter_cannot_be_optional_in_an_implementation_signature:t(2463,e.DiagnosticCategory.Error,"A_binding_pattern_parameter_cannot_be_optional_in_an_implementation_signature_2463","A binding pattern parameter cannot be optional in an implementation signature."),A_computed_property_name_must_be_of_type_string_number_symbol_or_any:t(2464,e.DiagnosticCategory.Error,"A_computed_property_name_must_be_of_type_string_number_symbol_or_any_2464","A computed property name must be of type 'string', 'number', 'symbol', or 'any'."),this_cannot_be_referenced_in_a_computed_property_name:t(2465,e.DiagnosticCategory.Error,"this_cannot_be_referenced_in_a_computed_property_name_2465","'this' cannot be referenced in a computed property name."),super_cannot_be_referenced_in_a_computed_property_name:t(2466,e.DiagnosticCategory.Error,"super_cannot_be_referenced_in_a_computed_property_name_2466","'super' cannot be referenced in a computed property name."),A_computed_property_name_cannot_reference_a_type_parameter_from_its_containing_type:t(2467,e.DiagnosticCategory.Error,"A_computed_property_name_cannot_reference_a_type_parameter_from_its_containing_type_2467","A computed property name cannot reference a type parameter from its containing type."),Cannot_find_global_value_0:t(2468,e.DiagnosticCategory.Error,"Cannot_find_global_value_0_2468","Cannot find global value '{0}'."),The_0_operator_cannot_be_applied_to_type_symbol:t(2469,e.DiagnosticCategory.Error,"The_0_operator_cannot_be_applied_to_type_symbol_2469","The '{0}' operator cannot be applied to type 'symbol'."),Symbol_reference_does_not_refer_to_the_global_Symbol_constructor_object:t(2470,e.DiagnosticCategory.Error,"Symbol_reference_does_not_refer_to_the_global_Symbol_constructor_object_2470","'Symbol' reference does not refer to the global Symbol constructor object."),A_computed_property_name_of_the_form_0_must_be_of_type_symbol:t(2471,e.DiagnosticCategory.Error,"A_computed_property_name_of_the_form_0_must_be_of_type_symbol_2471","A computed property name of the form '{0}' must be of type 'symbol'."),Spread_operator_in_new_expressions_is_only_available_when_targeting_ECMAScript_5_and_higher:t(2472,e.DiagnosticCategory.Error,"Spread_operator_in_new_expressions_is_only_available_when_targeting_ECMAScript_5_and_higher_2472","Spread operator in 'new' expressions is only available when targeting ECMAScript 5 and higher."),Enum_declarations_must_all_be_const_or_non_const:t(2473,e.DiagnosticCategory.Error,"Enum_declarations_must_all_be_const_or_non_const_2473","Enum declarations must all be const or non-const."),In_const_enum_declarations_member_initializer_must_be_constant_expression:t(2474,e.DiagnosticCategory.Error,"In_const_enum_declarations_member_initializer_must_be_constant_expression_2474","In 'const' enum declarations member initializer must be constant expression."),const_enums_can_only_be_used_in_property_or_index_access_expressions_or_the_right_hand_side_of_an_import_declaration_or_export_assignment_or_type_query:t(2475,e.DiagnosticCategory.Error,"const_enums_can_only_be_used_in_property_or_index_access_expressions_or_the_right_hand_side_of_an_im_2475","'const' enums can only be used in property or index access expressions or the right hand side of an import declaration or export assignment or type query."),A_const_enum_member_can_only_be_accessed_using_a_string_literal:t(2476,e.DiagnosticCategory.Error,"A_const_enum_member_can_only_be_accessed_using_a_string_literal_2476","A const enum member can only be accessed using a string literal."),const_enum_member_initializer_was_evaluated_to_a_non_finite_value:t(2477,e.DiagnosticCategory.Error,"const_enum_member_initializer_was_evaluated_to_a_non_finite_value_2477","'const' enum member initializer was evaluated to a non-finite value."),const_enum_member_initializer_was_evaluated_to_disallowed_value_NaN:t(2478,e.DiagnosticCategory.Error,"const_enum_member_initializer_was_evaluated_to_disallowed_value_NaN_2478","'const' enum member initializer was evaluated to disallowed value 'NaN'."),Property_0_does_not_exist_on_const_enum_1:t(2479,e.DiagnosticCategory.Error,"Property_0_does_not_exist_on_const_enum_1_2479","Property '{0}' does not exist on 'const' enum '{1}'."),let_is_not_allowed_to_be_used_as_a_name_in_let_or_const_declarations:t(2480,e.DiagnosticCategory.Error,"let_is_not_allowed_to_be_used_as_a_name_in_let_or_const_declarations_2480","'let' is not allowed to be used as a name in 'let' or 'const' declarations."),Cannot_initialize_outer_scoped_variable_0_in_the_same_scope_as_block_scoped_declaration_1:t(2481,e.DiagnosticCategory.Error,"Cannot_initialize_outer_scoped_variable_0_in_the_same_scope_as_block_scoped_declaration_1_2481","Cannot initialize outer scoped variable '{0}' in the same scope as block scoped declaration '{1}'."),The_left_hand_side_of_a_for_of_statement_cannot_use_a_type_annotation:t(2483,e.DiagnosticCategory.Error,"The_left_hand_side_of_a_for_of_statement_cannot_use_a_type_annotation_2483","The left-hand side of a 'for...of' statement cannot use a type annotation."),Export_declaration_conflicts_with_exported_declaration_of_0:t(2484,e.DiagnosticCategory.Error,"Export_declaration_conflicts_with_exported_declaration_of_0_2484","Export declaration conflicts with exported declaration of '{0}'."),The_left_hand_side_of_a_for_of_statement_must_be_a_variable_or_a_property_access:t(2487,e.DiagnosticCategory.Error,"The_left_hand_side_of_a_for_of_statement_must_be_a_variable_or_a_property_access_2487","The left-hand side of a 'for...of' statement must be a variable or a property access."),Type_must_have_a_Symbol_iterator_method_that_returns_an_iterator:t(2488,e.DiagnosticCategory.Error,"Type_must_have_a_Symbol_iterator_method_that_returns_an_iterator_2488","Type must have a '[Symbol.iterator]()' method that returns an iterator."),An_iterator_must_have_a_next_method:t(2489,e.DiagnosticCategory.Error,"An_iterator_must_have_a_next_method_2489","An iterator must have a 'next()' method."),The_type_returned_by_the_next_method_of_an_iterator_must_have_a_value_property:t(2490,e.DiagnosticCategory.Error,"The_type_returned_by_the_next_method_of_an_iterator_must_have_a_value_property_2490","The type returned by the 'next()' method of an iterator must have a 'value' property."),The_left_hand_side_of_a_for_in_statement_cannot_be_a_destructuring_pattern:t(2491,e.DiagnosticCategory.Error,"The_left_hand_side_of_a_for_in_statement_cannot_be_a_destructuring_pattern_2491","The left-hand side of a 'for...in' statement cannot be a destructuring pattern."),Cannot_redeclare_identifier_0_in_catch_clause:t(2492,e.DiagnosticCategory.Error,"Cannot_redeclare_identifier_0_in_catch_clause_2492","Cannot redeclare identifier '{0}' in catch clause."),Tuple_type_0_with_length_1_cannot_be_assigned_to_tuple_with_length_2:t(2493,e.DiagnosticCategory.Error,"Tuple_type_0_with_length_1_cannot_be_assigned_to_tuple_with_length_2_2493","Tuple type '{0}' with length '{1}' cannot be assigned to tuple with length '{2}'."),Using_a_string_in_a_for_of_statement_is_only_supported_in_ECMAScript_5_and_higher:t(2494,e.DiagnosticCategory.Error,"Using_a_string_in_a_for_of_statement_is_only_supported_in_ECMAScript_5_and_higher_2494","Using a string in a 'for...of' statement is only supported in ECMAScript 5 and higher."),Type_0_is_not_an_array_type_or_a_string_type:t(2495,e.DiagnosticCategory.Error,"Type_0_is_not_an_array_type_or_a_string_type_2495","Type '{0}' is not an array type or a string type."),The_arguments_object_cannot_be_referenced_in_an_arrow_function_in_ES3_and_ES5_Consider_using_a_standard_function_expression:t(2496,e.DiagnosticCategory.Error,"The_arguments_object_cannot_be_referenced_in_an_arrow_function_in_ES3_and_ES5_Consider_using_a_stand_2496","The 'arguments' object cannot be referenced in an arrow function in ES3 and ES5. Consider using a standard function expression."),Module_0_resolves_to_a_non_module_entity_and_cannot_be_imported_using_this_construct:t(2497,e.DiagnosticCategory.Error,"Module_0_resolves_to_a_non_module_entity_and_cannot_be_imported_using_this_construct_2497","Module '{0}' resolves to a non-module entity and cannot be imported using this construct."),Module_0_uses_export_and_cannot_be_used_with_export_Asterisk:t(2498,e.DiagnosticCategory.Error,"Module_0_uses_export_and_cannot_be_used_with_export_Asterisk_2498","Module '{0}' uses 'export =' and cannot be used with 'export *'."),An_interface_can_only_extend_an_identifier_Slashqualified_name_with_optional_type_arguments:t(2499,e.DiagnosticCategory.Error,"An_interface_can_only_extend_an_identifier_Slashqualified_name_with_optional_type_arguments_2499","An interface can only extend an identifier/qualified-name with optional type arguments."),A_class_can_only_implement_an_identifier_Slashqualified_name_with_optional_type_arguments:t(2500,e.DiagnosticCategory.Error,"A_class_can_only_implement_an_identifier_Slashqualified_name_with_optional_type_arguments_2500","A class can only implement an identifier/qualified-name with optional type arguments."),A_rest_element_cannot_contain_a_binding_pattern:t(2501,e.DiagnosticCategory.Error,"A_rest_element_cannot_contain_a_binding_pattern_2501","A rest element cannot contain a binding pattern."),_0_is_referenced_directly_or_indirectly_in_its_own_type_annotation:t(2502,e.DiagnosticCategory.Error,"_0_is_referenced_directly_or_indirectly_in_its_own_type_annotation_2502","'{0}' is referenced directly or indirectly in its own type annotation."),Cannot_find_namespace_0:t(2503,e.DiagnosticCategory.Error,"Cannot_find_namespace_0_2503","Cannot find namespace '{0}'."),Type_must_have_a_Symbol_asyncIterator_method_that_returns_an_async_iterator:t(2504,e.DiagnosticCategory.Error,"Type_must_have_a_Symbol_asyncIterator_method_that_returns_an_async_iterator_2504","Type must have a '[Symbol.asyncIterator]()' method that returns an async iterator."),A_generator_cannot_have_a_void_type_annotation:t(2505,e.DiagnosticCategory.Error,"A_generator_cannot_have_a_void_type_annotation_2505","A generator cannot have a 'void' type annotation."),_0_is_referenced_directly_or_indirectly_in_its_own_base_expression:t(2506,e.DiagnosticCategory.Error,"_0_is_referenced_directly_or_indirectly_in_its_own_base_expression_2506","'{0}' is referenced directly or indirectly in its own base expression."),Type_0_is_not_a_constructor_function_type:t(2507,e.DiagnosticCategory.Error,"Type_0_is_not_a_constructor_function_type_2507","Type '{0}' is not a constructor function type."),No_base_constructor_has_the_specified_number_of_type_arguments:t(2508,e.DiagnosticCategory.Error,"No_base_constructor_has_the_specified_number_of_type_arguments_2508","No base constructor has the specified number of type arguments."),Base_constructor_return_type_0_is_not_a_class_or_interface_type:t(2509,e.DiagnosticCategory.Error,"Base_constructor_return_type_0_is_not_a_class_or_interface_type_2509","Base constructor return type '{0}' is not a class or interface type."),Base_constructors_must_all_have_the_same_return_type:t(2510,e.DiagnosticCategory.Error,"Base_constructors_must_all_have_the_same_return_type_2510","Base constructors must all have the same return type."),Cannot_create_an_instance_of_an_abstract_class:t(2511,e.DiagnosticCategory.Error,"Cannot_create_an_instance_of_an_abstract_class_2511","Cannot create an instance of an abstract class."),Overload_signatures_must_all_be_abstract_or_non_abstract:t(2512,e.DiagnosticCategory.Error,"Overload_signatures_must_all_be_abstract_or_non_abstract_2512","Overload signatures must all be abstract or non-abstract."),Abstract_method_0_in_class_1_cannot_be_accessed_via_super_expression:t(2513,e.DiagnosticCategory.Error,"Abstract_method_0_in_class_1_cannot_be_accessed_via_super_expression_2513","Abstract method '{0}' in class '{1}' cannot be accessed via super expression."),Classes_containing_abstract_methods_must_be_marked_abstract:t(2514,e.DiagnosticCategory.Error,"Classes_containing_abstract_methods_must_be_marked_abstract_2514","Classes containing abstract methods must be marked abstract."),Non_abstract_class_0_does_not_implement_inherited_abstract_member_1_from_class_2:t(2515,e.DiagnosticCategory.Error,"Non_abstract_class_0_does_not_implement_inherited_abstract_member_1_from_class_2_2515","Non-abstract class '{0}' does not implement inherited abstract member '{1}' from class '{2}'."),All_declarations_of_an_abstract_method_must_be_consecutive:t(2516,e.DiagnosticCategory.Error,"All_declarations_of_an_abstract_method_must_be_consecutive_2516","All declarations of an abstract method must be consecutive."),Cannot_assign_an_abstract_constructor_type_to_a_non_abstract_constructor_type:t(2517,e.DiagnosticCategory.Error,"Cannot_assign_an_abstract_constructor_type_to_a_non_abstract_constructor_type_2517","Cannot assign an abstract constructor type to a non-abstract constructor type."),A_this_based_type_guard_is_not_compatible_with_a_parameter_based_type_guard:t(2518,e.DiagnosticCategory.Error,"A_this_based_type_guard_is_not_compatible_with_a_parameter_based_type_guard_2518","A 'this'-based type guard is not compatible with a parameter-based type guard."),An_async_iterator_must_have_a_next_method:t(2519,e.DiagnosticCategory.Error,"An_async_iterator_must_have_a_next_method_2519","An async iterator must have a 'next()' method."),Duplicate_identifier_0_Compiler_uses_declaration_1_to_support_async_functions:t(2520,e.DiagnosticCategory.Error,"Duplicate_identifier_0_Compiler_uses_declaration_1_to_support_async_functions_2520","Duplicate identifier '{0}'. Compiler uses declaration '{1}' to support async functions."),Expression_resolves_to_variable_declaration_0_that_compiler_uses_to_support_async_functions:t(2521,e.DiagnosticCategory.Error,"Expression_resolves_to_variable_declaration_0_that_compiler_uses_to_support_async_functions_2521","Expression resolves to variable declaration '{0}' that compiler uses to support async functions."),The_arguments_object_cannot_be_referenced_in_an_async_function_or_method_in_ES3_and_ES5_Consider_using_a_standard_function_or_method:t(2522,e.DiagnosticCategory.Error,"The_arguments_object_cannot_be_referenced_in_an_async_function_or_method_in_ES3_and_ES5_Consider_usi_2522","The 'arguments' object cannot be referenced in an async function or method in ES3 and ES5. Consider using a standard function or method."),yield_expressions_cannot_be_used_in_a_parameter_initializer:t(2523,e.DiagnosticCategory.Error,"yield_expressions_cannot_be_used_in_a_parameter_initializer_2523","'yield' expressions cannot be used in a parameter initializer."),await_expressions_cannot_be_used_in_a_parameter_initializer:t(2524,e.DiagnosticCategory.Error,"await_expressions_cannot_be_used_in_a_parameter_initializer_2524","'await' expressions cannot be used in a parameter initializer."),Initializer_provides_no_value_for_this_binding_element_and_the_binding_element_has_no_default_value:t(2525,e.DiagnosticCategory.Error,"Initializer_provides_no_value_for_this_binding_element_and_the_binding_element_has_no_default_value_2525","Initializer provides no value for this binding element and the binding element has no default value."),A_this_type_is_available_only_in_a_non_static_member_of_a_class_or_interface:t(2526,e.DiagnosticCategory.Error,"A_this_type_is_available_only_in_a_non_static_member_of_a_class_or_interface_2526","A 'this' type is available only in a non-static member of a class or interface."),The_inferred_type_of_0_references_an_inaccessible_1_type_A_type_annotation_is_necessary:t(2527,e.DiagnosticCategory.Error,"The_inferred_type_of_0_references_an_inaccessible_1_type_A_type_annotation_is_necessary_2527","The inferred type of '{0}' references an inaccessible '{1}' type. A type annotation is necessary."),A_module_cannot_have_multiple_default_exports:t(2528,e.DiagnosticCategory.Error,"A_module_cannot_have_multiple_default_exports_2528","A module cannot have multiple default exports."),Duplicate_identifier_0_Compiler_reserves_name_1_in_top_level_scope_of_a_module_containing_async_functions:t(2529,e.DiagnosticCategory.Error,"Duplicate_identifier_0_Compiler_reserves_name_1_in_top_level_scope_of_a_module_containing_async_func_2529","Duplicate identifier '{0}'. Compiler reserves name '{1}' in top level scope of a module containing async functions."),Property_0_is_incompatible_with_index_signature:t(2530,e.DiagnosticCategory.Error,"Property_0_is_incompatible_with_index_signature_2530","Property '{0}' is incompatible with index signature."),Object_is_possibly_null:t(2531,e.DiagnosticCategory.Error,"Object_is_possibly_null_2531","Object is possibly 'null'."),Object_is_possibly_undefined:t(2532,e.DiagnosticCategory.Error,"Object_is_possibly_undefined_2532","Object is possibly 'undefined'."),Object_is_possibly_null_or_undefined:t(2533,e.DiagnosticCategory.Error,"Object_is_possibly_null_or_undefined_2533","Object is possibly 'null' or 'undefined'."),A_function_returning_never_cannot_have_a_reachable_end_point:t(2534,e.DiagnosticCategory.Error,"A_function_returning_never_cannot_have_a_reachable_end_point_2534","A function returning 'never' cannot have a reachable end point."),Enum_type_0_has_members_with_initializers_that_are_not_literals:t(2535,e.DiagnosticCategory.Error,"Enum_type_0_has_members_with_initializers_that_are_not_literals_2535","Enum type '{0}' has members with initializers that are not literals."),Type_0_cannot_be_used_to_index_type_1:t(2536,e.DiagnosticCategory.Error,"Type_0_cannot_be_used_to_index_type_1_2536","Type '{0}' cannot be used to index type '{1}'."),Type_0_has_no_matching_index_signature_for_type_1:t(2537,e.DiagnosticCategory.Error,"Type_0_has_no_matching_index_signature_for_type_1_2537","Type '{0}' has no matching index signature for type '{1}'."),Type_0_cannot_be_used_as_an_index_type:t(2538,e.DiagnosticCategory.Error,"Type_0_cannot_be_used_as_an_index_type_2538","Type '{0}' cannot be used as an index type."),Cannot_assign_to_0_because_it_is_not_a_variable:t(2539,e.DiagnosticCategory.Error,"Cannot_assign_to_0_because_it_is_not_a_variable_2539","Cannot assign to '{0}' because it is not a variable."),Cannot_assign_to_0_because_it_is_a_constant_or_a_read_only_property:t(2540,e.DiagnosticCategory.Error,"Cannot_assign_to_0_because_it_is_a_constant_or_a_read_only_property_2540","Cannot assign to '{0}' because it is a constant or a read-only property."),The_target_of_an_assignment_must_be_a_variable_or_a_property_access:t(2541,e.DiagnosticCategory.Error,"The_target_of_an_assignment_must_be_a_variable_or_a_property_access_2541","The target of an assignment must be a variable or a property access."),Index_signature_in_type_0_only_permits_reading:t(2542,e.DiagnosticCategory.Error,"Index_signature_in_type_0_only_permits_reading_2542","Index signature in type '{0}' only permits reading."),Duplicate_identifier_newTarget_Compiler_uses_variable_declaration_newTarget_to_capture_new_target_meta_property_reference:t(2543,e.DiagnosticCategory.Error,"Duplicate_identifier_newTarget_Compiler_uses_variable_declaration_newTarget_to_capture_new_target_me_2543","Duplicate identifier '_newTarget'. Compiler uses variable declaration '_newTarget' to capture 'new.target' meta-property reference."),Expression_resolves_to_variable_declaration_newTarget_that_compiler_uses_to_capture_new_target_meta_property_reference:t(2544,e.DiagnosticCategory.Error,"Expression_resolves_to_variable_declaration_newTarget_that_compiler_uses_to_capture_new_target_meta__2544","Expression resolves to variable declaration '_newTarget' that compiler uses to capture 'new.target' meta-property reference."),A_mixin_class_must_have_a_constructor_with_a_single_rest_parameter_of_type_any:t(2545,e.DiagnosticCategory.Error,"A_mixin_class_must_have_a_constructor_with_a_single_rest_parameter_of_type_any_2545","A mixin class must have a constructor with a single rest parameter of type 'any[]'."),Property_0_has_conflicting_declarations_and_is_inaccessible_in_type_1:t(2546,e.DiagnosticCategory.Error,"Property_0_has_conflicting_declarations_and_is_inaccessible_in_type_1_2546","Property '{0}' has conflicting declarations and is inaccessible in type '{1}'."),The_type_returned_by_the_next_method_of_an_async_iterator_must_be_a_promise_for_a_type_with_a_value_property:t(2547,e.DiagnosticCategory.Error,"The_type_returned_by_the_next_method_of_an_async_iterator_must_be_a_promise_for_a_type_with_a_value__2547","The type returned by the 'next()' method of an async iterator must be a promise for a type with a 'value' property."),Type_0_is_not_an_array_type_or_does_not_have_a_Symbol_iterator_method_that_returns_an_iterator:t(2548,e.DiagnosticCategory.Error,"Type_0_is_not_an_array_type_or_does_not_have_a_Symbol_iterator_method_that_returns_an_iterator_2548","Type '{0}' is not an array type or does not have a '[Symbol.iterator]()' method that returns an iterator."),Type_0_is_not_an_array_type_or_a_string_type_or_does_not_have_a_Symbol_iterator_method_that_returns_an_iterator:t(2549,e.DiagnosticCategory.Error,"Type_0_is_not_an_array_type_or_a_string_type_or_does_not_have_a_Symbol_iterator_method_that_returns__2549","Type '{0}' is not an array type or a string type or does not have a '[Symbol.iterator]()' method that returns an iterator."),Generic_type_instantiation_is_excessively_deep_and_possibly_infinite:t(2550,e.DiagnosticCategory.Error,"Generic_type_instantiation_is_excessively_deep_and_possibly_infinite_2550","Generic type instantiation is excessively deep and possibly infinite."),Property_0_does_not_exist_on_type_1_Did_you_mean_2:t(2551,e.DiagnosticCategory.Error,"Property_0_does_not_exist_on_type_1_Did_you_mean_2_2551","Property '{0}' does not exist on type '{1}'. Did you mean '{2}'?"),Cannot_find_name_0_Did_you_mean_1:t(2552,e.DiagnosticCategory.Error,"Cannot_find_name_0_Did_you_mean_1_2552","Cannot find name '{0}'. Did you mean '{1}'?"),Computed_values_are_not_permitted_in_an_enum_with_string_valued_members:t(2553,e.DiagnosticCategory.Error,"Computed_values_are_not_permitted_in_an_enum_with_string_valued_members_2553","Computed values are not permitted in an enum with string valued members."),Expected_0_arguments_but_got_1:t(2554,e.DiagnosticCategory.Error,"Expected_0_arguments_but_got_1_2554","Expected {0} arguments, but got {1}."),Expected_at_least_0_arguments_but_got_1:t(2555,e.DiagnosticCategory.Error,"Expected_at_least_0_arguments_but_got_1_2555","Expected at least {0} arguments, but got {1}."),Expected_0_arguments_but_got_1_or_more:t(2556,e.DiagnosticCategory.Error,"Expected_0_arguments_but_got_1_or_more_2556","Expected {0} arguments, but got {1} or more."),Expected_at_least_0_arguments_but_got_1_or_more:t(2557,e.DiagnosticCategory.Error,"Expected_at_least_0_arguments_but_got_1_or_more_2557","Expected at least {0} arguments, but got {1} or more."),Expected_0_type_arguments_but_got_1:t(2558,e.DiagnosticCategory.Error,"Expected_0_type_arguments_but_got_1_2558","Expected {0} type arguments, but got {1}."),Type_0_has_no_properties_in_common_with_type_1:t(2559,e.DiagnosticCategory.Error,"Type_0_has_no_properties_in_common_with_type_1_2559","Type '{0}' has no properties in common with type '{1}'."),Value_of_type_0_has_no_properties_in_common_with_type_1_Did_you_mean_to_call_it:t(2560,e.DiagnosticCategory.Error,"Value_of_type_0_has_no_properties_in_common_with_type_1_Did_you_mean_to_call_it_2560","Value of type '{0}' has no properties in common with type '{1}'. Did you mean to call it?"),Object_literal_may_only_specify_known_properties_but_0_does_not_exist_in_type_1_Did_you_mean_to_write_2:t(2561,e.DiagnosticCategory.Error,"Object_literal_may_only_specify_known_properties_but_0_does_not_exist_in_type_1_Did_you_mean_to_writ_2561","Object literal may only specify known properties, but '{0}' does not exist in type '{1}'. Did you mean to write '{2}'?"),Base_class_expressions_cannot_reference_class_type_parameters:t(2562,e.DiagnosticCategory.Error,"Base_class_expressions_cannot_reference_class_type_parameters_2562","Base class expressions cannot reference class type parameters."),The_containing_function_or_module_body_is_too_large_for_control_flow_analysis:t(2563,e.DiagnosticCategory.Error,"The_containing_function_or_module_body_is_too_large_for_control_flow_analysis_2563","The containing function or module body is too large for control flow analysis."),Property_0_has_no_initializer_and_is_not_definitely_assigned_in_the_constructor:t(2564,e.DiagnosticCategory.Error,"Property_0_has_no_initializer_and_is_not_definitely_assigned_in_the_constructor_2564","Property '{0}' has no initializer and is not definitely assigned in the constructor."),Property_0_is_used_before_being_assigned:t(2565,e.DiagnosticCategory.Error,"Property_0_is_used_before_being_assigned_2565","Property '{0}' is used before being assigned."),A_rest_element_cannot_have_a_property_name:t(2566,e.DiagnosticCategory.Error,"A_rest_element_cannot_have_a_property_name_2566","A rest element cannot have a property name."),Enum_declarations_can_only_merge_with_namespace_or_other_enum_declarations:t(2567,e.DiagnosticCategory.Error,"Enum_declarations_can_only_merge_with_namespace_or_other_enum_declarations_2567","Enum declarations can only merge with namespace or other enum declarations."),JSX_element_attributes_type_0_may_not_be_a_union_type:t(2600,e.DiagnosticCategory.Error,"JSX_element_attributes_type_0_may_not_be_a_union_type_2600","JSX element attributes type '{0}' may not be a union type."),The_return_type_of_a_JSX_element_constructor_must_return_an_object_type:t(2601,e.DiagnosticCategory.Error,"The_return_type_of_a_JSX_element_constructor_must_return_an_object_type_2601","The return type of a JSX element constructor must return an object type."),JSX_element_implicitly_has_type_any_because_the_global_type_JSX_Element_does_not_exist:t(2602,e.DiagnosticCategory.Error,"JSX_element_implicitly_has_type_any_because_the_global_type_JSX_Element_does_not_exist_2602","JSX element implicitly has type 'any' because the global type 'JSX.Element' does not exist."),Property_0_in_type_1_is_not_assignable_to_type_2:t(2603,e.DiagnosticCategory.Error,"Property_0_in_type_1_is_not_assignable_to_type_2_2603","Property '{0}' in type '{1}' is not assignable to type '{2}'."),JSX_element_type_0_does_not_have_any_construct_or_call_signatures:t(2604,e.DiagnosticCategory.Error,"JSX_element_type_0_does_not_have_any_construct_or_call_signatures_2604","JSX element type '{0}' does not have any construct or call signatures."),JSX_element_type_0_is_not_a_constructor_function_for_JSX_elements:t(2605,e.DiagnosticCategory.Error,"JSX_element_type_0_is_not_a_constructor_function_for_JSX_elements_2605","JSX element type '{0}' is not a constructor function for JSX elements."),Property_0_of_JSX_spread_attribute_is_not_assignable_to_target_property:t(2606,e.DiagnosticCategory.Error,"Property_0_of_JSX_spread_attribute_is_not_assignable_to_target_property_2606","Property '{0}' of JSX spread attribute is not assignable to target property."),JSX_element_class_does_not_support_attributes_because_it_does_not_have_a_0_property:t(2607,e.DiagnosticCategory.Error,"JSX_element_class_does_not_support_attributes_because_it_does_not_have_a_0_property_2607","JSX element class does not support attributes because it does not have a '{0}' property."),The_global_type_JSX_0_may_not_have_more_than_one_property:t(2608,e.DiagnosticCategory.Error,"The_global_type_JSX_0_may_not_have_more_than_one_property_2608","The global type 'JSX.{0}' may not have more than one property."),JSX_spread_child_must_be_an_array_type:t(2609,e.DiagnosticCategory.Error,"JSX_spread_child_must_be_an_array_type_2609","JSX spread child must be an array type."),Cannot_augment_module_0_with_value_exports_because_it_resolves_to_a_non_module_entity:t(2649,e.DiagnosticCategory.Error,"Cannot_augment_module_0_with_value_exports_because_it_resolves_to_a_non_module_entity_2649","Cannot augment module '{0}' with value exports because it resolves to a non-module entity."),A_member_initializer_in_a_enum_declaration_cannot_reference_members_declared_after_it_including_members_defined_in_other_enums:t(2651,e.DiagnosticCategory.Error,"A_member_initializer_in_a_enum_declaration_cannot_reference_members_declared_after_it_including_memb_2651","A member initializer in a enum declaration cannot reference members declared after it, including members defined in other enums."),Merged_declaration_0_cannot_include_a_default_export_declaration_Consider_adding_a_separate_export_default_0_declaration_instead:t(2652,e.DiagnosticCategory.Error,"Merged_declaration_0_cannot_include_a_default_export_declaration_Consider_adding_a_separate_export_d_2652","Merged declaration '{0}' cannot include a default export declaration. Consider adding a separate 'export default {0}' declaration instead."),Non_abstract_class_expression_does_not_implement_inherited_abstract_member_0_from_class_1:t(2653,e.DiagnosticCategory.Error,"Non_abstract_class_expression_does_not_implement_inherited_abstract_member_0_from_class_1_2653","Non-abstract class expression does not implement inherited abstract member '{0}' from class '{1}'."),Exported_external_package_typings_file_cannot_contain_tripleslash_references_Please_contact_the_package_author_to_update_the_package_definition:t(2654,e.DiagnosticCategory.Error,"Exported_external_package_typings_file_cannot_contain_tripleslash_references_Please_contact_the_pack_2654","Exported external package typings file cannot contain tripleslash references. Please contact the package author to update the package definition."),Exported_external_package_typings_file_0_is_not_a_module_Please_contact_the_package_author_to_update_the_package_definition:t(2656,e.DiagnosticCategory.Error,"Exported_external_package_typings_file_0_is_not_a_module_Please_contact_the_package_author_to_update_2656","Exported external package typings file '{0}' is not a module. Please contact the package author to update the package definition."),JSX_expressions_must_have_one_parent_element:t(2657,e.DiagnosticCategory.Error,"JSX_expressions_must_have_one_parent_element_2657","JSX expressions must have one parent element."),Type_0_provides_no_match_for_the_signature_1:t(2658,e.DiagnosticCategory.Error,"Type_0_provides_no_match_for_the_signature_1_2658","Type '{0}' provides no match for the signature '{1}'."),super_is_only_allowed_in_members_of_object_literal_expressions_when_option_target_is_ES2015_or_higher:t(2659,e.DiagnosticCategory.Error,"super_is_only_allowed_in_members_of_object_literal_expressions_when_option_target_is_ES2015_or_highe_2659","'super' is only allowed in members of object literal expressions when option 'target' is 'ES2015' or higher."),super_can_only_be_referenced_in_members_of_derived_classes_or_object_literal_expressions:t(2660,e.DiagnosticCategory.Error,"super_can_only_be_referenced_in_members_of_derived_classes_or_object_literal_expressions_2660","'super' can only be referenced in members of derived classes or object literal expressions."),Cannot_export_0_Only_local_declarations_can_be_exported_from_a_module:t(2661,e.DiagnosticCategory.Error,"Cannot_export_0_Only_local_declarations_can_be_exported_from_a_module_2661","Cannot export '{0}'. Only local declarations can be exported from a module."),Cannot_find_name_0_Did_you_mean_the_static_member_1_0:t(2662,e.DiagnosticCategory.Error,"Cannot_find_name_0_Did_you_mean_the_static_member_1_0_2662","Cannot find name '{0}'. Did you mean the static member '{1}.{0}'?"),Cannot_find_name_0_Did_you_mean_the_instance_member_this_0:t(2663,e.DiagnosticCategory.Error,"Cannot_find_name_0_Did_you_mean_the_instance_member_this_0_2663","Cannot find name '{0}'. Did you mean the instance member 'this.{0}'?"),Invalid_module_name_in_augmentation_module_0_cannot_be_found:t(2664,e.DiagnosticCategory.Error,"Invalid_module_name_in_augmentation_module_0_cannot_be_found_2664","Invalid module name in augmentation, module '{0}' cannot be found."),Invalid_module_name_in_augmentation_Module_0_resolves_to_an_untyped_module_at_1_which_cannot_be_augmented:t(2665,e.DiagnosticCategory.Error,"Invalid_module_name_in_augmentation_Module_0_resolves_to_an_untyped_module_at_1_which_cannot_be_augm_2665","Invalid module name in augmentation. Module '{0}' resolves to an untyped module at '{1}', which cannot be augmented."),Exports_and_export_assignments_are_not_permitted_in_module_augmentations:t(2666,e.DiagnosticCategory.Error,"Exports_and_export_assignments_are_not_permitted_in_module_augmentations_2666","Exports and export assignments are not permitted in module augmentations."),Imports_are_not_permitted_in_module_augmentations_Consider_moving_them_to_the_enclosing_external_module:t(2667,e.DiagnosticCategory.Error,"Imports_are_not_permitted_in_module_augmentations_Consider_moving_them_to_the_enclosing_external_mod_2667","Imports are not permitted in module augmentations. Consider moving them to the enclosing external module."),export_modifier_cannot_be_applied_to_ambient_modules_and_module_augmentations_since_they_are_always_visible:t(2668,e.DiagnosticCategory.Error,"export_modifier_cannot_be_applied_to_ambient_modules_and_module_augmentations_since_they_are_always__2668","'export' modifier cannot be applied to ambient modules and module augmentations since they are always visible."),Augmentations_for_the_global_scope_can_only_be_directly_nested_in_external_modules_or_ambient_module_declarations:t(2669,e.DiagnosticCategory.Error,"Augmentations_for_the_global_scope_can_only_be_directly_nested_in_external_modules_or_ambient_module_2669","Augmentations for the global scope can only be directly nested in external modules or ambient module declarations."),Augmentations_for_the_global_scope_should_have_declare_modifier_unless_they_appear_in_already_ambient_context:t(2670,e.DiagnosticCategory.Error,"Augmentations_for_the_global_scope_should_have_declare_modifier_unless_they_appear_in_already_ambien_2670","Augmentations for the global scope should have 'declare' modifier unless they appear in already ambient context."),Cannot_augment_module_0_because_it_resolves_to_a_non_module_entity:t(2671,e.DiagnosticCategory.Error,"Cannot_augment_module_0_because_it_resolves_to_a_non_module_entity_2671","Cannot augment module '{0}' because it resolves to a non-module entity."),Cannot_assign_a_0_constructor_type_to_a_1_constructor_type:t(2672,e.DiagnosticCategory.Error,"Cannot_assign_a_0_constructor_type_to_a_1_constructor_type_2672","Cannot assign a '{0}' constructor type to a '{1}' constructor type."),Constructor_of_class_0_is_private_and_only_accessible_within_the_class_declaration:t(2673,e.DiagnosticCategory.Error,"Constructor_of_class_0_is_private_and_only_accessible_within_the_class_declaration_2673","Constructor of class '{0}' is private and only accessible within the class declaration."),Constructor_of_class_0_is_protected_and_only_accessible_within_the_class_declaration:t(2674,e.DiagnosticCategory.Error,"Constructor_of_class_0_is_protected_and_only_accessible_within_the_class_declaration_2674","Constructor of class '{0}' is protected and only accessible within the class declaration."),Cannot_extend_a_class_0_Class_constructor_is_marked_as_private:t(2675,e.DiagnosticCategory.Error,"Cannot_extend_a_class_0_Class_constructor_is_marked_as_private_2675","Cannot extend a class '{0}'. Class constructor is marked as private."),Accessors_must_both_be_abstract_or_non_abstract:t(2676,e.DiagnosticCategory.Error,"Accessors_must_both_be_abstract_or_non_abstract_2676","Accessors must both be abstract or non-abstract."),A_type_predicate_s_type_must_be_assignable_to_its_parameter_s_type:t(2677,e.DiagnosticCategory.Error,"A_type_predicate_s_type_must_be_assignable_to_its_parameter_s_type_2677","A type predicate's type must be assignable to its parameter's type."),Type_0_is_not_comparable_to_type_1:t(2678,e.DiagnosticCategory.Error,"Type_0_is_not_comparable_to_type_1_2678","Type '{0}' is not comparable to type '{1}'."),A_function_that_is_called_with_the_new_keyword_cannot_have_a_this_type_that_is_void:t(2679,e.DiagnosticCategory.Error,"A_function_that_is_called_with_the_new_keyword_cannot_have_a_this_type_that_is_void_2679","A function that is called with the 'new' keyword cannot have a 'this' type that is 'void'."),A_0_parameter_must_be_the_first_parameter:t(2680,e.DiagnosticCategory.Error,"A_0_parameter_must_be_the_first_parameter_2680","A '{0}' parameter must be the first parameter."),A_constructor_cannot_have_a_this_parameter:t(2681,e.DiagnosticCategory.Error,"A_constructor_cannot_have_a_this_parameter_2681","A constructor cannot have a 'this' parameter."),get_and_set_accessor_must_have_the_same_this_type:t(2682,e.DiagnosticCategory.Error,"get_and_set_accessor_must_have_the_same_this_type_2682","'get' and 'set' accessor must have the same 'this' type."),this_implicitly_has_type_any_because_it_does_not_have_a_type_annotation:t(2683,e.DiagnosticCategory.Error,"this_implicitly_has_type_any_because_it_does_not_have_a_type_annotation_2683","'this' implicitly has type 'any' because it does not have a type annotation."),The_this_context_of_type_0_is_not_assignable_to_method_s_this_of_type_1:t(2684,e.DiagnosticCategory.Error,"The_this_context_of_type_0_is_not_assignable_to_method_s_this_of_type_1_2684","The 'this' context of type '{0}' is not assignable to method's 'this' of type '{1}'."),The_this_types_of_each_signature_are_incompatible:t(2685,e.DiagnosticCategory.Error,"The_this_types_of_each_signature_are_incompatible_2685","The 'this' types of each signature are incompatible."),_0_refers_to_a_UMD_global_but_the_current_file_is_a_module_Consider_adding_an_import_instead:t(2686,e.DiagnosticCategory.Error,"_0_refers_to_a_UMD_global_but_the_current_file_is_a_module_Consider_adding_an_import_instead_2686","'{0}' refers to a UMD global, but the current file is a module. Consider adding an import instead."),All_declarations_of_0_must_have_identical_modifiers:t(2687,e.DiagnosticCategory.Error,"All_declarations_of_0_must_have_identical_modifiers_2687","All declarations of '{0}' must have identical modifiers."),Cannot_find_type_definition_file_for_0:t(2688,e.DiagnosticCategory.Error,"Cannot_find_type_definition_file_for_0_2688","Cannot find type definition file for '{0}'."),Cannot_extend_an_interface_0_Did_you_mean_implements:t(2689,e.DiagnosticCategory.Error,"Cannot_extend_an_interface_0_Did_you_mean_implements_2689","Cannot extend an interface '{0}'. Did you mean 'implements'?"),An_import_path_cannot_end_with_a_0_extension_Consider_importing_1_instead:t(2691,e.DiagnosticCategory.Error,"An_import_path_cannot_end_with_a_0_extension_Consider_importing_1_instead_2691","An import path cannot end with a '{0}' extension. Consider importing '{1}' instead."),_0_is_a_primitive_but_1_is_a_wrapper_object_Prefer_using_0_when_possible:t(2692,e.DiagnosticCategory.Error,"_0_is_a_primitive_but_1_is_a_wrapper_object_Prefer_using_0_when_possible_2692","'{0}' is a primitive, but '{1}' is a wrapper object. Prefer using '{0}' when possible."),_0_only_refers_to_a_type_but_is_being_used_as_a_value_here:t(2693,e.DiagnosticCategory.Error,"_0_only_refers_to_a_type_but_is_being_used_as_a_value_here_2693","'{0}' only refers to a type, but is being used as a value here."),Namespace_0_has_no_exported_member_1:t(2694,e.DiagnosticCategory.Error,"Namespace_0_has_no_exported_member_1_2694","Namespace '{0}' has no exported member '{1}'."),Left_side_of_comma_operator_is_unused_and_has_no_side_effects:t(2695,e.DiagnosticCategory.Error,"Left_side_of_comma_operator_is_unused_and_has_no_side_effects_2695","Left side of comma operator is unused and has no side effects."),The_Object_type_is_assignable_to_very_few_other_types_Did_you_mean_to_use_the_any_type_instead:t(2696,e.DiagnosticCategory.Error,"The_Object_type_is_assignable_to_very_few_other_types_Did_you_mean_to_use_the_any_type_instead_2696","The 'Object' type is assignable to very few other types. Did you mean to use the 'any' type instead?"),An_async_function_or_method_must_return_a_Promise_Make_sure_you_have_a_declaration_for_Promise_or_include_ES2015_in_your_lib_option:t(2697,e.DiagnosticCategory.Error,"An_async_function_or_method_must_return_a_Promise_Make_sure_you_have_a_declaration_for_Promise_or_in_2697","An async function or method must return a 'Promise'. Make sure you have a declaration for 'Promise' or include 'ES2015' in your `--lib` option."),Spread_types_may_only_be_created_from_object_types:t(2698,e.DiagnosticCategory.Error,"Spread_types_may_only_be_created_from_object_types_2698","Spread types may only be created from object types."),Static_property_0_conflicts_with_built_in_property_Function_0_of_constructor_function_1:t(2699,e.DiagnosticCategory.Error,"Static_property_0_conflicts_with_built_in_property_Function_0_of_constructor_function_1_2699","Static property '{0}' conflicts with built-in property 'Function.{0}' of constructor function '{1}'."),Rest_types_may_only_be_created_from_object_types:t(2700,e.DiagnosticCategory.Error,"Rest_types_may_only_be_created_from_object_types_2700","Rest types may only be created from object types."),The_target_of_an_object_rest_assignment_must_be_a_variable_or_a_property_access:t(2701,e.DiagnosticCategory.Error,"The_target_of_an_object_rest_assignment_must_be_a_variable_or_a_property_access_2701","The target of an object rest assignment must be a variable or a property access."),_0_only_refers_to_a_type_but_is_being_used_as_a_namespace_here:t(2702,e.DiagnosticCategory.Error,"_0_only_refers_to_a_type_but_is_being_used_as_a_namespace_here_2702","'{0}' only refers to a type, but is being used as a namespace here."),The_operand_of_a_delete_operator_must_be_a_property_reference:t(2703,e.DiagnosticCategory.Error,"The_operand_of_a_delete_operator_must_be_a_property_reference_2703","The operand of a delete operator must be a property reference."),The_operand_of_a_delete_operator_cannot_be_a_read_only_property:t(2704,e.DiagnosticCategory.Error,"The_operand_of_a_delete_operator_cannot_be_a_read_only_property_2704","The operand of a delete operator cannot be a read-only property."),An_async_function_or_method_in_ES5_SlashES3_requires_the_Promise_constructor_Make_sure_you_have_a_declaration_for_the_Promise_constructor_or_include_ES2015_in_your_lib_option:t(2705,e.DiagnosticCategory.Error,"An_async_function_or_method_in_ES5_SlashES3_requires_the_Promise_constructor_Make_sure_you_have_a_de_2705","An async function or method in ES5/ES3 requires the 'Promise' constructor.  Make sure you have a declaration for the 'Promise' constructor or include 'ES2015' in your `--lib` option."),Required_type_parameters_may_not_follow_optional_type_parameters:t(2706,e.DiagnosticCategory.Error,"Required_type_parameters_may_not_follow_optional_type_parameters_2706","Required type parameters may not follow optional type parameters."),Generic_type_0_requires_between_1_and_2_type_arguments:t(2707,e.DiagnosticCategory.Error,"Generic_type_0_requires_between_1_and_2_type_arguments_2707","Generic type '{0}' requires between {1} and {2} type arguments."),Cannot_use_namespace_0_as_a_value:t(2708,e.DiagnosticCategory.Error,"Cannot_use_namespace_0_as_a_value_2708","Cannot use namespace '{0}' as a value."),Cannot_use_namespace_0_as_a_type:t(2709,e.DiagnosticCategory.Error,"Cannot_use_namespace_0_as_a_type_2709","Cannot use namespace '{0}' as a type."),_0_are_specified_twice_The_attribute_named_0_will_be_overwritten:t(2710,e.DiagnosticCategory.Error,"_0_are_specified_twice_The_attribute_named_0_will_be_overwritten_2710","'{0}' are specified twice. The attribute named '{0}' will be overwritten."),A_dynamic_import_call_returns_a_Promise_Make_sure_you_have_a_declaration_for_Promise_or_include_ES2015_in_your_lib_option:t(2711,e.DiagnosticCategory.Error,"A_dynamic_import_call_returns_a_Promise_Make_sure_you_have_a_declaration_for_Promise_or_include_ES20_2711","A dynamic import call returns a 'Promise'. Make sure you have a declaration for 'Promise' or include 'ES2015' in your `--lib` option."),A_dynamic_import_call_in_ES5_SlashES3_requires_the_Promise_constructor_Make_sure_you_have_a_declaration_for_the_Promise_constructor_or_include_ES2015_in_your_lib_option:t(2712,e.DiagnosticCategory.Error,"A_dynamic_import_call_in_ES5_SlashES3_requires_the_Promise_constructor_Make_sure_you_have_a_declarat_2712","A dynamic import call in ES5/ES3 requires the 'Promise' constructor.  Make sure you have a declaration for the 'Promise' constructor or include 'ES2015' in your `--lib` option."),Cannot_access_0_1_because_0_is_a_type_but_not_a_namespace_Did_you_mean_to_retrieve_the_type_of_the_property_1_in_0_with_0_1:t(2713,e.DiagnosticCategory.Error,"Cannot_access_0_1_because_0_is_a_type_but_not_a_namespace_Did_you_mean_to_retrieve_the_type_of_the_p_2713","Cannot access '{0}.{1}' because '{0}' is a type, but not a namespace. Did you mean to retrieve the type of the property '{1}' in '{0}' with '{0}[\"{1}\"]'?"),The_expression_of_an_export_assignment_must_be_an_identifier_or_qualified_name_in_an_ambient_context:t(2714,e.DiagnosticCategory.Error,"The_expression_of_an_export_assignment_must_be_an_identifier_or_qualified_name_in_an_ambient_context_2714","The expression of an export assignment must be an identifier or qualified name in an ambient context."),Abstract_property_0_in_class_1_cannot_be_accessed_in_the_constructor:t(2715,e.DiagnosticCategory.Error,"Abstract_property_0_in_class_1_cannot_be_accessed_in_the_constructor_2715","Abstract property '{0}' in class '{1}' cannot be accessed in the constructor."),Type_parameter_0_has_a_circular_default:t(2716,e.DiagnosticCategory.Error,"Type_parameter_0_has_a_circular_default_2716","Type parameter '{0}' has a circular default."),Subsequent_property_declarations_must_have_the_same_type_Property_0_must_be_of_type_1_but_here_has_type_2:t(2717,e.DiagnosticCategory.Error,"Subsequent_property_declarations_must_have_the_same_type_Property_0_must_be_of_type_1_but_here_has_t_2717","Subsequent property declarations must have the same type.  Property '{0}' must be of type '{1}', but here has type '{2}'."),Duplicate_declaration_0:t(2718,e.DiagnosticCategory.Error,"Duplicate_declaration_0_2718","Duplicate declaration '{0}'."),Type_0_is_not_assignable_to_type_1_Two_different_types_with_this_name_exist_but_they_are_unrelated:t(2719,e.DiagnosticCategory.Error,"Type_0_is_not_assignable_to_type_1_Two_different_types_with_this_name_exist_but_they_are_unrelated_2719","Type '{0}' is not assignable to type '{1}'. Two different types with this name exist, but they are unrelated."),Class_0_incorrectly_implements_class_1_Did_you_mean_to_extend_1_and_inherit_its_members_as_a_subclass:t(2720,e.DiagnosticCategory.Error,"Class_0_incorrectly_implements_class_1_Did_you_mean_to_extend_1_and_inherit_its_members_as_a_subclas_2720","Class '{0}' incorrectly implements class '{1}'. Did you mean to extend '{1}' and inherit its members as a subclass?"),Cannot_invoke_an_object_which_is_possibly_null:t(2721,e.DiagnosticCategory.Error,"Cannot_invoke_an_object_which_is_possibly_null_2721","Cannot invoke an object which is possibly 'null'."),Cannot_invoke_an_object_which_is_possibly_undefined:t(2722,e.DiagnosticCategory.Error,"Cannot_invoke_an_object_which_is_possibly_undefined_2722","Cannot invoke an object which is possibly 'undefined'."),Cannot_invoke_an_object_which_is_possibly_null_or_undefined:t(2723,e.DiagnosticCategory.Error,"Cannot_invoke_an_object_which_is_possibly_null_or_undefined_2723","Cannot invoke an object which is possibly 'null' or 'undefined'."),Module_0_has_no_exported_member_1_Did_you_mean_2:t(2724,e.DiagnosticCategory.Error,"Module_0_has_no_exported_member_1_Did_you_mean_2_2724","Module '{0}' has no exported member '{1}'. Did you mean '{2}'?"),Import_declaration_0_is_using_private_name_1:t(4e3,e.DiagnosticCategory.Error,"Import_declaration_0_is_using_private_name_1_4000","Import declaration '{0}' is using private name '{1}'."),Type_parameter_0_of_exported_class_has_or_is_using_private_name_1:t(4002,e.DiagnosticCategory.Error,"Type_parameter_0_of_exported_class_has_or_is_using_private_name_1_4002","Type parameter '{0}' of exported class has or is using private name '{1}'."),Type_parameter_0_of_exported_interface_has_or_is_using_private_name_1:t(4004,e.DiagnosticCategory.Error,"Type_parameter_0_of_exported_interface_has_or_is_using_private_name_1_4004","Type parameter '{0}' of exported interface has or is using private name '{1}'."),Type_parameter_0_of_constructor_signature_from_exported_interface_has_or_is_using_private_name_1:t(4006,e.DiagnosticCategory.Error,"Type_parameter_0_of_constructor_signature_from_exported_interface_has_or_is_using_private_name_1_4006","Type parameter '{0}' of constructor signature from exported interface has or is using private name '{1}'."),Type_parameter_0_of_call_signature_from_exported_interface_has_or_is_using_private_name_1:t(4008,e.DiagnosticCategory.Error,"Type_parameter_0_of_call_signature_from_exported_interface_has_or_is_using_private_name_1_4008","Type parameter '{0}' of call signature from exported interface has or is using private name '{1}'."),Type_parameter_0_of_public_static_method_from_exported_class_has_or_is_using_private_name_1:t(4010,e.DiagnosticCategory.Error,"Type_parameter_0_of_public_static_method_from_exported_class_has_or_is_using_private_name_1_4010","Type parameter '{0}' of public static method from exported class has or is using private name '{1}'."),Type_parameter_0_of_public_method_from_exported_class_has_or_is_using_private_name_1:t(4012,e.DiagnosticCategory.Error,"Type_parameter_0_of_public_method_from_exported_class_has_or_is_using_private_name_1_4012","Type parameter '{0}' of public method from exported class has or is using private name '{1}'."),Type_parameter_0_of_method_from_exported_interface_has_or_is_using_private_name_1:t(4014,e.DiagnosticCategory.Error,"Type_parameter_0_of_method_from_exported_interface_has_or_is_using_private_name_1_4014","Type parameter '{0}' of method from exported interface has or is using private name '{1}'."),Type_parameter_0_of_exported_function_has_or_is_using_private_name_1:t(4016,e.DiagnosticCategory.Error,"Type_parameter_0_of_exported_function_has_or_is_using_private_name_1_4016","Type parameter '{0}' of exported function has or is using private name '{1}'."),Implements_clause_of_exported_class_0_has_or_is_using_private_name_1:t(4019,e.DiagnosticCategory.Error,"Implements_clause_of_exported_class_0_has_or_is_using_private_name_1_4019","Implements clause of exported class '{0}' has or is using private name '{1}'."),extends_clause_of_exported_class_0_has_or_is_using_private_name_1:t(4020,e.DiagnosticCategory.Error,"extends_clause_of_exported_class_0_has_or_is_using_private_name_1_4020","'extends' clause of exported class '{0}' has or is using private name '{1}'."),extends_clause_of_exported_interface_0_has_or_is_using_private_name_1:t(4022,e.DiagnosticCategory.Error,"extends_clause_of_exported_interface_0_has_or_is_using_private_name_1_4022","'extends' clause of exported interface '{0}' has or is using private name '{1}'."),Exported_variable_0_has_or_is_using_name_1_from_external_module_2_but_cannot_be_named:t(4023,e.DiagnosticCategory.Error,"Exported_variable_0_has_or_is_using_name_1_from_external_module_2_but_cannot_be_named_4023","Exported variable '{0}' has or is using name '{1}' from external module {2} but cannot be named."),Exported_variable_0_has_or_is_using_name_1_from_private_module_2:t(4024,e.DiagnosticCategory.Error,"Exported_variable_0_has_or_is_using_name_1_from_private_module_2_4024","Exported variable '{0}' has or is using name '{1}' from private module '{2}'."),Exported_variable_0_has_or_is_using_private_name_1:t(4025,e.DiagnosticCategory.Error,"Exported_variable_0_has_or_is_using_private_name_1_4025","Exported variable '{0}' has or is using private name '{1}'."),Public_static_property_0_of_exported_class_has_or_is_using_name_1_from_external_module_2_but_cannot_be_named:t(4026,e.DiagnosticCategory.Error,"Public_static_property_0_of_exported_class_has_or_is_using_name_1_from_external_module_2_but_cannot__4026","Public static property '{0}' of exported class has or is using name '{1}' from external module {2} but cannot be named."),Public_static_property_0_of_exported_class_has_or_is_using_name_1_from_private_module_2:t(4027,e.DiagnosticCategory.Error,"Public_static_property_0_of_exported_class_has_or_is_using_name_1_from_private_module_2_4027","Public static property '{0}' of exported class has or is using name '{1}' from private module '{2}'."),Public_static_property_0_of_exported_class_has_or_is_using_private_name_1:t(4028,e.DiagnosticCategory.Error,"Public_static_property_0_of_exported_class_has_or_is_using_private_name_1_4028","Public static property '{0}' of exported class has or is using private name '{1}'."),Public_property_0_of_exported_class_has_or_is_using_name_1_from_external_module_2_but_cannot_be_named:t(4029,e.DiagnosticCategory.Error,"Public_property_0_of_exported_class_has_or_is_using_name_1_from_external_module_2_but_cannot_be_name_4029","Public property '{0}' of exported class has or is using name '{1}' from external module {2} but cannot be named."),Public_property_0_of_exported_class_has_or_is_using_name_1_from_private_module_2:t(4030,e.DiagnosticCategory.Error,"Public_property_0_of_exported_class_has_or_is_using_name_1_from_private_module_2_4030","Public property '{0}' of exported class has or is using name '{1}' from private module '{2}'."),Public_property_0_of_exported_class_has_or_is_using_private_name_1:t(4031,e.DiagnosticCategory.Error,"Public_property_0_of_exported_class_has_or_is_using_private_name_1_4031","Public property '{0}' of exported class has or is using private name '{1}'."),Property_0_of_exported_interface_has_or_is_using_name_1_from_private_module_2:t(4032,e.DiagnosticCategory.Error,"Property_0_of_exported_interface_has_or_is_using_name_1_from_private_module_2_4032","Property '{0}' of exported interface has or is using name '{1}' from private module '{2}'."),Property_0_of_exported_interface_has_or_is_using_private_name_1:t(4033,e.DiagnosticCategory.Error,"Property_0_of_exported_interface_has_or_is_using_private_name_1_4033","Property '{0}' of exported interface has or is using private name '{1}'."),Parameter_type_of_public_static_setter_0_from_exported_class_has_or_is_using_name_1_from_private_module_2:t(4034,e.DiagnosticCategory.Error,"Parameter_type_of_public_static_setter_0_from_exported_class_has_or_is_using_name_1_from_private_mod_4034","Parameter type of public static setter '{0}' from exported class has or is using name '{1}' from private module '{2}'."),Parameter_type_of_public_static_setter_0_from_exported_class_has_or_is_using_private_name_1:t(4035,e.DiagnosticCategory.Error,"Parameter_type_of_public_static_setter_0_from_exported_class_has_or_is_using_private_name_1_4035","Parameter type of public static setter '{0}' from exported class has or is using private name '{1}'."),Parameter_type_of_public_setter_0_from_exported_class_has_or_is_using_name_1_from_private_module_2:t(4036,e.DiagnosticCategory.Error,"Parameter_type_of_public_setter_0_from_exported_class_has_or_is_using_name_1_from_private_module_2_4036","Parameter type of public setter '{0}' from exported class has or is using name '{1}' from private module '{2}'."),Parameter_type_of_public_setter_0_from_exported_class_has_or_is_using_private_name_1:t(4037,e.DiagnosticCategory.Error,"Parameter_type_of_public_setter_0_from_exported_class_has_or_is_using_private_name_1_4037","Parameter type of public setter '{0}' from exported class has or is using private name '{1}'."),Return_type_of_public_static_getter_0_from_exported_class_has_or_is_using_name_1_from_external_module_2_but_cannot_be_named:t(4038,e.DiagnosticCategory.Error,"Return_type_of_public_static_getter_0_from_exported_class_has_or_is_using_name_1_from_external_modul_4038","Return type of public static getter '{0}' from exported class has or is using name '{1}' from external module {2} but cannot be named."),Return_type_of_public_static_getter_0_from_exported_class_has_or_is_using_name_1_from_private_module_2:t(4039,e.DiagnosticCategory.Error,"Return_type_of_public_static_getter_0_from_exported_class_has_or_is_using_name_1_from_private_module_4039","Return type of public static getter '{0}' from exported class has or is using name '{1}' from private module '{2}'."),Return_type_of_public_static_getter_0_from_exported_class_has_or_is_using_private_name_1:t(4040,e.DiagnosticCategory.Error,"Return_type_of_public_static_getter_0_from_exported_class_has_or_is_using_private_name_1_4040","Return type of public static getter '{0}' from exported class has or is using private name '{1}'."),Return_type_of_public_getter_0_from_exported_class_has_or_is_using_name_1_from_external_module_2_but_cannot_be_named:t(4041,e.DiagnosticCategory.Error,"Return_type_of_public_getter_0_from_exported_class_has_or_is_using_name_1_from_external_module_2_but_4041","Return type of public getter '{0}' from exported class has or is using name '{1}' from external module {2} but cannot be named."),Return_type_of_public_getter_0_from_exported_class_has_or_is_using_name_1_from_private_module_2:t(4042,e.DiagnosticCategory.Error,"Return_type_of_public_getter_0_from_exported_class_has_or_is_using_name_1_from_private_module_2_4042","Return type of public getter '{0}' from exported class has or is using name '{1}' from private module '{2}'."),Return_type_of_public_getter_0_from_exported_class_has_or_is_using_private_name_1:t(4043,e.DiagnosticCategory.Error,"Return_type_of_public_getter_0_from_exported_class_has_or_is_using_private_name_1_4043","Return type of public getter '{0}' from exported class has or is using private name '{1}'."),Return_type_of_constructor_signature_from_exported_interface_has_or_is_using_name_0_from_private_module_1:t(4044,e.DiagnosticCategory.Error,"Return_type_of_constructor_signature_from_exported_interface_has_or_is_using_name_0_from_private_mod_4044","Return type of constructor signature from exported interface has or is using name '{0}' from private module '{1}'."),Return_type_of_constructor_signature_from_exported_interface_has_or_is_using_private_name_0:t(4045,e.DiagnosticCategory.Error,"Return_type_of_constructor_signature_from_exported_interface_has_or_is_using_private_name_0_4045","Return type of constructor signature from exported interface has or is using private name '{0}'."),Return_type_of_call_signature_from_exported_interface_has_or_is_using_name_0_from_private_module_1:t(4046,e.DiagnosticCategory.Error,"Return_type_of_call_signature_from_exported_interface_has_or_is_using_name_0_from_private_module_1_4046","Return type of call signature from exported interface has or is using name '{0}' from private module '{1}'."),Return_type_of_call_signature_from_exported_interface_has_or_is_using_private_name_0:t(4047,e.DiagnosticCategory.Error,"Return_type_of_call_signature_from_exported_interface_has_or_is_using_private_name_0_4047","Return type of call signature from exported interface has or is using private name '{0}'."),Return_type_of_index_signature_from_exported_interface_has_or_is_using_name_0_from_private_module_1:t(4048,e.DiagnosticCategory.Error,"Return_type_of_index_signature_from_exported_interface_has_or_is_using_name_0_from_private_module_1_4048","Return type of index signature from exported interface has or is using name '{0}' from private module '{1}'."),Return_type_of_index_signature_from_exported_interface_has_or_is_using_private_name_0:t(4049,e.DiagnosticCategory.Error,"Return_type_of_index_signature_from_exported_interface_has_or_is_using_private_name_0_4049","Return type of index signature from exported interface has or is using private name '{0}'."),Return_type_of_public_static_method_from_exported_class_has_or_is_using_name_0_from_external_module_1_but_cannot_be_named:t(4050,e.DiagnosticCategory.Error,"Return_type_of_public_static_method_from_exported_class_has_or_is_using_name_0_from_external_module__4050","Return type of public static method from exported class has or is using name '{0}' from external module {1} but cannot be named."),Return_type_of_public_static_method_from_exported_class_has_or_is_using_name_0_from_private_module_1:t(4051,e.DiagnosticCategory.Error,"Return_type_of_public_static_method_from_exported_class_has_or_is_using_name_0_from_private_module_1_4051","Return type of public static method from exported class has or is using name '{0}' from private module '{1}'."),Return_type_of_public_static_method_from_exported_class_has_or_is_using_private_name_0:t(4052,e.DiagnosticCategory.Error,"Return_type_of_public_static_method_from_exported_class_has_or_is_using_private_name_0_4052","Return type of public static method from exported class has or is using private name '{0}'."),Return_type_of_public_method_from_exported_class_has_or_is_using_name_0_from_external_module_1_but_cannot_be_named:t(4053,e.DiagnosticCategory.Error,"Return_type_of_public_method_from_exported_class_has_or_is_using_name_0_from_external_module_1_but_c_4053","Return type of public method from exported class has or is using name '{0}' from external module {1} but cannot be named."),Return_type_of_public_method_from_exported_class_has_or_is_using_name_0_from_private_module_1:t(4054,e.DiagnosticCategory.Error,"Return_type_of_public_method_from_exported_class_has_or_is_using_name_0_from_private_module_1_4054","Return type of public method from exported class has or is using name '{0}' from private module '{1}'."),Return_type_of_public_method_from_exported_class_has_or_is_using_private_name_0:t(4055,e.DiagnosticCategory.Error,"Return_type_of_public_method_from_exported_class_has_or_is_using_private_name_0_4055","Return type of public method from exported class has or is using private name '{0}'."),Return_type_of_method_from_exported_interface_has_or_is_using_name_0_from_private_module_1:t(4056,e.DiagnosticCategory.Error,"Return_type_of_method_from_exported_interface_has_or_is_using_name_0_from_private_module_1_4056","Return type of method from exported interface has or is using name '{0}' from private module '{1}'."),Return_type_of_method_from_exported_interface_has_or_is_using_private_name_0:t(4057,e.DiagnosticCategory.Error,"Return_type_of_method_from_exported_interface_has_or_is_using_private_name_0_4057","Return type of method from exported interface has or is using private name '{0}'."),Return_type_of_exported_function_has_or_is_using_name_0_from_external_module_1_but_cannot_be_named:t(4058,e.DiagnosticCategory.Error,"Return_type_of_exported_function_has_or_is_using_name_0_from_external_module_1_but_cannot_be_named_4058","Return type of exported function has or is using name '{0}' from external module {1} but cannot be named."),Return_type_of_exported_function_has_or_is_using_name_0_from_private_module_1:t(4059,e.DiagnosticCategory.Error,"Return_type_of_exported_function_has_or_is_using_name_0_from_private_module_1_4059","Return type of exported function has or is using name '{0}' from private module '{1}'."),Return_type_of_exported_function_has_or_is_using_private_name_0:t(4060,e.DiagnosticCategory.Error,"Return_type_of_exported_function_has_or_is_using_private_name_0_4060","Return type of exported function has or is using private name '{0}'."),Parameter_0_of_constructor_from_exported_class_has_or_is_using_name_1_from_external_module_2_but_cannot_be_named:t(4061,e.DiagnosticCategory.Error,"Parameter_0_of_constructor_from_exported_class_has_or_is_using_name_1_from_external_module_2_but_can_4061","Parameter '{0}' of constructor from exported class has or is using name '{1}' from external module {2} but cannot be named."),Parameter_0_of_constructor_from_exported_class_has_or_is_using_name_1_from_private_module_2:t(4062,e.DiagnosticCategory.Error,"Parameter_0_of_constructor_from_exported_class_has_or_is_using_name_1_from_private_module_2_4062","Parameter '{0}' of constructor from exported class has or is using name '{1}' from private module '{2}'."),Parameter_0_of_constructor_from_exported_class_has_or_is_using_private_name_1:t(4063,e.DiagnosticCategory.Error,"Parameter_0_of_constructor_from_exported_class_has_or_is_using_private_name_1_4063","Parameter '{0}' of constructor from exported class has or is using private name '{1}'."),Parameter_0_of_constructor_signature_from_exported_interface_has_or_is_using_name_1_from_private_module_2:t(4064,e.DiagnosticCategory.Error,"Parameter_0_of_constructor_signature_from_exported_interface_has_or_is_using_name_1_from_private_mod_4064","Parameter '{0}' of constructor signature from exported interface has or is using name '{1}' from private module '{2}'."),Parameter_0_of_constructor_signature_from_exported_interface_has_or_is_using_private_name_1:t(4065,e.DiagnosticCategory.Error,"Parameter_0_of_constructor_signature_from_exported_interface_has_or_is_using_private_name_1_4065","Parameter '{0}' of constructor signature from exported interface has or is using private name '{1}'."),Parameter_0_of_call_signature_from_exported_interface_has_or_is_using_name_1_from_private_module_2:t(4066,e.DiagnosticCategory.Error,"Parameter_0_of_call_signature_from_exported_interface_has_or_is_using_name_1_from_private_module_2_4066","Parameter '{0}' of call signature from exported interface has or is using name '{1}' from private module '{2}'."),Parameter_0_of_call_signature_from_exported_interface_has_or_is_using_private_name_1:t(4067,e.DiagnosticCategory.Error,"Parameter_0_of_call_signature_from_exported_interface_has_or_is_using_private_name_1_4067","Parameter '{0}' of call signature from exported interface has or is using private name '{1}'."),Parameter_0_of_public_static_method_from_exported_class_has_or_is_using_name_1_from_external_module_2_but_cannot_be_named:t(4068,e.DiagnosticCategory.Error,"Parameter_0_of_public_static_method_from_exported_class_has_or_is_using_name_1_from_external_module__4068","Parameter '{0}' of public static method from exported class has or is using name '{1}' from external module {2} but cannot be named."),Parameter_0_of_public_static_method_from_exported_class_has_or_is_using_name_1_from_private_module_2:t(4069,e.DiagnosticCategory.Error,"Parameter_0_of_public_static_method_from_exported_class_has_or_is_using_name_1_from_private_module_2_4069","Parameter '{0}' of public static method from exported class has or is using name '{1}' from private module '{2}'."),Parameter_0_of_public_static_method_from_exported_class_has_or_is_using_private_name_1:t(4070,e.DiagnosticCategory.Error,"Parameter_0_of_public_static_method_from_exported_class_has_or_is_using_private_name_1_4070","Parameter '{0}' of public static method from exported class has or is using private name '{1}'."),Parameter_0_of_public_method_from_exported_class_has_or_is_using_name_1_from_external_module_2_but_cannot_be_named:t(4071,e.DiagnosticCategory.Error,"Parameter_0_of_public_method_from_exported_class_has_or_is_using_name_1_from_external_module_2_but_c_4071","Parameter '{0}' of public method from exported class has or is using name '{1}' from external module {2} but cannot be named."),Parameter_0_of_public_method_from_exported_class_has_or_is_using_name_1_from_private_module_2:t(4072,e.DiagnosticCategory.Error,"Parameter_0_of_public_method_from_exported_class_has_or_is_using_name_1_from_private_module_2_4072","Parameter '{0}' of public method from exported class has or is using name '{1}' from private module '{2}'."),Parameter_0_of_public_method_from_exported_class_has_or_is_using_private_name_1:t(4073,e.DiagnosticCategory.Error,"Parameter_0_of_public_method_from_exported_class_has_or_is_using_private_name_1_4073","Parameter '{0}' of public method from exported class has or is using private name '{1}'."),Parameter_0_of_method_from_exported_interface_has_or_is_using_name_1_from_private_module_2:t(4074,e.DiagnosticCategory.Error,"Parameter_0_of_method_from_exported_interface_has_or_is_using_name_1_from_private_module_2_4074","Parameter '{0}' of method from exported interface has or is using name '{1}' from private module '{2}'."),Parameter_0_of_method_from_exported_interface_has_or_is_using_private_name_1:t(4075,e.DiagnosticCategory.Error,"Parameter_0_of_method_from_exported_interface_has_or_is_using_private_name_1_4075","Parameter '{0}' of method from exported interface has or is using private name '{1}'."),Parameter_0_of_exported_function_has_or_is_using_name_1_from_external_module_2_but_cannot_be_named:t(4076,e.DiagnosticCategory.Error,"Parameter_0_of_exported_function_has_or_is_using_name_1_from_external_module_2_but_cannot_be_named_4076","Parameter '{0}' of exported function has or is using name '{1}' from external module {2} but cannot be named."),Parameter_0_of_exported_function_has_or_is_using_name_1_from_private_module_2:t(4077,e.DiagnosticCategory.Error,"Parameter_0_of_exported_function_has_or_is_using_name_1_from_private_module_2_4077","Parameter '{0}' of exported function has or is using name '{1}' from private module '{2}'."),Parameter_0_of_exported_function_has_or_is_using_private_name_1:t(4078,e.DiagnosticCategory.Error,"Parameter_0_of_exported_function_has_or_is_using_private_name_1_4078","Parameter '{0}' of exported function has or is using private name '{1}'."),Exported_type_alias_0_has_or_is_using_private_name_1:t(4081,e.DiagnosticCategory.Error,"Exported_type_alias_0_has_or_is_using_private_name_1_4081","Exported type alias '{0}' has or is using private name '{1}'."),Default_export_of_the_module_has_or_is_using_private_name_0:t(4082,e.DiagnosticCategory.Error,"Default_export_of_the_module_has_or_is_using_private_name_0_4082","Default export of the module has or is using private name '{0}'."),Type_parameter_0_of_exported_type_alias_has_or_is_using_private_name_1:t(4083,e.DiagnosticCategory.Error,"Type_parameter_0_of_exported_type_alias_has_or_is_using_private_name_1_4083","Type parameter '{0}' of exported type alias has or is using private name '{1}'."),Conflicting_definitions_for_0_found_at_1_and_2_Consider_installing_a_specific_version_of_this_library_to_resolve_the_conflict:t(4090,e.DiagnosticCategory.Error,"Conflicting_definitions_for_0_found_at_1_and_2_Consider_installing_a_specific_version_of_this_librar_4090","Conflicting definitions for '{0}' found at '{1}' and '{2}'. Consider installing a specific version of this library to resolve the conflict."),Parameter_0_of_index_signature_from_exported_interface_has_or_is_using_name_1_from_private_module_2:t(4091,e.DiagnosticCategory.Error,"Parameter_0_of_index_signature_from_exported_interface_has_or_is_using_name_1_from_private_module_2_4091","Parameter '{0}' of index signature from exported interface has or is using name '{1}' from private module '{2}'."),Parameter_0_of_index_signature_from_exported_interface_has_or_is_using_private_name_1:t(4092,e.DiagnosticCategory.Error,"Parameter_0_of_index_signature_from_exported_interface_has_or_is_using_private_name_1_4092","Parameter '{0}' of index signature from exported interface has or is using private name '{1}'."),Property_0_of_exported_class_expression_may_not_be_private_or_protected:t(4094,e.DiagnosticCategory.Error,"Property_0_of_exported_class_expression_may_not_be_private_or_protected_4094","Property '{0}' of exported class expression may not be private or protected."),Public_static_method_0_of_exported_class_has_or_is_using_name_1_from_external_module_2_but_cannot_be_named:t(4095,e.DiagnosticCategory.Error,"Public_static_method_0_of_exported_class_has_or_is_using_name_1_from_external_module_2_but_cannot_be_4095","Public static method '{0}' of exported class has or is using name '{1}' from external module {2} but cannot be named."),Public_static_method_0_of_exported_class_has_or_is_using_name_1_from_private_module_2:t(4096,e.DiagnosticCategory.Error,"Public_static_method_0_of_exported_class_has_or_is_using_name_1_from_private_module_2_4096","Public static method '{0}' of exported class has or is using name '{1}' from private module '{2}'."),Public_static_method_0_of_exported_class_has_or_is_using_private_name_1:t(4097,e.DiagnosticCategory.Error,"Public_static_method_0_of_exported_class_has_or_is_using_private_name_1_4097","Public static method '{0}' of exported class has or is using private name '{1}'."),Public_method_0_of_exported_class_has_or_is_using_name_1_from_external_module_2_but_cannot_be_named:t(4098,e.DiagnosticCategory.Error,"Public_method_0_of_exported_class_has_or_is_using_name_1_from_external_module_2_but_cannot_be_named_4098","Public method '{0}' of exported class has or is using name '{1}' from external module {2} but cannot be named."),Public_method_0_of_exported_class_has_or_is_using_name_1_from_private_module_2:t(4099,e.DiagnosticCategory.Error,"Public_method_0_of_exported_class_has_or_is_using_name_1_from_private_module_2_4099","Public method '{0}' of exported class has or is using name '{1}' from private module '{2}'."),Public_method_0_of_exported_class_has_or_is_using_private_name_1:t(4100,e.DiagnosticCategory.Error,"Public_method_0_of_exported_class_has_or_is_using_private_name_1_4100","Public method '{0}' of exported class has or is using private name '{1}'."),Method_0_of_exported_interface_has_or_is_using_name_1_from_private_module_2:t(4101,e.DiagnosticCategory.Error,"Method_0_of_exported_interface_has_or_is_using_name_1_from_private_module_2_4101","Method '{0}' of exported interface has or is using name '{1}' from private module '{2}'."),Method_0_of_exported_interface_has_or_is_using_private_name_1:t(4102,e.DiagnosticCategory.Error,"Method_0_of_exported_interface_has_or_is_using_private_name_1_4102","Method '{0}' of exported interface has or is using private name '{1}'."),The_current_host_does_not_support_the_0_option:t(5001,e.DiagnosticCategory.Error,"The_current_host_does_not_support_the_0_option_5001","The current host does not support the '{0}' option."),Cannot_find_the_common_subdirectory_path_for_the_input_files:t(5009,e.DiagnosticCategory.Error,"Cannot_find_the_common_subdirectory_path_for_the_input_files_5009","Cannot find the common subdirectory path for the input files."),File_specification_cannot_end_in_a_recursive_directory_wildcard_Asterisk_Asterisk_Colon_0:t(5010,e.DiagnosticCategory.Error,"File_specification_cannot_end_in_a_recursive_directory_wildcard_Asterisk_Asterisk_Colon_0_5010","File specification cannot end in a recursive directory wildcard ('**'): '{0}'."),Cannot_read_file_0_Colon_1:t(5012,e.DiagnosticCategory.Error,"Cannot_read_file_0_Colon_1_5012","Cannot read file '{0}': {1}."),Failed_to_parse_file_0_Colon_1:t(5014,e.DiagnosticCategory.Error,"Failed_to_parse_file_0_Colon_1_5014","Failed to parse file '{0}': {1}."),Unknown_compiler_option_0:t(5023,e.DiagnosticCategory.Error,"Unknown_compiler_option_0_5023","Unknown compiler option '{0}'."),Compiler_option_0_requires_a_value_of_type_1:t(5024,e.DiagnosticCategory.Error,"Compiler_option_0_requires_a_value_of_type_1_5024","Compiler option '{0}' requires a value of type {1}."),Could_not_write_file_0_Colon_1:t(5033,e.DiagnosticCategory.Error,"Could_not_write_file_0_Colon_1_5033","Could not write file '{0}': {1}."),Option_project_cannot_be_mixed_with_source_files_on_a_command_line:t(5042,e.DiagnosticCategory.Error,"Option_project_cannot_be_mixed_with_source_files_on_a_command_line_5042","Option 'project' cannot be mixed with source files on a command line."),Option_isolatedModules_can_only_be_used_when_either_option_module_is_provided_or_option_target_is_ES2015_or_higher:t(5047,e.DiagnosticCategory.Error,"Option_isolatedModules_can_only_be_used_when_either_option_module_is_provided_or_option_target_is_ES_5047","Option 'isolatedModules' can only be used when either option '--module' is provided or option 'target' is 'ES2015' or higher."),Option_0_can_only_be_used_when_either_option_inlineSourceMap_or_option_sourceMap_is_provided:t(5051,e.DiagnosticCategory.Error,"Option_0_can_only_be_used_when_either_option_inlineSourceMap_or_option_sourceMap_is_provided_5051","Option '{0} can only be used when either option '--inlineSourceMap' or option '--sourceMap' is provided."),Option_0_cannot_be_specified_without_specifying_option_1:t(5052,e.DiagnosticCategory.Error,"Option_0_cannot_be_specified_without_specifying_option_1_5052","Option '{0}' cannot be specified without specifying option '{1}'."),Option_0_cannot_be_specified_with_option_1:t(5053,e.DiagnosticCategory.Error,"Option_0_cannot_be_specified_with_option_1_5053","Option '{0}' cannot be specified with option '{1}'."),A_tsconfig_json_file_is_already_defined_at_Colon_0:t(5054,e.DiagnosticCategory.Error,"A_tsconfig_json_file_is_already_defined_at_Colon_0_5054","A 'tsconfig.json' file is already defined at: '{0}'."),Cannot_write_file_0_because_it_would_overwrite_input_file:t(5055,e.DiagnosticCategory.Error,"Cannot_write_file_0_because_it_would_overwrite_input_file_5055","Cannot write file '{0}' because it would overwrite input file."),Cannot_write_file_0_because_it_would_be_overwritten_by_multiple_input_files:t(5056,e.DiagnosticCategory.Error,"Cannot_write_file_0_because_it_would_be_overwritten_by_multiple_input_files_5056","Cannot write file '{0}' because it would be overwritten by multiple input files."),Cannot_find_a_tsconfig_json_file_at_the_specified_directory_Colon_0:t(5057,e.DiagnosticCategory.Error,"Cannot_find_a_tsconfig_json_file_at_the_specified_directory_Colon_0_5057","Cannot find a tsconfig.json file at the specified directory: '{0}'."),The_specified_path_does_not_exist_Colon_0:t(5058,e.DiagnosticCategory.Error,"The_specified_path_does_not_exist_Colon_0_5058","The specified path does not exist: '{0}'."),Invalid_value_for_reactNamespace_0_is_not_a_valid_identifier:t(5059,e.DiagnosticCategory.Error,"Invalid_value_for_reactNamespace_0_is_not_a_valid_identifier_5059","Invalid value for '--reactNamespace'. '{0}' is not a valid identifier."),Option_paths_cannot_be_used_without_specifying_baseUrl_option:t(5060,e.DiagnosticCategory.Error,"Option_paths_cannot_be_used_without_specifying_baseUrl_option_5060","Option 'paths' cannot be used without specifying '--baseUrl' option."),Pattern_0_can_have_at_most_one_Asterisk_character:t(5061,e.DiagnosticCategory.Error,"Pattern_0_can_have_at_most_one_Asterisk_character_5061","Pattern '{0}' can have at most one '*' character."),Substitution_0_in_pattern_1_in_can_have_at_most_one_Asterisk_character:t(5062,e.DiagnosticCategory.Error,"Substitution_0_in_pattern_1_in_can_have_at_most_one_Asterisk_character_5062","Substitution '{0}' in pattern '{1}' in can have at most one '*' character."),Substitutions_for_pattern_0_should_be_an_array:t(5063,e.DiagnosticCategory.Error,"Substitutions_for_pattern_0_should_be_an_array_5063","Substitutions for pattern '{0}' should be an array."),Substitution_0_for_pattern_1_has_incorrect_type_expected_string_got_2:t(5064,e.DiagnosticCategory.Error,"Substitution_0_for_pattern_1_has_incorrect_type_expected_string_got_2_5064","Substitution '{0}' for pattern '{1}' has incorrect type, expected 'string', got '{2}'."),File_specification_cannot_contain_a_parent_directory_that_appears_after_a_recursive_directory_wildcard_Asterisk_Asterisk_Colon_0:t(5065,e.DiagnosticCategory.Error,"File_specification_cannot_contain_a_parent_directory_that_appears_after_a_recursive_directory_wildca_5065","File specification cannot contain a parent directory ('..') that appears after a recursive directory wildcard ('**'): '{0}'."),Substitutions_for_pattern_0_shouldn_t_be_an_empty_array:t(5066,e.DiagnosticCategory.Error,"Substitutions_for_pattern_0_shouldn_t_be_an_empty_array_5066","Substitutions for pattern '{0}' shouldn't be an empty array."),Invalid_value_for_jsxFactory_0_is_not_a_valid_identifier_or_qualified_name:t(5067,e.DiagnosticCategory.Error,"Invalid_value_for_jsxFactory_0_is_not_a_valid_identifier_or_qualified_name_5067","Invalid value for 'jsxFactory'. '{0}' is not a valid identifier or qualified-name."),Adding_a_tsconfig_json_file_will_help_organize_projects_that_contain_both_TypeScript_and_JavaScript_files_Learn_more_at_https_Colon_Slash_Slashaka_ms_Slashtsconfig:t(5068,e.DiagnosticCategory.Error,"Adding_a_tsconfig_json_file_will_help_organize_projects_that_contain_both_TypeScript_and_JavaScript__5068","Adding a tsconfig.json file will help organize projects that contain both TypeScript and JavaScript files. Learn more at https://aka.ms/tsconfig."),Concatenate_and_emit_output_to_single_file:t(6001,e.DiagnosticCategory.Message,"Concatenate_and_emit_output_to_single_file_6001","Concatenate and emit output to single file."),Generates_corresponding_d_ts_file:t(6002,e.DiagnosticCategory.Message,"Generates_corresponding_d_ts_file_6002","Generates corresponding '.d.ts' file."),Specify_the_location_where_debugger_should_locate_map_files_instead_of_generated_locations:t(6003,e.DiagnosticCategory.Message,"Specify_the_location_where_debugger_should_locate_map_files_instead_of_generated_locations_6003","Specify the location where debugger should locate map files instead of generated locations."),Specify_the_location_where_debugger_should_locate_TypeScript_files_instead_of_source_locations:t(6004,e.DiagnosticCategory.Message,"Specify_the_location_where_debugger_should_locate_TypeScript_files_instead_of_source_locations_6004","Specify the location where debugger should locate TypeScript files instead of source locations."),Watch_input_files:t(6005,e.DiagnosticCategory.Message,"Watch_input_files_6005","Watch input files."),Redirect_output_structure_to_the_directory:t(6006,e.DiagnosticCategory.Message,"Redirect_output_structure_to_the_directory_6006","Redirect output structure to the directory."),Do_not_erase_const_enum_declarations_in_generated_code:t(6007,e.DiagnosticCategory.Message,"Do_not_erase_const_enum_declarations_in_generated_code_6007","Do not erase const enum declarations in generated code."),Do_not_emit_outputs_if_any_errors_were_reported:t(6008,e.DiagnosticCategory.Message,"Do_not_emit_outputs_if_any_errors_were_reported_6008","Do not emit outputs if any errors were reported."),Do_not_emit_comments_to_output:t(6009,e.DiagnosticCategory.Message,"Do_not_emit_comments_to_output_6009","Do not emit comments to output."),Do_not_emit_outputs:t(6010,e.DiagnosticCategory.Message,"Do_not_emit_outputs_6010","Do not emit outputs."),Allow_default_imports_from_modules_with_no_default_export_This_does_not_affect_code_emit_just_typechecking:t(6011,e.DiagnosticCategory.Message,"Allow_default_imports_from_modules_with_no_default_export_This_does_not_affect_code_emit_just_typech_6011","Allow default imports from modules with no default export. This does not affect code emit, just typechecking."),Skip_type_checking_of_declaration_files:t(6012,e.DiagnosticCategory.Message,"Skip_type_checking_of_declaration_files_6012","Skip type checking of declaration files."),Do_not_resolve_the_real_path_of_symlinks:t(6013,e.DiagnosticCategory.Message,"Do_not_resolve_the_real_path_of_symlinks_6013","Do not resolve the real path of symlinks."),Only_emit_d_ts_declaration_files:t(6014,e.DiagnosticCategory.Message,"Only_emit_d_ts_declaration_files_6014","Only emit '.d.ts' declaration files."),Specify_ECMAScript_target_version_Colon_ES3_default_ES5_ES2015_ES2016_ES2017_ES2018_or_ESNEXT:t(6015,e.DiagnosticCategory.Message,"Specify_ECMAScript_target_version_Colon_ES3_default_ES5_ES2015_ES2016_ES2017_ES2018_or_ESNEXT_6015","Specify ECMAScript target version: 'ES3' (default), 'ES5', 'ES2015', 'ES2016', 'ES2017','ES2018' or 'ESNEXT'."),Specify_module_code_generation_Colon_none_commonjs_amd_system_umd_es2015_or_ESNext:t(6016,e.DiagnosticCategory.Message,"Specify_module_code_generation_Colon_none_commonjs_amd_system_umd_es2015_or_ESNext_6016","Specify module code generation: 'none', 'commonjs', 'amd', 'system', 'umd', 'es2015', or 'ESNext'."),Print_this_message:t(6017,e.DiagnosticCategory.Message,"Print_this_message_6017","Print this message."),Print_the_compiler_s_version:t(6019,e.DiagnosticCategory.Message,"Print_the_compiler_s_version_6019","Print the compiler's version."),Compile_the_project_given_the_path_to_its_configuration_file_or_to_a_folder_with_a_tsconfig_json:t(6020,e.DiagnosticCategory.Message,"Compile_the_project_given_the_path_to_its_configuration_file_or_to_a_folder_with_a_tsconfig_json_6020","Compile the project given the path to its configuration file, or to a folder with a 'tsconfig.json'."),Syntax_Colon_0:t(6023,e.DiagnosticCategory.Message,"Syntax_Colon_0_6023","Syntax: {0}"),options:t(6024,e.DiagnosticCategory.Message,"options_6024","options"),file:t(6025,e.DiagnosticCategory.Message,"file_6025","file"),Examples_Colon_0:t(6026,e.DiagnosticCategory.Message,"Examples_Colon_0_6026","Examples: {0}"),Options_Colon:t(6027,e.DiagnosticCategory.Message,"Options_Colon_6027","Options:"),Version_0:t(6029,e.DiagnosticCategory.Message,"Version_0_6029","Version {0}"),Insert_command_line_options_and_files_from_a_file:t(6030,e.DiagnosticCategory.Message,"Insert_command_line_options_and_files_from_a_file_6030","Insert command line options and files from a file."),Starting_compilation_in_watch_mode:t(6031,e.DiagnosticCategory.Message,"Starting_compilation_in_watch_mode_6031","Starting compilation in watch mode..."),File_change_detected_Starting_incremental_compilation:t(6032,e.DiagnosticCategory.Message,"File_change_detected_Starting_incremental_compilation_6032","File change detected. Starting incremental compilation..."),KIND:t(6034,e.DiagnosticCategory.Message,"KIND_6034","KIND"),FILE:t(6035,e.DiagnosticCategory.Message,"FILE_6035","FILE"),VERSION:t(6036,e.DiagnosticCategory.Message,"VERSION_6036","VERSION"),LOCATION:t(6037,e.DiagnosticCategory.Message,"LOCATION_6037","LOCATION"),DIRECTORY:t(6038,e.DiagnosticCategory.Message,"DIRECTORY_6038","DIRECTORY"),STRATEGY:t(6039,e.DiagnosticCategory.Message,"STRATEGY_6039","STRATEGY"),FILE_OR_DIRECTORY:t(6040,e.DiagnosticCategory.Message,"FILE_OR_DIRECTORY_6040","FILE OR DIRECTORY"),Compilation_complete_Watching_for_file_changes:t(6042,e.DiagnosticCategory.Message,"Compilation_complete_Watching_for_file_changes_6042","Compilation complete. Watching for file changes."),Generates_corresponding_map_file:t(6043,e.DiagnosticCategory.Message,"Generates_corresponding_map_file_6043","Generates corresponding '.map' file."),Compiler_option_0_expects_an_argument:t(6044,e.DiagnosticCategory.Error,"Compiler_option_0_expects_an_argument_6044","Compiler option '{0}' expects an argument."),Unterminated_quoted_string_in_response_file_0:t(6045,e.DiagnosticCategory.Error,"Unterminated_quoted_string_in_response_file_0_6045","Unterminated quoted string in response file '{0}'."),Argument_for_0_option_must_be_Colon_1:t(6046,e.DiagnosticCategory.Error,"Argument_for_0_option_must_be_Colon_1_6046","Argument for '{0}' option must be: {1}."),Locale_must_be_of_the_form_language_or_language_territory_For_example_0_or_1:t(6048,e.DiagnosticCategory.Error,"Locale_must_be_of_the_form_language_or_language_territory_For_example_0_or_1_6048","Locale must be of the form <language> or <language>-<territory>. For example '{0}' or '{1}'."),Unsupported_locale_0:t(6049,e.DiagnosticCategory.Error,"Unsupported_locale_0_6049","Unsupported locale '{0}'."),Unable_to_open_file_0:t(6050,e.DiagnosticCategory.Error,"Unable_to_open_file_0_6050","Unable to open file '{0}'."),Corrupted_locale_file_0:t(6051,e.DiagnosticCategory.Error,"Corrupted_locale_file_0_6051","Corrupted locale file {0}."),Raise_error_on_expressions_and_declarations_with_an_implied_any_type:t(6052,e.DiagnosticCategory.Message,"Raise_error_on_expressions_and_declarations_with_an_implied_any_type_6052","Raise error on expressions and declarations with an implied 'any' type."),File_0_not_found:t(6053,e.DiagnosticCategory.Error,"File_0_not_found_6053","File '{0}' not found."),File_0_has_unsupported_extension_The_only_supported_extensions_are_1:t(6054,e.DiagnosticCategory.Error,"File_0_has_unsupported_extension_The_only_supported_extensions_are_1_6054","File '{0}' has unsupported extension. The only supported extensions are {1}."),Suppress_noImplicitAny_errors_for_indexing_objects_lacking_index_signatures:t(6055,e.DiagnosticCategory.Message,"Suppress_noImplicitAny_errors_for_indexing_objects_lacking_index_signatures_6055","Suppress noImplicitAny errors for indexing objects lacking index signatures."),Do_not_emit_declarations_for_code_that_has_an_internal_annotation:t(6056,e.DiagnosticCategory.Message,"Do_not_emit_declarations_for_code_that_has_an_internal_annotation_6056","Do not emit declarations for code that has an '@internal' annotation."),Specify_the_root_directory_of_input_files_Use_to_control_the_output_directory_structure_with_outDir:t(6058,e.DiagnosticCategory.Message,"Specify_the_root_directory_of_input_files_Use_to_control_the_output_directory_structure_with_outDir_6058","Specify the root directory of input files. Use to control the output directory structure with --outDir."),File_0_is_not_under_rootDir_1_rootDir_is_expected_to_contain_all_source_files:t(6059,e.DiagnosticCategory.Error,"File_0_is_not_under_rootDir_1_rootDir_is_expected_to_contain_all_source_files_6059","File '{0}' is not under 'rootDir' '{1}'. 'rootDir' is expected to contain all source files."),Specify_the_end_of_line_sequence_to_be_used_when_emitting_files_Colon_CRLF_dos_or_LF_unix:t(6060,e.DiagnosticCategory.Message,"Specify_the_end_of_line_sequence_to_be_used_when_emitting_files_Colon_CRLF_dos_or_LF_unix_6060","Specify the end of line sequence to be used when emitting files: 'CRLF' (dos) or 'LF' (unix)."),NEWLINE:t(6061,e.DiagnosticCategory.Message,"NEWLINE_6061","NEWLINE"),Option_0_can_only_be_specified_in_tsconfig_json_file:t(6064,e.DiagnosticCategory.Error,"Option_0_can_only_be_specified_in_tsconfig_json_file_6064","Option '{0}' can only be specified in 'tsconfig.json' file."),Enables_experimental_support_for_ES7_decorators:t(6065,e.DiagnosticCategory.Message,"Enables_experimental_support_for_ES7_decorators_6065","Enables experimental support for ES7 decorators."),Enables_experimental_support_for_emitting_type_metadata_for_decorators:t(6066,e.DiagnosticCategory.Message,"Enables_experimental_support_for_emitting_type_metadata_for_decorators_6066","Enables experimental support for emitting type metadata for decorators."),Enables_experimental_support_for_ES7_async_functions:t(6068,e.DiagnosticCategory.Message,"Enables_experimental_support_for_ES7_async_functions_6068","Enables experimental support for ES7 async functions."),Specify_module_resolution_strategy_Colon_node_Node_js_or_classic_TypeScript_pre_1_6:t(6069,e.DiagnosticCategory.Message,"Specify_module_resolution_strategy_Colon_node_Node_js_or_classic_TypeScript_pre_1_6_6069","Specify module resolution strategy: 'node' (Node.js) or 'classic' (TypeScript pre-1.6)."),Initializes_a_TypeScript_project_and_creates_a_tsconfig_json_file:t(6070,e.DiagnosticCategory.Message,"Initializes_a_TypeScript_project_and_creates_a_tsconfig_json_file_6070","Initializes a TypeScript project and creates a tsconfig.json file."),Successfully_created_a_tsconfig_json_file:t(6071,e.DiagnosticCategory.Message,"Successfully_created_a_tsconfig_json_file_6071","Successfully created a tsconfig.json file."),Suppress_excess_property_checks_for_object_literals:t(6072,e.DiagnosticCategory.Message,"Suppress_excess_property_checks_for_object_literals_6072","Suppress excess property checks for object literals."),Stylize_errors_and_messages_using_color_and_context_experimental:t(6073,e.DiagnosticCategory.Message,"Stylize_errors_and_messages_using_color_and_context_experimental_6073","Stylize errors and messages using color and context (experimental)."),Do_not_report_errors_on_unused_labels:t(6074,e.DiagnosticCategory.Message,"Do_not_report_errors_on_unused_labels_6074","Do not report errors on unused labels."),Report_error_when_not_all_code_paths_in_function_return_a_value:t(6075,e.DiagnosticCategory.Message,"Report_error_when_not_all_code_paths_in_function_return_a_value_6075","Report error when not all code paths in function return a value."),Report_errors_for_fallthrough_cases_in_switch_statement:t(6076,e.DiagnosticCategory.Message,"Report_errors_for_fallthrough_cases_in_switch_statement_6076","Report errors for fallthrough cases in switch statement."),Do_not_report_errors_on_unreachable_code:t(6077,e.DiagnosticCategory.Message,"Do_not_report_errors_on_unreachable_code_6077","Do not report errors on unreachable code."),Disallow_inconsistently_cased_references_to_the_same_file:t(6078,e.DiagnosticCategory.Message,"Disallow_inconsistently_cased_references_to_the_same_file_6078","Disallow inconsistently-cased references to the same file."),Specify_library_files_to_be_included_in_the_compilation:t(6079,e.DiagnosticCategory.Message,"Specify_library_files_to_be_included_in_the_compilation_6079","Specify library files to be included in the compilation."),Specify_JSX_code_generation_Colon_preserve_react_native_or_react:t(6080,e.DiagnosticCategory.Message,"Specify_JSX_code_generation_Colon_preserve_react_native_or_react_6080","Specify JSX code generation: 'preserve', 'react-native', or 'react'."),File_0_has_an_unsupported_extension_so_skipping_it:t(6081,e.DiagnosticCategory.Message,"File_0_has_an_unsupported_extension_so_skipping_it_6081","File '{0}' has an unsupported extension, so skipping it."),Only_amd_and_system_modules_are_supported_alongside_0:t(6082,e.DiagnosticCategory.Error,"Only_amd_and_system_modules_are_supported_alongside_0_6082","Only 'amd' and 'system' modules are supported alongside --{0}."),Base_directory_to_resolve_non_absolute_module_names:t(6083,e.DiagnosticCategory.Message,"Base_directory_to_resolve_non_absolute_module_names_6083","Base directory to resolve non-absolute module names."),Deprecated_Use_jsxFactory_instead_Specify_the_object_invoked_for_createElement_when_targeting_react_JSX_emit:t(6084,e.DiagnosticCategory.Message,"Deprecated_Use_jsxFactory_instead_Specify_the_object_invoked_for_createElement_when_targeting_react__6084","[Deprecated] Use '--jsxFactory' instead. Specify the object invoked for createElement when targeting 'react' JSX emit"),Enable_tracing_of_the_name_resolution_process:t(6085,e.DiagnosticCategory.Message,"Enable_tracing_of_the_name_resolution_process_6085","Enable tracing of the name resolution process."),Resolving_module_0_from_1:t(6086,e.DiagnosticCategory.Message,"Resolving_module_0_from_1_6086","======== Resolving module '{0}' from '{1}'. ========"),Explicitly_specified_module_resolution_kind_Colon_0:t(6087,e.DiagnosticCategory.Message,"Explicitly_specified_module_resolution_kind_Colon_0_6087","Explicitly specified module resolution kind: '{0}'."),Module_resolution_kind_is_not_specified_using_0:t(6088,e.DiagnosticCategory.Message,"Module_resolution_kind_is_not_specified_using_0_6088","Module resolution kind is not specified, using '{0}'."),Module_name_0_was_successfully_resolved_to_1:t(6089,e.DiagnosticCategory.Message,"Module_name_0_was_successfully_resolved_to_1_6089","======== Module name '{0}' was successfully resolved to '{1}'. ========"),Module_name_0_was_not_resolved:t(6090,e.DiagnosticCategory.Message,"Module_name_0_was_not_resolved_6090","======== Module name '{0}' was not resolved. ========"),paths_option_is_specified_looking_for_a_pattern_to_match_module_name_0:t(6091,e.DiagnosticCategory.Message,"paths_option_is_specified_looking_for_a_pattern_to_match_module_name_0_6091","'paths' option is specified, looking for a pattern to match module name '{0}'."),Module_name_0_matched_pattern_1:t(6092,e.DiagnosticCategory.Message,"Module_name_0_matched_pattern_1_6092","Module name '{0}', matched pattern '{1}'."),Trying_substitution_0_candidate_module_location_Colon_1:t(6093,e.DiagnosticCategory.Message,"Trying_substitution_0_candidate_module_location_Colon_1_6093","Trying substitution '{0}', candidate module location: '{1}'."),Resolving_module_name_0_relative_to_base_url_1_2:t(6094,e.DiagnosticCategory.Message,"Resolving_module_name_0_relative_to_base_url_1_2_6094","Resolving module name '{0}' relative to base url '{1}' - '{2}'."),Loading_module_as_file_Slash_folder_candidate_module_location_0_target_file_type_1:t(6095,e.DiagnosticCategory.Message,"Loading_module_as_file_Slash_folder_candidate_module_location_0_target_file_type_1_6095","Loading module as file / folder, candidate module location '{0}', target file type '{1}'."),File_0_does_not_exist:t(6096,e.DiagnosticCategory.Message,"File_0_does_not_exist_6096","File '{0}' does not exist."),File_0_exist_use_it_as_a_name_resolution_result:t(6097,e.DiagnosticCategory.Message,"File_0_exist_use_it_as_a_name_resolution_result_6097","File '{0}' exist - use it as a name resolution result."),Loading_module_0_from_node_modules_folder_target_file_type_1:t(6098,e.DiagnosticCategory.Message,"Loading_module_0_from_node_modules_folder_target_file_type_1_6098","Loading module '{0}' from 'node_modules' folder, target file type '{1}'."),Found_package_json_at_0:t(6099,e.DiagnosticCategory.Message,"Found_package_json_at_0_6099","Found 'package.json' at '{0}'."),package_json_does_not_have_a_0_field:t(6100,e.DiagnosticCategory.Message,"package_json_does_not_have_a_0_field_6100","'package.json' does not have a '{0}' field."),package_json_has_0_field_1_that_references_2:t(6101,e.DiagnosticCategory.Message,"package_json_has_0_field_1_that_references_2_6101","'package.json' has '{0}' field '{1}' that references '{2}'."),Allow_javascript_files_to_be_compiled:t(6102,e.DiagnosticCategory.Message,"Allow_javascript_files_to_be_compiled_6102","Allow javascript files to be compiled."),Option_0_should_have_array_of_strings_as_a_value:t(6103,e.DiagnosticCategory.Error,"Option_0_should_have_array_of_strings_as_a_value_6103","Option '{0}' should have array of strings as a value."),Checking_if_0_is_the_longest_matching_prefix_for_1_2:t(6104,e.DiagnosticCategory.Message,"Checking_if_0_is_the_longest_matching_prefix_for_1_2_6104","Checking if '{0}' is the longest matching prefix for '{1}' - '{2}'."),Expected_type_of_0_field_in_package_json_to_be_string_got_1:t(6105,e.DiagnosticCategory.Message,"Expected_type_of_0_field_in_package_json_to_be_string_got_1_6105","Expected type of '{0}' field in 'package.json' to be 'string', got '{1}'."),baseUrl_option_is_set_to_0_using_this_value_to_resolve_non_relative_module_name_1:t(6106,e.DiagnosticCategory.Message,"baseUrl_option_is_set_to_0_using_this_value_to_resolve_non_relative_module_name_1_6106","'baseUrl' option is set to '{0}', using this value to resolve non-relative module name '{1}'."),rootDirs_option_is_set_using_it_to_resolve_relative_module_name_0:t(6107,e.DiagnosticCategory.Message,"rootDirs_option_is_set_using_it_to_resolve_relative_module_name_0_6107","'rootDirs' option is set, using it to resolve relative module name '{0}'."),Longest_matching_prefix_for_0_is_1:t(6108,e.DiagnosticCategory.Message,"Longest_matching_prefix_for_0_is_1_6108","Longest matching prefix for '{0}' is '{1}'."),Loading_0_from_the_root_dir_1_candidate_location_2:t(6109,e.DiagnosticCategory.Message,"Loading_0_from_the_root_dir_1_candidate_location_2_6109","Loading '{0}' from the root dir '{1}', candidate location '{2}'."),Trying_other_entries_in_rootDirs:t(6110,e.DiagnosticCategory.Message,"Trying_other_entries_in_rootDirs_6110","Trying other entries in 'rootDirs'."),Module_resolution_using_rootDirs_has_failed:t(6111,e.DiagnosticCategory.Message,"Module_resolution_using_rootDirs_has_failed_6111","Module resolution using 'rootDirs' has failed."),Do_not_emit_use_strict_directives_in_module_output:t(6112,e.DiagnosticCategory.Message,"Do_not_emit_use_strict_directives_in_module_output_6112","Do not emit 'use strict' directives in module output."),Enable_strict_null_checks:t(6113,e.DiagnosticCategory.Message,"Enable_strict_null_checks_6113","Enable strict null checks."),Unknown_option_excludes_Did_you_mean_exclude:t(6114,e.DiagnosticCategory.Error,"Unknown_option_excludes_Did_you_mean_exclude_6114","Unknown option 'excludes'. Did you mean 'exclude'?"),Raise_error_on_this_expressions_with_an_implied_any_type:t(6115,e.DiagnosticCategory.Message,"Raise_error_on_this_expressions_with_an_implied_any_type_6115","Raise error on 'this' expressions with an implied 'any' type."),Resolving_type_reference_directive_0_containing_file_1_root_directory_2:t(6116,e.DiagnosticCategory.Message,"Resolving_type_reference_directive_0_containing_file_1_root_directory_2_6116","======== Resolving type reference directive '{0}', containing file '{1}', root directory '{2}'. ========"),Resolving_using_primary_search_paths:t(6117,e.DiagnosticCategory.Message,"Resolving_using_primary_search_paths_6117","Resolving using primary search paths..."),Resolving_from_node_modules_folder:t(6118,e.DiagnosticCategory.Message,"Resolving_from_node_modules_folder_6118","Resolving from node_modules folder..."),Type_reference_directive_0_was_successfully_resolved_to_1_primary_Colon_2:t(6119,e.DiagnosticCategory.Message,"Type_reference_directive_0_was_successfully_resolved_to_1_primary_Colon_2_6119","======== Type reference directive '{0}' was successfully resolved to '{1}', primary: {2}. ========"),Type_reference_directive_0_was_not_resolved:t(6120,e.DiagnosticCategory.Message,"Type_reference_directive_0_was_not_resolved_6120","======== Type reference directive '{0}' was not resolved. ========"),Resolving_with_primary_search_path_0:t(6121,e.DiagnosticCategory.Message,"Resolving_with_primary_search_path_0_6121","Resolving with primary search path '{0}'."),Root_directory_cannot_be_determined_skipping_primary_search_paths:t(6122,e.DiagnosticCategory.Message,"Root_directory_cannot_be_determined_skipping_primary_search_paths_6122","Root directory cannot be determined, skipping primary search paths."),Resolving_type_reference_directive_0_containing_file_1_root_directory_not_set:t(6123,e.DiagnosticCategory.Message,"Resolving_type_reference_directive_0_containing_file_1_root_directory_not_set_6123","======== Resolving type reference directive '{0}', containing file '{1}', root directory not set. ========"),Type_declaration_files_to_be_included_in_compilation:t(6124,e.DiagnosticCategory.Message,"Type_declaration_files_to_be_included_in_compilation_6124","Type declaration files to be included in compilation."),Looking_up_in_node_modules_folder_initial_location_0:t(6125,e.DiagnosticCategory.Message,"Looking_up_in_node_modules_folder_initial_location_0_6125","Looking up in 'node_modules' folder, initial location '{0}'."),Containing_file_is_not_specified_and_root_directory_cannot_be_determined_skipping_lookup_in_node_modules_folder:t(6126,e.DiagnosticCategory.Message,"Containing_file_is_not_specified_and_root_directory_cannot_be_determined_skipping_lookup_in_node_mod_6126","Containing file is not specified and root directory cannot be determined, skipping lookup in 'node_modules' folder."),Resolving_type_reference_directive_0_containing_file_not_set_root_directory_1:t(6127,e.DiagnosticCategory.Message,"Resolving_type_reference_directive_0_containing_file_not_set_root_directory_1_6127","======== Resolving type reference directive '{0}', containing file not set, root directory '{1}'. ========"),Resolving_type_reference_directive_0_containing_file_not_set_root_directory_not_set:t(6128,e.DiagnosticCategory.Message,"Resolving_type_reference_directive_0_containing_file_not_set_root_directory_not_set_6128","======== Resolving type reference directive '{0}', containing file not set, root directory not set. ========"),Resolving_real_path_for_0_result_1:t(6130,e.DiagnosticCategory.Message,"Resolving_real_path_for_0_result_1_6130","Resolving real path for '{0}', result '{1}'."),Cannot_compile_modules_using_option_0_unless_the_module_flag_is_amd_or_system:t(6131,e.DiagnosticCategory.Error,"Cannot_compile_modules_using_option_0_unless_the_module_flag_is_amd_or_system_6131","Cannot compile modules using option '{0}' unless the '--module' flag is 'amd' or 'system'."),File_name_0_has_a_1_extension_stripping_it:t(6132,e.DiagnosticCategory.Message,"File_name_0_has_a_1_extension_stripping_it_6132","File name '{0}' has a '{1}' extension - stripping it."),_0_is_declared_but_its_value_is_never_read:t(6133,e.DiagnosticCategory.Error,"_0_is_declared_but_its_value_is_never_read_6133","'{0}' is declared but its value is never read."),Report_errors_on_unused_locals:t(6134,e.DiagnosticCategory.Message,"Report_errors_on_unused_locals_6134","Report errors on unused locals."),Report_errors_on_unused_parameters:t(6135,e.DiagnosticCategory.Message,"Report_errors_on_unused_parameters_6135","Report errors on unused parameters."),The_maximum_dependency_depth_to_search_under_node_modules_and_load_JavaScript_files:t(6136,e.DiagnosticCategory.Message,"The_maximum_dependency_depth_to_search_under_node_modules_and_load_JavaScript_files_6136","The maximum dependency depth to search under node_modules and load JavaScript files."),Cannot_import_type_declaration_files_Consider_importing_0_instead_of_1:t(6137,e.DiagnosticCategory.Error,"Cannot_import_type_declaration_files_Consider_importing_0_instead_of_1_6137","Cannot import type declaration files. Consider importing '{0}' instead of '{1}'."),Property_0_is_declared_but_its_value_is_never_read:t(6138,e.DiagnosticCategory.Error,"Property_0_is_declared_but_its_value_is_never_read_6138","Property '{0}' is declared but its value is never read."),Import_emit_helpers_from_tslib:t(6139,e.DiagnosticCategory.Message,"Import_emit_helpers_from_tslib_6139","Import emit helpers from 'tslib'."),Auto_discovery_for_typings_is_enabled_in_project_0_Running_extra_resolution_pass_for_module_1_using_cache_location_2:t(6140,e.DiagnosticCategory.Error,"Auto_discovery_for_typings_is_enabled_in_project_0_Running_extra_resolution_pass_for_module_1_using__6140","Auto discovery for typings is enabled in project '{0}'. Running extra resolution pass for module '{1}' using cache location '{2}'."),Parse_in_strict_mode_and_emit_use_strict_for_each_source_file:t(6141,e.DiagnosticCategory.Message,"Parse_in_strict_mode_and_emit_use_strict_for_each_source_file_6141",'Parse in strict mode and emit "use strict" for each source file.'),Module_0_was_resolved_to_1_but_jsx_is_not_set:t(6142,e.DiagnosticCategory.Error,"Module_0_was_resolved_to_1_but_jsx_is_not_set_6142","Module '{0}' was resolved to '{1}', but '--jsx' is not set."),Module_0_was_resolved_as_locally_declared_ambient_module_in_file_1:t(6144,e.DiagnosticCategory.Message,"Module_0_was_resolved_as_locally_declared_ambient_module_in_file_1_6144","Module '{0}' was resolved as locally declared ambient module in file '{1}'."),Module_0_was_resolved_as_ambient_module_declared_in_1_since_this_file_was_not_modified:t(6145,e.DiagnosticCategory.Message,"Module_0_was_resolved_as_ambient_module_declared_in_1_since_this_file_was_not_modified_6145","Module '{0}' was resolved as ambient module declared in '{1}' since this file was not modified."),Specify_the_JSX_factory_function_to_use_when_targeting_react_JSX_emit_e_g_React_createElement_or_h:t(6146,e.DiagnosticCategory.Message,"Specify_the_JSX_factory_function_to_use_when_targeting_react_JSX_emit_e_g_React_createElement_or_h_6146","Specify the JSX factory function to use when targeting 'react' JSX emit, e.g. 'React.createElement' or 'h'."),Resolution_for_module_0_was_found_in_cache_from_location_1:t(6147,e.DiagnosticCategory.Message,"Resolution_for_module_0_was_found_in_cache_from_location_1_6147","Resolution for module '{0}' was found in cache from location '{1}'."),Directory_0_does_not_exist_skipping_all_lookups_in_it:t(6148,e.DiagnosticCategory.Message,"Directory_0_does_not_exist_skipping_all_lookups_in_it_6148","Directory '{0}' does not exist, skipping all lookups in it."),Show_diagnostic_information:t(6149,e.DiagnosticCategory.Message,"Show_diagnostic_information_6149","Show diagnostic information."),Show_verbose_diagnostic_information:t(6150,e.DiagnosticCategory.Message,"Show_verbose_diagnostic_information_6150","Show verbose diagnostic information."),Emit_a_single_file_with_source_maps_instead_of_having_a_separate_file:t(6151,e.DiagnosticCategory.Message,"Emit_a_single_file_with_source_maps_instead_of_having_a_separate_file_6151","Emit a single file with source maps instead of having a separate file."),Emit_the_source_alongside_the_sourcemaps_within_a_single_file_requires_inlineSourceMap_or_sourceMap_to_be_set:t(6152,e.DiagnosticCategory.Message,"Emit_the_source_alongside_the_sourcemaps_within_a_single_file_requires_inlineSourceMap_or_sourceMap__6152","Emit the source alongside the sourcemaps within a single file; requires '--inlineSourceMap' or '--sourceMap' to be set."),Transpile_each_file_as_a_separate_module_similar_to_ts_transpileModule:t(6153,e.DiagnosticCategory.Message,"Transpile_each_file_as_a_separate_module_similar_to_ts_transpileModule_6153","Transpile each file as a separate module (similar to 'ts.transpileModule')."),Print_names_of_generated_files_part_of_the_compilation:t(6154,e.DiagnosticCategory.Message,"Print_names_of_generated_files_part_of_the_compilation_6154","Print names of generated files part of the compilation."),Print_names_of_files_part_of_the_compilation:t(6155,e.DiagnosticCategory.Message,"Print_names_of_files_part_of_the_compilation_6155","Print names of files part of the compilation."),The_locale_used_when_displaying_messages_to_the_user_e_g_en_us:t(6156,e.DiagnosticCategory.Message,"The_locale_used_when_displaying_messages_to_the_user_e_g_en_us_6156","The locale used when displaying messages to the user (e.g. 'en-us')"),Do_not_generate_custom_helper_functions_like_extends_in_compiled_output:t(6157,e.DiagnosticCategory.Message,"Do_not_generate_custom_helper_functions_like_extends_in_compiled_output_6157","Do not generate custom helper functions like '__extends' in compiled output."),Do_not_include_the_default_library_file_lib_d_ts:t(6158,e.DiagnosticCategory.Message,"Do_not_include_the_default_library_file_lib_d_ts_6158","Do not include the default library file (lib.d.ts)."),Do_not_add_triple_slash_references_or_imported_modules_to_the_list_of_compiled_files:t(6159,e.DiagnosticCategory.Message,"Do_not_add_triple_slash_references_or_imported_modules_to_the_list_of_compiled_files_6159","Do not add triple-slash references or imported modules to the list of compiled files."),Deprecated_Use_skipLibCheck_instead_Skip_type_checking_of_default_library_declaration_files:t(6160,e.DiagnosticCategory.Message,"Deprecated_Use_skipLibCheck_instead_Skip_type_checking_of_default_library_declaration_files_6160","[Deprecated] Use '--skipLibCheck' instead. Skip type checking of default library declaration files."),List_of_folders_to_include_type_definitions_from:t(6161,e.DiagnosticCategory.Message,"List_of_folders_to_include_type_definitions_from_6161","List of folders to include type definitions from."),Disable_size_limitations_on_JavaScript_projects:t(6162,e.DiagnosticCategory.Message,"Disable_size_limitations_on_JavaScript_projects_6162","Disable size limitations on JavaScript projects."),The_character_set_of_the_input_files:t(6163,e.DiagnosticCategory.Message,"The_character_set_of_the_input_files_6163","The character set of the input files."),Emit_a_UTF_8_Byte_Order_Mark_BOM_in_the_beginning_of_output_files:t(6164,e.DiagnosticCategory.Message,"Emit_a_UTF_8_Byte_Order_Mark_BOM_in_the_beginning_of_output_files_6164","Emit a UTF-8 Byte Order Mark (BOM) in the beginning of output files."),Do_not_truncate_error_messages:t(6165,e.DiagnosticCategory.Message,"Do_not_truncate_error_messages_6165","Do not truncate error messages."),Output_directory_for_generated_declaration_files:t(6166,e.DiagnosticCategory.Message,"Output_directory_for_generated_declaration_files_6166","Output directory for generated declaration files."),A_series_of_entries_which_re_map_imports_to_lookup_locations_relative_to_the_baseUrl:t(6167,e.DiagnosticCategory.Message,"A_series_of_entries_which_re_map_imports_to_lookup_locations_relative_to_the_baseUrl_6167","A series of entries which re-map imports to lookup locations relative to the 'baseUrl'."),List_of_root_folders_whose_combined_content_represents_the_structure_of_the_project_at_runtime:t(6168,e.DiagnosticCategory.Message,"List_of_root_folders_whose_combined_content_represents_the_structure_of_the_project_at_runtime_6168","List of root folders whose combined content represents the structure of the project at runtime."),Show_all_compiler_options:t(6169,e.DiagnosticCategory.Message,"Show_all_compiler_options_6169","Show all compiler options."),Deprecated_Use_outFile_instead_Concatenate_and_emit_output_to_single_file:t(6170,e.DiagnosticCategory.Message,"Deprecated_Use_outFile_instead_Concatenate_and_emit_output_to_single_file_6170","[Deprecated] Use '--outFile' instead. Concatenate and emit output to single file"),Command_line_Options:t(6171,e.DiagnosticCategory.Message,"Command_line_Options_6171","Command-line Options"),Basic_Options:t(6172,e.DiagnosticCategory.Message,"Basic_Options_6172","Basic Options"),Strict_Type_Checking_Options:t(6173,e.DiagnosticCategory.Message,"Strict_Type_Checking_Options_6173","Strict Type-Checking Options"),Module_Resolution_Options:t(6174,e.DiagnosticCategory.Message,"Module_Resolution_Options_6174","Module Resolution Options"),Source_Map_Options:t(6175,e.DiagnosticCategory.Message,"Source_Map_Options_6175","Source Map Options"),Additional_Checks:t(6176,e.DiagnosticCategory.Message,"Additional_Checks_6176","Additional Checks"),Experimental_Options:t(6177,e.DiagnosticCategory.Message,"Experimental_Options_6177","Experimental Options"),Advanced_Options:t(6178,e.DiagnosticCategory.Message,"Advanced_Options_6178","Advanced Options"),Provide_full_support_for_iterables_in_for_of_spread_and_destructuring_when_targeting_ES5_or_ES3:t(6179,e.DiagnosticCategory.Message,"Provide_full_support_for_iterables_in_for_of_spread_and_destructuring_when_targeting_ES5_or_ES3_6179","Provide full support for iterables in 'for-of', spread, and destructuring when targeting 'ES5' or 'ES3'."),Enable_all_strict_type_checking_options:t(6180,e.DiagnosticCategory.Message,"Enable_all_strict_type_checking_options_6180","Enable all strict type-checking options."),List_of_language_service_plugins:t(6181,e.DiagnosticCategory.Message,"List_of_language_service_plugins_6181","List of language service plugins."),Scoped_package_detected_looking_in_0:t(6182,e.DiagnosticCategory.Message,"Scoped_package_detected_looking_in_0_6182","Scoped package detected, looking in '{0}'"),Reusing_resolution_of_module_0_to_file_1_from_old_program:t(6183,e.DiagnosticCategory.Message,"Reusing_resolution_of_module_0_to_file_1_from_old_program_6183","Reusing resolution of module '{0}' to file '{1}' from old program."),Reusing_module_resolutions_originating_in_0_since_resolutions_are_unchanged_from_old_program:t(6184,e.DiagnosticCategory.Message,"Reusing_module_resolutions_originating_in_0_since_resolutions_are_unchanged_from_old_program_6184","Reusing module resolutions originating in '{0}' since resolutions are unchanged from old program."),Disable_strict_checking_of_generic_signatures_in_function_types:t(6185,e.DiagnosticCategory.Message,"Disable_strict_checking_of_generic_signatures_in_function_types_6185","Disable strict checking of generic signatures in function types."),Enable_strict_checking_of_function_types:t(6186,e.DiagnosticCategory.Message,"Enable_strict_checking_of_function_types_6186","Enable strict checking of function types."),Enable_strict_checking_of_property_initialization_in_classes:t(6187,e.DiagnosticCategory.Message,"Enable_strict_checking_of_property_initialization_in_classes_6187","Enable strict checking of property initialization in classes."),Numeric_separators_are_not_allowed_here:t(6188,e.DiagnosticCategory.Error,"Numeric_separators_are_not_allowed_here_6188","Numeric separators are not allowed here."),Multiple_consecutive_numeric_separators_are_not_permitted:t(6189,e.DiagnosticCategory.Error,"Multiple_consecutive_numeric_separators_are_not_permitted_6189","Multiple consecutive numeric separators are not permitted."),Found_package_json_at_0_Package_ID_is_1:t(6190,e.DiagnosticCategory.Message,"Found_package_json_at_0_Package_ID_is_1_6190","Found 'package.json' at '{0}'. Package ID is '{1}'."),Whether_to_keep_outdated_console_output_in_watch_mode_instead_of_clearing_the_screen:t(6191,e.DiagnosticCategory.Message,"Whether_to_keep_outdated_console_output_in_watch_mode_instead_of_clearing_the_screen_6191","Whether to keep outdated console output in watch mode instead of clearing the screen."),All_imports_in_import_declaration_are_unused:t(6192,e.DiagnosticCategory.Error,"All_imports_in_import_declaration_are_unused_6192","All imports in import declaration are unused."),Variable_0_implicitly_has_an_1_type:t(7005,e.DiagnosticCategory.Error,"Variable_0_implicitly_has_an_1_type_7005","Variable '{0}' implicitly has an '{1}' type."),Parameter_0_implicitly_has_an_1_type:t(7006,e.DiagnosticCategory.Error,"Parameter_0_implicitly_has_an_1_type_7006","Parameter '{0}' implicitly has an '{1}' type."),Member_0_implicitly_has_an_1_type:t(7008,e.DiagnosticCategory.Error,"Member_0_implicitly_has_an_1_type_7008","Member '{0}' implicitly has an '{1}' type."),new_expression_whose_target_lacks_a_construct_signature_implicitly_has_an_any_type:t(7009,e.DiagnosticCategory.Error,"new_expression_whose_target_lacks_a_construct_signature_implicitly_has_an_any_type_7009","'new' expression, whose target lacks a construct signature, implicitly has an 'any' type."),_0_which_lacks_return_type_annotation_implicitly_has_an_1_return_type:t(7010,e.DiagnosticCategory.Error,"_0_which_lacks_return_type_annotation_implicitly_has_an_1_return_type_7010","'{0}', which lacks return-type annotation, implicitly has an '{1}' return type."),Function_expression_which_lacks_return_type_annotation_implicitly_has_an_0_return_type:t(7011,e.DiagnosticCategory.Error,"Function_expression_which_lacks_return_type_annotation_implicitly_has_an_0_return_type_7011","Function expression, which lacks return-type annotation, implicitly has an '{0}' return type."),Construct_signature_which_lacks_return_type_annotation_implicitly_has_an_any_return_type:t(7013,e.DiagnosticCategory.Error,"Construct_signature_which_lacks_return_type_annotation_implicitly_has_an_any_return_type_7013","Construct signature, which lacks return-type annotation, implicitly has an 'any' return type."),Element_implicitly_has_an_any_type_because_index_expression_is_not_of_type_number:t(7015,e.DiagnosticCategory.Error,"Element_implicitly_has_an_any_type_because_index_expression_is_not_of_type_number_7015","Element implicitly has an 'any' type because index expression is not of type 'number'."),Could_not_find_a_declaration_file_for_module_0_1_implicitly_has_an_any_type:t(7016,e.DiagnosticCategory.Error,"Could_not_find_a_declaration_file_for_module_0_1_implicitly_has_an_any_type_7016","Could not find a declaration file for module '{0}'. '{1}' implicitly has an 'any' type."),Element_implicitly_has_an_any_type_because_type_0_has_no_index_signature:t(7017,e.DiagnosticCategory.Error,"Element_implicitly_has_an_any_type_because_type_0_has_no_index_signature_7017","Element implicitly has an 'any' type because type '{0}' has no index signature."),Object_literal_s_property_0_implicitly_has_an_1_type:t(7018,e.DiagnosticCategory.Error,"Object_literal_s_property_0_implicitly_has_an_1_type_7018","Object literal's property '{0}' implicitly has an '{1}' type."),Rest_parameter_0_implicitly_has_an_any_type:t(7019,e.DiagnosticCategory.Error,"Rest_parameter_0_implicitly_has_an_any_type_7019","Rest parameter '{0}' implicitly has an 'any[]' type."),Call_signature_which_lacks_return_type_annotation_implicitly_has_an_any_return_type:t(7020,e.DiagnosticCategory.Error,"Call_signature_which_lacks_return_type_annotation_implicitly_has_an_any_return_type_7020","Call signature, which lacks return-type annotation, implicitly has an 'any' return type."),_0_implicitly_has_type_any_because_it_does_not_have_a_type_annotation_and_is_referenced_directly_or_indirectly_in_its_own_initializer:t(7022,e.DiagnosticCategory.Error,"_0_implicitly_has_type_any_because_it_does_not_have_a_type_annotation_and_is_referenced_directly_or__7022","'{0}' implicitly has type 'any' because it does not have a type annotation and is referenced directly or indirectly in its own initializer."),_0_implicitly_has_return_type_any_because_it_does_not_have_a_return_type_annotation_and_is_referenced_directly_or_indirectly_in_one_of_its_return_expressions:t(7023,e.DiagnosticCategory.Error,"_0_implicitly_has_return_type_any_because_it_does_not_have_a_return_type_annotation_and_is_reference_7023","'{0}' implicitly has return type 'any' because it does not have a return type annotation and is referenced directly or indirectly in one of its return expressions."),Function_implicitly_has_return_type_any_because_it_does_not_have_a_return_type_annotation_and_is_referenced_directly_or_indirectly_in_one_of_its_return_expressions:t(7024,e.DiagnosticCategory.Error,"Function_implicitly_has_return_type_any_because_it_does_not_have_a_return_type_annotation_and_is_ref_7024","Function implicitly has return type 'any' because it does not have a return type annotation and is referenced directly or indirectly in one of its return expressions."),Generator_implicitly_has_type_0_because_it_does_not_yield_any_values_Consider_supplying_a_return_type:t(7025,e.DiagnosticCategory.Error,"Generator_implicitly_has_type_0_because_it_does_not_yield_any_values_Consider_supplying_a_return_typ_7025","Generator implicitly has type '{0}' because it does not yield any values. Consider supplying a return type."),JSX_element_implicitly_has_type_any_because_no_interface_JSX_0_exists:t(7026,e.DiagnosticCategory.Error,"JSX_element_implicitly_has_type_any_because_no_interface_JSX_0_exists_7026","JSX element implicitly has type 'any' because no interface 'JSX.{0}' exists."),Unreachable_code_detected:t(7027,e.DiagnosticCategory.Error,"Unreachable_code_detected_7027","Unreachable code detected."),Unused_label:t(7028,e.DiagnosticCategory.Error,"Unused_label_7028","Unused label."),Fallthrough_case_in_switch:t(7029,e.DiagnosticCategory.Error,"Fallthrough_case_in_switch_7029","Fallthrough case in switch."),Not_all_code_paths_return_a_value:t(7030,e.DiagnosticCategory.Error,"Not_all_code_paths_return_a_value_7030","Not all code paths return a value."),Binding_element_0_implicitly_has_an_1_type:t(7031,e.DiagnosticCategory.Error,"Binding_element_0_implicitly_has_an_1_type_7031","Binding element '{0}' implicitly has an '{1}' type."),Property_0_implicitly_has_type_any_because_its_set_accessor_lacks_a_parameter_type_annotation:t(7032,e.DiagnosticCategory.Error,"Property_0_implicitly_has_type_any_because_its_set_accessor_lacks_a_parameter_type_annotation_7032","Property '{0}' implicitly has type 'any', because its set accessor lacks a parameter type annotation."),Property_0_implicitly_has_type_any_because_its_get_accessor_lacks_a_return_type_annotation:t(7033,e.DiagnosticCategory.Error,"Property_0_implicitly_has_type_any_because_its_get_accessor_lacks_a_return_type_annotation_7033","Property '{0}' implicitly has type 'any', because its get accessor lacks a return type annotation."),Variable_0_implicitly_has_type_1_in_some_locations_where_its_type_cannot_be_determined:t(7034,e.DiagnosticCategory.Error,"Variable_0_implicitly_has_type_1_in_some_locations_where_its_type_cannot_be_determined_7034","Variable '{0}' implicitly has type '{1}' in some locations where its type cannot be determined."),Try_npm_install_types_Slash_0_if_it_exists_or_add_a_new_declaration_d_ts_file_containing_declare_module_0:t(7035,e.DiagnosticCategory.Error,"Try_npm_install_types_Slash_0_if_it_exists_or_add_a_new_declaration_d_ts_file_containing_declare_mod_7035","Try `npm install @types/{0}` if it exists or add a new declaration (.d.ts) file containing `declare module '{0}';`"),Dynamic_import_s_specifier_must_be_of_type_string_but_here_has_type_0:t(7036,e.DiagnosticCategory.Error,"Dynamic_import_s_specifier_must_be_of_type_string_but_here_has_type_0_7036","Dynamic import's specifier must be of type 'string', but here has type '{0}'."),Enables_emit_interoperability_between_CommonJS_and_ES_Modules_via_creation_of_namespace_objects_for_all_imports_Implies_allowSyntheticDefaultImports:t(7037,e.DiagnosticCategory.Message,"Enables_emit_interoperability_between_CommonJS_and_ES_Modules_via_creation_of_namespace_objects_for__7037","Enables emit interoperability between CommonJS and ES Modules via creation of namespace objects for all imports. Implies 'allowSyntheticDefaultImports'."),A_namespace_style_import_cannot_be_called_or_constructed_and_will_cause_a_failure_at_runtime:t(7038,e.DiagnosticCategory.Error,"A_namespace_style_import_cannot_be_called_or_constructed_and_will_cause_a_failure_at_runtime_7038","A namespace-style import cannot be called or constructed, and will cause a failure at runtime."),Mapped_object_type_implicitly_has_an_any_template_type:t(7039,e.DiagnosticCategory.Error,"Mapped_object_type_implicitly_has_an_any_template_type_7039","Mapped object type implicitly has an 'any' template type."),You_cannot_rename_this_element:t(8e3,e.DiagnosticCategory.Error,"You_cannot_rename_this_element_8000","You cannot rename this element."),You_cannot_rename_elements_that_are_defined_in_the_standard_TypeScript_library:t(8001,e.DiagnosticCategory.Error,"You_cannot_rename_elements_that_are_defined_in_the_standard_TypeScript_library_8001","You cannot rename elements that are defined in the standard TypeScript library."),import_can_only_be_used_in_a_ts_file:t(8002,e.DiagnosticCategory.Error,"import_can_only_be_used_in_a_ts_file_8002","'import ... =' can only be used in a .ts file."),export_can_only_be_used_in_a_ts_file:t(8003,e.DiagnosticCategory.Error,"export_can_only_be_used_in_a_ts_file_8003","'export=' can only be used in a .ts file."),type_parameter_declarations_can_only_be_used_in_a_ts_file:t(8004,e.DiagnosticCategory.Error,"type_parameter_declarations_can_only_be_used_in_a_ts_file_8004","'type parameter declarations' can only be used in a .ts file."),implements_clauses_can_only_be_used_in_a_ts_file:t(8005,e.DiagnosticCategory.Error,"implements_clauses_can_only_be_used_in_a_ts_file_8005","'implements clauses' can only be used in a .ts file."),interface_declarations_can_only_be_used_in_a_ts_file:t(8006,e.DiagnosticCategory.Error,"interface_declarations_can_only_be_used_in_a_ts_file_8006","'interface declarations' can only be used in a .ts file."),module_declarations_can_only_be_used_in_a_ts_file:t(8007,e.DiagnosticCategory.Error,"module_declarations_can_only_be_used_in_a_ts_file_8007","'module declarations' can only be used in a .ts file."),type_aliases_can_only_be_used_in_a_ts_file:t(8008,e.DiagnosticCategory.Error,"type_aliases_can_only_be_used_in_a_ts_file_8008","'type aliases' can only be used in a .ts file."),_0_can_only_be_used_in_a_ts_file:t(8009,e.DiagnosticCategory.Error,"_0_can_only_be_used_in_a_ts_file_8009","'{0}' can only be used in a .ts file."),types_can_only_be_used_in_a_ts_file:t(8010,e.DiagnosticCategory.Error,"types_can_only_be_used_in_a_ts_file_8010","'types' can only be used in a .ts file."),type_arguments_can_only_be_used_in_a_ts_file:t(8011,e.DiagnosticCategory.Error,"type_arguments_can_only_be_used_in_a_ts_file_8011","'type arguments' can only be used in a .ts file."),parameter_modifiers_can_only_be_used_in_a_ts_file:t(8012,e.DiagnosticCategory.Error,"parameter_modifiers_can_only_be_used_in_a_ts_file_8012","'parameter modifiers' can only be used in a .ts file."),non_null_assertions_can_only_be_used_in_a_ts_file:t(8013,e.DiagnosticCategory.Error,"non_null_assertions_can_only_be_used_in_a_ts_file_8013","'non-null assertions' can only be used in a .ts file."),enum_declarations_can_only_be_used_in_a_ts_file:t(8015,e.DiagnosticCategory.Error,"enum_declarations_can_only_be_used_in_a_ts_file_8015","'enum declarations' can only be used in a .ts file."),type_assertion_expressions_can_only_be_used_in_a_ts_file:t(8016,e.DiagnosticCategory.Error,"type_assertion_expressions_can_only_be_used_in_a_ts_file_8016","'type assertion expressions' can only be used in a .ts file."),Octal_literal_types_must_use_ES2015_syntax_Use_the_syntax_0:t(8017,e.DiagnosticCategory.Error,"Octal_literal_types_must_use_ES2015_syntax_Use_the_syntax_0_8017","Octal literal types must use ES2015 syntax. Use the syntax '{0}'."),Octal_literals_are_not_allowed_in_enums_members_initializer_Use_the_syntax_0:t(8018,e.DiagnosticCategory.Error,"Octal_literals_are_not_allowed_in_enums_members_initializer_Use_the_syntax_0_8018","Octal literals are not allowed in enums members initializer. Use the syntax '{0}'."),Report_errors_in_js_files:t(8019,e.DiagnosticCategory.Message,"Report_errors_in_js_files_8019","Report errors in .js files."),JSDoc_types_can_only_be_used_inside_documentation_comments:t(8020,e.DiagnosticCategory.Error,"JSDoc_types_can_only_be_used_inside_documentation_comments_8020","JSDoc types can only be used inside documentation comments."),JSDoc_typedef_tag_should_either_have_a_type_annotation_or_be_followed_by_property_or_member_tags:t(8021,e.DiagnosticCategory.Error,"JSDoc_typedef_tag_should_either_have_a_type_annotation_or_be_followed_by_property_or_member_tags_8021","JSDoc '@typedef' tag should either have a type annotation or be followed by '@property' or '@member' tags."),JSDoc_0_is_not_attached_to_a_class:t(8022,e.DiagnosticCategory.Error,"JSDoc_0_is_not_attached_to_a_class_8022","JSDoc '@{0}' is not attached to a class."),JSDoc_0_1_does_not_match_the_extends_2_clause:t(8023,e.DiagnosticCategory.Error,"JSDoc_0_1_does_not_match_the_extends_2_clause_8023","JSDoc '@{0} {1}' does not match the 'extends {2}' clause."),JSDoc_param_tag_has_name_0_but_there_is_no_parameter_with_that_name:t(8024,e.DiagnosticCategory.Error,"JSDoc_param_tag_has_name_0_but_there_is_no_parameter_with_that_name_8024","JSDoc '@param' tag has name '{0}', but there is no parameter with that name."),Class_declarations_cannot_have_more_than_one_augments_or_extends_tag:t(8025,e.DiagnosticCategory.Error,"Class_declarations_cannot_have_more_than_one_augments_or_extends_tag_8025","Class declarations cannot have more than one `@augments` or `@extends` tag."),Expected_0_type_arguments_provide_these_with_an_extends_tag:t(8026,e.DiagnosticCategory.Error,"Expected_0_type_arguments_provide_these_with_an_extends_tag_8026","Expected {0} type arguments; provide these with an '@extends' tag."),Expected_0_1_type_arguments_provide_these_with_an_extends_tag:t(8027,e.DiagnosticCategory.Error,"Expected_0_1_type_arguments_provide_these_with_an_extends_tag_8027","Expected {0}-{1} type arguments; provide these with an '@extends' tag."),JSDoc_may_only_appear_in_the_last_parameter_of_a_signature:t(8028,e.DiagnosticCategory.Error,"JSDoc_may_only_appear_in_the_last_parameter_of_a_signature_8028","JSDoc '...' may only appear in the last parameter of a signature."),Only_identifiers_Slashqualified_names_with_optional_type_arguments_are_currently_supported_in_a_class_extends_clause:t(9002,e.DiagnosticCategory.Error,"Only_identifiers_Slashqualified_names_with_optional_type_arguments_are_currently_supported_in_a_clas_9002","Only identifiers/qualified-names with optional type arguments are currently supported in a class 'extends' clause."),class_expressions_are_not_currently_supported:t(9003,e.DiagnosticCategory.Error,"class_expressions_are_not_currently_supported_9003","'class' expressions are not currently supported."),Language_service_is_disabled:t(9004,e.DiagnosticCategory.Error,"Language_service_is_disabled_9004","Language service is disabled."),JSX_attributes_must_only_be_assigned_a_non_empty_expression:t(17e3,e.DiagnosticCategory.Error,"JSX_attributes_must_only_be_assigned_a_non_empty_expression_17000","JSX attributes must only be assigned a non-empty 'expression'."),JSX_elements_cannot_have_multiple_attributes_with_the_same_name:t(17001,e.DiagnosticCategory.Error,"JSX_elements_cannot_have_multiple_attributes_with_the_same_name_17001","JSX elements cannot have multiple attributes with the same name."),Expected_corresponding_JSX_closing_tag_for_0:t(17002,e.DiagnosticCategory.Error,"Expected_corresponding_JSX_closing_tag_for_0_17002","Expected corresponding JSX closing tag for '{0}'."),JSX_attribute_expected:t(17003,e.DiagnosticCategory.Error,"JSX_attribute_expected_17003","JSX attribute expected."),Cannot_use_JSX_unless_the_jsx_flag_is_provided:t(17004,e.DiagnosticCategory.Error,"Cannot_use_JSX_unless_the_jsx_flag_is_provided_17004","Cannot use JSX unless the '--jsx' flag is provided."),A_constructor_cannot_contain_a_super_call_when_its_class_extends_null:t(17005,e.DiagnosticCategory.Error,"A_constructor_cannot_contain_a_super_call_when_its_class_extends_null_17005","A constructor cannot contain a 'super' call when its class extends 'null'."),An_unary_expression_with_the_0_operator_is_not_allowed_in_the_left_hand_side_of_an_exponentiation_expression_Consider_enclosing_the_expression_in_parentheses:t(17006,e.DiagnosticCategory.Error,"An_unary_expression_with_the_0_operator_is_not_allowed_in_the_left_hand_side_of_an_exponentiation_ex_17006","An unary expression with the '{0}' operator is not allowed in the left-hand side of an exponentiation expression. Consider enclosing the expression in parentheses."),A_type_assertion_expression_is_not_allowed_in_the_left_hand_side_of_an_exponentiation_expression_Consider_enclosing_the_expression_in_parentheses:t(17007,e.DiagnosticCategory.Error,"A_type_assertion_expression_is_not_allowed_in_the_left_hand_side_of_an_exponentiation_expression_Con_17007","A type assertion expression is not allowed in the left-hand side of an exponentiation expression. Consider enclosing the expression in parentheses."),JSX_element_0_has_no_corresponding_closing_tag:t(17008,e.DiagnosticCategory.Error,"JSX_element_0_has_no_corresponding_closing_tag_17008","JSX element '{0}' has no corresponding closing tag."),super_must_be_called_before_accessing_this_in_the_constructor_of_a_derived_class:t(17009,e.DiagnosticCategory.Error,"super_must_be_called_before_accessing_this_in_the_constructor_of_a_derived_class_17009","'super' must be called before accessing 'this' in the constructor of a derived class."),Unknown_type_acquisition_option_0:t(17010,e.DiagnosticCategory.Error,"Unknown_type_acquisition_option_0_17010","Unknown type acquisition option '{0}'."),super_must_be_called_before_accessing_a_property_of_super_in_the_constructor_of_a_derived_class:t(17011,e.DiagnosticCategory.Error,"super_must_be_called_before_accessing_a_property_of_super_in_the_constructor_of_a_derived_class_17011","'super' must be called before accessing a property of 'super' in the constructor of a derived class."),_0_is_not_a_valid_meta_property_for_keyword_1_Did_you_mean_2:t(17012,e.DiagnosticCategory.Error,"_0_is_not_a_valid_meta_property_for_keyword_1_Did_you_mean_2_17012","'{0}' is not a valid meta-property for keyword '{1}'. Did you mean '{2}'?"),Meta_property_0_is_only_allowed_in_the_body_of_a_function_declaration_function_expression_or_constructor:t(17013,e.DiagnosticCategory.Error,"Meta_property_0_is_only_allowed_in_the_body_of_a_function_declaration_function_expression_or_constru_17013","Meta-property '{0}' is only allowed in the body of a function declaration, function expression, or constructor."),JSX_fragment_has_no_corresponding_closing_tag:t(17014,e.DiagnosticCategory.Error,"JSX_fragment_has_no_corresponding_closing_tag_17014","JSX fragment has no corresponding closing tag."),Expected_corresponding_closing_tag_for_JSX_fragment:t(17015,e.DiagnosticCategory.Error,"Expected_corresponding_closing_tag_for_JSX_fragment_17015","Expected corresponding closing tag for JSX fragment."),JSX_fragment_is_not_supported_when_using_jsxFactory:t(17016,e.DiagnosticCategory.Error,"JSX_fragment_is_not_supported_when_using_jsxFactory_17016","JSX fragment is not supported when using --jsxFactory"),JSX_fragment_is_not_supported_when_using_an_inline_JSX_factory_pragma:t(17017,e.DiagnosticCategory.Error,"JSX_fragment_is_not_supported_when_using_an_inline_JSX_factory_pragma_17017","JSX fragment is not supported when using an inline JSX factory pragma"),Circularity_detected_while_resolving_configuration_Colon_0:t(18e3,e.DiagnosticCategory.Error,"Circularity_detected_while_resolving_configuration_Colon_0_18000","Circularity detected while resolving configuration: {0}"),A_path_in_an_extends_option_must_be_relative_or_rooted_but_0_is_not:t(18001,e.DiagnosticCategory.Error,"A_path_in_an_extends_option_must_be_relative_or_rooted_but_0_is_not_18001","A path in an 'extends' option must be relative or rooted, but '{0}' is not."),The_files_list_in_config_file_0_is_empty:t(18002,e.DiagnosticCategory.Error,"The_files_list_in_config_file_0_is_empty_18002","The 'files' list in config file '{0}' is empty."),No_inputs_were_found_in_config_file_0_Specified_include_paths_were_1_and_exclude_paths_were_2:t(18003,e.DiagnosticCategory.Error,"No_inputs_were_found_in_config_file_0_Specified_include_paths_were_1_and_exclude_paths_were_2_18003","No inputs were found in config file '{0}'. Specified 'include' paths were '{1}' and 'exclude' paths were '{2}'."),File_is_a_CommonJS_module_it_may_be_converted_to_an_ES6_module:t(80001,e.DiagnosticCategory.Suggestion,"File_is_a_CommonJS_module_it_may_be_converted_to_an_ES6_module_80001","File is a CommonJS module; it may be converted to an ES6 module."),This_constructor_function_may_be_converted_to_a_class_declaration:t(80002,e.DiagnosticCategory.Suggestion,"This_constructor_function_may_be_converted_to_a_class_declaration_80002","This constructor function may be converted to a class declaration."),Import_may_be_converted_to_a_default_import:t(80003,e.DiagnosticCategory.Suggestion,"Import_may_be_converted_to_a_default_import_80003","Import may be converted to a default import."),JSDoc_types_may_be_moved_to_TypeScript_types:t(80004,e.DiagnosticCategory.Suggestion,"JSDoc_types_may_be_moved_to_TypeScript_types_80004","JSDoc types may be moved to TypeScript types."),Add_missing_super_call:t(90001,e.DiagnosticCategory.Message,"Add_missing_super_call_90001","Add missing 'super()' call"),Make_super_call_the_first_statement_in_the_constructor:t(90002,e.DiagnosticCategory.Message,"Make_super_call_the_first_statement_in_the_constructor_90002","Make 'super()' call the first statement in the constructor"),Change_extends_to_implements:t(90003,e.DiagnosticCategory.Message,"Change_extends_to_implements_90003","Change 'extends' to 'implements'"),Remove_declaration_for_Colon_0:t(90004,e.DiagnosticCategory.Message,"Remove_declaration_for_Colon_0_90004","Remove declaration for: '{0}'"),Remove_import_from_0:t(90005,e.DiagnosticCategory.Message,"Remove_import_from_0_90005","Remove import from '{0}'"),Implement_interface_0:t(90006,e.DiagnosticCategory.Message,"Implement_interface_0_90006","Implement interface '{0}'"),Implement_inherited_abstract_class:t(90007,e.DiagnosticCategory.Message,"Implement_inherited_abstract_class_90007","Implement inherited abstract class"),Add_this_to_unresolved_variable:t(90008,e.DiagnosticCategory.Message,"Add_this_to_unresolved_variable_90008","Add 'this.' to unresolved variable"),Import_0_from_module_1:t(90013,e.DiagnosticCategory.Message,"Import_0_from_module_1_90013","Import '{0}' from module \"{1}\""),Change_0_to_1:t(90014,e.DiagnosticCategory.Message,"Change_0_to_1_90014","Change '{0}' to '{1}'"),Add_0_to_existing_import_declaration_from_1:t(90015,e.DiagnosticCategory.Message,"Add_0_to_existing_import_declaration_from_1_90015","Add '{0}' to existing import declaration from \"{1}\""),Declare_property_0:t(90016,e.DiagnosticCategory.Message,"Declare_property_0_90016","Declare property '{0}'"),Add_index_signature_for_property_0:t(90017,e.DiagnosticCategory.Message,"Add_index_signature_for_property_0_90017","Add index signature for property '{0}'"),Disable_checking_for_this_file:t(90018,e.DiagnosticCategory.Message,"Disable_checking_for_this_file_90018","Disable checking for this file"),Ignore_this_error_message:t(90019,e.DiagnosticCategory.Message,"Ignore_this_error_message_90019","Ignore this error message"),Initialize_property_0_in_the_constructor:t(90020,e.DiagnosticCategory.Message,"Initialize_property_0_in_the_constructor_90020","Initialize property '{0}' in the constructor"),Initialize_static_property_0:t(90021,e.DiagnosticCategory.Message,"Initialize_static_property_0_90021","Initialize static property '{0}'"),Change_spelling_to_0:t(90022,e.DiagnosticCategory.Message,"Change_spelling_to_0_90022","Change spelling to '{0}'"),Declare_method_0:t(90023,e.DiagnosticCategory.Message,"Declare_method_0_90023","Declare method '{0}'"),Declare_static_method_0:t(90024,e.DiagnosticCategory.Message,"Declare_static_method_0_90024","Declare static method '{0}'"),Prefix_0_with_an_underscore:t(90025,e.DiagnosticCategory.Message,"Prefix_0_with_an_underscore_90025","Prefix '{0}' with an underscore"),Rewrite_as_the_indexed_access_type_0:t(90026,e.DiagnosticCategory.Message,"Rewrite_as_the_indexed_access_type_0_90026","Rewrite as the indexed access type '{0}'"),Declare_static_property_0:t(90027,e.DiagnosticCategory.Message,"Declare_static_property_0_90027","Declare static property '{0}'"),Call_decorator_expression:t(90028,e.DiagnosticCategory.Message,"Call_decorator_expression_90028","Call decorator expression"),Add_async_modifier_to_containing_function:t(90029,e.DiagnosticCategory.Message,"Add_async_modifier_to_containing_function_90029","Add async modifier to containing function"),Convert_function_to_an_ES2015_class:t(95001,e.DiagnosticCategory.Message,"Convert_function_to_an_ES2015_class_95001","Convert function to an ES2015 class"),Convert_function_0_to_class:t(95002,e.DiagnosticCategory.Message,"Convert_function_0_to_class_95002","Convert function '{0}' to class"),Extract_to_0_in_1:t(95004,e.DiagnosticCategory.Message,"Extract_to_0_in_1_95004","Extract to {0} in {1}"),Extract_function:t(95005,e.DiagnosticCategory.Message,"Extract_function_95005","Extract function"),Extract_constant:t(95006,e.DiagnosticCategory.Message,"Extract_constant_95006","Extract constant"),Extract_to_0_in_enclosing_scope:t(95007,e.DiagnosticCategory.Message,"Extract_to_0_in_enclosing_scope_95007","Extract to {0} in enclosing scope"),Extract_to_0_in_1_scope:t(95008,e.DiagnosticCategory.Message,"Extract_to_0_in_1_scope_95008","Extract to {0} in {1} scope"),Annotate_with_type_from_JSDoc:t(95009,e.DiagnosticCategory.Message,"Annotate_with_type_from_JSDoc_95009","Annotate with type from JSDoc"),Annotate_with_types_from_JSDoc:t(95010,e.DiagnosticCategory.Message,"Annotate_with_types_from_JSDoc_95010","Annotate with types from JSDoc"),Infer_type_of_0_from_usage:t(95011,e.DiagnosticCategory.Message,"Infer_type_of_0_from_usage_95011","Infer type of '{0}' from usage"),Infer_parameter_types_from_usage:t(95012,e.DiagnosticCategory.Message,"Infer_parameter_types_from_usage_95012","Infer parameter types from usage"),Convert_to_default_import:t(95013,e.DiagnosticCategory.Message,"Convert_to_default_import_95013","Convert to default import"),Install_0:t(95014,e.DiagnosticCategory.Message,"Install_0_95014","Install '{0}'"),Replace_import_with_0:t(95015,e.DiagnosticCategory.Message,"Replace_import_with_0_95015","Replace import with '{0}'."),Use_synthetic_default_member:t(95016,e.DiagnosticCategory.Message,"Use_synthetic_default_member_95016","Use synthetic 'default' member."),Convert_to_ES6_module:t(95017,e.DiagnosticCategory.Message,"Convert_to_ES6_module_95017","Convert to ES6 module"),Add_undefined_type_to_property_0:t(95018,e.DiagnosticCategory.Message,"Add_undefined_type_to_property_0_95018","Add 'undefined' type to property '{0}'"),Add_initializer_to_property_0:t(95019,e.DiagnosticCategory.Message,"Add_initializer_to_property_0_95019","Add initializer to property '{0}'"),Add_definite_assignment_assertion_to_property_0:t(95020,e.DiagnosticCategory.Message,"Add_definite_assignment_assertion_to_property_0_95020","Add definite assignment assertion to property '{0}'")};}(i||(i={})),function(e){function t(e){return e>=71}e.tokenIsIdentifierOrKeyword=t,e.tokenIsIdentifierOrKeywordOrGreaterThan=function(e){return 29===e||t(e)};var r=e.createMapFromTemplate({abstract:117,any:119,as:118,boolean:122,break:72,case:73,catch:74,class:75,continue:77,const:76,constructor:123,debugger:78,declare:124,default:79,delete:80,do:81,else:82,enum:83,export:84,extends:85,false:86,finally:87,for:88,from:142,function:89,get:125,if:90,implements:108,import:91,in:92,infer:126,instanceof:93,interface:109,is:127,keyof:128,let:110,module:129,namespace:130,never:131,new:94,null:95,number:134,object:135,package:111,private:112,protected:113,public:114,readonly:132,require:133,global:143,return:96,set:136,static:115,string:137,super:97,switch:98,symbol:138,this:99,throw:100,true:101,try:102,type:139,typeof:103,undefined:140,unique:141,var:104,void:105,while:106,with:107,yield:116,async:120,await:121,of:144,"{":17,"}":18,"(":19,")":20,"[":21,"]":22,".":23,"...":24,";":25,",":26,"<":27,">":29,"<=":30,">=":31,"==":32,"!=":33,"===":34,"!==":35,"=>":36,"+":37,"-":38,"**":40,"*":39,"/":41,"%":42,"++":43,"--":44,"<<":45,"</":28,">>":46,">>>":47,"&":48,"|":49,"^":50,"!":51,"~":52,"&&":53,"||":54,"?":55,":":56,"=":58,"+=":59,"-=":60,"*=":61,"**=":62,"/=":63,"%=":64,"<<=":65,">>=":66,">>>=":67,"&=":68,"|=":69,"^=":70,"@":57}),n=[170,170,181,181,186,186,192,214,216,246,248,543,546,563,592,685,688,696,699,705,720,721,736,740,750,750,890,890,902,902,904,906,908,908,910,929,931,974,976,983,986,1011,1024,1153,1164,1220,1223,1224,1227,1228,1232,1269,1272,1273,1329,1366,1369,1369,1377,1415,1488,1514,1520,1522,1569,1594,1600,1610,1649,1747,1749,1749,1765,1766,1786,1788,1808,1808,1810,1836,1920,1957,2309,2361,2365,2365,2384,2384,2392,2401,2437,2444,2447,2448,2451,2472,2474,2480,2482,2482,2486,2489,2524,2525,2527,2529,2544,2545,2565,2570,2575,2576,2579,2600,2602,2608,2610,2611,2613,2614,2616,2617,2649,2652,2654,2654,2674,2676,2693,2699,2701,2701,2703,2705,2707,2728,2730,2736,2738,2739,2741,2745,2749,2749,2768,2768,2784,2784,2821,2828,2831,2832,2835,2856,2858,2864,2866,2867,2870,2873,2877,2877,2908,2909,2911,2913,2949,2954,2958,2960,2962,2965,2969,2970,2972,2972,2974,2975,2979,2980,2984,2986,2990,2997,2999,3001,3077,3084,3086,3088,3090,3112,3114,3123,3125,3129,3168,3169,3205,3212,3214,3216,3218,3240,3242,3251,3253,3257,3294,3294,3296,3297,3333,3340,3342,3344,3346,3368,3370,3385,3424,3425,3461,3478,3482,3505,3507,3515,3517,3517,3520,3526,3585,3632,3634,3635,3648,3654,3713,3714,3716,3716,3719,3720,3722,3722,3725,3725,3732,3735,3737,3743,3745,3747,3749,3749,3751,3751,3754,3755,3757,3760,3762,3763,3773,3773,3776,3780,3782,3782,3804,3805,3840,3840,3904,3911,3913,3946,3976,3979,4096,4129,4131,4135,4137,4138,4176,4181,4256,4293,4304,4342,4352,4441,4447,4514,4520,4601,4608,4614,4616,4678,4680,4680,4682,4685,4688,4694,4696,4696,4698,4701,4704,4742,4744,4744,4746,4749,4752,4782,4784,4784,4786,4789,4792,4798,4800,4800,4802,4805,4808,4814,4816,4822,4824,4846,4848,4878,4880,4880,4882,4885,4888,4894,4896,4934,4936,4954,5024,5108,5121,5740,5743,5750,5761,5786,5792,5866,6016,6067,6176,6263,6272,6312,7680,7835,7840,7929,7936,7957,7960,7965,7968,8005,8008,8013,8016,8023,8025,8025,8027,8027,8029,8029,8031,8061,8064,8116,8118,8124,8126,8126,8130,8132,8134,8140,8144,8147,8150,8155,8160,8172,8178,8180,8182,8188,8319,8319,8450,8450,8455,8455,8458,8467,8469,8469,8473,8477,8484,8484,8486,8486,8488,8488,8490,8493,8495,8497,8499,8505,8544,8579,12293,12295,12321,12329,12337,12341,12344,12346,12353,12436,12445,12446,12449,12538,12540,12542,12549,12588,12593,12686,12704,12727,13312,19893,19968,40869,40960,42124,44032,55203,63744,64045,64256,64262,64275,64279,64285,64285,64287,64296,64298,64310,64312,64316,64318,64318,64320,64321,64323,64324,64326,64433,64467,64829,64848,64911,64914,64967,65008,65019,65136,65138,65140,65140,65142,65276,65313,65338,65345,65370,65382,65470,65474,65479,65482,65487,65490,65495,65498,65500],i=[170,170,181,181,186,186,192,214,216,246,248,543,546,563,592,685,688,696,699,705,720,721,736,740,750,750,768,846,864,866,890,890,902,902,904,906,908,908,910,929,931,974,976,983,986,1011,1024,1153,1155,1158,1164,1220,1223,1224,1227,1228,1232,1269,1272,1273,1329,1366,1369,1369,1377,1415,1425,1441,1443,1465,1467,1469,1471,1471,1473,1474,1476,1476,1488,1514,1520,1522,1569,1594,1600,1621,1632,1641,1648,1747,1749,1756,1759,1768,1770,1773,1776,1788,1808,1836,1840,1866,1920,1968,2305,2307,2309,2361,2364,2381,2384,2388,2392,2403,2406,2415,2433,2435,2437,2444,2447,2448,2451,2472,2474,2480,2482,2482,2486,2489,2492,2492,2494,2500,2503,2504,2507,2509,2519,2519,2524,2525,2527,2531,2534,2545,2562,2562,2565,2570,2575,2576,2579,2600,2602,2608,2610,2611,2613,2614,2616,2617,2620,2620,2622,2626,2631,2632,2635,2637,2649,2652,2654,2654,2662,2676,2689,2691,2693,2699,2701,2701,2703,2705,2707,2728,2730,2736,2738,2739,2741,2745,2748,2757,2759,2761,2763,2765,2768,2768,2784,2784,2790,2799,2817,2819,2821,2828,2831,2832,2835,2856,2858,2864,2866,2867,2870,2873,2876,2883,2887,2888,2891,2893,2902,2903,2908,2909,2911,2913,2918,2927,2946,2947,2949,2954,2958,2960,2962,2965,2969,2970,2972,2972,2974,2975,2979,2980,2984,2986,2990,2997,2999,3001,3006,3010,3014,3016,3018,3021,3031,3031,3047,3055,3073,3075,3077,3084,3086,3088,3090,3112,3114,3123,3125,3129,3134,3140,3142,3144,3146,3149,3157,3158,3168,3169,3174,3183,3202,3203,3205,3212,3214,3216,3218,3240,3242,3251,3253,3257,3262,3268,3270,3272,3274,3277,3285,3286,3294,3294,3296,3297,3302,3311,3330,3331,3333,3340,3342,3344,3346,3368,3370,3385,3390,3395,3398,3400,3402,3405,3415,3415,3424,3425,3430,3439,3458,3459,3461,3478,3482,3505,3507,3515,3517,3517,3520,3526,3530,3530,3535,3540,3542,3542,3544,3551,3570,3571,3585,3642,3648,3662,3664,3673,3713,3714,3716,3716,3719,3720,3722,3722,3725,3725,3732,3735,3737,3743,3745,3747,3749,3749,3751,3751,3754,3755,3757,3769,3771,3773,3776,3780,3782,3782,3784,3789,3792,3801,3804,3805,3840,3840,3864,3865,3872,3881,3893,3893,3895,3895,3897,3897,3902,3911,3913,3946,3953,3972,3974,3979,3984,3991,3993,4028,4038,4038,4096,4129,4131,4135,4137,4138,4140,4146,4150,4153,4160,4169,4176,4185,4256,4293,4304,4342,4352,4441,4447,4514,4520,4601,4608,4614,4616,4678,4680,4680,4682,4685,4688,4694,4696,4696,4698,4701,4704,4742,4744,4744,4746,4749,4752,4782,4784,4784,4786,4789,4792,4798,4800,4800,4802,4805,4808,4814,4816,4822,4824,4846,4848,4878,4880,4880,4882,4885,4888,4894,4896,4934,4936,4954,4969,4977,5024,5108,5121,5740,5743,5750,5761,5786,5792,5866,6016,6099,6112,6121,6160,6169,6176,6263,6272,6313,7680,7835,7840,7929,7936,7957,7960,7965,7968,8005,8008,8013,8016,8023,8025,8025,8027,8027,8029,8029,8031,8061,8064,8116,8118,8124,8126,8126,8130,8132,8134,8140,8144,8147,8150,8155,8160,8172,8178,8180,8182,8188,8255,8256,8319,8319,8400,8412,8417,8417,8450,8450,8455,8455,8458,8467,8469,8469,8473,8477,8484,8484,8486,8486,8488,8488,8490,8493,8495,8497,8499,8505,8544,8579,12293,12295,12321,12335,12337,12341,12344,12346,12353,12436,12441,12442,12445,12446,12449,12542,12549,12588,12593,12686,12704,12727,13312,19893,19968,40869,40960,42124,44032,55203,63744,64045,64256,64262,64275,64279,64285,64296,64298,64310,64312,64316,64318,64318,64320,64321,64323,64324,64326,64433,64467,64829,64848,64911,64914,64967,65008,65019,65056,65059,65075,65076,65101,65103,65136,65138,65140,65140,65142,65276,65296,65305,65313,65338,65343,65343,65345,65370,65381,65470,65474,65479,65482,65487,65490,65495,65498,65500],a=[170,170,181,181,186,186,192,214,216,246,248,705,710,721,736,740,748,748,750,750,880,884,886,887,890,893,902,902,904,906,908,908,910,929,931,1013,1015,1153,1162,1319,1329,1366,1369,1369,1377,1415,1488,1514,1520,1522,1568,1610,1646,1647,1649,1747,1749,1749,1765,1766,1774,1775,1786,1788,1791,1791,1808,1808,1810,1839,1869,1957,1969,1969,1994,2026,2036,2037,2042,2042,2048,2069,2074,2074,2084,2084,2088,2088,2112,2136,2208,2208,2210,2220,2308,2361,2365,2365,2384,2384,2392,2401,2417,2423,2425,2431,2437,2444,2447,2448,2451,2472,2474,2480,2482,2482,2486,2489,2493,2493,2510,2510,2524,2525,2527,2529,2544,2545,2565,2570,2575,2576,2579,2600,2602,2608,2610,2611,2613,2614,2616,2617,2649,2652,2654,2654,2674,2676,2693,2701,2703,2705,2707,2728,2730,2736,2738,2739,2741,2745,2749,2749,2768,2768,2784,2785,2821,2828,2831,2832,2835,2856,2858,2864,2866,2867,2869,2873,2877,2877,2908,2909,2911,2913,2929,2929,2947,2947,2949,2954,2958,2960,2962,2965,2969,2970,2972,2972,2974,2975,2979,2980,2984,2986,2990,3001,3024,3024,3077,3084,3086,3088,3090,3112,3114,3123,3125,3129,3133,3133,3160,3161,3168,3169,3205,3212,3214,3216,3218,3240,3242,3251,3253,3257,3261,3261,3294,3294,3296,3297,3313,3314,3333,3340,3342,3344,3346,3386,3389,3389,3406,3406,3424,3425,3450,3455,3461,3478,3482,3505,3507,3515,3517,3517,3520,3526,3585,3632,3634,3635,3648,3654,3713,3714,3716,3716,3719,3720,3722,3722,3725,3725,3732,3735,3737,3743,3745,3747,3749,3749,3751,3751,3754,3755,3757,3760,3762,3763,3773,3773,3776,3780,3782,3782,3804,3807,3840,3840,3904,3911,3913,3948,3976,3980,4096,4138,4159,4159,4176,4181,4186,4189,4193,4193,4197,4198,4206,4208,4213,4225,4238,4238,4256,4293,4295,4295,4301,4301,4304,4346,4348,4680,4682,4685,4688,4694,4696,4696,4698,4701,4704,4744,4746,4749,4752,4784,4786,4789,4792,4798,4800,4800,4802,4805,4808,4822,4824,4880,4882,4885,4888,4954,4992,5007,5024,5108,5121,5740,5743,5759,5761,5786,5792,5866,5870,5872,5888,5900,5902,5905,5920,5937,5952,5969,5984,5996,5998,6e3,6016,6067,6103,6103,6108,6108,6176,6263,6272,6312,6314,6314,6320,6389,6400,6428,6480,6509,6512,6516,6528,6571,6593,6599,6656,6678,6688,6740,6823,6823,6917,6963,6981,6987,7043,7072,7086,7087,7098,7141,7168,7203,7245,7247,7258,7293,7401,7404,7406,7409,7413,7414,7424,7615,7680,7957,7960,7965,7968,8005,8008,8013,8016,8023,8025,8025,8027,8027,8029,8029,8031,8061,8064,8116,8118,8124,8126,8126,8130,8132,8134,8140,8144,8147,8150,8155,8160,8172,8178,8180,8182,8188,8305,8305,8319,8319,8336,8348,8450,8450,8455,8455,8458,8467,8469,8469,8473,8477,8484,8484,8486,8486,8488,8488,8490,8493,8495,8505,8508,8511,8517,8521,8526,8526,8544,8584,11264,11310,11312,11358,11360,11492,11499,11502,11506,11507,11520,11557,11559,11559,11565,11565,11568,11623,11631,11631,11648,11670,11680,11686,11688,11694,11696,11702,11704,11710,11712,11718,11720,11726,11728,11734,11736,11742,11823,11823,12293,12295,12321,12329,12337,12341,12344,12348,12353,12438,12445,12447,12449,12538,12540,12543,12549,12589,12593,12686,12704,12730,12784,12799,13312,19893,19968,40908,40960,42124,42192,42237,42240,42508,42512,42527,42538,42539,42560,42606,42623,42647,42656,42735,42775,42783,42786,42888,42891,42894,42896,42899,42912,42922,43e3,43009,43011,43013,43015,43018,43020,43042,43072,43123,43138,43187,43250,43255,43259,43259,43274,43301,43312,43334,43360,43388,43396,43442,43471,43471,43520,43560,43584,43586,43588,43595,43616,43638,43642,43642,43648,43695,43697,43697,43701,43702,43705,43709,43712,43712,43714,43714,43739,43741,43744,43754,43762,43764,43777,43782,43785,43790,43793,43798,43808,43814,43816,43822,43968,44002,44032,55203,55216,55238,55243,55291,63744,64109,64112,64217,64256,64262,64275,64279,64285,64285,64287,64296,64298,64310,64312,64316,64318,64318,64320,64321,64323,64324,64326,64433,64467,64829,64848,64911,64914,64967,65008,65019,65136,65140,65142,65276,65313,65338,65345,65370,65382,65470,65474,65479,65482,65487,65490,65495,65498,65500],o=[170,170,181,181,186,186,192,214,216,246,248,705,710,721,736,740,748,748,750,750,768,884,886,887,890,893,902,902,904,906,908,908,910,929,931,1013,1015,1153,1155,1159,1162,1319,1329,1366,1369,1369,1377,1415,1425,1469,1471,1471,1473,1474,1476,1477,1479,1479,1488,1514,1520,1522,1552,1562,1568,1641,1646,1747,1749,1756,1759,1768,1770,1788,1791,1791,1808,1866,1869,1969,1984,2037,2042,2042,2048,2093,2112,2139,2208,2208,2210,2220,2276,2302,2304,2403,2406,2415,2417,2423,2425,2431,2433,2435,2437,2444,2447,2448,2451,2472,2474,2480,2482,2482,2486,2489,2492,2500,2503,2504,2507,2510,2519,2519,2524,2525,2527,2531,2534,2545,2561,2563,2565,2570,2575,2576,2579,2600,2602,2608,2610,2611,2613,2614,2616,2617,2620,2620,2622,2626,2631,2632,2635,2637,2641,2641,2649,2652,2654,2654,2662,2677,2689,2691,2693,2701,2703,2705,2707,2728,2730,2736,2738,2739,2741,2745,2748,2757,2759,2761,2763,2765,2768,2768,2784,2787,2790,2799,2817,2819,2821,2828,2831,2832,2835,2856,2858,2864,2866,2867,2869,2873,2876,2884,2887,2888,2891,2893,2902,2903,2908,2909,2911,2915,2918,2927,2929,2929,2946,2947,2949,2954,2958,2960,2962,2965,2969,2970,2972,2972,2974,2975,2979,2980,2984,2986,2990,3001,3006,3010,3014,3016,3018,3021,3024,3024,3031,3031,3046,3055,3073,3075,3077,3084,3086,3088,3090,3112,3114,3123,3125,3129,3133,3140,3142,3144,3146,3149,3157,3158,3160,3161,3168,3171,3174,3183,3202,3203,3205,3212,3214,3216,3218,3240,3242,3251,3253,3257,3260,3268,3270,3272,3274,3277,3285,3286,3294,3294,3296,3299,3302,3311,3313,3314,3330,3331,3333,3340,3342,3344,3346,3386,3389,3396,3398,3400,3402,3406,3415,3415,3424,3427,3430,3439,3450,3455,3458,3459,3461,3478,3482,3505,3507,3515,3517,3517,3520,3526,3530,3530,3535,3540,3542,3542,3544,3551,3570,3571,3585,3642,3648,3662,3664,3673,3713,3714,3716,3716,3719,3720,3722,3722,3725,3725,3732,3735,3737,3743,3745,3747,3749,3749,3751,3751,3754,3755,3757,3769,3771,3773,3776,3780,3782,3782,3784,3789,3792,3801,3804,3807,3840,3840,3864,3865,3872,3881,3893,3893,3895,3895,3897,3897,3902,3911,3913,3948,3953,3972,3974,3991,3993,4028,4038,4038,4096,4169,4176,4253,4256,4293,4295,4295,4301,4301,4304,4346,4348,4680,4682,4685,4688,4694,4696,4696,4698,4701,4704,4744,4746,4749,4752,4784,4786,4789,4792,4798,4800,4800,4802,4805,4808,4822,4824,4880,4882,4885,4888,4954,4957,4959,4992,5007,5024,5108,5121,5740,5743,5759,5761,5786,5792,5866,5870,5872,5888,5900,5902,5908,5920,5940,5952,5971,5984,5996,5998,6e3,6002,6003,6016,6099,6103,6103,6108,6109,6112,6121,6155,6157,6160,6169,6176,6263,6272,6314,6320,6389,6400,6428,6432,6443,6448,6459,6470,6509,6512,6516,6528,6571,6576,6601,6608,6617,6656,6683,6688,6750,6752,6780,6783,6793,6800,6809,6823,6823,6912,6987,6992,7001,7019,7027,7040,7155,7168,7223,7232,7241,7245,7293,7376,7378,7380,7414,7424,7654,7676,7957,7960,7965,7968,8005,8008,8013,8016,8023,8025,8025,8027,8027,8029,8029,8031,8061,8064,8116,8118,8124,8126,8126,8130,8132,8134,8140,8144,8147,8150,8155,8160,8172,8178,8180,8182,8188,8204,8205,8255,8256,8276,8276,8305,8305,8319,8319,8336,8348,8400,8412,8417,8417,8421,8432,8450,8450,8455,8455,8458,8467,8469,8469,8473,8477,8484,8484,8486,8486,8488,8488,8490,8493,8495,8505,8508,8511,8517,8521,8526,8526,8544,8584,11264,11310,11312,11358,11360,11492,11499,11507,11520,11557,11559,11559,11565,11565,11568,11623,11631,11631,11647,11670,11680,11686,11688,11694,11696,11702,11704,11710,11712,11718,11720,11726,11728,11734,11736,11742,11744,11775,11823,11823,12293,12295,12321,12335,12337,12341,12344,12348,12353,12438,12441,12442,12445,12447,12449,12538,12540,12543,12549,12589,12593,12686,12704,12730,12784,12799,13312,19893,19968,40908,40960,42124,42192,42237,42240,42508,42512,42539,42560,42607,42612,42621,42623,42647,42655,42737,42775,42783,42786,42888,42891,42894,42896,42899,42912,42922,43e3,43047,43072,43123,43136,43204,43216,43225,43232,43255,43259,43259,43264,43309,43312,43347,43360,43388,43392,43456,43471,43481,43520,43574,43584,43597,43600,43609,43616,43638,43642,43643,43648,43714,43739,43741,43744,43759,43762,43766,43777,43782,43785,43790,43793,43798,43808,43814,43816,43822,43968,44010,44012,44013,44016,44025,44032,55203,55216,55238,55243,55291,63744,64109,64112,64217,64256,64262,64275,64279,64285,64296,64298,64310,64312,64316,64318,64318,64320,64321,64323,64324,64326,64433,64467,64829,64848,64911,64914,64967,65008,65019,65024,65039,65056,65062,65075,65076,65101,65103,65136,65140,65142,65276,65296,65305,65313,65338,65343,65343,65345,65370,65382,65470,65474,65479,65482,65487,65490,65495,65498,65500];function s(e,t){if(e<t[0])return!1;for(var r,n=0,i=t.length;n+1<i;){if(r=n+(i-n)/2,t[r-=r%2]<=e&&e<=t[r+1])return!0;e<t[r]?i=r:n=r+2;}return!1}function c(e,t){return s(e,t>=1?a:n)}e.isUnicodeIdentifierStart=c;var u,l=(u=[],r.forEach(function(e,t){u[e]=t;}),u);function _(e){for(var t=new Array,r=0,n=0;r<e.length;){var i=e.charCodeAt(r);switch(r++,i){case 13:10===e.charCodeAt(r)&&r++;case 10:t.push(n),n=r;break;default:i>127&&y(i)&&(t.push(n),n=r);}}return t.push(n),t}function d(t,r,n,i){(r<0||r>=t.length)&&e.Debug.fail("Bad line number. Line: "+r+", lineStarts.length: "+t.length+" , line map is correct? "+(void 0!==i?e.arraysEqual(t,_(i)):"unknown"));var a=t[r]+n;return r<t.length-1?e.Debug.assert(a<t[r+1]):void 0!==i&&e.Debug.assert(a<=i.length),a}function p(e){return e.lineMap||(e.lineMap=_(e.text))}function f(t,r){var n=e.binarySearch(t,r,e.identity,e.compareValues);return n<0&&(n=~n-1,e.Debug.assert(-1!==n,"position cannot precede the beginning of the file")),{line:n,character:r-t[n]}}function m(e){return g(e)||y(e)}function g(e){return 32===e||9===e||11===e||12===e||160===e||133===e||5760===e||e>=8192&&e<=8203||8239===e||8287===e||12288===e||65279===e}function y(e){return 10===e||13===e||8232===e||8233===e}function h(e){return e>=48&&e<=57}function v(e){return e>=48&&e<=55}e.tokenToString=function(e){return l[e]},e.stringToToken=function(e){return r.get(e)},e.computeLineStarts=_,e.getPositionOfLineAndCharacter=function(e,t,r){return d(p(e),t,r,e.text)},e.computePositionOfLineAndCharacter=d,e.getLineStarts=p,e.computeLineAndCharacterOfPosition=f,e.getLineAndCharacterOfPosition=function(e,t){return f(p(e),t)},e.isWhiteSpaceLike=m,e.isWhiteSpaceSingleLine=g,e.isLineBreak=y,e.isOctalDigit=v,e.couldStartTrivia=function(e,t){var r=e.charCodeAt(t);switch(r){case 13:case 10:case 9:case 11:case 12:case 32:case 47:case 60:case 124:case 61:case 62:return!0;case 35:return 0===t;default:return r>127}},e.skipTrivia=function(t,r,n,i){if(void 0===i&&(i=!1),e.positionIsSynthesized(r))return r;for(;;){var a=t.charCodeAt(r);switch(a){case 13:10===t.charCodeAt(r+1)&&r++;case 10:if(r++,n)return r;continue;case 9:case 11:case 12:case 32:r++;continue;case 47:if(i)break;if(47===t.charCodeAt(r+1)){for(r+=2;r<t.length&&!y(t.charCodeAt(r));)r++;continue}if(42===t.charCodeAt(r+1)){for(r+=2;r<t.length;){if(42===t.charCodeAt(r)&&47===t.charCodeAt(r+1)){r+=2;break}r++;}continue}break;case 60:case 124:case 61:case 62:if(x(t,r)){r=S(t,r);continue}break;case 35:if(0===r&&T(t,r)){r=D(t,r);continue}break;default:if(a>127&&m(a)){r++;continue}}return r}};var b="<<<<<<<".length;function x(t,r){if(e.Debug.assert(r>=0),0===r||y(t.charCodeAt(r-1))){var n=t.charCodeAt(r);if(r+b<t.length){for(var i=0;i<b;i++)if(t.charCodeAt(r+i)!==n)return!1;return 61===n||32===t.charCodeAt(r+b)}}return!1}function S(t,r,n){n&&n(e.Diagnostics.Merge_conflict_marker_encountered,r,b);var i=t.charCodeAt(r),a=t.length;if(60===i||62===i)for(;r<a&&!y(t.charCodeAt(r));)r++;else for(e.Debug.assert(124===i||61===i);r<a;){var o=t.charCodeAt(r);if((61===o||62===o)&&o!==i&&x(t,r))break;r++;}return r}var k=/^#!.*/;function T(t,r){return e.Debug.assert(0===r),k.test(t)}function D(e,t){return t+=k.exec(e)[0].length}function C(e,t,r,n,i,a,o){var s,c,u,l,_=!1,d=n||0===r,p=o;e:for(;r>=0&&r<t.length;){var f=t.charCodeAt(r);switch(f){case 13:10===t.charCodeAt(r+1)&&r++;case 10:if(r++,n)break e;d=!0,_&&(l=!0);continue;case 9:case 11:case 12:case 32:r++;continue;case 47:var g=t.charCodeAt(r+1),h=!1;if(47===g||42===g){var v=47===g?2:3,b=r;if(r+=2,47===g)for(;r<t.length;){if(y(t.charCodeAt(r))){h=!0;break}r++;}else for(;r<t.length;){if(42===t.charCodeAt(r)&&47===t.charCodeAt(r+1)){r+=2;break}r++;}if(d){if(_){if(p=i(s,c,u,l,a,p),!e&&p)return p;_=!1;}s=b,c=r,u=v,l=h,_=!0;}continue}break e;default:if(f>127&&m(f)){_&&y(f)&&(l=!0),r++;continue}break e}}return _&&(p=i(s,c,u,l,a,p)),p}function E(e,t,r,n,i){return C(!0,e,t,!1,r,n,i)}function N(e,t,r,n,i){return C(!0,e,t,!0,r,n,i)}function A(e,t,r,n,i,a){return a||(a=[]),a.push({kind:r,pos:e,end:t,hasTrailingNewLine:n}),a}function P(e,t){return e>=65&&e<=90||e>=97&&e<=122||36===e||95===e||e>127&&c(e,t)}function w(e,t){return e>=65&&e<=90||e>=97&&e<=122||e>=48&&e<=57||36===e||95===e||e>127&&function(e,t){return s(e,t>=1?o:i)}(e,t)}e.forEachLeadingCommentRange=function(e,t,r,n){return C(!1,e,t,!1,r,n)},e.forEachTrailingCommentRange=function(e,t,r,n){return C(!1,e,t,!0,r,n)},e.reduceEachLeadingCommentRange=E,e.reduceEachTrailingCommentRange=N,e.getLeadingCommentRanges=function(e,t){return E(e,t,A,void 0,void 0)},e.getTrailingCommentRanges=function(e,t){return N(e,t,A,void 0,void 0)},e.getShebang=function(e){var t=k.exec(e);if(t)return t[0]},e.isIdentifierStart=P,e.isIdentifierPart=w,e.isIdentifierText=function(e,t){if(!P(e.charCodeAt(0),t))return!1;for(var r=1;r<e.length;r++)if(!w(e.charCodeAt(r),t))return!1;return!0},e.createScanner=function(n,i,a,o,s,c,u){var l,_,d,p,f,b,k;return void 0===a&&(a=0),W(o,c,u),{getStartPos:function(){return d},getTextPos:function(){return l},getToken:function(){return f},getTokenPos:function(){return p},getTokenText:function(){return o.substring(p,l)},getTokenValue:function(){return b},hasExtendedUnicodeEscape:function(){return 0!=(8&k)},hasPrecedingLineBreak:function(){return 0!=(1&k)},isIdentifier:function(){return 71===f||f>107},isReservedWord:function(){return f>=72&&f<=107},isUnterminated:function(){return 0!=(4&k)},getTokenFlags:function(){return k},reScanGreaterToken:function(){if(29===f){if(62===o.charCodeAt(l))return 62===o.charCodeAt(l+1)?61===o.charCodeAt(l+2)?(l+=3,f=67):(l+=2,f=47):61===o.charCodeAt(l+1)?(l+=2,f=66):(l++,f=46);if(61===o.charCodeAt(l))return l++,f=31}return f},reScanSlashToken:function(){if(41===f||63===f){for(var t=p+1,r=!1,i=!1;;){if(t>=_){k|=4,C(e.Diagnostics.Unterminated_regular_expression_literal);break}var a=o.charCodeAt(t);if(y(a)){k|=4,C(e.Diagnostics.Unterminated_regular_expression_literal);break}if(r)r=!1;else{if(47===a&&!i){t++;break}91===a?i=!0:92===a?r=!0:93===a&&(i=!1);}t++;}for(;t<_&&w(o.charCodeAt(t),n);)t++;l=t,b=o.substring(p,l),f=12;}return f},reScanTemplateToken:function(){return e.Debug.assert(18===f,"'reScanTemplateToken' should only be called on a '}'"),l=p,f=L()},scanJsxIdentifier:function(){if(t(f)){for(var e=l;l<_;){var r=o.charCodeAt(l);if(45!==r&&(e===l?!P(r,n):!w(r,n)))break;l++;}b+=o.substring(e,l);}return f},scanJsxAttributeValue:function(){switch(d=l,o.charCodeAt(l)){case 34:case 39:return b=M(!0),f=9;default:return U()}},reScanJsxToken:function(){return l=p=d,f=q()},scanJsxToken:q,scanJSDocToken:function(){if(l>=_)return f=1;d=l,p=l;var e=o.charCodeAt(l);switch(l++,e){case 9:case 11:case 12:case 32:for(;l<_&&g(o.charCodeAt(l));)l++;return f=5;case 64:return f=57;case 10:case 13:return f=4;case 42:return f=39;case 123:return f=17;case 125:return f=18;case 91:return f=21;case 93:return f=22;case 60:return f=27;case 61:return f=58;case 44:return f=26;case 46:return f=23}if(P(e,6)){for(;w(o.charCodeAt(l),6)&&l<_;)l++;return b=o.substring(p,l),f=71}return f=0},scan:U,getText:function(){return o},setText:W,setScriptTarget:function(e){n=e;},setLanguageVariant:function(e){a=e;},setOnError:function(e){s=e;},setTextPos:H,tryScan:function(e){return V(e,!1)},lookAhead:function(e){return V(e,!0)},scanRange:function(e,t,r){var n=_,i=l,a=d,s=p,c=f,u=b,m=k;W(o,e,t);var g=r();return _=n,l=i,d=a,p=s,f=c,b=u,k=m,g}};function C(e,t,r){if(void 0===t&&(t=l),s){var n=l;l=t,s(e,r||0),l=n;}}function E(){for(var t=l,r=!1,n=!1,i="";;){var a=o.charCodeAt(l);if(95!==a){if(!h(a))break;r=!0,n=!1,l++;}else k|=512,r?(r=!1,n=!0,i+=o.substring(t,l)):C(n?e.Diagnostics.Multiple_consecutive_numeric_separators_are_not_permitted:e.Diagnostics.Numeric_separators_are_not_allowed_here,l,1),t=++l;}return 95===o.charCodeAt(l-1)&&C(e.Diagnostics.Numeric_separators_are_not_allowed_here,l-1,1),i+o.substring(t,l)}function N(){var t,r,n=l,i=E();46===o.charCodeAt(l)&&(l++,t=E());var a=l;if(69===o.charCodeAt(l)||101===o.charCodeAt(l)){l++,k|=16,43!==o.charCodeAt(l)&&45!==o.charCodeAt(l)||l++;var s=l,c=E();c?(r=o.substring(a,s)+c,a=l):C(e.Diagnostics.Digit_expected);}if(512&k){var u=i;return t&&(u+="."+t),r&&(u+=r),""+ +u}return""+ +o.substring(n,a)}function A(){for(var e=l;v(o.charCodeAt(l));)l++;return+o.substring(e,l)}function F(e,t){return I(e,!1,t)}function O(e,t){return I(e,!0,t)}function I(t,r,n){for(var i=0,a=0,s=!1,c=!1;i<t||r;){var u=o.charCodeAt(l);if(n&&95===u)k|=512,s?(s=!1,c=!0):C(c?e.Diagnostics.Multiple_consecutive_numeric_separators_are_not_permitted:e.Diagnostics.Numeric_separators_are_not_allowed_here,l,1),l++;else{if(s=n,u>=48&&u<=57)a=16*a+u-48;else if(u>=65&&u<=70)a=16*a+u-65+10;else{if(!(u>=97&&u<=102))break;a=16*a+u-97+10;}l++,i++,c=!1;}}return i<t&&(a=-1),95===o.charCodeAt(l-1)&&C(e.Diagnostics.Numeric_separators_are_not_allowed_here,l-1,1),a}function M(t){void 0===t&&(t=!1);for(var r=o.charCodeAt(l),n="",i=++l;;){if(l>=_){n+=o.substring(i,l),k|=4,C(e.Diagnostics.Unterminated_string_literal);break}var a=o.charCodeAt(l);if(a===r){n+=o.substring(i,l),l++;break}if(92!==a||t){if(y(a)&&!t){n+=o.substring(i,l),k|=4,C(e.Diagnostics.Unterminated_string_literal);break}l++;}else n+=o.substring(i,l),n+=R(),i=l;}return n}function L(){for(var t,r=96===o.charCodeAt(l),n=++l,i="";;){if(l>=_){i+=o.substring(n,l),k|=4,C(e.Diagnostics.Unterminated_template_literal),t=r?13:16;break}var a=o.charCodeAt(l);if(96===a){i+=o.substring(n,l),l++,t=r?13:16;break}if(36===a&&l+1<_&&123===o.charCodeAt(l+1)){i+=o.substring(n,l),l+=2,t=r?14:15;break}92!==a?13!==a?l++:(i+=o.substring(n,l),++l<_&&10===o.charCodeAt(l)&&l++,i+="\n",n=l):(i+=o.substring(n,l),i+=R(),n=l);}return e.Debug.assert(void 0!==t),b=i,t}function R(){if(++l>=_)return C(e.Diagnostics.Unexpected_end_of_text),"";var t,r,n=o.charCodeAt(l);switch(l++,n){case 48:return"\0";case 98:return"\b";case 116:return"\t";case 110:return"\n";case 118:return"\v";case 102:return"\f";case 114:return"\r";case 39:return"'";case 34:return'"';case 117:return l<_&&123===o.charCodeAt(l)?(k|=8,l++,t=O(1,!1),r=!1,t<0?(C(e.Diagnostics.Hexadecimal_digit_expected),r=!0):t>1114111&&(C(e.Diagnostics.An_extended_Unicode_escape_value_must_be_between_0x0_and_0x10FFFF_inclusive),r=!0),l>=_?(C(e.Diagnostics.Unexpected_end_of_text),r=!0):125===o.charCodeAt(l)?l++:(C(e.Diagnostics.Unterminated_Unicode_escape_sequence),r=!0),r?"":function(t){if(e.Debug.assert(0<=t&&t<=1114111),t<=65535)return String.fromCharCode(t);var r=Math.floor((t-65536)/1024)+55296,n=(t-65536)%1024+56320;return String.fromCharCode(r,n)}(t)):B(4);case 120:return B(2);case 13:l<_&&10===o.charCodeAt(l)&&l++;case 10:case 8232:case 8233:return"";default:return String.fromCharCode(n)}}function B(t){var r=F(t,!1);return r>=0?String.fromCharCode(r):(C(e.Diagnostics.Hexadecimal_digit_expected),"")}function K(){if(l+5<_&&117===o.charCodeAt(l+1)){var e=l;l+=2;var t=F(4,!1);return l=e,t}return-1}function j(){for(var e="",t=l;l<_;){var r=o.charCodeAt(l);if(w(r,n))l++;else{if(92!==r)break;if(!((r=K())>=0&&w(r,n)))break;e+=o.substring(t,l),e+=String.fromCharCode(r),t=l+=6;}}return e+=o.substring(t,l)}function J(){var e=b.length;if(e>=2&&e<=11){var t=b.charCodeAt(0);if(t>=97&&t<=122&&void 0!==(f=r.get(b)))return f}return f=71}function z(t){e.Debug.assert(2===t||8===t,"Expected either base 2 or base 8");for(var r=0,n=0,i=!1,a=!1;;){var s=o.charCodeAt(l);if(95!==s){i=!0;var c=s-48;if(!h(s)||c>=t)break;r=r*t+c,l++,n++,a=!1;}else k|=512,i?(i=!1,a=!0):C(a?e.Diagnostics.Multiple_consecutive_numeric_separators_are_not_permitted:e.Diagnostics.Numeric_separators_are_not_allowed_here,l,1),l++;}return 0===n?-1:95===o.charCodeAt(l-1)?(C(e.Diagnostics.Numeric_separators_are_not_allowed_here,l-1,1),r):r}function U(){for(d=l,k=0;;){if(p=l,l>=_)return f=1;var t=o.charCodeAt(l);if(35===t&&0===l&&T(o,l)){if(l=D(o,l),i)continue;return f=6}switch(t){case 10:case 13:if(k|=1,i){l++;continue}return 13===t&&l+1<_&&10===o.charCodeAt(l+1)?l+=2:l++,f=4;case 9:case 11:case 12:case 32:if(i){l++;continue}for(;l<_&&g(o.charCodeAt(l));)l++;return f=5;case 33:return 61===o.charCodeAt(l+1)?61===o.charCodeAt(l+2)?(l+=3,f=35):(l+=2,f=33):(l++,f=51);case 34:case 39:return b=M(),f=9;case 96:return f=L();case 37:return 61===o.charCodeAt(l+1)?(l+=2,f=64):(l++,f=42);case 38:return 38===o.charCodeAt(l+1)?(l+=2,f=53):61===o.charCodeAt(l+1)?(l+=2,f=68):(l++,f=48);case 40:return l++,f=19;case 41:return l++,f=20;case 42:return 61===o.charCodeAt(l+1)?(l+=2,f=61):42===o.charCodeAt(l+1)?61===o.charCodeAt(l+2)?(l+=3,f=62):(l+=2,f=40):(l++,f=39);case 43:return 43===o.charCodeAt(l+1)?(l+=2,f=43):61===o.charCodeAt(l+1)?(l+=2,f=59):(l++,f=37);case 44:return l++,f=26;case 45:return 45===o.charCodeAt(l+1)?(l+=2,f=44):61===o.charCodeAt(l+1)?(l+=2,f=60):(l++,f=38);case 46:return h(o.charCodeAt(l+1))?(b=N(),f=8):46===o.charCodeAt(l+1)&&46===o.charCodeAt(l+2)?(l+=3,f=24):(l++,f=23);case 47:if(47===o.charCodeAt(l+1)){for(l+=2;l<_&&!y(o.charCodeAt(l));)l++;if(i)continue;return f=2}if(42===o.charCodeAt(l+1)){l+=2,42===o.charCodeAt(l)&&47!==o.charCodeAt(l+1)&&(k|=2);for(var r=!1;l<_;){var s=o.charCodeAt(l);if(42===s&&47===o.charCodeAt(l+1)){l+=2,r=!0;break}y(s)&&(k|=1),l++;}if(r||C(e.Diagnostics.Asterisk_Slash_expected),i)continue;return r||(k|=4),f=3}return 61===o.charCodeAt(l+1)?(l+=2,f=63):(l++,f=41);case 48:var c;if(l+2<_&&(88===o.charCodeAt(l+1)||120===o.charCodeAt(l+1)))return l+=2,(c=O(1,!0))<0&&(C(e.Diagnostics.Hexadecimal_digit_expected),c=0),b=""+c,k|=64,f=8;if(l+2<_&&(66===o.charCodeAt(l+1)||98===o.charCodeAt(l+1)))return l+=2,(c=z(2))<0&&(C(e.Diagnostics.Binary_digit_expected),c=0),b=""+c,k|=128,f=8;if(l+2<_&&(79===o.charCodeAt(l+1)||111===o.charCodeAt(l+1)))return l+=2,(c=z(8))<0&&(C(e.Diagnostics.Octal_digit_expected),c=0),b=""+c,k|=256,f=8;if(l+1<_&&v(o.charCodeAt(l+1)))return b=""+A(),k|=32,f=8;case 49:case 50:case 51:case 52:case 53:case 54:case 55:case 56:case 57:return b=N(),f=8;case 58:return l++,f=56;case 59:return l++,f=25;case 60:if(x(o,l)){if(l=S(o,l,C),i)continue;return f=7}return 60===o.charCodeAt(l+1)?61===o.charCodeAt(l+2)?(l+=3,f=65):(l+=2,f=45):61===o.charCodeAt(l+1)?(l+=2,f=30):1===a&&47===o.charCodeAt(l+1)&&42!==o.charCodeAt(l+2)?(l+=2,f=28):(l++,f=27);case 61:if(x(o,l)){if(l=S(o,l,C),i)continue;return f=7}return 61===o.charCodeAt(l+1)?61===o.charCodeAt(l+2)?(l+=3,f=34):(l+=2,f=32):62===o.charCodeAt(l+1)?(l+=2,f=36):(l++,f=58);case 62:if(x(o,l)){if(l=S(o,l,C),i)continue;return f=7}return l++,f=29;case 63:return l++,f=55;case 91:return l++,f=21;case 93:return l++,f=22;case 94:return 61===o.charCodeAt(l+1)?(l+=2,f=70):(l++,f=50);case 123:return l++,f=17;case 124:if(x(o,l)){if(l=S(o,l,C),i)continue;return f=7}return 124===o.charCodeAt(l+1)?(l+=2,f=54):61===o.charCodeAt(l+1)?(l+=2,f=69):(l++,f=49);case 125:return l++,f=18;case 126:return l++,f=52;case 64:return l++,f=57;case 92:var u=K();return u>=0&&P(u,n)?(l+=6,b=String.fromCharCode(u)+j(),f=J()):(C(e.Diagnostics.Invalid_character),l++,f=0);default:if(P(t,n)){for(l++;l<_&&w(t=o.charCodeAt(l),n);)l++;return b=o.substring(p,l),92===t&&(b+=j()),f=J()}if(g(t)){l++;continue}if(y(t)){k|=1,l++;continue}return C(e.Diagnostics.Invalid_character),l++,f=0}}}function q(){if(d=p=l,l>=_)return f=1;var e=o.charCodeAt(l);if(60===e)return 47===o.charCodeAt(l+1)?(l+=2,f=28):(l++,f=27);if(123===e)return l++,f=17;for(var t=0;l<_&&123!==(e=o.charCodeAt(l));){if(60===e){if(x(o,l))return l=S(o,l,C),f=7;break}y(e)&&0===t?t=-1:m(e)||(t=l),l++;}return-1===t?11:10}function V(e,t){var r=l,n=d,i=p,a=f,o=b,s=k,c=e();return c&&!t||(l=r,d=n,p=i,f=a,b=o,k=s),c}function W(e,t,r){o=e||"",_=void 0===r?o.length:t+r,H(t||0);}function H(t){e.Debug.assert(t>=0),l=t,d=t,p=t,f=0,b=void 0,k=0;}};}(i||(i={})),function(e){e.resolvingEmptyArray=[],e.emptyMap=e.createMap(),e.emptyUnderscoreEscapedMap=e.emptyMap,e.externalHelpersModuleNameText="tslib",e.getDeclarationOfKind=function(e,t){var r=e.declarations;if(r)for(var n=0,i=r;n<i.length;n++){var a=i[n];if(a.kind===t)return a}};var t,r,n=(t="",{getText:function(){return t},write:r=function(e){return t+=e},rawWrite:r,writeTextOfNode:r,writeKeyword:r,writeOperator:r,writePunctuation:r,writeSpace:r,writeStringLiteral:r,writeLiteral:r,writeParameter:r,writeProperty:r,writeSymbol:r,getTextPos:function(){return t.length},getLine:function(){return 0},getColumn:function(){return 0},getIndent:function(){return 0},isAtStartOfLine:function(){return!1},writeLine:function(){return t+=" "},increaseIndent:e.noop,decreaseIndent:e.noop,clear:function(){return t=""},trackSymbol:e.noop,reportInaccessibleThisError:e.noop,reportInaccessibleUniqueSymbolError:e.noop,reportPrivateInBaseOfClassExpression:e.noop});function i(e){return e.end-e.pos}function a(t){return function(t){if(!(262144&t.flags)){var r=0!=(32768&t.flags)||e.forEachChild(t,a);r&&(t.flags|=131072),t.flags|=262144;}}(t),0!=(131072&t.flags)}function o(e){for(;e&&272!==e.kind;)e=e.parent;return e}function s(t,r){e.Debug.assert(t>=0);var n=e.getLineStarts(r),i=t,a=r.text;if(i+1===n.length)return a.length-1;var o=n[i],s=n[i+1]-1;for(e.Debug.assert(e.isLineBreak(a.charCodeAt(s)));o<=s&&e.isLineBreak(a.charCodeAt(s));)s--;return s}function c(e){return void 0===e||e.pos===e.end&&e.pos>=0&&1!==e.kind}function u(e){return!c(e)}function l(e,t){return 42===e.charCodeAt(t.pos+1)&&33===e.charCodeAt(t.pos+2)}function _(t,r,n){return c(t)?t.pos:e.isJSDocNode(t)?e.skipTrivia((r||o(t)).text,t.pos,!1,!0):n&&e.hasJSDocNodes(t)?_(t.jsDoc[0]):293===t.kind&&t._children.length>0?_(t._children[0],r,n):e.skipTrivia((r||o(t)).text,t.pos)}function d(e,t,r){return void 0===r&&(r=!1),p(e.text,t,r)}function p(t,r,n){return void 0===n&&(n=!1),c(r)?"":t.substring(n?r.pos:e.skipTrivia(t,r.pos),r.end)}function f(e,t){return void 0===t&&(t=!1),d(o(e),e,t)}function m(e){return e.pos}function g(e){var t=e.emitNode;return t&&t.flags}function y(e){return e.length>=2&&95===e.charCodeAt(0)&&95===e.charCodeAt(1)?"_"+e:e}function h(e){var t=xe(e);return 230===t.kind&&267===t.parent.kind}function v(t){return e.isModuleDeclaration(t)&&(9===t.name.kind||x(t))}function b(t){return e.isModuleDeclaration(t)&&9===t.name.kind}function x(e){return!!(512&e.flags)}function S(t){switch(t.parent.kind){case 272:return e.isExternalModule(t.parent);case 238:return v(t.parent.parent)&&e.isSourceFile(t.parent.parent.parent)&&!e.isExternalModule(t.parent.parent.parent)}return!1}function k(t,r){switch(t.kind){case 272:case 239:case 267:case 237:case 218:case 219:case 220:case 154:case 153:case 155:case 156:case 232:case 190:case 191:return!0;case 211:return r&&!e.isFunctionLike(r)}return!1}function T(e){return 0===i(e)?"(Missing)":f(e)}function D(t){switch(t.kind){case 71:return t.escapedText;case 9:case 8:return y(t.text);case 146:return fe(t.expression)?y(t.expression.text):void 0;default:e.Debug.assertNever(t);}}function C(t,r,n,i,a,o,s){var c=N(t,r);return e.createFileDiagnostic(t,c.start,c.length,n,i,a,o,s)}function E(t,r){var n=e.createScanner(t.languageVersion,!0,t.languageVariant,t.text,void 0,r);n.scan();var i=n.getTokenPos();return e.createTextSpanFromBounds(i,n.getTextPos())}function N(t,r){var n=r;switch(r.kind){case 272:var i=e.skipTrivia(t.text,0,!1);return i===t.text.length?e.createTextSpan(0,0):E(t,i);case 230:case 180:case 233:case 203:case 234:case 237:case 236:case 271:case 232:case 190:case 153:case 155:case 156:case 235:n=r.name;break;case 191:return function(t,r){var n=e.skipTrivia(t.text,r.pos);if(r.body&&211===r.body.kind){var i=e.getLineAndCharacterOfPosition(t,r.body.pos).line;if(i<e.getLineAndCharacterOfPosition(t,r.body.end).line)return e.createTextSpan(n,s(i,t)-n+1)}return e.createTextSpanFromBounds(n,r.end)}(t,r)}if(void 0===n)return E(t,r.pos);var a=c(n),o=a?n.pos:e.skipTrivia(t.text,n.pos);return a?(e.Debug.assert(o===n.pos,"This failure could trigger https://github.com/Microsoft/TypeScript/issues/20809"),e.Debug.assert(o===n.end,"This failure could trigger https://github.com/Microsoft/TypeScript/issues/20809")):(e.Debug.assert(o>=n.pos,"This failure could trigger https://github.com/Microsoft/TypeScript/issues/20809"),e.Debug.assert(o<=n.end,"This failure could trigger https://github.com/Microsoft/TypeScript/issues/20809")),e.createTextSpanFromBounds(o,n.end)}function A(t){return!!(2&e.getCombinedNodeFlags(t))||!!(2048&e.getCombinedModifierFlags(t))}e.usingSingleLineStringWriter=function(e){var t=n.getText();try{return e(n),n.getText()}finally{n.clear(),n.writeKeyword(t);}},e.getFullWidth=i,e.getResolvedModule=function(e,t){return e&&e.resolvedModules&&e.resolvedModules.get(t)},e.setResolvedModule=function(t,r,n){t.resolvedModules||(t.resolvedModules=e.createMap()),t.resolvedModules.set(r,n);},e.setResolvedTypeReferenceDirective=function(t,r,n){t.resolvedTypeReferenceDirectiveNames||(t.resolvedTypeReferenceDirectiveNames=e.createMap()),t.resolvedTypeReferenceDirectiveNames.set(r,n);},e.moduleResolutionIsEqualTo=function(e,t){return e.isExternalLibraryImport===t.isExternalLibraryImport&&e.extension===t.extension&&e.resolvedFileName===t.resolvedFileName&&e.originalPath===t.originalPath&&(r=e.packageId,n=t.packageId,r===n||r&&n&&r.name===n.name&&r.subModuleName===n.subModuleName&&r.version===n.version);var r,n;},e.packageIdToString=function(e){var t=e.name,r=e.subModuleName,n=e.version;return(r?t+"/"+r:t)+"@"+n},e.typeDirectiveIsEqualTo=function(e,t){return e.resolvedFileName===t.resolvedFileName&&e.primary===t.primary},e.hasChangesInResolutions=function(t,r,n,i){e.Debug.assert(t.length===r.length);for(var a=0;a<t.length;a++){var o=r[a],s=n&&n.get(t[a]);if(s?!o||!i(s,o):o)return!0}return!1},e.containsParseError=a,e.getSourceFileOfNode=o,e.isStatementWithLocals=function(e){switch(e.kind){case 211:case 239:case 218:case 219:case 220:return!0}return!1},e.getStartPositionOfLine=function(t,r){return e.Debug.assert(t>=0),e.getLineStarts(r)[t]},e.nodePosToString=function(t){var r=o(t),n=e.getLineAndCharacterOfPosition(r,t.pos);return r.fileName+"("+(n.line+1)+","+(n.character+1)+")"},e.getEndLinePosition=s,e.nodeIsMissing=c,e.nodeIsPresent=u,e.isRecognizedTripleSlashComment=function(t,r,n){if(47===t.charCodeAt(r+1)&&r+2<n&&47===t.charCodeAt(r+2)){var i=t.substring(r,n);return!!(i.match(e.fullTripleSlashReferencePathRegEx)||i.match(e.fullTripleSlashAMDReferencePathRegEx)||i.match(P)||i.match(w))}return!1},e.isPinnedComment=l,e.getTokenPosOfNode=_,e.getNonDecoratorTokenPosOfNode=function(t,r){return c(t)||!t.decorators?_(t,r):e.skipTrivia((r||o(t)).text,t.decorators.end)},e.getSourceTextOfNodeFromSourceFile=d,e.getTextOfNodeFromSourceText=p,e.getTextOfNode=f,e.indexOfNode=function(t,r){return e.binarySearch(t,r,m,e.compareValues)},e.getEmitFlags=g,e.getLiteralText=function(t,r){if(!Se(t)&&t.parent&&!(e.isNumericLiteral(t)&&512&t.numericLiteralFlags))return d(r,t);var n=16777216&g(t)?Pe:Ie;switch(t.kind){case 9:return t.singleQuote?"'"+n(t.text,39)+"'":'"'+n(t.text,34)+'"';case 13:return"`"+n(t.text,96)+"`";case 14:return"`"+n(t.text,96)+"${";case 15:return"}"+n(t.text,96)+"${";case 16:return"}"+n(t.text,96)+"`";case 8:case 12:return t.text}e.Debug.fail("Literal kind '"+t.kind+"' not accounted for.");},e.getTextOfConstantValue=function(t){return e.isString(t)?'"'+Ie(t)+'"':""+t},e.escapeLeadingUnderscores=y,e.escapeIdentifier=function(e){return e},e.makeIdentifierFromModuleName=function(t){return e.getBaseFileName(t).replace(/^(\d)/,"_$1").replace(/\W/g,"_")},e.isBlockOrCatchScoped=function(t){return 0!=(3&e.getCombinedNodeFlags(t))||h(t)},e.isCatchClauseVariableDeclarationOrBindingElement=h,e.isAmbientModule=v,e.isModuleWithStringLiteralName=b,e.isNonGlobalAmbientModule=function(t){return e.isModuleDeclaration(t)&&e.isStringLiteral(t.name)},e.isShorthandAmbientModuleSymbol=function(e){return(t=e.valueDeclaration)&&237===t.kind&&!t.body;var t;},e.isBlockScopedContainerTopLevel=function(t){return 272===t.kind||237===t.kind||e.isFunctionLike(t)},e.isGlobalScopeAugmentation=x,e.isExternalModuleAugmentation=function(e){return v(e)&&S(e)},e.isModuleAugmentationExternal=S,e.isEffectiveExternalModule=function(t,r){return e.isExternalModule(t)||r.isolatedModules||e.getEmitModuleKind(r)===e.ModuleKind.CommonJS&&!!t.commonJsModuleIndicator},e.isBlockScope=k,e.isDeclarationWithTypeParameters=function(t){switch(t.kind){case 157:case 158:case 152:case 159:case 162:case 163:case 280:case 233:case 203:case 234:case 235:case 290:case 232:case 153:case 154:case 155:case 156:case 190:case 191:return!0;default:return e.assertTypeIsNever(t),!1}},e.isAnyImportSyntax=function(e){switch(e.kind){case 242:case 241:return!0;default:return!1}},e.getEnclosingBlockScopeContainer=function(e){for(var t=e.parent;t;){if(k(t,t.parent))return t;t=t.parent;}},e.declarationNameToString=T,e.getNameFromIndexInfo=function(e){return e.declaration?T(e.declaration.parameters[0].name):void 0},e.getTextOfPropertyName=D,e.entityNameToString=function t(r){switch(r.kind){case 71:return 0===i(r)?e.idText(r):f(r);case 145:return t(r.left)+"."+t(r.right);case 183:return t(r.expression)+"."+t(r.name)}},e.createDiagnosticForNode=function(e,t,r,n,i,a){return C(o(e),e,t,r,n,i,a)},e.createDiagnosticForNodeArray=function(t,r,n,i,a,o,s){var c=e.skipTrivia(t.text,r.pos);return e.createFileDiagnostic(t,c,r.end-c,n,i,a,o,s)},e.createDiagnosticForNodeInSourceFile=C,e.createDiagnosticForNodeSpan=function(t,r,n,i,a,o,s,c){var u=e.skipTrivia(t.text,r.pos);return e.createFileDiagnostic(t,u,n.end-u,i,a,o,s,c)},e.createDiagnosticForNodeFromMessageChain=function(e,t){var r=o(e),n=N(r,e);return{file:r,start:n.start,length:n.length,code:t.code,category:t.category,messageText:t.next?t:t.messageText}},e.getSpanOfTokenAtPosition=E,e.getErrorSpanForNode=N,e.isExternalOrCommonJsModule=function(e){return void 0!==(e.externalModuleIndicator||e.commonJsModuleIndicator)},e.isConstEnumDeclaration=function(e){return 236===e.kind&&A(e)},e.isConst=A,e.isLet=function(t){return!!(1&e.getCombinedNodeFlags(t))},e.isSuperCall=function(e){return 185===e.kind&&97===e.expression.kind},e.isImportCall=function(e){return 185===e.kind&&91===e.expression.kind},e.isPrologueDirective=function(e){return 214===e.kind&&9===e.expression.kind},e.getLeadingCommentRangesOfNode=function(t,r){return 10!==t.kind?e.getLeadingCommentRanges(r.text,t.pos):void 0},e.getJSDocCommentRanges=function(t,r){var n=148===t.kind||147===t.kind||190===t.kind||191===t.kind||189===t.kind?e.concatenate(e.getTrailingCommentRanges(r,t.pos),e.getLeadingCommentRanges(r,t.pos)):e.getLeadingCommentRanges(r,t.pos);return e.filter(n,function(e){return 42===r.charCodeAt(e.pos+1)&&42===r.charCodeAt(e.pos+2)&&47!==r.charCodeAt(e.pos+3)})},e.fullTripleSlashReferencePathRegEx=/^(\/\/\/\s*<reference\s+path\s*=\s*)('|")(.+?)\2.*?\/>/;var P=/^(\/\/\/\s*<reference\s+types\s*=\s*)('|")(.+?)\2.*?\/>/;e.fullTripleSlashAMDReferencePathRegEx=/^(\/\/\/\s*<amd-dependency\s+path\s*=\s*)('|")(.+?)\2.*?\/>/;var w=/^(\/\/\/\s*<reference\s+no-default-lib\s*=\s*)('|")(.+?)\2\s*\/>/;function F(t){if(160<=t.kind&&t.kind<=177)return!0;switch(t.kind){case 119:case 134:case 137:case 122:case 138:case 140:case 131:return!0;case 105:return 194!==t.parent.kind;case 205:return!_t(t);case 147:return 176===t.parent.kind||171===t.parent.kind;case 71:145===t.parent.kind&&t.parent.right===t?t=t.parent:183===t.parent.kind&&t.parent.name===t&&(t=t.parent),e.Debug.assert(71===t.kind||145===t.kind||183===t.kind,"'node' was expected to be a qualified name, identifier or property access in 'isPartOfTypeNode'.");case 145:case 183:case 99:var r=t.parent;if(164===r.kind)return!1;if(160<=r.kind&&r.kind<=177)return!0;switch(r.kind){case 205:return!_t(r);case 147:return t===r.constraint;case 151:case 150:case 148:case 230:return t===r.type;case 232:case 190:case 191:case 154:case 153:case 152:case 155:case 156:return t===r.type;case 157:case 158:case 159:case 188:return t===r.type;case 185:case 186:return e.contains(r.typeArguments,t);case 187:return!1}}return!1}function O(e){if(e)switch(e.kind){case 180:case 271:case 148:case 268:case 151:case 150:case 269:case 230:return!0}return!1}function I(e){return 231===e.parent.kind&&212===e.parent.parent.kind}function M(t,r){for(;;){if(!(t=t.parent))return;switch(t.kind){case 146:if(e.isClassLike(t.parent.parent))return t;t=t.parent;break;case 149:148===t.parent.kind&&e.isClassElement(t.parent.parent)?t=t.parent.parent:e.isClassElement(t.parent)&&(t=t.parent);break;case 191:if(!r)continue;case 232:case 190:case 237:case 151:case 150:case 153:case 152:case 154:case 155:case 156:case 157:case 158:case 159:case 236:case 272:return t}}}function L(e,t,r){switch(e.kind){case 233:return!0;case 151:return 233===t.kind;case 155:case 156:case 153:return void 0!==e.body&&233===t.kind;case 148:return void 0!==t.body&&(154===t.kind||153===t.kind||156===t.kind)&&233===r.kind}return!1}function R(e,t,r){return void 0!==e.decorators&&L(e,t,r)}function B(e,t,r){return R(e,t,r)||K(e,t)}function K(t,r){switch(t.kind){case 233:return e.forEach(t.members,function(e){return B(e,t,r)});case 153:case 156:return e.forEach(t.parameters,function(e){return R(e,t,r)})}}function j(e){var t=e.parent;return(255===t.kind||254===t.kind||256===t.kind)&&t.tagName===e}function J(e){switch(e.kind){case 97:case 95:case 101:case 86:case 12:case 181:case 182:case 183:case 184:case 185:case 186:case 187:case 206:case 188:case 207:case 189:case 190:case 203:case 191:case 194:case 192:case 193:case 196:case 197:case 198:case 199:case 202:case 200:case 13:case 204:case 253:case 254:case 257:case 201:case 195:case 208:return!0;case 145:for(;145===e.parent.kind;)e=e.parent;return 164===e.parent.kind||j(e);case 71:if(164===e.parent.kind||j(e))return!0;case 8:case 9:case 99:return z(e);default:return!1}}function z(e){var t=e.parent;switch(t.kind){case 230:case 148:case 151:case 150:case 271:case 268:case 180:return t.initializer===e;case 214:case 215:case 216:case 217:case 223:case 224:case 225:case 264:case 227:return t.expression===e;case 218:var r=t;return r.initializer===e&&231!==r.initializer.kind||r.condition===e||r.incrementor===e;case 219:case 220:var n=t;return n.initializer===e&&231!==n.initializer.kind||n.expression===e;case 188:case 206:case 209:case 146:return e===t.expression;case 149:case 263:case 262:case 270:return!0;case 205:return t.expression===e&&_t(t);default:return J(t)}}function U(e){return 241===e.kind&&252===e.moduleReference.kind}function q(e){return V(e)}function V(e){return e&&!!(65536&e.flags)}function W(t){if(t&&e.isVariableDeclaration(t)&&t.initializer)return G(t.initializer,!1)||e.isIdentifier(t.name)&&$(t.name,t.initializer,!1)}function H(t){if(t&&t.parent&&e.isBinaryExpression(t.parent)&&58===t.parent.operatorToken.kind){var r=e.isPropertyAccessExpression(t.parent.left)&&"prototype"===t.parent.left.name.escapedText;return G(t.parent.right,r)||$(t.parent.left,t.parent.right,r)}}function G(t,r){if(e.isCallExpression(t)){var n=ce(t.expression);return 190===n.kind||191===n.kind?t:void 0}return 190===t.kind||203===t.kind?t:e.isObjectLiteralExpression(t)&&(0===t.properties.length||r)?t:void 0}function $(t,r,n){var i=e.isBinaryExpression(r)&&54===r.operatorToken.kind&&G(r.right,n);if(i&&function t(r,n){if(e.isIdentifier(r)&&e.isIdentifier(n))return r.escapedText===n.escapedText;if(e.isIdentifier(r)&&e.isPropertyAccessExpression(n))return(99===n.expression.kind||e.isIdentifier(n.expression)&&("window"===n.expression.escapedText||"self"===n.expression.escapedText||"global"===n.expression.escapedText))&&t(r,n.name);if(e.isPropertyAccessExpression(r)&&e.isPropertyAccessExpression(n))return r.name.escapedText===n.name.escapedText&&t(r.expression,n.expression);return!1}(t,r.left))return i}function X(t){if(!V(t)||58!==t.operatorToken.kind||!e.isPropertyAccessExpression(t.left))return 0;var r=t.left;if(99===r.expression.kind)return 4;if(e.isIdentifier(r.expression)&&"module"===r.expression.escapedText&&"exports"===r.name.escapedText)return 2;if(dt(r.expression)){if("prototype"===r.name.escapedText&&e.isObjectLiteralExpression(t.right))return 6;if(e.isPropertyAccessExpression(r.expression)&&"prototype"===r.expression.name.escapedText)return 3;for(var n=r;e.isPropertyAccessExpression(n.expression);)n=n.expression;e.Debug.assert(e.isIdentifier(n.expression));var i=n.expression;return"exports"===i.escapedText||"module"===i.escapedText&&"exports"===n.name.escapedText?1:5}return 0}function Q(t){return e.isExpressionStatement(t)&&t.expression&&e.isBinaryExpression(t.expression)&&58===t.expression.operatorToken.kind&&t.expression.right}function Y(t){return e.isExpressionStatement(t)&&e.isBinaryExpression(t.expression)&&0!==X(t.expression)&&e.isBinaryExpression(t.expression.right)&&54===t.expression.right.operatorToken.kind&&t.expression.right.right}function Z(e){switch(e.kind){case 212:var t=ee(e);return t&&t.initializer;case 151:return e.initializer}}function ee(t){return e.isVariableStatement(t)&&t.declarationList.declarations.length>0&&t.declarationList.declarations[0]}function te(e){return 237===e.kind&&e.body&&237===e.body.kind&&e.body}function re(t){var r=ne(t),n=Y(r)||Q(r)||Z(r)||ee(r)||te(r)||r;return n&&e.isFunctionLike(n)?n:void 0}function ne(t){return e.Debug.assert(282===t.parent.kind),t.parent.parent}function ie(e){return void 0!==e.dotDotDotToken}function ae(e){for(var t=e.parent;;){switch(t.kind){case 198:var r=t.operatorToken.kind;return ct(r)&&t.left===e?58===r?1:2:0;case 196:case 197:var n=t.operator;return 43===n||44===n?2:0;case 219:case 220:return t.initializer===e?1:0;case 189:case 181:case 202:case 207:e=t;break;case 269:if(t.name!==e)return 0;e=t.parent;break;case 268:if(t.name===e)return 0;e=t.parent;break;default:return 0}t=e.parent;}}function oe(e,t){for(;e&&e.kind===t;)e=e.parent;return e}function se(e){return oe(e,189)}function ce(e){for(;189===e.kind;)e=e.expression;return e}function ue(e){return dt(e.expression)}function le(e,t){if(e)for(var r=0,n=e;r<n.length;r++){var i=n[r];if(i.token===t)return i}}function _e(e){return 72<=e&&e<=144}function de(e){return 117<=e&&e<=144}function pe(e){return _e(e)&&!de(e)}function fe(e){var t=e.kind;return 9===t||8===t}function me(t){var r=e.getNameOfDeclaration(t);return r&&ge(r)}function ge(e){return 146===e.kind&&!fe(e.expression)&&!ye(e.expression)}function ye(t){return e.isPropertyAccessExpression(t)&&be(t.expression)}function he(t){if(71===t.kind)return t.escapedText;if(9===t.kind||8===t.kind)return y(t.text);if(146===t.kind){var r=t.expression;if(ye(r))return ve(e.idText(r.name));if(9===r.kind||8===r.kind)return y(r.text)}}function ve(e){return"__@"+e}function be(e){return 71===e.kind&&"Symbol"===e.escapedText}function xe(e){for(;180===e.kind;)e=e.parent.parent;return e}function Se(t){return e.positionIsSynthesized(t.pos)||e.positionIsSynthesized(t.end)}function ke(e,t,r){switch(e){case 186:return r?0:1;case 196:case 193:case 194:case 192:case 195:case 199:case 201:return 1;case 198:switch(t){case 40:case 58:case 59:case 60:case 62:case 61:case 63:case 64:case 65:case 66:case 67:case 68:case 70:case 69:return 1}}return 0}function Te(e){return 198===e.kind?e.operatorToken.kind:196===e.kind||197===e.kind?e.operator:e.kind}function De(e,t,r){switch(e){case 99:case 97:case 71:case 95:case 101:case 86:case 8:case 9:case 181:case 182:case 190:case 191:case 203:case 253:case 254:case 257:case 12:case 13:case 200:case 189:case 204:return 19;case 187:case 183:case 184:return 18;case 186:return r?18:17;case 185:return 17;case 197:return 16;case 196:case 193:case 194:case 192:case 195:return 15;case 198:switch(t){case 51:case 52:return 15;case 40:case 39:case 41:case 42:return 14;case 37:case 38:return 13;case 45:case 46:case 47:return 12;case 27:case 30:case 29:case 31:case 92:case 93:return 11;case 32:case 34:case 33:case 35:return 10;case 48:return 9;case 50:return 8;case 49:return 7;case 53:return 6;case 54:return 5;case 58:case 59:case 60:case 62:case 61:case 63:case 64:case 65:case 66:case 67:case 68:case 70:case 69:return 3;case 26:return 0;default:return-1}case 199:return 4;case 201:return 2;case 202:return 1;case 296:return 0;default:return-1}}e.isPartOfTypeNode=F,e.isChildOfNodeWithKind=function(e,t){for(;e;){if(e.kind===t)return!0;e=e.parent;}return!1},e.forEachReturnStatement=function(t,r){return function t(n){switch(n.kind){case 223:return r(n);case 239:case 211:case 215:case 216:case 217:case 218:case 219:case 220:case 224:case 225:case 264:case 265:case 226:case 228:case 267:return e.forEachChild(n,t)}}(t)},e.forEachYieldExpression=function(t,r){return function t(n){switch(n.kind){case 201:r(n);var i=n.expression;return void(i&&t(i));case 236:case 234:case 237:case 235:case 233:case 203:return;default:if(e.isFunctionLike(n)){if(n.name&&146===n.name.kind)return void t(n.name.expression)}else F(n)||e.forEachChild(n,t);}}(t)},e.getRestParameterElementType=function(t){return t&&166===t.kind?t.elementType:t&&161===t.kind?e.singleOrUndefined(t.typeArguments):void 0},e.getMembersOfDeclaration=function(e){switch(e.kind){case 234:case 233:case 203:case 165:return e.members;case 182:return e.properties}},e.isVariableLike=O,e.isVariableDeclarationInVariableStatement=I,e.isValidESSymbolDeclaration=function(t){return e.isVariableDeclaration(t)?A(t)&&e.isIdentifier(t.name)&&I(t):e.isPropertyDeclaration(t)?nt(t)&&rt(t):e.isPropertySignature(t)&&nt(t)},e.introducesArgumentsExoticObject=function(e){switch(e.kind){case 153:case 152:case 154:case 155:case 156:case 232:case 190:return!0}return!1},e.unwrapInnermostStatementOfLabel=function(e,t){for(;;){if(t&&t(e),226!==e.statement.kind)return e.statement;e=e.statement;}},e.isFunctionBlock=function(t){return t&&211===t.kind&&e.isFunctionLike(t.parent)},e.isObjectLiteralMethod=function(e){return e&&153===e.kind&&182===e.parent.kind},e.isObjectLiteralOrClassExpressionMethod=function(e){return 153===e.kind&&(182===e.parent.kind||203===e.parent.kind)},e.isIdentifierTypePredicate=function(e){return e&&1===e.kind},e.isThisTypePredicate=function(e){return e&&0===e.kind},e.getPropertyAssignment=function(t,r,n){return e.filter(t.properties,function(e){if(268===e.kind){var t=D(e.name);return r===t||n&&n===t}})},e.getContainingFunction=function(t){return e.findAncestor(t.parent,e.isFunctionLike)},e.getContainingClass=function(t){return e.findAncestor(t.parent,e.isClassLike)},e.getThisContainer=M,e.getNewTargetContainer=function(e){var t=M(e,!1);if(t)switch(t.kind){case 154:case 232:case 190:return t}},e.getSuperContainer=function(t,r){for(;;){if(!(t=t.parent))return t;switch(t.kind){case 146:t=t.parent;break;case 232:case 190:case 191:if(!r)continue;case 151:case 150:case 153:case 152:case 154:case 155:case 156:return t;case 149:148===t.parent.kind&&e.isClassElement(t.parent.parent)?t=t.parent.parent:e.isClassElement(t.parent)&&(t=t.parent);}}},e.getImmediatelyInvokedFunctionExpression=function(e){if(190===e.kind||191===e.kind){for(var t=e,r=e.parent;189===r.kind;)t=r,r=r.parent;if(185===r.kind&&r.expression===t)return r}},e.isSuperProperty=function(e){var t=e.kind;return(183===t||184===t)&&97===e.expression.kind},e.isThisProperty=function(e){var t=e.kind;return(183===t||184===t)&&99===e.expression.kind},e.getEntityNameFromTypeNode=function(e){switch(e.kind){case 161:return e.typeName;case 205:return dt(e.expression)?e.expression:void 0;case 71:case 145:return e}},e.getInvokedExpression=function(e){switch(e.kind){case 187:return e.tag;case 255:case 254:return e.tagName;default:return e.expression}},e.nodeCanBeDecorated=L,e.nodeIsDecorated=R,e.nodeOrChildIsDecorated=B,e.childIsDecorated=K,e.isJSXTagName=j,e.isExpressionNode=J,e.isInExpressionContext=z,e.isExternalModuleImportEqualsDeclaration=U,e.getExternalModuleImportEqualsDeclarationExpression=function(t){return e.Debug.assert(U(t)),t.moduleReference.expression},e.isInternalModuleImportEqualsDeclaration=function(e){return 241===e.kind&&252!==e.moduleReference.kind},e.isSourceFileJavaScript=q,e.isInJavaScriptFile=V,e.isInJSDoc=function(e){return e&&!!(1048576&e.flags)},e.isJSDocIndexSignature=function(t){return e.isTypeReferenceNode(t)&&e.isIdentifier(t.typeName)&&"Object"===t.typeName.escapedText&&t.typeArguments&&2===t.typeArguments.length&&(137===t.typeArguments[0].kind||134===t.typeArguments[0].kind)},e.isRequireCall=function(e,t){if(185!==e.kind)return!1;var r=e,n=r.expression,i=r.arguments;if(71!==n.kind||"require"!==n.escapedText)return!1;if(1!==i.length)return!1;var a=i[0];return!t||9===a.kind||13===a.kind},e.isSingleOrDoubleQuote=function(e){return 39===e||34===e},e.isStringDoubleQuoted=function(e,t){return 34===d(t,e).charCodeAt(0)},e.getJSInitializerSymbol=function(e){if(!e||!e.valueDeclaration)return e;var t=e.valueDeclaration,r=W(t)||H(t);return r&&r.symbol?r.symbol:e},e.getDeclaredJavascriptInitializer=W,e.getAssignedJavascriptInitializer=H,e.getJavascriptInitializer=G,e.getOuterNameOfJsInitializer=function(t){if(e.isBinaryExpression(t.parent)){var r=54===t.parent.operatorToken.kind&&e.isBinaryExpression(t.parent.parent)?t.parent.parent:t.parent;if(58===r.operatorToken.kind&&e.isIdentifier(r.left))return r.left}else if(e.isVariableDeclaration(t.parent))return t.parent.name},e.getRightMostAssignedExpression=function(e){for(;lt(e,!0);)e=e.right;return e},e.isExportsIdentifier=function(t){return e.isIdentifier(t)&&"exports"===t.escapedText},e.isModuleExportsPropertyAccessExpression=function(t){return e.isPropertyAccessExpression(t)&&e.isIdentifier(t.expression)&&"module"===t.expression.escapedText&&"exports"===t.name.escapedText},e.getSpecialPropertyAssignmentKind=X,e.isSpecialPropertyDeclaration=function(t){return V(t)&&t.parent&&214===t.parent.kind&&!!e.getJSDocTypeTag(t.parent)},e.getExternalModuleName=function(e){if(242===e.kind)return e.moduleSpecifier;if(241===e.kind){var t=e.moduleReference;if(252===t.kind)return t.expression}return 248===e.kind?e.moduleSpecifier:b(e)?e.name:void 0},e.getNamespaceDeclarationNode=function(t){switch(t.kind){case 242:return t.importClause&&e.tryCast(t.importClause.namedBindings,e.isNamespaceImport);case 241:return t;case 248:return;default:return e.Debug.assertNever(t)}},e.isDefaultImport=function(e){return 242===e.kind&&e.importClause&&!!e.importClause.name},e.hasQuestionToken=function(e){if(e)switch(e.kind){case 148:case 153:case 152:case 269:case 268:case 151:case 150:return void 0!==e.questionToken}return!1},e.isJSDocConstructSignature=function(e){return 280===e.kind&&e.parameters.length>0&&e.parameters[0].name&&"new"===e.parameters[0].name.escapedText},e.getJSDocCommentsAndTags=function(t){var r;return function t(n){var i=n.parent;i&&(268===i.kind||151===i.kind||te(i))&&t(i),i&&i.parent&&(ee(i.parent)===n||Q(i.parent))&&t(i.parent),i&&i.parent&&i.parent.parent&&(Z(i.parent.parent)===n||Y(i.parent.parent))&&t(i.parent.parent),(e.isBinaryExpression(n)&&0!==X(n)||183===n.kind&&n.parent&&214===n.parent.kind)&&t(i),148===n.kind&&(r=e.addRange(r,e.getJSDocParameterTags(n))),O(n)&&e.hasInitializer(n)&&e.hasJSDocNodes(n.initializer)&&(r=e.addRange(r,n.initializer.jsDoc)),e.hasJSDocNodes(n)&&(r=e.addRange(r,n.jsDoc));}(t),r||e.emptyArray},e.getParameterSymbolFromJSDoc=function(t){if(t.symbol)return t.symbol;if(e.isIdentifier(t.name)){var r=t.name.escapedText,n=re(t);if(n){var i=e.find(n.parameters,function(e){return 71===e.name.kind&&e.name.escapedText===r});return i&&i.symbol}}},e.getHostSignatureFromJSDoc=re,e.getJSDocHost=ne,e.getTypeParameterFromJsDoc=function(t){var r=t.name.escapedText,n=t.parent.parent.parent.typeParameters;return e.find(n,function(e){return e.name.escapedText===r})},e.hasRestParameter=function(t){var r=e.lastOrUndefined(t.parameters);return r&&ie(r)},e.isRestParameter=ie,function(e){e[e.None=0]="None",e[e.Definite=1]="Definite",e[e.Compound=2]="Compound";}(e.AssignmentKind||(e.AssignmentKind={})),e.getAssignmentTargetKind=ae,e.isAssignmentTarget=function(e){return 0!==ae(e)},e.isNodeWithPossibleHoistedDeclaration=function(e){switch(e.kind){case 211:case 212:case 224:case 215:case 225:case 239:case 264:case 265:case 226:case 218:case 219:case 220:case 216:case 217:case 228:case 267:return!0}return!1},e.walkUpParenthesizedTypes=function(e){return oe(e,172)},e.walkUpParenthesizedExpressions=se,e.skipParentheses=ce,e.isDeleteTarget=function(e){return(183===e.kind||184===e.kind)&&(e=se(e.parent))&&192===e.kind},e.isNodeDescendantOf=function(e,t){for(;e;){if(e===t)return!0;e=e.parent;}return!1},e.isDeclarationName=function(t){return!e.isSourceFile(t)&&!e.isBindingPattern(t)&&e.isDeclaration(t.parent)&&t.parent.name===t},e.isAnyDeclarationName=function(t){switch(t.kind){case 71:case 9:case 8:if(e.isDeclaration(t.parent))return t.parent.name===t;var r=t.parent.parent;return e.isBinaryExpression(r)&&0!==X(r)&&e.getNameOfDeclaration(r)===t;default:return!1}},e.isLiteralComputedPropertyDeclarationName=function(t){return(9===t.kind||8===t.kind)&&146===t.parent.kind&&e.isDeclaration(t.parent.parent)},e.isIdentifierName=function(e){var t=e.parent;switch(t.kind){case 151:case 150:case 153:case 152:case 155:case 156:case 271:case 268:case 183:return t.name===e;case 145:if(t.right===e){for(;145===t.kind;)t=t.parent;return 164===t.kind}return!1;case 180:case 246:return t.propertyName===e;case 250:case 260:return!0}return!1},e.isAliasSymbolDeclaration=function(e){return 241===e.kind||240===e.kind||243===e.kind&&!!e.name||244===e.kind||246===e.kind||250===e.kind||247===e.kind&&ue(e)},e.exportAssignmentIsAlias=ue,e.getClassExtendsHeritageClauseElement=function(e){var t=le(e.heritageClauses,85);return t&&t.types.length>0?t.types[0]:void 0},e.getClassImplementsHeritageClauseElements=function(e){var t=le(e.heritageClauses,108);return t?t.types:void 0},e.getInterfaceBaseTypeNodes=function(e){var t=le(e.heritageClauses,85);return t?t.types:void 0},e.getHeritageClause=le,e.tryResolveScriptReference=function(t,r,n){if(!t.getCompilerOptions().noResolve){var i=e.isRootedDiskPath(n.fileName)?n.fileName:e.combinePaths(e.getDirectoryPath(r.fileName),n.fileName);return t.getSourceFile(i)}},e.getAncestor=function(e,t){for(;e;){if(e.kind===t)return e;e=e.parent;}},e.isKeyword=_e,e.isContextualKeyword=de,e.isNonContextualKeyword=pe,e.isStringANonContextualKeyword=function(t){var r=e.stringToToken(t);return void 0!==r&&pe(r)},e.isTrivia=function(e){return 2<=e&&e<=7},function(e){e[e.Normal=0]="Normal",e[e.Generator=1]="Generator",e[e.Async=2]="Async",e[e.Invalid=4]="Invalid",e[e.AsyncGenerator=3]="AsyncGenerator";}(e.FunctionFlags||(e.FunctionFlags={})),e.getFunctionFlags=function(e){if(!e)return 4;var t=0;switch(e.kind){case 232:case 190:case 153:e.asteriskToken&&(t|=1);case 191:tt(e,256)&&(t|=2);}return e.body||(t|=4),t},e.isAsyncFunction=function(e){switch(e.kind){case 232:case 190:case 191:case 153:return void 0!==e.body&&void 0===e.asteriskToken&&tt(e,256)}return!1},e.isStringOrNumericLiteral=fe,e.hasDynamicName=me,e.isDynamicName=ge,e.isWellKnownSymbolSyntactically=ye,e.getPropertyNameForPropertyNameNode=he,e.isPropertyNameLiteral=function(e){switch(e.kind){case 71:case 9:case 13:case 8:return!0;default:return!1}},e.getTextOfIdentifierOrLiteral=function(t){return 71===t.kind?e.idText(t):t.text},e.getEscapedTextOfIdentifierOrLiteral=function(e){return 71===e.kind?e.escapedText:y(e.text)},e.getPropertyNameForKnownSymbolName=ve,e.isKnownSymbol=function(t){return e.startsWith(t.escapedName,"__@")},e.isESSymbolIdentifier=be,e.isPushOrUnshiftIdentifier=function(e){return"push"===e.escapedText||"unshift"===e.escapedText},e.isParameterDeclaration=function(e){return 148===xe(e).kind},e.getRootDeclaration=xe,e.nodeStartsNewLexicalEnvironment=function(e){var t=e.kind;return 154===t||190===t||232===t||191===t||153===t||155===t||156===t||237===t||272===t},e.nodeIsSynthesized=Se,e.getOriginalSourceFile=function(t){return e.getParseTreeNode(t,e.isSourceFile)||t},function(e){e[e.Left=0]="Left",e[e.Right=1]="Right";}(e.Associativity||(e.Associativity={})),e.getExpressionAssociativity=function(e){var t=Te(e),r=186===e.kind&&void 0!==e.arguments;return ke(e.kind,t,r)},e.getOperatorAssociativity=ke,e.getExpressionPrecedence=function(e){var t=Te(e),r=186===e.kind&&void 0!==e.arguments;return De(e.kind,t,r)},e.getOperator=Te,e.getOperatorPrecedence=De,e.createDiagnosticCollection=function(){var t=[],r=[],n=e.createMap(),i=!1,a=0;return{add:function(o){var s;o.file?(s=n.get(o.file.fileName))||(s=[],n.set(o.file.fileName,s),e.insertSorted(r,o.file.fileName,e.compareStringsCaseSensitive)):(i&&(i=!1,t=t.slice()),s=t),e.insertSorted(s,o,e.compareDiagnostics),a++;},getGlobalDiagnostics:function(){return i=!0,t},getDiagnostics:function(i){if(i)return n.get(i)||[];var a=e.flatMap(r,function(e){return n.get(e)});return t.length?(a.unshift.apply(a,t),a):a},getModificationCount:function(){return a},reattachFileDiagnostics:function(t){e.forEach(n.get(t.fileName),function(e){return e.file=t});}}};var Ce=/[\\\"\u0000-\u001f\t\v\f\b\r\n\u2028\u2029\u0085]/g,Ee=/[\\\'\u0000-\u001f\t\v\f\b\r\n\u2028\u2029\u0085]/g,Ne=/[\\\`\u0000-\u001f\t\v\f\b\r\n\u2028\u2029\u0085]/g,Ae=e.createMapFromTemplate({"\t":"\\t","\v":"\\v","\f":"\\f","\b":"\\b","\r":"\\r","\n":"\\n","\\":"\\\\",'"':'\\"',"'":"\\'","`":"\\`","\u2028":"\\u2028","\u2029":"\\u2029","":"\\u0085"});function Pe(e,t){var r=96===t?Ne:39===t?Ee:Ce;return e.replace(r,we)}function we(e,t,r){if(0===e.charCodeAt(0)){var n=r.charCodeAt(t+e.length);return n>=48&&n<=57?"\\x00":"\\0"}return Ae.get(e)||Fe(e.charCodeAt(0))}function Fe(e){return"\\u"+("0000"+e.toString(16).toUpperCase()).slice(-4)}e.escapeString=Pe,e.isIntrinsicJsxName=function(e){var t=e.charCodeAt(0);return t>=97&&t<=122||e.indexOf("-")>-1};var Oe=/[^\u0000-\u007F]/g;function Ie(e,t){return e=Pe(e,t),Oe.test(e)?e.replace(Oe,function(e){return Fe(e.charCodeAt(0))}):e}e.escapeNonAsciiString=Ie;var Me=["","    "];function Le(e){return void 0===Me[e]&&(Me[e]=Le(e-1)+Me[1]),Me[e]}function Re(){return Me[1].length}function Be(e,t){return t.moduleName||Ke(e,t.fileName)}function Ke(t,r){var n=function(e){return t.getCanonicalFileName(e)},i=e.toPath(t.getCommonSourceDirectory(),t.getCurrentDirectory(),n),a=e.getNormalizedAbsolutePath(r,t.getCurrentDirectory()),o=e.getRelativePathToDirectoryOrUrl(i,a,i,n,!1);return e.removeFileExtension(o)}function je(e,t,r){return!(t.noEmitForJsFiles&&q(e)||e.isDeclarationFile||r(e))}function Je(t,r,n){var i=e.getNormalizedAbsolutePath(t.fileName,r.getCurrentDirectory()),a=r.getCommonSourceDirectory();return i=0===r.getCanonicalFileName(i).indexOf(r.getCanonicalFileName(a))?i.substring(a.length):i,e.combinePaths(n,i)}function ze(t,r){return e.getLineAndCharacterOfPosition(t,r).line}function Ue(t,r){return e.computeLineAndCharacterOfPosition(t,r).line}function qe(e){if(e&&e.parameters.length>0){var t=2===e.parameters.length&&Ve(e.parameters[0]);return e.parameters[t?1:0]}}function Ve(e){return We(e.name)}function We(e){return e&&71===e.kind&&He(e)}function He(e){return 99===e.originalKeywordKind}function Ge(t){return t.type||(V(t)?e.getJSDocType(t):void 0)}function $e(t){var r=e.getJSDocTemplateTag(t);return r&&r.typeParameters}function Xe(e,t,r,n){Qe(e,t,r.pos,n);}function Qe(e,t,r,n){n&&n.length&&r!==n[0].pos&&Ue(e,r)!==Ue(e,n[0].pos)&&t.writeLine();}function Ye(e,t,r,n,i,a,o,s){if(n&&n.length>0){i&&r.write(" ");for(var c=!1,u=0,l=n;u<l.length;u++){var _=l[u];c&&(r.write(" "),c=!1),s(e,t,r,_.pos,_.end,o),_.hasTrailingNewLine?r.writeLine():c=!0;}c&&a&&r.write(" ");}}function Ze(e,t,r,n,i,a){var o=Math.min(t,a-1),s=e.substring(i,o).replace(/^\s+|\s+$/g,"");s?(r.write(s),o!==t&&r.writeLine()):r.writeLiteral(n);}function et(t,r,n){for(var i=0;r<n&&e.isWhiteSpaceSingleLine(t.charCodeAt(r));r++)9===t.charCodeAt(r)?i+=Re()-i%Re():i++;return i}function tt(e,t){return!!it(e,t)}function rt(e){return tt(e,32)}function nt(e){return tt(e,64)}function it(e,t){return at(e)&t}function at(e){if(536870912&e.modifierFlagsCache)return-536870913&e.modifierFlagsCache;var t=ot(e);return e.modifierFlagsCache=536870912|t,t}function ot(e){var t=0;if(e.modifiers)for(var r=0,n=e.modifiers;r<n.length;r++){t|=st(n[r].kind);}return(4&e.flags||71===e.kind&&e.isInJSDocNamespace)&&(t|=1),t}function st(e){switch(e){case 115:return 32;case 114:return 4;case 113:return 16;case 112:return 8;case 117:return 128;case 84:return 1;case 124:return 2;case 76:return 2048;case 79:return 512;case 120:return 256;case 132:return 64}return 0}function ct(e){return e>=58&&e<=70}function ut(t){if(205===t.kind&&85===t.parent.token&&e.isClassLike(t.parent.parent))return t.parent.parent}function lt(t,r){return e.isBinaryExpression(t)&&(r?58===t.operatorToken.kind:ct(t.operatorToken.kind))&&e.isLeftHandSideExpression(t.left)}function _t(e){return void 0!==ut(e)}function dt(e){return 71===e.kind||183===e.kind&&dt(e.expression)}e.getIndentString=Le,e.getIndentSize=Re,e.createTextWriter=function(t){var r,n,i,a,o;function s(e){e&&e.length&&(i&&(r+=Le(n),i=!1),r+=e);}function c(){r="",n=0,i=!0,a=0,o=0;}return c(),{write:s,rawWrite:function(e){void 0!==e&&(i&&(i=!1),r+=e);},writeTextOfNode:function(e,t){s(p(e,t));},writeLiteral:function(t){if(t&&t.length){s(t);var n=e.computeLineStarts(t);n.length>1&&(a=a+n.length-1,o=r.length-t.length+e.lastOrUndefined(n));}},writeLine:function(){i||(a++,o=(r+=t).length,i=!0);},increaseIndent:function(){n++;},decreaseIndent:function(){n--;},getIndent:function(){return n},getTextPos:function(){return r.length},getLine:function(){return a+1},getColumn:function(){return i?n*Re()+1:r.length-o+1},getText:function(){return r},isAtStartOfLine:function(){return i},clear:c,reportInaccessibleThisError:e.noop,reportPrivateInBaseOfClassExpression:e.noop,reportInaccessibleUniqueSymbolError:e.noop,trackSymbol:e.noop,writeKeyword:s,writeOperator:s,writeParameter:s,writeProperty:s,writePunctuation:s,writeSpace:s,writeStringLiteral:s,writeSymbol:s}},e.getResolvedExternalModuleName=Be,e.getExternalModuleNameFromDeclaration=function(e,t,r){var n=t.getExternalModuleFileFromDeclaration(r);if(n&&!n.isDeclarationFile)return Be(e,n)},e.getExternalModuleNameFromPath=Ke,e.getOwnEmitOutputFilePath=function(t,r,n){var i=r.getCompilerOptions();return(i.outDir?e.removeFileExtension(Je(t,r,i.outDir)):e.removeFileExtension(t.fileName))+n},e.getDeclarationEmitOutputFilePath=function(t,r){var n=r.getCompilerOptions(),i=n.declarationDir||n.outDir,a=i?Je(t,r,i):t.fileName;return e.removeFileExtension(a)+".d.ts"},e.getSourceFilesToEmit=function(t,r){var n=t.getCompilerOptions(),i=function(e){return t.isSourceFileFromExternalLibrary(e)};if(n.outFile||n.out){var a=e.getEmitModuleKind(n),o=a===e.ModuleKind.AMD||a===e.ModuleKind.System;return e.filter(t.getSourceFiles(),function(t){return(o||!e.isExternalModule(t))&&je(t,n,i)})}var s=void 0===r?t.getSourceFiles():[r];return e.filter(s,function(e){return je(e,n,i)})},e.sourceFileMayBeEmitted=je,e.getSourceFilePathInNewDir=Je,e.writeFile=function(t,r,n,i,a,o){t.writeFile(n,i,a,function(t){r.add(e.createCompilerDiagnostic(e.Diagnostics.Could_not_write_file_0_Colon_1,n,t));},o);},e.getLineOfLocalPosition=ze,e.getLineOfLocalPositionFromLineMap=Ue,e.getFirstConstructorWithBody=function(t){return e.forEach(t.members,function(e){if(154===e.kind&&u(e.body))return e})},e.getSetAccessorTypeAnnotationNode=function(e){var t=qe(e);return t&&t.type},e.getThisParameter=function(e){if(e.parameters.length){var t=e.parameters[0];if(Ve(t))return t}},e.parameterIsThisKeyword=Ve,e.isThisIdentifier=We,e.identifierIsThisKeyword=He,e.getAllAccessorDeclarations=function(t,r){var n,i,a,o;return me(r)?(n=r,155===r.kind?a=r:156===r.kind?o=r:e.Debug.fail("Accessor has wrong kind")):e.forEach(t,function(e){155!==e.kind&&156!==e.kind||tt(e,32)!==tt(r,32)||he(e.name)===he(r.name)&&(n?i||(i=e):n=e,155!==e.kind||a||(a=e),156!==e.kind||o||(o=e));}),{firstAccessor:n,secondAccessor:i,getAccessor:a,setAccessor:o}},e.getEffectiveTypeAnnotationNode=Ge,e.getEffectiveReturnTypeNode=function(t){return t.type||(V(t)?e.getJSDocReturnType(t):void 0)},e.getEffectiveTypeParameterDeclarations=function(e){return e.typeParameters||(V(e)?$e(e):void 0)},e.getJSDocTypeParameterDeclarations=$e,e.getEffectiveSetAccessorTypeAnnotationNode=function(e){var t=qe(e);return t&&Ge(t)},e.emitNewLineBeforeLeadingComments=Xe,e.emitNewLineBeforeLeadingCommentsOfPosition=Qe,e.emitNewLineBeforeLeadingCommentOfPosition=function(e,t,r,n){r!==n&&Ue(e,r)!==Ue(e,n)&&t.writeLine();},e.emitComments=Ye,e.emitDetachedComments=function(t,r,n,i,a,o,s){var c,u;if(s?0===a.pos&&(c=e.filter(e.getLeadingCommentRanges(t,a.pos),function(e){return l(t,e)})):c=e.getLeadingCommentRanges(t,a.pos),c){for(var _=[],d=void 0,p=0,f=c;p<f.length;p++){var m=f[p];if(d){var g=Ue(r,d.end);if(Ue(r,m.pos)>=g+2)break}_.push(m),d=m;}_.length&&(g=Ue(r,e.lastOrUndefined(_).end),Ue(r,e.skipTrivia(t,a.pos))>=g+2&&(Xe(r,n,a,c),Ye(t,r,n,_,!1,!0,o,i),u={nodePos:a.pos,detachedCommentEndPos:e.lastOrUndefined(_).end}));}return u},e.writeCommentRange=function(t,r,n,i,a,o){if(42===t.charCodeAt(i+1))for(var s=e.computeLineAndCharacterOfPosition(r,i),c=r.length,u=void 0,l=i,_=s.line;l<a;_++){var d=_+1===c?t.length+1:r[_+1];if(l!==i){void 0===u&&(u=et(t,r[s.line],i));var p=n.getIndent()*Re()-u+et(t,l,d);if(p>0){var f=p%Re(),m=Le((p-f)/Re());for(n.rawWrite(m);f;)n.rawWrite(" "),f--;}else n.rawWrite("");}Ze(t,a,n,o,l,d),l=d;}else n.write(t.substring(i,a));},e.hasModifiers=function(e){return 0!==at(e)},e.hasModifier=tt,e.hasStaticModifier=rt,e.hasReadonlyModifier=nt,e.getSelectedModifierFlags=it,e.getModifierFlags=at,e.getModifierFlagsNoCache=ot,e.modifierToFlag=st,e.isLogicalOperator=function(e){return 54===e||53===e||51===e},e.isAssignmentOperator=ct,e.tryGetClassExtendingExpressionWithTypeArguments=ut,e.isAssignmentExpression=lt,e.isDestructuringAssignment=function(e){if(lt(e,!0)){var t=e.left.kind;return 182===t||181===t}return!1},e.isExpressionWithTypeArgumentsInClassExtendsClause=_t,e.isExpressionWithTypeArgumentsInClassImplementsClause=function(t){return 205===t.kind&&dt(t.expression)&&t.parent&&108===t.parent.token&&t.parent.parent&&e.isClassLike(t.parent.parent)},e.isEntityNameExpression=dt,e.isRightSideOfQualifiedNameOrPropertyAccess=function(e){return 145===e.parent.kind&&e.parent.right===e||183===e.parent.kind&&e.parent.name===e},e.isEmptyObjectLiteral=function(e){return 182===e.kind&&0===e.properties.length},e.isEmptyArrayLiteral=function(e){return 181===e.kind&&0===e.elements.length},e.getLocalSymbolForExportDefault=function(t){return function(t){return t&&e.length(t.declarations)>0&&tt(t.declarations[0],512)}(t)?t.declarations[0].localSymbol:void 0},e.tryExtractTypeScriptExtension=function(t){return e.find(e.supportedTypescriptExtensionsForExtractExtension,function(r){return e.fileExtensionIs(t,r)})};var pt="ABCDEFGHIJKLMNOPQRSTUVWXYZabcdefghijklmnopqrstuvwxyz0123456789+/=";e.convertToBase64=function(t){for(var r,n,i,a,o="",s=function(t){for(var r=[],n=t.length,i=0;i<n;i++){var a=t.charCodeAt(i);a<128?r.push(a):a<2048?(r.push(a>>6|192),r.push(63&a|128)):a<65536?(r.push(a>>12|224),r.push(a>>6&63|128),r.push(63&a|128)):a<131072?(r.push(a>>18|240),r.push(a>>12&63|128),r.push(a>>6&63|128),r.push(63&a|128)):e.Debug.assert(!1,"Unexpected code point");}return r}(t),c=0,u=s.length;c<u;)r=s[c]>>2,n=(3&s[c])<<4|s[c+1]>>4,i=(15&s[c+1])<<2|s[c+2]>>6,a=63&s[c+2],c+1>=u?i=a=64:c+2>=u&&(a=64),o+=pt.charAt(r)+pt.charAt(n)+pt.charAt(i)+pt.charAt(a),c+=3;return o};var ft,mt="\r\n",gt="\n";function yt(t,r,n){void 0===t&&(t=0);var i=function(t){var r=[];for(var n in t){var i=t[n];"number"==typeof i&&r.push([i,n]);}return e.stableSort(r,function(t,r){return e.compareValues(t[0],r[0])})}(r);if(0===t)return i.length>0&&0===i[0][0]?i[0][1]:"0";if(n){for(var a="",o=t,s=i.length-1;s>=0&&0!==o;s--){var c=i[s],u=c[0],l=c[1];0!==u&&(o&u)===u&&(o&=~u,a=l+(a?", ":"")+a);}if(0===o)return a}else for(var _=0,d=i;_<d.length;_++){var p=d[_];u=p[0],l=p[1];if(u===t)return l}return t.toString()}function ht(e,t){return{pos:e,end:t}}function vt(e,t){return ht(t,e.end)}function bt(e){return e.decorators&&e.decorators.length>0?vt(e,e.decorators.end):e}function xt(e,t,r){return St(kt(e,r),t.end,r)}function St(e,t,r){return e===t||ze(r,e)===ze(r,t)}function kt(t,r){return e.positionIsSynthesized(t.pos)?-1:e.skipTrivia(r.text,t.pos)}function Tt(e){return void 0!==e.initializer}function Dt(e){return 33554432&e.flags?e.checkFlags:0}function Ct(e){var t=e.parent;if(!t)return 0;switch(t.kind){case 197:case 196:var r=t.operator;return 43===r||44===r?o():0;case 198:var n=t,i=n.left,a=n.operatorToken;return i===e&&ct(a.kind)?o():0;case 183:return t.name!==e?0:Ct(t);default:return 0}function o(){return t.parent&&214===t.parent.kind?1:2}}function Et(t,r){for(;;){var n=r(t);if(void 0!==n)return n;var i=e.getDirectoryPath(t);if(i===t)return;t=i;}}function Nt(e){if(32&e.flags){var t=At(e);return!!t&&tt(t,128)}return!1}function At(t){return e.find(t.declarations,e.isClassLike)}function Pt(e){return 65536&e.flags?e.objectFlags:0}e.getNewLineCharacter=function(t,r){switch(t.newLine){case 0:return mt;case 1:return gt}return r?r():e.sys?e.sys.newLine:mt},e.formatSyntaxKind=function(t){return yt(t,e.SyntaxKind,!1)},e.formatModifierFlags=function(t){return yt(t,e.ModifierFlags,!0)},e.formatTransformFlags=function(t){return yt(t,e.TransformFlags,!0)},e.formatEmitFlags=function(t){return yt(t,e.EmitFlags,!0)},e.formatSymbolFlags=function(t){return yt(t,e.SymbolFlags,!0)},e.formatTypeFlags=function(t){return yt(t,e.TypeFlags,!0)},e.formatObjectFlags=function(t){return yt(t,e.ObjectFlags,!0)},e.createRange=ht,e.moveRangeEnd=function(e,t){return ht(e.pos,t)},e.moveRangePos=vt,e.moveRangePastDecorators=bt,e.moveRangePastModifiers=function(e){return e.modifiers&&e.modifiers.length>0?vt(e,e.modifiers.end):bt(e)},e.isCollapsedRange=function(e){return e.pos===e.end},e.createTokenRange=function(t,r){return ht(t,t+e.tokenToString(r).length)},e.rangeIsOnSingleLine=function(e,t){return xt(e,e,t)},e.rangeStartPositionsAreOnSameLine=function(e,t,r){return St(kt(e,r),kt(t,r),r)},e.rangeEndPositionsAreOnSameLine=function(e,t,r){return St(e.end,t.end,r)},e.rangeStartIsOnSameLineAsRangeEnd=xt,e.rangeEndIsOnSameLineAsRangeStart=function(e,t,r){return St(e.end,kt(t,r),r)},e.positionsAreOnSameLine=St,e.getStartPositionOfRange=kt,e.isDeclarationNameOfEnumOrNamespace=function(t){var r=e.getParseTreeNode(t);if(r)switch(r.parent.kind){case 236:case 237:return r===r.parent.name}return!1},e.getInitializedVariables=function(t){return e.filter(t.declarations,Tt)},e.isWatchSet=function(e){return e.watch&&e.hasOwnProperty("watch")},e.getCheckFlags=Dt,e.getDeclarationModifierFlagsFromSymbol=function(t){if(t.valueDeclaration){var r=e.getCombinedModifierFlags(t.valueDeclaration);return t.parent&&32&t.parent.flags?r:-29&r}if(6&Dt(t)){var n=t.checkFlags;return(256&n?8:64&n?4:16)|(512&n?32:0)}return 4194304&t.flags?36:0},e.skipAlias=function(e,t){return 2097152&e.flags?t.getAliasedSymbol(e):e},e.getCombinedLocalAndExportSymbolFlags=function(e){return e.exportSymbol?e.exportSymbol.flags|e.flags:e.flags},e.isWriteOnlyAccess=function(e){return 1===Ct(e)},e.isWriteAccess=function(e){return 0!==Ct(e)},function(e){e[e.Read=0]="Read",e[e.Write=1]="Write",e[e.ReadWrite=2]="ReadWrite";}(ft||(ft={})),e.compareDataObjects=function e(t,r){if(!t||!r||Object.keys(t).length!==Object.keys(r).length)return!1;for(var n in t)if("object"==typeof t[n]){if(!e(t[n],r[n]))return!1}else if("function"!=typeof t[n]&&t[n]!==r[n])return!1;return!0},e.clearMap=function(e,t){e.forEach(t),e.clear();},e.mutateMap=function(e,t,r){var n=r.createNewValue,i=r.onDeleteValue,a=r.onExistingValue;e.forEach(function(r,n){var o=t.get(n);void 0===o?(e.delete(n),i(r,n)):a&&a(r,o,n);}),t.forEach(function(t,r){e.has(r)||e.set(r,n(r,t));});},e.forEachAncestorDirectory=Et,e.isAbstractConstructorType=function(e){return!!(16&Pt(e))&&!!e.symbol&&Nt(e.symbol)},e.isAbstractConstructorSymbol=Nt,e.getClassLikeDeclarationOfSymbol=At,e.getObjectFlags=Pt,e.typeHasCallOrConstructSignatures=function(e,t){return 0!==t.getSignaturesOfType(e,0).length||0!==t.getSignaturesOfType(e,1).length},e.forSomeAncestorDirectory=function(e,t){return!!Et(e,function(e){return!!t(e)||void 0})},e.isUMDExportSymbol=function(t){return t&&t.declarations&&t.declarations[0]&&e.isNamespaceExportDeclaration(t.declarations[0])},e.showModuleSpecifier=function(t){var r=t.moduleSpecifier;return e.isStringLiteral(r)?r.text:f(r)};}(i||(i={})),function(e){function t(e){return e.start+e.length}function r(e){return 0===e.length}function n(e,t){var r=a(e,t);return r&&0===r.length?void 0:r}function i(e,t,r,n){return r<=e+t&&r+n>=e}function a(e,r){var n=Math.max(e.start,r.start),i=Math.min(t(e),t(r));return n<=i?s(n,i):void 0}function o(e,t){if(e<0)throw new Error("start < 0");if(t<0)throw new Error("length < 0");return{start:e,length:t}}function s(e,t){return o(e,t-e)}function c(e,t){if(t<0)throw new Error("newLength < 0");return{span:e,newLength:t}}function u(t){return!!e.isBindingPattern(t)&&e.every(t.elements,l)}function l(t){return!!e.isOmittedExpression(t)||u(t.name)}function _(t){for(;t&&(180===t.kind||e.isBindingPattern(t));)t=t.parent;return t}function d(e,t){if(e)for(;void 0!==e.original;)e=e.original;return!t||t(e)?e:void 0}function p(e){return 0==(8&e.flags)}function f(e){var t=e;return t.length>=3&&95===t.charCodeAt(0)&&95===t.charCodeAt(1)&&95===t.charCodeAt(2)?t.substr(1):t}function m(t){var r=y(t);return e.isIdentifier(r)?r:void 0}function g(t){return t.name||function(t){var r=t.parent.parent;if(r){if(e.isDeclaration(r))return m(r);switch(r.kind){case 212:return r.declarationList&&r.declarationList.declarations[0]?m(r.declarationList.declarations[0]):void 0;case 214:var n=r.expression;switch(n.kind){case 183:return n.name;case 184:var i=n.argumentExpression;if(e.isIdentifier(i))return i}return;case 1:return;case 189:return m(r.expression);case 226:return e.isDeclaration(r.statement)||e.isExpression(r.statement)?m(r.statement):void 0;default:e.Debug.assertNever(r,"Found typedef tag attached to node which it should not be!");}}}(t)}function y(t){if(t){switch(t.kind){case 71:return t;case 292:case 287:var r=t.name;if(145===r.kind)return r.right;break;case 198:var n=t;switch(e.getSpecialPropertyAssignmentKind(n)){case 1:case 4:case 5:case 3:return n.left.name;default:return}case 291:return g(t);case 247:var i=t.expression;return e.isIdentifier(i)?i:void 0}return t.name}}function h(t){if(t.name&&e.isIdentifier(t.name)){var r=t.name.escapedText;return b(t.parent).filter(function(t){return e.isJSDocParameterTag(t)&&e.isIdentifier(t.name)&&t.name.escapedText===r})}}function v(e){return x(e,288)}function b(t){var r=t.jsDocCache;return void 0===r&&(t.jsDocCache=r=e.flatMap(e.getJSDocCommentsAndTags(t),function(t){return e.isJSDoc(t)?t.tags:t})),r}function x(t,r){var n=b(t);return e.find(n,function(e){return e.kind===r})}e.getDefaultLibFileName=function(e){switch(e.target){case 6:return"lib.esnext.full.d.ts";case 4:return"lib.es2017.full.d.ts";case 3:return"lib.es2016.full.d.ts";case 2:return"lib.es6.d.ts";default:return"lib.d.ts"}},e.textSpanEnd=t,e.textSpanIsEmpty=r,e.textSpanContainsPosition=function(e,r){return r>=e.start&&r<t(e)},e.textSpanContainsTextSpan=function(e,r){return r.start>=e.start&&t(r)<=t(e)},e.textSpanOverlapsWith=function(e,t){return void 0!==n(e,t)},e.textSpanOverlap=n,e.textSpanIntersectsWithTextSpan=function(e,t){return i(e.start,e.length,t.start,t.length)},e.textSpanIntersectsWith=function(e,t,r){return i(e.start,e.length,t,r)},e.decodedTextSpanIntersectsWith=i,e.textSpanIntersectsWithPosition=function(e,r){return r<=t(e)&&r>=e.start},e.textSpanIntersection=a,e.createTextSpan=o,e.createTextSpanFromBounds=s,e.textChangeRangeNewSpan=function(e){return o(e.span.start,e.newLength)},e.textChangeRangeIsUnchanged=function(e){return r(e.span)&&0===e.newLength},e.createTextChangeRange=c,e.unchangedTextChangeRange=c(o(0,0),0),e.collapseTextChangeRangesAcrossMultipleVersions=function(r){if(0===r.length)return e.unchangedTextChangeRange;if(1===r.length)return r[0];for(var n=r[0],i=n.span.start,a=t(n.span),o=i+n.newLength,u=1;u<r.length;u++){var l=r[u],_=i,d=a,p=o,f=l.span.start,m=t(l.span),g=f+l.newLength;i=Math.min(_,f),a=Math.max(d,d+(m-p)),o=Math.max(g,g+(p-m));}return c(s(i,a),o-i)},e.getTypeParameterOwner=function(t){if(t&&147===t.kind)for(var r=t;r;r=r.parent)if(e.isFunctionLike(r)||e.isClassLike(r)||234===r.kind)return r},e.isParameterPropertyDeclaration=function(t){return e.hasModifier(t,92)&&154===t.parent.kind&&e.isClassLike(t.parent.parent)},e.isEmptyBindingPattern=u,e.isEmptyBindingElement=l,e.getCombinedModifierFlags=function(t){t=_(t);var r=e.getModifierFlags(t);return 230===t.kind&&(t=t.parent),t&&231===t.kind&&(r|=e.getModifierFlags(t),t=t.parent),t&&212===t.kind&&(r|=e.getModifierFlags(t)),r},e.getCombinedNodeFlags=function(e){var t=(e=_(e)).flags;return 230===e.kind&&(e=e.parent),e&&231===e.kind&&(t|=e.flags,e=e.parent),e&&212===e.kind&&(t|=e.flags),t},e.validateLocaleAndSetLanguage=function(t,r,n){var i=/^([a-z]+)([_\-]([a-z]+))?$/.exec(t.toLowerCase());if(i){var a=i[1];o(a,i[3],n)||o(a,void 0,n),e.setUILocale(t);}else n&&n.push(e.createCompilerDiagnostic(e.Diagnostics.Locale_must_be_of_the_form_language_or_language_territory_For_example_0_or_1,"en","ja-jp"));function o(t,n,i){var a=e.normalizePath(r.getExecutingFilePath()),o=e.getDirectoryPath(a),s=e.combinePaths(o,t);if(n&&(s=s+"-"+n),s=r.resolvePath(e.combinePaths(s,"diagnosticMessages.generated.json")),!r.fileExists(s))return!1;var c="";try{c=r.readFile(s);}catch(t){return i&&i.push(e.createCompilerDiagnostic(e.Diagnostics.Unable_to_open_file_0,s)),!1}try{e.localizedDiagnosticMessages=JSON.parse(c);}catch(t){return i&&i.push(e.createCompilerDiagnostic(e.Diagnostics.Corrupted_locale_file_0,s)),!1}return!0}},e.getOriginalNode=d,e.isParseTreeNode=p,e.getParseTreeNode=function(e,t){return void 0===e||p(e)?e:!p(e=d(e))||t&&!t(e)?void 0:e},e.unescapeLeadingUnderscores=f,e.idText=function(e){return f(e.escapedText)},e.symbolName=function(e){return f(e.escapedName)},e.unescapeIdentifier=function(e){return e},e.getNameOfJSDocTypedef=g,e.isNamedDeclaration=function(e){return!!e.name},e.getNameOfDeclaration=y,e.getJSDocParameterTags=h,e.hasJSDocParameterTags=function(e){return!!x(e,287)},e.getJSDocAugmentsTag=function(e){return x(e,285)},e.getJSDocClassTag=function(e){return x(e,286)},e.getJSDocReturnTag=v,e.getJSDocTemplateTag=function(e){return x(e,290)},e.getJSDocTypeTag=function(e){var t=x(e,289);if(t&&t.typeExpression&&t.typeExpression.type)return t},e.getJSDocType=function(t){var r=x(t,289);if(!r&&148===t.kind){var n=h(t);n&&(r=e.find(n,function(e){return!!e.typeExpression}));}return r&&r.typeExpression&&r.typeExpression.type},e.getJSDocReturnType=function(e){var t=v(e);return t&&t.typeExpression&&t.typeExpression.type},e.getJSDocTags=b,e.getAllJSDocTagsOfKind=function(t,r){var n=b(t);return e.filter(n,function(e){return e.kind===r})};}(i||(i={})),function(e){e.isNumericLiteral=function(e){return 8===e.kind},e.isStringLiteral=function(e){return 9===e.kind},e.isJsxText=function(e){return 10===e.kind},e.isRegularExpressionLiteral=function(e){return 12===e.kind},e.isNoSubstitutionTemplateLiteral=function(e){return 13===e.kind},e.isTemplateHead=function(e){return 14===e.kind},e.isTemplateMiddle=function(e){return 15===e.kind},e.isTemplateTail=function(e){return 16===e.kind},e.isIdentifier=function(e){return 71===e.kind},e.isQualifiedName=function(e){return 145===e.kind},e.isComputedPropertyName=function(e){return 146===e.kind},e.isTypeParameterDeclaration=function(e){return 147===e.kind},e.isParameter=function(e){return 148===e.kind},e.isDecorator=function(e){return 149===e.kind},e.isPropertySignature=function(e){return 150===e.kind},e.isPropertyDeclaration=function(e){return 151===e.kind},e.isMethodSignature=function(e){return 152===e.kind},e.isMethodDeclaration=function(e){return 153===e.kind},e.isConstructorDeclaration=function(e){return 154===e.kind},e.isGetAccessorDeclaration=function(e){return 155===e.kind},e.isSetAccessorDeclaration=function(e){return 156===e.kind},e.isCallSignatureDeclaration=function(e){return 157===e.kind},e.isConstructSignatureDeclaration=function(e){return 158===e.kind},e.isIndexSignatureDeclaration=function(e){return 159===e.kind},e.isTypePredicateNode=function(e){return 160===e.kind},e.isTypeReferenceNode=function(e){return 161===e.kind},e.isFunctionTypeNode=function(e){return 162===e.kind},e.isConstructorTypeNode=function(e){return 163===e.kind},e.isTypeQueryNode=function(e){return 164===e.kind},e.isTypeLiteralNode=function(e){return 165===e.kind},e.isArrayTypeNode=function(e){return 166===e.kind},e.isTupleTypeNode=function(e){return 167===e.kind},e.isUnionTypeNode=function(e){return 168===e.kind},e.isIntersectionTypeNode=function(e){return 169===e.kind},e.isConditionalTypeNode=function(e){return 170===e.kind},e.isInferTypeNode=function(e){return 171===e.kind},e.isParenthesizedTypeNode=function(e){return 172===e.kind},e.isThisTypeNode=function(e){return 173===e.kind},e.isTypeOperatorNode=function(e){return 174===e.kind},e.isIndexedAccessTypeNode=function(e){return 175===e.kind},e.isMappedTypeNode=function(e){return 176===e.kind},e.isLiteralTypeNode=function(e){return 177===e.kind},e.isObjectBindingPattern=function(e){return 178===e.kind},e.isArrayBindingPattern=function(e){return 179===e.kind},e.isBindingElement=function(e){return 180===e.kind},e.isArrayLiteralExpression=function(e){return 181===e.kind},e.isObjectLiteralExpression=function(e){return 182===e.kind},e.isPropertyAccessExpression=function(e){return 183===e.kind},e.isElementAccessExpression=function(e){return 184===e.kind},e.isCallExpression=function(e){return 185===e.kind},e.isNewExpression=function(e){return 186===e.kind},e.isTaggedTemplateExpression=function(e){return 187===e.kind},e.isTypeAssertion=function(e){return 188===e.kind},e.isParenthesizedExpression=function(e){return 189===e.kind},e.skipPartiallyEmittedExpressions=function(e){for(;295===e.kind;)e=e.expression;return e},e.isFunctionExpression=function(e){return 190===e.kind},e.isArrowFunction=function(e){return 191===e.kind},e.isDeleteExpression=function(e){return 192===e.kind},e.isTypeOfExpression=function(e){return 193===e.kind},e.isVoidExpression=function(e){return 194===e.kind},e.isAwaitExpression=function(e){return 195===e.kind},e.isPrefixUnaryExpression=function(e){return 196===e.kind},e.isPostfixUnaryExpression=function(e){return 197===e.kind},e.isBinaryExpression=function(e){return 198===e.kind},e.isConditionalExpression=function(e){return 199===e.kind},e.isTemplateExpression=function(e){return 200===e.kind},e.isYieldExpression=function(e){return 201===e.kind},e.isSpreadElement=function(e){return 202===e.kind},e.isClassExpression=function(e){return 203===e.kind},e.isOmittedExpression=function(e){return 204===e.kind},e.isExpressionWithTypeArguments=function(e){return 205===e.kind},e.isAsExpression=function(e){return 206===e.kind},e.isNonNullExpression=function(e){return 207===e.kind},e.isMetaProperty=function(e){return 208===e.kind},e.isTemplateSpan=function(e){return 209===e.kind},e.isSemicolonClassElement=function(e){return 210===e.kind},e.isBlock=function(e){return 211===e.kind},e.isVariableStatement=function(e){return 212===e.kind},e.isEmptyStatement=function(e){return 213===e.kind},e.isExpressionStatement=function(e){return 214===e.kind},e.isIfStatement=function(e){return 215===e.kind},e.isDoStatement=function(e){return 216===e.kind},e.isWhileStatement=function(e){return 217===e.kind},e.isForStatement=function(e){return 218===e.kind},e.isForInStatement=function(e){return 219===e.kind},e.isForOfStatement=function(e){return 220===e.kind},e.isContinueStatement=function(e){return 221===e.kind},e.isBreakStatement=function(e){return 222===e.kind},e.isBreakOrContinueStatement=function(e){return 222===e.kind||221===e.kind},e.isReturnStatement=function(e){return 223===e.kind},e.isWithStatement=function(e){return 224===e.kind},e.isSwitchStatement=function(e){return 225===e.kind},e.isLabeledStatement=function(e){return 226===e.kind},e.isThrowStatement=function(e){return 227===e.kind},e.isTryStatement=function(e){return 228===e.kind},e.isDebuggerStatement=function(e){return 229===e.kind},e.isVariableDeclaration=function(e){return 230===e.kind},e.isVariableDeclarationList=function(e){return 231===e.kind},e.isFunctionDeclaration=function(e){return 232===e.kind},e.isClassDeclaration=function(e){return 233===e.kind},e.isInterfaceDeclaration=function(e){return 234===e.kind},e.isTypeAliasDeclaration=function(e){return 235===e.kind},e.isEnumDeclaration=function(e){return 236===e.kind},e.isModuleDeclaration=function(e){return 237===e.kind},e.isModuleBlock=function(e){return 238===e.kind},e.isCaseBlock=function(e){return 239===e.kind},e.isNamespaceExportDeclaration=function(e){return 240===e.kind},e.isImportEqualsDeclaration=function(e){return 241===e.kind},e.isImportDeclaration=function(e){return 242===e.kind},e.isImportClause=function(e){return 243===e.kind},e.isNamespaceImport=function(e){return 244===e.kind},e.isNamedImports=function(e){return 245===e.kind},e.isImportSpecifier=function(e){return 246===e.kind},e.isExportAssignment=function(e){return 247===e.kind},e.isExportDeclaration=function(e){return 248===e.kind},e.isNamedExports=function(e){return 249===e.kind},e.isExportSpecifier=function(e){return 250===e.kind},e.isMissingDeclaration=function(e){return 251===e.kind},e.isExternalModuleReference=function(e){return 252===e.kind},e.isJsxElement=function(e){return 253===e.kind},e.isJsxSelfClosingElement=function(e){return 254===e.kind},e.isJsxOpeningElement=function(e){return 255===e.kind},e.isJsxClosingElement=function(e){return 256===e.kind},e.isJsxFragment=function(e){return 257===e.kind},e.isJsxOpeningFragment=function(e){return 258===e.kind},e.isJsxClosingFragment=function(e){return 259===e.kind},e.isJsxAttribute=function(e){return 260===e.kind},e.isJsxAttributes=function(e){return 261===e.kind},e.isJsxSpreadAttribute=function(e){return 262===e.kind},e.isJsxExpression=function(e){return 263===e.kind},e.isCaseClause=function(e){return 264===e.kind},e.isDefaultClause=function(e){return 265===e.kind},e.isHeritageClause=function(e){return 266===e.kind},e.isCatchClause=function(e){return 267===e.kind},e.isPropertyAssignment=function(e){return 268===e.kind},e.isShorthandPropertyAssignment=function(e){return 269===e.kind},e.isSpreadAssignment=function(e){return 270===e.kind},e.isEnumMember=function(e){return 271===e.kind},e.isSourceFile=function(e){return 272===e.kind},e.isBundle=function(e){return 273===e.kind},e.isJSDocTypeExpression=function(e){return 274===e.kind},e.isJSDocAllType=function(e){return 275===e.kind},e.isJSDocUnknownType=function(e){return 276===e.kind},e.isJSDocNullableType=function(e){return 277===e.kind},e.isJSDocNonNullableType=function(e){return 278===e.kind},e.isJSDocOptionalType=function(e){return 279===e.kind},e.isJSDocFunctionType=function(e){return 280===e.kind},e.isJSDocVariadicType=function(e){return 281===e.kind},e.isJSDoc=function(e){return 282===e.kind},e.isJSDocAugmentsTag=function(e){return 285===e.kind},e.isJSDocParameterTag=function(e){return 287===e.kind},e.isJSDocReturnTag=function(e){return 288===e.kind},e.isJSDocTypeTag=function(e){return 289===e.kind},e.isJSDocTemplateTag=function(e){return 290===e.kind},e.isJSDocTypedefTag=function(e){return 291===e.kind},e.isJSDocPropertyTag=function(e){return 292===e.kind},e.isJSDocPropertyLikeTag=function(e){return 292===e.kind||287===e.kind},e.isJSDocTypeLiteral=function(e){return 283===e.kind};}(i||(i={})),function(e){function t(e){return e>=145}function r(e){return 8<=e&&e<=13}function n(e){return 13<=e&&e<=16}function i(e){switch(e){case 117:case 120:case 76:case 124:case 79:case 84:case 114:case 112:case 113:case 132:case 115:return!0}return!1}function a(e){return e&&s(e.kind)}function o(e){switch(e){case 232:case 153:case 154:case 155:case 156:case 190:case 191:return!0;default:return!1}}function s(e){switch(e){case 152:case 157:case 158:case 159:case 162:case 280:case 163:return!0;default:return o(e)}}function c(e){switch(e.kind){case 178:case 182:return!0}return!1}function u(e){switch(e.kind){case 179:case 181:return!0}return!1}function l(e){switch(e){case 183:case 184:case 186:case 185:case 253:case 254:case 257:case 187:case 181:case 189:case 182:case 203:case 190:case 71:case 12:case 8:case 9:case 13:case 200:case 86:case 95:case 99:case 101:case 97:case 207:case 208:case 91:return!0;default:return!1}}function _(e){switch(e){case 196:case 197:case 192:case 193:case 194:case 195:case 188:return!0;default:return l(e)}}function d(t){return function(e){switch(e){case 199:case 201:case 191:case 198:case 202:case 206:case 204:case 296:case 295:return!0;default:return _(e)}}(e.skipPartiallyEmittedExpressions(t).kind)}function p(e){return 295===e.kind}function f(e){return 294===e.kind}function m(e){return 232===e||251===e||233===e||234===e||235===e||236===e||237===e||242===e||241===e||248===e||247===e||240===e}function g(e){return 222===e||221===e||229===e||216===e||214===e||213===e||219===e||220===e||218===e||215===e||226===e||223===e||225===e||227===e||228===e||212===e||217===e||224===e||294===e||298===e||297===e}function y(e){return e.kind>=284&&e.kind<=292}function h(e){return!!e.initializer}e.isSyntaxList=function(e){return 293===e.kind},e.isNode=function(e){return t(e.kind)},e.isNodeKind=t,e.isToken=function(e){return e.kind>=0&&e.kind<=144},e.isNodeArray=function(e){return e.hasOwnProperty("pos")&&e.hasOwnProperty("end")},e.isLiteralKind=r,e.isLiteralExpression=function(e){return r(e.kind)},e.isTemplateLiteralKind=n,e.isTemplateMiddleOrTemplateTail=function(e){var t=e.kind;return 15===t||16===t},e.isStringTextContainingNode=function(e){return 9===e.kind||n(e.kind)},e.isGeneratedIdentifier=function(t){return e.isIdentifier(t)&&(7&t.autoGenerateFlags)>0},e.isModifierKind=i,e.isModifier=function(e){return i(e.kind)},e.isEntityName=function(e){var t=e.kind;return 145===t||71===t},e.isPropertyName=function(e){var t=e.kind;return 71===t||9===t||8===t||146===t},e.isBindingName=function(e){var t=e.kind;return 71===t||178===t||179===t},e.isFunctionLike=a,e.isFunctionLikeDeclaration=function(e){return e&&o(e.kind)},e.isFunctionLikeKind=s,e.isFunctionOrModuleBlock=function(t){return e.isSourceFile(t)||e.isModuleBlock(t)||e.isBlock(t)&&a(t.parent)},e.isClassElement=function(e){var t=e.kind;return 154===t||151===t||153===t||155===t||156===t||159===t||210===t||251===t},e.isClassLike=function(e){return e&&(233===e.kind||203===e.kind)},e.isAccessor=function(e){return e&&(155===e.kind||156===e.kind)},e.isMethodOrAccessor=function(e){switch(e.kind){case 153:case 155:case 156:return!0;default:return!1}},e.isTypeElement=function(e){var t=e.kind;return 158===t||157===t||150===t||152===t||159===t||251===t},e.isObjectLiteralElementLike=function(e){var t=e.kind;return 268===t||269===t||270===t||153===t||155===t||156===t||251===t},e.isTypeNode=function(e){return(t=e.kind)>=160&&t<=177||119===t||134===t||135===t||122===t||137===t||138===t||99===t||105===t||140===t||95===t||131===t||205===t||275===t||276===t||277===t||278===t||279===t||280===t||281===t;var t;},e.isFunctionOrConstructorTypeNode=function(e){switch(e.kind){case 162:case 163:return!0}return!1},e.isBindingPattern=function(e){if(e){var t=e.kind;return 179===t||178===t}return!1},e.isAssignmentPattern=function(e){var t=e.kind;return 181===t||182===t},e.isArrayBindingElement=function(e){var t=e.kind;return 180===t||204===t},e.isDeclarationBindingElement=function(e){switch(e.kind){case 230:case 148:case 180:return!0}return!1},e.isBindingOrAssignmentPattern=function(e){return c(e)||u(e)},e.isObjectBindingOrAssignmentPattern=c,e.isArrayBindingOrAssignmentPattern=u,e.isPropertyAccessOrQualifiedName=function(e){var t=e.kind;return 183===t||145===t},e.isCallLikeExpression=function(e){switch(e.kind){case 255:case 254:case 185:case 186:case 187:case 149:return!0;default:return!1}},e.isCallOrNewExpression=function(e){return 185===e.kind||186===e.kind},e.isTemplateLiteral=function(e){var t=e.kind;return 200===t||13===t},e.isLeftHandSideExpression=function(t){return l(e.skipPartiallyEmittedExpressions(t).kind)},e.isUnaryExpression=function(t){return _(e.skipPartiallyEmittedExpressions(t).kind)},e.isUnaryExpressionWithWrite=function(e){switch(e.kind){case 197:return!0;case 196:return 43===e.operator||44===e.operator;default:return!1}},e.isExpression=d,e.isAssertionExpression=function(e){var t=e.kind;return 188===t||206===t},e.isPartiallyEmittedExpression=p,e.isNotEmittedStatement=f,e.isNotEmittedOrPartiallyEmittedNode=function(e){return f(e)||p(e)},e.isIterationStatement=function e(t,r){switch(t.kind){case 218:case 219:case 220:case 216:case 217:return!0;case 226:return r&&e(t.statement,r)}return!1},e.isForInOrOfStatement=function(e){return 219===e.kind||220===e.kind},e.isConciseBody=function(t){return e.isBlock(t)||d(t)},e.isFunctionBody=function(t){return e.isBlock(t)},e.isForInitializer=function(t){return e.isVariableDeclarationList(t)||d(t)},e.isModuleBody=function(e){var t=e.kind;return 238===t||237===t||71===t},e.isNamespaceBody=function(e){var t=e.kind;return 238===t||237===t},e.isJSDocNamespaceBody=function(e){var t=e.kind;return 71===t||237===t},e.isNamedImportBindings=function(e){var t=e.kind;return 245===t||244===t},e.isModuleOrEnumDeclaration=function(e){return 237===e.kind||236===e.kind},e.isDeclaration=function(t){return 147===t.kind?290!==t.parent.kind||e.isInJavaScriptFile(t):191===(r=t.kind)||180===r||233===r||203===r||154===r||236===r||271===r||250===r||232===r||190===r||155===r||243===r||241===r||246===r||234===r||260===r||153===r||152===r||237===r||240===r||244===r||148===r||268===r||151===r||150===r||156===r||269===r||235===r||147===r||230===r||291===r;var r;},e.isDeclarationStatement=function(e){return m(e.kind)},e.isStatementButNotDeclaration=function(e){return g(e.kind)},e.isStatement=function(t){var r=t.kind;return g(r)||m(r)||function(t){return 211===t.kind&&((void 0===t.parent||228!==t.parent.kind&&267!==t.parent.kind)&&!e.isFunctionBlock(t))}(t)},e.isModuleReference=function(e){var t=e.kind;return 252===t||145===t||71===t},e.isJsxTagNameExpression=function(e){var t=e.kind;return 99===t||71===t||183===t},e.isJsxChild=function(e){var t=e.kind;return 253===t||263===t||254===t||10===t||257===t},e.isJsxAttributeLike=function(e){var t=e.kind;return 260===t||262===t},e.isStringLiteralOrJsxExpression=function(e){var t=e.kind;return 9===t||263===t},e.isJsxOpeningLikeElement=function(e){var t=e.kind;return 255===t||254===t},e.isCaseOrDefaultClause=function(e){var t=e.kind;return 264===t||265===t},e.isJSDocNode=function(e){return e.kind>=274&&e.kind<=292},e.isJSDocCommentContainingNode=function(t){return 282===t.kind||y(t)||e.isJSDocTypeLiteral(t)},e.isJSDocTag=y,e.isSetAccessor=function(e){return 156===e.kind},e.isGetAccessor=function(e){return 155===e.kind},e.hasJSDocNodes=function(e){return!!e.jsDoc&&e.jsDoc.length>0},e.hasType=function(e){return!!e.type},e.hasInitializer=h,e.hasOnlyExpressionInitializer=function(t){return h(t)&&!e.isForStatement(t)&&!e.isForInStatement(t)&&!e.isForOfStatement(t)&&!e.isJsxAttribute(t)},e.isObjectLiteralElement=function(e){switch(e.kind){case 260:case 262:case 268:case 269:case 153:case 155:case 156:return!0;default:return!1}},e.isTypeReferenceType=function(e){return 161===e.kind||205===e.kind},e.isStringLiteralLike=function(e){return 9===e.kind||13===e.kind};}(i||(i={})),function(e){var t,r,n,i,a,o,s;function c(e,t){return t&&e(t)}function u(e,t,r){if(r){if(t)return t(r);for(var n=0,i=r;n<i.length;n++){var a=e(i[n]);if(a)return a}}}function l(e,t,r){if(e&&!(e.kind<=144))switch(e.kind){case 145:return c(t,e.left)||c(t,e.right);case 147:return c(t,e.name)||c(t,e.constraint)||c(t,e.default)||c(t,e.expression);case 269:return u(t,r,e.decorators)||u(t,r,e.modifiers)||c(t,e.name)||c(t,e.questionToken)||c(t,e.equalsToken)||c(t,e.objectAssignmentInitializer);case 270:return c(t,e.expression);case 148:return u(t,r,e.decorators)||u(t,r,e.modifiers)||c(t,e.dotDotDotToken)||c(t,e.name)||c(t,e.questionToken)||c(t,e.type)||c(t,e.initializer);case 151:return u(t,r,e.decorators)||u(t,r,e.modifiers)||c(t,e.name)||c(t,e.questionToken)||c(t,e.exclamationToken)||c(t,e.type)||c(t,e.initializer);case 150:return u(t,r,e.decorators)||u(t,r,e.modifiers)||c(t,e.name)||c(t,e.questionToken)||c(t,e.type)||c(t,e.initializer);case 268:return u(t,r,e.decorators)||u(t,r,e.modifiers)||c(t,e.name)||c(t,e.questionToken)||c(t,e.initializer);case 230:return u(t,r,e.decorators)||u(t,r,e.modifiers)||c(t,e.name)||c(t,e.exclamationToken)||c(t,e.type)||c(t,e.initializer);case 180:return u(t,r,e.decorators)||u(t,r,e.modifiers)||c(t,e.dotDotDotToken)||c(t,e.propertyName)||c(t,e.name)||c(t,e.initializer);case 162:case 163:case 157:case 158:case 159:return u(t,r,e.decorators)||u(t,r,e.modifiers)||u(t,r,e.typeParameters)||u(t,r,e.parameters)||c(t,e.type);case 153:case 152:case 154:case 155:case 156:case 190:case 232:case 191:return u(t,r,e.decorators)||u(t,r,e.modifiers)||c(t,e.asteriskToken)||c(t,e.name)||c(t,e.questionToken)||u(t,r,e.typeParameters)||u(t,r,e.parameters)||c(t,e.type)||c(t,e.equalsGreaterThanToken)||c(t,e.body);case 161:return c(t,e.typeName)||u(t,r,e.typeArguments);case 160:return c(t,e.parameterName)||c(t,e.type);case 164:return c(t,e.exprName);case 165:return u(t,r,e.members);case 166:return c(t,e.elementType);case 167:return u(t,r,e.elementTypes);case 168:case 169:return u(t,r,e.types);case 170:return c(t,e.checkType)||c(t,e.extendsType)||c(t,e.trueType)||c(t,e.falseType);case 171:return c(t,e.typeParameter);case 172:case 174:return c(t,e.type);case 175:return c(t,e.objectType)||c(t,e.indexType);case 176:return c(t,e.readonlyToken)||c(t,e.typeParameter)||c(t,e.questionToken)||c(t,e.type);case 177:return c(t,e.literal);case 178:case 179:case 181:return u(t,r,e.elements);case 182:return u(t,r,e.properties);case 183:return c(t,e.expression)||c(t,e.name);case 184:return c(t,e.expression)||c(t,e.argumentExpression);case 185:case 186:return c(t,e.expression)||u(t,r,e.typeArguments)||u(t,r,e.arguments);case 187:return c(t,e.tag)||c(t,e.template);case 188:return c(t,e.type)||c(t,e.expression);case 189:case 192:case 193:case 194:return c(t,e.expression);case 196:return c(t,e.operand);case 201:return c(t,e.asteriskToken)||c(t,e.expression);case 195:return c(t,e.expression);case 197:return c(t,e.operand);case 198:return c(t,e.left)||c(t,e.operatorToken)||c(t,e.right);case 206:return c(t,e.expression)||c(t,e.type);case 207:return c(t,e.expression);case 208:return c(t,e.name);case 199:return c(t,e.condition)||c(t,e.questionToken)||c(t,e.whenTrue)||c(t,e.colonToken)||c(t,e.whenFalse);case 202:return c(t,e.expression);case 211:case 238:return u(t,r,e.statements);case 272:return u(t,r,e.statements)||c(t,e.endOfFileToken);case 212:return u(t,r,e.decorators)||u(t,r,e.modifiers)||c(t,e.declarationList);case 231:return u(t,r,e.declarations);case 214:return c(t,e.expression);case 215:return c(t,e.expression)||c(t,e.thenStatement)||c(t,e.elseStatement);case 216:return c(t,e.statement)||c(t,e.expression);case 217:return c(t,e.expression)||c(t,e.statement);case 218:return c(t,e.initializer)||c(t,e.condition)||c(t,e.incrementor)||c(t,e.statement);case 219:return c(t,e.initializer)||c(t,e.expression)||c(t,e.statement);case 220:return c(t,e.awaitModifier)||c(t,e.initializer)||c(t,e.expression)||c(t,e.statement);case 221:case 222:return c(t,e.label);case 223:return c(t,e.expression);case 224:return c(t,e.expression)||c(t,e.statement);case 225:return c(t,e.expression)||c(t,e.caseBlock);case 239:return u(t,r,e.clauses);case 264:return c(t,e.expression)||u(t,r,e.statements);case 265:return u(t,r,e.statements);case 226:return c(t,e.label)||c(t,e.statement);case 227:return c(t,e.expression);case 228:return c(t,e.tryBlock)||c(t,e.catchClause)||c(t,e.finallyBlock);case 267:return c(t,e.variableDeclaration)||c(t,e.block);case 149:return c(t,e.expression);case 233:case 203:case 234:return u(t,r,e.decorators)||u(t,r,e.modifiers)||c(t,e.name)||u(t,r,e.typeParameters)||u(t,r,e.heritageClauses)||u(t,r,e.members);case 235:return u(t,r,e.decorators)||u(t,r,e.modifiers)||c(t,e.name)||u(t,r,e.typeParameters)||c(t,e.type);case 236:return u(t,r,e.decorators)||u(t,r,e.modifiers)||c(t,e.name)||u(t,r,e.members);case 271:return c(t,e.name)||c(t,e.initializer);case 237:return u(t,r,e.decorators)||u(t,r,e.modifiers)||c(t,e.name)||c(t,e.body);case 241:return u(t,r,e.decorators)||u(t,r,e.modifiers)||c(t,e.name)||c(t,e.moduleReference);case 242:return u(t,r,e.decorators)||u(t,r,e.modifiers)||c(t,e.importClause)||c(t,e.moduleSpecifier);case 243:return c(t,e.name)||c(t,e.namedBindings);case 240:case 244:return c(t,e.name);case 245:case 249:return u(t,r,e.elements);case 248:return u(t,r,e.decorators)||u(t,r,e.modifiers)||c(t,e.exportClause)||c(t,e.moduleSpecifier);case 246:case 250:return c(t,e.propertyName)||c(t,e.name);case 247:return u(t,r,e.decorators)||u(t,r,e.modifiers)||c(t,e.expression);case 200:return c(t,e.head)||u(t,r,e.templateSpans);case 209:return c(t,e.expression)||c(t,e.literal);case 146:return c(t,e.expression);case 266:return u(t,r,e.types);case 205:return c(t,e.expression)||u(t,r,e.typeArguments);case 252:return c(t,e.expression);case 251:return u(t,r,e.decorators);case 296:return u(t,r,e.elements);case 253:return c(t,e.openingElement)||u(t,r,e.children)||c(t,e.closingElement);case 257:return c(t,e.openingFragment)||u(t,r,e.children)||c(t,e.closingFragment);case 254:case 255:return c(t,e.tagName)||c(t,e.attributes);case 261:return u(t,r,e.properties);case 260:return c(t,e.name)||c(t,e.initializer);case 262:return c(t,e.expression);case 263:return c(t,e.dotDotDotToken)||c(t,e.expression);case 256:return c(t,e.tagName);case 274:case 278:case 277:case 279:return c(t,e.type);case 280:return u(t,r,e.parameters)||c(t,e.type);case 281:return c(t,e.type);case 282:return u(t,r,e.tags);case 287:case 292:return e.isNameFirst?c(t,e.name)||c(t,e.typeExpression):c(t,e.typeExpression)||c(t,e.name);case 288:case 289:return c(t,e.typeExpression);case 285:return c(t,e.class);case 290:return u(t,r,e.typeParameters);case 291:return e.typeExpression&&274===e.typeExpression.kind?c(t,e.typeExpression)||c(t,e.fullName):c(t,e.fullName)||c(t,e.typeExpression);case 283:if(e.jsDocPropertyTags)for(var n=0,i=e.jsDocPropertyTags;n<i.length;n++){c(t,i[n]);}return;case 295:return c(t,e.expression)}}function _(t,r){for(var n=e.createScanner(t.languageVersion,!1,0,r),i=[];;){var a=n.scan();if(!e.isTrivia(a))break;var o={kind:n.getToken(),pos:n.getTokenPos(),end:n.getTextPos()};y(i,o,r.substring(o.pos,o.end));}t.pragmas=e.createMap();for(var s=0,c=i;s<c.length;s++){var u=c[s];if(t.pragmas.has(u.name)){var l=t.pragmas.get(u.name);l instanceof Array?l.push(u.args):t.pragmas.set(u.name,[l,u.args]);}else t.pragmas.set(u.name,u.args);}}function d(t,r){t.checkJsDirective=void 0,t.referencedFiles=[],t.typeReferenceDirectives=[],t.amdDependencies=[],t.hasNoDefaultLib=!1,t.pragmas.forEach(function(n,i){switch(i){case"reference":var a=t.referencedFiles,o=t.typeReferenceDirectives;e.forEach(e.toArray(n),function(n){n.arguments["no-default-lib"]?t.hasNoDefaultLib=!0:n.arguments.types?o.push({pos:n.arguments.types.pos,end:n.arguments.types.end,fileName:n.arguments.types.value}):n.arguments.path?a.push({pos:n.arguments.path.pos,end:n.arguments.path.end,fileName:n.arguments.path.value}):r(n.range.pos,n.range.end-n.range.pos,e.Diagnostics.Invalid_reference_directive_syntax);});break;case"amd-dependency":t.amdDependencies=e.map(e.toArray(n),function(e){var t=e.arguments;return{name:t.name,path:t.path}});break;case"amd-module":if(n instanceof Array)for(var s=0,c=n;s<c.length;s++){var u=c[s];t.moduleName&&r(u.range.pos,u.range.end-u.range.pos,e.Diagnostics.An_AMD_module_cannot_have_multiple_name_assignments),t.moduleName=u.arguments.name;}else t.moduleName=n.arguments.name;break;case"ts-nocheck":case"ts-check":e.forEach(e.toArray(n),function(e){(!t.checkJsDirective||e.range.pos>t.checkJsDirective.pos)&&(t.checkJsDirective={enabled:"ts-check"===i,end:e.range.end,pos:e.range.pos});});break;case"jsx":return;default:e.Debug.fail("Unhandled pragma kind");}});}!function(e){e[e.None=0]="None",e[e.Yield=1]="Yield",e[e.Await=2]="Await",e[e.Type=4]="Type",e[e.RequireCompleteParameterList=8]="RequireCompleteParameterList",e[e.IgnoreMissingOpenBrace=16]="IgnoreMissingOpenBrace",e[e.JSDoc=32]="JSDoc";}(t||(t={})),e.createNode=function(t,o,s){return 272===t?new(a||(a=e.objectAllocator.getSourceFileConstructor()))(t,o,s):71===t?new(i||(i=e.objectAllocator.getIdentifierConstructor()))(t,o,s):e.isNodeKind(t)?new(r||(r=e.objectAllocator.getNodeConstructor()))(t,o,s):new(n||(n=e.objectAllocator.getTokenConstructor()))(t,o,s)},e.forEachChild=l,e.createSourceFile=function(t,r,n,i,a){void 0===i&&(i=!1),e.performance.mark("beforeParse");var s=o.parseSourceFile(t,r,n,void 0,i,a);return e.performance.mark("afterParse"),e.performance.measure("Parse","beforeParse","afterParse"),s},e.parseIsolatedEntityName=function(e,t){return o.parseIsolatedEntityName(e,t)},e.parseJsonText=function(e,t){return o.parseJsonText(e,t)},e.isExternalModule=function(e){return void 0!==e.externalModuleIndicator},e.updateSourceFile=function(e,t,r,n){var i=s.updateSourceFile(e,t,r,n);return i.flags|=524288&e.flags,i},e.parseIsolatedJSDocComment=function(e,t,r){var n=o.JSDocParser.parseIsolatedJSDocComment(e,t,r);return n&&n.jsDoc&&o.fixupParentReferences(n.jsDoc),n},e.parseJSDocTypeExpressionForTests=function(e,t,r){return o.JSDocParser.parseJSDocTypeExpressionForTests(e,t,r)},function(t){var r,n,i,a,o,s,c,u,p,f,m,g,y,h,v,b,x,S=e.createScanner(6,!0),k=10240,T=!1;function D(e){return 4===e||2===e||1===e||6===e?1:0}function C(t,o,u,l){switch(r=e.objectAllocator.getNodeConstructor(),n=e.objectAllocator.getTokenConstructor(),i=e.objectAllocator.getIdentifierConstructor(),a=e.objectAllocator.getSourceFileConstructor(),p=t,c=u,s=[],y=0,m=e.createMap(),g=0,f=0,l){case 1:case 2:case 6:h=65536;break;default:h=0;}T=!1,S.setText(p),S.setOnError(G),S.setScriptTarget(o),S.setLanguageVariant(D(l));}function E(){S.setText(""),S.setOnError(void 0),s=void 0,o=void 0,m=void 0,c=void 0,p=void 0;}function N(t,r,n,i){var a=function(t){return e.fileExtensionIs(t,".d.ts")}(t);return a&&(h|=2097152),(o=w(t,r,i,a)).flags=h,Q(),_(o,p),d(o,function(t,r,n){s.push(e.createFileDiagnostic(o,t,r,n));}),o.statements=Be(0,wr),e.Debug.assert(1===X()),o.endOfFileToken=A(ue()),function(t){t.externalModuleIndicator=e.forEach(t.statements,function(t){return e.hasModifier(t,1)||241===t.kind&&252===t.moduleReference.kind||242===t.kind||247===t.kind||248===t.kind?t:void 0});}(o),o.nodeCount=f,o.identifierCount=g,o.identifiers=m,o.parseDiagnostics=s,n&&P(o),o}function A(t){var r=e.getJSDocCommentRanges(t,o.text);if(r)for(var n=0,i=r;n<i.length;n++){var a=i[n];t.jsDoc=e.append(t.jsDoc,x.parseJSDocComment(t,a.pos,a.end-a.pos));}return t}function P(t){var r=t;return void l(t,function t(n){if(n.parent!==r){n.parent=r;var i=r;if(r=n,l(n,t),e.hasJSDocNodes(n))for(var a=0,o=n.jsDoc;a<o.length;a++){var s=o[a];s.parent=n,r=s,l(s,t);}r=i;}})}function w(t,r,n,i){var o=new a(272,0,p.length);return f++,o.text=p,o.bindDiagnostics=[],o.languageVersion=r,o.fileName=e.normalizePath(t),o.languageVariant=D(n),o.isDeclarationFile=i,o.scriptKind=n,o}function F(e,t){e?h|=t:h&=~t;}function O(e){F(e,2048);}function I(e){F(e,4096);}function M(e){F(e,8192);}function L(e){F(e,16384);}function R(e,t){var r=e&h;if(r){F(!1,r);var n=t();return F(!0,r),n}return t()}function B(e,t){var r=e&~h;if(r){F(!0,r);var n=t();return F(!1,r),n}return t()}function K(e){return R(2048,e)}function j(e){return B(16384,e)}function J(e){return 0!=(h&e)}function z(){return J(4096)}function U(){return J(2048)}function q(){return J(8192)}function V(){return J(16384)}function W(e,t){var r=S.getTokenPos();H(r,S.getTextPos()-r,e,t);}function H(t,r,n,i){var a=e.lastOrUndefined(s);a&&t===a.start||s.push(e.createFileDiagnostic(o,t,r,n,i)),T=!0;}function G(e,t){H(S.getTextPos(),t||0,e);}function $(){return S.getStartPos()}function X(){return u}function Q(){return u=S.scan()}function Y(){return u=S.reScanGreaterToken()}function Z(){return u=S.scanJsxIdentifier()}function ee(){return u=S.scanJsxToken()}function te(t,r){var n=u,i=s.length,a=T,o=h,c=r?S.lookAhead(t):S.tryScan(t);return e.Debug.assert(o===h),c&&!r||(u=n,s.length=i,T=a),c}function re(e){return te(e,!0)}function ne(e){return te(e,!1)}function ie(){return 71===X()||(116!==X()||!z())&&((121!==X()||!V())&&X()>107)}function ae(t,r,n){return void 0===n&&(n=!0),X()===t?(n&&Q(),!0):(r?W(r):W(e.Diagnostics._0_expected,e.tokenToString(t)),!1)}function oe(e){return X()===e&&(Q(),!0)}function se(e){if(X()===e)return ue()}function ce(t,r,n){return se(t)||ge(t,!1,r||e.Diagnostics._0_expected,n||e.tokenToString(t))}function ue(){var e=de(X());return Q(),me(e)}function le(){return 25===X()||(18===X()||1===X()||S.hasPrecedingLineBreak())}function _e(){return le()?(25===X()&&Q(),!0):ae(25)}function de(t,a){f++;var o=a>=0?a:S.getStartPos();return e.isNodeKind(t)||0===t?new r(t,o,o):71===t?new i(t,o,o):new n(t,o,o)}function pe(e){var t=de(e);return 2&S.getTokenFlags()&&A(t),t}function fe(e,t,r){var n=e.length,i=n>=1&&n<=4?e.slice():e;return i.pos=t,i.end=void 0===r?S.getStartPos():r,i}function me(e,t){return e.end=void 0===t?S.getStartPos():t,h&&(e.flags|=h),T&&(T=!1,e.flags|=32768),e}function ge(t,r,n,i){r?H(S.getStartPos(),0,n,i):W(n,i);var a=de(t);return 71===t?a.escapedText="":(e.isLiteralKind(t)||e.isTemplateLiteralKind(t))&&(a.text=""),me(a)}function ye(e){var t=m.get(e);return void 0===t&&m.set(e,t=e),t}function he(t,r){if(g++,t){var n=de(71);return 71!==X()&&(n.originalKeywordKind=X()),n.escapedText=e.escapeLeadingUnderscores(ye(S.getTokenValue())),Q(),me(n)}return ge(71,1===X(),r||e.Diagnostics.Identifier_expected)}function ve(e){return he(ie(),e)}function be(t){return he(e.tokenIsIdentifierOrKeyword(X()),t)}function xe(){return e.tokenIsIdentifierOrKeyword(X())||9===X()||8===X()}function Se(e){if(9===X()||8===X()){var t=Xe();return t.text=ye(t.text),t}return e&&21===X()?function(){var e=de(146);return ae(21),e.expression=K(Lt),ae(22),me(e)}():be()}function ke(){return Se(!0)}function Te(e){return X()===e&&ne(Ce)}function De(){return Q(),!S.hasPrecedingLineBreak()&&Ee()}function Ce(){return 76===X()?83===Q():84===X()?(Q(),79===X()?re(Ne):39!==X()&&118!==X()&&17!==X()&&Ee()):79===X()?Ne():115===X()?(Q(),Ee()):De()}function Ee(){return 21===X()||17===X()||39===X()||24===X()||xe()}function Ne(){return Q(),75===X()||89===X()||109===X()||117===X()&&re(Tr)||120===X()&&re(Dr)}function Ae(t,r){if(je(t))return!0;switch(t){case 0:case 1:case 3:return!(25===X()&&r)&&Ar();case 2:return 73===X()||79===X();case 4:return re(_t);case 5:return re(Qr)||25===X()&&!r;case 6:return 21===X()||xe();case 12:return 21===X()||39===X()||24===X()||xe();case 17:return xe();case 9:return 21===X()||24===X()||xe();case 7:return 17===X()?re(Pe):r?ie()&&!Ie():It()&&!Ie();case 8:return Kr();case 10:return 26===X()||24===X()||Kr();case 18:return ie();case 15:if(26===X())return!0;case 11:return 24===X()||Mt();case 16:return nt();case 19:case 20:return 26===X()||St();case 21:return un();case 22:return e.tokenIsIdentifierOrKeyword(X());case 13:return e.tokenIsIdentifierOrKeyword(X())||17===X();case 14:return!0}e.Debug.fail("Non-exhaustive case in 'isListElement'.");}function Pe(){if(e.Debug.assert(17===X()),18===Q()){var t=Q();return 26===t||17===t||85===t||108===t}return!0}function we(){return Q(),ie()}function Fe(){return Q(),e.tokenIsIdentifierOrKeyword(X())}function Oe(){return Q(),e.tokenIsIdentifierOrKeywordOrGreaterThan(X())}function Ie(){return(108===X()||85===X())&&re(Me)}function Me(){return Q(),Mt()}function Le(){return Q(),St()}function Re(e){if(1===X())return!0;switch(e){case 1:case 2:case 4:case 5:case 6:case 12:case 9:case 22:return 18===X();case 3:return 18===X()||73===X()||79===X();case 7:return 17===X()||85===X()||108===X();case 8:return function(){if(le())return!0;if(Wt(X()))return!0;if(36===X())return!0;return!1}();case 18:return 29===X()||19===X()||17===X()||85===X()||108===X();case 11:return 20===X()||25===X();case 15:case 20:case 10:return 22===X();case 16:case 17:return 20===X()||22===X();case 19:return 26!==X();case 21:return 17===X()||18===X();case 13:return 29===X()||41===X();case 14:return 27===X()&&re(fn)}}function Be(e,t){var r=y;y|=1<<e;for(var n=[],i=$();!Re(e);)if(Ae(e,!1)){var a=Ke(e,t);n.push(a);}else if(Je(e))break;return y=r,fe(n,i)}function Ke(e,t){var r=je(e);return r?function(e){return S.setTextPos(e.end),Q(),e}(r):t()}function je(t){if(!T&&c){var r=c.currentNode(S.getStartPos());if(!e.nodeIsMissing(r))if(!r.intersectsChange)if(!e.containsParseError(r))if((6387712&r.flags)===h&&function(e,t){switch(t){case 5:return function(e){if(e)switch(e.kind){case 154:case 159:case 155:case 156:case 151:case 210:return!0;case 153:var t=e,r=71===t.name.kind&&123===t.name.originalKeywordKind;return!r}return!1}(e);case 2:return function(e){if(e)switch(e.kind){case 264:case 265:return!0}return!1}(e);case 0:case 1:case 3:return function(e){if(e)switch(e.kind){case 232:case 212:case 211:case 215:case 214:case 227:case 223:case 225:case 222:case 221:case 219:case 220:case 218:case 217:case 224:case 213:case 228:case 226:case 216:case 229:case 242:case 241:case 248:case 247:case 237:case 233:case 234:case 236:case 235:return!0}return!1}(e);case 6:return function(e){return 271===e.kind}(e);case 4:return function(e){if(e)switch(e.kind){case 158:case 152:case 159:case 150:case 157:return!0}return!1}(e);case 8:return function(e){if(230!==e.kind)return!1;return void 0===e.initializer}(e);case 16:return function(e){if(148!==e.kind)return!1;return void 0===e.initializer}(e);case 17:return!1}return!1}(r,t))return r.jsDocCache&&(r.jsDocCache=void 0),r}}function Je(t){return W(function(t){switch(t){case 0:case 1:return e.Diagnostics.Declaration_or_statement_expected;case 2:return e.Diagnostics.case_or_default_expected;case 3:return e.Diagnostics.Statement_expected;case 17:case 4:return e.Diagnostics.Property_or_signature_expected;case 5:return e.Diagnostics.Unexpected_token_A_constructor_method_accessor_or_property_was_expected;case 6:return e.Diagnostics.Enum_member_expected;case 7:return e.Diagnostics.Expression_expected;case 8:return e.Diagnostics.Variable_declaration_expected;case 9:return e.Diagnostics.Property_destructuring_pattern_expected;case 10:return e.Diagnostics.Array_element_destructuring_pattern_expected;case 11:return e.Diagnostics.Argument_expression_expected;case 12:return e.Diagnostics.Property_assignment_expected;case 15:return e.Diagnostics.Expression_or_comma_expected;case 16:return e.Diagnostics.Parameter_declaration_expected;case 18:return e.Diagnostics.Type_parameter_declaration_expected;case 19:return e.Diagnostics.Type_argument_expected;case 20:return e.Diagnostics.Type_expected;case 21:return e.Diagnostics.Unexpected_token_expected;case 22:case 13:case 14:return e.Diagnostics.Identifier_expected}}(t)),!!function(){for(var e=0;e<23;e++)if(y&1<<e&&(Ae(e,!0)||Re(e)))return!0;return!1}()||(Q(),!1)}function ze(e,t,r){var n=y;y|=1<<e;for(var i=[],a=$(),o=-1;;)if(Ae(e,!1)){var s=S.getStartPos();if(i.push(Ke(e,t)),o=S.getTokenPos(),oe(26))continue;if(o=-1,Re(e))break;ae(26),r&&25===X()&&!S.hasPrecedingLineBreak()&&Q(),s===S.getStartPos()&&Q();}else{if(Re(e))break;if(Je(e))break}y=n;var c=fe(i,a);return o>=0&&(c.hasTrailingComma=!0),c}function Ue(){return fe([],$())}function qe(e,t,r,n){if(ae(r)){var i=ze(e,t);return ae(n),i}return Ue()}function Ve(e,t){for(var r=e?be(t):ve(t),n=S.getStartPos();oe(23);){if(27===X()){r.jsdocDotPos=n;break}n=S.getStartPos(),r=We(r,He(e));}return r}function We(e,t){var r=de(145,e.pos);return r.left=e,r.right=t,me(r)}function He(t){if(S.hasPrecedingLineBreak()&&e.tokenIsIdentifierOrKeyword(X())&&re(kr))return ge(71,!0,e.Diagnostics.Identifier_expected);return t?be():ve()}function Ge(){var t,r=de(200);r.head=(t=Qe(X()),e.Debug.assert(14===t.kind,"Template head has wrong token kind"),t),e.Debug.assert(14===r.head.kind,"Template head has wrong token kind");var n=[],i=$();do{n.push($e());}while(15===e.lastOrUndefined(n).literal.kind);return r.templateSpans=fe(n,i),me(r)}function $e(){var t,r,n=de(209);return n.expression=K(Lt),18===X()?(u=S.reScanTemplateToken(),r=Qe(X()),e.Debug.assert(15===r.kind||16===r.kind,"Template fragment has wrong token kind"),t=r):t=ce(16,e.Diagnostics._0_expected,e.tokenToString(18)),n.literal=t,me(n)}function Xe(){return Qe(X())}function Qe(e){var t=de(e),r=S.getTokenValue();return t.text=r,S.hasExtendedUnicodeEscape()&&(t.hasExtendedUnicodeEscape=!0),S.isUnterminated()&&(t.isUnterminated=!0),8===t.kind&&(t.numericLiteralFlags=1008&S.getTokenFlags()),Q(),me(t),t}function Ye(){var t=de(161);return t.typeName=Ve(!0,e.Diagnostics.Type_expected),S.hasPrecedingLineBreak()||27!==X()||(t.typeArguments=qe(19,wt,27,29)),me(t)}function Ze(){var e=de(148);return 99!==X()&&94!==X()||(e.name=be(),ae(56)),e.type=wt(),me(e)}function et(){var e=de(147);return e.name=ve(),oe(85)&&(St()||!Mt()?e.constraint=wt():e.expression=Qt()),oe(58)&&(e.default=wt()),me(e)}function tt(){if(27===X())return qe(18,et,27,29)}function rt(){if(oe(56))return wt()}function nt(){return 24===X()||Kr()||e.isModifierKind(X())||57===X()||St(!0)}function it(){var t=pe(148);return 99===X()?(t.name=he(!0),t.type=rt(),me(t)):(t.decorators=Yr(),t.modifiers=Zr(),t.dotDotDotToken=se(24),t.name=jr(),0===e.getFullWidth(t.name)&&!e.hasModifiers(t)&&e.isModifierKind(X())&&Q(),t.questionToken=se(55),t.type=rt(),t.initializer=Rt(),me(t))}function at(t,r,n){32&r||(n.typeParameters=tt()),n.parameters=function(e){if(ae(19)){var t=z(),r=V();I(!!(1&e)),L(!!(2&e));var n=ze(16,32&e?Ze:it);if(I(t),L(r),!ae(20)&&8&e)return;return n}return 8&e?void 0:Ue()}(r),n.type=function(t,r){return function(t,r){if(36===t)return ae(t),!0;if(oe(56))return!0;if(r&&36===X())return W(e.Diagnostics._0_expected,e.tokenToString(56)),Q(),!0;return!1}(t,r)?function(){var e=ie()&&ne(Pt),t=wt();if(e){var r=de(160,e.pos);return r.parameterName=e,r.type=t,me(r)}return t}():void 0}(t,!!(4&r));}function ot(){oe(26)||_e();}function st(e){var t=pe(e);return 158===e&&ae(94),at(56,4,t),ot(),me(t)}function ct(){return 21===X()&&re(ut)}function ut(){if(Q(),24===X()||22===X())return!0;if(e.isModifierKind(X())){if(Q(),ie())return!0}else{if(!ie())return!1;Q();}return 56===X()||26===X()||55===X()&&(Q(),56===X()||26===X()||22===X())}function lt(e){return e.kind=159,e.parameters=qe(16,it,21,22),e.type=Ot(),ot(),me(e)}function _t(){if(19===X()||27===X())return!0;for(var t;e.isModifierKind(X());)t=!0,Q();return 21===X()||(xe()&&(t=!0,Q()),!!t&&(19===X()||27===X()||55===X()||56===X()||26===X()||le()))}function dt(){if(19===X()||27===X())return st(157);if(94===X()&&re(pt))return st(158);var e=pe(0);return e.modifiers=Zr(),ct()?lt(e):function(e){return e.name=ke(),e.questionToken=se(55),19===X()||27===X()?(e.kind=152,at(56,4,e)):(e.kind=150,e.type=Ot(),58===X()&&(e.initializer=Rt())),ot(),me(e)}(e)}function pt(){return Q(),19===X()||27===X()}function ft(){var e;return ae(17)?(e=Be(4,dt),ae(18)):e=Ue(),e}function mt(){return Q(),37===X()||38===X()?132===Q():(132===X()&&Q(),21===X()&&we()&&92===Q())}function gt(){var e=de(176);return ae(17),132!==X()&&37!==X()&&38!==X()||(e.readonlyToken=ue(),132!==e.readonlyToken.kind&&ce(132)),ae(21),e.typeParameter=function(){var e=de(147);return e.name=ve(),ae(92),e.constraint=wt(),me(e)}(),ae(22),55!==X()&&37!==X()&&38!==X()||(e.questionToken=ue(),55!==e.questionToken.kind&&ce(55)),e.type=Ot(),_e(),ae(18),me(e)}function yt(e){var t=pe(e);return 163===e&&ae(94),at(36,4,t),me(t)}function ht(){var e=ue();return 23===X()?void 0:e}function vt(e){var t,r=de(177);e&&((t=de(196)).operator=38,Q());var n=101===X()||86===X()?ue():Qe(X());return e&&(t.operand=n,me(t),n=t),r.literal=n,me(r)}function bt(){return 8===Q()}function xt(){switch(X()){case 119:case 137:case 134:case 138:case 122:case 140:case 131:case 135:return ne(ht)||Ye();case 39:return r=de(275),Q(),me(r);case 55:return function(){var e,t=S.getStartPos();return Q(),26===X()||18===X()||20===X()||29===X()||58===X()||49===X()?me(e=de(276,t)):((e=de(277,t)).type=wt(),me(e))}();case 89:return function(){if(re(pn)){var e=pe(280);return Q(),at(56,36,e),me(e)}var t=de(161);return t.typeName=be(),me(t)}();case 51:return function(e){var t=de(e);return Q(),t.type=xt(),me(t)}(278);case 13:case 9:case 8:case 101:case 86:return vt();case 38:return re(bt)?vt(!0):Ye();case 105:case 95:return ue();case 99:var e=(t=de(173),Q(),me(t));return 127!==X()||S.hasPrecedingLineBreak()?e:function(e){Q();var t=de(160,e.pos);return t.parameterName=e,t.type=wt(),me(t)}(e);case 103:return function(){var e=de(164);return ae(103),e.exprName=Ve(!0),me(e)}();case 17:return re(mt)?gt():function(){var e=de(165);return e.members=ft(),me(e)}();case 21:return function(){var e=de(167);return e.elementTypes=qe(20,wt,21,22),me(e)}();case 19:return function(){var e=de(172);return ae(19),e.type=wt(),ae(20),me(e)}();default:return Ye()}var t,r;}function St(e){switch(X()){case 119:case 137:case 134:case 122:case 138:case 141:case 105:case 140:case 95:case 99:case 103:case 131:case 17:case 21:case 27:case 49:case 48:case 94:case 9:case 8:case 101:case 86:case 135:case 39:case 55:case 51:case 24:case 126:return!0;case 38:return!e&&re(bt);case 19:return!e&&re(kt);default:return ie()}}function kt(){return Q(),20===X()||nt()||St()}function Tt(){for(var e=xt();!S.hasPrecedingLineBreak();)switch(X()){case 58:if(!(1048576&h))return e;e=Dt(279,e);break;case 51:e=Dt(278,e);break;case 55:if(!(1048576&h)&&re(Le))return e;e=Dt(277,e);break;case 21:var t;if(ae(21),St())(t=de(175,e.pos)).objectType=e,t.indexType=wt(),ae(22),e=me(t);else(t=de(166,e.pos)).elementType=e,ae(22),e=me(t);break;default:return e}return e}function Dt(e,t){Q();var r=de(e,t.pos);return r.type=t,me(r)}function Ct(){var e=X();switch(e){case 128:case 141:return function(e){var t=de(174);return ae(e),t.operator=e,t.type=Ct(),me(t)}(e);case 126:return function(){var e=de(171);ae(126);var t=de(147);return t.name=ve(),e.typeParameter=me(t),me(e)}();case 24:var t=de(281);return Q(),t.type=Tt(),me(t)}return Tt()}function Et(e,t,r){oe(r);var n=t();if(X()===r){for(var i=[n];oe(r);)i.push(t());var a=de(e,n.pos);a.types=fe(i,n.pos),n=me(a);}return n}function Nt(){return Et(169,Ct,48)}function At(){if(Q(),20===X()||24===X())return!0;if(function(){if(e.isModifierKind(X())&&Zr(),ie()||99===X())return Q(),!0;if(21===X()||17===X()){var t=s.length;return jr(),t===s.length}return!1}()){if(56===X()||26===X()||55===X()||58===X())return!0;if(20===X()&&(Q(),36===X()))return!0}return!1}function Pt(){var e=ve();if(127===X()&&!S.hasPrecedingLineBreak())return Q(),e}function wt(){return R(20480,Ft)}function Ft(e){if(27===X()||19===X()&&re(At))return yt(162);if(94===X())return yt(163);var t=Et(168,Nt,49);if(!e&&!S.hasPrecedingLineBreak()&&oe(85)){var r=de(170,t.pos);return r.checkType=t,r.extendsType=Ft(!0),ae(55),r.trueType=Ft(),ae(56),r.falseType=Ft(),me(r)}return t}function Ot(){return oe(56)?wt():void 0}function It(){switch(X()){case 99:case 97:case 95:case 101:case 86:case 8:case 9:case 13:case 14:case 19:case 21:case 17:case 89:case 75:case 94:case 41:case 63:case 71:return!0;case 91:return re(pt);default:return ie()}}function Mt(){if(It())return!0;switch(X()){case 37:case 38:case 52:case 51:case 80:case 103:case 105:case 43:case 44:case 27:case 121:case 116:return!0;default:return!!function(){if(U()&&92===X())return!1;return Gt()>0}()||ie()}}function Lt(){var e=q();e&&M(!1);for(var t,r=Bt();t=se(26);)r=$t(r,t,Bt());return e&&M(!0),r}function Rt(){return oe(58)?Bt():void 0}function Bt(){if(function(){if(116===X())return!!z()||re(Cr);return!1}())return t=de(201),Q(),S.hasPrecedingLineBreak()||39!==X()&&!Mt()?me(t):(t.asteriskToken=se(39),t.expression=Bt(),me(t));var t,r=function(){var t=function(){if(19===X()||27===X()||120===X())return re(jt);if(36===X())return 1;return 0}();if(0===t)return;var r=1===t?Ut(!0):ne(Jt);if(!r)return;var n=e.hasModifier(r,256),i=X();return r.equalsGreaterThanToken=ce(36),r.body=36===i||17===i?qt(n):ve(),me(r)}()||function(){if(120===X()&&1===re(zt)){var e=en(),t=Vt(0);return Kt(t,e)}return}();if(r)return r;var n=Vt(0);return 71===n.kind&&36===X()?Kt(n):e.isLeftHandSideExpression(n)&&e.isAssignmentOperator(Y())?$t(n,ue(),Bt()):function(t){var r=se(55);if(!r)return t;var n=de(199,t.pos);return n.condition=t,n.questionToken=r,n.whenTrue=R(k,Bt),n.colonToken=ce(56),n.whenFalse=e.nodeIsPresent(n.colonToken)?Bt():ge(71,!1,e.Diagnostics._0_expected,e.tokenToString(56)),me(n)}(n)}function Kt(t,r){var n;e.Debug.assert(36===X(),"parseSimpleArrowFunctionExpression should only have been called if we had a =>"),r?(n=de(191,r.pos)).modifiers=r:n=de(191,t.pos);var i=de(148,t.pos);return i.name=t,me(i),n.parameters=fe([i],i.pos,i.end),n.equalsGreaterThanToken=ce(36),n.body=qt(!!r),A(me(n))}function jt(){if(120===X()){if(Q(),S.hasPrecedingLineBreak())return 0;if(19!==X()&&27!==X())return 0}var t=X(),r=Q();if(19===t){if(20===r)switch(Q()){case 36:case 56:case 17:return 1;default:return 0}if(21===r||17===r)return 2;if(24===r)return 1;if(e.isModifierKind(r)&&120!==r&&re(we))return 1;if(!ie())return 0;switch(Q()){case 56:return 1;case 55:return Q(),56===X()||26===X()||58===X()||20===X()?1:0;case 26:case 58:case 20:return 2}return 0}return e.Debug.assert(27===t),ie()?1===o.languageVariant?re(function(){var e=Q();if(85===e)switch(Q()){case 58:case 29:return!1;default:return!0}else if(26===e)return!0;return!1})?1:0:2:0}function Jt(){return Ut(!1)}function zt(){if(120===X()){if(Q(),S.hasPrecedingLineBreak()||36===X())return 0;var e=Vt(0);if(!S.hasPrecedingLineBreak()&&71===e.kind&&36===X())return 1}return 0}function Ut(t){var r=pe(191);if(r.modifiers=en(),at(56,(e.hasModifier(r,256)?2:0)|(t?0:8),r),r.parameters&&(t||36===X()||17===X()))return r}function qt(e){return 17===X()?hr(e?2:0):25===X()||89===X()||75===X()||!Ar()||17!==X()&&89!==X()&&75!==X()&&57!==X()&&Mt()?e?j(Bt):R(16384,Bt):hr(16|(e?2:0))}function Vt(e){return Ht(e,Qt())}function Wt(e){return 92===e||144===e}function Ht(e,t){for(;;){Y();var r=Gt();if(!(40===X()?r>=e:r>e))break;if(92===X()&&U())break;if(118===X()){if(S.hasPrecedingLineBreak())break;Q(),t=Xt(t,wt());}else t=$t(t,ue(),Vt(r));}return t}function Gt(){switch(X()){case 54:return 1;case 53:return 2;case 49:return 3;case 50:return 4;case 48:return 5;case 32:case 33:case 34:case 35:return 6;case 27:case 29:case 30:case 31:case 93:case 92:case 118:return 7;case 45:case 46:case 47:return 8;case 37:case 38:return 9;case 39:case 41:case 42:return 10;case 40:return 11}return-1}function $t(e,t,r){var n=de(198,e.pos);return n.left=e,n.operatorToken=t,n.right=r,me(n)}function Xt(e,t){var r=de(206,e.pos);return r.expression=e,r.type=t,me(r)}function Qt(){if(function(){switch(X()){case 37:case 38:case 52:case 51:case 80:case 103:case 105:case 121:return!1;case 27:if(1!==o.languageVariant)return!1;default:return!0}}()){var t=Zt();return 40===X()?Ht(Gt(),t):t}var r=X(),n=Yt();if(40===X()){var i=e.skipTrivia(p,n.pos);188===n.kind?H(i,n.end-i,e.Diagnostics.A_type_assertion_expression_is_not_allowed_in_the_left_hand_side_of_an_exponentiation_expression_Consider_enclosing_the_expression_in_parentheses):H(i,n.end-i,e.Diagnostics.An_unary_expression_with_the_0_operator_is_not_allowed_in_the_left_hand_side_of_an_exponentiation_expression_Consider_enclosing_the_expression_in_parentheses,e.tokenToString(r));}return n}function Yt(){switch(X()){case 37:case 38:case 52:case 51:return(e=de(196)).operator=X(),Q(),e.operand=Yt(),me(e);case 80:return function(){var e=de(192);return Q(),e.expression=Yt(),me(e)}();case 103:return function(){var e=de(193);return Q(),e.expression=Yt(),me(e)}();case 105:return function(){var e=de(194);return Q(),e.expression=Yt(),me(e)}();case 27:return function(){var e=de(188);return ae(27),e.type=wt(),ae(29),e.expression=Yt(),me(e)}();case 121:if(121===X()&&(V()||re(Cr)))return function(){var e=de(195);return Q(),e.expression=Yt(),me(e)}();default:return Zt()}var e;}function Zt(){if(43===X()||44===X())return(t=de(196)).operator=X(),Q(),t.operand=er(),me(t);if(1===o.languageVariant&&27===X()&&re(Oe))return rr(!0);var t,r=er();return e.Debug.assert(e.isLeftHandSideExpression(r)),43!==X()&&44!==X()||S.hasPrecedingLineBreak()?r:((t=de(197,r.pos)).operand=r,t.operator=X(),Q(),me(t))}function er(){var t;return 91===X()&&re(pt)?(o.flags|=524288,t=ue()):t=97===X()?function(){var t=ue();if(19===X()||23===X()||21===X())return t;var r=de(183,t.pos);return r.expression=t,ce(23,e.Diagnostics.super_must_be_followed_by_an_argument_list_or_member_access),r.name=He(!0),me(r)}():tr(),function(e){for(;;)if(e=cr(e),27!==X()){if(19!==X())return e;var t=de(185,e.pos);t.expression=e,t.arguments=ur(),e=me(t);}else{var r=ne(lr);if(!r)return e;var t=de(185,e.pos);t.expression=e,t.typeArguments=r,t.arguments=ur(),e=me(t);}}(t)}function tr(){return cr(function(){switch(X()){case 8:case 9:case 13:return Xe();case 99:case 97:case 95:case 101:case 86:return ue();case 19:return t=pe(189),ae(19),t.expression=K(Lt),ae(20),me(t);case 21:return function(){var e=de(181);ae(21),S.hasPrecedingLineBreak()&&(e.multiLine=!0);return e.elements=ze(15,_r),ae(22),me(e)}();case 17:return fr();case 120:if(!re(Dr))break;return mr();case 75:return nn(pe(0),203);case 89:return mr();case 94:return function(){var e=S.getStartPos();if(ae(94),oe(23)){var t=de(208,e);return t.keywordToken=94,t.name=be(),me(t)}var r=de(186,e);r.expression=tr(),r.typeArguments=ne(lr),(r.typeArguments||19===X())&&(r.arguments=ur());return me(r)}();case 41:case 63:if(12===(u=S.reScanSlashToken()))return Xe();break;case 14:return Ge()}var t;return ve(e.Diagnostics.Expression_expected)}())}function rr(t){var r,n=function(e){var t=S.getStartPos();if(ae(27),29===X()){var r=de(258,t);return ee(),me(r)}var n,i=ar(),a=(o=de(261),o.properties=Be(13,sr),me(o));var o;29===X()?(n=de(255,t),ee()):(ae(41),e?ae(29):(ae(29,void 0,!1),ee()),n=de(254,t));return n.tagName=i,n.attributes=a,me(n)}(t);if(255===n.kind)(i=de(253,n.pos)).openingElement=n,i.children=ir(i.openingElement),i.closingElement=function(e){var t=de(256);ae(28),t.tagName=ar(),e?ae(29):(ae(29,void 0,!1),ee());return me(t)}(t),function e(t,r){return t.kind===r.kind&&(71===t.kind?t.escapedText===r.escapedText:99===t.kind||t.name.escapedText===r.name.escapedText&&e(t.expression,r.expression))}(i.openingElement.tagName,i.closingElement.tagName)||H(i.closingElement.pos,i.closingElement.end-i.closingElement.pos,e.Diagnostics.Expected_corresponding_JSX_closing_tag_for_0,e.getTextOfNodeFromSourceText(p,i.openingElement.tagName)),r=me(i);else if(258===n.kind){var i;(i=de(257,n.pos)).openingFragment=n,i.children=ir(i.openingFragment),i.closingFragment=function(t){var r=de(259);if(ae(28),e.tokenIsIdentifierOrKeyword(X())){var n=ar();H(n.pos,n.end-n.pos,e.Diagnostics.Expected_corresponding_closing_tag_for_JSX_fragment);}t?ae(29):(ae(29,void 0,!1),ee());return me(r)}(t),r=me(i);}else e.Debug.assert(254===n.kind),r=n;if(t&&27===X()){var a=ne(function(){return rr(!0)});if(a){W(e.Diagnostics.JSX_expressions_must_have_one_parent_element);var o=de(198,r.pos);return o.end=a.end,o.left=r,o.right=a,o.operatorToken=ge(26,!1,void 0),o.operatorToken.pos=o.operatorToken.end=o.right.pos,o}}return r}function nr(){switch(X()){case 10:case 11:return(t=de(10)).containsOnlyWhiteSpaces=11===u,u=S.scanJsxToken(),me(t);case 17:return or(!1);case 27:return rr(!1)}var t;e.Debug.fail("Unknown JSX child kind "+X());}function ir(t){var r=[],n=$(),i=y;for(y|=16384;u=S.reScanJsxToken(),28!==X();){if(1===X()){if(e.isJsxOpeningFragment(t))H(t.pos,t.end-t.pos,e.Diagnostics.JSX_fragment_has_no_corresponding_closing_tag);else{var a=t.tagName;H(a.pos,a.end-a.pos,e.Diagnostics.JSX_element_0_has_no_corresponding_closing_tag,e.getTextOfNodeFromSourceText(p,a));}break}if(7===X())break;var o=nr();o&&r.push(o);}return y=i,fe(r,n)}function ar(){Z();for(var e=99===X()?ue():be();oe(23);){var t=de(183,e.pos);t.expression=e,t.name=He(!0),e=me(t);}return e}function or(e){var t=de(263);if(ae(17))return 18!==X()&&(t.dotDotDotToken=se(24),t.expression=Bt()),e?ae(18):(ae(18,void 0,!1),ee()),me(t)}function sr(){if(17===X())return function(){var e=de(262);return ae(17),ae(24),e.expression=Lt(),ae(18),me(e)}();Z();var e=de(260);if(e.name=be(),58===X())switch(u=S.scanJsxAttributeValue()){case 9:e.initializer=Xe();break;default:e.initializer=or(!0);}return me(e)}function cr(e){for(;;){if(se(23)){var t=de(183,e.pos);t.expression=e,t.name=He(!0),e=me(t);}else if(51!==X()||S.hasPrecedingLineBreak())if(q()||!oe(21)){if(13!==X()&&14!==X())return e;var r=de(187,e.pos);r.tag=e,r.template=13===X()?Xe():Ge(),e=me(r);}else{var n=de(184,e.pos);if(n.expression=e,22!==X()&&(n.argumentExpression=K(Lt),9===n.argumentExpression.kind||8===n.argumentExpression.kind)){var i=n.argumentExpression;i.text=ye(i.text);}ae(22),e=me(n);}else{Q();var a=de(207,e.pos);a.expression=e,e=me(a);}}}function ur(){ae(19);var e=ze(11,dr);return ae(20),e}function lr(){if(oe(27)){var e=ze(19,wt);if(ae(29))return e&&function(){switch(X()){case 19:case 23:case 20:case 22:case 56:case 25:case 55:case 32:case 34:case 33:case 35:case 53:case 54:case 50:case 48:case 49:case 18:case 1:return!0;case 26:case 17:default:return!1}}()?e:void 0}}function _r(){return 24===X()?(e=de(202),ae(24),e.expression=Bt(),me(e)):26===X()?de(204):Bt();var e;}function dr(){return R(k,_r)}function pr(){var e=pe(0);if(se(24))return e.kind=270,e.expression=Bt(),me(e);if(e.decorators=Yr(),e.modifiers=Zr(),Te(125))return $r(e,155);if(Te(136))return $r(e,156);var t=se(39),r=ie();if(e.name=ke(),e.questionToken=se(55),t||19===X()||27===X())return Hr(e,t);if(r&&(26===X()||18===X()||58===X())){e.kind=269;var n=se(58);n&&(e.equalsToken=n,e.objectAssignmentInitializer=K(Bt));}else e.kind=268,ae(56),e.initializer=K(Bt);return me(e)}function fr(){var e=de(182);return ae(17),S.hasPrecedingLineBreak()&&(e.multiLine=!0),e.properties=ze(12,pr,!0),ae(18),me(e)}function mr(){var t=q();t&&M(!1);var r=pe(190);r.modifiers=Zr(),ae(89),r.asteriskToken=se(39);var n=r.asteriskToken?1:0,i=e.hasModifier(r,256)?2:0;return r.name=n&&i?B(20480,gr):n?function(e){return B(4096,e)}(gr):i?j(gr):gr(),at(56,n|i,r),r.body=hr(n|i),t&&M(!0),me(r)}function gr(){return ie()?ve():void 0}function yr(e,t){var r=de(211);return ae(17,t)||e?(S.hasPrecedingLineBreak()&&(r.multiLine=!0),r.statements=Be(1,wr),ae(18)):r.statements=Ue(),me(r)}function hr(e,t){var r=z();I(!!(1&e));var n=V();L(!!(2&e));var i=q();i&&M(!1);var a=yr(!!(16&e),t);return i&&M(!0),I(r),L(n),a}function vr(){var e=$();ae(88);var t,r,n=se(121);if(ae(19),25!==X()&&(t=104===X()||110===X()||76===X()?Ur(!0):B(2048,Lt)),n?ae(144):oe(144)){var i=de(220,e);i.awaitModifier=n,i.initializer=t,i.expression=K(Bt),ae(20),r=i;}else if(oe(92)){var a=de(219,e);a.initializer=t,a.expression=K(Lt),ae(20),r=a;}else{var o=de(218,e);o.initializer=t,ae(25),25!==X()&&20!==X()&&(o.condition=K(Lt)),ae(25),20!==X()&&(o.incrementor=K(Lt)),ae(20),r=o;}return r.statement=wr(),me(r)}function br(e){var t=de(e);return ae(222===e?72:77),le()||(t.label=ve()),_e(),me(t)}function xr(){return 73===X()?(e=de(264),ae(73),e.expression=K(Lt),ae(56),e.statements=Be(3,wr),me(e)):function(){var e=de(265);return ae(79),ae(56),e.statements=Be(3,wr),me(e)}();var e;}function Sr(){var e=de(228);return ae(102),e.tryBlock=yr(!1),e.catchClause=74===X()?function(){var e=de(267);ae(74),oe(19)?(e.variableDeclaration=zr(),ae(20)):e.variableDeclaration=void 0;return e.block=yr(!1),me(e)}():void 0,e.catchClause&&87!==X()||(ae(87),e.finallyBlock=yr(!1)),me(e)}function kr(){return Q(),e.tokenIsIdentifierOrKeyword(X())&&!S.hasPrecedingLineBreak()}function Tr(){return Q(),75===X()&&!S.hasPrecedingLineBreak()}function Dr(){return Q(),89===X()&&!S.hasPrecedingLineBreak()}function Cr(){return Q(),(e.tokenIsIdentifierOrKeyword(X())||8===X()||9===X())&&!S.hasPrecedingLineBreak()}function Er(){for(;;)switch(X()){case 104:case 110:case 76:case 89:case 75:case 83:return!0;case 109:case 139:return Q(),!S.hasPrecedingLineBreak()&&ie();case 129:case 130:return Mr();case 117:case 120:case 124:case 112:case 113:case 114:case 132:if(Q(),S.hasPrecedingLineBreak())return!1;continue;case 143:return Q(),17===X()||71===X()||84===X();case 91:return Q(),9===X()||39===X()||17===X()||e.tokenIsIdentifierOrKeyword(X());case 84:if(Q(),58===X()||39===X()||17===X()||79===X()||118===X())return!0;continue;case 115:Q();continue;default:return!1}}function Nr(){return re(Er)}function Ar(){switch(X()){case 57:case 25:case 17:case 104:case 110:case 89:case 75:case 83:case 90:case 81:case 106:case 88:case 77:case 72:case 96:case 107:case 98:case 100:case 102:case 78:case 74:case 87:return!0;case 91:return Nr()||re(pt);case 76:case 84:return Nr();case 120:case 124:case 109:case 129:case 130:case 139:case 143:return!0;case 114:case 112:case 113:case 115:case 132:return Nr()||!re(kr);default:return Mt()}}function Pr(){return Q(),ie()||17===X()||21===X()}function wr(){switch(X()){case 25:return e=de(213),ae(25),me(e);case 17:return yr(!1);case 104:return Vr(pe(230));case 110:if(re(Pr))return Vr(pe(230));break;case 89:return Wr(pe(232));case 75:return rn(pe(233));case 90:return function(){var e=de(215);return ae(90),ae(19),e.expression=K(Lt),ae(20),e.thenStatement=wr(),e.elseStatement=oe(82)?wr():void 0,me(e)}();case 81:return function(){var e=de(216);return ae(81),e.statement=wr(),ae(106),ae(19),e.expression=K(Lt),ae(20),oe(25),me(e)}();case 106:return function(){var e=de(217);return ae(106),ae(19),e.expression=K(Lt),ae(20),e.statement=wr(),me(e)}();case 88:return vr();case 77:return br(221);case 72:return br(222);case 96:return function(){var e=de(223);return ae(96),le()||(e.expression=K(Lt)),_e(),me(e)}();case 107:return function(){var e=de(224);return ae(107),ae(19),e.expression=K(Lt),ae(20),e.statement=B(4194304,wr),me(e)}();case 98:return function(){var e=de(225);ae(98),ae(19),e.expression=K(Lt),ae(20);var t=de(239);return ae(17),t.clauses=Be(2,xr),ae(18),e.caseBlock=me(t),me(e)}();case 100:return function(){var e=de(227);return ae(100),e.expression=S.hasPrecedingLineBreak()?void 0:K(Lt),_e(),me(e)}();case 102:case 74:case 87:return Sr();case 78:return function(){var e=de(229);return ae(78),_e(),me(e)}();case 57:return Or();case 120:case 109:case 139:case 129:case 130:case 124:case 76:case 83:case 84:case 91:case 112:case 113:case 114:case 117:case 115:case 132:case 143:if(Nr())return Or()}var e;return function(){var e=pe(0),t=K(Lt);return 71===t.kind&&oe(56)?(e.kind=226,e.label=t,e.statement=wr()):(e.kind=214,e.expression=t,_e()),me(e)}()}function Fr(e){return 124===e.kind}function Or(){var t=pe(0);if(t.decorators=Yr(),t.modifiers=Zr(),e.some(t.modifiers,Fr)){for(var r=0,n=t.modifiers;r<n.length;r++){n[r].flags|=2097152;}return B(2097152,function(){return Ir(t)})}return Ir(t)}function Ir(t){switch(X()){case 104:case 110:case 76:return Vr(t);case 89:return Wr(t);case 75:return rn(t);case 109:return function(e){return e.kind=234,ae(109),e.name=ve(),e.typeParameters=tt(),e.heritageClauses=an(),e.members=ft(),me(e)}(t);case 139:return function(e){return e.kind=235,ae(139),e.name=ve(),e.typeParameters=tt(),ae(58),e.type=wt(),_e(),me(e)}(t);case 83:return function(e){e.kind=236,ae(83),e.name=ve(),ae(17)?(e.members=ze(6,ln),ae(18)):e.members=Ue();return me(e)}(t);case 143:case 129:case 130:return function(e){var t=0;if(143===X())return dn(e);if(oe(130))t|=16;else if(ae(129),9===X())return dn(e);return function e(t,r){t.kind=237;var n=16&r;t.flags|=r;t.name=ve();t.body=oe(23)?e(de(0),4|n):_n();return me(t)}(e,t)}(t);case 91:return function(e){ae(91);var t,r=S.getStartPos();if(ie()&&(t=ve(),26!==X()&&142!==X()))return function(e,t){return e.kind=241,e.name=t,ae(58),e.moduleReference=function(){return 133===X()&&re(pn)?(e=de(252),ae(133),ae(19),e.expression=mn(),ae(20),me(e)):Ve(!1);var e;}(),_e(),me(e)}(e,t);e.kind=242,(t||39===X()||17===X())&&(e.importClause=function(e,t){var r=de(243,t);e&&(r.name=e);r.name&&!oe(26)||(r.namedBindings=39===X()?(n=de(244),ae(39),ae(118),n.name=ve(),me(n)):gn(245));var n;return me(r)}(t,r),ae(142));return e.moduleSpecifier=mn(),_e(),me(e)}(t);case 84:switch(Q(),X()){case 79:case 58:return function(e){e.kind=247,oe(58)?e.isExportEquals=!0:ae(79);return e.expression=Bt(),_e(),me(e)}(t);case 118:return function(e){return e.kind=240,ae(118),ae(130),e.name=ve(),_e(),me(e)}(t);default:return function(e){e.kind=248,oe(39)?(ae(142),e.moduleSpecifier=mn()):(e.exportClause=gn(249),(142===X()||9===X()&&!S.hasPrecedingLineBreak())&&(ae(142),e.moduleSpecifier=mn()));return _e(),me(e)}(t)}default:if(t.decorators||t.modifiers){var r=ge(251,!0,e.Diagnostics.Declaration_expected);return r.pos=t.pos,r.decorators=t.decorators,r.modifiers=t.modifiers,me(r)}}}function Mr(){return Q(),!S.hasPrecedingLineBreak()&&(ie()||9===X())}function Lr(e,t){if(17===X()||!le())return hr(e,t);_e();}function Rr(){if(26===X())return de(204);var e=de(180);return e.dotDotDotToken=se(24),e.name=jr(),e.initializer=Rt(),me(e)}function Br(){var e=de(180);e.dotDotDotToken=se(24);var t=ie(),r=ke();return t&&56!==X()?e.name=r:(ae(56),e.propertyName=r,e.name=jr()),e.initializer=Rt(),me(e)}function Kr(){return 17===X()||21===X()||ie()}function jr(){return 21===X()?(e=de(179),ae(21),e.elements=ze(10,Rr),ae(22),me(e)):17===X()?function(){var e=de(178);return ae(17),e.elements=ze(9,Br),ae(18),me(e)}():ve();var e;}function Jr(){return zr(!0)}function zr(e){var t=de(230);return t.name=jr(),e&&71===t.name.kind&&51===X()&&!S.hasPrecedingLineBreak()&&(t.exclamationToken=ue()),t.type=Ot(),Wt(X())||(t.initializer=Rt()),me(t)}function Ur(t){var r=de(231);switch(X()){case 104:break;case 110:r.flags|=1;break;case 76:r.flags|=2;break;default:e.Debug.fail();}if(Q(),144===X()&&re(qr))r.declarations=Ue();else{var n=U();O(t),r.declarations=ze(8,t?zr:Jr),O(n);}return me(r)}function qr(){return we()&&20===Q()}function Vr(e){return e.kind=212,e.declarationList=Ur(!1),_e(),me(e)}function Wr(t){t.kind=232,ae(89),t.asteriskToken=se(39),t.name=e.hasModifier(t,512)?gr():ve();var r=t.asteriskToken?1:0,n=e.hasModifier(t,256)?2:0;return at(56,r|n,t),t.body=Lr(r|n,e.Diagnostics.or_expected),me(t)}function Hr(t,r,n){t.kind=153,t.asteriskToken=r;var i=r?1:0,a=e.hasModifier(t,256)?2:0;return at(56,i|a,t),t.body=Lr(i|a,n),me(t)}function Gr(t){return t.kind=151,t.questionToken||51!==X()||S.hasPrecedingLineBreak()||(t.exclamationToken=ue()),t.type=Ot(),t.initializer=e.hasModifier(t,32)?K(Rt):R(6144,Rt),_e(),me(t)}function $r(e,t){return e.kind=t,e.name=ke(),at(56,0,e),e.body=Lr(0),me(e)}function Xr(e){switch(e){case 114:case 112:case 113:case 115:case 132:return!0;default:return!1}}function Qr(){var t;if(57===X())return!0;for(;e.isModifierKind(X());){if(Xr(t=X()))return!0;Q();}if(39===X())return!0;if(xe()&&(t=X(),Q()),21===X())return!0;if(void 0!==t){if(!e.isKeyword(t)||136===t||125===t)return!0;switch(X()){case 19:case 27:case 51:case 56:case 58:case 55:return!0;default:return le()}}return!1}function Yr(){for(var e,t=$();;){var r=$();if(!oe(57))break;var n=de(149,r);n.expression=B(8192,er),me(n),(e||(e=[])).push(n);}return e&&fe(e,t)}function Zr(t){for(var r,n=$();;){var i=S.getStartPos(),a=X();if(76===X()&&t){if(!ne(De))break}else if(!e.isModifierKind(X())||!ne(Ce))break;var o=me(de(a,i));(r||(r=[])).push(o);}return r&&fe(r,n)}function en(){var e;if(120===X()){var t=S.getStartPos(),r=X();Q(),e=fe([me(de(r,t))],t);}return e}function tn(){if(25===X()){var t=de(210);return Q(),me(t)}var r=pe(0);return r.decorators=Yr(),r.modifiers=Zr(!0),Te(125)?$r(r,155):Te(136)?$r(r,156):123===X()?function(t){return t.kind=154,ae(123),at(56,0,t),t.body=Lr(0,e.Diagnostics.or_expected),me(t)}(r):ct()?lt(r):e.tokenIsIdentifierOrKeyword(X())||9===X()||8===X()||39===X()||21===X()?function(t){var r=se(39);return t.name=ke(),t.questionToken=se(55),r||19===X()||27===X()?Hr(t,r,e.Diagnostics.or_expected):Gr(t)}(r):r.decorators||r.modifiers?(r.name=ge(71,!0,e.Diagnostics.Declaration_expected),Gr(r)):void e.Debug.fail("Should not have attempted to parse class member declaration.")}function rn(e){return nn(e,233)}function nn(e,t){return e.kind=t,ae(75),e.name=!ie()||108===X()&&re(Fe)?void 0:ve(),e.typeParameters=tt(),e.heritageClauses=an(),ae(17)?(e.members=Be(5,tn),ae(18)):e.members=Ue(),me(e)}function an(){if(un())return Be(21,on$$1)}function on$$1(){var e=X();if(85===e||108===e){var t=de(266);return t.token=e,Q(),t.types=ze(7,sn),me(t)}}function sn(){var e=de(205);return e.expression=er(),e.typeArguments=cn(),me(e)}function cn(){return 27===X()?qe(19,wt,27,29):void 0}function un(){return 85===X()||108===X()}function ln(){var e=pe(271);return e.name=ke(),e.initializer=K(Rt),me(e)}function _n(){var e=de(238);return ae(17)?(e.statements=Be(1,wr),ae(18)):e.statements=Ue(),me(e)}function dn(e){return e.kind=237,143===X()?(e.name=ve(),e.flags|=512):(e.name=Xe(),e.name.text=ye(e.name.text)),17===X()?e.body=_n():_e(),me(e)}function pn(){return 19===Q()}function fn(){return 41===Q()}function mn(){if(9===X()){var e=Xe();return e.text=ye(e.text),e}return Lt()}function gn(e){var t=de(e);return t.elements=qe(22,245===e?hn:yn,17,18),me(t)}function yn(){return vn(250)}function hn(){return vn(246)}function vn(t){var r=de(t),n=e.isKeyword(X())&&!ie(),i=S.getTokenPos(),a=S.getTextPos(),o=be();return 118===X()?(r.propertyName=o,ae(118),n=e.isKeyword(X())&&!ie(),i=S.getTokenPos(),a=S.getTextPos(),r.name=be()):r.name=o,246===t&&n&&H(i,a-i,e.Diagnostics.Identifier_expected),me(r)}t.parseSourceFile=function(t,r,n,i,a,o){C(r,n,i,o=e.ensureScriptKind(t,o));var s=N(t,n,a,o);return E(),s},t.parseIsolatedEntityName=function(e,t){C(e,t,void 0,1),Q();var r=Ve(!0),n=1===X()&&!s.length;return E(),n?r:void 0},t.parseJsonText=function(t,r){C(r,2,void 0,6);var n=o=w(t,2,6,!1);return Q(),1===X()?o.endOfFileToken=ue():17===X()||re(function(){return 9===X()})?(n.jsonObject=fr(),o.endOfFileToken=ce(1,e.Diagnostics.Unexpected_token)):ae(17),o.parseDiagnostics=s,E(),n},t.fixupParentReferences=P,function(e){e[e.SourceElements=0]="SourceElements",e[e.BlockStatements=1]="BlockStatements",e[e.SwitchClauses=2]="SwitchClauses",e[e.SwitchClauseStatements=3]="SwitchClauseStatements",e[e.TypeMembers=4]="TypeMembers",e[e.ClassMembers=5]="ClassMembers",e[e.EnumMembers=6]="EnumMembers",e[e.HeritageClauseElement=7]="HeritageClauseElement",e[e.VariableDeclarations=8]="VariableDeclarations",e[e.ObjectBindingElements=9]="ObjectBindingElements",e[e.ArrayBindingElements=10]="ArrayBindingElements",e[e.ArgumentExpressions=11]="ArgumentExpressions",e[e.ObjectLiteralMembers=12]="ObjectLiteralMembers",e[e.JsxAttributes=13]="JsxAttributes",e[e.JsxChildren=14]="JsxChildren",e[e.ArrayLiteralMembers=15]="ArrayLiteralMembers",e[e.Parameters=16]="Parameters",e[e.RestProperties=17]="RestProperties",e[e.TypeParameters=18]="TypeParameters",e[e.TypeArguments=19]="TypeArguments",e[e.TupleElementTypes=20]="TupleElementTypes",e[e.HeritageClauses=21]="HeritageClauses",e[e.ImportOrExportSpecifiers=22]="ImportOrExportSpecifiers",e[e.Count=23]="Count";}(v||(v={})),function(e){e[e.False=0]="False",e[e.True=1]="True",e[e.Unknown=2]="Unknown";}(b||(b={})),function(t){function r(e){var t=de(274,S.getTokenPos()),r=(e?oe:ae)(17);return t.type=B(1048576,wt),e&&!r||ae(18),P(t),me(t)}var n,i;function a(t,n){var i=p;t=t||0;var a,o,s,c=void 0===n?i.length:t+n;n=c-t,e.Debug.assert(t>=0),e.Debug.assert(t<=c),e.Debug.assert(c<=i.length);var l,_=[];return function(e,t){return 47===e.charCodeAt(t)&&42===e.charCodeAt(t+1)&&42===e.charCodeAt(t+2)&&42!==e.charCodeAt(t+3)}(i,t)?(S.scanRange(t+3,n-5,function(){var e,r=1,n=t-Math.max(i.lastIndexOf("\n",t),0)+4;function u(t){e||(e=n),_.push(t),n+=t.length;}for(var p=A();5===p;)p=A();4===p&&(r=0,n=0,p=A());e:for(;;){switch(p){case 57:0===r||1===r?(f(_),g(n),r=0,e=void 0,n++):u(S.getTokenText());break;case 4:_.push(S.getTokenText()),r=0,n=0;break;case 39:var m=S.getTokenText();1===r||2===r?(r=2,u(m)):(r=1,n+=m.length);break;case 71:u(S.getTokenText()),r=2;break;case 5:var y=S.getTokenText();2===r?_.push(y):void 0!==e&&n+y.length>e&&_.push(y.slice(e-n-1)),n+=y.length;break;case 1:break e;default:r=2,u(S.getTokenText());}p=A();}d(_),f(_),l=function(){var e=de(282,t);return e.tags=a&&fe(a,o,s),e.comment=_.length?_.join(""):void 0,me(e,c)}();}),l):l;function d(e){for(;e.length&&("\n"===e[0]||"\r"===e[0]);)e.shift();}function f(e){for(;e.length&&("\n"===e[e.length-1]||"\r"===e[e.length-1]);)e.pop();}function m(){for(;5===X()||4===X();)A();}function g(t){e.Debug.assert(57===X());var r=de(57,S.getTokenPos());r.end=S.getTextPos(),A();var n=P();if(m(),n){var i;if(n)switch(n.escapedText){case"augments":case"extends":i=function(e,t){var r=de(285,e.pos);return r.atToken=e,r.tagName=t,r.class=function(){var e=oe(17),t=de(205);t.expression=function(){for(var e=P(!0);oe(23);){var t=de(183,e.pos);t.expression=e,t.name=P(),e=me(t);}return e}(),t.typeArguments=cn();var r=me(t);return e&&ae(18),r}(),me(r)}(r,n);break;case"class":case"constructor":i=function(e,t){var r=de(286,e.pos);return r.atToken=e,r.tagName=t,me(r)}(r,n);break;case"arg":case"argument":case"param":i=k(r,n,1);break;case"return":case"returns":i=function(t,r){e.forEach(a,function(e){return 288===e.kind})&&H(r.pos,S.getTokenPos()-r.pos,e.Diagnostics._0_tag_already_specified,r.escapedText);var n=de(288,t.pos);return n.atToken=t,n.tagName=r,n.typeExpression=v(),me(n)}(r,n);break;case"template":i=function(t,r){e.some(a,e.isJSDocTemplateTag)&&H(r.pos,S.getTokenPos()-r.pos,e.Diagnostics._0_tag_already_specified,r.escapedText);var n=[],i=$();for(;;){var o=de(147),s=N();if(m(),!s)return void H(S.getStartPos(),0,e.Diagnostics.Identifier_expected);if(o.name=s,me(o),n.push(o),26!==X())break;A(),m();}var c=de(290,t.pos);return c.atToken=t,c.tagName=r,c.typeParameters=fe(n,i),me(c),c}(r,n);break;case"type":i=T(r,n);break;case"typedef":i=function(t,r){var n=v();m();var i=de(291,t.pos);if(i.atToken=t,i.tagName=r,i.fullName=function e(t){var r=S.getTokenPos(),n=P();if(n&&oe(23)){var i=de(237,r);return i.flags|=t,i.name=n,i.body=e(4),me(i)}return n&&4&t&&(n.isInJSDocNamespace=!0),n}(0),i.fullName)for(var a=i.fullName;;){if(71===a.kind||!a.body){i.name=71===a.kind?a:a.name;break}a=a.body;}if(m(),i.typeExpression=n,!n||x(n.type)){for(var o=void 0,s=void 0,c=void 0,u=S.getStartPos();o=ne(function(){return C(0)});)if(s||(s=de(283,u)),289===o.kind){if(c)break;c=o;}else s.jsDocPropertyTags=e.append(s.jsDocPropertyTags,o);s&&(n&&166===n.type.kind&&(s.isArrayType=!0),i.typeExpression=c&&c.typeExpression&&!x(c.typeExpression.type)?c.typeExpression:me(s));}return me(i)}(r,n);break;default:i=h(r,n);}else i=h(r,n);i&&(i.comment=y(t+i.end-i.pos),function(e){a?a.push(e):(a=[e],o=e.pos);s=e.end;}(i));}}function y(e){var t,r=[],n=0;function i(n){t||(t=e),r.push(n),e+=n.length;}var a=X();e:for(;;){switch(a){case 4:n>=1&&(n=0,r.push(S.getTokenText())),e=0;break;case 57:S.setTextPos(S.getTextPos()-1);case 1:break e;case 5:if(2===n)i(S.getTokenText());else{var o=S.getTokenText();void 0!==t&&e+o.length>t&&r.push(o.slice(t-e-1)),e+=o.length;}break;case 39:if(0===n){n=1,e+=1;break}default:n=2,i(S.getTokenText());}a=A();}return d(r),f(r),0===r.length?void 0:r.join("")}function h(e,t){var r=de(284,e.pos);return r.atToken=e,r.tagName=t,me(r)}function v(){return m(),17===X()?r():void 0}function b(){var e=oe(21),t=function(){var e=P(!0);oe(21)&&ae(22);for(;oe(23);){var t=P(!0);oe(21)&&ae(22),e=We(e,t);}return e}();return e&&(m(),se(58)&&Lt(),ae(22)),{name:t,isBracketed:e}}function x(t){switch(t.kind){case 135:return!0;case 166:return x(t.elementType);default:return e.isTypeReferenceNode(t)&&e.isIdentifier(t.typeName)&&"Object"===t.typeName.escapedText}}function k(t,r,n){var i=v(),a=!i;m();var o=b(),s=o.name,c=o.isBracketed;m(),a&&(i=v());var u=de(1===n?287:292,t.pos),l=function(t,r){if(t&&x(t.type)){for(var n=de(274,S.getTokenPos()),i=void 0,a=void 0,o=S.getStartPos(),s=void 0;i=ne(function(){return C(1,r)});)s=e.append(s,i);if(s)return(a=de(283,o)).jsDocPropertyTags=s,166===t.type.kind&&(a.isArrayType=!0),n.type=me(a),me(n)}}(i,s);return l&&(i=l,a=!0),u.atToken=t,u.tagName=r,u.typeExpression=i,u.name=s,u.isNameFirst=a,u.isBracketed=c,me(u)}function T(t,n){e.forEach(a,function(e){return 289===e.kind})&&H(n.pos,S.getTokenPos()-n.pos,e.Diagnostics._0_tag_already_specified,n.escapedText);var i=de(289,t.pos);return i.atToken=t,i.tagName=n,i.typeExpression=r(!0),me(i)}function D(t,r){for(;!e.isIdentifier(t)||!e.isIdentifier(r);){if(e.isIdentifier(t)||e.isIdentifier(r)||t.right.escapedText!==r.right.escapedText)return!1;t=t.left,r=r.left;}return t.escapedText===r.escapedText}function C(t,r){for(var n=!0,i=!1;;)switch(A()){case 57:if(n){var a=E(t);return!(a&&287===a.kind&&(e.isIdentifier(a.name)||!D(r,a.name.left)))&&a}i=!1;break;case 4:n=!0,i=!1;break;case 39:i&&(n=!1),i=!0;break;case 71:n=!1;break;case 1:return!1}}function E(t){e.Debug.assert(57===X());var r=de(57);r.end=S.getTextPos(),A();var n,i=P();if(m(),!i)return!1;switch(i.escapedText){case"type":return 0===t&&T(r,i);case"prop":case"property":n=0;break;case"arg":case"argument":case"param":n=1;break;default:return!1}if(t!==n)return!1;var a=k(r,i,t);return a.comment=y(a.end-a.pos),a}function N(){var e=oe(17),t=P();return e&&ae(18),t}function A(){return u=S.scanJSDocToken()}function P(t){if(void 0===t&&(t=!1),!e.tokenIsIdentifierOrKeyword(X()))return t?ge(71,!0,e.Diagnostics.Identifier_expected):void W(e.Diagnostics.Identifier_expected);var r=S.getTokenPos(),n=S.getTextPos(),a=de(71,r);return a.escapedText=e.escapeLeadingUnderscores(i.substring(r,n)),me(a,n),A(),a}}t.parseJSDocTypeExpressionForTests=function(e,t,n){C(e,6,void 0,1),o=w("file.js",6,1,!1),S.setText(e,t,n),u=S.scan();var i=r(),a=s;return E(),i?{jsDocTypeExpression:i,diagnostics:a}:void 0},t.parseJSDocTypeExpression=r,t.parseIsolatedJSDocComment=function(e,t,r){C(e,6,void 0,1),o={languageVariant:0,text:e};var n=a(t,r),i=s;return E(),n?{jsDoc:n,diagnostics:i}:void 0},t.parseJSDocComment=function(e,t,r){var n,i=u,c=s.length,l=T,_=a(t,r);return _&&(_.parent=e),65536&h&&(o.jsDocDiagnostics||(o.jsDocDiagnostics=[]),(n=o.jsDocDiagnostics).push.apply(n,s)),u=i,s.length=c,T=l,_},function(e){e[e.BeginningOfLine=0]="BeginningOfLine",e[e.SawAsterisk=1]="SawAsterisk",e[e.SavingComments=2]="SavingComments";}(n||(n={})),function(e){e[e.Property=0]="Property",e[e.Parameter=1]="Parameter";}(i||(i={})),t.parseJSDocCommentWorker=a;}(x=t.JSDocParser||(t.JSDocParser={}));}(o||(o={})),function(t){function r(t,r,i,o,s,c){return void(r?_(t):u(t));function u(t){var r="";if(c&&n(t)&&(r=o.substring(t.pos,t.end)),t._children&&(t._children=void 0),t.pos+=i,t.end+=i,c&&n(t)&&e.Debug.assert(r===s.substring(t.pos,t.end)),l(t,u,_),e.hasJSDocNodes(t))for(var d=0,p=t.jsDoc;d<p.length;d++){l(p[d],u,_);}a(t,c);}function _(e){e._children=void 0,e.pos+=i,e.end+=i;for(var t=0,r=e;t<r.length;t++){u(r[t]);}}}function n(e){switch(e.kind){case 9:case 8:case 71:return!0}return!1}function i(t,r,n,i,a){e.Debug.assert(t.end>=r,"Adjusting an element that was entirely before the change range"),e.Debug.assert(t.pos<=n,"Adjusting an element that was entirely after the change range"),e.Debug.assert(t.pos<=t.end),t.pos=Math.min(t.pos,i),t.end>=n?t.end+=a:t.end=Math.min(t.end,i),e.Debug.assert(t.pos<=t.end),t.parent&&(e.Debug.assert(t.pos>=t.parent.pos),e.Debug.assert(t.end<=t.parent.end));}function a(t,r){if(r){var n=t.pos;l(t,function(t){e.Debug.assert(t.pos>=n),n=t.end;}),e.Debug.assert(n<=t.end);}}function s(t,r){var n,i=t;if(l(t,function t(a){if(e.nodeIsMissing(a))return;if(!(a.pos<=r))return e.Debug.assert(a.pos>r),!0;if(a.pos>=i.pos&&(i=a),r<a.end)return l(a,t),!0;e.Debug.assert(a.end<=r),n=a;}),n){var a=function(e){for(;;){var t=o(e);if(!t)return e;e=t;}}(n);a.pos>i.pos&&(i=a);}return i;function o(t){var r;return l(t,function(t){e.nodeIsPresent(t)&&(r=t);}),r}}function c(t,r,n,i){var a=t.text;if(n&&(e.Debug.assert(a.length-n.span.length+n.newLength===r.length),i||e.Debug.shouldAssert(3))){var o=a.substr(0,n.span.start),s=r.substr(0,n.span.start);e.Debug.assert(o===s);var c=a.substring(e.textSpanEnd(n.span),a.length),u=r.substring(e.textSpanEnd(e.textChangeRangeNewSpan(n)),r.length);e.Debug.assert(c===u);}}var u;t.updateSourceFile=function(t,n,u,_){if(c(t,n,u,_=_||e.Debug.shouldAssert(2)),e.textChangeRangeIsUnchanged(u))return t;if(0===t.statements.length)return o.parseSourceFile(t.fileName,n,t.languageVersion,void 0,!0,t.scriptKind);var d=t;e.Debug.assert(!d.hasBeenIncrementallyParsed),d.hasBeenIncrementallyParsed=!0;var p=t.text,f=function(t){var r=t.statements,n=0;e.Debug.assert(n<r.length);var i=r[n],a=-1;return{currentNode:function(o){return o!==a&&(i&&i.end===o&&n<r.length-1&&(i=r[++n]),i&&i.pos===o||function(e){return r=void 0,n=-1,i=void 0,void l(t,a,o);function a(t){return e>=t.pos&&e<t.end&&(l(t,a,o),!0)}function o(t){if(e>=t.pos&&e<t.end)for(var s=0;s<t.length;s++){var c=t[s];if(c){if(c.pos===e)return r=t,n=s,i=c,!0;if(c.pos<e&&e<c.end)return l(c,a,o),!0}}return!1}}(o)),a=o,e.Debug.assert(!i||i.pos===o),i}}}(t),m=function(t,r){for(var n=r.span.start,i=0;n>0&&i<=1;i++){var a=s(t,n);e.Debug.assert(a.pos<=n);var o=a.pos;n=Math.max(0,o-1);}var c=e.createTextSpanFromBounds(n,e.textSpanEnd(r.span)),u=r.newLength+(r.span.start-n);return e.createTextChangeRange(c,u)}(t,u);c(t,n,m,_),e.Debug.assert(m.span.start<=u.span.start),e.Debug.assert(e.textSpanEnd(m.span)===e.textSpanEnd(u.span)),e.Debug.assert(e.textSpanEnd(e.textChangeRangeNewSpan(m))===e.textSpanEnd(e.textChangeRangeNewSpan(u)));var g=e.textChangeRangeNewSpan(m).length-m.span.length;return function(t,n,o,s,c,u,_,d){return void p(t);function p(t){if(e.Debug.assert(t.pos<=t.end),t.pos>o)r(t,!1,c,u,_,d);else{var m=t.end;if(m>=n)return t.intersectsChange=!0,t._children=void 0,i(t,n,o,s,c),l(t,p,f),void a(t,d);e.Debug.assert(m<n);}}function f(t){if(e.Debug.assert(t.pos<=t.end),t.pos>o)r(t,!0,c,u,_,d);else{var a=t.end;if(a>=n){t.intersectsChange=!0,t._children=void 0,i(t,n,o,s,c);for(var l=0,f=t;l<f.length;l++){var m=f[l];p(m);}}else e.Debug.assert(a<n);}}}(d,m.span.start,e.textSpanEnd(m.span),e.textSpanEnd(e.textChangeRangeNewSpan(m)),g,p,n,_),o.parseSourceFile(t.fileName,n,t.languageVersion,f,!0,t.scriptKind)},function(e){e[e.Value=-1]="Value";}(u||(u={}));}(s||(s={})),e.processCommentPragmas=_,e.processPragmasIntoFields=d;var p=e.createMap();function f(e){if(p.has(e))return p.get(e);var t=new RegExp("(\\s"+e+"\\s*=\\s*)('|\")(.+?)\\2","im");return p.set(e,t),t}var m=/^\/\/\/\s*<(\S+)\s.*?\/>/im,g=/^\/\/\/?\s*@(\S+)\s*(.*)\s*$/im;function y(t,r,n){var i=m.exec(n);if(i){var a=i[1].toLowerCase(),o=e.commentPragmas[a];if(!(o&&1&o.kind))return;if(o.args){for(var s={},c=0,u=o.args;c<u.length;c++){var l=u[c],_=f(l.name).exec(n);if(!_&&!l.optional)return;if(_)if(l.captureSpan){var d=r.pos+_.index+_[1].length+_[2].length;s[l.name]={value:_[3],pos:d,end:d+_[3].length};}else s[l.name]=_[3];}t.push({name:a,args:{arguments:s,range:r}});}else t.push({name:a,args:{arguments:{},range:r}});}else{var p=g.exec(n);if(p)return h(t,r,2,p);for(var y,v=/\s*@(\S+)\s*(.*)\s*$/gim;y=v.exec(n);)h(t,r,4,y);}}function h(t,r,n,i){if(i){var a=i[1].toLowerCase(),o=e.commentPragmas[a];if(o&&o.kind&n){var s=function(t,r){if(!r)return{};if(!t.args)return{};for(var n=r.split(/\s+/),i={},a=0;a<t.args.length;a++){var o=t.args[a];if(!n[a]&&!o.optional)return"fail";if(o.captureSpan)return e.Debug.fail("Capture spans not yet implemented for non-xml pragmas");i[o.name]=n[a];}return i}(o,i[2]);"fail"!==s&&t.push({name:a,args:{arguments:s,range:r}});}}}}(i||(i={})),function(e){var t;function r(t){return t.body?function t(n){switch(n.kind){case 234:case 235:return 0;case 236:if(e.isConst(n))return 2;break;case 242:case 241:if(!e.hasModifier(n,1))return 0;break;case 238:var i=0;return e.forEachChild(n,function(r){var n=t(r);switch(n){case 0:return;case 2:return void(i=2);case 1:return i=1,!0;default:e.Debug.assertNever(n);}}),i;case 237:return r(n);case 71:if(n.isInJSDocNamespace)return 0}return 1}(t.body):1}!function(e){e[e.NonInstantiated=0]="NonInstantiated",e[e.Instantiated=1]="Instantiated",e[e.ConstEnumOnly=2]="ConstEnumOnly";}(e.ModuleInstanceState||(e.ModuleInstanceState={})),e.getModuleInstanceState=r,function(e){e[e.None=0]="None",e[e.IsContainer=1]="IsContainer",e[e.IsBlockScopedContainer=2]="IsBlockScopedContainer",e[e.IsControlFlowContainer=4]="IsControlFlowContainer",e[e.IsFunctionLike=8]="IsFunctionLike",e[e.IsFunctionExpression=16]="IsFunctionExpression",e[e.HasLocals=32]="HasLocals",e[e.IsInterface=64]="IsInterface",e[e.IsObjectLiteralOrClassExpressionMethod=128]="IsObjectLiteralOrClassExpressionMethod",e[e.IsInferenceContainer=256]="IsInferenceContainer";}(t||(t={}));var n=function(){var t,n,l,_,d,p,f,m,g,y,h,v,b,x,S,k,T,D,C,E,N,A,P,w=0,F={flags:1},O={flags:1},I=0;function M(r,n,i,a,o){return e.createDiagnosticForNodeInSourceFile(e.getSourceFileOfNode(r)||t,r,n,i,a,o)}return function(r,i){t=r,n=i,l=e.getEmitScriptTarget(n),E=function(t,r){return!(!e.getStrictOptionValue(r,"alwaysStrict")||t.isDeclarationFile)||!!t.externalModuleIndicator}(t,i),A=e.createUnderscoreEscapedMap(),w=0,P=t.isDeclarationFile,N=e.objectAllocator.getSymbolConstructor(),t.locals||(ke(t),t.symbolCount=w,t.classifiableNames=A);t=void 0,n=void 0,l=void 0,_=void 0,d=void 0,p=void 0,f=void 0,m=void 0,g=!1,y=void 0,h=void 0,v=void 0,b=void 0,x=void 0,S=void 0,T=void 0,D=!1,C=0,I=0;};function L(e,t){return w++,new N(e,t)}function R(t,r,n){if(t.flags|=n,r.symbol=t,t.declarations?t.declarations.push(r):t.declarations=[r],1952&n&&!t.exports&&(t.exports=e.createSymbolTable()),6240&n&&!t.members&&(t.members=e.createSymbolTable()),67216319&n){var i=t.valueDeclaration;(!i||i.kind!==r.kind&&237===i.kind)&&(t.valueDeclaration=r);}}function B(t){if(247===t.kind)return t.isExportEquals?"export=":"default";var r=e.getNameOfDeclaration(t);if(r){if(e.isAmbientModule(t)){var n=e.getTextOfIdentifierOrLiteral(r);return e.isGlobalScopeAugmentation(t)?"__global":'"'+n+'"'}if(146===r.kind){var i=r.expression;return e.isStringOrNumericLiteral(i)?e.escapeLeadingUnderscores(i.text):(e.Debug.assert(e.isWellKnownSymbolSyntactically(i)),e.getPropertyNameForKnownSymbolName(e.idText(i.name)))}return e.isPropertyNameLiteral(r)?e.getEscapedTextOfIdentifierOrLiteral(r):void 0}switch(t.kind){case 154:return"__constructor";case 162:case 157:return"__call";case 163:case 158:return"__new";case 159:return"__index";case 248:return"__export";case 198:if(2===e.getSpecialPropertyAssignmentKind(t))return"export=";e.Debug.fail("Unknown binary declaration kind");break;case 232:case 233:return e.hasModifier(t,512)?"default":void 0;case 280:return e.isJSDocConstructSignature(t)?"__new":"__call";case 148:e.Debug.assert(280===t.parent.kind);var a=t.parent,o=a.parameters.indexOf(t);return"arg"+o;case 291:var s=e.getNameOfJSDocTypedef(t);return void 0!==s?s.escapedText:void 0}}function K(t){return e.isNamedDeclaration(t)?e.declarationNameToString(t.name):e.unescapeLeadingUnderscores(B(t))}function j(r,n,i,a,o,s){e.Debug.assert(!e.hasDynamicName(i));var c,u=e.hasModifier(i,512),l=u&&n?"default":B(i);if(void 0===l)c=L(0,"__missing");else if(c=r.get(l),2885600&a&&A.set(l,!0),c){if(s&&!c.isReplaceableByMethod)return c;if(c.flags&o)if(c.isReplaceableByMethod)r.set(l,c=L(0,l));else{e.isNamedDeclaration(i)&&(i.name.parent=i);var _=2&c.flags?e.Diagnostics.Cannot_redeclare_block_scoped_variable_0:e.Diagnostics.Duplicate_identifier_0;(384&c.flags||384&a)&&(_=e.Diagnostics.Enum_declarations_can_only_merge_with_namespace_or_other_enum_declarations),c.declarations&&c.declarations.length&&(u?_=e.Diagnostics.A_module_cannot_have_multiple_default_exports:c.declarations&&c.declarations.length&&(u||247===i.kind&&!i.isExportEquals)&&(_=e.Diagnostics.A_module_cannot_have_multiple_default_exports)),e.forEach(c.declarations,function(r){t.bindDiagnostics.push(M(e.getNameOfDeclaration(r)||r,_,K(r)));}),t.bindDiagnostics.push(M(e.getNameOfDeclaration(i)||i,_,K(i))),c=L(0,l);}}else r.set(l,c=L(0,l)),s&&(c.isReplaceableByMethod=!0);return R(c,i,a),c.parent?e.Debug.assert(c.parent===n,"Existing symbol parent should match new one"):c.parent=n,c}function J(t,r,n){var i=1&e.getCombinedModifierFlags(t);if(2097152&r)return 250===t.kind||241===t.kind&&i?j(d.symbol.exports,d.symbol,t,r,n):j(d.locals,void 0,t,r,n);291===t.kind&&e.Debug.assert(e.isInJavaScriptFile(t));var a=e.isJSDocTypedefTag(t)&&t.name&&71===t.name.kind&&t.name.isInJSDocNamespace;if(!e.isAmbientModule(t)&&(i||32&d.flags)||a){var o=67216319&r?1048576:0,s=j(d.locals,void 0,t,o,n);return s.exportSymbol=j(d.symbol.exports,d.symbol,t,r,n),t.localSymbol=s,s}return j(d.locals,void 0,t,r,n)}function z(e){if(P)V(e);else if(536870912&e.transformFlags)P=!0,V(e),P=!1,I|=e.transformFlags&~c(e.kind);else{var t=I;I=0,V(e),I=t|s(e,I);}}function U(t){if(void 0!==t)if(P)e.forEach(t,ke);else{var r=I;I=0;for(var n=0,i=0,a=t;i<a.length;i++){var o=a[i];ke(o),n|=-536870913&o.transformFlags;}t.transformFlags=536870912|n,I|=r;}}function q(t){e.forEachChild(t,ke,U);}function V(i){if(e.hasJSDocNodes(i))if(e.isInJavaScriptFile(i))for(var a=0,o=i.jsDoc;a<o.length;a++){var s=o[a];ke(s);}else for(var c=0,l=i.jsDoc;c<l.length;c++){var s=l[c];u(i,s);}if(function(t){if(!(1&y.flags))return!1;if(y===F){var i=e.isStatementButNotDeclaration(t)&&213!==t.kind||233===t.kind||237===t.kind&&function(e){var t=r(e);return 1===t||2===t&&n.preserveConstEnums}(t)||236===t.kind&&(!e.isConstEnumDeclaration(t)||n.preserveConstEnums);if(i){y=O;var a=!n.allowUnreachableCode&&!(2097152&t.flags)&&(212!==t.kind||3&e.getCombinedNodeFlags(t.declarationList)||e.forEach(t.declarationList.declarations,function(e){return e.initializer}));a&&Se(t,e.Diagnostics.Unreachable_code_detected);}}return!0}(i))q(i);else switch(i.kind){case 217:!function(e){var t=Q(),r=X(),n=X();Z(t,y),y=t,oe(e.expression,r,n),y=ie(r),se(e.statement,n,t),Z(t,y),y=ie(n);}(i);break;case 216:!function(t){var r=Q(),n=226===t.parent.kind?e.lastOrUndefined(T):void 0,i=n?n.continueTarget:X(),a=n?n.breakTarget:X();Z(r,y),y=r,se(t.statement,a,i),Z(i,y),y=ie(i),oe(t.expression,r,a),y=ie(a);}(i);break;case 218:!function(e){var t=Q(),r=X(),n=X();ke(e.initializer),Z(t,y),y=t,oe(e.condition,r,n),y=ie(r),se(e.statement,n,t),ke(e.incrementor),Z(t,y),y=ie(n);}(i);break;case 219:case 220:!function(e){var t=Q(),r=X();Z(t,y),y=t,220===e.kind&&ke(e.awaitModifier);ke(e.expression),Z(r,y),ke(e.initializer),231!==e.initializer.kind&&le(e.initializer);se(e.statement,r,t),Z(t,y),y=ie(r);}(i);break;case 215:!function(e){var t=X(),r=X(),n=X();oe(e.expression,t,r),y=ie(t),ke(e.thenStatement),Z(n,y),y=ie(r),ke(e.elseStatement),Z(n,y),y=ie(n);}(i);break;case 223:case 227:!function(e){ke(e.expression),223===e.kind&&(D=!0,b&&Z(b,y));y=F;}(i);break;case 222:case 221:!function(e){if(ke(e.label),e.label){var t=function(e){if(T)for(var t=0,r=T;t<r.length;t++){var n=r[t];if(n.name===e)return n}return}(e.label.escapedText);t&&(t.referenced=!0,ce(e,t.breakTarget,t.continueTarget));}else ce(e,h,v);}(i);break;case 228:!function(e){var t=X(),r=y;ke(e.tryBlock),Z(t,y);var n=y,i=F;e.catchClause&&(y=r,ke(e.catchClause),Z(t,y),i=y);if(e.finallyBlock){var a={flags:2048,antecedent:r,lock:{}};if(Z(t,a),y=ie(t),ke(e.finallyBlock),1&y.flags||1&n.flags&&1&i.flags&&(y=n===O||i===O?O:F),!(1&y.flags)){var o={flags:4096,antecedent:y};a.lock=o,y=o;}}else y=ie(t);}(i);break;case 225:!function(t){var r=X();ke(t.expression);var n=h,i=k;h=r,k=y,ke(t.caseBlock),Z(r,y);var a=e.forEach(t.caseBlock.clauses,function(e){return 265===e.kind});t.possiblyExhaustive=!a&&!r.antecedents,a||Z(r,te(k,t,0,0));h=n,k=i,y=ie(r);}(i);break;case 239:!function(t){var r=I;I=0;for(var i=t.clauses,a=F,o=0;o<i.length;o++){for(var s=o;!i[o].statements.length&&o+1<i.length;)ke(i[o]),o++;var c=X();Z(c,te(k,t.parent,s,o+1)),Z(c,a),y=ie(c);var u=i[o];ke(u),a=y,1&y.flags||o===i.length-1||!n.noFallthroughCasesInSwitch||Se(u,e.Diagnostics.Fallthrough_case_in_switch);}i.transformFlags=536870912|I,I|=r;}(i);break;case 264:!function(e){var t=y;y=k,ke(e.expression),y=t,U(e.statements);}(i);break;case 226:!function(r){var i=Q(),a=X();ke(r.label),Z(i,y);var o=function(e,t,r){var n={name:e,breakTarget:t,continueTarget:r,referenced:!1};return(T||(T=[])).push(n),n}(r.label.escapedText,a,i);ke(r.statement),T.pop(),o.referenced||n.allowUnusedLabels||t.bindDiagnostics.push(M(r.label,e.Diagnostics.Unused_label));r.statement&&216===r.statement.kind||(Z(a,y),y=ie(a));}(i);break;case 196:!function(e){if(51===e.operator){var t=x;x=S,S=t,q(e),S=x,x=t;}else q(e),43!==e.operator&&44!==e.operator||le(e.operand);}(i);break;case 197:!function(e){q(e),(43===e.operator||44===e.operator)&&le(e.operand);}(i);break;case 198:!function(t){var r=t.operatorToken.kind;if(53===r||54===r)if(function(e){for(;189===e.parent.kind||196===e.parent.kind&&51===e.parent.operator;)e=e.parent;return!function(e){var t=e.parent;switch(t.kind){case 215:case 217:case 216:return t.expression===e;case 218:case 199:return t.condition===e}return!1}(e)&&!ae(e.parent)}(t)){var n=X();_e(t,n,n),y=ie(n);}else _e(t,x,S);else if(q(t),e.isAssignmentOperator(r)&&!e.isAssignmentTarget(t)&&(le(t.left),58===r&&184===t.left.kind)){var i=t.left;$(i.expression)&&(y=ne(y,t));}}(i);break;case 192:!function(e){q(e),183===e.expression.kind&&le(e.expression);}(i);break;case 199:!function(e){var t=X(),r=X(),n=X();oe(e.condition,t,r),y=ie(t),ke(e.questionToken),ke(e.whenTrue),Z(n,y),y=ie(r),ke(e.colonToken),ke(e.whenFalse),Z(n,y),y=ie(n);}(i);break;case 230:!function(t){q(t),(t.initializer||e.isForInOrOfStatement(t.parent.parent))&&function t(r){var n=e.isOmittedExpression(r)?void 0:r.name;if(e.isBindingPattern(n))for(var i=0,a=n.elements;i<a.length;i++){var o=a[i];t(o);}else y=re(y,r);}(t);}(i);break;case 185:!function(t){var r=t.expression;for(;189===r.kind;)r=r.expression;190===r.kind||191===r.kind?(U(t.typeArguments),U(t.arguments),ke(t.expression)):q(t);if(183===t.expression.kind){var n=t.expression;$(n.expression)&&e.isPushOrUnshiftIdentifier(n.name)&&(y=ne(y,t));}}(i);break;case 282:!function(t){e.forEachChild(t,function(e){291!==e.kind&&ke(e);});}(i);break;case 291:!function(t){e.forEachChild(t,function(e){t.fullName&&e===t.name&&71!==t.fullName.kind||ke(e);});}(i);break;default:q(i);}}function W(t){switch(t.kind){case 71:case 99:case 183:return H(t);case 185:return function(e){if(e.arguments)for(var t=0,r=e.arguments;t<r.length;t++){var n=r[t];if(H(n))return!0}if(183===e.expression.kind&&H(e.expression.expression))return!0;return!1}(t);case 189:return W(t.expression);case 198:return function(t){switch(t.operatorToken.kind){case 58:return H(t.left);case 32:case 33:case 34:case 35:return $(t.left)||$(t.right)||G(t.right,t.left)||G(t.left,t.right);case 93:return $(t.left);case 92:return r=t.left,n=t.right,e.isStringLiteralLike(r)&&W(n);case 26:return W(t.right)}var r,n;return!1}(t);case 196:return 51===t.operator&&W(t.operand)}return!1}function H(e){return 71===e.kind||99===e.kind||97===e.kind||183===e.kind&&H(e.expression)}function G(t,r){return e.isTypeOfExpression(t)&&$(t.expression)&&e.isStringLiteralLike(r)}function $(e){switch(e.kind){case 189:return $(e.expression);case 198:switch(e.operatorToken.kind){case 58:return $(e.left);case 26:return $(e.right)}}return H(e)}function X(){return{flags:4,antecedents:void 0}}function Q(){return{flags:8,antecedents:void 0}}function Y(e){e.flags|=512&e.flags?1024:512;}function Z(t,r){1&r.flags||e.contains(t.antecedents,r)||((t.antecedents||(t.antecedents=[])).push(r),Y(r));}function ee(e,t,r){return 1&t.flags?t:r?101===r.kind&&64&e||86===r.kind&&32&e?F:W(r)?(Y(t),{flags:e,expression:r,antecedent:t}):t:32&e?t:F}function te(e,t,r,n){return W(t.expression)?(Y(e),{flags:128,switchStatement:t,clauseStart:r,clauseEnd:n,antecedent:e}):e}function re(e,t){return Y(e),{flags:16,antecedent:e,node:t}}function ne(e,t){Y(e);var r={flags:256,antecedent:e,node:t};return r}function ie(e){var t=e.antecedents;return t?1===t.length?t[0]:e:F}function ae(e){for(;;)if(189===e.kind)e=e.expression;else{if(196!==e.kind||51!==e.operator)return 198===e.kind&&(53===e.operatorToken.kind||54===e.operatorToken.kind);e=e.operand;}}function oe(e,t,r){var n=x,i=S;x=t,S=r,ke(e),x=n,S=i,e&&ae(e)||(Z(t,ee(32,y,e)),Z(r,ee(64,y,e)));}function se(e,t,r){var n=h,i=v;h=t,v=r,ke(e),h=n,v=i;}function ce(e,t,r){var n=222===e.kind?t:r;n&&(Z(n,y),y=F);}function ue(e){198===e.kind&&58===e.operatorToken.kind?le(e.left):le(e);}function le(e){if(H(e))y=re(y,e);else if(181===e.kind)for(var t=0,r=e.elements;t<r.length;t++){var n=r[t];202===n.kind?le(n.expression):ue(n);}else if(182===e.kind)for(var i=0,a=e.properties;i<a.length;i++){var o=a[i];268===o.kind?ue(o.initializer):269===o.kind?le(o.name):270===o.kind&&le(o.expression);}}function _e(e,t,r){var n=X();53===e.operatorToken.kind?oe(e.left,n,r):oe(e.left,t,n),y=ie(n),ke(e.operatorToken),oe(e.right,t,r);}function de(e){m&&(m.nextContainer=e),m=e;}function pe(r,n,i){switch(d.kind){case 237:return J(r,n,i);case 272:return function(r,n,i){return e.isExternalModule(t)?J(r,n,i):j(t.locals,void 0,r,n,i)}(r,n,i);case 203:case 233:return function(t,r,n){return e.hasModifier(t,32)?j(d.symbol.exports,d.symbol,t,r,n):j(d.symbol.members,d.symbol,t,r,n)}(r,n,i);case 236:return j(d.symbol.exports,d.symbol,r,n,i);case 165:case 283:case 182:case 234:case 261:return j(d.symbol.members,d.symbol,r,n,i);case 162:case 163:case 157:case 158:case 159:case 153:case 152:case 154:case 155:case 156:case 232:case 190:case 191:case 280:case 235:case 176:return j(d.locals,void 0,r,n,i)}}function fe(e){2097152&e.flags&&!function(e){var t=272===e.kind?e:e.body;if(t&&(272===t.kind||238===t.kind))for(var r=0,n=t.statements;r<n.length;r++){var i=n[r];if(248===i.kind||247===i.kind)return!0}return!1}(e)?e.flags|=32:e.flags&=-33;}function me(e){var t=r(e),n=0!==t;return pe(e,n?512:1024,n?67215503:0),t}function ge(e,t,r){var n=L(t,r);106508&t&&(n.parent=d.symbol),R(n,e,t);}function ye(t,r,n){switch(p.kind){case 237:J(t,r,n);break;case 272:if(e.isExternalModule(d)){J(t,r,n);break}default:p.locals||(p.locals=e.createSymbolTable(),de(p)),j(p.locals,void 0,t,r,n);}}function he(r){!(E&&r.originalKeywordKind>=108&&r.originalKeywordKind<=116)||e.isIdentifierName(r)||2097152&r.flags||t.parseDiagnostics.length||t.bindDiagnostics.push(M(r,function(r){if(e.getContainingClass(r))return e.Diagnostics.Identifier_expected_0_is_a_reserved_word_in_strict_mode_Class_definitions_are_automatically_in_strict_mode;if(t.externalModuleIndicator)return e.Diagnostics.Identifier_expected_0_is_a_reserved_word_in_strict_mode_Modules_are_automatically_in_strict_mode;return e.Diagnostics.Identifier_expected_0_is_a_reserved_word_in_strict_mode}(r),e.declarationNameToString(r)));}function ve(r,n){if(n&&71===n.kind){var i=n;if(o=i,e.isIdentifier(o)&&("eval"===o.escapedText||"arguments"===o.escapedText)){var a=e.getErrorSpanForNode(t,n);t.bindDiagnostics.push(e.createFileDiagnostic(t,a.start,a.length,function(r){if(e.getContainingClass(r))return e.Diagnostics.Invalid_use_of_0_Class_definitions_are_automatically_in_strict_mode;if(t.externalModuleIndicator)return e.Diagnostics.Invalid_use_of_0_Modules_are_automatically_in_strict_mode;return e.Diagnostics.Invalid_use_of_0_in_strict_mode}(r),e.idText(i)));}}var o;}function be(e){E&&ve(e,e.name);}function xe(r){if(l<2&&272!==p.kind&&237!==p.kind&&!e.isFunctionLike(p)){var n=e.getErrorSpanForNode(t,r);t.bindDiagnostics.push(e.createFileDiagnostic(t,n.start,n.length,function(r){if(e.getContainingClass(r))return e.Diagnostics.Function_declarations_are_not_allowed_inside_blocks_in_strict_mode_when_targeting_ES3_or_ES5_Class_definitions_are_automatically_in_strict_mode;if(t.externalModuleIndicator)return e.Diagnostics.Function_declarations_are_not_allowed_inside_blocks_in_strict_mode_when_targeting_ES3_or_ES5_Modules_are_automatically_in_strict_mode;return e.Diagnostics.Function_declarations_are_not_allowed_inside_blocks_in_strict_mode_when_targeting_ES3_or_ES5}(r)));}}function Se(r,n,i,a,o){var s=e.getSpanOfTokenAtPosition(t,r.pos);t.bindDiagnostics.push(e.createFileDiagnostic(t,s.start,s.length,n,i,a,o));}function ke(r){if(r){r.parent=_;var n=E;if(e.isInJavaScriptFile(r)&&function(t){if(!e.hasJSDocNodes(t))return;for(var r=0,n=t.jsDoc;r<n.length;r++){var i=n[r];if(i.tags)for(var a=0,o=i.tags;a<o.length;a++){var s=o[a];if(291===s.kind){var c=_;_=i,ke(s),_=c;}}}}(r),function(r){switch(r.kind){case 71:if(r.isInJSDocNamespace){for(var n=r.parent;n&&291!==n.kind;)n=n.parent;ye(n,524288,67901928);break}case 99:return y&&(e.isExpression(r)||269===_.kind)&&(r.flowNode=y),he(r);case 183:y&&H(r)&&(r.flowNode=y),e.isSpecialPropertyDeclaration(r)&&function(t){99===t.expression.kind?Ne(t):e.isEntityNameExpression(t)&&272===t.parent.parent.kind&&(e.isPropertyAccessExpression(t.expression)&&"prototype"===t.expression.name.escapedText?Ae(t,t.parent):Pe(t));}(r);break;case 198:var o=e.getSpecialPropertyAssignmentKind(r);switch(o){case 1:Ee(r);break;case 2:!function(r){var n=e.getRightMostAssignedExpression(r.right);if(e.isEmptyObjectLiteral(n)||d===t&&i(t,n))return void Ce(r);Ce(r),j(t.symbol.exports,t.symbol,r,1049092,0);}(r);break;case 3:Ae(r.left,r);break;case 6:!function(e){e.left.parent=e,e.right.parent=e;var t=e.left;we(t,t,!1);}(r);break;case 4:Ne(r);break;case 5:!function(r){var n=r.left;r.left.parent=r,r.right.parent=r,e.isIdentifier(n.expression)&&d===t&&a(t,n.expression)?Ee(r):Pe(n);}(r);break;case 0:break;default:e.Debug.fail("Unknown special property assignment kind");}return function(t){E&&e.isLeftHandSideExpression(t.left)&&e.isAssignmentOperator(t.operatorToken.kind)&&ve(t,t.left);}(r);case 267:return function(e){E&&e.variableDeclaration&&ve(e,e.variableDeclaration.name);}(r);case 192:return function(r){if(E&&71===r.expression.kind){var n=e.getErrorSpanForNode(t,r.expression);t.bindDiagnostics.push(e.createFileDiagnostic(t,n.start,n.length,e.Diagnostics.delete_cannot_be_called_on_an_identifier_in_strict_mode));}}(r);case 8:return function(r){E&&32&r.numericLiteralFlags&&t.bindDiagnostics.push(M(r,e.Diagnostics.Octal_literals_are_not_allowed_in_strict_mode));}(r);case 197:return function(e){E&&ve(e,e.operand);}(r);case 196:return function(e){E&&(43!==e.operator&&44!==e.operator||ve(e,e.operand));}(r);case 224:return function(t){E&&Se(t,e.Diagnostics.with_statements_are_not_allowed_in_strict_mode);}(r);case 173:return void(g=!0);case 160:break;case 147:return function(t){171===t.parent.kind?f?(f.locals||(f.locals=e.createSymbolTable()),j(f.locals,void 0,t,262144,67639784)):ge(t,262144,B(t)):pe(t,262144,67639784);}(r);case 148:return function(t){!E||2097152&t.flags||ve(t,t.name);e.isBindingPattern(t.name)?ge(t,1,"__"+t.parent.parameters.indexOf(t)):pe(t,1,67216319);if(e.isParameterPropertyDeclaration(t)){var r=t.parent.parent;j(r.symbol.members,r.symbol,t,4|(t.questionToken?16777216:0),0);}}(r);case 230:return Ie(r);case 180:return r.flowNode=y,Ie(r);case 151:case 150:return function(e){return Me(e,4|(e.questionToken?16777216:0),0)}(r);case 268:case 269:return Me(r,4,0);case 271:return Me(r,8,68008959);case 157:case 158:case 159:return pe(r,131072,0);case 153:case 152:return Me(r,8192|(r.questionToken?16777216:0),e.isObjectLiteralMethod(r)?0:67208127);case 232:return function(r){t.isDeclarationFile||2097152&r.flags||e.isAsyncFunction(r)&&(C|=1024);be(r),E?(xe(r),ye(r,16,67215791)):pe(r,16,67215791);}(r);case 154:return pe(r,16384,0);case 155:return Me(r,32768,67150783);case 156:return Me(r,65536,67183551);case 162:case 280:case 163:return function(t){var r=L(131072,B(t));R(r,t,131072);var n=L(2048,"__type");R(n,t,2048),n.members=e.createSymbolTable(),n.members.set(r.escapedName,r);}(r);case 165:case 283:case 176:return function(e){return ge(e,2048,"__type")}(r);case 182:return function(r){var n;if(function(e){e[e.Property=1]="Property",e[e.Accessor=2]="Accessor";}(n||(n={})),E)for(var i=e.createUnderscoreEscapedMap(),a=0,o=r.properties;a<o.length;a++){var s=o[a];if(270!==s.kind&&71===s.name.kind){var c=s.name,u=268===s.kind||269===s.kind||153===s.kind?1:2,l=i.get(c.escapedText);if(l){if(1===u&&1===l){var _=e.getErrorSpanForNode(t,c);t.bindDiagnostics.push(e.createFileDiagnostic(t,_.start,_.length,e.Diagnostics.An_object_literal_cannot_have_multiple_properties_with_the_same_name_in_strict_mode));}}else i.set(c.escapedText,u);}}return ge(r,4096,"__object")}(r);case 190:case 191:return function(r){t.isDeclarationFile||2097152&r.flags||e.isAsyncFunction(r)&&(C|=1024);y&&(r.flowNode=y);be(r);var n=r.name?r.name.escapedText:"__function";return ge(r,16,n)}(r);case 185:e.isInJavaScriptFile(r)&&function(r){!t.commonJsModuleIndicator&&e.isRequireCall(r,!1)&&Ce(r);}(r);break;case 203:case 233:return E=!0,function(r){if(233===r.kind)ye(r,32,68008383);else{var n=r.name?r.name.escapedText:"__class";ge(r,32,n),r.name&&A.set(r.name.escapedText,!0);}var i=r.symbol,a=L(4194308,"prototype"),o=i.exports.get(a.escapedName);o&&(r.name&&(r.name.parent=r),t.bindDiagnostics.push(M(o.declarations[0],e.Diagnostics.Duplicate_identifier_0,e.symbolName(a))));i.exports.set(a.escapedName,a),a.parent=i;}(r);case 234:return ye(r,64,67901832);case 235:return ye(r,524288,67901928);case 236:return function(t){return e.isConst(t)?ye(t,128,68008831):ye(t,256,68008191)}(r);case 237:return function(r){if(fe(r),e.isAmbientModule(r))if(e.hasModifier(r,1)&&Se(r,e.Diagnostics.export_modifier_cannot_be_applied_to_ambient_modules_and_module_augmentations_since_they_are_always_visible),e.isModuleAugmentationExternal(r))me(r);else{var n=void 0;if(9===r.name.kind){var i=r.name.text;e.hasZeroOrOneAsteriskCharacter(i)?n=e.tryParsePattern(i):Se(r.name,e.Diagnostics.Pattern_0_can_have_at_most_one_Asterisk_character,i);}var a=pe(r,512,67215503);t.patternAmbientModules=e.append(t.patternAmbientModules,n&&{pattern:n,symbol:a});}else{var o=me(r);if(0!==o){var a=r.symbol;a.constEnumOnlyModule=!(304&a.flags)&&2===o&&!1!==a.constEnumOnlyModule;}}}(r);case 261:return function(e){return ge(e,4096,"__jsxAttributes")}(r);case 260:return function(e,t,r){return pe(e,t,r)}(r,4,0);case 241:case 244:case 246:case 250:return pe(r,2097152,2097152);case 240:return function(r){r.modifiers&&r.modifiers.length&&t.bindDiagnostics.push(M(r,e.Diagnostics.Modifiers_cannot_appear_here));if(272!==r.parent.kind)return void t.bindDiagnostics.push(M(r,e.Diagnostics.Global_module_exports_may_only_appear_at_top_level));var n=r.parent;if(!e.isExternalModule(n))return void t.bindDiagnostics.push(M(r,e.Diagnostics.Global_module_exports_may_only_appear_in_module_files));if(!n.isDeclarationFile)return void t.bindDiagnostics.push(M(r,e.Diagnostics.Global_module_exports_may_only_appear_in_declaration_files));t.symbol.globalExports=t.symbol.globalExports||e.createSymbolTable(),j(t.symbol.globalExports,t.symbol,r,2097152,2097152);}(r);case 243:return function(e){e.name&&pe(e,2097152,2097152);}(r);case 248:return function(e){d.symbol&&d.symbol.exports?e.exportClause||j(d.symbol.exports,d.symbol,e,8388608,0):ge(e,8388608,B(e));}(r);case 247:return function(t){if(d.symbol&&d.symbol.exports){var r=247===t.kind&&e.exportAssignmentIsAlias(t)?2097152:4;j(d.symbol.exports,d.symbol,t,r,67108863);}else ge(t,2097152,B(t));}(r);case 272:return Te(r.statements),fe(t),void(e.isExternalModule(t)&&De());case 211:if(!e.isFunctionLike(r.parent))return;case 238:return Te(r.statements);case 287:if(283!==r.parent.kind)break;case 292:var s=r,c=s.isBracketed||s.typeExpression&&279===s.typeExpression.type.kind?16777220:4;return pe(s,c,0);case 291:var u=r.fullName;if(!u||71===u.kind)ye(r,524288,67901928);}}(r),r.kind>144){var o=_;_=r;var c=function(t){switch(t.kind){case 203:case 233:case 236:case 182:case 165:case 283:case 261:return 1;case 234:return 65;case 237:case 235:case 176:return 33;case 170:return 256;case 272:return 37;case 153:if(e.isObjectLiteralOrClassExpressionMethod(t))return 173;case 154:case 232:case 152:case 155:case 156:case 157:case 280:case 162:case 158:case 159:case 163:return 45;case 190:case 191:return 61;case 238:return 4;case 151:return t.initializer?4:0;case 267:case 218:case 219:case 220:case 239:return 2;case 211:return e.isFunctionLike(t.parent)?0:2}return 0}(r);0===c?z(r):function(t,r){var n=d,i=p;1&r?(d=p=t,32&r&&(d.locals=e.createSymbolTable()),de(d)):2&r&&((p=t).locals=void 0);if(4&r){var a=y,o=h,s=v,c=b,u=T,l=D,_=16&r&&!e.hasModifier(t,256)&&!!e.getImmediatelyInvokedFunctionExpression(t);_||(y={flags:2},144&r&&(y.container=t)),b=_||154===t.kind?X():void 0,h=void 0,v=void 0,T=void 0,D=!1,z(t),t.flags&=-1409,!(1&y.flags)&&8&r&&e.nodeIsPresent(t.body)&&(t.flags|=128,D&&(t.flags|=256)),272===t.kind&&(t.flags|=C),b&&(Z(b,y),y=ie(b),154===t.kind&&(t.returnFlowNode=y)),_||(y=a),h=o,v=s,b=c,T=u,D=l;}else if(64&r)g=!1,z(t),t.flags=g?64|t.flags:-65&t.flags;else if(256&r){var m=f;f=t,t.locals=void 0,z(t),f=m;}else z(t);d=n,p=i;}(r,c),_=o;}else P||0!=(536870912&r.transformFlags)||(I|=s(r,0));E=n;}}function Te(r){if(!E)for(var n=0,i=r;n<i.length;n++){var a=i[n];if(!e.isPrologueDirective(a))return;if(o=a,void 0,'"use strict"'===(s=e.getSourceTextOfNodeFromSourceFile(t,o.expression))||"'use strict'"===s)return void(E=!0)}var o,s;}function De(){ge(t,512,'"'+e.removeFileExtension(t.fileName)+'"');}function Ce(e){t.commonJsModuleIndicator||(t.commonJsModuleIndicator=e,t.externalModuleIndicator||De());}function Ee(t){Ce(t);var r=t.left,n=Oe(r.expression,function(t,r){if(r){var n=e.getJSInitializerSymbol(r);return R(n,t,67110400),n}});n&&j(n.exports,n,r,1048580,0);}function Ne(t){e.Debug.assert(e.isInJavaScriptFile(t));var r=e.getThisContainer(t,!1);switch(r.kind){case 232:case 190:r.symbol.members=r.symbol.members||e.createSymbolTable(),j(r.symbol.members,r.symbol,t,4,0);break;case 154:case 151:case 153:case 155:case 156:var n=r.parent,i=e.hasModifier(r,32)?n.symbol.exports:n.symbol.members;j(i,n.symbol,t,4,0,!0);}}function Ae(e,t){var r=e.expression,n=r.expression;e.parent=t,n.parent=r,r.parent=e,we(n,e,!0);}function Pe(e){e.expression.parent=e,we(e.expression,e,!1);}function we(t,r,n){var i,a=e.getJSInitializerSymbol(Fe(t));if(e.isBinaryExpression(r.parent)){var o=e.isPropertyAccessExpression(r.parent.left)&&"prototype"===r.parent.left.name.escapedText;i=272===r.parent.parent.parent.kind&&!!e.getJavascriptInitializer(r.parent.right,o);}else i=272===r.parent.parent.kind;if(!n&&(!a||!(1920&a.flags))&&i){Oe(r.expression,function(e,t){return t?(R(t,e,67110400),t):a=j(a?a.exports:d.locals,a,e,67110400,106639)});}if(a&&5168&a.flags){var s=n?a.members||(a.members=e.createSymbolTable()):a.exports||(a.exports=e.createSymbolTable()),c=4|(i?67108864:0),u=0&~(i?67108864:0);j(s,a,r,c,u);}}function Fe(t){if(e.isIdentifier(t))return o(d,t.escapedText);var r=e.getJSInitializerSymbol(Fe(t.expression));return r&&r.exports&&r.exports.get(t.name.escapedText)}function Oe(r,n){if(i(t,r))return t.symbol;if(e.isIdentifier(r))return n(r,Fe(r));var a=e.getJSInitializerSymbol(Oe(r.expression,n));return e.Debug.assert(!!a&&!!a.exports),n(r.name,a.exports.get(r.name.escapedText))}function Ie(t){E&&ve(t,t.name),e.isBindingPattern(t.name)||(e.isBlockOrCatchScoped(t)?function(e){ye(e,2,67216319);}(t):e.isParameterDeclaration(t)?pe(t,1,67216319):pe(t,1,67216318));}function Me(r,n,i){return t.isDeclarationFile||2097152&r.flags||!e.isAsyncFunction(r)||(C|=1024),y&&e.isObjectLiteralOrClassExpressionMethod(r)&&(r.flowNode=y),e.hasDynamicName(r)?ge(r,n,"__computed"):pe(r,n,i)}}();function i(t,r){return e.isExportsIdentifier(r)||e.isModuleExportsPropertyAccessExpression(r)||e.isIdentifier(r)&&a(t,r)}function a(t,r){var n=o(t,r.escapedText);return n&&n.valueDeclaration&&e.isVariableDeclaration(n.valueDeclaration)&&n.valueDeclaration.initializer&&function t(r,n){return i(r,n)||e.isAssignmentExpression(n,!0)&&(t(r,n.left)||t(r,n.right))}(t,n.valueDeclaration.initializer)}function o(e,t){var r=e.locals&&e.locals.get(t);return r?r.exportSymbol||r:e.symbol&&e.symbol.exports&&e.symbol.exports.get(t)}function s(t,r){var n=t.kind;switch(n){case 185:return function(e,t){var r=t,n=e.expression;e.typeArguments&&(r|=3);(524288&t||402653184&n.transformFlags)&&(r|=192,268435456&n.transformFlags&&(r|=16384));91===n.kind&&(r|=67108864,16384&t&&(r|=32768));return e.transformFlags=536870912|r,-940049730&r}(t,r);case 186:return function(e,t){var r=t;e.typeArguments&&(r|=3);524288&t&&(r|=192);return e.transformFlags=536870912|r,-940049730&r}(t,r);case 237:return function(t,r){var n=3;0==(2&e.getModifierFlags(t))&&(n|=r);return t.transformFlags=536870912|n,-977327426&n}(t,r);case 189:return function(e,t){var r=t,n=e.expression,i=n.kind,a=n.transformFlags;206!==i&&188!==i||(r|=3);1024&a&&(r|=1024);return e.transformFlags=536870912|r,-536872258&r}(t,r);case 198:return function(e,t){var r=t,n=e.operatorToken.kind,i=e.left.kind;58===n&&182===i?r|=3272:58===n&&181===i?r|=3264:40!==n&&62!==n||(r|=32);return e.transformFlags=536870912|r,-939525442&r}(t,r);case 214:return function(e,t){var r=t;1024&e.expression.transformFlags&&(r|=192);return e.transformFlags=536870912|r,-939525442&r}(t,r);case 148:return function(t,r){var n=r,i=t.name,a=t.initializer,o=t.dotDotDotToken;(t.questionToken||t.type||4096&r||e.isThisIdentifier(i))&&(n|=3);e.hasModifier(t,92)&&(n|=262147);1048576&r&&(n|=8);(8388608&r||a||o)&&(n|=131264);return t.transformFlags=536870912|n,-939525442&n}(t,r);case 191:return function(t,r){var n=192|r;(e.hasModifier(t,2270)||t.typeParameters||t.type)&&(n|=3);e.hasModifier(t,256)&&(n|=16);1048576&r&&(n|=8);16384&r&&(n|=32768);return t.transformFlags=536870912|n,-1003902274&n}(t,r);case 190:return function(t,r){var n=r;(e.hasModifier(t,2270)||t.typeParameters||t.type)&&(n|=3);e.hasModifier(t,256)&&(n|=t.asteriskToken?8:16);1048576&r&&(n|=8);163840&r&&(n|=192);t.asteriskToken&&(n|=768);return t.transformFlags=536870912|n,-1003935042&n}(t,r);case 232:return function(t,r){var n,i=e.getModifierFlags(t);!t.body||2&i?n=3:(n=33554432|r,(2270&i||t.typeParameters||t.type)&&(n|=3),256&i&&(n|=t.asteriskToken?8:16),1048576&r&&(n|=8),163840&r&&(n|=192),t.asteriskToken&&(n|=768));return t.transformFlags=536870912|n,-1003935042&n}(t,r);case 230:return function(e,t){var r=t;r|=8388800,1048576&t&&(r|=8);e.type&&(r|=3);return e.transformFlags=536870912|r,-939525442&r}(t,r);case 231:return function(e,t){var r=33554432|t;8388608&t&&(r|=192);3&e.flags&&(r|=4194496);return e.transformFlags=536870912|r,-948962626&r}(t,r);case 212:return function(t,r){var n,i=t.declarationList.transformFlags;e.hasModifier(t,2)?n=3:(n=r,8388608&i&&(n|=192));return t.transformFlags=536870912|n,-939525442&n}(t,r);case 226:return function(t,r){var n=r;4194304&r&&e.isIterationStatement(t,!0)&&(n|=192);return t.transformFlags=536870912|n,-939525442&n}(t,r);case 233:return function(t,r){var n;e.hasModifier(t,2)?n=3:(n=192|r,(274432&r||t.typeParameters)&&(n|=3),65536&r&&(n|=16384));return t.transformFlags=536870912|n,-942011714&n}(t,r);case 203:return function(e,t){var r=192|t;(274432&t||e.typeParameters)&&(r|=3);65536&t&&(r|=16384);return e.transformFlags=536870912|r,-942011714&r}(t,r);case 266:return function(t,r){var n=r;switch(t.token){case 85:n|=192;break;case 108:n|=3;break;default:e.Debug.fail("Unexpected token for heritage clause");}return t.transformFlags=536870912|n,-939525442&n}(t,r);case 267:return function(t,r){var n=r;t.variableDeclaration?e.isBindingPattern(t.variableDeclaration.name)&&(n|=192):n|=8;return t.transformFlags=536870912|n,-940574018&n}(t,r);case 205:return function(e,t){var r=192|t;e.typeArguments&&(r|=3);return e.transformFlags=536870912|r,-939525442&r}(t,r);case 154:return function(t,r){var n=r;!e.hasModifier(t,2270)&&t.body||(n|=3);1048576&r&&(n|=8);return t.transformFlags=536870912|n,-1003668802&n}(t,r);case 151:return function(e,t){var r=3|t;e.initializer&&(r|=8192);return e.transformFlags=536870912|r,-939525442&r}(t,r);case 153:return function(t,r){var n=192|r;(t.decorators||e.hasModifier(t,2270)||t.typeParameters||t.type||t.name&&e.isComputedPropertyName(t.name)||!t.body)&&(n|=3);1048576&r&&(n|=8);e.hasModifier(t,256)&&(n|=t.asteriskToken?8:16);t.asteriskToken&&(n|=768);return t.transformFlags=536870912|n,-1003668802&n}(t,r);case 155:case 156:return function(t,r){var n=r;(t.decorators||e.hasModifier(t,2270)||t.type||t.name&&e.isComputedPropertyName(t.name)||!t.body)&&(n|=3);1048576&r&&(n|=8);return t.transformFlags=536870912|n,-1003668802&n}(t,r);case 241:return function(t,r){var n=r;e.isExternalModuleImportEqualsDeclaration(t)||(n|=3);return t.transformFlags=536870912|n,-939525442&n}(t,r);case 183:return function(e,t){var r=t;134217728&r&&(r^=134217728,r|=268435456);return e.transformFlags=536870912|r,-671089986&r}(t,r);case 184:return function(e,t){var r=t;134217728&e.expression.transformFlags&&(r&=-134217729,r|=268435456);return e.transformFlags=536870912|r,-671089986&r}(t,r);default:return function(e,t,r){var n=r,i=939525441;switch(t){case 120:case 195:n|=24;break;case 188:case 206:case 295:n|=3,i=536872257;break;case 114:case 112:case 113:case 117:case 124:case 76:case 236:case 271:case 207:case 132:n|=3;break;case 253:case 254:case 255:case 10:case 256:case 257:case 258:case 259:case 260:case 261:case 262:case 263:n|=4;break;case 13:case 14:case 15:case 16:case 200:case 187:case 269:case 115:case 208:n|=192;break;case 9:e.hasExtendedUnicodeEscape&&(n|=192);break;case 8:384&e.numericLiteralFlags&&(n|=192);break;case 220:e.awaitModifier&&(n|=8),n|=192;break;case 201:n|=16777416;break;case 119:case 134:case 131:case 135:case 137:case 122:case 138:case 105:case 147:case 150:case 152:case 157:case 158:case 159:case 160:case 161:case 162:case 163:case 164:case 165:case 166:case 167:case 168:case 169:case 170:case 171:case 172:case 234:case 235:case 173:case 174:case 175:case 176:case 177:case 240:n=3,i=-3;break;case 146:n|=2097152,16384&r&&(n|=65536);break;case 202:n|=524480;break;case 270:n|=1048584;break;case 97:n|=134217920,i=536872257;break;case 99:n|=16384;break;case 178:n|=8388800,524288&r&&(n|=1048584),i=940049729;break;case 179:n|=8388800,i=940049729;break;case 180:n|=192,e.dotDotDotToken&&(n|=524288);break;case 149:n|=4099;break;case 182:i=942740801,2097152&r&&(n|=192),65536&r&&(n|=16384),1048576&r&&(n|=8);break;case 181:case 186:i=940049729,524288&r&&(n|=192);break;case 216:case 217:case 218:case 219:4194304&r&&(n|=192);break;case 272:32768&r&&(n|=192);break;case 223:case 221:case 222:n|=33554432;}return e.transformFlags=536870912|n,n&~i}(t,n,r)}}function c(e){if(e>=160&&e<=177)return-3;switch(e){case 185:case 186:case 181:return 940049729;case 237:return 977327425;case 148:return 939525441;case 191:return 1003902273;case 190:case 232:return 1003935041;case 231:return 948962625;case 233:case 203:return 942011713;case 154:return 1003668801;case 153:case 155:case 156:return 1003668801;case 119:case 134:case 131:case 137:case 135:case 122:case 138:case 105:case 147:case 150:case 152:case 157:case 158:case 159:case 234:case 235:return-3;case 182:return 942740801;case 267:return 940574017;case 178:case 179:return 940049729;case 188:case 206:case 295:case 189:case 97:return 536872257;case 183:case 184:return 671089985;default:return 939525441}}function u(t,r){r.parent=t,e.forEachChild(r,function(e){return u(r,e)});}e.bindSourceFile=function(t,r){e.performance.mark("beforeBind"),n(t,r),e.performance.mark("afterBind"),e.performance.measure("Bind","beforeBind","afterBind");},e.isExportsOrModuleExportsOrAlias=i,e.computeTransformFlagsForNode=s,e.getTransformFlagsSubtreeExclusions=c;}(i||(i={})),function(e){e.createGetSymbolWalker=function(t,r,n,i,a,o,s,c,u,l){return function(_){void 0===_&&(_=function(){return!0});var d=[],p=[];return{walkType:function(t){try{return f(t),{visitedTypes:e.getOwnValues(d),visitedSymbols:e.getOwnValues(p)}}finally{e.clear(d),e.clear(p);}},walkSymbol:function(t){try{return y(t),{visitedTypes:e.getOwnValues(d),visitedSymbols:e.getOwnValues(p)}}finally{e.clear(d),e.clear(p);}}};function f(t){if(t&&!d[t.id]){d[t.id]=t;var r=y(t.symbol);if(!r){if(65536&t.flags){var n=t,a=n.objectFlags;4&a&&function(t){f(t.target),e.forEach(t.typeArguments,f);}(t),32&a&&function(e){f(e.typeParameter),f(e.constraintType),f(e.templateType),f(e.modifiersType);}(t),3&a&&(g(o=t),e.forEach(o.typeParameters,f),e.forEach(i(o),f),f(o.thisType)),24&a&&g(n);}var o;32768&t.flags&&function(e){f(u(e));}(t),393216&t.flags&&function(t){e.forEach(t.types,f);}(t),524288&t.flags&&function(e){f(e.type);}(t),1048576&t.flags&&function(e){f(e.objectType),f(e.indexType),f(e.constraint);}(t);}}}function m(i){var a=r(i);a&&f(a.type),e.forEach(i.typeParameters,f);for(var o=0,s=i.parameters;o<s.length;o++){var c=s[o];y(c);}f(t(i)),f(n(i));}function g(e){var t=c(e,0);f(t);var r=c(e,1);f(r);for(var n=a(e),i=0,o=n.callSignatures;i<o.length;i++){var s=o[i];m(s);}for(var u=0,l=n.constructSignatures;u<l.length;u++){var s=l[u];m(s);}for(var _=0,d=n.properties;_<d.length;_++){var p=d[_];y(p);}}function y(t){if(t){var r=e.getSymbolId(t);if(!p[r]){if(p[r]=t,!_(t))return!0;var n=o(t);f(n),1952&t.flags&&t.exports.forEach(y),e.forEach(t.declarations,function(e){if(e.type&&164===e.type.kind){var t=e.type,r=s(l(t.exprName));y(r);}});}}}}};}(i||(i={})),function(e){function t(t){t.trace(e.formatMessage.apply(void 0,arguments));}function n(e,t){return e.traceResolution&&void 0!==t.trace}function i(e,t){return t&&{path:t.path,extension:t.ext,packageId:e}}function a(e){return i(void 0,e)}var o;function s(t){if(t)return e.Debug.assert(e.extensionIsTypeScript(t.extension)),{fileName:t.path,packageId:t.packageId}}function c(e,t,r,n){return{resolvedModule:e&&{resolvedFileName:e.path,originalPath:t,extension:e.extension,isExternalLibraryImport:r,packageId:e.packageId},failedLookupLocations:n}}function u(r,n,i,a){return r?o("typings")||o("types"):o("main");function o(r){if(e.hasProperty(n,r)){var o=n[r];if(e.isString(o)){var s=e.normalizePath(e.combinePaths(i,o));return a.traceEnabled&&t(a.host,e.Diagnostics.package_json_has_0_field_1_that_references_2,r,o,s),s}a.traceEnabled&&t(a.host,e.Diagnostics.Expected_type_of_0_field_in_package_json_to_be_string_got_1,r,typeof o);}else a.traceEnabled&&t(a.host,e.Diagnostics.package_json_does_not_have_a_0_field,r);}}function l(e,t){try{var r=t.readFile(e);return r?JSON.parse(r):{}}catch(e){return{}}}function _(t,r){return t.typeRoots?t.typeRoots:(t.configFilePath?n=e.getDirectoryPath(t.configFilePath):r.getCurrentDirectory&&(n=r.getCurrentDirectory()),void 0!==n?function(t,r){if(!r.directoryExists)return[e.combinePaths(t,d)];var n;return e.forEachAncestorDirectory(e.normalizePath(t),function(t){var i=e.combinePaths(t,d);r.directoryExists(i)&&(n||(n=[])).push(i);}),n}(n,r):void 0);var n;}e.trace=t,e.isTraceEnabled=n,function(e){e[e.TypeScript=0]="TypeScript",e[e.JavaScript=1]="JavaScript",e[e.DtsOnly=2]="DtsOnly";}(o||(o={})),e.getEffectiveTypeRoots=_;var d=e.combinePaths("node_modules","@types");function p(t,r,n,i){return{getOrCreateCacheForDirectory:function(r){var a=e.toPath(r,n,i),o=t.get(a);o||(o=e.createMap(),t.set(a,o));return o},getOrCreateCacheForModuleName:function(t){if(e.isExternalModuleNameRelative(t))return;var a=r.get(t);a||(a=function(){var t=e.createMap();return{get:function(r){return t.get(e.toPath(r,n,i))},set:function(r,a){var o=e.toPath(r,n,i);if(t.has(o))return;t.set(o,a);var s=a.resolvedModule&&a.resolvedModule.resolvedFileName,c=function(t,r){if(void 0===r)return;var a=e.toPath(e.getDirectoryPath(r),n,i),o=0;for(;o<Math.min(t.length,a.length)&&t.charCodeAt(o)===a.charCodeAt(o);)o++;var s=t.lastIndexOf(e.directorySeparator,o);if(s<0)return;return t.substr(0,s)}(o,s),u=o;for(;;){var l=e.getDirectoryPath(u);if(l===u||t.has(l))break;if(t.set(l,a),(u=l)===c)break}}}}(),r.set(t,a));return a}}}function f(r,n,i,o,s,c){return e.isExternalModuleNameRelative(n)?function(r,n,i,a,o,s){if(!s.compilerOptions.rootDirs)return;s.traceEnabled&&t(s.host,e.Diagnostics.rootDirs_option_is_set_using_it_to_resolve_relative_module_name_0,n);for(var c,u,l=e.normalizePath(e.combinePaths(i,n)),_=0,d=s.compilerOptions.rootDirs;_<d.length;_++){var p=d[_],f=e.normalizePath(p);e.endsWith(f,e.directorySeparator)||(f+=e.directorySeparator);var m=e.startsWith(l,f)&&(void 0===u||u.length<f.length);s.traceEnabled&&t(s.host,e.Diagnostics.Checking_if_0_is_the_longest_matching_prefix_for_1_2,f,l,m),m&&(u=f,c=p);}if(u){s.traceEnabled&&t(s.host,e.Diagnostics.Longest_matching_prefix_for_0_is_1,l,u);var g=l.substr(u.length);s.traceEnabled&&t(s.host,e.Diagnostics.Loading_0_from_the_root_dir_1_candidate_location_2,g,u,l);var y=a(r,l,o,!S(i,s.host),s);if(y)return y;s.traceEnabled&&t(s.host,e.Diagnostics.Trying_other_entries_in_rootDirs);for(var h=0,v=s.compilerOptions.rootDirs;h<v.length;h++){var p=v[h];if(p!==c){var b=e.combinePaths(e.normalizePath(p),g);s.traceEnabled&&t(s.host,e.Diagnostics.Loading_0_from_the_root_dir_1_candidate_location_2,g,p,b);var x=e.getDirectoryPath(b),k=a(r,b,o,!S(x,s.host),s);if(k)return k}}s.traceEnabled&&t(s.host,e.Diagnostics.Module_resolution_using_rootDirs_has_failed);}return}(r,n,i,o,s,c):function(r,n,i,o,s){if(!s.compilerOptions.baseUrl)return;s.traceEnabled&&t(s.host,e.Diagnostics.baseUrl_option_is_set_to_0_using_this_value_to_resolve_non_relative_module_name_1,s.compilerOptions.baseUrl,n);var c;s.compilerOptions.paths&&(s.traceEnabled&&t(s.host,e.Diagnostics.paths_option_is_specified_looking_for_a_pattern_to_match_module_name_0,n),c=e.matchPatternOrExact(e.getOwnKeys(s.compilerOptions.paths),n));if(c){var u=e.isString(c)?void 0:e.matchedText(c,n),l=e.isString(c)?c:e.patternText(c);return s.traceEnabled&&t(s.host,e.Diagnostics.Module_name_0_matched_pattern_1,n,l),e.forEach(s.compilerOptions.paths[l],function(n){var c=u?n.replace("*",u):n,l=e.normalizePath(e.combinePaths(s.compilerOptions.baseUrl,c));s.traceEnabled&&t(s.host,e.Diagnostics.Trying_substitution_0_candidate_module_location_Colon_1,n,c);var _=e.tryGetExtensionFromPath(l);if(void 0!==_){var d=C(l,o,!1,s);if(void 0!==d)return a({path:d,ext:_})}return i(r,l,o,!S(e.getDirectoryPath(l),s.host),s)})}var _=e.normalizePath(e.combinePaths(s.compilerOptions.baseUrl,n));return s.traceEnabled&&t(s.host,e.Diagnostics.Resolving_module_name_0_relative_to_base_url_1_2,n,s.compilerOptions.baseUrl,_),i(r,_,o,!S(e.getDirectoryPath(_),s.host),s)}(r,n,o,s,c)}function m(t,r,n,i,a){return g(t,e.getDirectoryPath(r),n,i,a,!1)}function g(i,a,s,u,l,_){var d=n(s,u),p=[],m={compilerOptions:s,host:u,traceEnabled:d},g=_?b(o.JavaScript):b(o.TypeScript)||b(o.JavaScript);if(g&&g.value){var v=g.value;return c(v.resolved,v.originalPath,v.isExternalLibraryImport,p)}return{resolvedModule:void 0,failedLookupLocations:p};function b(n){var c=f(n,i,a,function(e,t,r,n,i){return h(e,t,r,n,i,!0)},p,m);if(c)return J({resolved:c,isExternalLibraryImport:!1});if(e.isExternalModuleNameRelative(i)){var _=e.normalizePathAndParts(e.combinePaths(a,i)),g=_.path,v=_.parts,b=h(n,g,p,!1,m,!0);return b&&J({resolved:b,isExternalLibraryImport:e.contains(v,"node_modules")})}d&&t(u,e.Diagnostics.Loading_module_0_from_node_modules_folder_target_file_type_1,i,o[n]);var x=O(n,i,a,p,m,l);if(x){var S=x.value,k=void 0;if(!s.preserveSymlinks&&S){k=S.path;var T=y(x.value.path,u,d);T===k&&(k=void 0),S=r({},S,{path:T});}return{value:S&&{resolved:S,originalPath:k,isExternalLibraryImport:!0}}}}}function y(r,n,i){if(!n.realpath)return r;var a=e.normalizePath(n.realpath(r));return i&&t(n,e.Diagnostics.Resolving_real_path_for_0_result_1,r,a),a}function h(r,n,a,s,c,u){if(c.traceEnabled&&t(c.host,e.Diagnostics.Loading_module_as_file_Slash_folder_candidate_module_location_0_target_file_type_1,n,o[r]),!e.pathEndsWithDirectorySeparator(n)){if(!s){var l=e.getDirectoryPath(n);S(l,c.host)||(c.traceEnabled&&t(c.host,e.Diagnostics.Directory_0_does_not_exist_skipping_all_lookups_in_it,l),s=!0);}var _=T(r,n,a,s,c);if(_){var d=u?function(t){var r=e.normalizePath(t.path),n=r.lastIndexOf(v);if(-1===n)return;var i=n+v.length,a=b(r,i);64===r.charCodeAt(i)&&(a=b(r,a));var o=r.slice(0,a),s=e.removeExtension(r.slice(a+1),t.ext)+".d.ts";return{packageDirectory:o,subModuleName:s}}(_):void 0;return i(d&&A(d.packageDirectory,d.subModuleName,a,!1,c).packageId,_)}}s||(S(n,c.host)||(c.traceEnabled&&t(c.host,e.Diagnostics.Directory_0_does_not_exist_skipping_all_lookups_in_it,n),s=!0));return E(r,n,a,s,c,u)}e.resolveTypeReferenceDirective=function(i,a,c,u){var l=n(c,u),d={compilerOptions:c,host:u,traceEnabled:l},p=_(c,u);l&&(void 0===a?void 0===p?t(u,e.Diagnostics.Resolving_type_reference_directive_0_containing_file_not_set_root_directory_not_set,i):t(u,e.Diagnostics.Resolving_type_reference_directive_0_containing_file_not_set_root_directory_1,i,p):void 0===p?t(u,e.Diagnostics.Resolving_type_reference_directive_0_containing_file_1_root_directory_not_set,i,a):t(u,e.Diagnostics.Resolving_type_reference_directive_0_containing_file_1_root_directory_2,i,a,p));var f,m=[],g=function(){if(p&&p.length)return l&&t(u,e.Diagnostics.Resolving_with_primary_search_path_0,p.join(", ")),e.forEach(p,function(r){var n=e.combinePaths(r,i),a=e.getDirectoryPath(n),c=S(a,u);return!c&&l&&t(u,e.Diagnostics.Directory_0_does_not_exist_skipping_all_lookups_in_it,a),s(E(o.DtsOnly,n,m,!c,d))});l&&t(u,e.Diagnostics.Root_directory_cannot_be_determined_skipping_primary_search_paths);}(),h=!0;return g||(g=function(){var r,n=a&&e.getDirectoryPath(a);if(void 0!==n){l&&t(u,e.Diagnostics.Looking_up_in_node_modules_folder_initial_location_0,n);var c=O(o.DtsOnly,i,n,m,d,void 0);return!(r=s(c&&c.value))&&l&&t(u,e.Diagnostics.Type_reference_directive_0_was_not_resolved,i),r}l&&t(u,e.Diagnostics.Containing_file_is_not_specified_and_root_directory_cannot_be_determined_skipping_lookup_in_node_modules_folder);}(),h=!1),g&&(c.preserveSymlinks||(g=r({},g,{fileName:y(g.fileName,u,l)})),l&&t(u,e.Diagnostics.Type_reference_directive_0_was_successfully_resolved_to_1_primary_Colon_2,i,g.fileName,h),f={primary:h,resolvedFileName:g.fileName,packageId:g.packageId}),{resolvedTypeReferenceDirective:f,failedLookupLocations:m}},e.getAutomaticTypeDirectiveNames=function(t,r){if(t.types)return t.types;var n=[];if(r.directoryExists&&r.getDirectories){var i=_(t,r);if(i)for(var a=0,o=i;a<o.length;a++){var s=o[a];if(r.directoryExists(s))for(var c=0,u=r.getDirectories(s);c<u.length;c++){var d=u[c],p=e.normalizePath(d),f=P(e.combinePaths(s,p));r.fileExists(f)&&null===l(f,r).typings||n.push(e.getBaseFileName(p));}}}return n},e.createModuleResolutionCache=function(t,r){return p(e.createMap(),e.createMap(),t,r)},e.createModuleResolutionCacheWithMaps=p,e.resolveModuleName=function(r,i,a,o,s){var c=n(a,o);c&&t(o,e.Diagnostics.Resolving_module_0_from_1,r,i);var u=e.getDirectoryPath(i),l=s&&s.getOrCreateCacheForDirectory(u),_=l&&l.get(r);if(_)c&&t(o,e.Diagnostics.Resolution_for_module_0_was_found_in_cache_from_location_1,r,u);else{var d=a.moduleResolution;switch(void 0===d?(d=e.getEmitModuleKind(a)===e.ModuleKind.CommonJS?e.ModuleResolutionKind.NodeJs:e.ModuleResolutionKind.Classic,c&&t(o,e.Diagnostics.Module_resolution_kind_is_not_specified_using_0,e.ModuleResolutionKind[d])):c&&t(o,e.Diagnostics.Explicitly_specified_module_resolution_kind_Colon_0,e.ModuleResolutionKind[d]),d){case e.ModuleResolutionKind.NodeJs:_=m(r,i,a,o,s);break;case e.ModuleResolutionKind.Classic:_=j(r,i,a,o,s);break;default:e.Debug.fail("Unexpected moduleResolution: "+d);}if(l){l.set(r,_);var p=s.getOrCreateCacheForModuleName(r);p&&p.set(u,_);}}return c&&(_.resolvedModule?t(o,e.Diagnostics.Module_name_0_was_successfully_resolved_to_1,r,_.resolvedModule.resolvedFileName):t(o,e.Diagnostics.Module_name_0_was_not_resolved,r)),_},e.nodeModuleNameResolver=m,e.resolveJavaScriptModule=function(t,r,n){var i=g(t,r,{moduleResolution:e.ModuleResolutionKind.NodeJs,allowJs:!0},n,void 0,!0),a=i.resolvedModule,o=i.failedLookupLocations;if(!a)throw new Error("Could not resolve JS module '"+t+"' starting at '"+r+"'. Looked in: "+o.join(", "));return a.resolvedFileName};var v="/node_modules/";function b(t,r){var n=t.indexOf(e.directorySeparator,r+1);return-1===n?r:n}function x(t){return""===t?"index.d.ts":e.endsWith(t,".d.ts")?t:e.endsWith(t,"/index")?t+".d.ts":t+"/index.d.ts"}function S(e,t){return!t.directoryExists||t.directoryExists(e)}function k(e,t,r,n,i){return a(T(e,t,r,n,i))}function T(r,n,i,a,o){var s=D(n,r,i,a,o);if(s)return s;if(e.hasJavaScriptFileExtension(n)){var c=e.removeFileExtension(n);if(o.traceEnabled){var u=n.substring(c.length);t(o.host,e.Diagnostics.File_name_0_has_a_1_extension_stripping_it,n,u);}return D(c,r,i,a,o)}}function D(t,r,n,i,a){if(!i){var s=e.getDirectoryPath(t);s&&(i=!S(s,a.host));}switch(r){case o.DtsOnly:return c(".d.ts");case o.TypeScript:return c(".ts")||c(".tsx")||c(".d.ts");case o.JavaScript:return c(".js")||c(".jsx")}function c(e){var r=C(t+e,n,i,a);return r&&{path:r,ext:e}}}function C(r,n,i,a){if(!i){if(a.host.fileExists(r))return a.traceEnabled&&t(a.host,e.Diagnostics.File_0_exist_use_it_as_a_name_resolution_result,r),r;a.traceEnabled&&t(a.host,e.Diagnostics.File_0_does_not_exist,r);}n.push(r);}function E(e,t,r,n,a,o){void 0===o&&(o=!0);var s=o?A(t,"",r,n,a):{packageJsonContent:void 0,packageId:void 0},c=s.packageJsonContent;return i(s.packageId,N(e,t,r,n,a,c))}function N(r,n,i,a,s,c){var l=c&&function(r,n,i,a,s){var c=u(n!==o.JavaScript,r,i,s);if(!c)return;var l=!S(e.getDirectoryPath(c),s.host),_=C(c,a,l,s);if(_){var d=_&&function(t,r){var n=e.tryGetExtensionFromPath(r);return void 0!==n&&function(e,t){switch(e){case o.JavaScript:return".js"===t||".jsx"===t;case o.TypeScript:return".ts"===t||".tsx"===t||".d.ts"===t;case o.DtsOnly:return".d.ts"===t}}(t,n)?{path:r,ext:n}:void 0}(n,_);if(d)return d;s.traceEnabled&&t(s.host,e.Diagnostics.File_0_has_an_unsupported_extension_so_skipping_it,_);}var p=h(n===o.DtsOnly?o.TypeScript:n,c,a,l,s,!1);if(p)return e.Debug.assert(void 0===p.packageId),{path:p.path,ext:p.extension}}(c,r,n,i,s);if(l)return l;var _=!a&&S(n,s.host);return T(r,e.combinePaths(n,"index"),i,!_,s)}function A(r,n,i,a,o){var s=o.host,c=o.traceEnabled,_=!a&&S(r,s),d=P(r);if(_&&s.fileExists(d)){var p=l(d,s);if(""===n){var f=u(!0,p,r,o);if("string"==typeof f)n=x(f.substring(r.length+1));else{var m=u(!1,p,r,o);n="string"==typeof m?e.removeExtension(e.removeExtension(m.substring(r.length+1),".js"),".jsx")+".d.ts":"index.d.ts";}}e.endsWith(n,".d.ts")||(n=x(n));var g="string"==typeof p.name&&"string"==typeof p.version?{name:p.name,subModuleName:n,version:p.version}:void 0;return c&&(g?t(s,e.Diagnostics.Found_package_json_at_0_Package_ID_is_1,d,e.packageIdToString(g)):t(s,e.Diagnostics.Found_package_json_at_0,d)),{found:!0,packageJsonContent:p,packageId:g}}return _&&c&&t(s,e.Diagnostics.File_0_does_not_exist,d),i.push(d),{found:!1,packageJsonContent:void 0,packageId:void 0}}function P(t){return e.combinePaths(t,"package.json")}function w(t,r,n,a,o,s){var c,u,l=e.normalizePath(e.combinePaths(n,r)),_=A(l,"",o,!a,s);if(_.found)c=_.packageJsonContent,u=_.packageId;else{var d=F(r),p=d.packageName,f=d.rest;if(""!==f)u=A(e.combinePaths(n,p),f,o,!a,s).packageId;}return i(u,T(t,l,o,!a,s)||N(t,l,o,!a,s,c))}function F(t){var r=t.indexOf(e.directorySeparator);return"@"===t[0]&&(r=t.indexOf(e.directorySeparator,r+1)),-1===r?{packageName:t,rest:""}:{packageName:t.slice(0,r),rest:t.slice(r+1)}}function O(e,t,r,n,i,a){return I(e,t,r,n,i,!1,a)}function I(t,r,n,i,a,o,s){var c=s&&s.getOrCreateCacheForModuleName(r);return e.forEachAncestorDirectory(e.normalizeSlashes(n),function(n){if("node_modules"!==e.getBaseFileName(n)){var s=K(c,r,n,a.traceEnabled,a.host);return s||J(M(t,r,n,i,a,o))}})}function M(r,n,i,a,s,c){void 0===c&&(c=!1);var u=e.combinePaths(i,"node_modules"),l=S(u,s.host);!l&&s.traceEnabled&&t(s.host,e.Diagnostics.Directory_0_does_not_exist_skipping_all_lookups_in_it,u);var _=c?void 0:w(r,n,u,l,a,s);if(_)return _;if(r!==o.JavaScript){var d=e.combinePaths(u,"@types"),p=l;return l&&!S(d,s.host)&&(s.traceEnabled&&t(s.host,e.Diagnostics.Directory_0_does_not_exist_skipping_all_lookups_in_it,d),p=!1),w(o.DtsOnly,function(r,n){var i=R(r);n.traceEnabled&&i!==r&&t(n.host,e.Diagnostics.Scoped_package_detected_looking_in_0,i);return i}(n,s),d,p,a,s)}}e.directoryProbablyExists=S,e.getPackageName=F;var L="__";function R(t){if(e.startsWith(t,"@")){var r=t.replace(e.directorySeparator,L);if(r!==t)return r.slice(1)}return t}function B(t){return e.stringContains(t,L)?"@"+t.replace(L,e.directorySeparator):t}function K(r,n,i,a,o){var s=r&&r.get(i);if(s)return a&&t(o,e.Diagnostics.Resolution_for_module_0_was_found_in_cache_from_location_1,n,i),{value:s.resolvedModule&&{path:s.resolvedModule.resolvedFileName,extension:s.resolvedModule.extension,packageId:s.resolvedModule.packageId}}}function j(t,r,i,a,s){var u=n(i,a),l={compilerOptions:i,host:a,traceEnabled:u},_=[],d=e.getDirectoryPath(r),p=m(o.TypeScript)||m(o.JavaScript);return c(p&&p.value,void 0,!1,_);function m(r){var n=f(r,t,d,k,_,l);if(n)return{value:n};var i=s&&s.getOrCreateCacheForModuleName(t);if(e.isExternalModuleNameRelative(t)){var c=e.normalizePath(e.combinePaths(d,t));return J(k(r,c,_,!1,l))}var p=e.forEachAncestorDirectory(d,function(n){var o=K(i,t,n,u,a);if(o)return o;var s=e.normalizePath(e.combinePaths(n,t));return J(k(r,s,_,!1,l))});return p||(r===o.TypeScript?function(e,t,r,n){return I(o.DtsOnly,e,t,r,n,!0,void 0)}(t,d,_,l):void 0)}}function J(e){return void 0!==e?{value:e}:void 0}e.getTypesPackageName=function(e){return"@types/"+R(e)},e.getMangledNameForScopedPackage=R,e.getPackageNameFromAtTypesDirectory=function(t){var r=e.removePrefix(t,"@types/");return r!==t?B(r):t},e.getUnmangledNameForScopedPackage=B,e.classicNameResolver=j,e.loadModuleFromGlobalCache=function(r,i,a,s,u){var l=n(a,s);l&&t(s,e.Diagnostics.Auto_discovery_for_typings_is_enabled_in_project_0_Running_extra_resolution_pass_for_module_1_using_cache_location_2,i,r,u);var _={compilerOptions:a,host:s,traceEnabled:l},d=[];return c(M(o.DtsOnly,r,u,d,_),void 0,!0,d)};}(i||(i={})),function(e){var t,n=/^".+"$/,i=1,a=1,o=1,s=1;function c(e){return e.id||(e.id=a,a++),e.id}function u(e){return e.id||(e.id=i,i++),e.id}function l(t,r){var n=e.getModuleInstanceState(t);return 1===n||r&&2===n}function _(t){switch(t.parent.kind){case 246:case 250:return e.isIdentifier(t);default:return e.isDeclarationName(t)}}function d(e){switch(e.kind){case 243:case 241:case 244:case 246:return!0;case 71:return 246===e.parent.kind;default:return!1}}e.getNodeId=c,e.getSymbolId=u,e.isInstantiatedModule=l,e.createTypeChecker=function(i,a){var p,f,m,g=e.objectAllocator.getSymbolConstructor(),y=e.objectAllocator.getTypeConstructor(),h=e.objectAllocator.getSignatureConstructor(),v=0,b=0,x=0,S=0,k=e.createSymbolTable(),T=e.identity,D=i.getCompilerOptions(),C=e.getEmitScriptTarget(D),E=e.getEmitModuleKind(D),N=!!D.noUnusedLocals||!!D.noUnusedParameters,A=e.getAllowSyntheticDefaultImports(D),P=e.getStrictOptionValue(D,"strictNullChecks"),w=e.getStrictOptionValue(D,"strictFunctionTypes"),F=e.getStrictOptionValue(D,"strictPropertyInitialization"),O=e.getStrictOptionValue(D,"noImplicitAny"),I=e.getStrictOptionValue(D,"noImplicitThis"),M=function(){var t,r=i.getResolvedTypeReferenceDirectives();return r&&(t=e.createMap(),r.forEach(function(e,r){if(e){var n=i.getSourceFile(e.resolvedFileName);t.set(n.path,r);}})),{getReferencedExportContainer:jm,getReferencedImportDeclaration:Jm,getReferencedDeclarationWithCollidingName:Um,isDeclarationWithCollidingName:qm,isValueAliasDeclaration:function(t){return!(t=e.getParseTreeNode(t))||Vm(t)},hasGlobalName:og,isReferencedAliasDeclaration:function(t,r){return!(t=e.getParseTreeNode(t))||function t(r,n){if(e.isAliasSymbolDeclaration(r)){var i=nn(r);if(i&&gr(i).referenced)return!0;var a=gr(i).target;if(a&&1&e.getModifierFlags(r)&&67216319&a.flags)return!0}return!!n&&e.forEachChild(r,function(e){return t(e,n)})}(t,r)},getNodeCheckFlags:function(t){return(t=e.getParseTreeNode(t))?Ym(t):void 0},isTopLevelValueImportEqualsWithEntityName:Wm,isDeclarationVisible:In,isImplementationOfOverload:$m,isRequiredInitializedParameter:Xm,isOptionalUninitializedParameterProperty:Qm,writeTypeOfDeclaration:ng,writeReturnTypeOfSignatureDeclaration:ig,writeTypeOfExpression:ag,isSymbolAccessible:xn,isEntityNameVisible:Tn,getConstantValue:function(t){return(t=e.getParseTreeNode(t,eg))?tg(t):void 0},collectLinkedAliases:Mn,getReferencedValueDeclaration:cg,getTypeReferenceSerializationKind:rg,isOptionalParameter:Ga,moduleExportsSomeValue:Km,isArgumentsLocalBinding:Bm,getExternalModuleFileFromDeclaration:_g,getTypeReferenceDirectivesForEntityName:function(e){if(t){var r=183===e.kind||71===e.kind&&zu(e)?68264895:67903464,i=zr(e,r,!0);return i&&i!==$?n(i,r):void 0}},getTypeReferenceDirectivesForSymbol:n,isLiteralConstDeclaration:ug,isLateBound:function(t){var r=(t=e.getParseTreeNode(t,e.isDeclaration))&&nn(t);return!!(r&&1024&e.getCheckFlags(r))},writeLiteralConstValue:lg,getJsxFactoryEntity:function(t){return t?(or(t),e.getSourceFileOfNode(t).localJsxFactory||jt):jt}};function n(r,n){if(t&&function(r){if(!r.declarations)return!1;for(var n=r;;){var i=an(n);if(!i)break;n=i;}if(n.valueDeclaration&&272===n.valueDeclaration.kind&&512&n.flags)return!1;for(var a=0,o=r.declarations;a<o.length;a++){var s=o[a],c=e.getSourceFileOfNode(s);if(t.has(c.path))return!0}return!1}(r)){for(var i,a=0,o=r.declarations;a<o.length;a++){var s=o[a];if(s.symbol&&s.symbol.flags&n){var c=e.getSourceFileOfNode(s),u=t.get(c.path);if(!u)return;(i||(i=[])).push(u);}}return i}}}(),L=function(){return{typeToTypeNode:function(n,i,a,o){e.Debug.assert(void 0===i||0==(8&i.flags));var s=t(i,a,o),c=r(n,s),u=s.encounteredError?void 0:c;return u},indexInfoToIndexSignatureDeclaration:function(r,n,a,o,s){e.Debug.assert(void 0===a||0==(8&a.flags));var c=t(a,o,s),u=i(r,n,c),l=c.encounteredError?void 0:u;return l},signatureToSignatureDeclaration:function(r,n,i,o,s){e.Debug.assert(void 0===i||0==(8&i.flags));var c=t(i,o,s),u=a(r,n,c),l=c.encounteredError?void 0:u;return l},symbolToEntityName:function(r,n,i,a,o){e.Debug.assert(void 0===i||0==(8&i.flags));var s=t(i,a,o),c=_(r,s,n,!1),u=s.encounteredError?void 0:c;return u},symbolToExpression:function(r,n,i,a,o){e.Debug.assert(void 0===i||0==(8&i.flags));var s=t(i,a,o),u=function(t,r,n){var i=c(t,r,n);return function t(n,i){var a=l(n,i,r),o=n[i];0===i&&(r.flags|=16777216);var s=On(o,r);0===i&&(r.flags^=16777216);var c=s.charCodeAt(0),u=e.isIdentifierStart(c,C);if(0===i||u){var _=e.setEmitFlags(e.createIdentifier(s,a),16777216);return _.symbol=o,i>0?e.createPropertyAccess(t(n,i-1),_):_}91===c&&(s=s.substring(1,s.length-1),c=s.charCodeAt(0));var d=void 0;return e.isSingleOrDoubleQuote(c)?(d=e.createLiteral(s.substring(1,s.length-1).replace(/\\./g,function(e){return e.substring(1)}))).singleQuote=39===c:""+ +s===s&&(d=e.createLiteral(+s)),d||((d=e.setEmitFlags(e.createIdentifier(s,a),16777216)).symbol=o),e.createElementAccess(t(n,i-1),d)}(i,i.length-1)}(r,s,n),_=s.encounteredError?void 0:u;return _},symbolToTypeParameterDeclarations:function(r,n,i,a){e.Debug.assert(void 0===n||0==(8&n.flags));var o=t(n,i,a),s=u(r,o),c=o.encounteredError?void 0:s;return c},symbolToParameterDeclaration:function(r,n,i,a){e.Debug.assert(void 0===n||0==(8&n.flags));var o=t(n,i,a),c=s(r,o),u=o.encounteredError?void 0:c;return u},typeParameterToDeclaration:function(r,n,i,a){e.Debug.assert(void 0===n||0==(8&n.flags));var s=t(n,i,a),c=o(r,s),u=s.encounteredError?void 0:c;return u}};function t(t,r,n){return{enclosingDeclaration:t,flags:r,tracker:n&&n.trackSymbol?n:{trackSymbol:e.noop},encounteredError:!1,symbolStack:void 0}}function r(t,s){var c=8388608&s.flags;if(s.flags&=-8388609,t){if(1&t.flags)return e.createKeywordTypeNode(119);if(2&t.flags)return e.createKeywordTypeNode(137);if(4&t.flags)return e.createKeywordTypeNode(134);if(8&t.flags)return e.createKeywordTypeNode(122);if(256&t.flags&&!(131072&t.flags)){var u=an(t.symbol),l=_(u,s,67901928,!1),d=Fi(u)===t?l:e.createQualifiedName(l,e.symbolName(t.symbol));return e.createTypeReferenceNode(d,void 0)}if(272&t.flags){var p=_(t.symbol,s,67901928,!1);return e.createTypeReferenceNode(p,void 0)}if(32&t.flags)return e.createLiteralTypeNode(e.setEmitFlags(e.createLiteral(t.value),16777216));if(64&t.flags)return e.createLiteralTypeNode(e.createLiteral(t.value));if(128&t.flags)return"true"===t.intrinsicName?e.createTrue():e.createFalse();if(1024&t.flags){if(!(1048576&s.flags)){if(bn(t.symbol,s.enclosingDeclaration))return e.createTypeQueryNode(_(t.symbol,s,67216319,!1));s.tracker.reportInaccessibleUniqueSymbolError&&s.tracker.reportInaccessibleUniqueSymbolError();}return e.createTypeOperatorNode(141,e.createKeywordTypeNode(138))}if(2048&t.flags)return e.createKeywordTypeNode(105);if(4096&t.flags)return e.createKeywordTypeNode(140);if(8192&t.flags)return e.createKeywordTypeNode(95);if(16384&t.flags)return e.createKeywordTypeNode(131);if(512&t.flags)return e.createKeywordTypeNode(138);if(134217728&t.flags)return e.createKeywordTypeNode(135);if(32768&t.flags&&t.isThisType)return 4194304&s.flags&&(s.encounteredError||32768&s.flags||(s.encounteredError=!0),s.tracker.reportInaccessibleThisError&&s.tracker.reportInaccessibleThisError()),e.createThis();var f,m,g=e.getObjectFlags(t);if(4&g)return e.Debug.assert(!!(65536&t.flags)),function(t){var i=t.typeArguments||e.emptyArray;if(t.target===Pe){if(2&s.flags){var a=r(i[0],s);return e.createTypeReferenceNode("Array",[a])}var o=r(i[0],s);return e.createArrayTypeNode(o)}if(8&t.target.objectFlags){if(i.length>0){var c=n(i.slice(0,To(t)),s);if(c&&c.length>0)return e.createTupleTypeNode(c)}return s.encounteredError||524288&s.flags?e.createTupleTypeNode([]):void(s.encounteredError=!0)}if(2048&s.flags&&t.symbol.valueDeclaration&&203===t.symbol.valueDeclaration.kind)return N(t);var u=t.target.outerTypeParameters,l=0,_=void 0;if(u)for(var d=u.length;l<d;){var p=l,f=vo(u[l]);do{l++;}while(l<d&&vo(u[l])===f);if(!e.rangeEquals(u,i,p,l)){var m=n(i.slice(p,l),s),g=m&&e.createNodeArray(m),y=P(f);(71===y.kind?y:y.right).typeArguments=g,_?(e.Debug.assert(!_.right),_=w(_,y),_=e.createQualifiedName(_,void 0)):_=e.createQualifiedName(y,void 0);}}var h=void 0,v=P(t.symbol);_?(e.Debug.assert(!_.right),_=w(_,v),h=_):h=v;var b=void 0;if(i.length>0){var x=(t.target.typeParameters||e.emptyArray).length;b=n(i.slice(l,x),s);}if(b){var S=71===h.kind?h:h.right;S.typeArguments=void 0;}return e.createTypeReferenceNode(h,b)}(t);if(32768&t.flags||3&g){var p=t.symbol?_(t.symbol,s,67901928,!1):e.createIdentifier("?");return e.createTypeReferenceNode(p,void 0)}if(!c&&t.aliasSymbol&&(16384&s.flags||(f=t.aliasSymbol,m=s.enclosingDeclaration,0===xn(f,m,67901928,!1).accessibility))){var p=P(t.aliasSymbol),y=n(t.aliasTypeArguments,s);return e.createTypeReferenceNode(p,y)}if(393216&t.flags){var h=131072&t.flags?function(e){for(var t=[],r=0,n=0;n<e.length;n++){var i=e[n];if(r|=i.flags,!(12288&i.flags)){if(384&i.flags){var a=128&i.flags?ue:Ni(i);if(131072&a.flags){var o=a.types.length;if(n+o<=e.length&&e[n+o-1]===a.types[o-1]){t.push(a),n+=o-1;continue}}}t.push(i);}}return 8192&r&&t.push(ne),4096&r&&t.push(te),t||e}(t.types):t.types,v=n(h,s);if(v&&v.length>0){var b=e.createUnionOrIntersectionTypeNode(131072&t.flags?168:169,v);return b}s.encounteredError||262144&s.flags||(s.encounteredError=!0);}else{if(48&g)return e.Debug.assert(!!(65536&t.flags)),N(t);if(524288&t.flags){var x=t.type,S=r(x,s);return e.createTypeOperatorNode(S)}if(1048576&t.flags){var k=r(t.objectType,s),S=r(t.indexType,s);return e.createIndexedAccessTypeNode(k,S)}if(2097152&t.flags){var T=r(t.checkType,s),D=r(t.extendsType,s),C=r(ws(t),s),E=r(Fs(t),s);return e.createConditionalTypeNode(T,D,C,E)}if(4194304&t.flags)return r(t.typeParameter,s);e.Debug.fail("Should be unreachable.");}}else s.encounteredError=!0;function N(t){var r=t.symbol;if(r){if(32&r.flags&&!oi(r)&&!(203===r.valueDeclaration.kind&&2048&s.flags)||896&r.flags||function(){var t=!!(8192&r.flags)&&e.some(r.declarations,function(t){return e.hasModifier(t,32)}),n=!!(16&r.flags)&&(r.parent||e.forEach(r.declarations,function(e){return 272===e.parent.kind||238===e.parent.kind}));if(t||n)return(!!(4096&s.flags)||e.contains(s.symbolStack,r))&&(!(8&s.flags)||bn(r,s.enclosingDeclaration))}())return function(t,r){var n=_(t,s,r,!1);return e.createTypeQueryNode(n)}(r,67216319);if(e.contains(s.symbolStack,r)){var n=function(t){if(t.symbol&&2048&t.symbol.flags){var r=e.findAncestor(t.symbol.declarations[0].parent,function(e){return 172!==e.kind});if(235===r.kind)return nn(r)}}(t);if(n){var i=_(n,s,67901928,!1);return e.createTypeReferenceNode(i,void 0)}return e.createKeywordTypeNode(119)}s.symbolStack||(s.symbolStack=[]);var a=16&e.getObjectFlags(t)&&t.symbol&&32&t.symbol.flags;if(a)return A(t);s.symbolStack.push(r);var o=A(t);return s.symbolStack.pop(),o}return A(t)}function A(t){if(ga(t))return function(t){e.Debug.assert(!!(65536&t.flags));var n=t.declaration.readonlyToken?e.createToken(t.declaration.readonlyToken.kind):void 0,i=t.declaration.questionToken?e.createToken(t.declaration.questionToken.kind):void 0,a=o(ua(t),s,la(t)),c=r(_a(t),s),u=e.createMappedTypeNode(n,a,i,c);return e.setEmitFlags(u,1)}(t);var n=ya(t);if(!n.properties.length&&!n.stringIndexInfo&&!n.numberIndexInfo){if(!n.callSignatures.length&&!n.constructSignatures.length)return e.setEmitFlags(e.createTypeLiteralNode(void 0),1);if(1===n.callSignatures.length&&!n.constructSignatures.length){var c=n.callSignatures[0],u=a(c,162,s);return u}if(1===n.constructSignatures.length&&!n.callSignatures.length){var c=n.constructSignatures[0],u=a(c,163,s);return u}}var l=s.flags;s.flags|=4194304;var d=function(t){for(var n=[],o=0,c=t.callSignatures;o<c.length;o++){var u=c[o];n.push(a(u,157,s));}for(var l=0,d=t.constructSignatures;l<d.length;l++){var u=d[l];n.push(a(u,158,s));}if(t.stringIndexInfo){var p=2048&t.objectFlags?go(Q,t.stringIndexInfo.isReadonly,t.stringIndexInfo.declaration):t.stringIndexInfo;n.push(i(p,0,s));}t.numberIndexInfo&&n.push(i(t.numberIndexInfo,1,s));var f=t.properties;if(!f)return n;for(var m=0,g=f;m<g.length;m++){var y=g[m];if(2048&s.flags){if(4194304&y.flags)continue;24&e.getDeclarationModifierFlagsFromSymbol(y)&&s.tracker.reportPrivateInBaseOfClassExpression&&s.tracker.reportPrivateInBaseOfClassExpression(e.unescapeLeadingUnderscores(y.escapedName));}var h=2048&e.getCheckFlags(y)&&33554432&s.flags?Q:ui(y),v=s.enclosingDeclaration;if(s.enclosingDeclaration=void 0,1024&e.getCheckFlags(y)){var b=e.firstOrUndefined(y.declarations),x=Ui(b)&&zr(b.name.expression,67216319);x&&s.tracker.trackSymbol&&s.tracker.trackSymbol(x,v,67216319);}var S=_(y,s,67216319,!0);s.enclosingDeclaration=v;var k=16777216&y.flags?e.createToken(55):void 0;if(8208&y.flags&&!ha(h).length)for(var T=Ka(h,0),D=0,C=T;D<C.length;D++){var u=C[D],E=a(u,152,s);E.name=S,E.questionToken=k,n.push(E);}else{var N=s.flags;s.flags|=2048&e.getCheckFlags(y)?33554432:0;var A=h?r(h,s):e.createKeywordTypeNode(119);s.flags=N;var P=dp(y)?[e.createToken(132)]:void 0,w=e.createPropertySignature(P,S,k,A,void 0);n.push(w);}}return n.length?n:void 0}(n);s.flags=l;var p=e.createTypeLiteralNode(d);return e.setEmitFlags(p,1024&s.flags?0:1)}function P(t){var r=32&t.flags||!dn(t.escapedName)?_(t,s,67901928,!1):e.createIdentifier("");return r}function w(t,r){if(e.Debug.assert(void 0===t.right),71===r.kind)return t.right=r,t;for(var n=r;71!==n.left.kind;)n=n.left;return t.right=n.left,n.left=t,r}}function n(t,n){if(e.some(t)){for(var i=[],a=0,o=t;a<o.length;a++){var s=o[a],c=r(s,n);c&&i.push(c);}return i}}function i(t,n,i){var a=e.getNameFromIndexInfo(t)||"x",o=e.createKeywordTypeNode(0===n?137:134),s=e.createParameter(void 0,void 0,void 0,a,void 0,o,void 0),c=t.type?r(t.type,i):r(Q,i);return t.type||2097152&i.flags||(i.encounteredError=!0),e.createIndexSignature(void 0,t.isReadonly?[e.createToken(132)]:void 0,[s],c)}function a(t,n,i){var a,c;32&i.flags&&t.target&&t.mapper&&t.target.typeParameters?c=t.target.typeParameters.map(function(e){return r(uc(e,t.mapper),i)}):a=t.typeParameters&&t.typeParameters.map(function(e){return o(e,i)});var u,l=t.parameters.map(function(e){return s(e,i)});if(t.thisParameter){var _=s(t.thisParameter,i);l.unshift(_);}var d=no(t);if(d){var p=1===d.kind?e.setEmitFlags(e.createIdentifier(d.parameterName),16777216):e.createThisTypeNode(),f=r(d.type,i);u=e.createTypePredicateNode(p,f);}else{var m=io(t);u=m&&r(m,i);}return 256&i.flags?u&&119===u.kind&&(u=void 0):u||(u=e.createKeywordTypeNode(119)),e.createSignatureDeclaration(n,a,l,u,c)}function o(t,n,i){void 0===i&&(i=ho(t));var a=n.flags;n.flags&=-513;var o=_(t.symbol,n,67901928,!0),s=i&&r(i,n),c=Fa(t),u=c&&r(c,n);return n.flags=a,e.createTypeParameterDeclaration(o,s,u)}function s(t,n){var i=e.getDeclarationOfKind(t,148);e.Debug.assert(!!i||ur(t)&&!!t.isRestParameter);var a=ui(t);i&&Xm(i)&&(a=_u(a));var o=r(a,n),s=!(8192&n.flags)&&i&&i.modifiers&&i.modifiers.map(e.getSynthesizedClone),c=!i||e.isRestParameter(i)?e.createToken(24):void 0,u=i&&i.name?71===i.name.kind?e.setEmitFlags(e.getSynthesizedClone(i.name),16777216):function t(r){var n=e.visitEachChild(r,t,e.nullTransformationContext,void 0,t),i=e.nodeIsSynthesized(n)?n:e.getSynthesizedClone(n);return 180===i.kind&&(i.initializer=void 0),e.setEmitFlags(i,16777217)}(i.name):e.symbolName(t),l=i&&Ga(i)?e.createToken(55):void 0,_=e.createParameter(void 0,s,c,u,l,o,void 0);return _}function c(t,r,n){var i;r.tracker.trackSymbol(t,r.enclosingDeclaration,n);var a=262144&t.flags;return!a&&(r.enclosingDeclaration||64&r.flags)?(i=function t(n,i,a){var o,s=hn(n,r.enclosingDeclaration,i,!!(128&r.flags));if(!s||vn(s[0],r.enclosingDeclaration,1===s.length?i:yn(i))){var c=an(s?s[0]:n);if(c){var u=t(c,yn(i),!1);u&&(o=c,s=u.concat(s||[n]));}}return s||(!a&&(!o&&e.forEach(n.declarations,Sn)||6144&n.flags)?void 0:[n])}(t,n,!0),e.Debug.assert(i&&i.length>0)):i=[t],i}function u(t,r){var n,i=am(t);return 524384&i.flags&&(n=e.createNodeArray(e.map(gi(t),function(e){return o(e,r)}))),n}function l(t,r,i){e.Debug.assert(t&&0<=r&&r<t.length);var a,o=t[r];if(512&i.flags&&r<t.length-1){var s=o,c=t[r+1];if(1&e.getCheckFlags(c)){var l=function(t){return e.concatenate(mi(t),gi(t))}(2097152&s.flags?Rr(s):s);a=n(e.map(l,c.mapper),i);}else a=u(o,i);}return a}function _(t,r,n,i){var a=c(t,r,n);return!i||1===a.length||r.encounteredError||65536&r.flags||(r.encounteredError=!0),function t(n,i){var a=l(n,i,r),o=n[i];0===i&&(r.flags|=16777216);var s=On(o,r);0===i&&(r.flags^=16777216);var c=e.setEmitFlags(e.createIdentifier(s,a),16777216);return c.symbol=o,i>0?e.createQualifiedName(t(n,i-1),c):c}(a,a.length-1)}}(),R=cr(4,"undefined");R.declarations=[];var B,K,j=cr(4,"arguments"),J={getNodeCount:function(){return e.sum(i.getSourceFiles(),"nodeCount")},getIdentifierCount:function(){return e.sum(i.getSourceFiles(),"identifierCount")},getSymbolCount:function(){return e.sum(i.getSourceFiles(),"symbolCount")+b},getTypeCount:function(){return v},isUndefinedSymbol:function(e){return e===R},isArgumentsSymbol:function(e){return e===j},isUnknownSymbol:function(e){return e===$},getMergedSymbol:rn,getDiagnostics:Dm,getGlobalDiagnostics:function(){return Cm(),Lt.getGlobalDiagnostics()},getTypeOfSymbolAtLocation:function(t,r){return(r=e.getParseTreeNode(r))?function(t,r){if(t=t.exportSymbol||t,71===r.kind&&(e.isRightSideOfQualifiedNameOrPropertyAccess(r)&&(r=r.parent),e.isExpressionNode(r)&&!e.isAssignmentTarget(r))){var n=Lp(r);if(on$$1(yr(r).resolvedSymbol)===t)return n}return ui(t)}(t,r):ee},getSymbolsOfParameterPropertyDeclaration:function(t,r){return t=e.getParseTreeNode(t,e.isParameter),e.Debug.assert(void 0!==t,"Cannot get symbols of a synthetic parameter that cannot be resolved to a parse-tree node."),function(t,r){var n=t.parent,i=t.parent.parent,a=vr(n.locals,r,67216319),o=vr(Gi(i.symbol),r,67216319);if(a&&o)return[a,o];e.Debug.fail("There should exist two symbols, one as property declaration and one as parameter declaration");}(t,e.escapeLeadingUnderscores(r))},getDeclaredTypeOfSymbol:Fi,getPropertiesOfType:xa,getPropertyOfType:function(t,r){return Ra(t,e.escapeLeadingUnderscores(r))},getIndexInfoOfType:za,getSignaturesOfType:Ka,getIndexTypeOfType:Ua,getBaseTypes:ki,getBaseTypeOfLiteralType:tu,getWidenedType:bu,getTypeFromTypeNode:function(t){return(t=e.getParseTreeNode(t,e.isTypeNode))?Hs(t):ee},getParameterType:Zd,getReturnTypeOfSignature:io,getNullableType:lu,getNonNullableType:du,typeToTypeNode:L.typeToTypeNode,indexInfoToIndexSignatureDeclaration:L.indexInfoToIndexSignatureDeclaration,signatureToSignatureDeclaration:L.signatureToSignatureDeclaration,symbolToEntityName:L.symbolToEntityName,symbolToExpression:L.symbolToExpression,symbolToTypeParameterDeclarations:L.symbolToTypeParameterDeclarations,symbolToParameterDeclaration:L.symbolToParameterDeclaration,typeParameterToDeclaration:L.typeParameterToDeclaration,getSymbolsInScope:function(t,r){return(t=e.getParseTreeNode(t))?function(t,r){if(4194304&t.flags)return[];var n=e.createSymbolTable(),i=!1;return function(){for(;t;){switch(t.locals&&!hr(t)&&o(t.locals,r),t.kind){case 237:o(nn(t).exports,2623475&r);break;case 236:o(nn(t).exports,8&r);break;case 203:var n=t.name;n&&a(t.symbol,r);case 233:case 234:i||o(Gi(nn(t)),67901928&r);break;case 190:var s=t.name;s&&a(t.symbol,r);}e.introducesArgumentsExoticObject(t)&&a(j,r),i=e.hasModifier(t,32),t=t.parent;}o(_t,r);}(),Va(n);function a(t,r){if(e.getCombinedLocalAndExportSymbolFlags(t)&r){var i=t.escapedName;n.has(i)||n.set(i,t);}}function o(e,t){t&&e.forEach(function(e){a(e,t);});}}(t,r):[]},getSymbolAtLocation:function(t){return(t=e.getParseTreeNode(t))?Om(t):void 0},getShorthandAssignmentValueSymbol:function(t){return(t=e.getParseTreeNode(t))?function(e){if(e&&269===e.kind)return zr(e.name,69313471)}(t):void 0},getExportSpecifierLocalTargetSymbol:function(t){return(t=e.getParseTreeNode(t,e.isExportSpecifier))?function(e){return e.parent.parent.moduleSpecifier?Fr(e.parent.parent,e):zr(e.propertyName||e.name,70107135)}(t):void 0},getExportSymbolOfSymbol:function(e){return rn(e.exportSymbol||e)},getTypeAtLocation:function(t){return(t=e.getParseTreeNode(t))?Im(t):ee},getPropertySymbolOfDestructuringAssignment:function(t){return(t=e.getParseTreeNode(t,e.isIdentifier))?function(t){var r=function t(r){if(e.Debug.assert(182===r.kind||181===r.kind),220===r.parent.kind){var n=zf(r.parent.expression,r.parent.awaitModifier);return kp(r,n||ee)}if(198===r.parent.kind){var n=Lp(r.parent.right);return kp(r,n||ee)}if(268===r.parent.kind){var i=t(r.parent.parent);return xp(i||ee,r.parent)}e.Debug.assert(181===r.parent.kind);var a=t(r.parent),o=Uf(a||ee,r.parent,!1,!1)||ee;return Sp(r.parent,a,r.parent.elements.indexOf(r),o||ee)}(t.parent.parent);return r&&Ra(r,t.escapedText)}(t):void 0},signatureToString:function(t,r,n,i){return Cn(t,e.getParseTreeNode(r),n,i)},typeToString:function(t,r,n){return En(t,e.getParseTreeNode(r),n)},symbolToString:function(t,r,n,i){return Dn(t,e.getParseTreeNode(r),n,i)},typePredicateToString:function(t,r,n){return An(t,e.getParseTreeNode(r),n)},writeSignature:function(t,r,n,i,a){return Cn(t,e.getParseTreeNode(r),n,i,a)},writeType:function(t,r,n,i){return En(t,e.getParseTreeNode(r),n,i)},writeSymbol:function(t,r,n,i,a){return Dn(t,e.getParseTreeNode(r),n,i,a)},writeTypePredicate:function(t,r,n,i){return An(t,e.getParseTreeNode(r),n,i)},getSymbolDisplayBuilder:function(){return{buildTypeDisplay:function(e,r,n,i){En(e,n,i,t(r));},buildSymbolDisplay:function(e,r,n,i,a){Dn(e,n,i,4|a,t(r));},buildSignatureDisplay:function(e,r,n,i,a){Cn(e,n,i,a,t(r));},buildIndexSignatureDisplay:function(r,n,i,a,o){var s=L.indexInfoToIndexSignatureDeclaration(r,i,a,3112960|Nn(o),n),c=e.createPrinter({removeComments:!0});c.writeNode(4,s,e.getSourceFileOfNode(e.getParseTreeNode(a)),t(n));},buildParameterDisplay:function(r,n,i,a){var o=L.symbolToParameterDeclaration(r,i,3112960|Nn(a),n),s=e.createPrinter({removeComments:!0});s.writeNode(4,o,e.getSourceFileOfNode(e.getParseTreeNode(i)),t(n));},buildTypeParameterDisplay:function(r,n,i,a){var o=L.typeParameterToDeclaration(r,i,3121152|Nn(a),n),s=e.createPrinter({removeComments:!0});s.writeNode(4,o,e.getSourceFileOfNode(e.getParseTreeNode(i)),t(n));},buildTypePredicateDisplay:function(e,r,n,i){An(e,n,i,t(r));},buildTypeParameterDisplayFromSymbol:function(r,n,i,a){var o=L.symbolToTypeParameterDeclarations(r,i,3112960|Nn(a),n),s=e.createPrinter({removeComments:!0});s.writeList(26896,o,e.getSourceFileOfNode(e.getParseTreeNode(i)),t(n));},buildDisplayForParametersAndDelimiters:function(r,n,i,a,o){var s=e.createPrinter({removeComments:!0}),c=3121152|Nn(o),u=r?[L.symbolToParameterDeclaration(r,a,c)]:[],l=e.createNodeArray(u.concat(e.map(n,function(e){return L.symbolToParameterDeclaration(e,a,c)})));s.writeList(1296,l,e.getSourceFileOfNode(e.getParseTreeNode(a)),t(i));},buildDisplayForTypeParametersAndDelimiters:function(r,n,i,a){var o=e.createPrinter({removeComments:!0}),s=e.createNodeArray(e.map(r,function(e){return L.typeParameterToDeclaration(e,i,Nn(a))}));o.writeList(26896,s,e.getSourceFileOfNode(e.getParseTreeNode(i)),t(n));},buildReturnTypeDisplay:function(r,n,i,a){n.writePunctuation(":"),n.writeSpace(" ");var o=no(r);if(o)return An(o,i,a,t(n));var s=L.typeToTypeNode(io(r),i,3112960|Nn(a),n),c=e.createPrinter({removeComments:!0});c.writeNode(4,s,e.getSourceFileOfNode(e.getParseTreeNode(i)),t(n));}};function t(t){return{write:e.noop,writeTextOfNode:e.noop,writeLine:e.noop,increaseIndent:function(){return t.increaseIndent()},decreaseIndent:function(){return t.decreaseIndent()},getText:function(){return""},rawWrite:e.noop,writeLiteral:function(e){return t.writeStringLiteral(e)},getTextPos:function(){return 0},getLine:function(){return 0},getColumn:function(){return 0},getIndent:function(){return 0},isAtStartOfLine:function(){return!1},clear:function(){return t.clear()},writeKeyword:function(e){return t.writeKeyword(e)},writeOperator:function(e){return t.writeOperator(e)},writePunctuation:function(e){return t.writePunctuation(e)},writeSpace:function(e){return t.writeSpace(e)},writeStringLiteral:function(e){return t.writeStringLiteral(e)},writeParameter:function(e){return t.writeParameter(e)},writeProperty:function(e){return t.writeProperty(e)},writeSymbol:function(e,r){return t.writeSymbol(e,r)},trackSymbol:function(e,r,n){return t.trackSymbol&&t.trackSymbol(e,r,n)},reportInaccessibleThisError:function(){return t.reportInaccessibleThisError&&t.reportInaccessibleThisError()},reportPrivateInBaseOfClassExpression:function(e){return t.reportPrivateInBaseOfClassExpression&&t.reportPrivateInBaseOfClassExpression(e)},reportInaccessibleUniqueSymbolError:function(){return t.reportInaccessibleUniqueSymbolError&&t.reportInaccessibleUniqueSymbolError()}}}},getAugmentedPropertiesOfType:Lm,getRootSymbols:function t(r){var n=function(t){if(6&e.getCheckFlags(t))return e.mapDefined(gr(t).containingType.types,function(e){return Ra(e,t.escapedName)});if(33554432&t.flags){var r=t,n=r.leftSpread,i=r.rightSpread,a=r.syntheticOrigin;return n?[n,i]:a?[a]:e.singleElementArray(function(e){for(var t,r=e;r=gr(r).target;)t=r;return t}(t))}}(r);return n?e.flatMap(n,t):[r]},getContextualType:function(t){return(t=e.getParseTreeNode(t,e.isExpression))?c_(t):void 0},getContextualTypeForArgumentAtIndex:function(t,r){return(t=e.getParseTreeNode(t,e.isCallLikeExpression))&&Zl(t,r)},getContextualTypeForJsxAttribute:function(t){return(t=e.getParseTreeNode(t,e.isJsxAttributeLike))&&o_(t)},isContextSensitive:dc,getFullyQualifiedName:Jr,getResolvedSignature:function(t,r,n){t=e.getParseTreeNode(t,e.isCallLikeExpression),B=n;var i=t?Kd(t,r):void 0;return B=void 0,i},getConstantValue:function(t){return(t=e.getParseTreeNode(t,eg))?tg(t):void 0},isValidPropertyAccess:function(t,r){return!!(t=e.getParseTreeNode(t,e.isPropertyAccessOrQualifiedName))&&function(e,t){var r=183===e.kind?e.expression:e.left;return od(e,r,t,bu(Rp(r)))}(t,e.escapeLeadingUnderscores(r))},isValidPropertyAccessForCompletions:function(t,r,n){return!!(t=e.getParseTreeNode(t,e.isPropertyAccessExpression))&&function(t,r,n){return od(t,t.expression,n.escapedName,r)&&(!(8192&n.flags)||(i=r,a=Ka(du(si(n)),0),e.Debug.assert(0!==a.length),a.some(function(e){var t=to(e);return!t||bc(i,function(e,t,r){if(!e.typeParameters)return t;var n=Du(e.typeParameters,e,0);return Iu(n.inferences,r,t),uc(t,co(e,ju(n)))}(e,t,i))})));var i,a;}(t,r,n)},getSignatureFromDeclaration:function(t){return(t=e.getParseTreeNode(t,e.isFunctionLike))?Za(t):void 0},isImplementationOfOverload:function(t){var r=e.getParseTreeNode(t,e.isFunctionLike);return r?$m(r):void 0},getImmediateAliasedSymbol:function(t){e.Debug.assert(0!=(2097152&t.flags),"Should only get Alias here.");var r=gr(t);if(!r.immediateTarget){var n=Ar(t);e.Debug.assert(!!n),r.immediateTarget=Ir(n,!0);}return r.immediateTarget},getAliasedSymbol:Rr,getEmitResolver:function(e,t){return Dm(e,t),M},getExportsOfModule:Xr,getExportsAndPropertiesOfModule:function(t){var r=Xr(t),n=Hr(t);return n!==t&&e.addRange(r,xa(ui(n))),r},getSymbolWalker:e.createGetSymbolWalker(ao,no,io,ki,ya,ui,Ju,Ja,ho,pm),getAmbientModules:function(){return Ce||(Ce=[],_t.forEach(function(e,t){n.test(t)&&Ce.push(e);})),Ce},getAllAttributesTypeFromJsxOpeningLikeElement:function(t){return(t=e.getParseTreeNode(t,e.isJsxOpeningLikeElement))?function(e){return C_(e.tagName)?B_(e):K_(e,!0)}(t):void 0},getJsxIntrinsicTagNamesAt:function(r){var n=P_(t.IntrinsicElements,r);return n?xa(n):e.emptyArray},isOptionalParameter:function(t){return!!(t=e.getParseTreeNode(t,e.isParameter))&&Ga(t)},tryGetMemberInModuleExports:function(t,r){return Qr(e.escapeLeadingUnderscores(t),r)},tryGetMemberInModuleExportsAndProperties:function(t,r){return function(e,t){var r=Qr(e,t);if(r)return r;var n=Hr(t);if(n!==t){var i=ui(n);return 16382&i.flags?void 0:Ra(i,e)}}(e.escapeLeadingUnderscores(t),r)},tryFindAmbientModuleWithoutAugmentations:function(e){return Ha(e,!1)},getApparentType:Oa,getUnionType:ds,createAnonymousType:mn,createSignature:Yi,createSymbol:cr,createIndexInfo:go,getAnyType:function(){return Q},getStringType:function(){return ae},getNumberType:function(){return oe},createPromiseType:rp,createArrayType:rs,getBooleanType:function(){return ue},getVoidType:function(){return _e},getUndefinedType:function(){return te},getNullType:function(){return ne},getESSymbolType:function(){return le},getNeverType:function(){return de},isSymbolAccessible:xn,isArrayLikeType:Qc,getAllPossiblePropertiesOfTypes:function(t){var r=ds(t);if(!(131072&r.flags))return Lm(r);for(var n=e.createSymbolTable(),i=0,a=t;i<a.length;i++)for(var o=a[i],s=0,c=Lm(o);s<c.length;s++){var u=c[s].escapedName;if(!n.has(u)){var l=Ia(r,u);l&&n.set(u,l);}}return e.arrayFrom(n.values())},getSuggestionForNonexistentProperty:function(e,t){return td(e,t)},getSuggestionForNonexistentSymbol:function(t,r,n){return rd(t,e.escapeLeadingUnderscores(r),n)},getBaseConstraintOfType:Ea,getDefaultFromTypeParameter:function(e){return e&&32768&e.flags?Fa(e):void 0},resolveName:function(t,r,n,i){return xr(r,e.escapeLeadingUnderscores(t),n,void 0,void 0,!1,i)},getJsxNamespace:function(t){return e.unescapeLeadingUnderscores(or(t))},getAccessibleSymbolChain:hn,getTypePredicateOfSignature:no,resolveExternalModuleSymbol:Hr,tryGetThisTypeAt:function(t){return(t=e.getParseTreeNode(t))&&Ul(t)},getTypeArgumentConstraint:function(t){return(t=e.getParseTreeNode(t,e.isTypeNode))&&function(t){var r=e.tryCast(t.parent,e.isTypeReferenceType);if(r){var n=Xp(r),i=ka(n[r.typeArguments.indexOf(t)]);return i&&uc(i,Qs(n,Gp(r,n)))}}(t)},getSuggestionDiagnostics:function(t){return Rt.get(t.fileName)||e.emptyArray}},z=[],U=e.createMap(),q=e.createMap(),V=e.createMap(),W=e.createMap(),H=[],G=e.createMap(),$=cr(4,"unknown"),X=cr(0,"__resolving__"),Q=ln(1,"any"),Y=ln(1,"any"),Z=ln(1,"any"),ee=ln(1,"unknown"),te=ln(4096,"undefined"),re=P?te:ln(16781312,"undefined"),ne=ln(8192,"null"),ie=P?ne:ln(16785408,"null"),ae=ln(2,"string"),oe=ln(4,"number"),se=ln(128,"true"),ce=ln(128,"false"),ue=((K=ds([se,ce])).flags|=8,K.intrinsicName="boolean",K),le=ln(512,"symbol"),_e=ln(2048,"void"),de=ln(16384,"never"),pe=ln(16384,"never"),fe=ln(16384,"never"),me=ln(134217728,"object"),ge=mn(void 0,k,e.emptyArray,e.emptyArray,void 0,void 0),ye=cr(2048,"__type");ye.members=e.createSymbolTable();var he=mn(ye,k,e.emptyArray,e.emptyArray,void 0,void 0),ve=mn(void 0,k,e.emptyArray,e.emptyArray,void 0,void 0);ve.instantiations=e.createMap();var be=mn(void 0,k,e.emptyArray,e.emptyArray,void 0,void 0);be.flags|=67108864;var xe=mn(void 0,k,e.emptyArray,e.emptyArray,void 0,void 0),Se=mn(void 0,k,e.emptyArray,e.emptyArray,void 0,void 0),ke=mn(void 0,k,e.emptyArray,e.emptyArray,void 0,void 0),Te=un(32768),De=un(32768);De.constraint=Te;var Ce,Ee,Ne,Ae,Pe,we,Fe,Oe,Ie,Me,Le,Re,Be,Ke,je,Je,ze,Ue,qe,Ve,We,He,Ge,$e,Xe,Qe,Ye,Ze,et,tt,rt,nt=un(32768),it=$a("<<unresolved>>",0,Q),at=Yi(void 0,void 0,void 0,e.emptyArray,Q,void 0,0,!1,!1),ot=Yi(void 0,void 0,void 0,e.emptyArray,ee,void 0,0,!1,!1),st=Yi(void 0,void 0,void 0,e.emptyArray,Q,void 0,0,!1,!1),ct=Yi(void 0,void 0,void 0,e.emptyArray,pe,void 0,0,!1,!1),ut=go(ae,!0),lt=go(Q,!1),_t=e.createSymbolTable(),dt=e.createMap(),pt=0,ft=0,mt=0,gt=!1,yt=qs(""),ht=qs(0),vt=[],bt=[],xt=[],St=0,kt=10,Tt=[],Dt=[],Ct=[],Et=[],Nt=[],At=[],Pt=[],wt=[],Ft=[],Ot=[],It=[],Mt=[],Lt=e.createDiagnosticCollection(),Rt=e.createMultiMap();function Bt(t){Rt.add(t.file.fileName,r({},t,{category:e.DiagnosticCategory.Suggestion}));}!function(e){e[e.None=0]="None",e[e.TypeofEQString=1]="TypeofEQString",e[e.TypeofEQNumber=2]="TypeofEQNumber",e[e.TypeofEQBoolean=4]="TypeofEQBoolean",e[e.TypeofEQSymbol=8]="TypeofEQSymbol",e[e.TypeofEQObject=16]="TypeofEQObject",e[e.TypeofEQFunction=32]="TypeofEQFunction",e[e.TypeofEQHostObject=64]="TypeofEQHostObject",e[e.TypeofNEString=128]="TypeofNEString",e[e.TypeofNENumber=256]="TypeofNENumber",e[e.TypeofNEBoolean=512]="TypeofNEBoolean",e[e.TypeofNESymbol=1024]="TypeofNESymbol",e[e.TypeofNEObject=2048]="TypeofNEObject",e[e.TypeofNEFunction=4096]="TypeofNEFunction",e[e.TypeofNEHostObject=8192]="TypeofNEHostObject",e[e.EQUndefined=16384]="EQUndefined",e[e.EQNull=32768]="EQNull",e[e.EQUndefinedOrNull=65536]="EQUndefinedOrNull",e[e.NEUndefined=131072]="NEUndefined",e[e.NENull=262144]="NENull",e[e.NEUndefinedOrNull=524288]="NEUndefinedOrNull",e[e.Truthy=1048576]="Truthy",e[e.Falsy=2097152]="Falsy",e[e.All=4194303]="All",e[e.BaseStringStrictFacts=933633]="BaseStringStrictFacts",e[e.BaseStringFacts=3145473]="BaseStringFacts",e[e.StringStrictFacts=4079361]="StringStrictFacts",e[e.StringFacts=4194049]="StringFacts",e[e.EmptyStringStrictFacts=3030785]="EmptyStringStrictFacts",e[e.EmptyStringFacts=3145473]="EmptyStringFacts",e[e.NonEmptyStringStrictFacts=1982209]="NonEmptyStringStrictFacts",e[e.NonEmptyStringFacts=4194049]="NonEmptyStringFacts",e[e.BaseNumberStrictFacts=933506]="BaseNumberStrictFacts",e[e.BaseNumberFacts=3145346]="BaseNumberFacts",e[e.NumberStrictFacts=4079234]="NumberStrictFacts",e[e.NumberFacts=4193922]="NumberFacts",e[e.ZeroStrictFacts=3030658]="ZeroStrictFacts",e[e.ZeroFacts=3145346]="ZeroFacts",e[e.NonZeroStrictFacts=1982082]="NonZeroStrictFacts",e[e.NonZeroFacts=4193922]="NonZeroFacts",e[e.BaseBooleanStrictFacts=933252]="BaseBooleanStrictFacts",e[e.BaseBooleanFacts=3145092]="BaseBooleanFacts",e[e.BooleanStrictFacts=4078980]="BooleanStrictFacts",e[e.BooleanFacts=4193668]="BooleanFacts",e[e.FalseStrictFacts=3030404]="FalseStrictFacts",e[e.FalseFacts=3145092]="FalseFacts",e[e.TrueStrictFacts=1981828]="TrueStrictFacts",e[e.TrueFacts=4193668]="TrueFacts",e[e.SymbolStrictFacts=1981320]="SymbolStrictFacts",e[e.SymbolFacts=4193160]="SymbolFacts",e[e.ObjectStrictFacts=1972176]="ObjectStrictFacts",e[e.ObjectFacts=4184016]="ObjectFacts",e[e.FunctionStrictFacts=1970144]="FunctionStrictFacts",e[e.FunctionFacts=4181984]="FunctionFacts",e[e.UndefinedFacts=2457472]="UndefinedFacts",e[e.NullFacts=2340752]="NullFacts";}(rt||(rt={}));var Kt,jt,Jt,zt,Ut,qt,Vt,Wt,Ht,Gt=e.createMapFromTemplate({string:1,number:2,boolean:4,symbol:8,undefined:16384,object:16,function:32}),$t=e.createMapFromTemplate({string:128,number:256,boolean:512,symbol:1024,undefined:131072,object:2048,function:4096}),Xt=e.createMapFromTemplate({string:ae,number:oe,boolean:ue,symbol:le,undefined:te}),Qt=ds(e.arrayFrom(Gt.keys(),qs)),Yt=e.createMap(),Zt=e.createMap(),er=e.createMap(),tr=e.createMap(),rr=e.createMap(),nr=e.createMap();!function(e){e[e.Type=0]="Type",e[e.ResolvedBaseConstructorType=1]="ResolvedBaseConstructorType",e[e.DeclaredType=2]="DeclaredType",e[e.ResolvedReturnType=3]="ResolvedReturnType",e[e.ResolvedBaseConstraint=4]="ResolvedBaseConstraint";}(Jt||(Jt={})),function(e){e[e.Normal=0]="Normal",e[e.SkipContextSensitive=1]="SkipContextSensitive",e[e.Inferential=2]="Inferential",e[e.Contextual=3]="Contextual";}(zt||(zt={})),function(e){e[e.None=0]="None",e[e.Bivariant=1]="Bivariant",e[e.Strict=2]="Strict";}(Ut||(Ut={})),function(e){e[e.IncludeReadonly=1]="IncludeReadonly",e[e.ExcludeReadonly=2]="ExcludeReadonly",e[e.IncludeOptional=4]="IncludeOptional",e[e.ExcludeOptional=8]="ExcludeOptional";}(qt||(qt={})),function(e){e[e.None=0]="None",e[e.Source=1]="Source",e[e.Target=2]="Target",e[e.Both=3]="Both";}(Vt||(Vt={})),function(e){e[e.Any=1]="Any",e[e.Undefined=2]="Undefined",e[e.Null=4]="Null",e[e.Never=8]="Never",e[e.NonWideningType=16]="NonWideningType",e[e.String=32]="String",e[e.Number=64]="Number",e[e.ESSymbol=128]="ESSymbol",e[e.LiteralOrUniqueESSymbol=256]="LiteralOrUniqueESSymbol",e[e.ObjectType=512]="ObjectType",e[e.EmptyObject=1024]="EmptyObject",e[e.Union=2048]="Union",e[e.Wildcard=4096]="Wildcard";}(Wt||(Wt={})),function(e){e.resolvedExports="resolvedExports",e.resolvedMembers="resolvedMembers";}(Ht||(Ht={}));var ir=e.createSymbolTable();ir.set(R.escapedName,R);var ar=e.and(bm,function(t){return!e.isAccessor(t)});return function(){for(var t=0,r=i.getSourceFiles();t<r.length;t++){var n=r[t];e.bindSourceFile(n,D);}for(var a,o=0,s=i.getSourceFiles();o<s.length;o++){var n=s[o];if(e.isExternalOrCommonJsModule(n)||fr(_t,n.locals),n.patternAmbientModules&&n.patternAmbientModules.length&&(Ee=e.concatenate(Ee,n.patternAmbientModules)),n.moduleAugmentations.length&&(a||(a=[])).push(n.moduleAugmentations),n.symbol&&n.symbol.globalExports){var c=n.symbol.globalExports;c.forEach(function(e,t){_t.has(t)||_t.set(t,e);});}}if(a)for(var u=0,l=a;u<l.length;u++)for(var _=l[u],d=0,p=_;d<p.length;d++){var f=p[d];e.isGlobalScopeAugmentation(f.parent)&&mr(f);}if(function(t,r,n){r.forEach(function(r,i){var a=t.get(i);a?e.forEach(a.declarations,function(t,r){return function(n){return Lt.add(e.createDiagnosticForNode(n,r,t))}}(e.unescapeLeadingUnderscores(i),n)):t.set(i,r);});}(_t,ir,e.Diagnostics.Declaration_name_conflicts_with_built_in_global_identifier_0),gr(R).type=re,gr(j).type=Ko("IArguments",0,!0),gr($).type=ee,Pe=Ko("Array",1,!0),Ne=Ko("Object",0,!0),Ae=Ko("Function",0,!0),Fe=Ko("String",0,!0),Oe=Ko("Number",0,!0),Ie=Ko("Boolean",0,!0),Me=Ko("RegExp",0,!0),Re=rs(Q),(Be=rs(Y))===ge&&(Be=mn(void 0,k,e.emptyArray,e.emptyArray,void 0,void 0)),we=Xo("ReadonlyArray",1),Ke=we?Qo(we,[Q]):Re,Le=Xo("ThisType",1),a)for(var m=0,g=a;m<g.length;m++)for(var _=g[m],y=0,h=_;y<h.length;y++){var f=h[y];e.isGlobalScopeAugmentation(f.parent)||mr(f);}}(),J;function or(t){if(t){var r=e.getSourceFileOfNode(t);if(r){if(r.localJsxNamespace)return r.localJsxNamespace;var n=r.pragmas.get("jsx");if(n){var i=e.isArray(n)?n[0]:n;if(r.localJsxFactory=e.parseIsolatedEntityName(i.arguments.factory,C),r.localJsxFactory)return r.localJsxNamespace=pm(r.localJsxFactory).escapedText}}}return Kt||(Kt="React",D.jsxFactory?(jt=e.parseIsolatedEntityName(D.jsxFactory,C))&&(Kt=pm(jt).escapedText):D.reactNamespace&&(Kt=e.escapeLeadingUnderscores(D.reactNamespace))),Kt}function sr(t,r,n,i,a,o){var s=t?e.createDiagnosticForNode(t,r,n,i,a,o):e.createCompilerDiagnostic(r,n,i,a,o);Lt.add(s);}function cr(e,t,r){b++;var n=new g(33554432|e,t);return n.checkFlags=r||0,n}function ur(e){return 0!=(33554432&e.flags)}function lr(e){var t=0;return 2&e&&(t|=67216319),1&e&&(t|=67216318),4&e&&(t|=0),8&e&&(t|=68008959),16&e&&(t|=67215791),32&e&&(t|=68008383),64&e&&(t|=67901832),256&e&&(t|=68008191),128&e&&(t|=68008831),512&e&&(t|=67215503),8192&e&&(t|=67208127),32768&e&&(t|=67150783),65536&e&&(t|=67183551),262144&e&&(t|=67639784),524288&e&&(t|=67901928),2097152&e&&(t|=2097152),t}function _r(e,t){t.mergeId||(t.mergeId=o,o++),Tt[t.mergeId]=e;}function dr(t){var r=cr(t.flags,t.escapedName);return r.declarations=t.declarations?t.declarations.slice():[],r.parent=t.parent,t.valueDeclaration&&(r.valueDeclaration=t.valueDeclaration),t.constEnumOnlyModule&&(r.constEnumOnlyModule=!0),t.members&&(r.members=e.cloneMap(t.members)),t.exports&&(r.exports=e.cloneMap(t.exports)),_r(r,t),r}function pr(t,r){if(!(t.flags&lr(r.flags))||67108864&(r.flags|t.flags)){if(512&r.flags&&512&t.flags&&t.constEnumOnlyModule&&!r.constEnumOnlyModule&&(t.constEnumOnlyModule=!1),t.flags|=r.flags,r.valueDeclaration&&(!t.valueDeclaration||237===t.valueDeclaration.kind&&237!==r.valueDeclaration.kind)&&(t.valueDeclaration=r.valueDeclaration),e.addRange(t.declarations,r.declarations),r.members&&(t.members||(t.members=e.createSymbolTable()),fr(t.members,r.members)),r.exports&&(t.exports||(t.exports=e.createSymbolTable()),fr(t.exports,r.exports)),67108864&(r.flags|t.flags)){var n=e.getJSInitializerSymbol(r),i=e.getJSInitializerSymbol(t);n===r&&i===t||pr(i,n);}_r(t,r);}else if(1024&t.flags)sr(e.getNameOfDeclaration(r.declarations[0]),e.Diagnostics.Cannot_augment_module_0_with_value_exports_because_it_resolves_to_a_non_module_entity,Dn(t));else{var a=384&t.flags||384&r.flags?e.Diagnostics.Enum_declarations_can_only_merge_with_namespace_or_other_enum_declarations:2&t.flags||2&r.flags?e.Diagnostics.Cannot_redeclare_block_scoped_variable_0:e.Diagnostics.Duplicate_identifier_0;e.forEach(r.declarations,function(t){sr((e.getJavascriptInitializer(t,!1)?e.getOuterNameOfJsInitializer(t):e.getNameOfDeclaration(t))||t,a,Dn(r));}),e.forEach(t.declarations,function(t){sr((e.getJavascriptInitializer(t,!1)?e.getOuterNameOfJsInitializer(t):e.getNameOfDeclaration(t))||t,a,Dn(r));});}}function fr(e,t){t.forEach(function(t,r){var n=e.get(r);n?(33554432&n.flags||(n=dr(n),e.set(r,n)),pr(n,t)):e.set(r,t);});}function mr(t){var r=t.parent;if(r.symbol.declarations[0]===r)if(e.isGlobalScopeAugmentation(r))fr(_t,r.symbol.exports);else{var n=qr(t,t,2097152&t.parent.parent.flags?void 0:e.Diagnostics.Invalid_module_name_in_augmentation_module_0_cannot_be_found,!0);if(!n)return;1920&(n=Hr(n)).flags?pr(n=33554432&n.flags?n:dr(n),r.symbol):sr(t,e.Diagnostics.Cannot_augment_module_0_because_it_resolves_to_a_non_module_entity,t.text);}else e.Debug.assert(r.symbol.declarations.length>1);}function gr(e){if(33554432&e.flags)return e;var t=u(e);return Dt[t]||(Dt[t]={})}function yr(e){var t=c(e);return Ct[t]||(Ct[t]={flags:0})}function hr(t){return 272===t.kind&&!e.isExternalOrCommonJsModule(t)}function vr(t,r,n){if(n){var i=t.get(r);if(i){if(e.Debug.assert(0==(1&e.getCheckFlags(i)),"Should never get an instantiated symbol here."),i.flags&n)return i;if(2097152&i.flags){var a=Rr(i);if(a===$||a.flags&n)return i}}}}function br(t,r){var n=e.getSourceFileOfNode(t),a=e.getSourceFileOfNode(r);if(n!==a){if(E&&(n.externalModuleIndicator||a.externalModuleIndicator)||!D.outFile&&!D.out||zu(r)||2097152&t.flags)return!0;if(u(r,t))return!0;var o=i.getSourceFiles();return o.indexOf(n)<=o.indexOf(a)}if(t.pos<=r.pos){if(180===t.kind){var s=e.getAncestor(r,180);return s?e.findAncestor(s,e.isBindingElement)!==e.findAncestor(t,e.isBindingElement)||t.pos<s.pos:br(e.getAncestor(t,230),r)}return 230!==t.kind||!function(t,r){var n=e.getEnclosingBlockScopeContainer(t);switch(t.parent.parent.kind){case 212:case 218:case 220:if(Er(r,t,n))return!0}return e.isForInOrOfStatement(t.parent.parent)&&Er(r,t.parent.parent.expression,n)}(t,r)}if(250===r.parent.kind||247===r.parent.kind&&r.parent.isExportEquals)return!0;if(247===r.kind&&r.isExportEquals)return!0;var c=e.getEnclosingBlockScopeContainer(t);return zu(r)||u(r,t,c);function u(t,r,n){return!!e.findAncestor(t,function(i){if(i===n)return"quit";if(e.isFunctionLike(i))return!0;if(i.parent&&151===i.parent.kind&&i.parent.initializer===i)if(e.hasModifier(i.parent,32)){if(153===r.kind)return!0}else if(151!==r.kind||e.hasModifier(r,32)||e.getContainingClass(t)!==e.getContainingClass(r))return!0})}}function xr(e,t,r,n,i,a,o,s){return void 0===o&&(o=!1),Sr(e,t,r,n,i,a,o,vr,s)}function Sr(t,r,n,i,a,o,s,c,u){var l,_,d,p,f,m=t,g=t,y=!1;e:for(;t;){if(t.locals&&!hr(t)&&(l=c(t.locals,r,n))){var h=!0;if(e.isFunctionLike(t)&&_&&_!==t.body?(n&l.flags&67901928&&282!==_.kind&&(h=!!(262144&l.flags)&&(_===t.type||148===_.kind||147===_.kind)),67216319&n&&1&l.flags&&(h=148===_.kind||_===t.type&&148===l.valueDeclaration.kind)):170===t.kind&&(h=_===t.trueType),h)break e;l=void 0;}switch(t.kind){case 272:if(!e.isExternalOrCommonJsModule(t))break;y=!0;case 237:var v=nn(t).exports;if(272===t.kind||e.isAmbientModule(t)){if(l=v.get("default")){var b=e.getLocalSymbolForExportDefault(l);if(b&&l.flags&n&&b.escapedName===r)break e;l=void 0;}var x=v.get(r);if(x&&2097152===x.flags&&e.getDeclarationOfKind(x,250))break}if(l=c(v,r,2623475&n))break e;break;case 236:if(l=c(nn(t).exports,r,8&n))break e;break;case 151:case 150:if(e.isClassLike(t.parent)&&!e.hasModifier(t,32)){var S=cn(t.parent);S&&S.locals&&c(S.locals,r,67216319&n)&&(p=t);}break;case 233:case 203:case 234:if(l=c(Gi(nn(t)),r,67901928&n)){if(!Dr(l,t)){l=void 0;break}if(_&&e.hasModifier(_,32))return void sr(g,e.Diagnostics.Static_members_cannot_reference_class_type_parameters);break e}if(203===t.kind&&32&n){var k=t.name;if(k&&r===k.escapedText){l=t.symbol;break e}}break;case 205:if(_===t.expression&&85===t.parent.token){var T=t.parent.parent;if(e.isClassLike(T)&&(l=c(nn(T).members,r,67901928&n)))return void(i&&sr(g,e.Diagnostics.Base_class_expressions_cannot_reference_class_type_parameters))}break;case 146:if(f=t.parent.parent,(e.isClassLike(f)||234===f.kind)&&(l=c(nn(f).members,r,67901928&n)))return void sr(g,e.Diagnostics.A_computed_property_name_cannot_reference_a_type_parameter_from_its_containing_type);break;case 153:case 152:case 154:case 155:case 156:case 232:case 191:if(3&n&&"arguments"===r){l=j;break e}break;case 190:if(3&n&&"arguments"===r){l=j;break e}if(16&n){var D=t.name;if(D&&r===D.escapedText){l=t.symbol;break e}}break;case 149:t.parent&&148===t.parent.kind&&(t=t.parent),t.parent&&e.isClassElement(t.parent)&&(t=t.parent);}kr(t)&&(d=t),_=t,t=t.parent;}if(o&&l&&i&&N&&(!d||l!==d.symbol)&&(l.isReferenced|=n),!l){if(_&&(e.Debug.assert(272===_.kind),_.commonJsModuleIndicator&&"exports"===r))return _.symbol;s||(l=c(_t,r,n));}if(l){if(i){if(p){var C=p.name;return void sr(g,e.Diagnostics.Initializer_of_instance_member_variable_0_cannot_reference_identifier_1_declared_in_the_constructor,e.declarationNameToString(C),Tr(a))}if(g&&(2&n||(32&n||384&n)&&67216319==(67216319&n))){var E=on$$1(l);(2&E.flags||32&E.flags||384&E.flags)&&function(t,r){e.Debug.assert(!!(2&t.flags||32&t.flags||384&t.flags));var n=e.forEach(t.declarations,function(t){return e.isBlockOrCatchScoped(t)||e.isClassLike(t)||236===t.kind?t:void 0});e.Debug.assert(void 0!==n,"Declaration to checkResolvedBlockScopedVariable is undefined"),2097152&n.flags||br(n,r)||(2&t.flags?sr(r,e.Diagnostics.Block_scoped_variable_0_used_before_its_declaration,e.declarationNameToString(e.getNameOfDeclaration(n))):32&t.flags?sr(r,e.Diagnostics.Class_0_used_before_its_declaration,e.declarationNameToString(e.getNameOfDeclaration(n))):256&t.flags&&sr(r,e.Diagnostics.Enum_0_used_before_its_declaration,e.declarationNameToString(e.getNameOfDeclaration(n))));}(E,g);}if(l&&y&&67216319==(67216319&n)){var A=l.declarations;A&&1===A.length&&240===A[0].kind&&sr(g,e.Diagnostics._0_refers_to_a_UMD_global_but_the_current_file_is_a_module_Consider_adding_an_import_instead,e.unescapeLeadingUnderscores(r));}}return l}if(i&&(!g||!(function(t,r,n){if(!e.isIdentifier(t)||t.escapedText!==r||Nm(t)||zu(t))return!1;for(var i=e.getThisContainer(t,!0),a=i;a;){if(e.isClassLike(a.parent)){var o=nn(a.parent);if(!o)break;var s=ui(o);if(Ra(s,r))return sr(t,e.Diagnostics.Cannot_find_name_0_Did_you_mean_the_static_member_1_0,Tr(n),Dn(o)),!0;if(a===i&&!e.hasModifier(a,32)){var c=Fi(o).thisType;if(Ra(c,r))return sr(t,e.Diagnostics.Cannot_find_name_0_Did_you_mean_the_instance_member_this_0,Tr(n)),!0}}a=a.parent;}return!1}(g,r,a)||Cr(g)||function(t,r,n){var i=1920|(e.isInJavaScriptFile(t)?67216319:0);if(n===i){var a=Lr(xr(t,r,67901928&~i,void 0,void 0,!1)),o=t.parent;if(a){if(e.isQualifiedName(o)){e.Debug.assert(o.left===t,"Should only be resolving left side of qualified name as a namespace");var s=o.right.escapedText,c=Ra(Fi(a),s);if(c)return sr(o,e.Diagnostics.Cannot_access_0_1_because_0_is_a_type_but_not_a_namespace_Did_you_mean_to_retrieve_the_type_of_the_property_1_in_0_with_0_1,e.unescapeLeadingUnderscores(r),e.unescapeLeadingUnderscores(s)),!0}return sr(t,e.Diagnostics._0_only_refers_to_a_type_but_is_being_used_as_a_namespace_here,e.unescapeLeadingUnderscores(r)),!0}}return!1}(g,r,n)||function(t,r,n){if(67216319&n){if("any"===r||"string"===r||"number"===r||"boolean"===r||"never"===r)return sr(t,e.Diagnostics._0_only_refers_to_a_type_but_is_being_used_as_a_value_here,e.unescapeLeadingUnderscores(r)),!0;var i=Lr(xr(t,r,792640,void 0,void 0,!1));if(i&&!(1024&i.flags))return sr(t,e.Diagnostics._0_only_refers_to_a_type_but_is_being_used_as_a_value_here,e.unescapeLeadingUnderscores(r)),!0}return!1}(g,r,n)||function(t,r,n){if(107031&n){var i=Lr(xr(t,r,1024,void 0,void 0,!1));if(i)return sr(t,e.Diagnostics.Cannot_use_namespace_0_as_a_value,e.unescapeLeadingUnderscores(r)),!0}else if(792640&n){var i=Lr(xr(t,r,1536,void 0,void 0,!1));if(i)return sr(t,e.Diagnostics.Cannot_use_namespace_0_as_a_type,e.unescapeLeadingUnderscores(r)),!0}return!1}(g,r,n)))){var P=void 0;u&&St<kt&&(P=rd(m,r,n))&&sr(g,u,Tr(a),P),P||sr(g,i,Tr(a)),St++;}}function kr(e){switch(e.kind){case 232:case 233:case 234:case 236:case 235:case 237:return!0;default:return!1}}function Tr(t){return e.isString(t)?e.unescapeLeadingUnderscores(t):e.declarationNameToString(t)}function Dr(e,t){for(var r=0,n=e.declarations;r<n.length;r++){var i=n[r];if(147===i.kind&&i.parent===t)return!0}return!1}function Cr(t){var r=function t(r){switch(r.kind){case 71:case 183:return r.parent?t(r.parent):void 0;case 205:if(e.isEntityNameExpression(r.expression))return r.expression;default:return}}(t),n=!(!r||!zr(r,64,!0));return n&&sr(t,e.Diagnostics.Cannot_extend_an_interface_0_Did_you_mean_implements,e.getTextOfNode(r)),n}function Er(t,r,n){return r&&!!e.findAncestor(t,function(t){return t===n||e.isFunctionLike(t)?"quit":t===r})}function Nr(e){switch(e.kind){case 241:return e;case 243:return e.parent;case 244:return e.parent.parent;case 246:return e.parent.parent.parent;default:return}}function Ar(t){return e.find(t.declarations,e.isAliasSymbolDeclaration)}function Pr(e,t,r){var n=e.exports.get("export=");return n?Ra(ui(n),t):Lr(e.exports.get(t),r)}function wr(t,r,n){return!!A&&(!t||t.isDeclarationFile?!Pr(r,"default",n)&&!Pr(r,e.escapeLeadingUnderscores("__esModule"),n):e.isSourceFileJavaScript(t)?!t.externalModuleIndicator&&!Pr(r,e.escapeLeadingUnderscores("__esModule"),n):$r(r))}function Fr(t,r,n){var i=Ur(t,t.moduleSpecifier),a=Gr(i,t.moduleSpecifier,n);if(a){var o=r.propertyName||r.name;if(o.escapedText){if(e.isShorthandAmbientModuleSymbol(i))return i;var s=void 0;s=Lr(s=i&&i.exports&&i.exports.get("export=")?Ra(ui(a),o.escapedText):function(e,t){if(3&e.flags){var r=e.valueDeclaration.type;if(r)return Lr(Ra(Hs(r),t))}}(a,o.escapedText),n);var c=function(e,t,r){if(1536&e.flags)return Lr(Yr(e).get(t),r)}(a,o.escapedText,n);!c&&A&&"default"===o.escapedText&&(c=Hr(i,n)||Lr(i,n));var u=c&&s?function(t,r){if(t===$&&r===$)return $;if(67903464&t.flags)return t;var n=cr(t.flags|r.flags,t.escapedName);return n.declarations=e.concatenate(t.declarations,r.declarations),n.parent=t.parent||r.parent,t.valueDeclaration&&(n.valueDeclaration=t.valueDeclaration),r.members&&(n.members=r.members),t.exports&&(n.exports=t.exports),n}(s,c):c||s;if(!u){var l=Jr(i),_=e.declarationNameToString(o),d=function(t,r){var n=r.exports&&nd(e.idText(t),Xr(r),2623475);return n&&e.symbolName(n)}(o,a);void 0!==d?sr(o,e.Diagnostics.Module_0_has_no_exported_member_1_Did_you_mean_2,l,_,d):sr(o,e.Diagnostics.Module_0_has_no_exported_member_1,l,_);}return u}}}function Or(e,t,r){return e.parent.parent.moduleSpecifier?Fr(e.parent.parent,e,r):zr(e.propertyName||e.name,t,!1,r)}function Ir(t,r){switch(t.kind){case 241:return function(t,r){return 252===t.moduleReference.kind?Hr(Ur(t,e.getExternalModuleImportEqualsDeclarationExpression(t))):jr(t.moduleReference,r)}(t,r);case 243:return function(t,r){var n=Ur(t,t.parent.moduleSpecifier);if(n){var i=void 0;i=e.isShorthandAmbientModuleSymbol(n)?n:Pr(n,"default",r);var a=wr(e.find(n.declarations,e.isSourceFile),n,r);if(i||a){if(!i&&a)return Hr(n,r)||Lr(n,r)}else sr(t.name,e.Diagnostics.Module_0_has_no_default_export,Dn(n));return i}}(t,r);case 244:return function(e,t){var r=e.parent.parent.moduleSpecifier;return Gr(Ur(e,r),r,t)}(t,r);case 246:return function(e,t){return Fr(e.parent.parent.parent,e,t)}(t,r);case 250:return Or(t,68009983,r);case 247:return function(e,t){return zr(e.expression,68009983,!1,t)}(t,r);case 240:return function(e,t){return Hr(e.parent.symbol,t)}(t,r)}}function Mr(e,t){return void 0===t&&(t=68009983),e&&2097152==(e.flags&(2097152|t))}function Lr(e,t){return!t&&Mr(e)?Rr(e):e}function Rr(t){e.Debug.assert(0!=(2097152&t.flags),"Should only get Alias here.");var r=gr(t);if(r.target)r.target===X&&(r.target=$);else{r.target=X;var n=Ar(t);e.Debug.assert(!!n);var i=Ir(n);r.target===X?r.target=i||$:sr(n,e.Diagnostics.Circular_definition_of_import_alias_0,Dn(t));}return r.target}function Br(e){var t=nn(e),r=Rr(t);r&&(r===$||67216319&r.flags&&!Gm(r))&&Kr(t);}function Kr(t){var r=gr(t);if(!r.referenced){r.referenced=!0;var n=Ar(t);e.Debug.assert(!!n),247===n.kind?Ap(n.expression):250===n.kind?Ap(n.propertyName||n.name):e.isInternalModuleImportEqualsDeclaration(n)&&Ap(n.moduleReference);}}function jr(t,r){return 71===t.kind&&e.isRightSideOfQualifiedNameOrPropertyAccess(t)&&(t=t.parent),71===t.kind||145===t.parent.kind?zr(t,1920,!1,r):(e.Debug.assert(241===t.parent.kind),zr(t,68009983,!1,r))}function Jr(e){return e.parent?Jr(e.parent)+"."+Dn(e):Dn(e)}function zr(t,r,n,i,a){if(!e.nodeIsMissing(t)){var o,s=1920|(e.isInJavaScriptFile(t)?67216319&r:0);if(71===t.kind){var c=r===s?e.Diagnostics.Cannot_find_namespace_0:e.Diagnostics.Cannot_find_name_0;if(!(o=xr(a||t,t.escapedText,r,n?void 0:c,t,!0)))return}else if(145===t.kind||183===t.kind){var u=145===t.kind?t.left:t.expression,l=145===t.kind?t.right:t.name,_=zr(u,s,n,!1,a);if(!_||e.nodeIsMissing(l))return;if(_===$)return _;if(e.isInJavaScriptFile(t)){var d=e.getDeclaredJavascriptInitializer(_.valueDeclaration)||e.getAssignedJavascriptInitializer(_.valueDeclaration);if(d&&(_=nn(d)),_.valueDeclaration&&e.isVariableDeclaration(_.valueDeclaration)&&$d(_.valueDeclaration.initializer)){var p=_.valueDeclaration.initializer.arguments[0],f=Ur(p,p);if(f){var m=Hr(f);m&&(_=m);}}}if(!(o=vr(Yr(_),l.escapedText,r)))return void(n||sr(l,e.Diagnostics.Namespace_0_has_no_exported_member_1,Jr(_),e.declarationNameToString(l)))}else e.Debug.assertNever(t,"Unknown entity name kind.");return e.Debug.assert(0==(1&e.getCheckFlags(o)),"Should never get an instantiated symbol here."),o.flags&r||i?o:Rr(o)}}function Ur(t,r){return qr(t,r,e.Diagnostics.Cannot_find_module_0)}function qr(t,r,n,i){return void 0===i&&(i=!1),e.isStringLiteralLike(r)?Vr(t,r.text,n,r,i):void 0}function Vr(t,r,n,a,o){if(void 0===o&&(o=!1),void 0!==r){e.startsWith(r,"@types/")&&sr(a,e.Diagnostics.Cannot_import_type_declaration_files_Consider_importing_0_instead_of_1,e.removePrefix(r,"@types/"),r);var s=Ha(r,!0);if(s)return s;var c=e.getResolvedModule(e.getSourceFileOfNode(t),r),u=c&&e.getResolutionDiagnostic(D,c),l=c&&!u&&i.getSourceFile(c.resolvedFileName);if(l)return l.symbol?(c.isExternalLibraryImport&&!e.extensionIsTypeScript(c.extension)&&Bt(Wr(a,c,r)),rn(l.symbol)):void(n&&sr(a,e.Diagnostics.File_0_is_not_a_module,l.fileName));if(Ee){var _=e.findBestPatternMatch(Ee,function(e){return e.pattern},r);if(_)return rn(_.symbol)}if(c&&!e.extensionIsTypeScript(c.extension)&&void 0===u||u===e.Diagnostics.Could_not_find_a_declaration_file_for_module_0_1_implicitly_has_an_any_type)o?sr(a,e.Diagnostics.Invalid_module_name_in_augmentation_Module_0_resolves_to_an_untyped_module_at_1_which_cannot_be_augmented,r,c.resolvedFileName):function(e,t){e?Lt.add(t):Bt(t);}(O&&!!n,Wr(a,c,r));else if(n)if(u)sr(a,u,r,c.resolvedFileName);else{var d=e.tryExtractTypeScriptExtension(r);d?sr(a,e.Diagnostics.An_import_path_cannot_end_with_a_0_extension_Consider_importing_1_instead,d,e.removeExtension(r,d)):sr(a,n,r);}}}function Wr(t,r,n){var i=r.packageId,a=r.resolvedFileName,o=i&&e.chainDiagnosticMessages(void 0,e.Diagnostics.Try_npm_install_types_Slash_0_if_it_exists_or_add_a_new_declaration_d_ts_file_containing_declare_module_0,e.getMangledNameForScopedPackage(i.name));return e.createDiagnosticForNodeFromMessageChain(t,e.chainDiagnosticMessages(o,e.Diagnostics.Could_not_find_a_declaration_file_for_module_0_1_implicitly_has_an_any_type,n,a))}function Hr(e,t){return e&&rn(Lr(e.exports.get("export="),t))||e}function Gr(t,r,n){var i=Hr(t,n);if(!n&&i){if(!(1539&i.flags))return sr(r,e.Diagnostics.Module_0_resolves_to_a_non_module_entity_and_cannot_be_imported_using_this_construct,Dn(t)),i;if(D.esModuleInterop){var a=r.parent;if(e.isImportDeclaration(a)&&e.getNamespaceDeclarationNode(a)||e.isImportCall(a)){var o=ui(i),s=Ba(o,0);if(s&&s.length||(s=Ba(o,1)),s&&s.length){var c=Gd(o,i,t),u=cr(i.flags,i.escapedName);u.declarations=i.declarations?i.declarations.slice():[],u.parent=i.parent,u.target=i,u.originatingImport=a,i.valueDeclaration&&(u.valueDeclaration=i.valueDeclaration),i.constEnumOnlyModule&&(u.constEnumOnlyModule=!0),i.members&&(u.members=e.cloneMap(i.members)),i.exports&&(u.exports=e.cloneMap(i.exports));var l=ya(c);return u.type=mn(u,l.members,e.emptyArray,e.emptyArray,l.stringIndexInfo,l.numberIndexInfo),u}}}}return i}function $r(e){return void 0!==e.exports.get("export=")}function Xr(e){return Va(Zr(e))}function Qr(e,t){var r=Zr(t);if(r)return r.get(e)}function Yr(e){return 32&e.flags?Hi(e,"resolvedExports"):1536&e.flags?Zr(e):e.exports||k}function Zr(e){var t=gr(e);return t.resolvedExports||(t.resolvedExports=tn(e))}function en(t,r,n,i){r&&r.forEach(function(r,a){if("default"!==a){var o=t.get(a);if(o){if(n&&i&&o&&Lr(o)!==Lr(r)){var s=n.get(a);s.exportsWithDuplicate?s.exportsWithDuplicate.push(i):s.exportsWithDuplicate=[i];}}else t.set(a,r),n&&i&&n.set(a,{specifierText:e.getTextOfNode(i.moduleSpecifier)});}});}function tn(t){var r=[];return function t(n){if(n&&1952&n.flags&&e.pushIfUnique(r,n)){var i=e.cloneMap(n.exports),a=n.exports.get("__export");if(a){for(var o=e.createSymbolTable(),s=e.createMap(),c=0,u=a.declarations;c<u.length;c++){var l=u[c],_=Ur(l,l.moduleSpecifier),d=t(_);en(o,d,s,l);}s.forEach(function(t,r){var n=t.exportsWithDuplicate;if("export="!==r&&n&&n.length&&!i.has(r))for(var a=0,o=n;a<o.length;a++){var c=o[a];Lt.add(e.createDiagnosticForNode(c,e.Diagnostics.Module_0_has_already_exported_a_member_named_1_Consider_explicitly_re_exporting_to_resolve_the_ambiguity,s.get(r).specifierText,e.unescapeLeadingUnderscores(r)));}}),en(i,o);}return i}}(t=Hr(t))||k}function rn(e){var t;return e&&e.mergeId&&(t=Tt[e.mergeId])?t:e}function nn(e){return rn(e.symbol&&$i(e.symbol))}function an(e){return rn(e.parent&&$i(e.parent))}function on$$1(e){return e&&0!=(1048576&e.flags)?rn(e.exportSymbol):e}function sn(e){return!!(67216319&e.flags||2097152&e.flags&&67216319&Rr(e).flags)}function cn(t){for(var r=0,n=t.members;r<n.length;r++){var i=n[r];if(154===i.kind&&e.nodeIsPresent(i.body))return i}}function un(e){var t=new y(J,e);return v++,t.id=v,t}function ln(e,t){var r=un(e);return r.intrinsicName=t,r}function _n(e,t){var r=un(65536);return r.objectFlags=e,r.symbol=t,r}function dn(e){return 95===e.charCodeAt(0)&&95===e.charCodeAt(1)&&95!==e.charCodeAt(2)&&64!==e.charCodeAt(2)}function pn(t){var r;return t.forEach(function(e,t){dn(t)||(r||(r=[]),sn(e)&&r.push(e));}),r||e.emptyArray}function fn(e,t,r,n,i,a){return e.members=t,e.properties=pn(t),e.callSignatures=r,e.constructSignatures=n,i&&(e.stringIndexInfo=i),a&&(e.numberIndexInfo=a),e}function mn(e,t,r,n,i,a){return fn(_n(16,e),t,r,n,i,a)}function gn(t,r){for(var n,i=t;i;i=i.parent){if(i.locals&&!hr(i)&&(n=r(i.locals)))return n;switch(i.kind){case 272:if(!e.isExternalOrCommonJsModule(i))break;case 237:if(n=r(nn(i).exports))return n}}return r(_t)}function yn(e){return 67216319===e?67216319:1920}function hn(t,r,n,i,a){if(void 0===a&&(a=e.createMap()),t&&!function(e){if(e.declarations&&e.declarations.length){for(var t=0,r=e.declarations;t<r.length;t++){var n=r[t];switch(n.kind){case 151:case 153:case 155:case 156:continue;default:return!1}}return!0}return!1}(t)){var o,s=""+u(t);return a.has(s)?o=a.get(s):a.set(s,o=[]),gn(r,c)}function c(a,s){if(e.pushIfUnique(o,a)){var u=function(a,o){return _(a.get(t.escapedName),void 0,o)?[t]:e.forEachEntry(a,function(t){if(2097152&t.flags&&"export="!==t.escapedName&&"default"!==t.escapedName&&!(e.isUMDExportSymbol(t)&&r&&e.isExternalModule(e.getSourceFileOfNode(r)))&&(!i||e.some(t.declarations,e.isExternalModuleImportEqualsDeclaration))){var a=Rr(t);if(_(t,a,o))return[t];var s=Yr(a),u=s&&c(s,!0);if(u&&l(t,yn(n)))return[t].concat(u)}})}(a,s);return o.pop(),u}}function l(e,t){return!vn(e,r,t)||!!hn(e.parent,r,yn(t),i,a)}function _(r,i,a){return t===(i||r)&&!e.some(r.declarations,Sn)&&(a||l(r,n))}}function vn(t,r,n){var i=!1;return gn(r,function(r){var a=r.get(t.escapedName);return!!a&&(a===t||!!((a=2097152&a.flags&&!e.getDeclarationOfKind(a,250)?Rr(a):a).flags&n)&&(i=!0,!0))}),i}function bn(e,t){return 0===xn(e,t,67216319,!1).accessibility}function xn(t,r,n,i){if(t&&r&&!(262144&t.flags)){for(var a=t,o=n;t;){var s=hn(t,r,o,!1);if(s){var c=kn(s[0],i);return c||{accessibility:1,errorSymbolName:Dn(a,r,n),errorModuleName:t!==a?Dn(t,r,1920):void 0}}o=yn(n),t=an(t);}var u=e.forEach(a.declarations,l);return u&&u!==l(r)?{accessibility:2,errorSymbolName:Dn(a,r,n),errorModuleName:Dn(u)}:{accessibility:1,errorSymbolName:Dn(a,r,n)}}return{accessibility:0};function l(t){var r=e.findAncestor(t,Sn);return r&&nn(r)}}function Sn(t){return e.isAmbientModule(t)||272===t.kind&&e.isExternalOrCommonJsModule(t)}function kn(t,r){var n;if(!e.forEach(t.declarations,function(t){return!function(t){if(!In(t)){var i=Nr(t);return!(!i||e.hasModifier(i,1)||!In(i.parent)||(r&&(yr(t).isVisible=!0,n=e.appendIfUnique(n,i)),0))}return!0}(t)}))return{accessibility:0,aliasesToMakeVisible:n}}function Tn(t,r){var n;n=164===t.parent.kind||e.isExpressionWithTypeArgumentsInClassExtendsClause(t.parent)||146===t.parent.kind?68264895:145===t.kind||183===t.kind||241===t.parent.kind?1920:67901928;var i=pm(t),a=xr(r,i.escapedText,n,void 0,void 0,!1);return a&&kn(a,!0)||{accessibility:1,errorSymbolName:e.getTextOfNode(i),errorNode:i}}function Dn(t,r,n,i,a){void 0===i&&(i=4);var o=3112960;2&i&&(o|=128),1&i&&(o|=512),8&i&&(o|=16384);var s=4&i?L.symbolToExpression:L.symbolToEntityName;return a?c(a).getText():e.usingSingleLineStringWriter(c);function c(i){var a=s(t,n,r,o),c=e.createPrinter({removeComments:!0}),u=r&&e.getSourceFileOfNode(r);return c.writeNode(4,a,u,i),i}}function Cn(t,r,n,i,a){return a?o(a).getText():e.usingSingleLineStringWriter(o);function o(a){var o;o=262144&n?1===i?163:162:1===i?158:157;var s=L.signatureToSignatureDeclaration(t,o,r,3113472|Nn(n)),c=e.createPrinter({removeComments:!0,omitTrailingSemicolon:!0}),u=r&&e.getSourceFileOfNode(r);return c.writeNode(4,s,u,a),a}}function En(t,r,n,i){void 0===n&&(n=1048576),void 0===i&&(i=e.createTextWriter(""));var a=L.typeToTypeNode(t,r,3112960|Nn(n),i);e.Debug.assert(void 0!==a,"should always get typenode");var o=e.createPrinter({removeComments:!0}),s=r&&e.getSourceFileOfNode(r);o.writeNode(4,a,s,i);var c=i.getText(),u=D.noErrorTruncation||1&n?void 0:100;return u&&c&&c.length>=u?c.substr(0,u-"...".length)+"...":c}function Nn(e){return 9469291&e}function An(t,r,n,i){return i?a(i).getText():e.usingSingleLineStringWriter(a);function a(i){var a=e.createTypePredicateNode(1===t.kind?e.createIdentifier(t.parameterName):e.createThisTypeNode(),L.typeToTypeNode(t.type,r,3113472|Nn(n))),o=e.createPrinter({removeComments:!0}),s=r&&e.getSourceFileOfNode(r);return o.writeNode(4,a,s,i),i}}function Pn(e){return 8===e?"private":16===e?"protected":"public"}function wn(t){return t&&t.parent&&238===t.parent.kind&&e.isExternalModuleAugmentation(t.parent.parent)}function Fn(t){return 272===t.kind||e.isAmbientModule(t)}function On(t,r){if(r&&"default"===t.escapedName&&!(16384&r.flags)&&(!(16777216&r.flags)||!t.declarations||r.enclosingDeclaration&&e.findAncestor(t.declarations[0],Fn)!==e.findAncestor(r.enclosingDeclaration,Fn)))return"default";if(t.declarations&&t.declarations.length){var n=t.declarations[0],i=e.getNameOfDeclaration(n);if(i)return e.declarationNameToString(i);if(n.parent&&230===n.parent.kind)return e.declarationNameToString(n.parent.name);switch(!r||r.encounteredError||131072&r.flags||(r.encounteredError=!0),n.kind){case 203:return"(Anonymous class)";case 190:case 191:return"(Anonymous function)"}}if(t.nameType&&32&t.nameType.flags){var a=t.nameType.value;if(!e.isIdentifierText(a,D.target))return'"'+e.escapeString(a,34)+'"'}return e.symbolName(t)}function In(t){if(t){var r=yr(t);return void 0===r.isVisible&&(r.isVisible=!!function(){switch(t.kind){case 180:return In(t.parent.parent);case 230:if(e.isBindingPattern(t.name)&&!t.name.elements.length)return!1;case 237:case 233:case 234:case 235:case 232:case 236:case 241:if(e.isExternalModuleAugmentation(t))return!0;var r=jn(t);return 1&e.getCombinedModifierFlags(t)||241!==t.kind&&272!==r.kind&&2097152&r.flags?In(r):hr(r);case 151:case 150:case 155:case 156:case 153:case 152:if(e.hasModifier(t,24))return!1;case 154:case 158:case 157:case 159:case 148:case 238:case 162:case 163:case 165:case 161:case 166:case 167:case 168:case 169:case 172:return In(t.parent);case 243:case 244:case 246:return!1;case 147:case 272:case 240:return!0;case 247:default:return!1}}()),r.isVisible}return!1}function Mn(t,r){var n,i;return t.parent&&247===t.parent.kind?n=xr(t,t.escapedText,70107135,void 0,t,!1):250===t.parent.kind&&(n=Or(t.parent,70107135)),n&&function t(n){e.forEach(n,function(n){var a=Nr(n)||n;if(r?yr(n).isVisible=!0:(i=i||[],e.pushIfUnique(i,a)),e.isInternalModuleImportEqualsDeclaration(n)){var o=n.moduleReference,s=pm(o),c=xr(n,s.escapedText,68009983,void 0,void 0,!1);c&&t(c.declarations);}});}(n.declarations),i}function Ln(e,t){var r=Rn(e,t);if(r>=0){for(var n=vt.length,i=r;i<n;i++)bt[i]=!1;return!1}return vt.push(e),bt.push(!0),xt.push(t),!0}function Rn(e,t){for(var r=vt.length-1;r>=0;r--){if(Bn(vt[r],xt[r]))return-1;if(vt[r]===e&&xt[r]===t)return r}return-1}function Bn(t,r){if(0===r)return gr(t).type;if(2===r)return gr(t).declaredType;if(1===r)return t.resolvedBaseConstructorType;if(3===r)return t.resolvedReturnType;if(4===r){var n=t.resolvedBaseConstraint;return n&&n!==Se}e.Debug.fail("Unhandled TypeSystemPropertyName "+r);}function Kn(){return vt.pop(),xt.pop(),bt.pop()}function jn(t){return(t=e.findAncestor(e.getRootDeclaration(t),function(e){switch(e.kind){case 230:case 231:case 246:case 245:case 244:case 243:return!1;default:return!0}}))&&t.parent}function Jn(e,t){var r=Ra(e,t);return r?ui(r):void 0}function zn(e){return e&&0!=(1&e.flags)}function Un(e){var t=nn(e);return t&&gr(t).type||Xn(e,!1)}function qn(t){return 146===t.kind&&!e.isStringOrNumericLiteral(t.expression)}function Vn(t,r,n){if(16384&(t=pl(t,function(e){return!(12288&e.flags)})).flags)return ge;if(131072&t.flags)return fl(t,function(e){return Vn(e,r,n)});for(var i=e.createSymbolTable(),a=e.createUnderscoreEscapedMap(),o=0,s=r;o<s.length;o++){var c=s[o];a.set(e.getTextOfPropertyName(c),!0);}for(var u=0,l=xa(t);u<l.length;u++){var _=l[u],d=a.has(_.escapedName),p=24&e.getDeclarationModifierFlagsFromSymbol(_),f=65536&_.flags&&!(32768&_.flags);d||p||js(_)||f||i.set(_.escapedName,_);}var m=za(t,0),g=za(t,1);return mn(n,i,e.emptyArray,e.emptyArray,m,g)}function Wn(t){var r,n=t.parent,i=Un(n.parent);if(i===ee)return ee;if(!i)return t.initializer?wp(t):i;if(zn(i))return i;if(178===n.kind)if(t.dotDotDotToken){if(!T_(i))return sr(t,e.Diagnostics.Rest_types_may_only_be_created_from_object_types),ee;for(var a=[],o=0,s=n.elements;o<s.length;o++){var c=s[o];c.dotDotDotToken||a.push(c.propertyName||c.name);}r=Vn(i,a,t.symbol);}else{var u=t.propertyName||t.name;if(qn(u))return Q;var l=e.getTextOfPropertyName(u);P&&2097152&t.flags&&e.isParameterDeclaration(t)&&(i=du(i));var _=Jn(i,l),d=_&&Ml(_,t.name);if(!(r=d&&Nl(t,d)||b_(l)&&Ua(i,1)||Ua(i,0)))return sr(u,e.Diagnostics.Type_0_has_no_property_1_and_no_string_index_signature,En(i),e.declarationNameToString(u)),ee}else{var p=Uf(i,n,!1,!1);if(t.dotDotDotToken)r=rs(p);else{var f=""+n.elements.indexOf(t);if(!(r=Yc(i)?Jn(i,f):p))return au(i)?sr(t,e.Diagnostics.Tuple_type_0_with_length_1_cannot_be_assigned_to_tuple_with_length_2,En(i),To(i),n.elements.length):sr(t,e.Diagnostics.Type_0_has_no_property_1,En(i),f),ee}}return!P||!t.initializer||4096&su(Ap(t.initializer))||(r=Qu(r,131072)),t.initializer?ds([r,Ap(t.initializer)],2):r}function Hn(t){var r=e.getJSDocType(t);if(r)return Hs(r)}function Gn(t){var r=e.skipParentheses(t);return 181===r.kind&&0===r.elements.length}function $n(e,t){return void 0===t&&(t=!0),P&&t?_u(e):e}function Xn(t,r){if(e.isVariableDeclaration(t)&&219===t.parent.parent.kind){var n=vs($_(t.parent.parent.expression));return 557056&n.flags?n:ae}if(e.isVariableDeclaration(t)&&220===t.parent.parent.kind){var i=t.parent.parent;return zf(i.expression,i.awaitModifier)||Q}if(e.isBindingPattern(t.parent))return Wn(t);var a,o,s=!e.isBindingElement(t)&&!e.isVariableDeclaration(t)&&!!t.questionToken&&r,c=ti(t);if(c)return $n(c,s);if((O||e.isInJavaScriptFile(t))&&230===t.kind&&!e.isBindingPattern(t.name)&&!(1&e.getCombinedModifierFlags(t))&&!(2097152&t.flags)){if(!(2&e.getCombinedNodeFlags(t)||t.initializer&&(a=t.initializer,o=e.skipParentheses(a),95!==o.kind&&(71!==o.kind||Ju(o)!==R))))return Y;if(t.initializer&&Gn(t.initializer))return Be}if(148===t.kind){var u=t.parent;if(156===u.kind&&!qi(u)){var l=e.getDeclarationOfKind(nn(t.parent),155);if(l){var _=Za(l),d=Eg(u);return d&&t===d?(e.Debug.assert(!d.type),ui(_.thisParameter)):io(_)}}var p=void 0;if(p="this"===t.symbol.escapedName?Gl(u):$l(t))return $n(p,s)}return t.initializer?$n(p=wp(t),s):e.isJsxAttribute(t)?se:e.isBindingPattern(t.name)?Yn(t.name,!1,!0):void 0}function Qn(t,r,n){return t.initializer?wp(t):e.isBindingPattern(t.name)?Yn(t.name,r,n):(n&&O&&!ei(t)&&Su(t,Q),Q)}function Yn(t,r,n){return 178===t.kind?function(t,r,n){var i,a=e.createSymbolTable(),o=!1;e.forEach(t.elements,function(t){var s=t.propertyName||t.name;if(qn(s))o=!0;else if(t.dotDotDotToken)i=go(Q,!1);else{var c=e.getTextOfPropertyName(s),u=cr(4|(t.initializer?16777216:0),c);u.type=Qn(t,r,n),u.bindingElement=t,a.set(u.escapedName,u);}});var s=mn(void 0,a,e.emptyArray,e.emptyArray,i,void 0);return r&&(s.pattern=t),o&&(s.objectFlags|=512),s}(t,r,n):function(t,r,n){var i=t.elements,a=e.lastOrUndefined(i);if(0===i.length||!e.isOmittedExpression(a)&&a.dotDotDotToken)return C>=2?es(Q):Re;var o=is(e.map(i,function(t){return e.isOmittedExpression(t)?Q:Qn(t,r,n)}));return r&&((o=ko(o)).pattern=t),o}(t,r,n)}function Zn(t,r){var n=Xn(t,!0);return n?(r&&ku(t,n),1024&n.flags&&(e.isBindingElement(t)||!t.type)&&n.symbol!==nn(t)&&(n=le),bu(n)):(n=e.isParameter(t)&&t.dotDotDotToken?Re:Q,r&&O&&(ei(t)||Su(t,n)),n)}function ei(t){var r=e.getRootDeclaration(t);return ef(148===r.kind?r.parent:r)}function ti(t){var r=e.getEffectiveTypeAnnotationNode(t);if(r)return Hs(r)}function ri(t){var r,n=gr(t);if(!n.type){if(4194304&t.flags)return n.type=(r=Fi(an(t))).typeParameters?So(r,e.map(r.typeParameters,function(e){return Q})):r;var i=t.valueDeclaration;if(e.isCatchClauseVariableDeclarationOrBindingElement(i))return n.type=Q;if(247===i.kind)return n.type=Rp(i.expression);if(e.isInJavaScriptFile(i)&&e.isJSDocPropertyLikeTag(i)&&i.typeExpression)return n.type=Hs(i.typeExpression.type);if(!Ln(t,0))return ee;var a=void 0;if(198===i.kind||183===i.kind&&198===i.parent.kind)a=function(t){var r=e.getAssignedJavascriptInitializer(t.valueDeclaration);if(r)return ru(Ap(r));for(var n,i=[],a=!1,o=!1,s=0,c=t.declarations;s<c.length;s++){var u=c[s],l=198===u.kind?u:183===u.kind?e.getAncestor(u,198):void 0;if(!l)return ee;e.isPropertyAccessExpression(l.left)&&99===l.left.expression.kind&&(154===e.getThisContainer(l,!1).kind?a=!0:o=!0);var _=Hn(l.parent);if(_){var d=bu(_);n?n===ee||d===ee||gc(n,d)||67108864&t.flags||Lf(n,u,d):n=d;}else n||i.push(ru(Ap(l.right)));}return bu($n(n||ds(i,2),o&&!a))}(t);else if(e.isJSDocPropertyTag(i)||e.isPropertyAccessExpression(i)||e.isIdentifier(i)||e.isMethodDeclaration(i)&&!e.isObjectLiteralMethod(i)||e.isMethodSignature(i)){if(9136&t.flags)return si(t);a=ti(i)||Q;}else e.isPropertyAssignment(i)?a=ti(i)||Op(i):e.isJsxAttribute(i)?a=ti(i)||E_(i):e.isShorthandPropertyAssignment(i)?a=ti(i)||Fp(i.name,0):e.isObjectLiteralMethod(i)?a=ti(i)||Ip(i,0):e.isParameter(i)||e.isPropertyDeclaration(i)||e.isPropertySignature(i)||e.isVariableDeclaration(i)||e.isBindingElement(i)?a=Zn(i,!0):e.Debug.fail("Unhandled declaration kind! "+e.Debug.showSyntaxKind(i));Kn()||(a=ci(t)),n.type=a;}return n.type}function ni(t){if(t){if(155===t.kind){var r=e.getEffectiveReturnTypeNode(t);return r&&Hs(r)}var n=e.getEffectiveSetAccessorTypeAnnotationNode(t);return n&&Hs(n)}}function ii(e){return to(Za(e))}function ai(t){var r=gr(t);if(!r.type){var n=e.getDeclarationOfKind(t,155),i=e.getDeclarationOfKind(t,156);if(n&&e.isInJavaScriptFile(n)){var a=Hn(n);if(a)return r.type=a}if(!Ln(t,0))return ee;var o=void 0,s=ni(n);if(s)o=s;else{var c=ni(i);c?o=c:n&&n.body?o=ip(n):(O&&(i?sr(i,e.Diagnostics.Property_0_implicitly_has_type_any_because_its_set_accessor_lacks_a_parameter_type_annotation,Dn(t)):(e.Debug.assert(!!n,"there must existed getter as we are current checking either setter or getter in this function"),sr(n,e.Diagnostics.Property_0_implicitly_has_type_any_because_its_get_accessor_lacks_a_return_type_annotation,Dn(t)))),o=Q);}Kn()||(o=Q,O&&sr(e.getDeclarationOfKind(t,155),e.Diagnostics._0_implicitly_has_return_type_any_because_it_does_not_have_a_return_type_annotation_and_is_referenced_directly_or_indirectly_in_one_of_its_return_expressions,Dn(t))),r.type=o;}return r.type}function oi(e){var t=Si(Di(e));return 1081344&t.flags?t:void 0}function si(t){var r=gr(t);if(!r.type)if(1536&t.flags&&e.isShorthandAmbientModuleSymbol(t))r.type=Q;else{var n=_n(16,t);if(32&t.flags){var i=oi(t);r.type=i?ys([n,i]):n;}else r.type=P&&16777216&t.flags?_u(n):n;}return r.type}function ci(t){return e.getEffectiveTypeAnnotationNode(t.valueDeclaration)?(sr(t.valueDeclaration,e.Diagnostics._0_is_referenced_directly_or_indirectly_in_its_own_type_annotation,Dn(t)),ee):(O&&sr(t.valueDeclaration,e.Diagnostics._0_implicitly_has_type_any_because_it_does_not_have_a_type_annotation_and_is_referenced_directly_or_indirectly_in_its_own_initializer,Dn(t)),Q)}function ui(t){return 1&e.getCheckFlags(t)?function(t){var r=gr(t);if(!r.type)if(100===S)sr(t.valueDeclaration,e.Diagnostics.Generic_type_instantiation_is_excessively_deep_and_possibly_infinite),r.type=ee;else{if(!Ln(t,0))return ee;S++;var n=uc(ui(r.target),r.mapper);S--,Kn()||(n=ci(t)),r.type=n;}return r.type}(t):2048&e.getCheckFlags(t)?function(e){return wu(e.propertyType,e.mappedType)}(t):7&t.flags?ri(t):9136&t.flags?si(t):8&t.flags?function(e){var t=gr(e);return t.type||(t.type=Pi(e)),t.type}(t):98304&t.flags?ai(t):2097152&t.flags?function(e){var t=gr(e);if(!t.type){var r=Rr(e);t.type=67216319&r.flags?ui(r):ee;}return t.type}(t):ee}function li(t,r){return void 0!==t&&void 0!==r&&0!=(4&e.getObjectFlags(t))&&t.target===r}function _i(t){return 4&e.getObjectFlags(t)?t.target:t}function di(t,r){return function t(n){if(7&e.getObjectFlags(n)){var i=_i(n);return i===r||e.forEach(ki(i),t)}if(262144&n.flags)return e.forEach(n.types,t)}(t)}function pi(t,r){for(var n=0,i=r;n<i.length;n++){var a=wi(nn(i[n]));t=e.appendIfUnique(t,a);}return t}function fi(t,r){for(;;){if(!(t=t.parent))return;switch(t.kind){case 233:case 203:case 234:case 157:case 158:case 152:case 162:case 163:case 280:case 232:case 153:case 190:case 191:case 235:case 290:case 176:case 170:var n=fi(t,r);if(176===t.kind)return e.append(n,wi(nn(t.typeParameter)));if(170===t.kind)return e.concatenate(n,Os(t));var i=pi(n,e.getEffectiveTypeParameterDeclarations(t)||e.emptyArray),a=r&&(233===t.kind||203===t.kind||234===t.kind)&&Di(nn(t)).thisType;return a?e.append(i,a):i}}}function mi(t){return fi(32&t.flags?t.valueDeclaration:e.getDeclarationOfKind(t,234))}function gi(e){for(var t,r=0,n=e.declarations;r<n.length;r++){var i=n[r];if(234===i.kind||233===i.kind||203===i.kind||235===i.kind){var a=i;a.typeParameters&&(t=pi(t,a.typeParameters));}}return t}function yi(e){var t=Ka(e,1);if(1===t.length){var r=t[0];return!r.typeParameters&&1===r.parameters.length&&r.hasRestParameter&&Yd(r.parameters[0])===Re}return!1}function hi(e){if(Ti(e)&&Ka(e,1).length>0)return!0;if(1081344&e.flags){var t=Ea(e);return t&&Ti(t)&&yi(t)}return!1}function vi(t){var r=t.symbol.valueDeclaration;if(e.isInJavaScriptFile(r)){var n=e.getJSDocAugmentsTag(r);if(n)return n.class}return e.getClassExtendsHeritageClauseElement(r)}function bi(t,r,n){var i=e.length(r),a=e.isInJavaScriptFile(n);return e.filter(Ka(t,1),function(t){return(a||i>=Qa(t.typeParameters))&&i<=e.length(t.typeParameters)})}function xi(t,r,n){var i=bi(t,r,n),a=e.map(r,Hs);return e.sameMap(i,function(t){return e.some(t.typeParameters)?oo(t,a,e.isInJavaScriptFile(n)):t})}function Si(t){if(!t.resolvedBaseConstructorType){var r=t.symbol.valueDeclaration,n=e.getClassExtendsHeritageClauseElement(r),i=vi(t);if(!i)return t.resolvedBaseConstructorType=te;if(!Ln(t,1))return ee;var a=Rp(i.expression);if(n&&i!==n&&(e.Debug.assert(!n.typeArguments),Rp(n.expression)),327680&a.flags&&ya(a),!Kn())return sr(t.symbol.valueDeclaration,e.Diagnostics._0_is_referenced_directly_or_indirectly_in_its_own_base_expression,Dn(t.symbol)),t.resolvedBaseConstructorType=ee;if(!(1&a.flags||a===ie||hi(a)))return sr(i.expression,e.Diagnostics.Type_0_is_not_a_constructor_function_type,En(a)),t.resolvedBaseConstructorType=ee;t.resolvedBaseConstructorType=a;}return t.resolvedBaseConstructorType}function ki(t){return t.resolvedBaseTypes||(8&t.objectFlags?t.resolvedBaseTypes=[rs(ds(t.typeParameters))]:96&t.symbol.flags?(32&t.symbol.flags&&function(t){t.resolvedBaseTypes=e.resolvingEmptyArray;var r=Oa(Si(t));if(!(327681&r.flags))return t.resolvedBaseTypes=e.emptyArray;var n,i=vi(t),a=Io(i),o=r&&r.symbol?Fi(r.symbol):void 0;if(r.symbol&&32&r.symbol.flags&&function(e){var t=e.outerTypeParameters;if(t){var r=t.length-1,n=e.typeArguments;return t[r].symbol!==n[r].symbol}return!0}(o))n=Do(i,r.symbol,a);else if(1&r.flags)n=r;else{var s=xi(r,i.typeArguments,i);if(!s.length)return sr(i.expression,e.Diagnostics.No_base_constructor_has_the_specified_number_of_type_arguments),t.resolvedBaseTypes=e.emptyArray;n=io(s[0]);}n===ee?t.resolvedBaseTypes=e.emptyArray:Ti(n)?t===n||di(n,t)?(sr(t.symbol.valueDeclaration,e.Diagnostics.Type_0_recursively_references_itself_as_a_base_type,En(t,void 0,2)),t.resolvedBaseTypes=e.emptyArray):(t.resolvedBaseTypes===e.resolvingEmptyArray&&(t.members=void 0),t.resolvedBaseTypes=[n]):(sr(i.expression,e.Diagnostics.Base_constructor_return_type_0_is_not_a_class_or_interface_type,En(n)),t.resolvedBaseTypes=e.emptyArray);}(t),64&t.symbol.flags&&function(t){t.resolvedBaseTypes=t.resolvedBaseTypes||e.emptyArray;for(var r=0,n=t.symbol.declarations;r<n.length;r++){var i=n[r];if(234===i.kind&&e.getInterfaceBaseTypeNodes(i))for(var a=0,o=e.getInterfaceBaseTypeNodes(i);a<o.length;a++){var s=o[a],c=Hs(s);c!==ee&&(Ti(c)?t===c||di(c,t)?sr(i,e.Diagnostics.Type_0_recursively_references_itself_as_a_base_type,En(t,void 0,2)):t.resolvedBaseTypes===e.emptyArray?t.resolvedBaseTypes=[c]:t.resolvedBaseTypes.push(c):sr(s,e.Diagnostics.An_interface_may_only_extend_a_class_or_another_interface));}}}(t)):e.Debug.fail("type must be class or interface")),t.resolvedBaseTypes}function Ti(t){return 134283265&t.flags&&!ga(t)||262144&t.flags&&!e.forEach(t.types,function(e){return!Ti(e)})}function Di(t){var r=gr(t);if(!r.declaredType){var n=32&t.flags?1:2,i=r.declaredType=_n(n,t),a=mi(t),o=gi(t);(a||o||1===n||!function(t){for(var r=0,n=t.declarations;r<n.length;r++){var i=n[r];if(234===i.kind){if(64&i.flags)return!1;var a=e.getInterfaceBaseTypeNodes(i);if(a)for(var o=0,s=a;o<s.length;o++){var c=s[o];if(e.isEntityNameExpression(c.expression)){var u=zr(c.expression,67901928,!0);if(!u||!(64&u.flags)||Di(u).thisType)return!1}}}}return!0}(t))&&(i.objectFlags|=4,i.typeParameters=e.concatenate(a,o),i.outerTypeParameters=a,i.localTypeParameters=o,i.instantiations=e.createMap(),i.instantiations.set(bo(i.typeParameters),i),i.target=i,i.typeArguments=i.typeParameters,i.thisType=un(32768),i.thisType.isThisType=!0,i.thisType.symbol=t,i.thisType.constraint=i);}return r.declaredType}function Ci(t){var r=t.initializer;if(!r)return!(2097152&t.flags);switch(r.kind){case 9:case 8:return!0;case 196:return 38===r.operator&&8===r.operand.kind;case 71:return e.nodeIsMissing(r)||!!nn(t.parent).exports.get(r.escapedText);default:return!1}}function Ei(e){var t=gr(e);if(void 0!==t.enumKind)return t.enumKind;for(var r=!1,n=0,i=e.declarations;n<i.length;n++){var a=i[n];if(236===a.kind)for(var o=0,s=a.members;o<s.length;o++){var c=s[o];if(c.initializer&&9===c.initializer.kind)return t.enumKind=1;Ci(c)||(r=!0);}}return t.enumKind=r?0:1}function Ni(e){return 256&e.flags&&!(131072&e.flags)?Fi(an(e.symbol)):e}function Ai(e){var t=gr(e);if(t.declaredType)return t.declaredType;if(1===Ei(e)){x++;for(var r=[],n=0,i=e.declarations;n<i.length;n++){var a=i[n];if(236===a.kind)for(var o=0,s=a.members;o<s.length;o++){var c=s[o],u=qs(Zm(c),x,nn(c));gr(nn(c)).declaredType=u,r.push(u);}}if(r.length){var l=ds(r,1,e,void 0);return 131072&l.flags&&(l.flags|=256,l.symbol=e),t.declaredType=l}}var _=un(16);return _.symbol=e,t.declaredType=_}function Pi(e){var t=gr(e);if(!t.declaredType){var r=Ai(an(e));t.declaredType||(t.declaredType=r);}return t.declaredType}function wi(e){var t=gr(e);if(!t.declaredType){var r=un(32768);r.symbol=e,t.declaredType=r;}return t.declaredType}function Fi(e){return Oi(e)||ee}function Oi(t){return 96&t.flags?Di(t):524288&t.flags?function(t){var r=gr(t);if(!r.declaredType){if(!Ln(t,2))return ee;var n=e.find(t.declarations,function(e){return 291===e.kind||235===e.kind}),i=291===n.kind?n.typeExpression:n.type,a=i?Hs(i):ee;if(Kn()){var o=gi(t);o&&(r.typeParameters=o,r.instantiations=e.createMap(),r.instantiations.set(bo(o),a));}else a=ee,sr(n.name,e.Diagnostics.Type_alias_0_circularly_references_itself,Dn(t));r.declaredType=a;}return r.declaredType}(t):262144&t.flags?wi(t):384&t.flags?Ai(t):8&t.flags?Pi(t):2097152&t.flags?function(e){var t=gr(e);return t.declaredType||(t.declaredType=Fi(Rr(e))),t.declaredType}(t):void 0}function Ii(e){switch(e.kind){case 119:case 137:case 134:case 122:case 138:case 135:case 105:case 140:case 95:case 131:case 177:return!0;case 166:return Ii(e.elementType);case 161:return!e.typeArguments||e.typeArguments.every(Ii)}return!1}function Mi(e){return!e.constraint||Ii(e.constraint)}function Li(t){var r=e.getEffectiveTypeAnnotationNode(t);return r?Ii(r):!e.hasInitializer(t)}function Ri(t){if(t.declarations&&1===t.declarations.length){var r=t.declarations[0];if(r)switch(r.kind){case 151:case 150:return Li(r);case 153:case 152:case 154:return n=r,i=e.getEffectiveReturnTypeNode(n),(154===n.kind||i&&Ii(i))&&n.parameters.every(Li)&&(!n.typeParameters||n.typeParameters.every(Mi))}}var n,i;return!1}function Bi(t,r,n){for(var i=e.createSymbolTable(),a=0,o=t;a<o.length;a++){var s=o[a];i.set(s.escapedName,n&&Ri(s)?s:ic(s,r));}return i}function Ki(e,t){for(var r=0,n=t;r<n.length;r++){var i=n[r];e.has(i.escapedName)||e.set(i.escapedName,i);}}function ji(e){if(!e.declaredProperties){var t=e.symbol,r=Gi(t);e.declaredProperties=pn(r),e.declaredCallSignatures=eo(r.get("__call")),e.declaredConstructSignatures=eo(r.get("__new")),e.declaredStringIndexInfo=yo(t,0),e.declaredNumberIndexInfo=yo(t,1);}return e}function Ji(e){return!!(1120&e.flags)}function zi(t){return e.isComputedPropertyName(t)&&e.isEntityNameExpression(t.expression)&&Ji(x_(t))}function Ui(t){var r=e.getNameOfDeclaration(t);return r&&zi(r)}function qi(t){return e.hasDynamicName(t)&&!Ui(t)}function Vi(t){return 1024&t.flags?"__@"+t.symbol.escapedName+"@"+u(t.symbol):96&t.flags?e.escapeLeadingUnderscores(""+t.value):void 0}function Wi(t,r,n,i){e.Debug.assert(!!i.symbol,"The member is expected to have a symbol.");var a=yr(i);if(!a.resolvedSymbol){a.resolvedSymbol=i.symbol;var o=x_(i.name);if(Ji(o)){var s=Vi(o),c=i.symbol.flags,u=n.get(s);u||n.set(s,u=cr(0,s,1024));var l=r&&r.get(s);if(u.flags&lr(c)||l){var _=l?e.concatenate(l.declarations,u.declarations):u.declarations,d=e.declarationNameToString(i.name);e.forEach(_,function(t){return sr(e.getNameOfDeclaration(t)||t,e.Diagnostics.Duplicate_declaration_0,d)}),sr(i.name||i,e.Diagnostics.Duplicate_declaration_0,d),u=cr(0,s,1024);}var p=gr(u);return p.nameType||(p.nameType=o),function(t,r,n){if(e.Debug.assert(!!(1024&e.getCheckFlags(t)),"Expected a late-bound symbol."),t.flags|=n,gr(r.symbol).lateSymbol=t,t.declarations?t.declarations.push(r):t.declarations=[r],67216319&n){var i=t.valueDeclaration;i&&i.kind===r.kind||(t.valueDeclaration=r);}}(u,i,c),u.parent?e.Debug.assert(u.parent===t,"Existing symbol parent should match new one"):u.parent=t,a.resolvedSymbol=u}}return a.resolvedSymbol}function Hi(t,r){var n=gr(t);if(!n[r]){var i="resolvedExports"===r,a=i?1536&t.flags?tn(t):t.exports:t.members;n[r]=a||k;for(var o=e.createSymbolTable(),s=0,c=t.declarations;s<c.length;s++){var u=c[s],l=e.getMembersOfDeclaration(u);if(l)for(var _=0,d=l;_<d.length;_++){var p=d[_];i===e.hasStaticModifier(p)&&Ui(p)&&Wi(t,a,o,p);}}n[r]=function(t,r){if(!t||0===t.size)return r;if(!r||0===r.size)return t;var n=e.createSymbolTable();return fr(n,t),fr(n,r),n}(a,o)||k;}return n[r]}function Gi(e){return 6240&e.flags?Hi(e,"resolvedMembers"):e.members||k}function $i(t){if(106500&t.flags&&"__computed"===t.escapedName){var r=gr(t);return!r.lateSymbol&&e.some(t.declarations,Ui)&&(e.some(t.declarations,e.hasStaticModifier)?Yr(t.parent):Gi(t.parent)),r.lateSymbol||(r.lateSymbol=t)}return t}function Xi(t,r,n){if(4&e.getObjectFlags(t)){var i=t.target,a=t.typeArguments;if(e.length(i.typeParameters)===e.length(a)){var o=So(i,e.concatenate(a,[r||i.thisType]));return n?Oa(o):o}}else if(262144&t.flags)return ys(e.map(t.types,function(e){return Xi(e,r,n)}));return n?Oa(t):t}function Qi(t,r,n,i){var a,o,s,c,u,l;e.rangeEquals(n,i,0,n.length)?(a=T,o=r.symbol?Gi(r.symbol):e.createSymbolTable(r.declaredProperties),s=r.declaredCallSignatures,c=r.declaredConstructSignatures,u=r.declaredStringIndexInfo,l=r.declaredNumberIndexInfo):(a=Qs(n,i),o=Bi(r.declaredProperties,a,1===n.length),s=Xs(r.declaredCallSignatures,a),c=Xs(r.declaredConstructSignatures,a),u=_c(r.declaredStringIndexInfo,a),l=_c(r.declaredNumberIndexInfo,a));var _=ki(r);if(_.length){r.symbol&&o===Gi(r.symbol)&&(o=e.createSymbolTable(r.declaredProperties)),fn(t,o,s,c,u,l);for(var d=e.lastOrUndefined(i),p=0,f=_;p<f.length;p++){var m=f[p],g=d?Xi(uc(m,a),d):m;Ki(o,xa(g)),s=e.concatenate(s,Ka(g,0)),c=e.concatenate(c,Ka(g,1)),u||(u=g===Q?go(Q,!1):za(g,0)),l=l||za(g,1);}}fn(t,o,s,c,u,l);}function Yi(e,t,r,n,i,a,o,s,c){var u=new h(J);return u.declaration=e,u.typeParameters=t,u.parameters=n,u.thisParameter=r,u.resolvedReturnType=i,u.resolvedTypePredicate=a,u.minArgumentCount=o,u.hasRestParameter=s,u.hasLiteralTypes=c,u.target=void 0,u.mapper=void 0,u}function Zi(e){return Yi(e.declaration,e.typeParameters,e.thisParameter,e.parameters,void 0,void 0,e.minArgumentCount,e.hasRestParameter,e.hasLiteralTypes)}function ea(e,t,r,n,i){for(var a=0,o=e;a<o.length;a++){var s=o[a];if(Wc(s,t,r,n,i,yc))return s}}function ta(t,r,n){if(r.typeParameters){if(n>0)return;for(var i=1;i<t.length;i++)if(!ea(t[i],r,!1,!1,!1))return;return[r]}var a;for(i=0;i<t.length;i++){var o=i===n?r:ea(t[i],r,!0,!0,!0);if(!o)return;a=e.appendIfUnique(a,o);}return a}function ra(t,r){for(var n,i=e.map(t,function(e){return Ka(e,r)}),a=0;a<i.length;a++)for(var o=0,s=i[a];o<s.length;o++){var c=s[o];if(!n||!ea(n,c,!1,!0,!0)){var u=ta(i,c,a);if(u){var l=c;if(u.length>1){var _=c.thisParameter;if(e.forEach(u,function(e){return e.thisParameter})){var d=ds(e.map(u,function(e){return e.thisParameter?ui(e.thisParameter):Q}),2);_=fu(c.thisParameter,d);}(l=Zi(c)).thisParameter=_,l.unionSignatures=u;}(n||(n=[])).push(l);}}}return n||e.emptyArray}function na(e,t){for(var r=[],n=!1,i=0,a=e;i<a.length;i++){var o=za(a[i],t);if(!o)return;r.push(o.type),n=n||o.isReadonly;}return go(ds(r,2),n)}function ia(e,t){return e?t?ys([e,t]):e:t}function aa(e,t){return e?t?go(ys([e.type,t.type]),e.isReadonly&&t.isReadonly):e:t}function oa(e,t){return e&&t&&go(ds([e.type,t.type]),e.isReadonly||t.isReadonly)}function sa(t){for(var r,n,i=e.emptyArray,a=e.emptyArray,o=t.types,s=e.countWhere(o,yi),c=function(c){var u=t.types[c];if(0===s||s===o.length&&0===c||!yi(u)){var l=Ka(u,1);l.length&&s>0&&(l=e.map(l,function(e){var t=Zi(e);return t.resolvedReturnType=function(e,t,r){for(var n=[],i=0;i<t.length;i++)i===r?n.push(e):yi(t[i])&&n.push(io(Ka(t[i],1)[0]));return ys(n)}(io(e),o,c),t})),a=e.concatenate(a,l);}i=e.concatenate(i,Ka(u,0)),r=aa(r,za(u,0)),n=aa(n,za(u,1));},u=0;u<o.length;u++)c(u);fn(t,k,i,a,r,n);}function ca(t){var r=t.symbol;if(t.target)fn(t,n=Bi(ha(t.target),t.mapper,!1),Xs(Ka(t.target,0),t.mapper),s=Xs(Ka(t.target,1),t.mapper),i=_c(za(t.target,0),t.mapper),o=_c(za(t.target,1),t.mapper));else if(2048&r.flags)fn(t,n=Gi(r),eo(n.get("__call")),s=eo(n.get("__new")),i=yo(r,0),o=yo(r,1));else{var n=k,i=void 0;if(r.exports&&(n=Yr(r)),fn(t,n,e.emptyArray,e.emptyArray,void 0,void 0),32&r.flags){var a=Si(c=Di(r));1409024&a.flags?Ki(n=e.createSymbolTable(pn(n)),xa(a)):a===Q&&(i=go(Q,!1));}var o=384&r.flags?ut:void 0;if(fn(t,n,e.emptyArray,e.emptyArray,i,o),8208&r.flags&&(t.callSignatures=eo(r)),32&r.flags){var s,c=Di(r);(s=eo(r.members.get("__constructor"))).length||(s=function(t){var r=Ka(Si(t),1);if(0===r.length)return[Yi(void 0,t.localTypeParameters,void 0,e.emptyArray,t,void 0,0,!1,!1)];for(var n=vi(t),i=e.isInJavaScriptFile(n),a=Io(n),o=e.length(a),s=[],c=0,u=r;c<u.length;c++){var l=u[c],_=Qa(l.typeParameters),d=e.length(l.typeParameters);if(i||o>=_&&o<=d){var p=d?so(l,Ya(a,l.typeParameters,_,i)):Zi(l);p.typeParameters=t.localTypeParameters,p.resolvedReturnType=t,s.push(p);}}return s}(c)),t.constructSignatures=s;}}}function ua(e){return e.typeParameter||(e.typeParameter=wi(nn(e.declaration.typeParameter)))}function la(e){return e.constraintType||(e.constraintType=uc(ka(ua(e)),e.mapper||T)||ee)}function _a(e){return e.templateType||(e.templateType=e.declaration.type?uc($n(Hs(e.declaration.type),!!(4&pa(e))),e.mapper||T):ee)}function da(e){if(!e.modifiersType){var t=e.declaration.typeParameter.constraint;if(174===t.kind&&128===t.operator)e.modifiersType=uc(Hs(t.type),e.mapper||T);else{var r=la(As(e.declaration)),n=r&&32768&r.flags?ka(r):r;e.modifiersType=n&&524288&n.flags?uc(n.type,e.mapper||T):ge;}}return e.modifiersType}function pa(e){var t=e.declaration;return(t.readonlyToken?38===t.readonlyToken.kind?2:1:0)|(t.questionToken?38===t.questionToken.kind?8:4:0)}function fa(e){var t=pa(e);return 8&t?-1:4&t?1:0}function ma(e){var t=fa(e),r=da(e);return t||(ga(r)?fa(r):0)}function ga(t){return 32&e.getObjectFlags(t)&&Ss(la(t))}function ya(t){return t.members||(65536&t.flags?4&t.objectFlags?function(t){var r=ji(t.target),n=e.concatenate(r.typeParameters,[r.thisType]);Qi(t,r,n,t.typeArguments&&t.typeArguments.length===n.length?t.typeArguments:e.concatenate(t.typeArguments,[t]));}(t):3&t.objectFlags?function(t){Qi(t,ji(t),e.emptyArray,e.emptyArray);}(t):2048&t.objectFlags?function(t){for(var r=za(t.source,0),n=pa(t.mappedType),i=!(1&n),a=4&n?0:16777216,o=r&&go(wu(r.type,t.mappedType),i&&r.isReadonly),s=e.createSymbolTable(),c=0,u=xa(t.source);c<u.length;c++){var l=u[c],_=2048|(i&&dp(l)?8:0),d=cr(4|l.flags&a,l.escapedName,_);d.declarations=l.declarations,d.propertyType=ui(l),d.mappedType=t.mappedType,s.set(l.escapedName,d);}fn(t,s,e.emptyArray,e.emptyArray,o,void 0);}(t):16&t.objectFlags?ca(t):32&t.objectFlags&&function(t){var r,n=e.createSymbolTable();fn(t,k,e.emptyArray,e.emptyArray,void 0,void 0);var i=ua(t),a=la(t),o=_a(t.target||t),s=Oa(da(t)),c=pa(t),u=t.declaration.typeParameter.constraint;if(174===u.kind&&128===u.operator){for(var l=0,_=xa(s);l<_.length;l++){var d=_[l];f(hs(d),d);}(1&s.flags||za(s,0))&&f(ae);}else{var p=7372800&a.flags?Oa(a):a;dl(524288&p.flags?vs(Oa(p.type)):p,f);}function f(e,a){var u;"object"==typeof a&&(u=a);var l=Zs(t.mapper,Qs([i],[e])),_=uc(o,l);if(32&e.flags){var d=Vi(e),p=Ra(s,d),f=!!(4&c||!(8&c)&&p&&16777216&p.flags),m=!!(1&c||!(2&c)&&p&&dp(p)),g=cr(4|(f?16777216:0),d,m?8:0);g.type=P&&f&&!bc(te,_)?_u(_):P&&!f&&p&&16777216&p.flags?Qu(_,131072):_,u&&(g.syntheticOrigin=u,g.declarations=u.declarations),g.nameType=e,n.set(d,g);}else 3&e.flags&&(r=go(_,!!(1&c)));}fn(t,n,e.emptyArray,e.emptyArray,r,void 0);}(t):131072&t.flags?function(e){var t=ra(e.types,0),r=ra(e.types,1),n=na(e.types,0),i=na(e.types,1);fn(e,k,t,r,n,i);}(t):262144&t.flags&&sa(t)),t}function ha(t){return 65536&t.flags?ya(t).properties:e.emptyArray}function va(e,t){if(65536&e.flags){var r=ya(e).members.get(t);if(r&&sn(r))return r}}function ba(t){if(!t.resolvedProperties){for(var r=e.createSymbolTable(),n=0,i=t.types;n<i.length;n++){for(var a=0,o=xa(i[n]);a<o.length;a++){var s=o[a];if(!r.has(s.escapedName)){var c=La(t,s.escapedName);c&&r.set(s.escapedName,c);}}if(131072&t.flags)break}t.resolvedProperties=pn(r);}return t.resolvedProperties}function xa(e){return 393216&(e=Oa(e)).flags?ba(e):ha(e)}function Sa(e){return 32768&e.flags?ka(e):1048576&e.flags?function(e){var t=Ds(e);if(t)return t;var r=Ea(e.objectType),n=Ea(e.indexType);return(n!==ae||za(r||e.objectType,0))&&(r||n)?Es(r||e.objectType,n||e.indexType):void 0}(e):2097152&e.flags?Ca(e):Ea(e)}function ka(e){return Aa(e)?ho(e):void 0}function Ta(e){return ds([ws(e),Fs(e)])}function Da(e){if(e.root.isDistributive){var t=Sa(e.checkType);if(t)return cc(e,Zs(Qs([e.root.checkType],[t]),e.mapper))}}function Ca(e){return Da(e)||Ta(e)}function Ea(e){var t=function(e){if(7766016&e.flags){var t=Pa(e);if(t!==xe&&t!==Se)return t}}(e);return!t&&524288&e.flags?ae:t}function Na(e){return Ea(e)||e}function Aa(e){return Pa(e)!==Se}function Pa(e){var t;if(!e.resolvedBaseConstraint){var r=n(e);e.resolvedBaseConstraint=t?Se:Xi(r||xe,e);}return e.resolvedBaseConstraint;function n(e){if(Ln(e,4)){var r=function(e){if(32768&e.flags){var t=ho(e);return e.isThisType||!t?t:n(t)}if(393216&e.flags){for(var r=e.types,i=[],a=0,o=r;a<o.length;a++){var s=o[a],c=n(s);c&&i.push(c);}return 131072&e.flags&&i.length===r.length?ds(i):262144&e.flags&&i.length?ys(i):void 0}if(524288&e.flags)return ae;if(1048576&e.flags){var u=Ds(e);if(u)return n(u);var l=n(e.objectType),_=n(e.indexType),d=l&&_?Es(l,_):void 0;return d&&d!==ee?n(d):void 0}if(2097152&e.flags){var t=Ca(e);return t&&n(t)}return 4194304&e.flags?n(e.substitute):ga(e)?ge:e}(e);if(Kn())return r;t=!0;}else t=!0;}}function wa(t){if(t.default)t.default===ke&&(t.default=Se);else if(t.target){var r=wa(t.target);t.default=r?uc(r,t.mapper):xe;}else{t.default=ke;var n=t.symbol&&e.forEach(t.symbol.declarations,function(t){return e.isTypeParameterDeclaration(t)&&t.default}),i=n?Hs(n):xe;t.default===ke&&(t.default=i);}return t.default}function Fa(e){var t=wa(e);return t!==xe&&t!==Se?t:void 0}function Oa(e){var t=7897088&e.flags?Ea(e)||ge:e;return 262144&t.flags?function(e){return e.resolvedApparentType||(e.resolvedApparentType=Xi(e,e,!0))}(t):524322&t.flags?Fe:84&t.flags?Oe:136&t.flags?Ie:1536&t.flags?Jo(C>=2):134217728&t.flags?ge:t}function Ia(t,r){for(var n,i=131072&t.flags,a=i?24:0,o=i?0:16777216,s=4,c=0,u=0,l=t.types;u<l.length;u++)if((h=Oa(l[u]))!==ee){var _=(y=Ra(h,r))?e.getDeclarationModifierFlagsFromSymbol(y):0;!y||_&a?i&&(c|=16):(o&=y.flags,n=e.appendIfUnique(n,y),c|=(dp(y)?8:0)|(24&_?0:64)|(16&_?128:0)|(8&_?256:0)|(32&_?512:0),W_(y)||(s=2));}if(n){if(1===n.length&&!(16&c))return n[0];for(var d,p=[],f=[],m=0,g=n;m<g.length;m++){var y;(y=g[m]).declarations&&e.addRange(f,y.declarations);var h=ui(y);d?h!==d&&(c|=32):d=h,p.push(h);}var v=cr(4|o,r,s|c);return v.containingType=t,v.declarations=f,v.type=i?ds(p):ys(p),v}}function Ma(t,r){var n=t.propertyCache||(t.propertyCache=e.createSymbolTable()),i=n.get(r);return i||(i=Ia(t,r))&&n.set(r,i),i}function La(t,r){var n=Ma(t,r);return!n||16&e.getCheckFlags(n)?void 0:n}function Ra(e,t){if(65536&(e=Oa(e)).flags){var r=ya(e),n=r.members.get(t);if(n&&sn(n))return n;if(r===be||r.callSignatures.length||r.constructSignatures.length){var i=va(Ae,t);if(i)return i}return va(Ne,t)}if(393216&e.flags)return La(e,t)}function Ba(t,r){if(458752&t.flags){var n=ya(t);return 0===r?n.callSignatures:n.constructSignatures}return e.emptyArray}function Ka(e,t){return Ba(Oa(e),t)}function ja(e,t){if(458752&e.flags){var r=ya(e);return 0===t?r.stringIndexInfo:r.numberIndexInfo}}function Ja(e,t){var r=ja(e,t);return r&&r.type}function za(e,t){return ja(Oa(e),t)}function Ua(e,t){return Ja(Oa(e),t)}function qa(e,t){if(pu(e)){for(var r=[],n=0,i=xa(e);n<i.length;n++){var a=i[n];(0===t||b_(a.escapedName))&&r.push(ui(a));}if(r.length)return ds(r,2)}}function Va(e){var t=[];return e.forEach(function(e,r){dn(r)||t.push(e);}),t}function Wa(t){if(e.isInJavaScriptFile(t)){if(t.type&&279===t.type.kind)return!0;var r=e.getJSDocParameterTags(t);if(r)for(var n=0,i=r;n<i.length;n++){var a=i[n];if(a.isBracketed)return!0;if(a.typeExpression)return 279===a.typeExpression.type.kind}}}function Ha(t,r){if(!e.isExternalModuleNameRelative(t)){var n=vr(_t,'"'+t+'"',512);return n&&r?rn(n):n}}function Ga(t){if(e.hasQuestionToken(t)||Wa(t))return!0;if(t.initializer){var r=Za(t.parent),n=t.parent.parameters.indexOf(t);return e.Debug.assert(n>=0),n>=r.minArgumentCount}var i=e.getImmediatelyInvokedFunctionExpression(t.parent);return!!i&&!t.type&&!t.dotDotDotToken&&t.parent.parameters.indexOf(t)>=i.arguments.length}function $a(e,t,r){return{kind:1,parameterName:e,parameterIndex:t,type:r}}function Xa(e){return{kind:0,type:e}}function Qa(t){var r,n=0;if(t)for(var i=0;i<t.length;i++)(r=t[i]).symbol&&e.forEach(r.symbol.declarations,function(t){return e.isTypeParameterDeclaration(t)&&t.default})||(n=i+1);return n}function Ya(t,r,n,i){var a=e.length(r);if(a){var o=e.length(t);if(i||o>=n&&o<=a){t||(t=[]);for(var s=o;s<a;s++)t[s]=Ku(i);for(s=o;s<a;s++){var c=Qs(r,t),u=Fa(r[s]);u&&gc(u,ge)&&i&&(u=Q),t[s]=u?uc(u,c):Ku(i);}t.length=r.length;}}return t}function Za(t){var r,n=yr(t);if(!n.resolvedSignature){for(var i=[],a=!1,o=0,s=void 0,c=void 0,u=e.getImmediatelyInvokedFunctionExpression(t),l=e.isJSDocConstructSignature(t),_=!u&&!l&&e.isInJavaScriptFile(t)&&!e.hasJSDocParameterTags(t),d=l?1:0;d<t.parameters.length;d++){var p=t.parameters[d],f=p.symbol;f&&4&f.flags&&!e.isBindingPattern(p.name)&&(f=xr(p,f.escapedName,67216319,void 0,void 0,!1)),0===d&&"this"===f.escapedName?(c=!0,s=p.symbol):i.push(f),p.type&&177===p.type.kind&&(a=!0),p.initializer||p.questionToken||p.dotDotDotToken||u&&i.length>u.arguments.length&&!p.type||Wa(p)||_||(o=i.length);}if(!(155!==t.kind&&156!==t.kind||qi(t)||c&&s)){var m=155===t.kind?156:155,g=e.getDeclarationOfKind(nn(t),m);g&&(s=(r=Eg(g))&&r.symbol);}var y=154===t.kind?Di(rn(t.parent.symbol)):void 0,h=y?y.localTypeParameters:function(t){var r;return e.forEach(e.getEffectiveTypeParameterDeclarations(t),function(t){var n=wi(t.symbol);r=e.appendIfUnique(r,n);}),r}(t),v=function(t,r,n){if(r)return Hs(t.parameters[0].type);if(n)return n;var i=e.getEffectiveReturnTypeNode(t);if(i)return Hs(i);if(155===t.kind&&!qi(t)){var a=e.getDeclarationOfKind(nn(t),156);return ni(a)}return e.nodeIsMissing(t.body)?Q:void 0}(t,l,y),b=e.hasRestParameter(t)||e.isInJavaScriptFile(t)&&function(t,r){var n=e.lastOrUndefined(t.parameters),i=n&&e.getJSDocParameterTags(n),a=e.firstDefined(i,function(t){return t.typeExpression&&e.isJSDocVariadicType(t.typeExpression.type)?t.typeExpression.type:void 0});if(!a&&!function(t){var r=yr(t);return void 0===r.containsArgumentsReference&&(8192&r.flags?r.containsArgumentsReference=!0:r.containsArgumentsReference=function t(r){if(!r)return!1;switch(r.kind){case 71:return"arguments"===r.escapedText&&e.isExpressionNode(r);case 151:case 153:case 155:case 156:return 146===r.name.kind&&t(r.name);default:return!e.nodeStartsNewLexicalEnvironment(r)&&!e.isPartOfTypeNode(r)&&e.forEachChild(r,t)}}(t.body)),r.containsArgumentsReference}(t))return!1;var o=cr(3,"args");return o.type=a?rs(Hs(a.type)):Re,o.isRestParameter=!0,a&&r.pop(),r.push(o),!0}(t,i);n.resolvedSignature=Yi(t,h,s,i,v,void 0,o,b,a);}return n.resolvedSignature}function eo(t){if(!t)return e.emptyArray;for(var r=[],n=0;n<t.declarations.length;n++){var i=t.declarations[n];switch(i.kind){case 162:case 163:case 232:case 153:case 152:case 154:case 157:case 158:case 159:case 155:case 156:case 190:case 191:case 280:if(n>0&&i.body){var a=t.declarations[n-1];if(i.parent===a.parent&&i.kind===a.kind&&i.pos===a.end)break}r.push(Za(i));}}return r}function to(e){if(e.thisParameter)return ui(e.thisParameter)}function ro(e){return void 0!==no(e)}function no(t){if(!t.resolvedTypePredicate){if(t.target){var r=no(t.target);t.resolvedTypePredicate=r?(s=r,c=t.mapper,e.isIdentifierTypePredicate(s)?{kind:1,parameterName:s.parameterName,parameterIndex:s.parameterIndex,type:uc(s.type,c)}:{kind:0,type:uc(s.type,c)}):it;}else if(t.unionSignatures)t.resolvedTypePredicate=function(t){for(var r,n=[],i=0,a=t;i<a.length;i++){var o=a[i],s=no(o);if(s){if(r){if(!ps(r,s))return}else r=s;n.push(s.type);}}if(r){var c=ds(n);return e.isIdentifierTypePredicate(r)?$a(r.parameterName,r.parameterIndex,c):Xa(c)}}(t.unionSignatures)||it;else{var n=t.declaration;t.resolvedTypePredicate=n&&n.type&&160===n.type.kind?(i=n.type,a=i.parameterName,o=Hs(i.type),71===a.kind?$a(a&&a.escapedText,a&&function(e,t){if(e)for(var r=0;r<e.length;r++){var n=e[r];if(71===n.name.kind&&n.name.escapedText===t.escapedText)return r}return-1}(i.parent.parameters,a),o):Xa(o)):it;}e.Debug.assert(!!t.resolvedTypePredicate);}var i,a,o,s,c;return t.resolvedTypePredicate===it?void 0:t.resolvedTypePredicate}function io(t){if(!t.resolvedReturnType){if(!Ln(t,3))return ee;var r=void 0;if(r=t.target?uc(io(t.target),t.mapper):t.unionSignatures?ds(e.map(t.unionSignatures,io),2):ip(t.declaration),!Kn()&&(r=Q,O)){var n=t.declaration,i=e.getNameOfDeclaration(n);i?sr(i,e.Diagnostics._0_implicitly_has_return_type_any_because_it_does_not_have_a_return_type_annotation_and_is_referenced_directly_or_indirectly_in_one_of_its_return_expressions,e.declarationNameToString(i)):sr(n,e.Diagnostics.Function_implicitly_has_return_type_any_because_it_does_not_have_a_return_type_annotation_and_is_referenced_directly_or_indirectly_in_one_of_its_return_expressions);}t.resolvedReturnType=r;}return t.resolvedReturnType}function ao(t){if(t.hasRestParameter){var r=ui(e.lastOrUndefined(t.parameters));if(4&e.getObjectFlags(r)&&r.target===Pe)return r.typeArguments[0]}return Q}function oo(t,r,n){r=Ya(r,t.typeParameters,Qa(t.typeParameters),n);var i=t.instantiations||(t.instantiations=e.createMap()),a=bo(r),o=i.get(a);return o||i.set(a,o=so(t,r)),o}function so(e,t){return nc(e,co(e,t),!0)}function co(e,t){return Qs(e.typeParameters,t)}function uo(e){return e.typeParameters?e.erasedSignatureCache||(e.erasedSignatureCache=function(e){return nc(e,Ys(e.typeParameters),!0)}(e)):e}function lo(t){return t.typeParameters?t.canonicalSignatureCache||(t.canonicalSignatureCache=function(t){return oo(t,e.map(t.typeParameters,function(e){return e.target&&!ka(e.target)?e.target:e}),e.isInJavaScriptFile(t.declaration))}(t)):t}function _o(t){var r=t.typeParameters;if(r){var n=Ys(r);return nc(t,Qs(r,e.map(r,function(e){return uc(Ea(e),n)||ge})),!0)}return t}function po(t){if(!t.isolatedSignatureType){var r=154===t.declaration.kind||158===t.declaration.kind,n=_n(16);n.members=k,n.properties=e.emptyArray,n.callSignatures=r?e.emptyArray:[t],n.constructSignatures=r?[t]:e.emptyArray,t.isolatedSignatureType=n;}return t.isolatedSignatureType}function fo(e){return e.members.get("__index")}function mo(e,t){var r=1===t?134:137,n=fo(e);if(n)for(var i=0,a=n.declarations;i<a.length;i++){var o=a[i];if(1===o.parameters.length){var s=o.parameters[0];if(s&&s.type&&s.type.kind===r)return o}}}function go(e,t,r){return{type:e,isReadonly:t,declaration:r}}function yo(t,r){var n=mo(t,r);if(n)return go(n.type?Hs(n.type):Q,e.hasModifier(n,64),n)}function ho(t){if(!t.constraint)if(t.target){var r=ka(t.target);t.constraint=r?uc(r,t.mapper):xe;}else{var n=(i=t).symbol&&e.getDeclarationOfKind(i.symbol,147).constraint;t.constraint=n?Hs(n):function(t){var r;if(t.symbol)for(var n=0,i=t.symbol.declarations;n<i.length;n++){var a=i[n];if(171===a.parent.kind&&161===a.parent.parent.kind){var o=a.parent.parent,s=Xp(o);if(s){var c=o.typeArguments.indexOf(a.parent);if(c<s.length){var u=ka(s[c]);if(u){var l=uc(u,Qs(s,Gp(o,s)));l!==t&&(r=e.append(r,l));}}}}}return r&&ys(r)}(t)||xe;}var i;return t.constraint===xe?void 0:t.constraint}function vo(t){return nn(e.getDeclarationOfKind(t.symbol,147).parent)}function bo(e){var t="";if(e)for(var r=e.length,n=0;n<r;){for(var i=e[n].id,a=1;n+a<r&&e[n+a].id===i+a;)a++;t.length&&(t+=","),t+=i,a>1&&(t+=":"+a),n+=a;}return t}function xo(e,t){for(var r=0,n=0,i=e;n<i.length;n++){var a=i[n];a.flags&t||(r|=a.flags);}return 117440512&r}function So(e,t){var r=bo(t),n=e.instantiations.get(r);return n||(n=_n(4,e.symbol),e.instantiations.set(r,n),n.flags|=t?xo(t,0):0,n.target=e,n.typeArguments=t),n}function ko(e){var t=un(e.flags);return t.symbol=e.symbol,t.objectFlags=e.objectFlags,t.target=e.target,t.typeArguments=e.typeArguments,t}function To(t){return e.length(t.target.typeParameters)}function Do(t,r,n){var i=Fi(rn(r)),a=i.localTypeParameters;if(a){var o=e.length(t.typeArguments),s=Qa(a),c=e.isInJavaScriptFile(t);if((O||!c)&&(o<s||o>a.length)){var u=c&&285!==t.parent.kind;if(sr(t,s===a.length?u?e.Diagnostics.Expected_0_type_arguments_provide_these_with_an_extends_tag:e.Diagnostics.Generic_type_0_requires_1_type_argument_s:u?e.Diagnostics.Expected_0_1_type_arguments_provide_these_with_an_extends_tag:e.Diagnostics.Generic_type_0_requires_between_1_and_2_type_arguments,En(i,void 0,2),s,a.length),!c)return ee}return So(i,e.concatenate(i.outerTypeParameters,Ya(n,a,s,c)))}return Fo(t,r)?i:ee}function Co(t,r){var n=Fi(t),i=gr(t),a=i.typeParameters,o=bo(r),s=i.instantiations.get(o);return s||i.instantiations.set(o,s=uc(n,Qs(a,Ya(r,a,Qa(a),e.isInJavaScriptFile(t.valueDeclaration))))),s}function Eo(t){switch(t.kind){case 161:return t.typeName;case 205:var r=t.expression;if(e.isEntityNameExpression(r))return r}}function No(e,t){return e&&zr(e,t)||$}function Ao(t,r){var n=Io(t);if(r===$)return ee;var i=Po(t,r,n);if(i)return i;var a=Oi(r);if(a)return Fo(t,r)?32768&a.flags?function(t,r){for(var n;e.isPartOfTypeNode(r);){var i=r.parent;170===i.kind&&r===i.trueType&&Hs(i.checkType)===t&&(n=e.append(n,Hs(i.extendsType))),r=i;}return n?function(e,t){var r=un(4194304);return r.typeParameter=e,r.substitute=t,r}(t,ys(e.append(n,t))):t}(a,t):a:ee;if(!(67216319&r.flags&&wo(t)))return ee;var o=Jd(r),s=ui(r),c=s.symbol&&!qd(s)&&Po(t,s.symbol,n);return c||o?c&&o?ys([o,c]):c||o:(No(Eo(t),67901928),s)}function Po(t,r,n){return 96&r.flags?Do(t,r,n):524288&r.flags?function(t,r,n){var i=Fi(r),a=gr(r).typeParameters;if(a){var o=e.length(t.typeArguments),s=Qa(a);return o<s||o>a.length?(sr(t,s===a.length?e.Diagnostics.Generic_type_0_requires_1_type_argument_s:e.Diagnostics.Generic_type_0_requires_between_1_and_2_type_arguments,Dn(r),s,a.length),ee):Co(r,n)}return Fo(t,r)?i:ee}(t,r,n):16&r.flags&&wo(t)&&(r.members||e.getJSDocClassTag(r.valueDeclaration))?Ud(r):void 0}function wo(e){return 1048576&e.flags&&161===e.kind}function Fo(t,r){return!t.typeArguments||(sr(t,e.Diagnostics.Type_0_is_not_generic,r?Dn(r):e.declarationNameToString(t.typeName)),!1)}function Oo(t){var r=yr(t);if(!r.resolvedType){var n=void 0,i=void 0,a=67901928;wo(t)&&(i=function(t){if(e.isIdentifier(t.typeName)){var r=t.typeArguments;switch(t.typeName.escapedText){case"String":return Fo(t),ae;case"Number":return Fo(t),oe;case"Boolean":return Fo(t),ue;case"Void":return Fo(t),_e;case"Undefined":return Fo(t),te;case"Null":return Fo(t),ne;case"Function":case"function":return Fo(t),Ae;case"Array":case"array":return r&&r.length?void 0:Re;case"Promise":case"promise":return r&&r.length?void 0:rp(Q);case"Object":if(r&&2===r.length){if(e.isJSDocIndexSignature(t)){var n=Hs(r[0]),i=go(Hs(r[1]),!1);return mn(void 0,k,e.emptyArray,e.emptyArray,n===ae&&i,n===oe&&i)}return Q}return Fo(t),Q}}}(t),a|=67216319),i||(i=Ao(t,n=No(Eo(t),a))),r.resolvedSymbol=n,r.resolvedType=i;}return r.resolvedType}function Io(t){return e.map(t.typeArguments,Hs)}function Mo(e){var t=yr(e);return t.resolvedType||(t.resolvedType=bu(Rp(e.exprName))),t.resolvedType}function Lo(t,r){function n(e){for(var t=0,r=e.declarations;t<r.length;t++){var n=r[t];switch(n.kind){case 233:case 234:case 236:return n}}}if(!t)return r?ve:ge;var i=Fi(t);return 65536&i.flags?e.length(i.typeParameters)!==r?(sr(n(t),e.Diagnostics.Global_type_0_must_have_1_type_parameter_s,e.symbolName(t),r),r?ve:ge):i:(sr(n(t),e.Diagnostics.Global_type_0_must_be_a_class_or_interface_type,e.symbolName(t)),r?ve:ge)}function Ro(t,r){return Bo(t,67216319,r?e.Diagnostics.Cannot_find_global_value_0:void 0)}function Bo(e,t,r){return xr(void 0,e,t,r,e,!1)}function Ko(t,r,n){var i=function(t,r){return Bo(t,67901928,r?e.Diagnostics.Cannot_find_global_type_0:void 0)}(t,n);return i||n?Lo(i,r):void 0}function jo(e){return Je||(Je=Ro("Symbol",e))}function Jo(e){return ze||(ze=Ko("Symbol",0,e))||ge}function zo(e){return qe||(qe=Ko("Promise",1,e))||ve}function Uo(e){return Ve||(Ve=Ro("Promise",e))}function qo(e){return Xe||(Xe=Ko("AsyncIterable",1,e))||ve}function Vo(e){return Qe||(Qe=Ko("AsyncIterator",1,e))||ve}function Wo(e){return Ye||(Ye=Ko("AsyncIterableIterator",1,e))||ve}function Ho(e){return He||(He=Ko("Iterable",1,e))||ve}function Go(e){return Ge||(Ge=Ko("Iterator",1,e))||ve}function $o(e){return $e||($e=Ko("IterableIterator",1,e))||ve}function Xo(e,t){void 0===t&&(t=0);var r=Bo(e,67901928,void 0);return r&&Lo(r,t)}function Qo(e,t){return e!==ve?So(e,t):ge}function Yo(e){return Qo(Ue||(Ue=Ko("TypedPropertyDescriptor",1,!0))||ve,[e])}function Zo(e){return Qo(Wo(!0),[e])}function es(e){return Qo(Ho(!0),[e])}function ts(e){return Qo($o(!0),[e])}function rs(e){return Qo(Pe,[e])}function ns(t){return z[t]||(z[t]=function(t){for(var r=[],n=[],i=0;i<t;i++){var a=un(32768);r.push(a);var o=cr(4,""+i);o.type=a,n.push(o);}var s=cr(4,"length");s.type=qs(t),n.push(s);var c=_n(12);return c.typeParameters=r,c.outerTypeParameters=void 0,c.localTypeParameters=r,c.instantiations=e.createMap(),c.instantiations.set(bo(c.typeParameters),c),c.target=c,c.typeArguments=c.typeParameters,c.thisType=un(32768),c.thisType.isThisType=!0,c.thisType.constraint=c,c.declaredProperties=n,c.declaredCallSignatures=e.emptyArray,c.declaredConstructSignatures=e.emptyArray,c.declaredStringIndexInfo=void 0,c.declaredNumberIndexInfo=void 0,c}(t))}function is(e){return So(ns(e.length),e)}function as(e){return e.id}function os$$1(t,r){return e.binarySearch(t,r,as,e.compareValues)>=0}function ss(t,r,n){var i=n.flags;if(131072&i)r=cs(t,r,n.types);else if(1&i)r|=1,n===Z&&(r|=4096);else if(!P&&12288&i)4096&i&&(r|=2),8192&i&&(r|=4),16777216&i||(r|=16);else if(!(16384&i||262144&i&&function(e){for(var t=0,r=0,n=e.types;r<n.length;r++){var i=n[r];if(13536&i.flags&&13536&t)return!0;if(12288&(t|=i.flags)&&134283264&t)return!0}return!1}(n))){2&i&&(r|=32),4&i&&(r|=64),512&i&&(r|=128),1120&i&&(r|=256);var a=t.length,o=a&&n.id>t[a-1].id?~a:e.binarySearch(t,n,as,e.compareValues);o<0&&(65536&i&&16&n.objectFlags&&n.symbol&&8208&n.symbol.flags&&us(t,n)||t.splice(~o,0,n));}return r}function cs(e,t,r){for(var n=0,i=r;n<i.length;n++)t=ss(e,t,i[n]);return t}function us(e,t){for(var r=0,n=e;r<n.length;r++)if(gc(n[r],t))return!0;return!1}function ls(t,r){for(var n=0,i=r;n<i.length;n++){var a=i[n];if(t!==a&&vc(t,a)&&(!(1&e.getObjectFlags(_i(t)))||!(1&e.getObjectFlags(_i(a)))||xc(t,a)))return!0}return!1}function _s(t){if(0!==t.length&&!function(e){var t=e[0];if(256&t.flags){for(var r=an(t.symbol),n=1;n<e.length;n++){var i=e[n];if(!(256&i.flags)||r!==an(i.symbol))return!1}return!0}return!1}(t))for(var r=t.length;r>0;)ls(t[--r],t)&&e.orderedRemoveItemAt(t,r);}function ds(t,r,n,i){if(void 0===r&&(r=1),0===t.length)return de;if(1===t.length)return t[0];var a=[],o=cs(a,0,t);if(1&o)return 4096&o?Z:Q;switch(r){case 1:256&o&&function(t,r){for(var n=t.length;n>0;){var i=t[--n];(32&i.flags&&32&r||64&i.flags&&64&r||1024&i.flags&&128&r||96&i.flags&&8388608&i.flags&&os$$1(t,i.regularType))&&e.orderedRemoveItemAt(t,n);}}(a,o);break;case 2:_s(a);}return 0===a.length?4&o?16&o?ne:ie:2&o?16&o?te:re:de:fs$$1(a,n,i)}function ps(t,r){return e.isIdentifierTypePredicate(t)?e.isIdentifierTypePredicate(r)&&t.parameterIndex===r.parameterIndex:!e.isIdentifierTypePredicate(r)}function fs$$1(e,t,r){if(0===e.length)return de;if(1===e.length)return e[0];var n=bo(e),i=U.get(n);return i||(i=un(131072|xo(e,12288)),U.set(n,i),i.types=e,i.aliasSymbol=t,i.aliasTypeArguments=r),i}function ms(t,r,n){var i=n.flags;return 262144&i?r=gs(t,r,n.types):1&i?(r|=1,n===Z&&(r|=4096)):16384&i?r|=8:16&e.getObjectFlags(n)&&Ac(n)?r|=1024:!P&&12288&i||e.contains(t,n)||(65536&i&&(r|=512),131072&i&&(r|=2048),65536&i&&16&n.objectFlags&&n.symbol&&8208&n.symbol.flags&&us(t,n)||t.push(n)),r}function gs(e,t,r){for(var n=0,i=r;n<i.length;n++)t=ms(e,t,Us(i[n]));return t}function ys(t,r,n){if(0===t.length)return ge;var i=[],a=gs(i,0,t);if(8&a)return de;if(1&a)return 4096&a?Z:Q;if(1024&a&&!(512&a)&&i.push(ge),1===i.length)return i[0];if(2048&a){var o=e.findIndex(i,function(e){return 0!=(131072&e.flags)}),s=i[o];return ds(e.map(s.types,function(t){return ys(e.replaceElement(i,o,t))}),1,r,n)}var c=bo(i),u=q.get(c);return u||(u=un(262144|xo(i,12288)),q.set(c,u),u.types=i,u.aliasSymbol=r,u.aliasTypeArguments=n),u}function hs(t){var r=gr($i(t));return r.nameType||(r.target&&r.target!==$&&r.target!==X?(e.Debug.assert(r.target.escapedName===t.escapedName||"__computed"===r.target.escapedName,"Target symbol and symbol do not have the same name"),r.nameType=hs(r.target)):r.nameType=24&e.getDeclarationModifierFlagsFromSymbol(t)||e.isKnownSymbol(t)?de:qs(e.symbolName(t))),r.nameType}function vs(t){return 262144&t.flags?ds(e.map(t.types,function(e){return vs(e)})):gp(t,7372800)?function(e){return e.resolvedIndexType||(e.resolvedIndexType=un(524288),e.resolvedIndexType.type=e),e.resolvedIndexType}(t):32&e.getObjectFlags(t)?la(t):t===Z?Z:1&t.flags||za(t,0)?ae:function(t){return ds(e.map(xa(t),hs))}(t)}function bs(t,r,n,i){var a=n&&184===n.kind?n:void 0,o=Ji(r)?Vi(r):a&&ud(a.argumentExpression,r,!1)?e.getPropertyNameForKnownSymbolName(e.idText(a.argumentExpression.name)):void 0;if(void 0!==o){var s=Ra(t,o);if(s){if(a){if(ad(s,a,99===a.expression.kind),e.isAssignmentTarget(a)&&(pp(a,s)||fp(a)))return sr(a.argumentExpression,e.Diagnostics.Cannot_assign_to_0_because_it_is_a_constant_or_a_read_only_property,Dn(s)),ee;i&&(yr(n).resolvedSymbol=s);}return ui(s)}}if(!(12288&r.flags)&&yp(r,525942)){if(zn(t))return t;var c=yp(r,84)&&za(t,1)||za(t,0)||void 0;if(c)return a&&c.isReadonly&&(e.isAssignmentTarget(a)||e.isDeleteTarget(a))&&sr(a,e.Diagnostics.Index_signature_in_type_0_only_permits_reading,En(t)),c.type;if(a&&!vp(t))return O&&!D.suppressImplicitAnyIndexErrors&&(Ua(t,1)?sr(a.argumentExpression,e.Diagnostics.Element_implicitly_has_an_any_type_because_index_expression_is_not_of_type_number):sr(a,e.Diagnostics.Element_implicitly_has_an_any_type_because_type_0_has_no_index_signature,En(t))),Q}if(n){var u=184===n.kind?n.argumentExpression:n.indexType;return 96&r.flags?sr(u,e.Diagnostics.Property_0_does_not_exist_on_type_1,""+r.value,En(t)):6&r.flags?sr(u,e.Diagnostics.Type_0_has_no_matching_index_signature_for_type_1,En(t),En(r)):sr(u,e.Diagnostics.Type_0_cannot_be_used_as_an_index_type,En(r)),ee}return Q}function xs(e){return gp(e,544243712)}function Ss(e){return gp(e,7897088)}function ks(e){if(65536&e.flags&&!ga(e)){var t=ya(e);return 0===t.properties.length&&0===t.callSignatures.length&&0===t.constructSignatures.length&&t.stringIndexInfo&&!t.numberIndexInfo}return!1}function Ts(t){return 32&e.getObjectFlags(t)&&_a(t)===de}function Ds(t){var r=t.objectType;if(262144&r.flags&&xs(r)){if(e.some(r.types,ks)){for(var n=[],i=[],a=0,o=r.types;a<o.length;a++){var s=o[a];ks(s)?i.push(Ua(s,0)):n.push(s);}return ds([Es(ys(n),t.indexType),ys(i)])}if(e.some(r.types,Ts))return Es(ys(e.filter(r.types,function(e){return!Ts(e)})),t.indexType)}if(ga(r))return Cs(r,t);if(32768&r.flags){var c=ho(r);if(c&&ga(c))return Cs(c,t)}}function Cs(e,t){var r=Qs([ua(e)],[t.indexType]),n=Zs(e.mapper,r);return uc(_a(e),n)}function Es(e,t,r){if(e===Z||t===Z)return Z;if(Ss(t)||(!r||184!==r.kind)&&xs(e)){if(1&e.flags)return e;var n=e.id+","+t.id,i=W.get(n);return i||W.set(n,i=function(e,t){var r=un(1048576);return r.objectType=e,r.indexType=t,r}(e,t)),i}var a=Oa(e);if(131072&t.flags&&!(8&t.flags)){for(var o=[],s=0,c=t.types;s<c.length;s++){var u=bs(a,c[s],r,!1);if(u===ee)return ee;o.push(u);}return ds(o)}return bs(a,t,r,!0)}function Ns(e){var t=yr(e);return t.resolvedType||(t.resolvedType=Es(Hs(e.objectType),Hs(e.indexType),e)),t.resolvedType}function As(e){var t=yr(e);if(!t.resolvedType){var r=_n(32,e.symbol);r.declaration=e,r.aliasSymbol=Ms(e),r.aliasTypeArguments=Ls(e),t.resolvedType=r,la(r);}return t.resolvedType}function Ps(e,t){var r=uc(e.checkType,t),n=uc(e.extendsType,t);if(r===Z||n===Z)return Z;if(!e.isDistributive||!gp(r,7897088)){var i=void 0;if(e.inferTypeParameters){var a=Du(e.inferTypeParameters,void 0,0);Iu(a.inferences,r,n,48),i=Zs(t,a);}if(1&r.flags)return ds([uc(e.trueType,i||t),uc(e.falseType,t)]);var o=i?uc(e.extendsType,i):n;if(!bc(lc(r),lc(o)))return uc(e.falseType,t);if(Ic(r,o,er,void 0))return uc(e.trueType,i||t)}var s,c=4194304&(s=r).flags?s.typeParameter:s,u=un(2097152);return u.root=e,u.checkType=c,u.extendsType=n,u.mapper=t,u.aliasSymbol=e.aliasSymbol,u.aliasTypeArguments=$s(e.aliasTypeArguments,t),u}function ws(e){return e.resolvedTrueType||(e.resolvedTrueType=uc(e.root.trueType,e.mapper))}function Fs(e){return e.resolvedFalseType||(e.resolvedFalseType=uc(e.root.falseType,e.mapper))}function Os(t){var r;return t.locals&&t.locals.forEach(function(t){262144&t.flags&&(r=e.append(r,Fi(t)));}),r}function Is(t){var r=yr(t);if(!r.resolvedType){var n=Ms(t);if(0!==Gi(t.symbol).size||n){var i=_n(16,t.symbol);i.aliasSymbol=n,i.aliasTypeArguments=Ls(t),e.isJSDocTypeLiteral(t)&&t.isArrayType&&(i=rs(i)),r.resolvedType=i;}else r.resolvedType=he;}return r.resolvedType}function Ms(e){return 235===e.parent.kind?nn(e.parent):void 0}function Ls(e){var t=Ms(e);return t?gi(t):void 0}function Rs(t,r,n,i,a){if(1&t.flags||1&r.flags)return Q;if(16384&t.flags)return r;if(16384&r.flags)return t;if(131072&t.flags)return fl(t,function(e){return Rs(e,r,n,i,a)});if(131072&r.flags)return fl(r,function(e){return Rs(t,e,n,i,a)});if(134742526&r.flags)return t;var o,s,c=e.createSymbolTable(),u=e.createUnderscoreEscapedMap();t===ge?(o=za(r,0),s=za(r,1)):(o=oa(za(t,0),za(r,0)),s=oa(za(t,1),za(r,1)));for(var l=0,_=xa(r);l<_.length;l++){var d=65536&(g=_[l]).flags&&!(32768&g.flags);24&e.getDeclarationModifierFlagsFromSymbol(g)?u.set(g.escapedName,!0):js(g)||d||c.set(g.escapedName,Bs(g));}for(var p=0,f=xa(t);p<f.length;p++){var m=f[p];if(!(65536&m.flags&&!(32768&m.flags)||u.has(m.escapedName)||js(m)))if(c.has(m.escapedName)){var g,y=ui(g=c.get(m.escapedName));if(16777216&g.flags){var h=e.concatenate(m.declarations,g.declarations),v=cr(4|16777216&m.flags,m.escapedName);v.type=ds([ui(m),Qu(y,131072)]),v.leftSpread=m,v.rightSpread=g,v.declarations=h,c.set(m.escapedName,v);}}else c.set(m.escapedName,Bs(m));}var b=mn(n,c,e.emptyArray,e.emptyArray,Ks(o),Ks(s));return b.flags|=33554432|i,b.objectFlags|=1152|a,b}function Bs(e){if(!dp(e))return e;var t=cr(4|16777216&e.flags,e.escapedName);return t.type=ui(e),t.declarations=e.declarations,t.syntheticOrigin=e,t}function Ks(e){return e&&e.isReadonly?go(e.type,!1,e.declaration):e}function js(t){return 8192&t.flags&&e.find(t.declarations,function(t){return e.isClassLike(t.parent)})}function Js(e,t,r){var n=un(e);return n.symbol=r,n.value=t,n}function zs(e){if(96&e.flags&&!(8388608&e.flags)){if(!e.freshType){var t=Js(8388608|e.flags,e.value,e.symbol);t.regularType=e,e.freshType=t;}return e.freshType}return e}function Us(e){return 96&e.flags&&8388608&e.flags?e.regularType:e}function qs(e,t,r){var n="number"==typeof e?"#":"@",i=t?t+n+e:n+e,a=V.get(i);if(!a){var o=("number"==typeof e?64:32)|(t?256:0);V.set(i,a=Js(o,e,r));}return a}function Vs(t){if(e.isValidESSymbolDeclaration(t)){var r=nn(t),n=gr(r);return n.uniqueESSymbolType||(n.uniqueESSymbolType=function(e){var t=un(1024);return t.symbol=e,t}(r))}return le}function Ws(t){var r=yr(t);return r.resolvedType||(r.resolvedType=function(t){var r=e.getThisContainer(t,!1),n=r&&r.parent;return!n||!e.isClassLike(n)&&234!==n.kind||e.hasModifier(r,32)||154===r.kind&&!e.isNodeDescendantOf(t,r.body)?(sr(t,e.Diagnostics.A_this_type_is_available_only_in_a_non_static_member_of_a_class_or_interface),ee):Di(nn(n)).thisType}(t)),r.resolvedType}function Hs(t){switch(t.kind){case 119:case 275:case 276:return Q;case 137:return ae;case 134:return oe;case 122:return ue;case 138:return le;case 105:return _e;case 140:return te;case 95:return ne;case 131:return de;case 135:return 65536&t.flags?Q:me;case 173:case 99:return Ws(t);case 177:return function(e){var t=yr(e);return t.resolvedType||(t.resolvedType=Us(Rp(e.literal))),t.resolvedType}(t);case 161:return Oo(t);case 160:return ue;case 205:return Oo(t);case 164:return Mo(t);case 166:return function(e){var t=yr(e);return t.resolvedType||(t.resolvedType=rs(Hs(e.elementType))),t.resolvedType}(t);case 167:return function(t){var r=yr(t);return r.resolvedType||(r.resolvedType=is(e.map(t.elementTypes,Hs))),r.resolvedType}(t);case 168:return function(t){var r=yr(t);return r.resolvedType||(r.resolvedType=ds(e.map(t.types,Hs),1,Ms(t),Ls(t))),r.resolvedType}(t);case 169:return function(t){var r=yr(t);return r.resolvedType||(r.resolvedType=ys(e.map(t.types,Hs),Ms(t),Ls(t))),r.resolvedType}(t);case 277:return function(e){var t=Hs(e.type);return P?lu(t,8192):t}(t);case 172:case 278:case 279:case 274:return Hs(t.type);case 281:return function(t){var r=Hs(t.type),n=t.parent,i=n.parent;if(e.isJSDocTypeExpression(n)&&e.isJSDocParameterTag(i)){var a=e.getParameterSymbolFromJSDoc(i);if(a){var o=e.getHostSignatureFromJSDoc(i),s=o&&e.last(o.parameters);if(s.symbol===a&&e.isRestParameter(s))return rs(r)}}return $n(r)}(t);case 162:case 163:case 165:case 283:case 280:return Is(t);case 174:return function(t){var r=yr(t);if(!r.resolvedType)switch(t.operator){case 128:r.resolvedType=vs(Hs(t.type));break;case 141:r.resolvedType=138===t.type.kind?Vs(e.walkUpParenthesizedTypes(t.parent)):ee;}return r.resolvedType}(t);case 175:return Ns(t);case 176:return As(t);case 170:return function(t){var r=yr(t);if(!r.resolvedType){var n=Hs(t.checkType),i=Ls(t),a=fi(t,!0),o=i?a:e.filter(a,function(e){return oc(e,t)}),s={node:t,checkType:n,extendsType:Hs(t.extendsType),trueType:Hs(t.trueType),falseType:Hs(t.falseType),isDistributive:!!(32768&n.flags),inferTypeParameters:Os(t),outerTypeParameters:o,instantiations:void 0,aliasSymbol:Ms(t),aliasTypeArguments:i};r.resolvedType=Ps(s,void 0),o&&(s.instantiations=e.createMap(),s.instantiations.set(bo(o),r.resolvedType));}return r.resolvedType}(t);case 171:return function(e){var t=yr(e);return t.resolvedType||(t.resolvedType=wi(nn(e.typeParameter))),t.resolvedType}(t);case 71:case 145:var r=Om(t);return r&&Fi(r);default:return ee}}function Gs(e,t,r){if(e&&e.length)for(var n=0;n<e.length;n++){var i=e[n],a=r(i,t);if(i!==a){var o=0===n?[]:e.slice(0,n);for(o.push(a),n++;n<e.length;n++)o.push(r(e[n],t));return o}}return e}function $s(e,t){return Gs(e,t,uc)}function Xs(e,t){return Gs(e,t,nc)}function Qs(t,r){return e.Debug.assert(void 0===r||t.length===r.length),1===t.length?(s=t[0],c=r?r[0]:Q,function(e){return e===s?c:e}):2===t.length?(n=t[0],i=r?r[0]:Q,a=t[1],o=r?r[1]:Q,function(e){return e===n?i:e===a?o:e}):function(e,t){return function(r){for(var n=0;n<e.length;n++)if(r===e[n])return t?t[n]:Q;return r}}(t,r);var n,i,a,o,s,c;}function Ys(e){return Qs(e,void 0)}function Zs(e,t){return e?t?function(r){return uc(e(r),t)}:e:t}function ec(e,t,r){return function(n){return n===e?t:r(n)}}function tc(e){return 32768&e.flags?Z:e}function rc(e){var t=un(32768);return t.symbol=e.symbol,t.target=e,t}function nc(t,r,n){var i;if(t.typeParameters&&!n){i=e.map(t.typeParameters,rc),r=Zs(Qs(t.typeParameters,i),r);for(var a=0,o=i;a<o.length;a++)o[a].mapper=r;}var s=Yi(t.declaration,i,t.thisParameter&&ic(t.thisParameter,r),Gs(t.parameters,r,ic),void 0,void 0,t.minArgumentCount,t.hasRestParameter,t.hasLiteralTypes);return s.target=t,s.mapper=r,s}function ic(t,r){var n=gr(t);if(n.type&&!gp(n.type,7962624))return t;1&e.getCheckFlags(t)&&(t=n.target,r=Zs(n.mapper,r));var i=cr(t.flags,t.escapedName,1);return i.declarations=t.declarations,i.parent=t.parent,i.target=t,i.mapper=r,t.valueDeclaration&&(i.valueDeclaration=t.valueDeclaration),t.isRestParameter&&(i.isRestParameter=t.isRestParameter),i}function ac(t,r){var n=64&t.objectFlags?t.target:t,i=n.symbol,a=gr(i),o=a.outerTypeParameters;if(!o){var s=i.declarations[0],c=fi(s,!0)||e.emptyArray;o=2048&i.flags&&!n.aliasTypeArguments?e.filter(c,function(e){return oc(e,s)}):c,a.outerTypeParameters=o,o.length&&(a.instantiations=e.createMap(),a.instantiations.set(bo(o),n));}if(o.length){var u=64&t.objectFlags?Zs(t.mapper,r):r,l=e.map(o,u),_=bo(l),d=a.instantiations.get(_);if(!d){var p=Qs(o,l);d=32&n.objectFlags?function(e,t){var r=la(e);if(524288&r.flags){var n=r.type;if(32768&n.flags){var i=uc(n,t);if(n!==i)return fl(i,function(r){return function(e){return 7700481&e.flags}(r)?sc(e,ec(n,r,t)):r})}}return sc(e,t)}(n,p):sc(n,p),a.instantiations.set(_,d);}return d}return t}function oc(t,r){if(t.symbol&&t.symbol.declarations&&1===t.symbol.declarations.length){var n=t.symbol.declarations[0].parent;if(e.findAncestor(r,function(e){return 211===e.kind?"quit":e===n}))return e.forEachChild(r,function r(n){switch(n.kind){case 173:return t.isThisType;case 71:return!t.isThisType&&e.isPartOfTypeNode(n)&&Hs(n)===t;case 164:return!0}return e.forEachChild(n,r)})}return!0}function sc(e,t){var r=_n(64|e.objectFlags,e.symbol);return 32&e.objectFlags&&(r.declaration=e.declaration),r.target=e,r.mapper=t,r.aliasSymbol=e.aliasSymbol,r.aliasTypeArguments=$s(e.aliasTypeArguments,t),r}function cc(t,r){var n=t.root;if(n.outerTypeParameters){var i=e.map(n.outerTypeParameters,r),a=bo(i),o=n.instantiations.get(a);return o||(o=function(e,t){if(e.isDistributive){var r=e.checkType,n=t(r);if(r!==n&&147456&n.flags)return fl(n,function(n){return Ps(e,ec(r,n,t))})}return Ps(e,t)}(n,Qs(n.outerTypeParameters,i)),n.instantiations.set(a,o)),o}return t}function uc(e,t){if(e&&t&&t!==T){if(32768&e.flags)return t(e);if(65536&e.flags){if(16&e.objectFlags)return e.symbol&&14384&e.symbol.flags&&e.symbol.declarations?ac(e,t):e;if(32&e.objectFlags)return ac(e,t);if(4&e.objectFlags){var r=e.typeArguments,n=$s(r,t);return n!==r?So(e.target,n):e}}var i,a;if(131072&e.flags&&!(16382&e.flags))return(a=$s(i=e.types,t))!==i?ds(a,1,e.aliasSymbol,$s(e.aliasTypeArguments,t)):e;if(262144&e.flags)return(a=$s(i=e.types,t))!==i?ys(a,e.aliasSymbol,$s(e.aliasTypeArguments,t)):e;if(524288&e.flags)return vs(uc(e.type,t));if(1048576&e.flags)return Es(uc(e.objectType,t),uc(e.indexType,t));if(2097152&e.flags)return cc(e,Zs(e.mapper,t));if(4194304&e.flags)return t(e.typeParameter)}return e}function lc(e){return 32767&e.flags?e:e.wildcardInstantiation||(e.wildcardInstantiation=uc(e,tc))}function _c(e,t){return e&&go(uc(e.type,t),e.isReadonly,e.declaration)}function dc(t){switch(e.Debug.assert(153!==t.kind||e.isObjectLiteralMethod(t)),t.kind){case 190:case 191:case 153:return pc(t);case 182:return e.forEach(t.properties,dc);case 181:return e.forEach(t.elements,dc);case 199:return dc(t.whenTrue)||dc(t.whenFalse);case 198:return 54===t.operatorToken.kind&&(dc(t.left)||dc(t.right));case 268:return dc(t.initializer);case 189:return dc(t.expression);case 261:return e.forEach(t.properties,dc);case 260:return t.initializer&&dc(t.initializer);case 263:return t.expression&&dc(t.expression)}return!1}function pc(t){if(t.typeParameters)return!1;if(e.forEach(t.parameters,function(t){return!e.getEffectiveTypeAnnotationNode(t)}))return!0;if(191!==t.kind){var r=e.firstOrUndefined(t.parameters);if(!r||!e.parameterIsThisKeyword(r))return!0}return 211!==t.body.kind&&dc(t.body)}function fc(t){return(p_(t)||e.isObjectLiteralMethod(t))&&pc(t)}function mc(t){if(65536&t.flags){var r=ya(t);if(r.constructSignatures.length){var n=_n(16,t.symbol);return n.members=r.members,n.properties=r.properties,n.callSignatures=e.emptyArray,n.constructSignatures=e.emptyArray,n}}else if(262144&t.flags)return ys(e.map(t.types,mc));return t}function gc(e,t){return Fc(e,t,rr)}function yc(e,t){return Fc(e,t,rr)?-1:0}function hc(e,t){return Fc(e,t,Zt)?-1:0}function vc(e,t){return Fc(e,t,Yt)}function bc(e,t){return Fc(e,t,Zt)}function xc(t,r){return 131072&t.flags?e.every(t.types,function(e){return xc(e,r)}):131072&r.flags?e.some(r.types,function(e){return xc(t,e)}):7372800&t.flags?xc(Ea(t)||ge,r):r===Ne||r===Ae?vc(t,r):di(t,_i(r))}function Sc(e,t){return Fc(e,t,tr)}function kc(e,t){return Sc(e,t)||Sc(t,e)}function Tc(e,t,r,n,i){return Ic(e,t,Zt,r,n,i)}function Dc(e,t,r,n,i){return Ic(e,t,tr,r,n,i)}function Cc(t,r,n,i,a,o,s){if(t===r)return-1;if(!r.hasRestParameter&&t.minArgumentCount>r.parameters.length)return 0;t.typeParameters&&t.typeParameters!==r.typeParameters&&(t=gd(t,r=lo(r),void 0,s));var c=r.declaration?r.declaration.kind:0,u=!n&&w&&153!==c&&152!==c&&154!==c,l=-1,_=to(t);if(_&&_!==_e){var d=to(r);if(d){if(!(v=!u&&s(_,d,!1)||s(d,_,a)))return a&&o(e.Diagnostics.The_this_types_of_each_signature_are_incompatible),0;l&=v;}}for(var p=Nc(t),f=Nc(r),m=function(e,t,r,n){return e.hasRestParameter===r.hasRestParameter?e.hasRestParameter?Math.max(t,n)+1:Math.min(t,n):e.hasRestParameter?n:t}(t,p,r,f),g=t.parameters,y=r.parameters,h=0;h<m;h++){var v,b=h<p?Yd(g[h]):ao(t),x=h<f?Yd(y[h]):ao(r),S=n?void 0:md(du(b)),k=n?void 0:md(du(x));if(!(v=S&&k&&!ro(S)&&!ro(k)&&(12288&su(b))==(12288&su(x))?Cc(k,S,u?2:1,!1,a,o,s):!n&&!u&&s(b,x,!1)||s(x,b,a)))return a&&o(e.Diagnostics.Types_of_parameters_0_and_1_are_incompatible,e.symbolName(g[h<p?h:p]),e.symbolName(y[h<f?h:f])),0;l&=v;}if(!i){var T=io(r);if(T===_e)return l;var D=io(t),C=no(r);if(C){var E=no(t);if(E)l&=function(t,r,n,i,a,o,s){if(t.kind!==r.kind)return a&&(o(e.Diagnostics.A_this_based_type_guard_is_not_compatible_with_a_parameter_based_type_guard),o(e.Diagnostics.Type_predicate_0_is_not_assignable_to_1,An(t),An(r))),0;if(1===t.kind){var c=r,u=t.parameterIndex-(e.getThisParameter(n)?1:0),l=c.parameterIndex-(e.getThisParameter(i)?1:0);if(u!==l)return a&&(o(e.Diagnostics.Parameter_0_is_not_in_the_same_position_as_parameter_1,t.parameterName,c.parameterName),o(e.Diagnostics.Type_predicate_0_is_not_assignable_to_1,An(t),An(r))),0}var _=s(t.type,r.type,a);return 0===_&&a&&o(e.Diagnostics.Type_predicate_0_is_not_assignable_to_1,An(t),An(r)),_}(E,C,t.declaration,r.declaration,a,o,s);else if(e.isIdentifierTypePredicate(C))return a&&o(e.Diagnostics.Signature_0_must_be_a_type_predicate,Cn(t)),0}else l&=1===n&&s(T,D,!1)||s(D,T,a);}return l}function Ec(e,t){var r=uo(e),n=uo(t),i=io(r),a=io(n);return!(a!==_e&&!Fc(a,i,Zt)&&!Fc(i,a,Zt))&&0!==Cc(r,n,0,!0,!1,void 0,hc)}function Nc(e){var t=e.parameters.length;return e.hasRestParameter?t-1:t}function Ac(t){return 65536&t.flags?0===(r=ya(t)).properties.length&&0===r.callSignatures.length&&0===r.constructSignatures.length&&!r.stringIndexInfo&&!r.numberIndexInfo:!!(134217728&t.flags)||(131072&t.flags?e.forEach(t.types,Ac):!!(262144&t.flags)&&!e.forEach(t.types,function(e){return!Ac(e)}));var r;}function Pc(t,r,n){if(t===r)return!0;var i=u(t)+","+u(r),a=nr.get(i);if(void 0!==a)return a;if(!(t.escapedName===r.escapedName&&256&t.flags&&256&r.flags))return nr.set(i,!1),!1;for(var o=ui(r),s=0,c=xa(ui(t));s<c.length;s++){var l=c[s];if(8&l.flags){var _=Ra(o,l.escapedName);if(!(_&&8&_.flags))return n&&n(e.Diagnostics.Property_0_is_missing_in_type_1,e.symbolName(l),En(Fi(r),void 0,64)),nr.set(i,!1),!1}}return nr.set(i,!0),!0}function wc(e,t,r,n){var i=e.flags,a=t.flags;if(1&a||16384&i||e===Z)return!0;if(16384&a)return!1;if(524322&i&&2&a)return!0;if(32&i&&256&i&&32&a&&!(256&a)&&e.value===t.value)return!0;if(84&i&&4&a)return!0;if(64&i&&256&i&&64&a&&!(256&a)&&e.value===t.value)return!0;if(136&i&&8&a)return!0;if(1536&i&&512&a)return!0;if(16&i&&16&a&&Pc(e.symbol,t.symbol,n))return!0;if(256&i&&256&a){if(131072&i&&131072&a&&Pc(e.symbol,t.symbol,n))return!0;if(224&i&&224&a&&e.value===t.value&&Pc(an(e.symbol),an(t.symbol),n))return!0}if(4096&i&&(!P||6144&a))return!0;if(8192&i&&(!P||8192&a))return!0;if(65536&i&&134217728&a)return!0;if(1024&i||1024&a)return!1;if(r===Zt||r===er||r===tr){if(1&i)return!0;if(68&i&&!(256&i)&&(16&a||64&a&&256&a))return!0}return!1}function Fc(e,t,r){if(96&e.flags&&8388608&e.flags&&(e=e.regularType),96&t.flags&&8388608&t.flags&&(t=t.regularType),e===t||r===tr&&!(16384&t.flags)&&wc(t,e,r)||r!==rr&&wc(e,t,r))return!0;if(65536&e.flags&&65536&t.flags){var n=r.get(jc(e,t,r));if(void 0!==n)return 1===n}return!!(8355840&e.flags||8355840&t.flags)&&Ic(e,t,r,void 0)}function Oc(t,r,n){return 4096&e.getObjectFlags(t)&&!(D_(r.escapedName)||n)}function Ic(t,r,n,i,a,o){var s,c,u,l,_=0,d=0,p=0,f=!1,m=!1;e.Debug.assert(n!==rr||!i,"no error reporting in identity checking");var g=x(t,r,!!i,a);if(f)sr(i,e.Diagnostics.Excessive_stack_depth_comparing_types_0_and_1,En(t),En(r));else if(s){if(o){var y=o();y&&(s=e.concatenateDiagnosticMessageChains(y,s));}Lt.add(e.createDiagnosticForNodeFromMessageChain(i,s));}if(a&&i&&!g&&t.symbol){var h=gr(t.symbol);h.originatingImport&&!e.isImportCall(h.originatingImport)&&Ic(ui(h.target),r,n,void 0)&&Lt.add(e.createDiagnosticForNode(h.originatingImport,e.Diagnostics.A_namespace_style_import_cannot_be_called_or_constructed_and_will_cause_a_failure_at_runtime));}return 0!==g;function v(t,r,n,a){e.Debug.assert(!!i),s=e.chainDiagnosticMessages(s,t,r,n,a);}function b(t,r,i){var a=En(r),o=En(i);a===o&&(a=En(r,void 0,64),o=En(i,void 0,64)),t||(t=n===tr?e.Diagnostics.Type_0_is_not_comparable_to_type_1:a===o?e.Diagnostics.Type_0_is_not_assignable_to_type_1_Two_different_types_with_this_name_exist_but_they_are_unrelated:e.Diagnostics.Type_0_is_not_assignable_to_type_1),v(t,a,o);}function x(t,r,a,o){if(96&t.flags&&8388608&t.flags&&(t=t.regularType),96&r.flags&&8388608&r.flags&&(r=r.regularType),4194304&t.flags&&(t=n===er?t.typeParameter:t.substitute),4194304&r.flags&&(r=r.typeParameter),t===r)return-1;if(n===rr)return function(e,t){var r,n=e.flags&t.flags;return 65536&n?E(e,t,!1):393216&n&&(r=S(e,t))&&(r&=S(t,e))?r:524288&n?x(e.type,t.type,!1):1048576&n&&(r=x(e.objectType,t.objectType,!1))&&(r&=x(e.indexType,t.indexType,!1))?r:2097152&n&&e.root.isDistributive===t.root.isDistributive&&(r=x(e.checkType,t.checkType,!1))&&(r&=x(e.extendsType,t.extendsType,!1))&&(r&=x(ws(e),ws(t),!1))&&(r&=x(Fs(e),Fs(t),!1))?r:4194304&n?x(e.substitute,t.substitute,!1):0}(t,r);if(n===tr&&!(16384&r.flags)&&wc(r,t,n)||wc(t,r,n,a?v:void 0))return-1;if(Ru(t)&&8388608&t.flags){var c=131072&r.flags?T(t,r):void 0;if(function t(r,a,o,s){if(gp(a,65536)&&!(512&e.getObjectFlags(a))){var c=!!(4096&e.getObjectFlags(r));if((n===Zt||n===er||n===tr)&&(_l(Ne,a)||!c&&Ac(a)))return!1;if(o)return t(r,o,void 0,s);for(var u=function(t){if(!q_(a,t.escapedName,c)){if(s)if(e.Debug.assert(!!i),e.isJsxAttributes(i)||e.isJsxOpeningLikeElement(i))v(e.Diagnostics.Property_0_does_not_exist_on_type_1,Dn(t),En(a));else{var n=r.symbol&&e.firstOrUndefined(r.symbol.declarations),o=void 0;if(t.valueDeclaration&&e.findAncestor(t.valueDeclaration,function(e){return e===n})){var u=t.valueDeclaration;e.Debug.assertNode(u,e.isObjectLiteralElementLike),i=u,e.isIdentifier(u.name)&&(o=td(u.name,a));}void 0!==o?v(e.Diagnostics.Object_literal_may_only_specify_known_properties_but_0_does_not_exist_in_type_1_Did_you_mean_to_write_2,Dn(t),En(a),o):v(e.Diagnostics.Object_literal_may_only_specify_known_properties_and_0_does_not_exist_in_type_1,Dn(t),En(a));}return{value:!0}}},l=0,_=ha(r);l<_.length;l++){var d=_[l],p=u(d);if("object"==typeof p)return p.value}}return!1}(t,r,c,a))return a&&b(o,t,r),0;(function(e){if(!(393216&e.flags))return!1;for(var t=!1,r=0,n=e.types;r<n.length;r++)if(!(12288&n[r].flags)){if(t)return!0;t=!0;}return!1})(r)&&!c&&(t=mu(t));}if(n!==tr&&!(393216&t.flags)&&!(131072&r.flags)&&!m&&t!==Ne&&(xa(t).length>0||Rm(t))&&A(r)&&!function(t,r){for(var n=!!(4096&e.getObjectFlags(t)),i=0,a=xa(t);i<a.length;i++){var o=a[i];if(q_(r,o.escapedName,n))return!0}return!1}(t,r)){if(a){var u=Ka(t,0),l=Ka(t,1);u.length>0&&x(io(u[0]),r,!1)||l.length>0&&x(io(l[0]),r,!1)?v(e.Diagnostics.Value_of_type_0_has_no_properties_in_common_with_type_1_Did_you_mean_to_call_it,En(t),En(r)):v(e.Diagnostics.Type_0_has_no_properties_in_common_with_type_1,En(t),En(r));}return 0}var _=0,d=s,p=m;return m=!1,131072&t.flags?_=n===tr?C(t,r,a&&!(16382&t.flags)):function(e,t,r){for(var n=-1,i=0,a=e.types;i<a.length;i++){var o=a[i],s=x(o,t,r);if(!s)return 0;n&=s;}return n}(t,r,a&&!(16382&t.flags)):(131072&r.flags?_=k(t,r,a&&!(16382&t.flags)&&!(16382&r.flags)):262144&r.flags?(m=!0,_=function(e,t,r){for(var n=-1,i=0,a=t.types;i<a.length;i++){var o=a[i],s=x(e,o,r);if(!s)return 0;n&=s;}return n}(t,r,a)):262144&t.flags&&(_=C(t,r,!1)),!_&&(8355840&t.flags||8355840&r.flags)&&(_=E(t,r,a))&&(s=d)),m=p,!_&&a&&(65536&t.flags&&16382&r.flags?function(t,r){var n=En(t),i=En(r);(Fe===t&&ae===r||Oe===t&&oe===r||Ie===t&&ue===r||Jo(!1)===t&&le===r)&&v(e.Diagnostics._0_is_a_primitive_but_1_is_a_wrapper_object_Prefer_using_0_when_possible,i,n);}(t,r):t.symbol&&65536&t.flags&&Ne===t&&v(e.Diagnostics.The_Object_type_is_assignable_to_very_few_other_types_Did_you_mean_to_use_the_any_type_instead),b(o,t,r)),_}function S(e,t){for(var r=-1,n=0,i=e.types;n<i.length;n++){var a=k(i[n],t,!1);if(!a)return 0;r&=a;}return r}function k(e,t,r){var n=t.types;if(131072&t.flags&&os$$1(n,e))return-1;for(var i=0,a=n;i<a.length;i++){var o=x(e,a[i],!1);if(o)return o}return r&&x(e,T(e,t)||n[n.length-1],!0),0}function T(e,t){var r,n=ha(e);if(n){var i=function(e,t){for(var r,n=0,i=e;n<i.length;n++){var a=i[n];if(Hu(t,a.escapedName)){if(r){r.push(a);continue}r=[a];}}return r}(n,t);if(i)for(var a=0,o=i;a<o.length;a++)for(var s=o[a],c=ui(s),u=0,l=t.types;u<l.length;u++){var _=l[u],d=Jn(_,s.escapedName);if(d&&x(c,d)){if(_===r)continue;if(r)return;r=_;}}}return r}function C(e,t,r){var n=e.types;if(131072&e.flags&&os$$1(n,t))return-1;for(var i=n.length,a=0;a<i;a++){var o=x(n[a],t,r&&a===i-1);if(o)return o}return 0}function E(t,r,i){if(f)return 0;var a=jc(t,r,n),o=n.get(a);if(void 0!==o){if(!i||2!==o)return 1===o?-1:0;n.set(a,3);}if(c){for(var m=0;m<_;m++)if(a===c[m])return 1;if(100===d)return f=!0,0}else c=[],u=[],l=[];var g=_;c[_]=a,_++,u[d]=t,l[d]=r,d++;var y=p;1&p||!qc(t,u,d)||(p|=1),2&p||!qc(r,l,d)||(p|=2);var h=3!==p?function(t,r,i){var a,o,c,u=s;if(32768&r.flags){if(32&e.getObjectFlags(t)&&la(t)===vs(r)&&!(4&pa(t))){var l=_a(t),_=Es(r,ua(t));if(a=x(l,_,i))return a}}else if(524288&r.flags){if(524288&t.flags&&(a=x(r.type,t.type,!1)))return a;var d=N(r.type);if(d&&(a=x(t,vs(d),i)))return a}else if(1048576&r.flags){var d=N(r);if(d&&(a=x(t,d,i)))return s=u,a}else if(ga(r)){var p=_a(r),f=pa(r);if(!(8&f)){if(1048576&p.flags&&p.objectType===t&&p.indexType===ua(r))return-1;if(!ga(t)&&la(r)===vs(t)){var _=Es(t,ua(r)),l=_a(r);if(a=x(_,l,i))return s=u,a}}}if(32768&t.flags){var d=N(t);if(d||!(134217728&r.flags)){(!d||1&d.flags)&&(d=ge);var m=i&&d!==ge;if(a=x(d,r,m))return s=u,a}}else if(1048576&t.flags){var d=N(t);if(d){if(a=x(d,r,i))return s=u,a}else if(1048576&r.flags&&((a=x(t.objectType,r.objectType,i))&&(a&=x(t.indexType,r.indexType,i)),a))return s=u,a}else if(2097152&t.flags){if(2097152&r.flags){if(gc(t.checkType,r.checkType)&&gc(t.extendsType,r.extendsType)&&((a=x(ws(t),ws(r),i))&&(a&=x(Fs(t),Fs(r),i)),a))return s=u,a}else if(n!==er){var g=Da(t);if(g&&(a=x(g,r,i)))return s=u,a;var y=Ta(t);if(y&&(a=x(y,r,i)))return s=u,a}}else{if(4&e.getObjectFlags(t)&&4&e.getObjectFlags(r)&&t.target===r.target&&!(8192&e.getObjectFlags(t)||8192&e.getObjectFlags(r))){var h=Lc(t.target);if(a=function(t,r,i,a){var o=t.typeArguments||e.emptyArray,s=r.typeArguments||e.emptyArray;if(o.length!==s.length&&n===rr)return 0;for(var c=o.length<=s.length?o.length:s.length,u=-1,l=0;l<c;l++){var _=l<i.length?i[l]:1;if(4!==_){var d=o[l],p=s[l],f=-1;if(1===_?f=x(d,p,a):2===_?f=x(p,d,a):3===_?(f=x(p,d,!1))||(f=x(d,p,a)):(f=x(d,p,a))&&(f&=x(p,d,a)),!f)return 0;u&=f;}}return u}(t,r,h,i))return a;if(h!==e.emptyArray&&!function(e,t){for(var r=0;r<t.length;r++)if(1===t[r]&&2048&e.typeArguments[r].flags)return!0;return!1}(r,h)){if(!i||!e.some(h,function(e){return 0===e}))return 0;o=s,s=u;}}var b=!!(16382&t.flags);if(n!==rr&&(t=Oa(t)),327680&t.flags&&65536&r.flags){var S=i&&s===u&&!b;if(c=r,32&e.getObjectFlags(c)&&4&pa(c)&&!ga(t)&&Ac(t)?a=-1:ga(r)?a=ga(t)?function(e,t,r){var i;if((n===tr||(n===rr?pa(e)===pa(t):ma(e)<=ma(t)))&&(i=x(la(t),la(e),r))){var a=Qs([ua(e)],[ua(t)]);return i&x(uc(_a(e),a),_a(t),r)}return 0}(t,r,S):0:(a=function(t,r,i){if(n===rr)return function(e,t){if(!(65536&e.flags&&65536&t.flags))return 0;var r=ha(e),n=ha(t);if(r.length!==n.length)return 0;for(var i=-1,a=0,o=r;a<o.length;a++){var s=o[a],c=va(t,s.escapedName);if(!c)return 0;var u=Vc(s,c,x);if(!u)return 0;i&=u;}return i}(t,r);var a,o,s=!(n!==Yt||Ru(t)||(a=t,o=Xc(a)?a.typeArguments[0]:void 0,o===re||o===fe)),c=Fu(t,r,s);if(c)return i&&v(e.Diagnostics.Property_0_is_missing_in_type_1,Dn(c),En(t)),0;if(Ru(r))for(var u=0,l=xa(t);u<l.length;u++){var _=l[u];if(!va(r,_.escapedName)){var d=ui(_);if(d!==te&&d!==re)return i&&v(e.Diagnostics.Property_0_does_not_exist_on_type_1,Dn(_),En(r)),0}}for(var p=-1,f=0,m=ha(r);f<m.length;f++){var g=m[f];if(!(4194304&g.flags)){var _=Ra(t,g.escapedName);if(_&&_!==g){if(Oc(t,_,ui(g)))continue;var y=e.getDeclarationModifierFlagsFromSymbol(_),h=e.getDeclarationModifierFlagsFromSymbol(g);if(8&y||8&h){if(256&e.getCheckFlags(_))return i&&v(e.Diagnostics.Property_0_has_conflicting_declarations_and_is_inaccessible_in_type_1,Dn(_),En(t)),0;if(_.valueDeclaration!==g.valueDeclaration)return i&&(8&y&&8&h?v(e.Diagnostics.Types_have_separate_declarations_of_a_private_property_0,Dn(g)):v(e.Diagnostics.Property_0_is_private_in_type_1_but_not_in_type_2,Dn(g),En(8&y?t:r),En(8&y?r:t))),0}else if(16&h){if(!Uc(_,g))return i&&v(e.Diagnostics.Property_0_is_protected_but_type_1_is_not_a_class_derived_from_2,Dn(g),En(zc(_)||t),En(zc(g)||r)),0}else if(16&y)return i&&v(e.Diagnostics.Property_0_is_protected_in_type_1_but_public_in_type_2,Dn(g),En(t),En(r)),0;var b=x(ui(_),ui(g),i);if(!b)return i&&v(e.Diagnostics.Types_of_property_0_are_incompatible,Dn(g)),0;if(p&=b,n!==tr&&16777216&_.flags&&!(16777216&g.flags))return i&&v(e.Diagnostics.Property_0_is_optional_in_type_1_but_required_in_type_2,Dn(g),En(t),En(r)),0}}}return p}(t,r,S))&&(a&=P(t,r,0,S))&&(a&=P(t,r,1,S))&&(a&=O(t,r,0,b,S))&&(a&=O(t,r,1,b,S)),a){if(!o)return s=u,a;s=o;}}}return 0}(t,r,i):1;if(p=y,d--,h){if(-1===h||0===d){for(m=g;m<_;m++)n.set(c[m],1);_=g;}}else n.set(a,i?3:2),_=g;return h}function N(e){return n===er?void 0:Sa(e)}function A(t){if(65536&t.flags){var r=ya(t);return 0===r.callSignatures.length&&0===r.constructSignatures.length&&!r.stringIndexInfo&&!r.numberIndexInfo&&r.properties.length>0&&e.every(r.properties,function(e){return!!(16777216&e.flags)})}return!!(262144&t.flags)&&e.every(t.types,A)}function P(t,r,i,a){if(n===rr)return function(e,t,r){var n=Ka(e,r),i=Ka(t,r);if(n.length!==i.length)return 0;for(var a=-1,o=0;o<n.length;o++){var s=Wc(n[o],i[o],!1,!1,!1,x);if(!s)return 0;a&=s;}return a}(t,r,i);if(r===be||t===be)return-1;var o=Ka(t,i),c=Ka(r,i);if(1===i&&o.length&&c.length){if(e.isAbstractConstructorType(t)&&!e.isAbstractConstructorType(r))return a&&v(e.Diagnostics.Cannot_assign_an_abstract_constructor_type_to_a_non_abstract_constructor_type),0;if(!function(t,r,n){if(!t.declaration||!r.declaration)return!0;var i=e.getSelectedModifierFlags(t.declaration,24),a=e.getSelectedModifierFlags(r.declaration,24);return 8===a||(16===a&&8!==i||(16!==a&&!i||(n&&v(e.Diagnostics.Cannot_assign_a_0_constructor_type_to_a_1_constructor_type,Pn(i),Pn(a)),!1)))}(o[0],c[0],a))return 0}var u=-1,l=s;if(64&e.getObjectFlags(t)&&64&e.getObjectFlags(r)&&t.symbol===r.symbol)for(var _=0;_<c.length;_++){if(!(b=w(o[_],c[_],!0,a)))return 0;u&=b;}else if(1===o.length&&1===c.length){var d=n===tr||D.noStrictGenericChecks;u=w(o[0],c[0],d,a);}else e:for(var p=0,f=c;p<f.length;p++){for(var m=f[p],g=a,y=0,h=o;y<h.length;y++){var b;if(b=w(h[y],m,!0,g)){u&=b,s=l;continue e}g=!1;}return g&&v(e.Diagnostics.Type_0_provides_no_match_for_the_signature_1,En(t),Cn(m,void 0,void 0,i)),0}return u}function w(e,t,r,n){return Cc(r?uo(e):e,r?uo(t):t,0,!1,n,v,x)}function F(t,r,n){var i=x(t.type,r.type,n);return!i&&n&&v(e.Diagnostics.Index_signatures_are_incompatible),i}function O(t,r,i,a,o){if(n===rr)return function(e,t,r){var n=za(t,r),i=za(e,r);return i||n?i&&n&&i.isReadonly===n.isReadonly?x(i.type,n.type):0:-1}(t,r,i);var s=za(r,i);if(!s||1&s.type.flags&&!a)return-1;var c=za(t,i)||1===i&&za(t,0);if(c)return F(c,s,o);if(ga(t))return 0===i&&x(_a(t),s.type,o);if(pu(t)){var u=-1;if(0===i){var l=za(t,1);l&&(u=F(l,s,o));}return u&&(u&=function(t,r,n,i){for(var a=-1,o=0,s=ha(t);o<s.length;o++){var c=s[o];if(!Oc(t,c,void 0)){var u=hs(c);if((void 0===u||x(u,ae)||x(u,oe))&&(0===n||b_(c.escapedName))){var l=x(ui(c),r,i);if(!l)return i&&v(e.Diagnostics.Property_0_is_incompatible_with_index_signature,Dn(c)),0;a&=l;}}}return a}(t,s.type,i,o)),u}return o&&v(e.Diagnostics.Index_signature_is_missing_in_type_0,En(t)),0}}function Mc(t,r,n){var i=So(t,e.map(t.typeParameters,function(e){return e===r?n:e}));return i.objectFlags|=8192,i}function Lc(t){if(!w)return e.emptyArray;var r=t.typeParameters||e.emptyArray,n=t.variances;if(!n){if(t===Pe||t===we)n=[1];else{t.variances=e.emptyArray,n=[];for(var i=0,a=r;i<a.length;i++){var o=a[i],s=Mc(t,o,Te),c=Mc(t,o,De),u=(bc(c,s)?1:0)|(bc(s,c)?2:0);3===u&&bc(Mc(t,o,nt),s)&&(u=4),n.push(u);}}t.variances=n;}return n}function Rc(e){return 32768&e.flags&&!ho(e)}function Bc(t){return 4&e.getObjectFlags(t)&&e.some(t.typeArguments,function(e){return Rc(e)||Bc(e)})}function Kc(e,t,r){void 0===r&&(r=0);for(var n=""+e.target.id,i=0,a=e.typeArguments;i<a.length;i++){var o=a[i];if(Rc(o)){var s=t.indexOf(o);s<0&&(s=t.length,t.push(o)),n+="="+s;}else r<4&&Bc(o)?n+="<"+Kc(o,t,r+1)+">":n+="-"+o.id;}return n}function jc(e,t,r){if(r===rr&&e.id>t.id){var n=e;e=t,t=n;}if(Bc(e)&&Bc(t)){var i=[];return Kc(e,i)+","+Kc(t,i)}return e.id+","+t.id}function Jc(t,r){if(!(6&e.getCheckFlags(t)))return r(t);for(var n=0,i=t.containingType.types;n<i.length;n++){var a=Ra(i[n],t.escapedName),o=a&&Jc(a,r);if(o)return o}}function zc(e){return e.parent&&32&e.parent.flags?Fi(an(e)):void 0}function Uc(t,r){return!Jc(r,function(r){return!!(16&e.getDeclarationModifierFlagsFromSymbol(r))&&(n=t,i=zc(r),!Jc(n,function(e){var t=zc(e);return!!t&&di(t,i)}));var n,i;})}function qc(e,t,r){if(r>=5&&65536&e.flags){var n=e.symbol;if(n)for(var i=0,a=0;a<r;a++){var o=t[a];if(65536&o.flags&&o.symbol===n&&++i>=5)return!0}}return!1}function Vc(t,r,n){if(t===r)return-1;var i=24&e.getDeclarationModifierFlagsFromSymbol(t);if(i!==(24&e.getDeclarationModifierFlagsFromSymbol(r)))return 0;if(i){if(am(t)!==am(r))return 0}else if((16777216&t.flags)!=(16777216&r.flags))return 0;return dp(t)!==dp(r)?0:n(ui(t),ui(r))}function Wc(t,r,n,i,a,o){if(t===r)return-1;if(!function(e,t,r){if(e.parameters.length===t.parameters.length&&e.minArgumentCount===t.minArgumentCount&&e.hasRestParameter===t.hasRestParameter)return!0;var n=e.hasRestParameter?1:0,i=t.hasRestParameter?1:0;return!!(r&&e.minArgumentCount<=t.minArgumentCount&&(n>i||n===i&&e.parameters.length>=t.parameters.length))}(t,r,n))return 0;if(e.length(t.typeParameters)!==e.length(r.typeParameters))return 0;t=uo(t),r=uo(r);var s=-1;if(!i){var c=to(t);if(c){var u=to(r);if(u){if(!(d=o(c,u)))return 0;s&=d;}}}for(var l=r.parameters.length,_=0;_<l;_++){var d;if(!(d=o(Hc(t,_)?ao(t):Yd(t.parameters[_]),Hc(r,_)?ao(r):Yd(r.parameters[_]))))return 0;s&=d;}if(!a){var p=no(t),f=no(r);s&=void 0!==p||void 0!==f?function(e,t,r){return void 0!==e&&void 0!==t&&ps(e,t)?r(e.type,t.type):0}(p,f,o):o(io(t),io(r));}return s}function Hc(e,t){return e.hasRestParameter&&t>=e.parameters.length-1}function Gc(t){return function(e){for(var t,r=0,n=e;r<n.length;r++){var i=n[r],a=tu(i);if(t||(t=a),a===i||a!==t)return!1}return!0}(t)?ds(t):e.reduceLeft(t,function(e,t){return vc(e,t)?t:e})}function $c(t){return e.reduceLeft(t,function(e,t){return vc(t,e)?t:e})}function Xc(t){return 4&e.getObjectFlags(t)&&t.target===Pe}function Qc(t){return 4&e.getObjectFlags(t)&&(t.target===Pe||t.target===we)||!(12288&t.flags)&&bc(t,Ke)}function Yc(e){return!!Ra(e,"0")}function Zc(e){return!!(13536&e.flags)}function eu(t){return!!(8&t.flags)||(131072&t.flags?!!(256&t.flags)||!e.forEach(t.types,function(e){return!Zc(e)}):Zc(t))}function tu(t){return 256&t.flags?Ni(t):32&t.flags?ae:64&t.flags?oe:128&t.flags?ue:131072&t.flags?ds(e.sameMap(t.types,tu)):t}function ru(t){return 256&t.flags?Ni(t):32&t.flags&&8388608&t.flags?ae:64&t.flags&&8388608&t.flags?oe:128&t.flags?ue:131072&t.flags?ds(e.sameMap(t.types,ru)):t}function nu(t){return 1024&t.flags?le:131072&t.flags?ds(e.sameMap(t.types,nu)):t}function iu(t,r){return function t(r,n){if(n){if(393216&n.flags){var i=n.types;return e.some(i,function(e){return t(r,e)})}if(7372800&n.flags){var a=Ea(n)||ge;return 2&a.flags&&gp(r,32)||4&a.flags&&gp(r,64)||8&a.flags&&gp(r,128)||512&a.flags&&gp(r,1024)||t(r,a)}return 524320&n.flags&&gp(r,32)||64&n.flags&&gp(r,64)||128&n.flags&&gp(r,128)||1024&n.flags&&gp(r,1024)}return!1}(t,r)||(t=nu(ru(t))),t}function au(t){return!!(4&e.getObjectFlags(t)&&8&t.target.objectFlags)}function ou(e){for(var t=0,r=0,n=e;r<n.length;r++)t|=su(n[r]);return t}function su(e){return 131072&e.flags?ou(e.types):32&e.flags?""===e.value?32:0:64&e.flags?0===e.value?64:0:128&e.flags?e===ce?128:0:14574&e.flags}function cu(e){return 14560&su(e)?pl(e,function(e){return!(14560&su(e))}):e}function uu(e){return 2&e.flags?yt:4&e.flags?ht:8&e.flags||e===ce?ce:14336&e.flags||32&e.flags&&""===e.value||64&e.flags&&0===e.value?e:de}function lu(e,t){var r=t&~e.flags&12288;return 0===r?e:ds(4096===r?[e,te]:8192===r?[e,ne]:[e,te,ne])}function _u(t){return e.Debug.assert(P),4096&t.flags?t:ds([t,te])}function du(e){return P?function(e){return je||(je=Bo("NonNullable",524288,void 0)||$),je!==$?Co(je,[e]):Qu(e,524288)}(e):e}function pu(e){return e.symbol&&0!=(6656&e.symbol.flags)&&!Rm(e)}function fu(e,t){var r=cr(e.flags,e.escapedName);return r.declarations=e.declarations,r.parent=e.parent,r.type=t,r.target=e,e.valueDeclaration&&(r.valueDeclaration=e.valueDeclaration),r}function mu(t){if(!(Ru(t)&&8388608&t.flags))return t;var r=t.regularType;if(r)return r;var n=t,i=function(t,r){for(var n=e.createSymbolTable(),i=0,a=ha(t);i<a.length;i++){var o=a[i],s=ui(o),c=r(s);n.set(o.escapedName,c===s?o:fu(o,c));}return n}(t,mu),a=mn(n.symbol,i,n.callSignatures,n.constructSignatures,n.stringIndexInfo,n.numberIndexInfo);return a.flags=-8388609&n.flags,a.objectFlags|=128,t.regularType=a,a}function gu(e,t,r){return{parent:e,propertyName:t,siblings:r,resolvedPropertyNames:void 0}}function yu(t){if(!t.resolvedPropertyNames){for(var r=e.createMap(),n=0,i=function e(t){if(!t.siblings){for(var r=[],n=0,i=e(t.parent);n<i.length;n++){var a=i[n];if(Ru(a)){var o=va(a,t.propertyName);o&&dl(ui(o),function(e){r.push(e);});}}t.siblings=r;}return t.siblings}(t);n<i.length;n++){var a=i[n];if(Ru(a)&&!(1024&e.getObjectFlags(a)))for(var o=0,s=xa(a);o<s.length;o++){var c=s[o];r.set(c.escapedName,!0);}}t.resolvedPropertyNames=e.arrayFrom(r.keys());}return t.resolvedPropertyNames}function hu(e,t){var r=ui(e),n=xu(r,t&&gu(t,e.escapedName,void 0));return n===r?e:fu(e,n)}function vu(t){var r=G.get(t);if(r)return r;var n=cr(16777220,t);n.type=te;var i=qs(e.unescapeLeadingUnderscores(t));return 32&i.flags&&(n.nameType=i),G.set(t,n),n}function bu(e){return xu(e,void 0)}function xu(t,r){if(50331648&t.flags){if(12288&t.flags)return Q;if(Ru(t))return function(t,r){for(var n=e.createSymbolTable(),i=0,a=ha(t);i<a.length;i++){var o=a[i];n.set(o.escapedName,4&o.flags?hu(o,r):o);}if(r)for(var s=0,c=yu(r);s<c.length;s++){var u=c[s];n.has(u)||n.set(u,vu(u));}var l=za(t,0),_=za(t,1);return mn(t.symbol,n,e.emptyArray,e.emptyArray,l&&go(bu(l.type),l.isReadonly),_&&go(bu(_.type),_.isReadonly))}(t,r);if(131072&t.flags){var n=r||gu(void 0,void 0,t.types),i=e.sameMap(t.types,function(e){return 12288&e.flags?e:xu(e,n)});return ds(i,e.some(i,Ac)?2:1)}if(Xc(t)||au(t))return So(t.target,e.sameMap(t.typeArguments,bu))}return t}function Su(t,r){var n,i=En(bu(r));switch(t.kind){case 151:case 150:n=e.Diagnostics.Member_0_implicitly_has_an_1_type;break;case 148:n=t.dotDotDotToken?e.Diagnostics.Rest_parameter_0_implicitly_has_an_any_type:e.Diagnostics.Parameter_0_implicitly_has_an_1_type;break;case 180:n=e.Diagnostics.Binding_element_0_implicitly_has_an_1_type;break;case 232:case 153:case 152:case 155:case 156:case 190:case 191:if(!t.name)return void sr(t,e.Diagnostics.Function_expression_which_lacks_return_type_annotation_implicitly_has_an_0_return_type,i);n=e.Diagnostics._0_which_lacks_return_type_annotation_implicitly_has_an_1_return_type;break;case 176:return void sr(t,e.Diagnostics.Mapped_object_type_implicitly_has_an_any_template_type);default:n=e.Diagnostics.Variable_0_implicitly_has_an_1_type;}sr(t,n,e.declarationNameToString(e.getNameOfDeclaration(t)),i);}function ku(t,r){a&&O&&16777216&r.flags&&(function t(r){var n=!1;if(16777216&r.flags){if(131072&r.flags)if(e.some(r.types,Ac))n=!0;else for(var i=0,a=r.types;i<a.length;i++)t(l=a[i])&&(n=!0);if(Xc(r)||au(r))for(var o=0,s=r.typeArguments;o<s.length;o++)t(l=s[o])&&(n=!0);if(Ru(r))for(var c=0,u=ha(r);c<u.length;c++){var l,_=u[c];16777216&(l=ui(_)).flags&&(t(l)||sr(_.valueDeclaration,e.Diagnostics.Object_literal_s_property_0_implicitly_has_an_1_type,Dn(_),En(bu(l))),n=!0);}}return n}(r)||Su(t,r));}function Tu(e,t,r){var n,i=e.parameters.length,a=t.parameters.length;n=e.hasRestParameter&&t.hasRestParameter?Math.max(i,a):e.hasRestParameter?a:t.hasRestParameter?i:Math.min(i,a);for(var o=0;o<n;o++)r(Zd(e,o),Zd(t,o));}function Du(e,t,r,n,i){var a=i?i.map(Eu):e.map(Cu),o=function(e){for(var t=0;t<a.length;t++)if(e===a[t].typeParameter)return a[t].isFixed=!0,Bu(o,t);return e};return o.typeParameters=e,o.signature=t,o.inferences=a,o.flags=r,o.compareTypes=n||hc,o}function Cu(e){return{typeParameter:e,candidates:void 0,contraCandidates:void 0,inferredType:void 0,priority:void 0,topLevel:!0,isFixed:!1}}function Eu(e){return{typeParameter:e.typeParameter,candidates:e.candidates&&e.candidates.slice(),contraCandidates:e.contraCandidates&&e.contraCandidates.slice(),inferredType:e.inferredType,priority:e.priority,topLevel:e.topLevel,isFixed:e.isFixed}}function Nu(t){var r=e.getObjectFlags(t);return!!(7897088&t.flags||4&r&&e.forEach(t.typeArguments,Nu)||16&r&&t.symbol&&10288&t.symbol.flags||32&r||393216&t.flags&&function(t){return void 0===t.couldContainTypeVariables&&(t.couldContainTypeVariables=e.forEach(t.types,Nu)),t.couldContainTypeVariables}(t))}function Au(t,r){return t===r||393216&t.flags&&e.forEach(t.types,function(e){return Au(e,r)})}function Pu(e,t){var r=e.id+","+t.id;if(dt.has(r))return dt.get(r);dt.set(r,void 0);var n=function(e,t){var r=xa(e);if(0!==r.length||za(e,0)){for(var n=0,i=r;n<i.length;n++){var a=i[n];if(67108864&ui(a).flags)return}var o=_n(2064,void 0);return o.source=e,o.mappedType=t,o}}(e,t);return dt.set(r,n),n}function wu(e,t){var r=Es(la(t).type,ua(t)),n=_a(t),i=Cu(r);return Iu([i],e,n),Ou(i)}function Fu(e,t,r){for(var n=0,i=262144&t.flags?ba(t):ha(t);n<i.length;n++){var a=i[n];if((r||!(16777216&a.flags))&&!Ra(e,a.escapedName))return a}}function Ou(e){return e.candidates?ds(e.candidates,2):e.contraCandidates?ys(e.contraCandidates):ge}function Iu(t,r,n,i){var a,o;void 0===i&&(i=0);var s,c=!1;function u(t,r){if(Nu(r)){if(1&t.flags){var p=s;return s=t,u(r,r),void(s=p)}if(t.aliasSymbol&&t.aliasTypeArguments&&t.aliasSymbol===r.aliasSymbol)for(var f=t.aliasTypeArguments,m=r.aliasTypeArguments,g=0;g<f.length;g++)u(f[g],m[g]);else{if(131072&t.flags&&131072&r.flags&&!(256&t.flags&&256&r.flags)||262144&t.flags&&262144&r.flags){if(t===r){for(var y=0,h=t.types;y<h.length;y++)u(F=h[y],F);return}for(var v=void 0,b=0,x=t.types;b<x.length;b++)if(Mu(F=x[b],r.types))(v||(v=[])).push(F),u(F,F);else if(96&F.flags){var S=tu(F);Mu(S,r.types)&&(v||(v=[])).push(F,S);}v&&(t=Lu(t,v),r=Lu(r,v));}if(1081344&r.flags){if(67108864&t.flags||t===pe)return;var k=_(r);if(k){if(!k.isFixed){if((void 0===k.priority||i<k.priority)&&(k.candidates=void 0,k.contraCandidates=void 0,k.priority=i),i===k.priority){var T=s||t;c?k.contraCandidates=e.append(k.contraCandidates,T):k.candidates=e.append(k.candidates,T);}8&i||!(32768&r.flags)||Au(n,r)||(k.topLevel=!1);}return}}if(4&e.getObjectFlags(t)&&4&e.getObjectFlags(r)&&t.target===r.target){f=t.typeArguments||e.emptyArray,m=r.typeArguments||e.emptyArray;var D=f.length<m.length?f.length:m.length,C=Lc(t.target);for(g=0;g<D;g++)g<C.length&&2===C[g]?l(f[g],m[g]):u(f[g],m[g]);}else if(524288&t.flags&&524288&r.flags)c=!c,u(t.type,r.type),c=!c;else if((eu(t)||2&t.flags)&&524288&r.flags){var E=function(t){var r=e.createSymbolTable();dl(t,function(t){if(32&t.flags){var n=e.escapeLeadingUnderscores(t.value),i=cr(4,n);i.type=Q,t.symbol&&(i.declarations=t.symbol.declarations,i.valueDeclaration=t.symbol.valueDeclaration),r.set(n,i);}});var n=2&t.flags?go(ge,!1):void 0;return mn(void 0,r,e.emptyArray,e.emptyArray,n,void 0)}(t);c=!c,u(E,r.type),c=!c;}else if(1048576&t.flags&&1048576&r.flags)u(t.objectType,r.objectType),u(t.indexType,r.indexType);else if(2097152&t.flags&&2097152&r.flags)u(t.checkType,r.checkType),u(t.extendsType,r.extendsType),u(ws(t),ws(r)),u(Fs(t),Fs(r));else if(393216&r.flags){for(var N=0,A=void 0,P=0,w=m=r.types;P<w.length;P++){var F;_(F=w[P])?(A=F,N++):u(t,F);}if(1===N){var O=i;i|=1,u(t,A),i=O;}}else if(131072&t.flags)for(var I=0,M=f=t.types;I<M.length;I++)u(M[I],r);else if(16&i&&8159232&t.flags||(t=Oa(t)),327680&t.flags){var L=t.id+","+r.id;if(o&&o.get(L))return;(o||(o=e.createMap())).set(L,!0);var R=65536&r.flags&&!(16&e.getObjectFlags(r)&&r.symbol&&32&r.symbol.flags)?r.symbol:void 0;if(R){if(e.contains(a,R))return;(a||(a=[])).push(R),d(t,r),a.pop();}else d(t,r);}}}}function l(e,t){w||32&i?(c=!c,u(e,t),c=!c):u(e,t);}function _(e){if(1081344&e.flags)for(var r=0,n=t;r<n.length;r++){var i=n[r];if(e===i.typeParameter)return i}}function d(t,r){if(ga(t)&&ga(r)&&(u(la(t),la(r)),u(_a(t),_a(r))),32&e.getObjectFlags(r)){var n=la(r);if(524288&n.flags){var a=_(n.type);if(a&&!a.isFixed){var o=Pu(t,r);if(o){var s=i;i|=2,u(o,a.typeParameter),i=s;}}return}if(32768&n.flags)return s=i,i|=4,u(vs(t),n),i=s,void u(ds(e.map(xa(t),ui)),_a(r))}Fu(t,r,!1)&&Fu(r,t,!1)||(function(e,t){for(var r=0,n=ha(t);r<n.length;r++){var i=n[r],a=Ra(e,i.escapedName);a&&u(ui(a),ui(i));}}(t,r),p(t,r,0),p(t,r,1),function(e,t){var r=Ua(t,0);if(r){var n=Ua(e,0)||qa(e,0);n&&u(n,r);}var i=Ua(t,1);if(i){var n=Ua(e,1)||Ua(e,0)||qa(e,1);n&&u(n,i);}}(t,r));}function p(e,t,r){for(var n=Ka(e,r),i=Ka(t,r),a=n.length,o=i.length,s=a<o?a:o,c=0;c<s;c++)f(_o(n[a-s+c]),_o(i[o-s+c]));}function f(e,t){Tu(e,t,l);var r=no(e),n=no(t);r&&n&&r.kind===n.kind?u(r.type,n.type):u(io(e),io(t));}u(r,n);}function Mu(e,t){for(var r=0,n=t;r<n.length;r++)if(gc(n[r],e))return!0;return!1}function Lu(e,t){for(var r=[],n=0,i=e.types;n<i.length;n++){var a=i[n];Mu(a,t)||r.push(a);}return 131072&e.flags?ds(r):ys(r)}function Ru(t){return!!(128&e.getObjectFlags(t))}function Bu(t,r){var n=t.inferences[r],i=n.inferredType;if(!i){var a=t.signature;if(a)if(n.candidates){var o=function(t){if(t.length>1){var r=e.filter(t,Ru);if(r.length){var n=bu(ds(r,2));return e.concatenate(e.filter(t,function(e){return!Ru(e)}),[n])}}return t}(n.candidates),s=!n.topLevel||function(e){var t=ka(e);return t&&gp(t,540670)}(n.typeParameter)||!n.isFixed&&Au(io(a),n.typeParameter)?o:e.sameMap(o,ru);16384&(i=bu(1&t.flags||12&n.priority?ds(s,2):function(t){if(!P)return Gc(t);var r=e.filter(t,function(e){return!(12288&e.flags)});return r.length?lu(Gc(r),12288&ou(t)):ds(t,2)}(s))).flags&&n.contraCandidates&&(i=$c(n.contraCandidates));}else if(n.contraCandidates)i=$c(n.contraCandidates);else if(2&t.flags)i=pe;else{var c=Fa(n.typeParameter);i=c?uc(c,Zs(function(e,t){return function(r){return e.indexOf(r)>=t?ge:r}}(t.signature.typeParameters,r),t)):Ku(!!(4&t.flags));}else i=Ou(n);i=nu(i),n.inferredType=i;var u=ka(n.typeParameter);if(u){var l=uc(u,t);t.compareTypes(i,Xi(l,i))||(n.inferredType=i=nu(l));}}return i}function Ku(e){return e?Q:ge}function ju(e){for(var t=[],r=0;r<e.inferences.length;r++)t.push(Bu(e,r));return t}function Ju(t){var r=yr(t);return r.resolvedSymbol||(r.resolvedSymbol=!e.nodeIsMissing(t)&&xr(t,t.escapedText,68264895,e.Diagnostics.Cannot_find_name_0,t,!e.isWriteOnlyAccess(t),!1,e.Diagnostics.Cannot_find_name_0_Did_you_mean_1)||$),r.resolvedSymbol}function zu(t){return!!e.findAncestor(t,function(e){return 164===e.kind||71!==e.kind&&145!==e.kind&&"quit"})}function Uu(t){if(178!==t.parent.kind)return""+t.parent.elements.indexOf(t);var r=t.propertyName||t.name;switch(r.kind){case 71:return e.idText(r);case 146:return e.isStringOrNumericLiteral(r.expression)?r.expression.text:void 0;case 9:case 8:return r.text;default:e.Debug.fail("Unexpected name kind for binding element name");}}function qu(e,t){switch(e.kind){case 71:return 71===t.kind&&Ju(e)===Ju(t)||(230===t.kind||180===t.kind)&&on$$1(Ju(e))===nn(t);case 99:return 99===t.kind;case 97:return 97===t.kind;case 183:return 183===t.kind&&e.name.escapedText===t.name.escapedText&&qu(e.expression,t.expression);case 180:if(183!==t.kind)return!1;var r=t;if(r.name.escapedText!==Uu(e))return!1;if(180===e.parent.parent.kind&&qu(e.parent.parent,r.expression))return!0;if(230===e.parent.parent.kind){var n=e.parent.parent.initializer;return n&&qu(n,r.expression)}}return!1}function Vu(e,t){for(;183===e.kind;)if(qu(e=e.expression,t))return!0;return!1}function Wu(e,t){return 183===t.kind&&Vu(e,t.expression)&&Hu(function e(t){if(71===t.kind)return ui(Ju(t));if(183===t.kind){var r=e(t.expression);return r&&Jn(r,t.name.escapedText)}}(t.expression),t.name.escapedText)}function Hu(t,r){if(t&&131072&t.flags){var n=Ma(t,r);if(n&&2&e.getCheckFlags(n))return void 0===n.isDiscriminantProperty&&(n.isDiscriminantProperty=32&n.checkFlags&&eu(ui(n))),n.isDiscriminantProperty}return!1}function Gu(e,t){return qu(e,t)||Vu(e,t)}function $u(e,t){if(e!==t){if(16384&t.flags)return t;var r=pl(e,function(e){return function(e,t){if(!(131072&e.flags))return bc(e,t);for(var r=0,n=e.types;r<n.length;r++)if(bc(n[r],t))return!0;return!1}(t,e)});if(!(16384&r.flags))return r}return e}function Xu(e){var t=e.flags;if(2&t)return P?4079361:4194049;if(32&t){var r=""===e.value;return P?r?3030785:1982209:r?3145473:4194049}if(20&t)return P?4079234:4193922;if(64&t){var n=0===e.value;return P?n?3030658:1982082:n?3145346:4193922}return 8&t?P?4078980:4193668:136&t?P?e===ce?3030404:1981828:e===ce?3145092:4193668:65536&t?function(e){var t=ya(e);return!!(t.callSignatures.length||t.constructSignatures.length||t.members.get("bind")&&vc(e,Ae))}(e)?P?1970144:4181984:P?1972176:4184016:6144&t?2457472:8192&t?2340752:1536&t?P?1981320:4193160:134217728&t?P?1972176:4184016:7897088&t?Xu(Ea(e)||ge):393216&t?function(e){for(var t=0,r=0,n=e;r<n.length;r++)t|=Xu(n[r]);return t}(e.types):4194303}function Qu(e,t){return pl(e,function(e){return 0!=(Xu(e)&t)})}function Yu(e,t){if(t){var r=Lp(t);return ds([Qu(e,131072),r])}return e}function Zu(t,r){var n=e.getTextOfPropertyName(r);return Jn(t,n)||b_(n)&&Ua(t,1)||Ua(t,0)||ee}function el(e,t){return Yc(e)&&Jn(e,""+t)||Uf(e,void 0,!1,!1)||ee}function tl(e){return rs(Uf(e,void 0,!1,!1)||ee)}function rl(e){return 198===e.parent.kind&&e.parent.left===e||220===e.parent.kind&&e.parent.initializer===e}function nl(e){return Zu(il(e.parent),e.name)}function il(e){var t=e.parent;switch(t.kind){case 219:return ae;case 220:return zf(t.expression,t.awaitModifier)||ee;case 198:return function(e){return 181===e.parent.kind&&rl(e.parent)||268===e.parent.kind&&rl(e.parent.parent)?Yu(il(e),e.right):Lp(e.right)}(t);case 192:return te;case 181:return function(e,t){return el(il(e),e.elements.indexOf(t))}(t,e);case 202:return function(e){return tl(il(e.parent))}(t);case 268:return nl(t);case 269:return function(e){return Yu(nl(e),e.objectAssignmentInitializer)}(t)}return ee}function al(e){return e.initializer?function(e){return yr(e).resolvedType||Lp(e)}(e.initializer):219===e.parent.parent.kind?ae:220===e.parent.parent.kind&&zf(e.parent.parent.expression,e.parent.parent.awaitModifier)||ee}function ol(e){return 230===e.kind?al(e):function(e){var t=e.parent,r=ol(t.parent);return Yu(178===t.kind?Zu(r,e.propertyName||e.name):e.dotDotDotToken?tl(r):el(r,t.elements.indexOf(e)),e.initializer)}(e)}function sl(e){return 230===e.kind||180===e.kind?ol(e):il(e)}function cl(e){switch(e.kind){case 189:return cl(e.expression);case 198:switch(e.operatorToken.kind){case 58:return cl(e.left);case 26:return cl(e.right)}}return e}function ul(e){if(264===e.kind){var t=Us(Lp(e.expression));return Zc(t)?t:void 0}return de}function ll(t){var r=yr(t);if(!r.switchTypes){r.switchTypes=[];for(var n=0,i=t.caseBlock.clauses;n<i.length;n++){var a=ul(i[n]);if(void 0===a)return r.switchTypes=e.emptyArray;r.switchTypes.push(a);}}return r.switchTypes}function _l(e,t){return e===t||131072&t.flags&&function(e,t){if(131072&e.flags){for(var r=0,n=e.types;r<n.length;r++){var i=n[r];if(!os$$1(t.types,i))return!1}return!0}return!!(256&e.flags&&Ni(e)===t)||os$$1(t.types,e)}(e,t)}function dl(t,r){return 131072&t.flags?e.forEach(t.types,r):r(t)}function pl(t,r){if(131072&t.flags){var n=t.types,i=e.filter(n,r);return i===n?t:fs$$1(i)}return r(t)?t:de}function fl(e,t,r){if(16384&e.flags)return e;if(!(131072&e.flags))return t(e);for(var n,i,a=0,o=e.types;a<o.length;a++){var s=t(o[a]);s&&(n?i?i.push(s):i=[n,s]:n=s);}return i?ds(i,r?0:1):n}function ml(e,t){return pl(e,function(e){return 0!=(e.flags&t)})}function gl(e,t){return _l(ae,e)&&gp(t,32)||_l(oe,e)&&gp(t,64)?fl(e,function(e){return 2&e.flags?ml(t,34):4&e.flags?ml(t,68):e}):e}function yl(e){return 0===e.flags}function hl(e){return 0===e.flags?e.type:e}function vl(e,t){return t?{flags:0,type:e}:e}function bl(e){return H[e.id]||(H[e.id]=function(e){var t=_n(256);return t.elementType=e,t}(e))}function xl(e,t){var r=tu(function(e){var t=e.contextualType;e.contextualType=Q;var r=Lp(e);return e.contextualType=t,r}(t));return _l(r,e.elementType)?e:bl(ds([e.elementType,r]))}function Sl(e){return e.finalArrayType||(e.finalArrayType=16384&(t=e.elementType).flags?Be:rs(131072&t.flags?ds(t.types,2):t));var t;}function kl(t){return 256&e.getObjectFlags(t)?Sl(t):t}function Tl(t){return 256&e.getObjectFlags(t)?t.elementType:de}function Dl(t,r){return function(t){for(var r=!1,n=0,i=t;n<i.length;n++){var a=i[n];if(!(16384&a.flags)){if(!(256&e.getObjectFlags(a)))return!1;r=!0;}}return r}(t)?bl(ds(e.map(t,Tl))):ds(e.sameMap(t,kl),r)}function Cl(t){var r=function e(t){var r=t.parent;return 189===r.kind||198===r.kind&&58===r.operatorToken.kind&&r.left===t||198===r.kind&&26===r.operatorToken.kind&&r.right===t?e(r):t}(t),n=r.parent,i=183===n.kind&&("length"===n.name.escapedText||185===n.parent.kind&&e.isPushOrUnshiftIdentifier(n.name)),a=184===n.kind&&n.expression===r&&198===n.parent.kind&&58===n.parent.operatorToken.kind&&n.parent.left===n&&!e.isAssignmentTarget(n.parent)&&yp(Lp(n.argumentExpression),84);return i||a}function El(t){var r=yr(t);return void 0===r.maybeTypePredicate&&(r.maybeTypePredicate=function(t){if(97!==t.expression.kind){var r=$_(t.expression);if(r!==pe){var n=Oa(r);return n!==ee&&e.some(Ka(n,0),ro)}}return!1}(t)),r.maybeTypePredicate}function Nl(t,r,n,i,a){var o;void 0===n&&(n=r);var c=0;if(gt)return ee;if(!t.flowNode||!a&&!(142575359&r.flags))return r;var l=mt,_=hl(p(t.flowNode));mt=l;var d=256&e.getObjectFlags(_)&&Cl(t)?Re:kl(_);return t.parent&&207===t.parent.kind&&16384&Qu(d,524288).flags?r:d;function p(a){if(2500===c)return gt=!0,o=t,s=e.findAncestor(o,e.isFunctionOrModuleBlock),u=e.getSourceFileOfNode(o),_=e.getSpanOfTokenAtPosition(u,s.statements.pos),Lt.add(e.createFileDiagnostic(u,_.start,_.length,e.Diagnostics.The_containing_function_or_module_body_is_too_large_for_control_flow_analysis)),ee;var o,s,u,_;for(c++;;){var d=a.flags;if(1024&d)for(var b=l;b<mt;b++)if(wt[b]===a)return c--,Ft[b];var x=void 0;if(4096&d)a.locked=!0,x=p(a.antecedent),a.locked=!1;else{if(2048&d){a=a.antecedent;continue}if(16&d){if(!(x=f(a))){a=a.antecedent;continue}}else if(96&d)x=g(a);else if(128&d)x=y(a);else if(12&d){if(1===a.antecedents.length){a=a.antecedents[0];continue}x=4&d?h(a):v(a);}else if(256&d){if(!(x=m(a))){a=a.antecedent;continue}}else if(2&d){var S=a.container;if(S&&S!==i&&183!==t.kind&&99!==t.kind){a=S.flowNode;continue}x=n;}else x=If(r);}return 1024&d&&(wt[mt]=a,Ft[mt]=x,mt++),c--,x}}function f(n){var i=n.node;if(qu(t,i)){if(2===e.getAssignmentTargetKind(i)){var a=p(n.antecedent);return vl(tu(hl(a)),yl(a))}if(r===Y||r===Be){if(function(e){return 230===e.kind&&e.initializer&&Gn(e.initializer)||180!==e.kind&&198===e.parent.kind&&Gn(e.parent.right)}(i))return bl(de);var o=tu(sl(i));return bc(o,r)?o:Re}return 131072&r.flags?$u(r,sl(i)):r}if(Vu(t,i))return r}function m(n){if(r===Y||r===Be){var i=n.node,a=185===i.kind?i.expression.expression:i.left.expression;if(qu(t,cl(a))){var o=p(n.antecedent),s=hl(o);if(256&e.getObjectFlags(s)){var c=s;if(185===i.kind)for(var u=0,l=i.arguments;u<l.length;u++)c=xl(c,l[u]);else yp(Lp(i.left.argumentExpression),84)&&(c=xl(c,i.right));return c===s?o:vl(c,yl(o))}return o}}}function g(e){var t=p(e.antecedent),r=hl(t);if(16384&r.flags)return t;var n=0!=(32&e.flags),i=kl(r),a=w(i,e.expression,n);if(a===i)return t;var o=yl(t);return vl(o&&16384&a.flags?pe:a,o)}function y(e){var r=p(e.antecedent),n=hl(r),i=e.switchStatement.expression;return qu(t,i)?n=E(n,e.switchStatement,e.clauseStart,e.clauseEnd):b(i,n)&&(n=x(n,i,function(t){return E(t,e.switchStatement,e.clauseStart,e.clauseEnd)})),vl(n,yl(r))}function h(t){for(var i=[],a=!1,o=!1,s=0,c=t.antecedents;s<c.length;s++){var u=c[s];if(!(2048&u.flags&&u.lock.locked)){var l=p(u),_=hl(l);if(_===r&&r===n)return _;e.pushIfUnique(i,_),_l(_,r)||(a=!0),yl(l)&&(o=!0);}}return vl(Dl(i,a?2:1),o)}function v(n){var i=function(e){return e.id||(e.id=s,s++),e.id}(n),a=Et[i]||(Et[i]=e.createMap());if(!o&&!(o=function t(r){if(71===r.kind){var n=Ju(r);return n!==$?(Ol(r)?"@":"")+u(n):void 0}if(99===r.kind)return"0";if(183===r.kind)return(a=t(r.expression))&&a+"."+e.idText(r.name);if(180===r.kind){var i=r.parent.parent,a=180===i.kind?t(i):i.initializer&&t(i.initializer),o=Uu(r);return a&&o&&a+"."+o}}(t)))return r;var c=a.get(o);if(c)return c;for(var l=pt;l<ft;l++)if(Nt[l]===n&&At[l]===o&&Pt[l].length)return vl(Dl(Pt[l],1),!0);var _,d=[],f=!1;Nt[ft]=n,At[ft]=o,Pt[ft]=d;for(var m=0,g=n.antecedents;m<g.length;m++){var y=g[m];ft++;var h=p(y);ft--,_||(_=h);var v=hl(h),b=a.get(o);if(b)return b;if(e.pushIfUnique(d,v),_l(v,r)||(f=!0),v===r)break}var x=Dl(d,f?2:1);return yl(_)?vl(x,!0):(a.set(o,x),x)}function b(e,r){return 183===e.kind&&131072&r.flags&&qu(t,e.expression)&&Hu(r,e.name.escapedText)}function x(e,t,r){var n=t.name.escapedText,i=Jn(e,n),a=i&&r(i);return i===a?e:pl(e,function(e){return Sc(Jn(e,n),a)})}function S(e,n,i){return qu(t,n)?Qu(e,i?1048576:2097152):b(n,r)?x(e,n,function(e){return Qu(e,i?1048576:2097152)}):Wu(t,n)?r:e}function k(t,r,n){if(196608&t.flags||32768&t.flags&&t.isThisType){var i=e.escapeLeadingUnderscores(r.text);return pl(t,function(e){return function(e,t,r){if(za(e,0))return!0;var n=Ra(e,t);return n?!!(16777216&n.flags)||r:!r}(e,i,n)})}return t}function T(n,i,a){switch(i.operatorToken.kind){case 58:return S(n,i.left,a);case 32:case 33:case 34:case 35:var o=i.operatorToken.kind,s=cl(i.left),c=cl(i.right);if(193===s.kind&&e.isStringLiteralLike(c))return C(n,s,o,c,a);if(193===c.kind&&e.isStringLiteralLike(s))return C(n,c,o,s,a);if(qu(t,s))return D(n,o,c,a);if(qu(t,c))return D(n,o,s,a);if(b(s,r))return x(n,s,function(e){return D(e,o,c,a)});if(b(c,r))return x(n,c,function(e){return D(e,o,s,a)});if(Wu(t,s)||Wu(t,c))return r;break;case 93:return function(n,i,a){var o=cl(i.left);if(!qu(t,o))return Vu(t,o)?r:n;var s,c=Lp(i.right);if(!vc(c,Ae))return n;var u=Ra(c,"prototype");if(u){var l=ui(u);zn(l)||(s=l);}if(zn(n)&&(s===Ne||s===Ae))return n;if(!s){var _=void 0;2&e.getObjectFlags(c)?_=ji(c).declaredConstructSignatures:16&e.getObjectFlags(c)&&(_=Ka(c,1)),_&&_.length&&(s=ds(e.map(_,function(e){return io(uo(e))})));}return s?N(n,s,a,xc):n}(n,i,a);case 92:var u=cl(i.right);if(e.isStringLiteralLike(i.left)&&qu(t,u))return k(n,i.left,a);break;case 26:return w(n,i.right,a)}return n}function D(e,t,r,n){if(1&e.flags)return e;33!==t&&35!==t||(n=!n);var i=Lp(r);if(12288&i.flags)return P?Qu(e,32===t||33===t?n?65536:524288:95===r.kind?n?32768:262144:n?16384:131072):e;if(134283777&e.flags)return e;if(n){var a=pl(e,function(e){return kc(e,i)});return 16384&a.flags?e:gl(a,i)}if(Zc(i)){var o=Us(i);return pl(e,function(e){return Us(e)!==o})}return e}function C(e,n,i,a,o){var s=cl(n.expression);if(!qu(t,s))return Vu(t,s)?r:e;if(33!==i&&35!==i||(o=!o),o&&!(131072&e.flags)){var c=Xt.get(a.text);if(c){if(vc(c,e))return c;if(7897088&e.flags&&vc(c,Ea(e)||Q))return ys([e,c])}}return Qu(e,o?Gt.get(a.text)||64:$t.get(a.text)||8192)}function E(t,r,n,i){var a=ll(r);if(!a.length)return t;var o=a.slice(n,i),s=n===i||e.contains(o,de),c=ds(o),u=16384&c.flags?de:gl(pl(t,function(e){return kc(c,e)}),c);if(!s)return u;var l=pl(t,function(t){return!(Zc(t)&&e.contains(a,Us(t)))});return 16384&u.flags?l:ds([u,l])}function N(e,t,r,n){if(!r)return pl(e,function(e){return!n(e,t)});if(131072&e.flags){var i=pl(e,function(e){return n(e,t)});if(!(16384&i.flags))return i}return vc(t,e)?t:bc(e,t)?e:bc(t,e)?t:ys([e,t])}function A(n,i,a){if(!function(e,t){if(e.arguments)for(var r=0,n=e.arguments;r<n.length;r++)if(Gu(t,n[r]))return!0;return!(183!==e.expression.kind||!Gu(t,e.expression.expression))}(i,t)||!El(i))return n;var o=Kd(i),s=no(o);if(!s)return n;if(zn(n)&&(s.type===Ne||s.type===Ae))return n;if(e.isIdentifierTypePredicate(s)){var c=i.arguments[s.parameterIndex-(o.thisParameter?1:0)];if(c){if(qu(t,c))return N(n,s.type,a,vc);if(Vu(t,c))return r}}else{var u=e.skipParentheses(i.expression);if(184===u.kind||183===u.kind){var l=u,_=e.skipParentheses(l.expression);if(qu(t,_))return N(n,s.type,a,vc);if(Vu(t,_))return r}}return n}function w(e,t,r){switch(t.kind){case 71:case 99:case 97:case 183:return S(e,t,r);case 185:return A(e,t,r);case 189:return w(e,t.expression,r);case 198:return T(e,t,r);case 196:if(51===t.operator)return w(e,t.operand,!r)}return e}}function Al(t){return e.findAncestor(t.parent,function(t){return e.isFunctionLike(t)&&!e.getImmediatelyInvokedFunctionExpression(t)||238===t.kind||272===t.kind||151===t.kind})}function Pl(t){var r,n=e.getRootDeclaration(t.valueDeclaration).parent,i=yr(n);return 4194304&i.flags||(i.flags|=4194304,r=n,e.findAncestor(r.parent,function(t){return e.isFunctionLike(t)&&!!(4194304&yr(t).flags)})||wl(n)),t.isAssigned||!1}function wl(t){if(71===t.kind){if(e.isAssignmentTarget(t)){var r=Ju(t);r.valueDeclaration&&148===e.getRootDeclaration(r.valueDeclaration).kind&&(r.isAssigned=!0);}}else e.forEachChild(t,wl);}function Fl(e){return 3&e.flags&&0!=(2&V_(e))&&ui(e)!==Be}function Ol(e){var t=e.parent;return 183===t.kind||185===t.kind&&t.expression===e||184===t.kind&&t.expression===e||180===t.kind&&t.name===e&&!!t.initializer}function Il(e){return 7372800&e.flags&&gp(Ea(e)||ge,12288)}function Ml(e,t){return Ol(t)&&dl(e,Il)?fl(bu(e),Na):e}function Ll(e,t){!Mr(e,67216319)||zu(t)||Gm(Rr(e))||Kr(e);}function Rl(t){var r=Ju(t);if(r===$)return ee;if(r===j){var n=e.getContainingFunction(t);return C<2&&(191===n.kind?sr(t,e.Diagnostics.The_arguments_object_cannot_be_referenced_in_an_arrow_function_in_ES3_and_ES5_Consider_using_a_standard_function_expression):e.hasModifier(n,256)&&sr(t,e.Diagnostics.The_arguments_object_cannot_be_referenced_in_an_async_function_or_method_in_ES3_and_ES5_Consider_using_a_standard_function_or_method)),yr(n).flags|=8192,ui(r)}t.parent&&e.isPropertyAccessExpression(t.parent)&&t.parent.expression===t||Ll(r,t);var i=on$$1(r),a=i.valueDeclaration;if(32&i.flags)if(233===a.kind&&e.nodeIsDecorated(a))for(n=e.getContainingClass(t);void 0!==n;){if(n===a&&n.name!==t){yr(a).flags|=8388608,yr(t).flags|=16777216;break}n=e.getContainingClass(n);}else if(203===a.kind)for(n=e.getThisContainer(t,!1);void 0!==n;){if(n.parent===a){151===n.kind&&e.hasModifier(n,32)&&(yr(a).flags|=8388608,yr(t).flags|=16777216);break}n=e.getThisContainer(n,!1);}Pf(t,t),Cf(t,t),Ef(t,t),function(t,r){if(!(C>=2||0==(34&r.flags)||267===r.valueDeclaration.parent.kind)){for(var n=e.getEnclosingBlockScopeContainer(r.valueDeclaration),i=function(t,r){return!!e.findAncestor(t,function(t){return t===r?"quit":e.isFunctionLike(t)})}(t.parent,n),a=n,o=!1;a&&!e.nodeStartsNewLexicalEnvironment(a);){if(e.isIterationStatement(a,!1)){o=!0;break}a=a.parent;}o&&(i&&(yr(a).flags|=65536),218===n.kind&&e.getAncestor(r.valueDeclaration,231).parent===n&&function(t,r){for(var n=t;189===n.parent.kind;)n=n.parent;var i=!1;if(e.isAssignmentTarget(n))i=!0;else if(196===n.parent.kind||197===n.parent.kind){var a=n.parent;i=43===a.operator||44===a.operator;}return!!i&&!!e.findAncestor(n,function(e){return e===r?"quit":e===r.statement})}(t,n)&&(yr(r.valueDeclaration).flags|=2097152),yr(r.valueDeclaration).flags|=262144),i&&(yr(r.valueDeclaration).flags|=131072);}}(t,r);var o=Ml(ui(i),t),s=e.getAssignmentTargetKind(t);if(s){if(!(3&i.flags))return sr(t,e.Diagnostics.Cannot_assign_to_0_because_it_is_not_a_variable,Dn(r)),ee;if(dp(i))return sr(t,e.Diagnostics.Cannot_assign_to_0_because_it_is_a_constant_or_a_read_only_property,Dn(r)),ee}var c=2097152&i.flags;if(3&i.flags){if(1===s)return o}else{if(!c)return o;a=e.find(r.declarations,d);}if(!a)return o;for(var u=148===e.getRootDeclaration(a).kind,l=Al(a),_=Al(t),p=_!==l,f=t.parent&&t.parent.parent&&e.isSpreadAssignment(t.parent)&&rl(t.parent.parent);_!==l&&(190===_.kind||191===_.kind||e.isObjectLiteralOrClassExpressionMethod(_))&&(Fl(i)||u&&!Pl(i));)_=Al(_);var m=u||c||p||f||o!==Y&&o!==Be&&(!P||0!=(1&o.flags)||zu(t)||250===t.parent.kind)||207===t.parent.kind||230===a.kind&&a.exclamationToken||2097152&a.flags,g=Nl(t,o,m?u?function(e,t){return P&&148===t.kind&&t.initializer&&4096&su(e)&&!(4096&su(Rp(t.initializer)))?Qu(e,131072):e}(o,a):o:o===Y||o===Be?te:_u(o),_,!m);if(o===Y||o===Be){if(g===Y||g===Be)return O&&(sr(e.getNameOfDeclaration(a),e.Diagnostics.Variable_0_implicitly_has_type_1_in_some_locations_where_its_type_cannot_be_determined,Dn(r),En(g)),sr(t,e.Diagnostics.Variable_0_implicitly_has_an_1_type,Dn(r),En(g))),If(g)}else if(!m&&!(4096&su(o))&&4096&su(g))return sr(t,e.Diagnostics.Variable_0_is_used_before_being_assigned,Dn(r)),o;return s?tu(g):g}function Bl(e,t){yr(e).flags|=2,151===t.kind||154===t.kind?yr(t.parent).flags|=4:yr(t).flags|=4;}function Kl(t){return e.isSuperCall(t)?t:e.isFunctionLike(t)?void 0:e.forEachChild(t,Kl)}function jl(e){var t=yr(e);return void 0===t.hasSuperCall&&(t.superCall=Kl(e.body),t.hasSuperCall=!!t.superCall),t.superCall}function Jl(e){return Si(Fi(nn(e)))===ie}function zl(t,r,n){var i=r.parent;if(e.getClassExtendsHeritageClauseElement(i)&&!Jl(i)){var a=jl(r);(!a||a.end>t.pos)&&sr(t,n);}}function Ul(t,r){if(void 0===r&&(r=e.getThisContainer(t,!1)),e.isFunctionLike(r)&&(!Xl(t)||e.getThisParameter(r))){if(190===r.kind&&198===r.parent.kind&&3===e.getSpecialPropertyAssignmentKind(r.parent)){var n=Rp(r.parent.left.expression.expression).symbol;if(n&&n.members&&16&n.flags)return Nl(t,Ud(n))}var i=ii(r)||Gl(r);if(i)return Nl(t,i)}if(e.isClassLike(r.parent)){var a=nn(r.parent);return Nl(t,o=e.hasModifier(r,32)?ui(a):Fi(a).thisType)}var o;if(e.isInJavaScriptFile(t)&&(o=function(t){var r=e.getJSDocType(t);if(r&&280===r.kind){var n=r;if(n.parameters.length>0&&n.parameters[0].name&&"this"===n.parameters[0].name.escapedText)return Hs(n.parameters[0].type)}}(r))&&o!==ee)return Nl(t,o)}function ql(t,r){return!!e.findAncestor(t,function(e){return e===r?"quit":148===e.kind})}function Vl(t){var r=185===t.parent.kind&&t.parent.expression===t,n=e.getSuperContainer(t,!0),i=!1;if(!r)for(;n&&191===n.kind;)n=e.getSuperContainer(n,!0),i=C<2;var a=0;if(!function(t){return!!t&&(r?154===t.kind:!(!e.isClassLike(t.parent)&&182!==t.parent.kind)&&(e.hasModifier(t,32)?153===t.kind||152===t.kind||155===t.kind||156===t.kind:153===t.kind||152===t.kind||155===t.kind||156===t.kind||151===t.kind||150===t.kind||154===t.kind))}(n)){var o=e.findAncestor(t,function(e){return e===n?"quit":146===e.kind});return o&&146===o.kind?sr(t,e.Diagnostics.super_cannot_be_referenced_in_a_computed_property_name):r?sr(t,e.Diagnostics.Super_calls_are_not_permitted_outside_constructors_or_in_nested_functions_inside_constructors):n&&n.parent&&(e.isClassLike(n.parent)||182===n.parent.kind)?sr(t,e.Diagnostics.super_property_access_is_permitted_only_in_a_constructor_member_function_or_member_accessor_of_a_derived_class):sr(t,e.Diagnostics.super_can_only_be_referenced_in_members_of_derived_classes_or_object_literal_expressions),ee}if(r||154!==n.kind||zl(t,n,e.Diagnostics.super_must_be_called_before_accessing_a_property_of_super_in_the_constructor_of_a_derived_class),a=e.hasModifier(n,32)||r?512:256,yr(t).flags|=a,153===n.kind&&e.hasModifier(n,256)&&(e.isSuperProperty(t.parent)&&e.isAssignmentTarget(t.parent)?yr(n).flags|=4096:yr(n).flags|=2048),i&&Bl(t.parent,n),182===n.parent.kind)return C<2?(sr(t,e.Diagnostics.super_is_only_allowed_in_members_of_object_literal_expressions_when_option_target_is_ES2015_or_higher),ee):Q;var s=n.parent;if(!e.getClassExtendsHeritageClauseElement(s))return sr(t,e.Diagnostics.super_can_only_be_referenced_in_a_derived_class),ee;var c=Fi(nn(s)),u=c&&ki(c)[0];return u?154===n.kind&&ql(t,n)?(sr(t,e.Diagnostics.super_cannot_be_referenced_in_constructor_arguments),ee):512===a?Si(c):Xi(u,c.thisType):ee}function Wl(t){return 4&e.getObjectFlags(t)&&t.target===Le?t.typeArguments[0]:void 0}function Hl(t){return fl(t,function(t){return 262144&t.flags?e.forEach(t.types,Wl):Wl(t)})}function Gl(t){if(191!==t.kind){if(fc(t)){var r=g_(t);if(r){var n=r.thisParameter;if(n)return ui(n)}}var i=e.isInJavaScriptFile(t);if(I||i){var a=function(e){return 153!==e.kind&&155!==e.kind&&156!==e.kind||182!==e.parent.kind?190===e.kind&&268===e.parent.kind?e.parent.parent:void 0:e.parent}(t);if(a){for(var o=s_(a),s=a,c=o;c;){var u=Hl(c);if(u)return uc(u,u_(a));if(268!==s.parent.kind)break;c=s_(s=s.parent.parent);}return o?du(o):Ap(a)}var l=t.parent;if(198===l.kind&&58===l.operatorToken.kind){var _=l.left;if(183===_.kind||184===_.kind){var d=_.expression;if(i&&e.isIdentifier(d)){var p=e.getSourceFileOfNode(l);if(p.commonJsModuleIndicator&&Ju(d)===p.symbol)return}return Ap(d)}}}}}function $l(t){var r=t.parent;if(fc(r)){var n=e.getImmediatelyInvokedFunctionExpression(r);if(n&&n.arguments){var i=r.parameters.indexOf(t);if(t.dotDotDotToken){for(var a=[],o=i;o<n.arguments.length;o++)a.push(ru(Rp(n.arguments[o])));return a.length?rs(ds(a)):void 0}var s=yr(n),c=s.resolvedSignature;s.resolvedSignature=at;var u=i<n.arguments.length?ru(Rp(n.arguments[i])):t.initializer?void 0:re;return s.resolvedSignature=c,u}var l=g_(r);if(l){var _=e.hasRestParameter(r),d=r.parameters.length-(_?1:0);if(i=r.parameters.indexOf(t),void 0===e.getThisParameter(r)||l.thisParameter||(e.Debug.assert(0!==i),i-=1),i<d)return Zd(l,i);if(_&&i===r.parameters.length-1&&Hc(l,r.parameters.length-1))return ui(e.lastOrUndefined(l.parameters))}}}function Xl(t){for(var r=!1;t.parent&&!e.isFunctionLike(t.parent);){if(e.isParameter(t.parent)&&(r||t.parent.initializer===t))return!0;e.isBindingElement(t.parent)&&t.parent.initializer===t&&(r=!0),t=t.parent;}return!1}function Ql(t){if(154===t.kind||e.getEffectiveReturnTypeNode(t)||$f(t))return io(Za(t));var r=f_(t);return r&&!function(e){return!e.resolvedReturnType&&Rn(e,3)>=0}(r)?io(r):void 0}function Yl(e,t){var r=Sd(e).indexOf(t);return-1===r?void 0:Zl(e,r)}function Zl(e,t){return Zd(yr(e).resolvedSignature===st?st:Kd(e),t)}function e_(t){var r=t.parent,n=r.left,i=r.operatorToken,a=r.right;switch(i.kind){case 58:return t===a&&function(t){var r=e.getSpecialPropertyAssignmentKind(t);switch(r){case 0:return!0;case 5:return!t.left.symbol;case 1:case 2:case 3:case 4:case 6:return!1;default:e.Debug.assertNever(r);}}(r)?Lp(n):void 0;case 54:var o=c_(r);return o||t!==a||e.getDeclaredJavascriptInitializer(r.parent)||e.getAssignedJavascriptInitializer(r)?o:Lp(n,!0);case 53:case 26:return t===a?c_(r):void 0;default:return}}function t_(e,t){return fl(e,function(e){var r=458752&e.flags?Ra(e,t):void 0;return r?ui(r):void 0},!0)}function r_(e,t){return fl(e,function(e){return Ja(e,t)},!0)}function n_(e){var t=s_(e.parent);if(t){if(!qi(e)){var r=t_(t,nn(e).escapedName);if(r)return r}return v_(e.name)&&r_(t,1)||r_(t,0)}}function i_(e,t){return e&&(t_(e,""+t)||r_(e,1)||qf(e,void 0,!1,!1,!1))}function a_(t){var r=t.parent;return e.isJsxAttributeLike(r)?c_(t):e.isJsxElement(r)?function(e){var t=s_(e.openingElement.tagName),r=M_(F_(e));return t&&!zn(t)&&r&&""!==r?t_(t,r):void 0}(r):void 0}function o_(t){if(e.isJsxAttribute(t)){var r=s_(t.parent);if(!r||zn(r))return;return t_(r,t.name.escapedText)}return c_(t.parent)}function s_(t){var r,n=c_(t);if(!((n=n&&fl(n,Oa))&&131072&n.flags&&e.isObjectLiteralExpression(t)))return n;e:for(var i=0,a=t.properties;i<a.length;i++){var o=a[i];if(o.symbol&&268===o.kind&&Hu(n,o.symbol.escapedName))for(var s=Im(o.initializer),c=0,u=n.types;c<u.length;c++){var l=u[c],_=Jn(l,o.symbol.escapedName);if(_&&Tc(s,_,void 0)){if(r){if(l===r)continue;r=void 0;break e}r=l;}}}return r||n}function c_(r){if(!(4194304&r.flags)){if(r.contextualType)return r.contextualType;var n=r.parent;switch(n.kind){case 230:case 148:case 151:case 150:case 180:return function(t){var r=t.parent;if(e.hasInitializer(r)&&t===r.initializer){var n=e.getEffectiveTypeAnnotationNode(r);if(n)return Hs(n);if(148===r.kind){var i=$l(r);if(i)return i}if(e.isBindingPattern(r.name))return Yn(r.name,!0,!1);if(e.isBindingPattern(r.parent)){var a=r.parent.parent,o=r.propertyName||r.name;if(180!==a.kind){var s=e.getEffectiveTypeAnnotationNode(a);if(s&&!e.isBindingPattern(o)){var c=e.getTextOfPropertyName(o);if(c)return Jn(Hs(s),c)}}}}}(r);case 191:case 223:return function(t){var r=e.getContainingFunction(t);if(r){var n=e.getFunctionFlags(r);if(1&n)return;var i=Ql(r);return 2&n?i&&af(i):i}}(r);case 201:return function(t){var r=e.getContainingFunction(t);if(r){var n=e.getFunctionFlags(r),i=Ql(r);if(i)return t.asteriskToken?i:Hf(i,0!=(2&n))}}(n);case 185:case 186:return Yl(n,r);case 188:case 206:return Hs(n.type);case 198:return e_(r);case 268:case 269:return n_(n);case 270:return s_(n.parent);case 181:var i=n;return i_(s_(i),e.indexOfNode(i.elements,r));case 199:return function(e){var t=e.parent;return e===t.whenTrue||e===t.whenFalse?c_(t):void 0}(r);case 209:return e.Debug.assert(200===n.parent.kind),function(e,t){if(187===e.parent.kind)return Yl(e.parent,t)}(n.parent,r);case 189:var a=e.isInJavaScriptFile(n)?e.getJSDocTypeTag(n):void 0;return a?Hs(a.typeExpression.type):c_(n);case 263:return a_(n);case 260:case 262:return o_(n);case 255:case 254:return function(r){if(C_(r.tagName))return B_(r);var n=Rp(r.tagName);if(zn(n))return Q;var i=e.isInJavaScriptFile(r);return fl(n,function(n){return function(r,n,i){if(2&r.flags)return Q;if(32&r.flags){var a=P_(t.IntrinsicElements,i);if(a!==ee){var o=r.value,s=Ra(a,e.escapeLeadingUnderscores(o));if(s)return ui(s);var c=Ua(a,0);if(c)return c}return Q}var u=Ka(r,1),l=!0;return 0===u.length&&(u=Ka(r,0),l=!1,0===u.length)?ee:ds(e.map(u,l?function(e){return function(e,t,r){var n=io(e);return n?__(n,t,r):l_(e,r)}(e,n,i)}:function(e){return l_(e,i)}),0)}(n,i,r)})}(n)}}}function u_(t){return(t=e.findAncestor(t,function(e){return!!e.contextualMapper}))?t.contextualMapper:T}function l_(e,r){var n=ep(e),i=P_(t.IntrinsicAttributes,r);return i!==ee&&(n=ia(i,n)),n}function __(e,r,n){if(zn(e))return e;var i=I_(F_(n));if(void 0===i)return Q;if(""===i)return e;var a=Jn(e,i);if(a){if(zn(a))return a;var o=a,s=P_(t.IntrinsicClassAttributes,n);if(s!==ee){var c=gi(s.symbol);o=ia(c?So(s,Ya([e],c,Qa(c),r)):s,o);}var u=P_(t.IntrinsicAttributes,n);return u!==ee&&(o=ia(u,o)),o}return ge}function d_(t,r){var n=Ka(t,0);if(1===n.length){var i=n[0];if(!function(t,r){for(var n=0;n<r.parameters.length;n++){var i=r.parameters[n];if(i.initializer||i.questionToken||i.dotDotDotToken||Wa(i))break}return r.parameters.length&&e.parameterIsThisKeyword(r.parameters[0])&&n--,(t.hasRestParameter?Number.MAX_VALUE:t.parameters.length)<n}(i,r))return i}}function p_(e){return 190===e.kind||191===e.kind}function f_(t){return p_(t)||e.isObjectLiteralMethod(t)?g_(t):void 0}function m_(t){return e.isObjectLiteralMethod(t)?function(t){if(e.Debug.assert(e.isObjectLiteralMethod(t)),!(4194304&t.flags))return n_(t)}(t):s_(t)}function g_(t){e.Debug.assert(153!==t.kind||e.isObjectLiteralMethod(t));var r=m_(t);if(r){if(!(131072&r.flags))return d_(r,t);for(var n,i,a=0,o=r.types;a<o.length;a++){var s=d_(o[a],t);if(s)if(n){if(!Wc(n[0],s,!1,!0,!0,yc))return;n.push(s);}else n=[s];}return n&&((i=Zi(n[0])).unionSignatures=n),i}}function y_(e){return 180===e.kind&&!!e.initializer||198===e.kind&&58===e.operatorToken.kind}function h_(t,r){for(var n=t.elements,i=!1,a=[],o=e.isAssignmentTarget(t),s=s_(t),c=0;c<n.length;c++){var u=n[c];if(o&&202===u.kind){var l=Rp(u.expression,r),_=Ua(l,1)||qf(l,void 0,!1,!1,!1);_&&a.push(_);}else{var d=Fp(u,r,i_(s,c));a.push(d);}i=i||202===u.kind;}if(!i){if(o&&a.length)return(d=ko(is(a))).pattern=t,d;if(s&&function(t){return!!(131072&t.flags?e.forEach(t.types,Yc):Yc(t))}(s)){var p=s.pattern;if(p&&(179===p.kind||181===p.kind))for(var f=p.elements,m=a.length;m<f.length;m++){var g=f[m];y_(g)?a.push(s.typeArguments[m]):(204!==g.kind&&sr(g,e.Diagnostics.Initializer_provides_no_value_for_this_binding_element_and_the_binding_element_has_no_default_value),a.push(P?fe:re));}if(a.length)return is(a)}}return rs(a.length?ds(a,2):P?fe:re)}function v_(e){switch(e.kind){case 146:return function(e){return yp(x_(e),84)}(e);case 71:return b_(e.escapedText);case 8:case 9:return b_(e.text);default:return!1}}function b_(e){return(+e).toString()===e}function x_(t){var r=yr(t.expression);return r.resolvedType||(r.resolvedType=Rp(t.expression),12288&r.resolvedType.flags||!yp(r.resolvedType,525942)&&!bc(r.resolvedType,ds([ae,oe,le]))?sr(t,e.Diagnostics.A_computed_property_name_must_be_of_type_string_number_symbol_or_any):ud(t.expression,r.resolvedType,!0)),r.resolvedType}function S_(e,t,r,n){for(var i=[],a=0;a<r.length;a++)(0===n||v_(e[a+t].name))&&i.push(ui(r[a]));return go(i.length?ds(i,2):te,!1)}function k_(t,r){var n,i=e.isAssignmentTarget(t);!function(t,r){var n;!function(e){e[e.Property=1]="Property",e[e.GetAccessor=2]="GetAccessor",e[e.SetAccessor=4]="SetAccessor",e[e.GetOrSetAccessor=6]="GetOrSetAccessor";}(n||(n={}));for(var i=e.createUnderscoreEscapedMap(),a=0,o=t.properties;a<o.length;a++){var s=o[a];if(270!==s.kind){var c=s.name;if(146===c.kind&&kg(c),269===s.kind&&!r&&s.objectAssignmentInitializer)return Mg(s.equalsToken,e.Diagnostics.can_only_be_used_in_an_object_literal_property_inside_a_destructuring_assignment);if(s.modifiers)for(var u=0,l=s.modifiers;u<l.length;u++){var _=l[u];120===_.kind&&153===s.kind||Mg(_,e.Diagnostics._0_modifier_cannot_be_used_here,e.getTextOfNode(_));}var d=void 0;switch(s.kind){case 268:case 269:Dg(s.questionToken,e.Diagnostics.An_object_member_cannot_be_declared_optional),8===c.kind&&Rg(c);case 153:d=1;break;case 155:d=2;break;case 156:d=4;break;default:e.Debug.assertNever(s,"Unexpected syntax kind:"+s.kind);}var p=e.getPropertyNameForPropertyNameNode(c);if(void 0!==p){var f=i.get(p);if(f)if(1===d&&1===f)Mg(c,e.Diagnostics.Duplicate_identifier_0,e.getTextOfNode(c));else{if(!(6&d&&6&f))return Mg(c,e.Diagnostics.An_object_literal_cannot_have_property_and_accessor_with_the_same_name);if(6===f||d===f)return Mg(c,e.Diagnostics.An_object_literal_cannot_have_multiple_get_Slashset_accessors_with_the_same_name);i.set(p,d|f);}else i.set(p,d);}}}}(t,i);var a=[],o=ge,s=8388608,c=s_(t),u=c&&c.pattern&&(178===c.pattern.kind||182===c.pattern.kind),l=e.isInJavaScriptFile(t),_=!c&&l,d=0,p=!1,f=!1,m=!1;if(l&&0===t.properties.length){var g=nn(t);if(g.exports)return n=g.exports,g.exports.forEach(function(e){return a.push(rn(e))}),O()}n=e.createSymbolTable();for(var y=0,h=0;h<t.properties.length;h++){var v=t.properties[h],b=nn(v),x=void 0;if(268===v.kind||269===v.kind||e.isObjectLiteralMethod(v)){var S=void 0;l&&(S=Hn(v));var k=void 0;if(268===v.kind){if(146===v.name.kind){var T=x_(v.name);224&T.flags&&(x=e.escapeLeadingUnderscores(""+T.value));}k=Op(v,r);}else 153===v.kind?k=Ip(v,r):(e.Debug.assert(269===v.kind),k=Fp(v.name,r));S&&(Tc(k,S,v),k=S),d|=k.flags;var E=Ui(v)?x_(v.name):void 0,N=E&&Ji(E),A=N?cr(4|b.flags,Vi(E),1024):cr(4|b.flags,x||b.escapedName);if(N&&(A.nameType=E),i)(268===v.kind&&y_(v.initializer)||269===v.kind&&v.objectAssignmentInitializer)&&(A.flags|=16777216),!x&&e.hasDynamicName(v)&&(p=!0);else if(u&&!(512&e.getObjectFlags(c))){var P=Ra(c,b.escapedName);P?A.flags|=16777216&P.flags:D.suppressExcessPropertyErrors||za(c,0)||sr(v.name,e.Diagnostics.Object_literal_may_only_specify_known_properties_and_0_does_not_exist_in_type_1,Dn(b),En(c));}A.declarations=b.declarations,A.parent=b.parent,b.valueDeclaration&&(A.valueDeclaration=b.valueDeclaration),A.type=k,A.target=b,b=A;}else{if(270===v.kind){if(C<2&&dg(v,2),a.length>0&&(o=Rs(o,O(),t.symbol,s,0),a=[],n=e.createSymbolTable(),f=!1,m=!1,d=0),!T_(k=Rp(v.expression)))return sr(v,e.Diagnostics.Spread_types_may_only_be_created_from_object_types),ee;o=Rs(o,k,t.symbol,s,0),y=h+1;continue}e.Debug.assert(155===v.kind||156===v.kind),km(v);}!x&&qi(v)?v_(v.name)?m=!0:f=!0:n.set(b.escapedName,b),a.push(b);}if(u)for(var w=0,F=xa(c);w<F.length;w++)A=F[w],n.get(A.escapedName)||o&&Ra(o,A.escapedName)||(16777216&A.flags||sr(A.valueDeclaration||A.bindingElement,e.Diagnostics.Initializer_provides_no_value_for_this_binding_element_and_the_binding_element_has_no_default_value),n.set(A.escapedName,A),a.push(A));return o!==ge?(a.length>0&&(o=Rs(o,O(),t.symbol,s,0)),o):O();function O(){var r=_?lt:f?S_(t.properties,y,a,0):void 0,o=m&&!_?S_(t.properties,y,a,1):void 0,c=mn(t.symbol,n,e.emptyArray,e.emptyArray,r,o),u=D.suppressExcessPropertyErrors?0:8388608;return c.flags|=33554432|u|117440512&d,c.objectFlags|=128,p&&(c.objectFlags|=512),i&&(c.pattern=t),12288&c.flags||(s|=117440512&c.flags),c}}function T_(t){return!!(134217729&t.flags||14560&su(t)&&T_(cu(t))||65536&t.flags&&!ga(t)||393216&t.flags&&!e.forEach(t.types,function(e){return!T_(e)}))}function D_(t){return!e.stringContains(t,"-")}function C_(t){switch(t.kind){case 183:case 99:return!1;case 71:return e.isIntrinsicJsxName(t.escapedText);default:e.Debug.fail();}}function E_(e,t){return e.initializer?Fp(e.initializer,t):se}function N_(t,r){for(var n,i=t.attributes,a=e.createSymbolTable(),o=ge,s=!1,c=!1,u=M_(F_(t)),l=0,_=i.properties;l<_.length;l++){var d=_[l],p=d.symbol;if(e.isJsxAttribute(d)){var f=E_(d,r),m=cr(33554436|p.flags,p.escapedName);m.declarations=p.declarations,m.parent=p.parent,p.valueDeclaration&&(m.valueDeclaration=p.valueDeclaration),m.type=f,m.target=p,a.set(m.escapedName,m),d.name.escapedText===u&&(c=!0);}else e.Debug.assert(262===d.kind),a.size>0&&(o=Rs(o,b(),i.symbol,0,4096),a=e.createSymbolTable()),zn(f=Ap(d.expression,r))&&(s=!0),T_(f)?o=Rs(o,f,t.symbol,0,4096):n=n?ys([n,f]):f;}s||a.size>0&&(o=Rs(o,b(),i.symbol,0,4096));var g=253===t.parent.kind?t.parent:void 0;if(g&&g.openingElement===t&&g.children.length>0){var y=A_(g,r);if(!s&&u&&""!==u){c&&sr(i,e.Diagnostics._0_are_specified_twice_The_attribute_named_0_will_be_overwritten,e.unescapeLeadingUnderscores(u));var h=cr(33554436,u);h.type=1===y.length?y[0]:rs(ds(y));var v=e.createSymbolTable();v.set(u,h),o=Rs(o,mn(i.symbol,v,e.emptyArray,e.emptyArray,void 0,void 0),i.symbol,0,4096);}}return s?Q:n&&o!==ge?ys([n,o]):n||o;function b(){var t=mn(i.symbol,a,e.emptyArray,e.emptyArray,void 0,void 0);return t.flags|=33554432,t.objectFlags|=4224,t}}function A_(e,t){for(var r=[],n=0,i=e.children;n<i.length;n++){var a=i[n];10===a.kind?a.containsOnlyWhiteSpaces||r.push(ae):r.push(Fp(a,t));}return r}function P_(e,t){var r=F_(t),n=r&&Yr(r),i=n&&vr(n,e,67901928);return i?Fi(i):ee}function w_(r){var n=yr(r);if(!n.resolvedSymbol){var i=P_(t.IntrinsicElements,r);if(i!==ee){if(!e.isIdentifier(r.tagName))return e.Debug.fail();var a=Ra(i,r.tagName.escapedText);return a?(n.jsxFlags|=1,n.resolvedSymbol=a):Ua(i,0)?(n.jsxFlags|=2,n.resolvedSymbol=i.symbol):(sr(r,e.Diagnostics.Property_0_does_not_exist_on_type_1,e.idText(r.tagName),"JSX."+t.IntrinsicElements),n.resolvedSymbol=$)}return O&&sr(r,e.Diagnostics.JSX_element_implicitly_has_type_any_because_no_interface_JSX_0_exists,e.unescapeLeadingUnderscores(t.IntrinsicElements)),n.resolvedSymbol=$}return n.resolvedSymbol}function F_(e){var r=or(e),n=xr(e,r,1920,void 0,r,!1);if(n){var i=vr(Yr(Lr(n)),t.JSX,1920);if(i)return i}return Bo(t.JSX,1920,void 0)}function O_(t,r){var n=r&&vr(r.exports,t,67901928),i=n&&Fi(n),a=i&&xa(i);if(a){if(0===a.length)return"";if(1===a.length)return a[0].escapedName;a.length>1&&sr(n.declarations[0],e.Diagnostics.The_global_type_JSX_0_may_not_have_more_than_one_property,e.unescapeLeadingUnderscores(t));}}function I_(e){return O_(t.ElementAttributesPropertyNameContainer,e)}function M_(e){return O_(t.ElementChildrenAttributeNameContainer,e)}function L_(e){if(e){if(262144&e.flags){for(var t=[],r=0,n=e.types;r<n.length;r++){var i=n[r];t.push(Oa(i));}return ys(t)}return Oa(e)}}function R_(r,n,i,a){if(131072&i.flags)return ds(i.types.map(function(e){return R_(r,n,e,a)}),2);if(2&i.flags)return Q;if(32&i.flags){var o=P_(t.IntrinsicElements,r);if(o!==ee){var s=i.value,c=Ra(o,e.escapeLeadingUnderscores(s));if(c)return ui(c);var u=Ua(o,0);if(u)return u;sr(r,e.Diagnostics.Property_0_does_not_exist_on_type_1,s,"JSX."+t.IntrinsicElements);}return Q}var l=function(t,r){if(e.Debug.assert(!(131072&r.flags)),zn(r))return Q;var n=Ka(r,1);if(0===n.length&&0===(n=Ka(r,0)).length)return sr(t.tagName,e.Diagnostics.JSX_element_type_0_does_not_have_any_construct_or_call_signatures,e.getTextOfNode(t.tagName)),ee;for(var i=[],a=0,o=n;a<o.length;a++){var s=o[a];if(s.typeParameters){var c=e.isInJavaScriptFile(t),u=yd(s,t,Du(s.typeParameters,s,c?4:0));i.push(oo(s,u,c));}else i.push(s);}return ds(e.map(i,io),2)}(r,i),_=n?function(r,n,i,a){if(e.Debug.assert(!(131072&n.flags)),!a||!bc(i,a)){var o=z_(r);if(o){var s=[];Ld(r,n,s);for(var c=void 0,u=void 0,l=0,_=s;l<_.length;l++){var d=_[l],p=io(d),f=p&&(0===d.parameters.length?ge:ui(d.parameters[0]));if(f=L_(f),p&&bc(p,o)){for(var m=!0,g=0,y=r.attributes.properties;g<y.length;g++){var h=y[g];if(e.isJsxAttribute(h)&&D_(h.name.escapedText)&&!Ra(f,h.name.escapedText)){m=!1;break}}m&&(c=ia(c,f)),u=ia(u,f);}}c||(c=u);var v=P_(t.IntrinsicAttributes,r);return v!==ee&&(c=ia(v,c)),c}}}(r,i,l,a):function(r,n,i,a){if(e.Debug.assert(!(131072&n.flags)),!a||!bc(i,a)){var o=z_(r);if(o){var s=Ld(r,n,void 0);if(s!==ot){var c=s&&io(s),u=c&&(0===s.parameters.length?ge:ui(s.parameters[0]));if(u=L_(u),c&&bc(c,o)){var l=P_(t.IntrinsicAttributes,r);return l!==ee&&(u=ia(l,u)),u}}}}}(r,i,l,a);return _||(a&&Ic(l,a,Zt,r,e.Diagnostics.JSX_element_type_0_is_not_a_constructor_function_for_JSX_elements),__(l,e.isInJavaScriptFile(r),r))}function B_(t){e.Debug.assert(C_(t.tagName));var r=yr(t);if(!r.resolvedJsxElementAttributesType){var n=w_(t);return 1&r.jsxFlags?r.resolvedJsxElementAttributesType=ui(n):2&r.jsxFlags?r.resolvedJsxElementAttributesType=yo(n,0).type:r.resolvedJsxElementAttributesType=ee}return r.resolvedJsxElementAttributesType}function K_(e,r){return R_(e,r,Rp(e.tagName),(n=e,(i=P_(t.ElementClass,n))===ee?void 0:i));var n,i;}function j_(e){var t;return Ra(C_((t=e.parent.parent).tagName)?B_(t):K_(t,!1),e.name.escapedText)||$}function J_(e){return P_(t.Element,e)}function z_(e){var t=J_(e);if(t)return ds([t,ne])}function U_(t,r){var n,i=e.isJsxOpeningLikeElement(t);i&&function(t){for(var r=e.createUnderscoreEscapedMap(),n=0,i=t.attributes.properties;n<i.length;n++){var a=i[n];if(262!==a.kind){var o=a.name,s=a.initializer;if(r.get(o.escapedText))return Mg(o,e.Diagnostics.JSX_elements_cannot_have_multiple_attributes_with_the_same_name);if(r.set(o.escapedText,!0),s&&263===s.kind&&!s.expression)return Mg(s,e.Diagnostics.JSX_attributes_must_only_be_assigned_a_non_empty_expression)}}}(t),n=t,0===(D.jsx||0)&&sr(n,e.Diagnostics.Cannot_use_JSX_unless_the_jsx_flag_is_provided),void 0===J_(n)&&O&&sr(n,e.Diagnostics.JSX_element_implicitly_has_type_any_because_the_global_type_JSX_Element_does_not_exist);var a=Lt&&2===D.jsx?e.Diagnostics.Cannot_find_name_0:void 0,o=or(t),s=xr(i?t.tagName:t,o,67216319,a,o,!0);s&&(s.isReferenced=67108863,2097152&s.flags&&!Gm(Rr(s))&&Kr(s)),i?function(t,r){var n=C_(t.tagName)?B_(t):K_(t,!1),i=N_(t,r);if(n===ge&&(zn(i)||xa(i).length>0))sr(t,e.Diagnostics.JSX_element_class_does_not_support_attributes_because_it_does_not_have_a_0_property,e.unescapeLeadingUnderscores(I_(F_(t))));else{var a=Tc(i,n,t.attributes.properties.length>0?t.attributes:t);if(a&&!zn(i)&&!zn(n))for(var o=0,s=t.attributes.properties;o<s.length;o++){var c=s[o];if(e.isJsxAttribute(c)){var u=c.name,l=D_(e.idText(u))||!!Ra(n,u.escapedText);if(l&&!q_(n,u.escapedText,!0)){sr(c,e.Diagnostics.Property_0_does_not_exist_on_type_1,e.idText(u),En(n));break}}}}}(t,r):A_(t.parent);}function q_(e,t,r){if(65536&e.flags){var n=ya(e);if(n.stringIndexInfo||n.numberIndexInfo&&b_(t)||va(e,t)||r&&!D_(t))return!0}else if(393216&e.flags)for(var i=0,a=e.types;i<a.length;i++)if(q_(a[i],t,r))return!0;return!1}function V_(t){return t.valueDeclaration?e.getCombinedNodeFlags(t.valueDeclaration):0}function W_(t){return!!(8192&t.flags||4&e.getCheckFlags(t))}function H_(t,r,n,i){var a,o=e.getDeclarationModifierFlagsFromSymbol(i),s=183===t.kind||230===t.kind?t.name:t.right;if(256&e.getCheckFlags(i))return sr(s,e.Diagnostics.Property_0_has_conflicting_declarations_and_is_inaccessible_in_type_1,Dn(i),En(n)),!1;if(97===r.kind){if(C<2&&G_(i))return sr(s,e.Diagnostics.Only_public_and_protected_methods_of_the_base_class_are_accessible_via_the_super_keyword),!1;if(128&o)return sr(s,e.Diagnostics.Abstract_method_0_in_class_1_cannot_be_accessed_via_super_expression,Dn(i),En(zc(i))),!1}if(128&o&&e.isThisProperty(t)&&G_(i)&&(a=e.getClassLikeDeclarationOfSymbol(an(i)))&&function(t,r){return e.findAncestor(t,function(t){return!(!e.isConstructorDeclaration(t)||!e.nodeIsPresent(t.body)||t.parent!==r)||!(t!==r&&!e.isFunctionLikeDeclaration(t))&&"quit"})}(t,a))return sr(s,e.Diagnostics.Abstract_property_0_in_class_1_cannot_be_accessed_in_the_constructor,Dn(i),e.getTextOfIdentifierOrLiteral(a.name)),!1;if(!(24&o))return!0;if(8&o)return!!Pm(t,a=e.getClassLikeDeclarationOfSymbol(an(i)))||(sr(s,e.Diagnostics.Property_0_is_private_and_only_accessible_within_class_1,Dn(i),En(zc(i))),!1);if(97===r.kind)return!0;var c=Am(t,function(t){var r=Fi(nn(t));return function(t,r){return Jc(r,function(r){return!!(16&e.getDeclarationModifierFlagsFromSymbol(r))&&!di(t,zc(r))})?void 0:t}(r,i)?r:void 0});return c?!!(32&o)||(32768&n.flags&&(n=n.isThisType?ka(n):Ea(n)),!(!n||!di(n,c))||(sr(s,e.Diagnostics.Property_0_is_protected_and_only_accessible_through_an_instance_of_class_1,Dn(i),En(c)),!1)):(sr(s,e.Diagnostics.Property_0_is_protected_and_only_accessible_within_class_1_and_its_subclasses,Dn(i),En(zc(i)||n)),!1)}function G_(e){return Jc(e,function(e){var t,r=(t=e).valueDeclaration?t.valueDeclaration.kind:151;return 153!==r&&152!==r})}function $_(e,t,r,n){return X_(Rp(e),e,t,r,n)}function X_(t,r,n,i,a){var o=12288&(P?su(t):t.flags);if(o){sr(r,4096&o?8192&o?a||e.Diagnostics.Object_is_possibly_null_or_undefined:i||e.Diagnostics.Object_is_possibly_undefined:n||e.Diagnostics.Object_is_possibly_null);var s=du(t);return 28672&s.flags?ee:s}return t}function Q_(e){return Z_(e,e.expression,e.name)}function Y_(e){return Z_(e,e.left,e.right)}function Z_(t,r,n){var i,a=$_(r),o=yr(r).resolvedSymbol,s=Oa(bu(a));if(zn(s)||s===pe)return e.isIdentifier(r)&&o&&Ll(o,t),s;var c=e.getAssignmentTargetKind(t),u=Ra(s,n.escapedText);if(!e.isIdentifier(r)||!o||u&&Gm(u)||Ll(o,t),u){if(function(t,r,n){var i=t.valueDeclaration;i&&(!function(t){return!!e.findAncestor(t,function(t){switch(t.kind){case 151:return!0;case 268:return!1;default:return!e.isExpressionNode(t)&&"quit"}})}(r)||br(i,n)||function(e){if(!(32&e.parent.flags))return!1;for(var t=ui(e.parent);;){if(!(t=ed(t)))return!1;var r=va(t,e.escapedName);if(r&&r.valueDeclaration)return!0}}(t)?233!==i.kind||161===r.parent.kind||2097152&i.flags||br(i,n)||sr(n,e.Diagnostics.Class_0_used_before_its_declaration,e.idText(n)):sr(n,e.Diagnostics.Block_scoped_variable_0_used_before_its_declaration,e.idText(n)));}(u,t,n),ad(u,t,99===r.kind),yr(t).resolvedSymbol=u,H_(t,r,s,u),c&&(pp(t,u)||fp(t)))return sr(n,e.Diagnostics.Cannot_assign_to_0_because_it_is_a_constant_or_a_read_only_property,e.idText(n)),ee;i=Ml(ui(u),t);}else{var l=za(s,0);if(!l||!l.type)return n.escapedText&&!Cr(t)&&function(t,r){var n;if(131072&r.flags&&!(16382&r.flags))for(var i=0,a=r.types;i<a.length;i++){var o=a[i];if(!Ra(o,t.escapedText)){n=e.chainDiagnosticMessages(n,e.Diagnostics.Property_0_does_not_exist_on_type_1,e.declarationNameToString(t),En(o));break}}var s=td(t,r);n=void 0!==s?e.chainDiagnosticMessages(n,e.Diagnostics.Property_0_does_not_exist_on_type_1_Did_you_mean_2,e.declarationNameToString(t),En(r),s):e.chainDiagnosticMessages(n,e.Diagnostics.Property_0_does_not_exist_on_type_1,e.declarationNameToString(t),En(r)),Lt.add(e.createDiagnosticForNodeFromMessageChain(t,n));}(n,32768&a.flags&&a.isThisType?s:a),ee;l.isReadonly&&(e.isAssignmentTarget(t)||e.isDeleteTarget(t))&&sr(t,e.Diagnostics.Index_signature_in_type_0_only_permits_reading,En(s)),i=l.type;}if(183!==t.kind||1===c||u&&!(98311&u.flags)&&!(8192&u.flags&&131072&i.flags))return i;var _=!1;if(P&&F&&99===r.kind){var d=u&&u.valueDeclaration;if(d&&om(d)){var p=Al(t);154===p.kind&&p.parent===d.parent&&(_=!0);}}var f=Nl(t,i,_?_u(i):i);return _&&!(4096&su(i))&&4096&su(f)?(sr(n,e.Diagnostics.Property_0_is_used_before_being_assigned,Dn(u)),i):c?tu(f):f}function ed(t){var r=ki(t);if(0!==r.length)return e.Debug.assert(1===r.length),r[0]}function td(t,r){var n=nd(e.idText(t),xa(r),67216319);return n&&e.symbolName(n)}function rd(t,r,n){e.Debug.assert(void 0!==r,"outername should always be defined");var i=Sr(t,r,n,void 0,r,!1,!1,function(t,n,i){return e.Debug.assertEqual(r,n,"name should equal outerName"),vr(t,n,i)||nd(e.unescapeLeadingUnderscores(n),e.arrayFrom(t.values()),i)});return i&&e.symbolName(i)}function nd(t,r,n){for(var i,a=Math.min(2,Math.floor(.34*t.length)),o=Math.floor(.4*t.length)+1,s=!1,c=t.toLowerCase(),u=0,l=r;u<l.length;u++){var _=l[u],d=e.symbolName(_);if(_.flags&n&&Math.abs(d.length-c.length)<=a){var p=d.toLowerCase();if(p===c)return _;if(!(s||d.length<3)){var f=id(c,p,o-1);void 0!==f&&(f<3?(s=!0,i=_):(e.Debug.assert(f<o),o=f,i=_));}}}return i}function id(e,t,r){for(var n=new Array(t.length+1),i=new Array(t.length+1),a=r+1,o=0;o<=t.length;o++)n[o]=o;for(o=1;o<=e.length;o++){var s=e.charCodeAt(o-1),c=o>r?o-r:1,u=t.length>r+o?r+o:t.length;i[0]=o;for(var l=o,_=1;_<c;_++)i[_]=a;for(_=c;_<=u;_++){var d=s===t.charCodeAt(_-1)?n[_-1]:Math.min(n[_]+1,i[_-1]+1,n[_-1]+2);i[_]=d,l=Math.min(l,d);}for(_=u+1;_<=t.length;_++)i[_]=a;if(l>r)return;var p=n;n=i,i=p;}var f=n[t.length];return f>r?void 0:f}function ad(t,r,n){if(t&&N&&106500&t.flags&&t.valueDeclaration&&e.hasModifier(t.valueDeclaration,8)&&(!r||!e.isWriteOnlyAccess(r)||65536&t.flags&&!(32768&t.flags))){if(n){var i=e.findAncestor(r,e.isFunctionLikeDeclaration);if(i&&i.symbol===t)return}(1&e.getCheckFlags(t)?gr(t).target:t).isReferenced=67108863;}}function od(t,r,n,i){if(i===ee||zn(i))return!0;var a=Ra(i,n);return a?H_(t,r,i,a):e.isInJavaScriptFile(t)&&131072&i.flags&&i.types.some(function(e){return od(t,r,n,e)})}function sd(t){var r=t.initializer;if(231===r.kind){var n=r.declarations[0];if(n&&!e.isBindingPattern(n.name))return nn(n)}else if(71===r.kind)return Ju(r)}function cd(t){var r=$_(t.expression),n=t.argumentExpression;if(!n){var i,a=e.getSourceFileOfNode(t);return 186===t.parent.kind&&t.parent.expression===t?Ig(a,i=e.skipTrivia(a.text,t.expression.end),t.end-i,e.Diagnostics.new_T_cannot_be_used_to_create_an_array_Use_new_Array_T_instead):Ig(a,i=t.end-"]".length,t.end-i,e.Diagnostics.Expression_expected),ee}var o=function(t){var r,n=e.skipParentheses(t);if(71===n.kind){var i=Ju(n);if(3&i.flags)for(var a=t,o=t.parent;o;){if(219===o.kind&&a===o.statement&&sd(o)===i&&Ua(r=Lp(o.expression),1)&&!Ua(r,0))return!0;a=o,o=o.parent;}}return!1}(n)?oe:Rp(n);return r===ee||r===pe?r:vp(r)&&9!==n.kind?(sr(n,e.Diagnostics.A_const_enum_member_can_only_be_accessed_using_a_string_literal),ee):Yp(Es(r,o,t),t)}function ud(t,r,n){if(r===ee)return!1;if(!e.isWellKnownSymbolSyntactically(t))return!1;if(0==(1536&r.flags))return n&&sr(t,e.Diagnostics.A_computed_property_name_of_the_form_0_must_be_of_type_symbol,e.getTextOfNode(t)),!1;var i=t.expression,a=Ju(i);if(!a)return!1;var o=jo(!0);return!(!o||a!==o&&(n&&sr(i,e.Diagnostics.Symbol_reference_does_not_refer_to_the_global_Symbol_constructor_object),1))}function ld(t){return e.isCallOrNewExpression(t)}function _d(t){return ld(t)&&e.forEach(t.typeArguments,xm),187===t.kind?Rp(t.template):149!==t.kind&&e.forEach(t.arguments,function(e){Rp(e);}),at}function dd(e){return _d(e),ot}function pd(e){for(var t=0;t<e.length;t++){var r=e[t];if(r&&202===r.kind)return t}return-1}function fd(t,r,n,i){var a,o,s;void 0===i&&(i=!1);var c=-1;if(e.isJsxOpeningLikeElement(t))return!0;if(187===t.kind)if(a=r.length,o=void 0,200===t.template.kind){var u=e.lastOrUndefined(t.template.templateSpans);e.Debug.assert(void 0!==u),s=e.nodeIsMissing(u.literal)||!!u.literal.isUnterminated;}else{var l=t.template;e.Debug.assert(13===l.kind),s=!!l.isUnterminated;}else if(149===t.kind)o=void 0,a=kd(t,void 0,n);else{if(!t.arguments)return e.Debug.assert(186===t.kind),0===n.minArgumentCount;a=i?r.length+1:r.length,s=t.arguments.end===t.end,o=t.typeArguments,c=pd(r);}var _=e.length(n.typeParameters),d=Qa(n.typeParameters);if(o&&!(o.length>=d&&o.length<=_))return!1;if(c>=0)return Hc(n,c)||n.minArgumentCount<=c&&c<n.parameters.length;if(!n.hasRestParameter&&a>n.parameters.length)return!1;var p=a>=n.minArgumentCount;return s||p}function md(e){if(65536&e.flags){var t=ya(e);if(1===t.callSignatures.length&&0===t.constructSignatures.length&&0===t.properties.length&&!t.stringIndexInfo&&!t.numberIndexInfo)return t.callSignatures[0]}}function gd(t,r,n,i){var a=Du(t.typeParameters,t,1,i);return Tu(r,t,function(e,t){Iu(a.inferences,uc(e,n||T),t);}),n||Iu(a.inferences,io(r),io(t),8),oo(t,ju(a),e.isInJavaScriptFile(r.declaration))}function yd(e,t,r){var n=Zd(e,0),i=Np(t.attributes,n,T);Iu(r.inferences,i,n);var a=Zd(e,0),o=Np(t.attributes,a,r);return Iu(r.inferences,o,a),ju(r)}function hd(t,r,n,i,a){for(var o=0,s=a.inferences;o<s.length;o++){var c=s[o];c.isFixed||(c.inferredType=void 0);}if(149!==t.kind){var u=c_(t);if(u){var l=uc(u,function(e){return e&&function(e){return!!e.typeParameters}(e)?Du(e.typeParameters,e.signature,2|e.flags,e.compareTypes,e.inferences):e}(u_(t))),_=md(l),d=_&&_.typeParameters?po(oo(_,_.typeParameters,e.isInJavaScriptFile(t))):l,p=io(r);Iu(a.inferences,d,p,8);}}var f=to(r);if(f){var m=xd(t),g=m?Rp(m):_e;Iu(a.inferences,g,f);}for(var y=kd(t,n,r),h=0;h<y;h++)if(void 0===(x=Ed(t,n,h))||204!==x.kind){var v=Zd(r,h),b=Cd(t,h);void 0===b&&(b=Np(x,v,i&&void 0!==i[h]?T:a)),Iu(a.inferences,b,v);}if(i)for(h=0;h<y;h++)if(!1===i[h]){var x=n[h];v=Zd(r,h),Iu(a.inferences,Np(x,v,a),v);}return ju(a)}function vd(t,r,n,i){for(var a,o=e.isInJavaScriptFile(t.declaration),s=t.typeParameters,c=Ya(e.map(r,Hs),s,Qa(s),o),u=0;u<r.length;u++){e.Debug.assert(void 0!==s[u],"Should not call checkTypeArguments with too many type arguments");var l=ka(s[u]);if(l){var _=n&&i&&function(){return e.chainDiagnosticMessages(void 0,e.Diagnostics.Type_0_does_not_satisfy_the_constraint_1)},d=i||e.Diagnostics.Type_0_does_not_satisfy_the_constraint_1;a||(a=Qs(s,c));var p=c[u];if(!Tc(p,Xi(uc(l,a),p),n?r[u]:void 0,d,_))return!1}}return c}function bd(t,r,n,i,a,o){if(e.isJsxOpeningLikeElement(t))return function(t,r,n){if(t.attributes.end===t.end)return!0;for(var i=e.Diagnostics.Argument_of_type_0_is_not_assignable_to_parameter_of_type_1,a=Zd(r,0),o=Np(t.attributes,a,void 0),s=0,c=xa(o);s<c.length;s++){var u=c[s];if(!Ra(a,u.escapedName)&&D_(u.escapedName))return!1}return Ic(o,a,n,void 0,i)}(t,n,i);var s=to(n);if(s&&s!==_e&&186!==t.kind){var c=xd(t),u=c?Rp(c):_e,l=o?c||t:void 0,_=e.Diagnostics.The_this_context_of_type_0_is_not_assignable_to_method_s_this_of_type_1;if(!Ic(u,to(n),i,l,_))return!1}for(var d=e.Diagnostics.Argument_of_type_0_is_not_assignable_to_parameter_of_type_1,p=kd(t,r,n),f=0;f<p;f++){var m=Ed(t,r,f);if(void 0===m||204!==m.kind){var g=Zd(n,f),y=Cd(t,f)||Np(m,g,a&&a[f]?T:void 0);if(!Ic(a?mu(y):y,g,i,l=o?Nd(t,f,m):void 0,d))return!1}}return!0}function xd(e){if(185===e.kind){var t=e.expression;if(183===t.kind)return t.expression;if(184===t.kind)return t.expression}}function Sd(t){if(187===t.kind){var r=t.template,n=[void 0];return 200===r.kind&&e.forEach(r.templateSpans,function(e){n.push(e.expression);}),n}return 149===t.kind?void 0:e.isJsxOpeningLikeElement(t)?t.attributes.properties.length>0?[t.attributes]:e.emptyArray:t.arguments||e.emptyArray}function kd(e,t,r){if(149!==e.kind)return t.length;switch(e.parent.kind){case 233:case 203:return 1;case 151:return 2;case 153:case 155:case 156:return 0===C?2:r.parameters.length>=3?3:2;case 148:return 3}}function Td(t){return 233===t.kind?ui(nn(t)):148===t.kind&&154===(t=t.parent).kind?ui(nn(t)):151===t.kind||153===t.kind||155===t.kind||156===t.kind?function(t){var r=nn(t.parent);return e.hasModifier(t,32)?ui(r):Fi(r)}(t):(e.Debug.fail("Unsupported decorator target."),ee)}function Dd(t,r){return 0===r?Td(t.parent):1===r?function(t){if(233===t.kind)return e.Debug.fail("Class decorators should not have a second synthetic argument."),ee;if(148===t.kind&&154===(t=t.parent).kind)return Q;if(151===t.kind||153===t.kind||155===t.kind||156===t.kind){var r=t;switch(r.name.kind){case 71:return qs(e.idText(r.name));case 8:case 9:return qs(r.name.text);case 146:var n=x_(r.name);return yp(n,1536)?n:ae;default:return e.Debug.fail("Unsupported property name."),ee}}return e.Debug.fail("Unsupported decorator target."),ee}(t.parent):2===r?function(t){return 233===t.kind?(e.Debug.fail("Class decorators should not have a third synthetic argument."),ee):148===t.kind?oe:151===t.kind?(e.Debug.fail("Property decorators should not have a third synthetic argument."),ee):153===t.kind||155===t.kind||156===t.kind?Yo(Im(t)):(e.Debug.fail("Unsupported decorator target."),ee)}(t.parent):(e.Debug.fail("Decorators should not have a fourth synthetic argument."),ee)}function Cd(e,t){return 149===e.kind?Dd(e,t):0===t&&187===e.kind?Ze||(Ze=Ko("TemplateStringsArray",0,!0))||ge:void 0}function Ed(e,t,r){if(149!==e.kind&&(0!==r||187!==e.kind))return t[r]}function Nd(e,t,r){return 149===e.kind?e.expression:0===t&&187===e.kind?e.template:r}function Ad(t,r,n,i){var o,s=187===t.kind,c=149===t.kind,u=e.isJsxOpeningLikeElement(t);s||c||u||(o=t.typeArguments,97!==t.expression.kind&&e.forEach(o,xm));var l=n||[];if(function(t,r){var n,i,a,o,s=0,c=-1;e.Debug.assert(!r.length);for(var u=0,l=t;u<l.length;u++){var _=l[u],d=_.declaration&&nn(_.declaration),p=_.declaration&&_.declaration.parent;i&&d!==i?(a=s=r.length,n=p):n&&p===n?a++:(n=p,a=s),i=d,_.hasLiteralTypes?(o=++c,s++):o=a,r.splice(o,0,_);}}(r,l),!l.length)return Lt.add(e.createDiagnosticForNode(t,e.Diagnostics.Call_target_does_not_contain_any_signatures)),dd(t);var _,d,p,f,m=Sd(t),g=1===l.length&&!l[0].typeParameters,y=0;if(!c&&!g)for(var h=s?1:0;h<m.length;h++)dc(m[h])&&(_||(_=new Array(m.length)),_[h]=!0,y++);var v=n&&185===t.kind&&t.arguments.hasTrailingComma;if(l.length>1&&(f=R(l,Yt,v)),f||(f=R(l,Zt,v)),f)return f;if(d){if(u)return d;bd(t,m,d,Zt,void 0,!0);}else if(p)vd(p,t.typeArguments,!0,i);else if(o&&e.every(r,function(t){return e.length(t.typeParameters)!==o.length})){for(var b=Number.POSITIVE_INFINITY,x=Number.NEGATIVE_INFINITY,S=0,k=r;S<k.length;S++){var T=k[S];b=Math.min(b,Qa(T.typeParameters)),x=Math.max(x,e.length(T.typeParameters));}var D=b<x?b+"-"+x:b;Lt.add(e.createDiagnosticForNodeArray(e.getSourceFileOfNode(t),o,e.Diagnostics.Expected_0_type_arguments_but_got_1,D,o.length));}else if(m){b=Number.POSITIVE_INFINITY,x=Number.NEGATIVE_INFINITY;for(var C=0,E=r;C<E.length;C++)T=E[C],b=Math.min(b,T.minArgumentCount),x=Math.max(x,T.parameters.length);var N=e.some(r,function(e){return e.hasRestParameter}),A=pd(m)>-1,P=(D=N?b:b<x?b+"-"+x:b,m.length);P<=x&&A&&P--;var w=N&&A?e.Diagnostics.Expected_at_least_0_arguments_but_got_1_or_more:N?e.Diagnostics.Expected_at_least_0_arguments_but_got_1:A?e.Diagnostics.Expected_0_arguments_but_got_1_or_more:e.Diagnostics.Expected_0_arguments_but_got_1;Lt.add(e.createDiagnosticForNode(t,w,D,P));}else i&&Lt.add(e.createDiagnosticForNode(t,i));if(!a){e.Debug.assert(l.length>0);var F=function(e,t){for(var r=-1,n=-1,i=0;i<e.length;i++){var a=e[i];if(a.hasRestParameter||a.parameters.length>=t)return i;a.parameters.length>n&&(n=a.parameters.length,r=i);}return r}(l,void 0===B?m.length:B),O=l[F],I=O.typeParameters;if(I&&ld(t)&&t.typeArguments){for(var M=t.typeArguments.map(Im);M.length>I.length;)M.pop();for(;M.length<I.length;)M.push(Ku(e.isInJavaScriptFile(t)));var L=so(O,M);return l[F]=L,L}return O}return dd(t);function R(r,n,i){if(void 0===i&&(i=!1),d=void 0,p=void 0,g){var a=r[0];if(!fd(t,m,a,i))return;return bd(t,m,a,n,_,!1)?a:void(d=a)}for(var s=0;s<r.length;s++){var c=r[s];if(fd(t,m,c,i)){a=void 0;for(var u=c.typeParameters?Du(c.typeParameters,c,e.isInJavaScriptFile(t)?4:0):void 0;;){if((a=c).typeParameters){var l=void 0;if(o){var f=vd(a,o,!1);if(!f){p=c;break}l=f;}else l=hd(t,a,m,_,u);a=oo(a,l,e.isInJavaScriptFile(a.declaration));}if(!bd(t,m,a,n,_,!1)){d=a;break}if(0===y)return r[s]=a,a;--y>0?_[_.indexOf(!0)]=!1:_=void 0;}}}}}function Pd(e,t,r,n){return zn(e)||zn(t)&&32768&e.flags||!r&&!n&&!(147456&t.flags)&&bc(e,Ae)}function wd(t,r){if(t.arguments&&C<1){var n=pd(t.arguments);n>=0&&sr(t.arguments[n],e.Diagnostics.Spread_operator_in_new_expressions_is_only_available_when_targeting_ECMAScript_5_and_higher);}var i=$_(t.expression);if(i===pe)return ct;if((i=Oa(i))===ee)return dd(t);if(zn(i))return t.typeArguments&&sr(t,e.Diagnostics.Untyped_function_calls_may_not_accept_type_arguments),_d(t);var a=Ka(i,1);if(a.length){if(!function(t,r){if(!r||!r.declaration)return!0;var n=r.declaration,i=e.getSelectedModifierFlags(n,24);if(!i)return!0;var a=e.getClassLikeDeclarationOfSymbol(n.parent.symbol),o=Fi(n.parent.symbol);if(!Pm(t,a)){var s=e.getContainingClass(t);if(s)for(var c=Im(s),u=ki(c);u.length;){var l=u[0];if(16&i&&l.symbol===n.parent.symbol)return!0;u=ki(l);}return 8&i&&sr(t,e.Diagnostics.Constructor_of_class_0_is_private_and_only_accessible_within_the_class_declaration,En(o)),16&i&&sr(t,e.Diagnostics.Constructor_of_class_0_is_protected_and_only_accessible_within_the_class_declaration,En(o)),!1}return!0}(t,a[0]))return dd(t);var o=i.symbol&&e.getClassLikeDeclarationOfSymbol(i.symbol);return o&&e.hasModifier(o,128)?(sr(t,e.Diagnostics.Cannot_create_an_instance_of_an_abstract_class),dd(t)):Ad(t,a,r)}var s=Ka(i,0);if(s.length){var c=Ad(t,s,r);return jd(c.declaration)||io(c)===_e||sr(t,e.Diagnostics.Only_a_void_function_can_be_called_with_the_new_keyword),to(c)===_e&&sr(t,e.Diagnostics.A_function_that_is_called_with_the_new_keyword_cannot_have_a_this_type_that_is_void),c}return Fd(t,i,1),dd(t)}function Fd(t,r,n){sr(t,0===n?e.Diagnostics.Cannot_invoke_an_expression_whose_type_lacks_a_call_signature_Type_0_has_no_compatible_call_signatures:e.Diagnostics.Cannot_use_new_with_an_expression_whose_type_lacks_a_call_or_construct_signature,En(r)),Od(r,n);}function Od(t,r){if(t.symbol){var n=gr(t.symbol).originatingImport;if(n&&!e.isImportCall(n)){var i=Ka(ui(gr(t.symbol).target),r);if(!i||!i.length)return;sr(n,e.Diagnostics.A_namespace_style_import_cannot_be_called_or_constructed_and_will_cause_a_failure_at_runtime);}}}function Id(t){switch(t.parent.kind){case 233:case 203:return e.Diagnostics.Unable_to_resolve_signature_of_class_decorator_when_called_as_an_expression;case 148:return e.Diagnostics.Unable_to_resolve_signature_of_parameter_decorator_when_called_as_an_expression;case 151:return e.Diagnostics.Unable_to_resolve_signature_of_property_decorator_when_called_as_an_expression;case 153:case 155:case 156:return e.Diagnostics.Unable_to_resolve_signature_of_method_decorator_when_called_as_an_expression}}function Md(t,r){var n=Rp(t.expression),i=Oa(n);if(i===ee)return dd(t);var a,o,s=Ka(i,0),c=Ka(i,1);if(Pd(n,i,s.length,c.length))return _d(t);if(a=t,(o=s).length&&e.every(o,function(e){return 0===e.minArgumentCount&&!e.hasRestParameter&&e.parameters.length<kd(a,void 0,e)})){var u=e.getTextOfNode(t.expression,!1);return sr(t,e.Diagnostics._0_accepts_too_few_arguments_to_be_used_as_a_decorator_here_Did_you_mean_to_call_it_first_and_write_0,u),dd(t)}var l=Id(t);if(!s.length){var _=void 0;return _=e.chainDiagnosticMessages(_,e.Diagnostics.Cannot_invoke_an_expression_whose_type_lacks_a_call_signature_Type_0_has_no_compatible_call_signatures,En(i)),_=e.chainDiagnosticMessages(_,l),Lt.add(e.createDiagnosticForNodeFromMessageChain(t,_)),Od(i,0),dd(t)}return Ad(t,s,r,l)}function Ld(t,r,n){return e.Debug.assert(!(131072&r.flags)),Rd(t,r,n)}function Rd(e,t,r){if(131072&t.flags){for(var n=void 0,i=0,a=t.types;i<a.length;i++){var o=a[i];n=n||Rd(e,o,r);}return n}var s=t&&Ka(t,0);if(s&&s.length>0)return Ad(e,s,r)}function Bd(t,r){switch(t.kind){case 185:return function(t,r){if(97===t.expression.kind){var n=Vl(t.expression);if(n!==ee){var i=e.getClassExtendsHeritageClauseElement(e.getContainingClass(t));if(i)return Ad(t,xi(n,i.typeArguments,i),r)}return _d(t)}var a=$_(t.expression,e.Diagnostics.Cannot_invoke_an_object_which_is_possibly_null,e.Diagnostics.Cannot_invoke_an_object_which_is_possibly_undefined,e.Diagnostics.Cannot_invoke_an_object_which_is_possibly_null_or_undefined);if(a===pe)return ct;var o=Oa(a);if(o===ee)return dd(t);var s=Ka(o,0),c=Ka(o,1);return Pd(a,o,s.length,c.length)?(a!==ee&&t.typeArguments&&sr(t,e.Diagnostics.Untyped_function_calls_may_not_accept_type_arguments),_d(t)):s.length?Ad(t,s,r):(c.length?sr(t,e.Diagnostics.Value_of_type_0_is_not_callable_Did_you_mean_to_include_new,En(a)):Fd(t,o,0),dd(t))}(t,r);case 186:return wd(t,r);case 187:return function(e,t){var r=Rp(e.tag),n=Oa(r);if(n===ee)return dd(e);var i=Ka(n,0),a=Ka(n,1);return Pd(r,n,i.length,a.length)?_d(e):i.length?Ad(e,i,t):(Fd(e,n,0),dd(e))}(t,r);case 149:return Md(t,r);case 255:case 254:return Rd(t,Rp(t.tagName),r)||ot}e.Debug.assertNever(t,"Branch in 'resolveSignature' should be unreachable.");}function Kd(e,t){var r=yr(e),n=r.resolvedSignature;if(n&&n!==st&&!t)return n;r.resolvedSignature=st;var i=Bd(e,t);return r.resolvedSignature=pt===ft?i:n,i}function jd(t){if(t&&e.isInJavaScriptFile(t)){if(e.getJSDocClassTag(t))return!0;var r=e.isFunctionDeclaration(t)||e.isFunctionExpression(t)?nn(t):e.isVariableDeclaration(t)&&t.initializer&&e.isFunctionExpression(t.initializer)?nn(t.initializer):void 0;return r&&void 0!==r.members}return!1}function Jd(t){var r=t.valueDeclaration,n=r&&r.parent&&(e.isBinaryExpression(r.parent)&&nn(r.parent.left)||e.isVariableDeclaration(r.parent)&&nn(r.parent));if(n){var i=e.forEach(n.declarations,zd);if(i)return Rp(i)}}function zd(t){if(!t.parent)return!1;for(var r=t.parent;r&&183===r.kind;)r=r.parent;return r&&e.isBinaryExpression(r)&&e.isPropertyAccessExpression(r.left)&&"prototype"===r.left.name.escapedText&&58===r.operatorToken.kind&&e.isObjectLiteralExpression(r.right)&&r.right}function Ud(t){var r=gr(t);return r.inferredClassType||(r.inferredClassType=mn(t,Gi(t)||k,e.emptyArray,e.emptyArray,void 0,void 0)),r.inferredClassType}function qd(t){return t.symbol&&16&e.getObjectFlags(t)&&gr(t.symbol).inferredClassType===t}function Vd(t){vg(t,t.typeArguments)||bg(t.arguments);var r=Kd(t);if(97===t.expression.kind)return _e;if(186===t.kind){var n=r.declaration;if(n&&154!==n.kind&&158!==n.kind&&163!==n.kind&&!e.isJSDocConstructSignature(n)){var i=Rp(t.expression).symbol;i||71!==t.expression.kind||(i=Ju(t.expression));var a=i&&function(t){var r,n=e.getDeclaredJavascriptInitializer(t.valueDeclaration);n&&(t=nn(n)),jd(t.valueDeclaration)&&(r=Ud(t));var i=Jd(t),a=ui(t);return a.symbol&&!qd(a)&&jd(a.symbol.valueDeclaration)&&(r=Ud(a.symbol)),i&&r?ys([r,i]):i||r}(i);return a||(O&&sr(t,e.Diagnostics.new_expression_whose_target_lacks_a_construct_signature_implicitly_has_an_any_type),Q)}}if(e.isInJavaScriptFile(t)&&$d(t))return function(e){var t=Ur(e,e);if(t){var r=Hr(t);if(r)return ui(r)}return Q}(t.arguments[0]);var o=io(r);return 1536&o.flags&&Wd(t)?Vs(e.walkUpParenthesizedExpressions(t.parent)):o}function Wd(t){if(!e.isCallExpression(t))return!1;var r=t.expression;if(e.isPropertyAccessExpression(r)&&"for"===r.name.escapedText&&(r=r.expression),!e.isIdentifier(r)||"Symbol"!==r.escapedText)return!1;var n=jo(!1);return!!n&&n===xr(r,"Symbol",67216319,void 0,void 0,!1)}function Hd(t){if(bg(t.arguments)||function(t){if(E===e.ModuleKind.ES2015)return Mg(t,e.Diagnostics.Dynamic_import_cannot_be_used_when_targeting_ECMAScript_2015_modules);if(t.typeArguments)return Mg(t,e.Diagnostics.Dynamic_import_cannot_have_type_arguments);var r=t.arguments;if(1!==r.length)return Mg(t,e.Diagnostics.Dynamic_import_must_have_one_specifier_as_an_argument);e.isSpreadElement(r[0])&&Mg(r[0],e.Diagnostics.Specifier_of_dynamic_import_cannot_be_spread_element);}(t),0===t.arguments.length)return np(t,Q);for(var r=t.arguments[0],n=Ap(r),i=1;i<t.arguments.length;++i)Ap(t.arguments[i]);(4096&n.flags||8192&n.flags||!bc(n,ae))&&sr(r,e.Diagnostics.Dynamic_import_s_specifier_must_be_of_type_string_but_here_has_type_0,En(n));var a=Ur(t,r);if(a){var o=Gr(a,r,!0);if(o)return np(t,Gd(ui(o),o,a))}return np(t,Q)}function Gd(t,r,n){if(A&&t&&t!==ee){var i=t;if(!i.syntheticType)if(wr(e.find(n.declarations,e.isSourceFile),n,!1)){var a=e.createSymbolTable(),o=cr(2097152,"default");o.target=Lr(r),a.set("default",o);var s=cr(2048,"__type"),c=mn(s,a,e.emptyArray,e.emptyArray,void 0,void 0);s.type=c,i.syntheticType=T_(t)?Rs(t,c,s,0,0):c;}else i.syntheticType=t;return i.syntheticType}return t}function $d(t){if(!e.isRequireCall(t,!0))return!1;if(!e.isIdentifier(t.expression))return e.Debug.fail();var r=xr(t.expression,t.expression.escapedText,67216319,void 0,void 0,!0);if(!r)return!0;if(2097152&r.flags)return!1;var n=16&r.flags?232:3&r.flags?230:0;if(0!==n){var i=e.getDeclarationOfKind(r,n);return!!i&&!!(2097152&i.flags)}return!1}function Xd(t,r,n,i){var o=mu(tu(Rp(n,i)));xm(r);var s=Hs(r);return a&&s!==ee&&(Sc(s,bu(o))||Dc(o,s,t,e.Diagnostics.Type_0_cannot_be_converted_to_type_1)),s}function Qd(t){!function(t){94===t.keywordToken&&"target"!==t.name.escapedText&&Mg(t.name,e.Diagnostics._0_is_not_a_valid_meta_property_for_keyword_1_Did_you_mean_2,t.name.escapedText,e.tokenToString(t.keywordToken),"target");}(t);var r=e.getNewTargetContainer(t);return r?154===r.kind?ui(nn(r.parent)):ui(nn(r)):(sr(t,e.Diagnostics.Meta_property_0_is_only_allowed_in_the_body_of_a_function_declaration_function_expression_or_constructor,"new.target"),ee)}function Yd(t){var r=ui(t);if(P){var n=t.valueDeclaration;if(n&&e.hasInitializer(n))return _u(r)}return r}function Zd(e,t){return e.hasRestParameter?t<e.parameters.length-1?Yd(e.parameters[t]):ao(e):t<e.parameters.length?Yd(e.parameters[t]):Q}function ep(e){return e.parameters.length>0?Zd(e,0):de}function tp(t,r){var n=gr(t);if(!n.type){n.type=r;var i=t.valueDeclaration;71!==i.name.kind&&(n.type===ge&&(n.type=Yn(i.name)),function t(r){for(var n=0,i=r.elements;n<i.length;n++){var a=i[n];e.isOmittedExpression(a)||(71===a.name.kind?gr(nn(a)).type=Wn(a):t(a.name));}}(i.name));}}function rp(e){var t=zo(!0);return t!==ve?So(t,[e=cf(e)||ge]):ge}function np(t,r){var n=rp(r);return n===ge?(sr(t,e.isImportCall(t)?e.Diagnostics.A_dynamic_import_call_returns_a_Promise_Make_sure_you_have_a_declaration_for_Promise_or_include_ES2015_in_your_lib_option:e.Diagnostics.An_async_function_or_method_must_return_a_Promise_Make_sure_you_have_a_declaration_for_Promise_or_include_ES2015_in_your_lib_option),ee):(Uo(!0)||sr(t,e.isImportCall(t)?e.Diagnostics.A_dynamic_import_call_in_ES5_SlashES3_requires_the_Promise_constructor_Make_sure_you_have_a_declaration_for_the_Promise_constructor_or_include_ES2015_in_your_lib_option:e.Diagnostics.An_async_function_or_method_in_ES5_SlashES3_requires_the_Promise_constructor_Make_sure_you_have_a_declaration_for_the_Promise_constructor_or_include_ES2015_in_your_lib_option),n)}function ip(t,r){if(!t.body)return ee;var n,i=e.getFunctionFlags(t);if(211!==t.body.kind)n=Ap(t.body,r),2&i&&(n=sf(n,t,e.Diagnostics.The_return_type_of_an_async_function_must_either_be_a_valid_promise_or_must_not_contain_a_callable_then_member));else{var a=function(t,r){var n=e.getFunctionFlags(t),i=[],a=sp(t),o=!1;if(e.forEachReturnStatement(t.body,function(s){var c=s.expression;if(c){var u=Ap(c,r);2&n&&(u=sf(u,t,e.Diagnostics.The_return_type_of_an_async_function_must_either_be_a_valid_promise_or_must_not_contain_a_callable_then_member)),16384&u.flags&&(o=!0),e.pushIfUnique(i,u);}else a=!0;}),0!==i.length||a||!o&&!function(e){switch(e.kind){case 190:case 191:return!0;case 153:return 182===e.parent.kind;default:return!1}}(t))return P&&i.length&&a&&e.pushIfUnique(i,te),i}(t,r);if(1&i){if(!(a=e.concatenate(function(t,r){var n=[],i=0!=(2&e.getFunctionFlags(t));return e.forEachYieldExpression(t.body,function(t){e.pushIfUnique(n,ap(t,i,r));}),n}(t,r),a))||0===a.length){var o=2&i?Zo(Q):ts(Q);return O&&sr(t.asteriskToken,e.Diagnostics.Generator_implicitly_has_type_0_because_it_does_not_yield_any_values_Consider_supplying_a_return_type,En(o)),o}}else{if(!a)return 2&i?np(t,de):de;if(0===a.length)return 2&i?np(t,_e):_e}n=ds(a,2);}var s=f_(t);if(s||ku(t,n),Zc(n)){var c=s?s===Za(t)?n:io(s):void 0;if(c)switch(3&i){case 3:c=Hf(c,!0);break;case 1:c=Hf(c,!1);break;case 2:c=of(c);}n=iu(n,c);}var u=bu(n);switch(3&i){case 3:return Zo(u);case 1:return ts(u);case 2:return rp(u);default:return u}}function ap(t,r,n){var i=t.expression||t,a=t.expression?Ap(t.expression,n):re,o=t.asteriskToken?Uf(a,i,!1,r):a;return r?cf(o,i,t.asteriskToken?e.Diagnostics.Type_of_iterated_elements_of_a_yield_Asterisk_operand_must_either_be_a_valid_promise_or_must_not_contain_a_callable_then_member:e.Diagnostics.Type_of_yield_operand_in_an_async_generator_must_either_be_a_valid_promise_or_must_not_contain_a_callable_then_member):o}function op(t){if(!t.possiblyExhaustive)return!1;var r=Lp(t.expression);if(!eu(r))return!1;var n,i,a=ll(t);return!!a.length&&(n=fl(r,Us),i=a,131072&n.flags?!e.forEach(n.types,function(t){return!e.contains(i,t)}):e.contains(i,n))}function sp(t){return!!(128&t.flags)&&!e.some(t.body.statements,function(e){return 225===e.kind&&op(e)})}function cp(t,r){if(a&&(!r||!gp(r,2049))&&152!==t.kind&&!e.nodeIsMissing(t.body)&&211===t.body.kind&&sp(t)){var n=256&t.flags;if(r&&16384&r.flags)sr(e.getEffectiveReturnTypeNode(t),e.Diagnostics.A_function_returning_never_cannot_have_a_reachable_end_point);else if(r&&!n)sr(e.getEffectiveReturnTypeNode(t),e.Diagnostics.A_function_whose_declared_type_is_neither_void_nor_any_must_return_a_value);else if(r&&P&&!bc(te,r))sr(e.getEffectiveReturnTypeNode(t),e.Diagnostics.Function_lacks_ending_return_statement_and_return_type_does_not_include_undefined);else if(D.noImplicitReturns){if(!r){if(!n)return;if(Xf(t,io(Za(t))))return}sr(e.getEffectiveReturnTypeNode(t)||t,e.Diagnostics.Not_all_code_paths_return_a_value);}}}function up(t,r){if(e.Debug.assert(153!==t.kind||e.isObjectLiteralMethod(t)),1===r&&dc(t))return km(t),be;hg(t)||190!==t.kind||Tg(t);var n=yr(t),i=ui(t.symbol);if(!(1024&n.flags)){var o=g_(t);if(!(1024&n.flags)){if(n.flags|=1024,o){var s=Ka(i,0)[0];if(dc(t)){var c=u_(t);2===r&&function(t,r,n){for(var i=t.parameters.length-(t.hasRestParameter?1:0),a=0;a<i;a++){var o=t.parameters[a].valueDeclaration;if(o.type){var s=e.getEffectiveTypeAnnotationNode(o);s&&Iu(n.inferences,Hs(s),Zd(r,a));}}}(s,o,c),function(t,r){t.typeParameters=r.typeParameters,r.thisParameter&&(!(a=t.thisParameter)||a.valueDeclaration&&!a.valueDeclaration.type)&&(a||(t.thisParameter=fu(r.thisParameter,void 0)),tp(t.thisParameter,ui(r.thisParameter)));for(var n=t.parameters.length-(t.hasRestParameter?1:0),i=0;i<n;i++){var a=t.parameters[i];e.getEffectiveTypeAnnotationNode(a.valueDeclaration)||tp(a,Zd(r,i));}t.hasRestParameter&&Hc(r,t.parameters.length-1)&&(!ur(a=e.lastOrUndefined(t.parameters))&&e.getEffectiveTypeAnnotationNode(a.valueDeclaration)||tp(a,ui(e.lastOrUndefined(r.parameters))));}(s,c===T?o:nc(o,c));}if(!e.getEffectiveReturnTypeNode(t)&&!s.resolvedReturnType){var u=ip(t,r);s.resolvedReturnType||(s.resolvedReturnType=u);}}Jp(t),km(t);}}return a&&153!==t.kind&&(Pf(t,t.name),Cf(t,t.name),Ef(t,t.name)),i}function lp(t){e.Debug.assert(153!==t.kind||e.isObjectLiteralMethod(t));var r=e.getFunctionFlags(t),n=e.getEffectiveReturnTypeNode(t),i=n&&(2==(3&r)?uf(t):Hs(n));if(0==(1&r)&&cp(t,i),t.body){if(n||io(Za(t)),211===t.body.kind)xm(t.body);else{var a=Rp(t.body);i&&Tc(2==(3&r)?sf(a,t.body,e.Diagnostics.The_return_type_of_an_async_function_must_either_be_a_valid_promise_or_must_not_contain_a_callable_then_member):a,i,t.body);}yf(t);}}function _p(e,t,r){return!!yp(t,84)||(sr(e,r),!1)}function dp(t){return!!(8&e.getCheckFlags(t)||4&t.flags&&64&e.getDeclarationModifierFlagsFromSymbol(t)||3&t.flags&&2&V_(t)||98304&t.flags&&!(65536&t.flags)||8&t.flags)}function pp(t,r){if(dp(r)){if(4&r.flags&&(183===t.kind||184===t.kind)&&99===t.expression.kind){var n=e.getContainingFunction(t);return!n||154!==n.kind||!(n.parent===r.valueDeclaration.parent||n===r.valueDeclaration.parent)}return!0}return!1}function fp(t){if(183===t.kind||184===t.kind){var r=e.skipParentheses(t.expression);if(71===r.kind){var n=yr(r).resolvedSymbol;if(2097152&n.flags){var i=Ar(n);return i&&244===i.kind}}}return!1}function mp(t,r){var n=e.skipOuterExpressions(t,3);return 71===n.kind||183===n.kind||184===n.kind||(sr(t,r),!1)}function gp(e,t){if(e.flags&t||536870912&t&&ga(e))return!0;if(393216&e.flags)for(var r=0,n=e.types;r<n.length;r++)if(gp(n[r],t))return!0;return!1}function yp(e,t,r){return!!(e.flags&t)||!(r&&14337&e.flags)&&(84&t&&bc(e,oe)||524322&t&&bc(e,ae)||136&t&&bc(e,ue)||2048&t&&bc(e,_e)||16384&t&&bc(e,de)||8192&t&&bc(e,ne)||4096&t&&bc(e,te)||512&t&&bc(e,le)||134217728&t&&bc(e,me))}function hp(t,r,n){return 131072&t.flags?e.every(t.types,function(e){return hp(e,r,n)}):yp(t,r,n)}function vp(t){return 16&e.getObjectFlags(t)&&t.symbol&&bp(t.symbol)}function bp(e){return 0!=(128&e.flags)}function xp(t,r,n){if(268===r.kind||269===r.kind){var i=r.name;if(146===i.kind&&x_(i),qn(i))return;var a=e.getTextOfPropertyName(i);if(c=zn(t)?t:Jn(t,a)||b_(a)&&Ua(t,1)||Ua(t,0))return 269===r.kind?kp(r,c):kp(r.initializer,c);sr(i,e.Diagnostics.Type_0_has_no_property_1_and_no_string_index_signature,En(t),e.declarationNameToString(i));}else{if(270===r.kind){C<6&&dg(r,4);var o=[];if(n)for(var s=0;s<n.length-1;s++)o.push(n[s].name);var c=Vn(t,o,t.symbol);return kp(r.expression,c)}sr(r,e.Diagnostics.Property_assignment_expected);}}function Sp(t,r,n,i,a){var o=t.elements,s=o[n];if(204!==s.kind)if(202!==s.kind){var c=""+n,u=zn(r)?r:Yc(r)?Jn(r,c):i;if(u)return kp(s,u,a);Rp(s),au(r)?sr(s,e.Diagnostics.Tuple_type_0_with_length_1_cannot_be_assigned_to_tuple_with_length_2,En(r),To(r),o.length):sr(s,e.Diagnostics.Type_0_has_no_property_1,En(r),c);}else if(n<o.length-1)sr(s,e.Diagnostics.A_rest_element_must_be_last_in_a_destructuring_pattern);else{var l=s.expression;if(198!==l.kind||58!==l.operatorToken.kind)return kp(l,rs(i),a);sr(l.operatorToken,e.Diagnostics.A_rest_element_cannot_have_an_initializer);}}function kp(t,r,n){var i;if(269===t.kind){var a=t;a.objectAssignmentInitializer&&(!P||4096&su(Rp(a.objectAssignmentInitializer))||(r=Qu(r,131072)),Cp(a.name,a.equalsToken,a.objectAssignmentInitializer,n)),i=t.name;}else i=t;return 198===i.kind&&58===i.operatorToken.kind&&(Dp(i,n),i=i.left),182===i.kind?function(e,t){var r=e.properties;if(P&&0===r.length)return X_(t,e);for(var n=0,i=r;n<i.length;n++)xp(t,i[n],r);return t}(i,r):181===i.kind?function(e,t,r){C<2&&D.downlevelIteration&&dg(e,512);for(var n=Uf(t,e,!1,!1)||ee,i=e.elements,a=0;a<i.length;a++)Sp(e,t,a,n,r);return t}(i,r,n):function(t,r,n){var i=Rp(t,n),a=270===t.parent.kind?e.Diagnostics.The_target_of_an_object_rest_assignment_must_be_a_variable_or_a_property_access:e.Diagnostics.The_left_hand_side_of_an_assignment_expression_must_be_a_variable_or_a_property_access;return mp(t,a)&&Tc(r,i,t,void 0),r}(i,r,n)}function Tp(e,t){return 0!=(12288&t.flags)||Sc(e,t)}function Dp(t,r){return e.isInJavaScriptFile(t)&&e.getAssignedJavascriptInitializer(t)?Rp(t.right,r):Cp(t.left,t.operatorToken,t.right,r,t)}function Cp(t,r,n,i,o){var s=r.kind;if(58===s&&(182===t.kind||181===t.kind))return kp(t,Rp(n,i),i);var c,u,l=Rp(t,i),_=Rp(n,i);switch(s){case 39:case 40:case 61:case 62:case 41:case 63:case 42:case 64:case 38:case 60:case 45:case 65:case 46:case 66:case 47:case 67:case 49:case 69:case 50:case 70:case 48:case 68:if(l===pe||_===pe)return pe;l=X_(l,t),_=X_(_,n);var d=void 0;if(136&l.flags&&136&_.flags&&void 0!==(d=function(e){switch(e){case 49:case 69:return 54;case 50:case 70:return 35;case 48:case 68:return 53;default:return}}(r.kind)))sr(o||r,e.Diagnostics.The_0_operator_is_not_allowed_for_boolean_types_Consider_using_1_instead,e.tokenToString(r.kind),e.tokenToString(d));else{var p=_p(t,l,e.Diagnostics.The_left_hand_side_of_an_arithmetic_operation_must_be_of_type_any_number_or_an_enum_type),f=_p(n,_,e.Diagnostics.The_right_hand_side_of_an_arithmetic_operation_must_be_of_type_any_number_or_an_enum_type);p&&f&&v(oe);}return oe;case 37:case 59:if(l===pe||_===pe)return pe;yp(l,524322)||yp(_,524322)||(l=X_(l,t),_=X_(_,n));var m=void 0;return yp(l,84,!0)&&yp(_,84,!0)?m=oe:yp(l,524322,!0)||yp(_,524322,!0)?m=ae:(zn(l)||zn(_))&&(m=l===ee||_===ee?ee:Q),m&&!h(s)?m:m?(59===s&&v(m),m):(b(),Q);case 27:case 29:case 30:case 31:return h(s)&&(l=tu(X_(l,t)),_=tu(X_(_,n)),Sc(l,_)||Sc(_,l)||b()),ue;case 32:case 33:case 34:case 35:var g=eu(l),y=eu(_);return g&&y||(l=g?tu(l):l,_=y?tu(_):_),Tp(l,_)||Tp(_,l)||b(),ue;case 93:return function(t,r,n,i){return n===pe||i===pe?pe:(!zn(n)&&hp(n,16382)&&sr(t,e.Diagnostics.The_left_hand_side_of_an_instanceof_expression_must_be_of_type_any_an_object_type_or_a_type_parameter),zn(i)||Rm(i)||vc(i,Ae)||sr(r,e.Diagnostics.The_right_hand_side_of_an_instanceof_expression_must_be_of_type_any_or_of_a_type_assignable_to_the_Function_interface_type),ue)}(t,n,l,_);case 92:return function(t,r,n,i){return n===pe||i===pe?pe:(n=X_(n,t),i=X_(i,r),Sc(n,ae)||yp(n,1620)||sr(t,e.Diagnostics.The_left_hand_side_of_an_in_expression_must_be_of_type_any_string_number_or_symbol),yp(i,141590528)||sr(r,e.Diagnostics.The_right_hand_side_of_an_in_expression_must_be_of_type_any_an_object_type_or_a_type_parameter),ue)}(t,n,l,_);case 53:return 1048576&Xu(l)?ds([(u=P?l:tu(_),fl(u,uu)),_]):l;case 54:return 2097152&Xu(l)?ds([cu(l),_],2):l;case 58:return v(_),mu(_);case 26:return!D.allowUnreachableCode&&function t(r){switch((r=e.skipParentheses(r)).kind){case 71:case 9:case 12:case 187:case 200:case 13:case 8:case 101:case 86:case 95:case 140:case 190:case 203:case 191:case 181:case 182:case 193:case 207:case 254:case 253:return!0;case 199:return t(r.whenTrue)&&t(r.whenFalse);case 198:return!e.isAssignmentOperator(r.operatorToken.kind)&&t(r.left)&&t(r.right);case 196:case 197:switch(r.operator){case 51:case 37:case 38:case 52:return!0}return!1;case 194:case 188:case 206:default:return!1}}(t)&&(71!==(c=n).kind||"eval"!==c.escapedText)&&sr(t,e.Diagnostics.Left_side_of_comma_operator_is_unused_and_has_no_side_effects),_}function h(r){var i=gp(l,1536)?t:gp(_,1536)?n:void 0;return!i||(sr(i,e.Diagnostics.The_0_operator_cannot_be_applied_to_type_symbol,e.tokenToString(r)),!1)}function v(r){a&&e.isAssignmentOperator(s)&&mp(t,e.Diagnostics.The_left_hand_side_of_an_assignment_expression_must_be_a_variable_or_a_property_access)&&Tc(r,l,t,void 0);}function b(){sr(o||r,e.Diagnostics.Operator_0_cannot_be_applied_to_types_1_and_2,e.tokenToString(r.kind),En(l),En(_));}}function Ep(t){a&&(4096&t.flags&&!function(t){for(var r=t,n=t.parent;n;){if(e.isFunctionLike(n)&&r===n.body)return!1;if(e.isClassLike(r))return!0;r=n,n=n.parent;}return!1}(t)||Og(t,e.Diagnostics.A_yield_expression_is_only_allowed_in_a_generator_body),Xl(t)&&sr(t,e.Diagnostics.yield_expressions_cannot_be_used_in_a_parameter_initializer));var r=e.getContainingFunction(t),n=r?e.getFunctionFlags(r):0;if(!(1&n))return Q;t.asteriskToken&&(3==(3&n)&&C<6&&dg(t,26624),1==(3&n)&&C<2&&D.downlevelIteration&&dg(t,256));var i=0!=(2&n),o=ap(t,i),s=e.getEffectiveReturnTypeNode(r);return s&&Tc(o,Hf(Hs(s),i)||Q,t.expression||t,void 0),Q}function Np(e,t,r){var n=function(e){return 261===e.kind?e.parent.parent:e}(e),i=n.contextualType,a=n.contextualMapper;n.contextualType=t,n.contextualMapper=r;var o=Rp(e,r===T?1:r?2:3);return n.contextualType=i,n.contextualMapper=a,o}function Ap(e,t){var r=yr(e);if(!r.resolvedType){if(t)return Rp(e,t);var n=pt;pt=ft,r.resolvedType=Rp(e,t),pt=n;}return r.resolvedType}function Pp(t){return 188===(t=e.skipParentheses(t)).kind||206===t.kind}function wp(t){var r=e.isInJavaScriptFile(t)&&e.getDeclaredJavascriptInitializer(t)||t.initializer,n=Lp(r,!0);return 2&e.getCombinedNodeFlags(t)||64&e.getCombinedModifierFlags(t)&&!e.isParameterPropertyDeclaration(t)||Pp(r)?n:ru(n)}function Fp(e,t,r){2===arguments.length&&(r=c_(e));var n=Rp(e,t);return Pp(e)?n:iu(n,r)}function Op(e,t){return 146===e.name.kind&&x_(e.name),Fp(e.initializer,t)}function Ip(e,t){return Ag(e),146===e.name.kind&&x_(e.name),Mp(e,up(e,t),t)}function Mp(e,t,r){if(2===r){var n=md(t);if(n&&n.typeParameters){var i=s_(e);if(i){var a=md(du(i));if(a&&!a.typeParameters)return po(gd(n,a,u_(e)))}}}return t}function Lp(t,r){if(185===t.kind&&97!==t.expression.kind&&!e.isRequireCall(t,!0)&&!Wd(t)){var n=md($_(t.expression));if(n&&!n.typeParameters)return io(n)}return r?Ap(t):Rp(t)}function Rp(t,r){var n;return vp(n=145===t.kind?Y_(t):Mp(t,function(t,r){switch(t.kind){case 71:return Rl(t);case 99:return function(t){var r=e.getThisContainer(t,!0),n=!1;switch(154===r.kind&&zl(t,r,e.Diagnostics.super_must_be_called_before_accessing_this_in_the_constructor_of_a_derived_class),191===r.kind&&(r=e.getThisContainer(r,!1),n=C<2),r.kind){case 237:sr(t,e.Diagnostics.this_cannot_be_referenced_in_a_module_or_namespace_body);break;case 236:sr(t,e.Diagnostics.this_cannot_be_referenced_in_current_location);break;case 154:ql(t,r)&&sr(t,e.Diagnostics.this_cannot_be_referenced_in_constructor_arguments);break;case 151:case 150:e.hasModifier(r,32)&&sr(t,e.Diagnostics.this_cannot_be_referenced_in_a_static_property_initializer);break;case 146:sr(t,e.Diagnostics.this_cannot_be_referenced_in_a_computed_property_name);}n&&Bl(t,r);var i=Ul(t,r);return!i&&I&&sr(t,e.Diagnostics.this_implicitly_has_type_any_because_it_does_not_have_a_type_annotation),i||Q}(t);case 97:return Vl(t);case 95:return ie;case 13:case 9:return zs(qs(t.text));case 8:return Rg(t),zs(qs(+t.text));case 101:return se;case 86:return ce;case 200:return function(t){return e.forEach(t.templateSpans,function(e){Rp(e.expression);}),ae}(t);case 12:return Me;case 181:return h_(t,r);case 182:return k_(t,r);case 183:return Q_(t);case 184:return cd(t);case 185:if(91===t.expression.kind)return Hd(t);case 186:return Vd(t);case 187:return function(e){return C<2&&dg(e,65536),io(Kd(e))}(t);case 189:return function(t,r){var n=e.isInJavaScriptFile(t)?e.getJSDocTypeTag(t):void 0;return n?Xd(n,n.typeExpression.type,t.expression,r):Rp(t.expression,r)}(t,r);case 203:return function(e){return nm(e),km(e),ui(nn(e))}(t);case 190:case 191:return up(t,r);case 193:return function(e){return Rp(e.expression),Qt}(t);case 188:case 206:return function(e){return Xd(e,e.type,e.expression)}(t);case 207:return function(e){return du(Rp(e.expression))}(t);case 208:return Qd(t);case 192:return function(t){Rp(t.expression);var r=e.skipParentheses(t.expression);if(183!==r.kind&&184!==r.kind)return sr(r,e.Diagnostics.The_operand_of_a_delete_operator_must_be_a_property_reference),ue;var n=on$$1(yr(r).resolvedSymbol);return n&&dp(n)&&sr(r,e.Diagnostics.The_operand_of_a_delete_operator_cannot_be_a_read_only_property),ue}(t);case 194:return function(e){return Rp(e.expression),re}(t);case 195:return function(t){return a&&(16384&t.flags||Og(t,e.Diagnostics.await_expression_is_only_allowed_within_an_async_function),Xl(t)&&sr(t,e.Diagnostics.await_expressions_cannot_be_used_in_a_parameter_initializer)),sf(Rp(t.expression),t,e.Diagnostics.Type_of_await_operand_must_either_be_a_valid_promise_or_must_not_contain_a_callable_then_member)}(t);case 196:return function(t){var r=Rp(t.operand);if(r===pe)return pe;if(8===t.operand.kind){if(38===t.operator)return zs(qs(-t.operand.text));if(37===t.operator)return zs(qs(+t.operand.text))}switch(t.operator){case 37:case 38:case 52:return X_(r,t.operand),gp(r,1536)&&sr(t.operand,e.Diagnostics.The_0_operator_cannot_be_applied_to_type_symbol,e.tokenToString(t.operator)),oe;case 51:var n=3145728&Xu(r);return 1048576===n?ce:2097152===n?se:ue;case 43:case 44:return _p(t.operand,X_(r,t.operand),e.Diagnostics.An_arithmetic_operand_must_be_of_type_any_number_or_an_enum_type)&&mp(t.operand,e.Diagnostics.The_operand_of_an_increment_or_decrement_operator_must_be_a_variable_or_a_property_access),oe}return ee}(t);case 197:return function(t){var r=Rp(t.operand);return r===pe?pe:(_p(t.operand,X_(r,t.operand),e.Diagnostics.An_arithmetic_operand_must_be_of_type_any_number_or_an_enum_type)&&mp(t.operand,e.Diagnostics.The_operand_of_an_increment_or_decrement_operator_must_be_a_variable_or_a_property_access),oe)}(t);case 198:return Dp(t,r);case 199:return function(e,t){return Rp(e.condition),ds([Rp(e.whenTrue,t),Rp(e.whenFalse,t)],2)}(t,r);case 202:return function(e,t){return C<2&&D.downlevelIteration&&dg(e,1536),Uf(Rp(e.expression,t),e.expression,!1,!1)}(t,r);case 204:return re;case 201:return Ep(t);case 263:return function(t,r){if(t.expression){var n=Rp(t.expression,r);return t.dotDotDotToken&&n!==Q&&!Xc(n)&&sr(t,e.Diagnostics.JSX_spread_child_must_be_an_array_type),n}return ee}(t,r);case 253:return function(e,t){return U_(e.openingElement,t),C_(e.closingElement.tagName)?w_(e.closingElement):Rp(e.closingElement.tagName),J_(e)||Q}(t,r);case 254:return function(e,t){return U_(e,t),J_(e)||Q}(t,r);case 257:return function(t,r){return U_(t.openingFragment,r),2===D.jsx&&(D.jsxFactory||e.getSourceFileOfNode(t).pragmas.has("jsx"))&&sr(t,D.jsxFactory?e.Diagnostics.JSX_fragment_is_not_supported_when_using_jsxFactory:e.Diagnostics.JSX_fragment_is_not_supported_when_using_an_inline_JSX_factory_pragma),J_(t)||Q}(t,r);case 261:return function(e,t){return N_(e.parent,t)}(t,r);case 255:e.Debug.fail("Shouldn't ever directly check a JsxOpeningElement");}return ee}(t,r),r))&&(183===t.parent.kind&&t.parent.expression===t||184===t.parent.kind&&t.parent.expression===t||(71===t.kind||145===t.kind)&&wm(t)||164===t.parent.kind&&t.parent.exprName===t||sr(t,e.Diagnostics.const_enums_can_only_be_used_in_property_or_index_access_expressions_or_the_right_hand_side_of_an_import_declaration_or_export_assignment_or_type_query)),n}function Bp(t){t.expression&&Og(t.expression,e.Diagnostics.Type_expected),xm(t.constraint),xm(t.default);var r=wi(nn(t));Aa(r)||sr(t.constraint,e.Diagnostics.Type_parameter_0_has_a_circular_constraint,En(r)),function(e){return wa(e)!==Se}(r)||sr(t.default,e.Diagnostics.Type_parameter_0_has_a_circular_default,En(r));var n=ka(r),i=Fa(r);n&&i&&Tc(i,Xi(n,i),t.default,e.Diagnostics.Type_0_does_not_satisfy_the_constraint_1),a&&Zf(t.name,e.Diagnostics.Type_parameter_name_cannot_be_0);}function Kp(t){fg(t),Mf(t);var r=e.getContainingFunction(t);e.hasModifier(t,92)&&(154===r.kind&&e.nodeIsPresent(r.body)||sr(t,e.Diagnostics.A_parameter_property_is_only_allowed_in_a_constructor_implementation)),t.questionToken&&e.isBindingPattern(t.name)&&r.body&&sr(t,e.Diagnostics.A_binding_pattern_parameter_cannot_be_optional_in_an_implementation_signature),t.name&&e.isIdentifier(t.name)&&("this"===t.name.escapedText||"new"===t.name.escapedText)&&(0!==r.parameters.indexOf(t)&&sr(t,e.Diagnostics.A_0_parameter_must_be_the_first_parameter,t.name.escapedText),154!==r.kind&&158!==r.kind&&163!==r.kind||sr(t,e.Diagnostics.A_constructor_cannot_have_a_this_parameter)),!t.dotDotDotToken||e.isBindingPattern(t.name)||Xc(ui(t.symbol))||sr(t,e.Diagnostics.A_rest_parameter_must_be_of_an_array_type);}function jp(t,r,n){for(var i=0,a=t.elements;i<a.length;i++){var o=a[i];if(!e.isOmittedExpression(o)){var s=o.name;if(71===s.kind&&s.escapedText===n)return sr(r,e.Diagnostics.A_type_predicate_cannot_reference_element_0_in_a_binding_pattern,n),!0;if((179===s.kind||178===s.kind)&&jp(s,r,n))return!0}}}function Jp(t){159===t.kind?function(t){fg(t)||function(t){var r=t.parameters[0];if(1!==t.parameters.length)return Mg(r?r.name:t,e.Diagnostics.An_index_signature_must_have_exactly_one_parameter);if(r.dotDotDotToken)return Mg(r.dotDotDotToken,e.Diagnostics.An_index_signature_cannot_have_a_rest_parameter);if(e.hasModifiers(r))return Mg(r.name,e.Diagnostics.An_index_signature_parameter_cannot_have_an_accessibility_modifier);if(r.questionToken)return Mg(r.questionToken,e.Diagnostics.An_index_signature_parameter_cannot_have_a_question_mark);if(r.initializer)return Mg(r.name,e.Diagnostics.An_index_signature_parameter_cannot_have_an_initializer);if(!r.type)return Mg(r.name,e.Diagnostics.An_index_signature_parameter_must_have_a_type_annotation);if(137!==r.type.kind&&134!==r.type.kind){var n=Hs(r.type);return 2&n.flags||4&n.flags?Mg(r.name,e.Diagnostics.An_index_signature_parameter_type_cannot_be_a_type_alias_Consider_writing_0_Colon_1_Colon_2_instead,e.getTextOfNode(r.name),En(n),En(Hs(t.type))):hp(n,32,!0)?Mg(r.name,e.Diagnostics.An_index_signature_parameter_type_cannot_be_a_union_type_Consider_using_a_mapped_object_type_instead):Mg(r.name,e.Diagnostics.An_index_signature_parameter_type_must_be_string_or_number)}t.type||Mg(t,e.Diagnostics.An_index_signature_must_have_a_type_annotation);}(t);}(t):162!==t.kind&&232!==t.kind&&163!==t.kind&&157!==t.kind&&154!==t.kind&&158!==t.kind||hg(t);var r=e.getFunctionFlags(t);if(4&r||(3==(3&r)&&C<6&&dg(t,6144),2==(3&r)&&C<4&&dg(t,64),0!=(3&r)&&C<2&&dg(t,128)),em(t.typeParameters),e.forEach(t.parameters,Kp),t.type&&xm(t.type),a){!function(t){!e.hasRestParameter(t)||2097152&t.flags||e.nodeIsMissing(t.body)||e.forEach(t.parameters,function(t){t.name&&!e.isBindingPattern(t.name)&&t.name.escapedText===j.escapedName&&sr(t,e.Diagnostics.Duplicate_identifier_arguments_Compiler_uses_arguments_to_initialize_rest_parameters);});}(t);var n=e.getEffectiveReturnTypeNode(t);if(O&&!n)switch(t.kind){case 158:sr(t,e.Diagnostics.Construct_signature_which_lacks_return_type_annotation_implicitly_has_an_any_return_type);break;case 157:sr(t,e.Diagnostics.Call_signature_which_lacks_return_type_annotation_implicitly_has_an_any_return_type);}if(n){var i=e.getFunctionFlags(t);if(1==(5&i)){var o=Hs(n);if(o===_e)sr(n,e.Diagnostics.A_generator_cannot_have_a_void_type_annotation);else{var s=Hf(o,0!=(2&i))||Q;Tc(2&i?Zo(s):ts(s),o,n);}}else 2==(3&i)&&uf(t);}N&&!t.body&&Sf(t);}}function zp(t){for(var r=e.createMap(),n=0,i=t.members;n<i.length;n++){var a=i[n];if(150===a.kind){var o=void 0;switch(a.name.kind){case 9:case 8:o=a.name.text;break;case 71:o=e.idText(a.name);break;default:continue}r.get(o)?(sr(e.getNameOfDeclaration(a.symbol.valueDeclaration),e.Diagnostics.Duplicate_identifier_0,o),sr(a.name,e.Diagnostics.Duplicate_identifier_0,o)):r.set(o,!0);}}}function Up(t){if(234===t.kind){var r=nn(t);if(r.declarations.length>0&&r.declarations[0]!==t)return}var n=fo(nn(t));if(n)for(var i=!1,a=!1,o=0,s=n.declarations;o<s.length;o++){var c=s[o];if(1===c.parameters.length&&c.parameters[0].type)switch(c.parameters[0].type.kind){case 137:a?sr(c,e.Diagnostics.Duplicate_string_index_signature):a=!0;break;case 134:i?sr(c,e.Diagnostics.Duplicate_number_index_signature):i=!0;}}}function qp(t){fg(t)||function(t){if(e.isClassLike(t.parent)){if(Ng(t.name,e.Diagnostics.A_computed_property_name_in_a_class_property_declaration_must_refer_to_an_expression_whose_type_is_a_literal_type_or_a_unique_symbol_type))return!0}else if(234===t.parent.kind){if(Ng(t.name,e.Diagnostics.A_computed_property_name_in_an_interface_must_refer_to_an_expression_whose_type_is_a_literal_type_or_a_unique_symbol_type))return!0;if(t.initializer)return Mg(t.initializer,e.Diagnostics.An_interface_property_cannot_have_an_initializer)}else if(165===t.parent.kind){if(Ng(t.name,e.Diagnostics.A_computed_property_name_in_a_type_literal_must_refer_to_an_expression_whose_type_is_a_literal_type_or_a_unique_symbol_type))return!0;if(t.initializer)return Mg(t.initializer,e.Diagnostics.A_type_literal_property_cannot_have_an_initializer)}return 2097152&t.flags&&t.initializer?Og(t.initializer,e.Diagnostics.Initializers_are_not_allowed_in_ambient_contexts):e.isPropertyDeclaration(t)&&t.exclamationToken&&(!e.isClassLike(t.parent)||!t.type||t.initializer||2097152&t.flags||e.hasModifier(t,160))?Mg(t.exclamationToken,e.Diagnostics.A_definite_assignment_assertion_is_not_permitted_in_this_context):void 0}(t)||kg(t.name),Mf(t);}function Vp(t){Jp(t),function(t){var r=e.getEffectiveTypeParameterDeclarations(t);if(r){var n=e.isNodeArray(r)?r:e.first(r),i=n.pos,a=n.end;return Ig(t,i,a-i,e.Diagnostics.Type_parameters_cannot_appear_on_a_constructor_declaration)}}(t)||function(t){var r=e.getEffectiveReturnTypeNode(t);r&&Mg(r,e.Diagnostics.Type_annotation_cannot_appear_on_a_constructor_declaration);}(t),xm(t.body),yf(t);var r=nn(t);if(t===e.getDeclarationOfKind(r,t.kind)&&rf(r),!e.nodeIsMissing(t.body)&&a){var n=t.parent;if(e.getClassExtendsHeritageClauseElement(n)){Bl(t.parent,n);var i=Jl(n),o=jl(t);if(o){if(i&&sr(o,e.Diagnostics.A_constructor_cannot_contain_a_super_call_when_its_class_extends_null),e.some(t.parent.members,function(t){return 151===t.kind&&!e.hasModifier(t,32)&&!!t.initializer})||e.some(t.parameters,function(t){return e.hasModifier(t,92)})){for(var s=void 0,c=0,u=t.body.statements;c<u.length;c++){var l=u[c];if(214===l.kind&&e.isSuperCall(l.expression)){s=l;break}if(!e.isPrologueDirective(l))break}s||sr(t,e.Diagnostics.A_super_call_must_be_the_first_statement_in_the_constructor_when_a_class_contains_initialized_properties_or_has_parameter_properties);}}else i||sr(t,e.Diagnostics.Constructors_for_derived_classes_must_contain_a_super_call);}}}function Wp(t){if(a){if(hg(t)||function(t){var r=t.kind;if(C<1)return Mg(t.name,e.Diagnostics.Accessors_are_only_available_when_targeting_ECMAScript_5_and_higher);if(2097152&t.flags)return Mg(t.name,e.Diagnostics.An_accessor_cannot_be_declared_in_an_ambient_context);if(void 0===t.body&&!e.hasModifier(t,128))return Ig(t,t.end-1,";".length,e.Diagnostics._0_expected,"{");if(t.body&&e.hasModifier(t,128))return Mg(t,e.Diagnostics.An_abstract_accessor_cannot_have_an_implementation);if(t.typeParameters)return Mg(t.name,e.Diagnostics.An_accessor_cannot_have_type_parameters);if(!function(e){return Eg(e)||e.parameters.length===(155===e.kind?0:1)}(t))return Mg(t.name,155===r?e.Diagnostics.A_get_accessor_cannot_have_parameters:e.Diagnostics.A_set_accessor_must_have_exactly_one_parameter);if(156===r){if(t.type)return Mg(t.name,e.Diagnostics.A_set_accessor_cannot_have_a_return_type_annotation);var n=t.parameters[0];if(n.dotDotDotToken)return Mg(n.dotDotDotToken,e.Diagnostics.A_set_accessor_cannot_have_rest_parameter);if(n.questionToken)return Mg(n.questionToken,e.Diagnostics.A_set_accessor_cannot_have_an_optional_parameter);if(n.initializer)return Mg(t.name,e.Diagnostics.A_set_accessor_parameter_cannot_have_an_initializer)}}(t)||kg(t.name),ff(t),Jp(t),155===t.kind&&!(2097152&t.flags)&&e.nodeIsPresent(t.body)&&128&t.flags&&(256&t.flags||sr(t.name,e.Diagnostics.A_get_accessor_must_return_a_value)),146===t.name.kind&&x_(t.name),!qi(t)){var r=155===t.kind?156:155,n=e.getDeclarationOfKind(nn(t),r);if(n){var i=e.getModifierFlags(t),o=e.getModifierFlags(n);(28&i)!=(28&o)&&sr(t.name,e.Diagnostics.Getter_and_setter_accessors_do_not_agree_in_visibility),(128&i)!=(128&o)&&sr(t.name,e.Diagnostics.Accessors_must_both_be_abstract_or_non_abstract),Hp(t,n,ni,e.Diagnostics.get_and_set_accessor_must_have_the_same_type),Hp(t,n,ii,e.Diagnostics.get_and_set_accessor_must_have_the_same_this_type);}}var s=ai(nn(t));155===t.kind&&cp(t,s);}xm(t.body),yf(t);}function Hp(e,t,r,n){var i=r(e),a=r(t);i&&a&&!gc(i,a)&&sr(e,n);}function Gp(t,r){return Ya(e.map(t.typeArguments,Hs),r,Qa(r),e.isInJavaScriptFile(t))}function $p(t,r){for(var n,i,a=!0,o=0;o<r.length;o++){var s=ka(r[o]);s&&(n||(i=Qs(r,n=Gp(t,r))),a=a&&Tc(n[o],uc(s,i),t.typeArguments[o],e.Diagnostics.Type_0_does_not_satisfy_the_constraint_1));}return a}function Xp(t){var r=Oo(t);if(r!==ee){var n=yr(t).resolvedSymbol;if(n)return 524288&n.flags&&gr(n).typeParameters||(4&e.getObjectFlags(r)?r.target.localTypeParameters:void 0)}}function Qp(t){vg(t,t.typeArguments),161!==t.kind||void 0===t.typeName.jsdocDotPos||e.isInJavaScriptFile(t)||e.isInJSDoc(t)||Ig(t,t.typeName.jsdocDotPos,1,e.Diagnostics.JSDoc_types_can_only_be_used_inside_documentation_comments);var r=Oo(t);if(r!==ee){if(t.typeArguments&&(e.forEach(t.typeArguments,xm),a)){var n=Xp(t);n&&$p(t,n);}16&r.flags&&8&yr(t).resolvedSymbol.flags&&sr(t,e.Diagnostics.Enum_type_0_has_members_with_initializers_that_are_not_literals,En(r));}}function Yp(t,r){if(!(1048576&t.flags))return t;var n=t.objectType,i=t.indexType;return bc(i,vs(n))?(184===r.kind&&e.isAssignmentTarget(r)&&32&e.getObjectFlags(n)&&1&pa(n)&&sr(r,e.Diagnostics.Index_signature_in_type_0_only_permits_reading,En(n)),t):za(Oa(n),1)&&yp(i,84)?t:(sr(r,e.Diagnostics.Type_0_cannot_be_used_to_index_type_1,En(i),En(n)),t)}function Zp(t){!function(t){if(141===t.operator){if(138!==t.type.kind)return Mg(t.type,e.Diagnostics._0_expected,e.tokenToString(138));var r=e.walkUpParenthesizedTypes(t.parent);switch(r.kind){case 230:var n=r;if(71!==n.name.kind)return Mg(t,e.Diagnostics.unique_symbol_types_may_not_be_used_on_a_variable_declaration_with_a_binding_name);if(!e.isVariableDeclarationInVariableStatement(n))return Mg(t,e.Diagnostics.unique_symbol_types_are_only_allowed_on_variables_in_a_variable_statement);if(!(2&n.parent.flags))return Mg(r.name,e.Diagnostics.A_variable_whose_type_is_a_unique_symbol_type_must_be_const);break;case 151:if(!e.hasModifier(r,32)||!e.hasModifier(r,64))return Mg(r.name,e.Diagnostics.A_property_of_a_class_whose_type_is_a_unique_symbol_type_must_be_both_static_and_readonly);break;case 150:if(!e.hasModifier(r,64))return Mg(r.name,e.Diagnostics.A_property_of_an_interface_or_type_literal_whose_type_is_a_unique_symbol_type_must_be_readonly);break;default:Mg(t,e.Diagnostics.unique_symbol_types_are_not_allowed_here);}}}(t),xm(t.type);}function ef(t){return e.hasModifier(t,8)&&!!(2097152&t.flags)}function tf(t,r){var n=e.getCombinedModifierFlags(t);return 234!==t.parent.kind&&233!==t.parent.kind&&203!==t.parent.kind&&2097152&t.flags&&(2&n||(n|=1),n|=2),n&r}function rf(t){if(a){for(var r,n,i,o=0,s=155,c=!1,u=!0,l=!1,_=t.declarations,d=0!=(16384&t.flags),p=!1,f=!1,m=0,g=_;m<g.length;m++){var y=g[m],h=2097152&y.flags,v=234===y.parent.kind||165===y.parent.kind||h;if(v&&(i=void 0),232===y.kind||153===y.kind||152===y.kind||154===y.kind){var b=tf(y,155);o|=b,s&=b,c=c||e.hasQuestionToken(y),u=u&&e.hasQuestionToken(y),e.nodeIsPresent(y.body)&&r?d?f=!0:p=!0:i&&i.parent===y.parent&&i.end!==y.pos&&E(i),e.nodeIsPresent(y.body)?r||(r=y):l=!0,i=y,v||(n=y);}}if(f&&e.forEach(_,function(t){sr(t,e.Diagnostics.Multiple_constructor_implementations_are_not_allowed);}),p&&e.forEach(_,function(t){sr(e.getNameOfDeclaration(t),e.Diagnostics.Duplicate_function_implementation);}),!n||n.body||e.hasModifier(n,128)||n.questionToken||E(n),l&&(function(t,r,n,i,a){if(0!=(i^a)){var o=tf(C(t,r),n);e.forEach(t,function(t){var r=tf(t,n)^o;1&r?sr(e.getNameOfDeclaration(t),e.Diagnostics.Overload_signatures_must_all_be_exported_or_non_exported):2&r?sr(e.getNameOfDeclaration(t),e.Diagnostics.Overload_signatures_must_all_be_ambient_or_non_ambient):24&r?sr(e.getNameOfDeclaration(t)||t,e.Diagnostics.Overload_signatures_must_all_be_public_private_or_protected):128&r&&sr(e.getNameOfDeclaration(t),e.Diagnostics.Overload_signatures_must_all_be_abstract_or_non_abstract);});}}(_,r,155,o,s),function(t,r,n,i){if(n!==i){var a=e.hasQuestionToken(C(t,r));e.forEach(t,function(t){e.hasQuestionToken(t)!==a&&sr(e.getNameOfDeclaration(t),e.Diagnostics.Overload_signatures_must_all_be_optional_or_required);});}}(_,r,c,u),r))for(var x=eo(t),S=Za(r),k=0,T=x;k<T.length;k++){var D=T[k];if(!Ec(S,D)){sr(D.declaration,e.Diagnostics.Overload_signature_is_not_compatible_with_function_implementation);break}}}function C(e,t){return void 0!==t&&t.parent===e[0].parent?t:e[0]}function E(t){if(!t.name||!e.nodeIsMissing(t.name)){var r=!1,n=e.forEachChild(t.parent,function(e){if(r)return e;r=e===t;});if(n&&n.pos===t.end&&n.kind===t.kind){var i=n.name||n,a=n.name;if(t.name&&a&&(e.isComputedPropertyName(t.name)&&e.isComputedPropertyName(a)||!e.isComputedPropertyName(t.name)&&!e.isComputedPropertyName(a)&&e.getEscapedTextOfIdentifierOrLiteral(t.name)===e.getEscapedTextOfIdentifierOrLiteral(a)))return void(153!==t.kind&&152!==t.kind||e.hasModifier(t,32)===e.hasModifier(n,32)||sr(i,e.hasModifier(t,32)?e.Diagnostics.Function_overload_must_be_static:e.Diagnostics.Function_overload_must_not_be_static));if(e.nodeIsPresent(n.body))return void sr(i,e.Diagnostics.Function_implementation_name_must_be_0,e.declarationNameToString(t.name))}var o=t.name||t;d?sr(o,e.Diagnostics.Constructor_implementation_is_missing):e.hasModifier(t,128)?sr(o,e.Diagnostics.All_declarations_of_an_abstract_method_must_be_consecutive):sr(o,e.Diagnostics.Function_implementation_is_missing_or_not_immediately_following_the_declaration);}}}function nf(t){if(a){var r=t.localSymbol;if((r||(r=nn(t)).exportSymbol)&&e.getDeclarationOfKind(r,t.kind)===t){for(var n=0,i=0,o=0,s=0,c=r.declarations;s<c.length;s++){var u=h(g=c[s]),l=tf(g,513);1&l?512&l?o|=u:n|=u:i|=u;}var _,d=n&i,p=o&(n|i);if(d||p)for(var f=0,m=r.declarations;f<m.length;f++){u=h(g=m[f]);var g,y=e.getNameOfDeclaration(g);u&p?sr(y,e.Diagnostics.Merged_declaration_0_cannot_include_a_default_export_declaration_Consider_adding_a_separate_export_default_0_declaration_instead,e.declarationNameToString(y)):u&d&&sr(y,e.Diagnostics.Individual_declarations_in_merged_declaration_0_must_be_all_exported_or_all_local,e.declarationNameToString(y));}!function(e){e[e.None=0]="None",e[e.ExportValue=1]="ExportValue",e[e.ExportType=2]="ExportType",e[e.ExportNamespace=4]="ExportNamespace";}(_||(_={}));}}function h(t){switch(t.kind){case 234:case 235:case 291:return 2;case 237:return e.isAmbientModule(t)||0!==e.getModuleInstanceState(t)?5:4;case 233:case 236:return 3;case 272:return 7;case 241:case 244:case 243:var r=0,n=Rr(nn(t));return e.forEach(n.declarations,function(e){r|=h(e);}),r;case 230:case 180:case 232:case 246:return 1;default:e.Debug.fail(e.Debug.showSyntaxKind(t));}}}function af(e,t,r){var n=of(e,t);return n&&cf(n,t,r)}function of(t,r){if(!zn(t)){var n=t;if(n.promisedTypeOfPromise)return n.promisedTypeOfPromise;if(li(t,zo(!1)))return n.promisedTypeOfPromise=t.typeArguments[0];var i=Jn(t,"then");if(!zn(i)){var a=i?Ka(i,0):e.emptyArray;if(0!==a.length){var o=Qu(ds(e.map(a,ep)),524288);if(!zn(o)){var s=Ka(o,0);if(0!==s.length)return n.promisedTypeOfPromise=ds(e.map(s,ep),2);r&&sr(r,e.Diagnostics.The_first_parameter_of_the_then_method_of_a_promise_must_be_a_callback);}}else r&&sr(r,e.Diagnostics.A_promise_must_have_a_then_method);}}}function sf(e,t,r){return cf(e,t,r)||ee}function cf(t,r,n){var i=t;if(i.awaitedTypeOfType)return i.awaitedTypeOfType;if(zn(t))return i.awaitedTypeOfType=t;if(131072&t.flags){for(var a=void 0,o=0,s=t.types;o<s.length;o++){var c=s[o];a=e.append(a,cf(c,r,n));}if(!a)return;return i.awaitedTypeOfType=ds(a)}var u=of(t);if(u){if(t.id===u.id||Mt.indexOf(u.id)>=0)return void(r&&sr(r,e.Diagnostics.Type_is_referenced_directly_or_indirectly_in_the_fulfillment_callback_of_its_own_then_method));Mt.push(t.id);var l=cf(u,r,n);if(Mt.pop(),!l)return;return i.awaitedTypeOfType=l}var _=Jn(t,"then");if(!(_&&Ka(_,0).length>0))return i.awaitedTypeOfType=t;r&&(e.Debug.assert(!!n),sr(r,n));}function uf(t){var r=e.getEffectiveReturnTypeNode(t),n=Hs(r);if(C>=2){if(n===ee)return ee;var i=zo(!0);if(i!==ve&&!li(n,i))return sr(r,e.Diagnostics.The_return_type_of_an_async_function_or_method_must_be_the_global_Promise_T_type),ee}else{if(function(t){_f(t&&e.getEntityNameFromTypeNode(t));}(r),n===ee)return ee;var a=e.getEntityNameFromTypeNode(r);if(void 0===a)return sr(r,e.Diagnostics.Type_0_is_not_a_valid_async_function_return_type_in_ES5_SlashES3_because_it_does_not_refer_to_a_Promise_compatible_constructor_value,En(n)),ee;var o=zr(a,67216319,!0),s=o?ui(o):ee;if(s===ee)return 71===a.kind&&"Promise"===a.escapedText&&_i(n)===zo(!1)?sr(r,e.Diagnostics.An_async_function_or_method_in_ES5_SlashES3_requires_the_Promise_constructor_Make_sure_you_have_a_declaration_for_the_Promise_constructor_or_include_ES2015_in_your_lib_option):sr(r,e.Diagnostics.Type_0_is_not_a_valid_async_function_return_type_in_ES5_SlashES3_because_it_does_not_refer_to_a_Promise_compatible_constructor_value,e.entityNameToString(a)),ee;var c=We||(We=Ko("PromiseConstructorLike",0,!0))||ge;if(c===ge)return sr(r,e.Diagnostics.Type_0_is_not_a_valid_async_function_return_type_in_ES5_SlashES3_because_it_does_not_refer_to_a_Promise_compatible_constructor_value,e.entityNameToString(a)),ee;if(!Tc(s,c,r,e.Diagnostics.Type_0_is_not_a_valid_async_function_return_type_in_ES5_SlashES3_because_it_does_not_refer_to_a_Promise_compatible_constructor_value))return ee;var u=a&&pm(a),l=vr(t.locals,u.escapedText,67216319);if(l)return sr(l.valueDeclaration,e.Diagnostics.Duplicate_identifier_0_Compiler_uses_declaration_1_to_support_async_functions,e.idText(u),e.entityNameToString(a)),ee}return sf(n,t,e.Diagnostics.The_return_type_of_an_async_function_must_either_be_a_valid_promise_or_must_not_contain_a_callable_then_member)}function lf(t){var r=io(Kd(t));if(!(1&r.flags)){var n,i,a=Id(t);switch(t.parent.kind){case 233:n=ds([ui(nn(t.parent)),_e]);break;case 148:n=_e,i=e.chainDiagnosticMessages(i,e.Diagnostics.The_return_type_of_a_parameter_decorator_function_must_be_either_void_or_any);break;case 151:n=_e,i=e.chainDiagnosticMessages(i,e.Diagnostics.The_return_type_of_a_property_decorator_function_must_be_either_void_or_any);break;case 153:case 155:case 156:n=ds([Yo(Im(t.parent)),_e]);}Tc(r,n,t,a,function(){return i});}}function _f(e){if(e){var t=pm(e),r=2097152|(71===e.kind?67901928:1920),n=xr(t,t.escapedText,r,void 0,void 0,!0);n&&2097152&n.flags&&sn(n)&&!Gm(Rr(n))&&Kr(n);}}function df(t){var r=function t(r){if(r)switch(r.kind){case 169:case 168:for(var n=void 0,i=0,a=r.types;i<a.length;i++){for(var o=a[i];172===o.kind;)o=o.type;if(131!==o.kind&&(P||95!==o.kind&&140!==o.kind)){var s=t(o);if(!s)return;if(n){if(!e.isIdentifier(n)||!e.isIdentifier(s)||n.escapedText!==s.escapedText)return}else n=s;}}return n;case 172:return t(r.type);case 161:return r.typeName}}(t);r&&e.isEntityName(r)&&_f(r);}function pf(t){var r=e.getEffectiveTypeAnnotationNode(t);return e.isRestParameter(t)?e.getRestParameterElementType(r):r}function ff(t){if(t.decorators&&e.nodeCanBeDecorated(t,t.parent,t.parent.parent)){D.experimentalDecorators||sr(t,e.Diagnostics.Experimental_support_for_decorators_is_a_feature_that_is_subject_to_change_in_a_future_release_Set_the_experimentalDecorators_option_to_remove_this_warning);var r=t.decorators[0];if(dg(r,8),148===t.kind&&dg(r,32),D.emitDecoratorMetadata)switch(dg(r,16),t.kind){case 233:var n=e.getFirstConstructorWithBody(t);if(n)for(var i=0,a=n.parameters;i<a.length;i++)df(pf(a[i]));break;case 153:case 155:case 156:for(var o=0,s=t.parameters;o<s.length;o++)df(pf(s[o]));df(e.getEffectiveReturnTypeNode(t));break;case 151:df(e.getEffectiveTypeAnnotationNode(t));break;case 148:df(pf(t));for(var c=0,u=t.parent.parameters;c<u.length;c++)df(pf(u[c]));}e.forEach(t.decorators,lf);}}function mf(e){switch(e.kind){case 71:return e;case 183:return e.name;default:return}}function gf(t){ff(t),Jp(t);var r=e.getFunctionFlags(t);if(t.name&&146===t.name.kind&&x_(t.name),!qi(t)){var n=nn(t),i=t.localSymbol||n,o=e.find(i.declarations,function(e){return e.kind===t.kind&&!(65536&e.flags)});t===o&&rf(i),n.parent&&e.getDeclarationOfKind(n,t.kind)===t&&rf(n);}var s=152===t.kind?void 0:t.body;xm(s);var c=e.getEffectiveReturnTypeNode(t);if(0==(1&r)){var u=c&&(2&r?uf(t):Hs(c));cp(t,u);}a&&!c&&(O&&e.nodeIsMissing(s)&&!ef(t)&&Su(t,Q),1&r&&e.nodeIsPresent(s)&&io(Za(t))),yf(t);}function yf(e){tt&&tt.push(e);}function hf(t){!N||2097152&t.flags||t.locals.forEach(function(t){if(262144&t.flags?3&t.flags&&!(3&t.isReferenced):!t.isReferenced)if(t.valueDeclaration&&148===e.getRootDeclaration(t.valueDeclaration).kind){var r=e.getRootDeclaration(t.valueDeclaration),n=e.getNameOfDeclaration(t.valueDeclaration);!D.noUnusedParameters||e.isParameterPropertyDeclaration(r)||e.parameterIsThisKeyword(r)||(i=n)&&bf(i)||sr(n,e.Diagnostics._0_is_declared_but_its_value_is_never_read,e.symbolName(t));}else D.noUnusedLocals&&e.forEach(t.declarations,function(r){return vf(r,e.symbolName(t))});var i;});}function vf(t,r){var n=e.getNameOfDeclaration(t)||t;if(bf(n)){var i=e.getRootDeclaration(n.parent);if(230===i.kind&&e.isForInOrOfStatement(i.parent.parent)||147===i.kind)return}(function(t){if(e.isBindingElement(t)&&e.isObjectBindingPattern(t.parent)){var r=e.lastOrUndefined(t.parent.elements);return r!==t&&!!r.dotDotDotToken}return!1})(71===n.kind?n.parent:n)||Lt.add(e.createDiagnosticForNodeSpan(e.getSourceFileOfNode(t),t,n,e.Diagnostics._0_is_declared_but_its_value_is_never_read,r));}function bf(t){return e.isIdentifier(t)&&95===e.idText(t).charCodeAt(0)}function xf(t){if(D.noUnusedLocals&&!(2097152&t.flags))for(var r=0,n=t.members;r<n.length;r++){var i=n[r];switch(i.kind){case 153:case 151:case 155:case 156:if(156===i.kind&&32768&i.symbol.flags)break;var a=nn(i);!a.isReferenced&&e.hasModifier(i,8)&&sr(i.name,e.Diagnostics._0_is_declared_but_its_value_is_never_read,Dn(a));break;case 154:for(var o=0,s=i.parameters;o<s.length;o++){var c=s[o];!c.symbol.isReferenced&&e.hasModifier(c,8)&&sr(c.name,e.Diagnostics.Property_0_is_declared_but_its_value_is_never_read,e.symbolName(c.symbol));}break;case 159:case 210:break;default:e.Debug.fail();}}}function Sf(t){if(D.noUnusedParameters&&!(2097152&t.flags)&&t.typeParameters){var r=nn(t);if((r&&r.declarations&&e.lastOrUndefined(r.declarations))!==t)return;for(var n=0,i=t.typeParameters;n<i.length;n++){var a=i[n];262144&rn(a.symbol).isReferenced||bf(a.name)||sr(a.name,e.Diagnostics._0_is_declared_but_its_value_is_never_read,e.symbolName(a.symbol));}}}function kf(t){if(D.noUnusedLocals&&!(2097152&t.flags)){var r=e.createMap();t.locals.forEach(function(t){var n,i;if(!t.isReferenced&&!t.exportSymbol)for(var a=0,o=t.declarations;a<o.length;a++){var s=o[a];if(!e.isAmbientModule(s))if(243===(i=s).kind||246===i.kind||244===i.kind){var u=243===(n=s).kind?n:244===n.kind?n.parent:n.parent.parent,l=String(c(u)),_=r.get(l);_?_[1].push(s):r.set(l,[u,[s]]);}else vf(s,e.symbolName(t));}}),r.forEach(function(t){var r=t[0],n=t[1],i=r.parent;if(function(t,r){var n=t.name,i=t.namedBindings;return n&&r(t)||i&&(244===i.kind?r(i):e.forEach(i.elements,r))}(r,function(t){return!e.contains(n,t)}))for(var a=0,o=n;a<o.length;a++){var s=o[a];vf(s,e.idText(s.name));}else 1===n.length?sr(i,e.Diagnostics._0_is_declared_but_its_value_is_never_read,e.idText(e.first(n).name)):sr(i,e.Diagnostics.All_imports_in_import_declaration_are_unused,e.showModuleSpecifier(i));});}}function Tf(t){if(211===t.kind&&Lg(t),e.isFunctionOrModuleBlock(t)){var r=gt;e.forEach(t.statements,xm),gt=r;}else e.forEach(t.statements,xm);t.locals&&yf(t);}function Df(t,r,n){if(!r||r.escapedText!==n)return!1;if(151===t.kind||150===t.kind||153===t.kind||152===t.kind||155===t.kind||156===t.kind)return!1;if(2097152&t.flags)return!1;var i=e.getRootDeclaration(t);return 148!==i.kind||!e.nodeIsMissing(i.parent.body)}function Cf(e,t){Df(e,t,"_this")&&Ot.push(e);}function Ef(e,t){Df(e,t,"_newTarget")&&It.push(e);}function Nf(t){e.findAncestor(t,function(r){if(4&Ym(r))return 71!==t.kind?sr(e.getNameOfDeclaration(t),e.Diagnostics.Duplicate_identifier_this_Compiler_uses_variable_declaration_this_to_capture_this_reference):sr(t,e.Diagnostics.Expression_resolves_to_variable_declaration_this_that_compiler_uses_to_capture_this_reference),!0});}function Af(t){e.findAncestor(t,function(r){if(8&Ym(r))return 71!==t.kind?sr(e.getNameOfDeclaration(t),e.Diagnostics.Duplicate_identifier_newTarget_Compiler_uses_variable_declaration_newTarget_to_capture_new_target_meta_property_reference):sr(t,e.Diagnostics.Expression_resolves_to_variable_declaration_newTarget_that_compiler_uses_to_capture_new_target_meta_property_reference),!0});}function Pf(t,r){if(Df(t,r,"_super")){var n=e.getContainingClass(t);!n||2097152&n.flags||e.getClassExtendsHeritageClauseElement(n)&&sr(t,71!==t.kind?e.Diagnostics.Duplicate_identifier_super_Compiler_uses_super_to_capture_base_class_reference:e.Diagnostics.Expression_resolves_to_super_that_compiler_uses_to_capture_base_class_reference);}}function wf(t,r){if(!(E>=e.ModuleKind.ES2015)&&(Df(t,r,"require")||Df(t,r,"exports"))&&(!e.isModuleDeclaration(t)||1===e.getModuleInstanceState(t))){var n=jn(t);272===n.kind&&e.isExternalOrCommonJsModule(n)&&sr(r,e.Diagnostics.Duplicate_identifier_0_Compiler_reserves_name_1_in_top_level_scope_of_a_module,e.declarationNameToString(r),e.declarationNameToString(r));}}function Ff(t,r){if(!(C>=4)&&Df(t,r,"Promise")&&(!e.isModuleDeclaration(t)||1===e.getModuleInstanceState(t))){var n=jn(t);272===n.kind&&e.isExternalOrCommonJsModule(n)&&1024&n.flags&&sr(r,e.Diagnostics.Duplicate_identifier_0_Compiler_reserves_name_1_in_top_level_scope_of_a_module_containing_async_functions,e.declarationNameToString(r),e.declarationNameToString(r));}}function Of(t){if(148===e.getRootDeclaration(t).kind){var r=e.getContainingFunction(t);!function n(i){if(!e.isTypeNode(i)&&!e.isDeclarationName(i)){if(183===i.kind)return n(i.expression);if(71!==i.kind)return e.forEachChild(i,n);var a=xr(i,i.escapedText,69313471,void 0,void 0,!1);if(a&&a!==$&&a.valueDeclaration)if(a.valueDeclaration!==t){var o=e.getEnclosingBlockScopeContainer(a.valueDeclaration);if(o===r){if(148===a.valueDeclaration.kind||180===a.valueDeclaration.kind){if(a.valueDeclaration.pos<t.pos)return;if(e.findAncestor(i,function(r){return r===t.initializer?"quit":e.isFunctionLike(r.parent)||151===r.parent.kind&&!e.hasModifier(r.parent,32)&&e.isClassLike(r.parent.parent)}))return}sr(i,e.Diagnostics.Initializer_of_parameter_0_cannot_reference_identifier_1_declared_after_it,e.declarationNameToString(t.name),e.declarationNameToString(i));}}else sr(i,e.Diagnostics.Parameter_0_cannot_be_referenced_in_its_initializer,e.declarationNameToString(t.name));}}(t.initializer);}}function If(e){return e===Y?Q:e===Be?Re:e}function Mf(t){if(ff(t),e.isBindingElement(t)||xm(t.type),t.name){if(146===t.name.kind&&(x_(t.name),t.initializer&&Ap(t.initializer)),180===t.kind){178===t.parent.kind&&C<6&&dg(t,4),t.propertyName&&146===t.propertyName.kind&&x_(t.propertyName);var r=t.parent.parent,n=Un(r),i=t.propertyName||t.name;if(!e.isBindingPattern(i)){var a=Ra(n,e.getTextOfPropertyName(i));ad(a,void 0,!1),r.initializer&&a&&H_(r,r.initializer,n,a);}}if(e.isBindingPattern(t.name)&&(179===t.name.kind&&C<2&&D.downlevelIteration&&dg(t,512),e.forEach(t.name.elements,xm)),t.initializer&&148===e.getRootDeclaration(t).kind&&e.nodeIsMissing(e.getContainingFunction(t).body))sr(t,e.Diagnostics.A_parameter_initializer_is_only_allowed_in_a_function_or_constructor_implementation);else if(e.isBindingPattern(t.name)){if(t.initializer&&219!==t.parent.parent.kind){var o=Ap(t.initializer);P&&0===t.name.elements.length?X_(o,t):Tc(o,Zn(t),t,void 0),Of(t);}}else{var s=nn(t),c=If(ui(s));if(t===s.valueDeclaration)t.initializer&&219!==t.parent.parent.kind&&(Tc(Ap(e.isInJavaScriptFile(t)&&e.getDeclaredJavascriptInitializer(t)||t.initializer),c,t,void 0),Of(t));else{var u=If(Zn(t));c===ee||u===ee||gc(c,u)||67108864&s.flags||Lf(c,t,u),t.initializer&&Tc(Ap(t.initializer),u,t,void 0),l=t,_=s.valueDeclaration,148===l.kind&&230===_.kind||230===l.kind&&148===_.kind||e.hasQuestionToken(l)===e.hasQuestionToken(_)&&e.getSelectedModifierFlags(l,504)===e.getSelectedModifierFlags(_,504)||(sr(e.getNameOfDeclaration(s.valueDeclaration),e.Diagnostics.All_declarations_of_0_must_have_identical_modifiers,e.declarationNameToString(t.name)),sr(t.name,e.Diagnostics.All_declarations_of_0_must_have_identical_modifiers,e.declarationNameToString(t.name)));}151!==t.kind&&150!==t.kind&&(nf(t),230!==t.kind&&180!==t.kind||function(t){if(0==(3&e.getCombinedNodeFlags(t))&&!e.isParameterDeclaration(t)&&(230!==t.kind||t.initializer)){var r=nn(t);if(1&r.flags){if(!e.isIdentifier(t.name))return e.Debug.fail();var n=xr(t,t.name.escapedText,3,void 0,void 0,!1);if(n&&n!==r&&2&n.flags&&3&V_(n)){var i=e.getAncestor(n.valueDeclaration,231),a=212===i.parent.kind&&i.parent.parent?i.parent.parent:void 0;if(!a||!(211===a.kind&&e.isFunctionLike(a.parent)||238===a.kind||237===a.kind||272===a.kind)){var o=Dn(n);sr(t,e.Diagnostics.Cannot_initialize_outer_scoped_variable_0_in_the_same_scope_as_block_scoped_declaration_1,o,o);}}}}}(t),Pf(t,t.name),Cf(t,t.name),Ef(t,t.name),wf(t,t.name),Ff(t,t.name));}}var l,_;}function Lf(t,r,n){var i=e.getNameOfDeclaration(r);sr(i,151===r.kind||150===r.kind?e.Diagnostics.Subsequent_property_declarations_must_have_the_same_type_Property_0_must_be_of_type_1_but_here_has_type_2:e.Diagnostics.Subsequent_variable_declarations_must_have_the_same_type_Variable_0_must_be_of_type_1_but_here_has_type_2,e.declarationNameToString(i),En(t),En(n));}function Rf(t){return function(t){if(219!==t.parent.parent.kind&&220!==t.parent.parent.kind)if(2097152&t.flags){if(t.initializer){if(!e.isConst(t)||t.type){var r="=".length;return Ig(t,t.initializer.pos-r,r,e.Diagnostics.Initializers_are_not_allowed_in_ambient_contexts)}if(!Pg(t.initializer))return Mg(t.initializer,e.Diagnostics.A_const_initializer_in_an_ambient_context_must_be_a_string_or_numeric_literal)}if(t.initializer&&(!e.isConst(t)||!Pg(t.initializer))){var r="=".length;return Ig(t,t.initializer.pos-r,r,e.Diagnostics.Initializers_are_not_allowed_in_ambient_contexts)}}else if(!t.initializer){if(e.isBindingPattern(t.name)&&!e.isBindingPattern(t.parent))return Mg(t,e.Diagnostics.A_destructuring_declaration_must_have_an_initializer);if(e.isConst(t))return Mg(t,e.Diagnostics.const_declarations_must_be_initialized)}if(t.exclamationToken&&(212!==t.parent.parent.kind||!t.type||t.initializer||2097152&t.flags))return Mg(t.exclamationToken,e.Diagnostics.A_definite_assignment_assertion_is_not_permitted_in_this_context);D.module===e.ModuleKind.ES2015||D.module===e.ModuleKind.ESNext||D.module===e.ModuleKind.System||D.noEmit||2097152&t.parent.parent.flags||!e.hasModifier(t.parent.parent,1)||function t(r){if(71===r.kind){if("__esModule"===e.idText(r))return Mg(r,e.Diagnostics.Identifier_expected_esModule_is_reserved_as_an_exported_marker_when_transforming_ECMAScript_modules)}else for(var n=r.elements,i=0,a=n;i<a.length;i++){var o=a[i];if(!e.isOmittedExpression(o))return t(o.name)}}(t.name),(e.isLet(t)||e.isConst(t))&&function t(r){if(71===r.kind){if(110===r.originalKeywordKind)return Mg(r,e.Diagnostics.let_is_not_allowed_to_be_used_as_a_name_in_let_or_const_declarations)}else for(var n=r.elements,i=0,a=n;i<a.length;i++){var o=a[i];e.isOmittedExpression(o)||t(o.name);}}(t.name);}(t),Mf(t)}function Bf(t){return function(t){if(t.dotDotDotToken){var r=t.parent.elements;if(t!==e.last(r))return Mg(t,e.Diagnostics.A_rest_element_must_be_last_in_a_destructuring_pattern);if(179===t.name.kind||178===t.name.kind)return Mg(t.name,e.Diagnostics.A_rest_element_cannot_contain_a_binding_pattern);if(t.propertyName)return Mg(t.name,e.Diagnostics.A_rest_element_cannot_have_a_property_name);t.initializer&&Ig(t,t.initializer.pos-1,1,e.Diagnostics.A_rest_element_cannot_have_an_initializer);}}(t),Mf(t)}function Kf(t){fg(t)||wg(t.declarationList)||function(t){if(!function e(t){switch(t.kind){case 215:case 216:case 217:case 224:case 218:case 219:case 220:return!1;case 226:return e(t.parent)}return!0}(t.parent)){if(e.isLet(t.declarationList))return Mg(t,e.Diagnostics.let_declarations_can_only_be_declared_inside_a_block);e.isConst(t.declarationList)&&Mg(t,e.Diagnostics.const_declarations_can_only_be_declared_inside_a_block);}}(t),e.forEach(t.declarationList.declarations,xm);}function jf(t){Cg(t);var r,n=$_(t.expression);if(231===t.initializer.kind){var i=t.initializer.declarations[0];i&&e.isBindingPattern(i.name)&&sr(i.name,e.Diagnostics.The_left_hand_side_of_a_for_in_statement_cannot_be_a_destructuring_pattern),Jf(t);}else{var a=t.initializer,o=Rp(a);181===a.kind||182===a.kind?sr(a,e.Diagnostics.The_left_hand_side_of_a_for_in_statement_cannot_be_a_destructuring_pattern):bc(16384&(r=vs(n)).flags?ae:r,o)?mp(a,e.Diagnostics.The_left_hand_side_of_a_for_in_statement_must_be_a_variable_or_a_property_access):sr(a,e.Diagnostics.The_left_hand_side_of_a_for_in_statement_must_be_of_type_string_or_any);}yp(n,141590528)||sr(t.expression,e.Diagnostics.The_right_hand_side_of_a_for_in_statement_must_be_of_type_any_an_object_type_or_a_type_parameter),xm(t.statement),t.locals&&yf(t);}function Jf(e){var t=e.initializer;t.declarations.length>=1&&Rf(t.declarations[0]);}function zf(e,t){return Uf($_(e),e,!0,void 0!==t)}function Uf(e,t,r,n){return zn(e)?e:qf(e,t,r,n,!0)||Q}function qf(t,r,n,i,a){var o=C>=2,s=!o&&D.downlevelIteration;if(o||s||i){var c=Vf(t,o?r:void 0,i,!0,a);if(c||o)return c}var u=t,l=!1,_=!1;if(n){if(131072&u.flags){var d=t.types,p=e.filter(d,function(e){return!(524322&e.flags)});p!==d&&(u=ds(p,2));}else 524322&u.flags&&(u=de);if((_=u!==t)&&(C<1&&r&&(sr(r,e.Diagnostics.Using_a_string_in_a_for_of_statement_is_only_supported_in_ECMAScript_5_and_higher),l=!0),16384&u.flags))return ae}if(!Qc(u))return r&&!l&&sr(r,!n||_?s?e.Diagnostics.Type_0_is_not_an_array_type_or_does_not_have_a_Symbol_iterator_method_that_returns_an_iterator:e.Diagnostics.Type_0_is_not_an_array_type:s?e.Diagnostics.Type_0_is_not_an_array_type_or_a_string_type_or_does_not_have_a_Symbol_iterator_method_that_returns_an_iterator:e.Diagnostics.Type_0_is_not_an_array_type_or_a_string_type,En(u)),_?ae:void 0;var f=Ua(u,1);return _&&f?524322&f.flags?ae:ds([f,ae],2):f}function Vf(t,r,n,i,a){if(!zn(t))return fl(t,function(t){var o=t;if(n){if(o.iteratedTypeOfAsyncIterable)return o.iteratedTypeOfAsyncIterable;if(li(t,qo(!1))||li(t,Wo(!1)))return o.iteratedTypeOfAsyncIterable=t.typeArguments[0]}if(i){if(o.iteratedTypeOfIterable)return o.iteratedTypeOfIterable;if(li(t,Ho(!1))||li(t,$o(!1)))return o.iteratedTypeOfIterable=t.typeArguments[0]}var s=n&&Jn(t,e.getPropertyNameForKnownSymbolName("asyncIterator")),c=s||i&&Jn(t,e.getPropertyNameForKnownSymbolName("iterator"));if(!zn(c)){var u=c&&Ka(c,0);if(e.some(u)){var l=Wf(ds(e.map(u,io),2),r,!!s);return a&&r&&l&&Tc(t,s?function(e){return Qo(qo(!0),[e])}(l):es(l),r),s?o.iteratedTypeOfAsyncIterable=l:o.iteratedTypeOfIterable=l}r&&(sr(r,n?e.Diagnostics.Type_must_have_a_Symbol_asyncIterator_method_that_returns_an_async_iterator:e.Diagnostics.Type_must_have_a_Symbol_iterator_method_that_returns_an_iterator),r=void 0);}})}function Wf(t,r,n){if(!zn(t)){var i=t;if(n?i.iteratedTypeOfAsyncIterator:i.iteratedTypeOfIterator)return n?i.iteratedTypeOfAsyncIterator:i.iteratedTypeOfIterator;if(li(t,(n?Vo:Go)(!1)))return n?i.iteratedTypeOfAsyncIterator=t.typeArguments[0]:i.iteratedTypeOfIterator=t.typeArguments[0];var a=Jn(t,"next");if(!zn(a)){var o=a?Ka(a,0):e.emptyArray;if(0!==o.length){var s=ds(e.map(o,io),2);if(!(zn(s)||n&&zn(s=af(s,r,e.Diagnostics.The_type_returned_by_the_next_method_of_an_async_iterator_must_be_a_promise_for_a_type_with_a_value_property)))){var c=s&&Jn(s,"value");if(c)return n?i.iteratedTypeOfAsyncIterator=c:i.iteratedTypeOfIterator=c;r&&sr(r,n?e.Diagnostics.The_type_returned_by_the_next_method_of_an_async_iterator_must_be_a_promise_for_a_type_with_a_value_property:e.Diagnostics.The_type_returned_by_the_next_method_of_an_iterator_must_have_a_value_property);}}else r&&sr(r,n?e.Diagnostics.An_async_iterator_must_have_a_next_method:e.Diagnostics.An_iterator_must_have_a_next_method);}}}function Hf(e,t){if(!zn(e))return Vf(e,void 0,t,!t,!1)||Wf(e,void 0,t)}function Gf(t){Lg(t)||function(t){for(var r=t;r;){if(e.isFunctionLike(r))return Mg(t,e.Diagnostics.Jump_target_cannot_cross_function_boundary);switch(r.kind){case 226:if(t.label&&r.label.escapedText===t.label.escapedText){var n=221===t.kind&&!e.isIterationStatement(r.statement,!0);return!!n&&Mg(t,e.Diagnostics.A_continue_statement_can_only_jump_to_a_label_of_an_enclosing_iteration_statement)}break;case 225:if(222===t.kind&&!t.label)return!1;break;default:if(e.isIterationStatement(r,!1)&&!t.label)return!1}r=r.parent;}if(t.label){var i=222===t.kind?e.Diagnostics.A_break_statement_can_only_jump_to_a_label_of_an_enclosing_statement:e.Diagnostics.A_continue_statement_can_only_jump_to_a_label_of_an_enclosing_iteration_statement;return Mg(t,i)}var i=222===t.kind?e.Diagnostics.A_break_statement_can_only_be_used_within_an_enclosing_iteration_or_switch_statement:e.Diagnostics.A_continue_statement_can_only_be_used_within_an_enclosing_iteration_statement;Mg(t,i);}(t);}function $f(t){return 155===t.kind&&void 0!==e.getEffectiveSetAccessorTypeAnnotationNode(e.getDeclarationOfKind(t.symbol,156))}function Xf(t,r){var n=2==(3&e.getFunctionFlags(t))?of(r):r;return n&&gp(n,2049)}function Qf(t){Lg(t)||void 0===t.expression&&function(t,r,n,i,a){var o=e.getSourceFileOfNode(t);if(!Fg(o)){var s=e.getSpanOfTokenAtPosition(o,t.pos);Lt.add(e.createFileDiagnostic(o,e.textSpanEnd(s),0,r,n,i,a));}}(t,e.Diagnostics.Line_break_not_permitted_here),t.expression&&Rp(t.expression);}function Yf(t){var r,n=mo(t.symbol,1),i=mo(t.symbol,0),a=Ua(t,0),o=Ua(t,1);if((a||o)&&(e.forEach(ha(t),function(e){var r=ui(e);d(e,r,t,i,a,0),d(e,r,t,n,o,1);}),1&e.getObjectFlags(t)&&e.isClassLike(t.symbol.valueDeclaration)))for(var s=0,c=t.symbol.valueDeclaration.members;s<c.length;s++){var u=c[s];if(!e.hasModifier(u,32)&&qi(u)){var l=nn(u),_=ui(l);d(l,_,t,i,a,0),d(l,_,t,n,o,1);}}function d(t,r,n,i,a,o){if(a&&!e.isKnownSymbol(t)){var s,c=t.valueDeclaration;if(1!==o||(c?v_(e.getNameOfDeclaration(c)):b_(t.escapedName)))!c||198!==c.kind&&146!==e.getNameOfDeclaration(c).kind&&t.parent!==n.symbol?i?s=i:2&e.getObjectFlags(n)&&(s=e.forEach(ki(n),function(e){return va(e,t.escapedName)&&Ua(e,o)})?void 0:n.symbol.declarations[0]):s=c,s&&!bc(r,a)&&sr(s,0===o?e.Diagnostics.Property_0_of_type_1_is_not_assignable_to_string_index_type_2:e.Diagnostics.Property_0_of_type_1_is_not_assignable_to_numeric_index_type_2,Dn(t),En(r),En(a));}}a&&o&&!(r=n||i)&&2&e.getObjectFlags(t)&&(r=e.forEach(ki(t),function(e){return Ua(e,0)&&Ua(e,1)})?void 0:t.symbol.declarations[0]),r&&!bc(o,a)&&sr(r,e.Diagnostics.Numeric_index_type_0_is_not_assignable_to_string_index_type_1,En(o),En(a));}function Zf(e,t){switch(e.escapedText){case"any":case"number":case"boolean":case"string":case"symbol":case"void":case"object":sr(e,t,e.escapedText);}}function em(t){if(t)for(var r=!1,n=0;n<t.length;n++){var i=t[n];if(Bp(i),a){i.default?r=!0:r&&sr(i,e.Diagnostics.Required_type_parameters_may_not_follow_optional_type_parameters);for(var o=0;o<n;o++)t[o].symbol===i.symbol&&sr(i.name,e.Diagnostics.Duplicate_identifier_0,e.declarationNameToString(i.name));}}}function tm(t){if(1!==t.declarations.length){var r=gr(t);if(!r.typeParametersChecked){r.typeParametersChecked=!0;var n=function(t){return e.filter(t.declarations,function(e){return 233===e.kind||234===e.kind})}(t);if(n.length<=1)return;if(!function(t,r){for(var n=e.length(r),i=Qa(r),a=0,o=t;a<o.length;a++){var s=o[a],c=e.length(s.typeParameters);if(c<i||c>n)return!1;for(var u=0;u<c;u++){var l=s.typeParameters[u],_=r[u];if(l.name.escapedText!==_.symbol.escapedName)return!1;var d=l.constraint&&Hs(l.constraint),p=ho(_);if(d&&(!p||!gc(d,p)))return!1;var f=l.default&&Hs(l.default),m=Fa(_);if(f&&m&&!gc(f,m))return!1}}return!0}(n,Fi(t).localTypeParameters))for(var i=Dn(t),a=0,o=n;a<o.length;a++)sr(o[a].name,e.Diagnostics.All_declarations_of_0_must_have_identical_type_parameters,i);}}}function rm(t){e.forEach(t.members,xm),yf(t);}function nm(t){!function(t){var r=e.getSourceFileOfNode(t);(function(t){var r=!1,n=!1;if(!fg(t)&&t.heritageClauses)for(var i=0,a=t.heritageClauses;i<a.length;i++){var o=a[i];if(85===o.token){if(r)return Og(o,e.Diagnostics.extends_clause_already_seen);if(n)return Og(o,e.Diagnostics.extends_clause_must_precede_implements_clause);if(o.types.length>1)return Og(o.types[1],e.Diagnostics.Classes_can_only_extend_a_single_class);r=!0;}else{if(e.Debug.assert(108===o.token),n)return Og(o,e.Diagnostics.implements_clause_already_seen);n=!0;}xg(o);}})(t)||yg(t.typeParameters,r);}(t),ff(t),t.name&&(Zf(t.name,e.Diagnostics.Class_name_cannot_be_0),Cf(t,t.name),Ef(t,t.name),wf(t,t.name),Ff(t,t.name)),em(t.typeParameters),nf(t);var r=nn(t),n=Fi(r),i=Xi(n),o=ui(r);tm(r),function(t){var r;!function(e){e[e.Getter=1]="Getter",e[e.Setter=2]="Setter",e[e.Method=4]="Method",e[e.Property=3]="Property";}(r||(r={}));for(var n=e.createUnderscoreEscapedMap(),i=e.createUnderscoreEscapedMap(),a=0,o=t.members;a<o.length;a++){var s=o[a];if(154===s.kind)for(var c=0,u=s.parameters;c<u.length;c++){var l=u[c];e.isParameterPropertyDeclaration(l)&&!e.isBindingPattern(l.name)&&p(n,l.name,l.name.escapedText,3);}else{var _=e.hasModifier(s,32)?i:n,d=s.name&&e.getPropertyNameForPropertyNameNode(s.name);if(d)switch(s.kind){case 155:p(_,s.name,d,1);break;case 156:p(_,s.name,d,2);break;case 151:p(_,s.name,d,3);break;case 153:p(_,s.name,d,4);}}}function p(t,r,n,i){var a=t.get(n);a?4&a?4!==i&&sr(r,e.Diagnostics.Duplicate_identifier_0,e.getTextOfNode(r)):a&i?sr(r,e.Diagnostics.Duplicate_identifier_0,e.getTextOfNode(r)):t.set(n,a|i):t.set(n,i);}}(t),2097152&t.flags||function(t){for(var r=0,n=t.members;r<n.length;r++){var i=n[r],a=i.name;if(e.hasModifier(i,32)&&a){var o=e.getPropertyNameForPropertyNameNode(a);switch(o){case"name":case"length":case"caller":case"arguments":case"prototype":sr(a,e.Diagnostics.Static_property_0_conflicts_with_built_in_property_Function_0_of_constructor_function_1,o,On(nn(t)));}}}}(t);var s=e.getClassExtendsHeritageClauseElement(t);if(s){C<2&&dg(s.parent,1);var c=ki(n);if(c.length&&a){var u=c[0],l=Si(n),_=Oa(l);if(function(t,r){var n=Ka(t,1);if(n.length){var i=n[0].declaration;if(i&&e.hasModifier(i,8)){var a=e.getClassLikeDeclarationOfSymbol(t.symbol);Pm(r,a)||sr(r,e.Diagnostics.Cannot_extend_a_class_0_Class_constructor_is_marked_as_private,Jr(t.symbol));}}}(_,s),xm(s.expression),e.some(s.typeArguments)){e.forEach(s.typeArguments,xm);for(var d=0,p=bi(_,s.typeArguments,s);d<p.length&&$p(s,p[d].typeParameters);d++);}if(Tc(i,b=Xi(u,n.thisType),void 0)||im(t,i,b,e.Diagnostics.Class_0_incorrectly_extends_base_class_1),Tc(o,mc(_),t.name||t,e.Diagnostics.Class_static_side_0_incorrectly_extends_base_class_static_side_1),1081344&l.flags&&!yi(o)&&sr(t.name||t,e.Diagnostics.A_mixin_class_must_have_a_constructor_with_a_single_rest_parameter_of_type_any),!(_.symbol&&32&_.symbol.flags||1081344&l.flags)){var f=xi(_,s.typeArguments,s);e.forEach(f,function(e){return io(e)!==u})&&sr(s.expression,e.Diagnostics.Base_constructors_must_all_have_the_same_return_type);}!function(t,r){for(var n=0,i=xa(r);n<i.length;n++){var a=i[n],o=am(a);if(!(4194304&o.flags)){var s=am(va(t,o.escapedName)),c=e.getDeclarationModifierFlagsFromSymbol(o);if(e.Debug.assert(!!s,"derived should point to something, even if it is the base class' declaration."),s)if(s===o){var u=e.getClassLikeDeclarationOfSymbol(t.symbol);!(128&c)||u&&e.hasModifier(u,128)||(203===u.kind?sr(u,e.Diagnostics.Non_abstract_class_expression_does_not_implement_inherited_abstract_member_0_from_class_1,Dn(a),En(r)):sr(u,e.Diagnostics.Non_abstract_class_0_does_not_implement_inherited_abstract_member_1_from_class_2,En(t),Dn(a),En(r)));}else{var l=e.getDeclarationModifierFlagsFromSymbol(s);if(8&c||8&l)continue;if(W_(o)&&W_(s)||98308&o.flags&&98308&s.flags)continue;var _=void 0;_=W_(o)?98304&s.flags?e.Diagnostics.Class_0_defines_instance_member_function_1_but_extended_class_2_defines_it_as_instance_member_accessor:e.Diagnostics.Class_0_defines_instance_member_function_1_but_extended_class_2_defines_it_as_instance_member_property:4&o.flags?e.Diagnostics.Class_0_defines_instance_member_property_1_but_extended_class_2_defines_it_as_instance_member_function:e.Diagnostics.Class_0_defines_instance_member_accessor_1_but_extended_class_2_defines_it_as_instance_member_function,sr(e.getNameOfDeclaration(s.valueDeclaration)||s.valueDeclaration,_,En(r),Dn(o),En(t));}}}}(n,u);}}var m=e.getClassImplementsHeritageClauseElements(t);if(m)for(var g=0,y=m;g<y.length;g++){var h=y[g];if(e.isEntityNameExpression(h.expression)||sr(h.expression,e.Diagnostics.A_class_can_only_implement_an_identifier_Slashqualified_name_with_optional_type_arguments),Qp(h),a){var v=Hs(h);if(v!==ee)if(Ti(v)){var b,x=v.symbol&&32&v.symbol.flags?e.Diagnostics.Class_0_incorrectly_implements_class_1_Did_you_mean_to_extend_1_and_inherit_its_members_as_a_subclass:e.Diagnostics.Class_0_incorrectly_implements_interface_1;Tc(i,b=Xi(v,n.thisType),void 0)||im(t,i,b,x);}else sr(h,e.Diagnostics.A_class_may_only_implement_another_class_or_interface);}}a&&(Yf(n),Up(t),function(t){if(P&&F&&!(2097152&t.flags))for(var r=cn(t),n=0,i=t.members;n<i.length;n++){var a=i[n];if(om(a)){var o=a.name;if(e.isIdentifier(o)){var s=ui(nn(a));1&s.flags||4096&su(s)||r&&sm(o,s,r)||sr(a.name,e.Diagnostics.Property_0_has_no_initializer_and_is_not_definitely_assigned_in_the_constructor,e.declarationNameToString(o));}}}}(t));}function im(t,r,n,i){for(var a=!1,o=function(t){if(e.hasStaticModifier(t))return"continue";var i=t.name&&Om(t.name)||Om(t);if(i){var o=Ra(r,i.escapedName),s=Ra(n,i.escapedName);o&&s&&(Tc(ui(o),ui(s),t.name||t,void 0,function(){return e.chainDiagnosticMessages(void 0,e.Diagnostics.Property_0_in_type_1_is_not_assignable_to_the_same_property_in_base_type_2,Dn(i),En(r),En(n))})||(a=!0));}},s=0,c=t.members;s<c.length;s++)o(c[s]);a||Tc(r,n,t.name||t,i);}function am(t){return 1&e.getCheckFlags(t)?t.target:t}function om(t){return 151===t.kind&&!e.hasModifier(t,160)&&!t.exclamationToken&&!t.initializer}function sm(t,r,n){var i=e.createPropertyAccess(e.createThis(),t);return i.flowNode=n.returnFlowNode,!(4096&su(Nl(i,r,_u(r))))}function cm(t){if(fg(t)||function(t){var r=!1;if(t.heritageClauses)for(var n=0,i=t.heritageClauses;n<i.length;n++){var a=i[n];if(85!==a.token)return e.Debug.assert(108===a.token),Og(a,e.Diagnostics.Interface_declaration_cannot_have_implements_clause);if(r)return Og(a,e.Diagnostics.extends_clause_already_seen);r=!0,xg(a);}}(t),em(t.typeParameters),a){Zf(t.name,e.Diagnostics.Interface_name_cannot_be_0),nf(t);var r=nn(t);if(tm(r),t===e.getDeclarationOfKind(r,234)){var n=Fi(r),i=Xi(n);if(function(t,r){var n=ki(t);if(n.length<2)return!0;var i=e.createUnderscoreEscapedMap();e.forEach(ji(t).declaredProperties,function(e){i.set(e.escapedName,{prop:e,containingType:t});});for(var a=!0,o=0,s=n;o<s.length;o++)for(var c=s[o],u=0,l=xa(Xi(c,t.thisType));u<l.length;u++){var _=l[u],d=i.get(_.escapedName);if(d){if(d.containingType!==t&&0===Vc(d.prop,_,yc)){a=!1;var p=En(d.containingType),f=En(c),m=e.chainDiagnosticMessages(void 0,e.Diagnostics.Named_property_0_of_types_1_and_2_are_not_identical,Dn(_),p,f);m=e.chainDiagnosticMessages(m,e.Diagnostics.Interface_0_cannot_simultaneously_extend_types_1_and_2,En(t),p,f),Lt.add(e.createDiagnosticForNodeFromMessageChain(r,m));}}else i.set(_.escapedName,{prop:_,containingType:c});}return a}(n,t.name)){for(var o=0,s=ki(n);o<s.length;o++)Tc(i,Xi(s[o],n.thisType),t.name,e.Diagnostics.Interface_0_incorrectly_extends_interface_1);Yf(n);}}zp(t);}e.forEach(e.getInterfaceBaseTypeNodes(t),function(t){e.isEntityNameExpression(t.expression)||sr(t.expression,e.Diagnostics.An_interface_can_only_extend_an_identifier_Slashqualified_name_with_optional_type_arguments),Qp(t);}),e.forEach(t.members,xm),a&&(Up(t),yf(t));}function um(e){var t=yr(e);if(!(16384&t.flags)){t.flags|=16384;for(var r=0,n=0,i=e.members;n<i.length;n++){var a=i[n],o=lm(a,r);yr(a).enumMemberValue=o,r="number"==typeof o?o+1:void 0;}}}function lm(t,r){if(qn(t.name))sr(t.name,e.Diagnostics.Computed_property_names_are_not_allowed_in_enums);else{var n=e.getTextOfPropertyName(t.name);b_(n)&&"Infinity"!==(i=n)&&"-Infinity"!==i&&"NaN"!==i&&sr(t.name,e.Diagnostics.An_enum_member_cannot_have_a_numeric_name);}var i;return t.initializer?function(t){var r=Ei(nn(t.parent)),n=e.isConst(t.parent),i=t.initializer,a=1!==r||Ci(t)?function r(n){switch(n.kind){case 196:var i=r(n.operand);if("number"==typeof i)switch(n.operator){case 37:return i;case 38:return-i;case 52:return~i}break;case 198:var a=r(n.left),s=r(n.right);if("number"==typeof a&&"number"==typeof s)switch(n.operatorToken.kind){case 49:return a|s;case 48:return a&s;case 46:return a>>s;case 47:return a>>>s;case 45:return a<<s;case 50:return a^s;case 39:return a*s;case 41:return a/s;case 37:return a+s;case 38:return a-s;case 42:return a%s;case 40:return Math.pow(a,s)}break;case 9:return n.text;case 8:return Rg(n),+n.text;case 189:return r(n.expression);case 71:return e.nodeIsMissing(n)?0:o(n,nn(t.parent),n.escapedText);case 184:case 183:var c=n;if(function e(t){return 71===t.kind||183===t.kind&&e(t.expression)||184===t.kind&&e(t.expression)&&9===t.argumentExpression.kind}(c)){var u=Lp(c.expression);if(u.symbol&&384&u.symbol.flags){var l=void 0;if(183===c.kind)l=c.name.escapedText;else{var _=c.argumentExpression;e.Debug.assert(e.isLiteralExpression(_)),l=e.escapeLeadingUnderscores(_.text);}return o(n,u.symbol,l)}}}}(i):void 0;if(void 0!==a)n&&"number"==typeof a&&!isFinite(a)&&sr(i,isNaN(a)?e.Diagnostics.const_enum_member_initializer_was_evaluated_to_disallowed_value_NaN:e.Diagnostics.const_enum_member_initializer_was_evaluated_to_a_non_finite_value);else{if(1===r)return sr(i,e.Diagnostics.Computed_values_are_not_permitted_in_an_enum_with_string_valued_members),0;n?sr(i,e.Diagnostics.In_const_enum_declarations_member_initializer_must_be_constant_expression):2097152&t.parent.flags?sr(i,e.Diagnostics.In_ambient_enum_declarations_member_initializer_must_be_constant_expression):Tc(Rp(i),Fi(nn(t.parent)),i,void 0);}return a;function o(r,n,i){var a=n.exports.get(i);if(a){var o=a.valueDeclaration;if(o!==t)return br(o,t)?Zm(o):(sr(r,e.Diagnostics.A_member_initializer_in_a_enum_declaration_cannot_reference_members_declared_after_it_including_members_defined_in_other_enums),0)}}}(t):2097152&t.parent.flags&&!e.isConst(t.parent)?void 0:void 0!==r?r:void sr(t.name,e.Diagnostics.Enum_member_must_have_initializer)}function _m(t){if(a){var r=e.isGlobalScopeAugmentation(t),n=2097152&t.flags;r&&!n&&sr(t.name,e.Diagnostics.Augmentations_for_the_global_scope_should_have_declare_modifier_unless_they_appear_in_already_ambient_context);var i=e.isAmbientModule(t);if(ym(t,i?e.Diagnostics.An_ambient_module_declaration_is_only_allowed_at_the_top_level_in_a_file:e.Diagnostics.A_namespace_declaration_is_only_allowed_in_a_namespace_or_module))return;fg(t)||n||9!==t.name.kind||Mg(t.name,e.Diagnostics.Only_ambient_modules_can_use_quoted_names),e.isIdentifier(t.name)&&(Cf(t,t.name),wf(t,t.name),Ff(t,t.name)),nf(t);var o=nn(t);if(512&o.flags&&o.declarations.length>1&&!n&&l(t,D.preserveConstEnums||D.isolatedModules)){var s=function(t){for(var r=0,n=t.declarations;r<n.length;r++){var i=n[r];if((233===i.kind||232===i.kind&&e.nodeIsPresent(i.body))&&!(2097152&i.flags))return i}}(o);s&&(e.getSourceFileOfNode(t)!==e.getSourceFileOfNode(s)?sr(t.name,e.Diagnostics.A_namespace_declaration_cannot_be_in_a_different_file_from_a_class_or_function_with_which_it_is_merged):t.pos<s.pos&&sr(t.name,e.Diagnostics.A_namespace_declaration_cannot_be_located_prior_to_a_class_or_function_with_which_it_is_merged));var c=e.getDeclarationOfKind(o,233);c&&(d=t,p=c,f=e.getEnclosingBlockScopeContainer(d),m=e.getEnclosingBlockScopeContainer(p),hr(f)?hr(m):!hr(m)&&f===m)&&(yr(t).flags|=32768);}if(i)if(e.isExternalModuleAugmentation(t)){if((r||33554432&nn(t).flags)&&t.body)for(var u=0,_=t.body.statements;u<_.length;u++)dm(_[u],r);}else hr(t.parent)?r?sr(t.name,e.Diagnostics.Augmentations_for_the_global_scope_can_only_be_directly_nested_in_external_modules_or_ambient_module_declarations):e.isExternalModuleNameRelative(e.getTextOfIdentifierOrLiteral(t.name))&&sr(t.name,e.Diagnostics.Ambient_module_declaration_cannot_specify_relative_module_name):sr(t.name,r?e.Diagnostics.Augmentations_for_the_global_scope_can_only_be_directly_nested_in_external_modules_or_ambient_module_declarations:e.Diagnostics.Ambient_modules_cannot_be_nested_in_other_modules_or_namespaces);}var d,p,f,m;t.body&&(xm(t.body),e.isGlobalScopeAugmentation(t)||yf(t));}function dm(t,r){switch(t.kind){case 212:for(var n=0,i=t.declarationList.declarations;n<i.length;n++)dm(i[n],r);break;case 247:case 248:Og(t,e.Diagnostics.Exports_and_export_assignments_are_not_permitted_in_module_augmentations);break;case 241:case 242:Og(t,e.Diagnostics.Imports_are_not_permitted_in_module_augmentations_Consider_moving_them_to_the_enclosing_external_module);break;case 180:case 230:var a=t.name;if(e.isBindingPattern(a)){for(var o=0,s=a.elements;o<s.length;o++)dm(s[o],r);break}case 233:case 236:case 232:case 234:case 237:case 235:if(r)return;var c=nn(t);if(c){var u=!(33554432&c.flags);u||(u=e.isExternalModuleAugmentation(c.parent.declarations[0]));}}}function pm(e){switch(e.kind){case 71:return e;case 145:do{e=e.left;}while(71!==e.kind);return e;case 183:do{e=e.expression;}while(71!==e.kind);return e}}function fm(t){var r=e.getExternalModuleName(t);if(e.nodeIsMissing(r))return!1;if(!e.isStringLiteral(r))return sr(r,e.Diagnostics.String_literal_expected),!1;var n=238===t.parent.kind&&e.isAmbientModule(t.parent.parent);return 272===t.parent.kind||n?!(n&&e.isExternalModuleNameRelative(r.text)&&!wn(t)&&(sr(t,e.Diagnostics.Import_or_export_declaration_in_an_ambient_module_declaration_cannot_reference_module_through_relative_module_name),1)):(sr(r,248===t.kind?e.Diagnostics.Export_declarations_are_not_permitted_in_a_namespace:e.Diagnostics.Import_declarations_in_a_namespace_cannot_reference_a_module),!1)}function mm(t){var r=nn(t),n=Rr(r);if(n!==$){var i=(68264895&r.flags?67216319:0)|(67901928&r.flags?67901928:0)|(1920&r.flags?1920:0);n.flags&i&&sr(t,250===t.kind?e.Diagnostics.Export_declaration_conflicts_with_exported_declaration_of_0:e.Diagnostics.Import_declaration_conflicts_with_local_declaration_of_0,Dn(r)),!D.isolatedModules||250!==t.kind||67216319&n.flags||2097152&t.flags||sr(t,e.Diagnostics.Cannot_re_export_a_type_when_the_isolatedModules_flag_is_provided);}}function gm(e){Cf(e,e.name),wf(e,e.name),Ff(e,e.name),mm(e);}function ym(e,t){var r=272===e.parent.kind||238===e.parent.kind||237===e.parent.kind;return r||Og(e,t),!r}function hm(t){if(mm(t),D.declaration&&Mn(t.propertyName||t.name,!0),!t.parent.parent.moduleSpecifier){var r=t.propertyName||t.name,n=xr(r,r.escapedText,70107135,void 0,void 0,!0);n&&(n===R||hr(jn(n.declarations[0])))?sr(r,e.Diagnostics.Cannot_export_0_Only_local_declarations_can_be_exported_from_a_module,e.idText(r)):Br(t);}}function vm(t){var r=nn(t),n=gr(r);if(!n.exportsChecked){var i=r.exports.get("export=");if(i&&function(t){return e.forEachEntry(t.exports,function(e,t){return"export="!==t})}(r)){var a=Ar(i)||i.valueDeclaration;wn(a)||sr(a,e.Diagnostics.An_export_assignment_cannot_be_used_in_a_module_with_other_exported_elements);}var o=Zr(r);o&&o.forEach(function(t,r){var n=t.declarations,i=t.flags;if("__export"!==r&&!(1984&i)){var a=e.countWhere(n,ar);if(!(524288&i&&a<=2)&&a>1)for(var o=0,s=n;o<s.length;o++){var c=s[o];bm(c)&&Lt.add(e.createDiagnosticForNode(c,e.Diagnostics.Cannot_redeclare_exported_variable_0,e.unescapeLeadingUnderscores(r)));}}}),n.exportsChecked=!0;}}function bm(e){return 232!==e.kind&&153!==e.kind||!!e.body}function xm(t){if(t){if(e.isInJavaScriptFile(t)&&t.jsDoc)for(var r=0,n=t.jsDoc;r<n.length;r++){var i=n[r].tags;e.forEach(i,xm);}var o=t.kind;if(p)switch(o){case 237:case 233:case 234:case 232:p.throwIfCancellationRequested();}switch(o){case 147:return Bp(t);case 148:return Kp(t);case 151:case 150:return qp(t);case 162:case 163:case 157:case 158:case 159:return Jp(t);case 153:case 152:return function(t){Ag(t)||kg(t.name),gf(t),e.hasModifier(t,128)&&153===t.kind&&t.body&&sr(t,e.Diagnostics.Method_0_cannot_have_an_implementation_because_it_is_marked_abstract,e.declarationNameToString(t.name));}(t);case 154:return Vp(t);case 155:case 156:return Wp(t);case 161:return Qp(t);case 160:return function(t){var r=function(e){switch(e.parent.kind){case 191:case 157:case 232:case 190:case 162:case 153:case 152:var t=e.parent;if(e===t.type)return t}}(t);if(r){var n=no(Za(r));if(n){xm(t.type);var i=t.parameterName;if(e.isThisTypePredicate(n))Ws(i);else if(n.parameterIndex>=0)r.parameters[n.parameterIndex].dotDotDotToken?sr(i,e.Diagnostics.A_type_predicate_cannot_reference_a_rest_parameter):Tc(n.type,Im(r.parameters[n.parameterIndex]),t.type,void 0,function(){return e.chainDiagnosticMessages(void 0,e.Diagnostics.A_type_predicate_s_type_must_be_assignable_to_its_parameter_s_type)});else if(i){for(var a=!1,o=0,s=r.parameters;o<s.length;o++){var c=s[o].name;if(e.isBindingPattern(c)&&jp(c,i,n.parameterName)){a=!0;break}}a||sr(t.parameterName,e.Diagnostics.Cannot_find_parameter_0,n.parameterName);}}}else sr(t,e.Diagnostics.A_type_predicate_is_only_allowed_in_return_type_position_for_functions_and_methods);}(t);case 164:return function(e){Mo(e);}(t);case 165:return function(t){e.forEach(t.members,xm),a&&(Yf(Is(t)),Up(t),zp(t));}(t);case 166:return function(e){xm(e.elementType);}(t);case 167:return function(t){gg(t.elementTypes)||0!==t.elementTypes.length||Mg(t,e.Diagnostics.A_tuple_type_element_list_cannot_be_empty),e.forEach(t.elementTypes,xm);}(t);case 168:case 169:return function(t){e.forEach(t.types,xm);}(t);case 172:return xm(t.type);case 174:return Zp(t);case 170:return function(t){e.forEachChild(t,xm);}(t);case 171:return function(t){e.findAncestor(t,function(e){return e.parent&&170===e.parent.kind&&e.parent.extendsType===e})||Mg(t,e.Diagnostics.infer_declarations_are_only_permitted_in_the_extends_clause_of_a_conditional_type),xm(t.typeParameter);}(t);case 285:return function(t){var r=e.getJSDocHost(t);if(e.isClassDeclaration(r)||e.isClassExpression(r)){var n=e.getAllJSDocTagsOfKind(r,285);e.Debug.assert(n.length>0),n.length>1&&sr(n[1],e.Diagnostics.Class_declarations_cannot_have_more_than_one_augments_or_extends_tag);var i=mf(t.class.expression),a=e.getClassExtendsHeritageClauseElement(r);if(a){var o=mf(a.expression);o&&i.escapedText!==o.escapedText&&sr(i,e.Diagnostics.JSDoc_0_1_does_not_match_the_extends_2_clause,e.idText(t.tagName),e.idText(i),e.idText(o));}}else sr(r,e.Diagnostics.JSDoc_0_is_not_attached_to_a_class,e.idText(t.tagName));}(t);case 291:return function(t){t.typeExpression||sr(t.name,e.Diagnostics.JSDoc_typedef_tag_should_either_have_a_type_annotation_or_be_followed_by_property_or_member_tags);}(t);case 287:return function(t){xm(t.typeExpression),e.getParameterSymbolFromJSDoc(t)||sr(t.name,e.Diagnostics.JSDoc_param_tag_has_name_0_but_there_is_no_parameter_with_that_name,e.idText(145===t.name.kind?t.name.right:t.name));}(t);case 280:Jp(t);case 278:case 277:case 275:case 276:return Sm(t),void e.forEachChild(t,xm);case 281:return void function(t){Sm(t),xm(t.type);var r=t.parent;e.isJSDocTypeExpression(r)||sr(t,e.Diagnostics.JSDoc_may_only_appear_in_the_last_parameter_of_a_signature);var n=r.parent;if(e.isJSDocParameterTag(n)){var i=e.getParameterSymbolFromJSDoc(n);if(i){var a=e.getHostSignatureFromJSDoc(n);a&&e.last(a.parameters).symbol===i||sr(t,e.Diagnostics.A_rest_parameter_must_be_last_in_a_parameter_list);}}else sr(t,e.Diagnostics.JSDoc_may_only_appear_in_the_last_parameter_of_a_signature);}(t);case 274:return xm(t.type);case 175:return function(e){xm(e.objectType),xm(e.indexType),Yp(Ns(e),e);}(t);case 176:return function(e){xm(e.typeParameter),xm(e.type),O&&!e.type&&Su(e,Q),Tc(la(As(e)),ae,e.typeParameter.constraint);}(t);case 232:return function(e){a&&(gf(e),Tg(e),Pf(e,e.name),Cf(e,e.name),Ef(e,e.name),wf(e,e.name),Ff(e,e.name));}(t);case 211:case 238:return Tf(t);case 212:return Kf(t);case 214:return function(e){Lg(e),Rp(e.expression);}(t);case 215:return function(t){Lg(t),Rp(t.expression),xm(t.thenStatement),213===t.thenStatement.kind&&sr(t.thenStatement,e.Diagnostics.The_body_of_an_if_statement_cannot_be_the_empty_statement),xm(t.elseStatement);}(t);case 216:return function(e){Lg(e),xm(e.statement),Rp(e.expression);}(t);case 217:return function(e){Lg(e),Rp(e.expression),xm(e.statement);}(t);case 218:return function(t){Lg(t)||t.initializer&&231===t.initializer.kind&&wg(t.initializer),t.initializer&&(231===t.initializer.kind?e.forEach(t.initializer.declarations,Rf):Rp(t.initializer)),t.condition&&Rp(t.condition),t.incrementor&&Rp(t.incrementor),xm(t.statement),t.locals&&yf(t);}(t);case 219:return jf(t);case 220:return function(t){if(Cg(t),220===t.kind&&(t.awaitModifier?2==(6&e.getFunctionFlags(e.getContainingFunction(t)))&&C<6&&dg(t,16384):D.downlevelIteration&&C<2&&dg(t,256)),231===t.initializer.kind)Jf(t);else{var r=t.initializer,n=zf(t.expression,t.awaitModifier);if(181===r.kind||182===r.kind)kp(r,n||ee);else{var i=Rp(r);mp(r,e.Diagnostics.The_left_hand_side_of_a_for_of_statement_must_be_a_variable_or_a_property_access),n&&Tc(n,i,r,void 0);}}xm(t.statement),t.locals&&yf(t);}(t);case 221:case 222:return Gf(t);case 223:return function(t){if(!Lg(t)){var r=e.getContainingFunction(t);if(r){var n=io(Za(r)),i=e.getFunctionFlags(r),a=1&i;if(P||t.expression||16384&n.flags){var o=t.expression?Ap(t.expression):te;if(a)return;if(156===r.kind)t.expression&&sr(t,e.Diagnostics.Setters_cannot_return_a_value);else if(154===r.kind)t.expression&&!Tc(o,n,t)&&sr(t,e.Diagnostics.Return_type_of_constructor_signature_must_be_assignable_to_the_instance_type_of_the_class);else if(e.getEffectiveReturnTypeNode(r)||$f(r))if(2&i){var s=of(n),c=sf(o,t,e.Diagnostics.The_return_type_of_an_async_function_must_either_be_a_valid_promise_or_must_not_contain_a_callable_then_member);s&&Tc(c,s,t);}else Tc(o,n,t);}else 154===r.kind||!D.noImplicitReturns||Xf(r,n)||a||sr(t,e.Diagnostics.Not_all_code_paths_return_a_value);}else Og(t,e.Diagnostics.A_return_statement_can_only_be_used_within_a_function_body);}}(t);case 224:return function(t){Lg(t)||16384&t.flags&&Og(t,e.Diagnostics.with_statements_are_not_allowed_in_an_async_function_block),Rp(t.expression);var r=e.getSourceFileOfNode(t);if(!Fg(r)){var n=e.getSpanOfTokenAtPosition(r,t.pos).start;Ig(r,n,t.statement.pos-n,e.Diagnostics.The_with_statement_is_not_supported_All_symbols_in_a_with_block_will_have_type_any);}}(t);case 225:return function(t){var r;Lg(t);var n=!1,i=Rp(t.expression),o=eu(i);e.forEach(t.caseBlock.clauses,function(s){if(265===s.kind&&!n)if(void 0===r)r=s;else{var c=e.getSourceFileOfNode(t),u=e.skipTrivia(c.text,s.pos);Ig(c,u,(s.statements.length>0?s.statements[0].pos:s.end)-u,e.Diagnostics.A_default_clause_cannot_appear_more_than_once_in_a_switch_statement),n=!0;}if(a&&264===s.kind){var l=Rp(s.expression),_=eu(l),d=i;_&&o||(l=_?tu(l):l,d=tu(i)),Tp(d,l)||Dc(l,d,s.expression,void 0);}e.forEach(s.statements,xm);}),t.caseBlock.locals&&yf(t.caseBlock);}(t);case 226:return function(t){Lg(t)||e.findAncestor(t.parent,function(r){return e.isFunctionLike(r)?"quit":226===r.kind&&r.label.escapedText===t.label.escapedText?(Mg(t.label,e.Diagnostics.Duplicate_label_0,e.getTextOfNode(t.label)),!0):void 0}),xm(t.statement);}(t);case 227:return Qf(t);case 228:return function(t){Lg(t),Tf(t.tryBlock);var r=t.catchClause;if(r){if(r.variableDeclaration)if(r.variableDeclaration.type)Og(r.variableDeclaration.type,e.Diagnostics.Catch_clause_variable_cannot_have_a_type_annotation);else if(r.variableDeclaration.initializer)Og(r.variableDeclaration.initializer,e.Diagnostics.Catch_clause_variable_cannot_have_an_initializer);else{var n=r.block.locals;n&&e.forEachKey(r.locals,function(t){var r=n.get(t);r&&0!=(2&r.flags)&&Mg(r.valueDeclaration,e.Diagnostics.Cannot_redeclare_identifier_0_in_catch_clause,t);});}Tf(r.block);}t.finallyBlock&&Tf(t.finallyBlock);}(t);case 230:return Rf(t);case 180:return Bf(t);case 233:return function(t){t.name||e.hasModifier(t,512)||Og(t,e.Diagnostics.A_class_declaration_without_the_default_modifier_must_have_a_name),nm(t),e.forEach(t.members,xm),yf(t);}(t);case 234:return cm(t);case 235:return function(t){fg(t),Zf(t.name,e.Diagnostics.Type_alias_name_cannot_be_0),em(t.typeParameters),xm(t.type),yf(t);}(t);case 236:return function(t){if(a){fg(t),Zf(t.name,e.Diagnostics.Enum_name_cannot_be_0),Cf(t,t.name),Ef(t,t.name),wf(t,t.name),Ff(t,t.name),nf(t),um(t);var r=e.isConst(t);D.isolatedModules&&r&&2097152&t.flags&&sr(t.name,e.Diagnostics.Ambient_const_enums_are_not_allowed_when_the_isolatedModules_flag_is_provided);var n=nn(t);if(t===e.getDeclarationOfKind(n,t.kind)){n.declarations.length>1&&e.forEach(n.declarations,function(t){e.isConstEnumDeclaration(t)!==r&&sr(e.getNameOfDeclaration(t),e.Diagnostics.Enum_declarations_must_all_be_const_or_non_const);});var i=!1;e.forEach(n.declarations,function(t){if(236!==t.kind)return!1;var r=t;if(!r.members.length)return!1;var n=r.members[0];n.initializer||(i?sr(n.name,e.Diagnostics.In_an_enum_with_multiple_declarations_only_one_declaration_can_omit_an_initializer_for_its_first_enum_element):i=!0);});}}}(t);case 237:return _m(t);case 242:return function(t){if(!ym(t,e.Diagnostics.An_import_declaration_can_only_be_used_in_a_namespace_or_module)&&(!fg(t)&&e.hasModifiers(t)&&Og(t,e.Diagnostics.An_import_declaration_cannot_have_modifiers),fm(t))){var r=t.importClause;r&&(r.name&&gm(r),r.namedBindings&&(244===r.namedBindings.kind?gm(r.namedBindings):e.forEach(r.namedBindings.elements,gm)));}}(t);case 241:return function(t){if(!ym(t,e.Diagnostics.An_import_declaration_can_only_be_used_in_a_namespace_or_module)&&(fg(t),e.isInternalModuleImportEqualsDeclaration(t)||fm(t)))if(gm(t),e.hasModifier(t,1)&&Br(t),252!==t.moduleReference.kind){var r=Rr(nn(t));if(r!==$){if(67216319&r.flags){var n=pm(t.moduleReference);1920&zr(n,67217343).flags||sr(n,e.Diagnostics.Module_0_is_hidden_by_a_local_declaration_with_the_same_name,e.declarationNameToString(n));}67901928&r.flags&&Zf(t.name,e.Diagnostics.Import_name_cannot_be_0);}}else E>=e.ModuleKind.ES2015&&!(2097152&t.flags)&&Mg(t,e.Diagnostics.Import_assignment_cannot_be_used_when_targeting_ECMAScript_modules_Consider_using_import_Asterisk_as_ns_from_mod_import_a_from_mod_import_d_from_mod_or_another_module_format_instead);}(t);case 248:return function(t){if(!ym(t,e.Diagnostics.An_export_declaration_can_only_be_used_in_a_module)&&(!fg(t)&&e.hasModifiers(t)&&Og(t,e.Diagnostics.An_export_declaration_cannot_have_modifiers),!t.moduleSpecifier||fm(t)))if(t.exportClause){e.forEach(t.exportClause.elements,hm);var r=238===t.parent.kind&&e.isAmbientModule(t.parent.parent),n=!r&&238===t.parent.kind&&!t.moduleSpecifier&&2097152&t.flags;272===t.parent.kind||r||n||sr(t,e.Diagnostics.Export_declarations_are_not_permitted_in_a_namespace);}else{var i=Ur(t,t.moduleSpecifier);i&&$r(i)&&sr(t.moduleSpecifier,e.Diagnostics.Module_0_uses_export_and_cannot_be_used_with_export_Asterisk,Dn(i)),E!==e.ModuleKind.System&&E!==e.ModuleKind.ES2015&&E!==e.ModuleKind.ESNext&&dg(t,32768);}}(t);case 247:return function(t){if(!ym(t,e.Diagnostics.An_export_assignment_can_only_be_used_in_a_module)){var r=272===t.parent.kind?t.parent:t.parent.parent;237!==r.kind||e.isAmbientModule(r)?(!fg(t)&&e.hasModifiers(t)&&Og(t,e.Diagnostics.An_export_assignment_cannot_have_modifiers),71===t.expression.kind?(Br(t),D.declaration&&Mn(t.expression,!0)):Ap(t.expression),vm(r),2097152&t.flags&&!e.isEntityNameExpression(t.expression)&&Mg(t.expression,e.Diagnostics.The_expression_of_an_export_assignment_must_be_an_identifier_or_qualified_name_in_an_ambient_context),!t.isExportEquals||2097152&t.flags||(E>=e.ModuleKind.ES2015?Mg(t,e.Diagnostics.Export_assignment_cannot_be_used_when_targeting_ECMAScript_modules_Consider_using_export_default_or_another_module_format_instead):E===e.ModuleKind.System&&Mg(t,e.Diagnostics.Export_assignment_is_not_supported_when_module_flag_is_system))):t.isExportEquals?sr(t,e.Diagnostics.An_export_assignment_cannot_be_used_in_a_namespace):sr(t,e.Diagnostics.A_default_export_can_only_be_used_in_an_ECMAScript_style_module);}}(t);case 213:case 229:return void Lg(t);case 251:return function(e){ff(e);}(t)}}}function Sm(t){e.isInJavaScriptFile(t)||Mg(t,e.Diagnostics.JSDoc_types_can_only_be_used_inside_documentation_comments);}function km(e){et&&et.push(e);}function Tm(t){e.performance.mark("beforeCheck"),function(t){var r=yr(t);if(!(1&r.flags)){if(D.skipLibCheck&&t.isDeclarationFile||D.skipDefaultLibCheck&&t.hasNoDefaultLib)return;!function(t){2097152&t.flags&&function(t){for(var r=0,n=t.statements;r<n.length;r++){var i=n[r];if((e.isDeclaration(i)||212===i.kind)&&(234!==(a=i).kind&&235!==a.kind&&242!==a.kind&&241!==a.kind&&248!==a.kind&&247!==a.kind&&240!==a.kind&&!e.hasModifier(a,515)&&Og(a,e.Diagnostics.A_declare_modifier_is_required_for_a_top_level_declaration_in_a_d_ts_file)))return!0}var a;}(t);}(t),e.clear(Ot),e.clear(It),et=[],tt=a&&N?[]:void 0,gt=!1,e.forEach(t.statements,xm),function(){for(var e=0,t=et;e<t.length;e++){var r=t[e];switch(r.kind){case 190:case 191:case 153:case 152:lp(r);break;case 155:case 156:Wp(r);break;case 203:rm(r);}}}(),e.isExternalOrCommonJsModule(t)&&yf(t),t.isDeclarationFile||function(){if(tt)for(var t=0,r=tt;t<r.length;t++){var n=r[t];switch(n.kind){case 272:case 237:kf(n);break;case 233:case 203:xf(n),Sf(n);break;case 234:Sf(n);break;case 211:case 239:case 218:case 219:case 220:hf(n);break;case 154:case 190:case 232:case 191:case 153:case 155:case 156:n.body&&hf(n),Sf(n);break;case 152:case 157:case 158:case 162:case 163:case 235:Sf(n);break;default:e.Debug.fail("Node should not have been registered for unused identifiers check");}}}(),et=void 0,tt=void 0,e.isExternalOrCommonJsModule(t)&&vm(t),Ot.length&&(e.forEach(Ot,Nf),e.clear(Ot)),It.length&&(e.forEach(It,Af),e.clear(It)),r.flags|=1;}}(t),e.performance.mark("afterCheck"),e.performance.measure("Check","beforeCheck","afterCheck");}function Dm(t,r){try{return p=r,function(t){if(Cm(),t){var r=Lt.getGlobalDiagnostics(),n=r.length;Tm(t);var a=Lt.getDiagnostics(t.fileName),o=Lt.getGlobalDiagnostics();if(o!==r){var s=e.relativeComplement(r,o,e.compareDiagnostics);return e.concatenate(s,a)}return 0===n&&o.length>0?e.concatenate(o,a):a}return e.forEach(i.getSourceFiles(),Tm),Lt.getDiagnostics()}(t)}finally{p=void 0;}}function Cm(){if(!a)throw new Error("Trying to get diagnostics from a type checker that does not produce them.")}function Em(e){switch(e.kind){case 147:case 233:case 234:case 235:case 236:return!0}}function Nm(e){for(var t=e;t.parent&&145===t.parent.kind;)t=t.parent;return t.parent&&161===t.parent.kind}function Am(t,r){for(var n;(t=e.getContainingClass(t))&&!(n=r(t)););return n}function Pm(e,t){return!!Am(e,function(e){return e===t})}function wm(e){return void 0!==function(e){for(;145===e.parent.kind;)e=e.parent;return 241===e.parent.kind?e.parent.moduleReference===e&&e.parent:247===e.parent.kind?e.parent.expression===e&&e.parent:void 0}(e)}function Fm(t){if(e.isDeclarationName(t))return nn(t.parent);if(e.isInJavaScriptFile(t)&&183===t.parent.kind&&t.parent===t.parent.parent.left){var r=function(t){switch(e.getSpecialPropertyAssignmentKind(t.parent.parent)){case 1:case 3:return nn(t.parent);case 4:case 2:case 5:return nn(t.parent.parent)}}(t);if(r)return r}if(247===t.parent.kind&&e.isEntityNameExpression(t))return zr(t,70107135);if(183!==t.kind&&wm(t)){var n=e.getAncestor(t,241);return e.Debug.assert(void 0!==n),jr(t,!0)}if(e.isRightSideOfQualifiedNameOrPropertyAccess(t)&&(t=t.parent),function(e){for(var t=e;t.parent&&183===t.parent.kind;)t=t.parent;return t.parent&&205===t.parent.kind}(t)){var i=0;205===t.parent.kind?(i=67901928,e.isExpressionWithTypeArgumentsInClassExtendsClause(t.parent)&&(i|=67216319)):i=1920,i|=2097152;var a=e.isEntityNameExpression(t)?zr(t,i):void 0;if(a)return a}if(287===t.parent.kind)return e.getParameterSymbolFromJSDoc(t.parent);if(147===t.parent.kind&&290===t.parent.parent.kind){e.Debug.assert(!e.isInJavaScriptFile(t));var o=e.getTypeParameterFromJsDoc(t.parent);return o&&o.symbol}if(e.isExpressionNode(t)){if(e.nodeIsMissing(t))return;if(71===t.kind){if(e.isJSXTagName(t)&&C_(t)){var s=w_(t.parent);return s===$?void 0:s}return zr(t,67216319,!1,!0)}if(183===t.kind||145===t.kind){var c=yr(t);return c.resolvedSymbol?c.resolvedSymbol:(183===t.kind?Q_(t):Y_(t),c.resolvedSymbol)}}else{if(Nm(t))return zr(t,i=161===t.parent.kind?67901928:1920,!1,!0);if(260===t.parent.kind)return j_(t.parent)}return 160===t.parent.kind?zr(t,1):void 0}function Om(t){if(272===t.kind)return e.isExternalModule(t)?rn(t.symbol):void 0;if(!(4194304&t.flags)){if(_(t))return nn(t.parent);if(e.isLiteralComputedPropertyDeclarationName(t))return nn(t.parent.parent);if(71===t.kind){if(wm(t))return Fm(t);if(180===t.parent.kind&&178===t.parent.parent.kind&&t===t.parent.propertyName){var r=Im(t.parent.parent),n=r&&Ra(r,t.escapedText);if(n)return n}}switch(t.kind){case 71:case 183:case 145:return Fm(t);case 99:var i=e.getThisContainer(t,!1);if(e.isFunctionLike(i)){var a=Za(i);if(a.thisParameter)return a.thisParameter}if(e.isInExpressionContext(t))return Rp(t).symbol;case 173:return Ws(t).symbol;case 97:return Rp(t).symbol;case 123:var o=t.parent;return o&&154===o.kind?o.parent.symbol:void 0;case 9:case 13:if(e.isExternalModuleImportEqualsDeclaration(t.parent.parent)&&e.getExternalModuleImportEqualsDeclarationExpression(t.parent.parent)===t||(242===t.parent.kind||248===t.parent.kind)&&t.parent.moduleSpecifier===t||e.isInJavaScriptFile(t)&&e.isRequireCall(t.parent,!1)||e.isImportCall(t.parent))return Ur(t,t);case 8:var s=e.isElementAccessExpression(t.parent)?t.parent.argumentExpression===t?Lp(t.parent.expression):void 0:e.isLiteralTypeNode(t.parent)&&e.isIndexedAccessTypeNode(t.parent.parent)?Hs(t.parent.parent.objectType):void 0;return s&&Ra(s,e.escapeLeadingUnderscores(t.text));case 79:case 89:case 36:return nn(t.parent);default:return}}}function Im(t){if(4194304&t.flags)return ee;if(e.isPartOfTypeNode(t)){var r=Hs(t);return r&&e.isExpressionWithTypeArgumentsInClassImplementsClause(t)&&(r=Xi(r,(n=Im(e.getContainingClass(t))).thisType)),r}if(e.isExpressionNode(t))return Mm(t);if(e.isExpressionWithTypeArgumentsInClassExtendsClause(t)){var n,i=ki(n=Fi(nn(e.getContainingClass(t))))[0];return i&&Xi(i,n.thisType)}var a,o;if(Em(t))return Fi(o=nn(t));if(71===(a=t).kind&&Em(a.parent)&&a.parent.name===a)return(o=Om(t))&&Fi(o);if(e.isDeclaration(t))return ui(o=nn(t));if(_(t))return(o=Om(t))&&ui(o);if(e.isBindingPattern(t))return Xn(t.parent,!0);if(wm(t)&&(o=Om(t))){var s=Fi(o);return s!==ee?s:ui(o)}return ee}function Mm(t){return e.isRightSideOfQualifiedNameOrPropertyAccess(t)&&(t=t.parent),Us(Lp(t))}function Lm(t){t=Oa(t);var r=e.createSymbolTable(xa(t));return Rm(t)&&e.forEach(xa(Ae),function(e){r.has(e.escapedName)||r.set(e.escapedName,e);}),pn(r)}function Rm(t){return e.typeHasCallOrConstructSignatures(t,J)}function Bm(t){return!(e.isGeneratedIdentifier(t)||!(t=e.getParseTreeNode(t,e.isIdentifier)))&&(!(183===t.parent.kind&&t.parent.name===t)&&sg(t)===j)}function Km(t){var r=Ur(t.parent,t);if(!r||e.isShorthandAmbientModuleSymbol(r))return!0;var n=$r(r),i=gr(r=Hr(r));return void 0===i.exportsSomeValue&&(i.exportsSomeValue=n?!!(67216319&r.flags):e.forEachEntry(Zr(r),function(e){return(e=Lr(e))&&!!(67216319&e.flags)})),i.exportsSomeValue}function jm(t,r){if(t=e.getParseTreeNode(t,e.isIdentifier)){var n=sg(t,function(t){var r=t.parent;return r&&e.isModuleOrEnumDeclaration(r)&&t===r.name}(t));if(n){if(1048576&n.flags){var i=rn(n.exportSymbol);if(!r&&944&i.flags&&!(3&i.flags))return;n=i;}var a=an(n);if(a){if(512&a.flags&&272===a.valueDeclaration.kind){var o=a.valueDeclaration;return o!==e.getSourceFileOfNode(t)?void 0:o}return e.findAncestor(t.parent,function(t){return e.isModuleOrEnumDeclaration(t)&&nn(t)===a})}}}}function Jm(t){if(t=e.getParseTreeNode(t,e.isIdentifier)){var r=sg(t);if(Mr(r,67216319))return Ar(r)}}function zm(t){if(418&t.flags){var r=gr(t);if(void 0===r.isDeclarationWithCollidingName){var n=e.getEnclosingBlockScopeContainer(t.valueDeclaration);if(e.isStatementWithLocals(n)){var i=yr(t.valueDeclaration);if(xr(n.parent,t.escapedName,67216319,void 0,void 0,!1))r.isDeclarationWithCollidingName=!0;else if(131072&i.flags){var a=262144&i.flags,o=e.isIterationStatement(n,!1),s=211===n.kind&&e.isIterationStatement(n.parent,!1);r.isDeclarationWithCollidingName=!(e.isBlockScopedContainerTopLevel(n)||a&&(o||s));}else r.isDeclarationWithCollidingName=!1;}}return r.isDeclarationWithCollidingName}return!1}function Um(t){if(!e.isGeneratedIdentifier(t)&&(t=e.getParseTreeNode(t,e.isIdentifier))){var r=sg(t);if(r&&zm(r))return r.valueDeclaration}}function qm(t){if(t=e.getParseTreeNode(t,e.isDeclaration)){var r=nn(t);if(r)return zm(r)}return!1}function Vm(t){switch(t.kind){case 241:case 243:case 244:case 246:case 250:return Hm(nn(t)||$);case 248:var r=t.exportClause;return r&&e.forEach(r.elements,Vm);case 247:return!t.expression||71!==t.expression.kind||Hm(nn(t)||$)}return!1}function Wm(t){return!(void 0===(t=e.getParseTreeNode(t,e.isImportEqualsDeclaration))||272!==t.parent.kind||!e.isInternalModuleImportEqualsDeclaration(t))&&Hm(nn(t))&&t.moduleReference&&!e.nodeIsMissing(t.moduleReference)}function Hm(e){var t=Rr(e);return t===$||67216319&t.flags&&(D.preserveConstEnums||!Gm(t))}function Gm(e){return bp(e)||e.constEnumOnlyModule}function $m(t){if(e.nodeIsPresent(t.body)){var r=eo(nn(t));return r.length>1||1===r.length&&r[0].declaration!==t}return!1}function Xm(t){return P&&!Ga(t)&&t.initializer&&!e.hasModifier(t,92)}function Qm(t){return P&&Ga(t)&&!t.initializer&&e.hasModifier(t,92)}function Ym(e){return yr(e).flags}function Zm(e){return um(e.parent),yr(e).enumMemberValue}function eg(e){switch(e.kind){case 271:case 183:case 184:return!0}return!1}function tg(t){if(271===t.kind)return Zm(t);var r=yr(t).resolvedSymbol;return r&&8&r.flags&&e.isConstEnumDeclaration(r.valueDeclaration.parent)?Zm(r.valueDeclaration):void 0}function rg(t,r){if(!(t=e.getParseTreeNode(t,e.isEntityName)))return e.TypeReferenceSerializationKind.Unknown;if(r&&!(r=e.getParseTreeNode(r)))return e.TypeReferenceSerializationKind.Unknown;var n=zr(t,67216319,!0,!1,r),i=zr(t,67901928,!0,!1,r);if(n&&n===i){var a=Uo(!1);if(a&&n===a)return e.TypeReferenceSerializationKind.Promise;var o=ui(n);if(o&&hi(o))return e.TypeReferenceSerializationKind.TypeWithConstructSignatureAndValue}if(!i)return e.TypeReferenceSerializationKind.ObjectType;var s=Fi(i);return s===ee?e.TypeReferenceSerializationKind.Unknown:1&s.flags?e.TypeReferenceSerializationKind.ObjectType:yp(s,30720)?e.TypeReferenceSerializationKind.VoidNullableOrNeverType:yp(s,136)?e.TypeReferenceSerializationKind.BooleanType:yp(s,84)?e.TypeReferenceSerializationKind.NumberLikeType:yp(s,524322)?e.TypeReferenceSerializationKind.StringLikeType:au(s)?e.TypeReferenceSerializationKind.ArrayLikeType:yp(s,1536)?e.TypeReferenceSerializationKind.ESSymbolType:function(e){return 65536&e.flags&&Ka(e,0).length>0}(s)?e.TypeReferenceSerializationKind.TypeWithCallSignature:Xc(s)?e.TypeReferenceSerializationKind.ArrayLikeType:e.TypeReferenceSerializationKind.ObjectType}function ng(e,t,r,n){var i=nn(e),a=!i||133120&i.flags?ee:ru(ui(i));1024&a.flags&&a.symbol===i&&(r|=1048576),131072&r&&(a=_u(a)),En(a,t,1024|r,n);}function ig(e,t,r,n){En(io(Za(e)),t,1024|r,n);}function ag(e,t,r,n){En(bu(Mm(e)),t,1024|r,n);}function og(t){return _t.has(e.escapeLeadingUnderscores(t))}function sg(t,r){var n=yr(t).resolvedSymbol;if(n)return n;var i=t;if(r){var a=t.parent;e.isDeclaration(a)&&t===a.name&&(i=jn(a));}return xr(i,t.escapedText,70362047,void 0,void 0,!0)}function cg(t){if(!e.isGeneratedIdentifier(t)&&(t=e.getParseTreeNode(t,e.isIdentifier))){var r=sg(t);if(r)return on$$1(r).valueDeclaration}}function ug(t){if(e.isConst(t)){var r=ui(nn(t));return!!(96&r.flags&&8388608&r.flags)}return!1}function lg(t,r){var n=ui(nn(t));r.writeStringLiteral(function(t){return 32&t.flags?'"'+e.escapeString(t.value)+'"':""+t.value}(n));}function _g(t){var r=e.getExternalModuleName(t),n=qr(r,r,void 0);if(n)return e.getDeclarationOfKind(n,272)}function dg(t,r){if((f&r)!==r&&D.importHelpers){var n=e.getSourceFileOfNode(t);if(e.isEffectiveExternalModule(n,D)&&!(2097152&t.flags)){var i=(c=t,m||(m=Vr(n,e.externalHelpersModuleNameText,e.Diagnostics.This_syntax_requires_an_imported_helper_but_module_0_cannot_be_found,c)||$),m);if(i!==$)for(var a=r&~f,o=1;o<=65536;o<<=1)if(a&o){var s=pg(o);vr(i.exports,e.escapeLeadingUnderscores(s),67216319)||sr(t,e.Diagnostics.This_syntax_requires_an_imported_helper_named_1_but_module_0_has_no_exported_member_1,e.externalHelpersModuleNameText,s);}f|=r;}}var c;}function pg(t){switch(t){case 1:return"__extends";case 2:return"__assign";case 4:return"__rest";case 8:return"__decorate";case 16:return"__metadata";case 32:return"__param";case 64:return"__awaiter";case 128:return"__generator";case 256:return"__values";case 512:return"__read";case 1024:return"__spread";case 2048:return"__await";case 4096:return"__asyncGenerator";case 8192:return"__asyncDelegator";case 16384:return"__asyncValues";case 32768:return"__exportStar";case 65536:return"__makeTemplateObject";default:e.Debug.fail("Unrecognized helper");}}function fg(t){return function(t){if(!t.decorators)return!1;if(!e.nodeCanBeDecorated(t,t.parent,t.parent.parent))return 153!==t.kind||e.nodeIsPresent(t.body)?Og(t,e.Diagnostics.Decorators_are_not_valid_here):Og(t,e.Diagnostics.A_decorator_can_only_decorate_a_method_implementation_not_an_overload);if(155===t.kind||156===t.kind){var r=e.getAllAccessorDeclarations(t.parent.members,t);if(r.firstAccessor.decorators&&t===r.secondAccessor)return Og(t,e.Diagnostics.Decorators_cannot_be_applied_to_multiple_get_Slashset_accessors_of_the_same_name)}return!1}(t)||function(t){var r,n,i,a,o=function(t){return!!t.modifiers&&(function(t){switch(t.kind){case 155:case 156:case 154:case 151:case 150:case 153:case 152:case 159:case 237:case 242:case 241:case 248:case 247:case 190:case 191:case 148:return!1;default:if(238===t.parent.kind||272===t.parent.kind)return!1;switch(t.kind){case 232:return mg(t,120);case 233:return mg(t,117);case 234:case 212:case 235:return!0;case 236:return mg(t,76);default:return e.Debug.fail(),!1}}}(t)?Og(t,e.Diagnostics.Modifiers_cannot_appear_here):void 0)}(t);if(void 0!==o)return o;for(var s=0,c=0,u=t.modifiers;c<u.length;c++){var l=u[c];if(132!==l.kind){if(150===t.kind||152===t.kind)return Mg(l,e.Diagnostics._0_modifier_cannot_appear_on_a_type_member,e.tokenToString(l.kind));if(159===t.kind)return Mg(l,e.Diagnostics._0_modifier_cannot_appear_on_an_index_signature,e.tokenToString(l.kind))}switch(l.kind){case 76:if(236!==t.kind&&233===t.parent.kind)return Mg(t,e.Diagnostics.A_class_member_cannot_have_the_0_keyword,e.tokenToString(76));break;case 114:case 113:case 112:var _=Pn(e.modifierToFlag(l.kind));if(28&s)return Mg(l,e.Diagnostics.Accessibility_modifier_already_seen);if(32&s)return Mg(l,e.Diagnostics._0_modifier_must_precede_1_modifier,_,"static");if(64&s)return Mg(l,e.Diagnostics._0_modifier_must_precede_1_modifier,_,"readonly");if(256&s)return Mg(l,e.Diagnostics._0_modifier_must_precede_1_modifier,_,"async");if(238===t.parent.kind||272===t.parent.kind)return Mg(l,e.Diagnostics._0_modifier_cannot_appear_on_a_module_or_namespace_element,_);if(128&s)return 112===l.kind?Mg(l,e.Diagnostics._0_modifier_cannot_be_used_with_1_modifier,_,"abstract"):Mg(l,e.Diagnostics._0_modifier_must_precede_1_modifier,_,"abstract");s|=e.modifierToFlag(l.kind);break;case 115:if(32&s)return Mg(l,e.Diagnostics._0_modifier_already_seen,"static");if(64&s)return Mg(l,e.Diagnostics._0_modifier_must_precede_1_modifier,"static","readonly");if(256&s)return Mg(l,e.Diagnostics._0_modifier_must_precede_1_modifier,"static","async");if(238===t.parent.kind||272===t.parent.kind)return Mg(l,e.Diagnostics._0_modifier_cannot_appear_on_a_module_or_namespace_element,"static");if(148===t.kind)return Mg(l,e.Diagnostics._0_modifier_cannot_appear_on_a_parameter,"static");if(128&s)return Mg(l,e.Diagnostics._0_modifier_cannot_be_used_with_1_modifier,"static","abstract");s|=32,r=l;break;case 132:if(64&s)return Mg(l,e.Diagnostics._0_modifier_already_seen,"readonly");if(151!==t.kind&&150!==t.kind&&159!==t.kind&&148!==t.kind)return Mg(l,e.Diagnostics.readonly_modifier_can_only_appear_on_a_property_declaration_or_index_signature);s|=64,a=l;break;case 84:if(1&s)return Mg(l,e.Diagnostics._0_modifier_already_seen,"export");if(2&s)return Mg(l,e.Diagnostics._0_modifier_must_precede_1_modifier,"export","declare");if(128&s)return Mg(l,e.Diagnostics._0_modifier_must_precede_1_modifier,"export","abstract");if(256&s)return Mg(l,e.Diagnostics._0_modifier_must_precede_1_modifier,"export","async");if(233===t.parent.kind)return Mg(l,e.Diagnostics._0_modifier_cannot_appear_on_a_class_element,"export");if(148===t.kind)return Mg(l,e.Diagnostics._0_modifier_cannot_appear_on_a_parameter,"export");s|=1;break;case 79:var d=272===t.parent.kind?t.parent:t.parent.parent;if(237===d.kind&&!e.isAmbientModule(d))return Mg(l,e.Diagnostics.A_default_export_can_only_be_used_in_an_ECMAScript_style_module);s|=512;break;case 124:if(2&s)return Mg(l,e.Diagnostics._0_modifier_already_seen,"declare");if(256&s)return Mg(l,e.Diagnostics._0_modifier_cannot_be_used_in_an_ambient_context,"async");if(233===t.parent.kind)return Mg(l,e.Diagnostics._0_modifier_cannot_appear_on_a_class_element,"declare");if(148===t.kind)return Mg(l,e.Diagnostics._0_modifier_cannot_appear_on_a_parameter,"declare");if(2097152&t.parent.flags&&238===t.parent.kind)return Mg(l,e.Diagnostics.A_declare_modifier_cannot_be_used_in_an_already_ambient_context);s|=2,n=l;break;case 117:if(128&s)return Mg(l,e.Diagnostics._0_modifier_already_seen,"abstract");if(233!==t.kind){if(153!==t.kind&&151!==t.kind&&155!==t.kind&&156!==t.kind)return Mg(l,e.Diagnostics.abstract_modifier_can_only_appear_on_a_class_method_or_property_declaration);if(233!==t.parent.kind||!e.hasModifier(t.parent,128))return Mg(l,e.Diagnostics.Abstract_methods_can_only_appear_within_an_abstract_class);if(32&s)return Mg(l,e.Diagnostics._0_modifier_cannot_be_used_with_1_modifier,"static","abstract");if(8&s)return Mg(l,e.Diagnostics._0_modifier_cannot_be_used_with_1_modifier,"private","abstract")}s|=128;break;case 120:if(256&s)return Mg(l,e.Diagnostics._0_modifier_already_seen,"async");if(2&s||2097152&t.parent.flags)return Mg(l,e.Diagnostics._0_modifier_cannot_be_used_in_an_ambient_context,"async");if(148===t.kind)return Mg(l,e.Diagnostics._0_modifier_cannot_appear_on_a_parameter,"async");s|=256,i=l;}}return 154===t.kind?32&s?Mg(r,e.Diagnostics._0_modifier_cannot_appear_on_a_constructor_declaration,"static"):128&s?Mg(r,e.Diagnostics._0_modifier_cannot_appear_on_a_constructor_declaration,"abstract"):256&s?Mg(i,e.Diagnostics._0_modifier_cannot_appear_on_a_constructor_declaration,"async"):64&s?Mg(a,e.Diagnostics._0_modifier_cannot_appear_on_a_constructor_declaration,"readonly"):void 0:(242===t.kind||241===t.kind)&&2&s?Mg(n,e.Diagnostics.A_0_modifier_cannot_be_used_with_an_import_declaration,"declare"):148===t.kind&&92&s&&e.isBindingPattern(t.name)?Mg(t,e.Diagnostics.A_parameter_property_may_not_be_declared_using_a_binding_pattern):148===t.kind&&92&s&&t.dotDotDotToken?Mg(t,e.Diagnostics.A_parameter_property_cannot_be_declared_using_a_rest_parameter):256&s?function(t,r){switch(t.kind){case 153:case 232:case 190:case 191:return!1}return Mg(r,e.Diagnostics._0_modifier_cannot_be_used_here,"async")}(t,i):void 0}(t)}function mg(e,t){return e.modifiers.length>1||e.modifiers[0].kind!==t}function gg(t){if(t&&t.hasTrailingComma){var r=t.end-",".length,n=t.end;return Ig(t[0],r,n-r,e.Diagnostics.Trailing_comma_not_allowed)}}function yg(t,r){if(t&&0===t.length){var n=t.pos-"<".length;return Ig(r,n,e.skipTrivia(r.text,t.end)+">".length-n,e.Diagnostics.Type_parameter_list_cannot_be_empty)}}function hg(t){var r=e.getSourceFileOfNode(t);return fg(t)||yg(t.typeParameters,r)||function(t){for(var r=!1,n=t.length,i=0;i<n;i++){var a=t[i];if(a.dotDotDotToken){if(i!==n-1)return Mg(a.dotDotDotToken,e.Diagnostics.A_rest_parameter_must_be_last_in_a_parameter_list);if(e.isBindingPattern(a.name))return Mg(a.name,e.Diagnostics.A_rest_element_cannot_contain_a_binding_pattern);if(a.questionToken)return Mg(a.questionToken,e.Diagnostics.A_rest_parameter_cannot_be_optional);if(a.initializer)return Mg(a.name,e.Diagnostics.A_rest_parameter_cannot_have_an_initializer)}else if(a.questionToken){if(r=!0,a.initializer)return Mg(a.name,e.Diagnostics.Parameter_cannot_have_question_mark_and_initializer)}else if(r&&!a.initializer)return Mg(a.name,e.Diagnostics.A_required_parameter_cannot_follow_an_optional_parameter)}}(t.parameters)||function(t,r){if(!e.isArrowFunction(t))return!1;var n=t.equalsGreaterThanToken,i=e.getLineAndCharacterOfPosition(r,n.pos).line,a=e.getLineAndCharacterOfPosition(r,n.end).line;return i!==a&&Mg(n,e.Diagnostics.Line_terminator_not_permitted_before_arrow)}(t,r)}function vg(t,r){return gg(r)||function(t,r){if(r&&0===r.length){var n=e.getSourceFileOfNode(t),i=r.pos-"<".length;return Ig(n,i,e.skipTrivia(n.text,r.end)+">".length-i,e.Diagnostics.Type_argument_list_cannot_be_empty)}}(t,r)}function bg(t){return function(t){if(t)for(var r=0,n=t;r<n.length;r++){var i=n[r];if(204===i.kind)return Ig(i,i.pos,0,e.Diagnostics.Argument_expression_expected)}}(t)}function xg(t){var r=t.types;if(gg(r))return!0;if(r&&0===r.length){var n=e.tokenToString(t.token);return Ig(t,r.pos,0,e.Diagnostics._0_list_cannot_be_empty,n)}return e.forEach(r,Sg)}function Sg(e){return vg(e,e.typeArguments)}function kg(t){if(146!==t.kind)return!1;var r=t;return 198===r.expression.kind&&26===r.expression.operatorToken.kind?Mg(r.expression,e.Diagnostics.A_comma_expression_is_not_allowed_in_a_computed_property_name):void 0}function Tg(t){if(t.asteriskToken){if(e.Debug.assert(232===t.kind||190===t.kind||153===t.kind),2097152&t.flags)return Mg(t.asteriskToken,e.Diagnostics.Generators_are_not_allowed_in_an_ambient_context);if(!t.body)return Mg(t.asteriskToken,e.Diagnostics.An_overload_signature_cannot_be_declared_as_a_generator)}}function Dg(e,t){if(e)return Mg(e,t)}function Cg(t){if(Lg(t))return!0;if(220===t.kind&&t.awaitModifier&&0==(16384&t.flags))return Mg(t.awaitModifier,e.Diagnostics.A_for_await_of_statement_is_only_allowed_within_an_async_function_or_async_generator);if(231===t.initializer.kind){var r=t.initializer;if(!wg(r)){var n=r.declarations;if(!n.length)return!1;if(n.length>1){var i=219===t.kind?e.Diagnostics.Only_a_single_variable_declaration_is_allowed_in_a_for_in_statement:e.Diagnostics.Only_a_single_variable_declaration_is_allowed_in_a_for_of_statement;return Og(r.declarations[1],i)}var a=n[0];if(a.initializer){var i=219===t.kind?e.Diagnostics.The_variable_declaration_of_a_for_in_statement_cannot_have_an_initializer:e.Diagnostics.The_variable_declaration_of_a_for_of_statement_cannot_have_an_initializer;return Mg(a.name,i)}if(a.type)return Mg(a,i=219===t.kind?e.Diagnostics.The_left_hand_side_of_a_for_in_statement_cannot_use_a_type_annotation:e.Diagnostics.The_left_hand_side_of_a_for_of_statement_cannot_use_a_type_annotation)}}return!1}function Eg(t){if(t.parameters.length===(155===t.kind?1:2))return e.getThisParameter(t)}function Ng(t,r){if(function(t){return e.isDynamicName(t)&&!zi(t)}(t))return Mg(t,r)}function Ag(t){if(hg(t))return!0;if(153===t.kind){if(182===t.parent.kind){if(t.modifiers&&(1!==t.modifiers.length||120!==e.first(t.modifiers).kind))return Og(t,e.Diagnostics.Modifiers_cannot_appear_here);if(Dg(t.questionToken,e.Diagnostics.An_object_member_cannot_be_declared_optional))return!0;if(void 0===t.body)return Ig(t,t.end-1,";".length,e.Diagnostics._0_expected,"{")}if(Tg(t))return!0}if(e.isClassLike(t.parent)){if(2097152&t.flags)return Ng(t.name,e.Diagnostics.A_computed_property_name_in_an_ambient_context_must_refer_to_an_expression_whose_type_is_a_literal_type_or_a_unique_symbol_type);if(153===t.kind&&!t.body)return Ng(t.name,e.Diagnostics.A_computed_property_name_in_a_method_overload_must_refer_to_an_expression_whose_type_is_a_literal_type_or_a_unique_symbol_type)}else{if(234===t.parent.kind)return Ng(t.name,e.Diagnostics.A_computed_property_name_in_an_interface_must_refer_to_an_expression_whose_type_is_a_literal_type_or_a_unique_symbol_type);if(165===t.parent.kind)return Ng(t.name,e.Diagnostics.A_computed_property_name_in_a_type_literal_must_refer_to_an_expression_whose_type_is_a_literal_type_or_a_unique_symbol_type)}}function Pg(e){return 9===e.kind||8===e.kind||196===e.kind&&38===e.operator&&8===e.operand.kind}function wg(t){var r=t.declarations;return!!gg(t.declarations)||(t.declarations.length?void 0:Ig(t,r.pos,r.end-r.pos,e.Diagnostics.Variable_declaration_list_cannot_be_empty))}function Fg(e){return e.parseDiagnostics.length>0}function Og(t,r,n,i,a){var o=e.getSourceFileOfNode(t);if(!Fg(o)){var s=e.getSpanOfTokenAtPosition(o,t.pos);return Lt.add(e.createFileDiagnostic(o,s.start,s.length,r,n,i,a)),!0}}function Ig(t,r,n,i,a,o,s){var c=e.getSourceFileOfNode(t);if(!Fg(c))return Lt.add(e.createFileDiagnostic(c,r,n,i,a,o,s)),!0}function Mg(t,r,n,i,a){if(!Fg(e.getSourceFileOfNode(t)))return Lt.add(e.createDiagnosticForNode(t,r,n,i,a)),!0}function Lg(t){if(2097152&t.flags){if(e.isAccessor(t.parent))return yr(t).hasReportedStatementInAmbientContext=!0;if(!yr(t).hasReportedStatementInAmbientContext&&e.isFunctionLike(t.parent))return yr(t).hasReportedStatementInAmbientContext=Og(t,e.Diagnostics.An_implementation_cannot_be_declared_in_ambient_contexts);if(211===t.parent.kind||238===t.parent.kind||272===t.parent.kind){var r=yr(t.parent);if(!r.hasReportedStatementInAmbientContext)return r.hasReportedStatementInAmbientContext=Og(t,e.Diagnostics.Statements_are_not_allowed_in_ambient_contexts)}}}function Rg(t){if(32&t.numericLiteralFlags){var r=void 0;if(C>=1?r=e.Diagnostics.Octal_literals_are_not_available_when_targeting_ECMAScript_5_and_higher_Use_the_syntax_0:e.isChildOfNodeWithKind(t,177)?r=e.Diagnostics.Octal_literal_types_must_use_ES2015_syntax_Use_the_syntax_0:e.isChildOfNodeWithKind(t,271)&&(r=e.Diagnostics.Octal_literals_are_not_allowed_in_enums_members_initializer_Use_the_syntax_0),r){var n=e.isPrefixUnaryExpression(t.parent)&&38===t.parent.operator,i=(n?"-":"")+"0o"+t.text;return Mg(n?t.parent:t,r,i)}}}},function(e){e.JSX="JSX",e.IntrinsicElements="IntrinsicElements",e.ElementClass="ElementClass",e.ElementAttributesPropertyNameContainer="ElementAttributesProperty",e.ElementChildrenAttributeNameContainer="ElementChildrenAttribute",e.Element="Element",e.IntrinsicAttributes="IntrinsicAttributes",e.IntrinsicClassAttributes="IntrinsicClassAttributes";}(t||(t={}));}(i||(i={})),function(e){function t(t){var r=e.createNode(t,-1,-1);return r.flags|=8,r}function r(t,r){return t!==r&&(Lt(t,r),Pt(t,r),e.aggregateTransformFlags(t)),t}function n(t,r){if(t){if(e.isNodeArray(t))return t}else t=[];var n=t;return n.pos=-1,n.end=-1,n.hasTrailingComma=r,n}function i(e){if(void 0!==e){var r=t(e.kind);for(var n in r.flags|=e.flags,Lt(r,e),e)!r.hasOwnProperty(n)&&e.hasOwnProperty(n)&&(r[n]=e[n]);return r}}function a(t){return"number"==typeof t?o(t+""):"boolean"==typeof t?t?d():p():e.isString(t)?s(t):(r=t,(n=s(e.getTextOfIdentifierOrLiteral(r))).textSourceNode=r,n);var r,n;}function o(e){var r=t(8);return r.text=e,r.numericLiteralFlags=0,r}function s(e){var r=t(9);return r.text=e,r}function c(r,i){var a=t(71);return a.escapedText=e.escapeLeadingUnderscores(r),a.originalKeywordKind=r?e.stringToToken(r):0,a.autoGenerateFlags=0,a.autoGenerateId=0,i&&(a.typeArguments=n(i)),a}e.updateNode=r,e.createNodeArray=n,e.getSynthesizedClone=i,e.createLiteral=a,e.createNumericLiteral=o,e.createIdentifier=c,e.updateIdentifier=function(t,n){return t.typeArguments!==n?r(c(e.idText(t),n),t):t};var u,l=0;function _(e){return t(e)}function d(){return t(101)}function p(){return t(86)}function f(e,r){var n=t(145);return n.left=e,n.right=Et(r),n}function m(r){var n=t(146);return n.expression=function(t){return e.isBinaryExpression(t)&&26===t.operatorToken.kind||296===t.kind?te(t):t}(r),n}function g(e,r,n){var i=t(147);return i.name=Et(e),i.constraint=r,i.default=n,i}function y(r,n,i,a,o,s,c){var u=t(148);return u.decorators=Nt(r),u.modifiers=Nt(n),u.dotDotDotToken=i,u.name=Et(a),u.questionToken=o,u.type=s,u.initializer=c?e.parenthesizeExpressionForList(c):void 0,u}function h(r){var n=t(149);return n.expression=e.parenthesizeForAccess(r),n}function v(e,r,n,i,a){var o=t(150);return o.modifiers=Nt(e),o.name=Et(r),o.questionToken=n,o.type=i,o.initializer=a,o}function b(e,r,n,i,a,o){var s=t(151);return s.decorators=Nt(e),s.modifiers=Nt(r),s.name=Et(n),s.questionToken=void 0!==i&&55===i.kind?i:void 0,s.exclamationToken=void 0!==i&&51===i.kind?i:void 0,s.type=a,s.initializer=o,s}function x(e,t,r,n,i){var a=E(152,e,t,r);return a.name=Et(n),a.questionToken=i,a}function S(e,r,i,a,o,s,c,u,l){var _=t(153);return _.decorators=Nt(e),_.modifiers=Nt(r),_.asteriskToken=i,_.name=Et(a),_.questionToken=o,_.typeParameters=Nt(s),_.parameters=n(c),_.type=u,_.body=l,_}function k(e,r,i,a){var o=t(154);return o.decorators=Nt(e),o.modifiers=Nt(r),o.typeParameters=void 0,o.parameters=n(i),o.type=void 0,o.body=a,o}function T(e,r,i,a,o,s){var c=t(155);return c.decorators=Nt(e),c.modifiers=Nt(r),c.name=Et(i),c.typeParameters=void 0,c.parameters=n(a),c.type=o,c.body=s,c}function D(e,r,i,a,o){var s=t(156);return s.decorators=Nt(e),s.modifiers=Nt(r),s.name=Et(i),s.typeParameters=void 0,s.parameters=n(a),s.body=o,s}function C(e,r,i,a){var o=t(159);return o.decorators=Nt(e),o.modifiers=Nt(r),o.parameters=n(i),o.type=a,o}function E(e,r,n,i,a){var o=t(e);return o.typeParameters=Nt(r),o.parameters=Nt(n),o.type=i,o.typeArguments=Nt(a),o}function N(e,t,n,i){return e.typeParameters!==t||e.parameters!==n||e.type!==i?r(E(e.kind,t,n,i),e):e}function A(e,r){var n=t(160);return n.parameterName=Et(e),n.type=r,n}function P(r,n){var i=t(161);return i.typeName=Et(r),i.typeArguments=n&&e.parenthesizeTypeParameters(n),i}function w(e){var r=t(164);return r.exprName=e,r}function F(e){var r=t(165);return r.members=n(e),r}function O(r){var n=t(166);return n.elementType=e.parenthesizeArrayTypeMember(r),n}function I(e){var r=t(167);return r.elementTypes=n(e),r}function M(r,n){var i=t(r);return i.types=e.parenthesizeElementTypeMembers(n),i}function L(e,t){return e.types!==t?r(M(e.kind,t),e):e}function R(r,n,i,a){var o=t(170);return o.checkType=e.parenthesizeConditionalTypeMember(r),o.extendsType=e.parenthesizeConditionalTypeMember(n),o.trueType=i,o.falseType=a,o}function B(e){var r=t(171);return r.typeParameter=e,r}function K(e){var r=t(172);return r.type=e,r}function j(r,n){var i=t(174);return i.operator="number"==typeof r?r:128,i.type=e.parenthesizeElementTypeMember("number"==typeof r?n:r),i}function J(r,n){var i=t(175);return i.objectType=e.parenthesizeElementTypeMember(r),i.indexType=n,i}function z(e,r,n,i){var a=t(176);return a.readonlyToken=e,a.typeParameter=r,a.questionToken=n,a.type=i,a}function U(e){var r=t(177);return r.literal=e,r}function q(e){var r=t(178);return r.elements=n(e),r}function V(e){var r=t(179);return r.elements=n(e),r}function W(e,r,n,i){var a=t(180);return a.dotDotDotToken=e,a.propertyName=Et(r),a.name=Et(n),a.initializer=i,a}function H(r,i){var a=t(181);return a.elements=e.parenthesizeListElements(n(r)),i&&(a.multiLine=!0),a}function G(e,r){var i=t(182);return i.properties=n(e),r&&(i.multiLine=!0),i}function $(r,n){var i=t(183);return i.expression=e.parenthesizeForAccess(r),i.name=Et(n),wt(i,131072),i}function X(r,n){var i,o=t(184);return o.expression=e.parenthesizeForAccess(r),o.argumentExpression=(i=n,e.isString(i)||"number"==typeof i?a(i):i),o}function Q(r,i,a){var o=t(185);return o.expression=e.parenthesizeForAccess(r),o.typeArguments=Nt(i),o.arguments=e.parenthesizeListElements(n(a)),o}function Y(r,i,a){var o=t(186);return o.expression=e.parenthesizeForNew(r),o.typeArguments=Nt(i),o.arguments=a?e.parenthesizeListElements(n(a)):void 0,o}function Z(r,n){var i=t(187);return i.tag=e.parenthesizeForAccess(r),i.template=n,i}function ee(r,n){var i=t(188);return i.type=r,i.expression=e.parenthesizePrefixOperand(n),i}function te(e){var r=t(189);return r.expression=e,r}function re(e,r,i,a,o,s,c){var u=t(190);return u.modifiers=Nt(e),u.asteriskToken=r,u.name=Et(i),u.typeParameters=Nt(a),u.parameters=n(o),u.type=s,u.body=c,u}function ne(r,i,a,o,s,c){var u=t(191);return u.modifiers=Nt(r),u.typeParameters=Nt(i),u.parameters=n(a),u.type=o,u.equalsGreaterThanToken=s||_(36),u.body=e.parenthesizeConciseBody(c),u}function ie(r){var n=t(192);return n.expression=e.parenthesizePrefixOperand(r),n}function ae(r){var n=t(193);return n.expression=e.parenthesizePrefixOperand(r),n}function oe(r){var n=t(194);return n.expression=e.parenthesizePrefixOperand(r),n}function se(r){var n=t(195);return n.expression=e.parenthesizePrefixOperand(r),n}function ce(r,n){var i=t(196);return i.operator=r,i.operand=e.parenthesizePrefixOperand(n),i}function ue(r,n){var i=t(197);return i.operand=e.parenthesizePostfixOperand(r),i.operator=n,i}function le(r,n,i){var a,o=t(198),s="number"==typeof(a=n)?_(a):a,c=s.kind;return o.left=e.parenthesizeBinaryOperand(c,r,!0,void 0),o.operatorToken=s,o.right=e.parenthesizeBinaryOperand(c,i,!1,o.left),o}function _e(r,n,i,a,o){var s=t(199);return s.condition=e.parenthesizeForConditionalHead(r),s.questionToken=o?n:_(55),s.whenTrue=e.parenthesizeSubexpressionOfConditionalExpression(o?i:n),s.colonToken=o?a:_(56),s.whenFalse=e.parenthesizeSubexpressionOfConditionalExpression(o||i),s}function de(e,r){var i=t(200);return i.head=e,i.templateSpans=n(r),i}function pe(e,r){var n=t(201);return n.asteriskToken=e&&39===e.kind?e:void 0,n.expression=e&&39!==e.kind?e:r,n}function fe(r){var n=t(202);return n.expression=e.parenthesizeExpressionForList(r),n}function me(e,r,i,a,o){var s=t(203);return s.decorators=void 0,s.modifiers=Nt(e),s.name=Et(r),s.typeParameters=Nt(i),s.heritageClauses=Nt(a),s.members=n(o),s}function ge(r,n){var i=t(205);return i.expression=e.parenthesizeForAccess(n),i.typeArguments=Nt(r),i}function ye(e,r){var n=t(206);return n.expression=e,n.type=r,n}function he(r){var n=t(207);return n.expression=e.parenthesizeForAccess(r),n}function ve(e,r){var n=t(208);return n.keywordToken=e,n.name=r,n}function be(e,r){var n=t(209);return n.expression=e,n.literal=r,n}function xe(e,r){var i=t(211);return i.statements=n(e),r&&(i.multiLine=r),i}function Se(r,n){var i=t(212);return i.decorators=void 0,i.modifiers=Nt(r),i.declarationList=e.isArray(n)?Ke(n):n,i}function ke(r){var n=t(214);return n.expression=e.parenthesizeExpressionForExpressionStatement(r),n}function Te(e,r,n){var i=t(215);return i.expression=e,i.thenStatement=r,i.elseStatement=n,i}function De(e,r){var n=t(216);return n.statement=e,n.expression=r,n}function Ce(e,r){var n=t(217);return n.expression=e,n.statement=r,n}function Ee(e,r,n,i){var a=t(218);return a.initializer=e,a.condition=r,a.incrementor=n,a.statement=i,a}function Ne(e,r,n){var i=t(219);return i.initializer=e,i.expression=r,i.statement=n,i}function Ae(e,r,n,i){var a=t(220);return a.awaitModifier=e,a.initializer=r,a.expression=n,a.statement=i,a}function Pe(e){var r=t(221);return r.label=Et(e),r}function we(e){var r=t(222);return r.label=Et(e),r}function Fe(e){var r=t(223);return r.expression=e,r}function Oe(e,r){var n=t(224);return n.expression=e,n.statement=r,n}function Ie(r,n){var i=t(225);return i.expression=e.parenthesizeExpressionForList(r),i.caseBlock=n,i}function Me(e,r){var n=t(226);return n.label=Et(e),n.statement=r,n}function Le(e){var r=t(227);return r.expression=e,r}function Re(e,r,n){var i=t(228);return i.tryBlock=e,i.catchClause=r,i.finallyBlock=n,i}function Be(r,n,i){var a=t(230);return a.name=Et(r),a.type=n,a.initializer=void 0!==i?e.parenthesizeExpressionForList(i):void 0,a}function Ke(e,r){var i=t(231);return i.flags|=3&r,i.declarations=n(e),i}function je(e,r,i,a,o,s,c,u){var l=t(232);return l.decorators=Nt(e),l.modifiers=Nt(r),l.asteriskToken=i,l.name=Et(a),l.typeParameters=Nt(o),l.parameters=n(s),l.type=c,l.body=u,l}function Je(e,r,i,a,o,s){var c=t(233);return c.decorators=Nt(e),c.modifiers=Nt(r),c.name=Et(i),c.typeParameters=Nt(a),c.heritageClauses=Nt(o),c.members=n(s),c}function ze(e,r,i,a,o,s){var c=t(234);return c.decorators=Nt(e),c.modifiers=Nt(r),c.name=Et(i),c.typeParameters=Nt(a),c.heritageClauses=Nt(o),c.members=n(s),c}function Ue(e,r,n,i,a){var o=t(235);return o.decorators=Nt(e),o.modifiers=Nt(r),o.name=Et(n),o.typeParameters=Nt(i),o.type=a,o}function qe(e,r,i,a){var o=t(236);return o.decorators=Nt(e),o.modifiers=Nt(r),o.name=Et(i),o.members=n(a),o}function Ve(e,r,n,i,a){var o=t(237);return o.flags|=532&a,o.decorator