window.addEventListener('load', function () {
	const canvas = document.querySelector('#draw');
	const ctx = canvas.getContext('2d');

	canvas.width = window.innerWidth;
	canvas.height = window.innerHeight;

	ctx.strokeStyle = '#BADA55';
	ctx.lineJoin = 'round';
	ctx.lineCap = 'round';
	ctx.lineWidth = 0;
	//ctx.globalCompositeOperation = 'multiply';

	let isDrawing = false;
	let lastX = 0;
	let lastY = 0;
	let hue = 0;
	let direction = true;

	function draw (e) {
		if(!isDrawing) return; // stop the function from running when mouse is not kept clicked
		//console.log(e);
		ctx.strokeStyle = `hsl(${hue}, 100%, 50%)`;		// :O
		//ctx.lineWidth = hue;

		ctx.beginPath();
		//start from
		ctx.moveTo(lastX, lastY);
		//go to
		ctx.lineTo(e.offsetX, e.offsetY);
		ctx.stroke();

		[lastX, lastY] = [e.offsetX, e.offsetY]; // destructuring array
		hue++;
		if(hue>=360) hue = 0;

		if(ctx.lineWidth>=100 || ctx.lineWidth<=1){
			direction = !direction;
		}
		if(direction) ctx.lineWidth++;
		else ctx.lineWidth--;
	}

	canvas.addEventListener('mousemove',draw);
	canvas.addEventListener('mousedown',(e) => {
		isDrawing = true;
		[lastX, lastY] = [e.offsetX, e.offsetY];
	});

	canvas.addEventListener('mouseup',() => isDrawing = false);
	canvas.addEventListener('mouseout', () => isDrawing = false);

	const btnClear = document.querySelector("#clear");
	btnClear.addEventListener("click", () => {
		ctx.clearRect(0, 0, canvas.width, canvas.height);
	})
});
