(function() {
  /**
   * This 'svg-assets-cache.js' file should be loaded to a CDN or edge-server (currently S3).
   * The CDN url (for this file) is then used in `doc/app/js/codepen.js#L59` to identify an
   * external JS file that CodePen should load for 'launched' demos.
   */
  var assetMap = {
    'img/icons/ic_card_giftcard_24px.svg' : '<svg fill="#000000" height="24" viewBox="0 0 24 24" width="24" xmlns="http://www.w3.org/2000/svg"> <path d="M20 6h-2.18c.11-.31.18-.65.18-1 0-1.66-1.34-3-3-3-1.05 0-1.96.54-2.5 1.35l-.5.67-.5-.68C10.96 2.54 10.05 2 9 2 7.34 2 6 3.34 6 5c0 .35.07.69.18 1H4c-1.11 0-1.99.89-1.99 2L2 19c0 1.11.89 2 2 2h16c1.11 0 2-.89 2-2V8c0-1.11-.89-2-2-2zm-5-2c.55 0 1 .45 1 1s-.45 1-1 1-1-.45-1-1 .45-1 1-1zM9 4c.55 0 1 .45 1 1s-.45 1-1 1-1-.45-1-1 .45-1 1-1zm11 15H4v-2h16v2zm0-5H4V8h5.08L7 10.83 8.62 12 11 8.76l1-1.36 1 1.36L15.38 12 17 10.83 14.92 8H20v6z"/> <path d="M0 0h24v24H0z" fill="none"/></svg>',
    'img/icons/github-icon.svg' : '<svg height="1024" width="1024" xmlns="http://www.w3.org/2000/svg" viewBox="0 0 1024 1024"> <path d="M512 0C229.252 0 0 229.25199999999995 0 512c0 226.251 146.688 418.126 350.155 485.813 25.593 4.686 34.937-11.125 34.937-24.626 0-12.188-0.469-52.562-0.718-95.314-128.708 23.46-161.707-31.541-172.469-60.373-5.525-14.809-30.407-60.249-52.398-72.263-17.988-9.828-43.26-33.237-0.917-33.735 40.434-0.476 69.348 37.308 78.471 52.75 45.938 77.749 119.876 55.627 148.999 42.5 4.654-32.999 17.902-55.627 32.501-68.373-113.657-12.939-233.22-56.875-233.22-253.063 0-55.94 19.968-101.561 52.658-137.404-5.22-12.999-22.844-65.095 5.063-135.563 0 0 42.937-13.749 140.811 52.501 40.811-11.406 84.594-17.031 128.124-17.22 43.499 0.188 87.314 5.874 128.188 17.28 97.689-66.311 140.686-52.501 140.686-52.501 28 70.532 10.375 122.564 5.124 135.499 32.811 35.844 52.626 81.468 52.626 137.404 0 196.686-119.751 240-233.813 252.686 18.439 15.876 34.748 47.001 34.748 94.748 0 68.437-0.686 123.627-0.686 140.501 0 13.625 9.312 29.561 35.25 24.562C877.436 929.998 1024 738.126 1024 512 1024 229.25199999999995 794.748 0 512 0z" /></svg>',
    'img/icons/tabs-arrow.svg' : '<?xml version="1.0" encoding="utf-8"?><!-- Generator: Adobe Illustrator 17.1.0, SVG Export Plug-In . SVG Version: 6.00 Build 0) --><!DOCTYPE svg PUBLIC "-//W3C//DTD SVG 1.1//EN" "http://www.w3.org/Graphics/SVG/1.1/DTD/svg11.dtd"><svg version="1.1" id="Layer_1" xmlns="http://www.w3.org/2000/svg" xmlns:xlink="http://www.w3.org/1999/xlink" x="0px" y="0px" viewBox="0 0 24 24" enable-background="new 0 0 24 24" xml:space="preserve"><g id="Header"> <g> <rect x="-618" y="-1208" fill="none" width="1400" height="3600"/> </g></g><g id="Label"></g><polygon points="15.4,7.4 14,6 8,12 14,18 15.4,16.6 10.8,12 "/><g id="Grid" display="none"></g></svg>',
    'img/icons/ic_arrow_up_24px.svg' : '<svg height="24" viewBox="0 0 24 24" width="24" xmlns="http://www.w3.org/2000/svg"> <path d="M7.41 15.41L12 10.83l4.59 4.58L18 14l-6-6-6 6z"/> <path d="M0 0h24v24H0z" fill="none"/></svg>',
    'img/icons/ic_build_24px.svg' : '<svg xmlns="http://www.w3.org/2000/svg" width="24" height="24" viewBox="0 0 24 24"> <path fill-rule="evenodd" clip-rule="evenodd" fill="none" d="M0 0h24v24H0z"/> <path d="M22.7 19l-9.1-9.1c.9-2.3.4-5-1.5-6.9-2-2-5-2.4-7.4-1.3L9 6 6 9 1.6 4.7C.4 7.1.9 10.1 2.9 12.1c1.9 1.9 4.6 2.4 6.9 1.5l9.1 9.1c.4.4 1 .4 1.4 0l2.3-2.3c.5-.4.5-1.1.1-1.4z"/></svg>',
    'img/icons/android.svg' : '<svg xmlns="http://www.w3.org/2000/svg" viewBox="0 0 24 24"><g id="android"><path d="M6 18c0 .55.45 1 1 1h1v3.5c0 .83.67 1.5 1.5 1.5s1.5-.67 1.5-1.5V19h2v3.5c0 .83.67 1.5 1.5 1.5s1.5-.67 1.5-1.5V19h1c.55 0 1-.45 1-1V8H6v10zM3.5 8C2.67 8 2 8.67 2 9.5v7c0 .83.67 1.5 1.5 1.5S5 17.33 5 16.5v-7C5 8.67 4.33 8 3.5 8zm17 0c-.83 0-1.5.67-1.5 1.5v7c0 .83.67 1.5 1.5 1.5s1.5-.67 1.5-1.5v-7c0-.83-.67-1.5-1.5-1.5zm-4.97-5.84l1.3-1.3c.2-.2.2-.51 0-.71-.2-.2-.51-.2-.71 0l-1.48 1.48C13.85 1.23 12.95 1 12 1c-.96 0-1.86.23-2.66.63L7.85.15c-.2-.2-.51-.2-.71 0-.2.2-.2.51 0 .71l1.31 1.31C6.97 3.26 6 5.01 6 7h12c0-1.99-.97-3.75-2.47-4.84zM10 5H9V4h1v1zm5 0h-1V4h1v1z"/></g></svg>',
    'img/icons/ic_people_24px.svg' : '<?xml version="1.0" encoding="utf-8"?><!-- Generator: Adobe Illustrator 17.1.0, SVG Export Plug-In . SVG Version: 6.00 Build 0) --><!DOCTYPE svg PUBLIC "-//W3C//DTD SVG 1.1//EN" "http://www.w3.org/Graphics/SVG/1.1/DTD/svg11.dtd"><svg version="1.1" xmlns="http://www.w3.org/2000/svg" xmlns:xlink="http://www.w3.org/1999/xlink" x="0px" y="0px" width="24px" height="24px" viewBox="0 0 24 24" enable-background="new 0 0 24 24" xml:space="preserve"><g id="Header"> <g> <rect x="-618" y="-2616" fill="none" width="1400" height="3600"/> </g></g><g id="Label"></g><g id="Icon"> <g> <g> <rect fill="none" width="24" height="24"/> </g> <path d="M16,11c1.7,0,3-1.3,3-3c0-1.7-1.3-3-3-3c-1.7,0-3,1.3-3,3C13,9.7,14.3,11,16,11z M8,11c1.7,0,3-1.3,3-3c0-1.7-1.3-3-3-3 C6.3,5,5,6.3,5,8C5,9.7,6.3,11,8,11z M8,13c-2.3,0-7,1.2-7,3.5V19h14v-2.5C15,14.2,10.3,13,8,13z M16,13c-0.3,0-0.6,0-1,0.1 c1.2,0.8,2,2,2,3.4V19h6v-2.5C23,14.2,18.3,13,16,13z"/> </g></g><g id="Grid" display="none"> <g display="inline"> </g></g></svg>',
    'img/icons/hangout.svg' : '<svg version="1.1" x="0px" y="0px" width="48px" height="48px" viewBox="0 0 48 48" enable-background="new 0 0 48 48" xml:space="preserve"><g><g><path fill="#159F5C" d="M23,4C13.6,4,6,11.6,6,21s7.6,17,17,17h1v7c9.7-4.7,16-15,16-24C40,11.6,32.4,4,23,4z M22,22l-2,4h-3l2-4h-3v-6h6V22zM30,22l-2,4h-3l2-4h-3v-6h6V22z"/><rect x="0" fill="none" width="48" height="48"/></g></g></svg>',
    'img/icons/ic_insert_drive_file_24px.svg' : '<svg version="1.1" xmlns="http://www.w3.org/2000/svg" x="0px" y="0px" width="24px" height="24px" viewBox="0 0 24 24"><g> <path d="M6,2C4.9,2,4,2.9,4,4l0,16c0,1.1,0.9,2,2,2h12c1.1,0,2-0.9,2-2V8l-6-6H6z M13,9V3.5L18.5,9H13z"/></g></svg>',
    'img/icons/ic_school_24px.svg' : '<svg xmlns="http://www.w3.org/2000/svg" width="24" height="24" viewBox="0 0 24 24"> <path d="M0 0h24v24H0z" fill="none"/> <path d="M5 13.18v4L12 21l7-3.82v-4L12 17l-7-3.82zM12 3L1 9l11 6 9-4.91V17h2V9L12 3z"/></svg>',
    'img/icons/ic_play_arrow_24px.svg' : '<?xml version="1.0" encoding="utf-8"?><!-- Generator: Adobe Illustrator 17.1.0, SVG Export Plug-In . SVG Version: 6.00 Build 0) --><!DOCTYPE svg PUBLIC "-//W3C//DTD SVG 1.1//EN" "http://www.w3.org/Graphics/SVG/1.1/DTD/svg11.dtd"><svg version="1.1" xmlns="http://www.w3.org/2000/svg" xmlns:xlink="http://www.w3.org/1999/xlink" x="0px" y="0px" width="24px" height="24px" viewBox="0 0 24 24" enable-background="new 0 0 24 24" xml:space="preserve"><g id="Header"> <g> <rect x="-618" y="-2232" fill="none" width="1400" height="3600"/> </g></g><g id="Label"></g><g id="Icon"> <g> <polygon points="8,5 8,19 19,12 " style="fill:#f3f3f3;" /> <rect fill="none" width="24" height="24"/> </g></g><g id="Grid" display="none"> <g display="inline"> </g></g></svg>',
    'img/icons/ic_chevron_right_24px.svg' : '<?xml version="1.0" encoding="utf-8"?><!-- Generator: Adobe Illustrator 17.1.0, SVG Export Plug-In . SVG Version: 6.00 Build 0) --><!DOCTYPE svg PUBLIC "-//W3C//DTD SVG 1.1//EN" "http://www.w3.org/Graphics/SVG/1.1/DTD/svg11.dtd"><svg version="1.1" xmlns="http://www.w3.org/2000/svg" xmlns:xlink="http://www.w3.org/1999/xlink" x="0px" y="0px" width="24px" height="24px" viewBox="0 0 24 24" enable-background="new 0 0 24 24" xml:space="preserve"><g id="Header"> <g> <rect x="-618" y="-1336" fill="none" width="1400" height="3600"/> </g></g><g id="Label"></g><g id="Icon"> <g> <polygon points="10,6 8.6,7.4 13.2,12 8.6,16.6 10,18 16,12 "/> <rect fill="none" width="24" height="24"/> </g></g><g id="Grid" display="none"> <g display="inline"> </g></g></svg>',
    'img/icons/bower-logo.svg' : '<?xml version="1.0" encoding="utf-8"?><!-- Generator: Adobe Illustrator 16.0.0, SVG Export Plug-In . SVG Version: 6.00 Build 0) --><!DOCTYPE svg PUBLIC "-//W3C//DTD SVG 1.1//EN" "http://www.w3.org/Graphics/SVG/1.1/DTD/svg11.dtd"><svg version="1.1" id="Layer_1" xmlns="http://www.w3.org/2000/svg" xmlns:xlink="http://www.w3.org/1999/xlink" x="0px" y="0px" width="512px" height="512px" viewBox="0 0 512 512" enable-background="new 0 0 512 512" xml:space="preserve"><g> <g id="leaf"> <path fill="#00ACEE" d="M434.625,63.496c-67.822,0-118.399,71.68-95.018,123.167C435.596,186.664,396.518,98.058,434.625,63.496z" /> </g> <path id="body" fill="#FFCC2F" d="M456.534,256.992c0-22.79-108.627-34.129-169.139-37.663 c-60.511-3.533-281.592,38.389-255.42,93.813c26.173,55.426,92.581,114.358,167.313,114.358c38.716,0,83.584-27.284,86.053-77.38 C330.121,335.163,456.534,334.371,456.534,256.992z"/> <path id="wing_tip" fill="#2BAF2B" d="M400.981,272.143c7.02,7.104-15.222,26.295-34.606,17.262 c8.731,19.688-29.676,36.064-48.336,22.026c1.998,15.865-36.122,24.996-48.285,7.292c3.136,8.441,5.757,14.898,8.229,20.209 c-0.029-0.09-0.046-0.149-0.046-0.149c6.324,8.279,14.929,14.939,52.394,14.939c57.727,0,150.97-43.849,150.97-76.039 c0-26.643-9.992-29.14-27.196-27.198c-17.208,1.942-107.17,11.291-126.306,7.534C338.182,260.229,390.54,270.259,400.981,272.143z" /> <path id="head" fill="#EF5734" d="M198.51,48.82c-110.382,0-221.179,109.721-168.451,261.056 c35.817,21.53,83.576,12.995,94.278,1.532c16.178,5.171,30.612,7.347,43.513,7.347c67.047,0,124.34-71.235,124.34-160.257 C292.189,67.196,231.93,48.82,198.51,48.82z"/> <path id="eye_rim" fill="#FFCC2F" d="M153.308,146.522c0,24.632,19.969,44.603,44.603,44.603c24.633,0,44.603-19.971,44.603-44.603 c0-24.633-19.97-44.603-44.603-44.603C173.277,101.92,153.308,121.89,153.308,146.522z"/> <path id="eye" fill="#543729" d="M171.207,146.522c0,14.747,11.956,26.704,26.704,26.704c14.748,0,26.703-11.957,26.703-26.704 c0-14.748-11.955-26.704-26.703-26.704C183.163,119.819,171.207,131.774,171.207,146.522z"/> <ellipse id="pupil_highlight" fill="#FFFFFF" cx="197.91" cy="134.674" rx="15.56" ry="9.675"/> <path id="beak" fill="#CECECE" d="M289.401,123.675c-20.275,11.807-19.604,50.03-10.595,68.681 c17.445-6.466,41.752-19.291,45.527-21.585c3.773-2.293-2.088-10.989,12.559-10.989c20.315,0,38.684,6.348,43.956,8.634 C377.511,161.547,335.758,123.675,289.401,123.675z"/> <path id="outline" fill="#543729" d="M502.214,250.797c-26.335-25.305-158.017-41.1-199.568-45.698 c2.014-4.754,3.726-9.669,5.142-14.731c5.665-2.481,11.776-4.789,18.101-6.716c0.77,2.272,4.397,10.98,6.465,15.112 c83.553,2.305,87.844-62.09,91.24-79.732c3.323-17.25,3.154-33.917,31.812-64.388C412.709,42.201,351.31,73.928,330.742,121.15 c-7.728-2.896-15.474-5.035-23.136-6.357c-5.488-22.146-34.077-83.845-109.097-83.845c-48.585,0-97.581,20.063-134.421,55.045 c-19.852,18.85-35.445,41.234-46.344,66.53C5.97,179.851,0,209.94,0,241.957C0,353.462,76.126,451.18,119.139,451.18 c18.784,0,34.943-14.067,38.736-26.675c3.181,8.645,12.938,35.522,16.142,42.364c4.737,10.117,26.642,18.872,36.229,8.373 c12.326,6.849,34.943,10.973,47.27-7.289c23.739,5.022,44.728-9.135,45.184-26.026c11.649-0.622,17.363-16.978,14.819-30.001 c-1.875-9.591-21.904-44-29.719-55.877c15.468,12.58,54.644,16.142,59.401,0.008c24.936,19.571,63.797,9.301,66.879-6.619 c30.301,7.874,65.054-9.417,59.348-30.359C522.102,315.711,515.872,263.921,502.214,250.797z M375.456,164.958 c-12.821-5.033-29.084-8.217-40.482-8.217c-16.164,0-26.009,9.16-41.218,9.16c-3.193,0-10.812,0.016-16.926-2.162 c4.021,4.217,9.025,6.505,18.725,6.505c5.793,0,17.263-2.958,26.553-5.752c0.129,1.956,0.334,3.898,0.61,5.826 c-17.402,4.161-35.664,15.231-40.949,18.105c-11.755-25.958-1.65-50.505,7.697-61.837 C331.331,126.686,365.144,155.433,375.456,164.958z M393.557,163.001l-6.406-5.979c-6.575-6.159-13.43-11.731-20.469-16.678 c10.483-20.801,23.658-43.514,40.298-57.565c-18.314,7.381-36.397,29.445-47.089,53.03c-5.448-3.464-10.98-6.554-16.561-9.255 c14.913-31.834,49.568-58.42,87.762-60.497C405.509,89.257,415.114,135.563,393.557,163.001z M341.006,184.7 c-2.821-6.114-5.677-16.27-5.328-22.239c4.753-0.112,13.868,1.67,15.335,2.016c-0.557,2.803-0.855,8.944-0.866,9.739 c0.903-1.556,3.41-6.922,4.43-9.029c9.127,1.744,21.126,4.659,28.161,7.938C374.478,178.473,360.439,184.293,341.006,184.7z M283.971,112.911c-33.381,33.832-20.199,76.63-8.046,95.976c-17.29,28.761-51.28,48.437-90.765,57.389 c44.328,0,70.397-11.409,85.563-22.586c9.677-7.131,14.928-14.17,17.608-18.088c65.72,4.251,169.783,25.423,179.935,32.281 c4.074,2.753,8.278,8.842,8.895,14.668c-49.387-6.914-138.407-14.188-161.719-15.424c16.549,2.347,137.241,25.202,158.163,30.552 c-6.368,10.384-20.872,17.715-42.733,12.621c11.812,16.093-11.125,35.399-43.071,24.766c7.032,15.799-21.413,30.021-53.741,13.555 c0.411,15.805-40.105,17.626-56.123,0.162c0.306,2.082,2.207,6.066,3.028,7.809c-5.162,46.15-42.961,74.783-81.677,74.783 c-94.794,0-177.375-76.989-177.375-179.417c0-108.292,80.03-189.096,176.597-189.096 C253.842,52.861,278.836,96.412,283.971,112.911z"/></g></svg>',
    'img/icons/mail.svg' : '<svg version="1.1" x="0px" y="0px" width="48px" height="48px" viewBox="0 0 48 48" enable-background="new 0 0 48 48" xml:space="preserve"><g><g><path fill="#7d7d7d" d="M40,8H8c-2.2,0-4,1.8-4,4l0,24c0,2.2,1.8,4,4,4h32c2.2,0,4-1.8,4-4V12C44,9.8,42.2,8,40,8z M40,16L24,26L8,16v-4l16,10l16-10V16z"/><rect fill="none" width="48" height="48"/></g></g></svg>',
    'img/icons/ic_play_circle_fill_24px.svg' : '<svg xmlns="http://www.w3.org/2000/svg" width="24" height="24" viewBox="0 0 24 24"> <path d="M0 0h24v24H0z" fill="none"/> <path d="M12 2C6.48 2 2 6.48 2 12s4.48 10 10 10 10-4.48 10-10S17.52 2 12 2zm-2 14.5v-9l6 4.5-6 4.5z"/></svg>',
    'img/icons/ic_comment_24px.svg' : '<?xml version="1.0" encoding="utf-8"?><!-- Generator: Adobe Illustrator 17.1.0, SVG Export Plug-In . SVG Version: 6.00 Build 0) --><!DOCTYPE svg PUBLIC "-//W3C//DTD SVG 1.1//EN" "http://www.w3.org/Graphics/SVG/1.1/DTD/svg11.dtd"><svg version="1.1" xmlns="http://www.w3.org/2000/svg" xmlns:xlink="http://www.w3.org/1999/xlink" x="0px" y="0px" width="24px" height="24px" viewBox="0 0 24 24" enable-background="new 0 0 24 24" xml:space="preserve"><g id="Header"> <g> <rect x="-618" y="-1464" fill="none" width="1400" height="3600"/> </g></g><g id="Labels"></g><g id="Icon"> <g> <path d="M22,4c0-1.1-0.9-2-2-2H4C2.9,2,2,2.9,2,4v12c0,1.1,0.9,2,2,2h14l4,4L22,4z M18,14H6v-2h12V14z M18,11H6V9h12V11z M18,8H6 V6h12V8z"/> <rect x="0" fill="none" width="24" height="24"/> </g></g><g id="Grid" display="none"> <g display="inline"> </g></g></svg>',
    'img/icons/copy2.svg' : '<svg version="1.1" x="0px" y="0px" width="48px" height="48px" viewBox="0 0 48 48" enable-background="new 0 0 48 48" xml:space="preserve"><g><g><rect fill="none" width="48" height="48"/><path fill="#7d7d7d" d="M32,2H8C5.8,2,4,3.8,4,6v28h4V6h24V2z M38,10H16c-2.2,0-4,1.8-4,4v28c0,2.2,1.8,4,4,4h22c2.2,0,4-1.8,4-4V14C42,11.8,40.2,10,38,10z M38,42H16V14h22V42z"/></g></g></svg>',
    'img/icons/baseline-share-24px.svg' : '<svg xmlns="http://www.w3.org/2000/svg" width="24" height="24" viewBox="0 0 24 24"> <path d="M0 0h24v24H0z" fill="none"/> <path d="M18 16.08c-.76 0-1.44.3-1.96.77L8.91 12.7c.05-.23.09-.46.09-.7s-.04-.47-.09-.7l7.05-4.11c.54.5 1.25.81 2.04.81 1.66 0 3-1.34 3-3s-1.34-3-3-3-3 1.34-3 3c0 .24.04.47.09.7L8.04 9.81C7.5 9.31 6.79 9 6 9c-1.66 0-3 1.34-3 3s1.34 3 3 3c.79 0 1.5-.31 2.04-.81l7.12 4.16c-.05.21-.08.43-.08.65 0 1.61 1.31 2.92 2.92 2.92 1.61 0 2.92-1.31 2.92-2.92s-1.31-2.92-2.92-2.92z"/></svg>',
    'img/icons/ic_launch_24px.svg' : '<?xml version="1.0" encoding="utf-8"?><!-- Generator: Adobe Illustrator 17.1.0, SVG Export Plug-In . SVG Version: 6.00 Build 0) --><!DOCTYPE svg PUBLIC "-//W3C//DTD SVG 1.1//EN" "http://www.w3.org/Graphics/SVG/1.1/DTD/svg11.dtd"><svg version="1.1" xmlns="http://www.w3.org/2000/svg" xmlns:xlink="http://www.w3.org/1999/xlink" x="0px" y="0px" width="24px" height="24px" viewBox="0 0 24 24" enable-background="new 0 0 24 24" xml:space="preserve"><g id="Header"> <g> <rect x="-618" y="-824" fill="none" width="1400" height="3600"/> </g></g><g id="Label"></g><g id="Icon"> <g> <rect fill="none" width="24" height="24"/> <path d="M19,19H5V5h7V3H5C3.9,3,3,3.9,3,5v14c0,1.1,0.9,2,2,2h14c1.1,0,2-0.9,2-2v-7h-2V19z M14,3v2h3.6l-9.8,9.8l1.4,1.4L19,6.4 V10h2V3H14z" /> </g></g><g id="Grid" display="none"> <g display="inline"> </g></g></svg>',
    'img/icons/cake.svg' : '<svg xmlns="http://www.w3.org/2000/svg" viewBox="0 0 24 24"><g id="cake"><path d="M12 6c1.11 0 2-.9 2-2 0-.38-.1-.73-.29-1.03L12 0l-1.71 2.97c-.19.3-.29.65-.29 1.03 0 1.1.9 2 2 2zm4.6 9.99l-1.07-1.07-1.08 1.07c-1.3 1.3-3.58 1.31-4.89 0l-1.07-1.07-1.09 1.07C6.75 16.64 5.88 17 4.96 17c-.73 0-1.4-.23-1.96-.61V21c0 .55.45 1 1 1h16c.55 0 1-.45 1-1v-4.61c-.56.38-1.23.61-1.96.61-.92 0-1.79-.36-2.44-1.01zM18 9h-5V7h-2v2H6c-1.66 0-3 1.34-3 3v1.54c0 1.08.88 1.96 1.96 1.96.52 0 1.02-.2 1.38-.57l2.14-2.13 2.13 2.13c.74.74 2.03.74 2.77 0l2.14-2.13 2.13 2.13c.37.37.86.57 1.38.57 1.08 0 1.96-.88 1.96-1.96V12C21 10.34 19.66 9 18 9z"/></g></svg>',
    'img/icons/ic_arrow_back_24px.svg' : '<?xml version="1.0" encoding="utf-8"?><!-- Generator: Adobe Illustrator 17.1.0, SVG Export Plug-In . SVG Version: 6.00 Build 0) --><!DOCTYPE svg PUBLIC "-//W3C//DTD SVG 1.1//EN" "http://www.w3.org/Graphics/SVG/1.1/DTD/svg11.dtd"><svg version="1.1" xmlns="http://www.w3.org/2000/svg" xmlns:xlink="http://www.w3.org/1999/xlink" x="0px" y="0px" width="24px" height="24px" viewBox="0 0 24 24" enable-background="new 0 0 24 24" xml:space="preserve"><g id="Header"> <g> <rect x="-618" y="-568" fill="none" width="1400" height="3600"/> </g></g><g id="Label"></g><g id="Icon"> <g> <rect fill="none" width="24" height="24"/> <path d="M20,11H7.8l5.6-5.6L12,4l-8,8l8,8l1.4-1.4L7.8,13H20V11z"/> </g></g><g id="Grid" display="none"> <g display="inline"> </g></g></svg>',
    'img/icons/ic_access_time_24px.svg' : '<?xml version="1.0" encoding="utf-8"?><!-- Generator: Adobe Illustrator 17.1.0, SVG Export Plug-In . SVG Version: 6.00 Build 0) --><!DOCTYPE svg PUBLIC "-//W3C//DTD SVG 1.1//EN" "http://www.w3.org/Graphics/SVG/1.1/DTD/svg11.dtd"><svg version="1.1" xmlns="http://www.w3.org/2000/svg" xmlns:xlink="http://www.w3.org/1999/xlink" x="0px" y="0px" width="24px" height="24px" viewBox="0 0 24 24" enable-background="new 0 0 24 24" xml:space="preserve"><g id="Header"> <g> <rect x="-618" y="-440" fill="none" width="1400" height="3600"/> </g></g><g id="Labels"></g><g id="Icon"> <g> <g> <path fill-opacity="0.9" d="M12,2C6.5,2,2,6.5,2,12s4.5,10,10,10c5.5,0,10-4.5,10-10S17.5,2,12,2z M12,20c-4.4,0-8-3.6-8-8 s3.6-8,8-8c4.4,0,8,3.6,8,8S16.4,20,12,20z"/> </g> <rect fill="none" width="24" height="24"/> <polygon fill-opacity="0.9" points="12.5,7 11,7 11,13 16.2,16.2 17,14.9 12.5,12.2 "/> </g></g><g id="Grid" display="none"> <g display="inline"> </g></g></svg>',
    'img/icons/ic_photo_24px.svg' : '<?xml version="1.0" encoding="utf-8"?><!-- Generator: Adobe Illustrator 17.1.0, SVG Export Plug-In . SVG Version: 6.00 Build 0) --><!DOCTYPE svg PUBLIC "-//W3C//DTD SVG 1.1//EN" "http://www.w3.org/Graphics/SVG/1.1/DTD/svg11.dtd"><svg version="1.1" xmlns="http://www.w3.org/2000/svg" xmlns:xlink="http://www.w3.org/1999/xlink" x="0px" y="0px" width="24px" height="24px" viewBox="0 0 24 24" enable-background="new 0 0 24 24" xml:space="preserve"><g id="Header"> <g> <rect x="-618" y="-2616" fill="none" width="1400" height="3600"/> </g></g><g id="Label"></g><g id="Icon"> <g> <rect x="0" fill="none" width="24" height="24"/> <path d="M21,19V5c0-1.1-0.9-2-2-2H5C3.9,3,3,3.9,3,5v14c0,1.1,0.9,2,2,2h14C20.1,21,21,20.1,21,19z M8.5,13.5l2.5,3l3.5-4.5l4.5,6 H5L8.5,13.5z"/> </g></g><g id="Grid" display="none"> <g display="inline"> </g></g></svg>',
    'img/icons/ic_menu_24px.svg' : '<?xml version="1.0" encoding="utf-8"?><!-- Generator: Adobe Illustrator 17.1.0, SVG Export Plug-In . SVG Version: 6.00 Build 0) --><!DOCTYPE svg PUBLIC "-//W3C//DTD SVG 1.1//EN" "http://www.w3.org/Graphics/SVG/1.1/DTD/svg11.dtd"><svg version="1.1" xmlns="http://www.w3.org/2000/svg" xmlns:xlink="http://www.w3.org/1999/xlink" x="0px" y="0px" width="24px" height="24px" viewBox="0 0 24 24" enable-background="new 0 0 24 24" xml:space="preserve"><g id="Header"> <g> <rect x="-618" y="-2232" fill="none" width="1400" height="3600"/> </g></g><g id="Label"></g><g id="Icon"> <g> <rect fill="none" width="24" height="24"/> <path d="M3,18h18v-2H3V18z M3,13h18v-2H3V13z M3,6v2h18V6H3z"/> </g></g><g id="Grid" display="none"> <g display="inline"> </g></g></svg>',
    'img/icons/ic_email_24px.svg' : '<svg xmlns="http://www.w3.org/2000/svg" width="24" height="24" viewBox="0 0 24 24"> <path d="M20 4h-16c-1.1 0-1.99.9-1.99 2l-.01 12c0 1.1.9 2 2 2h16c1.1 0 2-.9 2-2v-12c0-1.1-.9-2-2-2zm0 4l-8 5-8-5v-2l8 5 8-5v2z"/> <path d="M0 0h24v24h-24z" fill="none"/></svg>',
    'img/icons/toggle-arrow.svg' : '<svg version="1.1" x="0px" y="0px" viewBox="0 0 48 48"> <path d="M24 16l-12 12 2.83 2.83 9.17-9.17 9.17 9.17 2.83-2.83z"/> <path d="M0 0h48v48h-48z" fill="none"/></svg>',
    'img/icons/copy.svg' : '<svg version="1.1" x="0px" y="0px" width="24px" height="24px" viewBox="0 0 24 24" enable-background="new 0 0 24 24" xml:space="preserve"><g><g><rect fill="none" width="24" height="24"/><path fill="#7d7d7d" d="M16,1H4C2.9,1,2,1.9,2,3v14h2V3h12V1z M19,5H8C6.9,5,6,5.9,6,7v14c0,1.1,0.9,2,2,2h11c1.1,0,2-0.9,2-2V7C21,5.9,20.1,5,19,5z M19,21H8V7h11V21z"/></g></g></svg>',
    'img/icons/npm-logo.svg' : '<svg height="28" width="28" xmlns="http://www.w3.org/2000/svg" viewBox="0 0 27.23 27.23"> <rect fill="#333333" width="27.23" height="27.23" rx="2"></rect> <polygon fill="#fff" points="5.8 21.75 13.66 21.75 13.67 9.98 17.59 9.98 17.58 21.76 21.51 21.76 21.52 6.06 5.82 6.04 5.8 21.75"> </polygon></svg>',
    'img/icons/launch.svg' : '<svg xmlns="http://www.w3.org/2000/svg" width="24" height="24" viewBox="0 0 24 24"> <path d="M0 0h24v24h-24z" fill="none"/> <path d="M19 19h-14v-14h7v-2h-7c-1.11 0-2 .9-2 2v14c0 1.1.89 2 2 2h14c1.1 0 2-.9 2-2v-7h-2v7zm-5-16v2h3.59l-9.83 9.83 1.41 1.41 9.83-9.83v3.59h2v-7h-7z"/></svg>',
    'img/icons/ic_code_24px.svg' : '<svg xmlns="http://www.w3.org/2000/svg" width="24" height="24" viewBox="0 0 24 24"> <path fill="none" d="M0 0h24v24H0V0z"/> <path d="M9.4 16.6L4.8 12l4.6-4.6L8 6l-6 6 6 6 1.4-1.4zm5.2 0l4.6-4.6-4.6-4.6L16 6l6 6-6 6-1.4-1.4z"/></svg>',
    'img/icons/favorite.svg' : '<svg xmlns="http://www.w3.org/2000/svg" width="24" height="24" viewBox="0 0 24 24"> <path d="M0 0h24v24h-24z" fill="none"/> <path d="M12 21.35l-1.45-1.32c-5.15-4.67-8.55-7.75-8.55-11.53 0-3.08 2.42-5.5 5.5-5.5 1.74 0 3.41.81 4.5 2.09 1.09-1.28 2.76-2.09 4.5-2.09 3.08 0 5.5 2.42 5.5 5.5 0 3.78-3.4 6.86-8.55 11.54l-1.45 1.31z"/></svg>',
    'img/icons/ic_place_24px.svg' : '<svg xmlns="http://www.w3.org/2000/svg" width="24" height="24" viewBox="0 0 24 24"> <path d="M12 2c-3.87 0-7 3.13-7 7 0 5.25 7 13 7 13s7-7.75 7-13c0-3.87-3.13-7-7-7zm0 9.5c-1.38 0-2.5-1.12-2.5-2.5s1.12-2.5 2.5-2.5 2.5 1.12 2.5 2.5-1.12 2.5-2.5 2.5z"/> <path d="M0 0h24v24h-24z" fill="none"/></svg>',
    'img/icons/ic_euro_24px.svg' : '<?xml version="1.0" encoding="UTF-8" standalone="no"?><svg width="24px" height="24px" viewBox="0 0 24 24" version="1.1" xmlns="http://www.w3.org/2000/svg" xmlns:xlink="http://www.w3.org/1999/xlink" xmlns:sketch="http://www.bohemiancoding.com/sketch/ns"> <g id="Page-1" stroke="none" stroke-width="1" fill="none" fill-rule="evenodd" sketch:type="MSPage"> <g id="Desktop-HD" sketch:type="MSArtboardGroup" fill="#000000"> <g id="euro" sketch:type="MSLayerGroup" transform="translate(4.928571, 3.000000)"> <path d="M13.3295171,13.848956 C12.7717614,14.1408877 11.5268981,14.5372503 10.3117026,14.5372503 C8.98732947,14.5372503 7.74127945,14.1408877 6.89515215,13.1855827 C6.49641614,12.7381914 6.20567113,12.1258468 6.0205437,11.3319349 L12.6685173,11.3319349 L12.6685173,9.45217947 L5.65147555,9.45217947 L5.65147555,9.02852246 C5.65147555,8.73659074 5.65147555,8.47432688 5.67639655,8.20731616 L12.669704,8.20731616 L12.669704,6.32756069 L6.07513256,6.32756069 C6.26263342,5.63926639 6.52371057,5.03048195 6.92363329,4.60682495 C7.74246616,3.62541221 8.91019304,3.17564749 10.1550564,3.17564749 C11.3168497,3.17564749 12.4311744,3.52098135 13.1194687,3.81172636 L13.8587917,0.793911872 C12.9046734,0.371441579 11.4770561,0 9.88685892,0 C7.3722113,0 5.25273954,1.00514702 3.77172009,2.7282562 C2.92559278,3.68118779 2.2634062,4.89994338 1.94418005,6.32874741 L0.168855444,6.32874741 L0.168855444,8.20731616 L1.65343504,8.20731616 C1.65343504,8.47432688 1.62614062,8.73777745 1.62614062,9.00241475 L1.62614062,9.45217947 L0.168855444,9.45217947 L0.168855444,11.3331216 L1.89196462,11.3331216 C2.1304942,12.7393781 2.65858206,13.8750637 3.37417079,14.7745931 C4.85875039,16.7338585 7.21319158,17.7935943 9.83345677,17.7935943 C11.5292715,17.7935943 13.0660666,17.2904275 13.965596,16.789634 L13.3295171,13.848956 L13.3295171,13.848956 Z" id="Shape" sketch:type="MSShapeGroup"></path> </g> </g> </g></svg>',
    'img/icons/angular-logo.svg' : '<svg xmlns="http://www.w3.org/2000/svg" viewBox="-10 -10 120 120"> <defs> <filter id="shadow" x="-50%" y="-50%" width="200%" height="200%"> <feOffset result="offOut" in="SourceAlpha" dx="0" dy="0"></feOffset> <feGaussianBlur result="blurOut" in="offOut" stdDeviation="3"></feGaussianBlur> <feComponentTransfer in="blurOut" result="opacityOut"> <feFuncA type="linear" slope="0.5"></feFuncA> </feComponentTransfer> <feBlend in="SourceGraphic" in2="opacityOut" mode="normal"></feBlend> </filter> </defs> <path d=" M 5 18.25 L 50 2.25 L 96 18 L 88.5 77 L 50 98.25 L 12 77.25 Z" fill="black" filter="url(#shadow)" class="outline"></path> <path d=" M 5 18.25 L 50 2.25 L 50 98.25 L 12 77.25 Z" fill="#de3641" class="left"></path> <path d=" M 50 2.25 L 96 18 L 88.5 77 L 50 98.25 Z" fill="#b13138" class="right"></path> <path d=" M 50 13 L 79.25 75.5 L 69.25 75.5 L 63 61.25 L 50 61.25 L 50 52.75 L 59.5 52.75 L 50 33.1 L 42 52.75 L 50 52.75 L 50 61.25 L 38.1 61.25 L 32.5 75.5 L 21.75 75.5 Z" fill="white" class="letter"></path></svg>',
    'img/icons/message.svg' : '<svg version="1.1" x="0px" y="0px" width="48px" height="48px" viewBox="0 0 48 48" enable-background="new 0 0 48 48" xml:space="preserve"><g><g><path fill="#7d7d7d" d="M40,4H8C5.8,4,4,5.8,4,8l0,36l8-8h28c2.2,0,4-1.8,4-4V8C44,5.8,42.2,4,40,4z M36,28H12v-4h24V28z M36,22H12v-4h24V22zM36,16H12v-4h24V16z"/><rect x="0" fill="none" width="48" height="48"/></g></g></svg>',
    'img/icons/ic_refresh_24px.svg' : '<?xml version="1.0" encoding="utf-8"?><!-- Generator: Adobe Illustrator 17.1.0, SVG Export Plug-In . SVG Version: 6.00 Build 0) --><!DOCTYPE svg PUBLIC "-//W3C//DTD SVG 1.1//EN" "http://www.w3.org/Graphics/SVG/1.1/DTD/svg11.dtd"><svg version="1.1" xmlns="http://www.w3.org/2000/svg" xmlns:xlink="http://www.w3.org/1999/xlink" x="0px" y="0px" width="24px" height="24px" viewBox="0 0 24 24" enable-background="new 0 0 24 24" xml:space="preserve"><g id="Header"> <g> <rect x="-618" y="-2616" fill="none" width="1400" height="3600"/> </g></g><g id="Label"></g><g id="Icon"> <g> <path d="M17.6,6.4C16.2,4.9,14.2,4,12,4c-4.4,0-8,3.6-8,8s3.6,8,8,8c3.7,0,6.8-2.6,7.7-6h-2.1c-0.8,2.3-3,4-5.6,4 c-3.3,0-6-2.7-6-6s2.7-6,6-6c1.7,0,3.1,0.7,4.2,1.8L13,11h7V4L17.6,6.4z"/> <rect fill="none" width="24" height="24"/> </g></g><g id="Grid" display="none"> <g display="inline"> </g></g></svg>',
    'img/icons/facebook.svg' : '<svg version="1.1" x="0px" y="0px" width="48px" height="48px" viewBox="0 0 48 48" enable-background="new 0 0 48 48" xml:space="preserve"><g><g><g><path fill="#7d7d7d" d="M40,4H8C5.8,4,4,5.8,4,8l0,32c0,2.2,1.8,4,4,4h32c2.2,0,4-1.8,4-4V8C44,5.8,42.2,4,40,4z M38,8v6h-4c-1.1,0-2,0.9-2,2v4h6v6h-6v14h-6V26h-4v-6h4v-5c0-3.9,3.1-7,7-7H38z"/></g><g><rect fill="none" width="48" height="48"/></g></g></g></svg>',
    'img/icons/octicon-repo.svg' : '<svg xmlns="http://www.w3.org/2000/svg" x="0px" y="0px" viewBox="0 0 48 48"><path d="M21,12h-3v3h3V12z M21,6h-3v3h3V6z M39,0C37.5,0,10.5,0,9,0S6,1.5,6,3s0,34.5,0,36s1.5,3,3,3s6,0,6,0v6l4.5-4.5L24,48v-6 c0,0,13.5,0,15,0s3-1.5,3-3s0-34.5,0-36S40.5,0,39,0z M39,37.5c0,0.75-0.703,1.5-1.5,1.5S24,39,24,39v-3h-9v3c0,0-3.703,0-4.5,0 S9,38.203,9,37.5S9,33,9,33h30C39,33,39,36.75,39,37.5z M39,30H15V3h24.047L39,30z M21,24h-3v3h3V24z M21,18h-3v3h3V18z"/></svg>',
    'img/icons/separator.svg' : '<?xml version="1.0" encoding="utf-8"?><!-- Generator: Adobe Illustrator 16.0.4, SVG Export Plug-In . SVG Version: 6.00 Build 0) --><!DOCTYPE svg PUBLIC "-//W3C//DTD SVG 1.1//EN" "http://www.w3.org/Graphics/SVG/1.1/DTD/svg11.dtd"><svg version="1.1" id="Layer_1" xmlns="http://www.w3.org/2000/svg" xmlns:xlink="http://www.w3.org/1999/xlink" x="0px" y="0px" viewBox="0 0 4 6" enable-background="new 0 0 4 6" xml:space="preserve"><g> <polygon fill="#FFFFFF" points="3.719,3 0.968,0.25 0.281,0.938 2.344,3 0.281,5.062 0.968,5.75 "/></g></svg>',
    'img/icons/sets/symbol-icons.svg' : '<svg xmlns="http://www.w3.org/2000/svg" style="display: none;"> <symbol id="spinner" viewBox="0 0 24 24"> <title>Animated Spinner</title> <path d="M12 4V1L8 5l4 4V6c3.31 0 6 2.69 6 6 0 1.01-.25 1.97-.7 2.8l1.46 1.46C19.54 15.03 20 13.57 20 12c0-4.42-3.58-8-8-8zm0 14c-3.31 0-6-2.69-6-6 0-1.01.25-1.97.7-2.8L5.24 7.74C4.46 8.97 4 10.43 4 12c0 4.42 3.58 8 8 8v3l4-4-4-4v3z"/> <animateTransform attributeName="transform" type="rotate" from="360" to="0" dur="3s" repeatCount="indefinite"/> </symbol> <symbol id="angular" viewBox="-3.5 -3.5 165.908 175.75"> <title>AngularJS Logo</title> <g transform="translate(-4.054,-4.375)"> <polygon style="fill:#b3b3b3" points="153.4 137.8 166.5 29.46 83.24 0.875 0.554 29.98 13.62 138.3 83.33 176.6"/> <polygon style="fill:#a6120d" points="158.2 35.72 83.05 10.09 83.05 167.5 146 132.6"/> <polygon style="fill:#dd1b16" points="9.833 36.18 21.03 133.1 83.05 167.5 83.05 10.09"/> <path style="fill:#f2f2f2" d="m103.7 93.87-20.69 9.675h-21.77l-10.25 25.7-19.07 0.3 51.13-113.7zm-2-4.87-18.51-36.73-15.22 36.1h15.08z"/> <polygon style="fill:#b3b3b3" points="83.05 103.5 107.1 103.5 118.3 129.5 136.5 129.9 83.05 15.8 83.19 52.27 100.5 88.4 83.09 88.4"/> </g> </symbol></svg>',
    'img/icons/sets/communication-icons.svg' : '<svg><defs><g id="business"><path d="M12 7V3H2v18h20V7H12zM6 19H4v-2h2v2zm0-4H4v-2h2v2zm0-4H4V9h2v2zm0-4H4V5h2v2zm4 12H8v-2h2v2zm0-4H8v-2h2v2zm0-4H8V9h2v2zm0-4H8V5h2v2zm10 12h-8v-2h2v-2h-2v-2h2v-2h-2V9h8v10zm-2-8h-2v2h2v-2zm0 4h-2v2h2v-2z"/></g><g id="call"><path d="M6.62 10.79c1.44 2.83 3.76 5.14 6.59 6.59l2.2-2.2c.27-.27.67-.36 1.02-.24 1.12.37 2.33.57 3.57.57.55 0 1 .45 1 1V20c0 .55-.45 1-1 1-9.39 0-17-7.61-17-17 0-.55.45-1 1-1h3.5c.55 0 1 .45 1 1 0 1.25.2 2.45.57 3.57.11.35.03.74-.25 1.02l-2.2 2.2z"/></g><g id="call-end"><path d="M12 9c-1.6 0-3.15.25-4.6.72v3.1c0 .39-.23.74-.56.9-.98.49-1.87 1.12-2.66 1.85-.18.18-.43.28-.7.28-.28 0-.53-.11-.71-.29L.29 13.08c-.18-.17-.29-.42-.29-.7 0-.28.11-.53.29-.71C3.34 8.78 7.46 7 12 7s8.66 1.78 11.71 4.67c.18.18.29.43.29.71 0 .28-.11.53-.29.71l-2.48 2.48c-.18.18-.43.29-.71.29-.27 0-.52-.11-.7-.28-.79-.74-1.69-1.36-2.67-1.85-.33-.16-.56-.5-.56-.9v-3.1C15.15 9.25 13.6 9 12 9z"/></g><g id="call-made"><path d="M9 5v2h6.59L4 18.59 5.41 20 17 8.41V15h2V5z"/></g><g id="call-merge"><path d="M17 20.41L18.41 19 15 15.59 13.59 17 17 20.41zM7.5 8H11v5.59L5.59 19 7 20.41l6-6V8h3.5L12 3.5 7.5 8z"/></g><g id="call-missed"><path d="M19.59 7L12 14.59 6.41 9H11V7H3v8h2v-4.59l7 7 9-9z"/></g><g id="call-received"><path d="M20 5.41L18.59 4 7 15.59V9H5v10h10v-2H8.41z"/></g><g id="call-split"><path d="M14 4l2.29 2.29-2.88 2.88 1.42 1.42 2.88-2.88L20 10V4zm-4 0H4v6l2.29-2.29 4.71 4.7V20h2v-8.41l-5.29-5.3z"/></g><g id="chat"><path d="M20 2H4c-1.1 0-1.99.9-1.99 2L2 22l4-4h14c1.1 0 2-.9 2-2V4c0-1.1-.9-2-2-2zM6 9h12v2H6V9zm8 5H6v-2h8v2zm4-6H6V6h12v2z"/></g><g id="clear-all"><path d="M5 13h14v-2H5v2zm-2 4h14v-2H3v2zM7 7v2h14V7H7z"/></g><g id="comment"><path d="M21.99 4c0-1.1-.89-2-1.99-2H4c-1.1 0-2 .9-2 2v12c0 1.1.9 2 2 2h14l4 4-.01-18zM18 14H6v-2h12v2zm0-3H6V9h12v2zm0-3H6V6h12v2z"/></g><g id="contacts"><path d="M20 0H4v2h16V0zM4 24h16v-2H4v2zM20 4H4c-1.1 0-2 .9-2 2v12c0 1.1.9 2 2 2h16c1.1 0 2-.9 2-2V6c0-1.1-.9-2-2-2zm-8 2.75c1.24 0 2.25 1.01 2.25 2.25s-1.01 2.25-2.25 2.25S9.75 10.24 9.75 9 10.76 6.75 12 6.75zM17 17H7v-1.5c0-1.67 3.33-2.5 5-2.5s5 .83 5 2.5V17z"/></g><g id="dialer-sip"><path d="M17 3h-1v5h1V3zm-2 2h-2V4h2V3h-3v3h2v1h-2v1h3V5zm3-2v5h1V6h2V3h-3zm2 2h-1V4h1v1zm0 10.5c-1.25 0-2.45-.2-3.57-.57-.35-.11-.74-.03-1.01.24l-2.2 2.2c-2.83-1.44-5.15-3.75-6.59-6.59l2.2-2.21c.27-.26.35-.65.24-1C8.7 6.45 8.5 5.25 8.5 4c0-.55-.45-1-1-1H4c-.55 0-1 .45-1 1 0 9.39 7.61 17 17 17 .55 0 1-.45 1-1v-3.5c0-.55-.45-1-1-1z"/></g><g id="dialpad"><path d="M12 19c-1.1 0-2 .9-2 2s.9 2 2 2 2-.9 2-2-.9-2-2-2zM6 1c-1.1 0-2 .9-2 2s.9 2 2 2 2-.9 2-2-.9-2-2-2zm0 6c-1.1 0-2 .9-2 2s.9 2 2 2 2-.9 2-2-.9-2-2-2zm0 6c-1.1 0-2 .9-2 2s.9 2 2 2 2-.9 2-2-.9-2-2-2zm12-8c1.1 0 2-.9 2-2s-.9-2-2-2-2 .9-2 2 .9 2 2 2zm-6 8c-1.1 0-2 .9-2 2s.9 2 2 2 2-.9 2-2-.9-2-2-2zm6 0c-1.1 0-2 .9-2 2s.9 2 2 2 2-.9 2-2-.9-2-2-2zm0-6c-1.1 0-2 .9-2 2s.9 2 2 2 2-.9 2-2-.9-2-2-2zm-6 0c-1.1 0-2 .9-2 2s.9 2 2 2 2-.9 2-2-.9-2-2-2zm0-6c-1.1 0-2 .9-2 2s.9 2 2 2 2-.9 2-2-.9-2-2-2z"/></g><g id="dnd-on"><path d="M12 2C6.48 2 2 6.48 2 12s4.48 10 10 10 10-4.48 10-10S17.52 2 12 2zm0 18c-4.42 0-8-3.58-8-8 0-1.85.63-3.55 1.69-4.9L16.9 18.31C15.55 19.37 13.85 20 12 20zm6.31-3.1L7.1 5.69C8.45 4.63 10.15 4 12 4c4.42 0 8 3.58 8 8 0 1.85-.63 3.55-1.69 4.9z"/></g><g id="email"><path d="M20 4H4c-1.1 0-1.99.9-1.99 2L2 18c0 1.1.9 2 2 2h16c1.1 0 2-.9 2-2V6c0-1.1-.9-2-2-2zm0 4l-8 5-8-5V6l8 5 8-5v2z"/></g><g id="forum"><path d="M21 6h-2v9H6v2c0 .55.45 1 1 1h11l4 4V7c0-.55-.45-1-1-1zm-4 6V3c0-.55-.45-1-1-1H3c-.55 0-1 .45-1 1v14l4-4h10c.55 0 1-.45 1-1z"/></g><g id="import-export"><path d="M9 3L5 6.99h3V14h2V6.99h3L9 3zm7 14.01V10h-2v7.01h-3L15 21l4-3.99h-3z"/></g><g id="invert-colors-off"><path d="M20.65 20.87l-2.35-2.35-6.3-6.29-3.56-3.57-1.42-1.41L4.27 4.5 3 5.77l2.78 2.78c-2.55 3.14-2.36 7.76.56 10.69C7.9 20.8 9.95 21.58 12 21.58c1.79 0 3.57-.59 5.03-1.78l2.7 2.7L21 21.23l-.35-.36zM12 19.59c-1.6 0-3.11-.62-4.24-1.76C6.62 16.69 6 15.19 6 13.59c0-1.32.43-2.57 1.21-3.6L12 14.77v4.82zM12 5.1v4.58l7.25 7.26c1.37-2.96.84-6.57-1.6-9.01L12 2.27l-3.7 3.7 1.41 1.41L12 5.1z"/></g><g id="invert-colors-on"><path d="M17.66 7.93L12 2.27 6.34 7.93c-3.12 3.12-3.12 8.19 0 11.31C7.9 20.8 9.95 21.58 12 21.58c2.05 0 4.1-.78 5.66-2.34 3.12-3.12 3.12-8.19 0-11.31zM12 19.59c-1.6 0-3.11-.62-4.24-1.76C6.62 16.69 6 15.19 6 13.59s.62-3.11 1.76-4.24L12 5.1v14.49z"/></g><g id="live-help"><path d="M19 2H5c-1.11 0-2 .9-2 2v14c0 1.1.89 2 2 2h4l3 3 3-3h4c1.1 0 2-.9 2-2V4c0-1.1-.9-2-2-2zm-6 16h-2v-2h2v2zm2.07-7.75l-.9.92C13.45 11.9 13 12.5 13 14h-2v-.5c0-1.1.45-2.1 1.17-2.83l1.24-1.26c.37-.36.59-.86.59-1.41 0-1.1-.9-2-2-2s-2 .9-2 2H8c0-2.21 1.79-4 4-4s4 1.79 4 4c0 .88-.36 1.68-.93 2.25z"/></g><g id="location-off"><path d="M12 6.5c1.38 0 2.5 1.12 2.5 2.5 0 .74-.33 1.39-.83 1.85l3.63 3.63c.98-1.86 1.7-3.8 1.7-5.48 0-3.87-3.13-7-7-7-1.98 0-3.76.83-5.04 2.15l3.19 3.19c.46-.52 1.11-.84 1.85-.84zm4.37 9.6l-4.63-4.63-.11-.11L3.27 3 2 4.27l3.18 3.18C5.07 7.95 5 8.47 5 9c0 5.25 7 13 7 13s1.67-1.85 3.38-4.35L18.73 21 20 19.73l-3.63-3.63z"/></g><g id="location-on"><path d="M12 2C8.13 2 5 5.13 5 9c0 5.25 7 13 7 13s7-7.75 7-13c0-3.87-3.13-7-7-7zm0 9.5c-1.38 0-2.5-1.12-2.5-2.5s1.12-2.5 2.5-2.5 2.5 1.12 2.5 2.5-1.12 2.5-2.5 2.5z"/></g><g id="message"><path d="M20 2H4c-1.1 0-1.99.9-1.99 2L2 22l4-4h14c1.1 0 2-.9 2-2V4c0-1.1-.9-2-2-2zm-2 12H6v-2h12v2zm0-3H6V9h12v2zm0-3H6V6h12v2z"/></g><g id="messenger"><path d="M20 2H4c-1.1 0-2 .9-2 2v18l4-4h14c1.1 0 2-.9 2-2V4c0-1.1-.9-2-2-2z"/></g><g id="no-sim"><path d="M18.99 5c0-1.1-.89-2-1.99-2h-7L7.66 5.34 19 16.68 18.99 5zM3.65 3.88L2.38 5.15 5 7.77V19c0 1.1.9 2 2 2h10.01c.35 0 .67-.1.96-.26l1.88 1.88 1.27-1.27L3.65 3.88z"/></g><g id="phone"><path d="M6.62 10.79c1.44 2.83 3.76 5.14 6.59 6.59l2.2-2.2c.27-.27.67-.36 1.02-.24 1.12.37 2.33.57 3.57.57.55 0 1 .45 1 1V20c0 .55-.45 1-1 1-9.39 0-17-7.61-17-17 0-.55.45-1 1-1h3.5c.55 0 1 .45 1 1 0 1.25.2 2.45.57 3.57.11.35.03.74-.25 1.02l-2.2 2.2z"/></g><g id="portable-wifi-off"><path d="M17.56 14.24c.28-.69.44-1.45.44-2.24 0-3.31-2.69-6-6-6-.79 0-1.55.16-2.24.44l1.62 1.62c.2-.03.41-.06.62-.06 2.21 0 4 1.79 4 4 0 .21-.02.42-.05.63l1.61 1.61zM12 4c4.42 0 8 3.58 8 8 0 1.35-.35 2.62-.95 3.74l1.47 1.47C21.46 15.69 22 13.91 22 12c0-5.52-4.48-10-10-10-1.91 0-3.69.55-5.21 1.47l1.46 1.46C9.37 4.34 10.65 4 12 4zM3.27 2.5L2 3.77l2.1 2.1C2.79 7.57 2 9.69 2 12c0 3.7 2.01 6.92 4.99 8.65l1-1.73C5.61 17.53 4 14.96 4 12c0-1.76.57-3.38 1.53-4.69l1.43 1.44C6.36 9.68 6 10.8 6 12c0 2.22 1.21 4.15 3 5.19l1-1.74c-1.19-.7-2-1.97-2-3.45 0-.65.17-1.25.44-1.79l1.58 1.58L10 12c0 1.1.9 2 2 2l.21-.02.01.01 7.51 7.51L21 20.23 4.27 3.5l-1-1z"/></g><g id="quick-contacts-dialer"><path d="M22 3H2C.9 3 0 3.9 0 5v14c0 1.1.9 2 2 2h20c1.1 0 1.99-.9 1.99-2L24 5c0-1.1-.9-2-2-2zM8 6c1.66 0 3 1.34 3 3s-1.34 3-3 3-3-1.34-3-3 1.34-3 3-3zm6 12H2v-1c0-2 4-3.1 6-3.1s6 1.1 6 3.1v1zm3.85-4h1.64L21 16l-1.99 1.99c-1.31-.98-2.28-2.38-2.73-3.99-.18-.64-.28-1.31-.28-2s.1-1.36.28-2c.45-1.62 1.42-3.01 2.73-3.99L21 8l-1.51 2h-1.64c-.22.63-.35 1.3-.35 2s.13 1.37.35 2z"/></g><g id="quick-contacts-mail"><path d="M21 8V7l-3 2-3-2v1l3 2 3-2zm1-5H2C.9 3 0 3.9 0 5v14c0 1.1.9 2 2 2h20c1.1 0 1.99-.9 1.99-2L24 5c0-1.1-.9-2-2-2zM8 6c1.66 0 3 1.34 3 3s-1.34 3-3 3-3-1.34-3-3 1.34-3 3-3zm6 12H2v-1c0-2 4-3.1 6-3.1s6 1.1 6 3.1v1zm8-6h-8V6h8v6z"/></g><g id="ring-volume"><path d="M23.71 16.67C20.66 13.78 16.54 12 12 12 7.46 12 3.34 13.78.29 16.67c-.18.18-.29.43-.29.71 0 .28.11.53.29.71l2.48 2.48c.18.18.43.29.71.29.27 0 .52-.11.7-.28.79-.74 1.69-1.36 2.66-1.85.33-.16.56-.5.56-.9v-3.1c1.45-.48 3-.73 4.6-.73s3.15.25 4.6.72v3.1c0 .39.23.74.56.9.98.49 1.87 1.12 2.66 1.85.18.18.43.28.7.28.28 0 .53-.11.71-.29l2.48-2.48c.18-.18.29-.43.29-.71 0-.27-.11-.52-.29-.7zM21.16 6.26l-1.41-1.41-3.56 3.55 1.41 1.41s3.45-3.52 3.56-3.55zM13 2h-2v5h2V2zM6.4 9.81L7.81 8.4 4.26 4.84 2.84 6.26c.11.03 3.56 3.55 3.56 3.55z"/></g><g id="stay-current-landscape"><path d="M1.01 7L1 17c0 1.1.9 2 2 2h18c1.1 0 2-.9 2-2V7c0-1.1-.9-2-2-2H3c-1.1 0-1.99.9-1.99 2zM19 7v10H5V7h14z"/></g><g id="stay-current-portrait"><path d="M17 1.01L7 1c-1.1 0-1.99.9-1.99 2v18c0 1.1.89 2 1.99 2h10c1.1 0 2-.9 2-2V3c0-1.1-.9-1.99-2-1.99zM17 19H7V5h10v14z"/></g><g id="stay-primary-landscape"><path d="M1.01 7L1 17c0 1.1.9 2 2 2h18c1.1 0 2-.9 2-2V7c0-1.1-.9-2-2-2H3c-1.1 0-1.99.9-1.99 2zM19 7v10H5V7h14z"/></g><g id="stay-primary-portrait"><path d="M17 1.01L7 1c-1.1 0-1.99.9-1.99 2v18c0 1.1.89 2 1.99 2h10c1.1 0 2-.9 2-2V3c0-1.1-.9-1.99-2-1.99zM17 19H7V5h10v14z"/></g><g id="swap-calls"><path d="M18 4l-4 4h3v7c0 1.1-.9 2-2 2s-2-.9-2-2V8c0-2.21-1.79-4-4-4S5 5.79 5 8v7H2l4 4 4-4H7V8c0-1.1.9-2 2-2s2 .9 2 2v7c0 2.21 1.79 4 4 4s4-1.79 4-4V8h3l-4-4z"/></g><g id="textsms"><path d="M20 2H4c-1.1 0-1.99.9-1.99 2L2 22l4-4h14c1.1 0 2-.9 2-2V4c0-1.1-.9-2-2-2zM9 11H7V9h2v2zm4 0h-2V9h2v2zm4 0h-2V9h2v2z"/></g><g id="voicemail"><path d="M18.5 6C15.46 6 13 8.46 13 11.5c0 1.33.47 2.55 1.26 3.5H9.74c.79-.95 1.26-2.17 1.26-3.5C11 8.46 8.54 6 5.5 6S0 8.46 0 11.5 2.46 17 5.5 17h13c3.04 0 5.5-2.46 5.5-5.5S21.54 6 18.5 6zm-13 9C3.57 15 2 13.43 2 11.5S3.57 8 5.5 8 9 9.57 9 11.5 7.43 15 5.5 15zm13 0c-1.93 0-3.5-1.57-3.5-3.5S16.57 8 18.5 8 22 9.57 22 11.5 20.43 15 18.5 15z"/></g><g id="vpn-key"><path d="M12.65 10C11.83 7.67 9.61 6 7 6c-3.31 0-6 2.69-6 6s2.69 6 6 6c2.61 0 4.83-1.67 5.65-4H17v4h4v-4h2v-4H12.65zM7 14c-1.1 0-2-.9-2-2s.9-2 2-2 2 .9 2 2-.9 2-2 2z"/></g></defs></svg>',
    'img/icons/sets/core-icons.svg' : '<svg><defs><g id="3d-rotation"><path d="M7.52 21.48C4.25 19.94 1.91 16.76 1.55 13H.05C.56 19.16 5.71 24 12 24l.66-.03-3.81-3.81-1.33 1.32zm.89-6.52c-.19 0-.37-.03-.52-.08-.16-.06-.29-.13-.4-.24-.11-.1-.2-.22-.26-.37-.06-.14-.09-.3-.09-.47h-1.3c0 .36.07.68.21.95.14.27.33.5.56.69.24.18.51.32.82.41.3.1.62.15.96.15.37 0 .72-.05 1.03-.15.32-.1.6-.25.83-.44s.42-.43.55-.72c.13-.29.2-.61.2-.97 0-.19-.02-.38-.07-.56-.05-.18-.12-.35-.23-.51-.1-.16-.24-.3-.4-.43-.17-.13-.37-.23-.61-.31.2-.09.37-.2.52-.33.15-.13.27-.27.37-.42.1-.15.17-.3.22-.46.05-.16.07-.32.07-.48 0-.36-.06-.68-.18-.96-.12-.28-.29-.51-.51-.69-.2-.19-.47-.33-.77-.43C9.1 8.05 8.76 8 8.39 8c-.36 0-.69.05-1 .16-.3.11-.57.26-.79.45-.21.19-.38.41-.51.67-.12.26-.18.54-.18.85h1.3c0-.17.03-.32.09-.45s.14-.25.25-.34c.11-.09.23-.17.38-.22.15-.05.3-.08.48-.08.4 0 .7.1.89.31.19.2.29.49.29.86 0 .18-.03.34-.08.49-.05.15-.14.27-.25.37-.11.1-.25.18-.41.24-.16.06-.36.09-.58.09H7.5v1.03h.77c.22 0 .42.02.6.07s.33.13.45.23c.12.11.22.24.29.4.07.16.1.35.1.57 0 .41-.12.72-.35.93-.23.23-.55.33-.95.33zm8.55-5.92c-.32-.33-.7-.59-1.14-.77-.43-.18-.92-.27-1.46-.27H12v8h2.3c.55 0 1.06-.09 1.51-.27.45-.18.84-.43 1.16-.76.32-.33.57-.73.74-1.19.17-.47.26-.99.26-1.57v-.4c0-.58-.09-1.1-.26-1.57-.18-.47-.43-.87-.75-1.2zm-.39 3.16c0 .42-.05.79-.14 1.13-.1.33-.24.62-.43.85-.19.23-.43.41-.71.53-.29.12-.62.18-.99.18h-.91V9.12h.97c.72 0 1.27.23 1.64.69.38.46.57 1.12.57 1.99v.4zM12 0l-.66.03 3.81 3.81 1.33-1.33c3.27 1.55 5.61 4.72 5.96 8.48h1.5C23.44 4.84 18.29 0 12 0z"/></g><g id="accessibility"><path d="M12 2c1.1 0 2 .9 2 2s-.9 2-2 2-2-.9-2-2 .9-2 2-2zm9 7h-6v13h-2v-6h-2v6H9V9H3V7h18v2z"/></g><g id="account-balance"><path d="M4 10v7h3v-7H4zm6 0v7h3v-7h-3zM2 22h19v-3H2v3zm14-12v7h3v-7h-3zm-4.5-9L2 6v2h19V6l-9.5-5z"/></g><g id="account-balance-wallet"><path d="M21 18v1c0 1.1-.9 2-2 2H5c-1.11 0-2-.9-2-2V5c0-1.1.89-2 2-2h14c1.1 0 2 .9 2 2v1h-9c-1.11 0-2 .9-2 2v8c0 1.1.89 2 2 2h9zm-9-2h10V8H12v8zm4-2.5c-.83 0-1.5-.67-1.5-1.5s.67-1.5 1.5-1.5 1.5.67 1.5 1.5-.67 1.5-1.5 1.5z"/></g><g id="account-box"><path d="M3 5v14c0 1.1.89 2 2 2h14c1.1 0 2-.9 2-2V5c0-1.1-.9-2-2-2H5c-1.11 0-2 .9-2 2zm12 4c0 1.66-1.34 3-3 3s-3-1.34-3-3 1.34-3 3-3 3 1.34 3 3zm-9 8c0-2 4-3.1 6-3.1s6 1.1 6 3.1v1H6v-1z"/></g><g id="account-child"><circle cx="12" cy="13.49" r="1.5"/><path d="M12 2C6.48 2 2 6.48 2 12s4.48 10 10 10 10-4.48 10-10S17.52 2 12 2zm0 2.5c1.24 0 2.25 1.01 2.25 2.25S13.24 9 12 9 9.75 7.99 9.75 6.75 10.76 4.5 12 4.5zm5 10.56v2.5c-.45.41-.96.77-1.5 1.05v-.68c0-.34-.17-.65-.46-.92-.65-.62-1.89-1.02-3.04-1.02-.96 0-1.96.28-2.65.73l-.17.12-.21.17c.78.47 1.63.72 2.54.82l1.33.15c.37.04.66.36.66.75 0 .29-.16.53-.4.66-.28.15-.64.09-.95.09-.35 0-.69-.01-1.03-.05-.5-.06-.99-.17-1.46-.33-.49-.16-.97-.38-1.42-.64-.22-.13-.44-.27-.65-.43l-.31-.24c-.04-.02-.28-.18-.28-.23v-4.28c0-1.58 2.63-2.78 5-2.78s5 1.2 5 2.78v1.78z"/></g><g id="account-circle"><path d="M12 2C6.48 2 2 6.48 2 12s4.48 10 10 10 10-4.48 10-10S17.52 2 12 2zm0 3c1.66 0 3 1.34 3 3s-1.34 3-3 3-3-1.34-3-3 1.34-3 3-3zm0 14.2c-2.5 0-4.71-1.28-6-3.22.03-1.99 4-3.08 6-3.08 1.99 0 5.97 1.09 6 3.08-1.29 1.94-3.5 3.22-6 3.22z"/></g><g id="add"><path d="M19 13h-6v6h-2v-6H5v-2h6V5h2v6h6v2z"/></g><g id="add-box"><path d="M19 3H5c-1.11 0-2 .9-2 2v14c0 1.1.89 2 2 2h14c1.1 0 2-.9 2-2V5c0-1.1-.9-2-2-2zm-2 10h-4v4h-2v-4H7v-2h4V7h2v4h4v2z"/></g><g id="add-circle"><path d="M12 2C6.48 2 2 6.48 2 12s4.48 10 10 10 10-4.48 10-10S17.52 2 12 2zm5 11h-4v4h-2v-4H7v-2h4V7h2v4h4v2z"/></g><g id="add-circle-outline"><path d="M13 7h-2v4H7v2h4v4h2v-4h4v-2h-4V7zm-1-5C6.48 2 2 6.48 2 12s4.48 10 10 10 10-4.48 10-10S17.52 2 12 2zm0 18c-4.41 0-8-3.59-8-8s3.59-8 8-8 8 3.59 8 8-3.59 8-8 8z"/></g><g id="add-shopping-cart"><path d="M11 9h2V6h3V4h-3V1h-2v3H8v2h3v3zm-4 9c-1.1 0-1.99.9-1.99 2S5.9 22 7 22s2-.9 2-2-.9-2-2-2zm10 0c-1.1 0-1.99.9-1.99 2s.89 2 1.99 2 2-.9 2-2-.9-2-2-2zm-9.83-3.25l.03-.12.9-1.63h7.45c.75 0 1.41-.41 1.75-1.03l3.86-7.01L19.42 4h-.01l-1.1 2-2.76 5H8.53l-.13-.27L6.16 6l-.95-2-.94-2H1v2h2l3.6 7.59-1.35 2.45c-.16.28-.25.61-.25.96 0 1.1.9 2 2 2h12v-2H7.42c-.13 0-.25-.11-.25-.25z"/></g><g id="alarm"><path d="M22 5.72l-4.6-3.86-1.29 1.53 4.6 3.86L22 5.72zM7.88 3.39L6.6 1.86 2 5.71l1.29 1.53 4.59-3.85zM12.5 8H11v6l4.75 2.85.75-1.23-4-2.37V8zM12 4c-4.97 0-9 4.03-9 9s4.02 9 9 9c4.97 0 9-4.03 9-9s-4.03-9-9-9zm0 16c-3.87 0-7-3.13-7-7s3.13-7 7-7 7 3.13 7 7-3.13 7-7 7z"/></g><g id="alarm-add"><path d="M7.88 3.39L6.6 1.86 2 5.71l1.29 1.53 4.59-3.85zM22 5.72l-4.6-3.86-1.29 1.53 4.6 3.86L22 5.72zM12 4c-4.97 0-9 4.03-9 9s4.02 9 9 9c4.97 0 9-4.03 9-9s-4.03-9-9-9zm0 16c-3.87 0-7-3.13-7-7s3.13-7 7-7 7 3.13 7 7-3.13 7-7 7zm1-11h-2v3H8v2h3v3h2v-3h3v-2h-3V9z"/></g><g id="alarm-off"><path d="M12 6c3.87 0 7 3.13 7 7 0 .84-.16 1.65-.43 2.4l1.52 1.52c.58-1.19.91-2.51.91-3.92 0-4.97-4.03-9-9-9-1.41 0-2.73.33-3.92.91L9.6 6.43C10.35 6.16 11.16 6 12 6zm10-.28l-4.6-3.86-1.29 1.53 4.6 3.86L22 5.72zM2.92 2.29L1.65 3.57 2.98 4.9l-1.11.93 1.42 1.42 1.11-.94.8.8C3.83 8.69 3 10.75 3 13c0 4.97 4.02 9 9 9 2.25 0 4.31-.83 5.89-2.2l2.2 2.2 1.27-1.27L3.89 3.27l-.97-.98zm13.55 16.1C15.26 19.39 13.7 20 12 20c-3.87 0-7-3.13-7-7 0-1.7.61-3.26 1.61-4.47l9.86 9.86zM8.02 3.28L6.6 1.86l-.86.71 1.42 1.42.86-.71z"/></g><g id="alarm-on"><path d="M22 5.72l-4.6-3.86-1.29 1.53 4.6 3.86L22 5.72zM7.88 3.39L6.6 1.86 2 5.71l1.29 1.53 4.59-3.85zM12 4c-4.97 0-9 4.03-9 9s4.02 9 9 9c4.97 0 9-4.03 9-9s-4.03-9-9-9zm0 16c-3.87 0-7-3.13-7-7s3.13-7 7-7 7 3.13 7 7-3.13 7-7 7zm-1.46-5.47L8.41 12.4l-1.06 1.06 3.18 3.18 6-6-1.06-1.06-4.93 4.95z"/></g><g id="android"><path d="M6 18c0 .55.45 1 1 1h1v3.5c0 .83.67 1.5 1.5 1.5s1.5-.67 1.5-1.5V19h2v3.5c0 .83.67 1.5 1.5 1.5s1.5-.67 1.5-1.5V19h1c.55 0 1-.45 1-1V8H6v10zM3.5 8C2.67 8 2 8.67 2 9.5v7c0 .83.67 1.5 1.5 1.5S5 17.33 5 16.5v-7C5 8.67 4.33 8 3.5 8zm17 0c-.83 0-1.5.67-1.5 1.5v7c0 .83.67 1.5 1.5 1.5s1.5-.67 1.5-1.5v-7c0-.83-.67-1.5-1.5-1.5zm-4.97-5.84l1.3-1.3c.2-.2.2-.51 0-.71-.2-.2-.51-.2-.71 0l-1.48 1.48C13.85 1.23 12.95 1 12 1c-.96 0-1.86.23-2.66.63L7.85.15c-.2-.2-.51-.2-.71 0-.2.2-.2.51 0 .71l1.31 1.31C6.97 3.26 6 5.01 6 7h12c0-1.99-.97-3.75-2.47-4.84zM10 5H9V4h1v1zm5 0h-1V4h1v1z"/></g><g id="announcement"><path d="M20 2H4c-1.1 0-1.99.9-1.99 2L2 22l4-4h14c1.1 0 2-.9 2-2V4c0-1.1-.9-2-2-2zm-7 9h-2V5h2v6zm0 4h-2v-2h2v2z"/></g><g id="apps"><path d="M4 8h4V4H4v4zm6 12h4v-4h-4v4zm-6 0h4v-4H4v4zm0-6h4v-4H4v4zm6 0h4v-4h-4v4zm6-10v4h4V4h-4zm-6 4h4V4h-4v4zm6 6h4v-4h-4v4zm0 6h4v-4h-4v4z"/></g><g id="archive"><path d="M20.54 5.23l-1.39-1.68C18.88 3.21 18.47 3 18 3H6c-.47 0-.88.21-1.16.55L3.46 5.23C3.17 5.57 3 6.02 3 6.5V19c0 1.1.9 2 2 2h14c1.1 0 2-.9 2-2V6.5c0-.48-.17-.93-.46-1.27zM12 17.5L6.5 12H10v-2h4v2h3.5L12 17.5zM5.12 5l.81-1h12l.94 1H5.12z"/></g><g id="arrow-back"><path d="M20 11H7.83l5.59-5.59L12 4l-8 8 8 8 1.41-1.41L7.83 13H20v-2z"/></g><g id="arrow-drop-down"><path d="M7 10l5 5 5-5z"/></g><g id="arrow-drop-down-circle"><path d="M12 2C6.48 2 2 6.48 2 12s4.48 10 10 10 10-4.48 10-10S17.52 2 12 2zm0 12l-4-4h8l-4 4z"/></g><g id="arrow-drop-up"><path d="M7 14l5-5 5 5z"/></g><g id="cached"><path d="M19 8l-4 4h3c0 3.31-2.69 6-6 6-1.01 0-1.97-.25-2.8-.7l-1.46 1.46C8.97 19.54 10.43 20 12 20c4.42 0 8-3.58 8-8h3l-4-4zM6 12c0-3.31 2.69-6 6-6 1.01 0 1.97.25 2.8.7l1.46-1.46C15.03 4.46 13.57 4 12 4c-4.42 0-8 3.58-8 8H1l4 4 4-4H6z"/></g><g id="check"><path d="M9 16.17L4.83 12l-1.42 1.41L9 19 21 7l-1.41-1.41z"/></g><g id="undo"><path d="M12.5 8c-2.65 0-5.05.99-6.9 2.6L2 7v9h9l-3.62-3.62c1.39-1.16 3.16-1.88 5.12-1.88 3.54 0 6.55 2.31 7.6 5.5l2.37-.78C21.08 11.03 17.15 8 12.5 8z"/></g><g id="redo"><path d="M18.4 10.6C16.55 8.99 14.15 8 11.5 8c-4.65 0-8.58 3.03-9.96 7.22L3.9 16c1.05-3.19 4.05-5.5 7.6-5.5 1.95 0 3.73.72 5.12 1.88L13 16h9V7l-3.6 3.6z"/></g><g id="content-copy"><path d="M16 1H4c-1.1 0-2 .9-2 2v14h2V3h12V1zm3 4H8c-1.1 0-2 .9-2 2v14c0 1.1.9 2 2 2h11c1.1 0 2-.9 2-2V7c0-1.1-.9-2-2-2zm0 16H8V7h11v14z"/></g><g id="content-cut"><path d="M9.64 7.64c.23-.5.36-1.05.36-1.64 0-2.21-1.79-4-4-4S2 3.79 2 6s1.79 4 4 4c.59 0 1.14-.13 1.64-.36L10 12l-2.36 2.36C7.14 14.13 6.59 14 6 14c-2.21 0-4 1.79-4 4s1.79 4 4 4 4-1.79 4-4c0-.59-.13-1.14-.36-1.64L12 14l7 7h3v-1L9.64 7.64zM6 8c-1.1 0-2-.89-2-2s.9-2 2-2 2 .89 2 2-.9 2-2 2zm0 12c-1.1 0-2-.89-2-2s.9-2 2-2 2 .89 2 2-.9 2-2 2zm6-7.5c-.28 0-.5-.22-.5-.5s.22-.5.5-.5.5.22.5.5-.22.5-.5.5zM19 3l-6 6 2 2 7-7V3z"/></g><g id="content-paste"><path d="M19 2h-4.18C14.4.84 13.3 0 12 0c-1.3 0-2.4.84-2.82 2H5c-1.1 0-2 .9-2 2v16c0 1.1.9 2 2 2h14c1.1 0 2-.9 2-2V4c0-1.1-.9-2-2-2zm-7 0c.55 0 1 .45 1 1s-.45 1-1 1-1-.45-1-1 .45-1 1-1zm7 18H5V4h2v3h10V4h2v16z"/></g></defs></svg>',
    'img/icons/sets/device-icons.svg' : '<svg><defs><g id="access-alarm"><path d="M22 5.72l-4.6-3.86-1.29 1.53 4.6 3.86L22 5.72zM7.88 3.39L6.6 1.86 2 5.71l1.29 1.53 4.59-3.85zM12.5 8H11v6l4.75 2.85.75-1.23-4-2.37V8zM12 4c-4.97 0-9 4.03-9 9s4.02 9 9 9c4.97 0 9-4.03 9-9s-4.03-9-9-9zm0 16c-3.87 0-7-3.13-7-7s3.13-7 7-7 7 3.13 7 7-3.13 7-7 7z"/></g><g id="access-alarms"><path d="M22 5.7l-4.6-3.9-1.3 1.5 4.6 3.9L22 5.7zM7.9 3.4L6.6 1.9 2 5.7l1.3 1.5 4.6-3.8zM12.5 8H11v6l4.7 2.9.8-1.2-4-2.4V8zM12 4c-5 0-9 4-9 9s4 9 9 9 9-4 9-9-4-9-9-9zm0 16c-3.9 0-7-3.1-7-7s3.1-7 7-7 7 3.1 7 7-3.1 7-7 7z"/></g><g id="access-time"><path fill-opacity=".9" d="M11.99 2C6.47 2 2 6.48 2 12s4.47 10 9.99 10C17.52 22 22 17.52 22 12S17.52 2 11.99 2zM12 20c-4.42 0-8-3.58-8-8s3.58-8 8-8 8 3.58 8 8-3.58 8-8 8zM12.5 7H11v6l5.25 3.15.75-1.23-4.5-2.67z"/></g><g id="add-alarm"><path d="M7.88 3.39L6.6 1.86 2 5.71l1.29 1.53 4.59-3.85zM22 5.72l-4.6-3.86-1.29 1.53 4.6 3.86L22 5.72zM12 4c-4.97 0-9 4.03-9 9s4.02 9 9 9c4.97 0 9-4.03 9-9s-4.03-9-9-9zm0 16c-3.87 0-7-3.13-7-7s3.13-7 7-7 7 3.13 7 7-3.13 7-7 7zm1-11h-2v3H8v2h3v3h2v-3h3v-2h-3V9z"/></g><g id="airplanemode-off"><path d="M13 9V3.5c0-.83-.67-1.5-1.5-1.5S10 2.67 10 3.5v3.68l7.83 7.83L21 16v-2l-8-5zM3 5.27l4.99 4.99L2 14v2l8-2.5V19l-2 1.5V22l3.5-1 3.5 1v-1.5L13 19v-3.73L18.73 21 20 19.73 4.27 4 3 5.27z"/></g><g id="airplanemode-on"><path d="M10.18 9"/><path d="M21 16v-2l-8-5V3.5c0-.83-.67-1.5-1.5-1.5S10 2.67 10 3.5V9l-8 5v2l8-2.5V19l-2 1.5V22l3.5-1 3.5 1v-1.5L13 19v-5.5l8 2.5z"/></g><g id="battery-20"><path d="M7 17v3.67C7 21.4 7.6 22 8.33 22h7.33c.74 0 1.34-.6 1.34-1.33V17H7z"/><path fill-opacity=".3" d="M17 5.33C17 4.6 16.4 4 15.67 4H14V2h-4v2H8.33C7.6 4 7 4.6 7 5.33V17h10V5.33z"/></g><g id="battery-30"><path fill-opacity=".3" d="M17 5.33C17 4.6 16.4 4 15.67 4H14V2h-4v2H8.33C7.6 4 7 4.6 7 5.33V15h10V5.33z"/><path d="M7 15v5.67C7 21.4 7.6 22 8.33 22h7.33c.74 0 1.34-.6 1.34-1.33V15H7z"/></g><g id="battery-50"><path fill-opacity=".3" d="M17 5.33C17 4.6 16.4 4 15.67 4H14V2h-4v2H8.33C7.6 4 7 4.6 7 5.33V13h10V5.33z"/><path d="M7 13v7.67C7 21.4 7.6 22 8.33 22h7.33c.74 0 1.34-.6 1.34-1.33V13H7z"/></g><g id="battery-60"><path fill-opacity=".3" d="M17 5.33C17 4.6 16.4 4 15.67 4H14V2h-4v2H8.33C7.6 4 7 4.6 7 5.33V11h10V5.33z"/><path d="M7 11v9.67C7 21.4 7.6 22 8.33 22h7.33c.74 0 1.34-.6 1.34-1.33V11H7z"/></g><g id="battery-80"><path fill-opacity=".3" d="M17 5.33C17 4.6 16.4 4 15.67 4H14V2h-4v2H8.33C7.6 4 7 4.6 7 5.33V9h10V5.33z"/><path d="M7 9v11.67C7 21.4 7.6 22 8.33 22h7.33c.74 0 1.34-.6 1.34-1.33V9H7z"/></g><g id="battery-90"><path fill-opacity=".3" d="M17 5.33C17 4.6 16.4 4 15.67 4H14V2h-4v2H8.33C7.6 4 7 4.6 7 5.33V8h10V5.33z"/><path d="M7 8v12.67C7 21.4 7.6 22 8.33 22h7.33c.74 0 1.34-.6 1.34-1.33V8H7z"/></g><g id="battery-alert"><path d="M15.67 4H14V2h-4v2H8.33C7.6 4 7 4.6 7 5.33v15.33C7 21.4 7.6 22 8.33 22h7.33c.74 0 1.34-.6 1.34-1.33V5.33C17 4.6 16.4 4 15.67 4zM13 18h-2v-2h2v2zm0-4h-2V9h2v5z"/></g><g id="battery-charging-20"><path d="M11 20v-3H7v3.67C7 21.4 7.6 22 8.33 22h7.33c.74 0 1.34-.6 1.34-1.33V17h-4.4L11 20z"/><path fill-opacity=".3" d="M15.67 4H14V2h-4v2H8.33C7.6 4 7 4.6 7 5.33V17h4v-2.5H9L13 7v5.5h2L12.6 17H17V5.33C17 4.6 16.4 4 15.67 4z"/></g><g id="battery-charging-30"><path fill-opacity=".3" d="M15.67 4H14V2h-4v2H8.33C7.6 4 7 4.6 7 5.33v9.17h2L13 7v5.5h2l-1.07 2H17V5.33C17 4.6 16.4 4 15.67 4z"/><path d="M11 20v-5.5H7v6.17C7 21.4 7.6 22 8.33 22h7.33c.74 0 1.34-.6 1.34-1.33V14.5h-3.07L11 20z"/></g><g id="battery-charging-50"><path d="M14.47 13.5L11 20v-5.5H9l.53-1H7v7.17C7 21.4 7.6 22 8.33 22h7.33c.74 0 1.34-.6 1.34-1.33V13.5h-2.53z"/><path fill-opacity=".3" d="M15.67 4H14V2h-4v2H8.33C7.6 4 7 4.6 7 5.33v8.17h2.53L13 7v5.5h2l-.53 1H17V5.33C17 4.6 16.4 4 15.67 4z"/></g><g id="battery-charging-60"><path fill-opacity=".3" d="M15.67 4H14V2h-4v2H8.33C7.6 4 7 4.6 7 5.33V11h3.87L13 7v4h4V5.33C17 4.6 16.4 4 15.67 4z"/><path d="M13 12.5h2L11 20v-5.5H9l1.87-3.5H7v9.67C7 21.4 7.6 22 8.33 22h7.33c.74 0 1.34-.6 1.34-1.33V11h-4v1.5z"/></g><g id="battery-charging-80"><path fill-opacity=".3" d="M15.67 4H14V2h-4v2H8.33C7.6 4 7 4.6 7 5.33V9h4.93L13 7v2h4V5.33C17 4.6 16.4 4 15.67 4z"/><path d="M13 12.5h2L11 20v-5.5H9L11.93 9H7v11.67C7 21.4 7.6 22 8.33 22h7.33c.74 0 1.34-.6 1.34-1.33V9h-4v3.5z"/></g><g id="battery-charging-90"><path fill-opacity=".3" d="M15.67 4H14V2h-4v2H8.33C7.6 4 7 4.6 7 5.33V8h5.47L13 7v1h4V5.33C17 4.6 16.4 4 15.67 4z"/><path d="M13 12.5h2L11 20v-5.5H9L12.47 8H7v12.67C7 21.4 7.6 22 8.33 22h7.33c.74 0 1.34-.6 1.34-1.33V8h-4v4.5z"/></g><g id="battery-charging-full"><path d="M15.67 4H14V2h-4v2H8.33C7.6 4 7 4.6 7 5.33v15.33C7 21.4 7.6 22 8.33 22h7.33c.74 0 1.34-.6 1.34-1.33V5.33C17 4.6 16.4 4 15.67 4zM11 20v-5.5H9L13 7v5.5h2L11 20z"/></g><g id="battery-full"><path d="M15.67 4H14V2h-4v2H8.33C7.6 4 7 4.6 7 5.33v15.33C7 21.4 7.6 22 8.33 22h7.33c.74 0 1.34-.6 1.34-1.33V5.33C17 4.6 16.4 4 15.67 4z"/></g><g id="battery-std"><path d="M15.67 4H14V2h-4v2H8.33C7.6 4 7 4.6 7 5.33v15.33C7 21.4 7.6 22 8.33 22h7.33c.74 0 1.34-.6 1.34-1.33V5.33C17 4.6 16.4 4 15.67 4z"/></g><g id="battery-unknown"><path d="M15.67 4H14V2h-4v2H8.33C7.6 4 7 4.6 7 5.33v15.33C7 21.4 7.6 22 8.33 22h7.33c.74 0 1.34-.6 1.34-1.33V5.33C17 4.6 16.4 4 15.67 4zm-2.72 13.95h-1.9v-1.9h1.9v1.9zm1.35-5.26s-.38.42-.67.71c-.48.48-.83 1.15-.83 1.6h-1.6c0-.83.46-1.52.93-2l.93-.94c.27-.27.44-.65.44-1.06 0-.83-.67-1.5-1.5-1.5s-1.5.67-1.5 1.5H9c0-1.66 1.34-3 3-3s3 1.34 3 3c0 .66-.27 1.26-.7 1.69z"/></g><g id="bluetooth"><path d="M17.71 7.71L12 2h-1v7.59L6.41 5 5 6.41 10.59 12 5 17.59 6.41 19 11 14.41V22h1l5.71-5.71-4.3-4.29 4.3-4.29zM13 5.83l1.88 1.88L13 9.59V5.83zm1.88 10.46L13 18.17v-3.76l1.88 1.88z"/></g><g id="bluetooth-connected"><path d="M7 12l-2-2-2 2 2 2 2-2zm10.71-4.29L12 2h-1v7.59L6.41 5 5 6.41 10.59 12 5 17.59 6.41 19 11 14.41V22h1l5.71-5.71-4.3-4.29 4.3-4.29zM13 5.83l1.88 1.88L13 9.59V5.83zm1.88 10.46L13 18.17v-3.76l1.88 1.88zM19 10l-2 2 2 2 2-2-2-2z"/></g><g id="bluetooth-disabled"><path d="M13 5.83l1.88 1.88-1.6 1.6 1.41 1.41 3.02-3.02L12 2h-1v5.03l2 2v-3.2zM5.41 4L4 5.41 10.59 12 5 17.59 6.41 19 11 14.41V22h1l4.29-4.29 2.3 2.29L20 18.59 5.41 4zM13 18.17v-3.76l1.88 1.88L13 18.17z"/></g><g id="bluetooth-searching"><path d="M14.24 12.01l2.32 2.32c.28-.72.44-1.51.44-2.33 0-.82-.16-1.59-.43-2.31l-2.33 2.32zm5.29-5.3l-1.26 1.26c.63 1.21.98 2.57.98 4.02s-.36 2.82-.98 4.02l1.2 1.2c.97-1.54 1.54-3.36 1.54-5.31-.01-1.89-.55-3.67-1.48-5.19zm-3.82 1L10 2H9v7.59L4.41 5 3 6.41 8.59 12 3 17.59 4.41 19 9 14.41V22h1l5.71-5.71-4.3-4.29 4.3-4.29zM11 5.83l1.88 1.88L11 9.59V5.83zm1.88 10.46L11 18.17v-3.76l1.88 1.88z"/></g><g id="brightness-auto"><path d="M10.85 12.65h2.3L12 9l-1.15 3.65zM20 8.69V4h-4.69L12 .69 8.69 4H4v4.69L.69 12 4 15.31V20h4.69L12 23.31 15.31 20H20v-4.69L23.31 12 20 8.69zM14.3 16l-.7-2h-3.2l-.7 2H7.8L11 7h2l3.2 9h-1.9z"/></g><g id="brightness-high"><path d="M20 8.69V4h-4.69L12 .69 8.69 4H4v4.69L.69 12 4 15.31V20h4.69L12 23.31 15.31 20H20v-4.69L23.31 12 20 8.69zM12 18c-3.31 0-6-2.69-6-6s2.69-6 6-6 6 2.69 6 6-2.69 6-6 6zm0-10c-2.21 0-4 1.79-4 4s1.79 4 4 4 4-1.79 4-4-1.79-4-4-4z"/></g><g id="brightness-low"><path d="M20 15.31L23.31 12 20 8.69V4h-4.69L12 .69 8.69 4H4v4.69L.69 12 4 15.31V20h4.69L12 23.31 15.31 20H20v-4.69zM12 18c-3.31 0-6-2.69-6-6s2.69-6 6-6 6 2.69 6 6-2.69 6-6 6z"/></g><g id="brightness-medium"><path d="M20 15.31L23.31 12 20 8.69V4h-4.69L12 .69 8.69 4H4v4.69L.69 12 4 15.31V20h4.69L12 23.31 15.31 20H20v-4.69zM12 18V6c3.31 0 6 2.69 6 6s-2.69 6-6 6z"/></g><g id="data-usage"><path d="M13 2.05v3.03c3.39.49 6 3.39 6 6.92 0 .9-.18 1.75-.48 2.54l2.6 1.53c.56-1.24.88-2.62.88-4.07 0-5.18-3.95-9.45-9-9.95zM12 19c-3.87 0-7-3.13-7-7 0-3.53 2.61-6.43 6-6.92V2.05c-5.06.5-9 4.76-9 9.95 0 5.52 4.47 10 9.99 10 3.31 0 6.24-1.61 8.06-4.09l-2.6-1.53C16.17 17.98 14.21 19 12 19z"/></g><g id="developer-mode"><path d="M7 5h10v2h2V3c0-1.1-.9-1.99-2-1.99L7 1c-1.1 0-2 .9-2 2v4h2V5zm8.41 11.59L20 12l-4.59-4.59L14 8.83 17.17 12 14 15.17l1.41 1.42zM10 15.17L6.83 12 10 8.83 8.59 7.41 4 12l4.59 4.59L10 15.17zM17 19H7v-2H5v4c0 1.1.9 2 2 2h10c1.1 0 2-.9 2-2v-4h-2v2z"/></g><g id="devices"><path d="M4 6h18V4H4c-1.1 0-2 .9-2 2v11H0v3h14v-3H4V6zm19 2h-6c-.55 0-1 .45-1 1v10c0 .55.45 1 1 1h6c.55 0 1-.45 1-1V9c0-.55-.45-1-1-1zm-1 9h-4v-7h4v7z"/></g><g id="dvr"><path d="M21 3H3c-1.1 0-2 .9-2 2v12c0 1.1.9 2 2 2h5v2h8v-2h5c1.1 0 1.99-.9 1.99-2L23 5c0-1.1-.9-2-2-2zm0 14H3V5h18v12zm-2-9H8v2h11V8zm0 4H8v2h11v-2zM7 8H5v2h2V8zm0 4H5v2h2v-2z"/></g><g id="gps-fixed"><path d="M12 8c-2.21 0-4 1.79-4 4s1.79 4 4 4 4-1.79 4-4-1.79-4-4-4zm8.94 3c-.46-4.17-3.77-7.48-7.94-7.94V1h-2v2.06C6.83 3.52 3.52 6.83 3.06 11H1v2h2.06c.46 4.17 3.77 7.48 7.94 7.94V23h2v-2.06c4.17-.46 7.48-3.77 7.94-7.94H23v-2h-2.06zM12 19c-3.87 0-7-3.13-7-7s3.13-7 7-7 7 3.13 7 7-3.13 7-7 7z"/></g><g id="gps-not-fixed"><path d="M20.94 11c-.46-4.17-3.77-7.48-7.94-7.94V1h-2v2.06C6.83 3.52 3.52 6.83 3.06 11H1v2h2.06c.46 4.17 3.77 7.48 7.94 7.94V23h2v-2.06c4.17-.46 7.48-3.77 7.94-7.94H23v-2h-2.06zM12 19c-3.87 0-7-3.13-7-7s3.13-7 7-7 7 3.13 7 7-3.13 7-7 7z"/></g><g id="gps-off"><path d="M20.94 11c-.46-4.17-3.77-7.48-7.94-7.94V1h-2v2.06c-1.13.12-2.19.46-3.16.97l1.5 1.5C10.16 5.19 11.06 5 12 5c3.87 0 7 3.13 7 7 0 .94-.19 1.84-.52 2.65l1.5 1.5c.5-.96.84-2.02.97-3.15H23v-2h-2.06zM3 4.27l2.04 2.04C3.97 7.62 3.25 9.23 3.06 11H1v2h2.06c.46 4.17 3.77 7.48 7.94 7.94V23h2v-2.06c1.77-.2 3.38-.91 4.69-1.98L19.73 21 21 19.73 4.27 3 3 4.27zm13.27 13.27C15.09 18.45 13.61 19 12 19c-3.87 0-7-3.13-7-7 0-1.61.55-3.09 1.46-4.27l9.81 9.81z"/></g><g id="location-disabled"><path d="M20.94 11c-.46-4.17-3.77-7.48-7.94-7.94V1h-2v2.06c-1.13.12-2.19.46-3.16.97l1.5 1.5C10.16 5.19 11.06 5 12 5c3.87 0 7 3.13 7 7 0 .94-.19 1.84-.52 2.65l1.5 1.5c.5-.96.84-2.02.97-3.15H23v-2h-2.06zM3 4.27l2.04 2.04C3.97 7.62 3.25 9.23 3.06 11H1v2h2.06c.46 4.17 3.77 7.48 7.94 7.94V23h2v-2.06c1.77-.2 3.38-.91 4.69-1.98L19.73 21 21 19.73 4.27 3 3 4.27zm13.27 13.27C15.09 18.45 13.61 19 12 19c-3.87 0-7-3.13-7-7 0-1.61.55-3.09 1.46-4.27l9.81 9.81z"/></g><g id="location-searching"><path d="M20.94 11c-.46-4.17-3.77-7.48-7.94-7.94V1h-2v2.06C6.83 3.52 3.52 6.83 3.06 11H1v2h2.06c.46 4.17 3.77 7.48 7.94 7.94V23h2v-2.06c4.17-.46 7.48-3.77 7.94-7.94H23v-2h-2.06zM12 19c-3.87 0-7-3.13-7-7s3.13-7 7-7 7 3.13 7 7-3.13 7-7 7z"/></g><g id="multitrack-audio"><path d="M7 18h2V6H7v12zm4 4h2V2h-2v20zm-8-8h2v-4H3v4zm12 4h2V6h-2v12zm4-8v4h2v-4h-2z"/></g><g id="network-cell"><path fill-opacity=".3" d="M2 22h20V2z"/><path d="M17 7L2 22h15z"/></g><g id="network-wifi"><path fill-opacity=".3" d="M12.01 21.49L23.64 7c-.45-.34-4.93-4-11.64-4C5.28 3 .81 6.66.36 7l11.63 14.49.01.01.01-.01z"/><path d="M3.53 10.95l8.46 10.54.01.01.01-.01 8.46-10.54C20.04 10.62 16.81 8 12 8c-4.81 0-8.04 2.62-8.47 2.95z"/></g><g id="nfc"><path d="M20 2H4c-1.1 0-2 .9-2 2v16c0 1.1.9 2 2 2h16c1.1 0 2-.9 2-2V4c0-1.1-.9-2-2-2zm0 18H4V4h16v16zM18 6h-5c-1.1 0-2 .9-2 2v2.28c-.6.35-1 .98-1 1.72 0 1.1.9 2 2 2s2-.9 2-2c0-.74-.4-1.38-1-1.72V8h3v8H8V8h2V6H6v12h12V6z"/></g><g id="now-wallpaper"><path d="M4 4h7V2H4c-1.1 0-2 .9-2 2v7h2V4zm6 9l-4 5h12l-3-4-2.03 2.71L10 13zm7-4.5c0-.83-.67-1.5-1.5-1.5S14 7.67 14 8.5s.67 1.5 1.5 1.5S17 9.33 17 8.5zM20 2h-7v2h7v7h2V4c0-1.1-.9-2-2-2zm0 18h-7v2h7c1.1 0 2-.9 2-2v-7h-2v7zM4 13H2v7c0 1.1.9 2 2 2h7v-2H4v-7z"/></g><g id="now-widgets"><path d="M13 13v8h8v-8h-8zM3 21h8v-8H3v8zM3 3v8h8V3H3zm13.66-1.31L11 7.34 16.66 13l5.66-5.66-5.66-5.65z"/></g><g id="screen-lock-landscape"><path d="M21 5H3c-1.1 0-2 .9-2 2v10c0 1.1.9 2 2 2h18c1.1 0 2-.9 2-2V7c0-1.1-.9-2-2-2zm-2 12H5V7h14v10zm-9-1h4c.55 0 1-.45 1-1v-3c0-.55-.45-1-1-1v-1c0-1.11-.9-2-2-2-1.11 0-2 .9-2 2v1c-.55 0-1 .45-1 1v3c0 .55.45 1 1 1zm.8-6c0-.66.54-1.2 1.2-1.2.66 0 1.2.54 1.2 1.2v1h-2.4v-1z"/></g><g id="screen-lock-portrait"><path d="M10 16h4c.55 0 1-.45 1-1v-3c0-.55-.45-1-1-1v-1c0-1.11-.9-2-2-2-1.11 0-2 .9-2 2v1c-.55 0-1 .45-1 1v3c0 .55.45 1 1 1zm.8-6c0-.66.54-1.2 1.2-1.2.66 0 1.2.54 1.2 1.2v1h-2.4v-1zM17 1H7c-1.1 0-2 .9-2 2v18c0 1.1.9 2 2 2h10c1.1 0 2-.9 2-2V3c0-1.1-.9-2-2-2zm0 18H7V5h10v14z"/></g><g id="screen-lock-rotation"><path d="M23.25 12.77l-2.57-2.57-1.41 1.41 2.22 2.22-5.66 5.66L4.51 8.17l5.66-5.66 2.1 2.1 1.41-1.41L11.23.75c-.59-.59-1.54-.59-2.12 0L2.75 7.11c-.59.59-.59 1.54 0 2.12l12.02 12.02c.59.59 1.54.59 2.12 0l6.36-6.36c.59-.59.59-1.54 0-2.12zM8.47 20.48C5.2 18.94 2.86 15.76 2.5 12H1c.51 6.16 5.66 11 11.95 11l.66-.03-3.81-3.82-1.33 1.33zM16 9h5c.55 0 1-.45 1-1V4c0-.55-.45-1-1-1v-.5C21 1.12 19.88 0 18.5 0S16 1.12 16 2.5V3c-.55 0-1 .45-1 1v4c0 .55.45 1 1 1zm.8-6.5c0-.94.76-1.7 1.7-1.7s1.7.76 1.7 1.7V3h-3.4v-.5z"/></g><g id="screen-rotation"><path d="M16.48 2.52c3.27 1.55 5.61 4.72 5.97 8.48h1.5C23.44 4.84 18.29 0 12 0l-.66.03 3.81 3.81 1.33-1.32zm-6.25-.77c-.59-.59-1.54-.59-2.12 0L1.75 8.11c-.59.59-.59 1.54 0 2.12l12.02 12.02c.59.59 1.54.59 2.12 0l6.36-6.36c.59-.59.59-1.54 0-2.12L10.23 1.75zm4.6 19.44L2.81 9.17l6.36-6.36 12.02 12.02-6.36 6.36zm-7.31.29C4.25 19.94 1.91 16.76 1.55 13H.05C.56 19.16 5.71 24 12 24l.66-.03-3.81-3.81-1.33 1.32z"/></g><g id="sd-storage"><path d="M18 2h-8L4.02 8 4 20c0 1.1.9 2 2 2h12c1.1 0 2-.9 2-2V4c0-1.1-.9-2-2-2zm-6 6h-2V4h2v4zm3 0h-2V4h2v4zm3 0h-2V4h2v4z"/></g><g id="settings-system-daydream"><path d="M9 16h6.5c1.38 0 2.5-1.12 2.5-2.5S16.88 11 15.5 11h-.05c-.24-1.69-1.69-3-3.45-3-1.4 0-2.6.83-3.16 2.02h-.16C7.17 10.18 6 11.45 6 13c0 1.66 1.34 3 3 3zM21 3H3c-1.1 0-2 .9-2 2v14c0 1.1.9 2 2 2h18c1.1 0 2-.9 2-2V5c0-1.1-.9-2-2-2zm0 16.01H3V4.99h18v14.02z"/></g><g id="signal-cellular-0-bar"><path fill-opacity=".3" d="M2 22h20V2z"/></g><g id="signal-cellular-1-bar"><path fill-opacity=".3" d="M2 22h20V2z"/><path d="M12 12L2 22h10z"/></g><g id="signal-cellular-2-bar"><path fill-opacity=".3" d="M2 22h20V2z"/><path d="M14 10L2 22h12z"/></g><g id="signal-cellular-3-bar"><path fill-opacity=".3" d="M2 22h20V2z"/><path d="M17 7L2 22h15z"/></g><g id="signal-cellular-4-bar"><path d="M2 22h20V2z"/></g><g id="signal-cellular-connected-no-internet-0-bar"><path fill-opacity=".3" d="M22 8V2L2 22h16V8z"/><path d="M20 22h2v-2h-2v2zm0-12v8h2v-8h-2z"/></g><g id="signal-cellular-connected-no-internet-1-bar"><path fill-opacity=".3" d="M22 8V2L2 22h16V8z"/><path d="M20 10v8h2v-8h-2zm-8 12V12L2 22h10zm8 0h2v-2h-2v2z"/></g><g id="signal-cellular-connected-no-internet-2-bar"><path fill-opacity=".3" d="M22 8V2L2 22h16V8z"/><path d="M14 22V10L2 22h12zm6-12v8h2v-8h-2zm0 12h2v-2h-2v2z"/></g><g id="signal-cellular-connected-no-internet-3-bar"><path fill-opacity=".3" d="M22 8V2L2 22h16V8z"/><path d="M17 22V7L2 22h15zm3-12v8h2v-8h-2zm0 12h2v-2h-2v2z"/></g><g id="signal-cellular-connected-no-internet-4-bar"><path d="M20 18h2v-8h-2v8zm0 4h2v-2h-2v2zM2 22h16V8h4V2L2 22z"/></g><g id="signal-cellular-no-sim"><path d="M18.99 5c0-1.1-.89-2-1.99-2h-7L7.66 5.34 19 16.68 18.99 5zM3.65 3.88L2.38 5.15 5 7.77V19c0 1.1.9 2 2 2h10.01c.35 0 .67-.1.96-.26l1.88 1.88 1.27-1.27L3.65 3.88z"/></g><g id="signal-cellular-null"><path d="M20 6.83V20H6.83L20 6.83M22 2L2 22h20V2z"/></g><g id="signal-cellular-off"><path d="M21 1l-8.59 8.59L21 18.18V1zM4.77 4.5L3.5 5.77l6.36 6.36L1 21h17.73l2 2L22 21.73 4.77 4.5z"/></g><g id="signal-wifi-0-bar"><path fill-opacity=".3" d="M12.01 21.49L23.64 7c-.45-.34-4.93-4-11.64-4C5.28 3 .81 6.66.36 7l11.63 14.49.01.01.01-.01z"/></g><g id="signal-wifi-1-bar"><path fill-opacity=".3" d="M12.01 21.49L23.64 7c-.45-.34-4.93-4-11.64-4C5.28 3 .81 6.66.36 7l11.63 14.49.01.01.01-.01z"/><path d="M6.67 14.86L12 21.49v.01l.01-.01 5.33-6.63C17.06 14.65 15.03 13 12 13s-5.06 1.65-5.33 1.86z"/></g><g id="signal-wifi-2-bar"><path fill-opacity=".3" d="M12.01 21.49L23.64 7c-.45-.34-4.93-4-11.64-4C5.28 3 .81 6.66.36 7l11.63 14.49.01.01.01-.01z"/><path d="M4.79 12.52l7.2 8.98H12l.01-.01 7.2-8.98C18.85 12.24 16.1 10 12 10s-6.85 2.24-7.21 2.52z"/></g><g id="signal-wifi-3-bar"><path fill-opacity=".3" d="M12.01 21.49L23.64 7c-.45-.34-4.93-4-11.64-4C5.28 3 .81 6.66.36 7l11.63 14.49.01.01.01-.01z"/><path d="M3.53 10.95l8.46 10.54.01.01.01-.01 8.46-10.54C20.04 10.62 16.81 8 12 8c-4.81 0-8.04 2.62-8.47 2.95z"/></g><g id="signal-wifi-4-bar"><path d="M12.01 21.49L23.64 7c-.45-.34-4.93-4-11.64-4C5.28 3 .81 6.66.36 7l11.63 14.49.01.01.01-.01z"/></g><g id="signal-wifi-off"><path d="M23.64 7c-.45-.34-4.93-4-11.64-4-1.5 0-2.89.19-4.15.48L18.18 13.8 23.64 7zm-6.6 8.22L3.27 1.44 2 2.72l2.05 2.06C1.91 5.76.59 6.82.36 7l11.63 14.49.01.01.01-.01 3.9-4.86 3.32 3.32 1.27-1.27-3.46-3.46z"/></g><g id="storage"><path d="M2 20h20v-4H2v4zm2-3h2v2H4v-2zM2 4v4h20V4H2zm4 3H4V5h2v2zm-4 7h20v-4H2v4zm2-3h2v2H4v-2z"/></g><g id="usb"><path d="M15 7v4h1v2h-3V5h2l-3-4-3 4h2v8H8v-2.07c.7-.37 1.2-1.08 1.2-1.93 0-1.21-.99-2.2-2.2-2.2-1.21 0-2.2.99-2.2 2.2 0 .85.5 1.56 1.2 1.93V13c0 1.11.89 2 2 2h3v3.05c-.71.37-1.2 1.1-1.2 1.95 0 1.22.99 2.2 2.2 2.2 1.21 0 2.2-.98 2.2-2.2 0-.85-.49-1.58-1.2-1.95V15h3c1.11 0 2-.89 2-2v-2h1V7h-4z"/></g><g id="wifi-lock"><path d="M20.5 9.5c.28 0 .55.04.81.08L24 6c-3.34-2.51-7.5-4-12-4S3.34 3.49 0 6l12 16 3.5-4.67V14.5c0-2.76 2.24-5 5-5zM23 16v-1.5c0-1.38-1.12-2.5-2.5-2.5S18 13.12 18 14.5V16c-.55 0-1 .45-1 1v4c0 .55.45 1 1 1h5c.55 0 1-.45 1-1v-4c0-.55-.45-1-1-1zm-1 0h-3v-1.5c0-.83.67-1.5 1.5-1.5s1.5.67 1.5 1.5V16z"/></g><g id="wifi-tethering"><path d="M12 11c-1.1 0-2 .9-2 2s.9 2 2 2 2-.9 2-2-.9-2-2-2zm6 2c0-3.31-2.69-6-6-6s-6 2.69-6 6c0 2.22 1.21 4.15 3 5.19l1-1.74c-1.19-.7-2-1.97-2-3.45 0-2.21 1.79-4 4-4s4 1.79 4 4c0 1.48-.81 2.75-2 3.45l1 1.74c1.79-1.04 3-2.97 3-5.19zM12 3C6.48 3 2 7.48 2 13c0 3.7 2.01 6.92 4.99 8.65l1-1.73C5.61 18.53 4 15.96 4 13c0-4.42 3.58-8 8-8s8 3.58 8 8c0 2.96-1.61 5.53-4 6.92l1 1.73c2.99-1.73 5-4.95 5-8.65 0-5.52-4.48-10-10-10z"/></g></defs></svg>',
    'img/icons/sets/social-icons.svg' : '<svg><defs><g id="cake"><path d="M12 6c1.11 0 2-.9 2-2 0-.38-.1-.73-.29-1.03L12 0l-1.71 2.97c-.19.3-.29.65-.29 1.03 0 1.1.9 2 2 2zm4.6 9.99l-1.07-1.07-1.08 1.07c-1.3 1.3-3.58 1.31-4.89 0l-1.07-1.07-1.09 1.07C6.75 16.64 5.88 17 4.96 17c-.73 0-1.4-.23-1.96-.61V21c0 .55.45 1 1 1h16c.55 0 1-.45 1-1v-4.61c-.56.38-1.23.61-1.96.61-.92 0-1.79-.36-2.44-1.01zM18 9h-5V7h-2v2H6c-1.66 0-3 1.34-3 3v1.54c0 1.08.88 1.96 1.96 1.96.52 0 1.02-.2 1.38-.57l2.14-2.13 2.13 2.13c.74.74 2.03.74 2.77 0l2.14-2.13 2.13 2.13c.37.37.86.57 1.38.57 1.08 0 1.96-.88 1.96-1.96V12C21 10.34 19.66 9 18 9z"/></g><g id="domain"><path d="M12 7V3H2v18h20V7H12zM6 19H4v-2h2v2zm0-4H4v-2h2v2zm0-4H4V9h2v2zm0-4H4V5h2v2zm4 12H8v-2h2v2zm0-4H8v-2h2v2zm0-4H8V9h2v2zm0-4H8V5h2v2zm10 12h-8v-2h2v-2h-2v-2h2v-2h-2V9h8v10zm-2-8h-2v2h2v-2zm0 4h-2v2h2v-2z"/></g><g id="group"><path d="M16 11c1.66 0 2.99-1.34 2.99-3S17.66 5 16 5c-1.66 0-3 1.34-3 3s1.34 3 3 3zm-8 0c1.66 0 2.99-1.34 2.99-3S9.66 5 8 5C6.34 5 5 6.34 5 8s1.34 3 3 3zm0 2c-2.33 0-7 1.17-7 3.5V19h14v-2.5c0-2.33-4.67-3.5-7-3.5zm8 0c-.29 0-.62.02-.97.05 1.16.84 1.97 1.97 1.97 3.45V19h6v-2.5c0-2.33-4.67-3.5-7-3.5z"/></g><g id="group-add"><path d="M8 10H5V7H3v3H0v2h3v3h2v-3h3v-2zm10 1c1.66 0 2.99-1.34 2.99-3S19.66 5 18 5c-.32 0-.63.05-.91.14.57.81.9 1.79.9 2.86s-.34 2.04-.9 2.86c.28.09.59.14.91.14zm-5 0c1.66 0 2.99-1.34 2.99-3S14.66 5 13 5c-1.66 0-3 1.34-3 3s1.34 3 3 3zm6.62 2.16c.83.73 1.38 1.66 1.38 2.84v2h3v-2c0-1.54-2.37-2.49-4.38-2.84zM13 13c-2 0-6 1-6 3v2h12v-2c0-2-4-3-6-3z"/></g><g id="location-city"><path d="M15 11V5l-3-3-3 3v2H3v14h18V11h-6zm-8 8H5v-2h2v2zm0-4H5v-2h2v2zm0-4H5V9h2v2zm6 8h-2v-2h2v2zm0-4h-2v-2h2v2zm0-4h-2V9h2v2zm0-4h-2V5h2v2zm6 12h-2v-2h2v2zm0-4h-2v-2h2v2z"/></g><g id="mood"><path d="M11.99 2C6.47 2 2 6.48 2 12s4.47 10 9.99 10C17.52 22 22 17.52 22 12S17.52 2 11.99 2zM12 20c-4.42 0-8-3.58-8-8s3.58-8 8-8 8 3.58 8 8-3.58 8-8 8zm3.5-9c.83 0 1.5-.67 1.5-1.5S16.33 8 15.5 8 14 8.67 14 9.5s.67 1.5 1.5 1.5zm-7 0c.83 0 1.5-.67 1.5-1.5S9.33 8 8.5 8 7 8.67 7 9.5 7.67 11 8.5 11zm3.5 6.5c2.33 0 4.31-1.46 5.11-3.5H6.89c.8 2.04 2.78 3.5 5.11 3.5z"/></g><g id="notifications"><path d="M11.5 22c1.1 0 2-.9 2-2h-4c0 1.1.9 2 2 2zm6.5-6v-5.5c0-3.07-2.13-5.64-5-6.32V3.5c0-.83-.67-1.5-1.5-1.5S10 2.67 10 3.5v.68c-2.87.68-5 3.25-5 6.32V16l-2 2v1h17v-1l-2-2z"/></g><g id="notifications-none"><path d="M11.5 22c1.1 0 2-.9 2-2h-4c0 1.1.9 2 2 2zm6.5-6v-5.5c0-3.07-2.13-5.64-5-6.32V3.5c0-.83-.67-1.5-1.5-1.5S10 2.67 10 3.5v.68c-2.87.68-5 3.25-5 6.32V16l-2 2v1h17v-1l-2-2zm-2 1H7v-6.5C7 8.01 9.01 6 11.5 6S16 8.01 16 10.5V17z"/></g><g id="notifications-off"><path d="M11.5 22c1.1 0 2-.9 2-2h-4c0 1.1.9 2 2 2zM18 10.5c0-3.07-2.13-5.64-5-6.32V3.5c0-.83-.67-1.5-1.5-1.5S10 2.67 10 3.5v.68c-.51.12-.99.32-1.45.56L18 14.18V10.5zm-.27 8.5l2 2L21 19.73 4.27 3 3 4.27l2.92 2.92C5.34 8.16 5 9.29 5 10.5V16l-2 2v1h14.73z"/></g><g id="notifications-on"><path d="M6.58 3.58L5.15 2.15C2.76 3.97 1.18 6.8 1.03 10h2c.15-2.65 1.51-4.97 3.55-6.42zM19.97 10h2c-.15-3.2-1.73-6.03-4.13-7.85l-1.43 1.43c2.05 1.45 3.41 3.77 3.56 6.42zm-1.97.5c0-3.07-2.13-5.64-5-6.32V3.5c0-.83-.67-1.5-1.5-1.5S10 2.67 10 3.5v.68c-2.87.68-5 3.25-5 6.32V16l-2 2v1h17v-1l-2-2v-5.5zM11.5 22c.14 0 .27-.01.4-.04.65-.13 1.19-.58 1.44-1.18.1-.24.16-.5.16-.78h-4c0 1.1.9 2 2 2z"/></g><g id="notifications-paused"><path d="M11.5 22c1.1 0 2-.9 2-2h-4c0 1.1.9 2 2 2zm6.5-6v-5.5c0-3.07-2.13-5.64-5-6.32V3.5c0-.83-.67-1.5-1.5-1.5S10 2.67 10 3.5v.68c-2.87.68-5 3.25-5 6.32V16l-2 2v1h17v-1l-2-2zm-4-6.2l-2.8 3.4H14V15H9v-1.8l2.8-3.4H9V8h5v1.8z"/></g><g id="pages"><path d="M3 5v6h5L7 7l4 1V3H5c-1.1 0-2 .9-2 2zm5 8H3v6c0 1.1.9 2 2 2h6v-5l-4 1 1-4zm9 4l-4-1v5h6c1.1 0 2-.9 2-2v-6h-5l1 4zm2-14h-6v5l4-1-1 4h5V5c0-1.1-.9-2-2-2z"/></g><g id="party-mode"><path d="M20 4h-3.17L15 2H9L7.17 4H4c-1.1 0-2 .9-2 2v12c0 1.1.9 2 2 2h16c1.1 0 2-.9 2-2V6c0-1.1-.9-2-2-2zm-8 3c1.63 0 3.06.79 3.98 2H12c-1.66 0-3 1.34-3 3 0 .35.07.69.18 1H7.1c-.06-.32-.1-.66-.1-1 0-2.76 2.24-5 5-5zm0 10c-1.63 0-3.06-.79-3.98-2H12c1.66 0 3-1.34 3-3 0-.35-.07-.69-.18-1h2.08c.07.32.1.66.1 1 0 2.76-2.24 5-5 5z"/></g><g id="people"><path d="M16 11c1.66 0 2.99-1.34 2.99-3S17.66 5 16 5c-1.66 0-3 1.34-3 3s1.34 3 3 3zm-8 0c1.66 0 2.99-1.34 2.99-3S9.66 5 8 5C6.34 5 5 6.34 5 8s1.34 3 3 3zm0 2c-2.33 0-7 1.17-7 3.5V19h14v-2.5c0-2.33-4.67-3.5-7-3.5zm8 0c-.29 0-.62.02-.97.05 1.16.84 1.97 1.97 1.97 3.45V19h6v-2.5c0-2.33-4.67-3.5-7-3.5z"/></g><g id="people-outline"><path d="M16.5 13c-1.2 0-3.07.34-4.5 1-1.43-.67-3.3-1-4.5-1C5.33 13 1 14.08 1 16.25V19h22v-2.75c0-2.17-4.33-3.25-6.5-3.25zm-4 4.5h-10v-1.25c0-.54 2.56-1.75 5-1.75s5 1.21 5 1.75v1.25zm9 0H14v-1.25c0-.46-.2-.86-.52-1.22.88-.3 1.96-.53 3.02-.53 2.44 0 5 1.21 5 1.75v1.25zM7.5 12c1.93 0 3.5-1.57 3.5-3.5S9.43 5 7.5 5 4 6.57 4 8.5 5.57 12 7.5 12zm0-5.5c1.1 0 2 .9 2 2s-.9 2-2 2-2-.9-2-2 .9-2 2-2zm9 5.5c1.93 0 3.5-1.57 3.5-3.5S18.43 5 16.5 5 13 6.57 13 8.5s1.57 3.5 3.5 3.5zm0-5.5c1.1 0 2 .9 2 2s-.9 2-2 2-2-.9-2-2 .9-2 2-2z"/></g><g id="person"><path d="M12 12c2.21 0 4-1.79 4-4s-1.79-4-4-4-4 1.79-4 4 1.79 4 4 4zm0 2c-2.67 0-8 1.34-8 4v2h16v-2c0-2.66-5.33-4-8-4z"/></g><g id="person-add"><path d="M15 12c2.21 0 4-1.79 4-4s-1.79-4-4-4-4 1.79-4 4 1.79 4 4 4zm-9-2V7H4v3H1v2h3v3h2v-3h3v-2H6zm9 4c-2.67 0-8 1.34-8 4v2h16v-2c0-2.66-5.33-4-8-4z"/></g><g id="person-outline"><path d="M12 5.9c1.16 0 2.1.94 2.1 2.1s-.94 2.1-2.1 2.1S9.9 9.16 9.9 8s.94-2.1 2.1-2.1m0 9c2.97 0 6.1 1.46 6.1 2.1v1.1H5.9V17c0-.64 3.13-2.1 6.1-2.1M12 4C9.79 4 8 5.79 8 8s1.79 4 4 4 4-1.79 4-4-1.79-4-4-4zm0 9c-2.67 0-8 1.34-8 4v3h16v-3c0-2.66-5.33-4-8-4z"/></g><g id="plus-one"><path d="M10 8H8v4H4v2h4v4h2v-4h4v-2h-4zm4.5-1.92V7.9l2.5-.5V18h2V5z"/></g><g id="poll"><path d="M19 3H5c-1.1 0-2 .9-2 2v14c0 1.1.9 2 2 2h14c1.1 0 2-.9 2-2V5c0-1.1-.9-2-2-2zM9 17H7v-7h2v7zm4 0h-2V7h2v10zm4 0h-2v-4h2v4z"/></g><g id="public"><path d="M12 2C6.48 2 2 6.48 2 12s4.48 10 10 10 10-4.48 10-10S17.52 2 12 2zm-1 17.93c-3.95-.49-7-3.85-7-7.93 0-.62.08-1.21.21-1.79L9 15v1c0 1.1.9 2 2 2v1.93zm6.9-2.54c-.26-.81-1-1.39-1.9-1.39h-1v-3c0-.55-.45-1-1-1H8v-2h2c.55 0 1-.45 1-1V7h2c1.1 0 2-.9 2-2v-.41c2.93 1.19 5 4.06 5 7.41 0 2.08-.8 3.97-2.1 5.39z"/></g><g id="school"><path d="M5 13.18v4L12 21l7-3.82v-4L12 17l-7-3.82zM12 3L1 9l11 6 9-4.91V17h2V9L12 3z"/></g><g id="share"><path d="M18 16.08c-.76 0-1.44.3-1.96.77L8.91 12.7c.05-.23.09-.46.09-.7s-.04-.47-.09-.7l7.05-4.11c.54.5 1.25.81 2.04.81 1.66 0 3-1.34 3-3s-1.34-3-3-3-3 1.34-3 3c0 .24.04.47.09.7L8.04 9.81C7.5 9.31 6.79 9 6 9c-1.66 0-3 1.34-3 3s1.34 3 3 3c.79 0 1.5-.31 2.04-.81l7.12 4.16c-.05.21-.08.43-.08.65 0 1.61 1.31 2.92 2.92 2.92 1.61 0 2.92-1.31 2.92-2.92s-1.31-2.92-2.92-2.92z"/></g><g id="whatshot"><path d="M13.5.67s.74 2.65.74 4.8c0 2.06-1.35 3.73-3.41 3.73-2.07 0-3.63-1.67-3.63-3.73l.03-.36C5.21 7.51 4 10.62 4 14c0 4.42 3.58 8 8 8s8-3.58 8-8C20 8.61 17.41 3.8 13.5.67zM11.71 19c-1.78 0-3.22-1.4-3.22-3.14 0-1.62 1.05-2.76 2.81-3.12 1.77-.36 3.6-1.21 4.62-2.58.39 1.29.59 2.65.59 4.04 0 2.65-2.15 4.8-4.8 4.8z"/></g></defs></svg>',
    'img/icons/ic_label_24px.svg' : '<?xml version="1.0" encoding="utf-8"?><!-- Generator: Adobe Illustrator 17.1.0, SVG Export Plug-In . SVG Version: 6.00 Build 0) --><!DOCTYPE svg PUBLIC "-//W3C//DTD SVG 1.1//EN" "http://www.w3.org/Graphics/SVG/1.1/DTD/svg11.dtd"><svg version="1.1" xmlns="http://www.w3.org/2000/svg" xmlns:xlink="http://www.w3.org/1999/xlink" x="0px" y="0px" width="24px" height="24px" viewBox="0 0 24 24" enable-background="new 0 0 24 24" xml:space="preserve"><g id="Header"> <g> <rect x="-618" y="-568" fill="none" width="1400" height="3600"/> </g></g><g id="Label"></g><g id="Icon"> <g> <rect fill="none" width="24" height="24"/> <path d="M17.6,5.8C17.3,5.3,16.7,5,16,5L5,5C3.9,5,3,5.9,3,7v10c0,1.1,0.9,2,2,2l11,0c0.7,0,1.3-0.3,1.6-0.8L22,12L17.6,5.8z"/> </g></g><g id="Grid" display="none"> <g display="inline"> </g></g></svg>',
    'img/icons/ic_more_vert_24px.svg' : '<?xml version="1.0" encoding="utf-8"?><!-- Generator: Adobe Illustrator 17.1.0, SVG Export Plug-In . SVG Version: 6.00 Build 0) --><!DOCTYPE svg PUBLIC "-//W3C//DTD SVG 1.1//EN" "http://www.w3.org/Graphics/SVG/1.1/DTD/svg11.dtd"><svg version="1.1" xmlns="http://www.w3.org/2000/svg" xmlns:xlink="http://www.w3.org/1999/xlink" x="0px" y="0px" width="24px" height="24px" viewBox="0 0 24 24" enable-background="new 0 0 24 24" xml:space="preserve"><g id="Header"> <g> <rect x="-618" y="-2488" fill="none" width="1400" height="3600"/> </g></g><g id="Label"></g><g id="Icon"> <g> <rect fill="none" width="24" height="24"/> <path d="M12,8c1.1,0,2-0.9,2-2s-0.9-2-2-2c-1.1,0-2,0.9-2,2S10.9,8,12,8z M12,10c-1.1,0-2,0.9-2,2s0.9,2,2,2c1.1,0,2-0.9,2-2 S13.1,10,12,10z M12,16c-1.1,0-2,0.9-2,2s0.9,2,2,2c1.1,0,2-0.9,2-2S13.1,16,12,16z"/> </g></g><g id="Grid" display="none"> <g display="inline"> </g></g></svg>',
    'img/icons/ic_ondemand_video_24px.svg' : '<svg xmlns="http://www.w3.org/2000/svg" width="24" height="24" viewBox="0 0 24 24"> <path fill="none" d="M0 0h24v24H0V0z"/> <path d="M21 3H3c-1.11 0-2 .89-2 2v12c0 1.1.89 2 2 2h5v2h8v-2h5c1.1 0 1.99-.9 1.99-2L23 5c0-1.11-.9-2-2-2zm0 14H3V5h18v12zm-5-6l-7 4V7z"/></svg>',
    'img/icons/twitter.svg' : '<svg version="1.1" x="0px" y="0px" width="48px" height="48px" viewBox="0 0 48 48" enable-background="new 0 0 48 48" xml:space="preserve"><g><g><g><path fill="#7d7d7d" d="M40,4H8C5.8,4,4,5.8,4,8l0,32c0,2.2,1.8,4,4,4h32c2.2,0,4-1.8,4-4V8C44,5.8,42.2,4,40,4z M35.4,18.7c-0.1,9.2-6,15.6-14.8,16c-3.6,0.2-6.3-1-8.6-2.5c2.7,0.4,6-0.6,7.8-2.2c-2.6-0.3-4.2-1.6-4.9-3.8c0.8,0.1,1.6,0.1,2.3-0.1c-2.4-0.8-4.1-2.3-4.2-5.3c0.7,0.3,1.4,0.6,2.3,0.6c-1.8-1-3.1-4.7-1.6-7.2c2.6,2.9,5.8,5.3,11,5.6c-1.3-5.6,6.1-8.6,9.2-4.9c1.3-0.3,2.4-0.8,3.4-1.3c-0.4,1.3-1.2,2.2-2.2,2.9c1.1-0.1,2.1-0.4,2.9-0.8C37.5,16.9,36.4,17.9,35.4,18.7z"/></g><g><rect fill="none" width="48" height="48"/></g></g></g></svg>',
    'img/icons/addShoppingCart.svg' : '<svg xmlns="http://www.w3.org/2000/svg" viewBox="0 0 24 24"><g id="addShoppingCart"><g id="add-shopping-cart"><path d="M11 9h2V6h3V4h-3V1h-2v3H8v2h3v3zm-4 9c-1.1 0-1.99.9-1.99 2S5.9 22 7 22s2-.9 2-2-.9-2-2-2zm10 0c-1.1 0-1.99.9-1.99 2s.89 2 1.99 2 2-.9 2-2-.9-2-2-2zm-9.83-3.25l.03-.12.9-1.63h7.45c.75 0 1.41-.41 1.75-1.03l3.86-7.01L19.42 4h-.01l-1.1 2-2.76 5H8.53l-.13-.27L6.16 6l-.95-2-.94-2H1v2h2l3.6 7.59-1.35 2.45c-.16.28-.25.61-.25.96 0 1.1.9 2 2 2h12v-2H7.42c-.13 0-.25-.11-.25-.25z"/></g></svg>',
    'img/icons/ic_close_24px.svg' : '<svg xmlns="http://www.w3.org/2000/svg" width="24" height="24" viewBox="0 0 24 24"><path d="M19 6.41L17.59 5 12 10.59 6.41 5 5 6.41 10.59 12 5 17.59 6.41 19 12 13.41 17.59 19 19 17.59 13.41 12z"/></svg>',
    'img/icons/ic_visibility_24px.svg' : '<?xml version="1.0" encoding="utf-8"?><!-- Generator: Adobe Illustrator 17.1.0, SVG Export Plug-In . SVG Version: 6.00 Build 0) --><!DOCTYPE svg PUBLIC "-//W3C//DTD SVG 1.1//EN" "http://www.w3.org/Graphics/SVG/1.1/DTD/svg11.dtd"><svg version="1.1" xmlns="http://www.w3.org/2000/svg" xmlns:xlink="http://www.w3.org/1999/xlink" x="0px" y="0px" width="24px" height="24px" viewBox="0 0 24 24" enable-background="new 0 0 24 24" xml:space="preserve"><g id="Header"> <g> <rect x="-618" y="-1592" fill="none" width="1400" height="3600"/> </g></g><g id="Label"></g><g id="Icon"> <g> <rect fill="none" width="24" height="24"/> <path d="M12,4.5C7,4.5,2.7,7.6,1,12c1.7,4.4,6,7.5,11,7.5c5,0,9.3-3.1,11-7.5C21.3,7.6,17,4.5,12,4.5z M12,17c-2.8,0-5-2.2-5-5 s2.2-5,5-5c2.8,0,5,2.2,5,5S14.8,17,12,17z M12,9c-1.7,0-3,1.3-3,3s1.3,3,3,3c1.7,0,3-1.3,3-3S13.7,9,12,9z"/> </g></g><g id="Grid" display="none"> <g display="inline"> </g></g></svg>',
    'img/icons/upload.svg' : '<svg version="1.1" x="0px" y="0px" width="24px" height="24px" viewBox="0 0 24 24" enable-background="new 0 0 24 24" xml:space="preserve"><g><g><rect x="-618" y="-2232" fill="none" width="1400" height="3600"/></g></g><g><g><rect fill="none" width="24" height="24"/><path fill="#7d7d7d" d="M19.4,10c-0.7-3.4-3.7-6-7.4-6C9.1,4,6.6,5.6,5.4,8C2.3,8.4,0,10.9,0,14c0,3.3,2.7,6,6,6h13c2.8,0,5-2.2,5-5C24,12.4,21.9,10.2,19.4,10z M14,13v4h-4v-4H7l5-5l5,5H14z"/></g></g></svg>',
    'img/icons/codepen-logo.svg' : '<svg xmlns="http://www.w3.org/2000/svg" width="500" height="500" viewBox="0 0 500 500"><path d="M250 0C111.928 0 0 111.927 0 250c0 138.077 111.927 250 250 250 138.073 0 250-111.923 250-250C500 111.928 388.073 0 250 0zm0 458.943C134.79 458.943 41.06 365.21 41.06 250c0-115.207 93.73-208.94 208.94-208.94S458.94 134.793 458.94 250c0 115.21-93.73 208.943-208.94 208.943z"/><path d="M404.462 201.172c-.028-.195-.076-.382-.11-.577-.064-.374-.134-.748-.23-1.114-.058-.22-.14-.43-.207-.64-.106-.327-.212-.652-.342-.97-.09-.22-.196-.438-.297-.65-.14-.3-.285-.593-.452-.877-.122-.212-.25-.416-.377-.618-.18-.277-.362-.546-.562-.806-.146-.195-.3-.39-.454-.578-.21-.243-.43-.487-.663-.716-.174-.178-.346-.357-.528-.52-.245-.22-.497-.432-.753-.634-.198-.155-.395-.31-.602-.456-.078-.05-.146-.114-.22-.163L257.37 97.656c-4.465-2.976-10.275-2.976-14.74 0l-141.294 94.196c-.073.05-.142.114-.22.163-.207.146-.402.3-.597.456-.26.204-.513.416-.753.634-.187.164-.357.342-.533.52-.23.23-.45.474-.658.717-.16.19-.313.384-.46.578-.194.26-.382.53-.556.806-.134.203-.26.406-.382.618-.163.284-.31.577-.45.877-.103.21-.21.43-.298.65-.13.317-.236.642-.34.968-.07.21-.147.422-.21.642-.096.366-.16.74-.23 1.114-.032.195-.08.382-.106.577-.077.57-.122 1.147-.122 1.733V297.1c0 .585.044 1.162.122 1.74.025.188.074.382.106.568.07.374.134.748.23 1.114.063.22.14.432.21.643.104.324.21.65.34.975.09.222.195.433.297.645.143.3.29.592.45.885.123.204.25.406.383.61.174.276.362.545.557.806.146.203.3.39.46.577.207.243.426.488.657.716.175.177.346.356.533.52.24.22.492.43.752.634.194.155.39.31.597.454.077.05.146.115.22.163L242.63 402.35c2.232 1.487 4.803 2.236 7.372 2.236 2.566 0 5.135-.75 7.368-2.236l141.295-94.197c.074-.047.142-.112.22-.162.207-.145.403-.3.602-.454.256-.203.508-.414.752-.635.182-.163.353-.343.527-.52.232-.23.452-.474.664-.717.155-.187.31-.374.455-.577.2-.26.383-.53.562-.806.126-.204.255-.406.377-.61.167-.293.312-.585.452-.885.1-.212.206-.423.297-.645.13-.324.235-.65.342-.975.068-.21.15-.423.206-.643.1-.366.168-.74.233-1.114.033-.187.08-.38.11-.568.072-.578.118-1.155.118-1.74v-94.197c0-.585-.045-1.162-.118-1.73zm-141.176-67.64l104.088 69.388-46.493 31.103-57.594-38.527v-61.963zm-26.57 0v61.964l-57.593 38.527-46.497-31.103 104.09-69.387zm-114.726 94.24L155.228 250l-33.238 22.233V227.77zm114.725 138.7l-104.088-69.39 46.497-31.093 57.592 38.52v61.96zM250 281.43L203.014 250 250 218.574l46.986 31.428L250 281.432zm13.286 85.04v-61.963l57.595-38.52 46.494 31.093-104.088 69.388zm114.724-94.238L344.777 250l33.233-22.23v44.464z"/></svg>',
    'img/icons/more_vert.svg' : '<svg xmlns="http://www.w3.org/2000/svg" width="18" height="18" viewBox="0 0 18 18"> <path d="M0 0h18v18h-18z" fill="none"/> <path d="M9 5.5c.83 0 1.5-.67 1.5-1.5s-.67-1.5-1.5-1.5-1.5.67-1.5 1.5.67 1.5 1.5 1.5zm0 2c-.83 0-1.5.67-1.5 1.5s.67 1.5 1.5 1.5 1.5-.67 1.5-1.5-.67-1.5-1.5-1.5zm0 5c-.83 0-1.5.67-1.5 1.5s.67 1.5 1.5 1.5 1.5-.67 1.5-1.5-.67-1.5-1.5-1.5z"/></svg>',
    'img/icons/ic_person_24px.svg' : '<svg xmlns="http://www.w3.org/2000/svg" width="24" height="24" viewBox="0 0 24 24"> <path d="M12 12c2.21 0 4-1.79 4-4s-1.79-4-4-4-4 1.79-4 4 1.79 4 4 4zm0 2c-2.67 0-8 1.34-8 4v2h16v-2c0-2.66-5.33-4-8-4z"/> <path d="M0 0h24v24h-24z" fill="none"/></svg>',
    'img/icons/ic_phone_24px.svg' : '<svg xmlns="http://www.w3.org/2000/svg" width="24" height="24" viewBox="0 0 24 24"> <path d="M0 0h24v24h-24z" fill="none"/> <path d="M6.62 10.79c1.44 2.83 3.76 5.14 6.59 6.59l2.2-2.2c.27-.27.67-.36 1.02-.24 1.12.37 2.33.57 3.57.57.55 0 1 .45 1 1v3.49c0 .55-.45 1-1 1-9.39 0-17-7.61-17-17 0-.55.45-1 1-1h3.5c.55 0 1 .45 1 1 0 1.25.2 2.45.57 3.57.11.35.03.74-.25 1.02l-2.2 2.2z"/></svg>',
    'img/icons/menu.svg' : '<svg xmlns="http://www.w3.org/2000/svg" width="18" height="18" viewBox="0 0 18 18"> <path d="M0 0h18v18h-18z" fill="none"/> <path d="M2 13.5h14v-1.5h-14v1.5zm0-4h14v-1.5h-14v1.5zm0-5.5v1.5h14v-1.5h-14z"/></svg>',
    'img/icons/print.svg' : '<svg version="1.1" x="0px" y="0px" width="24px" height="24px" viewBox="0 0 24 24" enable-background="new 0 0 24 24" xml:space="preserve"><g><g><g><path d="M19,8H5c-1.7,0-3,1.3-3,3v6h4v4h12v-4h4v-6C22,9.3,20.7,8,19,8z M16,19H8v-5h8V19z M19,12c-0.6,0-1-0.4-1-1s0.4-1,1-1c0.6,0,1,0.4,1,1S19.6,12,19,12z M18,3H6v4h12V3z" fill="#7d7d7d"/></g><rect fill="none" width="24" height="24"/></g></g></svg>',
    'icons/avatar-icons.svg' : '<svg><defs> <svg viewBox="0 0 128 128" height="128" width="128" id="svg-1" x="128"> <path fill="#FF8A80" d="M0 0h128v128H0z"/> <path fill="#FFE0B2" d="M36.3 94.8c6.4 7.3 16.2 12.1 27.3 12.4 10.7-.3 20.3-4.7 26.7-11.6l.2.1c-17-13.3-12.9-23.4-8.5-28.6 1.3-1.2 2.8-2.5 4.4-3.9l13.1-11c1.5-1.2 2.6-3 2.9-5.1.6-4.4-2.5-8.4-6.9-9.1-1.5-.2-3 0-4.3.6-.3-1.3-.4-2.7-1.6-3.5-1.4-.9-2.8-1.7-4.2-2.5-7.1-3.9-14.9-6.6-23-7.9-5.4-.9-11-1.2-16.1.7-3.3 1.2-6.1 3.2-8.7 5.6-1.3 1.2-2.5 2.4-3.7 3.7l-1.8 1.9c-.3.3-.5.6-.8.8-.1.1-.2 0-.4.2.1.2.1.5.1.6-1-.3-2.1-.4-3.2-.2-4.4.6-7.5 4.7-6.9 9.1.3 2.1 1.3 3.8 2.8 5.1l11 9.3c1.8 1.5 3.3 3.8 4.6 5.7 1.5 2.3 2.8 4.9 3.5 7.6 1.7 6.8-.8 13.4-5.4 18.4-.5.6-1.1 1-1.4 1.7-.2.6-.4 1.3-.6 2-.4 1.5-.5 3.1-.3 4.6.4 3.1 1.8 6.1 4.1 8.2 3.3 3 8 4 12.4 4.5 5.2.6 10.5.7 15.7.2 4.5-.4 9.1-1.2 13-3.4 5.6-3.1 9.6-8.9 10.5-15.2M76.4 46c.9 0 1.6.7 1.6 1.6 0 .9-.7 1.6-1.6 1.6-.9 0-1.6-.7-1.6-1.6-.1-.9.7-1.6 1.6-1.6zm-25.7 0c.9 0 1.6.7 1.6 1.6 0 .9-.7 1.6-1.6 1.6-.9 0-1.6-.7-1.6-1.6-.1-.9.7-1.6 1.6-1.6z"/> <path fill="#E0F7FA" d="M105.3 106.1c-.9-1.3-1.3-1.9-1.3-1.9l-.2-.3c-.6-.9-1.2-1.7-1.9-2.4-3.2-3.5-7.3-5.4-11.4-5.7 0 0 .1 0 .1.1l-.2-.1c-6.4 6.9-16 11.3-26.7 11.6-11.2-.3-21.1-5.1-27.5-12.6-.1.2-.2.4-.2.5-3.1.9-6 2.7-8.4 5.4l-.2.2s-.5.6-1.5 1.7c-.9 1.1-2.2 2.6-3.7 4.5-3.1 3.9-7.2 9.5-11.7 16.6-.9 1.4-1.7 2.8-2.6 4.3h109.6c-3.4-7.1-6.5-12.8-8.9-16.9-1.5-2.2-2.6-3.8-3.3-5z"/> <circle fill="#444" cx="76.3" cy="47.5" r="2"/> <circle fill="#444" cx="50.7" cy="47.6" r="2"/> <path fill="#444" d="M48.1 27.4c4.5 5.9 15.5 12.1 42.4 8.4-2.2-6.9-6.8-12.6-12.6-16.4C95.1 20.9 92 10 92 10c-1.4 5.5-11.1 4.4-11.1 4.4H62.1c-1.7-.1-3.4 0-5.2.3-12.8 1.8-22.6 11.1-25.7 22.9 10.6-1.9 15.3-7.6 16.9-10.2z"/> </svg> <svg viewBox="0 0 128 128" height="128" width="128" id="svg-10" x="256" y="256"> <path fill="#FFCC80" d="M41.6 123.8s0 .1-.1.1l.3-.4c-.1.2-.1.2-.2.3z"/> <path fill="#8C9EFF" d="M0 0h128v128H0z"/> <path fill="#C2C2C2" d="M34.8 79.5c-2.5-3.4-5.9-6.4-6.9-10.3v-.1l-.6-.5c-.3-1.2.6-2 .5-3l-2.4-1h-6.9s0 17 17.4 17.3c-.9-.9-.7-1.8-1.1-2.4z"/> <path fill="#CFD8DC" d="M21.9 64.2l-.1-.3c0-.1 0-.2-.1-.4v-1l.1-.3c.1-.1.1-.2.1-.3.1-.1.1-.2.1-.2.2-.4.1-.8-.2-1.1-.4-.4-1-.4-1.3 0l-.2.2-.2.2c-.1.1-.2.2-.3.4l-.3.6-.3.6c-.1.2-.2.4-.2.7 0 .2-.1.5-.1.8v.5h3c.2-.2.1-.3 0-.4z"/> <path fill="#eee" d="M116.5 65.2c.1.1.2.1.2.2 0-.1-.1-.2-.2-.2zm8.2 6.1l.6.3c-.3-.1-.4-.2-.6-.3zm1.7 1l.6.3c-.2 0-.4-.1-.6-.3zm-3.4-2.1l.5.3c-.2 0-.4-.2-.5-.3zm-8-6.5zm-.1 64.1c-12-17.2-7.6-52-3.1-67.6v-.1c-3.5-4.2-7.8-11.7-10.2-18.7-1.7-5-4-8.8-6.4-11.8l-1.6-2-10.7 11.8c-1.5 2.1-3.3 1.8-4.1-.6l-7.1-17.3c-.3-.9-.3-1.9 0-2.7.3-1.1-.1-2.1.7-3l-2-.1c-1.3 0-2.5.1-3.7.3-1.7-.3-3.4-.5-5.1-.5-11.9 0-21.9 8.1-24.8 19.2-.5 1.8-.7 3.7-.8 5.6-1.2 3.6-4.2 7.7-11.5 8.4 1.3.4 2.2 1.9 2 3.6l-.5 2.8c-.3 2-1.2 2.4-2.2.9l1.6 8.6.2.9c.1 1.1.3 2.2.6 3.4 1 4 3.2 8.2 7.8 10.9.3.6 1 1.3 2 2.1 8.2 6.7 36 20.7 27.8 46.1h51.3c0-.1-.1-.1-.2-.2zM34.5 59.3c.5 0 1 .4 1 1 0 .5-.4 1-1 1-.5 0-1-.4-1-1s.4-1 1-1zm7.4 3.9c.5 0 1 .4 1 1 0 .5-.4 1-1 1-.5 0-1-.4-1-1 0-.5.5-1 1-1zm-1-8.5c-.5 0-1-.4-1-1 0-.5.4-1 1-1 .5 0 1 .4 1 1s-.5 1-1 1zm3.9-10.9c-.9 0-1.6-.7-1.6-1.6 0-.9.7-1.6 1.6-1.6.9 0 1.6.7 1.6 1.6 0 .9-.7 1.6-1.6 1.6zm73.3 22.7c.1.1.2.2.4.3-.2-.1-.3-.2-.4-.3zm3.2 2.6l.5.3-.5-.3zm-1.6-1.3l.4.3c-.1 0-.3-.1-.4-.3z"/> <path fill="#C2C2C2" d="M114.9 127.8l.2.2H128V73.2l-1-.6-.6-.3-1.2-.7-.6-.3-1.2-.7-.5-.3-1.2-.8-.5-.3-1.2-.9-.4-.3-1.2-1c-.1-.1-.2-.2-.4-.3l-1.3-1.2c-.1-.1-.2-.1-.2-.2l-1.5-1.5c-1.5-1.6-3-3.3-4.4-5.1-4.6 15.4-13 52.7 4.3 69.1z"/> <path fill="#646464" d="M26 55.1l.4-2.8c.2-1.8-.6-3.2-2-3.6-.3-.1-.7-.2-1.1-.1-2 .1-2.7 1.9-1.6 3.8l1.8 3.3c.1.2.2.3.3.4 1 1.3 1.9 1 2.2-1z"/> <circle fill="#444" cx="44.8" cy="42.2" r="2"/> <circle fill="#CFD8DC" cx="34.5" cy="60.3" r="1"/> <circle fill="#CFD8DC" cx="40.9" cy="53.7" r="1"/> <circle fill="#CFD8DC" cx="41.9" cy="64.2" r="1"/> <path fill="#646464" d="M70.7 18.8c-.3.8-.3 1.8 0 2.7l8.1 19.3c.8 2.5 2.6 2.7 4.1.6l12.3-11.8 1.4-1.3c.3-.4.5-.9.6-1.3.4-1.2.3-2.4-.1-3.6-1.1-4.3-5.6-8.9-11.2-10.3-5.6-1.4-10.9-.2-13.6 2.7-.8.8-1.3 1.8-1.6 3z"/> </svg> <svg viewBox="0 0 128 128" height="128" width="128" id="svg-11" y="128"> <path fill="#FFCC80" d="M41.6 123.8s0 .1-.1.1l.3-.4c-.1.2-.1.2-.2.3z"/> <path fill="#FFFF8D" d="M0 0h128v128H0z"/> <path fill="#F4B400" d="M110.3 91.4l-.5-.5c.1.2.3.4.5.5zm-4.4-4.5l.4.5c-.1-.2-.3-.4-.4-.5zm9.8 9.5c.2.2.4.4.7.6-.3-.2-.5-.4-.7-.6zM104.3 85c.2.2.3.4.5.5-.2-.1-.4-.3-.5-.5zm3.7 4.1zm16.9 14l.9.6c-.3-.3-.6-.4-.9-.6zm-28.5-29l.1.2c-.1 0-.1-.1-.1-.2zm15.2 18.6c.2.2.4.4.7.6l-.7-.6zm10 8.2l.9.6-.9-.6zm-18.8-17.7l.4.5c-.1-.1-.3-.3-.4-.5zm-1.4-1.7c.1.1.1.2.2.2-.1 0-.1-.1-.2-.2zm12.2 13l.7.6c-.2-.1-.5-.4-.7-.6zm-15-16.8c.1.1.1.2.2.2l-.2-.2zm-1.2-1.8l.2.3c0-.1-.1-.2-.2-.3zm28.4 27.7l-.9-.6-2.4-1.5-.9-.6c-1-.7-2.1-1.4-3.1-2.2l-2.2-1.8c-.2-.2-.4-.4-.7-.6-.5-.4-1-.8-1.4-1.2l-.7-.6-1.3-1.2-.7-.6c-.5-.4-.9-.9-1.3-1.3l-.5-.5-1.8-1.8c-.6-.6-1.1-1.2-1.6-1.8l-.4-.5-1.2-1.3c-.2-.2-.3-.4-.5-.5l-1.1-1.3-.4-.5-1.2-1.5c-.1-.1-.1-.2-.2-.2-.9-1.2-1.8-2.4-2.6-3.6-.1-.1-.1-.2-.2-.2l-1-1.5-.2-.3c-.3-.5-.6-1-1-1.5l-.1-.2c-1.1-1.8-2-3.5-2.9-5.2-3.1-6-4.8-11.4-5.7-15.9-.2-.9-.3-1.7-.4-2.6L85 13l-8 10.2c-3.7-2.6-8.2-4.2-13.1-4.2s-9.4 1.5-13.1 4.1L42.7 13l-1.8 29-7.7 71.8h.2c-.1 1-.2 2-.2 3 0 4 .8 7.7 2.1 11.2H128v-23.1c-.7-.4-1.5-.8-2.2-1.3zM55 38.4c-.9 0-1.6-.7-1.6-1.6 0-.9.7-1.6 1.6-1.6.9 0 1.6.7 1.6 1.6 0 .8-.7 1.6-1.6 1.6zm17.9 0c-.9 0-1.6-.7-1.6-1.6 0-.9.7-1.6 1.6-1.6.9 0 1.6.7 1.6 1.6 0 .8-.7 1.6-1.6 1.6z"/> <circle fill="#444" cx="72.9" cy="36.7" r="2"/> <circle fill="#444" cx="55" cy="36.7" r="2"/> <path fill="#444" d="M61.6 39.5c-.5 1-.1 1.7 1 1.7h4.6c1.1 0 1.6-.8 1-1.7l-2.3-4c-.5-1-1.4-1-2 0l-2.3 4z"/> <path fill="#FF5722" d="M92.5 102.7c8.3 11.3 23.6 14.4 35.5 7.8v-5.6l-2.2-1.3-.9-.6-2.4-1.5-.9-.6c-1-.7-2.1-1.4-3.1-2.2l-2.2-1.8c-.2-.2-.4-.4-.7-.6-.5-.4-1-.8-1.4-1.2l-.7-.6-1.3-1.2-.7-.6c-.5-.4-.9-.9-1.3-1.3l-.5-.5-1.8-1.8c-.6-.6-1.1-1.2-1.6-1.8l-.4-.5-1.2-1.3c-.2-.2-.3-.4-.5-.5l-1.1-1.3-.4-.5-1.2-1.5c-.1-.1-.1-.2-.2-.2-.9-1.2-1.8-2.4-2.6-3.6-.1-.1-.1-.2-.2-.2l-1-1.5-.2-.3c-.3-.5-.6-1-1-1.5l-.1-.2c-1.1-1.8-2-3.5-2.9-5.2-7.7 9.4-8.4 23.4-.8 33.7z"/> </svg> <svg viewBox="0 0 128 128" height="128" width="128" id="svg-12" x="128" y="128"> <path fill="#B9F6CA" d="M0 0h128v128H0z"/> <path fill="#444" d="M50.4 75.7c-1.6-1.6-3.2-2.9-4.7-4-.9-.6-1-1.7-1.7-2.2-1.8-1-3.2-5.9-5.3-3.4l-.5.8-.4-.9c-1.3-1.2-1-.4-1.3-2.3-.5-4.2 1.2-7.2 5.1-7.8 1-.1 2-.1 2.9.2 9.5-1.8 13.7-7.4 15.2-10 4 5.7 14.3 11.4 38.3 7.8 2.8-4.7 4.5-10.2 4.5-16C102.4 20.8 88.6 7 71.6 7c-6.7 0-12.8 2.1-17.9 5.7L27.9 31C16.3 36.6 8.3 48.5 8.3 62.2c0 19.1 15.5 34.6 34.6 34.6 4.6 0 9-.9 13-2.5.2-8.4-1.4-14.5-5.5-18.6zm-5.9-21.6z"/> <path fill="#8D6E63" d="M73.7 122c6.1.5 13.4-.3 22-3.5-.1-.7-.3-1.4-.5-2.1-.3-1.3-3.8-21.4-4-28.1-.1-7.3.8-11.9 2-14.7h8.7l-2.5-10.1c-.2-2.4-.4-4.7-.7-6.6-.2-1.8-.3-2.3-.8-3.9-24 3.6-34.2-3.7-38.2-9.4-1.4 2.5-5.7 8.8-15.3 10.5-.9-.3-1.9-.3-2.9-.2-3.9.6-6.7 4.5-6.1 8.8.3 2 1.2 3.6 2.5 4.8.2.1 1.5.6 3.3 1.7.7.4 1.6.9 2.4 1.6 1.5 1.1 3.1 2.4 4.7 4 4 4.1 7.6 10.2 7.4 18.5-.1 4.9-1.6 10.6-5.1 17.2.1 0 7.3 10.2 23.1 11.5zM44.5 54.1z"/> <path fill="#FFCC80" d="M41.6 123.8s.1-.2.2-.3c-.1.2-.1.2-.2.3z"/> <circle fill="#444" cx="83.5" cy="63.1" r="2"/> <path fill="#0097A7" d="M73.7 122c-15.9-1.3-23-11.5-23-11.5-2.1 4-5.1 8.4-8.9 13.1l-.3.4c-.5.6-1.1 1.3-1.7 2-.5.6-1 1.3-1.6 2.1h59.7c-.7-3.2-1.5-6.4-2.1-9.5-8.7 3.1-16 3.9-22.1 3.4z"/> </svg> <svg viewBox="0 0 128 128" height="128" width="128" id="svg-13" x="256"> <path fill="#448AFF" d="M0 0h128v128H0z"/> <g fill="#00BFA5"> <path d="M73 18.7c-4.8 0-9.7.8-14 2.3-.1.1-.2.2-.4.3l-7.3 4.6c-.6.4-1.4.4-2 .1-.3-.2-.6-.4-.8-.7l-.7-1.1c-.6-1-.3-2.2.6-2.8l7.3-4.6c.4-.2.8-.3 1.2-.3-5.5-3-23.7-10.7-33.7 10.7-11.8 25.4 11 50.2-14.4 62.6 0 0 26.2 13.7 40.9-24.8 3.7 3.2 8.8 5.8 16 7.4-.6-5.6.8-9.8-2.1-12.8-1.3-1.4-2.7-1.5-4-2.4-.7-.5-1.4-.9-2-1.3-1.5-.9-2.6-1.3-2.8-1.4-1.1-1-1.9-2.4-2.1-4.1-.5-3.6-2.2-6.9 1.1-7.4.8-.1 1.6-.1 2.4.2 8-1.5 11.6-6.7 12.8-8.9 3.4 4.8 11.7 9.8 31.9 6.8.3 1.1.6 1.2.8 2.4l.5-1.3c-.1-13-13.2-23.5-29.2-23.5zM56.1 43.2zm5.3 46.5s6 8.6 19.4 9.7c5.1.4 11.3-.3 18.6-2.9-.1-.6-.3-1.2-.4-1.7-.2-1.1-3.2-18-3.4-23.6-.2-6.2.6-10 1.6-12.4h7.3l-2.1-8.5c-.1-2-.4-3.9-.6-5.6 0-.3-.1-.7-.2-1-.2-1.1-.4-2.3-.8-3.4-20.2 3-28.5-2-31.9-6.8-1.2 2.1-4.8 7.4-12.8 8.9-.8-.2-1.6-.3-2.4-.2-3.3.5-5.6 3.8-5.1 7.4.2 1.7 1 3.1 2.1 4.1.2.1 1.3.5 2.8 1.4.6.4 1.3.8 2 1.3 1.3.9 2.6 2 4 3.4 2.9 3 5.6 7.2 6.1 12.8.5 4.5-.6 10.2-4.2 17.1zm27.5-41.2c.7 0 1.3.6 1.3 1.3s-.6 1.3-1.3 1.3-1.3-.6-1.3-1.3.6-1.3 1.3-1.3zm-32.8-5.3c.1-.1 0-.1 0 0zm-2.4 57.7l.2-.2-.2.2z"/> <circle cx="88.9" cy="49.8" r="2"/> <path d="M80.8 99.3c-13.3-1.1-19.4-9.7-19.4-9.7-1.8 3.4-4.3 7.1-7.5 11l-.3.3c-.4.5-.9 1.1-1.4 1.7-.7.9-1.6 2.1-2.8 3.7-2.3 3.2-5.4 7.8-8.8 13.5-1.4 2.4-2.9 5.1-4.4 8 0 0 0 .1-.1.1h71.3c-.6-1.6-1.3-3.2-1.7-4.8-2.2-8.6-4.6-17.9-6.5-26.8-7.2 2.8-13.3 3.5-18.4 3zM55.7 16.7l-7.3 4.6c-1 .6-1.3 1.9-.6 2.8l.7 1.1c.2.3.5.6.8.7.6.3 1.4.3 2-.1l7.3-4.6.4-.3c.7-.7.8-1.7.3-2.5l-.7-1.1c-.4-.6-1-.9-1.6-1-.5 0-1 .1-1.3.4z"/> </g> <path fill="#444" d="M73 18.7c-4.8 0-9.7.8-14 2.3-.1.1-.2.2-.4.3l-7.3 4.6c-.6.4-1.4.4-2 .1-.3-.2-.6-.4-.8-.7l-.7-1.1c-.6-1-.3-2.2.6-2.8l7.3-4.6c.4-.2.8-.3 1.2-.3-5.5-3-23.7-10.7-33.7 10.7-11.8 25.4 11 50.2-14.4 62.6 0 0 26.2 13.7 40.9-24.8 3.7 3.2 8.8 5.8 16 7.4-.6-5.6.8-9.8-2.1-12.8-1.3-1.4-2.7-1.5-4-2.4-.7-.5-1.4-.9-2-1.3-1.5-.9-2.6-1.3-2.8-1.4-1.1-1-1.9-2.4-2.1-4.1-.5-3.6-2.2-6.9 1.1-7.4.8-.1 1.6-.1 2.4.2 8-1.5 11.6-6.7 12.8-8.9 3.4 4.8 11.7 9.8 31.9 6.8.3 1.1.6 1.2.8 2.4l.5-1.3c-.1-13-13.2-23.5-29.2-23.5zM56.1 43.2z"/> <path fill="#FFE0B2" d="M61.4 89.7s6 8.6 19.4 9.7c5.1.4 11.3-.3 18.6-2.9-.1-.6-.3-1.2-.4-1.7-.2-1.1-3.2-18-3.4-23.6-.2-6.2.6-10 1.6-12.4h7.3l-2.1-8.5c-.1-2-.4-3.9-.6-5.6 0-.3-.1-.7-.2-1-.2-1.1-.4-2.3-.8-3.4-20.2 3-28.5-2-31.9-6.8-1.2 2.1-4.8 7.4-12.8 8.9-.8-.2-1.6-.3-2.4-.2-3.3.5-5.6 3.8-5.1 7.4.2 1.7 1 3.1 2.1 4.1.2.1 1.3.5 2.8 1.4.6.4 1.3.8 2 1.3 1.3.9 2.6 2 4 3.4 2.9 3 5.6 7.2 6.1 12.8.5 4.5-.6 10.2-4.2 17.1zm27.5-41.2c.7 0 1.3.6 1.3 1.3s-.6 1.3-1.3 1.3-1.3-.6-1.3-1.3.6-1.3 1.3-1.3zm-32.8-5.3c.1-.1 0-.1 0 0z"/> <path fill="#FFCC80" d="M53.7 100.9l.2-.2-.2.2z"/> <circle fill="#444" cx="88.9" cy="49.8" r="2"/> <path fill="#FF5722" d="M80.8 99.3c-13.3-1.1-19.4-9.7-19.4-9.7-1.8 3.4-4.3 7.1-7.5 11l-.3.3c-.4.5-.9 1.1-1.4 1.7-.7.9-1.6 2.1-2.8 3.7-2.3 3.2-5.4 7.8-8.8 13.5-1.4 2.4-2.9 5.1-4.4 8 0 0 0 .1-.1.1h71.3c-.6-1.6-1.3-3.2-1.7-4.8-2.2-8.6-4.6-17.9-6.5-26.8-7.2 2.8-13.3 3.5-18.4 3z"/> <path fill="#00BFA5" d="M55.7 16.7l-7.3 4.6c-1 .6-1.3 1.9-.6 2.8l.7 1.1c.2.3.5.6.8.7.6.3 1.4.3 2-.1l7.3-4.6.4-.3c.7-.7.8-1.7.3-2.5l-.7-1.1c-.4-.6-1-.9-1.6-1-.5 0-1 .1-1.3.4z"/> </svg> <svg viewBox="0 0 128 128" height="128" width="128" id="svg-14" x="256" y="128"> <path fill="#B388FF" d="M0 0h128v128H0z"/> <path fill="#1C3AA9" d="M70.5 128h12.4c-5.1-15.8-6.6-23.9-7.2-28.4-1.9 8.8-4 19.3-5.2 28.4z"/> <path d="M92.9 32.8l-.2.1c.1 0 .2 0 .2-.1zm-1.2.5l-.7.1.7-.1zm.6-.2l-.3.1.3-.1zm-52 .3c-.2 0-.5 0-.7-.1.3 0 .5.1.7.1zm-.9-.2l-.5-.1.5.1zm-.7-.2c-.2-.1-.4-.2-.5-.3.1.1.3.2.5.3z" fill="none"/> <path fill="#2A56C6" d="M82.9 90.8v.2-.2z"/> <path fill="#FFE0B2" d="M31.2 47.2zM45.8 93c5.8 5.5 13.6 9.1 22.3 9.3 2.8-.1 5.4-.5 8-1.2l.8-3.8c4.3-19.3 9.7-37.4 15-52.9h6.9L94 36.2c-.2-1.2-.4-2.5-.7-3.6l-.4.3-.2.1-.4.2-.3.1-.3.1-.7.1H40.3c-.2 0-.5 0-.7-.1-.1 0-.1 0-.2-.1l-.5-.1-.2-.1c-.2-.1-.4-.2-.5-.3 0 0-.1 0-.1-.1-.1.2-.1.4-.1.7-1-.3-2-.4-3-.3-4.1.6-6.9 4.7-6.3 9.1.3 2 1.2 3.8 2.6 5 .3.1 1.6.7 3.4 1.7.8.4 1.6 1 2.5 1.6 1.5 1.1 3.2 2.5 4.9 4.1 0 0 16.3 12.3 3.4 38 .1.2.2.3.3.4zm34.1-51.9c.8 0 1.5.7 1.5 1.6 0 .9-.7 1.6-1.5 1.6s-1.5-.7-1.5-1.6.6-1.6 1.5-1.6z"/> <path fill="#2A56C6" d="M68.1 102.3c-8.7-.2-16.5-3.8-22.3-9.3-.1-.1-.2-.2-.4-.3-3-.2-7.6.2-10.8.6-4.6.6-9.6 1.3-15 2.4-3.6.7-8.1 1.9-19.7 5.3v27h71.4c1.3-9.1 2.9-18.1 4.7-26.9-2.5.7-5.1 1.1-7.9 1.2z"/> <path fill="#6D4C41" d="M61.8 9.8c-7.3 1.1-13.6 5.1-17.9 10.8h43.7C81.5 12.7 71.9 8.3 61.8 9.8z"/> <path fill="#E65100" d="M38.7 33l.2.1c.2.1.3.1.5.1.1 0 .1 0 .2.1l.7.1H91c.2 0 .5 0 .7-.1l.3-.1.3-.1c.1 0 .3-.1.4-.2l.2-.1.4-.3c1-.7 1.6-1.9 1.6-3.2v-4.8c0-2.2-1.8-4-4-4H40.4c-2.2 0-4 1.8-4 4v4.8c0 1.4.7 2.6 1.8 3.3 0 0 .1 0 .1.1s.2.2.4.3z"/> <ellipse fill="#444" cx="79.9" cy="42.7" rx="2" ry="2.2"/> </svg> <svg viewBox="0 0 128 128" height="128" width="128" id="svg-15" y="256"> <path fill="#FF80AB" d="M0 0h128v128H0z"/> <path fill="#5D4037" d="M87.3 11.7c-7.6 0-14.1 4.9-16.4 11.7-2.8-1.6-5.9-2.7-9.1-3.1-13.9-2.1-26.9 7.1-31.1 21.1 5 .8 9.5 3.1 13.4 3.1 1.4-.6 3-.9 4.6-.9 1.1 0 2.2.2 3.3.5 10-1.3 15.2-5.2 17.9-9 .3.5.6 1 1 1.6v.1c2.1 3.1 6.6 7.7 14.7 9.2.9-.3 1.9-.4 3-.2 1.5.2 2.8-1.1 3.8-.1 7-2.2 12.2-8.8 12.2-16.5 0-9.7-7.8-17.5-17.3-17.5z"/> <path d="M70.9 36.6c-.4-.6-.8-1.2-1-1.6.2.5.5 1 1 1.6z" fill="none"/> <path fill="#5D4037" d="M85.6 45.9z"/> <path fill="#FFCC80" d="M48.6 63.8c5.6 0 10.1-4.5 10.1-10.1s-4.5-10.1-10.1-10.1-10.1 4.5-10.1 10.1c.1 5.5 4.6 10.1 10.1 10.1zm-1.7-10.5c0 .9-.7 1.6-1.6 1.6-.9 0-1.6-.7-1.6-1.6 0-.9.7-1.6 1.6-1.6.9-.1 1.6.7 1.6 1.6zm38.7-7.4z"/> <path fill="#F9A825" d="M35.6 117.3c0 2.5 2.1 4.6 4.6 4.6s4.6-2.1 4.6-4.6c0-1.7-.9-3.2-2.3-4-.8-.2-1.8-.3-2.7-.6-2.3.3-4.2 2.2-4.2 4.6z"/> <circle fill="#F9A825" cx="64.3" cy="117.1" r="4.6"/> <path fill="#F9A825" d="M83.4 117.3c0 2.5 2.1 4.6 4.6 4.6 1.5 0 2.8-.7 3.7-1.8l-.7-.9-.6-.8c-.6-.7-1.3-1.5-1.8-2.1l-.3-.4c-.4-.5-.8-.9-1.2-1.5-.3-.4-.6-.8-.9-1.3-1.7.8-2.8 2.4-2.8 4.2z"/> <path fill="#FFEE58" d="M91.6 119.8c-.8 1-2.1 1.7-3.5 1.7-2.4 0-4.4-2-4.4-4.4 0-1.8 1-3.3 2.5-4-3-3.9-5.3-7.5-7.2-11 .2.1-7.3 10.6-23.7 12-3.8.3-8 .1-12.8-.8 1.3.8 2.2 2.2 2.2 3.8 0 2.4-2 4.4-4.4 4.4s-4.4-2-4.4-4.4c0-2.3 1.8-4.2 4-4.4-2.4-.6-4.8-1.3-7.4-2.2-1.2 5.7-2.6 11.6-4.1 17.5h69c-1.4-2-2.6-3.8-3.7-5.3m-29.4-1.2c-2.4 0-4.4-2-4.4-4.4s2-4.4 4.4-4.4 4.4 2 4.4 4.4c0 2.4-2 4.4-4.4 4.4z"/> <path fill="#FFCC80" d="M92.4 45.6c-1-1-2.4-1.7-3.8-1.9-1-.2-2-.1-3 .2-8.1-1.5-12.6-6.1-14.7-9.2-.5-.7-.8-1.2-1.1-1.7-2.7 3.8-7.9 7.7-17.9 9l.9.3-9.4.4.6-.3c-3.9 0-8.3-.4-13.4-1.1-.5 1.7-.9 3.5-1.2 5.3-.2 1.8-.5 3.8-.6 6l-.3 2-2.3 9.4h9c1.2 3 2.1 7.7 1.9 15.3-.2 6.9-3.9 27.7-4.2 29-.1.7-.3 1.4-.5 2.1 2.6.9 5 2 7.3 2.5l2.7.5c4.8.9 9.2 1.4 13 1.1 16.4-1.3 24-12 24-12-9.8-18.4-4.6-30.7 2.1-37.5 1.6-1.7 3.3-3 4.9-4.1.9-.6 1.7-1.2 2.5-1.6 1.8-1.1 3.2-1.6 3.4-1.7 1.3-1.2 2.3-3 2.6-5 .3-2.6-.7-5.3-2.5-7zm-32.9 2.7c.5 1 .8 2 1 3.1l-1-3.1z"/> <path fill="#DB4437" d="M36.6 54.7c.5 6.2 5.7 11.1 12 11.1 6.7 0 12.1-5.4 12.1-12.1 0-5.5-3.7-10.2-8.8-11.6-1-.3-2.1-.5-3.3-.5-1.6 0-3.2.3-4.6.9-4.1 1.7-7.1 5.6-7.4 10.2h-7.7l-.1.9-.3 1.1h8.1zm12-11.1c5.6 0 10.1 4.5 10.1 10.1s-4.5 10.1-10.1 10.1-10.1-4.5-10.1-10.1c.1-5.6 4.6-10.1 10.1-10.1z"/> <circle fill="#444" cx="45.3" cy="53.3" r="2"/> </svg> <svg viewBox="0 0 128 128" height="128" width="128" id="svg-16" x="128" y="256"> <path fill="#B388FF" d="M0 0h128v128H0z"/> <path fill="#444" d="M58.4 24c4.2 5.9 23.9 10.2 38.9 4.6-4.2-14-17.1-23.2-31.1-21.1-11.7 1.8-20.8 11.2-23.7 22.9 7 3.2 14.5-3.8 15.9-6.4z"/> <path fill="#689F38" d="M72.7 101.3C56.3 100 48.8 89.4 48.8 89.4c-2.2 4.2-5.2 8.7-9.2 13.5l-.3.4-1.7 2c-.9 1.1-2 2.6-3.4 4.5-2.8 3.9-6.6 9.5-10.8 16.6l-.8 1.4h80.1c-2.5-9.8-5.1-20.3-7.3-30.2-8.9 3.4-16.5 4.3-22.7 3.7z"/> <path fill="#FFCC80" d="M101.8 51.3l-2.6-10.4c-.2-2.5-.5-4.9-.7-6.9-.2-1.9-.6-3.6-1.2-5.3-24.8 3.7-35-2.5-39.1-8.4-1.5 2.6-5.8 8.4-15.6 10.2-.1.2-.1.5-.1.7-.9-.3-1.9-.4-3-.2-4.1.6-6.9 4.7-6.3 9.1.3 2 1.2 3.8 2.6 5 .3.1 1.6.7 3.4 1.7.8.4 1.6 1 2.5 1.6 1.5 1.1 3.2 2.5 4.9 4.1 6.6 6.8 12.1 18.6 2.4 37 0 0 7.4 10.6 23.8 11.9 6.3.5 13.8-.3 22.8-3.6l-.5-2.1c-.3-1.4-4-22.1-4.2-29-.2-7.6.7-12.3 1.9-15.3h9zM81.1 40.5c0-.9.7-1.6 1.6-1.6.9 0 1.6.7 1.6 1.6 0 .9-.7 1.6-1.6 1.6-.9.1-1.6-.7-1.6-1.6zm-41.7 62.8s0 .1-.1.1l.3-.4c0 .1-.1.2-.2.3z"/> <circle fill="#444" cx="82.7" cy="40.5" r="2"/> </svg> <svg viewBox="0 0 128 128" height="128" width="128" id="svg-2"> <path fill="#B9F6CA" d="M0 0h128v128H0z"/> <path fill="#FFCC80" d="M70.1 122.5l.6-.1c6.1-.8 12-2.4 17.7-4.8 1.2-.5 2.4-1.1 3.2-2.1 1.3-1.7-.1-5.6-.5-7.7-.7-3.8-1.3-7.7-1.9-11.5-.7-4.5-1.5-9.1-1.6-13.7-.2-7.6.7-12.3 1.9-15.3h9l-2.6-10.4c-.2-2.4-.4-4.8-.7-6.8-.2-1.9-.6-3.6-1.2-5.3-14.9 2.2-24.5.9-30.7-1.8l-23.1 4.5-.7.1h-.7c-.4-.1-.9-.2-1.2-.4-.4 0-.9 0-1.4.1-4.1.6-6.9 4.7-6.3 9.1.3 2 1.2 3.8 2.6 5 .3.1 1.6.7 3.4 1.7.8.4 1.6 1 2.5 1.6 1.5 1.1 3.2 2.5 4.9 4.1 5.8 5.9 8.4 13.8 7.4 22-.6 4.7-2.2 9.4-4.4 13.6-.5 1-1 1.6-1.1 2.8-.1 1.1-.1 2.3.1 3.4.4 2.3 1.5 4.4 3 6.2 2.6 3.1 6.4 5 10.4 5.8 3.8.4 7.6.3 11.4-.1zm9.5-67.6c.9 0 1.6.7 1.6 1.6 0 .9-.7 1.6-1.6 1.6s-1.6-.7-1.6-1.6c-.1-.8.7-1.6 1.6-1.6zM128 97.7c-3.3 1.9-6.6 3.7-9.9 5.3-3.2 1.5-6.3 2.9-9.6 4.2-.9.4-2.1.5-2.9 1.1-1.1.8-1.9 2.5-2.3 3.7-.6 1.6-.6 3.4.3 4.8.8 1.2 2.1 2 3.5 2.6 5.9 2.9 12.2 5.1 18.6 6.5 1.4.3 2.3 1.8 2.4.1V97.9c-.1.1-.1-.1-.1-.2z"/> <path d="M38.9 47.4zm.7 0z" fill="none"/> <path fill="#444" d="M94.2 44.9c-.8-2.6-1.8-5-3.2-7.2l-7.2 1.4-20.4 4c6.3 2.7 15.9 4 30.8 1.8z"/> <path fill="#E65100" d="M38.9 48.4h.7c.2 0 .5 0 .7-.1l23.1-4.5 20.4-4 23.3-4.5c1.9-.4 3.2-2 2.9-3.6-.3-1.6-2.1-2.6-4.1-2.3l-19.6 3.8-1.3-6.8C83 15.5 70 8.7 55.9 11.5c-14 2.7-23.7 13.9-21.6 24.9h.1l1.7 9v.7c.2.8.7 1.4 1.4 1.9.5.1 1 .3 1.4.4z"/> <circle fill="#444" cx="79.6" cy="56.5" r="2"/> <path fill="#689F38" d="M128 128v-1.8L106.3 108l-.4.2-2.9 1.3c-3 1.3-6 2.6-9.2 3.8l-1.4.5c-9 3.3-16.5 4.1-22.8 3.6-16.4-1.3-23.8-11.9-23.8-11.9-2.2 4.2-5.2 8.7-9.2 13.5l-.3.4-1.7 2c-.9 1.1-2 2.6-3.4 4.5-.4.6-.9 1.3-1.4 2l98.2.1z"/> <path fill="#FFCC80" d="M36.3 119.3s.1-.2.2-.3c-.1.1-.2.2-.2.3z"/> </svg> <svg viewBox="0 0 128 128" height="128" width="128" id="svg-3" x="384"> <path fill="#80D8FF" d="M0 0h128v128H0z"/> <path fill="#5D4037" d="M53.7 68.3c.9-.1 1.7-.3 2-.9.1-.2.2-.4.2-.6.2-1-.2-2-.5-3-1.2-3.2-2-6.4-2.2-9.8-.3-3.9.4-7.8 1-11.6l12.7-8.1c.8-.5 1.8-1.5 2.7-1.7.9-.3 2.4.6 3.3.8 1.3.4 2.6.6 4 .9 5.4.9 10.9.7 16.2-.6 1.3-.3 2.7-1.1 4-1.3-.3-2.1-1.5-4.3-2.5-6.1-1-1.9-2.2-3.7-3.6-5.3-2.7-3.2-6-5.8-9.8-7.5-3.3-1.5-6.8-2.4-10.4-2.5 0 0-50.8-8.1-42.4 56.4l12.8.5 8.7.3c.9-.1 2.5.2 3.8.1z"/> <path d="M59.5 25.7l-.3-.4c0 .2.1.3.3.4zm-1-1.2c-.2-.2-.3-.4-.4-.6.1.2.2.4.4.6zm.4.6l-.3-.4.3.4zm1.1 1.2l-.4-.4c.2.1.3.3.4.4zM46.3 56.2zm.5.4l.3.3-.3-.3zm-.2-.2l.2.2-.2-.2zm-.2-.2l.1.1-.1-.1zm14.3-29.3l-.4-.4c.1.1.2.3.4.4zm8.6 4.7l-1-.3c.3 0 .6.2 1 .3zm1.3.3c-.4-.1-.8-.2-1.1-.3.3.1.7.2 1.1.3zm-23.4 25l.4.4c-.2-.1-.3-.3-.4-.4zm27-24.2l-.9-.2c.3.1.6.2.9.2zm-12.8-5.2l-.5-.4c.1.1.3.2.5.4zm6.7 3.7c-.3-.1-.6-.2-.9-.4.2.1.6.2.9.4zm-5.9-3.1l-.6-.5.6.5zm3.7 2.2c-1.4-.6-2.6-1.3-3.6-2.1 1 .7 2.2 1.4 3.6 2.1zm1.1.4l-.9-.4c.2.2.5.3.9.4zm20.1 2.7h-.8.8zm-3.2 0h1.4-1.4zm-3.9 0l1.9.1c-.6 0-1.1 0-1.7-.1H80zm2 0h1.6H82zm6.1-.1c.3 0 .7 0 1-.1h-.2c-.2.1-.5.1-.8.1zm6.2-.6l-.7.1c1.2-.1 2.4-.3 3.6-.5l-2.2.3c-.2.1-.5.1-.7.1zm-3.4.4c-.3 0-.6 0-.8.1.9-.1 1.9-.2 2.9-.3l-.8.1c-.5 0-.9 0-1.3.1zM51.1 61.9c.2.3.4.6.5 1-.2-.4-.3-.7-.5-1zm-3.5-4.6c.8.8 1.8 1.9 2.8 3.5-1-1.5-2-2.7-2.8-3.5zm2.9 3.6l.6.9c-.3-.3-.5-.6-.6-.9zm1.2 2.1l.6 1.1c-.3-.4-.4-.8-.6-1.1zm26.5-29.8l-.9-.1c-.2 0-.3 0-.5-.1l-.9-.1h-.2c1.3.2 2.6.3 4 .4-.3 0-.6 0-.9-.1-.2.1-.4.1-.6 0zm-3.8-.4l1.1.2-.9-.1c-.1-.1-.2-.1-.2-.1zm-3.7-.8c.7.2 1.5.4 2.3.5l-.9-.2-1.4-.3zM52.2 64.1c.6 1.2 1.1 2.6 1.5 4.1-.4-1.5-.9-2.9-1.5-4.1z" fill="none"/> <path fill="#E65100" d="M101.3 128h.3c-2.4-9.5-4.8-19.4-6.8-28.7-7.6 2.7-39.3.6-45.1-5.1-2.5 4.9-6 10.3-10.8 16.2H97l4.3 17.6z"/> <path fill="#2A56C6" d="M97.2 92.5v-.2.2z"/> <path fill="#00838F" d="M39.2 107.1l.3-.4-.3.3v.1z"/> <path fill="#EE8100" d="M101.6 128c-1.5-5.8-3-11.8-4.3-17.7H38.9c-.9 1.1-2.1 2.2-3.1 3.3-.2.2-.3.4-.5.5-4 4.6-7.5 9.2-10.4 13.8h76.7z"/> <path fill="#FFE0B2" d="M72.4 103.8c5.9-.2 14.8-1.8 22.4-4.5-.3-1.4-.6-2.7-.8-4.1-1.9-9.4-3.2-18.1-3.4-25-.5-19.6 6.6-20.2 6.6-20.2h2.1c0-4.2-.5-8.8-.9-12.3-.2-1.9-.6-3.6-1.2-5.3l-3.6.5-.6.1-2.9.3c-.3 0-.6 0-.9.1-.3 0-.7 0-1 .1-.3 0-.7 0-1 .1h-5.1c-.7 0-1.3 0-1.9-.1h-.3c-1.4-.1-2.8-.2-4-.4h-.2l-1.1-.2h-.2l-.9-.2c-.1 0-.2 0-.3-.1l-2.3-.5h-.1c-.4-.1-.8-.2-1.1-.3-.1 0-.1 0-.2-.1l-1-.3c-.1 0-.1 0-.2-.1-.3-.1-.6-.2-.9-.4-.1 0-.1 0-.2-.1l-.9-.4s-.1 0-.1-.1c-1.4-.6-2.6-1.3-3.6-2.1l-.1-.1-.6-.5-.2-.2-.5-.4-.2-.2-.4-.4-.2-.2-.4-.4-.2-.2-.3-.4-.2-.2-.3-.4-.1-.2c-.2-.2-.3-.4-.4-.6l-8 24.9-11.2-14.1c-4.1.6-6.9 4.7-6.3 9.1.3 2 1.2 3.8 2.6 5 .3.1 1.6.7 3.4 1.7.8.4 1.6 1 2.5 1.6 1.5 1.1 3.2 2.5 4.9 4.1h.1l.1.1.2.2.1.1.3.3.1.1.4.4c.8.8 1.8 1.9 2.8 3.5v.1l.6.9s0 .1.1.1c.2.3.4.6.5 1 0 0 0 .1.1.1l.6 1.1c.6 1.2 1.1 2.6 1.5 4.1 1.7 6.2 1.6 14.8-4 25.9 5.6 5.8 13.6 9.4 22.5 9.7z"/> <circle fill="#444" cx="84.2" cy="44.1" r="2"/> </svg> <svg viewBox="0 0 128 128" height="128" width="128" id="svg-4" x="384" y="128"> <path fill="#84FFFF" d="M0 0h128v128H0z"/> <path fill="#444" d="M28 54.2c1-.2 1.5.5 2.8.8 1.3.3 2.7.2 4-.2 2.2-.7 4.1-2.1 6.1-3.4 12.6-8.2 28.9-10.4 43.2-5.8 3 1 6 2.3 8 4.7.9 1.1 1.6 2.4 2.5 3.6s2.1 2.2 3.5 2.4c5.2.8 4.9-8.6 4.9-11.8 0-21.3-17.3-38.6-38.6-38.6S25.8 23.2 25.8 44.5c0 3.2.2 7 1.4 10 .3-.1.6-.2.8-.3z"/> <path fill="#8D6E63" d="M44.3 103.5c0 .2-.1.4-.1.5-.5 3.9.3 7.9 2.3 11.3 2.1 3.7 5.4 6.6 9.2 8.3 3.1 1.4 6.5 2.1 10 2.1 5.3-.1 10.6-2 14.2-5.9 1.9-2.1 3.2-4.6 4.5-7.1.9-1.7 1.8-3.4 2.5-5.2.6-1.7.6-2.3-.5-3.6-2.2-2.6-4.1-5.7-4.9-9.1-.9-4.1.3-9.7 3.5-12.6 1.3-1.2 2.8-2.5 4.4-3.9l13.1-11c1.5-1.2 2.6-3 2.9-5.1.4-3.2-1.1-6.3-3.7-7.9-.5-.3-.9-.5-1.5-.7h-.1c-.2-.1-.5-.2-.7-.2h-.1c-.3-.1-.6-.1-.8-.2-1.4-.2-2.8 0-4 .5-.8-14-13.9-11-29.9-11-14.6 0-26.8-2.5-29.4 7.8-.2.9-.5 2-.8 3.1-1.2-.4-2.4-.6-3.8-.4-.3 0-.6.1-.9.2l-.3.1-.6.2-.3.1-.6.3-.2.1-.8.5c-2.3 1.7-3.6 4.5-3.2 7.6.3 2.1 1.3 3.8 2.8 5.1 0 0 10.9 9.3 11 9.3 4.6 3.9 8.2 10.7 8.6 16.7.1 1.8 0 3.7-.5 5.5-.1 1.5-1 3-1.3 4.6z"/> <path d="M100.4 53.6zm-.8-.3h-.1.1zm-70.5.3l-.3.1c.1 0 .2 0 .3-.1zm-.9.4l-.2.1s.1 0 .2-.1zm1.7-.7l-.3.1c.2 0 .3-.1.3-.1z" fill="none"/> <path fill="#8D6E63" d="M39.3 109.5c-.1.1-.1.2-.1.2l.5-.6c-.1.1-.2.3-.4.4z"/> <path fill="#FFEB3B" d="M62.8 128h6.8l-3.4-5zm-23.6-18.3c-.1.2-.2.4-.2.5-3.1.9-6 2.7-8.4 5.4l-.2.2s-.5.6-1.5 1.7c-.9 1.1-2.2 2.6-3.7 4.5-1.3 1.6-2.8 3.6-4.4 5.8h28.6l-10.2-18.1zm72.3 16.6c-1.3-2.2-2.3-3.9-3.1-5.1-.9-1.3-1.3-2-1.3-2l-.2-.3c-.6-.9-1.2-1.7-1.9-2.4-3.1-3.4-7-5.2-10.9-5.7l-.3.4L83.6 128h28.9c-.3-.6-.7-1.2-1-1.7z"/> <circle fill="#444" cx="79.5" cy="62.7" r="2"/> <circle fill="#444" cx="53.8" cy="62.8" r="2"/> <path fill="#F57F17" d="M65.7 122.3l.5-.4L44 103.5l-4.3 5.6-.5.6L49.4 128h13.4l3.4-5zm0 0l.5.7 3.4 5h14l10.1-16.8.3-.4-6.4-6.2-.4.3-21 17z"/> </svg> <svg viewBox="0 0 128 128" height="128" width="128" id="svg-5" x="384" y="256"> <path fill="#FFFF8D" d="M0 0h128v128H0z"/> <path fill="#C2C2C2" d="M51.7 31.4v-22s-19.6 2.5-15.8 29.9c11 0 14.8-4.3 15.8-7.9z"/> <path fill="#848484" d="M94.1 39.8c.1-1 0-2-.1-3 0-1-.1-1.9-.2-2.9-.2-1.8-.4-3.5-.8-5.2-.6-2.9-1.5-5.8-2.9-8.4-1.1-2.2-2.6-4.2-4.3-6-1.6-1.6-3.3-2.9-5.3-3.9-1.8-1-3.8-1.7-5.8-2.2-2-.5-4-.8-6-.9-1.9-.1-3.8-.1-5.7 0-1.7.1-3.3.3-5 .6-1.3.2-2.5.5-3.8.8l-2.2.6-.4.1v20.8c0 1-.1 1.8.4 2.7.2.3.5.6.6.9.3.9.7 1.8 1.2 2.7 1.1 1.8 2.7 3.4 4.7 4.3 2.4 1.1 5.1 1.4 7.8 1.6 4.8.3 9.6.4 14.3.3 2.2 0 4.3-.3 6.4-.9 1.2-.3 2.4-.6 3.6-1 .6-.2 1.2-.4 1.8-.5.6-.2 1.2-.5 1.7-.5z"/> <path fill="#FFE0B2" d="M66.8 116.8l17.9-8.7 3.1-8.2c-15.1-17 1.2-31.6 2.3-32.5h.1l13.2-11.1c1.5-1.2 2.5-3 2.8-5 .6-4.4-2.5-8.4-6.9-9.1-1.5-.2-3 0-4.3.6-.2-1-.5-1.9-.8-2.9-26.9 3.7-37.9-2.5-42.4-8.4-1.6 2.6-5.1 6.1-15.8 7.9-.2.9-.5 2-.8 3.1-1.2-.4-2.4-.6-3.8-.4-4.4.6-7.5 4.7-6.9 9.1.3 2 1.3 3.8 2.8 5l7.5 6.4c4.2 4.5 18.4 21.7 9 37l.7 3.7 4.7 4.6 17.6 8.9z"/> <path fill="#055524" d="M39.8 104.7zm54.3-.4l-.8 1.5-6.8 12.1V128H128v-2.3z"/> <path fill="#FFE0B2" d="M40.4 103.9c-.2.2-.3.4-.5.5 0 0-.1.1-.1.2v.1l.6-.8z"/> <circle fill="#444" cx="80" cy="51.7" r="2"/> <circle fill="#444" cx="54.3" cy="51.7" r="2"/> <path fill="#055524" d="M39.8 104.7c-3.2.9-6.1 2.7-8.6 5.5l-.2.2s-.5.6-1.5 1.7c-.9 1.1-2.2 2.6-3.7 4.5-2.3 2.9-5.1 6.7-8.3 11.4h31v-7.8l-8.7-15.5z"/> <path fill="#848484" d="M65.3 67.3s2.7 9.8 14.5 9.8c0 0 3.9-18.5-14.5-18.5v8.7z"/> <path fill="#C2C2C2" d="M65.3 67.3v-8.7C46.9 58.6 50.8 77 50.8 77c11.8 0 14.5-9.7 14.5-9.7z"/> <path fill="#A7FFEB" d="M80.9 128h5.6v-10.1zm-21 0h13.8l-6.9-10zm-11.5 0h4.3l-4.3-7.8z"/> <path fill="#1DE9B6" d="M66.8 118l-.5-.8.5-.4-22.9-17.3h-.1l-3.4 4.4-.6.8 8.6 15.5 4.3 7.8h7.2zm26.5-12.2l.8-1.5-6.4-4.4-20.9 16.9-.5.4.5.8 6.9 10h7.2l5.6-10.1z"/> </svg> <svg viewBox="0 0 128 128" height="128" width="128" id="svg-6" y="384"> <path fill="#FF8A80" d="M0 0h128v128H0z"/> <path fill="#F2A600" d="M30.3 43.7c3.1-.4 6.1 1 7.7 3.4 10.3-2 11-11.5 12.6-14.1 4.5 5.8 13.3 17.8 39.5 14.5 1.6-2.7 4.7-4.3 8-3.8.4 0 .7-1.9 1-1.8-.1-2.2-.3-4.4-.8-6.4v-.1C94.9 19.6 80.8 7.8 64 7.8c-15 0-27.8 9.4-32.8 22.6C29.8 34 29 38 28.9 42.1l.7 1.8.7-.2z"/> <path d="M89.1 102.8l.4-.3c-.1 0-.3.1-.4.3zm2.2-1.9l-.5.4c.2-.2.3-.3.5-.4zm-18 9.2c-.1 0-.2 0-.3.1.1-.1.2-.1.3-.1zm-2.4.4h-.2.2zm16.1-6.2l.3-.2-.3.2zm-9 4.5l.5-.2-.5.2zm4.9-2.1l.2-.1c-.1.1-.1.1-.2.1zm2-1.1l.5-.3-.5.3zm-4.6 2.3l.4-.2c-.1.1-.2.2-.4.2zm12.6-8.6zM30.3 41.7c-.3 0-.5.1-.7.1.2 0 .5 0 .7-.1zm35.9 69.2c-.6 0-1.2 0-1.9-.1.6 0 1.2.1 1.9.1z" fill="none"/> <path fill="#F2A600" d="M41.5 101.3l.8.7c-.3-.3-.5-.5-.8-.7zm1.4 1.1c.2.2.5.4.8.6-.3-.2-.6-.4-.8-.6zm1.3 1.1c.2.2.5.4.8.5-.2-.1-.5-.3-.8-.5zm54.1-68.1zM38.7 98.3c.4.4.8.8 1.1 1.3-.4-.4-.8-.8-1.1-1.3zm-7.6-67.9zm15.4 74.7l.5.3-.5-.3zm4.6 2.4l.3.1c-.1 0-.2 0-.3-.1zm-3.1-1.6l.5.3c-.2-.1-.4-.2-.5-.3zm13.6 4.6l-.9-.1.9.1zM88.9 67c-1.6 1.4-3.1 2.7-4.4 3.9-3.3 3.8-6.3 10.3-1 18.7 5.7-8.1 10.6-17.7 13.2-29.1L88.9 67zM41 100.8l-.8-.8.8.8zm8.5 6l.4.2c-.1-.1-.2-.2-.4-.2zm9.5 3.3h.1-.1zm-46.1 17.3c4.5-7.1 8.6-12.7 11.7-16.6 1.5-2 2.8-3.5 3.7-4.5 1-1.1 1.5-1.7 1.5-1.7l.2-.2c2.4-2.7 5.3-4.5 8.4-5.4.1-.2.2-.4.2-.5 0-.1 0-.2.1-.2 13.6-13.3 4.7-26.5-1.5-32.9l-4.4-3.8c-2.6 8.7-8.5 18.2-20.1 26.9-6.4 4.1-10.6 11.4-10.6 19.7 0 8.2 4.1 15.4 10.4 19.8l.4-.6z"/> <path fill="#FFE0B2" d="M67.1 110.9h-2 2zM38.8 98.1c-.4.3 2.1 5.6 2.5 5.9 1.8 1.8 4.1 2.2 6.3 3.5 4.8 2.7 10.2 3.6 15.6 4.2 5.7.6 11.5-.5 16.8-2.6 2.5-1 4.8-2.3 7-3.8 1.2-.8 2.2-1.6 3.3-2.6.4-.3 2.4-3.6 2.7-3.3-4-3.3-8-6.9-10.4-11.6-2.2-4.2-2.6-9.1-.5-13.4 1.7-3.3 4.5-5.6 7.3-7.9 2.2-1.8 4.3-3.6 6.5-5.5l4.7-3.9c1-.8 2.1-1.6 2.8-2.7 1.5-2 1.9-4.6 1.2-7-1.4-4.8-7.1-7.2-11.5-4.9-1 .5-1.9 1.3-2.6 2.2l-.5.7-1.1.1c-.8.1-1.6.2-2.4.2-2.6.2-5.3.3-7.9.1-6.8-.3-13.5-2.1-19.1-6-3.6-2.4-6.3-5.6-8.9-9-.5.9-.8 1.9-1.1 2.8-.5 1.4-1 2.7-1.6 4-1.7 3.3-4.5 5.8-8.2 6.9-.5.2-1.1.3-1.7.4-.3-.5-.7-.9-1.1-1.3-.9-.6-2.1-1.3-3.3-1.6-2.5-.7-5.2-.2-7.2 1.4-3.9 3.1-4 9.2-.1 12.5l10.5 8.9c2.4 2 4.3 4.8 5.9 7.4 2.1 3.5 3.4 7.6 3.2 11.7-.3 5.6-3.3 10.4-7.1 14.2-.1.1 13.6-13.3 0 0z"/> <path fill="#80DEEA" d="M93 99.4l-.2-.1-1.5 1.5-.5.4c-.4.4-.9.8-1.3 1.1l-.4.3c-.6.5-1.2.9-1.8 1.3l-.3.2c-.5.4-1.1.7-1.6 1l-.5.3-1.8 1-.2.1c-.7.4-1.4.7-2.1 1l-.4.2-1.8.7-.5.2c-.8.3-1.5.5-2.3.7l-2.4.6c-.1 0-.2 0-.3.1l-2.1.4h-.2c-1.5.2-3 .3-4.5.4h2-1.9c-.6 0-1.2 0-1.9-.1l-2.7-.3-.9-.1-1.6-.3h-.1c-2.7-.6-5.2-1.4-7.6-2.4l-.3-.1c-.4-.2-.8-.4-1.2-.5l-.4-.2c-.4-.2-.7-.4-1-.5l-.5-.3-1-.6-.5-.3c-.5-.3-1-.6-1.5-1-.3-.2-.5-.4-.8-.5l-.6-.5-.8-.6-.6-.5c-.3-.2-.5-.4-.8-.7l-.5-.5-.8-.8-.4-.4c-.4-.4-.8-.8-1.1-1.3-.1.2-.2.4-.2.5-3.1.9-6 2.7-8.4 5.4l-.2.2s-.5.6-1.5 1.7c-.9 1.1-2.2 2.6-3.7 4.5-3.1 3.9-7.2 9.5-11.7 16.6-.1.2-.2.4-.4.6H118c-2.7-5.4-5.1-9.8-7.1-13.1-1.3-2.2-2.3-3.9-3.1-5.1-.9-1.3-1.3-2-1.3-2l-.2-.3c-.6-.9-1.2-1.7-1.9-2.4-3.3-3.3-7.4-5.2-11.4-5.5z"/> <circle fill="#444" cx="78.9" cy="51.3" r="2"/> <circle fill="#444" cx="53.2" cy="51.3" r="2"/> </svg> <svg viewBox="0 0 128 128" height="128" width="128" id="svg-7" x="128" y="384"> <path fill="#FFCC80" d="M41.6 123.8s0 .1-.1.1l.3-.4c-.1.2-.1.2-.2.3z"/> <path fill="#80D8FF" d="M0 0h128v128H0z"/> <path fill="#5D4037" d="M29.3 123.1c4.1-6.9 7.8-12.4 10.5-16.2 1.4-1.9 2.5-3.4 3.3-4.4l1.7-2s0-.1.1-.1l.3-.3C49 95.4 51.9 91 54.1 87c9.5-17.8 6.1-29.3-.3-35.9-1.6-1.6-3.2-2.9-4.7-4-.9-.6-1.7-1.1-2.4-1.6-1.8-1-3.1-1.6-3.3-1.7-1.3-1.2-2.2-2.9-2.5-4.9-.5-4.3 2.2-6.2 6.1-6.8 1-.1 2-.1 2.9.2 9.6-1.8 11.9-8 13.3-10.6 4 5.7 13.9 9.8 38 6.1C97.1 14.3 84.5 5.4 71 7.4c-4.4.7-8.3 2.4-11.8 4.9l-.1.1c-1.1.8-2.1 1.6-3 2.6l-35 30C12.9 49.8 7.3 58.8 7.3 69.1c0 2.7.4 5.3 1.1 7.8.3 4.9-.1 11.7-2.9 18.6-.2.5-.5 1-.7 1.6-1.2 3.2-1.9 6.6-1.9 10.2 0 8.2 3.5 15.6 9.1 20.7h14.5c1-1.7 1.9-3.4 2.8-4.9zm20.5-90.8z"/> <path fill="#FFCC80" d="M63.1 19.8c-1.4 2.6-5.7 8.8-15.3 10.6-.9-.3-1.9-.3-2.9-.2-3.9.6-6.7 4.5-6.1 8.8.3 2 1.2 3.7 2.5 4.9.2.1 1.5.6 3.3 1.7.7.4 1.6 1 2.4 1.6 1.5 1.1 3.1 2.4 4.7 4 6.4 6.6 11.8 18.1 2.3 35.9 0 0 7.3 15.5 23.2 16.9 6.1.5 13.3-5.6 22.1-8.8-.1-.7-.3-1.4-.5-2.1-.3-1.3-3.9-21.5-4.1-28.2-.2-7.4.7-11.9 1.9-14.8h8.8L103 39.7c-.2-2.4-.4-4.7-.7-6.7-.2-1.8-.6-3.5-1.1-5.2-24.2 3.7-34-2.3-38.1-8zm22.3 19.6c0-.9.7-1.6 1.6-1.6.9 0 1.6.7 1.6 1.6 0 .9-.7 1.6-1.6 1.6-.9 0-1.6-.7-1.6-1.6zm-35.6-7.1zm-4.9 68.1s0 .1-.1.1l.3-.4-.2.3z"/> <circle fill="#444" cx="86.9" cy="39.4" r="2"/> <path fill="#00BFA5" d="M77.2 98.5C61.3 97.2 54.1 87 54.1 87c-2.2 4-5.1 8.4-8.9 13.1l-.3.4c-.5.7-1.1 1.3-1.7 2-.8 1-2 2.5-3.3 4.4-2.8 3.8-6.5 9.2-10.5 16.2-.9 1.6-1.8 3.2-2.8 4.9h80.8l-.3-1c-2.6-10.3-5.4-21.4-7.7-31.9-8.8 3.1-16.1 3.9-22.2 3.4z"/> </svg> <svg viewBox="0 0 128 128" height="128" width="128" id="svg-8" x="256" y="384"> <path fill="#FFCC80" d="M41.6 123.8s.1-.2.2-.3c-.1.2-.1.2-.2.3z"/> <path fill="#B388FF" d="M0 0h128v128H0z"/> <path d="M64.1 34.5c-.1.1-.2.2-.3.2.1-.1.2-.2.3-.2zm.9-.7c-.1.1-.2.1-.2.2l.2-.2zm-1.9 1.3c-.1.1-.2.2-.4.2.2 0 .3-.1.4-.2zm-5.4 2.6l-.5.2c.2-.1.4-.2.5-.2zm2.8-1.1l-.2.1s.1-.1.2-.1zm-1.3.5l-.4.2c.1 0 .2-.1.4-.2zm8.8-6.3l-.2.3c.1-.1.2-.2.2-.3zm-1.9 2.1l-.3.2.3-.2zm1.4-1.4l-.3.3c.1-.2.2-.3.3-.3zm-.7.6l-.3.3c.2-.1.3-.2.3-.3zM62 35.8l-.3.2.3-.2zm5 47l-.3 1.6.3-1.6zM56.2 38.1l-.5.1c.1 0 .3 0 .5-.1zm10.4 46.5c-.1.5-.2 1.1-.4 1.6.2-.5.3-1 .4-1.6zm.6-3.6l-.2 1.6c.1-.5.1-1 .2-1.6zm-5.6-20.8c.1.1.2.3.4.4l-.4-.4zm7.5-30.9l-.6.9c.5-.7.9-1.3 1.2-1.8-.1.2-.3.5-.5.7 0 .1 0 .2-.1.2zM67.2 81c1-10.6-2.4-17.3-5.2-20.4 2.7 3.1 6.2 9.8 5.2 20.4zm-1 5.5c-.1.6-.3 1.1-.5 1.7.2-.6.4-1.2.5-1.7zm-5.6-27.4l.2.2c-.1 0-.2-.1-.2-.2zm-.3-.2s.1.1.2.1c-.1 0-.1 0-.2-.1zm-.2-.1zm-.1-.1zm1.7 38.2c-.1-.1-.2-.2-.4-.3l.1.1.3.2zm-.5-37.1l.3.3-.3-.3zm-.3-.4l.3.3c-.2-.1-.2-.2-.3-.3z" fill="none"/> <path fill="#2A56C6" d="M98.8 94.8v.2-.2z"/> <path fill="#FFE0B2" d="M2.8 109.6L0 110.8V128h15.5L2.8 109.6z"/> <path fill="#DD2C00" d="M91.9 128h5.6c-3.8-12-4.4-16-4.9-20.1-.1-.5-.5-2.4-.5-2.9-2.6.7-5.2 1.1-8 1.2-8.7-.2-16.5-3.8-22.3-9.3l-.2-.2-.1-.1c-2.9.2-7.6.2-10.8.6-4.6.6-9.6 1.3-15 2.4-4.7.9-11.2 2.7-33.3 9.3l.5.7L15.5 128h70.2"/> <path fill="#FFEB3B" d="M66.2 86.5c0-.1 0-.1.1-.2.1-.6.3-1.1.4-1.6v-.2l.3-1.6v-.1l.2-1.6c1-10.6-2.4-17.3-5.2-20.4-.1-.1-.2-.3-.4-.4l-.1-.1-.3-.3-.1-.1-.3-.3-.1-.1-.2-.2-.1-.1c-.1-.1-.1-.1-.2-.1 0 0-.1 0-.1-.1l-.1-.1s-.1 0-.1-.1c-1.6-1.7-3.3-3-4.9-4.1-.9-.6-1.7-1.2-2.5-1.6-1.8-1.1-3.2-1.6-3.4-1.7-1.3-1.2-2.3-3-2.6-5-.6-4.4.3-6.4 4.3-7.1 1-.2 2-.1 3 .2l.1-.7c.6-.1 1.1-.2 1.6-.4l.5-.1 1.1-.3.5-.2 1-.3.4-.2c.4-.1.7-.3 1.1-.5l.2-.1 1.2-.6.3-.2c.3-.1.5-.3.8-.5.1-.1.3-.2.4-.2.2-.1.4-.3.7-.4.1-.1.2-.2.3-.2l.7-.5c.1-.1.2-.1.2-.2.3-.2.5-.4.8-.7.1-.1.2-.1.2-.2l.5-.5.3-.3.4-.4.3-.3.3-.4c.1-.1.2-.2.2-.3.2-.2.3-.4.4-.6l.6-.9.1-.2c.2-.3.3-.5.5-.7 4.2 5.9 14.5 10.4 39.3 6.7-4.2-14-17.3-23.5-31.3-21.4-5.3.8-10.1 3.2-14 6.6l-.2.2c-.5.4-1 .9-1.4 1.4-5.3 4.8-23.3 19.8-52.2 26.5-3.9 0-7.4 1.6-9.9 4.2v19.3c.3.3.6.6.9.8l-.3.9S30.9 96.4 64 90.3l1.6-1.8c0-.1 0-.1.1-.2.2-.7.4-1.3.5-1.8z"/> <path fill="#FFE0B2" d="M84 106.2c2.8-.1 5.4-.5 8-1.2l.8-3.8c4.3-19.3 9.7-37.4 15-52.9h6.9l-4.8-8.2c-.2-1.9-.6-3.6-1.2-5.3-24.8 3.7-35-2.5-39.1-8.4-.3.5-.7 1.1-1.2 1.8l-.4.6-.2.3-.3.4-.3.3-.4.4-.3.3-.5.5s-.1 0-.2.1c-.3.2-.5.4-.8.7-.1.1-.2.1-.2.2-.2.2-.4.3-.7.5-.1.1-.2.2-.3.2-.2.1-.4.3-.7.4-.1.1-.2.2-.4.2l-.8.5-.3.2-1.2.6-.2.1-1.1.5-.4.2c-.3.1-.6.2-1 .3l-.5.2c-.3.1-.7.2-1.1.3l-.5.1-1.6.4c-.1.2-.1.5-.1.7-.9-.3-1.9-.4-3-.2-4.1.6-6.9 4.7-6.3 9.1.3 2 1.2 3.8 2.6 5 .3.1 1.6.7 3.4 1.7.8.4 1.6 1 2.5 1.6 1.5 1.1 3.2 2.5 4.9 4.1l.1.1.1.1.1.1s.1.1.2.1c0 0 .1 0 .1.1l.2.2.1.1.3.3.1.1.3.3.1.1s.2.3.4.4c2.7 3.1 7.2 9.8 6.2 20.4l-.2 1.6v.1l-.3 1.6v.2c-.1.5-.2 1.1-.4 1.6 0 .1 0 .1-.1.2-.1.6-.3 1.1-.5 1.7 0 .1 0 .1-.1.2-.8 2.6-1.8 5.3-3.3 8.3.1.1.2.2.4.3 5.7 5.6 13.5 9.1 22.2 9.3z"/> <path fill="#DD2C00" d="M85.6 128h5.1"/> <circle fill="#444" cx="95.8" cy="46.5" r="2"/> </svg> <svg viewBox="0 0 128 128" height="128" width="128" id="svg-9" x="384" y="384"> <path fill="#FFCC80" d="M41.6 123.8s0 .1-.1.1l.3-.4c-.1.2-.1.2-.2.3z"/> <path fill="#FFFF8D" d="M0 0h128v128H0z"/> <path fill="#C2C2C2" d="M83.2 26.6c.1-.9.2-1.8.2-2.7C83.4 13.5 75 5 64.6 5s-18.8 8.4-18.8 18.8c0 1.4.2 2.7.4 4 5.4-4 12.2-6.4 19.4-6.4 6.5.1 12.5 2 17.6 5.2z"/> <path fill="#848484" d="M41.4 58.4c9.6-1.9 10.3-10.7 11.7-13.2 4.2 5.4 12.4 16.6 36.8 13.5 1.5-2.5 4.4-6 7.4-5.6.3 0 .6.1 1 .2C98 42 92 32.1 83.1 26.5 78 23.3 72 21.4 65.6 21.4c-7.3 0-14 2.4-19.4 6.4-7.9 5.9-13.1 15.2-13.3 25.7.4-.1.9 1.7 1.4 1.7 2.8-.4 5.6 1 7.1 3.2z"/> <path fill="#FF5722" d="M109.6 121.5c-1.2-2-2.2-3.6-2.9-4.8l-1.2-1.8-.2-.3c-.5-.8-1.1-1.6-1.8-2.3-3.1-3.3-6.9-5.1-10.8-5.3 0 0 .1 0 .1.1l-.2-.1c-3.4 3.7-7.8 6.6-12.7 8.5V128h33.4c-1.4-2.5-2.6-4.7-3.7-6.5zM42 106l-.2.5c-2.9.8-5.6 2.5-7.8 5.1l-.2.2s-.5.6-1.4 1.6c-.9 1-2 2.4-3.5 4.2-2.1 2.6-4.7 6.1-7.5 10.4h28v-15.7c-2.8-1.7-5.3-3.8-7.4-6.3z"/> <path fill="#E0F7FA" d="M67.7 117.7c-6.8-.2-13.1-2.1-18.3-5.4V128h30.5v-12.6c-3.8 1.4-7.9 2.2-12.2 2.3z"/> <path fill="#FFE0B2" d="M42 106c2.1 2.4 4.6 4.5 7.4 6.3 5.2 3.3 11.5 5.3 18.3 5.4 4.3-.1 8.4-.9 12.1-2.3 5-1.9 9.3-4.8 12.7-8.5l.2.1s-.1 0-.1-.1c-15.7-12.3-12-21.7-7.8-26.6 1.3-1.1 2.6-2.3 4.1-3.6l12.2-10.3c1.4-1.2 2.4-2.8 2.7-4.8.5-3.8-1.9-7.3-5.4-8.2-.3-.1-.6-.2-1-.2-3.1-.4-5.9 1.1-7.4 3.6-24.4 3.1-32.7-8.1-36.8-13.5-1.5 2.4-2.1 11.3-11.7 13.2-1.6-2.3-4.3-3.6-7.2-3.2l-1.4.3c-3.4 1.1-5.5 4.5-5 8.1.3 1.9 1.3 3.6 2.6 4.7l10.2 8.7c5.8 6 14.1 18.3 1.4 30.7-.1.1-.1.2-.1.2zm37.6-45.3c.8 0 1.5.7 1.5 1.5s-.7 1.5-1.5 1.5-1.5-.7-1.5-1.5c-.1-.9.6-1.5 1.5-1.5zm-24 0c.8 0 1.5.7 1.5 1.5s-.7 1.5-1.5 1.5-1.5-.7-1.5-1.5c-.1-.9.6-1.5 1.5-1.5z"/> <circle fill="#444" cx="79.6" cy="62.2" r="2"/> <circle fill="#444" cx="55.6" cy="62.2" r="2"/> </svg> </defs></svg>',
  };

  // Note: 'material.svgAssetsCache' is used with AngularJS Material docs
  // when launching code pen demos; @see codepen.js

  angular.module('material.svgAssetsCache',[])
    .run(function($templateCache) {
      angular.forEach(assetMap, function(value, key) {
        $templateCache.put(key, value);
      });
    });
})();
