#!/bin/sh

set -xe

composer_update () {
    COMPOSER_ARGS=$1 ;

    composer update ${COMPOSER_ARGS} ;
    composer show ;
}

phpunit () {
    COVERAGE=$1

    if [ ${COVERAGE} = '1' ] ; then
        echo "zend_extension=xdebug.so" > /etc/php7/conf.d/xdebug.ini ;
        export PHPUNIT_ARGS='--coverage-text --coverage-html coverage' ;
    fi ;

    vendor/bin/phpunit --configuration phpunit.xml.dist --colors=never ${PHPUNIT_ARGS}
}

phpmd () {
    BINARY_PHPMD=phpmd

    if [ ! -f "$BINARY_PHPMD" ]; then
        composer require "phpmd/phpmd:dev-master" --dev
        BINARY_PHPMD=vendor/bin/phpmd

        #curl -o phpmd -L http://static.phpmd.org/php/latest/phpmd.phar ;
        #chmod +x phpmd ;
    fi ;

    "./$BINARY_PHPMD" src text ruleset.xml --reportfile-html phpmd.html ;
}

case $1 in
    composer_update_prefer_latest) composer_update ;;
    composer_update_prefer_lowest) composer_update '--prefer-lowest' ;;
    phpunit) phpunit 0 ;;
    phpunit_with_coverage) phpunit 1 ;;
    phpmd) phpmd ;;
esac
