import os.path
import re
import sys

pattern = re.compile(r"void\s+(onspawn|ai|ondeath)_(\w+)")

ai_dir = sys.argv[1]
ai_out = sys.argv[2]

matches = []
for fn in os.listdir(ai_dir):
	if os.path.isfile(ai_dir + fn):
		with open(ai_dir + fn, "r") as f:
			matches += pattern.findall(f.read())

with open(ai_out, "w") as header:
	header.write("// Generated by aigen.py - do not edit\n")
	for m in matches:
		header.write("void " + m[0] + "_" + m[1] + "(Entity *);\n")
