#include "common.h"

const uint16_t *time_tab;
const int16_t *speed_tab;

const uint16_t time_tab_ntsc[0x400] = {
    0x0000, 0x0001, 0x0002, 0x0003, 0x0005, 0x0006, 0x0007, 0x0008,
    0x0009, 0x000b, 0x000c, 0x000d, 0x000e, 0x000f, 0x0011, 0x0012,
    0x0013, 0x0014, 0x0015, 0x0017, 0x0018, 0x0019, 0x001a, 0x001b,
    0x001d, 0x001e, 0x001f, 0x0020, 0x0021, 0x0023, 0x0024, 0x0025,
    0x0026, 0x0027, 0x0029, 0x002a, 0x002b, 0x002c, 0x002d, 0x002f,
    0x0030, 0x0031, 0x0032, 0x0033, 0x0035, 0x0036, 0x0037, 0x0038,
    0x0039, 0x003b, 0x003c, 0x003d, 0x003e, 0x003f, 0x0041, 0x0042,
    0x0043, 0x0044, 0x0045, 0x0047, 0x0048, 0x0049, 0x004a, 0x004b,
    0x004d, 0x004e, 0x004f, 0x0050, 0x0051, 0x0053, 0x0054, 0x0055,
    0x0056, 0x0057, 0x0059, 0x005a, 0x005b, 0x005c, 0x005d, 0x005f,
    0x0060, 0x0061, 0x0062, 0x0063, 0x0065, 0x0066, 0x0067, 0x0068,
    0x0069, 0x006b, 0x006c, 0x006d, 0x006e, 0x006f, 0x0071, 0x0072,
    0x0073, 0x0074, 0x0075, 0x0077, 0x0078, 0x0079, 0x007a, 0x007b,
    0x007d, 0x007e, 0x007f, 0x0080, 0x0081, 0x0083, 0x0084, 0x0085,
    0x0086, 0x0087, 0x0089, 0x008a, 0x008b, 0x008c, 0x008d, 0x008f,
    0x0090, 0x0091, 0x0092, 0x0093, 0x0095, 0x0096, 0x0097, 0x0098,
    0x0099, 0x009b, 0x009c, 0x009d, 0x009e, 0x009f, 0x00a1, 0x00a2,
    0x00a3, 0x00a4, 0x00a5, 0x00a7, 0x00a8, 0x00a9, 0x00aa, 0x00ab,
    0x00ad, 0x00ae, 0x00af, 0x00b0, 0x00b1, 0x00b3, 0x00b4, 0x00b5,
    0x00b6, 0x00b7, 0x00b9, 0x00ba, 0x00bb, 0x00bc, 0x00bd, 0x00bf,
    0x00c0, 0x00c1, 0x00c2, 0x00c3, 0x00c5, 0x00c6, 0x00c7, 0x00c8,
    0x00c9, 0x00cb, 0x00cc, 0x00cd, 0x00ce, 0x00cf, 0x00d1, 0x00d2,
    0x00d3, 0x00d4, 0x00d5, 0x00d7, 0x00d8, 0x00d9, 0x00da, 0x00db,
    0x00dd, 0x00de, 0x00df, 0x00e0, 0x00e1, 0x00e3, 0x00e4, 0x00e5,
    0x00e6, 0x00e7, 0x00e9, 0x00ea, 0x00eb, 0x00ec, 0x00ed, 0x00ef,
    0x00f0, 0x00f1, 0x00f2, 0x00f3, 0x00f5, 0x00f6, 0x00f7, 0x00f8,
    0x00f9, 0x00fb, 0x00fc, 0x00fd, 0x00fe, 0x00ff, 0x0101, 0x0102,
    0x0103, 0x0104, 0x0105, 0x0107, 0x0108, 0x0109, 0x010a, 0x010b,
    0x010d, 0x010e, 0x010f, 0x0110, 0x0111, 0x0113, 0x0114, 0x0115,
    0x0116, 0x0117, 0x0119, 0x011a, 0x011b, 0x011c, 0x011d, 0x011f,
    0x0120, 0x0121, 0x0122, 0x0123, 0x0125, 0x0126, 0x0127, 0x0128,
    0x0129, 0x012b, 0x012c, 0x012d, 0x012e, 0x012f, 0x0131, 0x0132,
    0x0133, 0x0134, 0x0135, 0x0137, 0x0138, 0x0139, 0x013a, 0x013b,
    0x013d, 0x013e, 0x013f, 0x0140, 0x0141, 0x0143, 0x0144, 0x0145,
    0x0146, 0x0147, 0x0149, 0x014a, 0x014b, 0x014c, 0x014d, 0x014f,
    0x0150, 0x0151, 0x0152, 0x0153, 0x0155, 0x0156, 0x0157, 0x0158,
    0x0159, 0x015b, 0x015c, 0x015d, 0x015e, 0x015f, 0x0161, 0x0162,
    0x0163, 0x0164, 0x0165, 0x0167, 0x0168, 0x0169, 0x016a, 0x016b,
    0x016d, 0x016e, 0x016f, 0x0170, 0x0171, 0x0173, 0x0174, 0x0175,
    0x0176, 0x0177, 0x0179, 0x017a, 0x017b, 0x017c, 0x017d, 0x017f,
    0x0180, 0x0181, 0x0182, 0x0183, 0x0185, 0x0186, 0x0187, 0x0188,
    0x0189, 0x018b, 0x018c, 0x018d, 0x018e, 0x018f, 0x0191, 0x0192,
    0x0193, 0x0194, 0x0195, 0x0197, 0x0198, 0x0199, 0x019a, 0x019b,
    0x019d, 0x019e, 0x019f, 0x01a0, 0x01a1, 0x01a3, 0x01a4, 0x01a5,
    0x01a6, 0x01a7, 0x01a9, 0x01aa, 0x01ab, 0x01ac, 0x01ad, 0x01af,
    0x01b0, 0x01b1, 0x01b2, 0x01b3, 0x01b5, 0x01b6, 0x01b7, 0x01b8,
    0x01b9, 0x01bb, 0x01bc, 0x01bd, 0x01be, 0x01bf, 0x01c1, 0x01c2,
    0x01c3, 0x01c4, 0x01c5, 0x01c7, 0x01c8, 0x01c9, 0x01ca, 0x01cb,
    0x01cd, 0x01ce, 0x01cf, 0x01d0, 0x01d1, 0x01d3, 0x01d4, 0x01d5,
    0x01d6, 0x01d7, 0x01d9, 0x01da, 0x01db, 0x01dc, 0x01dd, 0x01df,
    0x01e0, 0x01e1, 0x01e2, 0x01e3, 0x01e5, 0x01e6, 0x01e7, 0x01e8,
    0x01e9, 0x01eb, 0x01ec, 0x01ed, 0x01ee, 0x01ef, 0x01f1, 0x01f2,
    0x01f3, 0x01f4, 0x01f5, 0x01f7, 0x01f8, 0x01f9, 0x01fa, 0x01fb,
    0x01fd, 0x01fe, 0x01ff, 0x0200, 0x0201, 0x0203, 0x0204, 0x0205,
    0x0206, 0x0207, 0x0209, 0x020a, 0x020b, 0x020c, 0x020d, 0x020f,
    0x0210, 0x0211, 0x0212, 0x0213, 0x0215, 0x0216, 0x0217, 0x0218,
    0x0219, 0x021b, 0x021c, 0x021d, 0x021e, 0x021f, 0x0221, 0x0222,
    0x0223, 0x0224, 0x0225, 0x0227, 0x0228, 0x0229, 0x022a, 0x022b,
    0x022d, 0x022e, 0x022f, 0x0230, 0x0231, 0x0233, 0x0234, 0x0235,
    0x0236, 0x0237, 0x0239, 0x023a, 0x023b, 0x023c, 0x023d, 0x023f,
    0x0240, 0x0241, 0x0242, 0x0243, 0x0245, 0x0246, 0x0247, 0x0248,
    0x0249, 0x024b, 0x024c, 0x024d, 0x024e, 0x024f, 0x0251, 0x0252,
    0x0253, 0x0254, 0x0255, 0x0257, 0x0258, 0x0259, 0x025a, 0x025b,
    0x025d, 0x025e, 0x025f, 0x0260, 0x0261, 0x0263, 0x0264, 0x0265,
    0x0266, 0x0267, 0x0269, 0x026a, 0x026b, 0x026c, 0x026d, 0x026f,
    0x0270, 0x0271, 0x0272, 0x0273, 0x0275, 0x0276, 0x0277, 0x0278,
    0x0279, 0x027b, 0x027c, 0x027d, 0x027e, 0x027f, 0x0281, 0x0282,
    0x0283, 0x0284, 0x0285, 0x0287, 0x0288, 0x0289, 0x028a, 0x028b,
    0x028d, 0x028e, 0x028f, 0x0290, 0x0291, 0x0293, 0x0294, 0x0295,
    0x0296, 0x0297, 0x0299, 0x029a, 0x029b, 0x029c, 0x029d, 0x029f,
    0x02a0, 0x02a1, 0x02a2, 0x02a3, 0x02a5, 0x02a6, 0x02a7, 0x02a8,
    0x02a9, 0x02ab, 0x02ac, 0x02ad, 0x02ae, 0x02af, 0x02b1, 0x02b2,
    0x02b3, 0x02b4, 0x02b5, 0x02b7, 0x02b8, 0x02b9, 0x02ba, 0x02bb,
    0x02bd, 0x02be, 0x02bf, 0x02c0, 0x02c1, 0x02c3, 0x02c4, 0x02c5,
    0x02c6, 0x02c7, 0x02c9, 0x02ca, 0x02cb, 0x02cc, 0x02cd, 0x02cf,
    0x02d0, 0x02d1, 0x02d2, 0x02d3, 0x02d5, 0x02d6, 0x02d7, 0x02d8,
    0x02d9, 0x02db, 0x02dc, 0x02dd, 0x02de, 0x02df, 0x02e1, 0x02e2,
    0x02e3, 0x02e4, 0x02e5, 0x02e7, 0x02e8, 0x02e9, 0x02ea, 0x02eb,
    0x02ed, 0x02ee, 0x02ef, 0x02f0, 0x02f1, 0x02f3, 0x02f4, 0x02f5,
    0x02f6, 0x02f7, 0x02f9, 0x02fa, 0x02fb, 0x02fc, 0x02fd, 0x02ff,
    0x0300, 0x0301, 0x0302, 0x0303, 0x0305, 0x0306, 0x0307, 0x0308,
    0x0309, 0x030b, 0x030c, 0x030d, 0x030e, 0x030f, 0x0311, 0x0312,
    0x0313, 0x0314, 0x0315, 0x0317, 0x0318, 0x0319, 0x031a, 0x031b,
    0x031d, 0x031e, 0x031f, 0x0320, 0x0321, 0x0323, 0x0324, 0x0325,
    0x0326, 0x0327, 0x0329, 0x032a, 0x032b, 0x032c, 0x032d, 0x032f,
    0x0330, 0x0331, 0x0332, 0x0333, 0x0335, 0x0336, 0x0337, 0x0338,
    0x0339, 0x033b, 0x033c, 0x033d, 0x033e, 0x033f, 0x0341, 0x0342,
    0x0343, 0x0344, 0x0345, 0x0347, 0x0348, 0x0349, 0x034a, 0x034b,
    0x034d, 0x034e, 0x034f, 0x0350, 0x0351, 0x0353, 0x0354, 0x0355,
    0x0356, 0x0357, 0x0359, 0x035a, 0x035b, 0x035c, 0x035d, 0x035f,
    0x0360, 0x0361, 0x0362, 0x0363, 0x0365, 0x0366, 0x0367, 0x0368,
    0x0369, 0x036b, 0x036c, 0x036d, 0x036e, 0x036f, 0x0371, 0x0372,
    0x0373, 0x0374, 0x0375, 0x0377, 0x0378, 0x0379, 0x037a, 0x037b,
    0x037d, 0x037e, 0x037f, 0x0380, 0x0381, 0x0383, 0x0384, 0x0385,
    0x0386, 0x0387, 0x0389, 0x038a, 0x038b, 0x038c, 0x038d, 0x038f,
    0x0390, 0x0391, 0x0392, 0x0393, 0x0395, 0x0396, 0x0397, 0x0398,
    0x0399, 0x039b, 0x039c, 0x039d, 0x039e, 0x039f, 0x03a1, 0x03a2,
    0x03a3, 0x03a4, 0x03a5, 0x03a7, 0x03a8, 0x03a9, 0x03aa, 0x03ab,
    0x03ad, 0x03ae, 0x03af, 0x03b0, 0x03b1, 0x03b3, 0x03b4, 0x03b5,
    0x03b6, 0x03b7, 0x03b9, 0x03ba, 0x03bb, 0x03bc, 0x03bd, 0x03bf,
    0x03c0, 0x03c1, 0x03c2, 0x03c3, 0x03c5, 0x03c6, 0x03c7, 0x03c8,
    0x03c9, 0x03cb, 0x03cc, 0x03cd, 0x03ce, 0x03cf, 0x03d1, 0x03d2,
    0x03d3, 0x03d4, 0x03d5, 0x03d7, 0x03d8, 0x03d9, 0x03da, 0x03db,
    0x03dd, 0x03de, 0x03df, 0x03e0, 0x03e1, 0x03e3, 0x03e4, 0x03e5,
    0x03e6, 0x03e7, 0x03e9, 0x03ea, 0x03eb, 0x03ec, 0x03ed, 0x03ef,
    0x03f0, 0x03f1, 0x03f2, 0x03f3, 0x03f5, 0x03f6, 0x03f7, 0x03f8,
    0x03f9, 0x03fb, 0x03fc, 0x03fd, 0x03fe, 0x03ff, 0x0401, 0x0402,
    0x0403, 0x0404, 0x0405, 0x0407, 0x0408, 0x0409, 0x040a, 0x040b,
    0x040d, 0x040e, 0x040f, 0x0410, 0x0411, 0x0413, 0x0414, 0x0415,
    0x0416, 0x0417, 0x0419, 0x041a, 0x041b, 0x041c, 0x041d, 0x041f,
    0x0420, 0x0421, 0x0422, 0x0423, 0x0425, 0x0426, 0x0427, 0x0428,
    0x0429, 0x042b, 0x042c, 0x042d, 0x042e, 0x042f, 0x0431, 0x0432,
    0x0433, 0x0434, 0x0435, 0x0437, 0x0438, 0x0439, 0x043a, 0x043b,
    0x043d, 0x043e, 0x043f, 0x0440, 0x0441, 0x0443, 0x0444, 0x0445,
    0x0446, 0x0447, 0x0449, 0x044a, 0x044b, 0x044c, 0x044d, 0x044f,
    0x0450, 0x0451, 0x0452, 0x0453, 0x0455, 0x0456, 0x0457, 0x0458,
    0x0459, 0x045b, 0x045c, 0x045d, 0x045e, 0x045f, 0x0461, 0x0462,
    0x0463, 0x0464, 0x0465, 0x0467, 0x0468, 0x0469, 0x046a, 0x046b,
    0x046d, 0x046e, 0x046f, 0x0470, 0x0471, 0x0473, 0x0474, 0x0475,
    0x0476, 0x0477, 0x0479, 0x047a, 0x047b, 0x047c, 0x047d, 0x047f,
    0x0480, 0x0481, 0x0482, 0x0483, 0x0485, 0x0486, 0x0487, 0x0488,
    0x0489, 0x048b, 0x048c, 0x048d, 0x048e, 0x048f, 0x0491, 0x0492,
    0x0493, 0x0494, 0x0495, 0x0497, 0x0498, 0x0499, 0x049a, 0x049b,
    0x049d, 0x049e, 0x049f, 0x04a0, 0x04a1, 0x04a3, 0x04a4, 0x04a5,
    0x04a6, 0x04a7, 0x04a9, 0x04aa, 0x04ab, 0x04ac, 0x04ad, 0x04af,
    0x04b0, 0x04b1, 0x04b2, 0x04b3, 0x04b5, 0x04b6, 0x04b7, 0x04b8,
    0x04b9, 0x04bb, 0x04bc, 0x04bd, 0x04be, 0x04bf, 0x04c1, 0x04c2,
    0x04c3, 0x04c4, 0x04c5, 0x04c7, 0x04c8, 0x04c9, 0x04ca, 0x04cb,
};

const int16_t speed_tab_ntsc[0x400] = {
    0x0000, 0x0001, 0x0001, 0x0002, 0x0003, 0x0004, 0x0005, 0x0006,
    0x0006, 0x0007, 0x0008, 0x0009, 0x000a, 0x000b, 0x000b, 0x000c,
    0x000d, 0x000e, 0x000f, 0x0010, 0x0010, 0x0011, 0x0012, 0x0013,
    0x0014, 0x0015, 0x0015, 0x0016, 0x0017, 0x0018, 0x0019, 0x001a,
    0x001a, 0x001b, 0x001c, 0x001d, 0x001e, 0x001f, 0x001f, 0x0020,
    0x0021, 0x0022, 0x0023, 0x0024, 0x0024, 0x0025, 0x0026, 0x0027,
    0x0028, 0x0029, 0x0029, 0x002a, 0x002b, 0x002c, 0x002d, 0x002e,
    0x002e, 0x002f, 0x0030, 0x0031, 0x0032, 0x0033, 0x0033, 0x0034,
    0x0035, 0x0036, 0x0037, 0x0038, 0x0038, 0x0039, 0x003a, 0x003b,
    0x003c, 0x003d, 0x003d, 0x003e, 0x003f, 0x0040, 0x0041, 0x0042,
    0x0042, 0x0043, 0x0044, 0x0045, 0x0046, 0x0047, 0x0047, 0x0048,
    0x0049, 0x004a, 0x004b, 0x004c, 0x004c, 0x004d, 0x004e, 0x004f,
    0x0050, 0x0051, 0x0051, 0x0052, 0x0053, 0x0054, 0x0055, 0x0056,
    0x0056, 0x0057, 0x0058, 0x0059, 0x005a, 0x005b, 0x005b, 0x005c,
    0x005d, 0x005e, 0x005f, 0x0060, 0x0060, 0x0061, 0x0062, 0x0063,
    0x0064, 0x0065, 0x0065, 0x0066, 0x0067, 0x0068, 0x0069, 0x006a,
    0x006a, 0x006b, 0x006c, 0x006d, 0x006e, 0x006f, 0x006f, 0x0070,
    0x0071, 0x0072, 0x0073, 0x0074, 0x0074, 0x0075, 0x0076, 0x0077,
    0x0078, 0x0079, 0x0079, 0x007a, 0x007b, 0x007c, 0x007d, 0x007e,
    0x007e, 0x007f, 0x0080, 0x0081, 0x0082, 0x0083, 0x0083, 0x0084,
    0x0085, 0x0086, 0x0087, 0x0088, 0x0088, 0x0089, 0x008a, 0x008b,
    0x008c, 0x008d, 0x008d, 0x008e, 0x008f, 0x0090, 0x0091, 0x0092,
    0x0092, 0x0093, 0x0094, 0x0095, 0x0096, 0x0097, 0x0097, 0x0098,
    0x0099, 0x009a, 0x009b, 0x009c, 0x009c, 0x009d, 0x009e, 0x009f,
    0x00a0, 0x00a1, 0x00a1, 0x00a2, 0x00a3, 0x00a4, 0x00a5, 0x00a6,
    0x00a6, 0x00a7, 0x00a8, 0x00a9, 0x00aa, 0x00ab, 0x00ab, 0x00ac,
    0x00ad, 0x00ae, 0x00af, 0x00b0, 0x00b0, 0x00b1, 0x00b2, 0x00b3,
    0x00b4, 0x00b5, 0x00b5, 0x00b6, 0x00b7, 0x00b8, 0x00b9, 0x00ba,
    0x00ba, 0x00bb, 0x00bc, 0x00bd, 0x00be, 0x00bf, 0x00bf, 0x00c0,
    0x00c1, 0x00c2, 0x00c3, 0x00c4, 0x00c4, 0x00c5, 0x00c6, 0x00c7,
    0x00c8, 0x00c9, 0x00c9, 0x00ca, 0x00cb, 0x00cc, 0x00cd, 0x00ce,
    0x00ce, 0x00cf, 0x00d0, 0x00d1, 0x00d2, 0x00d3, 0x00d3, 0x00d4,
    0x00d5, 0x00d6, 0x00d7, 0x00d8, 0x00d8, 0x00d9, 0x00da, 0x00db,
    0x00dc, 0x00dd, 0x00dd, 0x00de, 0x00df, 0x00e0, 0x00e1, 0x00e2,
    0x00e2, 0x00e3, 0x00e4, 0x00e5, 0x00e6, 0x00e7, 0x00e7, 0x00e8,
    0x00e9, 0x00ea, 0x00eb, 0x00ec, 0x00ec, 0x00ed, 0x00ee, 0x00ef,
    0x00f0, 0x00f1, 0x00f1, 0x00f2, 0x00f3, 0x00f4, 0x00f5, 0x00f6,
    0x00f6, 0x00f7, 0x00f8, 0x00f9, 0x00fa, 0x00fb, 0x00fb, 0x00fc,
    0x00fd, 0x00fe, 0x00ff, 0x0100, 0x0100, 0x0101, 0x0102, 0x0103,
    0x0104, 0x0105, 0x0105, 0x0106, 0x0107, 0x0108, 0x0109, 0x010a,
    0x010a, 0x010b, 0x010c, 0x010d, 0x010e, 0x010f, 0x010f, 0x0110,
    0x0111, 0x0112, 0x0113, 0x0114, 0x0114, 0x0115, 0x0116, 0x0117,
    0x0118, 0x0119, 0x0119, 0x011a, 0x011b, 0x011c, 0x011d, 0x011e,
    0x011e, 0x011f, 0x0120, 0x0121, 0x0122, 0x0123, 0x0123, 0x0124,
    0x0125, 0x0126, 0x0127, 0x0128, 0x0128, 0x0129, 0x012a, 0x012b,
    0x012c, 0x012d, 0x012d, 0x012e, 0x012f, 0x0130, 0x0131, 0x0132,
    0x0132, 0x0133, 0x0134, 0x0135, 0x0136, 0x0137, 0x0137, 0x0138,
    0x0139, 0x013a, 0x013b, 0x013c, 0x013c, 0x013d, 0x013e, 0x013f,
    0x0140, 0x0141, 0x0141, 0x0142, 0x0143, 0x0144, 0x0145, 0x0146,
    0x0146, 0x0147, 0x0148, 0x0149, 0x014a, 0x014b, 0x014b, 0x014c,
    0x014d, 0x014e, 0x014f, 0x0150, 0x0150, 0x0151, 0x0152, 0x0153,
    0x0154, 0x0155, 0x0155, 0x0156, 0x0157, 0x0158, 0x0159, 0x015a,
    0x015a, 0x015b, 0x015c, 0x015d, 0x015e, 0x015f, 0x015f, 0x0160,
    0x0161, 0x0162, 0x0163, 0x0164, 0x0164, 0x0165, 0x0166, 0x0167,
    0x0168, 0x0169, 0x0169, 0x016a, 0x016b, 0x016c, 0x016d, 0x016e,
    0x016e, 0x016f, 0x0170, 0x0171, 0x0172, 0x0173, 0x0173, 0x0174,
    0x0175, 0x0176, 0x0177, 0x0178, 0x0178, 0x0179, 0x017a, 0x017b,
    0x017c, 0x017d, 0x017d, 0x017e, 0x017f, 0x0180, 0x0181, 0x0182,
    0x0182, 0x0183, 0x0184, 0x0185, 0x0186, 0x0187, 0x0187, 0x0188,
    0x0189, 0x018a, 0x018b, 0x018c, 0x018c, 0x018d, 0x018e, 0x018f,
    0x0190, 0x0191, 0x0191, 0x0192, 0x0193, 0x0194, 0x0195, 0x0196,
    0x0196, 0x0197, 0x0198, 0x0199, 0x019a, 0x019b, 0x019b, 0x019c,
    0x019d, 0x019e, 0x019f, 0x01a0, 0x01a0, 0x01a1, 0x01a2, 0x01a3,
    0x01a4, 0x01a5, 0x01a5, 0x01a6, 0x01a7, 0x01a8, 0x01a9, 0x01aa,
    0x01aa, 0x01ab, 0x01ac, 0x01ad, 0x01ae, 0x01af, 0x01af, 0x01b0,
    0x01b1, 0x01b2, 0x01b3, 0x01b4, 0x01b4, 0x01b5, 0x01b6, 0x01b7,
    0x01b8, 0x01b9, 0x01b9, 0x01ba, 0x01bb, 0x01bc, 0x01bd, 0x01be,
    0x01be, 0x01bf, 0x01c0, 0x01c1, 0x01c2, 0x01c3, 0x01c3, 0x01c4,
    0x01c5, 0x01c6, 0x01c7, 0x01c8, 0x01c8, 0x01c9, 0x01ca, 0x01cb,
    0x01cc, 0x01cd, 0x01cd, 0x01ce, 0x01cf, 0x01d0, 0x01d1, 0x01d2,
    0x01d2, 0x01d3, 0x01d4, 0x01d5, 0x01d6, 0x01d7, 0x01d7, 0x01d8,
    0x01d9, 0x01da, 0x01db, 0x01dc, 0x01dc, 0x01dd, 0x01de, 0x01df,
    0x01e0, 0x01e1, 0x01e1, 0x01e2, 0x01e3, 0x01e4, 0x01e5, 0x01e6,
    0x01e6, 0x01e7, 0x01e8, 0x01e9, 0x01ea, 0x01eb, 0x01eb, 0x01ec,
    0x01ed, 0x01ee, 0x01ef, 0x01f0, 0x01f0, 0x01f1, 0x01f2, 0x01f3,
    0x01f4, 0x01f5, 0x01f5, 0x01f6, 0x01f7, 0x01f8, 0x01f9, 0x01fa,
    0x01fa, 0x01fb, 0x01fc, 0x01fd, 0x01fe, 0x01ff, 0x01ff, 0x0200,
    0x0201, 0x0202, 0x0203, 0x0204, 0x0204, 0x0205, 0x0206, 0x0207,
    0x0208, 0x0209, 0x0209, 0x020a, 0x020b, 0x020c, 0x020d, 0x020e,
    0x020e, 0x020f, 0x0210, 0x0211, 0x0212, 0x0213, 0x0213, 0x0214,
    0x0215, 0x0216, 0x0217, 0x0218, 0x0218, 0x0219, 0x021a, 0x021b,
    0x021c, 0x021d, 0x021d, 0x021e, 0x021f, 0x0220, 0x0221, 0x0222,
    0x0222, 0x0223, 0x0224, 0x0225, 0x0226, 0x0227, 0x0227, 0x0228,
    0x0229, 0x022a, 0x022b, 0x022c, 0x022c, 0x022d, 0x022e, 0x022f,
    0x0230, 0x0231, 0x0231, 0x0232, 0x0233, 0x0234, 0x0235, 0x0236,
    0x0236, 0x0237, 0x0238, 0x0239, 0x023a, 0x023b, 0x023b, 0x023c,
    0x023d, 0x023e, 0x023f, 0x0240, 0x0240, 0x0241, 0x0242, 0x0243,
    0x0244, 0x0245, 0x0245, 0x0246, 0x0247, 0x0248, 0x0249, 0x024a,
    0x024a, 0x024b, 0x024c, 0x024d, 0x024e, 0x024f, 0x024f, 0x0250,
    0x0251, 0x0252, 0x0253, 0x0254, 0x0254, 0x0255, 0x0256, 0x0257,
    0x0258, 0x0259, 0x0259, 0x025a, 0x025b, 0x025c, 0x025d, 0x025e,
    0x025e, 0x025f, 0x0260, 0x0261, 0x0262, 0x0263, 0x0263, 0x0264,
    0x0265, 0x0266, 0x0267, 0x0268, 0x0268, 0x0269, 0x026a, 0x026b,
    0x026c, 0x026d, 0x026d, 0x026e, 0x026f, 0x0270, 0x0271, 0x0272,
    0x0272, 0x0273, 0x0274, 0x0275, 0x0276, 0x0277, 0x0277, 0x0278,
    0x0279, 0x027a, 0x027b, 0x027c, 0x027c, 0x027d, 0x027e, 0x027f,
    0x0280, 0x0281, 0x0281, 0x0282, 0x0283, 0x0284, 0x0285, 0x0286,
    0x0286, 0x0287, 0x0288, 0x0289, 0x028a, 0x028b, 0x028b, 0x028c,
    0x028d, 0x028e, 0x028f, 0x0290, 0x0290, 0x0291, 0x0292, 0x0293,
    0x0294, 0x0295, 0x0295, 0x0296, 0x0297, 0x0298, 0x0299, 0x029a,
    0x029a, 0x029b, 0x029c, 0x029d, 0x029e, 0x029f, 0x029f, 0x02a0,
    0x02a1, 0x02a2, 0x02a3, 0x02a4, 0x02a4, 0x02a5, 0x02a6, 0x02a7,
    0x02a8, 0x02a9, 0x02a9, 0x02aa, 0x02ab, 0x02ac, 0x02ad, 0x02ae,
    0x02ae, 0x02af, 0x02b0, 0x02b1, 0x02b2, 0x02b3, 0x02b3, 0x02b4,
    0x02b5, 0x02b6, 0x02b7, 0x02b8, 0x02b8, 0x02b9, 0x02ba, 0x02bb,
    0x02bc, 0x02bd, 0x02bd, 0x02be, 0x02bf, 0x02c0, 0x02c1, 0x02c2,
    0x02c2, 0x02c3, 0x02c4, 0x02c5, 0x02c6, 0x02c7, 0x02c7, 0x02c8,
    0x02c9, 0x02ca, 0x02cb, 0x02cc, 0x02cc, 0x02cd, 0x02ce, 0x02cf,
    0x02d0, 0x02d1, 0x02d1, 0x02d2, 0x02d3, 0x02d4, 0x02d5, 0x02d6,
    0x02d6, 0x02d7, 0x02d8, 0x02d9, 0x02da, 0x02db, 0x02db, 0x02dc,
    0x02dd, 0x02de, 0x02df, 0x02e0, 0x02e0, 0x02e1, 0x02e2, 0x02e3,
    0x02e4, 0x02e5, 0x02e5, 0x02e6, 0x02e7, 0x02e8, 0x02e9, 0x02ea,
    0x02ea, 0x02eb, 0x02ec, 0x02ed, 0x02ee, 0x02ef, 0x02ef, 0x02f0,
    0x02f1, 0x02f2, 0x02f3, 0x02f4, 0x02f4, 0x02f5, 0x02f6, 0x02f7,
    0x02f8, 0x02f9, 0x02f9, 0x02fa, 0x02fb, 0x02fc, 0x02fd, 0x02fe,
    0x02fe, 0x02ff, 0x0300, 0x0301, 0x0302, 0x0303, 0x0303, 0x0304,
    0x0305, 0x0306, 0x0307, 0x0308, 0x0308, 0x0309, 0x030a, 0x030b,
    0x030c, 0x030d, 0x030d, 0x030e, 0x030f, 0x0310, 0x0311, 0x0312,
    0x0312, 0x0313, 0x0314, 0x0315, 0x0316, 0x0317, 0x0317, 0x0318,
    0x0319, 0x031a, 0x031b, 0x031c, 0x031c, 0x031d, 0x031e, 0x031f,
    0x0320, 0x0321, 0x0321, 0x0322, 0x0323, 0x0324, 0x0325, 0x0326,
    0x0326, 0x0327, 0x0328, 0x0329, 0x032a, 0x032b, 0x032b, 0x032c,
    0x032d, 0x032e, 0x032f, 0x0330, 0x0330, 0x0331, 0x0332, 0x0333,
    0x0334, 0x0335, 0x0335, 0x0336, 0x0337, 0x0338, 0x0339, 0x033a,
    0x033a, 0x033b, 0x033c, 0x033d, 0x033e, 0x033f, 0x033f, 0x0340,
    0x0341, 0x0342, 0x0343, 0x0344, 0x0344, 0x0345, 0x0346, 0x0347,
    0x0348, 0x0349, 0x0349, 0x034a, 0x034b, 0x034c, 0x034d, 0x034e,
    0x034e, 0x034f, 0x0350, 0x0351, 0x0352, 0x0353, 0x0353, 0x0354,
};

const uint16_t time_tab_pal[0x400] = {
    0x0000, 0x0001, 0x0002, 0x0003, 0x0004, 0x0005, 0x0006, 0x0007,
    0x0008, 0x0009, 0x000A, 0x000B, 0x000C, 0x000D, 0x000E, 0x000F,
    0x0010, 0x0011, 0x0012, 0x0013, 0x0014, 0x0015, 0x0016, 0x0017,
    0x0018, 0x0019, 0x001A, 0x001B, 0x001C, 0x001D, 0x001E, 0x001F,
    0x0020, 0x0021, 0x0022, 0x0023, 0x0024, 0x0025, 0x0026, 0x0027,
    0x0028, 0x0029, 0x002A, 0x002B, 0x002C, 0x002D, 0x002E, 0x002F,
    0x0030, 0x0031, 0x0032, 0x0033, 0x0034, 0x0035, 0x0036, 0x0037,
    0x0038, 0x0039, 0x003A, 0x003B, 0x003C, 0x003D, 0x003E, 0x003F,
    0x0040, 0x0041, 0x0042, 0x0043, 0x0044, 0x0045, 0x0046, 0x0047,
    0x0048, 0x0049, 0x004A, 0x004B, 0x004C, 0x004D, 0x004E, 0x004F,
    0x0050, 0x0051, 0x0052, 0x0053, 0x0054, 0x0055, 0x0056, 0x0057,
    0x0058, 0x0059, 0x005A, 0x005B, 0x005C, 0x005D, 0x005E, 0x005F,
    0x0060, 0x0061, 0x0062, 0x0063, 0x0064, 0x0065, 0x0066, 0x0067,
    0x0068, 0x0069, 0x006A, 0x006B, 0x006C, 0x006D, 0x006E, 0x006F,
    0x0070, 0x0071, 0x0072, 0x0073, 0x0074, 0x0075, 0x0076, 0x0077,
    0x0078, 0x0079, 0x007A, 0x007B, 0x007C, 0x007D, 0x007E, 0x007F,
    0x0080, 0x0081, 0x0082, 0x0083, 0x0084, 0x0085, 0x0086, 0x0087,
    0x0088, 0x0089, 0x008A, 0x008B, 0x008C, 0x008D, 0x008E, 0x008F,
    0x0090, 0x0091, 0x0092, 0x0093, 0x0094, 0x0095, 0x0096, 0x0097,
    0x0098, 0x0099, 0x009A, 0x009B, 0x009C, 0x009D, 0x009E, 0x009F,
    0x00A0, 0x00A1, 0x00A2, 0x00A3, 0x00A4, 0x00A5, 0x00A6, 0x00A7,
    0x00A8, 0x00A9, 0x00AA, 0x00AB, 0x00AC, 0x00AD, 0x00AE, 0x00AF,
    0x00B0, 0x00B1, 0x00B2, 0x00B3, 0x00B4, 0x00B5, 0x00B6, 0x00B7,
    0x00B8, 0x00B9, 0x00BA, 0x00BB, 0x00BC, 0x00BD, 0x00BE, 0x00BF,
    0x00C0, 0x00C1, 0x00C2, 0x00C3, 0x00C4, 0x00C5, 0x00C6, 0x00C7,
    0x00C8, 0x00C9, 0x00CA, 0x00CB, 0x00CC, 0x00CD, 0x00CE, 0x00CF,
    0x00D0, 0x00D1, 0x00D2, 0x00D3, 0x00D4, 0x00D5, 0x00D6, 0x00D7,
    0x00D8, 0x00D9, 0x00DA, 0x00DB, 0x00DC, 0x00DD, 0x00DE, 0x00DF,
    0x00E0, 0x00E1, 0x00E2, 0x00E3, 0x00E4, 0x00E5, 0x00E6, 0x00E7,
    0x00E8, 0x00E9, 0x00EA, 0x00EB, 0x00EC, 0x00ED, 0x00EE, 0x00EF,
    0x00F0, 0x00F1, 0x00F2, 0x00F3, 0x00F4, 0x00F5, 0x00F6, 0x00F7,
    0x00F8, 0x00F9, 0x00FA, 0x00FB, 0x00FC, 0x00FD, 0x00FE, 0x00FF,
    0x0100, 0x0101, 0x0102, 0x0103, 0x0104, 0x0105, 0x0106, 0x0107,
    0x0108, 0x0109, 0x010A, 0x010B, 0x010C, 0x010D, 0x010E, 0x010F,
    0x0110, 0x0111, 0x0112, 0x0113, 0x0114, 0x0115, 0x0116, 0x0117,
    0x0118, 0x0119, 0x011A, 0x011B, 0x011C, 0x011D, 0x011E, 0x011F,
    0x0120, 0x0121, 0x0122, 0x0123, 0x0124, 0x0125, 0x0126, 0x0127,
    0x0128, 0x0129, 0x012A, 0x012B, 0x012C, 0x012D, 0x012E, 0x012F,
    0x0130, 0x0131, 0x0132, 0x0133, 0x0134, 0x0135, 0x0136, 0x0137,
    0x0138, 0x0139, 0x013A, 0x013B, 0x013C, 0x013D, 0x013E, 0x013F,
    0x0140, 0x0141, 0x0142, 0x0143, 0x0144, 0x0145, 0x0146, 0x0147,
    0x0148, 0x0149, 0x014A, 0x014B, 0x014C, 0x014D, 0x014E, 0x014F,
    0x0150, 0x0151, 0x0152, 0x0153, 0x0154, 0x0155, 0x0156, 0x0157,
    0x0158, 0x0159, 0x015A, 0x015B, 0x015C, 0x015D, 0x015E, 0x015F,
    0x0160, 0x0161, 0x0162, 0x0163, 0x0164, 0x0165, 0x0166, 0x0167,
    0x0168, 0x0169, 0x016A, 0x016B, 0x016C, 0x016D, 0x016E, 0x016F,
    0x0170, 0x0171, 0x0172, 0x0173, 0x0174, 0x0175, 0x0176, 0x0177,
    0x0178, 0x0179, 0x017A, 0x017B, 0x017C, 0x017D, 0x017E, 0x017F,
    0x0180, 0x0181, 0x0182, 0x0183, 0x0184, 0x0185, 0x0186, 0x0187,
    0x0188, 0x0189, 0x018A, 0x018B, 0x018C, 0x018D, 0x018E, 0x018F,
    0x0190, 0x0191, 0x0192, 0x0193, 0x0194, 0x0195, 0x0196, 0x0197,
    0x0198, 0x0199, 0x019A, 0x019B, 0x019C, 0x019D, 0x019E, 0x019F,
    0x01A0, 0x01A1, 0x01A2, 0x01A3, 0x01A4, 0x01A5, 0x01A6, 0x01A7,
    0x01A8, 0x01A9, 0x01AA, 0x01AB, 0x01AC, 0x01AD, 0x01AE, 0x01AF,
    0x01B0, 0x01B1, 0x01B2, 0x01B3, 0x01B4, 0x01B5, 0x01B6, 0x01B7,
    0x01B8, 0x01B9, 0x01BA, 0x01BB, 0x01BC, 0x01BD, 0x01BE, 0x01BF,
    0x01C0, 0x01C1, 0x01C2, 0x01C3, 0x01C4, 0x01C5, 0x01C6, 0x01C7,
    0x01C8, 0x01C9, 0x01CA, 0x01CB, 0x01CC, 0x01CD, 0x01CE, 0x01CF,
    0x01D0, 0x01D1, 0x01D2, 0x01D3, 0x01D4, 0x01D5, 0x01D6, 0x01D7,
    0x01D8, 0x01D9, 0x01DA, 0x01DB, 0x01DC, 0x01DD, 0x01DE, 0x01DF,
    0x01E0, 0x01E1, 0x01E2, 0x01E3, 0x01E4, 0x01E5, 0x01E6, 0x01E7,
    0x01E8, 0x01E9, 0x01EA, 0x01EB, 0x01EC, 0x01ED, 0x01EE, 0x01EF,
    0x01F0, 0x01F1, 0x01F2, 0x01F3, 0x01F4, 0x01F5, 0x01F6, 0x01F7,
    0x01F8, 0x01F9, 0x01FA, 0x01FB, 0x01FC, 0x01FD, 0x01FE, 0x01FF,
    0x0200, 0x0201, 0x0202, 0x0203, 0x0204, 0x0205, 0x0206, 0x0207,
    0x0208, 0x0209, 0x020A, 0x020B, 0x020C, 0x020D, 0x020E, 0x020F,
    0x0210, 0x0211, 0x0212, 0x0213, 0x0214, 0x0215, 0x0216, 0x0217,
    0x0218, 0x0219, 0x021A, 0x021B, 0x021C, 0x021D, 0x021E, 0x021F,
    0x0220, 0x0221, 0x0222, 0x0223, 0x0224, 0x0225, 0x0226, 0x0227,
    0x0228, 0x0229, 0x022A, 0x022B, 0x022C, 0x022D, 0x022E, 0x022F,
    0x0230, 0x0231, 0x0232, 0x0233, 0x0234, 0x0235, 0x0236, 0x0237,
    0x0238, 0x0239, 0x023A, 0x023B, 0x023C, 0x023D, 0x023E, 0x023F,
    0x0240, 0x0241, 0x0242, 0x0243, 0x0244, 0x0245, 0x0246, 0x0247,
    0x0248, 0x0249, 0x024A, 0x024B, 0x024C, 0x024D, 0x024E, 0x024F,
    0x0250, 0x0251, 0x0252, 0x0253, 0x0254, 0x0255, 0x0256, 0x0257,
    0x0258, 0x0259, 0x025A, 0x025B, 0x025C, 0x025D, 0x025E, 0x025F,
    0x0260, 0x0261, 0x0262, 0x0263, 0x0264, 0x0265, 0x0266, 0x0267,
    0x0268, 0x0269, 0x026A, 0x026B, 0x026C, 0x026D, 0x026E, 0x026F,
    0x0270, 0x0271, 0x0272, 0x0273, 0x0274, 0x0275, 0x0276, 0x0277,
    0x0278, 0x0279, 0x027A, 0x027B, 0x027C, 0x027D, 0x027E, 0x027F,
    0x0280, 0x0281, 0x0282, 0x0283, 0x0284, 0x0285, 0x0286, 0x0287,
    0x0288, 0x0289, 0x028A, 0x028B, 0x028C, 0x028D, 0x028E, 0x028F,
    0x0290, 0x0291, 0x0292, 0x0293, 0x0294, 0x0295, 0x0296, 0x0297,
    0x0298, 0x0299, 0x029A, 0x029B, 0x029C, 0x029D, 0x029E, 0x029F,
    0x02A0, 0x02A1, 0x02A2, 0x02A3, 0x02A4, 0x02A5, 0x02A6, 0x02A7,
    0x02A8, 0x02A9, 0x02AA, 0x02AB, 0x02AC, 0x02AD, 0x02AE, 0x02AF,
    0x02B0, 0x02B1, 0x02B2, 0x02B3, 0x02B4, 0x02B5, 0x02B6, 0x02B7,
    0x02B8, 0x02B9, 0x02BA, 0x02BB, 0x02BC, 0x02BD, 0x02BE, 0x02BF,
    0x02C0, 0x02C1, 0x02C2, 0x02C3, 0x02C4, 0x02C5, 0x02C6, 0x02C7,
    0x02C8, 0x02C9, 0x02CA, 0x02CB, 0x02CC, 0x02CD, 0x02CE, 0x02CF,
    0x02D0, 0x02D1, 0x02D2, 0x02D3, 0x02D4, 0x02D5, 0x02D6, 0x02D7,
    0x02D8, 0x02D9, 0x02DA, 0x02DB, 0x02DC, 0x02DD, 0x02DE, 0x02DF,
    0x02E0, 0x02E1, 0x02E2, 0x02E3, 0x02E4, 0x02E5, 0x02E6, 0x02E7,
    0x02E8, 0x02E9, 0x02EA, 0x02EB, 0x02EC, 0x02ED, 0x02EE, 0x02EF,
    0x02F0, 0x02F1, 0x02F2, 0x02F3, 0x02F4, 0x02F5, 0x02F6, 0x02F7,
    0x02F8, 0x02F9, 0x02FA, 0x02FB, 0x02FC, 0x02FD, 0x02FE, 0x02FF,
    0x0300, 0x0301, 0x0302, 0x0303, 0x0304, 0x0305, 0x0306, 0x0307,
    0x0308, 0x0309, 0x030A, 0x030B, 0x030C, 0x030D, 0x030E, 0x030F,
    0x0310, 0x0311, 0x0312, 0x0313, 0x0314, 0x0315, 0x0316, 0x0317,
    0x0318, 0x0319, 0x031A, 0x031B, 0x031C, 0x031D, 0x031E, 0x031F,
    0x0320, 0x0321, 0x0322, 0x0323, 0x0324, 0x0325, 0x0326, 0x0327,
    0x0328, 0x0329, 0x032A, 0x032B, 0x032C, 0x032D, 0x032E, 0x032F,
    0x0330, 0x0331, 0x0332, 0x0333, 0x0334, 0x0335, 0x0336, 0x0337,
    0x0338, 0x0339, 0x033A, 0x033B, 0x033C, 0x033D, 0x033E, 0x033F,
    0x0340, 0x0341, 0x0342, 0x0343, 0x0344, 0x0345, 0x0346, 0x0347,
    0x0348, 0x0349, 0x034A, 0x034B, 0x034C, 0x034D, 0x034E, 0x034F,
    0x0350, 0x0351, 0x0352, 0x0353, 0x0354, 0x0355, 0x0356, 0x0357,
    0x0358, 0x0359, 0x035A, 0x035B, 0x035C, 0x035D, 0x035E, 0x035F,
    0x0360, 0x0361, 0x0362, 0x0363, 0x0364, 0x0365, 0x0366, 0x0367,
    0x0368, 0x0369, 0x036A, 0x036B, 0x036C, 0x036D, 0x036E, 0x036F,
    0x0370, 0x0371, 0x0372, 0x0373, 0x0374, 0x0375, 0x0376, 0x0377,
    0x0378, 0x0379, 0x037A, 0x037B, 0x037C, 0x037D, 0x037E, 0x037F,
    0x0380, 0x0381, 0x0382, 0x0383, 0x0384, 0x0385, 0x0386, 0x0387,
    0x0388, 0x0389, 0x038A, 0x038B, 0x038C, 0x038D, 0x038E, 0x038F,
    0x0390, 0x0391, 0x0392, 0x0393, 0x0394, 0x0395, 0x0396, 0x0397,
    0x0398, 0x0399, 0x039A, 0x039B, 0x039C, 0x039D, 0x039E, 0x039F,
    0x03A0, 0x03A1, 0x03A2, 0x03A3, 0x03A4, 0x03A5, 0x03A6, 0x03A7,
    0x03A8, 0x03A9, 0x03AA, 0x03AB, 0x03AC, 0x03AD, 0x03AE, 0x03AF,
    0x03B0, 0x03B1, 0x03B2, 0x03B3, 0x03B4, 0x03B5, 0x03B6, 0x03B7,
    0x03B8, 0x03B9, 0x03BA, 0x03BB, 0x03BC, 0x03BD, 0x03BE, 0x03BF,
    0x03C0, 0x03C1, 0x03C2, 0x03C3, 0x03C4, 0x03C5, 0x03C6, 0x03C7,
    0x03C8, 0x03C9, 0x03CA, 0x03CB, 0x03CC, 0x03CD, 0x03CE, 0x03CF,
    0x03D0, 0x03D1, 0x03D2, 0x03D3, 0x03D4, 0x03D5, 0x03D6, 0x03D7,
    0x03D8, 0x03D9, 0x03DA, 0x03DB, 0x03DC, 0x03DD, 0x03DE, 0x03DF,
    0x03E0, 0x03E1, 0x03E2, 0x03E3, 0x03E4, 0x03E5, 0x03E6, 0x03E7,
    0x03E8, 0x03E9, 0x03EA, 0x03EB, 0x03EC, 0x03ED, 0x03EE, 0x03EF,
    0x03F0, 0x03F1, 0x03F2, 0x03F3, 0x03F4, 0x03F5, 0x03F6, 0x03F7,
    0x03F8, 0x03F9, 0x03FA, 0x03FB, 0x03FC, 0x03FD, 0x03FE, 0x03FF,
};

const int16_t speed_tab_pal[0x400] = {
    0x0000, 0x0001, 0x0002, 0x0003, 0x0004, 0x0005, 0x0006, 0x0007,
    0x0008, 0x0009, 0x000a, 0x000b, 0x000c, 0x000d, 0x000e, 0x000f,
    0x0010, 0x0011, 0x0012, 0x0013, 0x0014, 0x0015, 0x0016, 0x0017,
    0x0018, 0x0019, 0x001a, 0x001b, 0x001c, 0x001d, 0x001e, 0x001f,
    0x0020, 0x0021, 0x0022, 0x0023, 0x0024, 0x0025, 0x0026, 0x0027,
    0x0028, 0x0029, 0x002a, 0x002b, 0x002c, 0x002d, 0x002e, 0x002f,
    0x0030, 0x0031, 0x0032, 0x0033, 0x0034, 0x0035, 0x0036, 0x0037,
    0x0038, 0x0039, 0x003a, 0x003b, 0x003c, 0x003d, 0x003e, 0x003f,
    0x0040, 0x0041, 0x0042, 0x0043, 0x0044, 0x0045, 0x0046, 0x0047,
    0x0048, 0x0049, 0x004a, 0x004b, 0x004c, 0x004d, 0x004e, 0x004f,
    0x0050, 0x0051, 0x0052, 0x0053, 0x0054, 0x0055, 0x0056, 0x0057,
    0x0058, 0x0059, 0x005a, 0x005b, 0x005c, 0x005d, 0x005e, 0x005f,
    0x0060, 0x0061, 0x0062, 0x0063, 0x0064, 0x0065, 0x0066, 0x0067,
    0x0068, 0x0069, 0x006a, 0x006b, 0x006c, 0x006d, 0x006e, 0x006f,
    0x0070, 0x0071, 0x0072, 0x0073, 0x0074, 0x0075, 0x0076, 0x0077,
    0x0078, 0x0079, 0x007a, 0x007b, 0x007c, 0x007d, 0x007e, 0x007f,
    0x0080, 0x0081, 0x0082, 0x0083, 0x0084, 0x0085, 0x0086, 0x0087,
    0x0088, 0x0089, 0x008a, 0x008b, 0x008c, 0x008d, 0x008e, 0x008f,
    0x0090, 0x0091, 0x0092, 0x0093, 0x0094, 0x0095, 0x0096, 0x0097,
    0x0098, 0x0099, 0x009a, 0x009b, 0x009c, 0x009d, 0x009e, 0x009f,
    0x00a0, 0x00a1, 0x00a2, 0x00a3, 0x00a4, 0x00a5, 0x00a6, 0x00a7,
    0x00a8, 0x00a9, 0x00aa, 0x00ab, 0x00ac, 0x00ad, 0x00ae, 0x00af,
    0x00b0, 0x00b1, 0x00b2, 0x00b3, 0x00b4, 0x00b5, 0x00b6, 0x00b7,
    0x00b8, 0x00b9, 0x00ba, 0x00bb, 0x00bc, 0x00bd, 0x00be, 0x00bf,
    0x00c0, 0x00c1, 0x00c2, 0x00c3, 0x00c4, 0x00c5, 0x00c6, 0x00c7,
    0x00c8, 0x00c9, 0x00ca, 0x00cb, 0x00cc, 0x00cd, 0x00ce, 0x00cf,
    0x00d0, 0x00d1, 0x00d2, 0x00d3, 0x00d4, 0x00d5, 0x00d6, 0x00d7,
    0x00d8, 0x00d9, 0x00da, 0x00db, 0x00dc, 0x00dd, 0x00de, 0x00df,
    0x00e0, 0x00e1, 0x00e2, 0x00e3, 0x00e4, 0x00e5, 0x00e6, 0x00e7,
    0x00e8, 0x00e9, 0x00ea, 0x00eb, 0x00ec, 0x00ed, 0x00ee, 0x00ef,
    0x00f0, 0x00f1, 0x00f2, 0x00f3, 0x00f4, 0x00f5, 0x00f6, 0x00f7,
    0x00f8, 0x00f9, 0x00fa, 0x00fb, 0x00fc, 0x00fd, 0x00fe, 0x00ff,
    0x0100, 0x0101, 0x0102, 0x0103, 0x0104, 0x0105, 0x0106, 0x0107,
    0x0108, 0x0109, 0x010a, 0x010b, 0x010c, 0x010d, 0x010e, 0x010f,
    0x0110, 0x0111, 0x0112, 0x0113, 0x0114, 0x0115, 0x0116, 0x0117,
    0x0118, 0x0119, 0x011a, 0x011b, 0x011c, 0x011d, 0x011e, 0x011f,
    0x0120, 0x0121, 0x0122, 0x0123, 0x0124, 0x0125, 0x0126, 0x0127,
    0x0128, 0x0129, 0x012a, 0x012b, 0x012c, 0x012d, 0x012e, 0x012f,
    0x0130, 0x0131, 0x0132, 0x0133, 0x0134, 0x0135, 0x0136, 0x0137,
    0x0138, 0x0139, 0x013a, 0x013b, 0x013c, 0x013d, 0x013e, 0x013f,
    0x0140, 0x0141, 0x0142, 0x0143, 0x0144, 0x0145, 0x0146, 0x0147,
    0x0148, 0x0149, 0x014a, 0x014b, 0x014c, 0x014d, 0x014e, 0x014f,
    0x0150, 0x0151, 0x0152, 0x0153, 0x0154, 0x0155, 0x0156, 0x0157,
    0x0158, 0x0159, 0x015a, 0x015b, 0x015c, 0x015d, 0x015e, 0x015f,
    0x0160, 0x0161, 0x0162, 0x0163, 0x0164, 0x0165, 0x0166, 0x0167,
    0x0168, 0x0169, 0x016a, 0x016b, 0x016c, 0x016d, 0x016e, 0x016f,
    0x0170, 0x0171, 0x0172, 0x0173, 0x0174, 0x0175, 0x0176, 0x0177,
    0x0178, 0x0179, 0x017a, 0x017b, 0x017c, 0x017d, 0x017e, 0x017f,
    0x0180, 0x0181, 0x0182, 0x0183, 0x0184, 0x0185, 0x0186, 0x0187,
    0x0188, 0x0189, 0x018a, 0x018b, 0x018c, 0x018d, 0x018e, 0x018f,
    0x0190, 0x0191, 0x0192, 0x0193, 0x0194, 0x0195, 0x0196, 0x0197,
    0x0198, 0x0199, 0x019a, 0x019b, 0x019c, 0x019d, 0x019e, 0x019f,
    0x01a0, 0x01a1, 0x01a2, 0x01a3, 0x01a4, 0x01a5, 0x01a6, 0x01a7,
    0x01a8, 0x01a9, 0x01aa, 0x01ab, 0x01ac, 0x01ad, 0x01ae, 0x01af,
    0x01b0, 0x01b1, 0x01b2, 0x01b3, 0x01b4, 0x01b5, 0x01b6, 0x01b7,
    0x01b8, 0x01b9, 0x01ba, 0x01bb, 0x01bc, 0x01bd, 0x01be, 0x01bf,
    0x01c0, 0x01c1, 0x01c2, 0x01c3, 0x01c4, 0x01c5, 0x01c6, 0x01c7,
    0x01c8, 0x01c9, 0x01ca, 0x01cb, 0x01cc, 0x01cd, 0x01ce, 0x01cf,
    0x01d0, 0x01d1, 0x01d2, 0x01d3, 0x01d4, 0x01d5, 0x01d6, 0x01d7,
    0x01d8, 0x01d9, 0x01da, 0x01db, 0x01dc, 0x01dd, 0x01de, 0x01df,
    0x01e0, 0x01e1, 0x01e2, 0x01e3, 0x01e4, 0x01e5, 0x01e6, 0x01e7,
    0x01e8, 0x01e9, 0x01ea, 0x01eb, 0x01ec, 0x01ed, 0x01ee, 0x01ef,
    0x01f0, 0x01f1, 0x01f2, 0x01f3, 0x01f4, 0x01f5, 0x01f6, 0x01f7,
    0x01f8, 0x01f9, 0x01fa, 0x01fb, 0x01fc, 0x01fd, 0x01fe, 0x01ff,
    0x0200, 0x0201, 0x0202, 0x0203, 0x0204, 0x0205, 0x0206, 0x0207,
    0x0208, 0x0209, 0x020a, 0x020b, 0x020c, 0x020d, 0x020e, 0x020f,
    0x0210, 0x0211, 0x0212, 0x0213, 0x0214, 0x0215, 0x0216, 0x0217,
    0x0218, 0x0219, 0x021a, 0x021b, 0x021c, 0x021d, 0x021e, 0x021f,
    0x0220, 0x0221, 0x0222, 0x0223, 0x0224, 0x0225, 0x0226, 0x0227,
    0x0228, 0x0229, 0x022a, 0x022b, 0x022c, 0x022d, 0x022e, 0x022f,
    0x0230, 0x0231, 0x0232, 0x0233, 0x0234, 0x0235, 0x0236, 0x0237,
    0x0238, 0x0239, 0x023a, 0x023b, 0x023c, 0x023d, 0x023e, 0x023f,
    0x0240, 0x0241, 0x0242, 0x0243, 0x0244, 0x0245, 0x0246, 0x0247,
    0x0248, 0x0249, 0x024a, 0x024b, 0x024c, 0x024d, 0x024e, 0x024f,
    0x0250, 0x0251, 0x0252, 0x0253, 0x0254, 0x0255, 0x0256, 0x0257,
    0x0258, 0x0259, 0x025a, 0x025b, 0x025c, 0x025d, 0x025e, 0x025f,
    0x0260, 0x0261, 0x0262, 0x0263, 0x0264, 0x0265, 0x0266, 0x0267,
    0x0268, 0x0269, 0x026a, 0x026b, 0x026c, 0x026d, 0x026e, 0x026f,
    0x0270, 0x0271, 0x0272, 0x0273, 0x0274, 0x0275, 0x0276, 0x0277,
    0x0278, 0x0279, 0x027a, 0x027b, 0x027c, 0x027d, 0x027e, 0x027f,
    0x0280, 0x0281, 0x0282, 0x0283, 0x0284, 0x0285, 0x0286, 0x0287,
    0x0288, 0x0289, 0x028a, 0x028b, 0x028c, 0x028d, 0x028e, 0x028f,
    0x0290, 0x0291, 0x0292, 0x0293, 0x0294, 0x0295, 0x0296, 0x0297,
    0x0298, 0x0299, 0x029a, 0x029b, 0x029c, 0x029d, 0x029e, 0x029f,
    0x02a0, 0x02a1, 0x02a2, 0x02a3, 0x02a4, 0x02a5, 0x02a6, 0x02a7,
    0x02a8, 0x02a9, 0x02aa, 0x02ab, 0x02ac, 0x02ad, 0x02ae, 0x02af,
    0x02b0, 0x02b1, 0x02b2, 0x02b3, 0x02b4, 0x02b5, 0x02b6, 0x02b7,
    0x02b8, 0x02b9, 0x02ba, 0x02bb, 0x02bc, 0x02bd, 0x02be, 0x02bf,
    0x02c0, 0x02c1, 0x02c2, 0x02c3, 0x02c4, 0x02c5, 0x02c6, 0x02c7,
    0x02c8, 0x02c9, 0x02ca, 0x02cb, 0x02cc, 0x02cd, 0x02ce, 0x02cf,
    0x02d0, 0x02d1, 0x02d2, 0x02d3, 0x02d4, 0x02d5, 0x02d6, 0x02d7,
    0x02d8, 0x02d9, 0x02da, 0x02db, 0x02dc, 0x02dd, 0x02de, 0x02df,
    0x02e0, 0x02e1, 0x02e2, 0x02e3, 0x02e4, 0x02e5, 0x02e6, 0x02e7,
    0x02e8, 0x02e9, 0x02ea, 0x02eb, 0x02ec, 0x02ed, 0x02ee, 0x02ef,
    0x02f0, 0x02f1, 0x02f2, 0x02f3, 0x02f4, 0x02f5, 0x02f6, 0x02f7,
    0x02f8, 0x02f9, 0x02fa, 0x02fb, 0x02fc, 0x02fd, 0x02fe, 0x02ff,
    0x0300, 0x0301, 0x0302, 0x0303, 0x0304, 0x0305, 0x0306, 0x0307,
    0x0308, 0x0309, 0x030a, 0x030b, 0x030c, 0x030d, 0x030e, 0x030f,
    0x0310, 0x0311, 0x0312, 0x0313, 0x0314, 0x0315, 0x0316, 0x0317,
    0x0318, 0x0319, 0x031a, 0x031b, 0x031c, 0x031d, 0x031e, 0x031f,
    0x0320, 0x0321, 0x0322, 0x0323, 0x0324, 0x0325, 0x0326, 0x0327,
    0x0328, 0x0329, 0x032a, 0x032b, 0x032c, 0x032d, 0x032e, 0x032f,
    0x0330, 0x0331, 0x0332, 0x0333, 0x0334, 0x0335, 0x0336, 0x0337,
    0x0338, 0x0339, 0x033a, 0x033b, 0x033c, 0x033d, 0x033e, 0x033f,
    0x0340, 0x0341, 0x0342, 0x0343, 0x0344, 0x0345, 0x0346, 0x0347,
    0x0348, 0x0349, 0x034a, 0x034b, 0x034c, 0x034d, 0x034e, 0x034f,
    0x0350, 0x0351, 0x0352, 0x0353, 0x0354, 0x0355, 0x0356, 0x0357,
    0x0358, 0x0359, 0x035a, 0x035b, 0x035c, 0x035d, 0x035e, 0x035f,
    0x0360, 0x0361, 0x0362, 0x0363, 0x0364, 0x0365, 0x0366, 0x0367,
    0x0368, 0x0369, 0x036a, 0x036b, 0x036c, 0x036d, 0x036e, 0x036f,
    0x0370, 0x0371, 0x0372, 0x0373, 0x0374, 0x0375, 0x0376, 0x0377,
    0x0378, 0x0379, 0x037a, 0x037b, 0x037c, 0x037d, 0x037e, 0x037f,
    0x0380, 0x0381, 0x0382, 0x0383, 0x0384, 0x0385, 0x0386, 0x0387,
    0x0388, 0x0389, 0x038a, 0x038b, 0x038c, 0x038d, 0x038e, 0x038f,
    0x0390, 0x0391, 0x0392, 0x0393, 0x0394, 0x0395, 0x0396, 0x0397,
    0x0398, 0x0399, 0x039a, 0x039b, 0x039c, 0x039d, 0x039e, 0x039f,
    0x03a0, 0x03a1, 0x03a2, 0x03a3, 0x03a4, 0x03a5, 0x03a6, 0x03a7,
    0x03a8, 0x03a9, 0x03aa, 0x03ab, 0x03ac, 0x03ad, 0x03ae, 0x03af,
    0x03b0, 0x03b1, 0x03b2, 0x03b3, 0x03b4, 0x03b5, 0x03b6, 0x03b7,
    0x03b8, 0x03b9, 0x03ba, 0x03bb, 0x03bc, 0x03bd, 0x03be, 0x03bf,
    0x03c0, 0x03c1, 0x03c2, 0x03c3, 0x03c4, 0x03c5, 0x03c6, 0x03c7,
    0x03c8, 0x03c9, 0x03ca, 0x03cb, 0x03cc, 0x03cd, 0x03ce, 0x03cf,
    0x03d0, 0x03d1, 0x03d2, 0x03d3, 0x03d4, 0x03d5, 0x03d6, 0x03d7,
    0x03d8, 0x03d9, 0x03da, 0x03db, 0x03dc, 0x03dd, 0x03de, 0x03df,
    0x03e0, 0x03e1, 0x03e2, 0x03e3, 0x03e4, 0x03e5, 0x03e6, 0x03e7,
    0x03e8, 0x03e9, 0x03ea, 0x03eb, 0x03ec, 0x03ed, 0x03ee, 0x03ef,
    0x03f0, 0x03f1, 0x03f2, 0x03f3, 0x03f4, 0x03f5, 0x03f6, 0x03f7,
    0x03f8, 0x03f9, 0x03fa, 0x03fb, 0x03fc, 0x03fd, 0x03fe, 0x03ff,
};
