/*
 * Licensed to the Apache Software Foundation (ASF) under one or more
 * contributor license agreements.  See the NOTICE file distributed with
 * this work for additional information regarding copyright ownership.
 * The ASF licenses this file to You under the Apache License, Version 2.0
 * (the "License"); you may not use this file except in compliance with
 * the License.  You may obtain a copy of the License at
 *
 *    http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

package org.apache.spark.sql.catalyst.optimizer

import org.apache.spark.sql.catalyst.expressions._
import org.apache.spark.sql.catalyst.plans.logical._

/**
 * Overrides our expression evaluation tests and reruns them after optimization has occured.  This
 * is to ensure that constant folding and other optimizations do not break anything.
 */
class ExpressionOptimizationSuite extends ExpressionEvaluationSuite {
  override def checkEvaluation(
      expression: Expression,
      expected: Any,
      inputRow: Row = EmptyRow): Unit = {
    val plan = Project(Alias(expression, s"Optimized($expression)")() :: Nil, NoRelation)
    val optimizedPlan = DefaultOptimizer(plan)
    super.checkEvaluation(optimizedPlan.expressions.head, expected, inputRow)
  }
}
