# Generated by Django 4.0.2 on 2022-03-11 22:10

import datetime
from django.db import migrations, models
import django.db.models.deletion
from django.utils.timezone import utc


class Migration(migrations.Migration):

    initial = True

    dependencies = [
    ]

    operations = [
        migrations.CreateModel(
            name='Friendship',
            fields=[
                ('ID', models.AutoField(primary_key=True, serialize=False)),
            ],
        ),
        migrations.CreateModel(
            name='Message',
            fields=[
                ('ID', models.AutoField(primary_key=True, serialize=False)),
                ('IdentifierNumber', models.IntegerField()),
                ('Content', models.CharField(max_length=4096)),
                ('Type', models.CharField(choices=[('Text', 'Text'), ('Image', 'Image'), ('Audio', 'Audio'), ('Video', 'Video')], default='Text', max_length=5)),
                ('Date', models.DateTimeField(default=datetime.datetime(2022, 3, 11, 22, 10, 15, 868291, tzinfo=utc))),
            ],
        ),
        migrations.CreateModel(
            name='RequestFriendship',
            fields=[
                ('ID', models.AutoField(primary_key=True, serialize=False)),
            ],
        ),
        migrations.CreateModel(
            name='User',
            fields=[
                ('Username', models.CharField(max_length=30, primary_key=True, serialize=False)),
                ('Password', models.CharField(max_length=30)),
                ('Email', models.CharField(max_length=80)),
                ('Name', models.CharField(max_length=25, null=True)),
                ('ProfilePicture', models.TextField(null=True)),
                ('Friends', models.ManyToManyField(related_name='FriendUser', through='chatApp.Friendship', to='chatApp.User')),
                ('Messages', models.ManyToManyField(related_name='MessageUser', to='chatApp.Message')),
                ('Requests', models.ManyToManyField(related_name='RequestToUser', through='chatApp.RequestFriendship', to='chatApp.User')),
            ],
        ),
        migrations.AddField(
            model_name='requestfriendship',
            name='Receiver',
            field=models.ForeignKey(on_delete=django.db.models.deletion.CASCADE, related_name='toRequestUser', to='chatApp.user'),
        ),
        migrations.AddField(
            model_name='requestfriendship',
            name='Sender',
            field=models.ForeignKey(on_delete=django.db.models.deletion.CASCADE, related_name='ofRequestUser', to='chatApp.user'),
        ),
        migrations.AddField(
            model_name='message',
            name='Receiver',
            field=models.OneToOneField(on_delete=django.db.models.deletion.CASCADE, related_name='toMessageUser', to='chatApp.user'),
        ),
        migrations.AddField(
            model_name='message',
            name='Sender',
            field=models.OneToOneField(on_delete=django.db.models.deletion.CASCADE, related_name='ofMessageUser', to='chatApp.user'),
        ),
        migrations.AddField(
            model_name='friendship',
            name='Person1',
            field=models.ForeignKey(on_delete=django.db.models.deletion.CASCADE, related_name='ofFriendUser', to='chatApp.user'),
        ),
        migrations.AddField(
            model_name='friendship',
            name='Person2',
            field=models.ForeignKey(on_delete=django.db.models.deletion.CASCADE, related_name='toFriendUser', to='chatApp.user'),
        ),
        migrations.AlterUniqueTogether(
            name='requestfriendship',
            unique_together={('Receiver', 'Sender')},
        ),
    ]
