JavaScript language features coverage
=====================================

List below is based on the [ES3 Standard](http://www-archive.mozilla.org/js/language/E262-3.pdf), mainly sections 11, 12 and 15.

### Statements

 - [x] **Block statement**
 - [x] **`var`**
 - [x] **Empty statement**
 - [x] **Expression statement**
 - [x] **`if` `else`**
 - [x] **`do` `while`**
 - [x] **`while`**
 - [x] **`for`**
 - [x] **`for` `of`**
 - [x] **`for` `in`**
 - [x] **`continue`**
 - [x] **`break`**
 - [x] **`return`**
 - [x] **`switch`**
 - [ ] `with`
 - [x] **Labelled statements**
 - [x] **`throw`**
 - [x] **`try`** _(maximum 10 directly or indirectly nested try-catch blocks)_
 - [x] **Function definition `function` ident `() {` ... `}`**


### Expressions

 - [x] **Primary Expressions**
    - [x] **`this`** _(partial: global this not supported)_
    - [x] **Identifier reference**
    - [x] **Literal**
        - [x] **`null`**
        - [x] **`true` / `false`**
        - [x] **number literal** _(partial: only 16-bit integers)_
        - [x] **string literal**
        - [x] **regular expression literal** _(partial: backreferences and regexp flags not supported)_
    - [x] **Array initializer `[` ... `]`** 
    - [x] **Object initializer `{` ... `}`**
    - [x] **Grouping operator `(` `)`**
 - [x] Left-hand-side Expressions
    - [x] **Property accessors**
    - [x] **`new` operator**
    - [x] **Function call**
    - [x] **Argument list**
    - [x] **Function expression `function() {` ... `}`**
 - [x] **Postfix expressions**
    - [x] **`--`**
    - [x] **`++`**
 - [x] **Unary operators**
    - [x] **`delete`**
    - [x] **`void`**
    - [x] **`typeof`**
    - [x] **Prefix increment operator `++`**
    - [x] **Prefix decrement operator `--`**
    - [x] **Unary `+`**
    - [x] **Unary `-`**
    - [x] **Bitwise NOT `~`**
    - [x] **Logical NOT `!`**
 - [x] **Multiplicative operators**
    - [x] **`*`**
    - [x] **`/`**
    - [x] **`%`**
 - [x] **Additive operators**
    - [x] **`+`**
    - [x] **`-`**
 - [x] **Bitwise shift operators**
    - [x] **`<<`**
    - [x] **`>>`**
    - [x] **`>>>`**
 - [ ] Relational operators
    - [x] **`<`**
    - [x] **`>`**
    - [x] **`<=`**
    - [x] **`>=`**
    - [ ] `instanceof`
    - [x] **`in`**
 - [x] **Equality operators**
    - [x] **`==`**
    - [x] **`!=`**
    - [x] **`===`**
    - [x] **`!==`**
 - [x] **Binary bitwise operators**
    - [x] **`&`**
    - [x] **`|`**
    - [x] **`^`**
 - [x] **Binary logical operators**
    - [x] **`&&`**
    - [x] **`||`**
 - [x] **Conditional operator `?` `:`**
 - [x] **Assignment operators**
    - [x] **Simple assignment `=`**
    - [x] **Compound assignments**
        - [x] **`+=`**
        - [x] **`-=`**
        - [x] **`*=`**
        - [x] **`/=`**
        - [x] **`%=`**
        - [x] **`<<=`**
        - [x] **`>>=`**
        - [x] **`>>>=`**
        - [x] **`&=`**
        - [x] **`^=`**
        - [x] **`|=`**
 - [x] **Comma operator**

### Built-in objects

 - [ ] Global
     - [x] **NaN**
     - [ ] Infinity
     - [x] **undefined**
     - [ ] ~~eval~~  _(will not be implemented)_
     - [x] **parseInt** _(partial: radix parameter not supported)_
     - [ ] parseFloat
     - [x] **isNaN**
     - [ ] isFinite
     - [ ] decodeURI
     - [ ] decodeURIComponent
     - [ ] encodeURI
     - [ ] encodeURIComponent
 - [ ] Object
     - [x] **new** _(partial: without argument)_
     - [ ] toString
     - [ ] toLocaleString
     - [ ] hasOwnProperty
     - [ ] isPrototypeOf
     - [ ] propertyIsEnumerable
 - [ ] Function
     - [ ] ~~new~~  _(will not be implemented)_
     - [ ] ~~toString~~  _(will not be implemented)_
     - [ ] apply
     - [ ] call
 - [ ] Array
     - [ ] new
     - [x] **toString**
     - [ ] toLocaleString
     - [x] **concat**
     - [x] **join**
     - [x] **pop**
     - [x] **push**
     - [x] **reverse**
     - [x] **shift**
     - [x] **slice** _(partial: no bounds checking)_
     - [x] **sort** _(partial: sort function as parameter not supported)_
     - [x] **splice** _(partial: no bounds checking)_
     - [x] **unshift**
     - [x] **length**
     - [x] **indexOf**
     - [x] **lastIndexOf**
 - [ ] String
     - [ ] new
     - [x] **toString**
     - [x] **valueOf**
     - [x] **charAt**
     - [x] **charCodeAt** _(partial: UTF8 symbols of length 3 and 4 bytes aren't supported)_
     - [x] **concat**
     - [x] **indexOf**
     - [x] **lastIndexOf**
     - [ ] localeCompare
     - [x] **match**
     - [ ] replace
     - [x] **search**
     - [x] **slice**
     - [ ] split
     - [x] **substring**
     - [ ] toLowerCase
     - [ ] toLocaleLowerCase
     - [ ] toUpperCase
     - [ ] toLocaleUpperCase
     - [x] **length**
 - [ ] Boolean
     - [ ] new
     - [ ] toString
     - [ ] valueOf
 - [ ] Number
     - [x] **Number (as function)**
     - [ ] new
     - [ ] MAX_VALUE
     - [ ] MIN_VALUE
     - [x] **NaN**
     - [ ] NEGATIVE_INFINITY
     - [ ] POSITIVE_INFINITY
     - [ ] toString
     - [ ] toLocaleString
     - [ ] valueOf
     - [ ] toFixed
     - [ ] toExponential
     - [ ] toPrecision
 - [ ] Math
     - [ ] LN10
     - [ ] LN2
     - [ ] LOG2E
     - [ ] LOG10E
     - [ ] PI
     - [ ] SQRT1_2
     - [ ] SQRT2
     - [ ] abs
     - [ ] acos
     - [ ] asin
     - [ ] atan
     - [ ] atan2
     - [ ] ceil
     - [ ] cos
     - [ ] exp
     - [ ] floor
     - [ ] log
     - [ ] max
     - [ ] min
     - [ ] pow
     - [ ] random
     - [ ] round
     - [ ] sin
     - [ ] sqrt
     - [ ] tan
 - [ ] Date
     - [ ] new
     - [ ] Date (as function)
     - [ ] now
     - [ ] parse
     - [ ] UTC
     - [ ] toString
     - [ ] toDateString
     - [ ] toTimeString
     - [ ] toLocaleString
     - [ ] toLocaleTimeString
     - [ ] valueOf
     - [ ] getTime
     - [ ] getFullYear
     - [ ] getUTCFullYear
     - [ ] getMonth
     - [ ] getUTCMonth
     - [ ] getDay
     - [ ] getUTCDay
     - [ ] getHours
     - [ ] getUTCHours
     - [ ] getMinutes
     - [ ] getUTCMinutes
     - [ ] getSeconds
     - [ ] getUTCSeconds
     - [ ] getMilliseconds
     - [ ] getUTCMilliseconds
     - [ ] getTimezoneOffset
     - [ ] setTime
     - [ ] setFullYear
     - [ ] setUTCFullYear
     - [ ] setMonth
     - [ ] setUTCMonth
     - [ ] setDay
     - [ ] setUTCDay
     - [ ] setHours
     - [ ] setUTCHours
     - [ ] setMinutes
     - [ ] setUTCMinutes
     - [ ] setSeconds
     - [ ] setUTCSeconds
     - [ ] setMilliseconds
     - [ ] setUTCMilliseconds
     - [ ] toUTCString
 - [ ] RegExp
     - [ ] RegExp (as function)
     - [ ] new
     - [ ] exec
     - [ ] test
     - [ ] toString
     - [ ] source
     - [ ] global
     - [ ] ignoreCase
     - [ ] multiline
     - [ ] lastIndex
 - [ ] Error objects
